/*=============================================================================
 *    Copyright 2005 Texas Instruments Inc. All rights reserved.
 */
#ifndef BSP_TWL3029_AUX_LLIF_PG2X_HEADER
#define BSP_TWL3029_AUX_LLIF_PG2X_HEADER

#include "bspUtil_BitUtil.h"

/*=============================================================================
 * Component Description:
 *    Provides accessor and manipulator macros for TWL3029 aka Triton
 *    register fields for BARAUX modules. Fields offsets and widths are encoded in contants
 *    that are to be fed into simple macros. This common approach should
 *    help to prevent masking errors.
 *    
 *    the BARAUX registers consist of
 *     - USB registers
 *     - MADC registers
 *     - AUX registers
 *     - WLED registers
 *     - VIB registers
 *     - BCI registers
 *     - SIM card registers
 *    The bits field macros below are for register bits that are specific 
 *    to harware PG1.x
 */

/*====================================================
 *       USB REGISTERS
 */

/*=========PAGE 0/2 USB register bit fields  =========
 */



/*=========BSP_TWL3029_LLIF_USB_RESERVED_USB_9=========
 */
 
#define BSP_TWL3029_LLIF_USB_RESERVED_USB_9_RSVRD_OFFSET 0  
#define BSP_TWL3029_LLIF_USB_RESERVED_USB_9_RSVRD_WIDTH  8 

/*  
 *   Note: name changesfor pg2.0:  SESS_VLD  --> VA_SESS_VLD 
 *                                 VBUS_VLD  --> VA_VBUS_VLD 
 *    orignal bit filed names  (specified in bspTwl3029_Aux_Llif.h)
 *    are also still valid.
 */

/*=========BSP_TWL3029_LLIF_USB_INT_LATCH_SET=========
 */

#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_VA_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_VA_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_VA_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_VA_VBUS_VLD_WIDTH   1


/*=========BSP_TWL3029_LLIF_USB_INT_LATCH_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_VA_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_VA_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_VA_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_VA_VBUS_VLD_WIDTH   1

/*=========BSP_TWL3029_LLIF_USB_INT_EN_LO_SET=========
 */

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_VA_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_VA_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_VA_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_VA_VBUS_VLD_WIDTH   1


/*=========BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_VA_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_VA_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_VA_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_VA_VBUS_VLD_WIDTH   1

/*=========BSP_TWL3029_LLIF_USB_INT_EN_HI_SET=========
 */

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_VA_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_VA_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_VA_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_VA_VBUS_VLD_WIDTH   1


/*=========BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR=========
 */


#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_VA_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_VA_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_VA_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_VA_VBUS_VLD_WIDTH   1

/*=========BSP_TWL3029_LLIF_USB_USB_POWER_SET=========
 */ 
#define BSP_TWL3029_LLIF_USB_USB_POWER_SET_VBUS_VRUSB_OFFSET   7
#define BSP_TWL3029_LLIF_USB_USB_POWER_SET_VBUS_VRUSB_WIDTH    1

/*=========BSP_TWL3029_LLIF_USB_USB_POWER_CLR=========
 */
#define BSP_TWL3029_LLIF_USB_USB_POWER_CLR_VBUS_VRUSB_OFFSET   7
#define BSP_TWL3029_LLIF_USB_USB_POWER_CLR_VBUS_VRUSB_WIDTH    1


/*=========BSP_TWL3029_LLIF_USB_CTRL_3_SET=========
 */

#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_MIC_EN_OFFSET  7
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_MIC_EN_WIDTH   1
   
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_MIC_BIAS_EN_OFFSET  6
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_MIC_BIAS_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_SPKR_RIGHT_EN_OFFSET  5
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_SPKR_RIGHT_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_SPKR_LEFT_EN_OFFSET  4
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_SPKR_LEFT_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_SPKR_R_BIAS_EN_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_SPKR_R_BIAS_EN_WIDTH   1
   
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_SPKR_L_BIAS_EN_OFFSET  2
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_SPKR_L_BIAS_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_RX_PULSE_EN_OFFSET  1
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_RX_PULSE_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_TX_PULSE_EN_OFFSET  0
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_TX_PULSE_EN_WIDTH   1  

/*=========BSP_TWL3029_LLIF_USB_CTRL_3_SET=========
 */
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_OFFSET  0
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_MIC_EN_OFFSET  7
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_MIC_EN_WIDTH   1
   
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_MIC_BIAS_EN_OFFSET  6
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_MIC_BIAS_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_SPKR_RIGHT_EN_OFFSET  5
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_SPKR_RIGHT_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_SPKR_LEFT_EN_OFFSET  4
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_SPKR_LEFT_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_SPKR_R_BIAS_EN_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_SPKR_R_BIAS_EN_WIDTH   1
   
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_SPKR_L_BIAS_EN_OFFSET  2
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_SPKR_L_BIAS_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_RX_PULSE_EN_OFFSET  1
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_RX_PULSE_EN_WIDTH   1
  
#define BSP_TWL3029_LLIF_USB_CTRL_3_CLR_TX_PULSE_EN_OFFSET  0
#define BSP_TWL3029_LLIF_USB_CTRL_3_SET_TX_PULSE_EN_WIDTH   1 

/*=========BSP_TWL3029_LLIF_TX_PLSWIDTH_POS=========
 */
#define BSP_TWL3029_LLIF_USB_TX_PLSWIDTH_POS_TX_PLSWIDTH_POS_OFFSET   0 
#define BSP_TWL3029_LLIF_USB_TX_PLSWIDTH_POS_TX_PLSWIDTH_POS_WIDTH    8

/*=========BSP_TWL3029_LLIF_TX_PLSWIDTH_NEG=========
 */
#define BSP_TWL3029_LLIF_USB_TX_PLSWIDTH_NEG_TX_PLSWIDTH_NEG_OFFSET   0 
#define BSP_TWL3029_LLIF_USB_TX_PLSWIDTH_NEG_TX_PLSWIDTH_NEG_WIDTH    8

/*=========BSP_TWL3029_LLIF_RX_RECOVERY=========
 */
#define BSP_TWL3029_LLIF_USB_RX_RECOVERY_RX_RECOVERY_OFFSET   0 
#define BSP_TWL3029_LLIF_USB_RX_RECOVERY_RX_RECOVERY_WIDTH    8

/*=========BSP_TWL3029_LLIF_CR_INT_DELAY=========
 */
#define BSP_TWL3029_LLIF_USB_CR_INT_DELAY_CR_INT_DELAY_OFFSET   0 
#define BSP_TWL3029_LLIF_USB_CR_INT_DELAY_CR_INT_DELAY_WIDTH    8

/*========= PAGE 2 USB register bit fields=========
 */


/*=========BSP_TWL3029_LLIF_INT_SRC_2=========
 */

#define BSP_TWL3029_LLIF_USB_INT_SRC_2_ID_RES_440K_OFFSET   5
#define BSP_TWL3029_LLIF_USB_INT_SRC_2_ID_RES_440K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_SRC_2_ID_RES_200K_OFFSET   4
#define BSP_TWL3029_LLIF_USB_INT_SRC_2_ID_RES_200K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_SRC_2_ID_RES_100K_OFFSET   3
#define BSP_TWL3029_LLIF_USB_INT_SRC_2_ID_RES_100K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_SRC_2_STRESS_OFFSET   2
#define BSP_TWL3029_LLIF_USB_INT_SRC_2_STRESS_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_SRC_2_VB_SESS_VLD_OFFSET   1
#define BSP_TWL3029_LLIF_USB_INT_SRC_2_VB_SESS_VLD_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_SRC_2_VB_SESS_END_OFFSET   0
#define BSP_TWL3029_LLIF_USB_INT_SRC_2_VB_SESS_END_WIDTH    1


/*=========BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET=========
 */

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_ID_RES_440K_OFFSET   5
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_ID_RES_440K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_ID_RES_200K_OFFSET   4
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_ID_RES_200K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_ID_RES_100K_OFFSET   3
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_ID_RES_100K_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_STRESS_OFFSET   2
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_STRESS_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_VB_SESS_VLD_OFFSET   1 
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_VB_SESS_VLD_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_VB_SESS_END_OFFSET   0
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_SET_VB_SESS_END_WIDTH    1 


/*=========BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_ID_RES_440K_OFFSET   5
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_ID_RES_440K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_ID_RES_200K_OFFSET   4
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_ID_RES_200K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_ID_RES_100K_OFFSET   3
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_ID_RES_100K_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_STRESS_OFFSET   2
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_STRESS_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_VB_SESS_VLD_OFFSET   1 
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_VB_SESS_VLD_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_VB_SESS_END_OFFSET   0
#define BSP_TWL3029_LLIF_USB_INT_LATCH_2_CLR_VB_SESS_END_WIDTH    1 



/*=========BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET=========
 */

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_ID_RES_440K_OFFSET   5
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_ID_RES_440K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_ID_RES_200K_OFFSET   4
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_ID_RES_200K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_ID_RES_100K_OFFSET   3
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_ID_RES_100K_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_STRESS_OFFSET        2
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_STRESS_WIDTH         1

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_VB_SESS_VLD_OFFSET   1 
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_VB_SESS_VLD_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_VB_SESS_END_OFFSET   0
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_SET_VB_SESS_END_WIDTH    1 



/*=========BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_ID_RES_440K_OFFSET   5
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_ID_RES_440K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_ID_RES_200K_OFFSET   4
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_ID_RES_200K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_ID_RES_100K_OFFSET   3
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_ID_RES_100K_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_STRESS_OFFSET        2
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_STRESS_WIDTH         1

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_VB_SESS_VLD_OFFSET   1 
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_VB_SESS_VLD_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_VB_SESS_END_OFFSET   0
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_2_CLR_VB_SESS_END_WIDTH    1 



/*=========BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET=========
 */

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_ID_RES_440K_OFFSET   5
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_ID_RES_440K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_ID_RES_200K_OFFSET   4
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_ID_RES_200K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_ID_RES_100K_OFFSET   3
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_ID_RES_100K_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_STRESS_OFFSET        2
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_STRESS_WIDTH         1

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_VB_SESS_VLD_OFFSET   1 
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_VB_SESS_VLD_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_VB_SESS_END_OFFSET   0
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_SET_VB_SESS_END_WIDTH    1 



/*=========BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_ID_RES_440K_OFFSET   5
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_ID_RES_440K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_ID_RES_200K_OFFSET   4
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_ID_RES_200K_WIDTH    1

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_ID_RES_100K_OFFSET   3
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_ID_RES_100K_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_STRESS_OFFSET        2
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_STRESS_WIDTH         1

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_VB_SESS_VLD_OFFSET   1 
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_VB_SESS_VLD_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_VB_SESS_END_OFFSET   0
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_2_CLR_VB_SESS_END_WIDTH    1 


/*=========BSP_TWL3029_LLIF_USB_CR_INT_SRC_1=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_PSM_ERROR_OFFSET   6
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_PSM_ERROR_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_PH_ACC_OFFSET      5
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_PH_ACC_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_CHARGER_OFFSET     4
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_CHARGER_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_USB_HOST_OFFSET    3
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_USB_HOST_WIDTH     1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_USB_OTG_B_OFFSET   2
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_USB_OTG_B_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_CARKIT_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_CARKIT_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_DISCONNECTED_OFFSET  0
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_1_DISCONNECTED_WIDTH   1



/*=========BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_PSM_ERROR_OFFSET   6
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_PSM_ERROR_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_PH_ACC_OFFSET      5
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_PH_ACC_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_CHARGER_OFFSET     4
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_CHARGER_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_USB_HOST_OFFSET    3
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_USB_HOST_WIDTH     1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_USB_OTG_B_OFFSET   2
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_USB_OTG_B_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_CARKIT_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_CARKIT_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_DISCONNECTED_OFFSET  0
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_SET_DISCONNECTED_WIDTH   1



/*=========BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_PSM_ERROR_OFFSET   6
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_PSM_ERROR_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_PH_ACC_OFFSET      5
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_PH_ACC_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_CHARGER_OFFSET     4
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_CHARGER_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_USB_HOST_OFFSET    3
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_USB_HOST_WIDTH     1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_USB_OTG_B_OFFSET   2
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_USB_OTG_B_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_CARKIT_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_CARKIT_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_DISCONNECTED_OFFSET  0
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_1_CLR_DISCONNECTED_WIDTH   1



/*=========BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_PSM_ERROR_OFFSET   6
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_PSM_ERROR_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_PH_ACC_OFFSET      5
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_PH_ACC_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_CHARGER_OFFSET     4
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_CHARGER_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_USB_HOST_OFFSET    3
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_USB_HOST_WIDTH     1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_USB_OTG_B_OFFSET   2
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_USB_OTG_B_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_CARKIT_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_CARKIT_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_DISCONNECTED_OFFSET  0
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_SET_DISCONNECTED_WIDTH   1



/*=========BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_PSM_ERROR_OFFSET   6
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_PSM_ERROR_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_PH_ACC_OFFSET      5
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_PH_ACC_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_CHARGER_OFFSET     4
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_CHARGER_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_USB_HOST_OFFSET    3
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_USB_HOST_WIDTH     1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_USB_OTG_B_OFFSET   2
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_USB_OTG_B_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_CARKIT_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_CARKIT_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_DISCONNECTED_OFFSET  0
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_1_CLR_DISCONNECTED_WIDTH   1


/*=========BSP_TWL3029_LLIF_USB_CR_INT_SRC_2=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_STOP_PLS_MISS_OFFSET   7
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_STOP_PLS_MISS_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_RSVRD_OFFSET           3
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_RSVRD_WIDTH            3

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_STEREO_TO_MONO_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_STEREO_TO_MONO_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_CARKIT_UART_OFFSET     2
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_CARKIT_UART_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_PHONE_UART_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_PHONE_UART_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_PH_NO_ACK_OFFSET       0
#define BSP_TWL3029_LLIF_USB_CR_INT_SRC_2_PH_NO_ACK_WIDTH        1


/*=========BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_STOP_PLS_MISS_OFFSET   7
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_STOP_PLS_MISS_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_RSVRD_OFFSET           3
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_RSVRD_WIDTH            3

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_STEREO_TO_MONO_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_STEREO_TO_MONO_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_CARKIT_UART_OFFSET     2
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_CARKIT_UART_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_PHONE_UART_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_PHONE_UART_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_PH_NO_ACK_OFFSET       0
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_SET_PH_NO_ACK_WIDTH        1


/*=========BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_STOP_PLS_MISS_OFFSET   7
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_STOP_PLS_MISS_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_RSVRD_OFFSET           3
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_RSVRD_WIDTH            3

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_STEREO_TO_MONO_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_STEREO_TO_MONO_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_CARKIT_UART_OFFSET     2
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_CARKIT_UART_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_PHONE_UART_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_PHONE_UART_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_PH_NO_ACK_OFFSET       0
#define BSP_TWL3029_LLIF_USB_CR_INT_LATCH_2_CLR_PH_NO_ACK_WIDTH        1


/*=========BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_STOP_PLS_MISS_OFFSET   7
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_STOP_PLS_MISS_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_RSVRD_OFFSET           3
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_RSVRD_WIDTH            3

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_STEREO_TO_MONO_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_STEREO_TO_MONO_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_CARKIT_UART_OFFSET     2
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_CARKIT_UART_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_PHONE_UART_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_PHONE_UART_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_PH_NO_ACK_OFFSET       0
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_SET_PH_NO_ACK_WIDTH        1


/*=========BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_STOP_PLS_MISS_OFFSET   7
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_STOP_PLS_MISS_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_RSVRD_OFFSET           3
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_RSVRD_WIDTH            3

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_STEREO_TO_MONO_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_STEREO_TO_MONO_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_CARKIT_UART_OFFSET     2
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_CARKIT_UART_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_PHONE_UART_OFFSET      1
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_PHONE_UART_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_PH_NO_ACK_OFFSET       0
#define BSP_TWL3029_LLIF_USB_CR_INT_EN_2_CLR_PH_NO_ACK_WIDTH        1


/*=========BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET=========
 */

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_DATA_DURING_AUDIO_OFFSET  5
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_DATA_DURING_AUDIO_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_CARKIT_TYPE_OFFSET       4
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_CARKIT_TYPE_WIDTH        1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_AUDIO_MODE_OFFSET        3
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_AUDIO_MODE_WIDTH         1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_USB_CARKIT_MODE_OFFSET   2
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_USB_CARKIT_MODE_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_CARKIT_PSM_RESET_OFFSET  1
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_CARKIT_PSM_RESET_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_CARKIT_PSM_EN_OFFSET     0
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_SET_CARKIT_PSM_EN_WIDTH      1



/*=========BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_DATA_DURING_AUDIO_OFFSET  5
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_DATA_DURING_AUDIO_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_CARKIT_TYPE_OFFSET       4
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_CARKIT_TYPE_WIDTH        1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_AUDIO_MODE_OFFSET        3
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_AUDIO_MODE_WIDTH         1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_USB_CARKIT_MODE_OFFSET   2
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_USB_CARKIT_MODE_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_CARKIT_PSM_RESET_OFFSET  1
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_CARKIT_PSM_RESET_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_CARKIT_PSM_EN_OFFSET     0
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_CLR_CARKIT_PSM_EN_WIDTH      1


/*=========BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET=========
 */

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_CR_INT_DET_OFFSET      7
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_CR_INT_DET_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_DISC_REQ_OFFSET        6
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_DISC_REQ_WIDTH         1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_SW_UART_READY_OFFSET   5
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_SW_UART_READY_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_CANCEL_PH_AUD_REQ_OFFSET   4
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_CANCEL_PH_AUD_REQ_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_PH_AUD_REQ_ST2_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_PH_AUD_REQ_ST2_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_PH_AUD_REQ_OFFSET      2
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_PH_AUD_REQ_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_PH_AUD_MUTE_OFFSET     1
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_PH_AUD_MUTE_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_PH_INT_REQ_OFFSET      0
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_SET_PH_INT_REQ_WIDTH       1


/*=========BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR=========
 */

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_CR_INT_DET_OFFSET      7
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_CR_INT_DET_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_DISC_REQ_OFFSET        6
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_DISC_REQ_WIDTH         1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_SW_UART_READY_OFFSET   5
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_SW_UART_READY_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_CANCEL_PH_AUD_REQ_OFFSET   4
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_CANCEL_PH_AUD_REQ_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_PH_AUD_REQ_ST2_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_PH_AUD_REQ_ST2_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_PH_AUD_REQ_OFFSET      2
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_PH_AUD_REQ_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_PH_AUD_MUTE_OFFSET     1
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_PH_AUD_MUTE_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_PH_INT_REQ_OFFSET      0
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_CLR_PH_INT_REQ_WIDTH       1


/*=========BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS=========
 */
 
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_CR_INT_DET_OFFSET      7
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_CR_INT_DET_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_DISC_REQ_OFFSET        6
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_DISC_REQ_WIDTH         1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_SW_UART_READY_OFFSET   5
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_SW_UART_READY_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_CANCEL_PH_AUD_REQ_OFFSET   4
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_CANCEL_PH_AUD_REQ_WIDTH    1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_PH_AUD_REQ_ST2_OFFSET  3
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_PH_AUD_REQ_ST2_WIDTH   1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_PH_AUD_REQ_OFFSET      2
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_PH_AUD_REQ_WIDTH       1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_PH_AUD_MUTE_OFFSET     1
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_PH_AUD_MUTE_WIDTH      1

#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_PH_INT_REQ_OFFSET      0
#define BSP_TWL3029_LLIF_USB_CR_PSM_CMD_STATUS_PH_INT_REQ_WIDTH       1
 
/*=========BSP_TWL3029_LLIF_USB_CR_PSM_STATUS=========
 */
#define BSP_TWL3029_LLIF_USB_CR_PSM_STATUS_PSM_STATUS_OFFSET          0
#define BSP_TWL3029_LLIF_USB_CR_PSM_STATUS_PSM_STATUS_WIDTH           6

/*=========BSP_TWL3029_LLIF_USB_CR_PSM_NEXT_STATUS=========
 */
#define BSP_TWL3029_LLIF_USB_CR_PSM_NEXT_STATUS_PSM_NEXT_STATUS_OFFSET 0
#define BSP_TWL3029_LLIF_USB_CR_PSM_NEXT_STATUS_PSM_NEXT_STATUS_WIDTH  6

/*=========BSP_TWL3029_LLIF_USB_CR_PSM_ERR_STATUS=========
 */
#define BSP_TWL3029_LLIF_USB_CR_PSM_ERR_STATUS_PSM_ERR_STATUS_OFFSET   0
#define BSP_TWL3029_LLIF_USB_CR_PSM_ERR_STATUS_PSM_ERR_STATUS_WIDTH    6


/*=========BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_STATE=========
 */
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_STATE_CTRL_STATE_EN_OFFSET    7
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_STATE_CTRL_STATE_EN_WIDTH     1
 
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_STATE_CTRL_STATE_OFFSET       0
#define BSP_TWL3029_LLIF_USB_CR_PSM_CTRL_STATE_CTRL_STATE_WIDTH        6


/*=========BSP_TWL3029_LLIF_USB_CABLE_DEBOUNCE=========
 */
#define BSP_TWL3029_LLIF_USB_CABLE_DEBOUNCE_CABLE_DEBOUNCE_OFFSET   0
#define BSP_TWL3029_LLIF_USB_CABLE_DEBOUNCE_CABLE_DEBOUNCE_WIDTH    8

/*=========BSP_TWL3029_LLIF_USB_TPH_DP_CON_MIN=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_DP_CON_MIN_TPH_DP_CON_MIN_OFFSET   0
#define BSP_TWL3029_LLIF_USB_TPH_DP_CON_MIN_TPH_DP_CON_MIN_WIDTH    7

/*=========BSP_TWL3029_LLIF_USB_TPH_DP_CON_MAX=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_DP_CON_MAX_TPH_DP_CON_MAX_OFFSET   0
#define BSP_TWL3029_LLIF_USB_TPH_DP_CON_MAX_TPH_DP_CON_MAX_WIDTH    7


/*=========BSP_TWL3029_LLIF_USB_TCR_DP_CON_MIN=========
 */
#define BSP_TWL3029_LLIF_USB_TCR_DP_CON_MIN_TCR_DP_CON_MIN_OFFSET   0
#define BSP_TWL3029_LLIF_USB_TCR_DP_CON_MIN_TCR_DP_CON_MIN_WIDTH    7

/*=========BSP_TWL3029_LLIF_USB_TCR_DP_CON_MAX=========
 */
#define BSP_TWL3029_LLIF_USB_TCR_DP_CON_MAX_TCR_DP_CON_MAX_OFFSET   0
#define BSP_TWL3029_LLIF_USB_TCR_DP_CON_MAX_TCR_DP_CON_MAX_WIDTH    7

/*=========BSP_TWL3029_LLIF_USB_TPH_DP_PD_SHORT=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_DP_PD_SHORT_TPH_DP_PD_SHORT_OFFSET 0
#define BSP_TWL3029_LLIF_USB_TPH_DP_PD_SHORT_TPH_DP_PD_SHORT_WIDTH  7

/*=========BSP_TWL3029_LLIF_USB_TPH_AUD_BIAS=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_AUD_BIAS_TPH_AUD_BIAS_OFFSET       0
#define BSP_TWL3029_LLIF_USB_TPH_AUD_BIAS_TPH_AUD_BIAS_WIDTH        7
  

/*=========BSP_TWL3029_LLIF_USB_TCR_INT_ACK=========
 */
#define BSP_TWL3029_LLIF_USB_TCR_INT_ACK_TCR_INT_ACK_OFFSET         0
#define BSP_TWL3029_LLIF_USB_TCR_INT_ACK_TCR_INT_ACK_WIDTH          7

/*=========BSP_TWL3029_LLIF_USB_TPH_MNLO_DET=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_MNLO_DET_TPH_MNLO_DET_OFFSET       0
#define BSP_TWL3029_LLIF_USB_TPH_MNLO_DET_TPH_MNLO_DET_WIDTH        7

/*=========BSP_TWL3029_LLIF_USB_TCR_UART_DET_MIN=========
 */
#define BSP_TWL3029_LLIF_USB_TCR_UART_DET_MIN_TCR_UART_DET_MIN_OFFSET 0
#define BSP_TWL3029_LLIF_USB_TCR_UART_DET_MIN_TCR_UART_DET_MIN_WIDTH  7

/*=========BSP_TWL3029_LLIF_USB_TCR_UART_DET_MAX=========
 */
#define BSP_TWL3029_LLIF_USB_TCR_UART_DET_MAX_TCR_UART_DET_MAX_OFFSET 0
#define BSP_TWL3029_LLIF_USB_TCR_UART_DET_MAX_TCR_UART_DET_MAX_WIDTH  7


/*=========BSP_TWL3029_LLIF_USB_TPH_STLO_DET=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_STLO_DET_TPH_STLO_DET_OFFSET      0
#define BSP_TWL3029_LLIF_USB_TPH_STLO_DET_TPH_STLO_DET_WIDTH       7

/*=========BSP_TWL3029_LLIF_USB_TPH_ID_INT_PW=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_ID_INT_PW_TPH_ID_INT_PW_OFFSET    0
#define BSP_TWL3029_LLIF_USB_TPH_ID_INT_PW_TPH_ID_INT_PW_WIDTH     7

/*=========BSP_TWL3029_LLIF_USB_TACC_ID_INT_WAIT=========
 */
#define BSP_TWL3029_LLIF_USB_TACC_ID_INT_WAIT_TACC_ID_INT_WAIT_OFFSET 0
#define BSP_TWL3029_LLIF_USB_TACC_ID_INT_WAIT_TACC_ID_INT_WAIT_WIDTH  7

/*=========BSP_TWL3029_LLIF_USB_TACC_ID_INT_PW=========
 */
#define BSP_TWL3029_LLIF_USB_TACC_ID_INT_PW_TACC_ID_INT_PW_OFFSET  0
#define BSP_TWL3029_LLIF_USB_TACC_ID_INT_PW_TACC_ID_INT_PW_WIDTH   7

/*=========BSP_TWL3029_LLIF_USB_TPH_CMD_WAIT=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_CMD_WAIT_TPH_CMD_WAIT_OFFSET      0
#define BSP_TWL3029_LLIF_USB_TPH_CMD_WAIT_TPH_CMD_WAIT_WIDTH       7


/*=========BSP_TWL3029_LLIF_USB_TPH_ACK_WAIT=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_ACK_WAIT_TPH_ACK_WAIT_OFFSET     0
#define BSP_TWL3029_LLIF_USB_TPH_ACK_WAIT_TPH_ACK_WAIT_WIDTH      7

/*=========BSP_TWL3029_LLIF_USB_TPH_DET_RST=========
 */
#define BSP_TWL3029_LLIF_USB_TPH_DET_RST_TPH_DET_RST_OFFSET       0
#define BSP_TWL3029_LLIF_USB_TPH_DET_RST_TPH_DET_RST_WIDTH        7


/*====================================================
 *       WLED drivers REGISTERS
 */
/*=========BSP_TWL3029_LLIF_WLED_CTRL=============
 */

#define BSP_TWL3029_LLIF_WLED_WLED_CTRL_WLED_SWFREQ_OFFSET       6  
#define BSP_TWL3029_LLIF_WLED_WLED_CTRL_WLED_SWFREQ_WIDTH        2 

#define BSP_TWL3029_LLIF_WLED_WLED_CTRL_DAC_IREF_CTRL_OFFSET     5  
#define BSP_TWL3029_LLIF_WLED_WLED_CTRL_DAC_IREF_CTRL_WIDTH      1 


/*=========BSP_TWL3029_LLIF_WLED_WLED_RES_TRIM=============
 */

#define BSP_TWL3029_LLIF_WLED_WLED_RES_TRIM_TRIM_CTRL_OFFSET     0
#define BSP_TWL3029_LLIF_WLED_WLED_RES_TRIM_TRIM_CTRL_WIDTH      5

#endif
