/*=============================================================================
 *    Copyright 2004 Texas Instruments Inc. All rights reserved.
 */
#ifndef BSP_TWL3029_AUX_MAP_HEADER
#define BSP_TWL3029_AUX_MAP_HEADER

#if (ANLG_PG == 1)
#include "pg1x/bspTwl3029_Aux_Map_pg1x.h"
#elif (ANLG_PG == 2)
#include "pg2x/bspTwl3029_Aux_Map_pg2x.h"
#endif

/*=============================================================================
 * Component Description:
 *    Register map for Triton Analog Base Band processor - module baraux.
 *     - mapping for the following Triton  registers 
 *    - USB
 *    - MADC
 *    - VIB
 *    - AUX_REG
 *    - WLED
 *    - BCI
 *    - SIM
 */

/*=============================================================================
 * Constants
 */

/*=============================================================================
 */
#define BSP_TWL3029_MAP_USB_VENDOR_ID_LSB_OFFSET      0  /* USB:   VENDOR_ID_LSB */   
#define BSP_TWL3029_MAP_USB_VENDOR_ID_MSB_OFFSET      1  /* USB:   VENDOR_ID_MSB */   
#define BSP_TWL3029_MAP_USB_PRODUCT_ID_LSB_OFFSET     2  /* USB:   PRODUCT_ID_LSB */   
#define BSP_TWL3029_MAP_USB_PRODUCT_ID_MSB_OFFSET     3  /* USB:   PRODUCT_ID_MSB */   
#define BSP_TWL3029_MAP_USB_CTRL_1_SET_OFFSET         4  /* USB:   CTRL_1_SET */   
#define BSP_TWL3029_MAP_USB_CTRL_1_CLR_OFFSET         5  /* USB:   CTRL_1_CLR */   
#define BSP_TWL3029_MAP_USB_CTRL_2_SET_OFFSET         6  /* USB:   CTRL_2_SET */   
#define BSP_TWL3029_MAP_USB_CTRL_2_CLR_OFFSET         7  /* USB:   CTRL_2_CLR */   
#define BSP_TWL3029_MAP_USB_INT_SRC_OFFSET            8  /* USB:   INT_SRC */   
#define BSP_TWL3029_MAP_USB_RESERVED_USB_1_OFFSET     9  /* USB:   RESERVED_USB_1 */   
#define BSP_TWL3029_MAP_USB_INT_LATCH_SET_OFFSET     10  /* USB:   INT_LATCH_SET */   
#define BSP_TWL3029_MAP_USB_INT_LATCH_CLR_OFFSET     11  /* USB:   INT_LATCH_CLR */   
#define BSP_TWL3029_MAP_USB_INT_EN_LO_SET_OFFSET     12  /* USB:   INT_EN_LO_SET */   
#define BSP_TWL3029_MAP_USB_INT_EN_LO_CLR_OFFSET     13  /* USB:   INT_EN_LO_CLR */   
#define BSP_TWL3029_MAP_USB_INT_EN_HI_SET_OFFSET     14  /* USB:   INT_EN_HI_SET */
#define BSP_TWL3029_MAP_USB_INT_EN_HI_CLR_OFFSET     15  /* USB:   INT_EN_HI_CLR */
#define BSP_TWL3029_MAP_USB_CR_PSM_CTRL_OFFSET       16  /* USB:   CR_PSM_CTRL */
/* rest of USB registers are specific to Triton hardware version (PG1.x or PG 2.0) */

#define BSP_TWL3029_MAP_MADC_RTSELECT_LSB_OFFSET      40  /* MADC: RTSELECT_LSB */
#define BSP_TWL3029_MAP_MADC_RTSELECT_MSB_OFFSET      41  /* MADC: RTSELECT_MSB */
#define BSP_TWL3029_MAP_MADC_CTRL_P1_OFFSET           42  /* MADC: CTRL_P1 */
#define BSP_TWL3029_MAP_MADC_CTRL_P2_OFFSET           43  /* MADC: CTRL_P2 */
#define BSP_TWL3029_MAP_MADC_RTCH1_LSB_OFFSET         44  /* MADC: RTCH1_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH1_MSB_OFFSET         45  /* MADC: RTCH1_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH2_LSB_OFFSET         46  /* MADC: RTCH2_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH2_MSB_OFFSET         47  /* MADC: RTCH2_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH3_LSB_OFFSET         48  /* MADC: RTCH3_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH3_MSB_OFFSET         49  /* MADC: RTCH3_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH4_LSB_OFFSET         50  /* MADC: RTCH4_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH4_MSB_OFFSET         51  /* MADC: RTCH4_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH5_LSB_OFFSET         52  /* MADC: RTCH5_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH5_MSB_OFFSET         53  /* MADC: RTCH5_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH6_LSB_OFFSET         54  /* MADC: RTCH6_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH6_MSB_OFFSET         55  /* MADC: RTCH6_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH7_LSB_OFFSET         56  /* MADC: RTCH7_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH7_MSB_OFFSET         57  /* MADC: RTCH7_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH8_LSB_OFFSET         58  /* MADC: RTCH8_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH8_MSB_OFFSET         59  /* MADC: RTCH8_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH9_LSB_OFFSET         60  /* MADC: RTCH9_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH9_MSB_OFFSET         61  /* MADC: RTCH9_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH10_LSB_OFFSET        62  /* MADC: RTCH10_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH10_MSB_OFFSET        63  /* MADC: RTCH10_MSB */
#define BSP_TWL3029_MAP_MADC_RTCH11_LSB_OFFSET        64  /* MADC: RTCH11_LSB */
#define BSP_TWL3029_MAP_MADC_RTCH11_MSB_OFFSET        65  /* MADC: RTCH11_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH1_LSB_OFFSET         66  /* MADC: GPCH1_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH1_MSB_OFFSET         67  /* MADC: GPCH1_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH2_LSB_OFFSET         68  /* MADC: GPCH2_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH2_MSB_OFFSET         69  /* MADC: GPCH2_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH3_LSB_OFFSET         70  /* MADC: GPCH3_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH3_MSB_OFFSET         71  /* MADC: GPCH3_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH4_LSB_OFFSET         72  /* MADC: GPCH4_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH4_MSB_OFFSET         73  /* MADC: GPCH4_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH5_LSB_OFFSET         74  /* MADC: GPCH5_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH5_MSB_OFFSET         75  /* MADC: GPCH5_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH6_LSB_OFFSET         76  /* MADC: GPCH6_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH6_MSB_OFFSET         77  /* MADC: GPCH6_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH7_LSB_OFFSET         78  /* MADC: GPCH7_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH7_MSB_OFFSET         79  /* MADC: GPCH7_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH8_LSB_OFFSET         80  /* MADC: GPCH8_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH8_MSB_OFFSET         81  /* MADC: GPCH8_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH9_LSB_OFFSET         82  /* MADC: GPCH9_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH9_MSB_OFFSET         83  /* MADC: GPCH9_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH10_LSB_OFFSET        84  /* MADC: GPCH10_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH10_MSB_OFFSET        85  /* MADC: GPCH10_MSB */
#define BSP_TWL3029_MAP_MADC_GPCH11_LSB_OFFSET        86  /* MADC: GPCH11_LSB */
#define BSP_TWL3029_MAP_MADC_GPCH11_MSB_OFFSET        87  /* MADC: GPCH11_MSB */
#define BSP_TWL3029_MAP_MADC_MADC_TEST_ANA_OFFSET     88  /* MADC: MADC_TEST_ANA */

#define BSP_TWL3029_MAP_AUX_REG_TOGGLE1_OFFSET          104  /* AUX_REG: TOGGLE1 */
#define BSP_TWL3029_MAP_AUX_REG_TOGGLE2_OFFSET          105  /* AUX_REG: TOGGLE2 */
#define BSP_TWL3029_MAP_AUX_REG_PWDNSTATUS_OFFSET       106  /* AUX_REG: PWDNSTATUS */


#define BSP_TWL3029_MAP_VIB_VIB_CTRL_OFFSET         109  /* VIB: VIB_CTRL */
#define BSP_TWL3029_MAP_VIB_VIB_TEST_ANA_OFFSET     110  /* VIB: VIB_TEST_ANA */

#define BSP_TWL3029_MAP_WLED_CTRL_LEDA_OFFSET        113  /* WLED: CTRL_LEDA */
#define BSP_TWL3029_MAP_WLED_CTRL_LEDB_OFFSET        114  /* WLED: CTRL_LEDB */
#define BSP_TWL3029_MAP_WLED_CTRL_LEDC_OFFSET        115  /* WLED: CTRL_LEDC */
#define BSP_TWL3029_MAP_WLED_WLED_CTRL_OFFSET        116  /* WLED: WLED_CTRL */
#define BSP_TWL3029_MAP_WLED_WLED_TEST_ANA_OFFSET    117  /* WLED: WLED_TEST_ANA */


#define BSP_TWL3029_MAP_BCI_CHGVREG2_OFFSET         119  /* BCI: CHGVREG2 */
#define BSP_TWL3029_MAP_BCI_CHGVREG1_OFFSET         120  /* BCI: CHGVREG1 */
#define BSP_TWL3029_MAP_BCI_CHGIREG_OFFSET          121  /* BCI: CHGIREG */
#define BSP_TWL3029_MAP_BCI_BCISECU_OFFSET          122  /* BCI: BCISECU */
#define BSP_TWL3029_MAP_BCI_BCISKEY_OFFSET          123  /* BCI: BCISKEY */
#define BSP_TWL3029_MAP_BCI_BCICTL1_OFFSET          124  /* BCI: BCICTL1 */
#define BSP_TWL3029_MAP_BCI_BCICTL2_OFFSET          125  /* BCI: BCICTL2 */
#define BSP_TWL3029_MAP_BCI_BCIPWM2_OFFSET          126  /* BCI: BCIPWM2 */   
#define BSP_TWL3029_MAP_BCI_BCIPWM1_OFFSET          127  /* BCI: BCIPWM1 */   
#define BSP_TWL3029_MAP_BCI_BCIWDKEY_OFFSET         128  /* BCI: BCIWDKEY */   
#define BSP_TWL3029_MAP_BCI_BCIWD_OFFSET            129  /* BCI: BCIWD */   
#define BSP_TWL3029_MAP_BCI_BCI_ICTL_OFFSET         130  /* BCI: BCI_ICTL */   
#define BSP_TWL3029_MAP_BCI_BCICTL3_OFFSET          131  /* BCI: BCICTL3 */   
#define BSP_TWL3029_MAP_BCI_TST_1_OFFSET            132  /* BCI: TST_1 */   
#define BSP_TWL3029_MAP_BCI_TST_2_OFFSET            133  /* BCI: TST_2 */   
#define BSP_TWL3029_MAP_BCI_TST_3_OFFSET            134  /* BCI: TST_3 */   
#define BSP_TWL3029_MAP_BCI_TST_4_OFFSET            135  /* BCI: TST_4 */   


#define BSP_TWL3029_MAP_SIM_SIMDEBOUNCING_OFFSET    139  /* SIM-Card: SIMDEBOUNCING */   
#define BSP_TWL3029_MAP_SIM_SIMDTCCTRL_OFFSET       140  /* SIM-Card: SIMDTCCTRL */   

#endif
