/*=============================================================================
 *    Copyright 2004 Texas Instruments Inc. All rights reserved.
 */
#ifndef BSP_TWL3029_AUX_LLIF_HEADER
#define BSP_TWL3029_AUX_LLIF_HEADER

#include "bspUtil_BitUtil.h"

#if (ANLG_PG == 1)
#include "pg1x/bspTwl3029_Aux_Llif_pg1x.h"
#elif (ANLG_PG == 2)
#include "pg2x/bspTwl3029_Aux_Llif_pg2x.h"
#endif 

/*=============================================================================
 * Component Description:
 *    Provides accessor and manipulator macros for TWL3029 aka Triton
 *    register fields for BARAUX modules. Fields offsets and widths are encoded in contants
 *    that are to be fed into simple macros. This common approach should
 *    help to prevent masking errors.
 *
 *    the BARAUX registers consist of
 *     - USB registers
 *     - MADC registers
 *     - AUX registers
 *     - WLED registers
 *     - VIB registers
 *     - BCI registers
 *     - SIM card registers
 */

/*====================================================
 *       USB REGISTERS
 */

/*=========BSP_TWL3029_LLIF_USB_VENDOR_ID_LSB=========
 */
#define BSP_TWL3029_LLIF_USB_VENDOR_ID_LSB_VENDOR_ID_OFFSET 0 
#define BSP_TWL3029_LLIF_USB_VENDOR_ID_LSB_VENDOR_ID_WIDTH  8 


/*=========BSP_TWL3029_LLIF_USB_VENDOR_ID_MSB=========
 */
#define BSP_TWL3029_LLIF_USB_VENDOR_ID_MSB_VENDOR_ID_OFFSET 0 
#define BSP_TWL3029_LLIF_USB_VENDOR_ID_MSB_VENDOR_ID_WIDTH  8 


/*=========BSP_TWL3029_LLIF_USB_PRODUCT_ID_LSB=========
 */
#define BSP_TWL3029_LLIF_USB_PRODUCT_ID_LSB_PRODUCT_ID_OFFSET 0 
#define BSP_TWL3029_LLIF_USB_PRODUCT_ID_LSB_PRODUCT_ID_WIDTH  8 

/*=========BSP_TWL3029_LLIF_USB_PRODUCT_ID_MSB=========
 */
#define BSP_TWL3029_LLIF_USB_PRODUCT_ID_MSB_PRODUCT_ID_OFFSET 0 
#define BSP_TWL3029_LLIF_USB_PRODUCT_ID_MSB_PRODUCT_ID_WIDTH  8 


/*=========BSP_TWL3029_LLIF_USB_CTRL_1_SET=========
 */
#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_RSVRD_2_OFFSET      7  
#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_RSVRD_2_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_UART_EN_OFFSET      6  
#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_UART_EN_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_OE_INT_EN_OFFSET    5 
#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_OE_INT_EN_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_BDIS_ACON_EN_OFFSET 4  
#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_BDIS_ACON_EN_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_RSVRD_1_OFFSET      3  
#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_RSVRD_1_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_DAT_SE0_OFFSET      2  
#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_DAT_SE0_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_SUSPEND_OFFSET      1  
#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_SUSPEND_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_SPEED_OFFSET        0 
#define BSP_TWL3029_LLIF_USB_CTRL_1_SET_SPEED_WIDTH         1


/*=========BSP_TWL3029_LLIF_USB_CTRL_1_CLR=========
 */
#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_RSVRD_2_OFFSET      7  
#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_RSVRD_2_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_UART_EN_OFFSET      6  
#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_UART_EN_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_OE_INT_EN_OFFSET    5 
#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_OE_INT_EN_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_BDIS_ACON_EN_OFFSET 4  
#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_BDIS_ACON_EN_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_RSVRD_1_OFFSET      3  
#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_RSVRD_1_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_DAT_SE0_OFFSET      2  
#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_DAT_SE0_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_SUSPEND_OFFSET      1  
#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_SUSPEND_WIDTH       1 

#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_SPEED_OFFSET        0 
#define BSP_TWL3029_LLIF_USB_CTRL_1_CLR_SPEED_WIDTH         1


/*=========BSP_TWL3029_LLIF_USB_CTRL_2_SET=========
 */
#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_VBUS_CHRG_OFFSET   7
#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_VBUS_CHRG_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_VBUS_DISCHRG_OFFSET 6  
#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_VBUS_DISCHRG_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_VBUS_DRV_OFFSET    5
#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_VBUS_DRV_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_CMD_ID_GND_OFFSET  4 
#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_CMD_ID_GND_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_DM_PULLDOWN_OFFSET 3  
#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_DM_PULLDOWN_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_DP_PULLDOWN_OFFSET 2  
#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_DP_PULLDOWN_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_DM_PULLUP_OFFSET  1 
#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_DM_PULLUP_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_DP_PULLUP_OFFSET  0 
#define BSP_TWL3029_LLIF_USB_CTRL_2_SET_DP_PULLUP_WIDTH   1

/*=========BSP_TWL3029_LLIF_USB_CTRL_2_CLR=========
 */
#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_VBUS_CHRG_OFFSET   7
#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_VBUS_CHRG_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_VBUS_DISCHRG_OFFSET 6  
#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_VBUS_DISCHRG_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_VBUS_DRV_OFFSET    5
#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_VBUS_DRV_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_CMD_ID_GND_OFFSET  4 
#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_CMD_ID_GND_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_DM_PULLDOWN_OFFSET 3  
#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_DM_PULLDOWN_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_DP_PULLDOWN_OFFSET 2  
#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_DP_PULLDOWN_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_DM_PULLUP_OFFSET  1 
#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_DM_PULLUP_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_DP_PULLUP_OFFSET  0 
#define BSP_TWL3029_LLIF_USB_CTRL_2_CLR_DP_PULLUP_WIDTH   1

/*=========BSP_TWL3029_LLIF_USB_INT_SRC=========
 */

#define BSP_TWL3029_LLIF_USB_INT_SRC_CR_INT_OFFSET    7
#define BSP_TWL3029_LLIF_USB_INT_SRC_CR_INT_WIDTH     1
 
#define BSP_TWL3029_LLIF_USB_INT_SRC_BDIS_ACON_OFFSET 6  
#define BSP_TWL3029_LLIF_USB_INT_SRC_BDIS_ACON_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_INT_SRC_ID_FLOAT_OFFSET 5  
#define BSP_TWL3029_LLIF_USB_INT_SRC_ID_FLOAT_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_INT_SRC_DM_HI_OFFSET    4  
#define BSP_TWL3029_LLIF_USB_INT_SRC_DM_HI_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_SRC_ID_GND_OFFSET   3
#define BSP_TWL3029_LLIF_USB_INT_SRC_ID_GND_WIDTH    1 

#define BSP_TWL3029_LLIF_USB_INT_SRC_DP_HI_OFFSET    2 
#define BSP_TWL3029_LLIF_USB_INT_SRC_DP_HI_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_SRC_SESS_VLD_OFFSET 1  
#define BSP_TWL3029_LLIF_USB_INT_SRC_SESS_VLD_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_INT_SRC_VBUS_VLD_OFFSET 0  
#define BSP_TWL3029_LLIF_USB_INT_SRC_VBUS_VLD_WIDTH  1



/*=========BSP_TWL3029_LLIF_USB_INT_LATCH_SET=========
 */
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_CR_INT_OFFSET    7
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_CR_INT_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_BDIS_ACON_OFFSET 6  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_BDIS_ACON_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_ID_FLOAT_OFFSET  5  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_ID_FLOAT_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_DM_HI_OFFSET     4
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_DM_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_ID_GND_OFFSET    3
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_ID_GND_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_DP_HI_OFFSET     2
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_DP_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_SET_VBUS_VLD_WIDTH   1


/*=========BSP_TWL3029_LLIF_USB_INT_LATCH_CLR=========
 */
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_CR_INT_OFFSET    7
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_CR_INT_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_BDIS_ACON_OFFSET 6  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_BDIS_ACON_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_ID_FLOAT_OFFSET  5  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_ID_FLOAT_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_DM_HI_OFFSET     4
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_DM_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_ID_GND_OFFSET    3
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_ID_GND_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_DP_HI_OFFSET     2
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_DP_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_LATCH_CLR_VBUS_VLD_WIDTH   1

/*=========BSP_TWL3029_LLIF_USB_INT_EN_LO_SET=========
 */
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_CR_INT_OFFSET    7
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_CR_INT_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_BDIS_ACON_OFFSET 6  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_BDIS_ACON_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_ID_FLOAT_OFFSET  5  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_ID_FLOAT_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_DM_HI_OFFSET     4
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_DM_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_ID_GND_OFFSET    3
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_ID_GND_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_DP_HI_OFFSET     2
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_DP_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_SET_VBUS_VLD_WIDTH   1


/*=========BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR=========
 */
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_CR_INT_OFFSET    7
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_CR_INT_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_BDIS_ACON_OFFSET 6  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_BDIS_ACON_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_ID_FLOAT_OFFSET  5  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_ID_FLOAT_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_DM_HI_OFFSET     4
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_DM_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_ID_GND_OFFSET    3
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_ID_GND_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_DP_HI_OFFSET     2
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_DP_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_EN_LO_CLR_VBUS_VLD_WIDTH   1

/*=========BSP_TWL3029_LLIF_USB_INT_EN_HI_SET=========
 */
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_CR_INT_OFFSET    7
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_CR_INT_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_BDIS_ACON_OFFSET 6  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_BDIS_ACON_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_ID_FLOAT_OFFSET  5  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_ID_FLOAT_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_DM_HI_OFFSET     4
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_DM_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_ID_GND_OFFSET    3
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_ID_GND_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_DP_HI_OFFSET     2
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_DP_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_SET_VBUS_VLD_WIDTH   1


/*=========BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR=========
 */
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_CR_INT_OFFSET    7
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_CR_INT_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_BDIS_ACON_OFFSET 6  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_BDIS_ACON_WIDTH  1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_ID_FLOAT_OFFSET  5  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_ID_FLOAT_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_DM_HI_OFFSET     4
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_DM_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_ID_GND_OFFSET    3
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_ID_GND_WIDTH     1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_DP_HI_OFFSET     2
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_DP_HI_WIDTH      1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_SESS_VLD_OFFSET  1  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_SESS_VLD_WIDTH   1 

#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_VBUS_VLD_OFFSET  0  
#define BSP_TWL3029_LLIF_USB_INT_EN_HI_CLR_VBUS_VLD_WIDTH   1


/*=====================================================
 *     MADC REGISTERS
 */

/*=========BSP_TWL3029_LLIF_MADC_RTSELECT_LSB=========
 */
#define BSP_TWL3029_LLIF_MADC_RTSELECT_LSB_CH_OFFSET 0
#define BSP_TWL3029_LLIF_MADC_RTSELECT_LSB_CH_WIDTH  8 

/*=========BSP_TWL3029_LLIF_MADC_RTSELECT_MSB=========
 */
#define BSP_TWL3029_LLIF_MADC_RTSELECT_MSB_CH_OFFSET 0
#define BSP_TWL3029_LLIF_MADC_RTSELECT_MSB_CH_WIDTH  3 

/*=========BSP_TWL3029_LLIF_MADC_CTRL_P1=============
 */
#define BSP_TWL3029_LLIF_MADC_CTRL_P1_SP1_OFFSET   3
#define BSP_TWL3029_LLIF_MADC_CTRL_P1_SP1_WIDTH    1 

#define BSP_TWL3029_LLIF_MADC_CTRL_P1_EOCRT_OFFSET 2  
#define BSP_TWL3029_LLIF_MADC_CTRL_P1_EOCRT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_CTRL_P1_EOCP1_OFFSET 1  
#define BSP_TWL3029_LLIF_MADC_CTRL_P1_EOCP1_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_CTRL_P1_BUSY_OFFSET  0 
#define BSP_TWL3029_LLIF_MADC_CTRL_P1_BUSY_WIDTH   1

/*=========BSP_TWL3029_LLIF_MADC_CTRL_P2=============
 */
 
#define BSP_TWL3029_LLIF_MADC_CTRL_P2_SP2_OFFSET  2  
#define BSP_TWL3029_LLIF_MADC_CTRL_SP2_WIDTH      1 

#define BSP_TWL3029_LLIF_MADC_CTRL_EOCP2_OFFSET   1  
#define BSP_TWL3029_LLIF_MADC_CTRL_EOCP2_WIDTH    1 

#define BSP_TWL3029_LLIF_MADC_CTRL_BUSY_OFFSET    0  
#define BSP_TWL3029_LLIF_MADC_CTRL_BUSY_WIDTH     1
 
/*=========BSP_TWL3029_LLIF_MADC_RTCH1_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH1_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH1_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH1_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH1_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH1_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH1_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH1_MSB_MSB_WIDTH           2 


/*=========BSP_TWL3029_LLIF_MADC_RTCH2_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH2_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH2_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH2_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH2_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH2_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH2_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH2_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_RTCH3_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH3_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH3_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH3_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH3_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH3_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH3_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH3_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_RTCH4_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH4_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH4_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH4_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH4_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH4_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH4_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH4_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_RTCH5_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH5_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH5_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH5_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH5_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH5_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH5_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH5_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_RTCH6_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH6_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH6_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH6_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH6_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH6_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH6_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH6_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_RTCH7_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH7_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH7_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH7_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH7_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH7_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH7_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH7_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_RTCH8_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH8_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH8_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH8_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH8_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH8_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH8_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH8_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_RTCH9_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH9_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH9_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH9_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH9_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH9_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH9_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH9_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_RTCH10_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH10_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH10_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH10_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH10_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH10_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH10_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH10_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_RTCH11_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_RTCH11_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_RTCH11_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_RTCH11_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_RTCH11_MSB_COLLISION_RT_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_RTCH11_MSB_COLLISION_RT_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_RTCH11_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_RTCH11_MSB_MSB_WIDTH           2 





/////start
 
/*=========BSP_TWL3029_LLIF_MADC_GPCH1_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH1_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH1_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH1_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH1_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH1_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH1_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH1_MSB_MSB_WIDTH           2 


/*=========BSP_TWL3029_LLIF_MADC_GPCH2_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH2_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH2_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH2_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH2_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH2_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH2_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH2_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_GPCH3_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH3_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH3_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH3_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH3_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH3_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH3_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH3_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_GPCH4_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH4_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH4_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH4_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH4_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH4_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH4_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH4_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_GPCH5_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH5_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH5_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH5_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH5_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH5_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH5_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH5_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_GPCH6_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH6_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH6_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH6_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH6_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH6_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH6_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH6_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_GPCH7_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH7_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH7_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH7_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH7_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH7_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH7_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH7_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_GPCH8_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH8_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH8_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH8_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH8_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH8_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH8_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH8_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_GPCH9_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH9_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH9_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH9_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH9_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH9_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH9_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH9_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_GPCH10_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH10_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH10_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH10_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH10_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH10_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH10_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH10_MSB_MSB_WIDTH           2 

/*=========BSP_TWL3029_LLIF_MADC_GPCH11_LSB=============
 */
#define BSP_TWL3029_LLIF_MADC_GPCH11_LSB_LSB_OFFSET          0 
#define BSP_TWL3029_LLIF_MADC_GPCH11_LSB_LSB_WIDTH           8 

/*=========BSP_TWL3029_LLIF_MADC_GPCH11_MSB=============
 */

#define BSP_TWL3029_LLIF_MADC_GPCH11_MSB_COLLISION_GP_OFFSET 2 
#define BSP_TWL3029_LLIF_MADC_GPCH11_MSB_COLLISION_GP_WIDTH  1 

#define BSP_TWL3029_LLIF_MADC_GPCH11_MSB_MSB_OFFSET          0  
#define BSP_TWL3029_LLIF_MADC_GPCH11_MSB_MSB_WIDTH           2 


/*=========BSP_TWL3029_LLIF_MADC_MADC_TEST_ANA=============
 */
#define BSP_TWL3029_LLIF_MADC_MADC_TEST_ANA_WLED_MONITOR_OFFSET 1  
#define BSP_TWL3029_LLIF_MADC_MADC_TEST_ANA_WLED_MONITOR_WIDTH  1
 
#define BSP_TWL3029_LLIF_MADC_MADC_TEST_ANA_TEST_VREF_OFFSET    0
#define BSP_TWL3029_LLIF_MADC_MADC_TEST_ANA_TEST_VREF_WIDTH     1


/*======================================================
 *     AUXILLARY REGISTERS
 */
 
/*=========BSP_TWL3029_LLIF_AUX_REG_TOGGLE1=============
 */
 
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_SIMS_OFFSET  7 
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_SIMS_WIDTH   1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_SIMR_OFFSET  6 
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_SIMR_WIDTH   1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_USBDS_OFFSET 5  
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_USBDS_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_USBDR_OFFSET 4  
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_USBDR_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_VIBS_OFFSET  3 
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_VIBS_WIDTH   1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_VIBR_OFFSET  2 
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_VIBR_WIDTH   1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_MADCS_OFFSET 1  
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_MADCS_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_MADCR_OFFSET 0   
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE1_MADCR_WIDTH  1

/*=========BSP_TWL3029_LLIF_AUX_REG_TOGGLE2=============
 */

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_USBAS_OFFSET  7 
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_USBAS_WIDTH   1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_USBAR_OFFSET  6 
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_USBAR_WIDTH   1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDCS_OFFSET 5  
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDCS_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDCR_OFFSET 4  
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDCR_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDBS_OFFSET 3  
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDBS_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDBR_OFFSET 2  
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDBR_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDAS_OFFSET 1  
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDAS_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDAR_OFFSET 0   
#define BSP_TWL3029_LLIF_AUX_REG_TOGGLE2_WLEDAR_WIDTH  1

/*=========BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS=============
 */
#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_USBA_EN_OFFSET  7 
#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_USBA_EN_WIDTH   1 

#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_WLEDC_EN_OFFSET 6  
#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_WLEDC_EN_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_WLEDB_EN_OFFSET 5  
#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_WLEDB_EN_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_WLEDA_EN_OFFSET 4  
#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_WLEDA_EN_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_SIM_EN_OFFSET  3 
#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_SIM_EN_WIDTH   1 

#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_USBD_EN_OFFSET 2  
#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_USBD_EN_WIDTH  1 

#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_VIB_EN_OFFSET  1 
#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_VIB_EN_WIDTH   1 

#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_MADCON_OFFSET  0 
#define BSP_TWL3029_LLIF_AUX_REG_PWDNSTATUS_MADCON_WIDTH   1

/*=========BSP_TWL3029_LLIF_VIB_VIB_CTRL=============
 */
#define BSP_TWL3029_LLIF_VIB_VIB_CTRL_TRIM_OFFSET 4 
#define BSP_TWL3029_LLIF_VIB_VIB_CTRL_TRIM_WIDTH  3 

#define BSP_TWL3029_LLIF_VIB_VIB_CTRL_VSEL_OFFSET   2
#define BSP_TWL3029_LLIF_VIB_VIB_CTRL_VSEL_WIDTH    2 

#define BSP_TWL3029_LLIF_VIB_VIB_CTRL_DSEL_OFFSET   0  
#define BSP_TWL3029_LLIF_VIB_VIB_CTRL_DSEL_WIDTH    2 

/*=========BSP_TWL3029_LLIF_VIB_VIB_TEST_ANA=============
 */

#define BSP_TWL3029_LLIF_VIB_VIB_TEST_ANA_TESTMODE_5_OFFSET 2  
#define BSP_TWL3029_LLIF_VIB_VIB_TEST_ANA_TESTMODE_5_WIDTH  1

#define BSP_TWL3029_LLIF_VIB_VIB_TEST_ANA_TESTMODE_4_OFFSET 1  
#define BSP_TWL3029_LLIF_VIB_VIB_TEST_ANA_TESTMODE_4_WIDTH  1 

#define BSP_TWL3029_LLIF_VIB_VIB_TEST_ANA_TESTMODE_3_OFFSET 0  
#define BSP_TWL3029_LLIF_VIB_VIB_TEST_ANA_TESTMODE_3_WIDTH  1

/*=========BSP_TWL3029_LLIF_WLED_CTRL_LEDA=============
 */
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DACINA_3_OFFSET  7 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DACINA_3_WIDTH   1
 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DACINA_2_OFFSET  6 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DACINA_2_WIDTH   1
 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DACINA_1_OFFSET  5 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DACINA_1_WIDTH   1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DACINA_0_OFFSET  4 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DACINA_0_WIDTH   1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DCCTRLA_3_OFFSET 3  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DCCTRLA_3_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DCCTRLA_2_OFFSET 2  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DCCTRLA_2_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DCCTRLA_1_OFFSET 1  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DCCTRLA_1_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DCCTRLA_0_OFFSET 0    
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDA_DCCTRLA_0_WIDTH  1


/*=========BSP_TWL3029_LLIF_WLED_CTRL_LEDB=============
 */
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DACINB_3_OFFSET  7 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DACINB_3_WIDTH   1
 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DACINB_2_OFFSET  6 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DACINB_2_WIDTH   1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DACINB_1_OFFSET  5 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DACINB_1_WIDTH   1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DACINB_0_OFFSET  4 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DACINB_0_WIDTH   1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DCCTRLB_3_OFFSET 3  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DCCTRLB_3_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DCCTRLB_2_OFFSET 2  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DCCTRLB_2_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DCCTRLB_1_OFFSET 1  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DCCTRLB_1_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DCCTRLB_0_OFFSET 0  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDB_DCCTRLB_0_WIDTH  1

/*=========BSP_TWL3029_LLIF_WLED_CTRL_LEDC=============
 */
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DACINC_3_OFFSET  7 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DACINC_3_WIDTH   1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DACINC_2_OFFSET  6 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DACINC_2_WIDTH   1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DACINC_1_OFFSET  5 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DACINC_1_WIDTH   1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DACINC_0_OFFSET  4 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DACINC_0_WIDTH   1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DCCTRLC_3_OFFSET 3  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DCCTRLC_3_WIDTH  1
 
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DCCTRLC_2_OFFSET 2  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DCCTRLC_2_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DCCTRLC_1_OFFSET 1  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DCCTRLC_1_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DCCTRLC_0_OFFSET 0  
#define BSP_TWL3029_LLIF_WLED_CTRL_LEDC_DCCTRLC_0_WIDTH  1

/*=========BSP_TWL3029_LLIF_WLED_CTRL=============
 */
#define BSP_TWL3029_LLIF_WLED_WLED_CTRL_TIMER_CTRL_OFFSET 1 
#define BSP_TWL3029_LLIF_WLED_WLED_CTRL_TIMER_CTRL_WIDTH  4 


#define BSP_TWL3029_LLIF_WLED_WLED_CTRL_LPM_OFFSET          0 
#define BSP_TWL3029_LLIF_WLED_WLED_CTRL_LPM_WIDTH           1

/*=========BSP_TWL3029_LLIF_WLED_TEST_ANA=============
 */

#define BSP_TWL3029_LLIF_WLED_WLED_TEST_ANA_ANTIDP_DEF_OFFSET 3  
#define BSP_TWL3029_LLIF_WLED_WLED_TEST_ANA_ANTIDP_DEF_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_WLED_TEST_ANA_TEST_4_OFFSET 2  
#define BSP_TWL3029_LLIF_WLED_WLED_TEST_ANA_TEST_4_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_WLED_TEST_ANA_TEST_2_OFFSET 1  
#define BSP_TWL3029_LLIF_WLED_WLED_TEST_ANA_TEST_2_WIDTH  1 

#define BSP_TWL3029_LLIF_WLED_WLED_TEST_ANA_TEST_1_OFFSET 0  
#define BSP_TWL3029_LLIF_WLED_WLED_TEST_ANA_TEST_1_WIDTH  1

/*===================================================
 *     BCI REGISTERS
 */
/*=========BSP_TWL3029_LLIF_BCI_CHGVREG2=============
 */
#define BSP_TWL3029_LLIF_BCI_CHGVREG2_CHGV_2_LSBS_OFFSET 6  
#define BSP_TWL3029_LLIF_BCI_CHGVREG2_CHGV_2_LSBS_WIDTH  2 



/*=========BSP_TWL3029_LLIF_BCI_CHGVREG1=============
 */
#define BSP_TWL3029_LLIF_BCI_CHGVREG1_CHGV_8_MSBS_OFFSET 0 
#define BSP_TWL3029_LLIF_BCI_CHGVREG1_CHGV_8_MSBS_WIDTH  8 

/*=========BSP_TWL3029_LLIF_BCI_CHGIREG=============
 */
#define BSP_TWL3029_LLIF_BCI_CHGIREG_CHGI_OFFSET  1
#define BSP_TWL3029_LLIF_BCI_CHGIREG_CHGI_WIDTH   8 

/*=========BSP_TWL3029_LLIF_BCI_BCISECU=============
 */
#define BSP_TWL3029_LLIF_BCI_BCISECU_PROCTL_OFFSET  6 
#define BSP_TWL3029_LLIF_BCI_BCISECU_PROCTL_WIDTH   2 

#define BSP_TWL3029_LLIF_BCI_BCISECU_THSIGN_OFFSET  5 
#define BSP_TWL3029_LLIF_BCI_BCISECU_THSIGN_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_BCISECU_PROEN_OFFSET   4  
#define BSP_TWL3029_LLIF_BCI_BCISECU_PROEN_WIDTH    1 

#define BSP_TWL3029_LLIF_BCI_BCISECU_LIMITEN_OFFSET 3  
#define BSP_TWL3029_LLIF_BCI_BCISECU_LIMITEN_WIDTH  1 

#define BSP_TWL3029_LLIF_BCI_BCISECU_PROTECT_OFFSET 2  
#define BSP_TWL3029_LLIF_BCI_BCISECU_PROTECT_WIDTH  1 

/*=========BSP_TWL3029_LLIF_BCI_BCISKEY=============
 */
#define BSP_TWL3029_LLIF_BCI_BCISKEY_SKEY_OFFSET 0  
#define BSP_TWL3029_LLIF_BCI_BCISKEY_SKEY_WIDTH  8 

/*=========BSP_TWL3029_LLIF_BCI_BCICTL1=============
 */
#define BSP_TWL3029_LLIF_BCI_BCICTL1_THSENSA_OFFSET  7 
#define BSP_TWL3029_LLIF_BCI_BCICTL1_THSENSA_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_BCICTL1_TYPEN_OFFSET    6 
#define BSP_TWL3029_LLIF_BCI_BCICTL1_TYPEN_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_BCICTL1_THEN_OFFSET     5
#define BSP_TWL3029_LLIF_BCI_BCICTL1_THEN_WIDTH      1 

#define BSP_TWL3029_LLIF_BCI_BCICTL1_THSENS_OFFSET   2  
#define BSP_TWL3029_LLIF_BCI_BCICTL1_THSENS_WIDTH    3 

#define BSP_TWL3029_LLIF_BCI_BCICTL1_CHIV_OFFSET    1
#define BSP_TWL3029_LLIF_BCI_BCICTL1_CHIV_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_BCICTL1_CHEN_OFFSET    0  
#define BSP_TWL3029_LLIF_BCI_BCICTL1_CHEN_WIDTH     1

/*=========BSP_TWL3029_LLIF_BCI_BCICTL2=============
 */
#define BSP_TWL3029_LLIF_BCI_BCICTL2_OFFEN_OFFSET     7  
#define BSP_TWL3029_LLIF_BCI_BCICTL2_OFFEN_WIDTH      1 

#define BSP_TWL3029_LLIF_BCI_BCICTL2_OFFSN_OFFSET     5
#define BSP_TWL3029_LLIF_BCI_BCICTL2_OFFSN_WIDTH      2 

#define BSP_TWL3029_LLIF_BCI_BCICTL2_CGAIN4_OFFSET    4
#define BSP_TWL3029_LLIF_BCI_BCICTL2_CGAIN4_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_BCICTL2_CLIB_OFFSET      3
#define BSP_TWL3029_LLIF_BCI_BCICTL2_CLIB_WIDTH       1 

#define BSP_TWL3029_LLIF_BCI_BCICTL2_ACCSUPEN_OFFSET  2 
#define BSP_TWL3029_LLIF_BCI_BCICTL2_ACCSUPEN_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_BCICTL2_ACPATHEN_OFFSET  1 
#define BSP_TWL3029_LLIF_BCI_BCICTL2_ACPATHEN_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_BCICTL2_USBPATHEN_OFFSET 0  
#define BSP_TWL3029_LLIF_BCI_BCICTL2_USBPATHEN_WIDTH  1

/*=========BSP_TWL3029_LLIF_BCI_BCIPWM2=============
 */
#define BSP_TWL3029_LLIF_BCI_BCIPWM2_PWMDTYCY_2LSBS_OFFSET  6  
#define BSP_TWL3029_LLIF_BCI_BCIPWM2_PWMDTYCY_2LSBS_WIDTH   2 

#define BSP_TWL3029_LLIF_BCI_BCIPWM2_PWMEN_OFFSET     5
#define BSP_TWL3029_LLIF_BCI_BCIPWM2_PWMEN_WIDTH      1 

#define BSP_TWL3029_LLIF_BCI_BCIPWM2_PWM_OFFSET       4
#define BSP_TWL3029_LLIF_BCI_BCIPWM2_PWM_WIDTH        1 

/*=========BSP_TWL3029_LLIF_BCI_BCIPWM1=============
 */
#define BSP_TWL3029_LLIF_BCI_BCIPWM1_PWMDTYCY_8MSBS_OFFSET 0 
#define BSP_TWL3029_LLIF_BCI_BCIPWM1_PWMDTYCY_8MSBS_WIDTH  8 

/*=========BSP_TWL3029_LLIF_BCI_BCIWDKEY=============
 */
#define BSP_TWL3029_LLIF_BCI_BCIWDKEY_WDKEY_OFFSET 0  
#define BSP_TWL3029_LLIF_BCI_BCIWDKEY_WDKEY_WIDTH  8

/*=========BSP_TWL3029_LLIF_BCI_BCIWD=============
 */
#define BSP_TWL3029_LLIF_BCI_BCIWD_WOVF_OFFSET   7  
#define BSP_TWL3029_LLIF_BCI_BCIWD_WOVF_WIDTH    1 

#define BSP_TWL3029_LLIF_BCI_BCIWD_WEN_OFFSET    6
#define BSP_TWL3029_LLIF_BCI_BCIWD_WEN_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_BCIWD_WSTS_OFFSET   4  
#define BSP_TWL3029_LLIF_BCI_BCIWD_WSTS_WIDTH    2 


/*=========BSP_TWL3029_LLIF_BCI_ICTL=============
 */
#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_ACFORCE0_OFFSET   7
#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_ACFORCE0_WIDTH    1 

#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_ACFORCE1_OFFSET   6
#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_ACFORCE1_WIDTH    1 

#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_AC2FORCE_OFFSET   5
#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_AC2FORCE_WIDTH    1 

#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_ACSHIFTEN_OFFSET  4 
#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_ACSHIFTEN_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_USBSHIFTEN_OFFSET 3   
#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_USBSHIFTEN_WIDTH  1 

#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_USB2FORCE_OFFSET  2  
#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_USB2FORCE_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_USBFORCE0_OFFSET  1  
#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_USBFORCE0_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_USBFORCE1_OFFSET  0    
#define BSP_TWL3029_LLIF_BCI_BCI_ICTL_USBFORCE1_WIDTH   1

/*=========BSP_TWL3029_LLIF_BCI_BCICTLL=============
 */
#define BSP_TWL3029_LLIF_BCI_BCICTL3_PREACOFF_OFFSET  7 
#define BSP_TWL3029_LLIF_BCI_BCICTL3_PREACOFF_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_BCICTL3_PREUSBOFF_OFFSET 6  
#define BSP_TWL3029_LLIF_BCI_BCICTL3_PREUSBOFF_WIDTH  1 

#define BSP_TWL3029_LLIF_BCI_BCICTL3_MESBAT_OFFSET    5
#define BSP_TWL3029_LLIF_BCI_BCICTL3_MESBAT_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_BCICTL3_MESVAC_OFFSET    4
#define BSP_TWL3029_LLIF_BCI_BCICTL3_MESVAC_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_BCICTL3_ITOVEN_OFFSET    3
#define BSP_TWL3029_LLIF_BCI_BCICTL3_ITOVEN_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_BCICTL3_BIASEN_OFFSET    2
#define BSP_TWL3029_LLIF_BCI_BCICTL3_BIASEN_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_BCICTL3_VBUSSTS_OFFSET   1 
#define BSP_TWL3029_LLIF_BCI_BCICTL3_VBUSSTS_WIDTH    1 

#define BSP_TWL3029_LLIF_BCI_BCICTL3_DACEN_OFFSET     0
#define BSP_TWL3029_LLIF_BCI_BCICTL3_DACEN_WIDTH      1

/*=========BSP_TWL3029_LLIF_BCI_TST_1=============
 */
#define BSP_TWL3029_LLIF_BCI_TST_1_CLK_SWTCH_OFFSET   7
#define BSP_TWL3029_LLIF_BCI_TST_1_CLK_SWTCH_WIDTH    1 

#define BSP_TWL3029_LLIF_BCI_TST_1_PROCTL_OFFSET      5
#define BSP_TWL3029_LLIF_BCI_TST_1_PROCTL_WIDTH       2 

#define BSP_TWL3029_LLIF_BCI_TST_1_THSIGN_OFFSET      4
#define BSP_TWL3029_LLIF_BCI_TST_1_THSIGN_WIDTH       1 

#define BSP_TWL3029_LLIF_BCI_TST_1_PROEN_OFFSET       3
#define BSP_TWL3029_LLIF_BCI_TST_1_PROEN_WIDTH        1 

#define BSP_TWL3029_LLIF_BCI_TST_1_LIMITEN_OFFSET     2
#define BSP_TWL3029_LLIF_BCI_TST_1_LIMITEN_WIDTH      1 

#define BSP_TWL3029_LLIF_BCI_TST_1_CHEN_OFFSET        1
#define BSP_TWL3029_LLIF_BCI_TST_1_CHEN_WIDTH         1 

#define BSP_TWL3029_LLIF_BCI_TST_1_TEST_BYPASS_OFFSET 0  
#define BSP_TWL3029_LLIF_BCI_TST_1_TEST_BYPASS_WIDTH  1

/*=========BSP_TWL3029_LLIF_BCI_TST_2=============
 */
#define BSP_TWL3029_LLIF_BCI_TST_2_DACV_SEL_2_OFFSET 5 
#define BSP_TWL3029_LLIF_BCI_TST_2_DACV_SEL_2_WIDTH  3 

#define BSP_TWL3029_LLIF_BCI_TST_2_ITOVEN_OFFSET    4 
#define BSP_TWL3029_LLIF_BCI_TST_2_ITOVEN_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_TST_2_BIASEN_OFFSET    3
#define BSP_TWL3029_LLIF_BCI_TST_2_BIASEN_WIDTH     1 

#define BSP_TWL3029_LLIF_BCI_TST_2_TESTDACEN_OFFSET 2  
#define BSP_TWL3029_LLIF_BCI_TST_2_TESTDACEN_WIDTH  1 

#define BSP_TWL3029_LLIF_BCI_TST_2_VDACnICHG_OFFSET 1  
#define BSP_TWL3029_LLIF_BCI_TST_2_VDACnICHG_WIDTH  1 

#define BSP_TWL3029_LLIF_BCI_TST_2_TESTEN_OFFSET    0
#define BSP_TWL3029_LLIF_BCI_TST_2_TESTEN_WIDTH     1


/*=========BSP_TWL3029_LLIF_BCI_TST_3=============
 */
#define BSP_TWL3029_LLIF_BCI_TST_3_ACFORCE0_OFFSET   7
#define BSP_TWL3029_LLIF_BCI_TST_3_ACFORCE0_WIDTH    1 

#define BSP_TWL3029_LLIF_BCI_TST_3_ACFORCE1_OFFSET   6
#define BSP_TWL3029_LLIF_BCI_TST_3_ACFORCE1_WIDTH    1 

#define BSP_TWL3029_LLIF_BCI_TST_3_AC2FORCE_OFFSET   5
#define BSP_TWL3029_LLIF_BCI_TST_3_AC2FORCE_WIDTH    1

#define BSP_TWL3029_LLIF_BCI_TST_3_ACSHIFTEN_OFFSET  4 
#define BSP_TWL3029_LLIF_BCI_TST_3_ACSHIFTEN_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_TST_3_USBSHIFTEN_OFFSET 3  
#define BSP_TWL3029_LLIF_BCI_TST_3_USBSHIFTEN_WIDTH  1 

#define BSP_TWL3029_LLIF_BCI_TST_3_USB2FORCE_OFFSET  2  
#define BSP_TWL3029_LLIF_BCI_TST_3_USB2FORCE_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_TST_3_DACEN_OFFSET      1 
#define BSP_TWL3029_LLIF_BCI_TST_3_DACEN_WIDTH       1 

/*=========BSP_TWL3029_LLIF_BCI_TST_4=============
 */
#define BSP_TWL3029_LLIF_BCI_TST_4_USBFORCE0_OFFSET  7 
#define BSP_TWL3029_LLIF_BCI_TST_4_USBFORCE0_WIDTH   1 

#define BSP_TWL3029_LLIF_BCI_TST_4_USBFORCE1_OFFSET  6  
#define BSP_TWL3029_LLIF_BCI_TST_4_USBFORCE1_WIDTH   1 

/*=========BSP_TWL3029_LLIF_SIM_SIMDEBOUNCING=============
 */
#define BSP_TWL3029_LLIF_SIM_SIMDEBOUNCING_SINS_DEB_3_OFFSET 4  
#define BSP_TWL3029_LLIF_SIM_SIMDEBOUNCING_SINS_DEB_3_WIDTH  4 

#define BSP_TWL3029_LLIF_SIM_SIMDEBOUNCING_SEXT_DEB_0_OFFSET 0 
#define BSP_TWL3029_LLIF_SIM_SIMDEBOUNCING_SEXT_DEB_0_WIDTH  4

/*=========BSP_TWL3029_LLIF_SIM_SIMDTCCTRL=============
 */
#define BSP_TWL3029_LLIF_SIM_SIMDTCCTRL_SW_FC_OFFSET      2
#define BSP_TWL3029_LLIF_SIM_SIMDTCCTRL_SW_FC_WIDTH       1 

#define BSP_TWL3029_LLIF_SIM_SIMDTCCTRL_CSIMDTCPUZ_OFFSET 1  
#define BSP_TWL3029_LLIF_SIM_SIMDTCCTRL_CSIMDTCPUZ_WIDTH  1 

#define BSP_TWL3029_LLIF_SIM_SIMDTCCTRL_CSIMDTCPD_OFFSET  0 
#define BSP_TWL3029_LLIF_SIM_SIMDTCCTRL_CSIMDTCPD_WIDTH   1


#endif
