/*=============================================================================
 *    Copyright 2004 Texas Instruments Inc. All rights reserved.
 */
#ifndef BSP_TWL3029_AUD_LLIF_HEADER
#define BSP_TWL3029_AUD_LLIF_HEADER

#include "bspUtil_BitUtil.h"

#if (ANLG_PG == 1)
#include "pg1x/bspTwl3029_Aud_Llif_pg1x.h"
#elif (ANLG_PG == 2)
#include "pg2x/bspTwl3029_Aud_Llif_pg2x.h"
#endif 
/*=============================================================================
 * Component Description:
 *    Provides accessor and manipulator macros for TWL3029 aka Triton
 *    register fields for BARPWR module. Fields offsets and widths are encoded in contants
 *    that are to be fed into simple macros. This common approach should
 *    help to prevent masking errors.
 *
 *    the BARINT registers consist of: 
 *     -  RTC registers
 *     -  power master registers registers
 *     -  power slave registers
 */

/*=========BSP_TWL3029_LLIF_AUDIO_TOGB=========
 */

  
#define BSP_TWL3029_LLIF_AUDIO_TOGB_RSVD_OFFSET  6
#define BSP_TWL3029_LLIF_AUDIO_TOGB_RSVD_WIDTH   2
  
#define BSP_TWL3029_LLIF_AUDIO_TOGB_STS_OFFSET   5
#define BSP_TWL3029_LLIF_AUDIO_TOGB_STS_WIDTH    1
  
#define BSP_TWL3029_LLIF_AUDIO_TOGB_STR_OFFSET   4
#define BSP_TWL3029_LLIF_AUDIO_TOGB_STR_WIDTH    1
  
#define BSP_TWL3029_LLIF_AUDIO_TOGB_VDLS_OFFSET  3
#define BSP_TWL3029_LLIF_AUDIO_TOGB_VDLS_WIDTH   1
  
#define BSP_TWL3029_LLIF_AUDIO_TOGB_VDLR_OFFSET  2
#define BSP_TWL3029_LLIF_AUDIO_TOGB_VDLR_WIDTH   1  
  
#define BSP_TWL3029_LLIF_AUDIO_TOGB_VULS_OFFSET  1
#define BSP_TWL3029_LLIF_AUDIO_TOGB_VULS_WIDTH   1
  
#define BSP_TWL3029_LLIF_AUDIO_TOGB_VULR_OFFSET  0
#define BSP_TWL3029_LLIF_AUDIO_TOGB_VULR_WIDTH   1  

/*====BSP_TWL3029_LLIF_AUDIO_PWRONSTATUS========
 */
//#define BSP_TWL3029_LLIF_AUDIO_PWRONSTATUS_RSVD_OFFSET  3 
//#define BSP_TWL3029_LLIF_AUDIO_PWRONSTATUS_RSVD_WIDTH   5

#define BSP_TWL3029_LLIF_AUDIO_PWRONSTATUS_STON_OFFSET  2 
#define BSP_TWL3029_LLIF_AUDIO_PWRONSTATUS_STON_WIDTH   1

#define BSP_TWL3029_LLIF_AUDIO_PWRONSTATUS_VDLON_OFFSET 1
#define BSP_TWL3029_LLIF_AUDIO_PWRONSTATUS_VDLON_WIDTH  1
 
#define BSP_TWL3029_LLIF_AUDIO_PWRONSTATUS_VULON_OFFSET 0 
#define BSP_TWL3029_LLIF_AUDIO_PWRONSTATUS_VULON_WIDTH  1


/*=========BSP_TWL3029_LLIF_AUDIO_CTRL1=========
 */
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VALOOP_OFFSET    7
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VALOOP_WIDTH     1

#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VULHPFBYP_OFFSET  6
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VULHPFBYP_WIDTH  1 

#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VDLFBYP_OFFSET   5
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VDLFBYP_WIDTH    1

#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VSPCK_OFFSET     4
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VSPCK_WIDTH      1

#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VSYNC_OFFSET     3
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VSYNC_WIDTH      1

#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VCLKMODE_OFFSET  2
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_VCLKMODE_WIDTH   1
  
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_BOOST_OFFSET     0
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_BOOST_WIDTH      1 
 
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_WBA_OFFSET 0 
#define BSP_TWL3029_LLIF_AUDIO_CTRL1_WBA_WIDTH  1

/*=========BSP_TWL3029_LLIF_AUDIO_CTRL2=========
 */

#define BSP_TWL3029_LLIF_AUDIO_CTRL2_VMIDSEL_OFFSET     7
#define BSP_TWL3029_LLIF_AUDIO_CTRL2_VMIDSEL_WIDTH      1

#define BSP_TWL3029_LLIF_AUDIO_CTRL2_VMIDRBYP_OFFSET    6
#define BSP_TWL3029_LLIF_AUDIO_CTRL2_VMIDRBYP_WIDTH     1

#define BSP_TWL3029_LLIF_AUDIO_CTRL2_MICBIASLVL_OFFSET  5
#define BSP_TWL3029_LLIF_AUDIO_CTRL2_MICBIASLVL_WIDTH   1

#define BSP_TWL3029_LLIF_AUDIO_CTRL2_MICBIASSEL_OFFSET  4
#define BSP_TWL3029_LLIF_AUDIO_CTRL2_MICBIASSEL_WIDTH   1   
   
#define BSP_TWL3029_LLIF_AUDIO_CTRL2_FMG_OFFSET         0
#define BSP_TWL3029_LLIF_AUDIO_CTRL2_FMG_WIDTH          4  

/*=========BSP_TWL3029_LLIF_AUDIO_CTRL3=========
 */
 
#define BSP_TWL3029_LLIF_AUDIO_CTRL3_SPKDIGON_OFFSET 7  
#define BSP_TWL3029_LLIF_AUDIO_CTRL3_SPKDIGON_WIDTH  1 

#define BSP_TWL3029_LLIF_AUDIO_CTRL3_SPKG_OFFSET    4
#define BSP_TWL3029_LLIF_AUDIO_CTRL3_SPKG_WIDTH     3    

#define BSP_TWL3029_LLIF_AUDIO_CTRL3_INMODE_OFFSET  0 
#define BSP_TWL3029_LLIF_AUDIO_CTRL3_INMODE_WIDTH   4
  

/*=========BSP_TWL3029_LLIF_AUDIO_CTRL4=========
 */
 
#define BSP_TWL3029_LLIF_AUDIO_CTRL4_VMEMO_OFFSET     7
#define BSP_TWL3029_LLIF_AUDIO_CTRL4_VMEMO_WIDTH      1
 
#define BSP_TWL3029_LLIF_AUDIO_CTRL4_I2SON_OFFSET     6
#define BSP_TWL3029_LLIF_AUDIO_CTRL4_I2SON_WIDTH      1

#define BSP_TWL3029_LLIF_AUDIO_CTRL4_MONOL_OFFSET     5
#define BSP_TWL3029_LLIF_AUDIO_CTRL4_MONOL_WIDTH      1

#define BSP_TWL3029_LLIF_AUDIO_CTRL4_MONOR_OFFSET     4
#define BSP_TWL3029_LLIF_AUDIO_CTRL4_MONOR_WIDTH      1

#define BSP_TWL3029_LLIF_AUDIO_CTRL4_AUGA_OFFSET      3
#define BSP_TWL3029_LLIF_AUDIO_CTRL4_AUGA_WIDTH       1

#define BSP_TWL3029_LLIF_AUDIO_CTRL4_SFTVOL_OFFSET    1
#define BSP_TWL3029_LLIF_AUDIO_CTRL4_SFTVOL_WIDTH     2

#define BSP_TWL3029_LLIF_AUDIO_CTRL4_BYPSFTVOL_OFFSET 0 
#define BSP_TWL3029_LLIF_AUDIO_CTRL4_BYPSFTVOL_WIDTH  1

/*=========BSP_TWL3029_LLIF_AUDIO_CTRL5=========
 */
 

//#define BSP_TWL3029_LLIF_AUDIO_CTRL5_RSVD_OFFSET    6
//#define BSP_TWL3029_LLIF_AUDIO_CTRL5_RSVD_WIDTH     2

#define BSP_TWL3029_LLIF_AUDIO_CTRL5_EARG_OFFSET    5
#define BSP_TWL3029_LLIF_AUDIO_CTRL5_EARG_WIDTH     1

#define BSP_TWL3029_LLIF_AUDIO_CTRL5_HOOKEN_OFFSET  4
#define BSP_TWL3029_LLIF_AUDIO_CTRL5_HOOKEN_WIDTH   1

#define BSP_TWL3029_LLIF_AUDIO_CTRL5_SRW_OFFSET    0 
#define BSP_TWL3029_LLIF_AUDIO_CTRL5_SRW_WIDTH     4 

/*=========BSP_TWL3029_LLIF_AUDIO_CTRL6=========
 */
#define BSP_TWL3029_LLIF_AUDIO_CTRL6_RSVD_OFFSET          5
#define BSP_TWL3029_LLIF_AUDIO_CTRL6_RSVD_WIDTH           3
  
#define BSP_TWL3029_LLIF_AUDIO_CTRL6_STPLLSPEEDUP_OFFSET  4
#define BSP_TWL3029_LLIF_AUDIO_CTRL6_STPLLSPEEDUP_WIDTH   1

#define BSP_TWL3029_LLIF_AUDIO_CTRL6_STPLLPCHGZ_OFFSET    3
#define BSP_TWL3029_LLIF_AUDIO_CTRL6_STPLLPCHGZ_WIDTH     1

#define BSP_TWL3029_LLIF_AUDIO_CTRL6_VPLLPCHGZ_OFFSET     2
#define BSP_TWL3029_LLIF_AUDIO_CTRL6_VPLLPCHGZ_WIDTH      1

#define BSP_TWL3029_LLIF_AUDIO_CTRL6_STPLLON_OFFSET       1
#define BSP_TWL3029_LLIF_AUDIO_CTRL6_STPLLON_WIDTH        1

#define BSP_TWL3029_LLIF_AUDIO_CTRL6_VPLLON_OFFSET        0
#define BSP_TWL3029_LLIF_AUDIO_CTRL6_VPLLON_WIDTH         1

/*=========BSP_TWL3029_LLIF_AUDIO_POPMAN=========
 */
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_CARKITDHG_OFFSET 7  
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_CARKITDHG_WIDTH  1
 
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_CARKITCHG_OFFSET 6 
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_CARKITCHG_WIDTH  1
 
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_AUXODHG_OFFSET   5
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_AUXODHG_WIDTH    1

#define BSP_TWL3029_LLIF_AUDIO_POPMAN_AUXOCHG_OFFSET   4
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_AUXOCHG_WIDTH    1
 
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_EARDHG_OFFSET    3
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_EARDHG_WIDTH     1
 
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_EARCHG_OFFSET    2
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_EARCHG_WIDTH     1
 
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_HSODHG_OFFSET    1
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_HSODHG_WIDTH     1
 
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_HSOCHG_OFFSET    0
#define BSP_TWL3029_LLIF_AUDIO_POPMAN_HSOCHG_WIDTH     1

/*=========BSP_TWL3029_LLIF_AUDIO_POPAUTO=========
 */

#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_RSVD_OFFSET  4
#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_RSVD_WIDTH   4
  
#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_CARKITAUTO_OFFSET 3 
#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_CARKITAUTO_WIDTH  1
  
#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_AUXOAUTO_OFFSET  2
#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_AUXOAUTO_WIDTH   1
  
#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_EARAUTO_OFFSET   1
#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_EARAUTO_WIDTH    1     
  
#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_HSOAUTO_OFFSET   0
#define BSP_TWL3029_LLIF_AUDIO_POPAUTO_HSOAUTO_WIDTH    1

/*=========BSP_TWL3029_LLIF_AUDIO_SIDETONE=========
 */

#define BSP_TWL3029_LLIF_AUDIO_SIDETONE_RSVD_OFFSET  4
#define BSP_TWL3029_LLIF_AUDIO_SIDETONE_RSVD_WIDTH   4

#define BSP_TWL3029_LLIF_AUDIO_SIDETONE_VST_OFFSET   0
#define BSP_TWL3029_LLIF_AUDIO_SIDETONE_VST_WIDTH    4  

/*=========BSP_TWL3029_LLIF_AUDIO_VULGAIN=========
 */
 
#define BSP_TWL3029_LLIF_AUDIO_VULGAIN_RSVD_OFFSET   6
#define BSP_TWL3029_LLIF_AUDIO_VULGAIN_RSVD_WIDTH    2

#define BSP_TWL3029_LLIF_AUDIO_VULGAIN_DXEN_OFFSET   5
#define BSP_TWL3029_LLIF_AUDIO_VULGAIN_DXEN_WIDTH    1

#define BSP_TWL3029_LLIF_AUDIO_VULGAIN_VULPG_OFFSET  0
#define BSP_TWL3029_LLIF_AUDIO_VULGAIN_VULPG_WIDTH   5

/*=========BSP_TWL3029_LLIF_AUDIO_VDLGAIN=========
 */
 
#define BSP_TWL3029_LLIF_AUDIO_VDLGAIN_RSVD_OFFSET    7
#define BSP_TWL3029_LLIF_AUDIO_VDLGAIN_RSVD_WIDTH     1

#define BSP_TWL3029_LLIF_AUDIO_VDLGAIN_VOLCTL_OFFSET  4
#define BSP_TWL3029_LLIF_AUDIO_VDLGAIN_VOLCTL_WIDTH   3 
 
#define BSP_TWL3029_LLIF_AUDIO_VDLGAIN_VDLPG_OFFSET  0 
#define BSP_TWL3029_LLIF_AUDIO_VDLGAIN_VDLPG_WIDTH   4 

/*=========BSP_TWL3029_LLIF_AUDIO_OUTEN1=========
 */
#define BSP_TWL3029_LLIF_AUDIO_OUTEN1_RSVD_OFFSET    7 
#define BSP_TWL3029_LLIF_AUDIO_OUTEN1_RSVD_WIDTH     1

#define BSP_TWL3029_LLIF_AUDIO_OUTEN1_HSOL_OFFSET    4
#define BSP_TWL3029_LLIF_AUDIO_OUTEN1_HSOL_WIDTH     3

#define BSP_TWL3029_LLIF_AUDIO_OUTEN1_HSOR_OFFSET    1
#define BSP_TWL3029_LLIF_AUDIO_OUTEN1_HSOR_WIDTH     3  

#define BSP_TWL3029_LLIF_AUDIO_OUTEN1_HSOVMID_OFFSET 0
#define BSP_TWL3029_LLIF_AUDIO_OUTEN1_HSOVMID_WIDTH  1

/*=========BSP_TWL3029_LLIF_AUDIO_OUTEN2=========
 */  
#define BSP_TWL3029_LLIF_AUDIO_OUTEN2_RSVD_OFFSET  6 
#define BSP_TWL3029_LLIF_AUDIO_OUTEN2_RSVD_WIDTH   2
  
#define BSP_TWL3029_LLIF_AUDIO_OUTEN2_CARKIT_OFFSET 4 
#define BSP_TWL3029_LLIF_AUDIO_OUTEN2_CARKIT_WIDTH  2 

#define BSP_TWL3029_LLIF_AUDIO_OUTEN2_AUXO_OFFSET  2
#define BSP_TWL3029_LLIF_AUDIO_OUTEN2_AUXO_WIDTH   2

#define BSP_TWL3029_LLIF_AUDIO_OUTEN2_EAR_OFFSET  0
#define BSP_TWL3029_LLIF_AUDIO_OUTEN2_EAR_WIDTH   2

/*=========BSP_TWL3029_LLIF_AUDIO_OUTEN3=========
 */  
#define BSP_TWL3029_LLIF_AUDIO_OUTEN3_RSVD_OFFSET  3
#define BSP_TWL3029_LLIF_AUDIO_OUTEN3_RSVD_WIDTH   5

#define BSP_TWL3029_LLIF_AUDIO_OUTEN3_SPK_OFFSET   0 
#define BSP_TWL3029_LLIF_AUDIO_OUTEN3_SPK_WIDTH    3

/*=========BSP_TWL3029_LLIF_AUDIO_AUDLGAIN=========
 */  
#define BSP_TWL3029_LLIF_AUDIO_AUDLGAIN_RSVD_OFFSET  3 
#define BSP_TWL3029_LLIF_AUDIO_AUDLGAIN_RSVD_WIDTH   5

#define BSP_TWL3029_LLIF_AUDIO_AUDLGAIN_AULGA_OFFSET 0
#define BSP_TWL3029_LLIF_AUDIO_AUDLGAIN_AULGA_WIDTH  5 



/*=========BSP_TWL3029_LLIF_AUDIO_AUDLGAIN=========
 */  
#define BSP_TWL3029_LLIF_AUDIO_AUDRGAIN_RSVD_OFFSET  5 
#define BSP_TWL3029_LLIF_AUDIO_AUDRGAIN_RSVD_WIDTH   3

#define BSP_TWL3029_LLIF_AUDIO_AUDRGAIN_AURGA_OFFSET 0
#define BSP_TWL3029_LLIF_AUDIO_AUDRGAIN_AURGA_WIDTH  5  

/*=========BSP_TWL3029_LLIF_AUDIO_VPLLTEST=========
 */  
#define BSP_TWL3029_LLIF_AUDIO_VPLLTEST_RSVD_2_OFFSET  6 
#define BSP_TWL3029_LLIF_AUDIO_VPLLTEST_RSVD_2_WIDTH   2
  
#define BSP_TWL3029_LLIF_AUDIO_VPLLTEST_TESTVTUNE_OFFSET 5 
#define BSP_TWL3029_LLIF_AUDIO_VPLLTEST_TESTVTUNE_WIDTH  1 

#define BSP_TWL3029_LLIF_AUDIO_VPLLTEST_RSVD_1_OFFSET  0
#define BSP_TWL3029_LLIF_AUDIO_VPLLTEST_RSVD_1_WIDTH   4
 

/*=========BSP_TWL3029_LLIF_AUDIO_STPLLTEST=========
 */   
#define BSP_TWL3029_LLIF_AUDIO_STPLLTEST_RSVD_OFFSET 0 
#define BSP_TWL3029_LLIF_AUDIO_STPLLTEST_RSVD_WIDTH  8

/*=========BSP_TWL3029_LLIF_AUDIO_VFTEST=========
 */
//#define BSP_TWL3029_LLIF_AUDIO_VFTEST_RSVD_OFFSET  0
//#define BSP_TWL3029_LLIF_AUDIO_VFTEST_RSVD_WIDTH   8

/*=========BSP_TWL3029_LLIF_AUDIO_AUDFTEST1=========
 */ 

#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST1_AUMLSW_OFFSET   6
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST1_AUMLSW_WIDTH    2

#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST1_AUMRSW_OFFSET   4
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST1_AUMRSW_WIDTH    2
 
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST1_AUHPLDG_OFFSET  2
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST1_AUHPLDG_WIDTH   2
 
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST1_AUHPRDG_OFFSET  0
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST1_AUHPRDG_WIDTH   2

/*=========BSP_TWL3029_LLIF_AUDIO_AUDFTEST2=========
 */ 
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST2_RSVD_OFFSET    4
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST2_RSVD_WIDTH     4
  
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST2_FIFOMUX_OFFSET 4
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST2_FIFOMUX_WIDTH  1 

#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST2_DMODMUX_OFFSET 2 
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST2_DMODMUX_WIDTH  1  
  
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST2_EFFECT_OFFSET  0 
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST2_EFFECT_WIDTH   2

/*=========BSP_TWL3029_LLIF_AUDIO_AUDFTEST3=========
 */ 
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_RSVD_OFFSET    7
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_RSVD_WIDTH     1

#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_OFFSTL_OFFSET  6
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_OFFSTL_WIDTH   1

#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_OFFSTR_OFFSET  5
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_OFFSTR_WIDTH   1

#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_SOFTVOL_OFFSET  2
#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_SOFTVOL_WIDTH   3

//#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_DFORMAT_OFFSET  0
//#define BSP_TWL3029_LLIF_AUDIO_AUDFTEST3_DFORMAT_WIDTH   2

/*=========BSP_TWL3029_LLIF_AUDIO_HFTEST1=========
 */ 
#define BSP_TWL3029_LLIF_AUDIO_HFTEST1_RSVD_OFFSET         3
#define BSP_TWL3029_LLIF_AUDIO_HFTEST1_RSVD_WIDTH          5

#define BSP_TWL3029_LLIF_AUDIO_HFTEST1_SPKPMOSALLON_OFFSET 2 
#define BSP_TWL3029_LLIF_AUDIO_HFTEST1_SPKPMOSALLON_WIDTH  0 

//#define BSP_TWL3029_LLIF_AUDIO_HFTEST1_SPKCLKDIV2_OFFSET   1
//#define BSP_TWL3029_LLIF_AUDIO_HFTEST1_SPKCLKDIV2_WIDTH    1

#define BSP_TWL3029_LLIF_AUDIO_HFTEST1_SPKALLZB_OFFSET     0 
#define BSP_TWL3029_LLIF_AUDIO_HFTEST1_SPKALLZB_WIDTH      1

/*=========BSP_TWL3029_LLIF_AUDIO_HFTEST2=========
 */ 
#define BSP_TWL3029_LLIF_AUDIO_HFTEST2_SPKB3L_OFFSET  0 
#define BSP_TWL3029_LLIF_AUDIO_HFTEST2_SPKB3L_WIDTH   8

/*=========BSP_TWL3029_LLIF_AUDIO_POPTEST1=========
 */ 
#define BSP_TWL3029_LLIF_AUDIO_POPTEST1_TBD_OFFSET   0
#define BSP_TWL3029_LLIF_AUDIO_POPTEST1_TBD_WIDTH    8

/*=========BSP_TWL3029_LLIF_AUDIO_POPTEST2=========
 */ 
#define BSP_TWL3029_LLIF_AUDIO_POPTEST2_TBD_OFFSET  0 
#define BSP_TWL3029_LLIF_AUDIO_POPTEST2_TBD_WIDTH   8

#endif
