/****************************************************************************/
/*                                                                          */
/*  File Name:  audio_api.h                                                 */
/*                                                                          */
/*  Purpose:  This file contains data structures and functions prototypes   */
/*            used to send events to the AUDIO SWE.                         */
/*                                                                          */
/*  Version   0.1                                                           */
/*                                                                          */
/*  Date         Modification                                               */
/*  ------------------------------------                                    */
/*  18 May 2001  Create                                                     */
/*                                                                          */
/*  Author       Francois Mazard - Stephanie Gerthoux                       */
/*                                                                          */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved*/
/****************************************************************************/



  #ifndef __AUDIO_API_H_
    #define __AUDIO_API_H_


/*********to_be_removed***********/
#ifndef AS_RFS_API
#define AS_RFS_API 1
#endif
/*********to_be_removed***********/


	#include "rv/rv_defined_swe.h"

	#ifndef _WINDOWS
      #include "chipset.cfg"
      #include "l1sw.cfg"
      #include "l1_confg.h"
    #endif


#if (ANLG_FAM == 11)
    #include "types.h"
    #include "bspTwl3029_I2c.h"
    #include "bspTwl3029_Audio.h"
#endif

    #ifdef __cplusplus
      extern "C"
        {
    #endif

#if (AS_RFS_API == 1)
  #include "rfs/rfs_api.h"
#endif

    #define AUDIO_EVENTS_MASK                       (0x3000)
    #define AUDIO_EVENT_EXTERN                      (0x0C00)

    /* Immediat return */
    typedef INT16 T_AUDIO_RET;

    /* possible values */
    #define AUDIO_OK                     (0)
    #define AUDIO_ERROR                  (-1)
    #define AUDIO_MODE_ERROR             (-2)
    /* Bad acquisition of the word. The word is too long or too short */
    #define AUDIO_BAD_ACQUISITION (-3)
    /* The DSP task to acquire the word takes to much time */
    #define AUDIO_TIME_OUT        (-4)
    /* Bad update of the model. The model from the database is too different */
    /* than the model built during the acquisition. */
    #define AUDIO_BAD_UPDATE      (-5)
    /* This word is out of vocabulary or the best words are too close  */
    #define AUDIO_BAD_RECOGNITION (-6)
    /* A word generated by the CTO algorithm is the best word. */
    #define AUDIO_CTO_WORD        (-7)
    /* The best word isn't the word to update. */
    #define AUDIO_CHECK_ERROR     (-8)
    #define AUDIO_NOT_ENOUGH_OSCILLATOR  (-9)
    /* MP3 L1 & L2 Not Supported Errror Handling */
    #define AUDIO_MP3_NOT_SUPP (-10)
	#define AUDIO_AAC_NOT_STOP (-11)

  /******************************* AUDIO DRIVER *****************************/
    #define AUDIO_VM_AMR_RECORD_SESSION_ID    (10)
    #define AUDIO_VM_AMR_PLAY_SESSION_ID      (11)
    #define AUDIO_EXT_MIDI_SESSION_ID         (12)
    #define AUDIO_MP3_SESSION_ID              (13)
    #define AUDIO_AAC_SESSION_ID              (14)

  /******************************* KEY BEEP REGISTRATION *****************************/
    /* Definition of no_beep */
    #define NO_BEEP     (0)

    /* Parameters */
    typedef struct
    {
      UINT16  frequency_beep[2]; /* Frequency of the 2 beeps */
      INT8    amplitude_beep[2];  /* Amplitude of the 2 beeps */
      UINT16  duration;
    } T_AUDIO_KEYBEEP_PARAMETER;

    /* Prototype */
    T_AUDIO_RET audio_keybeep_start (T_AUDIO_KEYBEEP_PARAMETER parameter,
                          T_RV_RETURN return_path);

    /* Event return */
    #define AUDIO_KEYBEEP_STATUS_MSG      (0x0001 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
    typedef struct
    {
      T_RV_HDR  os_hdr;
      INT8     status;
    } T_AUDIO_KEYBEEP_STATUS;

    /* Prototype */
    T_AUDIO_RET audio_keybeep_stop (T_RV_RETURN return_path);

    /******************************* TONES REGISTRATION *****************************/

    /* Definition of no_tone and tone_infinite */
    #define NO_TONE          (0)
    #define TONE_INFINITE    (0xFFFF)

    /* Parameters */
    typedef struct
    {
      UINT16  start_tone;        /* start date of the tone */
      UINT16  stop_tone;         /* stop date of the tone */
      UINT16  frequency_tone;    /* frequency of the tone */
      INT8    amplitude_tone;    /* amplitude of the tone */
    } T_AUDIO_TONE_DESC;

    typedef struct
    {
      T_AUDIO_TONE_DESC  tones[3];           /* Description of the 3 tones */
      UINT16              frame_duration;     /* Duration of the tones frame */
      UINT16              sequence_duration;  /* Duration of the sequence */
      UINT16              period_duration;    /* Duration of the period */
      UINT16              repetition;         /* number of period */
    } T_AUDIO_TONES_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_tones_start (T_AUDIO_TONES_PARAMETER* p_parameter,
                            T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_TONES_STATUS_MSG              (0x0002 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_TONES_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_tones_stop (T_RV_RETURN return_path);

      /******************************* AUDIO DRIVER REGISTRATION ************************/

      T_AUDIO_RET audio_driver_start_session(UINT8 channel_id, T_RV_RETURN notification_return_path);

      T_AUDIO_RET audio_driver_stop_session(UINT8 channel_id);

      T_AUDIO_RET audio_driver_free_session(UINT8 channel_id, T_RV_RETURN return_path);
      T_AUDIO_RET audio_driver_pause_session(UINT8 channel_id, T_RV_RETURN return_path);
      T_AUDIO_RET audio_driver_resume_session(UINT8 channel_id, T_RV_RETURN return_path);
      T_AUDIO_RET audio_driver_info_session(UINT8 channel_id, T_RV_RETURN return_path);
      #if (L1_AAC == 1)
        T_AUDIO_RET audio_driver_info_aac_session(UINT8 channel_id, T_RV_RETURN return_path);
      #endif
      T_AUDIO_RET audio_driver_restart_session(UINT8 channel_id, T_RV_RETURN return_path);

      T_AUDIO_RET audio_driver_get_play_buffer(UINT8 channel_id, UINT8 **pp_buffer);
      T_AUDIO_RET audio_driver_ext_midi_get_play_buffer(UINT8 channel_id, UINT8 **pp_buffer);
      T_AUDIO_RET audio_driver_play_buffer(UINT8 channel_id, UINT8 *p_buffer);
      T_AUDIO_RET audio_driver_play_midi_buffer(UINT8 channel_id, UINT8 *p_buffer);
      T_AUDIO_RET audio_driver_flush_buffer(UINT8 channel_id, UINT8 *p_buffer);

      #define AUDIO_DRIVER_INIT_STATUS_MSG          (0x0003 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR                      os_hdr;
        INT8                          status;
        UINT8                         channel_id;
        UINT8                         session_id;
      } T_AUDIO_DRIVER_INIT_STATUS;

      #define AUDIO_DRIVER_NOTIFICATION_MSG         (0x0004 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR header;
        UINT8    channel_id;
        UINT16   *p_buffer;
      }
      T_AUDIO_DRIVER_NOTIFICATION;

      #define AUDIO_DRIVER_LAST_NOTIFICATION_MSG    (0x0005 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR header;
        UINT8    channel_id;
        UINT16   *p_buffer;
        UINT32   recorded_size;
      }
      T_AUDIO_DRIVER_LAST_NOTIFICATION;

      #define AUDIO_DRIVER_STATUS_MSG               (0x0006 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR                      os_hdr;
        INT8                          status;
        UINT8                         status_type;
        UINT8                         channel_id;
      } T_AUDIO_DRIVER_STATUS;


      #define AUDIO_START_STATUS         (1)
      #define AUDIO_STOP_STATUS          (2)
      #define AUDIO_FREE_STATUS          (3)
      #define AUDIO_PAUSE_STATUS         (4)
      #define AUDIO_RESUME_STATUS        (5)
      #define AUDIO_INFO_STATUS          (6)
      #define AUDIO_AAC_INFO_STATUS      (7)
      #define AUDIO_RESTART_STATUS       (8)

      typedef struct
      {
        UINT16                 buffer_size;
        UINT8                  nb_buffer;
      } T_AUDIO_DRIVER_PARAMETER;

      /******************************* MELODY AND VOICE MEMO REGISTRATION *****************************/
      /* Definition of the maximum size of the path name */
      #define AUDIO_PATH_NAME_MAX_SIZE      (80)     /*      (20)   */
      /* Definition of the maximum number of instruments */
      #define AUDIO_MELODY_E2_MAX_NUMBER_OF_INSTRUMENT (128)

      /******************************* MELODY REGISTRATION *****************************/

      /* Definition of loopback melody mode */
      #define AUDIO_MELODY_NO_LOOPBACK       (0)
      #define AUDIO_MELODY_LOOPBACK          (1)

      /* Definition ofthe mode of melody */
      #define AUDIO_MELODY_GAME_MODE        (0)
      #define AUDIO_MELODY_NORMAL_MODE      (1)

      /******** Melody E1 ********/

      /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR melody_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#else
		char melody_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#endif
		BOOLEAN loopback;                     /* the melody is played indefinitely */
        BOOLEAN melody_mode;                  /* mode of the melody */
      } T_AUDIO_MELODY_E1_PARAMETER;

      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR melody_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#else
		char melody_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#endif
      }
      T_AUDIO_MELODY_E1_STOP_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_melody_E1_start (T_AUDIO_MELODY_E1_PARAMETER *parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_MELODY_E1_STATUS_MSG              (0x0007 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_MELODY_E1_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_melody_E1_stop (T_AUDIO_MELODY_E1_STOP_PARAMETER *parameter,
                                        T_RV_RETURN return_path);

      /******** Melody E2 ********/

      /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR    melody_E2_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#else
		char    melody_E2_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#endif
        BOOLEAN E2_loopback;                              /* the melody is played indefinitely */
        BOOLEAN melody_E2_mode;                           /* mode of the melody (Game/Normal)*/
      } T_AUDIO_MELODY_E2_PARAMETER;

      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR melody_E2_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#else
		char melody_E2_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#endif
      } T_AUDIO_MELODY_E2_STOP_PARAMETER;

      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR melody_E2_file_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#else
		char melody_E2_file_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#endif
      } T_AUDIO_MELODY_E2_LOAD_FILE_INSTR_PARAMETER;


      /* Prototype */
      T_AUDIO_RET audio_melody_E2_load_file_instruments (
                 T_AUDIO_MELODY_E2_LOAD_FILE_INSTR_PARAMETER *p_parameter);

      T_AUDIO_RET audio_melody_E2_start (T_AUDIO_MELODY_E2_PARAMETER *p_parameter,
                                         T_RV_RETURN return_path);
      T_AUDIO_RET audio_melody_E2_stop (T_AUDIO_MELODY_E2_STOP_PARAMETER *parameter,
                                        T_RV_RETURN return_path);

      /* Event return */
      /* For melody_E2 */
      #define AUDIO_MELODY_E2_STATUS_MSG              (0x0008 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)

      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_MELODY_E2_STATUS;



      /******************************* VOICE MEMO REGISTRATION *****************************/

      /* ---------------------------- */
      /*     Voice memo PLAY          */
      /* ---------------------------- */

      /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#else
		char memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#endif
      } T_AUDIO_VM_PLAY_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_vm_play_start(T_AUDIO_VM_PLAY_PARAMETER *p_parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_VM_PLAY_STATUS_MSG              (0x0009 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR   os_hdr;
        INT8      status;
      } T_AUDIO_VM_PLAY_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_vm_play_stop (T_RV_RETURN return_path);

      /* ---------------------------- */
      /*     Voice memo RECORD        */
      /* ---------------------------- */

      /* Definition of compression mode */
      #define AUDIO_VM_NO_COMPRESSION_MODE       (0)
      #define AUDIO_VM_COMPRESSION_MODE          (1)

      /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#else
		char    memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#endif
        UINT32  memo_duration;    /* maximum duration of the voice memo */
        BOOL    compression_mode; /* activate the compression */
        UINT16  microphone_gain;  /* recording gain applies to microphone */
        UINT16  network_gain;     /* gain applies to the network voice */
      } T_AUDIO_VM_RECORD_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_vm_record_start( T_AUDIO_VM_RECORD_PARAMETER *p_record_parameter,
                                         T_AUDIO_TONES_PARAMETER *p_tones_parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_VM_RECORD_STATUS_MSG              (0x000A | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
        UINT16    recorded_duration;
      } T_AUDIO_VM_RECORD_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_vm_record_stop (T_RV_RETURN return_path);

      /******************************* VOICE MEMO DRIVER AMR REGISTRATION *****************************/

      /* ---------------------------- */
      /*     Voice memo AMR PLAY      */
      /* ---------------------------- */

      /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR    memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo AMR play */
#else
		char    memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo AMR play */
#endif
      } T_AUDIO_AMR_PLAY_FROM_FFS_PARAMETER;

      typedef T_AUDIO_AMR_PLAY_FROM_FFS_PARAMETER T_AUDIO_MMS_PLAY_FROM_FFS_PARAMETER;

      typedef struct
      {
        UINT8  *p_buffer; /* pointer on buffer to copy from */
		UINT16 buffer_size; /* size of buffer */
      } T_AUDIO_AMR_PLAY_FROM_RAM_PARAMETER;

      #define AUDIO_AMR_PLAY_FROM_MEM_STATUS_MSG            (0x000B | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_AMR_PLAY_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_amr_play_from_ffs_start (T_AUDIO_AMR_PLAY_FROM_FFS_PARAMETER *p_record_parameter,
                                                 T_RV_RETURN return_path);
      T_AUDIO_RET audio_amr_play_from_ffs_stop  (void);

      T_AUDIO_RET audio_amr_play_from_ffs_pause (void);
      
      T_AUDIO_RET audio_amr_play_from_ffs_resume (void);

      T_AUDIO_RET audio_mms_play_from_ffs_start (T_AUDIO_MMS_PLAY_FROM_FFS_PARAMETER *p_record_parameter,
                                                 T_RV_RETURN return_path);
      T_AUDIO_RET audio_mms_play_from_ffs_stop  (void);

      T_AUDIO_RET audio_mms_play_from_ffs_pause (void);

      T_AUDIO_RET audio_mms_play_from_ffs_resume (void);
      
      T_AUDIO_RET audio_amr_play_from_ram_start (T_AUDIO_AMR_PLAY_FROM_RAM_PARAMETER *p_record_parameter,
                                                 T_RV_RETURN return_path);
      T_AUDIO_RET audio_amr_play_from_ram_stop  (void);

      T_AUDIO_RET audio_amr_play_from_ram_pause (void);

      T_AUDIO_RET audio_amr_play_from_ram_resume (void);

      T_AUDIO_RET audio_driver_init_vm_amr_play_session(T_AUDIO_DRIVER_PARAMETER *p_driver_parameter, T_RV_RETURN return_path);

      /* ---------------------------- */
      /*     Voice memo AMR RECORD    */
      /* ---------------------------- */

      /* Definition of compression mode */
      #define AUDIO_AMR_NO_COMPRESSION_MODE       (0)
      #define AUDIO_AMR_COMPRESSION_MODE          (1)

      /* Definition of AMR vocoders */
      #define AUDIO_AMR_VOCODER_4_75              (0)
      #define AUDIO_AMR_VOCODER_5_15              (1)
      #define AUDIO_AMR_VOCODER_5_90              (2)
      #define AUDIO_AMR_VOCODER_6_70              (3)
      #define AUDIO_AMR_VOCODER_7_40              (4)
      #define AUDIO_AMR_VOCODER_7_95              (5)
      #define AUDIO_AMR_VOCODER_10_2              (6)
      #define AUDIO_AMR_VOCODER_12_2              (7)

      /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR    memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo AMR play */
#else
		char    memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo AMR play */
#endif
        UINT32  memo_duration;    /* maximum duration of the voice memo */
        BOOL    compression_mode; /* activate the compression */
        UINT16  microphone_gain;  /* recording gain applies to microphone */
        UINT8   amr_vocoder;      /* AMR codec */
      } T_AUDIO_AMR_RECORD_TO_FFS_PARAMETER;

      typedef T_AUDIO_AMR_RECORD_TO_FFS_PARAMETER T_AUDIO_MMS_RECORD_TO_FFS_PARAMETER;

      typedef struct
      {
        UINT8   *p_buffer; /* pointer on buffer to copy to, length must be > memo_duration */
        UINT32  memo_duration;    /* maximum duration of the voice memo */
        BOOL    compression_mode; /* activate the compression */
        UINT16  microphone_gain;  /* recording gain applies to microphone */
        UINT8   amr_vocoder;      /* AMR codec */
      } T_AUDIO_AMR_RECORD_TO_RAM_PARAMETER;

      /* Parameters */
      typedef struct
      {
        UINT32  memo_duration;    /* maximum duration of the voice memo */
        BOOL    compression_mode; /* activate the compression */
        UINT16  microphone_gain;  /* recording gain applies to microphone */
        UINT8   amr_vocoder;      /* AMR codec */
      } T_AUDIO_DRIVER_VM_AMR_RECORD_PARAMETER;

      #define AUDIO_AMR_RECORD_TO_MEM_STATUS_MSG               (0x000C | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
        UINT32    recorded_duration;
      } T_AUDIO_AMR_RECORD_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_amr_record_to_ffs_start (T_AUDIO_AMR_RECORD_TO_FFS_PARAMETER *p_record_parameter,
                                                 T_RV_RETURN return_path);
      T_AUDIO_RET audio_amr_record_to_ffs_stop  (void);

      T_AUDIO_RET audio_mms_record_to_ffs_start (T_AUDIO_MMS_RECORD_TO_FFS_PARAMETER *p_record_parameter,
                                                 T_RV_RETURN return_path);
      T_AUDIO_RET audio_mms_record_to_ffs_stop  (void);

      T_AUDIO_RET audio_amr_record_to_ram_start (T_AUDIO_AMR_RECORD_TO_RAM_PARAMETER *p_record_parameter,
                                                 T_RV_RETURN return_path);
      T_AUDIO_RET audio_amr_record_to_ram_stop  (void);

      T_AUDIO_RET audio_driver_init_vm_amr_record_session(T_AUDIO_DRIVER_VM_AMR_RECORD_PARAMETER *p_record_parameter,
                                                          T_AUDIO_DRIVER_PARAMETER *p_driver_parameter,
                                                          T_RV_RETURN return_path);

      /******************************* AUDIO SPEECH RECOGNITION REGISTRATION ************************/

      /* ---------------------------- */
      /*     Start Enrollment         */
      /* ---------------------------- */

      /* Symbolic constant */
      #define AUDIO_SR_RECORD_SPEECH      (1)
      #define AUDIO_SR_NO_RECORD_SPEECH   (0)

      /* maximum number of vocabulary name */
      #define AUDIO_SR_MAX_VOCABULARY_NAME    (10)

      /* Parameters */
      typedef struct {
#if(AS_RFS_API == 1)
		T_WCHAR  enroll_name[AUDIO_PATH_NAME_MAX_SIZE];  /* name and path of the word to enroll */
#else
		char  enroll_name[AUDIO_PATH_NAME_MAX_SIZE];  /* name and path of the word to enroll */
#endif
        BOOL  record_speech;  /* speech sample must be recorded or not */
      }T_AUDIO_SR_ENROLL_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_sr_enroll_start (T_AUDIO_SR_ENROLL_PARAMETER *p_parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_SR_ENROLL_STATUS_MSG              (0x000D | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_SR_ENROLL_STATUS;

      /* ---------------------------- */
      /*     Stop Enrollment          */
      /* ---------------------------- */

      /* Symbolic constant */

      /* Parameters */

      /* Prototype */
      T_AUDIO_RET audio_sr_enroll_stop ( T_RV_RETURN return_path );

      /* Event return */

      /* ---------------------------- */
      /*     Start Update             */
      /* ---------------------------- */

      /* Symbolic constant */

      /* Parameters */
      typedef struct {
        char  update_name[AUDIO_PATH_NAME_MAX_SIZE];  /* name and path of the word to update */
        BOOL  record_speech;  /* speech sample must be recorded or not */
      }T_AUDIO_SR_UPDATE_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_sr_update_start (T_AUDIO_SR_UPDATE_PARAMETER *p_parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_SR_UPDATE_STATUS_MSG              (0x000E | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_SR_UPDATE_STATUS;

      /* ---------------------------- */
      /*     Stop Update              */
      /* ---------------------------- */

      /* Symbolic constant */

      /* Parameters */

      /* Prototype */
      T_AUDIO_RET audio_sr_update_stop ( T_RV_RETURN return_path );

      /* Event return */

      /* ---------------------------- */
      /*     Start Update             */
      /* ---------------------------- */

      /* Symbolic constant */

      /* Parameters */
      typedef struct {
        /* directory of the vocabulary database */
        char  database_directory[AUDIO_PATH_NAME_MAX_SIZE];
      }T_AUDIO_SR_RECO_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_sr_reco_start (T_AUDIO_SR_RECO_PARAMETER *p_parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_SR_RECO_STATUS_MSG              (0x000F | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct {
        T_RV_HDR  os_hdr;
        /* status about the recognition task */
        INT8      status;
        /*path ofthe recognized word */
        char word_recognized[AUDIO_PATH_NAME_MAX_SIZE];
      } T_AUDIO_SR_RECO_STATUS;

      /* ---------------------------- */
      /*     Stop reco                */
      /* ---------------------------- */

      /* Symbolic constant */

      /* Parameters */

      /* Prototype */
      T_AUDIO_RET audio_sr_reco_stop ( T_RV_RETURN return_path );

      /* Event return */



    /******************************* MIDI REGISTRATION *****************************/

      /* Ext Parameters */
      typedef enum
      {
	      AUDIO_EXT_MIDI_UNSIGNED,
	      AUDIO_EXT_MIDI_SIGNED
      } T_AUDIO_EXT_MIDI_TYPE;

      typedef struct
      {
        UINT16  sampling_rate; /* Sampling rate */
        UINT16  data_type;
        T_AUDIO_EXT_MIDI_TYPE bit_type;
        UINT8   channel;
        UINT16  frame_number;
      } T_AUDIO_EXT_MIDI_PARAMETER;


	    /* Buffer size and nb of buffers */
#if  (LOCOSTO_LITE==1)
      #define AUDIO_EXT_MIDI_BUFFER_SIZE      968 // 22ms buffer stereo at 22050 sampling rate; 1320 //4404  /*  in frame (1 frame = 2x16 bit words) */
#else
      #define AUDIO_EXT_MIDI_BUFFER_SIZE      2640 //4404  /*  in frame (1 frame = 2x16 bit words) */
#endif
      #define AUDIO_EXT_MIDI_NB_BUF           2     /* Nb of buffers */

	    /* Ext Prototype */
	    T_AUDIO_RET audio_ext_midi_start( T_AUDIO_EXT_MIDI_PARAMETER *p_midi_parameter,
										                    T_RV_RETURN *p_return_path);
      /* Event return */
      #define AUDIO_MIDI_STATUS_MSG      (0x0010 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)


      typedef struct
      {
        T_RV_HDR os_hdr;
        INT8     status;
      } T_AUDIO_MIDI_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_ext_midi_stop(void);

      T_AUDIO_RET audio_driver_init_midi_session(T_AUDIO_DRIVER_PARAMETER *p_driver_parameter, T_RV_RETURN *p_return_path);


      /******************************* AUDIO CONFIGURATION REGISTRATION *****************************/

      /******************/
      /*** Voice path ***/
      /******************/

      /* Parameters */

      /* Voice path selection */
      #define AUDIO_GSM_VOICE_PATH                (0)
      #define AUDIO_BLUETOOTH_CORDLESS_VOICE_PATH (1)
      #define AUDIO_BLUETOOTH_HEADSET             (2)
      #define AUDIO_DAI_ENCODER                   (12)
      #define AUDIO_DAI_DECODER                   (11)
      #define AUDIO_DAI_ACOUSTIC                  (14)

      /* Structure */
      /* audio path used */
      typedef UINT8 T_AUDIO_VOICE_PATH_SETTING;
      #if(AS_FM_RADIO==1)
      typedef UINT8 T_AUDIO_FM_PATH_SETTING;
	  #endif
#if (L1_EXT_MCU_AUDIO_VOICE_ONOFF == 1)
      #define AUDIO_VUL_OFF	0
      #define AUDIO_VUL_ON 	1
      #define AUDIO_VUL_NO_ACTION 2

      #define AUDIO_VDL_OFF	0
      #define AUDIO_VDL_ON 	1
      #define AUDIO_VDL_NO_ACTION 2

      typedef struct
      {
	UINT8 vul_onoff;
	UINT8 vdl_onoff;
      }
      T_AUDIO_MODE_ONOFF;
#endif

#if (ANLG_FAM != 11)
      /********************************/
      /*** Microphone configuration ***/
      /********************************/

      /* Parameters */
      /* Mode */
      #define AUDIO_MICROPHONE_HANDHELD             (0)
      #define AUDIO_MICROPHONE_HANDFREE             (1)
      #define AUDIO_MICROPHONE_HEADSET              (2)
      #define AUDIO_MICROPHONE_HEADSET_DIFFERENTIAL (3)

      /* gain */
      #define AUDIO_MICROPHONE_MUTE       (13)

      /* output_bias */
      #define AUDIO_MICROPHONE_OUTPUT_BIAS_2_0V  (0)
      #define AUDIO_MICROPHONE_OUTPUT_BIAS_2_5V  (1)

      /* extra gain */
      #define AUDIO_MICROPHONE_AUX_GAIN_28_2dB   (0)
      #define AUDIO_MICROPHONE_AUX_GAIN_4_6dB    (1)
#else
      /********************************/
      /*** Microphone configuration ***/
      /********************************/

      /* Parameters */
      /* Mode */
      #define AUDIO_MICROPHONE_NONE				(BSP_TWL3029_AUDIO_INPUT_PATH_ID_NONE)
      #define AUDIO_MICROPHONE_HANDSET_25_6DB   (BSP_TWL3029_AUDIO_INPUT_PATH_ID_HANDSET_MIC_25_6DB)
      #define AUDIO_MICROPHONE_HEADSET_4_9_DB   (BSP_TWL3029_AUDIO_INPUT_PATH_ID_HEADSET_MIC_4_9_DB)
      #define AUDIO_MICROPHONE_HEADSET_25_6DB	(BSP_TWL3029_AUDIO_INPUT_PATH_ID_HEADSET_MIC_25_6DB)
	  #define AUDIO_MICROPHONE_FM				(BSP_TWL3029_AUDIO_INPUT_PATH_ID_FM)
	  #define AUDIO_MICROPHONE_HEADSET_18DB		(BSP_TWL3029_AUDIO_INPUT_PATH_ID_HEADSET_MIC_18DB)
	  #define AUDIO_MICROPHONE_AUX_4_9DB		(BSP_TWL3029_AUDIO_INPUT_PATH_ID_AUX_4_9DB)
	  #define AUDIO_MICROPHONE_AUX_28_2DB		(BSP_TWL3029_AUDIO_INPUT_PATH_ID_AUX_28_2DB)
	  #define AUDIO_MICROPHONE_FM_MONO			(BSP_TWL3029_AUDIO_INPUT_PATH_ID_FM_MONO)
	  #define AUDIO_MICROPHONE_CARKIT			(BSP_TWL3029_AUDIO_INPUT_PATH_ID_CARKIT)

      /* gain */
      #define AUDIO_MICROPHONE_MUTE       (13)

      /* output_bias */
      #define AUDIO_MICROPHONE_OUTPUT_BIAS_2_0V  (BSP_TWL3029_AUDIO_INPUT_MIC_BIAS_2_0)
      #define AUDIO_MICROPHONE_OUTPUT_BIAS_2_5V  (BSP_TWL3029_AUDIO_INPUT_MIC_BIAS_2_5)

#if 0
      /* extra gain */
      #define AUDIO_MICROPHONE_AUX_GAIN_28_2dB   (0)
      #define AUDIO_MICROPHONE_AUX_GAIN_4_6dB    (1)
#endif

#endif

      /* Structure */
      typedef struct
      {
        UINT16 coefficient[31];
      }
      T_AUDIO_FIR_COEF;

#if (L1_ANR == 1)
      /* ANR Structure */
      typedef struct
      {
        BOOLEAN   anr_enable;
        INT16     min_gain;
        INT8      div_factor_shift;
        UINT8     ns_level;
      }
      T_AUDIO_ANR_CFG;
#endif
#if (L1_ANR == 2)
   typedef enum
   {
      AUDIO_ANR_STOP  = 0,
      AUDIO_ANR_START = 1,
      AUDIO_ANR_UPDATE = 2
   }
   T_AUDIO_ANR_CONTROL;

   typedef struct
   {
      INT16    control;
      INT16    ns_level;
      INT16    tone_ene_th;
      INT16    tone_cnt_th;
   }
   T_AUDIO_AQI_ANR_PARAMS;
   typedef struct
   {
      T_AUDIO_ANR_CONTROL         anr_ul_control;
      T_AUDIO_AQI_ANR_PARAMS  parameters;
   }
   T_AUDIO_AQI_ANR_CFG;
#endif

      /* ANR Structure */
      typedef struct
      {
         BOOLEAN es_enable;
         UINT8   es_behavior;
         UINT8   es_mode;
         INT16   es_gain_dl;
         INT16   es_gain_ul_1;
         INT16   es_gain_ul_2;
         INT16   tcl_fe_ls_thr;
         INT16   tcl_dt_ls_thr;
         INT16   tcl_fe_ns_thr;
         INT16   tcl_dt_ns_thr;
         INT16   tcl_ne_thr;
         INT16   ref_ls_pwr;
         UINT16  switching_time;
         UINT16  switching_time_dt;
         UINT16  hang_time;
         INT16   gain_lin_dl_vect[4];
         INT16   gain_lin_ul_vect[4];
      }
      T_AUDIO_ES_CFG;

/* For AGC, new structures are included below */
#if (L1_AGC_UL == 1 || L1_AGC_DL == 1)

   typedef enum
   {
     AUDIO_AGC_STOP   = 0,
     AUDIO_AGC_START  = 1,
     AUDIO_AGC_UPDATE = 2
   }
   T_AUDIO_AGC_CONTROL;

   typedef struct
   {
     UINT16  control;
     UINT16  frame_size;
     INT16   targeted_level;
     INT16   signal_up;
     INT16   signal_down;
     INT16   max_scale;
     INT16   gain_smooth_alpha;
     INT16   gain_smooth_alpha_fast;
     INT16   gain_smooth_beta;
     INT16   gain_smooth_beta_fast;
     INT16   gain_intp_flag;
   }
   T_AUDIO_AQI_AGC_PARAMS;

  #endif

  #if (L1_AGC_UL == 1)

   typedef struct
   {
     T_AUDIO_AGC_CONTROL        agc_ul_control;
	 T_AUDIO_AQI_AGC_PARAMS parameters;
   }
   T_AUDIO_AQI_AGC_UL_REQ ;

  #endif


  #if (L1_AGC_DL == 1)

   typedef struct
   {
     T_AUDIO_AGC_CONTROL        agc_dl_control;
	 T_AUDIO_AQI_AGC_PARAMS parameters;
   }
   T_AUDIO_AQI_AGC_DL_REQ ;

  #endif
/* AGC Structure definitions ends here*/

#if (ANLG_FAM != 11)
      typedef struct
      {
        /* gain of the microphone */
        INT8    gain;
        /* microphone output bias */
        INT8    output_bias;
        /* coefficients of the microphone FIR */
        T_AUDIO_FIR_COEF    fir;
        #if (L1_ANR == 1)
         /* ANR configuration */
         T_AUDIO_ANR_CFG     anr;
        #endif
        #if (L1_ES == 1)
         /* ES configuration */
         T_AUDIO_ES_CFG      es;
        #endif

      }
      T_AUDIO_MICROPHONE_MODE_HANDHELD;

      typedef struct {
        /* gain of the microphone */
        INT8    gain;
        /* extra gain of the microphone */
        INT8    extra_gain;
        /* microphone output bias */
        INT8    output_bias;
        /* coefficients of the microphone FIR */
        T_AUDIO_FIR_COEF    fir;
       #if (L1_ANR == 1)
        /* ANR configuration */
        T_AUDIO_ANR_CFG     anr;
       #endif
       #if (L1_ES == 1)
        /* ES configuration */
        T_AUDIO_ES_CFG     es;
       #endif
      }
      T_AUDIO_MICROPHONE_MODE_HANDFREE;

      typedef struct {
        /* gain of the microphone */
        INT8    gain;
        /* microphone output bias */
        INT8    output_bias;
        /* coefficients of the microphone FIR */
        T_AUDIO_FIR_COEF    fir;
       #if (L1_ANR == 1)
        /* ANR configuration */
        T_AUDIO_ANR_CFG     anr;
       #endif
       #if (L1_ES == 1)
        /* ES configuration */
        T_AUDIO_ES_CFG     es;
       #endif
      }
      T_AUDIO_MICROPHONE_MODE_HEADSET;

      typedef struct {
        /* gain of the microphone */
        INT8    gain;
        /* microphone output bias */
        INT8    output_bias;
        /* coefficients of the microphone FIR */
        T_AUDIO_FIR_COEF    fir;
       #if (L1_ANR == 1)
        /* ANR configuration */
        T_AUDIO_ANR_CFG     anr;
       #endif
       #if (L1_ES == 1)
        /* ES configuration */
        T_AUDIO_ES_CFG      es;
       #endif
      }
      T_AUDIO_MICROPHONE_MODE_HEADSET_DIFF;

      typedef union
      {
        /* handheld mode parameters */
        T_AUDIO_MICROPHONE_MODE_HANDHELD      handheld;
        /* handfree mode parameters */
        T_AUDIO_MICROPHONE_MODE_HANDFREE      handfree;
        /* headset mode parameters */
        T_AUDIO_MICROPHONE_MODE_HEADSET       headset;
        /* headset differential mode parameters */
        T_AUDIO_MICROPHONE_MODE_HEADSET_DIFF  headset_diff;
      }
      T_AUDIO_MICROPHONE_MODE;
#else

      typedef struct
      {
        /* gain of the microphone */
        INT8    gain;
        /* microphone output bias */
        INT8    output_bias;
        /* coefficients of the microphone FIR */
        T_AUDIO_FIR_COEF    fir;
        #if (L1_ANR == 1)
         /* ANR configuration */
         T_AUDIO_ANR_CFG     anr;
        #endif
        #if (L1_ANR == 2)
         /* ANR configuration */
         T_AUDIO_AQI_ANR_CFG     anr;
        #endif
        #if (L1_ES == 1)
         /* ES configuration */
         T_AUDIO_ES_CFG      es;
        #endif
        #if (L1_AGC_UL == 1)
         T_AUDIO_AQI_AGC_UL_REQ agc_ul;
        #endif

      }
      T_AUDIO_MICROPHONE_MODE_HANDSET_25_6DB;

      typedef T_AUDIO_MICROPHONE_MODE_HANDSET_25_6DB T_AUDIO_MICROPHONE_MODE_HEADSET_4_9_DB;
	  typedef T_AUDIO_MICROPHONE_MODE_HANDSET_25_6DB T_AUDIO_MICROPHONE_MODE_HEADSET_25_6DB;
	  typedef T_AUDIO_MICROPHONE_MODE_HANDSET_25_6DB T_AUDIO_MICROPHONE_MODE_HEADSET_18DB;
	  typedef T_AUDIO_MICROPHONE_MODE_HANDSET_25_6DB T_AUDIO_MICROPHONE_MODE_AUX_4_9DB;
	  typedef T_AUDIO_MICROPHONE_MODE_HANDSET_25_6DB T_AUDIO_MICROPHONE_MODE_AUX_28_2DB;
	  typedef T_AUDIO_MICROPHONE_MODE_HANDSET_25_6DB T_AUDIO_MICROPHONE_MODE_CARKIT;

      typedef struct
      {
        /* gain of the microphone */
        INT8    gain;
        /* microphone output bias */
        INT8    output_bias;
		       /* microphone output bias */
        INT8    extra_gain;
#if 0

/* These are not required as FM is directly fed back to the speaker */

        /* coefficients of the microphone FIR */
        T_AUDIO_FIR_COEF    fir;
        #if (L1_ANR == 1)
         /* ANR configuration */
         T_AUDIO_ANR_CFG     anr;
        #endif
        #if (L1_ES == 1)
         /* ES configuration */
         T_AUDIO_ES_CFG      es;
        #endif
#endif
      }
      T_AUDIO_MICROPHONE_MODE_FM_MONO;

	  typedef T_AUDIO_MICROPHONE_MODE_FM_MONO T_AUDIO_MICROPHONE_MODE_FM;

     typedef union
      {
        /* handheld mode parameters */
        T_AUDIO_MICROPHONE_MODE_HANDSET_25_6DB      handset_25_6db;
       /* handheld mode parameters */
        T_AUDIO_MICROPHONE_MODE_HEADSET_4_9_DB      headset_4_9db;
       /* handheld mode parameters */
        T_AUDIO_MICROPHONE_MODE_HEADSET_25_6DB      headset_25_6db;
       /* handheld mode parameters */
        T_AUDIO_MICROPHONE_MODE_HEADSET_18DB	    headset_18db;
       /* Aux mode parameters */
        T_AUDIO_MICROPHONE_MODE_AUX_4_9DB		    aux_4_9db;
       /* Aux mode parameters */
        T_AUDIO_MICROPHONE_MODE_AUX_28_2DB		    aux_28_2db;
		/* handfree mode parameters */
        T_AUDIO_MICROPHONE_MODE_FM_MONO      		fm_mono;
        /* headset mode parameters */
        T_AUDIO_MICROPHONE_MODE_CARKIT			    carkit;
        /* FM */
        T_AUDIO_MICROPHONE_MODE_FM					fm;
      }
      T_AUDIO_MICROPHONE_MODE;

#endif
      typedef struct
      {
      #if (AUDIO_DSP_FEATURES == 1)
        /* gain of the microphone */
        INT16              micro_gain;
        /* coefficients of the speaker FIR */
        T_AUDIO_FIR_COEF   fir;

        #if (L1_ANR == 1)
          /* ANR configuration */
          T_AUDIO_ANR_CFG  anr;
        #endif
        #if (L1_ES == 1)
          /* ES configuration */
          T_AUDIO_ES_CFG   es;
        #endif
        #if (L1_AGC_UL == 1)
         T_AUDIO_AQI_AGC_UL_REQ agc_ul;
        #endif
      #else
        /* mode of the microphone */
        INT8                     mode;
        /* Setting of the current mode */
        T_AUDIO_MICROPHONE_MODE  setting;
      #endif
      }
      T_AUDIO_MICROPHONE_SETTING;

#if (ANLG_FAM != 11)
      /*****************************/
      /*** Speaker configuration ***/
      /*****************************/

      /* Paratemers */
      /* Mode*/
      #define AUDIO_SPEAKER_HANDHELD          (0)
      #define AUDIO_SPEAKER_HANDFREE          (1)
      #define AUDIO_SPEAKER_HEADSET           (2)
      #define AUDIO_SPEAKER_BUZZER            (3)
      #define AUDIO_SPEAKER_HANDHELD_HANDFREE (4)
      #define AUDIO_SPEAKER_HANDHELD_8OHM     (5)
      #define AUDIO_SPEAKER_HANDFREE_8OHM     AUDIO_SPEAKER_HANDHELD_8OHM

      /* filters */
      #define AUDIO_SPEAKER_FILTER_ON   (0)
      #define AUDIO_SPEAKER_FILTER_OFF  (1)
      #define AUDIO_SPEAKER_HIGHPASS_FILTER_ON   (0)
      #define AUDIO_SPEAKER_HIGHPASS_FILTER_OFF  (1)

      /* Buzzer */
      #define AUDIO_SPEAKER_BUZZER_ON   (0)
      #define AUDIO_SPEAKER_BUZZER_OFF  (1)

      /* extra gain (SYREN) for 8ohm amplifier */
      #define AUDIO_SPEAKER_SPK_GAIN_2_5dB (0)
      #define AUDIO_SPEAKER_SPK_GAIN_8_5dB (1)
#else
      /*****************************/
      /*** Speaker configuration ***/
      /*****************************/

      /* Paratemers */
      /* Mode*/
      #define AUDIO_SPEAKER_NONE	          (0)
      #define AUDIO_SPEAKER_HANDHELD		  (1)
      #define AUDIO_SPEAKER_HEADSET 	      (2)
      #define AUDIO_SPEAKER_AUX				  (3)
      #define AUDIO_SPEAKER_CARKIT 			  (4)
      #define AUDIO_SPEAKER_HANDFREE   		  (5)
	#define AUDIO_SPEAKER_INVERTED_VOICE    (6)
	#define AUDIO_SPEAKER_HANDFREE_CLASS_D		(7)

	/*****************************/
      /*** FM Audio path configuration ***/
      /*****************************/
 #if(AS_FM_RADIO==1)
 #define AUDIO_FM_SPEAKER_NONE        (0)
 #define AUDIO_FM_STEREO_SPEAKER_HEADSET (1)
 #define AUDIO_FM_MONO_SPEAKER_HANDFREE  (2)
 #define AUDIO_FM_MONO_SPEAKER_HANDFREE_CLASSD (3)
 #endif


      /* filters */
      #define AUDIO_SPEAKER_FILTER_ON   (0)
      #define AUDIO_SPEAKER_FILTER_OFF  (1)
      #define AUDIO_SPEAKER_HIGHPASS_FILTER_ON   (0)
      #define AUDIO_SPEAKER_HIGHPASS_FILTER_OFF  (1)

      /* extra gain (SYREN) for 8ohm amplifier */
      #define AUDIO_SPEAKER_SPK_GAIN_2_5dB (0)
      #define AUDIO_SPEAKER_SPK_GAIN_8_5dB (1)

	  #define AUDIO_SIDETONE_MUTE (-26)
#endif


      #define AUDIO_LIMITER_MAX_FILTER_COEFS (31)
      #define AUDIO_LIMITER_BLOCK_SIZE       (160)

      /* Limiter Structure */
      typedef struct
      {
         BOOLEAN  limiter_enable;
         UINT16   block_size;
         UINT16   slope_update_period;
         UINT16   nb_fir_coefs;
         INT16    filter_coefs[AUDIO_LIMITER_MAX_FILTER_COEFS];
         INT16    thr_low_0;
         INT16    thr_low_slope;
         INT16    thr_high_0;
         INT16    thr_high_slope;
         INT16    gain_fall;
         INT16    gain_rise;
      }
      T_AUDIO_LIMITER_CFG;

#if (L1_IIR == 1)
      #define AUDIO_IIR_MAX_IIR_BLOCKS      (6)
      #define AUDIO_IIR_MIN_IIR_BLOCKS      (4)
      #define AUDIO_IIR_MAX_FIR_COEFS       (32)
      #define AUDIO_IIR_MIN_FIR_COEFS       (2)
      #define AUDIO_IIR_MAX_RANGE           (15)
      #define AUDIO_IIR_MIN_RANGE           (-16)
      #define AUDIO_IIR_MIN_OUTPUT_GAIN     (0)
      #define AUDIO_IIR_MAX_OUTPUT_GAIN     (1)

      typedef struct
      {
         BOOLEAN  iir_enable;
         UINT8    nb_iir_blocks;
         INT16    iir_coefs[AUDIO_IIR_MAX_IIR_BLOCKS*8];
         UINT8    nb_fir_coefs;
         INT16    fir_coefs[AUDIO_IIR_MAX_FIR_COEFS];
         INT8     input_scaling;
         INT8     fir_scaling;
         INT8     input_gain_scaling;
         INT8     output_gain_scaling;
         UINT16   output_gain;
         INT16    feedback;
       }
       T_AUDIO_IIR_CFG;

#elif (L1_IIR == 2)

	/* 160 samples for 8 Khz */
	#define AUDIO_IIR_FRAME_SIZE 		160
	#define AUDIO_IIR_DISABLE_IIR		0
	#define AUDIO_IIR_ENABLE_IIR		1
	#define AUDIO_IIR_DISABLE_FIR		0
	#define AUDIO_IIR_ENABLE_FIR		1
	#define AUDIO_IIR_MIN_FIR_TAPS		1
	#define AUDIO_IIR_MAX_FIR_TAPS	40
	#define AUDIO_IIR_MIN_IIR_BLOCKS	1
	#define AUDIO_IIR_MAX_IIR_BLOCKS	6

	typedef enum
	{
	  AUDIO_IIR_STOP   = 0,
         AUDIO_IIR_START  = 1,
         AUDIO_IIR_UPDATE = 2
   	}
	T_AUDIO_IIR_CONTROL;


	typedef struct
   	{
      	  UINT16  fir_enable;
         UINT16  fir_length;
         INT16  fir_shift;
         INT16  fir_taps[40];
   	}
   	T_AUDIO_IIR_FIR_PARAMS;

   	typedef struct
   	{
      	  INT16 sos_fact;
         INT16 sos_fact_form;
         INT16 sos_den[2];
         INT16 sos_num[3];
         INT16 sos_num_form;
        }
        T_AUDIO_IIR_SINGLE_SOS_PARAMS;

   	typedef struct
   	{
   	  UINT16 sos_enable;
   	  UINT16 sos_number;
   	  T_AUDIO_IIR_SINGLE_SOS_PARAMS sos_filter[6];
  	 }
   	 T_AUDIO_IIR_SOS_PARAMS;

   	typedef struct
   	{
     	  UINT16 control;
    	  UINT16 frame_size;
   	  UINT16 fir_swap;
	  T_AUDIO_IIR_FIR_PARAMS fir_filter;
     	  T_AUDIO_IIR_SOS_PARAMS sos_filter;
   	  INT16 gain;
   	}
  	T_AUDIO_IIR_PARAMS;

	typedef struct
   	{
	   T_AUDIO_IIR_CONTROL    iir_dl_control;
      	   T_AUDIO_IIR_PARAMS  	parameters;
	}
   	T_AUDIO_IIR_DL_CFG;

#endif

#if (L1_DRC == 1)

 	typedef enum
   	{
      	  AUDIO_DRC_STOP   = 0,
      	  AUDIO_DRC_START  = 1,
         AUDIO_DRC_UPDATE = 2
   	}
   	T_AUDIO_DRC_CONTROL;

	 typedef struct
   	{
     	  INT16 speech_mode_samp_f;
         INT16 num_subbands;
     	  INT16 frame_len;
     	  INT16 expansion_knee_fb_bs;
     	  INT16 expansion_knee_md_hg;
     	  INT16 expansion_ratio_fb_bs;
     	  INT16 expansion_ratio_md_hg;
     	  INT16 max_amplification_fb_bs;
     	  INT16 max_amplification_md_hg;
     	  INT16 compression_knee_fb_bs;
     	  INT16 compression_knee_md_hg;
     	  INT16 compression_ratio_fb_bs;
     	  INT16 compression_ratio_md_hg;
     	  INT16 energy_limiting_th_fb_bs;
     	  INT16 energy_limiting_th_md_hg;
     	  INT16 limiter_threshold_fb;
     	  INT16 limiter_threshold_bs;
     	  INT16 limiter_threshold_md;
     	  INT16 limiter_threshold_hg;
     	  INT16 limiter_hangover_spect_preserve;
     	  INT16 limiter_release_fb_bs;
     	  INT16 limiter_release_md_hg;
     	  INT16 gain_track_fb_bs;
     	  INT16 gain_track_md_hg;
     	  INT16 low_pass_filter[17];
     	  INT16 mid_band_filter[17];
   	}
   	T_AUDIO_DRC_PARAMS;

	typedef struct
   	{
      	  T_AUDIO_DRC_CONTROL   drc_dl_control;
      	  T_AUDIO_DRC_PARAMS  parameters;
   	}
   	T_AUDIO_DRC_CFG;

#endif

      /* Structure */
      typedef struct
      {
        /* gain of the speaker */
        INT8    gain;
        /* use the audio filter */
        INT8  audio_filter;
        #if ((ANLG_FAM == 3) || (ANLG_FAM == 4) || (ANLG_FAM == 11))
          /* use the audio highpass filter */
          INT8  audio_highpass_filter;
        #endif
		#if (ANLG_FAM == 11)
		  /* extra gain of the speaker */
        INT8   extra_gain;
		  /* AGC_DL of the speaker */
          #if (L1_AGC_DL == 1)
           T_AUDIO_AQI_AGC_DL_REQ agc_dl;
          #endif
		#endif
        #if (L1_IIR == 0)
          /* coefficients of the speaker FIR */
          T_AUDIO_FIR_COEF    fir;
        #endif
        #if (L1_LIMITER == 1)
          /* Limiter parameter */
          T_AUDIO_LIMITER_CFG   limiter;
        #endif
        #if (L1_IIR == 1)
          /* IIR filter parameters */
          T_AUDIO_IIR_CFG       iir;
        #elif(L1_IIR == 2)
          /* IIR 4.x filter parameters */
          T_AUDIO_IIR_DL_CFG       iir;
        #endif
        #if (L1_DRC == 1)
          /* DRC filter parameters */
          T_AUDIO_DRC_CFG       drc;
        #endif
      }
      T_AUDIO_SPEAKER_MODE_HANDHELD;

      typedef struct
      {
        /* gain of the speaker */
        INT8    gain;
        /* use the audio filter */
        INT8   audio_filter;
        #if ((ANLG_FAM == 3) || (ANLG_FAM == 4) || (ANLG_FAM == 11))
          /* use the audio highpass filter */
          INT8  audio_highpass_filter;
        #endif
		#if (ANLG_FAM == 11)
		  /* extra gain of the speaker */
        INT8   extra_gain;
		  /* AGC_DL of the speaker */
		  #if (L1_AGC_DL == 1)
           T_AUDIO_AQI_AGC_DL_REQ agc_dl;
          #endif
		#endif
        #if (L1_IIR == 0)
          /* coefficients of the speaker FIR */
          T_AUDIO_FIR_COEF    fir;
        #endif
        #if (L1_LIMITER == 1)
          /* Limiter parameter */
          T_AUDIO_LIMITER_CFG limiter;
        #endif
        #if (L1_IIR == 1)
          /* IIR filter parameters */
          T_AUDIO_IIR_CFG     iir;
        #elif (L1_IIR == 2)
          /* IIR 4.x filter parameters */
          T_AUDIO_IIR_DL_CFG     iir;
        #endif
       #if (L1_DRC == 1)
          /* DRC filter parameters */
          T_AUDIO_DRC_CFG       drc;
        #endif

      }
      T_AUDIO_SPEAKER_MODE_HANDFREE;

      typedef struct
      {
        /* gain of the speaker */
        INT8    gain;
        /* use the audio filter */
        INT8   audio_filter;
        #if ((ANLG_FAM == 3) || (ANLG_FAM == 4) || (ANLG_FAM == 11))
          /* use the audio highpass filter */
          INT8  audio_highpass_filter;
        #endif
		#if (ANLG_FAM == 11)
		  /* AGC_DL of the speaker */
          #if (L1_AGC_DL == 1)
           T_AUDIO_AQI_AGC_DL_REQ agc_dl;
          #endif
		#endif
        #if (L1_IIR == 0)
          /* coefficients of the speaker FIR */
          T_AUDIO_FIR_COEF    fir;
        #endif
        #if (L1_LIMITER == 1)
          /* Limiter parameter */
          T_AUDIO_LIMITER_CFG limiter;
        #endif
        #if (L1_IIR == 1)
          /* IIR filter parameters */
          T_AUDIO_IIR_CFG     iir;
        #elif (L1_IIR == 2)
          /* IIR 4.x filter parameters */
          T_AUDIO_IIR_DL_CFG     iir;
        #endif
        #if (L1_DRC == 1)
          /* DRC filter parameters */
          T_AUDIO_DRC_CFG       drc;
        #endif
      }
      T_AUDIO_SPEAKER_MODE_HEADSET;

#if (ANLG_FAM != 11)
      typedef struct
      {
        /* activate the buzzer */
        INT8  activate;
      }
      T_AUDIO_SPEAKER_MODE_BUZZER;

      typedef struct
      {
        /* gain of the speaker */
        INT8    gain;
        /* use the audio filter */
        INT8   audio_filter;
        #if ((ANLG_FAM == 3) || (ANLG_FAM == 4) || (ANLG_FAM == 11))
          /* use the audio highpass filter */
          INT8  audio_highpass_filter;
        #endif
        #if (L1_IIR == 0)
          /* coefficients of the speaker FIR */
          T_AUDIO_FIR_COEF    fir;
        #endif
        #if (L1_LIMITER == 1)
          /* Limiter parameter */
          T_AUDIO_LIMITER_CFG limiter;
        #endif
        #if (L1_IIR == 1)
          /* IIR filter parameters */
          T_AUDIO_IIR_CFG     iir;
        #elif (L1_IIR == 2)
          /* IIR 4.x filter parameters */
          T_AUDIO_IIR_DL_CFG     iir;
        #endif
        #if (L1_DRC == 1)
          /* DRC filter parameters */
          T_AUDIO_DRC_CFG       drc;
        #endif
      }
      T_AUDIO_SPEAKER_MODE_HANDHELD_HANDFREE;

      typedef struct
      {
        /* gain of the speaker */
        INT8    gain;
        /* extra gain of the speaker */
        INT8   extra_gain;
        /* use the audio filter */
        INT8   audio_filter;
        /* use the audio highpass filter */
        INT8  audio_highpass_filter;
        #if (L1_IIR == 0)
          /* coefficients of the speaker FIR */
          T_AUDIO_FIR_COEF    fir;
        #endif
        #if (L1_LIMITER == 1)
          /* Limiter parameter */
          T_AUDIO_LIMITER_CFG limiter;
        #endif
        #if (L1_IIR == 1)
          /* IIR filter parameters */
          T_AUDIO_IIR_CFG     iir;
        #elif (L1_IIR == 2)
          /* IIR 4.x filter parameters */
          T_AUDIO_IIR_DL_CFG     iir;
        #endif
	#if (L1_DRC == 1)
          /* DRC filter parameters */
          T_AUDIO_DRC_CFG       drc;
        #endif
      }
      T_AUDIO_SPEAKER_MODE_HANDHELD_8OHM;

      typedef T_AUDIO_SPEAKER_MODE_HANDHELD_8OHM T_AUDIO_SPEAKER_MODE_HANDFREE_8OHM;
#else

      typedef struct
      {
        /* gain of the speaker */
        INT8    gain;
        /* use the audio filter */
        INT8   audio_filter;
        /* use the audio highpass filter */
        INT8  audio_highpass_filter;
        #if (L1_IIR == 0)
          /* coefficients of the speaker FIR */
          T_AUDIO_FIR_COEF    fir;
        #endif
		#if (ANLG_FAM == 11)
		  /* AGC_DL of the speaker */
          #if (L1_AGC_DL == 1)
           T_AUDIO_AQI_AGC_DL_REQ agc_dl;
          #endif
		#endif
        #if (L1_LIMITER == 1)
          /* Limiter parameter */
          T_AUDIO_LIMITER_CFG limiter;
        #endif
        #if (L1_IIR == 1)
          /* IIR filter parameters */
          T_AUDIO_IIR_CFG     iir;
        #elif (L1_IIR == 2)
          /* IIR 4.x filter parameters */
          T_AUDIO_IIR_DL_CFG     iir;
        #endif
        #if (L1_DRC == 1)
          /* DRC filter parameters */
          T_AUDIO_DRC_CFG       drc;
        #endif
      }
      T_AUDIO_SPEAKER_MODE_AUX;

      typedef struct
      {
        /* gain of the speaker */
        INT8    gain;
        /* use the audio filter */
        INT8   audio_filter;
        /* use the audio highpass filter */
        INT8  audio_highpass_filter;
        #if (L1_IIR == 0)
          /* coefficients of the speaker FIR */
          T_AUDIO_FIR_COEF    fir;
        #endif
		#if (ANLG_FAM == 11)
		  /* AGC_DL of the speaker */
          #if (L1_AGC_DL == 1)
           T_AUDIO_AQI_AGC_DL_REQ agc_dl;
          #endif
		#endif
        #if (L1_LIMITER == 1)
          /* Limiter parameter */
          T_AUDIO_LIMITER_CFG limiter;
        #endif
        #if (L1_IIR == 1)
          /* IIR filter parameters */
          T_AUDIO_IIR_CFG     iir;
        #elif (L1_IIR == 2)
          /* IIR 4.x filter parameters */
          T_AUDIO_IIR_DL_CFG     iir;
        #endif
        #if (L1_DRC == 1)
          /* DRC filter parameters */
          T_AUDIO_DRC_CFG       drc;
        #endif
      }
      T_AUDIO_SPEAKER_MODE_CARKIT;

#endif

      typedef union
      {
        /* handheld mode parameters */
        T_AUDIO_SPEAKER_MODE_HANDHELD handheld;
        /* handfree mode parameters */
        T_AUDIO_SPEAKER_MODE_HANDFREE handfree;
        /* headset mode parameters */
        T_AUDIO_SPEAKER_MODE_HEADSET  headset;
#if (ANLG_FAM != 11)
        /* buzzer mode parameters */
        T_AUDIO_SPEAKER_MODE_BUZZER   buzzer;
        /* handheld and handfree mode parameters */
        T_AUDIO_SPEAKER_MODE_HANDHELD_HANDFREE handheld_handfree;
        /* handheld and handfree mode parameters */
        T_AUDIO_SPEAKER_MODE_HANDHELD_8OHM     handheld_8ohm;
        /* handheld and handfree mode parameters */
        T_AUDIO_SPEAKER_MODE_HANDFREE_8OHM     handfree_8ohm;
#else
		T_AUDIO_SPEAKER_MODE_AUX	aux;
		T_AUDIO_SPEAKER_MODE_CARKIT carkit;
#endif
      }
      T_AUDIO_SPEAKER_MODE;

      typedef struct
      {
      #if (AUDIO_DSP_FEATURES == 1)
        /* gain of the speaker */
        INT16                  speaker_gain;
        /* coefficients of the speaker FIR */
        T_AUDIO_FIR_COEF       fir;

		/* AGC_DL of the speaker */
        #if (L1_AGC_DL == 1)
         T_AUDIO_AQI_AGC_DL_REQ agc_dl;
        #endif
        #if (L1_LIMITER == 1)
          /* Limiter parameter */
          T_AUDIO_LIMITER_CFG  limiter;
        #endif
        #if (L1_IIR == 1)
          /* IIR filter parameters */
          T_AUDIO_IIR_CFG      iir;
        #elif(L1_IIR == 2)
          /* IIR 4.x filter parameters */
          T_AUDIO_IIR_DL_CFG      iir;
        #endif
        #if (L1_DRC == 1)
          /* DRC filter parameters */
          T_AUDIO_DRC_CFG       drc;
        #endif
      #else
        /* mode of the speaker */
        INT8                  mode;
        /* Setting of the current mode */
        T_AUDIO_SPEAKER_MODE  setting;
      #endif
      }
      T_AUDIO_SPEAKER_SETTING;

      /********************************************/
      /*** Mirophone-Speaker loop configuration ***/
      /********************************************/

      /* sidetone */
      #define AUDIO_SIDETONE_OPEN             (-26)

      /* AEC enable */
      #define AUDIO_AEC_ENABLE                (0x0002)
      #define AUDIO_AEC_DISABLE               (0x0000)

      /* AEC visibility */
      #define AUDIO_AEC_VISIBILITY_ENABLE     (0x0200)
      #define AUDIO_AEC_VISIBILITY_DISABLE    (0x0000)

      /* AEC mode */
      #define AUDIO_SHORT_ECHO                (0x0200)
      #define AUDIO_LONG_ECHO                 (0x0000)

      /* echo suppression level */
    #if (L1_NEW_AEC)
      #define AUDIO_MAX_ECHO_0dB              (0x7FFF)
      #define AUDIO_MAX_ECHO_2dB              (0x65AA)
      #define AUDIO_MAX_ECHO_3dB              (0x59AD)
      #define AUDIO_MAX_ECHO_6dB              (0x4000)
      #define AUDIO_MAX_ECHO_12dB             (0x1FFF)
      #define AUDIO_MAX_ECHO_18dB             (0x0FFF)
      #define AUDIO_MAX_ECHO_24dB             (0x07FF)
    #else
      #define AUDIO_ECHO_0dB                  (0x0000)
      #define AUDIO_ECHO_6dB                  (0x0008)
      #define AUDIO_ECHO_12dB                 (0x0010)
      #define AUDIO_ECHO_18dB                 (0x0018)
    #endif

      /* noise suppression enable */
      #define AUDIO_NOISE_SUPPRESSION_ENABLE  (0x0004)
      #define AUDIO_NOISE_SUPPRESSION_DISABLE (0x0000)

      /* ANR enable */
      #if (L1_ANR == 1)
        #define AUDIO_ANR_ENABLE              (0x0001)
        #define AUDIO_ANR_DISABLE             (0x0000)
      #endif

      #if (L1_ANR == 2)
        #define AUDIO_ANR_DISABLE             (0x0000)
        #define AUDIO_ANR_TONEDET_ENABLE      (0x0001)
        #define AUDIO_ANR_ENABLE_TONEDET_DISABLE (0x0003)
      #endif

      /* AGC enable */
      #if (L1_AGC_DL == 1 || L1_AGC_UL == 1)
        #define AUDIO_AGC_ENABLE              (0x0001)
        #define AUDIO_AGC_DISABLE             (0x0000)
      #endif

      /* ES enable */
      #if (L1_ES == 1)
        #define AUDIO_ES_DISABLE              (0x0000)
        #define AUDIO_ES_ENABLE               (0x0001)

        #define AUDIO_ES_B_ES_UL              (0x0001)
        #define AUDIO_ES_B_ES_DL              (0x0002)
        #define AUDIO_ES_B_CNG                (0x0004)
        #define AUDIO_ES_B_NSF                (0x0008)

        #define AUDIO_ES_BEHAVIOUR_1          (0x0000)
        #define AUDIO_ES_BEHAVIOUR_1A         (0x0001)
        #define AUDIO_ES_BEHAVIOUR_2A         (0x0002)
        #define AUDIO_ES_BEHAVIOUR_2B         (0x0003)
        #define AUDIO_ES_BEHAVIOUR_2C         (0x0004)
        #define AUDIO_ES_BEHAVIOUR_2C_IDLE    (0x0005)
        #define AUDIO_ES_BEHAVIOUR_3          (0x0006)
        #define AUDIO_ES_CUSTOM               (0x00FF)
      #endif

      /* IIR enable */
      #if (L1_IIR == 1 || L1_IIR == 2)
        #define AUDIO_IIR_ENABLE              (0x0001)
        #define AUDIO_IIR_DISABLE             (0x0000)
      #endif

      /* LIMITER enable */
      #if (L1_LIMITER == 1)
        #define AUDIO_LIMITER_ENABLE          (0x0001)
        #define AUDIO_LIMITER_DISABLE         (0x0000)
      #endif

      /* noise suppression level */
      #define AUDIO_NOISE_NO_LIMITATION       (0x0000)
      #define AUDIO_NOISE_6dB                 (0x0020)
      #define AUDIO_NOISE_12dB                (0x0040)
      #define AUDIO_NOISE_18dB                (0x0060)

#if (L1_AEC == 1)
      typedef struct
      {
        /* Enable the AEC */
        UINT16    aec_enable;
      #if (L1_NEW_AEC)
        BOOL   continuous_filtering;
        UINT16 granularity_attenuation;
        UINT16 smoothing_coefficient;
        UINT16 max_echo_suppression_level;
        UINT16 vad_factor;
        UINT16 absolute_threshold;
        UINT16 factor_asd_filtering;
        UINT16 factor_asd_muting;
        UINT16 aec_visibility; // UINT16 and not boolean because in L1, it is in aec_control
      #else
        /* Mode of the AEC */
        UINT16    aec_mode;
        /* level of the echo cancellation */
        UINT16    echo_suppression_level;
      #endif
      #if (L1_ANR == 0)
        /* enable the noise suppression */
        UINT16    noise_suppression_enable;
        /* level of the noise suppression */
        UINT16    noise_suppression_level;
      #endif
      }
      T_AUDIO_AEC_CFG;

      typedef struct
      {
       #if (AUDIO_DSP_FEATURES == 1)
        /* gain of the sidetone */
        INT16    sidetone_gain;
       #else
        /* gain of the sidetone */
        INT8    sidetone_gain;
       #endif
        /* configuration of the acoustic echo cancellation */
        T_AUDIO_AEC_CFG               aec;
      }
      T_AUDIO_MICROPHONE_SPEAKER_LOOP_SETTING;
#endif
#if (L1_AEC == 2)
      #define AUDIO_AQI_AEC_1_8_WITH_VAD_ES     0x0008
	  #define AUDIO_AQI_AEC_1_8_WITHOUT_VAD_ES  0x0000
	  #define AUDIO_AQI_AEC_2_0_WITH_VAD_ES     0x0007
	  #define AUDIO_AQI_AEC_2_0_WITHOUT_VAD_ES  0x0003

	  #define AUDIO_AQI_MU                      0x5000

	  #define AUDIO_AQI_CONT_FILT_ENABLED       0x0001
	  #define AUDIO_AQI_CONT_FILT_DISABLED      0x0000

	  #define AUDIO_AQI_NO_SCALING_UL           0x0000
	  #define AUDIO_AQI_SCALING_UL              0x0003

	  #define AUDIO_AQI_NO_SCALING_DL           0x0000
	  #define AUDIO_AQI_SCALING_DL              0x0003


	  #define AUDIO_AQI_DIV_DMAX                0x537D
	  #define AUDIO_AQI_DIV_SWAPE_GOOD          0x7FB2
	  #define AUDIO_AQI_DIV_SWAPE_BAD           0x65AD
	  #define AUDIO_AQI_BLOCK_INIT              0x07D0
	  #define AUDIO_AQI_FACT_VAD                0x3FFF
	  #define AUDIO_AQI_FACT_ASD_FIL            0x1000
	  #define AUDIO_AQI_FACT_ASD_MUT            0x1000
	  #define AUDIO_AQI_THR_ABS                 0x0032

	  #define AUDIO_AQI_ES_LEVEL_MIN            0x0813
	  #define AUDIO_AQI_ES_LEVEL_MAX            0x7FFF

	  #define AUDIO_AQI_GRANUL_ATT              0x00A0

	  #define AUDIO_AQI_COEF_SMOOTH_MIN         0x0CCB
	  #define AUDIO_AQI_COEF_SMOOTH_MAX         0x7FFF

      typedef enum
      {
	    AUDIO_AQI_AEC_STOP   = 0,
	    AUDIO_AQI_AEC_START  = 1,
	    AUDIO_AQI_AEC_UPDATE = 2
      }
      T_AUDIO_AEC_CONTROL;
      typedef struct
      {
        /* Enable the AEC */
        T_AUDIO_AEC_CONTROL    aec_control;

        INT16 aec_mode;
	    INT16 mu;
	    UINT16 cont_filter;
	    INT16 scale_input_ul;
	    INT16 scale_input_dl;
	    INT16 div_dmax;
	    UINT16 div_swap_good;
	    UINT16 div_swap_bad;
	    INT16 block_init;
	    UINT16 fact_vad;
	    UINT16 fact_asd_fil;
	    UINT16 fact_asd_mut;
	    UINT16 thrs_abs;
	    UINT16 es_level_max;
	    UINT16 granularity_att;
	    UINT16 coef_smooth;
      }
      T_AUDIO_AQI_AEC_CFG;

      typedef struct
      {
       #if (AUDIO_DSP_FEATURES == 1)
        /* gain of the sidetone */
        INT16    sidetone_gain;
       #else
        /* gain of the sidetone */
        INT8    sidetone_gain;
       #endif
        /* configuration of the acoustic echo cancellation */
        T_AUDIO_AQI_AEC_CFG               aec;
      }
      T_AUDIO_MICROPHONE_SPEAKER_LOOP_SETTING;
#endif

#if (ANLG_FAM != 11)
      /************************************/
      /*** Stereo speaker configuration ***/
      /************************************/

      /* Paratemers */
      /* Mode*/
      #define AUDIO_STEREO_SPEAKER_HEADPHONE          (0)
      #define AUDIO_STEREO_SPEAKER_HANDHELD           (1)
      #define AUDIO_STEREO_SPEAKER_HANDFREE           (2)
      #define AUDIO_STEREO_SPEAKER_HANDHELD_8OHM      (3)
      #define AUDIO_STEREO_SPEAKER_HANDFREE_8OHM      AUDIO_STEREO_SPEAKER_HANDHELD_8OHM

      /* filters */
      #define AUDIO_STEREO       (0)
      #define AUDIO_MONO_LEFT    (1 << 0)
      #define AUDIO_MONO_RIGHT   (1 << 1)

      /* sampling frequency */
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_48KHZ     (0)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_44_1KHZ   (1)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_32KHZ     (2)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_22_05KHZ  (3)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_16KHZ     (4)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_11_025KHZ (5)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_8KHZ      (6)

#else
   	  /*****************************/
      /*** Speaker configuration ***/
      /*****************************/
      /* Paratemers */
      /* Mode*/
      #define AUDIO_STEREO_SPEAKER_NONE	          (0)
      #define AUDIO_STEREO_SPEAKER_HANDHELD		  (1)
      #define AUDIO_STEREO_SPEAKER_HEADPHONE      (2)
      #define AUDIO_STEREO_SPEAKER_AUX			  (3)
      #define AUDIO_STEREO_SPEAKER_CARKIT 		  (4)
      #define AUDIO_STEREO_SPEAKER_HANDFREE		  (5)
	  // definition for 6 is skipped to match with speaker mode definitions
      #define AUDIO_STEREO_SPEAKER_HANDFREE_CLASS_D		  (7)

	  #define AUDIO_STEREO			BSP_TWL3029_AUDIO_STEREO2MONO_OFF
	  #define AUDIO_MONO_RIGHT		BSP_TWL3029_AUDIO_STEREO2MONO_RIGHT
	  #define AUDIO_MONO_LEFT		BSP_TWL3029_AUDIO_STEREO2MONO_LEFT
	  #define AUDIO_MONO_LEFT_RIGHT	BSP_TWL3029_AUDIO_STEREO2MONO_LEFT_AND_RIGHT

	 /* sampling frequency */
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_48KHZ     (0)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_44_1KHZ   (1)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_32KHZ     (2)
	  #define AUDIO_STEREO_SAMPLING_FREQUENCY_24KHZ		(3)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_22_05KHZ  (4)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_16KHZ     (5)
	  #define AUDIO_STEREO_SAMPLING_FREQUENCY_12KHZ		(6)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_11_025KHZ (7)
      #define AUDIO_STEREO_SAMPLING_FREQUENCY_8KHZ      (8)

      #define AUDIO_SPEAKER_SPK_GAIN_8_5DB		BSP_TWL3029_AUDIO_SPEAKER_AMP_GAIN_8_5DB
      #define AUDIO_SPEAKER_SPK_GAIN_2_5DB		BSP_TWL3029_AUDIO_SPEAKER_AMP_GAIN_2_5DB
      #define AUDIO_SPEAKER_SPK_GAIN_MINUS_3_5DB	BSP_TWL3029_AUDIO_SPEAKER_AMP_GAIN_MINUS_3_5DB
      #define AUDIO_SPEAKER_SPK_GAIN_MINUS_22_5DB 	BSP_TWL3029_AUDIO_SPEAKER_AMP_GAIN_MINUS_22_5DB

      #define AUDIO_EAR_GAIN_MINUS_11DB 	BSP_TWL3029_AUDIO_EARGAIN_MINUS_11DB
      #define AUDIO_EAR_GAIN_1DB		BSP_TWL3029_AUDIO_EARGAIN_1DB

#endif

      typedef struct
      {
        /* stereo/mono configuration of the speaker */
        INT8   stereo_mono;
        /* sampling rate frequency */
        INT8   sampling_frequency;
      }
      T_AUDIO_STEREO_SPEAKER_MODE_HEADPHONE;

      typedef struct
      {
        /* sampling rate frequency */
        INT8   sampling_frequency;
      }
      T_AUDIO_STEREO_SPEAKER_MODE_HANDHELD;

      typedef struct
      {
        /* sampling rate frequency */
        INT8   sampling_frequency;
      }
      T_AUDIO_STEREO_SPEAKER_MODE_HANDFREE;

#if (ANLG_FAM != 11)
      typedef struct
      {
        /* sampling rate frequency */
        INT8   sampling_frequency;
      }
      T_AUDIO_STEREO_SPEAKER_MODE_HANDHELD_8OHM;

      typedef T_AUDIO_STEREO_SPEAKER_MODE_HANDHELD_8OHM T_AUDIO_STEREO_SPEAKER_MODE_HANDFREE_8OHM;
#else

      typedef struct
      {
        /* sampling rate frequency */
        INT8   sampling_frequency;
      }
      T_AUDIO_STEREO_SPEAKER_MODE_AUX;

      typedef struct
      {
        /* stereo/mono configuration of the speaker */
        INT8   stereo_mono;
        /* sampling rate frequency */
        INT8   sampling_frequency;
      }
      T_AUDIO_STEREO_SPEAKER_MODE_CARKIT;

#endif

      typedef union
      {
        /* headphone mode parameters */
        T_AUDIO_STEREO_SPEAKER_MODE_HEADPHONE headphone;
        /* handheld mode parameters */
        T_AUDIO_STEREO_SPEAKER_MODE_HANDHELD  handheld;
        /* handfree mode parameters */
        T_AUDIO_STEREO_SPEAKER_MODE_HANDFREE  handfree;
		#if (ANLG_FAM != 11)
        /* handheld 8ohm mode parameters */
        T_AUDIO_STEREO_SPEAKER_MODE_HANDHELD_8OHM handheld_8ohm;
        /* handfree 8ohm mode parameters */
        T_AUDIO_STEREO_SPEAKER_MODE_HANDFREE_8OHM handfree_8ohm;
		#else
		T_AUDIO_STEREO_SPEAKER_MODE_AUX		aux;
		T_AUDIO_STEREO_SPEAKER_MODE_CARKIT 	carkit;
		#endif
      }
      T_AUDIO_STEREO_SPEAKER_MODE;

      typedef struct
      {
        /* mode of the speaker */
        INT8                         mode;
        /* Setting of the current mode */
        T_AUDIO_STEREO_SPEAKER_MODE setting;
      }
      T_AUDIO_STEREO_SPEAKER_SETTING;


      /********************************************/
      /*** Mirophone-Speaker loop configuration ***/
      /********************************************/

      /* Audio on off selection */
      #define AUDIO_ON      (1)
      #define AUDIO_OFF     (0)

      #if ((AUDIO_DSP_ONOFF == 1) || (AUDIO_DSP_FEATURES == 1))
       typedef struct
        {
         #if (AUDIO_DSP_FEATURES == 1)
          /* volume speed control */
          INT16 volume_speed;
         #endif
         #if (AUDIO_DSP_ONOFF == 1)
          /* audio on/off */
          INT8  audio_onoff;
         #endif
        }
        T_AUDIO_MICROPHONE_SPEAKER_SETTING;
      #endif

      /****************************************/
      /*      audio mode file struture        */
      /* this file is in the folder /AUDCFG/  */
      /* and has the extention .CFG           */
      /****************************************/

      typedef struct
      {
        /* group of setting to define the audio path used */
        T_AUDIO_VOICE_PATH_SETTING              audio_path_setting;
	/*Audio FM settings*/
	#if(AS_FM_RADIO==1)
	T_AUDIO_FM_PATH_SETTING                    audio_fm_setting;
    #endif
        /* group of setting to configure the audio path of the microphone */
        T_AUDIO_MICROPHONE_SETTING              audio_microphone_setting;
        /* group of setting to configure the audio path of the speaker */
        T_AUDIO_SPEAKER_SETTING                 audio_speaker_setting;
      #if (((ANLG_FAM == 3) && (AUDIO_DSP_FEATURES == 0)) || ((ANLG_FAM == 4)&& (AUDIO_DSP_FEATURES == 0)) || ((ANLG_FAM == 11) && (AUDIO_DSP_FEATURES == 0)))
        /* group of setting to configure the stereo_audio path of the speaker */
        T_AUDIO_STEREO_SPEAKER_SETTING          audio_stereo_speaker_setting;
      #endif
        /* group of setting to configure the audio mode involved */
        /* in the microphone and speaker loop */
        T_AUDIO_MICROPHONE_SPEAKER_LOOP_SETTING audio_microphone_speaker_loop_setting;
      #if ((AUDIO_DSP_ONOFF == 1) || (AUDIO_DSP_FEATURES == 1))
        /* group of settings to configure audio features common to */
        /* microphone and speaker */
        T_AUDIO_MICROPHONE_SPEAKER_SETTING audio_microphone_speaker_setting;
      #endif
      }
      T_AUDIO_MODE;

      /****************************************/
      /*      voice volume file struture      */
      /* this file is in the folder /AUDCFG/  */
      /* and has the extention .VOL           */
      /****************************************/
      /* speaker volume action */
      #define AUDIO_SPEAKER_VOLUME_INCREASE     (0)
      #define AUDIO_SPEAKER_VOLUME_DECREASE     (1)
      #define AUDIO_SPEAKER_VOLUME_SET          (2)

      /* speaker volume value */
      #define AUDIO_SPEAKER_VOLUME_MUTE         (0)
      #define AUDIO_SPEAKER_VOLUME_24dB         (1)
      #define AUDIO_SPEAKER_VOLUME_18dB         (50)
      #define AUDIO_SPEAKER_VOLUME_12dB         (100)
      #define AUDIO_SPEAKER_VOLUME_6dB          (150)
      #define AUDIO_SPEAKER_VOLUME_0dB          (200)
      typedef struct
      {
        /* volume of the voice speaker */
        UINT8      audio_speaker_level;
      }
      T_AUDIO_SPEAKER_LEVEL;

      /****************************************/
      /*      audio volume file struture      */
      /* this file is in the folder /AUDCFG/  */
      /* and has the extention .VOL           */
      /****************************************/
      /* speaker volume action */
      #define AUDIO_STEREO_SPEAKER_VOLUME_INCREASE     (0)
      #define AUDIO_STEREO_SPEAKER_VOLUME_DECREASE     (1)
      #define AUDIO_STEREO_SPEAKER_VOLUME_SET          (2)

      /* speaker volume value */
      #define AUDIO_STEREO_SPEAKER_VOLUME_MUTE         (0x1F)

      typedef struct
      {
        /* volume of the audio stereo speaker */
        UINT8      audio_stereo_speaker_level_left;
        UINT8      audio_stereo_speaker_level_right;
      }
      T_AUDIO_STEREO_SPEAKER_LEVEL;

      /******************/
      /* MMI family API */
      /******************/


      /* structure */
      /* maximum number of number of the filname characters */
      #define AUDIO_MODE_FILENAME_MAX_SIZE  (10)

      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR  audio_mode_filename[AUDIO_MODE_FILENAME_MAX_SIZE];
#else
		char  audio_mode_filename[AUDIO_MODE_FILENAME_MAX_SIZE];
#endif
      }
      T_AUDIO_MODE_LOAD;

      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR  audio_mode_filename[AUDIO_MODE_FILENAME_MAX_SIZE];
#else
		char  audio_mode_filename[AUDIO_MODE_FILENAME_MAX_SIZE];
#endif
      }
      T_AUDIO_MODE_SAVE;

      typedef struct
      {
        INT8    volume_action;
        UINT8   value;
      }
      T_AUDIO_SPEAKER_VOLUME;

      typedef struct
      {
        INT8    volume_action_left;
        UINT8   value_left;
        INT8    volume_action_right;
        UINT8   value_right;
      }
      T_AUDIO_STEREO_SPEAKER_VOLUME;

      /* Prototypes of MMI family*/
      T_AUDIO_RET audio_mode_load(T_AUDIO_MODE_LOAD  *p_parameter,
                                  T_RV_RETURN        return_path);

      T_AUDIO_RET audio_mode_save(T_AUDIO_MODE_SAVE  *p_parameter,
                                  T_RV_RETURN        return_path);

      T_AUDIO_RET audio_speaker_volume(T_AUDIO_SPEAKER_VOLUME volume,
                                        T_RV_RETURN            return_path);

      T_AUDIO_RET audio_stereo_speaker_volume(T_AUDIO_STEREO_SPEAKER_VOLUME volume,
                                              T_RV_RETURN            return_path);

      /* Event return of the MMI family API*/
      #define AUDIO_MODE_LOAD_DONE              (0x0011 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_LOAD_DONE;

      #define AUDIO_MODE_SAVE_DONE              (0x0012 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_SAVE_DONE;

      #define AUDIO_SPEAKER_VOLUME_DONE         (0x0013 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_VOLUME_DONE;

      #define AUDIO_STEREO_SPEAKER_VOLUME_DONE  (0x0014 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_STEREO_VOLUME_DONE;


      /**********************/
      /* Full Access Family */
      /**********************/

      /* structure */
      typedef struct
      {
        UINT8   variable_indentifier;
        void    *data;
      }
      T_AUDIO_FULL_ACCESS_WRITE;

      typedef struct
      {
        UINT8   variable_indentifier;
        void    *data;
      }
      T_AUDIO_FULL_ACCESS_READ;

      /* parameter */
      #define AUDIO_PATH_USED                         (0)
      #define AUDIO_MICROPHONE_MODE                   (1)
      #define AUDIO_MICROPHONE_GAIN                   (2)
      #define AUDIO_MICROPHONE_EXTRA_GAIN             (3)
      #define AUDIO_MICROPHONE_OUTPUT_BIAS            (4)
      #define AUDIO_MICROPHONE_FIR                    (5)
      #define AUDIO_SPEAKER_MODE                      (6)
      #define AUDIO_SPEAKER_GAIN                      (7)
      #define AUDIO_SPEAKER_FILTER                    (8)
      #define AUDIO_SPEAKER_FIR                       (9)
      #define AUDIO_SPEAKER_BUZZER_STATE              (10)
      #define AUDIO_MICROPHONE_SPEAKER_LOOP_SIDETONE  (11)
      #define AUDIO_MICROPHONE_SPEAKER_LOOP_AEC       (12)
      #define AUDIO_SPEAKER_VOLUME_LEVEL              (13)
      #define AUDIO_STEREO_SPEAKER_MODE               (14)
      #define AUDIO_STEREO_SPEAKER_STEREO_MONO        (15)
      #define AUDIO_STEREO_SPEAKER_SAMPLING_FREQUENCY (16)
      #define AUDIO_STEREO_SPEAKER_VOLUME_LEVEL       (17)
      #define AUDIO_VOLUME_SPEED                      (18)
      #define AUDIO_ONOFF                             (19)
      #define AUDIO_SPEAKER_EXTRA_GAIN                (20)
      #define AUDIO_SPEAKER_HIGHPASS_FILTER           (21)
      #define AUDIO_MICROPHONE_ANR                    (22)
      #define AUDIO_SPEAKER_IIR                       (23)
      #define AUDIO_SPEAKER_LIMITER                   (24)
      #define AUDIO_MICROPHONE_ES                     (25)
	  #define AUDIO_MICROPHONE_AGC                 (26)
	  #define AUDIO_SPEAKER_AGC                    (27)
      #define AUDIO_SPEAKER_DRC                 (28)
      #define AUDIO_STEREO_SPEAKER_EXTRA_GAIN         (29)

	#define AUDIO_FM_SPEAKER_MODE                 (32) /*FM audio support*/

      /* prototype */
      T_AUDIO_RET audio_full_access_write (T_AUDIO_FULL_ACCESS_WRITE  *p_parameter,
                                            T_RV_RETURN                           return_path);

      T_AUDIO_RET audio_full_access_read (T_AUDIO_FULL_ACCESS_READ    *p_parameter);


      /* Event returned ofthe Full Access Family */
      #define AUDIO_FULL_ACCESS_WRITE_DONE              (0x0015 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
      } T_AUDIO_FULL_ACCESS_WRITE_DONE;



      /******************************* MP3 REGISTRATION *****************************/
      /* Definition of the maximum size of the path name */
      #define AUDIO_MP3_PATH_NAME_MAX_SIZE      (80)        /*   (32)  */

      /* Definition of the channel configuration */
      #define AUDIO_MP3_MONO        (0)
      #define AUDIO_MP3_STEREO      (1)

	  //define mp3 folder in FFS
      #define     MP3_DIR          "/mp3"


      /* MP3 Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR   mp3_name[AUDIO_MP3_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#else
		char      mp3_name[AUDIO_MP3_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#endif
        BOOLEAN   mono_stereo;      /* channel configuration */
        UINT32    size_file_start;  /* size of the file where the melody must start */
        BOOLEAN   play_bar_on;   /* set to zero to switch off the playbar */
      } T_AUDIO_MP3_PARAMETER;

      /* Ext Prototype */
	    T_AUDIO_RET audio_mp3_start( T_AUDIO_MP3_PARAMETER *p_parameter,
										               T_RV_RETURN return_path);
      /* Event return */
      #define AUDIO_MP3_STATUS_MSG          (0x0016 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      #define AUDIO_MP3_STATUS_INFO_MSG     (0x0017 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      #define AUDIO_DRIVER_STATUS_INFO_MSG  (0x0018 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      #define AUDIO_MP3_STATUS_BAR          (0x0020 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
     



      typedef struct
      {
        T_RV_HDR os_hdr;
        INT8     status;
      } T_AUDIO_MP3_STATUS;

      /* Progress Bar */
      typedef struct
      {
        T_RV_HDR os_hdr;
        INT8     status;
        UINT32  u32TotalTimePlayed;
        UINT32 u32totalTimeEst;
      } T_AUDIO_MP3_STATUS_BAR;


      /* Prototype */
      T_AUDIO_RET audio_mp3_stop(UINT32 *size_played);
      T_AUDIO_RET audio_mp3_pause(void);
      T_AUDIO_RET audio_mp3_resume(void);
      T_AUDIO_RET audio_mp3_info(void);
      int audio_mp3_populate_files(char **file_names, int max_files_count);
      T_AUDIO_RET audio_mp3_forward(UINT32 skip_time);//MP3-FR
      T_AUDIO_RET audio_mp3_rewind(UINT32 skip_time);//MP3-FR

      T_AUDIO_RET audio_vm_amr_forward(UINT32 forward_skip_time); 
	  T_AUDIO_RET audio_vm_amr_rewind(UINT32 rewind_skip_time);


      T_AUDIO_RET audio_driver_init_mp3_session(T_AUDIO_DRIVER_PARAMETER *p_driver_parameter, T_RV_RETURN return_path);

            /******************************* AAC REGISTRATION *****************************/
      /* Definition of the maximum size of the path name */
      #define AUDIO_AAC_PATH_NAME_MAX_SIZE    (80)    /*      (20)  */

      /* Definition of the channel configuration */
      #define AUDIO_AAC_MONO        (0)
      #define AUDIO_AAC_STEREO      (1)

      /* Definition of the AAC format */
      #define AUDIO_AAC_ADIF        (0)
      #define AUDIO_AAC_ADTS        (1)

      /* AAC Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR      aac_name[AUDIO_AAC_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#else
		char      aac_name[AUDIO_AAC_PATH_NAME_MAX_SIZE]; /* File name of the melody */
#endif
        BOOLEAN   mono_stereo;      /* channel configuration */
        UINT32    size_file_start;  /* size of the file where the melody must start */
        BOOLEAN   play_bar_on;   /* set to zero to switch off the playbar */
      } T_AUDIO_AAC_PARAMETER;

      /* Ext Prototype */
	    T_AUDIO_RET audio_aac_start( T_AUDIO_AAC_PARAMETER *p_parameter,
										               T_RV_RETURN return_path);
      /* Event return */
      #define AUDIO_AAC_STATUS_MSG              (0x0019 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      #define AUDIO_AAC_STATUS_INFO_MSG         (0x001A | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      #define AUDIO_DRIVER_STATUS_AAC_INFO_MSG  (0x001B | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      #define AUDIO_AAC_STATUS_BAR              (0x0021 | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)

      /* AAC Status */
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT32     status;
        UINT8     aac_format;
      } T_AUDIO_AAC_STATUS;


      //progress bar
      typedef struct
      {
        T_RV_HDR os_hdr;
        INT8     status;
        UINT32  u32TotalTimePlayed;
        UINT16 u16totalTimeEst;
      } T_AUDIO_AAC_STATUS_BAR;

      typedef struct
      {
        UINT32    size_file_start;  /* size of the file where the melody must start */
      } T_AUDIO_AAC_RESTART_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_aac_stop(UINT32 *size_played);
      T_AUDIO_RET audio_aac_pause(void);
      T_AUDIO_RET audio_aac_resume(void);
      T_AUDIO_RET audio_aac_info(void);
      T_AUDIO_RET audio_aac_restart (UINT32 size_file_restart);

      T_AUDIO_RET audio_driver_init_aac_session(T_AUDIO_DRIVER_PARAMETER *p_driver_parameter, T_RV_RETURN return_path);

	  /*************VOICE MEMO PCM REGISTRATION******************************/
/*VENKAT*/
//#if (L1_PCM_EXTRACTION == 1)
	   /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#else
		char memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#endif
        UINT32  memo_duration;    /* maximum duration of the voice memo */
        UINT16  speaker_gain;  /* play gain applied to speaker. Sent as upload_ul_gain to L1*/
        UINT16  network_gain;     /* play gain applied to play to the network voice. Sent as upload_dl_gain to L1*/
      } T_AUDIO_VM_PCM_PLAY_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_vm_pcm_play_start(T_AUDIO_VM_PCM_PLAY_PARAMETER *p_parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_VM_PCM_PLAY_STATUS_MSG              (0x001C | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR   os_hdr;
        INT8      status;
      } T_AUDIO_VM_PCM_PLAY_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_vm_pcm_play_stop (T_RV_RETURN return_path);

      /* ---------------------------- */
      /*     Voice memo RECORD        */
      /* ---------------------------- */


      /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#else
		char    memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#endif
        UINT32  memo_duration;    /* maximum duration of the voice memo */
        UINT16  microphone_gain;  /* recording gain applies to microphone. Sent as upload_ul_gain to L1*/
        UINT16  network_gain;     /* gain applies to the network voice. Sent as upload_dl_gain to L1*/
      } T_AUDIO_VM_PCM_RECORD_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_vm_pcm_record_start( T_AUDIO_VM_PCM_RECORD_PARAMETER *p_record_parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_VM_PCM_RECORD_STATUS_MSG              (0x001D | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
        UINT16    recorded_duration;
      } T_AUDIO_VM_PCM_RECORD_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_vm_pcm_record_stop (T_RV_RETURN return_path);
	  /*!VENKAT*/

	  /*************VOICE Buffering on PCM REGISTRATION******************************/
/*VENKAT*/
	   /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#else
		char memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#endif
        UINT32  memo_duration;    /* maximum duration of the voice memo */
        UINT16  speaker_gain;  /* play gain applied to speaker. Sent as upload_ul_gain to L1*/
        UINT16  network_gain;     /* play gain applied to play to the network voice. Sent as upload_dl_gain to L1*/
      } T_AUDIO_VBUF_PCM_PLAY_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_voice_buffering_pcm_play_start(T_AUDIO_VBUF_PCM_PLAY_PARAMETER *p_parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_VBUF_PCM_PLAY_STATUS_MSG              (0x001E | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)
      typedef struct
      {
        T_RV_HDR   os_hdr;
        INT8      status;
      } T_AUDIO_VBUF_PCM_PLAY_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_voice_buffering_pcm_play_stop (T_RV_RETURN return_path);

       T_AUDIO_RET audio_set_file_delete_property(UINT8 file_stat );
 
      
      


      /* ---------------------------- */
      /*     Voice memo RECORD        */
      /* ---------------------------- */

      /* Parameters */
      typedef struct
      {
#if(AS_RFS_API == 1)
		T_WCHAR memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#else
		char    memo_name[AUDIO_PATH_NAME_MAX_SIZE]; /* File name of the Voice Memo play */
#endif
        UINT32  memo_duration;    /* maximum duration of the voice memo */
        UINT16  microphone_gain;  /* recording gain applies to microphone. Sent as upload_ul_gain to L1*/
        UINT16  network_gain;     /* gain applies to the network voice. Sent as upload_dl_gain to L1*/
      } T_AUDIO_VBUF_PCM_RECORD_PARAMETER;

      /* Prototype */
      T_AUDIO_RET audio_voice_buffering_pcm_record_start( T_AUDIO_VBUF_PCM_RECORD_PARAMETER *p_record_parameter,
                                         T_RV_RETURN return_path);

      /* Event return */
      #define AUDIO_VBUF_PCM_RECORD_STATUS_MSG              (0x001F | AUDIO_EVENT_EXTERN | AUDIO_EVENTS_MASK)

#if 0
   typedef struct
      {
        BOOLEAN  delete_file_after_play;     /* In voice buffering voice file in flash can be deleted before or after completion of playing this file
										0 - delete now; 1 - delete after completion of play*/
      } T_AUDIO_VBUF_PCM_RECORD_STOP_PARAMETER;
#endif //#if 0
      typedef struct
      {
        T_RV_HDR  os_hdr;
        INT8      status;
        UINT16    recorded_duration;
      } T_AUDIO_VBUF_PCM_RECORD_STATUS;

      /* Prototype */
      T_AUDIO_RET audio_voice_buffering_pcm_record_stop (/*T_AUDIO_VBUF_PCM_RECORD_STOP_PARAMETER* p_parameter,*/T_RV_RETURN return_path);
	  /*!VENKAT*/
//#endif //#if (L1_PCM_EXTRACTION == 1)

typedef struct
      {
BOOL connected_status;
      } T_AUDIO_BT_PARAMETER;

/*Prototype*/
T_AUDIO_RET  audio_bt_cfg(T_AUDIO_BT_PARAMETER *p_parameter ,T_RV_RETURN return_path);


    #ifdef __cplusplus
      }
    #endif

  #endif /* __AUDIO_API_H_ */



