#ifndef _MMI_MENU_H_
#define _MMI_MENU_H_ 1

/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	Basic MMI                                                      
 $Project code:	BMI (6349)                                                           
 $Module:		Menus
 $File:		    MmiMenu.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		    25/10/00                                                      
                                                                               
********************************************************************************
                                                                              
 Description:

    This provides the implementation of the main menu handling for the basic
	MMI
                        
********************************************************************************
 $History: MmiMenu.h

	25/10/00			Original Condat(UK) BMI version.	
	   
 $End

*******************************************************************************/


/*******************************************************************************
                                                                              
                                Public Definitions
                                                                              
*******************************************************************************/

#define ALLOC_MEMORY mfwAlloc
#define FREE_MEMORY  mfwFree


typedef void ( *SimMenuFunc )( MfwHnd window );


/* Reason definitions
*/
// RAVI - COMMENTED - NOT USED IN ANY PLACE - 24-11-2005
//typedef enum
//{
//	MenuNone = MenuDummy,           /* no reason                */
//	MenuNormal,                     /* normal menu mode         */
//	MenuDone                        /* done with menu           */
//};


/* How is the menu being accessed
*/
//typedef enum
//{
//	MenuAccess,
//	HotKeyAccess
//};


/*******************************************************************************
                                                                              
                                Public Prototypes
                                                                              
*******************************************************************************/

/* Standard menu initialise, exit and handler routines
*/
void menuInit( MfwHnd parent );
void menuExit( void );
void menuEnter( void );


/* Following functinos are provided to allow dynamic menu
   construction tables to be generated by other modules
*/
EXTERN USHORT item_flag_none( struct MfwMnuTag * m, struct MfwMnuAttrTag * ma, struct MfwMnuItemTag * mi );
//xpradipg - Aug 4:changes for WAP2.0 Menu
EXTERN USHORT item_flag_WAP_2_0( struct MfwMnuTag * m, struct MfwMnuAttrTag * ma, struct MfwMnuItemTag * mi );
EXTERN USHORT item_flag_hide( T_MFW_MNU * m, T_MFW_MNU_ATTR * ma, T_MFW_MNU_ITEM * mi );
EXTERN int menuSimItemCallback( MfwMnu* m, MfwMnuItem* i );


/* Display the soft keys associated with the menu window
*/
void showMenuSoftkeys( void );


/* Returns 1 if the menu window has the focus, else returns 0.
*/
int menuIsFocussed( void );


/* Make the menu window (if it exists) the top window.
*/
void menuRaise( void );


/* If possible go <levels> steps up the menu tree.
*/
void menuPop( int levels );


/* Go to the root level and then exit the main menu in an orderly fasion.
   Can only be called when the user is logically somewhere in the main menu tree,
   e.g. _after_ fully exiting an application invoked by the main menu, and
   this includes DYI sub-menu(tree)s of the main menu.
*/
void menuDropOut( void );


/* Unhides the SIM toolkit menu item, using <label> as the label.
   If <label> is NULL, the default label is used.
   If the SIM toolkit menu item is invoked by the user, <simCallback>
   gets called with argument <simWindow>, unless <simCallback> is NULL.
*/
void menuEnableSimMenu( char *label, SimMenuFunc simCallback, MfwHnd simWindow );


/* Hides the SIM toolkit menu item.
*/
void menuDisableSimMenu( void );

/* From where was the menu accessed?
*/
void menuAccessFrom( U8 source );


/*******************************************************************************
                                                                              
                                Developmental
                                                                              
*******************************************************************************/

/* Following definitions are provided for development use only
*/
#ifdef MMI_UNDER_DEVELOPMENT

int  mmiMenuNotImplemented( MfwMnu* m, MfwMnuItem* i );
void mmiMenuNotImplementedCB( T_MFW_HND win, UBYTE identifier, UBYTE reason );

#endif



/*******************************************************************************
                                                                              
                                End of File
                                                                              
*******************************************************************************/

#endif

