/*
+--------------------------------------------------------------------------+
| PROJECT : PROTOCOL STACK                                                 |
| FILE    : p_rrgrr.h                                                      |
| SOURCE  : "__out__\LNX_TI_cgt2_70\rel_n5_camera_micron\cdginc\condat\ms\doc\sap\rrgrr.pdf"                   |
| LastModified : "2003-11-19"                                              |
| IdAndVersion : "8441.112.03.031"                                         |
| SrcFileTime  : "Thu Nov 29 09:52:28 2007"                                |
| Generated by CCDGEN_2.5.5A on Wed Mar 11 09:58:59 2009                   |
|           !!DO NOT MODIFY!!DO NOT MODIFY!!DO NOT MODIFY!!                |
+--------------------------------------------------------------------------+
*/

/* PRAGMAS
 * PREFIX                 : NONE
 * COMPATIBILITY_DEFINES  : NO (require PREFIX)
 * ALWAYS_ENUM_IN_VAL_FILE: NO
 * ENABLE_GROUP: NO
 * CAPITALIZE_TYPENAME: NO
 */


#ifndef P_RRGRR_H
#define P_RRGRR_H


#define CDG_ENTER__P_RRGRR_H

#define CDG_ENTER__FILENAME _P_RRGRR_H
#define CDG_ENTER__P_RRGRR_H__FILE_TYPE CDGINC
#define CDG_ENTER__P_RRGRR_H__LAST_MODIFIED _2003_11_19
#define CDG_ENTER__P_RRGRR_H__ID_AND_VERSION _8441_112_03_031

#define CDG_ENTER__P_RRGRR_H__SRC_FILE_TIME _Thu_Nov_29_09_52_28_2007

#include "CDG_ENTER.h"

#undef CDG_ENTER__P_RRGRR_H

#undef CDG_ENTER__FILENAME


#include "p_rrgrr.val"

#include "p_mph.h"

#ifndef __T_si_states__
#define __T_si_states__
/*
 * States of the SI
 * CCDGEN:WriteStruct_Count==2915
 */
typedef struct
{
  U8                        si1_state;                /*<  0:  1> SI1 states                                         */
  U8                        si3_state;                /*<  1:  1> SI3 states                                         */
  U8                        si13_state;               /*<  2:  1> SI13 states                                        */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_si_states;
#endif

#ifndef __T_non_gprs__
#define __T_non_gprs__
/*
 * Non-GPRS parameters
 * CCDGEN:WriteStruct_Count==2916
 */
typedef struct
{
  U8                        v_non_gprs;               /*<  0:  1> Valid flag for non GPRS                            */
  U8                        att;                      /*<  1:  1> Attach/detach allowed                              */
  U8                        v_T3212;                  /*<  2:  1> Valid flag for T3212                               */
  U8                        T3212;                    /*<  3:  1> T3212 value                                        */
  U8                        neci;                     /*<  4:  1> Half rate support                                  */
  U8                        pwrc;                     /*<  5:  1> Power control indicator                            */
  U8                        dtx;                      /*<  6:  1> DTX indicator                                      */
  U8                        radio_link_timeout;       /*<  7:  1> Supervisory timer for RR connection                */
  U8                        bs_ag_blks_res;           /*<  8:  1> Number of blocks reserved for access grant         */
  U8                        ccch_conf;                /*<  9:  1> Physical channel configuration for CCCH            */
  U8                        bs_pa_mfrms;              /*< 10:  1> Paging Channel configuration                       */
  U8                        max_retrans;              /*< 11:  1> Maximum number of retransmissions                  */
  U8                        tx_integer;               /*< 12:  1> Number of slots to spread transmission             */
  U8                        ec;                       /*< 13:  1> Emergency call allowed                             */
  U8                        gprs_ms_txpwr_max_cch;    /*< 14:  1> GPRS_MS_TXPWR_MAX_CCH                              */
// ELEM-FF: REL99 
  U8                        ecsc;                     /*< 15:  1> Early Classmark sending flag in PSI2               */
} T_non_gprs;
#endif

#ifndef __T_ext_ie__
#define __T_ext_ie__
/*
 * Possible future extension
 * CCDGEN:WriteStruct_Count==2917
 */
typedef struct
{
  U8                        ext_len;                  /*<  0:  1> Extension length                                   */
  U8                        spare_bit[8];             /*<  1:  8> Spare bit (val(ext_len)+1)                         */
  U8                        _align0;                  /*<  9:  1> alignment                                          */
  U8                        _align1;                  /*< 10:  1> alignment                                          */
  U8                        _align2;                  /*< 11:  1> alignment                                          */
} T_ext_ie;
#endif

#ifndef __T_emlpp_prio__
#define __T_emlpp_prio__
/*
 * eMLPP_PRIORITY
 * CCDGEN:WriteStruct_Count==2918
 */
typedef struct
{
  U8                        v_emlpp;                  /*<  0:  1> Valid flag                                         */
  U8                        emlpp;                    /*<  1:  1> Value of emlpp_prio                                */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_emlpp_prio;
#endif

#ifndef __T_p_chan_req_des__
#define __T_p_chan_req_des__
/*
 * Requested channel characteristics
 * CCDGEN:WriteStruct_Count==2919
 */
typedef struct
{
  U8                        mo_mt;                    /*<  0:  1> MO/MT FALG                                         */
  U8                        prio;                     /*<  1:  1> Priority                                           */
  U8                        rlc_mode_req;             /*<  2:  1> RLC Mode                                           */
  U8                        llc_type;                 /*<  3:  1> LLC Frame Type                                     */
  U16                       req_bwd;                  /*<  4:  2> Requested Bandwidth                                */
  U16                       rlc_octets;               /*<  6:  2> RLC Octet Count                                    */
} T_p_chan_req_des;
#endif

#ifndef __T_gprs_meas_results__
#define __T_gprs_meas_results__
/*
 * GPRS Measurement Results
 * CCDGEN:WriteStruct_Count==2920
 */
typedef struct
{
  U8                        c_value;                  /*<  0:  1> C_Value                                            */
  U8                        rxqual;                   /*<  1:  1> Rx Quality                                         */
  U8                        sign_var;                 /*<  2:  1> Signal Variance                                    */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_gprs_meas_results;
#endif

#ifndef __T_sync_result__
#define __T_sync_result__
/*
 * Results of Synchronisation Attempts
 * CCDGEN:WriteStruct_Count==2921
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        sb_flag;                  /*<  2:  1> synchronisation burst flag                         */
  U8                        bsic;                     /*<  3:  1> base station identification code                   */
} T_sync_result;
#endif

#ifndef __T_rm_freq_list__
#define __T_rm_freq_list__
/*
 * frequencies to be removed
 * CCDGEN:WriteStruct_Count==2922
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        bsic;                     /*<  2:  1> base station identification code                   */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_rm_freq_list;
#endif

#ifndef __T_meas_res__
#define __T_meas_res__
/*
 * measurements ordered by the network
 * CCDGEN:WriteStruct_Count==2923
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        bsic;                     /*<  2:  1> base station identification code                   */
  U8                        rxlev;                    /*<  3:  1> receive signal strength level                      */
} T_meas_res;
#endif

#ifndef __T_arfcn_idx__
#define __T_arfcn_idx__
/*
 * Channel number and a associated index
 * CCDGEN:WriteStruct_Count==2924
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        idx;                      /*<  2:  1> index                                              */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_arfcn_idx;
#endif

#ifndef __T_xmeas_res__
#define __T_xmeas_res__
/*
 * results of the extended measurement
 * CCDGEN:WriteStruct_Count==2925
 */
typedef struct
{
  T_arfcn_idx               arfcn_idx;                /*<  0:  4> Channel number and a associated index              */
  U8                        rxlev;                    /*<  4:  1> receive signal strength level                      */
  U8                        bsic;                     /*<  5:  1> base station identification code                   */
  U8                        _align0;                  /*<  6:  1> alignment                                          */
  U8                        _align1;                  /*<  7:  1> alignment                                          */
} T_xmeas_res;
#endif

#ifndef __T_plmn__
#define __T_plmn__
/*
 * PLMN identification
 * CCDGEN:WriteStruct_Count==2926
 */
typedef struct
{
  U8                        v_plmn;                   /*<  0:  1> Valid Flag                                         */
  U8                        mcc[SIZE_MCC];            /*<  1:  3> Mobile Country Code                                */
  U8                        mnc[SIZE_MNC];            /*<  4:  3> Mobile Network Code                                */
  U8                        _align0;                  /*<  7:  1> alignment                                          */
} T_plmn;
#endif

#ifndef __T_rai__
#define __T_rai__
/*
 * routing area identifier
 * CCDGEN:WriteStruct_Count==2927
 */
typedef struct
{
  T_plmn                    plmn;                     /*<  0:  8> PLMN identification                                */
  U16                       lac;                      /*<  8:  2> location area code                                 */
  U8                        rac;                      /*< 10:  1> routing are code                                   */
  U8                        _align0;                  /*< 11:  1> alignment                                          */
} T_rai;
#endif

#ifndef __T_task__
#define __T_task__
/*
 * Task
 * CCDGEN:WriteStruct_Count==2928
 */
typedef union
{
  U8                        v_stop_ccch;              /*<  0:  1> Indicates whether CCCH shall be stopped            */
  U8                        v_pim_pbcch;              /*<  0:  1> pim                                                */
  U8                        v_pam_pbcch;              /*<  0:  1> pam                                                */
  U8                        v_ptm_pbcch;              /*<  0:  1> ptm                                                */
} T_task;
#endif

#ifndef __T_rr_cell_env__
#define __T_rr_cell_env__
/*
 * current location of the mobile equipment
 * CCDGEN:WriteStruct_Count==2929
 */
typedef struct
{
  T_plmn                    plmn;                     /*<  0:  8> PLMN identification                                */
  U16                       lac;                      /*<  8:  2> location area code                                 */
  U16                       cid;                      /*< 10:  2> cell identification                                */
} T_rr_cell_env;
#endif

#ifndef __T_serving_cell_info__
#define __T_serving_cell_info__
/*
 * Cell information
 * CCDGEN:WriteStruct_Count==2930
 */
typedef struct
{
  U8                        gprs_rxlev_access_min;    /*<  0:  1> GPRS_RXLEV_ACCESS_MIN                              */
  U8                        gprs_ms_txpwr_max_cch;    /*<  1:  1> GPRS_MS_TXPWR_MAX_CCH                              */
  U16                       bcch_arfcn;               /*<  2:  2> Frequency of BCCH                                  */
  U8                        bcch_bsic;                /*<  4:  1> BSIC of BCCH                                       */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U16                       ac_class;                 /*<  6:  2> Access class for RACH                              */
  U8                        pwr_offset;               /*<  8:  1> Power offset                                       */
  U8                        _align1;                  /*<  9:  1> alignment                                          */
  U8                        _align2;                  /*< 10:  1> alignment                                          */
  U8                        _align3;                  /*< 11:  1> alignment                                          */
  T_rr_cell_env             rr_cell_env;              /*< 12: 12> current location of the mobile equipment           */
  U8                        limited;                  /*< 24:  1> Limited service                                    */
  U8                        bs_pa_mfrms;              /*< 25:  1> Paging Channel configuration                       */
  U16                       arfcn[RRGRR_BA_LIST_SIZE]; /*< 26: 64> channel number                                     */
// ELEM-FF: REL99 AND TI_PS_FF_EMR 
  U8                        ba_ind;                   /*< 90:  1> BA_IND used by RR for neighbor cell list           */
  U8                        _align4;                  /*< 91:  1> alignment                                          */
} T_serving_cell_info;
#endif


// STRUCT-FF: REL99 AND TI_PS_FF_EMR 
#ifndef __T_nc_para_struct__
#define __T_nc_para_struct__
/*
 * Network control parameters
 * CCDGEN:WriteStruct_Count==2931
 */
typedef struct
{
// ELEM-FF: REL99 AND TI_PS_FF_EMR 
  U8                        nco;                      /*<  0:  1> Network control order, values same as enum T_NC_ORDER in grr.h */
// ELEM-FF: REL99 AND TI_PS_FF_EMR 
  U8                        is_valid;                 /*<  1:  1> Indicates whether NC parameters following are valid */
// ELEM-FF: REL99 AND TI_PS_FF_EMR 
  U8                        nc_non_drx;               /*<  2:  1> minimum time the mobile station shall stay in non-DRX mode after an NC-measurement report  */
// ELEM-FF: REL99 AND TI_PS_FF_EMR 
  U8                        nc_rep_per_i;             /*<  3:  1> Time period for cell reselection measurement reporting for packet idle mode (I)  */
// ELEM-FF: REL99 AND TI_PS_FF_EMR 
  U8                        nc_rep_per_t;             /*<  4:  1> Time period for cell reselection measurement reporting for packet transfer mode (T)  */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U8                        _align1;                  /*<  6:  1> alignment                                          */
  U8                        _align2;                  /*<  7:  1> alignment                                          */
} T_nc_para_struct;
#endif

#ifndef __T_cr_par__
#define __T_cr_par__
/*
 * GPRS Cell Selection Parameter
 * CCDGEN:WriteStruct_Count==2932
 */
typedef struct
{
  U8                        cell_bar_access_2;        /*<  0:  1> CELL_BAR_ACCESS_2                                  */
  U8                        exc_acc;                  /*<  1:  1> EXC_ACC                                            */
  U8                        same_ra_as_serving_cell;  /*<  2:  1> SAME_RA_AS_SERVING_CELL                            */
  U8                        gprs_rxlev_access_min;    /*<  3:  1> GPRS_RXLEV_ACCESS_MIN                              */
  U8                        gprs_ms_txpwr_max_cch;    /*<  4:  1> GPRS_MS_TXPWR_MAX_CCH                              */
  U8                        gprs_temporary_offset;    /*<  5:  1> GPRS_TEMPORARY_OFFSET                              */
  U8                        gprs_penalty_time;        /*<  6:  1> GPRS_PENALTY_TIME                                  */
  U8                        gprs_reselect_offset;     /*<  7:  1> GPRS_RESELECT_OFFSET                               */
  U8                        priority_class;           /*<  8:  1> PRIORITY_CLASS                                     */
  U8                        hcs_thr;                  /*<  9:  1> HCS_THR                                            */
  U8                        si13_location;            /*< 10:  1> SI13 Location                                      */
  U8                        pbcch_location;           /*< 11:  1> PBCCH_LOCATION                                     */
  U8                        psi1_repeat_period;       /*< 12:  1> PSI1_REPEAT_PERIOD                                 */
  U8                        _align0;                  /*< 13:  1> alignment                                          */
  U8                        _align1;                  /*< 14:  1> alignment                                          */
  U8                        _align2;                  /*< 15:  1> alignment                                          */
} T_cr_par;
#endif

#ifndef __T_add_freq_list__
#define __T_add_freq_list__
/*
 * BA list
 * CCDGEN:WriteStruct_Count==2933
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        bsic;                     /*<  2:  1> base station identification code                   */
  U8                        v_cr_par;                 /*<  3:  1> Valid Flag for GPRS Cell Selection Parameter       */
  T_cr_par                  cr_par;                   /*<  4: 16> GPRS Cell Selection Parameter                      */
} T_add_freq_list;
#endif


// STRUCT-FF: REL99 AND TI_PS_FF_RTD 
#ifndef __T_ncell_sync_list__
#define __T_ncell_sync_list__
/*
 * List of neighbourcell that needs to be synchronised.
 * CCDGEN:WriteStruct_Count==2934
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        v_rtd;                    /*<  2:  1> valid-flag                                         */
  U8                        c_rtd;                    /*<  3:  1> counter                                            */
  U16                       rtd[MAX_NUM_OF_RTD_VALUES]; /*<  4:  6> Real time difference value for all the neighbour cells */
  U8                        _align0;                  /*< 10:  1> alignment                                          */
  U8                        _align1;                  /*< 11:  1> alignment                                          */
} T_ncell_sync_list;
#endif


/*
 * End of substructure section, begin of primitive definition section
 */

#ifndef __T_RRGRR_GPRS_SI13_IND__
#define __T_RRGRR_GPRS_SI13_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2941
 */
typedef struct
{
  U8                        cause;                    /*<  0:  1> Cause                                              */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_si_states               si_states;                /*<  4:  4> States of the SI                                   */
  T_serving_cell_info       serving_cell_info;        /*<  8: 92> Cell information                                   */
  T_sdu                     sdu;                      /*<100: ? > service data unit                                  */
} T_RRGRR_GPRS_SI13_IND;
#endif

#ifndef __T_RRGRR_PACKET_PAGING_IND__
#define __T_RRGRR_PACKET_PAGING_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2942
 */
typedef struct
{
  U8                        pg_type;                  /*<  0:  1> The type of paging                                 */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_PACKET_PAGING_IND;
#endif

#ifndef __T_RRGRR_CHANNEL_REQ__
#define __T_RRGRR_CHANNEL_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2943
 */
typedef struct
{
  U8                        req_data;                 /*<  0:  1>                                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_CHANNEL_REQ;
#endif

#ifndef __T_RRGRR_IA_IND__
#define __T_RRGRR_IA_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2944
 */
typedef struct
{
  U32                       fn;                       /*<  0:  4> Frame Number                                       */
  U8                        r_bit;                    /*<  4:  1> retry bit                                          */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U8                        _align1;                  /*<  6:  1> alignment                                          */
  U8                        _align2;                  /*<  7:  1> alignment                                          */
  T_sdu                     sdu;                      /*<  8: ? > service data unit                                  */
} T_RRGRR_IA_IND;
#endif

#ifndef __T_RRGRR_IAEXT_IND__
#define __T_RRGRR_IAEXT_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2945
 */
typedef struct
{
  U8                        ia_index;                 /*<  0:  1> indicates valid parts of the Imm Ass Ext msg       */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  U32                       fn;                       /*<  4:  4> Frame Number                                       */
  U8                        r_bit;                    /*<  8:  1> retry bit                                          */
  U8                        _align3;                  /*<  9:  1> alignment                                          */
  U8                        _align4;                  /*< 10:  1> alignment                                          */
  U8                        _align5;                  /*< 11:  1> alignment                                          */
  T_sdu                     sdu;                      /*< 12: ? > service data unit                                  */
} T_RRGRR_IAEXT_IND;
#endif

#ifndef __T_RRGRR_ASSIGNMENT_REJ_IND__
#define __T_RRGRR_ASSIGNMENT_REJ_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2946
 */
typedef struct
{
  U8                        wait_ind;                 /*<  0:  1> wait indication (T3122)                            */
  U8                        r_bit;                    /*<  1:  1> retry bit                                          */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_RRGRR_ASSIGNMENT_REJ_IND;
#endif

#ifndef __T_RRGRR_DATA_IND__
#define __T_RRGRR_DATA_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2947
 */
typedef struct
{
  U32                       fn;                       /*<  0:  4> Frame Number                                       */
  T_sdu                     sdu;                      /*<  4: ? > service data unit                                  */
} T_RRGRR_DATA_IND;
#endif

#ifndef __T_RRGRR_DATA_REQ__
#define __T_RRGRR_DATA_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2948
 */
typedef struct
{
  T_sdu                     sdu;                      /*<  0: ? > service data unit                                  */
} T_RRGRR_DATA_REQ;
#endif

#ifndef __T_RRGRR_IA_DOWNLINK_IND__
#define __T_RRGRR_IA_DOWNLINK_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2949
 */
typedef struct
{
  U32                       fn;                       /*<  0:  4> Frame Number                                       */
  U8                        r_bit;                    /*<  4:  1> retry bit                                          */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U8                        _align1;                  /*<  6:  1> alignment                                          */
  U8                        _align2;                  /*<  7:  1> alignment                                          */
  T_sdu                     sdu;                      /*<  8: ? > service data unit                                  */
} T_RRGRR_IA_DOWNLINK_IND;
#endif

#ifndef __T_RRGRR_START_MON_CCCH_REQ__
#define __T_RRGRR_START_MON_CCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2950
 */
typedef struct
{
  U8                        pag_mode;                 /*<  0:  1> Paging Mode                                        */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       split_pg;                 /*<  2:  2> Split paging cycle (the value, NOT the code)       */
} T_RRGRR_START_MON_CCCH_REQ;
#endif

#ifndef __T_RRGRR_STOP_MON_CCCH_REQ__
#define __T_RRGRR_STOP_MON_CCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2951
 */
typedef struct
{
  U8                        is_pbcch_present;         /*<  0:  1> Indicates whether PBCCH is present or not          */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_STOP_MON_CCCH_REQ;
#endif

#ifndef __T_RRGRR_CR_REQ__
#define __T_RRGRR_CR_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2952
 */
typedef struct
{
  U8                        cr_type;                  /*<  0:  1> Cell re-selection mode                             */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       arfcn;                    /*<  2:  2> channel number                                     */
  U8                        bsic;                     /*<  4:  1> base station identification code                   */
  U8                        _align1;                  /*<  5:  1> alignment                                          */
  U8                        _align2;                  /*<  6:  1> alignment                                          */
  U8                        _align3;                  /*<  7:  1> alignment                                          */
} T_RRGRR_CR_REQ;
#endif

#ifndef __T_RRGRR_START_MON_BCCH_REQ__
#define __T_RRGRR_START_MON_BCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2953
 */
typedef struct
{
  U8                        si_to_read;               /*<  0:  1> SI to read                                         */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_START_MON_BCCH_REQ;
#endif

#ifndef __T_RRGRR_RR_EST_REQ__
#define __T_RRGRR_RR_EST_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2954
 */
typedef struct
{
  T_non_gprs                non_gprs;                 /*<  0: 16> Non-GPRS parameters                                */
  U8                        ch_needed;                /*< 16:  1> Channel needed field                               */
  U8                        ident_type;               /*< 17:  1> Identity type                                      */
  U8                        _align0;                  /*< 18:  1> alignment                                          */
  U8                        _align1;                  /*< 19:  1> alignment                                          */
  T_emlpp_prio              emlpp_prio;               /*< 20:  4> eMLPP_PRIORITY                                     */
  U8                        susp_req;                 /*< 24:  1> Send GPRS suspension request flag                  */
  U8                        _align2;                  /*< 25:  1> alignment                                          */
  U8                        _align3;                  /*< 26:  1> alignment                                          */
  U8                        _align4;                  /*< 27:  1> alignment                                          */
} T_RRGRR_RR_EST_REQ;
#endif

#ifndef __T_RRGRR_RR_EST_RSP__
#define __T_RRGRR_RR_EST_RSP__
/*
 * 
 * CCDGEN:WriteStruct_Count==2955
 */
typedef struct
{
  U8                        rr_est;                   /*<  0:  1> Allowance of RR establishment                      */
  U8                        susp_req;                 /*<  1:  1> Send GPRS suspension request flag                  */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_RRGRR_RR_EST_RSP;
#endif

#ifndef __T_RRGRR_RR_EST_IND__
#define __T_RRGRR_RR_EST_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2956
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_RR_EST_IND;
#endif

#ifndef __T_RRGRR_ACTIVATE_REQ__
#define __T_RRGRR_ACTIVATE_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2957
 */
typedef struct
{
  T_non_gprs                non_gprs;                 /*<  0: 16> Non-GPRS parameters                                */
  U8                        susp_req;                 /*< 16:  1> Send GPRS suspension request flag                  */
  U8                        rac;                      /*< 17:  1> routing are code                                   */
  U8                        _align0;                  /*< 18:  1> alignment                                          */
  U8                        _align1;                  /*< 19:  1> alignment                                          */
} T_RRGRR_ACTIVATE_REQ;
#endif

#ifndef __T_RRGRR_GPRS_DATA_REQ__
#define __T_RRGRR_GPRS_DATA_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2958
 */
typedef struct
{
  U32                       old_ptmsi;                /*<  0:  4> Packet Temporary Mobile Subsciber Identity         */
  U32                       new_ptmsi;                /*<  4:  4> Packet Temporary Mobile Subsciber Identity         */
  U32                       tlli;                     /*<  8:  4> temporary logical link identifier                  */
  T_p_chan_req_des          p_chan_req_des;           /*< 12:  8> Requested channel characteristics                  */
  T_gprs_meas_results       gprs_meas_results;        /*< 20:  4> GPRS Measurement Results                           */
  U8                        mac_req;                  /*< 24:  1> MAC mode request                                   */
  U8                        cs_req;                   /*< 25:  1> Channel Coding Schemme Request                     */
  U8                        _align0;                  /*< 26:  1> alignment                                          */
  U8                        _align1;                  /*< 27:  1> alignment                                          */
  T_rai                     rai;                      /*< 28: 12> routing area identifier                            */
} T_RRGRR_GPRS_DATA_REQ;
#endif

#ifndef __T_RRGRR_SUSPEND_DCCH_REQ__
#define __T_RRGRR_SUSPEND_DCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2959
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_SUSPEND_DCCH_REQ;
#endif

#ifndef __T_RRGRR_SUSPEND_DCCH_CNF__
#define __T_RRGRR_SUSPEND_DCCH_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2960
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_SUSPEND_DCCH_CNF;
#endif

#ifndef __T_RRGRR_RECONNECT_DCCH_REQ__
#define __T_RRGRR_RECONNECT_DCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2961
 */
typedef struct
{
  U8                        reconn_cause;             /*<  0:  1> Cause for the reconnection, refer to causes sent with ASSIGNMENT FAILURE [3] */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_RECONNECT_DCCH_REQ;
#endif

#ifndef __T_RRGRR_RECONNECT_DCCH_CNF__
#define __T_RRGRR_RECONNECT_DCCH_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2962
 */
typedef struct
{
  U8                        reconn_state;             /*<  0:  1> Indicates that the reconnection was successful or not */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_RECONNECT_DCCH_CNF;
#endif

#ifndef __T_RRGRR_RESUMED_TBF_REQ__
#define __T_RRGRR_RESUMED_TBF_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2963
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_RESUMED_TBF_REQ;
#endif

#ifndef __T_RRGRR_RESUMED_TBF_CNF__
#define __T_RRGRR_RESUMED_TBF_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2964
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_RESUMED_TBF_CNF;
#endif

#ifndef __T_RRGRR_STOP_DCCH_IND__
#define __T_RRGRR_STOP_DCCH_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2965
 */
typedef struct
{
  U8                        stop_cause;               /*<  0:  1> Stop cause                                         */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_STOP_DCCH_IND;
#endif

#ifndef __T_RRGRR_CR_IND__
#define __T_RRGRR_CR_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2966
 */
typedef struct
{
  U8                        cr_type;                  /*<  0:  1> Cell re-selection mode                             */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_CR_IND;
#endif

#ifndef __T_RRGRR_NCELL_SYNC_REQ__
#define __T_RRGRR_NCELL_SYNC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2967
 */
typedef struct
{
// ELEM-FF: !TI_PS_FF_RTD 
//   U16                       arfcn[RRGRR_MAX_ARFCN_NCELL_SYNC_REQ]; /*<  0:  0> channel number                                     */
  U8                        sync_type;                /*<  0:  1> Sync Info indicating the Reconfirm Sync timer status */
// ELEM-FF: REL99 AND TI_PS_FF_RTD 
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_ncell_sync_list         ncell_sync_list[RRGRR_MAX_ARFCN_NCELL_SYNC_REQ]; /*<  4:144> List of neighbourcell that needs to be synchronised. */
} T_RRGRR_NCELL_SYNC_REQ;
#endif

#ifndef __T_RRGRR_NCELL_SYNC_IND__
#define __T_RRGRR_NCELL_SYNC_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2968
 */
typedef struct
{
  T_sync_result             sync_result[RRGRR_MAX_RSLT_NCELL_SYNC_IND]; /*<  0: 48> Results of Synchronisation Attempts                */
} T_RRGRR_NCELL_SYNC_IND;
#endif

#ifndef __T_RRGRR_SYNC_REQ__
#define __T_RRGRR_SYNC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2969
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        bsic;                     /*<  2:  1> base station identification code                   */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_RRGRR_SYNC_REQ;
#endif

#ifndef __T_RRGRR_SYNC_IND__
#define __T_RRGRR_SYNC_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2970
 */
typedef struct
{
  U8                        sync_res;                 /*<  0:  1> Indicates the result of synchronisation            */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_SYNC_IND;
#endif

#ifndef __T_RRGRR_UPDATE_BA_REQ__
#define __T_RRGRR_UPDATE_BA_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2971
 */
typedef struct
{
  U8                        cell_type;                /*<  0:  1> Ncell or Scell                                     */
  U8                        nc_mode;                  /*<  1:  1> NC mode                                            */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  T_add_freq_list           add_freq_list[RRGRR_BA_LIST_SIZE]; /*<  4:640> BA list                                            */
  T_rm_freq_list            rm_freq_list[RRGRR_BA_LIST_SIZE]; /*<644:128> frequencies to be removed                          */
} T_RRGRR_UPDATE_BA_REQ;
#endif

#ifndef __T_RRGRR_MEAS_REP_REQ__
#define __T_RRGRR_MEAS_REP_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2972
 */
typedef struct
{
  U8                        meas_cause;               /*<  0:  1> Basic Element                                      */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_MEAS_REP_REQ;
#endif

#ifndef __T_RRGRR_MEAS_REP_CNF__
#define __T_RRGRR_MEAS_REP_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2973
 */
typedef struct
{
  T_meas_res                meas_res[RRGRR_MEAS_REP_LIST_SIZE]; /*<  0:132> measurements ordered by the network                */
} T_RRGRR_MEAS_REP_CNF;
#endif

#ifndef __T_RRGRR_TBF_ESTABLISHED_REQ__
#define __T_RRGRR_TBF_ESTABLISHED_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2974
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_TBF_ESTABLISHED_REQ;
#endif

#ifndef __T_RRGRR_CR_RSP__
#define __T_RRGRR_CR_RSP__
/*
 * 
 * CCDGEN:WriteStruct_Count==2975
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_CR_RSP;
#endif

#ifndef __T_RRGRR_MS_ID_IND__
#define __T_RRGRR_MS_ID_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2976
 */
typedef struct
{
  U32                       tmsi;                     /*<  0:  4> temporary logical link identifier                  */
} T_RRGRR_MS_ID_IND;
#endif

#ifndef __T_RRGRR_EXT_MEAS_REQ__
#define __T_RRGRR_EXT_MEAS_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2977
 */
typedef struct
{
  U8                        _align0;                  /*<  0:  1> alignment                                          */
  U8                        _align1;                  /*<  1:  1> alignment                                          */
  U8                        _align2;                  /*<  2:  1> alignment                                          */
  U8                        c_arfcn_idx;              /*<  3:  1> counter                                            */
  T_arfcn_idx               arfcn_idx[RRGRR_MAX_ARFCN_EXT_MEAS]; /*<  4:256> Channel number and a associated index              */
  U8                        call_ref;                 /*<260:  1> Call reference ID                                  */
  U8                        report_type;              /*<261:  1> Extended Measurement reporting type                */
  U8                        ncc_permitted;            /*<262:  1> network colour code permission indicator           */
  U8                        _align3;                  /*<263:  1> alignment                                          */
} T_RRGRR_EXT_MEAS_REQ;
#endif

#ifndef __T_RRGRR_EXT_MEAS_CNF__
#define __T_RRGRR_EXT_MEAS_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2978
 */
typedef struct
{
  U8                        _align0;                  /*<  0:  1> alignment                                          */
  U8                        _align1;                  /*<  1:  1> alignment                                          */
  U8                        _align2;                  /*<  2:  1> alignment                                          */
  U8                        c_xmeas_res;              /*<  3:  1> counter                                            */
  T_xmeas_res               xmeas_res[RRGRR_MAX_ARFCN_EXT_MEAS]; /*<  4:512> results of the extended measurement                */
  U8                        call_ref;                 /*<516:  1> Call reference ID                                  */
  U8                        xmeas_cause;              /*<517:  1> indicates the state of the extended measurement results */
  U8                        _align3;                  /*<518:  1> alignment                                          */
  U8                        _align4;                  /*<519:  1> alignment                                          */
} T_RRGRR_EXT_MEAS_CNF;
#endif

#ifndef __T_RRGRR_EXT_MEAS_STOP_REQ__
#define __T_RRGRR_EXT_MEAS_STOP_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2979
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_EXT_MEAS_STOP_REQ;
#endif

#ifndef __T_RRGRR_STOP_TASK_REQ__
#define __T_RRGRR_STOP_TASK_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2980
 */
typedef struct
{
  T_ctrl_task               ctrl_task;                /*<  0:  4> (enum=32bit) controller for union                  */
  T_task                    task;                     /*<  4:  1> Task                                               */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U8                        _align1;                  /*<  6:  1> alignment                                          */
  U8                        _align2;                  /*<  7:  1> alignment                                          */
} T_RRGRR_STOP_TASK_REQ;
#endif

#ifndef __T_RRGRR_STOP_TASK_CNF__
#define __T_RRGRR_STOP_TASK_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2981
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_STOP_TASK_CNF;
#endif

#ifndef __T_RRGRR_START_TASK_REQ__
#define __T_RRGRR_START_TASK_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2982
 */
typedef struct
{
  U8                        state;                    /*<  0:  1> Indicates to RR the state of GRR                   */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_RRGRR_START_TASK_REQ;
#endif

#ifndef __T_RRGRR_START_TASK_CNF__
#define __T_RRGRR_START_TASK_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2983
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_START_TASK_CNF;
#endif

#ifndef __T_RRGRR_STANDBY_STATE_IND__
#define __T_RRGRR_STANDBY_STATE_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2984
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_STANDBY_STATE_IND;
#endif

#ifndef __T_RRGRR_READY_STATE_IND__
#define __T_RRGRR_READY_STATE_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2985
 */
typedef struct
{
  U8                        dummy;                    /*<  0:  1> no parameters                                      */
} T_RRGRR_READY_STATE_IND;
#endif


// PRIM-FF: REL99 
#ifndef __T_RRGRR_CBCH_INFO_IND__
#define __T_RRGRR_CBCH_INFO_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2986
 */
typedef struct
{
  T_cbch                    cbch;                     /*<  0:140> cell broadcast channel (type defined in "p_mph.h") */
} T_RRGRR_CBCH_INFO_IND;
#endif


// PRIM-FF: REL99 AND TI_PS_FF_EMR 
#ifndef __T_RRGRR_SI2QUATER_IND__
#define __T_RRGRR_SI2QUATER_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2987
 */
typedef struct
{
// ELEM-FF: REL99 AND TI_PS_FF_EMR 
  U8                        rep_type;                 /*<  0:  1> Report type                                        */
// ELEM-FF: REL99 AND TI_PS_FF_EMR 
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_enh_para_struct         enh_para_struct;          /*<  4:428> Enhanced measurement parameters (type defined in "p_mph.h") */
// ELEM-FF: REL99 AND TI_PS_FF_EMR 
  T_nc_para_struct          nc_para_struct;           /*<432:  8> Network control parameters                         */
} T_RRGRR_SI2QUATER_IND;
#endif


#include "CDG_LEAVE.h"


#endif
