/* ----- WARNING - File automatically generated - Do not modify it ----- */





#include "l1_macro.h"
#include "l1_confg.h"

#if (CODE_VERSION == SIMULATION)
  #include <string.h>
  #include "l1_types.h"
  #include "sys_types.h"
  #include "l1_const.h"
  #include "l1_time.h"
  #include "l1_signa.h"
  #include <l1_trace.h>

  #if TESTMODE
    #include "l1tm_defty.h"
  #endif
  #if (AUDIO_TASK == 1)
    #include "l1audio_const.h"
    #include "l1audio_cust.h"
    #include "l1audio_signa.h"
    #include "l1audio_defty.h"
    #include "l1audio_msgty.h"
  #endif
  #if (L1_GTT == 1)
    #include "l1gtt_const.h"
    #include "l1gtt_defty.h"
  #endif
  #if (L1_MP3 == 1)
    #include "l1mp3_defty.h"
  #endif
  #if (L1_MIDI == 1)
    #include "l1midi_defty.h"
  #endif
//ADDED FOR AAC
  #if (L1_AAC == 1)
    #include "l1aac_defty.h"
  #endif
  #include "l1_defty.h"
  #include "cust_os.h"
  #include "l1_msgty.h"
  #include "l1_varex.h"
  #include "l1_proto.h"
  #include "l1_mftab.h"
  #include "l1_tabs.h"
  #include "l1_ver.h"
  #if L2_L3_SIMUL
    #include "l2_l3.h"
    #include "hw_debug.h"
  #endif

  #if L1_GPRS
    #include "l1p_cons.h"
    #include "l1p_msgt.h"
    #include "l1p_deft.h"
    #include "l1p_vare.h"
    #include "l1p_sign.h"
  #endif

  #include "sim_cons.h"
  #include "sim_def.h"
  extern T_hw FAR hw;

#else
  #include "abb.h"
  #include <string.h>
  #include "l1_types.h"
  #include "sys_types.h"
  #include "l1_const.h"
  #include "l1_time.h"
  #include "l1_signa.h"
  #if TESTMODE
    #include "l1tm_defty.h"
    #if (RF_FAM == 60)
      #include "pld.h"
    #endif
  #endif
  #if (AUDIO_TASK == 1)
    #include "l1audio_const.h"
    #include "l1audio_cust.h"
    #include "l1audio_signa.h"
    #include "l1audio_defty.h"
    #include "l1audio_msgty.h"
  #endif
  #if (L1_GTT == 1)
    #include "l1gtt_const.h"
    #include "l1gtt_defty.h"
  #endif
  #if (L1_MP3 == 1)
    #include "l1mp3_defty.h"
  #endif
  #if (L1_MIDI == 1)
    #include "l1midi_defty.h"
  #endif
//ADDED FOR AAC
  #if (L1_AAC == 1)
    #include "l1aac_defty.h"
  #endif
  #include "l1_defty.h"
  #include "cust_os.h"
  #include "l1_msgty.h"
  #include "l1_varex.h"
  #include "l1_proto.h"
  #include "l1_mftab.h"
  #include "l1_tabs.h"
  #include "l1_ver.h"
  #include "l1_trace.h"
  #include "l1_ctl.h"
  #if L2_L3_SIMUL
    #include "l2_l3.h"
    #include "hw_debug.h"
    #include "l2_simul.h"
  #endif

  #if L1_GPRS
    #include "l1p_cons.h"
    #include "l1p_msgt.h"
    #include "l1p_deft.h"
    #include "l1p_vare.h"
    #include "l1p_sign.h"
  #endif
#endif

#if(RF_FAM == 61)
	#include "l1_rf61.h"
#endif
#include "tpudrv61.h"
#include "l1_ctl.h"

#if W_A_DSP1
extern UWORD8 old_sacch_DSP_bug;
#endif

#if TESTMODE
  #include "l1tm_msgty.h"
  #include "l1tm_signa.h"
  #include "l1tm_varex.h"
  void l1tm_fill_burst (UWORD16 pattern, UWORD16 *TM_ul_data);
  #if (ANLG_FAM != 11)
  void ABB_Write_Uplink_Data(SYS_UWORD16 *TM_ul_data);
  #else
  // TODO
  #endif
#endif

#if ((TRACE_TYPE==2) || (TRACE_TYPE==3))
  extern void L1_trace_string(char *s);
  extern void L1_trace_char  (char s);
#endif

#if (GSM_IDLE_RAM != 0)
#if (OP_L1_STANDALONE == 1)
#include "csmi_simul.h"
#else
#include "csmi/sleep.h"
#endif
#endif

#if (RF_FAM == 61)
  #include "l1_rf61.h"
#if (DRP_FW_EXT==1)
  #include "l1_drp_inc.h"
#else
  #include "drp_drive.h"
#endif
#endif

/*-------------------------------------------------------*/
/* Prototypes of external functions used in this file.   */
/*-------------------------------------------------------*/
void l1dmacro_synchro        (UWORD32 when, UWORD32 value);

void l1dmacro_offset         (UWORD32 offset_value, WORD32 relative_time);
void l1dmacro_rx_synth       (UWORD16 arfcn);
void l1dmacro_agc            (UWORD16 arfcn,WORD8 gain, UWORD8 lna
	                                   #if (RF_FAM == 61)
                                            ,UWORD8 if_ctl
						#endif
							   );
void l1dmacro_rx_nb          (UWORD16 arfcn);
void l1dmacro_afc            (UWORD16 afc_value, UWORD8 win_id);
void l1dmacro_adc_read_rx    (void);
#if (CODE_VERSION != SIMULATION)
#if (L1_MADC_ON ==1)
void l1dmacro_adc_read_rx_cs_mode0(void);
#endif
#endif

#if (RF_FAM != 61)
void l1dtpu_serv_rx_nb       (UWORD16 radio_freq, WORD8 agc, UWORD8 lna_off,
                              UWORD32 synchro_serv,UWORD32 new_offset,BOOL change_offset, UWORD8 adc_active);
#endif

#if (RF_FAM == 61)
void l1dtpu_serv_rx_nb       (UWORD16 radio_freq, WORD8 agc, UWORD8 lna_off,
                              UWORD32 synchro_serv,UWORD32 new_offset,BOOL change_offset,
                              UWORD8 adc_active, UWORD8 csf_filter_choice, UWORD8 if_ctl
#if (NEW_SNR_THRESHOLD == 1)
                                  ,UWORD8 saic_flag
#endif /* NEW_SNR_THRESHOLD*/
                              );
#endif /* RF_FAM == 61*/

void l1ddsp_meas_read        (UWORD8 nbmeas, UWORD16 *pm);

#if L1_GPRS
void l1pddsp_synchro         (UWORD8 switch_mode, UWORD8  camp_timeslot);
void l1pddsp_load_bcchn_task (UWORD8 tsq,UWORD16 radio_freq);
void l1pddsp_meas_ctrl       (UWORD8 nbmeas, UWORD8 pm_pos);
void l1pddsp_meas_read       (UWORD8 nbmeas, UWORD16 *a_pm);
#if FF_L1_IT_DSP_USF
void l1pddsp_idle_rx_nb      (UWORD8 burst_nb, UWORD8 tsq, UWORD16 radio_freq,
                              UWORD8 timeslot_no, BOOL ptcch_dl, BOOL usf_interrupt);
#else
void l1pddsp_idle_rx_nb      (UWORD8 burst_nb, UWORD8 tsq, UWORD16 radio_freq,
                              UWORD8 timeslot_no, BOOL ptcch_dl);
#endif
#endif

#if (RF_FAM == 61)
void   cust_get_if_dco_ctl_algo (UWORD16* dco_algo_ctl, UWORD8* if_ctl,
  UWORD8 input_level_flag, UWORD8 input_level, UWORD16 radio_freq, UWORD8 if_threshold);
#endif


#if (GSM_IDLE_RAM != 0)
  UWORD16 toa_tab[4];
#endif
#if (GSM_IDLE_RAM != 0)

/*-------------------------------------------------------*/
/* l1s_abort()                                           */
/*-------------------------------------------------------*/
/*                                                       */
/* Description:                                          */
/* ------------                                          */
/* This function is a "COMPLEX" function used by the L1S */
/* task ABORT. When the L1S merge manager routine,       */
/* "l1s_merge_manager()", finds a conflict between a     */
/* running task and a pending task, it can come to       */
/* aborting the running one to start executing the       */
/* pending. Here is the routine which resets the comm.   */
/* between the MCU and the DSP and TPU. The DSP is also  */
/* signaled to abort any ongoing task. Here is a summary */
/* of the execution:                                     */
/*                                                       */
/*  - Traces for debug.                                  */
/*  - Reset MCU/DSP and MCU/TPU communications.          */
/*  - Signals the ABORT process to the DSP.              */
/*  - Flag DSP programmation.                            */
/*                                                       */
/* Input parameters from globals:                        */
/* ------------------------------                        */
/* "l1s.tpu_offset"                                      */
/*   OFFSET/SYNCHRO registers value for current serving  */
/*   cell setting.                                       */
/*                                                       */
/* Modified parameters from globals:                     */
/* ---------------------------------                     */
/* "l1s.dsp_ctrl_reg"                                    */
/*   bit register used to know at the end of L1S if      */
/*   something has been programmed on the MCU/DSP        */
/*   interface. This is used mainly to swap then the     */
/*   com. page at the end of a control frame.            */
/*   -> set CTRL_ABORT bit in the register.              */
/*                                                       */
/*-------------------------------------------------------*/
void l1s_abort(UWORD8 param1, UWORD8 param2)
{
  // Traces for debug.
  // ******************

  #if (TRACE_TYPE==5)
    trace_fct(CST_L1S_ABORT, l1a_l1s_com.Scell_info.radio_freq);
  #endif

  #if (TRACE_TYPE!=0) && (TRACE_TYPE!=5)
    trace_fct(CST_L1S_ABORT_W0_R0, (UWORD32)(-1));//OMAPS00090550
  #endif

  #if (TRACE_TYPE==1) || (TRACE_TYPE==4)
    if (trace_info.current_config->l1_dyn_trace & 1<<L1_DYN_TRACE_L1S_DEBUG)
      Trace_L1s_Abort(trace_info.abort_task);
  #endif

  // Reset MCU/DSP and MCU/TPU communications.
  // ******************************************

  // Reset Hardware...
  // Set "tpu_reset_bit" to 1.
  // Reset DSP write/read page.
  // Reset communication pointers.
  // Immediate Reload offset with Serving one.
  l1d_reset_hw(l1s.tpu_offset);

  l1s_dsp_com.dsp_db_w_ptr->d_debug = (l1s.debug_time + 2) ;

  // Signals the ABORT process to the DSP.
  // **************************************

  // Set "b_abort" to TRUE, dsp will reset current and pending tasks.
  l1s_dsp_com.dsp_db_w_ptr->d_ctrl_system |= (1 << B_TASK_ABORT);


  // Tasks are aborted on DSP side => forbid measurements during ABORT
  l1s.forbid_meas = 1;

  // Flag DSP programmation.
  // ************************

  // Set "CTRL_ABORT" flag in the controle flag register.
  l1s.dsp_ctrl_reg |= CTRL_ABORT;
#if (FF_L1_FAST_DECODING == 1)
  /* Reset fast decoding */
  l1a_apihisr_com.fast_decoding.status = C_FAST_DECODING_NONE;
  l1a_apihisr_com.fast_decoding.contiguous_decoding = FALSE;
#endif /* #if (FF_L1_FAST_DECODING == 1) */
}

#endif

/*-------------------------------------------------------*/
/* l1s_ctrl_fb26()                                       */
/*-------------------------------------------------------*/
/*                                                       */
/* Description:                                          */
/* ------------                                          */
/* This function is a "COMPLEX" function used by the L1S */
/* tasks: FB26. This function is the control function    */
/* for making a frequency burst acquisition attempt on   */
/* a neighbor cell in dedicated mode TCH. It programs    */
/* the DSP and the TPU for making 1 attempt in reading   */
/* the frequency burst.Here is a summary of the          */
/* execution:                                            */
/*                                                       */
/*  - If SEMAPHORE(task) is low.                         */
/*    - Traces and debug.                                */
/*    - Programs DSP for FB acquisition task.            */
/*    - Programs TPU for FB acquisition task.            */
/*  - Flag DSP and TPU programmation.                    */
/*                                                       */
/* Input parameters from globals:                        */
/* ------------------------------                        */
/* "l1a_l1s_com.Ncell_info.acquis"                       */
/*   cell information structure used for FB26 task.      */
/*                                                       */
/* "l1s.tpu_offset"                                      */
/*   value for SYNCHRO and OFFSET register in the TPU    */
/*   for current serving cell setting. It is used here   */
/*   by the frequency burst reading TPU driver since     */
/*   this driver changes the OFFSET register. At the end */
/*   of the task it restores the serving cell offset     */
/*   value.                                              */
/*                                                       */
/* Modified parameters from globals:                     */
/* ---------------------------------                     */
/* "l1s.tpu_ctrl_reg"                                    */
/*   bit register used to know at the end of L1S if      */
/*   something has been programmed on the MCU/TPU com.   */
/*   This is used mainly to swap then the com. page at   */
/*   the end of a control frame.                         */
/*   -> set CTRL_RX bit in the register.                 */
/*                                                       */
/* "l1s.dsp_ctrl_reg"                                    */
/*   bit register used to know at the end of L1S if      */
/*   something has been programmed on the MCU/DSP com.   */
/*   This is used mainly to swap then the com. page at   */
/*   the end of a control frame.                         */
/*   -> set CTRL_RX bit in the register.                 */
/*                                                       */
/*-------------------------------------------------------*/
void l1s_ctrl_fb26(UWORD8 param1, UWORD8 param2)
{
  WORD8    agc;
  BOOL     lna_off;
  UWORD32  dsp_task;
  UWORD16  radio_freq = 0;
#if (L1_FF_MULTIBAND == 1)
  UWORD16 operative_radio_freq;
#endif
  
#if (L1_12NEIGH ==1)
  BOOL     en_task;
  BOOL     task_param;

  // Get "enable" task flag and "synchro semaphore" for current task.
  en_task    = l1a_l1s_com.l1s_en_task[param1];
  task_param = l1a_l1s_com.task_param[param1];

  if((en_task) && !(task_param))
  // Check the task semaphore and enable flag. The control body is executed only
  // when the task semaphore is 0 and enable flag is 1. The semaphore can be set to
  // 1 whenever L1A makes some changes to the task parameters. The enable can be
  // reset to 0 when the task is no more enabled.
#else
  if(!(l1a_l1s_com.task_param[FB26] == SEMAPHORE_SET))
#endif
  // Check the task semaphore. The control body is executed only
  // when the task semaphore is 0. This semaphore can be set to
  // 1 whenever L1A makes some changes to the task parameters.
  {
#if (L1_12NEIGH ==1)
    T_NCELL_SINGLE *cell_info_ptr = NULL;

    cell_info_ptr = &l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id];
    radio_freq = cell_info_ptr->radio_freq;
#else
    radio_freq = l1a_l1s_com.nsync.list[0].radio_freq;
#endif
    // Traces and debug.
    // ******************

    #if (TRACE_TYPE!=0)
      trace_fct(CST_L1S_CTRL_FB26, radio_freq);
    #endif

    #if (TRACE_TYPE==5) && FLOWCHART
      trace_flowchart_dsp_tpu(dltsk_trace[FB26].name);
    #endif

    // Programs DSP for FB26 task.
    // ****************************

    // dsp pgm...

    dsp_task = l1s_swap_iq_dl(radio_freq,FB26);

    l1ddsp_load_monit_task(dsp_task, 1);

    // Programs TPU for FB26 task.
    // ****************************
#if (L1_FF_MULTIBAND == 0)
    
    lna_off = l1a_l1s_com.last_input_level[radio_freq - l1_config.std.radio_freq_index_offset].lna_off;
    // agc is just computed from last stored IL
    agc     = Cust_get_agc_from_IL(radio_freq, l1a_l1s_com.last_input_level[radio_freq - l1_config.std.radio_freq_index_offset].input_level >> 1, AV_ID, lna_off);

#else // L1_FF_MULTIBAND = 1 below

    operative_radio_freq = 
      l1_multiband_radio_freq_convert_into_operative_radio_freq(radio_freq);
    lna_off = l1a_l1s_com.last_input_level[operative_radio_freq].lna_off;
    // agc is just computed from last stored IL
    agc     = 
    Cust_get_agc_from_IL(radio_freq, l1a_l1s_com.last_input_level[operative_radio_freq].input_level >> 1, AV_ID, lna_off);

#endif // #if (L1_FF_MULTIBAND == 1) else


    // tpu pgm...
    l1dtpu_neig_fb26(radio_freq,
                     agc,
                     lna_off,
                     l1s.tpu_offset);
  }

  // Flag DSP and TPU programmation.
  // ********************************

  // Set "CTRL_RX" flag in the controle flag register.
  l1s.tpu_ctrl_reg |= CTRL_RX;
  l1s.dsp_ctrl_reg |= CTRL_RX;

  // This task is not compatible with Neigh. Measurement. Store task length
  // in "forbid_meas" to indicate when the task will last.
  // Special case: we set forbid_meas to skip the measurements in the frames
  // FN%26=24 or 25.
  l1s.forbid_meas = 3;
}

/*-------------------------------------------------------*/
/* l1s_ctrl_sb26()                                       */
/*-------------------------------------------------------*/
/*                                                       */
/* Description:                                          */
/* ------------                                          */
/* This function is a "COMPLEX" function used by the L1S */
/* tasks: SB1,SB2,SB51,SBCONF,SBCNF51. This function is  */
/* the control function for making a synchro burst       */
/* reading on a neighbor cell in Cell Selection, Idle    */
/* mode and dedicated mode SDCCH. It programs the DSP    */
/* and the TPU for making 1 attempt in reading the       */
/* synchro burst. Here is a summary of the execution:    */
/*                                                       */
/*  - If SEMAPHORE(task) is low.                         */
/*    - Get the cell information structure.              */
/*    - Traces and debug.                                */
/*    - Programs DSP for SB reading task.                */
/*    - Programs TPU for SB reading task.                */
/*  - Flag DSP and TPU programmation.                    */
/*                                                       */
/* Input parameters:                                     */
/* -----------------                                     */
/* "task"                                                */
/*   SB26, Synchro Burst reading task in Dedicated mode, */
/*   TCH.                                                */
/*   SBCNF26, Synchro Burst confirmation task in Dedic.  */
/*   mode TCH.                                           */
/*                                                       */
/* Input parameters from globals:                        */
/* ------------------------------                        */
/* "l1a_l1s_com.Ncell_info.acquis"                       */
/*   cell information structure used for SB26 task.      */
/*                                                       */
/* "l1a_l1s_com.Ncell_info.conf"                         */
/*   cell information structure used for SBCNF26 task.   */
/*                                                       */
/* "l1s.tpu_offset"                                      */
/*   value for SYNCHRO and OFFSET register in the TPU    */
/*   for current serving cell setting. It is used here   */
/*   by the synchro burst reading TPU driver since this  */
/*   driver changes the OFFSET register. At the end of   */
/*   the task it restores the serving cell offset value. */
/*                                                       */
/* Modified parameters from globals:                     */
/* ---------------------------------                     */
/* "l1s.tpu_ctrl_reg"                                    */
/*   bit register used to know at the end of L1S if      */
/*   something has been programmed on the MCU/TPU com.   */
/*   This is used mainly to swap then the com. page at   */
/*   the end of a control frame.                         */
/*   -> set CTRL_RX bit in the register.                 */
/*                                                       */
/* "l1s.dsp_ctrl_reg"                                    */
/*   bit register used to know at the end of L1S if      */
/*   something has been programmed on the MCU/DSP com.   */
/*   This is used mainly to swap then the com. page at   */
/*   the end of a control frame.                         */
/*   -> set CTRL_RX bit in the register.                 */
/*                                                       */
/*-------------------------------------------------------*/
void l1s_ctrl_sb26(UWORD8 task, UWORD8 param2)
{
  UWORD32  nb_nop = 0;
  WORD8    agc;
  BOOL     lna_off;
  UWORD32  dsp_task;
  UWORD8 input_level;
  UWORD32 temp;
#if (L1_FF_MULTIBAND == 1)
  UWORD16 operative_radio_freq;
#endif

#if (L1_12NEIGH ==1)
  BOOL     en_task;
  BOOL     task_param;
#if (RF_FAM == 61)
      UWORD16 dco_algo_ctl_sb = 0;
      UWORD8   if_ctl = 0 ;
	  UWORD8 if_threshold = C_IF_ZERO_LOW_THRESHOLD_GSM;
#endif

   // Get "enable" task flag and "synchro semaphore" for current task.
  en_task    = l1a_l1s_com.l1s_en_task[task];
  task_param = l1a_l1s_com.task_param[task];

 if((en_task) && !(task_param))
#else
  if(!(l1a_l1s_com.task_param[task]))
#endif
  // Check the task semaphore. The control body is executed only
  // when the task semaphore is 0. This semaphore can be set to
  // 1 whenever L1A makes some changes to the task parameters.
  {
    UWORD16  radio_freq = 0;
    UWORD32  time_alignmt = 0;
#if (L1_12NEIGH ==1)
    T_NCELL_SINGLE *cell_info_ptr = NULL;

    if (task == SB26)
       cell_info_ptr = &l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_sb_id];
    if (task == SBCNF26)
    {

#if (L1_EOTD==1)
       // We need to trigger the TOA tracking / adjustment period
       // which logs all TOA updates after E-OTD has started...

       if(l1a_l1s_com.nsync.eotd_meas_session == TRUE)
       {
         if(    (l1a_l1s_com.nsync.eotd_toa_phase == 0)
             && (l1a_l1s_com.nsync.active_sbconf_id == 12) )
         {
           l1a_l1s_com.nsync.eotd_toa_tracking = 0;
           l1a_l1s_com.nsync.eotd_toa_phase = 1;
         }

         l1a_l1s_com.nsync.eotd_cache_toa_tracking = l1a_l1s_com.nsync.eotd_toa_tracking;
       }
#endif

       cell_info_ptr = &l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_sbconf_id];

    }
if(cell_info_ptr != NULL)//OMAPS00090550
{
    radio_freq   = cell_info_ptr->radio_freq;
    time_alignmt = cell_info_ptr->time_alignmt;
}

#else
    // Get the cell information.
    // **************************
    radio_freq   = l1a_l1s_com.nsync.list[0].radio_freq;
    time_alignmt = l1a_l1s_com.nsync.list[0].time_alignmt;
#endif
    // Traces and debug.
    // ******************

    #if (TRACE_TYPE!=0)
      switch(task)
      {
        case SB26:    trace_fct(CST_L1S_CTRL_SB26, radio_freq);    break;
        case SBCNF26: trace_fct(CST_L1S_CTRL_SBCNF26, radio_freq); break;
      }
    #endif

    #if (TRACE_TYPE==5) && FLOWCHART
      trace_flowchart_dsp_tpu(dltsk_trace[task].name);
    #endif

    // Programs DSP for required task.
    // ********************************
    // dsp pgm...

    dsp_task = l1s_swap_iq_dl(radio_freq,task);
    l1ddsp_load_monit_task(dsp_task, 0);

    // Programs TPU for required task.
    // ********************************
  temp = (UWORD32)(l1_config.params.fb26_anchoring_time - EPSILON_SYNC);
  #if (L1_12NEIGH ==1)
  if(cell_info_ptr != NULL)//OMAPS00090550
  {
      if((cell_info_ptr->sb26_offset == 1) &&
         (time_alignmt >= temp)) //omaps00090550
  #else
      if((l1a_l1s_com.nsync.list[0].sb26_offset == 1) &&
         (time_alignmt >= temp)) //omaps00090550
  #endif
    // SB is in the 2nd frame of the search slot...
    // ...and SB is at the very end of the slot.
    // We insert a nop in the tpu scenario to
    // be able to jump the 1st frame.
    {
      nb_nop = 1;
    }
   #if (L1_12NEIGH ==1)
	}
   #endif

#if (L1_FF_MULTIBAND == 0)

    // agc is just computed from last stored IL
    input_level = l1a_l1s_com.last_input_level[radio_freq - l1_config.std.radio_freq_index_offset].input_level;
    lna_off = l1a_l1s_com.last_input_level[radio_freq - l1_config.std.radio_freq_index_offset].lna_off;
    agc     = Cust_get_agc_from_IL(radio_freq, input_level >> 1, AV_ID, lna_off);

#else // L1_FF_MULTIBAND = 1 below

    operative_radio_freq = 
      l1_multiband_radio_freq_convert_into_operative_radio_freq(radio_freq); 
    // agc is just computed from last stored IL
    input_level = l1a_l1s_com.last_input_level[operative_radio_freq].input_level;
    lna_off = l1a_l1s_com.last_input_level[operative_radio_freq].lna_off;    
    agc     = Cust_get_agc_from_IL(radio_freq, input_level >> 1, AV_ID, lna_off);    

#endif // #if (L1_FF_MULTIBAND == 0) else

    #if (RF_FAM == 61)   // Locosto DCO
       cust_get_if_dco_ctl_algo(&dco_algo_ctl_sb, &if_ctl, (UWORD8) L1_IL_VALID,
                                          input_level,
                                           radio_freq,if_threshold);
      	l1ddsp_load_dco_ctl_algo_sb(dco_algo_ctl_sb);
    #endif

    // tpu pgm...
    l1dtpu_neig_sb26(radio_freq,
                     agc,
                     lna_off,
                     time_alignmt,
                     nb_nop,
                     l1s.tpu_offset
                    #if (RF_FAM == 61)
                    ,if_ctl
                    #endif
                               	);
  }

  // Flag DSP and TPU programmation.
  // ********************************

  // Set "CTRL_RX" flag in the controle flag register.
  l1s.tpu_ctrl_reg |= CTRL_RX;
  l1s.dsp_ctrl_reg |= CTRL_RX;

  // This task is not compatible with Neigh. Measurement. Store task length
  // in "forbid_meas" to indicate when the task will last.
  // Special case: we set forbid_meas to skip the measurements in the frames
  // FN%26=24 or 25.
  l1s.forbid_meas = 3;
}
#if (GSM_IDLE_RAM != 0)

UWORD32 qual_acc_idle1[2];

/*-------------------------------------------------------*/
/* l1s_ctrl_snb_dl()                                     */
/*-------------------------------------------------------*/
/*                                                       */
/* Description:                                          */
/* ------------                                          */
/* This function is a "COMPLEX" function used by the L1S */
/* serving cell normal burst reading tasks: NP, EP,      */
/* BCCHS, ALLC, DDL and ADL. This function is the control*/
/* function for reading a normal burst on the serving    */
/* cell. It programs the DSP and the TPU for reading a   */
/* normal burst without change on the TPU OFFSET         */
/* register and flags the reading of the normal paging   */
/* burst. This flag is used by the measurement manager   */
/* "l1s_meas_manager()" at the end of L1S. Here is a     */
/* summary of the execution:                             */
/*                                                       */
/*  - If SEMAPHORE(task) is low.                         */
/*      - Catch ARFCN and set CIPHERING reduced frame    */
/*        number.                                        */
/*      - Traces and debug.                              */
/*      - Programs DSP for required task.                */
/*      - Programs TPU for required task.                */
/*      - Flag the reading of a Normal Paging burst.     */
/*  - Flag DSP and TPU programmation.                    */
/*                                                       */
/* Input parameters:                                     */
/* -----------------                                     */
/* "task"                                                */
/*   NP, Normal paging reading task.                     */
/*   EP, Extended paging reading task.                   */
/*   BCCHS, BCCH Serving reading task.                   */
/*   ALLC, All serving cell CCCH reading task.           */
/*                                                       */
/*   DDL, SDCCH DOWNLINK reading task.                   */
/*   ADL, SACCH DOWNLINK (associated with SDCCH)reading  */
/*   task.                                               */
/*                                                       */
/* "burst_id"                                            */
/*   BURST_1, 1st burst of the task.                     */
/*   BURST_2, 2nd burst of the task.                     */
/*   BURST_3, 3rd burst of the task.                     */
/*   BURST_4, 4th burst of the task.                     */
/*                                                       */
/* Input parameters from globals:                        */
/* ------------------------------                        */
/* "l1a_l1s_com.dedic_set"                               */
/*   Dedicated channel parameter structure. It is used   */
/*   to get the ARFCN to use for SDCCH (DDL, ADL). This  */
/*   ARFCN comes from the HOPPING algorithm called just  */
/*   before calling this function.                       */
/*                                                       */
/* "l1a_l1s_com.Scell_info"                              */
/*  Serving cell information structure.                  */
/*    .radio_freq, serving cell beacon frequency.             */
/*    .bsic, BSIC of the serving cell. It is used here   */
/*           to pass the training sequence number (part  */
/*           of BSIC) to the DSP.                        */
/*                                                       */
/* "l1s.afc"                                             */
/*   current AFC value to be applied for the given task. */
/*                                                       */
/* "l1s.tpu_offset"                                      */
/*   value for the TPU SYNCHRO and OFFSET registers      */
/*   for current serving cell setting. It is used here   */
/*   to refresh the TPU SYNCHRO and OFFSET registers     */
/*   with a corrected (time tracking of the serving)     */
/*   value prior to reading a serving cell normal burst. */
/*                                                       */
/* Modified parameters from globals:                     */
/* ---------------------------------                     */
/* "l1s.np_ctrl"                                         */
/*   Flag set when a normal paging burst reading is      */
/*   controled. This flag is used by the measurement     */
/*   manager "l1s_meas_manager()", at the end of L1S, to */
/*   scheduling the neighbor cell measurements.          */
/*   -> set to 1.                                        */
/*                                                       */
/* "l1s.tpu_win"                                         */
/*   each frame is composed with a maximum of 3          */
/*   working/TPU windows (typically RX/TX/PW). This is   */
/*   a counter used to count the number of windows       */
/*   used.                                               */
/*   -> incremented.                                     */
/*                                                       */
/* "l1s.tpu_ctrl_reg"                                    */
/*   bit register used to know at the end of L1S if      */
/*   something has been programmed on the MCU/TPU com.   */
/*   This is used mainly to swap then the com. page at   */
/*   the end of a control frame.                         */
/*   -> set CTRL_RX bit in the register.                 */
/*                                                       */
/* "l1s.dsp_ctrl_reg"                                    */
/*   bit register used to know at the end of L1S if      */
/*   something has been programmed on the MCU/DSP com.   */
/*   This is used mainly to swap then the com. page at   */
/*   the end of a control frame.                         */
/*   -> set CTRL_RX bit in the register.                 */
/*                                                       */
/*-------------------------------------------------------*/
void l1s_ctrl_snb_dl(UWORD8 task, UWORD8 burst_id)
{
  UWORD8          lna_off;
  WORD8           agc;
  UWORD16         rx_radio_freq;
  UWORD8          tsc;
  T_INPUT_LEVEL  *IL_info_ptr;
  UWORD32         dsp_task;
  //static  BOOL    change_synchro;
  UWORD8          adc_active = INACTIVE;
#if (L1_FF_MULTIBAND == 1)
  UWORD16 operative_radio_freq;
#endif /*L1_FF_MULTIBAND*/
  
#if L1_GPRS
  static  BOOL    BCCHS_in_transfert = FALSE;
  static  BOOL    change_synchro;//OMAPS90550-new
#endif
UWORD8 input_level = 0; //omaps00090550
#if (RF_FAM == 61)
    UWORD16 dco_algo_ctl_nb = 0;
    UWORD8 if_ctl = 0;
	UWORD8 if_threshold = C_IF_ZERO_LOW_THRESHOLD_GSM;
#endif
#if (NEW_SNR_THRESHOLD == 1)
  UWORD8 saic_flag=0;
#endif /* NEW_SNR_THRESHOLD */
  // By default we choose the hardware filter
  UWORD8 csf_filter_choice = L1_SAIC_HARDWARE_FILTER;
#if (FF_L1_FAST_DECODING == 1)
  BOOL fast_decoding_authorized = FALSE;

  if ( (burst_id == BURST_1) && (l1a_apihisr_com.fast_decoding.status == C_FAST_DECODING_FORBIDDEN) )
  {
    l1a_apihisr_com.fast_decoding.status = C_FAST_DECODING_NONE;
  }

  fast_decoding_authorized = l1s_check_fast_decoding_authorized(task);

  if ( fast_decoding_authorized && l1s_check_deferred_control(task,burst_id) )
  {
    /* Control is deferred until the upcoming fast decoding IT */
    return;
  } /* if (fast_decoding_authorized)*/

  /* In all other cases, control must be performed now. */
#endif /* FF_L1_FAST_DECODING == 1 */

  if(!(l1a_l1s_com.task_param[task] == SEMAPHORE_SET))
    // Check the task semaphore. The control body is executed only
    // when the task semaphore is 0. This semaphore can be set to
    // 1 whenever L1A makes some changes to the task parameters.
  {
    // Catch ARFCN and set CIPHERING reduced frame number.
    // Catch Training sequence.
    // ****************************************************

    if((task == DDL) || (task == ADL))
      // Dedicated mode SDCCH downlink.
    {
      // Get ARFCN to be used for current control.
      rx_radio_freq = l1a_l1s_com.dedic_set.radio_freq;

      if (rx_radio_freq==l1a_l1s_com.Scell_info.radio_freq) // we are working on a beacon freq.
        IL_info_ptr = &l1a_l1s_com.Scell_info.traffic_meas_beacon;
      else
        IL_info_ptr = &l1a_l1s_com.Scell_info.traffic_meas;// we are working on a daughter freq

      // Catch training sequence code from the channel description.
      tsc = l1a_l1s_com.dedic_set.aset->achan_ptr->desc_ptr->tsc;

      // Set CIPHERING reduced frame number.
#if (AMR == 1)
#if (FF_L1_TCH_VOCODER_CONTROL == 1)
      l1ddsp_load_tch_param(&(l1s.next_time),
        SIG_ONLY_MODE,
        l1a_l1s_com.dedic_set.aset->achan_ptr->desc_ptr->channel_type,
                              #if !FF_L1_IT_DSP_DTX
        0, 0, 0, 0, 0, 0);
#else
                                0, 0, 0, 0, 0, 0, 0);
                              #endif
        #else
      l1ddsp_load_tch_param(&(l1s.next_time),
        SIG_ONLY_MODE,
        l1a_l1s_com.dedic_set.aset->achan_ptr->desc_ptr->channel_type,
                              #if !FF_L1_IT_DSP_DTX
        0, 0, 0, 0);
                              #else
                                0, 0, 0, 0, 0);
#endif
        #endif
#else
#if (FF_L1_TCH_VOCODER_CONTROL == 1)
      l1ddsp_load_tch_param(&(l1s.next_time),
        SIG_ONLY_MODE,
        l1a_l1s_com.dedic_set.aset->achan_ptr->desc_ptr->channel_type,
                              #if !FF_L1_IT_DSP_DTX
        0, 0, 0, 0, 0);
#else
                                0, 0, 0, 0, 0, 0);
                              #endif
        #else
      l1ddsp_load_tch_param(&(l1s.next_time),
        SIG_ONLY_MODE,
        l1a_l1s_com.dedic_set.aset->achan_ptr->desc_ptr->channel_type,
                              #if !FF_L1_IT_DSP_DTX
        0, 0, 0);
                              #else
                                0, 0, 0, 0);
#endif
#endif
#endif
      lna_off = IL_info_ptr->lna_off;
      // for SDCCH we use DPAGC algorithm.
#if DPAGC_MAX_FLAG
      agc = Cust_get_agc_from_IL(rx_radio_freq, IL_info_ptr->input_level >> 1, MAX_ID, lna_off);
#else
      agc = Cust_get_agc_from_IL(rx_radio_freq, IL_info_ptr->input_level >> 1, AV_ID, lna_off);
#endif



      // Store input_level and lna_off field  used for current CTRL in order to be able to build IL
      // from pm in READ phase.
      l1a_l1s_com.Scell_used_IL = *IL_info_ptr;
    } // end if (task == DDL) || (task == ADL)
    else
    {
      rx_radio_freq = l1a_l1s_com.Scell_info.radio_freq;

      // Catch training sequence code from serving cell BCC (part of BSIC).
      tsc = l1a_l1s_com.Scell_info.bsic & 0x0007;

      // for PCH/E_PCH/Serving BCCH and All CCCH we use
      // PAGC algorithm.
#if (L1_FF_MULTIBAND == 0)

      input_level = l1a_l1s_com.last_input_level[rx_radio_freq - l1_config.std.radio_freq_index_offset].input_level ;
      lna_off = l1a_l1s_com.last_input_level[rx_radio_freq - l1_config.std.radio_freq_index_offset].lna_off;
      agc     = Cust_get_agc_from_IL(rx_radio_freq, input_level >> 1, MAX_ID, lna_off);


      // Store input_level and lna_off fields used for current CTRL in order to be able
      // to build IL from pm in READ phase.
      l1a_l1s_com.Scell_used_IL = l1a_l1s_com.last_input_level[rx_radio_freq - l1_config.std.radio_freq_index_offset];

#else // L1_FF_MULTIBAND = 1 below

    operative_radio_freq = 
      l1_multiband_radio_freq_convert_into_operative_radio_freq(rx_radio_freq);

      input_level = l1a_l1s_com.last_input_level[operative_radio_freq].input_level ;
      lna_off = l1a_l1s_com.last_input_level[operative_radio_freq].lna_off;
      agc     = Cust_get_agc_from_IL(rx_radio_freq, input_level >> 1, MAX_ID, lna_off);


      // Store input_level and lna_off fields used for current CTRL in order to be able
      // to build IL from pm in READ phase.
      l1a_l1s_com.Scell_used_IL = l1a_l1s_com.last_input_level[operative_radio_freq];


#endif // #if (L1_FF_MULTIBAND == 0) else

      
    }

   #if(RF_FAM == 61)   // Locosto DCO
          cust_get_if_dco_ctl_algo(&dco_algo_ctl_nb, &if_ctl, (UWORD8) L1_IL_VALID ,
                                                    input_level,
                                                    rx_radio_freq,if_threshold);
          l1ddsp_load_dco_ctl_algo_nb(dco_algo_ctl_nb);
   #endif //RF_FAM =61

    #if (L1_SAIC != 0)
      // If SAIC is enabled, call the low level SAIC control function
      csf_filter_choice = l1ctl_saic(l1a_l1s_com.Scell_used_IL.input_level,l1a_l1s_com.mode
      #if (NEW_SNR_THRESHOLD == 1)
          ,task
          ,&saic_flag
      #endif
          );
   #endif  //L!SAIC != 0

    // ADC measurement
    // ***************
    // check if during the 1st burst of the bloc an ADC measurement must be performed
    if ((burst_id == BURST_1) && (task == NP))
    {
#if L1_GPRS
      //In case of network mode of operation II or III, CCCH reading is possible
      //in packet idle mode and in packet transfer mode.
      //ADC measurements are already managed by comlex function of Packet idle tasks
      if (!((l1a_l1s_com.l1s_en_task[PNP]    == TASK_ENABLED) ||
        (l1a_l1s_com.l1s_en_task[PEP]    == TASK_ENABLED) ||
        (l1a_l1s_com.l1s_en_task[PALLC]  == TASK_ENABLED) ||
        (l1a_l1s_com.l1s_en_task[PDTCH]  == TASK_ENABLED) ||
        (l1a_l1s_com.l1s_en_task[SINGLE] == TASK_ENABLED)))
#endif
      {
        adc_active = l1s_ADC_decision_on_NP();
      }
    } // end if (burst_id == BURST_1) && (task == NP)

    if (task == ADL)
    {
      // ADC measurement for SACCH DL
      // ****************************

      // check if during the SACCH burst an ADC measurement must be performed
      if (l1a_l1s_com.adc_mode & ADC_NEXT_TRAFFIC_DL)  // perform ADC only one time
      {
        adc_active = ACTIVE;
        l1a_l1s_com.adc_mode &= ADC_MASK_RESET_TRAFFIC; // reset in order to have only one ADC measurement in Traffic
      }
      else
      if (l1a_l1s_com.adc_mode & ADC_EACH_TRAFFIC_DL) // perform ADC on each period bloc
      {
        if ((++l1a_l1s_com.adc_cpt)>=l1a_l1s_com.adc_traffic_period) // wait for the period
        {
          adc_active = ACTIVE;
          l1a_l1s_com.adc_cpt = 0;
        }
      }
    }

    // Traces and debug.
    // ******************

#if (TRACE_TYPE==5) && FLOWCHART
    trace_flowchart_dsp_tpu(dltsk_trace[task].name);
#endif

#if (TRACE_TYPE!=0) && (TRACE_TYPE!=5)
    trace_fct(CST_L1S_CTRL_SNB_DL_BURST0 + burst_id, (UWORD32)(-1));//OMAPS00090550
#endif

#if (TRACE_TYPE==5)
    trace_fct(CST_L1S_CTRL_SNB_DL, rx_radio_freq);
#endif

    l1s_dsp_com.dsp_db_w_ptr->d_debug = (l1s.debug_time + 2) ;

    // the l1a_l1s_com.mode variable could change during the block: So test this variable only on the 1st block
    // See BUG2237 (mode change from Idle to Transfert during BCCHS task)
#if (L1_GPRS)
    if (burst_id == BURST_1)
      BCCHS_in_transfert = ((l1a_l1s_com.mode == PACKET_TRANSFER_MODE) && ((task == EBCCHS) || (task == NBCCHS)));
#endif

    // Programs DSP according to the DSP scheduler used
    // *************************************************


#if (L1_GPRS)
    switch(l1a_l1s_com.dsp_scheduler_mode)
    {
      // dsp pgm is made using GSM scheduler...
    case GSM_SCHEDULER:
#if (FF_L1_FAST_DECODING == 1)
      l1ddsp_load_fast_dec_task(task,burst_id);
#endif
      dsp_task = l1s_swap_iq_dl(rx_radio_freq,task);
      l1ddsp_load_rx_task(dsp_task, burst_id, tsc);
      break;

      // dsp pgm is made using GPRS scheduler...
    case GPRS_SCHEDULER:
#if (FF_L1_FAST_DECODING == 1)
          l1ddsp_load_fast_dec_task(task,burst_id);
#endif
        #if FF_L1_IT_DSP_USF
          l1pddsp_idle_rx_nb(burst_id,tsc,rx_radio_freq,0,FALSE,FALSE);
        #else
          l1pddsp_idle_rx_nb(burst_id,tsc,rx_radio_freq,0,FALSE);
        #endif
      break;
    }
#else
#if (FF_L1_FAST_DECODING == 1)
    l1ddsp_load_fast_dec_task(task,burst_id);
#endif
    dsp_task = l1s_swap_iq_dl(rx_radio_freq,task);
    l1ddsp_load_rx_task(dsp_task, burst_id, tsc);
#endif

    // update the TPU with the new TOA if necessary
    l1ctl_update_TPU_with_toa();

    // Programs TPU for required task.
    // ********************************
#if (L1_GPRS)

    //In case of network mode of operation II or III, CCCH reading is possible
    //in packet idle mode and in packet transfer mode.
    // if (TS(CCCH) - TS(current task))%8 >= 4    synchro change is required
    // if not, OFFSET change is required
    //
    if (((task == EP) || (task == NP)) &&
      ((l1a_l1s_com.l1s_en_task[PNP]    == TASK_ENABLED) ||
      (l1a_l1s_com.l1s_en_task[PEP]    == TASK_ENABLED) ||
      (l1a_l1s_com.l1s_en_task[PALLC]  == TASK_ENABLED) ||
      (l1a_l1s_com.l1s_en_task[PDTCH]  == TASK_ENABLED) ||
      (l1a_l1s_com.l1s_en_task[SINGLE] == TASK_ENABLED)))
    {
      UWORD32  new_offset;
      WORD32   new_synchro;
      UWORD32  ts_ccch;

      ts_ccch =  (l1a_l1s_com.ccch_group * 2);                //timeslot CCCH burts
      new_offset = (ts_ccch  - l1a_l1s_com.dl_tn + 8) % 8;    //dl_tn is the current time slot from previous task

      if (burst_id == BURST_1)
        l1s.forbid_meas = TASK_ROM_MFTAB[task].size;

      if (new_offset >= 4)
        l1s.algo_change_synchro_active = TRUE;

      if (l1s.algo_change_synchro_active)
      {
        // compute TPU offset for "current timeslot + 4 timeslot"
        new_synchro = l1s.tpu_offset + (4 * TN_WIDTH);

        if(new_synchro >= TPU_CLOCK_RANGE)
          new_synchro -= TPU_CLOCK_RANGE;

        //compute new offset
        new_offset = (((ts_ccch + 4 - l1a_l1s_com.dl_tn)%8) * TN_WIDTH) + new_synchro;
      }
      //no synchro change required, but new offset is computed
      else
      {
        new_synchro = l1s.tpu_offset;
        new_offset = (new_offset * TN_WIDTH) + new_synchro;
      }

      if (new_offset >= TPU_CLOCK_RANGE)
        new_offset -= TPU_CLOCK_RANGE;

      // tpu pgm...
      l1dtpu_serv_rx_nb(rx_radio_freq,
        agc,
        lna_off,
        new_synchro,
        new_offset,
        TRUE,
        adc_active,
        csf_filter_choice
        #if (RF_FAM == 61)
	   ,if_ctl
	#endif
    #if (NEW_SNR_THRESHOLD == 1)
     ,saic_flag
    #endif /*NEW_SNR_THRESHOLD */
        );
    } // end if (task == EP) || (task == NP) in packet Idle

    // in case of EBCCHS and NBCCHS in packet transfer a change synchro is performed
    else if (BCCHS_in_transfert)
    {
      UWORD32  new_offset;
      WORD32   new_synchro;

      change_synchro = ((l1a_l1s_com.dl_tn > 0) && (l1a_l1s_com.dl_tn < 5 ));

      // if change synchro is needed
      if(change_synchro) // TS= [1,2,3,4]
      {
        // the synchro is changed by 4 timeslots.
        new_synchro = l1s.tpu_offset + (4 * TN_WIDTH);
        if(new_synchro >= TPU_CLOCK_RANGE)
          new_synchro -= TPU_CLOCK_RANGE;

        // the TPU offset is changed according to the PDTCH time slot
        // because of the new synchro above with a shift of 4TS,
        // 4TS are substract to the offset
        new_offset  = (8 - 4 - l1a_l1s_com.dl_tn) * TN_WIDTH;
      }
      else
      {
        // the synchro is unchanged
        new_synchro = l1s.tpu_offset;

        // the TPU offset is changed according to the PDTCH time slot
        new_offset  = (8 - l1a_l1s_com.dl_tn) * TN_WIDTH;
      }

      new_offset += new_synchro;
      if (new_offset >= TPU_CLOCK_RANGE)
        new_offset -= TPU_CLOCK_RANGE;

      // tpu pgm...
      #if (RF_FAM == 61)
        l1dtpu_serv_rx_nb(rx_radio_freq,
          agc,
          lna_off,
          new_synchro,
          new_offset,
          TRUE,
          adc_active,
          csf_filter_choice,
          if_ctl
          #if (NEW_SNR_THRESHOLD == 1)
          ,saic_flag
          #endif /*NEW_SNR_THRESHOLD */
          );
	#endif

	#if(RF_FAM != 61)
         l1dtpu_serv_rx_nb(rx_radio_freq,
           agc,
           lna_off,
           new_synchro,
           new_offset,
           TRUE,
           adc_active);
	#endif

    } // end if (task == EBCCHS) || (task == NBCCHS) in packet Idle
    else
#endif
    {
      // tpu pgm...
      #if (RF_FAM == 61)
        l1dtpu_serv_rx_nb(rx_radio_freq,
          agc,
          lna_off,
          l1s.tpu_offset,
          l1s.tpu_offset,
          FALSE,
          adc_active,
          csf_filter_choice,
          if_ctl
          #if (NEW_SNR_THRESHOLD == 1)
          ,saic_flag
          #endif /*NEW_SNR_THRESHOLD */
          );
	#endif
       #if (RF_FAM != 61)
         l1dtpu_serv_rx_nb(rx_radio_freq,
           agc,
           lna_off,
           l1s.tpu_offset,
           l1s.tpu_offset,
           FALSE,
           adc_active);
	#endif
    }

    // Increment tpu window identifier.
    l1s.tpu_win += (l1_config.params.rx_synth_load_split + RX_LOAD);

    // GSM DSP scheduler is not able to handle PWR too close to RX normal burst.
    // We have to oblige a min of 1 burst period between RX and PWR
    if(l1_config.params.rx_synth_load_split < BP_SPLIT)
      l1s.tpu_win += BP_SPLIT - l1_config.params.rx_synth_load_split;

   #if L2_L3_SIMUL
   #if (DEBUG_TRACE == BUFFER_TRACE_OFFSET_NEIGH)
       buffer_trace(4, l1s.actual_time.fn, rx_radio_freq,
         l1s.tpu_win,l1s.tpu_offset);
   #endif
   #endif
  }

    #if (L1_GPRS)

    //In case of network mode of operation II or III, CCCH reading is possible
    //in packet idle mode and in packet transfer mode.

    if (((task == EP) || (task == NP)) &&
        ((l1a_l1s_com.l1s_en_task[PNP]    == TASK_ENABLED) ||
         (l1a_l1s_com.l1s_en_task[PEP]    == TASK_ENABLED) ||
         (l1a_l1s_com.l1s_en_task[PALLC]  == TASK_ENABLED) ||
         (l1a_l1s_com.l1s_en_task[PDTCH]  == TASK_ENABLED) ||
         (l1a_l1s_com.l1s_en_task[SINGLE] == TASK_ENABLED)))
    {
        if((burst_id == BURST_4) && l1s.algo_change_synchro_active)
        {

            // Slide synchro back to mach current serving timeslot.
            l1dmacro_synchro(SWITCH_TIME, l1s.tpu_offset);


            // Increment frame number.
            l1s.actual_time    = l1s.next_time;
            l1s.next_time      = l1s.next_plus_time;
            l1s_increment_time (&(l1s.next_plus_time), 1);  // Increment "next_plus time".

            l1s.tpu_ctrl_reg |= CTRL_SYCB;
            l1s.dsp_ctrl_reg |= CTRL_SYNC;
            l1s.ctrl_synch_before = FALSE;
            l1s.algo_change_synchro_active = FALSE;

            #if (TRACE_TYPE == 1) || (TRACE_TYPE == 4)
              trace_fct(CST_L1S_ADJUST_TIME, (UWORD32)(-1));//OMAPS00090550
            #endif
        }
    }

    // in case of EBCCHS and NBCCHS in packet transfer a change synchro is performed
    else if (BCCHS_in_transfert)
    {
      // Shift TPU SYNCHRO/OFFSET registers back to the default timeslot .
      // ****************************************************************
      // When the E/NBCCHS reading control is completed ,
      // the SYNCHRO/OFFSET registers are shifted back to the normal
      // setting used for PCCH reading on the serving cell.
      // Check if "Synchro" change was needed.
      // If so the synchro is changed to recover normal synchro.
      if(burst_id == BURST_4)
      {
        if(change_synchro) // TS= [1,2,3,4]
        {
          // Slide synchro back to mach current serving timeslot.
          l1dmacro_synchro(SWITCH_TIME, l1s.tpu_offset);

          // Increment frame number.
          l1s.actual_time    = l1s.next_time;
          l1s.next_time      = l1s.next_plus_time;
          l1s_increment_time(&(l1s.next_plus_time), 1);  // Increment "next_plus time".

          #if (TRACE_TYPE == 1) || (TRACE_TYPE == 4)
            trace_fct(CST_L1S_ADJUST_TIME, (UWORD32)(-1));//OMAPS00090550
          #endif

          l1s.tpu_ctrl_reg |= CTRL_SYCB;
          l1s.dsp_ctrl_reg |= CTRL_SYNC;
        }
      }

      // This task is not compatible with Neigh. Measurement. Store task length
      // in "forbid_meas" to indicate when the task will last.
      if(burst_id == BURST_1)
        l1s.forbid_meas = TASK_ROM_MFTAB[task].size;
    }
  #endif

  // Flag the reading of a Normal Paging burst.
  // *******************************************

  // Set flag "NP contoled !!". Used in "l1_synch()" to generate meas. controles.
  if(task == NP)
     l1a_l1s_com.ba_list.np_ctrl = burst_id+1;

  // Flag DSP and TPU programmation.
  // ********************************

  // Set "CTRL_RX" flag in the controle flag register.
  l1s.tpu_ctrl_reg |= CTRL_RX;
  l1s.dsp_ctrl_reg |= CTRL_RX;
}

#endif

/*-------------------------------------------------------*/
/* l1s_ctrl_nnb()                                        */
/*-------------------------------------------------------*/
/*                                                       */
/* Description:                                          */
/* ------------                                          */
/* This function is a "COMPLEX" function used by the L1S */
/* neigbor cell normal burst reading tasks: BCCHN.       */
/* This function is the control function for reading 4   */
/* normal bursts on a neighbor cell. It programs the DSP */
/* and the TPU for reading the 4 bursts taking into      */
/* account the time difference between the serving and   */
/* the neighbor cells. To this avail, it shifts the TPU  */
/* OFFSET register according to this time difference and */
/* restores the serving offset value when the 4 burst    */
/* reading are completed. Here is a summary of the       */
/* execution:                                            */
/*                                                       */
/*  - If SEMAPHORE(task) is low.                         */
/*      - Traces and debug.                              */
/*      - Programs DSP for required task.                */
/*      - Programs TPU for required task.                */
/*  - Flag DSP and TPU programmation.                    */
/*                                                       */
/* Input parameters:                                     */
/* -----------------                                     */
/* "task"                                                */
/*   BCCHN, BCCH Neighbor reading task.                  */
/*                                                       */
/* Input parameters from globals:                        */
/* ------------------------------                        */
/* "l1a_l1s_com.Ncell_info.bcch"                         */
/*   cell information structure used for BCCHN task.     */
/*                                                       */
/* "l1a_l1s_com.l1s_en_task"                             */
/*   L1S task enable bit register. Used here to check if */
/*   the Full BCCH Reading task is enabled and then to   */
/*   take the decision to reloading the serving value    */
/*   in the TPU OFFSET register.                         */
/*                                                       */
/* "l1s.tpu_offset"                                      */
/*   value for SYNCHRO and OFFSET register in the TPU    */
/*   for current serving cell setting. At the end of     */
/*   the task this value is restored in the OFFSET       */
/*   register.                                           */
/*                                                       */
/* Modified parameters from globals:                     */
/* ---------------------------------                     */
/* "l1s.tpu_ctrl_reg"                                    */
/*   bit register used to know at the end of L1S if      */
/*   something has been programmed on the MCU/TPU com.   */
/*   This is used mainly to swap then the com. page at   */
/*   the end of a control frame.                         */
/*   -> set CTRL_RX bit in the register.                 */
/*                                                       */
/* "l1s.dsp_ctrl_reg"                                    */
/*   bit register used to know at the end of L1S if      */
/*   something has been programmed on the MCU/DSP com.   */
/*   This is used mainly to swap then the com. page at   */
/*   the end of a control frame.                         */
/*   -> set CTRL_RX bit in the register.                 */
/*                                                       */
/*-------------------------------------------------------*/
void l1s_ctrl_nnb(UWORD8 task, UWORD8 param2)
{
  UWORD8           lna_off;
  WORD8            agc;
  T_NCELL_SINGLE  *cell_info_ptr = NULL;
  BOOL             en_task;
  BOOL             task_param;
  UWORD32          dsp_task;
#if(L1_FF_MULTIBAND == 1)
 UWORD16 operative_radio_freq;
 UWORD8  input_level;
#endif
  
#if (RF_FAM == 61)
       UWORD16 dco_algo_ctl_nb = 0;
       UWORD8 if_ctl = 0;
	   UWORD8 if_threshold = C_IF_ZERO_LOW_THRESHOLD_GSM;
#endif

  // Get "enable" task flag and "synchro semaphore" for current task.
  en_task    = l1a_l1s_com.l1s_en_task[task];
  task_param = l1a_l1s_com.task_param[task];



  if((en_task) && !(task_param))
  // Check the task semaphore and enable flag. The control body is executed only
  // when the task semaphore is 0 and enable flag is 1. The semaphore can be set to
  // 1 whenever L1A makes some changes to the task parameters. The enable can be
  // reset to 0 when the task is no more enabled.
  {
    // Get the cell information structure.
    // ************************************
    if (task == BCCHN)
      cell_info_ptr = &l1a_l1s_com.bcchn.list[l1a_l1s_com.bcchn.active_neigh_id_norm];
    else // BCCHN_TOP and BCCHN_TRAN tasks
      cell_info_ptr = &l1a_l1s_com.bcchn.list[l1a_l1s_com.bcchn.active_neigh_id_top];

    // Traces and debug.
    // ******************

    #if (TRACE_TYPE!=0)
      trace_fct(CST_L1S_CTRL_NNB, cell_info_ptr->radio_freq);
    #endif

    #if (TRACE_TYPE==5) && FLOWCHART
      trace_flowchart_dsp_tpu(dltsk_trace[task].name);
    #endif

    l1s_dsp_com.dsp_db_w_ptr->d_debug = (l1s.debug_time + 6) ;

    // Programs DSP for required task.
    // ********************************

    #if L1_GPRS
      switch(l1a_l1s_com.dsp_scheduler_mode)
      {
        // dsp pgm is made using GSM scheduler...
        case GSM_SCHEDULER:
          dsp_task = l1s_swap_iq_dl(cell_info_ptr->radio_freq,task);
          l1ddsp_load_rx_task(dsp_task,
                              0,
                              cell_info_ptr->tsc);
        break;

        // dsp pgm is made using GPRS scheduler...
        case GPRS_SCHEDULER:
          l1pddsp_load_bcchn_task(cell_info_ptr->tsc, cell_info_ptr->radio_freq);
        break;
      }
    #else
      // dsp pgm...
      dsp_task = l1s_swap_iq_dl(cell_info_ptr->radio_freq,task);
      l1ddsp_load_rx_task(dsp_task,
                          0,
                          cell_info_ptr->tsc);
    #endif

    // Programs TPU for required task.
    // ********************************

    // We program 4 burst reading. The OFFSET register is used to
    // cope with the time difference between the serving and the
    // neighbor cells. The serving cell offset value (l1s.tpu_offset)
    // is restored at the end of the 4 burst reading.
#if (L1_FF_MULTIBAND == 0)

    lna_off = l1a_l1s_com.last_input_level[cell_info_ptr->radio_freq - l1_config.std.radio_freq_index_offset].lna_off;
    // agc is computed from PGC2 algo result.
    agc     = Cust_get_agc_from_IL(cell_info_ptr->radio_freq, l1a_l1s_com.last_input_level[cell_info_ptr->radio_freq - l1_config.std.radio_freq_index_offset].input_level >> 1, AV_ID, lna_off);

#else // L1_FF_MULTIBAND = 1 below

    operative_radio_freq = 
      l1_multiband_radio_freq_convert_into_operative_radio_freq(cell_info_ptr->radio_freq);
    lna_off = l1a_l1s_com.last_input_level[operative_radio_freq].lna_off;
    input_level = l1a_l1s_com.last_input_level[operative_radio_freq].input_level;
    // agc is computed from PGC2 algo result.
    agc     = Cust_get_agc_from_IL(cell_info_ptr->radio_freq, l1a_l1s_com.last_input_level[operative_radio_freq].input_level >> 1, AV_ID, lna_off);

#endif // #if (L1_FF_MULTIBAND == 0) else



    #if(RF_FAM == 61)  // Locosto DCO
        cust_get_if_dco_ctl_algo(&dco_algo_ctl_nb, &if_ctl, (UWORD8) L1_IL_VALID,
#if (L1_FF_MULTIBAND == 0)        
                                       l1a_l1s_com.last_input_level[cell_info_ptr->radio_freq - l1_config.std.radio_freq_index_offset].input_level,
#else
                                       input_level,
#endif                                        
                                        cell_info_ptr->radio_freq,if_threshold);

        //dco_algo_ctl has 0000 00ZL
         dco_algo_ctl_nb *= 0x55;   // replicate 0000 00zL as ZLZL ZLZL

        l1ddsp_load_dco_ctl_algo_nb(dco_algo_ctl_nb);
    #endif

    #if L2_L3_SIMUL
      #if (DEBUG_TRACE == BUFFER_TRACE_OFFSET_NEIGH)
        buffer_trace(4, l1s.actual_time.fn, cell_info_ptr->radio_freq,
                        cell_info_ptr->time_alignmt, cell_info_ptr->fn_offset);
      #endif
    #endif

  #if (RF_FAM == 61)
      if ( cell_info_ptr->time_alignmt >= TPU_CLOCK_RANGE - EPSILON_SYNC)
      {
        // Insert 1 NOP to correct the EPSILON_SYNC side effect
        l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                          agc,
                          lna_off,
                          cell_info_ptr->time_alignmt,
                          l1s.tpu_offset,
                          FALSE, 1,
   			     if_ctl
            #if (NEW_SNR_THRESHOLD == 1)
             ,SAIC_OFF
            #endif /* NEW_SNR_THRESHOLD == 1*/
             );
      }
      else
      {
        l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                          agc,
                          lna_off,
                          cell_info_ptr->time_alignmt,
                          l1s.tpu_offset,
                          FALSE, 0,
   			     if_ctl
             #if (NEW_SNR_THRESHOLD == 1)
             ,SAIC_OFF
            #endif /* NEW_SNR_THRESHOLD == 1*/
             );
      }

      l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                        agc,
                        lna_off,
                        cell_info_ptr->time_alignmt,
                        l1s.tpu_offset,
                        FALSE, 0,
   			     if_ctl
             #if (NEW_SNR_THRESHOLD == 1)
             ,SAIC_OFF
            #endif /* NEW_SNR_THRESHOLD == 1*/
             );
      l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                        agc,
                        lna_off,
                        cell_info_ptr->time_alignmt,
                        l1s.tpu_offset,
                        FALSE, 0,
   			     if_ctl
            #if (NEW_SNR_THRESHOLD == 1)
             ,SAIC_OFF
            #endif /* NEW_SNR_THRESHOLD == 1*/
             );
      l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                        agc,
                        lna_off,
                        cell_info_ptr->time_alignmt,
                        l1s.tpu_offset,
                        TRUE, 0,
   			     if_ctl
            #if (NEW_SNR_THRESHOLD == 1)
             ,SAIC_OFF
            #endif /* NEW_SNR_THRESHOLD == 1*/
             );
  #endif // RF_FAM == 61

  #if (RF_FAM != 61)
      if ( cell_info_ptr->time_alignmt >= TPU_CLOCK_RANGE - EPSILON_SYNC)
      {
        // Insert 1 NOP to correct the EPSILON_SYNC side effect
        l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                          agc,
                          lna_off,
                          cell_info_ptr->time_alignmt,
                          l1s.tpu_offset,
                          FALSE, 1);
      }
      else
      {
        l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                          agc,
                          lna_off,
                          cell_info_ptr->time_alignmt,
                          l1s.tpu_offset,
                          FALSE, 0);
      }

      l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                        agc,
                        lna_off,
                        cell_info_ptr->time_alignmt,
                        l1s.tpu_offset,
                        FALSE, 0);
      l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                        agc,
                        lna_off,
                        cell_info_ptr->time_alignmt,
                        l1s.tpu_offset,
                        FALSE, 0);
      l1dtpu_neig_rx_nb(cell_info_ptr->radio_freq,
                        agc,
                        lna_off,
                        cell_info_ptr->time_alignmt,
                        l1s.tpu_offset,
                        TRUE, 0);
  #endif // RF_FAM != 61
  }

  // Flag DSP and TPU programmation.
  // ********************************

  // Set "CTRL_RX" flag in the controle flag register.
  l1s.tpu_ctrl_reg |= CTRL_RX;
  l1s.dsp_ctrl_reg |= CTRL_RX;

  #if L1_GPRS
  // This task is not compatible with Neigh. Measurement. Store task length
  // in "forbid_meas" to indicate when the task will last.
  if(task == BCCHN_TRAN)
  {
    // In IDLE mode, l1s.forbid_meas is setted by the AGC ctrl
    l1s.forbid_meas = TASK_ROM_MFTAB[task].size;
  }
  #endif
}

/*-------------------------------------------------------*/
/* l1s_hopping_algo()                                    */
/*-------------------------------------------------------*/
/*                                                       */
/* Description:                                          */
/* ------------                                          */
/* This function is a "COMPLEX" function used by the L1S */
/* dedicated mode tasks: DDL, DUL, ADL, AUL, TCHTH/F and */
/* TCHA. This function performs the Hopping Sequence     */
/* generation. It computes the ARFCN to use on the next  */
/* frame. When the channel does not hop, it returns      */
/* the fixe ARFCN provided in the channel description.   */
/*                                                       */
/* If the channel is hopping and the ARFCN result is the */
/* BEACON frequency, an indication flag is set to warn   */
/* the DSP ("b_bcch_freq_ind").                          */
/*                                                       */
/* (see GSM05.02 $6.2.3)                                 */
/*                                                       */
/* Input parameters from globals:                        */
/* ------------------------------                        */
/* "l1a_l1s_com.dedic_set.aset"                          */
/*   Active set of Dedicated channel parameters.         */
/*                                                       */
/* "l1s.l1s.next_time"                                   */
/*   frame number and derived numbers for next frame.    */
/*                                                       */
/* Returned parameter in globals:                        */
/* ------------------------------                        */
/*                                                       */
/* "l1a_l1s_com.dedic_set.radio_freq"                    */
/*   ARFCN to be used on the next frame.                 */
/*                                                       */
/*-------------------------------------------------------*/
void l1s_hopping_algo(UWORD8 task, UWORD8 param2)
{
  UWORD8               mai;
  T_CHN_SEL           *chan_sel;
  T_MOBILE_ALLOCATION *alist_ptr;

  UWORD16             *ma;
  UWORD8               n;
  UWORD8               hsn;
  UWORD8               maio;
  UWORD16             *radio_freq_ptr;
  UWORD16             *beacon_channel_ptr=&l1a_l1s_com.Scell_info.radio_freq; // beacon channel of the serving cell
  T_TIME_INFO         *time_ptr;
  T_TIME_INFO         next_neighbor_time;


  switch(task)
  {

#if L1_GPRS
    case PTCCH:
    {
      chan_sel       = &(l1pa_l1ps_com.transfer.aset->freq_param.chan_sel);
      alist_ptr      = &(l1pa_l1ps_com.transfer.aset->freq_param.freq_list);
      radio_freq_ptr = &l1pa_l1ps_com.transfer.ptcch.radio_freq;
      time_ptr       = &l1s.next_time;
    }
    break;

    case PDTCH:
    case SINGLE:
    // For PDTCH, set pointers to the PACKET parameter structures.
    {
      chan_sel       = &(l1pa_l1ps_com.transfer.aset->freq_param.chan_sel);
      alist_ptr      = &(l1pa_l1ps_com.transfer.aset->freq_param.freq_list);
      radio_freq_ptr = &l1a_l1s_com.dedic_set.radio_freq;
      time_ptr       = &l1s.next_time;
    }
    break;

    case PALLC:
    case PNP:
    case PEP:
    {
      chan_sel       = &l1pa_l1ps_com.pccch.packet_chn_desc.chan_sel;
      alist_ptr      = &l1pa_l1ps_com.pccch.frequency_list;
      radio_freq_ptr = &l1pa_l1ps_com.p_idle_param.radio_freq;
      time_ptr       = &l1s.next_time;
    }
    break;

    case POLL:
    {
      // Load adequat freq. list according to the current mode:
      // SINGLE (i.e. 2 phase access) else Packet Access or Packet Idle
      if(l1a_l1s_com.l1s_en_task[SINGLE] == TASK_ENABLED)
      {
        chan_sel       = &(l1pa_l1ps_com.transfer.aset->freq_param.chan_sel);
        alist_ptr      = &(l1pa_l1ps_com.transfer.aset->freq_param.freq_list);
        radio_freq_ptr = &l1a_l1s_com.dedic_set.radio_freq;
      }
      else
      {
        chan_sel       = &l1pa_l1ps_com.pccch.packet_chn_desc.chan_sel;
        alist_ptr      = &l1pa_l1ps_com.pccch.frequency_list;
        radio_freq_ptr = &l1pa_l1ps_com.p_idle_param.radio_freq;
      }
      time_ptr       = &l1s.next_time;
    }
    break;

    case PBCCHS:
    {
      chan_sel       = &l1pa_l1ps_com.pbcchs.packet_chn_desc.chan_sel;
      alist_ptr      = &l1pa_l1ps_com.pbcchs.frequency_list;
      radio_freq_ptr = &l1pa_l1ps_com.p_idle_param.radio_freq;

      // If PBCCHS controlled one frame in advance --> correct Frame Number when PBCCH block is read
      if (l1pa_l1ps_com.pbcchs.control_offset)
        time_ptr       = &l1s.next_plus_time;
      else
      time_ptr       = &l1s.next_time;
    }
    break;

    case PBCCHN_IDLE:
    case PBCCHN_TRAN:
    {
      WORD32  next_neighbor_time_fn;

      chan_sel           = &l1pa_l1ps_com.pbcchn.packet_chn_desc.chan_sel;
      alist_ptr          = &l1pa_l1ps_com.pbcchn.frequency_list;
      radio_freq_ptr     = &l1pa_l1ps_com.p_idle_param.radio_freq;
      beacon_channel_ptr = &l1pa_l1ps_com.pbcchn.bcch_carrier;
      time_ptr           = &next_neighbor_time;

      // To review (is there any better solution?)...........
      next_neighbor_time_fn = l1s.next_time.fn + l1pa_l1ps_com.pbcchn.fn_offset;

      if (next_neighbor_time_fn > ((WORD32)MAX_FN))//OMAPS00090550
        next_neighbor_time.fn = (UWORD32) (next_neighbor_time_fn - MAX_FN);
      else if (next_neighbor_time_fn < 0)
        next_neighbor_time.fn = (UWORD32) (next_neighbor_time_fn + MAX_FN);
      else
        next_neighbor_time.fn = (UWORD32) (next_neighbor_time_fn);

      next_neighbor_time.t1 = next_neighbor_time.fn / (26L*51L);       // T1 = FN div 26*51
      next_neighbor_time.t2 = next_neighbor_time.fn % 26;              // T2 = FN % 26.
      next_neighbor_time.t3 = next_neighbor_time.fn % 51;              // T3 = FN % 51.
    }
    break;

    case ITMEAS:
    {
      // Packet transfer mode
      if (l1a_l1s_com.l1s_en_task[PDTCH] == TASK_ENABLED)
      {
        // We use the active TBF frequency parameters
        chan_sel  = &(l1pa_l1ps_com.transfer.aset->freq_param.chan_sel);
        alist_ptr = &(l1pa_l1ps_com.transfer.aset->freq_param.freq_list);
      }

      // Packet idle mode
      else
      {
        // We use the frequency parameters given in the MPHP_INT_MEAS_REQ message
        chan_sel     = &(l1pa_l1ps_com.itmeas.packet_intm_freq_param.chan_sel);
        alist_ptr    = &(l1pa_l1ps_com.itmeas.packet_intm_freq_param.freq_list);
      }

      radio_freq_ptr = &l1pa_l1ps_com.itmeas.radio_freq;
      time_ptr       = &l1s.next_plus_time;
    }
    break;

#endif

    case SMSCB:
    // For SMSCB, set pointers to the SMSCB parameter structures.
    {
      chan_sel       = &l1a_l1s_com.cbch_desc.chan_sel;
      alist_ptr      = &l1a_l1s_com.cbch_freq_list;
      radio_freq_ptr = &l1a_l1s_com.dedic_set.radio_freq;

      // If SMSCB is controlled one frame in advance --> correct Frame Number when SMSCB block is read
      if (l1a_l1s_com.pre_scheduled_cbch)
        time_ptr       = &l1s.next_plus_time;
      else
      time_ptr       = &l1s.next_time;
    }
    break;

    default:
    // For SDCCH/TCH, set pointers to the active channel description.
    {
      chan_sel       = &(l1a_l1s_com.dedic_set.aset->achan_ptr->desc_ptr->chan_sel);
      alist_ptr      = l1a_l1s_com.dedic_set.aset->ma.alist_ptr;
      radio_freq_ptr = &l1a_l1s_com.dedic_set.radio_freq;
      time_ptr       = &l1s.next_time;
    }
  } // End of switch(task)

  // Set local variables.
  ma   = &(alist_ptr->rf_chan_no.A[0]);
  n    =   alist_ptr->rf_chan_cnt;
  hsn  =   chan_sel->rf_channel.hopping_rf.hsn;
  maio =   chan_sel->rf_channel.hopping_rf.maio;

  if(chan_sel->h == FALSE)
  // Single RF channel, NOT HOPPING.
  {
    *radio_freq_ptr = chan_sel->rf_channel.single_rf.radio_freq;
  }

  else
  // Hopping channel...
  {
    /**************************************************/
    /* Perform the HOPPING algorithm.                 */
    /**************************************************/
    if(hsn == 0)
    // Cyclic hopping...
    {
      mai = (time_ptr->fn + maio) % n;
    }
    else
    {
      UWORD8  i = 0;
      UWORD8  m;
      UWORD8  mp;
      UWORD8  nbin =0; //omaps00090550
      UWORD8  tp;
      UWORD8  s;
      UWORD8  t1r = (UWORD8)(time_ptr->t1 % 64);

      while(i<=6)
      {
        if((n >> i) > 0) nbin = i;
        i++;
      }
      nbin++;

      m  = time_ptr->t2 + RNTABLE[(hsn ^ t1r) + time_ptr->t3];
      mp = m % (1L << nbin);
      tp = time_ptr->t3 % (1L << nbin);

      if(mp < n) s = mp;
      else       s = (mp + tp) % n;

      mai = (s + maio) % n;
    }

    *radio_freq_ptr = ma[mai];
  }

  if(*radio_freq_ptr == *beacon_channel_ptr)
  // If ARFCN is the BEACON...
  {
    // Set "b_bcch_freq_ind" to TRUE.
    l1s_dsp_com.dsp_db_w_ptr->d_ctrl_system |= (1 << B_BCCH_FREQ_IND);

  }
}
#if (GSM_IDLE_RAM != 0)

/*-------------------------------------------------------*/
/* l1s_read_dummy()                                      */
/*-------------------------------------------------------*/
/*                                                       */
/* Description:                                          */
/* ------------                                          */
/* This function is a "COMPLEX" function used by the L1S */
/* task: ABORT. Since this task just aborts any ongoing  */
/* DSP task, there is no result returned by the DSP to   */
/* the MCU when this abort is completed, but the MCU/DSP */
/* com. read page must be switched properly. This the    */
/* only reason why we have created this function.        */
/*                                                       */
/* Modified parameter in globals:                        */
/* ------------------------------                        */
/*                                                       */
/* "l1s_dsp_com.dsp_r_page_used"                         */
/*   Flag used by the function which closes L1S          */
/*   execution ("l1s_end_manager()") to know if the      */
/*   MCU/DSP read page must be switched.                 */
/*   -> Set to 1.                                        */
/*                                                       */
/*-------------------------------------------------------*/
void l1s_read_dummy(UWORD8 task, UWORD8 param2)
{
  l1_check_com_mismatch(task);

  #if (TRACE_TYPE!=0) && (TRACE_TYPE!=5)
    trace_fct(CST_L1S_READ_DUMMY ,(UWORD32)(-1));//OMAPS00090550
  #endif

      // task is completed, make it INACTIVE (only in case of TCHD).
  if(task == TCHD)
   l1s.task_status[task].current_status = INACTIVE;

  #if FF_L1_IT_DSP_DTX
    // Fast DTX status update
    if(task == TCHD)
    {
      UWORD8 subchannel = l1a_l1s_com.dedic_set.aset->achan_ptr->desc_ptr->subchannel;

      // Currently used for TCH-AHS only
      if (((subchannel == 0) && (l1s.actual_time.fn_mod13_mod4 == 0)) || // FN%13 = 4, 8 and 12 for TCH/H0 (no Read on FN%13=0)
          ((subchannel == 1) && (l1s.actual_time.fn_mod13_mod4 == 1)))   // FN%13 = 1, 5 and 9  for TCH/H1
      {
        // Latch TX activity status if DTX allowed
        if ((l1a_l1s_com.dedic_set.aset->dtx_allowed == FALSE) ||                // No DTX allowed
            (l1s_dsp_com.dsp_ndb_ptr->d_fast_dtx_enc_data ) || // DTX allowed but not used
            (l1a_apihisr_com.dtx.fast_dtx_ready == FALSE))                       // Fast DTX status is invalid
          l1a_apihisr_com.dtx.tx_active = TRUE;
        else
          l1a_apihisr_com.dtx.tx_active = FALSE;
      }
    }
  #endif
  // Set flag used to change the read page at the end of "l1_synch".
  l1s_dsp_com.dsp_r_page_used = TRUE;
}

#endif

/*-------------------------------------------------------*/
/* l1s_read_mon_result()                                 */
/*-------------------------------------------------------*/
/*                                                       */
/* Description:                                          */
/* ------------                                          */
/* This function is a "COMPLEX" function used by the L1S */
/* tasks: FBNEW,SB1,SB2,SBCONF,SB51,SBCNF51,SB26,SBCNF26.*/
/* This function is the reading result function used for */
/* reading the neighbor cell monitoring results. Here is */
/* a summary of the execution:                           */
/*                                                       */
/*  - Traces and debug.                                  */
/*  - Get task result from MCU/DSP read interface.       */
/*                                                       */
/*      - case: FBNEW/FB51.                              */
/*          - If SEMAPHORE(task) is low.                 */
/*              - Update AFC if required.                */
/*              - Read FB detection results.             */
/*              - Reports results to L1A.                */
/*          - Disactivate and Disable task.              */
/*          - Reset buffers and flags in NDB.            */
/*                                                       */
/*      - case: FB26.                                    */
/*          - Read FB detection results.                 */
/*          - Reports results to L1A.                    */
/*          - Disactivate task.                          */
/*                                                       */
/*      - case: SB26/SBCNF26.                            */
/*          - Read SB reading results.                   */
/*          - Reports results to L1A.                    */
/*          - Disactivate task.                          */
/*                                                       */
/*      - case: SB1/SB2/SB51/SBCONF/SBCNF51.             */
/*          - If SEMAPHORE(task) is low.                 */
/*              - Update AFC if required.                */
/*              - Read FB detection results.             */
/*              - Reports results to L1A.                */
/*          - Disactivate task when required.            */
/*                                                       */
/*  - Flag the use of the MCU/DSP dual page read         */
/*    interface.                                         */
/*                                                       */
/* Input parameters:                                     */
/* -----------------                                     */
/* "task"                                                */
/*   FBNEW, Frequency Burst detection task in Idle mode. */
/*   SB1, Synchro Burst reading task in Idle mode.       */
/*   SB2, Synchro Burst detection task in Idle mode.     */
/*   SBCONF, Synchro Burst confirmation task in Idle     */
/*   mode.                                               */
/*   SB51, Synchro Burst reading task in SDCCH Dedicated */
/*   mode.                                               */
/*   SBCNF51, Synchro Burst confirmation task in SDCCH   */
/*   Dedicated mode.                                     */
/*   SB26, Synchro Burst reading task in TCH Dedicated   */
/*   mode.                                               */
/*   SBCNF26, Synchro Burst confirmation task in TCH     */
/*   Dedicated mode.                                     */
/*                                                       */
/* "attempt_for_sb2"                                     */
/*   Since SB2 calls twice this function, this parameter */
/*   tells the function which call it it. Used mainly    */
/*   to know when to DISACTIVATE the task.               */
/*                                                       */
/* Input parameters from globals:                        */
/* ------------------------------                        */
/* "l1a_l1s_com.task_param"                              */
/*   task semaphore bit register. Used to skip the body  */
/*   of this function if L1A has changed or is changing  */
/*   some of the task parameters.                        */
/*                                                       */
/* Modified parameters from globals:                     */
/* ---------------------------------                     */
/* "l1a_l1s_com.l1s_en_task"                             */
/*   L1S task enable bit register.                       */
/*   -> disable FBNEW,FB51 task.                         */
/*                                                       */
/* "l1s.task_status[task].current_status"                */
/*   current task status. It must be reset (INACTIVE)    */
/*   when the task is completed.                         */
/*   -> disactivate task.                                */
/*                                                       */
/* "l1s_dsp_com.dsp_r_page_used"                         */
/*   Flag used by the function which closes L1S          */
/*   execution ("l1s_end_manager()") to know if the      */
/*   MCU/DSP read page must be switched.                 */
/*   -> Set to 1.                                        */
/*                                                       */
/* Use of MCU/DSP interface:                             */
/* -------------------------                             */
/* "l1s_dsp_com.dsp_ndb_ptr"                             */
/*   pointer to the non double buffered part (NDB) of    */
/*   the MCU/DSP interface. This part is R/W for both    */
/*   DSP and MCU.                                        */
/*                                                       */
/* "l1s_dsp_com.dsp_db_r_ptr"                            */
/*   pointer to the double buffered part (DB) of the     */
/*   MCU/DSP interface. This pointer points to the READ  */
/*   page.                                               */
/*                                                       */
/*-------------------------------------------------------*/
void l1s_read_mon_result(UWORD8 task, UWORD8 attempt)
{
  UWORD32   flag=0;
  UWORD32   toa;
  UWORD32   pm;
  UWORD32   angle;
  UWORD32   snr;

  #if TESTMODE
    UWORD32   pm_fullres;
  #endif

  API      *data;

  BOOL      en_task;
  BOOL      task_param;
  UWORD32   fb_abort_flag=0;

  /*-------------------------------------------------------------------------------*/
  /* READ MONITORING TASK RESULTS FROM MCU/DSP INTERFACE...                        */
  /*-------------------------------------------------------------------------------*/
  // Get "enable" task flag and "synchro semaphore" for current task.
  en_task    = l1a_l1s_com.l1s_en_task[task];
  task_param = l1a_l1s_com.task_param[task];

  // Traces and debug.
  // ******************
    #if (TRACE_TYPE!=0)&& (TRACE_TYPE !=5)
      trace_fct(CST_L1S_READ_MON_RESULT,(UWORD32)(-1));
    #endif

  if(!(en_task) || (task_param))
  {
    #if (TRACE_TYPE!=0)
      // Current task is no more alive, L1A changed the task parameters.
      // -> Trace "ABORT" on log file and screen.
      trace_fct(CST_TASK_KILLED, (UWORD32)(-1));
    #endif
  }
  else
  // Current task is still alive, check task identifier and debug number...
  {
    #if (TRACE_TYPE!=0)
      if((task != FB26) && (task != SB26) && (task != SBCNF26)) // DB cannot be used for FB26/SB26/SBCNF26 result.
        if((UWORD32)(l1s_dsp_com.dsp_db_r_ptr->d_task_md & 0xffff) !=
           (UWORD32)DSP_TASK_CODE[task])
          // Task id. different than the one expected...
          trace_fct(CST_DL_TASKS_DO_NOT_CORRESPOND,(UWORD32)(-1));
    #endif

    if((task != FB26) && (task != SB26)
       && (task != SBCNF26) && (attempt==12)
       #if ((REL99 == 1) && (FF_BHO == 1))
         && (task != FBSB)
       #endif
      ) // DB cannot be used for FB26/SB26/SBCNF26 result.
    {
        l1_check_com_mismatch(task);
    }
  }

  // Get task result from MCU/DSP read interface.
  // *********************************************

  switch(task)
  {
    case FBNEW :
    case FB51 :
    /*---------------------------------------------------*/
    /* Frequency burst detection result...               */
    /*---------------------------------------------------*/
    {
      if((en_task))
      // Check the task semaphore and the task enable bit. The reading
      // task body is executed only when the task semaphore is 0 and the
      // task is still enabled.
      // The semaphore can be set to 1 whenever L1A makes some changes
      // to the task parameters. The task can be disabled by L1A.
      {
        flag  = l1s_dsp_com.dsp_ndb_ptr->d_fb_det              & 0xffff; //  1 means FOUND.
        toa   = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_TOA]   & 0xffff; //  Unit is BIT.
        pm    = (l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM]   & 0xffff);
                                                                         //  WARNING... to be used!!!
        #if TESTMODE
          pm_fullres = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM] & 0xffff;  // F26.6
        #endif
        angle = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_ANGLE] & 0xffff; //  WARNING... to be used!!!
        snr   = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_SNR]   & 0xffff; //  WARNING... to be used!!!


        // Check FB detection flag and attempt:
        // If no detection and attempt < 12 than continue FB search
        // Attempt=11: special case: wait for next (last) read, as
        // other task may already be programmed in MFTAB (do not flush !!!)
        if(((!flag) && (attempt < 11)) || (attempt==11))
          break;

        // If FB detection occurs before 11th attempt, abort FB search
        if((flag == TRUE) && (attempt < 11))
          fb_abort_flag=TRUE;


        if (fb_abort_flag == TRUE)
        {
          if ((l1s_dsp_com.dsp_db_r_ptr->d_debug & 0xffff) != ((l1s.debug_time + (12 - attempt)) % 65536))
            l1_check_com_mismatch(task);
        }

//       l1_check_pm_error(pm, task);
         pm  = pm >> 5;

        #if TRACE_TYPE==3
          stats_samples_fb(flag,toa,pm,angle,snr);
        #endif

        #if (TRACE_TYPE==2 ) || (TRACE_TYPE==3)
          uart_trace(FB51);
        #endif

        // Update AFC: Call AFC control function (KALMAN filter).
        #if AFC_ALGO
          #if TESTMODE
            if (l1_config.afc_enable)
          #endif
            {
              WORD16 old_afc=l1s.afc;

           if((flag == TRUE) && (l1a_l1s_com.mode == CS_MODE))
           {
            #if (VCXO_ALGO == 0)
              l1s.afc = l1ctl_afc(AFC_OPEN_LOOP,
                                  &l1s.afc_frame_count,
                                  (WORD16)angle,
                                  0,
                                  l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].radio_freq);
            #else
              l1s.afc = l1ctl_afc(AFC_OPEN_LOOP,
                                  &l1s.afc_frame_count,
                                  (WORD16)angle,
                                  0,
                                  l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].radio_freq,l1a_l1s_com.mode);
            #endif
            #if L2_L3_SIMUL
              #if (DEBUG_TRACE == BUFFER_TRACE_AFC_OPEN)
                buffer_trace (4,(WORD16)angle,old_afc,l1s.afc,0);
              #endif
            #endif
              }
            }
        #endif

        // Call FB report function (send report msg to L1A).
        #if TESTMODE
          if (l1_config.TestMode)
            l1s_read_fb(task, flag, toa, attempt, pm_fullres, angle, snr);
          else
            l1s_read_fb(task, flag, toa, attempt, pm, angle, snr);
        #else
          l1s_read_fb(task, flag, toa, attempt, pm, angle, snr);
        #endif

        // The Frequency Burst detection task in Idle (FBNEW) and
        // Dedicated/SDCCH (FB51) are 1 shot tasks, they must be
        // disabled in L1S when they are completed. Disable it.
        l1a_l1s_com.l1s_en_task[task] = TASK_DISABLED;

        // the status is not used in D51 and D26 modes
        if (task != FB51 )
        {
          l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].status = NSYNC_COMPLETED;
        }
      }

      if ((fb_abort_flag == TRUE) || (attempt==12))
      {
        // FB task is completed, make it INACTIVE.
        l1s.task_status[task].current_status = INACTIVE;

        // Reset buffers and flags in NDB ...
        l1s_dsp_com.dsp_ndb_ptr->d_fb_det            = FALSE;
        l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_TOA] = 0;

        // This task is not compatible with Neigh. Measurement.
        // Clear "forbid_meas" to indicate when the task is complete.
        l1s.forbid_meas = 0;
      }

      // FB search finished before 11th attempt:
      // -reset DSP R/W pages, DSP tasks and TPU
      // -flush MFTAB and reset frame count
      // -adjust debug time
      if(fb_abort_flag)
      {
        l1d_reset_hw(l1s.tpu_offset);
        l1s.tpu_ctrl_reg |= CTRL_FB_ABORT; // set CTRL bit -> tpu_end_scenario
        l1s_clear_mftab(l1s.mftab.frmlst);
        l1s.frame_count = 0;

        // This task is not compatible with Neigh. Measurement.
        // Clear "forbid_meas" to indicate when the task is complete.
        l1s.forbid_meas = 0;
      }
    }
    break;

    case FB26 :
    /*---------------------------------------------------*/
    /* Frequency burst detection result...               */
    /*---------------------------------------------------*/
    {
      UWORD8 neigh_id;

      // read cell identifier.
      neigh_id = l1a_l1s_com.nsync.active_fb_id;

      if((en_task))
      // Check the task semaphore and the task enable bit. The reading
      // task body is executed only when the task semaphore is 0 and the
      // task is still enabled.
      // The semaphore can be set to 1 whenever L1A makes some changes
      // to the task parameters. The task can be disabled by L1A.
      {
        flag  = l1s_dsp_com.dsp_ndb_ptr->d_fb_det              & 0xffff; //  1 means FOUND.
        toa   = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_TOA]   & 0xffff; //  Unit is BIT.
        pm    = (l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM]   & 0xffff);
                                                                         //  WARNING... to be used!!!
        #if TESTMODE
          pm_fullres = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM] & 0xffff;  // F10.6
        #endif

        // CQ 19836: do not check PM on FB26
        //l1_check_pm_error(pm, task);
        pm = pm >> 5;

        angle = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_ANGLE] & 0xffff; //  WARNING... to be used!!!
        snr   = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_SNR]   & 0xffff; //  WARNING... to be used!!!

        // Call FB report function (send report msg to L1A).
        #if TESTMODE
          if (l1_config.TestMode)
            l1s_read_fb(task, flag, toa, NO_PAR, pm_fullres, angle, snr);
          else
            l1s_read_fb(task, flag, toa, NO_PAR, pm, angle, snr);
        #else
          l1s_read_fb(task, flag, toa, NO_PAR, pm, angle, snr);
        #endif
      }

      #if (TRACE_TYPE==2 ) || (TRACE_TYPE==3)
        uart_trace(FB26);
      #endif


      // The Frequency Burst detection task in Dedicated/TCH
      // is composed with several attempts managed in L1A.
      //    -> task is completed: set INACTIVE.
      l1s.task_status[task].current_status = INACTIVE;

      // Reset buffers and flags in NDB ...
      l1s_dsp_com.dsp_ndb_ptr->d_fb_det            = FALSE;
      l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_TOA] = 0;
    }
    break;

    case SB26 :
    case SBCNF26 :
    /*---------------------------------------------------*/
    /* Synchro. burst detection result...                */
    /*---------------------------------------------------*/
    {
      if((en_task) && !(task_param))
      // Check the task semaphore and the task enable bit. The reading
      // task body is executed only when the task semaphore is 0 and the

      // task is still enabled.
      // The semaphore can be set to 1 whenever L1A makes some changes
      // to the task parameters. The task can be disabled by L1A.
      {
        flag  = !(((l1s_dsp_com.dsp_ndb_ptr->a_sch26[0] & 0xffff) & (1<<B_SCH_CRC)) >> B_SCH_CRC); //  1 means ERROR.
        toa   = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_TOA]   & 0xffff;  //  Unit is BIT.
        pm    = (l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM]   & 0xffff);
                                                                          //  WARNING... to be used!!!
        #if TESTMODE
          pm_fullres = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM] & 0xffff;  // F26.6
        #endif

        angle = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_ANGLE] & 0xffff;
        snr   = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_SNR]   & 0xffff;
        data  = &(l1s_dsp_com.dsp_ndb_ptr->a_sch26[3]);                   // Set data block pointer (skip header).

        l1_check_pm_error(pm, task);
	pm = pm >> 5;

        // Call SB report function (send report msg to L1A).
        #if TESTMODE
          if (l1_config.TestMode)
            l1s_read_sb(task, flag, data, toa, attempt, pm_fullres, angle, snr);
          else
            l1s_read_sb(task, flag, data, toa, attempt, pm, angle, snr);
        #else
          l1s_read_sb(task, flag, data, toa, attempt, pm, angle, snr);
        #endif
      }
      #if (TRACE_TYPE==2 ) || (TRACE_TYPE==3)
        uart_trace(SB26);
      #endif


      // The Synchro Burst detection (SB26) and confirmation (SBCNF26)
      // tasks in Dedicated/TCH are enabling/disabling are fully
      // managed by L1A.
      //    -> task is completed: set INACTIVE.
      l1s.task_status[task].current_status = INACTIVE;

      // Reset buffers and flags in NDB ...
      l1s_dsp_com.dsp_ndb_ptr->a_sch26[0]    =  (1<<B_SCH_CRC);
    }
    break;

    case SB2 :
    case SBCONF :
    case SB51 :
    case SBCNF51 :
    /*---------------------------------------------------*/
    /* Synchro. burst detection result...                */
    /*---------------------------------------------------*/
    {
      if((en_task) && !(task_param))
      // Check the task semaphore and the task enable bit. The reading
      // task body is executed only when the task semaphore is 0 and the
      // task is still enabled.
      // The semaphore can be set to 1 whenever L1A makes some changes
      // to the task parameters. The task can be disabled by L1A.
      {
        UWORD8  neigh_id;

        if((task == SB2) || (task == SB51))
          neigh_id = l1a_l1s_com.nsync.active_sb_id;
        else
          neigh_id = l1a_l1s_com.nsync.active_sbconf_id;

        flag  = !(((l1s_dsp_com.dsp_db_r_ptr->a_sch[0] & 0xffff) & (1<<B_SCH_CRC)) >> B_SCH_CRC); //  1 means ERROR.
        toa   = l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_TOA]   & 0xffff;  //  Unit is BIT.
        pm    = (l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_PM]   & 0xffff);
                                                                           //  WARNING... to be used!!!
        #if TESTMODE
          pm_fullres = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM] & 0xffff;  // F26.6
        #endif

        angle = l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_ANGLE] & 0xffff;
        snr   = l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_SNR]   & 0xffff;
        data  = &(l1s_dsp_com.dsp_db_r_ptr->a_sch[3]);                     // Set data block pointer (skip header).

        l1ddsp_read_iq_dump(task);

        l1_check_pm_error(pm, task);
	pm = pm >> 5;

        // CQ30474. In case SNR is too low, the SB shall be considered as failed.
        // This is valuable for code running on target with DSP 3606.
#if (CODE_VERSION == NOT_SIMULATION)
       if ( snr < MIN_ACCEPTABLE_SNR_FOR_SB )
         flag = FALSE;
#endif

        #if L2_L3_SIMUL
          #if (DEBUG_TRACE == BUFFER_TRACE_OFFSET_NEIGH)
            buffer_trace(4, l1s.actual_time.fn, toa,pm, l1s_dsp_com.dsp_db_r_ptr->a_sch[0] & 0xffff);
          #endif
        #endif

        #if TRACE_TYPE==3
          stats_samples_sb(flag,toa,pm,angle,snr);
        #endif
        #if (TRACE_TYPE==2 ) || (TRACE_TYPE==3)
          if (task == SBCONF) uart_trace(SBCONF);
          else uart_trace(SB2);        // display result code...
        #endif

        // Update AFC: Call AFC control function (KALMAN filter).
        #if AFC_ALGO
          #if TESTMODE
            if (l1_config.afc_enable)
          #endif
            {
              WORD16 old_afc=l1s.afc;

           if((flag == TRUE) && (l1a_l1s_com.mode == CS_MODE))
           {
            #if (VCXO_ALGO == 0)
              l1s.afc = l1ctl_afc(AFC_OPEN_LOOP,
                                  &l1s.afc_frame_count,
                                  (WORD16)angle,
                                  0,
                                  l1a_l1s_com.nsync.list[neigh_id].radio_freq);
            #else
              l1s.afc = l1ctl_afc(AFC_OPEN_LOOP,
                                  &l1s.afc_frame_count,
                                  (WORD16)angle,
                                  0,
                                  l1a_l1s_com.nsync.list[neigh_id].radio_freq,l1a_l1s_com.mode);
            #endif

                #if L2_L3_SIMUL
                  #if (DEBUG_TRACE == BUFFER_TRACE_AFC_OPEN)
                    buffer_trace (4,(WORD16)angle,old_afc,l1s.afc,1);
                  #endif
                #endif
              }
            }
        #endif

        // Call SB report function (send report msg to L1A).
        #if TESTMODE
          if (l1_config.TestMode)
            l1s_read_sb(task, flag, data, toa, attempt, pm_fullres, angle, snr);
          else
            l1s_read_sb(task, flag, data, toa, attempt, pm, angle, snr);
        #else
          l1s_read_sb(task, flag, data, toa, attempt, pm, angle, snr);
        #endif

        // the status is not used in D51 and D26 modes
        if ((task != SBCNF51 ) && (task != SB51))
        {
          // SB2 activity completed for this neighbour cell.
          if((task != SB2) || ((task == SB2) && (attempt == 2)))
            l1a_l1s_com.nsync.list[neigh_id].status = NSYNC_COMPLETED;
        }
      }

      // All tasks are completed by this function except SB2 which
      // calls it twice. SB2 is then completed only when making the
      // second execution of this function.
      //    -> task is completed: set INACTIVE.
      if((task != SB2) || (task == SB2) && (attempt == 2))
      {
        l1s.task_status[task].current_status = INACTIVE;
        l1a_l1s_com.l1s_en_task[task] = TASK_DISABLED;
      }
    }
    break;
#if ((REL99 == 1) && (FF_BHO == 1))
    case FBSB :

    /*---------------------------------------------------*/
    /* Frequency + Synchro burst detection result...     */
    /*---------------------------------------------------*/
    {
      BOOL abort_flag = FALSE;

      if (l1a_l1s_com.nsync_fbsb.fb_found_attempt == 0)
      // Looking for FB
      {
        flag  = l1s_dsp_com.dsp_ndb_ptr->d_fb_det & 0xffff; //  flag = TRUE means FOUND.
        toa   = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_TOA]   & 0xffff; //  Unit is BIT.
        pm    = (l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM]   & 0xffff) >> 5;
#if TESTMODE
        pm_fullres = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM] & 0xffff;  // F26.6
#endif
        angle = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_ANGLE] & 0xffff;
        snr   = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_SNR]   & 0xffff;

        if (flag) // FB detected
        {
          // Store toa and attempt for future use
          l1a_l1s_com.nsync_fbsb.fb_toa = toa;
          l1a_l1s_com.nsync_fbsb.fb_found_attempt = attempt;

#if (TRACE_TYPE == 3)
          stats_samples_fb(flag, toa, pm, angle, snr);
#endif

#if (TRACE_TYPE == 2 ) || (TRACE_TYPE == 3)
          // uart_trace(FBSB);
#endif
        }
        else
        {
          if (attempt < 12)
          {
            // FB not found, some attempts remaining
            break;
          }
          else
          {
            // FB not found, no attempt remaining
            // Call FBSB report function (send report msg to L1A).
#if TESTMODE
            if (l1_config.TestMode)
              l1s_read_fbsb(task, attempt, FALSE, FALSE, (API *)NULL, toa, pm, angle, snr);
            else
#endif
              l1s_read_fbsb(task, attempt, FALSE, FALSE, (API *)NULL, toa, pm, angle, snr);

            abort_flag = TRUE;
          }
        }
      }
      else // if (l1a_l1s_com.nsync_fbsb.fb_found_attempt == 0)
      // Looking for SB
      {
        flag  = !(((l1s_dsp_com.dsp_db_r_ptr->a_sch[0] & 0xffff) & (1<<B_SCH_CRC)) >> B_SCH_CRC); //  //  flag = TRUE means FOUND.
        toa   = l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_TOA]   & 0xffff;  //  Unit is BIT.
        pm    = (l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_PM]   & 0xffff) >> 5;
#if TESTMODE
        pm_fullres = l1s_dsp_com.dsp_ndb_ptr->a_sync_demod[D_PM] & 0xffff;  // F26.6
#endif
        angle = l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_ANGLE] & 0xffff;
        snr   = l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_SNR]   & 0xffff;
        data  = &(l1s_dsp_com.dsp_db_r_ptr->a_sch[3]);  		   // Set data block pointer (skip header).

        if (flag) // SB detected
        {
          // SB found report SUCCESS

#if L2_L3_SIMUL
#if (DEBUG_TRACE == BUFFER_TRACE_OFFSET_NEIGH)
          buffer_trace(4, l1s.actual_time.fn, toa,pm, l1s_dsp_com.dsp_db_r_ptr->a_sch[0] & 0xffff);
#endif
#endif

#if (TRACE_TYPE == 3)
          stats_samples_sb(flag, toa, pm, angle, snr);
#endif

#if (TRACE_TYPE == 2 ) || (TRACE_TYPE == 3)
          // uart_trace(FBSB);        // display result code...
#endif

          // Call FBSB report function (send report msg to L1A).
#if TESTMODE
  	      if (l1_config.TestMode)
  	        l1s_read_fbsb(task, attempt, TRUE, TRUE, data, toa, pm, angle, snr);
  	      else
#endif
  	        l1s_read_fbsb(task, attempt, TRUE, TRUE, data, toa, pm, angle, snr);

  	      abort_flag = TRUE;
  	    }
  	    else // if (flag)
  	    {
  	      if (attempt < (l1a_l1s_com.nsync_fbsb.fb_found_attempt + 2))
  	      {
  	        // SB not found, one attempt remaining
  	        break;
  	      }
  	      else
  	      {
  	        // SB not found, no attempt remaining
  	        // Call FBSB report function (send report msg to L1A).
#if TESTMODE
 	        if (l1_config.TestMode)
 	          l1s_read_fbsb(task, attempt, TRUE, FALSE, (API *)NULL, toa, pm, angle, snr);
 	        else
#endif
  	          l1s_read_fbsb(task, attempt, TRUE, FALSE, (API *)NULL, toa, pm, angle, snr);

  	        abort_flag = TRUE;
  	      }
  	    }
      } // if(l1a_l1s_com.nsync_fbsb.fb_found_attempt == 0)


      if(abort_flag == TRUE)
      {
        //    -> task is completed: set INACTIVE.
        l1s.task_status[task].current_status = INACTIVE;
        l1a_l1s_com.l1s_en_task[task] = TASK_DISABLED;

        if (attempt < 14)
        {
          // FBSB search finished before last attempt:
          // -reset DSP R/W pages, DSP tasks and TPU
          // -flush MFTAB and reset frame count
          // -adjust debug time
          l1d_reset_hw(l1s.tpu_offset);
          l1s.tpu_ctrl_reg |= CTRL_FBSB_ABORT; // set CTRL bit -> tpu_end_scenario
          l1s_clear_mftab(l1s.mftab.frmlst);
          l1s.frame_count = 0;
        }
      }
    }
#endif // #if ((REL99 == 1) && (FF_BHO == 1))
  }

  // Flag the use of the MCU/DSP dual page read interface.
  // ******************************************************

  // Set flag used to change the read page at the end of "l1_synch" only if not
  // in dedicated/TCH mode (FB26,SB26,SBCNF26). Those task are not following the
  // common principle. They use only the NDB part of the MCU/DSP interface, no
  // page swapping is then needed.
#if ((REL99 == 1) && (FF_BHO == 1))
  if(((task != FB26) && (task != SB26) && (task != SBCNF26) && (task != FBNEW) && (task != FB51) && (task != FBSB)) ||
#else
  if(((task != FB26) && (task != SB26) && (task != SBCNF26) && (task != FBNEW) && (task != FB51)) ||
#endif // #if ((REL99 == 1) && (FF_BHO == 1))
     ((!fb_abort_flag) && (attempt==12)))
    l1s_dsp_com.dsp_r_page_used = TRUE;
}
#if (GSM_IDLE_RAM != 0)

/*-------------------------------------------------------*/
/* l1s_read_snb_dl()                                     */
/*-------------------------------------------------------*/
/*                                                       */
/* Description:                                          */
/* ------------                                          */
/* This function is a "COMPLEX" function used by the L1S */
/* tasks: BCCHS,NP,EP,ALLC,SMSCB.                        */
/* This function is the reading result function used for */
/* reading a serving cell burst acquisition result in    */
/* any mode except dedicated mode. Here is a summary of  */
/* the execution:                                        */
/*                                                       */
/*  - If SEMAPHORE(task) is low and task still enabled.  */
/*      - Traces and debug.                              */
/*      - Read control results and feed control algo.    */
/*      - Read DL DATA block from MCU/DSP interface.     */
/*  - Disactivate task.                                  */
/*  - Flag the use of the MCU/DSP dual page read         */
/*    interface.                                         */
/*                                                       */
/* Input parameters:                                     */
/* -----------------                                     */
/* "task"                                                */
/*   NP, Normal paging reading task.                     */
/*   EP, Extended paging reading task.                   */
/*   BCCHS, BCCH Serving reading task.                   */
/*   ALLC, All serving cell CCCH reading task.           */
/*   SMSCB, Short Message Service Cell Broadcast task.   */
/*                                                       */
/* "burst_id"                                            */
/*   BURST_1, 1st burst of the task.                     */
/*   BURST_2, 2nd burst of the task.                     */
/*   BURST_3, 3rd burst of the task.                     */
/*   BURST_4, 4th burst of the task.                     */
/*                                                       */
/* Input parameters from globals:                        */
/* ------------------------------                        */
/* "l1a_l1s_com.task_param"                              */
/*   task semaphore bit register. Used to skip the body  */
/*   of this function if L1A has changed or is changing  */
/*   some of the task parameters.                        */
/*                                                       */
/* "l1a_l1s_com.l1s_en_task"                             */
/*   L1S task enable bit register.                       */
/*                                                       */
/* Modified parameters from globals:                     */
/* ---------------------------------                     */
/* "l1s.task_status[task].current_status"                */
/*   current task status. It must be reset (INACTIVE)    */
/*   when the task is completed.                         */
/*   -> disactivate task.                                */
/*                                                       */
/* "l1s_dsp_com.dsp_r_page_used"                         */
/*   Flag used by the function which closes L1S          */
/*   execution ("l1s_end_manager()") to know if the      */
/*   MCU/DSP read page must be switched.                 */
/*   -> Set to 1.                                        */
/*                                                       */
/* Use of MCU/DSP interface:                             */
/* -------------------------                             */
/* "l1s_dsp_com.dsp_ndb_ptr"                             */
/*   pointer to the non double buffered part (NDB) of    */
/*   the MCU/DSP interface. This part is R/W for both    */
/*   DSP and MCU.                                        */
/*                                                       */
/* "l1s_dsp_com.dsp_db_r_ptr"                            */
/*   pointer to the double buffered part (DB) of the     */
/*   MCU/DSP interface. This pointer points to the READ  */
/*   page.                                               */
/*                                                       */
/*-------------------------------------------------------*/
void l1s_read_snb_dl(UWORD8 task, UWORD8 burst_id)
{
  UWORD32   toa;
  UWORD32   pm;
  UWORD32   angle;
  UWORD32   snr;
  BOOL      en_task;
  BOOL      task_param;
  UWORD16   radio_freq=0;
  static UWORD16 pwr_level;
#if L1_FF_MULTIBAND == 1
  UWORD16  operative_radio_freq;
#endif
  
#if (FF_L1_FAST_DECODING == 1)
  UWORD8 skipped_bursts = 0;
  BOOL fast_decoding_authorized = l1s_check_fast_decoding_authorized(task);
  BOOL fast_decoded = (l1a_apihisr_com.fast_decoding.status == C_FAST_DECODING_COMPLETE);
  if (fast_decoded)
  {
    skipped_bursts = BURST_4 - burst_id;
  }
#endif /* if (FF_L1_FAST_DECODING == 1) */

  /*--------------------------------------------------------*/
  /* READ SERVING CELL RECEIVE TASK RESULTS...              */
  /*--------------------------------------------------------*/
  /* Rem: only a partial result is present in the mcu<-dsp  */
  /* communication buffer. The DATA BLOCK content itself is */
  /* in the last comm. (BURST_4)                               */
  /*--------------------------------------------------------*/
  // Get "enable" task flag and "synchro semaphore" for current task.
  en_task    = l1a_l1s_com.l1s_en_task[task];
  task_param = l1a_l1s_com.task_param[task];

  if((en_task) && !(task_param))
  // Check the task semaphore and the task enable bit. The reading
  // task body is executed only when the task semaphore is 0 and the
  // task is still enabled.
  // The semaphore can be set to 1 whenever L1A makes some changes
  // to the task parameters. The task can be disabled by L1A.
  {
    // Traces and debug.
    // ******************

    #if (TRACE_TYPE!=0) && (TRACE_TYPE!=5)
      trace_fct(CST_L1S_READ_SNB_DL , (UWORD32)(-1));//OMAPS00090550
    #endif

    #if (TRACE_TYPE!=0)
      #if L1_GPRS
         if (l1a_l1s_com.dsp_scheduler_mode == GSM_SCHEDULER)
         {
            // Check task identifier...
            if((UWORD32)(l1s_dsp_com.dsp_db_r_ptr->d_task_d & 0xffff) != (UWORD32)DSP_TASK_CODE[task])
              trace_fct(CST_DL_TASKS_DO_NOT_CORRESPOND, (UWORD32)(-1));//OMAPS00090550

            // Check burst identifier...
            if((UWORD32)(l1s_dsp_com.dsp_db_r_ptr->d_burst_d & 0xffff) != burst_id)
              trace_fct(CST_DL_BURST_DOES_NOT_CORRESPOND, (UWORD32)(-1));//OMAPS00090550
         }
         else // GPRS scheduler
         {
            // Check burst identifier...
            if(l1ps_dsp_com.pdsp_db_r_ptr->d_burst_nb_gprs != burst_id)
              trace_fct(CST_DL_BURST_DOES_NOT_CORRESPOND, (UWORD32)(-1));
         }
      #else
        // Check task identifier...
        if((UWORD32)(l1s_dsp_com.dsp_db_r_ptr->d_task_d & 0xffff) != (UWORD32)DSP_TASK_CODE[task])
          trace_fct(CST_DL_TASKS_DO_NOT_CORRESPOND, (UWORD32)(-1));

        // Check burst identifier...
        if((UWORD32)(l1s_dsp_com.dsp_db_r_ptr->d_burst_d & 0xffff) != burst_id)
          trace_fct(CST_DL_BURST_DOES_NOT_CORRESPOND,(UWORD32)( -1));
      #endif
    #endif

    l1_check_com_mismatch(task);

    // Read control results and feed control algorithms.
    // **************************************************

    // Read control information.
    #if L1_GPRS
      if (l1a_l1s_com.dsp_scheduler_mode == GSM_SCHEDULER)
      {
        toa   =  l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_TOA]   & 0xffff;
        pm    = (l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_PM]    & 0xffff);
        angle =  l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_ANGLE] & 0xffff;
        snr   =  l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_SNR]   & 0xffff;
      }
      else
      {
        toa   =  l1ps_dsp_com.pdsp_db_r_ptr->a_burst_toa_gprs[0]   & 0xffff;
        pm    = (l1ps_dsp_com.pdsp_db_r_ptr->a_burst_pm_gprs[0]    & 0xffff);
        angle =  l1ps_dsp_com.pdsp_db_r_ptr->a_burst_angle_gprs[0] & 0xffff;
        snr   =  l1ps_dsp_com.pdsp_db_r_ptr->a_burst_snr_gprs[0]   & 0xffff;
      }
    #else
        toa   =  l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_TOA]   & 0xffff;
        pm    = (l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_PM]    & 0xffff);
        angle =  l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_ANGLE] & 0xffff;
        snr   =  l1s_dsp_com.dsp_db_r_ptr->a_serv_demod[D_SNR]   & 0xffff;
    #endif

    l1_check_pm_error(pm, task);
    pm = pm >> 5;

    // Update AGC: Call PAGC algorithm
    radio_freq = l1a_l1s_com.Scell_info.radio_freq;

#if (L1_FF_MULTIBAND == 0)

    l1a_l1s_com.Scell_IL_for_rxlev = l1ctl_pagc((UWORD8)pm, radio_freq,
                                                &l1a_l1s_com.last_input_level[radio_freq - l1_config.std.radio_freq_index_offset]);
#else // L1_FF_MULTIBAND = 1 below

  operative_radio_freq = 
    l1_multiband_radio_freq_convert_into_operative_radio_freq(radio_freq);
  l1a_l1s_com.Scell_IL_for_rxlev = l1ctl_pagc((UWORD8)pm, radio_freq,
                                                &l1a_l1s_com.last_input_level[operative_radio_freq]);  

#endif // #if (L1_FF_MULTIBAND == 0) else


#if (FF_L1_FAST_DECODING == 1)
    if (skipped_bursts>0)
    {
      l1ctl_pagc_missing_bursts(skipped_bursts);
    }
#endif /* if (FF_L1_FAST_DECODING == 1) */

    #if L2_L3_SIMUL
      #if (DEBUG_TRACE == BUFFER_TRACE_LNA)
      
        #if (L1_FF_MULTIBAND == 0)
            buffer_trace (4, 33, radio_freq,
                      l1a_l1s_com.last_input_level[radio_freq - l1_config.std.radio_freq_index_offset].input_level,
                      l1a_l1s_com.last_input_level[radio_freq - l1_config.std.radio_freq_index_offset].lna_off);
        
        #else // L1_FF_MULTIBAND = 1 below
        
            buffer_trace (4, 33, radio_freq,
                      l1a_l1s_com.last_input_level[operative_radio_freq].input_level,
                      l1a_l1s_com.last_input_level[operative_radio_freq].lna_off);
        
        #endif // #if (L1_FF_MULTIBAND == 0) else 
        
      #endif
    #endif

    #if TRACE_TYPE==3
      stats_samples_nb(toa,pm,angle,snr,burst_id,task);
    #endif

    // Update AFC: Call AFC control function (KALMAN filter).
    #if AFC_ALGO
      #if TESTMODE
        if (l1_config.afc_enable)
      #endif
        {
		  #if L2_L3_SIMUL
          #if (DEBUG_TRACE == BUFFER_TRACE_AFC_OPEN)//omaps00090550
          WORD16 old_afc  = l1s.afc;
          WORD16 old_count= l1s.afc_frame_count;
          #endif
          #endif



          #if (VCXO_ALGO == 0)
            l1s.afc = l1ctl_afc(AFC_CLOSED_LOOP, &l1s.afc_frame_count, (WORD16)angle, snr, radio_freq);
          #else
            l1s.afc = l1ctl_afc(AFC_CLOSED_LOOP, &l1s.afc_frame_count, (WORD16)angle, snr, radio_freq,l1a_l1s_com.mode);
          #endif

          #if L2_L3_SIMUL
            #if (DEBUG_TRACE == BUFFER_TRACE_AFC_OPEN)
              buffer_trace (4,(WORD16)angle,old_count,old_afc,l1s.afc);
            #endif
            #if (DEBUG_TRACE == BUFFER_TRACE_TOA)
             if (task == NP || task == EP)
               buffer_trace(5,
                           l1s.debug_time,
                           0xf1,
                           i,
                           l1s.afc,
                           angle );
            #endif
          #endif
        }
    #endif

    //Feed TOA histogram.
    #if (TOA_ALGO != 0)
    if (task != SMSCB)
   {
      #if (TOA_ALGO == 2)
        if(l1s.toa_var.toa_snr_mask == 0)
      #else
        if(l1s.toa_snr_mask == 0)
      #endif
      #if (RF_FAM == 2) // RF 2
        #if (TOA_ALGO == 2)
			if(l1a_l1s_com.Scell_IL_for_rxlev < IL_FOR_RXLEV_SNR)
			{
           l1s.toa_var.toa_shift = l1ctl_toa(TOA_RUN, l1a_l1s_com.mode, snr, toa);
			}
			else
			{
				l1s.toa_var.toa_shift = l1ctl_toa(TOA_RUN, l1a_l1s_com.mode, 0, toa);
			}
        #else
			if(l1a_l1s_com.Scell_IL_for_rxlev <IL_FOR_RXLEV_SNR)
            {
           l1s.toa_shift = l1ctl_toa(TOA_RUN, l1a_l1s_com.mode, snr, toa, &l1s.toa_update, &l1s.toa_period_count
#if (FF_L1_FAST_DECODING == 1)
               , skipped_bursts
#endif
               );
			}
			else
			{
                l1s.toa_shift = l1ctl_toa(TOA_RUN, l1a_l1s_com.mode, 0, toa, &l1s.toa_update, &l1s.toa_period_count
#if (FF_L1_FAST_DECODING == 1)
                    , skipped_bursts
#endif
                    );
			}
        #endif

        #if L2_L3_SIMUL
          #if (DEBUG_TRACE == BUFFER_TRACE_TOA )
           if (task == NP || task == EP)
             buffer_trace(5,
                     l1s.debug_time,
                     0xf0,
                     toa,
                     snr,
                     l1s.tpu_offset );
          #endif
        #endif
      #else // RF 2
        #if (TOA_ALGO == 2)
			if(l1a_l1s_com.Scell_IL_for_rxlev < IL_FOR_RXLEV_SNR)
			{
           l1s.toa_var.toa_shift = l1ctl_toa(TOA_RUN, l1a_l1s_com.mode, snr, toa);
			}
			else
			{
				l1s.toa_var.toa_shift = l1ctl_toa(TOA_RUN, l1a_l1s_com.mode, 0, toa);
			}
        #else
			if(l1a_l1s_com.Scell_IL_for_rxlev <IL_FOR_RXLEV_SNR)
            {
           l1s.toa_shift = l1ctl_toa(TOA_RUN, l1a_l1s_com.mode, snr, toa, &l1s.toa_update, &l1s.toa_period_count
#if (FF_L1_FAST_DECODING == 1)
               , skipped_bursts
#endif
               );
			}
			else
			{
                l1s.toa_shift = l1ctl_toa(TOA_RUN, l1a_l1s_com.mode, 0, toa, &l1s.toa_update, &l1s.toa_period_count
#if (FF_L1_FAST_DECODING ==1)
                    , skipped_bursts
#endif
                    );
			}
        #endif
      #endif // RF 2
   }
  #else  // TOA_ALGO
    #if L2_L3_SIMUL
      #if (DEBUG_TRACE == BUFFER_TRACE_TOA)
        if (task == NP || task == EP)
             buffer_trace(5,
                     l1s.debug_time,
                     0xf0,
                     toa,
                     snr,
                     l1s.tpu_offset );
      #endif
    #endif
  #endif // TOA_ALGO

    #if (TRACE_TYPE == 1) || (TRACE_TYPE == 4)
      RTTL1_FILL_DL_BURST(angle, snr, l1s.afc, task, pm, toa, l1a_l1s_com.Scell_IL_for_rxlev)
    #endif
    #if (TRACE_TYPE == 1) || (TRACE_TYPE == 4)
      l1_trace_burst_param(angle, snr, l1s.afc, task, pm, toa, l1a_l1s_com.Scell_IL_for_rxlev);
    #endif
    #if (BURST_PARAM_LOG_ENABLE == 1)
      l1_log_burst_param(angle, snr, l1s.afc, task, pm, toa, l1a_l1s_com.Scell_IL_for_rxlev);
    #endif

    // compute the Data bloc Power.
    // ******************************
    if(burst_id == BURST_1)
      pwr_level = 0;

    // add the burst power
    pwr_level += l1a_l1s_com.Scell_IL_for_rxlev;


    // Read downlink DATA block from MCU/DSP interface.

    if (task == NP)
    {
          toa_tab[burst_id] = toa;
  }

// added Enhanced RSSI
   if(l1s_dsp_com.dsp_ndb_ptr->a_cd[2] != 0xffff)
   {
        qual_acc_idle1[0]  += l1s_dsp_com.dsp_ndb_ptr->a_cd[2];
        //RX Qual value reporting- total number of decoded bits
         qual_acc_idle1[1] += 1;
   }

#if (FF_L1_FAST_DECODING == 1)
    /* Perform the reporting if
        - Burst is the 4th one (whether CRC is ok or not)
        - Fast decoding enabled and CRC already ok
    */
    if ( (burst_id == BURST_4) || fast_decoded )
#else /* #if (FF_L1_FAST_DECODING == 1) */
    if(burst_id == BURST_4)
#endif /* FF_L1_FAST_DECODING */
    {
      UWORD8 i;

      #if (TRACE_TYPE==2 ) || (TRACE_TYPE==3)
        uart_trace(task);
      #endif

      // the data power bloc = pwr_level/4.
#if (FF_L1_FAST_DECODING == 1)
      /* Data power block = pwr_level / (nb of bursts)*/
      pwr_level = pwr_level / (burst_id + 1);
#else /* #if (FF_L1_FAST_DECODING == 1) */
      // the data power bloc = pwr_level/4.
      pwr_level = pwr_level >> 2;
#endif /* #if (FF_L1_FAST_DECODING == 1) #else*/

#if (FF_L1_FAST_DECODING == 1)
      if(!fast_decoding_authorized)
      {
        /* When fast decoding wasn't used, burst_id is undefined (for the trace) */
        l1a_l1s_com.last_fast_decoding = 0;
      }
      else
      {
        l1a_l1s_com.last_fast_decoding = burst_id + 1;
      }
#endif /* #if (FF_L1_FAST_DECODING == 1) */

      // Read L3 frame block and send msg to L1A.
      #if L1_GPRS
        if (l1a_l1s_com.dsp_scheduler_mode == GSM_SCHEDULER)
          l1s_read_l3frm(pwr_level,&(l1s_dsp_com.dsp_ndb_ptr->a_cd[0]), task);
        else
          l1s_read_l3frm(pwr_level,&(l1ps_dsp_com.pdsp_ndb_ptr->a_dd_gprs[0][0]), task);
      #else
          l1s_read_l3frm(pwr_level,&(l1s_dsp_com.dsp_ndb_ptr->a_cd[0]), task);
      #endif

      #if L1_GPRS
        if (l1a_l1s_com.dsp_scheduler_mode == GSM_SCHEDULER)
      #endif
      {
        // reset buffers and flags in NDB ...
        // reset nerr....
        // reset A_CD contents.......
        l1s_dsp_com.dsp_ndb_ptr->a_cd[2]     =  0xffff;
        for (i=0;i<12;i++)
          l1s_dsp_com.dsp_ndb_ptr->a_cd[3+i] =  0x0000;
      }

    } // End if...
  } // End if...

  // The NP/EP task was enabled and could cancel a PTCCH burst
  // This incomplete PTCCH decoding block cause DSP troubles and so COM/PM errors
  // and then a recovery  => in this case restart the PTCCH from the burst 0
#if L1_GPRS
  if((task == NP)||(task == EP))
    if(l1a_l1s_com.l1s_en_task[PTCCH] == TASK_ENABLED)
      if(l1pa_l1ps_com.transfer.ptcch.activity & PTCCH_DL) // a PTCCH DL task is running
        if((l1s.actual_time.t2 >= 13) && (l1s.actual_time.t2 <= 17))  // only if the NP/EP remove a PTCCH activity
        {
          // Restart PTCCH DL task from the begining (i.e BURST 0).
          l1pa_l1ps_com.transfer.ptcch.activity ^= PTCCH_DL;  // disable PTCCH_DL activity running
          l1pa_l1ps_com.transfer.ptcch.request_dl = TRUE;     // restart PTCCH DL from the Burst0
        }
#endif

  // Deactivate task.
  // ******************

  // End of task -> task must become INACTIVE.
  // Rem: some TASKS (ALLC) can be pipelined and therefore must stay active if
  // they have already reentered the flow.
#if (FF_L1_FAST_DECODING == 1)
  if ( (burst_id == BURST_4) || fast_decoded )
#else /* #if (FF_L1_FAST_DECODING == 1) */
  if(burst_id == BURST_4)
#endif /* #if (FF_L1_FAST_DECODING == 1) #else*/

  {
#if (FF_L1_FAST_DECODING == 1)
    if((task == NP) || (task == NBCCHS))
    {
      if (l1a_apihisr_com.fast_decoding.contiguous_decoding == TRUE)
      {
        /* A new block has started, a new fast API IT is expected */
        l1a_apihisr_com.fast_decoding.contiguous_decoding = FALSE;
        l1a_apihisr_com.fast_decoding.status = C_FAST_DECODING_AWAITED;
      }
      else if(task == l1a_apihisr_com.fast_decoding.task)
      {
        /* Reset decoding status */
        l1a_apihisr_com.fast_decoding.status = C_FAST_DECODING_NONE;
      }
    }  /* end if tsk == NP */
#endif /* #if (FF_L1_FAST_DECODING == 1) */    
    if(l1s.task_status[task].current_status == RE_ENTERED)
      l1s.task_status[task].current_status = ACTIVE;
    else
      l1s.task_status[task].current_status = INACTIVE;
#if (FF_L1_FAST_DECODING == 1)
    if (burst_id != BURST_4)
    {
      /* Successful decode before the 4th burst, no other control/read activities are needed */
      l1s_clean_mftab(task, burst_id + 3);
      if(l1s.frame_count == (4 -burst_id))
      {
          l1s.frame_count = 1;
      }
    }
#endif /* #if (FF_L1_FAST_DECODING == 1) */
  }

  l1ddsp_read_iq_dump(task);
  // Flag the use of the MCU/DSP dual page read interface.
  // ******************************************************

  // Set flag used to change the read page at the end of "l1_synch".
  l1s_dsp_com.dsp_r_page_used = TRUE;
}


#endif

/*-------------------------------------------------------*/
/* l1s_read_fb()                                         */
/*-------------------------------------------------------*/
/* Parameters :                                          */
/* Return     :                                          */
/* Functionality : this function sends L1C_FB_INFO to L1A*/
/*-------------------------------------------------------*/
void l1s_read_fb(UWORD8 task, UWORD32 fb_flag, UWORD32 toa, UWORD32 attempt,
                 UWORD32 pm, UWORD32 angle, UWORD32 snr)
{
  xSignalHeaderRec  *msg;
  WORD32             modif_toa = 0;
  WORD32             ntdma  =0 ; //omaps000090550
  UWORD32            fn_offset =0 ; //omaps000090550 ;

  // For detail of the here below equation cf. BUG1558
  #define MAX_TOA_FOR_SB (D_NSUBB_DEDIC*48)+DL_ABB_DELAY/4-(SB_BURST_DURATION+DL_ABB_DELAY+SB_MARGIN)/4-2

  #if (TRACE_TYPE==5) && FLOWCHART
    trace_flowchart_dspres(dltsk_trace[task].name);
  #endif

  #if (TRACE_TYPE!=0)
    switch(task)
    {
      case FBNEW: trace_fct(CST_L1S_READ_FB, l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].radio_freq);break;
      case FB51:  trace_fct(CST_L1S_READ_FB51, l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].radio_freq);break;
      case FB26:  trace_fct(CST_L1S_READ_FB26, l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].radio_freq);break;
      default:    trace_fct(CST_UNKNOWN_FB, l1a_l1s_com.nsync.list[0].radio_freq);break;
    }
  #endif

  if(fb_flag == TRUE)
  {
    switch (task)
    {
      case FBNEW:
      case FB51:
      // Compute NTDMA & TOA taking into account the 23 bit guard for next SB receive window.
      {
        modif_toa = toa - (SB_MARGIN/4);     // Rem: unit is "BIT".
      }
      break;

      case FB26:
      // Compute TOA taking into account the 23 bit guard for next SB receive window
      // and the time diff. between a the fb search and a normal serving RX slot..
      // Rem: TOA cannot be less than "SB_MARGIN/4".
      {
        // Saturate TOA to MAX_TOA_FOR_SB since it is the last position compatible with the
        // SB26 tpu programming. MAX_TOA_FOR_SB + 1 would reject the TCHT/frame0 one frame later due
        // to an overlap of TPU scenarios.
        if(toa >= MAX_TOA_FOR_SB) toa = MAX_TOA_FOR_SB;

        modif_toa = toa + ((l1_config.params.fb26_anchoring_time + PROVISION_TIME - START_RX_FB)/4) - (SB_MARGIN/4); // Rem: unit is "BIT".
      }
      break;
    } // End of switch.

    if(modif_toa < 0)
    {
      modif_toa = (modif_toa + (TPU_CLOCK_RANGE/4)) * 4; // Unit is changed from bit to qbit.
      ntdma     = - 1;
    }
    else
    {
      ntdma     = modif_toa / (TPU_CLOCK_RANGE/4);
      modif_toa = (modif_toa - ntdma * (TPU_CLOCK_RANGE/4)) * 4;  // Unit is changed from bit to qbit.
    }

    switch (task)
    {
      case FBNEW:
      // Compute NTDMA & TOA taking into account the 23 bit guard for next SB receive window.
      {
        // "fn_offset" loaded with serving frame number corresponding to FB.
        // Keep a %51 format to prepare SB scheduling.
        fn_offset = (l1s.actual_time.fn - attempt + ntdma + MAX_FN) % 51;
      }
      break;

      case FB51:
      // Compute NTDMA & TOA taking into account the 23 bit guard for next SB receive window.
      {
        // "fn_offset" loaded with serving frame number corresponding to FB.
        // Keep a full frame number to allow scheduling of SB, 2 MF51 later.
        fn_offset = (l1s.actual_time.fn - attempt + ntdma + MAX_FN) % MAX_FN;
      }
      break;

      case FB26:
      {
        // "fn_offset" loaded with serving frame number corresponding to CTL(SB26).
        fn_offset = (l1s.actual_time.fn + 52 - 3) % MAX_FN;

        if(ntdma == 1) // 2nd frame...
          l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].sb26_offset = 1;
        else
          l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].sb26_offset = 0;
      }
      break;
    } // End of switch.

  } // End if.

  // Store TOA and FN offset in neighbor cell structure.
  l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].time_alignmt = modif_toa;
  l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].fn_offset    = fn_offset;

  // Create message T_L1C_FB_INFO.
  msg = os_alloc_sig(sizeof(T_L1C_FB_INFO));
  DEBUGMSG(status,NU_ALLOC_ERR)
  msg->SignalCode = L1C_FB_INFO;

  // Fill msg fields.
  ((T_L1C_FB_INFO *) (msg->SigP))->fb_flag    = fb_flag;
  ((T_L1C_FB_INFO *) (msg->SigP))->ntdma      = ntdma;
  ((T_L1C_FB_INFO *) (msg->SigP))->neigh_id   = l1a_l1s_com.nsync.active_fb_id;
  // Debug info or testmode
  ((T_L1C_FB_INFO *) (msg->SigP))->pm       = pm;
  ((T_L1C_FB_INFO*)(msg->SigP))->toa        = toa;
  ((T_L1C_FB_INFO*)(msg->SigP))->angle      = angle;
  ((T_L1C_FB_INFO*)(msg->SigP))->snr        = snr;
  ((T_L1C_FB_INFO *) (msg->SigP))->radio_freq = l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_fb_id].radio_freq;

  os_send_sig(msg, L1C1_QUEUE);
  DEBUGMSG(status,NU_SEND_QUEUE_ERR)
}

/*-------------------------------------------------------*/
/* l1s_read_sb()                                         */
/*-------------------------------------------------------*/
/* Parameters :                                          */
/* Return     :                                          */
/* Functionality : this function sends L1C_SB_INFO to L1A*/
/*-------------------------------------------------------*/
void l1s_read_sb(UWORD8 task, UWORD32 flag, API *data, UWORD32 toa, UWORD8 attempt,
                 UWORD32 pm, UWORD32 angle, UWORD32 snr)
{
  xSignalHeaderRec  *msg;
  UWORD8             bsic=0;
  UWORD32            sb;
  WORD32             modif_toa = 0;
  UWORD32            fn_offset    = 0;
  WORD32             time_alignmt = 0;
  T_NCELL_SINGLE    *cell_ptr = NULL; //omaps00090550 NULL;
  UWORD32            SignalCode=0;
  UWORD8             fn_delay     = 2; // SB result read with 2 frames delay.
  UWORD8             neigh_id=0;
  UWORD32            fn;

  switch(task)
  {
    case SB2 :
    case SB51 :
    case SB26 :
      // Get Neighbour cell ptr.
      cell_ptr = &l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_sb_id];
      neigh_id = l1a_l1s_com.nsync.active_sb_id;

      #if (TRACE_TYPE!=0)
        trace_fct(CST_L1S_READ_SB, cell_ptr->radio_freq);
      #endif

      SignalCode = L1C_SB_INFO;
      if(task == SB26) fn_delay = 3 - l1a_l1s_com.nsync.list[neigh_id].sb26_offset;
    break;

    case SBCONF :
    case SBCNF51 :
    case SBCNF26 :
      // Get Neighbour cell ptr.
      cell_ptr = &l1a_l1s_com.nsync.list[l1a_l1s_com.nsync.active_sbconf_id];
      neigh_id = l1a_l1s_com.nsync.active_sbconf_id;

      #if (TRACE_TYPE!=0)
        trace_fct(CST_L1S_READ_SBCONF, cell_ptr->radio_freq);
      #endif

      SignalCode = L1C_SBCONF_INFO;
      if(task == SBCNF26) fn_delay = 3 - l1a_l1s_com.nsync.list[neigh_id].sb26_offset;
    break;
  }

  #if (TRACE_TYPE==5) && FLOWCHART
    trace_flowchart_dspres(dltsk_trace[task].name);
  #endif

  // Compute NTDMA & TOA taking into account the 23 bit guard for next SB receive window.
  modif_toa = (toa - (SB_MARGIN/4)) * 4;       // Rem: unit is "QBIT".

  // Read SB content,.
  sb = data[0] & 0xffff | ((data[1] & 0xffff) << 16);

  if (flag == TRUE)
  // SB has been found...
  // We synchronized with a NEIGHBOUR cell.
  {
    UWORD32    t1, t2, t3, t3p;

    // extract BSIC, T1, T2, T3. Compute FN.
    // bsic contains NCC & BCC (GSM05.02, p9)
    bsic   = (UWORD8) ((sb & 0x000000fc) >> 2);

    t1  = ((sb & 0x00800000) >> 23 |   // t1 low
           (sb & 0x0000ff00) >> 7  |   // t1 midle
           (sb & 0x00000003) << 9);    // t1 high
    t2  =  (sb & 0x007c0000) >> 18;
    t3p = ((sb & 0x01000000) >> 24 |   // t3p low
           (sb & 0x00030000) >> 15);   // t3p high
    t3  =  (10*(t3p) +1);
    fn  =  (51 * ((t3 - t2 + 26) % 26) + t3 + (26 * 51 * t1));

    // Due to pipeline effect (CTRL.WORK.WORK.READ), sb content is taken into account
    // "fn_delay" TDMA later: that's why we use "fn + fn_delay..." in the offset computation.
    //
    // NEIGHBOUR DOMAIN:
    // -----------------
    // |                    |<----- 1 TDMA ----->| SB                 |                    |
    // |                    |                    |XXXX                |                    |
    // |                    |                    |                    |                    |
    // |                    |                    |  FN_neighbour(SB)  | FN_neighbour(SB)+1 | FN_neighbour(SB)+2
    // |                    |                    |                    |                    |
    //                                                                            offset   |
    //                                                                              +      |
    //                                                                             BOB     |
    //                                                                       |<----------->|
    // MS DOMAIN:                                                            |
    // ----------                  |                    |                    |                    |
    //        |        CTRL        |        WORK        |        WORK        |         READ       |
    //        |                    |                    |                    |                    |
    //
    // offset = FN_neighbour(SB)+ fn_delay - FN_serving(READ).
    // Bob: fine timing difference between the Neighbour timing and the MS internal timing.
    //
    fn_offset = (fn + fn_delay + MAX_FN - l1s.actual_time.fn) % MAX_FN;

    // "time_alignmt" must be corrected (use "modif_toa" from the SB read).
    // Check that "time_alignmt" do not become bigger than "TPU_CLOCK_RANGE".
    // If so, "fn_offset" must be decremented.
    if(cell_ptr != NULL)//OMAPS00090550
    time_alignmt   = cell_ptr->time_alignmt + modif_toa;
    if(time_alignmt >= TPU_CLOCK_RANGE)
    {
      time_alignmt -= TPU_CLOCK_RANGE;  // qbp for sim. Normal value is 1250;
      fn_offset    -= 1;                // WARNING....to be checked!!!!!!
    }
    else
    if(time_alignmt < 0)
    {
      time_alignmt += TPU_CLOCK_RANGE;  // qbp for sim. Normal value is 1250;
      fn_offset    += 1;                // WARNING....to be checked!!!!!!
    }
  }

  #if L1_RECOVERY
    if(flag)
    {
      // recovery flag is reseted because the system works fine
      // this check is performed in all modes.
      l1a_l1s_com.recovery_flag = FALSE;

      // Reset error flags and counter
      l1s.recovery.frame_count  = 0;
    }
  #endif

  // In all mode send result message to L1 Async.
  msg = os_alloc_sig(sizeof(T_MPHC_NCELL_SYNC_IND));
  DEBUGMSG(status,NU_ALLOC_ERR)
  msg->SignalCode   = SignalCode;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->sb_flag      = flag;
  if(cell_ptr != NULL)//OMAPS00090550
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->radio_freq   = cell_ptr->radio_freq;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->bsic         = bsic;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->fn_offset    = fn_offset;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->time_alignmt = time_alignmt;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->neigh_id     = neigh_id;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->attempt      = attempt;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->pm           = pm;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->toa          = toa;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->angle        = angle;
  ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->snr          = snr;


  #if (L1_EOTD == 1)
  // In EOTD mode read additional results
  if (l1a_l1s_com.nsync.eotd_meas_session == TRUE)
  {
    UWORD8  i;
    WORD16  d_eotd_first;
    WORD16  d_eotd_max;
    UWORD32 d_eotd_nrj;
    API     *data = &(l1s_dsp_com.dsp_ndb_ptr->a_eotd_crosscor[0]);
    UWORD32 fn_sb_neigh;

    d_eotd_first   = l1s_dsp_com.dsp_ndb_ptr->d_eotd_first & 0xffff;

    d_eotd_max     = l1s_dsp_com.dsp_ndb_ptr->d_eotd_max & 0xffff;

    fn_sb_neigh = (l1s.actual_time.fn - fn_delay + MAX_FN) % MAX_FN;
    ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->fn_sb_neigh  = fn_sb_neigh;

    d_eotd_nrj   = (l1s_dsp_com.dsp_ndb_ptr->d_eotd_nrj_low & 0xffff) |
                   ((l1s_dsp_com.dsp_ndb_ptr->d_eotd_nrj_high & 0x00ff) << 16);

    // L1 SW :
    //         CPS Cursor expects the accumulated signal level of the cross
    //         correlation (d_eotd_nrj) to be 16bit format. The DSP reports
    //         it as 24bit format (lsb aligned in a 32bit word).
    //         We scale the DSP result by right shifting by 8, hence preserving
    //         the MSBs

    d_eotd_nrj >>= 8;

    ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->eotd_data_valid = TRUE;
    ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->d_eotd_first    = d_eotd_first;
    ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->d_eotd_max      = d_eotd_max;
    ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->d_eotd_nrj      = d_eotd_nrj;
    ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->fn_in_SB        = fn;
    for (i=0; i<18; i++)
      ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->a_eotd_crosscor[i] = data[i] & 0xffff;;

    if(task == SBCNF26)
    {
      ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->toa_correction =
        l1a_l1s_com.nsync.eotd_cache_toa_tracking;
    }
    else
    {
      ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->toa_correction = 0;
    }

  }
  else
   ((T_MPHC_NCELL_SYNC_IND*)(msg->SigP))->eotd_data_valid = FALSE;
#endif



  os_send_sig(msg, L1C1_QUEUE);
  DEBUGMSG(status,NU_SEND_QUEUE_ERR)
}

/*-------------------------------------------------------*/
/* l1s_read_fbsb()                                       */
/*-------------------------------------------------------*/
/* Parameters :                                          */
/* Return     :                                          */
/* Functionality : sends L1C_FBSB_INFO to L1A            */
/*-------------------------------------------------------*/
#if ((REL99 == 1) && (FF_BHO == 1))
void l1s_read_fbsb(UWORD8 task, UWORD8 attempt, BOOL fb_flag,  BOOL sb_flag, API *data, UWORD32 toa, UWORD32 pm, UWORD32 angle, UWORD32 snr)
{
  xSignalHeaderRec  *msg;
  UWORD8             bsic = 0;
  UWORD32            fn_offset = 0;
  UWORD32            time_alignmt = 0;

  #if (TRACE_TYPE==5) && FLOWCHART
    trace_flowchart_dspres(dltsk_trace[task].name);
  #endif

  #if (TRACE_TYPE!=0)
    // trace_fct(CST_L1S_READ_FBSB, l1a_l1s_com.nsync_fbsb.radio_freq);
  #endif

  if ((fb_flag == TRUE) && (sb_flag == TRUE))
  {
    UWORD32    toa_qbit, sb, fn, fn2, t1, t2, t3, t3p;
    UWORD8     ntdma;

    // Read SB content,.
    sb = data[0] & 0xffff | ((data[1] & 0xffff) << 16);

    // extract BSIC, T1, T2, T3. Compute FN.
    // bsic contains NCC & BCC (GSM05.02, p9)
    bsic   = (UWORD8) ((sb & 0x000000fc) >> 2);

    t1  = ((sb & 0x00800000) >> 23 |   // t1 low
           (sb & 0x0000ff00) >> 7  |   // t1 midle
           (sb & 0x00000003) << 9);    // t1 high
    t2  =  (sb & 0x007c0000) >> 18;
    t3p = ((sb & 0x01000000) >> 24 |   // t3p low
           (sb & 0x00030000) >> 15);   // t3p high
    t3  =  (10*(t3p) +1);
    fn  =  (51 * ((t3 - t2 + 26) % 26) + t3 + (26 * 51 * t1));

    // _|-----------------------------------|___  : TPU WINDOW
    //                    |FB|          |SB|
    // _|---------------->|--------->|->|
    //        toa_fb       1 frame  toa_sb
    //
    //  we also need to take into account the 23 bit guard for SB receive window.

    toa_qbit = (l1a_l1s_com.nsync_fbsb.fb_toa + toa) * 4 + TPU_CLOCK_RANGE - SB_MARGIN;

    ntdma = toa_qbit / TPU_CLOCK_RANGE;

    fn_offset = (fn - l1s.actual_time.fn + attempt - ntdma + (2 * MAX_FN))% MAX_FN;

    time_alignmt = toa_qbit - (ntdma * TPU_CLOCK_RANGE);
  }

  // Create message T_L1C_FBSB_INFO.
  msg = os_alloc_sig(sizeof(T_L1C_FB_INFO));
  DEBUGMSG(status,NU_ALLOC_ERR)
  msg->SignalCode = L1C_FBSB_INFO;

  // Fill msg fields.
  ((T_L1C_FBSB_INFO *) (msg->SigP))->fb_flag      = fb_flag;
  ((T_L1C_FBSB_INFO *) (msg->SigP))->sb_flag      = sb_flag;
  ((T_L1C_FBSB_INFO *) (msg->SigP))->bsic         = bsic;
  ((T_L1C_FBSB_INFO *) (msg->SigP))->fn_offset    = fn_offset;
  ((T_L1C_FBSB_INFO *) (msg->SigP))->time_alignmt = time_alignmt;
  ((T_L1C_FBSB_INFO *) (msg->SigP))->pm           = pm;
  ((T_L1C_FBSB_INFO *) (msg->SigP))->toa          = toa;
  ((T_L1C_FBSB_INFO *) (msg->SigP))->angle        = angle;
  ((T_L1C_FBSB_INFO *) (msg->SigP))->snr          = snr;


  os_send_sig(msg, L1C1_QUEUE);
  DEBUGMSG(status,NU_SEND_QUEUE_ERR)
}
#endif // #if ((REL99 == 1) && (FF_BHO == 1))
#if (GSM_IDLE_RAM != 0)

/*-------------------------------------------------------*/
/* l1s_read_l3frm()                                      */
/*-------------------------------------------------------*/
/* Parameters :                                          */
/* Return     :                                          */
/* Functionality : reads NB data                         */
/*                 and formate MPHC_DATA_IND message     */
/*-------------------------------------------------------*/
void l1s_read_l3frm(UWORD8 pwr_level, API *info_address, UWORD32 task_rx)
{
  xSignalHeaderRec *msg;
  UWORD32           i,j;
  UWORD32           word32;
  UWORD32           rx_fail_flag;
  //OMAPS00090550 UWORD32           b_fire0;
  UWORD32           b_fire1;
  UWORD8            tc = l1s.actual_time.tc; // Default: tc loaded with current serving TC.
  UWORD16           radio_freq = l1a_l1s_com.Scell_info.radio_freq; // Default: radio_freq load with serving cell

  #if (TRACE_TYPE==5) && FLOWCHART
    trace_flowchart_dspres(dltsk_trace[task_rx].name);
  #endif

  // Allocate result message.

  #if (GSM_IDLE_RAM == 1)         // GPF not modified for GSM_IDLE_RAM -> enable Traffic Controller in L1S
    if (!READ_TRAFFIC_CONT_STATE)
    CSMI_TrafficControllerOn();
  #endif

  msg = os_alloc_sig(sizeof(T_MPHC_DATA_IND));
  DEBUGMSG(status,NU_ALLOC_ERR)

  switch(task_rx)
  {
    case NP:
      #if (TRACE_TYPE!=0)
        trace_fct(CST_L1S_READ_L3FRM__NP, l1a_l1s_com.Scell_info.radio_freq);
      #endif

      // Fill msg signal code and L2 channel.
      msg->SignalCode = L1C_NP_INFO;
      ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_CHANNEL_PCH;
    break;

    case EP:
      #if (TRACE_TYPE!=0)
        trace_fct(CST_L1S_READ_L3FRM__EP, l1a_l1s_com.Scell_info.radio_freq);
      #endif

      // Fill msg signal code and L2 channel.
      msg->SignalCode = L1C_EP_INFO;
      ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_CHANNEL_EPCH;
    break;

    case NBCCHS:
      #if (TRACE_TYPE!=0)
        trace_fct(CST_L1S_READ_L3FRM__NBCCHS, l1a_l1s_com.Scell_info.radio_freq);
      #endif

      // Fill msg signal code and L2 channel.
      msg->SignalCode = L1C_BCCHS_INFO;
      ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_CHANNEL_NBCCH;
    break;

    case EBCCHS:
      #if (TRACE_TYPE!=0)
        trace_fct(CST_L1S_READ_L3FRM__EBCCHS, l1a_l1s_com.Scell_info.radio_freq);
      #endif

      // Fill msg signal code and L2 channel.
      msg->SignalCode = L1C_BCCHS_INFO;
      ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_CHANNEL_EBCCH;
    break;

    case BCCHN:
    #if L1_GPRS
    case BCCHN_TRAN:
    #endif
    case BCCHN_TOP:
      #if (TRACE_TYPE!=0)
        if (task_rx == BCCHN)
          trace_fct(CST_L1S_READ_L3FRM__BCCHN, l1a_l1s_com.bcchn.list[l1a_l1s_com.bcchn.active_neigh_id_norm].radio_freq);
        else // BCCHN_TRAN and BCCHN_TOP tasks
          trace_fct(CST_L1S_READ_L3FRM__BCCHN, l1a_l1s_com.bcchn.list[l1a_l1s_com.bcchn.active_neigh_id_top].radio_freq);
      #endif

      // Fill msg signal code, L2 channel and get neighbour TC.
      msg->SignalCode = L1C_BCCHN_INFO;

      // Save neighbour ID.
      // With TC and Neighbour ID, L1A can manage the remaining BCCH requests.
      if (task_rx == BCCHN)
      {
        ((T_MPHC_DATA_IND *)(msg->SigP))->neigh_id = l1a_l1s_com.bcchn.active_neigh_id_norm;
        tc = l1a_l1s_com.bcchn.active_neigh_tc_norm;
        radio_freq = l1a_l1s_com.bcchn.list[l1a_l1s_com.bcchn.active_neigh_id_norm].radio_freq;
      }
      else // BCCHN_TRAN and BCCHN_TOP tasks
      {
        ((T_MPHC_DATA_IND *)(msg->SigP))->neigh_id = l1a_l1s_com.bcchn.active_neigh_id_top;
        tc = l1a_l1s_com.bcchn.active_neigh_tc_top;
        radio_freq = l1a_l1s_com.bcchn.list[l1a_l1s_com.bcchn.active_neigh_id_top].radio_freq;
      }

      if(tc >= 8)
      {
        // Reading Extended BCCH.
        tc -= 8;
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_CHANNEL_EBCCH;
      }
      else
      {
        // Reading Normal BCCH.
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_CHANNEL_NBCCH;
      }

    break;

    case ALLC:
      #if (TRACE_TYPE!=0)
        trace_fct(CST_L1S_READ_L3FRM__ALLC, l1a_l1s_com.Scell_info.radio_freq);
      #endif

      // Fill msg signal code, L2 channel and get neighbour TC.
      msg->SignalCode = L1C_ALLC_INFO;
      ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_CHANNEL_CCCH;
    break;

    case SMSCB:
      #if (TRACE_TYPE!=0)
        trace_fct(CST_L1S_READ_L3FRM__CB, l1a_l1s_com.Scell_info.radio_freq);
      #endif

      // Fill msg signal code, L2 channel and get neighbour TC.
      msg->SignalCode = L1C_CB_INFO;
      ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_CHANNEL_CBCH;
    break;

    #if L1_GPRS

      case PNP:
        #if (TRACE_TYPE!=0)
          trace_fct(CST_L1PS_READ_L3FRM__PNP, l1a_l1s_com.Scell_info.radio_freq);
        #endif

        // Fill msg signal code and L2 channel.
        msg->SignalCode = L1P_PNP_INFO;
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_PCHANNEL_PPCH;
        tc = l1pa_l1ps_com.pbcchs.rel_pos_to_report;
      break;

      case PEP:
        #if (TRACE_TYPE!=0)
          trace_fct(CST_L1PS_READ_L3FRM__PEP, l1a_l1s_com.Scell_info.radio_freq);
        #endif

        // Fill msg signal code and L2 channel.
        msg->SignalCode = L1P_PEP_INFO;
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_PCHANNEL_PEPCH;
        tc = l1pa_l1ps_com.pbcchs.rel_pos_to_report;
      break;

      case PALLC:
        #if (TRACE_TYPE!=0)
          trace_fct(CST_L1PS_READ_L3FRM__PALLC, l1a_l1s_com.Scell_info.radio_freq);
        #endif

        // Fill msg signal code and L2 channel.
        msg->SignalCode = L1P_PALLC_INFO;
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_PCHANNEL_PCCCH;
        tc = l1pa_l1ps_com.pbcchs.rel_pos_to_report;
      break;

      case PBCCHS:
        #if (TRACE_TYPE!=0)
          trace_fct(CST_L1PS_READ_L3FRM__PBCCHS, l1a_l1s_com.Scell_info.radio_freq);
        #endif

        // Fill msg signal code and L2 channel.
        msg->SignalCode = L1P_PBCCHS_INFO;
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_PCHANNEL_PBCCH;
        tc = l1pa_l1ps_com.pbcchs.rel_pos_to_report;
      break;

      case PBCCHN_IDLE:
      case PBCCHN_TRAN:
        #if (TRACE_TYPE!=0)
          trace_fct(CST_L1PS_READ_L3FRM__PBCCHN, l1pa_l1ps_com.pbcchn.bcch_carrier);
        #endif

        // Fill msg signal code and L2 channel.
        msg->SignalCode = L1P_PBCCHN_INFO;
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_PCHANNEL_PBCCH;
        tc = l1pa_l1ps_com.pbcchn.relative_position;
        radio_freq = l1pa_l1ps_com.pbcchn.bcch_carrier;
      break;

      case SINGLE:
        #if (TRACE_TYPE!=0)
          trace_fct(CST_L1PS_READ_L3FRM__SINGLE, l1a_l1s_com.Scell_info.radio_freq);
        #endif

        // Fill L2 channel.
        msg->SignalCode = L1P_PACCH_INFO;
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_PCHANNEL_PACCH;
        tc = l1pa_l1ps_com.pbcchs.rel_pos_to_report;
      break;

    #endif

    // WARNING !!! to be removed (for CBCH debugging).
    default:
      #if (TRACE_TYPE!=0)
        trace_fct(CST_L1PS_READ_L3FRM__UNKNOWN, l1a_l1s_com.Scell_info.radio_freq);
      #endif

      // Fill msg signal code, L2 channel and get neighbour TC.
      msg->SignalCode = L1C_CB_INFO;
      ((T_MPHC_DATA_IND *)(msg->SigP))->l2_channel = L2_CHANNEL_CCCH;
  }

  #if L1_GPRS
  if (l1a_l1s_com.dsp_scheduler_mode == GSM_SCHEDULER)
  #endif
  {
    // Compute detection flag.
 //OMAPS00090550   b_fire0 = ((info_address[0] & 0xffff) & (1<<B_FIRE0)) >> B_FIRE0;
    b_fire1 = ((info_address[0] & 0xffff) & (1<<B_FIRE1)) >> B_FIRE1;
    if(b_fire1 != 1)
      rx_fail_flag = FALSE;  // information block received successfully.
    else
      rx_fail_flag = TRUE;   // information block reception failled.

    // Get 23 bytes info. from DSP.
    for (j=0, i=0; i<11; i++)
    {
      word32 = info_address[3 + i]; // Get info word, rem: skip info. header.
      ((T_MPHC_DATA_IND *)(msg->SigP))->l2_frame.A[j++] = (word32 & 0x000000ff);
      ((T_MPHC_DATA_IND *)(msg->SigP))->l2_frame.A[j++] = (word32 & 0x0000ff00) >> 8;
    }
    ((T_MPHC_DATA_IND *)(msg->SigP))->l2_frame.A[22] = (info_address[14] & 0x000000ff);

    // reset buffers and flags in NDB ...
    // B_FIRE1 =1, B_FIRE0 =0 , BLUD =0
    info_address[0] = (1<<B_FIRE1);
  }
  #if L1_GPRS
    else // GPRS scheduler
    {
      // Compute detection flag.
      rx_fail_flag = ((*info_address & 0x0100) >> 8);

      // Get 24 bytes info. from DSP: CS1 meaningful block is of size 12 UWORD16 data.
      // !!! WARNING: word32 type is for compatibility with chipset == 0.
      // Can be word16 if only chipset == 2 is used.
      for (j=0, i=0; i<12; i++)
      {
        // Data downloaded from a_dd_gprs[0][]...
        word32 = info_address[4 + i]; // Get info word, rem: skip info. header.
        if(j<23)
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_frame.A[j++] = (word32 & 0x000000ff);
        if(j<23)
        ((T_MPHC_DATA_IND *)(msg->SigP))->l2_frame.A[j++] = (word32 & 0x0000ff00) >> 8;
      }

      // reset buffers and flags in NDB ...
      // reset CS_TYPE
      info_address[0] = CS_NONE_TYPE;
    }
  #endif

  // Report detection flag.
  if((l1s_dsp_com.dsp_db_r_ptr->d_debug & 0xffff ) != (l1s.debug_time & 0xffff )) // in case of COM error the block is false
    ((T_MPHC_DATA_IND *)(msg->SigP))->error_flag = TRUE;
  else
    ((T_MPHC_DATA_IND *)(msg->SigP))->error_flag = rx_fail_flag;

  // be careful: radio_freq is setted at the beging of the code and may be modified inside the "case"
  ((T_MPHC_DATA_IND *)(msg->SigP))->radio_freq = radio_freq;

   // be careful: tc is setted at the beging of the code and may be modified inside the "case"
  ((T_MPHC_DATA_IND *)(msg->SigP))->tc = tc;

  // convert in ETSI format and send it back to L3
  ((T_MPHC_DATA_IND *)(msg->SigP))->ccch_lev = l1s_encode_rxlev(pwr_level);

#if (FF_L1_FAST_DECODING == 1)
  // Update the fn according to the number of the last decoded burst (2, 3 or 4) in case of fast paging: alignment with a block boudary
  if(l1a_l1s_com.last_fast_decoding == 0)
    // fast decoding was not not used
  ((T_MPHC_DATA_IND *)(msg->SigP))->fn       = l1s.actual_time.fn;
  else
    // fast decoding done, fn is incremented up to 2 frames (if fast decoding with 2 bursts), 0 if fast decoding with 4 bursts (normal decoding)
    ((T_MPHC_DATA_IND *)(msg->SigP))->fn       = l1s.actual_time.fn + BURST_4 + 1 - l1a_l1s_com.last_fast_decoding;
#else
    ((T_MPHC_DATA_IND *)(msg->SigP))->fn       = l1s.actual_time.fn;
#endif
  // send message...

  os_send_sig(msg, L1C1_QUEUE);
  DEBUGMSG(status,NU_SEND_QUEUE_ERR)
}

#endif
