/*
 * Decompiled with CFR 0.152.
 */
package com.ti.xslt.extension;

import com.ti.xslt.extension.DocbookAux;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;

public class TableCalc {
    private double[] tableWidths = null;
    private double[] tableWidthsZero = null;
    private double[] tableWidthsThead = null;
    private double[] tableWidthsTheadZero = null;
    private int widthsOk = 0;
    private ArrayList sizes = null;
    private ArrayList strings = null;
    private int rows = 0;
    private int cols = 0;
    private double[] actRowSizes;
    private String[] actRowStrings;
    private int actCol = 0;
    private static int maxSortHandle = 0;
    private static HashMap instances = new HashMap();
    private boolean sorted = true;
    private ArrayList elements = new ArrayList();
    private static final int LINK_NONE = 0;
    private static final int LINK_INTERNAL = 1;
    private static final int LINK_EXTERNAL = 2;
    private static final int LINK_URL = 3;

    public static int startTable(int cols) {
        int handle = maxSortHandle++;
        instances.put(Integer.toString(handle).intern(), new TableCalc(cols));
        return handle;
    }

    private TableCalc(int cols) {
        this.cols = cols;
        this.sizes = new ArrayList();
        this.strings = new ArrayList();
    }

    private void newRow(int cols) {
        this.actRowSizes = new double[cols];
        this.actRowStrings = new String[cols];
        int i = 0;
        while (i < cols) {
            this.actRowSizes[i] = 0.0;
            this.actRowStrings[i] = null;
            ++i;
        }
        this.sizes.add(this.actRowSizes);
        this.strings.add(this.actRowStrings);
    }

    public static void addTableEntry(int handle, String contents) {
        TableCalc.addTableEntry(handle, contents, contents, false);
    }

    public static void addTableEntry(int handle, String contents, String displayContents) {
        TableCalc.addTableEntry(handle, contents, displayContents, true);
    }

    private static void addTableEntry(int handle, String contents, String displayContents, boolean disableOutputEscaping) {
        TableCalc inst = (TableCalc)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            inst.addTableEntry(contents, displayContents, 0, disableOutputEscaping);
        }
    }

    public static void addTableEntryLink(int handle, String contents) {
        TableCalc inst = (TableCalc)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            inst.addTableEntry(contents, contents, 1, false);
        }
    }

    public static long getRelWidth(int handle, int colNr) {
        TableCalc inst = (TableCalc)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            return inst.getRelWidth(colNr, false, false);
        }
        return -2L;
    }

    public static String getTableBody(int handle) {
        return TableCalc.getTableBody(handle, false);
    }

    public static String getTableBody(int handle, boolean thead) {
        return TableCalc.getTableBody(handle, thead, false);
    }

    public static String getTableBody(int handle, boolean thead, boolean omitEmptyCols) {
        TableCalc inst = (TableCalc)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            return inst.getTableBody(thead, omitEmptyCols);
        }
        return "";
    }

    public static String getTableBody(int handle, boolean thead, boolean omitEmptyCols, String tgroupattr) {
        TableCalc inst = (TableCalc)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            return inst.getTableBody(thead, omitEmptyCols, tgroupattr);
        }
        return "";
    }

    private String getTableBody(boolean thead, boolean omitEmptyCols, String tgroupattr) {
        int suppressedCols = 0;
        int i = 0;
        while (i < this.cols) {
            long relWidth = this.getRelWidth(i, thead, omitEmptyCols);
            if (omitEmptyCols && relWidth == 0L) {
                ++suppressedCols;
            }
            ++i;
        }
        return "\n<tgroup " + (tgroupattr != null ? tgroupattr : "") + " cols=\"" + (this.cols - suppressedCols) + "\">" + this.getTableBody(thead, omitEmptyCols) + "</tgroup>\n";
    }

    private String getTableBody(boolean thead, boolean omitEmptyCols) {
        StringBuffer table = new StringBuffer("\n");
        boolean[] omitCols = new boolean[this.cols];
        int i = 0;
        while (i < this.cols) {
            long relWidth = this.getRelWidth(i, thead, omitEmptyCols);
            if (!omitEmptyCols || relWidth != 0L) {
                table.append("<colspec colwidth=\"" + (relWidth > 0L ? relWidth : 1L) + "*\"/>\n");
                omitCols[i] = false;
            } else {
                omitCols[i] = true;
            }
            ++i;
        }
        if (!thead) {
            table.append("<tbody>\n");
        } else {
            table.append("<thead>\n");
        }
        i = 0;
        while (i < this.rows) {
            table.append("<row>\n");
            String[] rs = (String[])this.strings.get(i);
            if (rs != null) {
                int k = 0;
                while (k < this.cols) {
                    if (!omitCols[k]) {
                        table.append("<entry>" + (rs[k] != null ? rs[k] : "") + "</entry>\n");
                    }
                    ++k;
                }
            }
            table.append("</row>\n");
            if (i == 0 && thead) {
                table.append("</thead>\n<tbody>\n");
            }
            ++i;
        }
        table.append("</tbody>\n");
        return table.toString();
    }

    private long getRelWidth(int colNr, boolean thead, boolean zeroEmptyCols) {
        if (colNr >= this.cols) {
            return -3L;
        }
        return new Double(this.calculateWidths(thead, zeroEmptyCols)[colNr] * 100.0).longValue();
    }

    private double[] calculateWidths(boolean thead, boolean zeroEmptyCols) {
        double[] rs;
        int i;
        double[] tw;
        int startRow = 0;
        if (thead) {
            startRow = 1;
        }
        if (thead && zeroEmptyCols) {
            if ((this.widthsOk & 2) != 0) {
                return this.tableWidthsTheadZero;
            }
            this.widthsOk &= 2;
            tw = new double[this.cols];
            this.tableWidthsTheadZero = tw;
        } else if (thead) {
            if ((this.widthsOk & 1) != 0) {
                return this.tableWidthsThead;
            }
            this.widthsOk &= 1;
            tw = new double[this.cols];
            this.tableWidthsThead = tw;
        } else if (zeroEmptyCols) {
            if ((this.widthsOk & 4) != 0) {
                return this.tableWidthsZero;
            }
            this.widthsOk &= 4;
            tw = new double[this.cols];
            this.tableWidthsZero = tw;
        } else {
            if ((this.widthsOk & 8) != 0) {
                return this.tableWidths;
            }
            this.widthsOk &= 8;
            tw = new double[this.cols];
            this.tableWidths = tw;
        }
        if (zeroEmptyCols) {
            i = 0;
            while (i < this.cols) {
                tw[i] = 0.0;
                int k = startRow;
                while (k < this.rows) {
                    rs = (double[])this.sizes.get(k);
                    if (tw[i] < rs[i]) {
                        tw[i] = rs[i];
                    }
                    ++k;
                }
                if (tw[i] < 0.0) {
                    tw[i] = 0.0;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.cols) {
                tw[i] = 0.0;
                int k = startRow;
                while (k < this.rows) {
                    rs = (double[])this.sizes.get(k);
                    if (tw[i] < rs[i]) {
                        tw[i] = rs[i];
                    }
                    ++k;
                }
                ++i;
            }
            boolean k = false;
            double min = -1.0;
            int i2 = 0;
            while (i2 < this.cols) {
                if (tw[i2] > 0.0 && (min < 0.0 || min > tw[i2])) {
                    min = tw[i2];
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.cols) {
                if (tw[i2] <= 0.0) {
                    tw[i2] = min;
                }
                ++i2;
            }
        }
        double twsum = 0.0;
        int i3 = 0;
        while (i3 < this.cols) {
            twsum += tw[i3];
            ++i3;
        }
        double twmid = twsum / (double)this.cols;
        int i4 = 0;
        while (i4 < this.cols) {
            if (tw[i4] > 0.0) {
                tw[i4] = (tw[i4] * 5.0 + twmid * 2.0) / 7.0;
            }
            ++i4;
        }
        twsum /= 16.0;
        i4 = 0;
        while (i4 < this.cols) {
            if (tw[i4] < twsum && tw[i4] > 0.0) {
                tw[i4] = twsum;
            }
            ++i4;
        }
        return tw;
    }

    private void addTableEntry(String string, String displayString, int linkType, boolean disableOutputEscaping) {
        Rectangle2D box;
        FontRenderContext frc;
        this.widthsOk = 0;
        double width = -1.0;
        if (string == null) {
            string = "";
        } else if (!disableOutputEscaping) {
            string = string.replaceAll("&", "&amp;");
            string = string.replaceAll("<", "&lt;");
        }
        Font font = new Font("Serif", 0, 10);
        if (font != null && (frc = new FontRenderContext(null, false, true)) != null && (box = font.getStringBounds(displayString, frc)) != null) {
            width = box.getWidth();
        }
        if (this.actCol == 0) {
            this.newRow(this.cols);
        }
        switch (linkType) {
            case 1: {
                string = DocbookAux.putLink(string);
                break;
            }
        }
        this.actRowStrings[this.actCol] = string;
        this.actRowSizes[this.actCol] = width;
        if (++this.actCol >= this.cols) {
            ++this.rows;
            this.actCol = 0;
        }
    }

    public static void endTable(int handle) {
        instances.remove(Integer.toString(handle).intern());
    }
}

