/*
 * Decompiled with CFR 0.152.
 */
package com.ti.xslt.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ForwardRefSort {
    private String circularInfo = "";
    private ArrayList circularMemory = new ArrayList();
    private int returnIndex = 0;
    private boolean circular = false;
    private static int maxSortHandle = 0;
    private static HashMap instances = new HashMap();
    private boolean sorted = true;
    private ArrayList elements = new ArrayList();
    private Element actElement = null;

    public static int startSort() {
        int handle = maxSortHandle++;
        instances.put(Integer.toString(handle).intern(), new ForwardRefSort());
        return handle;
    }

    public static void addElement(int handle) {
        ForwardRefSort inst = (ForwardRefSort)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            inst.addElement();
        }
    }

    public static void addElementName(int handle, String elementName) {
        ForwardRefSort inst = (ForwardRefSort)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            inst.addElementName(elementName);
        }
    }

    public static void addLinkName(int handle, String linkName) {
        ForwardRefSort inst = (ForwardRefSort)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            inst.addLinkName(linkName);
        }
    }

    public static int getNextForwardRefResolved(int handle) {
        ForwardRefSort inst = (ForwardRefSort)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            return inst.getNextForwardRefResolved();
        }
        return -2;
    }

    public static int hasNextForwardRefResolved(int handle) {
        ForwardRefSort inst = (ForwardRefSort)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            return inst.hasNextForwardRefResolved();
        }
        return -2;
    }

    public static void endSort(int handle) {
        instances.remove(Integer.toString(handle).intern());
    }

    public static String getCircularInfo(int handle) {
        ForwardRefSort inst = (ForwardRefSort)instances.get(Integer.toString(handle).intern());
        if (inst != null) {
            return inst.getCircularInfo();
        }
        return "";
    }

    private String getCircularInfo() {
        return this.circularInfo;
    }

    private int getNextForwardRefResolved() {
        if (!this.sorted) {
            this.circular = false;
            this.circularMemory = new ArrayList();
            this.circularInfo = "";
            this.returnIndex = 0;
            this.sortResolveForwardRef();
            this.sorted = true;
        }
        if (this.circular) {
            return -3;
        }
        if (this.elements.size() > this.returnIndex) {
            return ((Element)this.elements.get(this.returnIndex++)).elementPos;
        }
        return -1;
    }

    private int hasNextForwardRefResolved() {
        if (!this.sorted) {
            this.circular = false;
            this.circularMemory = new ArrayList();
            this.circularInfo = "";
            this.returnIndex = 0;
            this.sortResolveForwardRef();
            this.sorted = true;
        }
        if (this.circular) {
            return -3;
        }
        if (this.elements.size() > this.returnIndex) {
            return 1;
        }
        return -1;
    }

    private void sortResolveForwardRef() {
        int nextElPos = 0;
        Iterator itEl = this.elements.iterator();
        while (itEl.hasNext()) {
            Element el = (Element)itEl.next();
            ++nextElPos;
            if (el == null) continue;
            Iterator itLinks = el.elementLinks.iterator();
            while (itLinks.hasNext()) {
                String linkName = (String)itLinks.next();
                if (linkName == null) continue;
                int checkElPos = nextElPos - 1;
                while (checkElPos < this.elements.size()) {
                    Element checkEl = (Element)this.elements.get(checkElPos);
                    if (checkEl != null && checkEl.isElementName(linkName)) {
                        if (this.checkIsCircular(this.elements, el, checkElPos)) {
                            this.circular = true;
                            return;
                        }
                        this.elements.remove(el);
                        this.elements.add(checkElPos, el);
                        this.sortResolveForwardRef();
                        return;
                    }
                    ++checkElPos;
                }
            }
        }
    }

    private boolean checkIsCircular(ArrayList elements, Element el, int checkElPos) {
        int elPos = elements.indexOf(el);
        int[] elOrder = new int[elements.size()];
        int i = 0;
        Iterator it2 = elements.iterator();
        while (it2.hasNext()) {
            elOrder[i++] = ((Element)it2.next()).elementPos;
        }
        Iterator it = this.circularMemory.iterator();
        while (it.hasNext()) {
            MoveOp op = (MoveOp)it.next();
            if (op == null || op.element != el || op.elPos != elPos || op.checkElPos != checkElPos) continue;
            boolean notCircular = false;
            i = 0;
            while (i < elOrder.length) {
                if (elOrder[i] != op.elOrder[i]) {
                    notCircular = true;
                    break;
                }
                ++i;
            }
            if (notCircular) continue;
            this.circularInfo = el != null && el.elementNames != null && el.elementNames.size() > 0 ? (String)el.elementNames.get(0) : "<UNKNOWN>";
            return true;
        }
        this.circularMemory.add(new MoveOp(el, elPos, checkElPos, elOrder));
        return false;
    }

    private void addElement() {
        this.actElement = new Element(this.elements.size());
        this.elements.add(this.actElement);
    }

    private void addElementName(String elementName) {
        if (this.actElement != null) {
            this.actElement.elementNames.add(elementName);
        }
        this.sorted = false;
    }

    private void addLinkName(String linkName) {
        if (this.actElement != null && linkName != null) {
            this.actElement.elementLinks.add(linkName);
        }
        this.sorted = false;
    }

    public class MoveOp {
        private int[] elOrder = null;
        public int checkElPos = -1;
        public int elPos = -1;
        public Element element = null;

        public MoveOp(Element el, int elPos, int checkElPos, int[] elOrder) {
            this.element = el;
            this.elPos = elPos;
            this.checkElPos = checkElPos;
            this.elOrder = elOrder;
        }
    }

    private static class Element {
        private int elementPos = -1;
        ArrayList elementNames = new ArrayList();
        ArrayList elementLinks = new ArrayList();

        public boolean isElementName(String linkName) {
            if (linkName != null && this.elementNames != null) {
                Iterator it = this.elementNames.iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    if (name == null || !name.equals(linkName)) continue;
                    return true;
                }
            }
            return false;
        }

        public Element(int elementPos) {
            this.elementPos = elementPos;
        }
    }
}

