/*****************************************************************************/
/* stdlib.h   V1.22e                                                          */
/* Copyright (c) 1995-1997 Texas Instruments Incorporated                    */
/*****************************************************************************/

#ifndef _STDLIB
#define _STDLIB

#ifdef __cplusplus
extern "C" {
#endif

typedef struct { int quot, rem; } div_t, ldiv_t;

#define MB_CUR_MAX    1

#ifndef NULL
#define NULL          0
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif

#ifndef _WCHAR_T
#define _WCHAR_T
typedef char wchar_t;
#endif

#define EXIT_FAILURE  0
#define EXIT_SUCCESS  1

#define RAND_MAX 32767

#ifdef _INLINE
#define __INLINE static inline
#else
#define __INLINE
#endif

/*---------------------------------------------------------------*/
/* NOTE - Normally, abs, labs, and fabs are expanded inline, so  */
/*        no formal definition is really required. However, ANSI */
/*        requires that they exist as separate functions.        */
/*---------------------------------------------------------------*/
         int           abs (int val); 
         long          labs(long val);
        
         int           atoi(const char *st);
__INLINE long          atol(const char *st);
__INLINE double        atof(const char *st);

         long          strtol (const char *st, char **endptr, int base);
         unsigned long strtoul(const char *st, char **endptr, int base);
         double        strtod (const char *st, char **endptr);

         int           rand (void);
         void          srand(unsigned seed);

         void         *calloc  (size_t num, size_t size);
         void         *malloc  (size_t size);
         void         *realloc (void *ptr, size_t size);
         void          free    (void *ptr);
	 void         *memalign(size_t aln, size_t size);

         void          abort  (void); 
         int           atexit (void (*func)(void));
         void         *bsearch(const void *key, 
			       const void *base, 
			       size_t nmemb, 
			       size_t size, 
			       int (*compar)(const void *,const void *)); 
         void          qsort  (void *base, 
			       size_t nmemb,
			       size_t size, 
			       int (*compar)(const void *, const void *));
         void          exit   (int status);

         div_t         div (int numer, int denom);
         ldiv_t        ldiv(long numer, long denom);

         char         *getenv(const char *string);
	 int           system(const char *name);

#ifdef _INLINE

/****************************************************************************/
/*  atof                                                                    */
/****************************************************************************/
static inline double atof(const char *st)
{
   return strtod(st, (char **)0);
}

/****************************************************************************/
/*  atol                                                                    */
/****************************************************************************/
static inline long atol(register const char *st)
{
   return atoi(st);
}

#endif
#undef __INLINE

#ifdef __cplusplus
}
#endif

#endif

