/*****************************************************************************/
/* math.h     V1.22e                                                          */
/* Copyright (c) 1995-1997 Texas Instruments Incorporated                    */
/*****************************************************************************/

#ifndef _MATH
#define _MATH


#define HUGE_VAL  1.7976931348623124e+308

#if defined (_INLINE) && 0
#define __INLINE static inline
#else
#define __INLINE
#endif

/***************************************************************/
/* FUNCTION DEFINITIONS.                                       */
/***************************************************************/
         double asin(double x);
         double acos(double x);
         double atan(double x);
         double atan2(double y, double x);
__INLINE double ceil(double x);
         double cos(double x);
         double cosh(double x);
         double exp(double x);
         double fabs(double x); 
__INLINE double floor(double x);
__INLINE double fmod(double x, double y);
         double frexp(double x, int *exp);
         double ldexp(double x, int exp);
         double log(double x);
         double log10(double x);
         double modf(double x, double *y); 
         double pow(double x, double y);
         double sin(double x);
         double sinh(double x);
         double tan(double x);
         double tanh(double x);
         double sqrt(double x);

#if defined (_INLINE) && 0

/****************************************************************************/
/*  floor                                                                   */
/****************************************************************************/
static inline double floor(double x) 
{
     double y; 
     return (modf(x, &y) < 0 ? y - 1 : y);
}

/****************************************************************************/
/*  ceil                                                                    */
/****************************************************************************/
static inline double ceil(double x)
{
     double y; 
     return (modf(x, &y) > 0 ? y + 1 : y);
}


/****************************************************************************/
/*  fmod                                                                    */
/****************************************************************************/
static inline double fmod(double x, double y)
{
     double d = fabs(x); 
     if (d - fabs(y) == d) return (0);
     modf(x/y, &d);  
     return (x - d * y);
}

#endif

#undef __INLINE

#endif
