#//START_MODULE_HEADER///////////////////////////////////////////////////////
#
#  Filename:    tpi_tnet.tcl
#
#  Description: Tcl script to initialize connection to ToolNet interface with
#               Quartus.
#
#  Authors:    	Altera Corporation 
#
#               Copyright (c)  Altera Corporation 1998 - 1999
#               All rights reserved.
#
#//END_MODULE_HEADER/////////////////////////////////////////////////////////

set tnet_tcl_dir    [file dirname [info script]]
set tnet_bin_dir $quartus(binpath)
set tnet_tcldp_dir  [file join $tnet_bin_dir "tcl-dp"]
set tnet_server_exe [file join $tnet_bin_dir "xprobe_server.exe"]
set tnet_server_scr [file join $tnet_tcl_dir "xprobe_server.tcl"]

set tnet_host localhost

proc tnet_get_port_number {} {
	global env

    set envlist [array get env XPROBE_PORTID]
    if { [llength $envlist] > 0 } {
		set port [lindex $envlist 1]
    } else {
		set port 8000
    }
}

proc tnet_LoadLib args {
	global tnet_tcldp_dir
	global tnet_bin_dir
		
	foreach file [list "acl.tcl" "distribobj.tcl" "dp_atclose.tcl" "dp_atexit.tcl" "ldelete.tcl" "oo.tcl" "rpc.tcl"] {
		uplevel #0 source [list [ file join $tnet_tcldp_dir $file]]
	}
	uplevel #0 load [list [file join $tnet_bin_dir "dp40_84.dll"]]
}

proc dp_cl_opencrossprobe { host port } {
	global tnet_tcl_dir
	global objInfo
	global server
	global env
	
	source [file join $tnet_tcl_dir "xprobe.tcl"]

	set tnet_rv [catch { set server [dp_MakeRPCClient $host $port] } errmsg ]
	if { $tnet_rv == 1 } {
		return ""
	}

	set localConn [dp_RPC $server -events all set dp_rpcFile]

	dp_RPC $server -events all eval dp_DistributeObject crossprobe $localConn CrossProbeInfo
	
	dp_atclose $objInfo(crossprobe,owner) prepend "dp_clean_up $localConn"
	
	dp_RPC $objInfo(crossprobe,owner) peercomplete
	return $localConn
}

proc dp_clean_up { localconn } {
	global objInfo

	catch { dp_RPC $objInfo(crossprobe,owner) dp_UndistributeObject crossprobe $localconn } errmsg
}

proc HiliteNet {callerId hilitedNet} {

	set sendargs $callerId

	set SplList [split $hilitedNet]

	foreach el $SplList {
		set highlitedNet [join $el] # This removes the special characters
		set sendargs [concat $sendargs \{$highlitedNet\}]
	}
	eval Client_HiliteNet $sendargs 

}

proc UnHiliteNet {callerId unhilitedNet} {

	set sendargs $callerId
	set SplList [split $unhilitedNet]

	foreach el $SplList {
		set unhighlitedNet [join $el] # This removes the special characters
		set sendargs [concat $sendargs \{$unhighlitedNet\}]
	}
	eval Client_UnHiliteNet $sendargs 
}

proc HiliteInst {callerId hilitedInst} {

	set sendargs $callerId

	set SplList [split $hilitedInst]

	foreach el $SplList {
		set highlitedInst [join $el] # This removes the special characters
		set sendargs [concat $sendargs \{$highlitedInst\}]
	}
	eval Client_HiliteInst $sendargs 
}

proc UnHiliteInst { callerId unhilitedInst} {
	
	set sendargs $callerId
	set SplList [split $unhilitedInst]

	foreach el $SplList {
		set unhighlitedInst [join $el] # This removes the special characters
		set sendargs [concat $sendargs \{$unhighlitedInst\}]
	}
	eval Client_UnHiliteInst $sendargs 
}

proc HilitePort {callerId hilitedPort} {

	set sendargs $callerId

	set SplList [split $hilitedPort]

	foreach el $SplList {
		set highlitedPort [join $el] # This removes the special characters
		set sendargs [concat $sendargs \{$highlitedPort\}]
	}
	eval Client_HilitePort $sendargs 
}

proc UnHilitePort { callerId unhilitedPort} {

	set sendargs $callerId
	set SplList [split $unhilitedPort]

	foreach el $SplList {
		set unhighlitedPort [join $el] # This removes the special characters
		set sendargs [concat $sendargs \{$unhighlitedPort\}]
	}
	eval Client_UnHilitePort $sendargs 
}

proc HiliteText { callerId whereinfo} {
	set sendargs $callerId
	set SplList [split $whereinfo]

	foreach el $SplList {
		set highlitedText [join $el] # This removes the special characters
		set sendargs [concat $sendargs \{$highlitedText\}]
	}
	eval Client_HiliteText $sendargs 
}

proc UnHiliteText {callerId whereinfo} {
	set sendargs $callerId
	set SplList [split $whereinfo]

	foreach el $SplList {
		set unhighlitedText [join $el] # This removes the special characters
		set sendargs [concat $sendargs \{$unhighlitedText\}]
	}
	eval Client_UnHiliteText $sendargs 
}

proc UnHiliteAll {callerId} {
	set sendargs $callerId
	eval Client_UnHiliteAll
}

proc tnet_setupClient {}  {
    global localConn
	global tnet_host
	global tnet_port

	set localConn [dp_cl_opencrossprobe $tnet_host $tnet_port]
	if {[string length $localConn] == 0} {
		return
	}

	dp_SetTrigger after crossprobe LastHilitedNet HiliteNet
	dp_SetTrigger after crossprobe LastUnHilitedNet UnHiliteNet
	dp_SetTrigger after crossprobe LastHilitedInst HiliteInst
	dp_SetTrigger after crossprobe LastUnHilitedInst UnHiliteInst
	dp_SetTrigger after crossprobe LastHilitedPort HilitePort
	dp_SetTrigger after crossprobe LastUnHilitedPort UnHilitePort
	dp_SetTrigger after crossprobe LastHilitedText HiliteText
	dp_SetTrigger after crossprobe LastUnHilitedText UnHiliteText
	dp_SetTrigger after crossprobe LastRemoveAll UnHiliteAll
}

package ifneeded dp 4.0 [list tnet_LoadLib]
package require dp 4.0

set tnet_port [tnet_get_port_number]

set tnet_rv [catch { set channelId [socket  $tnet_host $tnet_port]} errmsg]
if { $tnet_rv == 1 } {
	exec $tnet_server_exe $tnet_server_scr &
} 

tnet_setupClient
