# ***************************************************************
# ***************************************************************
#
# File:         qnativesim.tcl
# Description:  Quartus Nativelink Simulation flow 
#               This script is used by Quartus to launch eda 
#               simulation tools.
#
# Version:      1.0
#
# Authors:      Altera Corporation
#
#               Copyright (c)  Altera Corporation 2003 - .
#               All rights reserved.
#
# ***************************************************************
# ***************************************************************


variable return_status 0

variable ::quartus

source "$quartus(nativelink_tclpath)/qnativelinkflow.tcl"
namespace import ::quartus::nativelinkflow::open_nl_log
namespace import ::quartus::nativelinkflow::close_nl_log
namespace import ::quartus::nativelinkflow::nl_postmsg
namespace import ::quartus::nativelinkflow::nl_logmsg
namespace import ::quartus::nativelinkflow::get_nativelink_info
namespace import ::quartus::nativelinkflow::convert_filepath_to_tclstyle
namespace import ::quartus::nativelinkflow::convert_to_standard_name


package require cmdline

set         tlist       "-rtl_sim"
lappend     tlist       0
lappend     tlist       "If set script should archive every compile, not just ba
se/best compiles"
lappend function_opts $tlist

array set optshash [cmdline::getKnownOptions ::quartus(args) $function_opts]

if { [llength $quartus(args)] != 2 } {
    nl_postmsg  error "Error: Wrong number of arguments to top level NativeLink script, Project name and/or Compiler Settings name could not be set properly "
    qexit -error
} else {
    set project  [lindex $quartus(args) 0]
    set action_pt [lindex $quartus(args) 1]
}

set nl_rpt_file "${action_pt}_nativelink_simulation.rpt"
open_nl_log $nl_rpt_file
nl_postmsg info "Info: Start Nativelink Simulation process"

if [ catch {project_open $project -cmp $action_pt} temp ] {
    #post_message -type error "Error: $temp"
    nl_postmsg error "Error: $temp"
    set return_status 1
}

namespace import ::quartus::nativelinkflow::set_project_dir;
set_project_dir "[pwd]"

if {$return_status == 0} {

	source "$quartus(nativelink_tclpath)/qnativesimflow.tcl"
	namespace import ::quartus::nativelinkflow::sim::run_eda_simulation_tool;
	# Import simulation fns
	if [catch {run_eda_simulation_tool $optshash(-rtl_sim)} return_status] {
	    nl_postmsg error "Error: Encountered errors while running NativeLink Simulation scripts"
	    set return_status 1
	}
}

if {$return_status != 0} {
    nl_postmsg error "Error: NativeLink simulation flow was NOT successful"
    #debug messages, will not appear in quartus compile
    nl_logmsg "\n\n\n================The following additional information is provided to help identify the cause of error while running nativelink scripts================="
    nl_logmsg "Nativelink TCL script failed with errorCode:  $errorCode"
    nl_logmsg "Nativelink TCL script failed with errorInfo:  $errorInfo"
    post_message -type info "Info: For messages from NativeLink scripts, check the file [pwd]/$nl_rpt_file" -file "[pwd]/$nl_rpt_file"
    qexit -error
} else {
    nl_postmsg info "Info: Nativelink simulation process ended"
    post_message -type info "Info: For messages from NativeLink scripts, check the file [pwd]/$nl_rpt_file" -file "[pwd]/$nl_rpt_file"
    qexit -success 
}
