# ***************************************************************
# ***************************************************************
#
# File:         qnativeresyn.tcl
# Description:  Quartus NativeLink Synthesis flow 
#               This script is used by Quartus to launch eda 
#               physical synthesis tools.
#
# Version:           1.0
#
# Authors:          Altera Corporation
#
#               Copyright (c)  Altera Corporation 2003 - .
#               All rights reserved.
#
# ***************************************************************
# ***************************************************************

set return_status 0
variable ::quartus

post_message -type info "Info: Using NativeLink to launch EDA physical synthesis flow"

#First check if palace is installed and set up correctly.
post_message -type info "Info: Searching for PALACE physical synthesis tool"
if ![ info exists env(PALACE_ROOTDIR) ] {
   post_message -type error "Error: Can't find PALACE physical synthesis tool -- PALACE physical synthesis tool may not be installed or environment variable PALACE_ROOTDIR not set correctly"
  set return_status 3 
} else {
    regsub -all {\\} $env(PALACE_ROOTDIR) {/} palace_rootdir
}


if { $return_status == 0} {

    if { ([llength $q_args] <= 1) || ([llength $q_args] > 2) } {
	post_message  "Error" "Error: Missing required argument project_name"
	post_message  "Error" "Usage: quartus_sh -t qnativeresyn.tcl project_name \[cmp_name\]"
	set return_status 3
    } else {
	set project [lindex $q_args 0]
	set active_cmp $project
	if {[llength $q_args] == 2} {
	    set active_cmp [lindex $q_args 1]
	} 
	if [ catch {project_open $project -cmp $active_cmp} qerror ] {
	    post_message -type error "Error: $qerror"
	    set return_status 1
	} else {
	    set assignment_name {EDA_RESYNTHESIS_TOOL}
	    set section_id $quartus(project)
	    set tool [ get_global_assignment -name  $assignment_name]
	    if ![ string compare -nocase $tool "PALACE"] {
		set palace_flow_script "$palace_rootdir/bin/aa_flow.tcl"
		if [ file exists $palace_flow_script ] {
		    if [ catch {source "$palace_flow_script"} ] {
			post_message -type error "Error: Encountered Errors while running PALACE physical synthesis tool -- physical synthesis flow could not be completed"
			set return_status 3
		    } else {
		        if [ catch {run_gui $quartus(project)} return_status ] {
			    post_message -type error "Error: Encountered errors while running PALACE physical synthesis tool -- physical synthesis flow could not be completed"
			}
		    }
		} else {
		    post_message -type error "Error: Can't find script required to start PALACE -- PALACE may not be correctly installed"
		    set return_status 3
		}
	    }
	}
    }
}

if {$return_status != 0} {
    #debug messages, will not appear in quartus compile
    puts "==========Start Debug Information================="
    puts "errorCode:  $errorCode"
    puts "errorInfo:  $errorInfo"
    puts "==========END Debug Information==================="
    qexit -error 
} else {
    qexit -success 
}
