package ifneeded ::quartus::sdc 1.0 {

	if [ catch { load "" sdc } load_result ] {
		# If static load fails, load dynamic lib
		set_dll_loading -dynamic
		load tsm_sta sdc
		set_dll_loading -static
	}

	# BEGIN_PROCEDURE_HEADER ###################################################
	#
	proc derive_lvds_clocks_internal {} {
	#
	# Description: Procedure definition for "derive_lvds_clocks" command.
	#
	# END_PROCEDURE_HEADER #####################################################
	
		set load_reg_col [get_registers *lvds*~load_reg]
		foreach_in_collection load_reg $load_reg_col {
			set load_reg_name [get_object_info -name $load_reg]
			set short_load_reg_name [regsub -all {[^|]*:} $load_reg_name ""]
			set cell_name [regsub {~load_reg$} $short_load_reg_name ""]
			set pin_name "$cell_name|CLK0"
			set cmd_name "create_generated_clock -source $pin_name -multiply_by 1 -name $short_load_reg_name $load_reg_name"
			post_message -type info "$cmd_name"
			eval $cmd_name
		}
	}
}

