package ifneeded ::quartus::misc 1.0 {

	if [ catch { load "" misc } load_result ] {
		# If static load fails, load dynamic lib
		set_dll_loading -dynamic
		load ccl_atcl misc
		set_dll_loading -static
	}

	# BEGIN_PROCEDURE_HEADER ###################################################
	#
	proc get_collection_size_internal { collection_id } {
	#
	# Description: Procedure definition for "get_collection_size" command.
	#
	# END_PROCEDURE_HEADER #####################################################
	
		set cnt 0
		foreach_in_collection i $collection_id {
			incr cnt
		}
		return $cnt
	}

	# BEGIN_PROCEDURE_HEADER ###################################################
	#
	proc escape_brackets_internal { str } {
	#
	# Description: Procedure definition for "escape_brackets" command.
	#
	# END_PROCEDURE_HEADER #####################################################
	
			regsub -all {\\} $str {\\\\} str
			return [regsub -all "(\[\\\[\\\]\])" $str "\\\\&"]
	}

	# BEGIN_PROCEDURE_HEADER ###################################################
	#
	proc enable_natural_bus_naming_internal {} {
	#
	# Description: Procedure definition for "enable_natural_bus_naming" command.
	#
	# END_PROCEDURE_HEADER #####################################################
	
		if {[info commands unknown_original] == ""} {
			rename unknown unknown_original
			proc unknown { cmd args } {
				if { ([string is integer -strict $cmd] && $cmd >= 0) \
					 || \
					 ([regexp {^[?]+$} $cmd]) \
					 || \
					 ($cmd == "*") } {
					return "\[$cmd\]"
				} else {
					eval unknown_original $cmd $args
				}
			}
		}
		
		set_quartus_array -key natural_bus_naming 1
	}

	# BEGIN_PROCEDURE_HEADER ###################################################
	#
	proc disable_natural_bus_naming_internal {} {
	#
	# Description: Procedure definition for "disable_natural_bus_naming" command.
	#
	# END_PROCEDURE_HEADER #####################################################
	
		if {[info commands unknown_original] != ""} {
			rename unknown ""
			rename unknown_original unknown
		}
		
		set_quartus_array -key natural_bus_naming 0
	}
}

