::dtw::add_version_date {$Date:   05 Feb 2006 03:13:48  $}

##############################################################################
#
# File Name:    dtw_data_entry.tcl
#
# Summary:      This TK script is a simple Graphical User Interface to
#               generate timing requirements for DDR memory interfaces
#
# Licencing:
#               ALTERA LEGAL NOTICE
#               
#               This script is  pursuant to the following license agreement
#               (BY VIEWING AND USING THIS SCRIPT, YOU AGREE TO THE
#               FOLLOWING): Copyright (c) 2006-2007 Altera Corporation, San Jose,
#               California, USA.  Permission is hereby granted, free of
#               charge, to any person obtaining a copy of this software and
#               associated documentation files (the "Software"), to deal in
#               the Software without restriction, including without limitation
#               the rights to use, copy, modify, merge, publish, distribute,
#               sublicense, and/or sell copies of the Software, and to permit
#               persons to whom the Software is furnished to do so, subject to
#               the following conditions:
#               
#               The above copyright notice and this permission notice shall be
#               included in all copies or substantial portions of the Software.
#               
#               THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#               EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
#               OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#               NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
#               HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
#               WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#               FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
#               OTHER DEALINGS IN THE SOFTWARE.
#               
#               This agreement shall be governed in all respects by the laws of
#               the State of California and by the laws of the United States of
#               America.
#
#               
#
# Usage:
#
#               You can run this script from a command line by typing:
#                     quartus_sh --dtw
#
###############################################################################

# ----------------------------------------------------------------
#
namespace eval dtw_data_entry {
#
# Description: Namespace to encapsulate a data entry
#
# ----------------------------------------------------------------
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::dtw_data_entry { data_window label_text units default_unit units_width default_data data_width user_term_label_text entry_label_text validate_command } {
#
# Description: A frame of controls for entering numbers/time
#
# ----------------------------------------------------------------
	frame $data_window -padx 4 -pady 2
	label $data_window.label -text $label_text -justify left -anchor w
	label $data_window.user_term_label -justify left
	label $data_window.entry_label -text $entry_label_text -justify right
	entry $data_window.entry -width $data_width -justify right -validate all -validatecommand $validate_command
	$data_window.entry insert 0 $default_data

	if {$units != [list]} {
		set max_units_width 0
		ComboBox $data_window.units -width $units_width -values $units -editable 0
		$data_window.units setvalue $default_unit
	}

	pack $data_window.units -side right
	pack $data_window.entry -side right
	pack $data_window.entry_label -side right
	pack $data_window.user_term_label -side right
	pack $data_window.label -side right -fill x -expand 1
	bind $data_window.label <Configure> "$data_window.label configure -wraplength %w"

	return $data_window
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::set_label { data_window entry_label} {
#
# Description: Set the label
#
# ----------------------------------------------------------------
	${data_window}.label configure -text "$entry_label"
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::set_user_term_label_text { data_window user_term_label_text} {
#
# Description: Set the label
#
# ----------------------------------------------------------------
	${data_window}.user_term_label configure -text "$user_term_label_text"
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::set_entry_label_text { data_window entry_label_text} {
#
# Description: Set the label
#
# ----------------------------------------------------------------
	${data_window}.entry_label configure -text "$entry_label_text"
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::get_label { data_window} {
#
# Description: Set the label
#
# ----------------------------------------------------------------
	return [${data_window}.label cget -text]
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::set_data { data_window data } {
#
# Description: Set the entry
#
# ----------------------------------------------------------------
	set data_value "[lindex $data 0]"
	set data_units "[lindex $data 1]"

	${data_window}.entry delete 0 end
	${data_window}.entry insert 0 "$data_value"
	${data_window}.units configure -text "$data_units"
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::get_entry_text { data_window } {
#
# Description: Set the entry
#
# ----------------------------------------------------------------
	return [$data_window.entry get]
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::get_data { data_window } {
#
# Description: Get the entry and units
#
# ----------------------------------------------------------------
	set data_value [get_entry_text $data_window]
	set data_units [$data_window.units cget -text]
	return [list $data_value $data_units]
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::bind_to_entry { data_window event event_command } {
#
# Description: Binds an event handler to an entry event
#
# ----------------------------------------------------------------
	bind ${data_window}.entry $event "$event_command"
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::set_labels_state { data_window state } {
#
# Description: Set the enable/disabled state of the labels
#
# ----------------------------------------------------------------
	${data_window}.label configure -state $state
	${data_window}.user_term_label configure -state $state
	${data_window}.entry_label configure -state $state
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::get_labels_state { data_window } {
#
# Description: Get the enable/disabled state of the labels
#
# ----------------------------------------------------------------
	return [${data_window}.label cget -state]
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::set_entry_state { data_window state } {
#
# Description: Set the enable/disabled state of the entry boxes
#
# ----------------------------------------------------------------
	${data_window}.entry configure -state $state
	${data_window}.units configure -state $state
}

# ----------------------------------------------------------------
#
proc dtw_data_entry::get_entry_state { data_window } {
#
# Description: Get the enable/disabled state of the entry boxes
#
# ----------------------------------------------------------------
	return [{data_window}.entry cget -state $state]
}
