// file: uart_routines.c
//
// +----------------------------
// | C-language routines for
// | basic operations on the
// | Altera Avalon UART peripheral
// |

#include "excalibur.h"



void nr_uart_initialize(np_uart *uartBase)
	{
	}

int nr_uart_rxchar(np_uart *uartBase)
	{
	// |
	// | Let zero mean "default uart", if there is one.
	// |

#ifdef nasys_printf_uart
	if(!uartBase)
		uartBase = (np_uart *)nasys_printf_uart;
#endif

	// |
	// | See if there's a character, or return -1
	// |

	if(uartBase->np_uartstatus & np_uartstatus_rrdy_mask)
		return uartBase->np_uartrxdata;
	else
		return -1;
	}


void nr_uart_txchar(int c,np_uart *uartBase)
	{
	// |
	// | Let zero mean "default uart", if there is one.
	// |

#ifdef nasys_printf_uart
	if(!uartBase)
		uartBase = (np_uart *)nasys_printf_uart;
#endif

	// |
	// | Wait until the uart is ready for a character
	// |

	while((uartBase->np_uartstatus & np_uartstatus_trdy_mask) == 0)
		;

	// |
	// | And pop the character into the register
	// |

	uartBase->np_uarttxdata = c;
	}


// +------------------------------------------
// | The rest of the routines operate only
// | on the default ("printf") UART.
// |

void nr_uart_txcr(void)
	{
	nr_uart_txchar(13,0);
	nr_uart_txchar(10,0);
	}

void nr_uart_txhex16(short x)
	{
	int i;
	int a;

	for(i = 0; i < 4; i++)
		{
		a = (x >> 4*(3-i)) & 0x000f;
		if(a > 9)
			a = a + 'A' - '0' - 10;
		a += '0';
		nr_uart_txchar(a,0);
		}
	}

void nr_uart_txhex32(long x)
	{
	nr_uart_txhex16( (short)((x >> 16) & 0x0000ffff) );
	nr_uart_txhex16( (short)((x      ) & 0x0000ffff) );
	}

void nr_uart_txhex(int x)
	{
	if(sizeof(int) > 2)
		nr_uart_txhex32(x);
	else
		nr_uart_txhex16(x);
	}


void nr_uart_txstring(char *s)
	{
	while(*s)
		nr_uart_txchar(*s++,0);
	}


// end of file
