; ----------------------------------------------
; UART Peripheral
;
	;
	; UART Registers
	;
	.equ np_uartrxdata,      0 ; Read-only, 8-bit
	.equ np_uarttxdata,      1 ; Write-only, 8-bit
	.equ np_uartstatus,      2 ; Read-only, 8-bit
	.equ np_uartcontrol,     3 ; Read/Write, 9-bit
	.equ np_uartdivisor,     4 ; Read/Write, 16-bit, optional
	.equ np_uartendofpacket, 5 ; Read/Write, end-of-packet character

	;
	; UART Status Register
	;
	.equ np_uartstatus_eop_mask,  (1<<12)
	.equ np_uartstatus_cts_mask,  (1<<11)
	.equ np_uartstatus_dcts_mask, (1<<10)
	.equ np_uartstatus_e_mask,    (1<<8)
	.equ np_uartstatus_rrdy_mask, (1<<7)
	.equ np_uartstatus_trdy_mask, (1<<6)
	.equ np_uartstatus_tmt_mask,  (1<<5)
	.equ np_uartstatus_toe_mask,  (1<<4)
	.equ np_uartstatus_roe_mask,  (1<<3)
	.equ np_uartstatus_brk_mask,  (1<<2)
	.equ np_uartstatus_fe_mask,   (1<<1)
	.equ np_uartstatus_pe_mask,   (1<<0)

	.equ np_uartstatus_eop_bit,  12
	.equ np_uartstatus_cts_bit,  11
	.equ np_uartstatus_dcts_bit, 10
	.equ np_uartstatus_e_bit,    8
	.equ np_uartstatus_rrdy_bit, 7
	.equ np_uartstatus_trdy_bit, 6
	.equ np_uartstatus_tmt_bit,  5
	.equ np_uartstatus_toe_bit,  4
	.equ np_uartstatus_roe_bit,  3
	.equ np_uartstatus_brk_bit,  2
	.equ np_uartstatus_fe_bit,   1
	.equ np_uartstatus_pe_bit,   0

	;
	; UART Control Register
	;
	.equ np_uartcontrol_eop_mask,   (1<<10)
	.equ np_uartcontrol_tbrk_mask,  (1<<9)
	.equ np_uartcontrol_ie_mask,    (1<<8)
	.equ np_uartcontrol_irrdy_mask, (1<<7)
	.equ np_uartcontrol_itrdy_mask, (1<<6)
	.equ np_uartcontrol_itmt_mask,  (1<<5)
	.equ np_uartcontrol_itoe_mask,  (1<<4)
	.equ np_uartcontrol_iroe_mask,  (1<<3)
	.equ np_uartcontrol_ibrk_mask,  (1<<2)
	.equ np_uartcontrol_ife_mask,   (1<<1)
	.equ np_uartcontrol_ipe_mask,   (1<<0)

	.equ np_uartcontrol_eop_bit,  10
	.equ np_uartcontrol_tbrk_bit,  9
	.equ np_uartcontrol_ie_bit,    8
	.equ np_uartcontrol_irrdy_bit, 7
	.equ np_uartcontrol_itrdy_bit, 6
	.equ np_uartcontrol_itmt_bit,  5
	.equ np_uartcontrol_itoe_bit,  4
	.equ np_uartcontrol_iroe_bit,  3
	.equ np_uartcontrol_ibrk_bit,  2
	.equ np_uartcontrol_ife_bit,   1
	.equ np_uartcontrol_ipe_bit,   0

