// file: timer_milliseconds.c
//
// A simple milliseconds counter that REQUIRES a timer
// named na_timer1, and hogs it completely up.
//

#include "excalibur.h"


#ifdef na_timer1

static void timer_isr_handler(int context);
static int milliseconds_count;

int nr_timer_milliseconds(void)
    {
    static int running_yet = 0;

    if(!running_yet)
        {
        milliseconds_count = 0;
        nr_installuserisr(na_timer1_irq,timer_isr_handler,0);

        na_timer1->np_timerperiodl = (nasys_clock_freq_1000) & 0x0000ffff;
        na_timer1->np_timerperiodh = (nasys_clock_freq_1000 >> 16) & 0x0000ffff;

        na_timer1->np_timercontrol =
                np_timercontrol_start_mask
                | np_timercontrol_cont_mask
                | np_timercontrol_ito_mask;

        running_yet = 1;
        }

    return milliseconds_count;
    }


static void timer_isr_handler(int context)
    {
    milliseconds_count++;
    na_timer1->np_timerstatus = 0;  // write to clear the IRQ
    }

#endif
// end of file
