; ----------------------------------------------
; Timer Peripheral
;
	;
	; Timer Register Offsets
	;

	.equ np_timerstatus,  0  ; read only, 2 bits (any write to clear to)
	.equ np_timercontrol, 1  ; write/readable, 4 bits
	.equ np_timerperiodl, 2  ; write/readable, 16 bits
	.equ np_timerperiodh, 3  ; write/readable, 16 bits
	.equ np_timersnapl,   4  ; read only, 16 bits
	.equ np_timersnaph,   5  ; read only, 16 bits

	;
	; Timer Register Bits
	;

	.equ np_timerstatus_run_bit,    1 ; timer is running
	.equ np_timerstatus_to_bit,     0 ; timer has timed out
 
	.equ np_timercontrol_stop_bit,  3 ; stop the timer
	.equ np_timercontrol_start_bit, 2 ; start the timer
	.equ np_timercontrol_cont_bit,  1 ; continous mode
	.equ np_timercontrol_ito_bit,   0 ; enable time out interrupt

	.equ np_timerstatus_run_mask,    (1<<1) ; timer is running
	.equ np_timerstatus_tO_mask,     (1<<0) ; timer has timed out
 
	.equ np_timercontrol_stop_mask,  (1<<3) ; stop the timer
	.equ np_timercontrol_start_mask, (1<<2) ; start the timer
	.equ np_timercontrol_cont_mask,  (1<<1) ; continous mode
	.equ np_timercontrol_ito_mask,   (1<<0) ; enable time out interrupt

