###############################################################
# System-ID peripheral
#
#
################################################################

use europa_all;
use europa_utils;
use strict;
#use TrulyRandom;


#START:
my $project = e_project->new(@ARGV);

&make_sysid ($project->top(), $project);

$project->output();
# DONE!


# My, what a lame hash-algorithm.  Wouldn't you just love to show
# how smart you are by writing your own?
sub hash
{
   my ($inputstring) = (@_);
   my @charlist = split (//, $inputstring);
   my @sumbytes = (0,0,0,0);
   my $i = 0;
   foreach my $char (@charlist) {
      $sumbytes[$i] += $char;
      $sumbytes[$i] &= 0xFF;
      $i = ($i + 1) % 4;
   }
   return ($sumbytes[3] << 24) | 
          ($sumbytes[2] << 16) | 
          ($sumbytes[1] <<  8) | 
          ($sumbytes[0] <<  0)  ;  
}

################################################################
# make_sysid
#
################################################################
sub make_sysid
{
   my ($module, $project) = (@_);
   
   my $name = $module->name();
   my $wsa = $project->system_ptf()->{"MODULE $name"}->{WIZARD_SCRIPT_ARGUMENTS};
   my $slave_SBI = $project->system_ptf()->{"MODULE $name"}->{'SLAVE control_slave'}->{SYSTEM_BUILDER_INFO};
   my $SBI = $project->system_ptf()->{"MODULE $name"}->{SYSTEM_BUILDER_INFO};
   # Do the dirty deed: Come up with the two values:
   my $value0 = hash ($project->ptf_to_string());
   my $value1 = time();
  
   # Append 'u' to these values to ensure that they're treated
   # as unsigned ints in the Eclipse system.h.
   $wsa->{id} = $value0 . 'u';
   $wsa->{timestamp} = $value1 . 'u';

   # mark the new, empty module as the one into which
   # all new "things" should go.  It gets unmarked when this subroutine
   # exits and "$marker" is destroyed.
   #
   my $marker = e_default_module_marker->new($module);

   e_port->adds(["address",       $slave_SBI->{Address_Width}, "in" ],
                ["readdata",      32,                          "out"],  );
   
   e_avalon_slave->add ({name => "control_slave",});  
   e_assign->add ({lhs => "readdata", 
                   rhs => "address[0] ? $value1 : $value0",
                });   

   # Fill-in the MAKE section with our verifysysid target
   my $base_address = $slave_SBI->{Base_Address};
   $wsa->{MAKE} = {};    # Paranoia--purge whatever was there before.


   # Now create a PTF structure that looks like this:
   #
   #   WIZARD_SCRIPT_ARGUMENTS 
   #   {
   #      id = 2405390472u;
   #      timestamp = 1073319295u;
   #
   #      MAKE 
   #      {
   #         TARGET verifysysid
   #         {
   #            verifysysid
   #            {
   #              Command = "verifysysid [...]";
   #              Target_File = "dummy_verifysysid_file";
   #              All_Depends_On = "0";
   #            }
   #         }
   #      }
   #  }
   #
   # TODO: remove the verifysysid target from the makefile when we are sure
   # nothing uses it any more.
   #
   my $wsa_make = $wsa->{MAKE};
   $wsa_make->{"TARGET verifysysid"} = {};
   my $target_section = $wsa_make->{'TARGET verifysysid'};
   $target_section->{"verifysysid"} = {};
   my $verifysysid_section = $target_section->{'verifysysid'};
   
   $verifysysid_section->{Target_File} = 'dummy_verifysysid_file';
   $verifysysid_section->{Is_Phony} = 1;
   $verifysysid_section->{Command} = 
       "nios2-download \$(JTAG_CABLE)                                --sidp=$base_address --id=$value0 --timestamp=$value1";

      # 'make all' shouldn't check system ID:
   $verifysysid_section->{All_Depends_On} = '0';  

   
   # Fill-out a hover-tip which allows users to query the ID and
   # timestamp (using a hidden feature, but whatever.)
   #
   my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = 
       localtime ($value1);

   my $weekday = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat') [$wday];
   my $month =
   ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec')[$mon];
   my $realyear = $year + 1900;
   my $ampm = "AM";
   if ($hour > 12) {
      $ampm = "PM";
      $hour -= 12;
   }
   my $hexid    = sprintf ("%08X", $value0);
   my $hexstamp = sprintf ("%08X", $value1);
   my $minstring = sprintf ("%02d", $min);

   $SBI->{View}->{Settings_Summary} = 
       "System ID (at last Generate):<br>" .
       " <b>$hexid</b>    (unique ID tag) <br>" .
       " <b>$hexstamp</b> (timestamp: $weekday $month $mday, $realyear \@$hour:$minstring $ampm)";

}





