; ----------------------------------------------
; SPI Peripheral
;
  ;
  ; SPI Registers
  ;
  .equ np_spirxdata,      0 ; Read-only, 1-16 bit
  .equ np_spitxdata,      1 ; Write-only, same width as rxdata
  .equ np_spistatus,      2 ; Read-only, 9-bit
  .equ np_spicontrol,     3 ; Read/Write, 9-bit
  .equ np_spireserved,    4 ; reserved
  .equ np_spislaveselect, 5 ; Read/Write, 1-16 bit, master only
  .equ np_spiendofpacket, 6 ; Read/write, same width as txdata, rxdata.

  ;
  ; SPI Status Register
  ;
  .equ np_spistatus_eop_mask,  (1 << 9)
  .equ np_spistatus_e_mask,    (1 << 8)
  .equ np_spistatus_rrdy_mask, (1 << 7)
  .equ np_spistatus_trdy_mask, (1 << 6)
  .equ np_spistatus_tmt_mask,  (1 << 5)
  .equ np_spistatus_toe_mask,  (1 << 4)
  .equ np_spistatus_roe_mask,  (1 << 3)

  .equ np_spistatus_eop_bit,  9
  .equ np_spistatus_e_bit,    8
  .equ np_spistatus_rrdy_bit, 7
  .equ np_spistatus_trdy_bit, 6
  .equ np_spistatus_tmt_bit,  5
  .equ np_spistatus_toe_bit,  4
  .equ np_spistatus_roe_bit,  3

  ;
  ; SPI Control Register
  ;
  .equ np_spicontrol_sso_mask,   (1 << 10)
  .equ np_spicontrol_ieop_mask,  (1 << 9)
  .equ np_spicontrol_ie_mask,    (1 << 8)
  .equ np_spicontrol_irrdy_mask, (1 << 7)
  .equ np_spicontrol_itrdy_mask, (1 << 6)
  .equ np_spicontrol_itoe_mask,  (1 << 4)
  .equ np_spicontrol_iroe_mask,  (1 << 3)

  .equ np_spicontrol_sso_bit,   10
  .equ np_spicontrol_ieop_bit,  9
  .equ np_spicontrol_ie_bit,    8
  .equ np_spicontrol_irrdy_bit, 7
  .equ np_spicontrol_itrdy_bit, 6
  .equ np_spicontrol_itoe_bit,  4
  .equ np_spicontrol_iroe_bit,  3

