// file: pio_lcd16207.h
// Support for the Optrex 16207 16x2 character LCD
//

#ifndef _pio_lcd16207_
#define _pio_lcd16207_

#include "nios.h"

#define LCD_NUM_ROW 2	
#define LCD_NUM_COL 16


// Main Routines

void nr_pio_lcdinit(np_pio *lcdPio);
void nr_pio_lcdwritescreen(char * string);

// Lower Level Routines

void nr_pio_lcdwritecommand(unsigned char command);
void nr_pio_lcdwritecharacter(unsigned char character);
void nr_pio_lcdprintstringslowly(char *string, int time);
void nr_pio_lcdsetcursor(int row, int col);
void nr_pio_lcdclearscreen(void);
void nr_pio_lcdcursorvisible(int bVisible);
void nr_pio_lcdon(int bOn);

#endif // _pio_lcd16207_
