/******************************************************************************
*                                                                             *
* License Agreement                                                           *
*                                                                             *
* Copyright (c) 2003 Altera Corporation, San Jose, California, USA.           *
* All rights reserved.                                                        *
*                                                                             *
* Permission is hereby granted, free of charge, to any person obtaining a     *
* copy of this software and associated documentation files (the "Software"),  *
* to deal in the Software without restriction, including without limitation   *
* the rights to use, copy, modify, merge, publish, distribute, sublicense,    *
* and/or sell copies of the Software, and to permit persons to whom the       *
* Software is furnished to do so, subject to the following conditions:        *
*                                                                             *
* The above copyright notice and this permission notice shall be included in  *
* all copies or substantial portions of the Software.                         *
*                                                                             *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING     *
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER         *
* DEALINGS IN THE SOFTWARE.                                                   *
*                                                                             *
* This agreement shall be governed in all respects by the laws of the State   *
* of California and by the laws of the United States of America.              *
*                                                                             *
* Altera does not recommend, suggest or require that this reference design    *
* file be used in conjunction or combination with any other product.          *
*                                                                             *
* altera_avalon_lan91c111.h - LWIP ethernet interface for the the Lan91C111   *
* on the Nios boards.                                                         *
*                                                                             *
* Author PRR                                                                  *
*                                                                             *
******************************************************************************/

#ifndef __ALTERA_AVALON_LAN91C111_H__
#define __ALTERA_AVALON_LAN91C111_H__

#ifdef LWIP
#include <stdlib.h>
#include <stdio.h>
#include "alt_types.h"
#include "system.h"
#include "lwip/netif.h"
#include "arch/sys_arch.h"
#include "alt_lwip_dev.h"
#include "sys/alt_warning.h"

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

err_t alt_avalon_lan91c111_init(struct netif *netif);
void alt_avalon_lan91c111_rx();

typedef struct 
{
  alt_lwip_dev_list   lwip_dev_list;
  int                 base_addr;
  int                 irq;
  int                 bus_width;
  sys_sem_t           semaphore;
  sys_sem_t           arp_semaphore;
  alt_u8              tx_packet_no; /* Number of packet allocated for Tx */
}alt_avalon_lan91c111_if;

#define ALTERA_AVALON_LAN91C111_INSTANCE(name, dev) \
alt_avalon_lan91c111_if dev = \
{\
  {\
    ALT_LLIST_ENTRY,\
    {\
      0,\
      name##_NAME,\
      alt_avalon_lan91c111_init, \
      alt_avalon_lan91c111_rx,\
    },\
  },\
  name##_BASE + name##_LAN91C111_REGISTERS_OFFSET,\
  name##_IRQ,\
  name##_LAN91C111_DATA_BUS_WIDTH,\
  0,\
  0\
}


#define ALTERA_AVALON_LAN91C111_INIT(name, dev)                           \
  if (name##_IRQ == ALT_IRQ_NOT_CONNECTED)                                \
  {                                                                       \
    ALT_LINK_ERROR ("Error: Interrupt not connected for " #dev ". "       \
                    "The ALTERA Avalon lan91c111 driver requires that an "\
                    "interrupt is connected. Please select an IRQ for "   \
                    "this device in SOPC builder.");                      \
  }                                                                       \
  else if (name##_LAN91C111_DATA_BUS_WIDTH != 32)                         \
  {                                                                       \
    ALT_LINK_ERROR ("Error: Invalid configuration for " #dev ". "         \
                    "The ALTERA Avalon lan91c111 driver currently only "  \
                    "supports the configuration of MAC/PHY on the "       \
                    "development board. Please select this option  "      \
                    "in SOPC builder.");                                  \
  }                                                                       \
  else                                                                    \
  {                                                                       \
    alt_lwip_dev_reg(dev);                                                \
  }                                                                       \

#ifdef __cplusplus
}
#endif /* __cplusplus */

#else

// SPR 189741. This warning directive causes an error in the Nios II IDE console because of an Eclipse bug (2 files same name with #warning)
// So we are removing the warning.  If your SOPC Builder design includes Ethernet hardware and your Nios II IDE project does not include LWIP, 
// you will see errors indicating the LWIP headers cannot be found.
// See the errata notes for more details.
// #warning excluding drivers for the lan91c111 as you do not have the LWIP software component selected

#define ALTERA_AVALON_LAN91C111_INSTANCE(name, dev) extern int alt_no_storage
#define ALTERA_AVALON_LAN91C111_INIT(name, dev) while(0)     
#endif /* LWIP */

#endif /* __ALTERA_AVALON_LAN91C111_H__ */
