#ifndef __ALT_AVALON_JTAG_UART_H__
#define __ALT_AVALON_JTAG_UART_H__

/******************************************************************************
*                                                                             *
* License Agreement                                                           *
*                                                                             *
* Copyright (c) 2003 Altera Corporation, San Jose, California, USA.           *
* All rights reserved.                                                        *
*                                                                             *
* Permission is hereby granted, free of charge, to any person obtaining a     *
* copy of this software and associated documentation files (the "Software"),  *
* to deal in the Software without restriction, including without limitation   *
* the rights to use, copy, modify, merge, publish, distribute, sublicense,    *
* and/or sell copies of the Software, and to permit persons to whom the       *
* Software is furnished to do so, subject to the following conditions:        *
*                                                                             *
* The above copyright notice and this permission notice shall be included in  *
* all copies or substantial portions of the Software.                         *
*                                                                             *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING     *
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER         *
* DEALINGS IN THE SOFTWARE.                                                   *
*                                                                             *
* This agreement shall be governed in all respects by the laws of the State   *
* of California and by the laws of the United States of America.              *
*                                                                             *
******************************************************************************/

#include <stddef.h>

#include "sys/alt_dev.h"
#include "sys/alt_alarm.h"
#include "sys/alt_warning.h"

#include "os/alt_sem.h"
#include "os/alt_flag.h"

/* If the user wants all drivers to be small rather than fast then make sure
 * this one is marked as needing to be small.
 */
#if defined ALT_USE_SMALL_DRIVERS && !defined ALTERA_AVALON_JTAG_UART_SMALL
#define ALTERA_AVALON_JTAG_UART_SMALL
#endif

#define ALT_AVALON_JTAG_UART_BUF_LEN (2048)

/*
 * Device structure definition. This is needed by alt_sys_init in order to reserve memory
 * for the device instance.
 */

typedef struct alt_avalon_jtag_uart_dev_s
{
  alt_dev dev;
  unsigned int base;

#ifndef ALTERA_AVALON_JTAG_UART_SMALL
 
  unsigned int  timeout; /* Timeout until host is assumed inactive */
  alt_alarm     alarm;
  unsigned int  irq_enable;
  unsigned int  host_inactive;

  ALT_SEM      (read_lock)
  ALT_SEM      (write_lock)
  ALT_FLAG_GRP (events)
  
  /* The variables below are volatile because they are modified by the
   * interrupt routine.  Making them volatile and reading them atomically
   * means that we don't need any large critical sections.
   */
  volatile unsigned int rx_in;
  unsigned int  rx_out;
  unsigned int  tx_in;
  volatile unsigned int tx_out;
  char          rx_buf[ALT_AVALON_JTAG_UART_BUF_LEN];
  char          tx_buf[ALT_AVALON_JTAG_UART_BUF_LEN];

#endif

} alt_avalon_jtag_uart_dev;

/*
 *
 */

extern int alt_avalon_jtag_uart_read (alt_fd* fd, char* ptr, int len);
extern int alt_avalon_jtag_uart_write (alt_fd* fd, const char* ptr, int len);

#ifndef ALTERA_AVALON_JTAG_UART_SMALL

extern void alt_avalon_jtag_uart_init (alt_avalon_jtag_uart_dev* dev, int base, int irq);
extern int alt_avalon_jtag_uart_fstat (alt_fd* dev, struct stat *st);
extern int alt_avalon_jtag_uart_ioctl (alt_fd* fd, int req, void* arg);

#endif

/*
 * Macros used by alt_sys_init
 */

#ifndef ALTERA_AVALON_JTAG_UART_SMALL

#define ALTERA_AVALON_JTAG_UART_INSTANCE(name, device)   \
  static alt_avalon_jtag_uart_dev device =               \
  {                                                      \
    {                                                    \
      ALT_LLIST_ENTRY,                                   \
      name##_NAME,                                       \
      NULL, /* open */                                   \
      NULL, /* close */                                  \
      alt_avalon_jtag_uart_read,                         \
      alt_avalon_jtag_uart_write,                        \
      NULL, /* lseek */                                  \
      NULL, /* fstat */                                  \
      alt_avalon_jtag_uart_ioctl,                        \
    },                                                   \
    name##_BASE,                                         \
    10,                                                  \
  }

#define ALTERA_AVALON_JTAG_UART_INIT(name, dev)                              \
  {                                                                          \
    if (name##_IRQ == ALT_IRQ_NOT_CONNECTED)                                 \
    {                                                                        \
      ALT_LINK_ERROR ("Error: Interrupt not connected for " #dev ". "        \
                      "You have selected the interrupt driven version of "   \
                      "the ALTERA Avalon JTAG UART driver, but the "         \
                      "interrupt is not connected for this device. You can " \
                      "select a polled mode driver by checking the 'small "  \
                      "driver' option in the HAL configuration window, or "  \
                      "by using the -DALTERA_AVALON_JTAG_UART_SMALL "        \
                      "preprocessor flag.");                                 \
    }                                                                        \
    else                                                                     \
      alt_avalon_jtag_uart_init (&dev, name##_BASE, name##_IRQ);             \
  }

#else

#define ALTERA_AVALON_JTAG_UART_INSTANCE(name, device)   \
  static alt_avalon_jtag_uart_dev device =               \
  {                                                      \
    {                                                    \
      ALT_LLIST_ENTRY,                                   \
      name##_NAME,                                       \
      NULL, /* open */                                   \
      NULL, /* close */                                  \
      alt_avalon_jtag_uart_read,                         \
      alt_avalon_jtag_uart_write,                        \
      NULL, /* lseek */                                  \
      NULL, /* fstat */                                  \
      NULL, /* ioctl */                                  \
    },                                                   \
    name##_BASE,                                         \
  }

#define ALTERA_AVALON_JTAG_UART_INIT(name, device) alt_dev_reg (&device.dev)

#endif

/*
 *
 */

#endif /* __ALT_AVALON_JTAG_UART_H__ */
