
; ----------------------------------------------
;  DMA Peripheral

;  DMA Registers
  .equ np_dmastatus,          0   ;  status register
  .equ np_dmareadaddress,     1   ;  read address
  .equ np_dmawriteaddress,    2   ;  write address
  .equ np_dmalength,          3   ;  length in bytes
  .equ np_dmareserved1,       4   ;  reserved
  .equ np_dmareserved2,       5   ;  reserved
  .equ np_dmacontrol,         6   ;  control register
  .equ np_dmareserved3,       7   ;  control register alternate

; DMA Register Bits
  .equ np_dmacontrol_byte_bit,                  0 ; Byte transaction
  .equ np_dmacontrol_hw_bit,                    1 ; Half-word transaction
  .equ np_dmacontrol_word_bit,                  2 ; Word transaction
  .equ np_dmacontrol_go_bit,                    3 ; enable execution
  .equ np_dmacontrol_i_en_bit,                  4 ; enable interrupt
  .equ np_dmacontrol_reen_bit,                  5 ; Enable read end-of-packet
  .equ np_dmacontrol_ween_bit,                  6 ; Enable write end-of-packet
  .equ np_dmacontrol_leen_bit,                  7 ; Enable length=0 transaction end
  .equ np_dmacontrol_rcon_bit,                  8 ; Read from a fixed address
  .equ np_dmacontrol_wcon_bit,                  9 ; Write to a fixed address
  .equ np_dmacontrol_doubleword_bit,            10 ; Double-word transaction
  .equ np_dmacontrol_quadword_bit,              11 ; Quad-word transaction
  .equ np_dmacontrol_softwarereset_bit,         12 ; Software reset - write twice in succession to reset
  .equ np_dmastatus_done_bit,                   0 ; 1 when done.  Status write clears.
  .equ np_dmastatus_busy_bit,                   1 ; 1 when busy.
  .equ np_dmastatus_reop_bit,                   2 ; read-eop received
  .equ np_dmastatus_weop_bit,                   3 ; write-eop received
  .equ np_dmastatus_len_bit,                    4 ; requested length transacted
 
  .equ np_dmacontrol_byte_mask,                 (1 << 0) ; Byte transaction
  .equ np_dmacontrol_hw_mask,                   (1 << 1) ; Half-word transaction
  .equ np_dmacontrol_word_mask,                 (1 << 2) ; Word transaction
  .equ np_dmacontrol_go_mask,                   (1 << 3) ; enable execution
  .equ np_dmacontrol_i_en_mask,                 (1 << 4) ; enable interrupt
  .equ np_dmacontrol_reen_mask,                 (1 << 5) ; Enable read end-of-packet
  .equ np_dmacontrol_ween_mask,                 (1 << 6) ; Enable write end-of-packet
  .equ np_dmacontrol_leen_mask,                 (1 << 7) ; Enable length=0 transaction end
  .equ np_dmacontrol_rcon_mask,                 (1 << 8) ; Read from a fixed address
  .equ np_dmacontrol_wcon_mask,                 (1 << 9) ; Write to a fixed address
  .equ np_dmacontrol_doubleword_mask,           (1 << 10) ; Double-word transaction
  .equ np_dmacontrol_quadword_mask,             (1 << 11) ; Quad-word transaction
  .equ np_dmacontrol_softwarereset_mask,        (1 << 12) ; Software reset - write twice in succession to reset
  .equ np_dmastatus_done_mask,                  (1 << 0) ; 1 when done.  Status write clears.
  .equ np_dmastatus_busy_mask,                  (1 << 1) ; 1 when busy.
  .equ np_dmastatus_reop_mask,                  (1 << 2) ; read-eop received
  .equ np_dmastatus_weop_mask,                  (1 << 3) ; write-eop received
  .equ np_dmastatus_len_mask,                   (1 << 4) ; requested length transacted
;  DMA Routines

