/*
	
	Erase the EPCS4 device.
	
	WARNING: This program erases the entire EPCS4 device

	-TR-
*/

#include "excalibur.h"

unsigned char* error_string(int error_code)
{
  switch (error_code)
  {
    case na_asmi_success: return "na_asmi_success";
    case na_asmi_err_device_not_present: return "na_asmi_err_device_not_present";
    case na_asmi_err_device_not_ready: return "na_asmi_err_device_not_ready";
    case na_asmi_err_timedout: return "na_asmi_err_timedout";
    case na_asmi_err_write_failed: return "na_asmi_err_write_failed";
    case na_asmi_invalid_config: return "na_asmi_invalid_config";
  }

  return "unknown error code";
}

int main(void){

	char answer = 0;
	int s = 0;

  printf("\nWARNING:\nExisting EPCS4 contents will be lost.\nAre you sure you "
    "want to proceed?  (type 'Y' to continue, 'N' to abort)\n");

  while (1)
  {
    answer = nm_printf_rxchar(0);
    if (answer == 'y' || answer == 'Y') break;
    if (answer != 'n' && answer != 'N') continue;
    printf("\nAborting EPCS4 write.  EPCS4 contents is unchanged.\n\n\004");
    return 0;
  }

	  // Unprotect the EPCS4.
  printf("unprotecting EPCS4...\n");
  s = nr_asmi_protect_region(na_asmi_protect_none);
  if (na_asmi_success != s)
  {
    printf("nr_asmi_protect_region() failed ('%s').\n\004", error_string(s));
    return 0;
  }

  // Erase the EPCS4.
  printf("erasing EPCS4...\n");
  s = nr_asmi_erase_bulk();
  if (na_asmi_success != s)
  {
    printf("nr_asmi_erase_bulk() failed ('%s').\n\004", error_string(s));
    return 0;
  }

	printf("Erase Done.\n\n\004");

	return 0;

}
