; ----------------------------------------------
; ASMI Peripheral
;
  ;
  ; ASMI Registers
  ;
  .equ np_asmirxdata,      0 ; Read-only, 1-16 bit
  .equ np_asmitxdata,      1 ; Write-only, same width as rxdata
  .equ np_asmistatus,      2 ; Read-only, 9-bit
  .equ np_asmicontrol,     3 ; Read/Write, 9-bit
  .equ np_asmireserved,    4 ; reserved
  .equ np_asmislaveselect, 5 ; Read/Write, 1-16 bit, master only
  .equ np_asmiendofpacket, 6 ; Read/write, same width as txdata, rxdata.

  ;
  ; ASMI Status Register
  ;
  .equ np_asmistatus_eop_mask,  (1 << 9)
  .equ np_asmistatus_e_mask,    (1 << 8)
  .equ np_asmistatus_rrdy_mask, (1 << 7)
  .equ np_asmistatus_trdy_mask, (1 << 6)
  .equ np_asmistatus_tmt_mask,  (1 << 5)
  .equ np_asmistatus_toe_mask,  (1 << 4)
  .equ np_asmistatus_roe_mask,  (1 << 3)

  .equ np_asmistatus_eop_bit,  9
  .equ np_asmistatus_e_bit,    8
  .equ np_asmistatus_rrdy_bit, 7
  .equ np_asmistatus_trdy_bit, 6
  .equ np_asmistatus_tmt_bit,  5
  .equ np_asmistatus_toe_bit,  4
  .equ np_asmistatus_roe_bit,  3

  ;
  ; ASMI Control Register
  ;
  .equ np_asmicontrol_sso_mask,   (1 << 10)
  .equ np_asmicontrol_ieop_mask,  (1 << 9)
  .equ np_asmicontrol_ie_mask,    (1 << 8)
  .equ np_asmicontrol_irrdy_mask, (1 << 7)
  .equ np_asmicontrol_itrdy_mask, (1 << 6)
  .equ np_asmicontrol_itoe_mask,  (1 << 4)
  .equ np_asmicontrol_iroe_mask,  (1 << 3)

  .equ np_asmicontrol_sso_bit,   10
  .equ np_asmicontrol_ieop_bit,  9
  .equ np_asmicontrol_ie_bit,    8
  .equ np_asmicontrol_irrdy_bit, 7
  .equ np_asmicontrol_itrdy_bit, 6
  .equ np_asmicontrol_itoe_bit,  4
  .equ np_asmicontrol_iroe_bit,  3

  ; ASMI memory definitions
.if na_asmi_64K
  .equ na_asmi_bulk_size,   (0x2000)
  .equ na_asmi_sector_size, (na_asmi_bulk_size >> 2)
  .equ na_asmi_page_size,   0x20

.elseif na_asmi_1M
  .equ na_asmi_bulk_size,   (0x20000)
  .equ na_asmi_sector_size, (na_asmi_bulk_size >> 2)
  .equ na_asmi_page_size,   0x100

.elseif na_asmi_4M
  .equ na_asmi_bulk_size,   (0x80000)
  .equ na_asmi_sector_size, (na_asmi_bulk_size >> 3)
  .equ na_asmi_page_size,   0x100
.endif

  ;ASMI memory instructions
  .equ na_asmi_read,    0x03
  .equ na_asmi_write,   0x02
  .equ na_asmi_wren,    0x06
  .equ na_asmi_wrdi,    0x04
  .equ na_asmi_rdsr,    0x05
  .equ na_asmi_wrsr,    0x01
  .equ na_asmi_se,      0xd8
  .equ na_asmi_be,      0xc7
  .equ na_asmi_dp,      0xb9

  ;ASMI memory status register bit masks
.if (na_asmi_64K) || (na_asmi_1M)
  .equ na_asmi_bp,      0xc
.else
  .equ na_asmi_bp,      0x1c
.endif
  .equ na_asmi_wel,     0x2
  .equ na_asmi_wip,     0x1

  ;ASMI protection masks
  .equ na_asmi_protect_none,        0
.if (na_asmi_64K) || (na_asmi_1M)
  .equ na_asmi_protect_top_quarter, 0x4
  .equ na_asmi_protect_top_half,    0x8
  .equ na_asmi_protect_all,         0xc
.else
  .equ na_asmi_protect_top_eighth,  0x4
  .equ na_asmi_protect_top_quarter, 0x8
  .equ na_asmi_protect_top_half,    0xc
  .equ na_asmi_protect_all,         0x10
.endif

