#Copyright (C)2001-2002 Altera Corporation
#Any megafunction design, and related net list (encrypted or decrypted),
#support information, device programming or simulation file, and any other
#associated documentation or information provided by Altera or a partner
#under Altera's Megafunction Partnership Program may be used only to
#program PLD devices (but not masked PLD devices) from Altera.  Any other
#use of such megafunction design, net list, support information, device
#programming or simulation file, or any other related documentation or
#information is prohibited for any other purpose, including, but not
#limited to modification, reverse engineering, de-compiling, or use with
#any other silicon devices, unless such use is explicitly licensed under
#a separate agreement with Altera or a megafunction partner.  Title to
#the intellectual property, including patents, copyrights, trademarks,
#trade secrets, or maskworks, embodied in any such megafunction design,
#net list, support information, device programming or simulation file, or
#any other related documentation or information provided by Altera or a
#megafunction partner, remains with Altera, the megafunction partner, or
#their respective licensors.  No other licenses, including any licenses
#needed under any third party's intellectual property, are provided herein.
#Copying or modifying any file, or portion thereof, to which this notice
#is attached violates this copyright.



use strict;

###############
# utilities and GASP! a global variable (its called $GLOBAL_PROJECT
# and is hidden in global_project).

use print_command;
use mk_bsf;
use e_ptf;
#use Cwd;
use filename_utils;
use run_system_command_utils;

use europa_global_project;
################################################################
use europa_utils;

######################################################################
# here are the classes that a europa coder needs to know about.  To
# find out more about these classes, you can open their corresponding
# file. (e.g. e_module is in a file called e_module.pm).  Look at
# their "new" method to see their supported fields.

use e_module;          # equivalent to a verilog module or vhdl entity.  
                       # everything below here may go inside the contents of
                       # e_module with the exception of e_if which may
                       # only go inside the contents of an e_process statement.

use e_expression;      # The basic verilog/vhdl expression engine.
###############
# objects derived from e_module :
use e_test_module;     # e_module which optionally routes out no signals
use e_fifo;            # FIFO with predictive fifo-full.
use e_async_fifo;      # asynchronous FIFO for clock domain crossing

###############
#instantiations
use e_instance;        # equivalent to an instance of a module.  It
                       # declares a module and defines a port map.

use e_rom;             # child of e_instance.  Set up to instantiate a lpm_rom.
use e_ram;             # child of e_instance.  Set up to instantiate a lpm_ram_dp.
use e_dpram;           # lpm_ram_dp or altsyncram.
use e_fifo_with_registered_outputs;
#use e_firm_flip_flop;  # child of e_instance.  Set up to instantiate a dffe.

###############
#signals
use e_signal;          # use this to define signals.
use e_port;            # e_signal plus direction.  You should only use
                       # e_port to describe an interface to a  black
                       # box module.  Otherwise, e_signal is smart
                       # enough to determine if the signal is an
                       # input,output or an internal signal.

use e_control_signal;  # e_signal plus additional control stuff. ask
                       # Peter Hutkins about this one.

#use e_self_wiring_signal; # a signal which can be wired up based upon
                          # its type
 
###############
#assignments
use e_assign;          # used for assigning wires or registers in
                       # verilog.  used to assign signals in vhdl.
use e_mux;             # e_assign with capabilities for arbitrating
                       # multiple input signals

###############
#always (verilog) / process (vhdl) statements
use e_stop;
use e_if_x;            
use e_process_x;       #simulation checking for x

use e_assign_is_x;     # assign non-zero if x 

use e_process;         # used to define generic processes.  Inside
                       # e_process you'll find e_if and e_assign
                       # statements

use e_if;              # only allowed inside e_process contents.  Used
                       # to describe conditional assigning.

use e_case;            # only allowed inside e_process contents.  Used
                       # to describe conditional assigning.

use e_register;        # a more restrictive e_process definition to describe
                       # flip flops which may help lame synthesis
                       # tools to define a better object.

use e_mux_reg;

###############
# Higher-level synchronous constructs
use e_edge_detector;   # Register-plus-logic for rising/falling edge 
                       # detection.  Just a convenient bundle.

use e_shift_register;  # Pretty handy bundle which allows flexible
                       # creation of complex shift-register objects
                       # with lots of different options and features.

use e_width_conduit;
use e_export;

################
# SOPC-Builer (PTF-file) interface.
use e_slave;           # An abstract class that corresponds to a "SLAVE" 
                       # port section in the PTF-file.

use e_avalon_slave;    # An e_slave object which "knows about" Avalon 
                       # port types.

use e_avalon_master;   # An e_slave object which "knows about" Avalon 
                       # port types: corresponds to MASTER section of PTF file.

################
# Simulation support
use e_clk_gen;        # generate a clock signal
use e_sim_fopen;      # An object for opening files
use e_sim_write;      # An object for implementing '$write' directives
                      # to a putative simulator.
use e_initial_block;  # For things that happen at init time, e.g. $readmemb
use e_readmem;        # Load a memory from a file, via $readmemh, $readmemb.
use e_reset_gen;      # generate a reset signal
use e_pull;           # Test bench pullup or pulldown

use e_drom;           # dynamic rom (can be written to by perl)
use e_log;            # logs ASCII output to a file

use e_sim_wave_text;  # an emux whose result is a text string when
                      # displayed as radix ascii in a wave viewer. 

use e_sim_cmd;        # A way to call a simulator function (e.g. $display)
                      # or a PLI/FLI function. Only supports Verilog for now.

use e_lpm_base;
use e_lpm_altsyncram;
use e_lpm_dcfifo;
use e_clock_crossing;
use e_synchronizer;
use e_comment;
use e_component;

# Adapters:
use e_adapter;
use e_avalon_adapter_interface;
use e_avalon_adapter_master;
use e_avalon_adapter_slave;

#end of the classes a europa coder needs to know about.
######################################################################

######################################################################
# following are a list of classes which form the infrastructure of
# europa, you don't need to worry about them unless you have to go
# "under the hood".

#use e_parameter;   # parameters are supported for instantiating lpm
                    # rams and roms but you should really use europa
                    # to paramterize your modules.

#use _e_ram_module;
#use _e_rom_module;
#use e_object;
#use e_expression;
#use e_module_database;
#use e_thing_that_can_go_in_a_module;
#use e_ptf;
#use e_project;




# +------------------------------------------------------
# | Make europa_all itself a package for the sole purpose
# | of making a version number accessible.
# |
package europa_all;
    use Exporter;
    @europa_all::ISA = ("Exporter");
    @europa_all::EXPORT = qw($VERSION);


    # version number
    $europa_all::VERSION = "6.0";  # it is a dotted-number string,
                          # like our Java Version class.
# |
# +------------------------------------------------------



#that's europa
1;

