




################################################################
# CLASS: e_test_module
#
################################################################


=head1 NAME

e_test_module - description of the module goes here ...

=head1 SYNOPSIS

The e_test_module class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_test_module;
use e_module;
use europa_utils;

@ISA = ("e_module");
use strict;

################################################################
# e_module::new
#
# Constructor copied straight out of the tutorial.
#
################################################################
my %fields = (
              export_no_signals   => 0,
              add_user_comments   => 1,
              );

my %pointers = ();

&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

################################################################################

=item I<get_internal_signal_names()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub get_internal_signal_names
{
   my $this = shift;
   if ($this->export_no_signals())
   {
      #everything is internal
      return $this->get_signal_names();
   }
   else
   {
      return $this->SUPER::get_internal_signal_names();
   }
}

################################################################################

=item I<to_verilog()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub to_verilog
{
  my $this = shift;
  return if ($this->_hdl_generated());
  $this->_hdl_generated(1);

  my $sys_dir = quotemeta($this->_project()->_system_directory());
  
  # N.b. The function _make_verilog_string() has important side effects.
  # Call it now, a.k.a. before calling _get_unique_sim_hdl_files(),
  # or you lose.  But!  _make_verilog_string() calls print_user_code(), which
  # pops user-code-sections off of a list.  So, there's an additional wrinkle: 
  # in order to pull the user-code sections off the list in the right order,
  # I have to call print_user_code myself first, save the result, then use it
  # below.
  my $user_include_code = $this->print_user_code();
  my $vs = $this->_make_verilog_string();
  
  # Strip the project directory from all source files.    
  my @included_files = map {s/$sys_dir[\\\/]//sg; $_;}
    $this->_project()->_get_unique_sim_hdl_files();
    
  
   # PLI STUFF:  VERILOG ONLY!!!!!!
   # What is this:  Well, when it comes to simulating a system in Verilog, some of the Altera's memory models
   # are capable of loading either a HEX or DAT file.  However, the loading of the HEX file requires that the
   # version of Modelsim be enabled with a PLI DLL.
   # Problem...
   # Only the Altera OEM version of Modelsim has the PLI DLL natively enabled.
   # Users of the Professional Version of Modelsim do not have the PLI DLL and need to go through some effort to
   # make everything work.
   # Therefore...
   # Until we can conditionally turn on/off the NO_PLI directive based on whether or not the customer wants 
   # it, we will turn it off by default.

   my $my_pli_funny_business;
   $my_pli_funny_business .= "// If user logic components use Altsync_Ram with convert_hex2ver.dll,\n";
   $my_pli_funny_business .= "// set USE_convert_hex2ver in the user comments section above\n\n";
   $my_pli_funny_business .= "`ifdef USE_convert_hex2ver\n";
   $my_pli_funny_business .= "`else\n";
   $my_pli_funny_business .= "`define NO_PLI 1\n";
   $my_pli_funny_business .= "`endif\n";

  my $project = $this->_project();
  my $quartus_sim_dir_location = $project->_sopc_quartus_dir(). '/eda/sim_lib';

  unshift (@included_files, 
           "$quartus_sim_dir_location/altera_mf.v",
           "$quartus_sim_dir_location/220model.v",
           "$quartus_sim_dir_location/sgate.v"
           );

   my $vs = join ("\n",
                  "//". $this->_project()->_translate_off,
                  "",
                  $user_include_code,
		  $my_pli_funny_business,

		  # strip VHDL file include references
		  # VHDL component files have suffixes: .vhd, .vhdl or .vho (Simgen)
                  (map {/\.vh.*$/ ? "\/\/ $_" : "\`include \"$_\""} @included_files),

                  "",
                  $this->project->_get_timescale_directive
                     ("no translate_off"),
                  $vs,
                  "//".$this->project()->_translate_on);

  push (@{$project->module_pool()->{verilog}},$vs);
}

################################################################################

=item I<to_vhdl()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub to_vhdl
{
   my $this = shift;
   return if ($this->_hdl_generated());
   $this->_hdl_generated(1);

   my $vs = join ("\n","--".$this->_project->_translate_off,
      "",
      $this->_vhdl_make_string(),
      "",
                  "--".$this->_project->_translate_on."\n");

   push (@{$this->_project()->module_pool()->{vhdl}},$vs);
}

################################################################################

=item I<is_output()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub is_output
{
  my $this = shift;

  if ($this->export_no_signals())
  {
    return 0;
  }
  else
  {
    return ($this->SUPER::is_output(@_));
  }
}

################################################################################

=item I<is_input()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub is_input
{
    my $this = shift;
    if ($this->export_no_signals())
    {
      return 0;
    }
    else
    {
      return ($this->SUPER::is_input(@_));
    }
}

################################################################
# to_ptf
#
################################################################
################################################################################

=item I<to_ptf()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub to_ptf
{
  my $this = shift;

  return if ($this->export_no_signals()); #no signals going out mean,
                                          #nothing to put in the ptf file
  my $ptf_section = 
      $this->module_ptf()->{SIMULATION}{INSTANTIATIONS};

  $ptf_section->{PORT_WIRING} = {} ;# unless $ptf_section->{PORT_WIRING};
  
  foreach my $port_name ($this->get_port_names()) 
  {
     my $sig_object = $this->get_signal_by_name ($port_name)
         or &ribbit ("port '$port_name' cannot be found.");

    $sig_object->add_to_ptf_section ($ptf_section->{PORT_WIRING});
  }
}

1;


=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_module

=begin html

<A HREF="e_module.html">e_module</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
