
################################################################
# CLASS: e_sim_cmd
#
################################################################

# Used to put calls to built-in and PLI/FLI simulator functions.
# 
# For example,
#   e_sim_cmd->new("display", qw("%0d: abc became %h"), "\$time", "abc");
# becomes this Verilog:
#   $display("%0d: abc became %h", $time, abc");


=head1 NAME

e_sim_cmd - description of the module goes here ...

=head1 SYNOPSIS

The e_sim_cmd class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_sim_cmd;

@ISA = ("e_thing_that_can_go_in_a_module");
use strict;
use europa_utils;

################################################################
# e_sim_cmd::new
#
# Constructor copied straight out of the tutorial.
#
################################################################
my %fields = (
              function_name => '',
              args         => [],
              _expressions  => [],
             );

my %pointers = ();

&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields,
     \%pointers);

################################################################################

=item I<_order()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _order
{
   return ['function_name', 'args'];
}

# sub args
# {
#    my $this = shift;
#    my @_arg_array;
#    my @_expression_array;

#    foreach my $arg (@_)
#    {
#       push (@_arg_array, $arg);

#    }
# }

################################################################################

=item I<to_verilog()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub to_verilog 
{
   my $this = shift;
   my $indent = shift;
   my $function_name = $this->function_name();

   my $str = $indent . "\$". $function_name;

   my @args = @{$this->args()};
   if (scalar(@args)) 
   {
      $str .= "(" . join(',', @args) . ")";
   }

   return $str . ";\n";
}

################################################################################

=item I<to_vhdl()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub to_vhdl 
{
   my $this = shift;
   my $indent = shift;
   my $function_name = $this->function_name();

   &ribbit("e_sim_cmd not yet supported for vhdl");
}

__PACKAGE__->DONE();

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_thing_that_can_go_in_a_module

=begin html

<A HREF="e_thing_that_can_go_in_a_module.html">e_thing_that_can_go_in_a_module</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
