

################################################################
# CLASS: e_pull
#
################################################################


=head1 NAME

e_pull - description of the module goes here ...

=head1 SYNOPSIS

The e_pull class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_pull;
use e_expression;
use e_process;
@ISA = ("e_thing_that_can_go_in_a_module");
use strict;
use europa_utils;

#done because of comment stripper.
my $__HASH_CHARACTER__ = '#';

################################################################
# ::new
#
# Constructor copied straight out of the tutorial.
#
################################################################
my %fields = (
              signal => undef,
              pull_type => 'pullup',
              );

my %pointers = (
               );

&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

################################################################################

=item I<to_verilog()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub to_verilog
{
   my $this = shift;
   my $indent = shift;

   my $sig = $this->signal();

   my $vs = $this->pull_type() . "($sig);\n\n";

   #indent it.
   $vs =~ s/^/$indent/mg;
   return ($vs);
}

################################################################################

=item I<to_vhdl()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub to_vhdl
{
   my $this = shift;
   my $indent = shift;

   my $sig = $this->signal();
   my $value = "''";
   {
     $this->pull_type eq 'pullup' and do {$value = "'H'"; last;};
     $this->pull_type eq 'pulldown' and do {$value = "'L'"; last;};
   }
   
   my $vs = 
"PROCESS
BEGIN
  $sig <= $value;  
WAIT;
END PROCESS;
\n\n";


   #indent it.
   $vs =~ s/^/$indent/mg;
   return ($vs);
}

1;

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_thing_that_can_go_in_a_module

=begin html

<A HREF="e_thing_that_can_go_in_a_module.html">e_thing_that_can_go_in_a_module</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
