






=head1 NAME

e_ptf_update_to_4_0 - description of the module goes here ...

=head1 SYNOPSIS

The e_ptf_update_to_4_0 class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_ptf_update_to_4_0;
@ISA = ("e_ptf_update_to_2_8");
use e_ptf;
use e_ptf_update_to_2_8;
use europa_utils;
use strict;

################################################################
#
# Constructor copied straight out of the tutorial.
#
################################################################
my %fields   = ();
my %pointers = ();

&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

################################################################
#
# translates an outdated ptf_file to a modern ptf file and
# writes it back to the original file
################################################################

################################################################################

=item I<ptf_update()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub ptf_update
{
   my $this = shift;

   $this->SUPER::ptf_update();

   foreach my $system (keys %{$this->ptf_hash()})
   {
      my $system_hash = $this->ptf_hash()->{$system};

      #make sure we need to update.
      my $SWV = $system_hash->{System_Wizard_Version};

      #convert 1.1.1 to 1.11
      while ($SWV =~ s/^(.*?\..*)\./$1/s){;}

      my $version_number = 4.0;
      return if ($SWV >= $version_number);
      $this->need_to_write_file(1);
      $system_hash->{System_Wizard_Version} = "$version_number";

      my @replaced_names;
      foreach my $module (keys %{$system_hash})
      {
         next unless ($module =~ /MODULE\s+(\w+)/);
         my $name = $1;
         my $mod = $system_hash->{$module};

         #class renaming
         my $class = $mod->{class};
         my $sbi   = $mod->{SYSTEM_BUILDER_INFO};
         my $wsa   = $mod->{WIZARD_SCRIPT_ARGUMENTS};

         if ($class eq "altera_avalon_onchip_memory")
         {
            # For onchip memories, STRATIX and STRATIXII are equivalent.
            $mod->{SYSTEM_BUILDER_INFO}->{Required_Device_Family}
              =~ s/STRATIX/STRATIX,STRATIXII/;
            
            $mod->{class_version} = "4.0";
         }
      }
   }
   $this->ptf_to_file();
}

1;

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_ptf_update_to_2_8

=begin html

<A HREF="e_ptf_update_to_2_8.html">e_ptf_update_to_2_8</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
