



################################################################
# CLASS: e_ptf_master_arbitration_module (based upon e_ptf_arbitration_module).
#   e_ptf_master_arbitration_module is the module associated with a particular master.
#   All signals which come from the master, get broadcast out.  It is
#   the job of the slave_arbitrator to handle slave specific desires,
#   like setup/hold time or dynamic bus sizing of the address.
#   
#   Nearly all signals which go to the master are routed here from
#   slaves and are muxed by the slave chip select.  The exception is
#   the irq_number mux.  You might think the waitrequest bus would
#   also be an exception, but all of its complexity is handled in the
#   slave arbitration module
#
#   The irq mux is a priority mux prioritized by the actual
#   irq_number field in the SYSTEM_BUILDER_INFO section.  The wait
#   request mux can be asserted by the slave waitrequest pin or by a
#   counter depending upon the SYSTEM_BUILDER_INFO->{Read_Wait_States}
#   and SYSTEM_BUILDER_INFO->{Write_Wait_States} fields.
#    
# ADDITIONAL FIELDS:
#   readata, waitrequest, irq
#     muxes for arbitrating the data going to the master
#
#
################################################################

=head1 NAME

e_ptf_master_arbitration_module - description of the module goes here ...

=head1 SYNOPSIS

The e_ptf_master_arbitration_module class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_ptf_master_arbitration_module;

use e_ptf_arbitration_module;
@ISA = ("e_ptf_arbitration_module");

use strict;
use europa_utils;

################################################################
# new
#
#
################################################################
my %fields   = ();
my %pointers = ();

################################################################################

=item I<update()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub update
{
   my $this = shift;
   $this->_update_name();

   $this->SUPER::update(@_);
}

1;

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_ptf_arbitration_module

=begin html

<A HREF="e_ptf_arbitration_module.html">e_ptf_arbitration_module</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
