






=head1 NAME

e_ptf_master - description of the module goes here ...

=head1 SYNOPSIS

The e_ptf_master class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_ptf_master;

use e_ptf_slave;

@ISA = ("e_ptf_slave");
use strict;
use europa_utils;

################################################################
# e_ptf_master::new
#
#
################################################################

my %fields = (
              _already_updated => 0,
              );

my %pointers = ();

&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

################################################################################

=item I<_get_exclusively_named_port_by_type()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_exclusively_named_port_by_type
{
   my $this = shift;

   my $type = shift or &ribbit ("no type");

   my $return = 
       $this->_get_exclusively_named_port_or_its_complement
           ($type);

   #"no read port for you!" if you don't have readdata.
   $return = ""
       if (
           ($type =~ /^read(\_n)?$/) &&
           !($this->_get_exclusively_named_port_or_its_complement
            ("readdata")
             )
           );

   #"no write port for you!" if you don't have writedata.
   $return = ""
       if (
           ($type =~ /^write(\_n)?$/) &&
           !($this->_get_exclusively_named_port_or_its_complement
            ("writedata")
             )
           );

   # If someone asks for a master's address, return the outgoing
   # address instead.  If you want the true master address, use
   # the function _get_actual_master_address.
   if ($return && ($type =~ /^address(_n)*/))
   {
     $return .= "_to_slave";
   }
   
   return $return;
}

# This routine returns the unmodified address signal from the master.
# If anyone asks for the master address in the ordinary fashion (via
# _get_exclusively_named_port_by_type() they get the "shunted" address,
# which is equivalent to the master address, with optional optimizations.
################################################################################

=item I<_get_actual_master_address()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_actual_master_address
{
   my $this = shift;

   return $this->_get_exclusively_named_port_or_its_complement
           ('address');
}

################################################################################

=item I<_get_address_width()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_address_width
{
   my $this = shift;

   # Grab the 'address' port from this master, and return its width.
   my ($port) = $this->_get_port_or_its_complement('address', 'e_port');

   my $width = 0;
   if ($port)
   {
     $width = $port->width();
   }
   
   return $width;
}

=item I<_make_address_shunt()>

The address from the master comes into the master arbitrator,
goes through a piece of combinational logic, and goes out
to each slave.

The generated logic depends on ptf option
 <system>/WIZARD_SCRIPT_ARGUMENTS/optimize_master_address
which defaults to 1.
The address shunt logic is either
1) A simple assignment (optimize_master_address = 0)
2) Logic which attempts to capitalize on knowledge of
  all the master's slaves' base addresses and ranges.
  (optimize_master_address = 1, or the assignment doesn't exist).

=cut

sub _make_address_shunt
{
   my $this = shift;
   
   my $pm = $this->parent_module();
   my $module_name = $pm->name();
   my $master_name = $this->name();
   my $master_desc = "$module_name/$master_name";
   
   my $master_address = $this->_get_exclusively_named_port_by_type("address");
   return if !$master_address;

   my $thing_name = "$master_desc address to slave";
   
   my $assign = $this->_arbitrator()->get_and_set_once_by_name({
     comment => "optimize select-logic by passing only those address bits which matter.",
     thing => 'assign',
     name => $thing_name,
   });
   
   # If this assignment already exists, our work here is done.
   return if !$assign;
   
   my $address_width = $this->_get_address_width();
   my $actual_master_address = $this->_get_actual_master_address();
   
   # Optimized or not, the address shunt has this output (master
   # address to slave):
   $assign->lhs(e_signal->new([$master_address, $address_width, 1]));

   my $project = $pm->project();
   my $wsa =
     $project->spaceless_system_ptf()->{WIZARD_SCRIPT_ARGUMENTS};
   
   # Grab the ptf option that controls this optimization.  
   # If the value isn't present in the ptf file, default to 1 (do
   # optimization).
   my $do_opt = $wsa->{optimize_master_address};
   $do_opt = 1 if !exists($wsa->{optimize_master_address});

   # The only thing left to do is to figure out the input to the 
   # address shunt.  If we're not optimizing, the input is simply
   # the actual master address.  Optimizing requires analysis of
   # all this master's slaves' addresses and ranges.
   #
   my $rhs;
   if (!$do_opt || $this->is_adapter())
   {
     # This is easy.  Send the incoming address back out.
     $rhs = $actual_master_address;
   }
   else
   {
      # Create a concatenation of constant values and slices of the
      # master address, e.g.
      # {3'b101, <actual_master_address>[10 : 0]}
      
      my ($volatile_address_mask, $constant_address_value) =
           _get_volatile_and_constant_address_bits(
              $project,
              $module_name,
              $master_name,
              $master_desc);
              
      # volatile_address_mask has a 1-bit wherever the address must
      # be driven by a real register, and a 0-bit where a constant
      # value can be driven.  constant_address_value contains the
      # proper constant value to drive, in each bit position where
      # volatile_address_mask has a 0-bit.
      
      # Walk two pointers through the volatile address mask from msb to lsb,
      # finding sub-sequences of all-constant or all-volatile bits.  For each
      # sub-sequence, push a representing expression into a list.
      
      my @bits;
      my $ms_bit_index = $address_width - 1;
      my $ls_bit_index = $ms_bit_index - 1;
      while (1)
      {
        # Fear not, ms_bit_index is never > 31, so there won't be overflow.
        my $ms_bit_index_mask = 1 << $ms_bit_index;
        my $ls_bit_index_mask = 1 << $ls_bit_index;
        
        my $is_volatile_ms_bit =
          ($ms_bit_index_mask & $volatile_address_mask) ? 1 : 0;
        my $is_volatile_ls_bit =
          ($ls_bit_index_mask & $volatile_address_mask) ? 1 : 0;
          
        if (($ls_bit_index == -1) || ($is_volatile_ms_bit != $is_volatile_ls_bit))
        {
          my $term;
          #
          # ms_bit_index is now the bit-index of the most-significant end of
          # the sub-sequence; ls_bit_index is one bit beyond the end of the
          # least-significant end of the sub-sequence.
          #
          # What we do next depends on whether the identified sub-sequence is
          # full of constant or volatile bits.
          if ($is_volatile_ms_bit)
          {
            # If it's a volatile bit-sequence, pass the actual master's
            # address bits to the slave.
            $term = "$actual_master_address\[$ms_bit_index : @{[$ls_bit_index + 1]}]";
          }
          else
          {
            # It's a constant bit-sequence.  Extract the appropriate constant
            # bits from constant_address_value.
            
            # Pull out $ms_bit_index - $ls_bit_index bits from the constant value...
            my $width = $ms_bit_index - $ls_bit_index;
            # ... create a mask of 1-bits for this sequence...
            my $const_bits_mask = get_mask_of_1_bits($ms_bit_index + 1);
            if ($ls_bit_index > -1)
            {
              # Zero out the lsb's of this sequence, unless we're at the end.
              $const_bits_mask &= ~get_mask_of_1_bits($ls_bit_index);
            }
              
            # ... pull out the constant value, and shift it down to 0-position...
            my $const_bits = ($const_bits_mask & $constant_address_value) >> ($ls_bit_index + 1);
            
            # ... spit out the extracted bits as a verilog constant.
            $term = sprintf("%d'b%b", $width, $const_bits)
          }
          
          # Add the appropriate expression to the list.
          push @bits, $term;
          # Update base to start the next sequence.
          $ms_bit_index = $ls_bit_index;
        }

        # If end has reached -1, we just emitted the last sequence.
        # Get outta town.
        last if $ls_bit_index == -1;
        
        # Two cases:
        # 1) we're in a sequence.  
        # 2) just came to the end of a sequence and emitted it to the list.
        # Either way, walk end one bit towards the lsb.
        $ls_bit_index--;
      }
      
      $rhs = concatenate(@bits);
      
        # A simulation warning when a master addresses outside its
        # range would be kinda cool, but this implementation is flawed.
        # Don't use it for now.
      $this->_make_master_address_assertion(
        $master_desc,
        $volatile_address_mask,
        $constant_address_value,
        $address_width,
        $actual_master_address
      );
   }

   $assign->rhs($rhs);
}

################################################################################

=item I<_get_volatile_and_constant_address_bits()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_volatile_and_constant_address_bits
{
  my ($project, $module_name, $master_name, $master_desc) = @_;

  my @slave_names =
    $project->get_slaves_by_master_name($module_name, $master_name);

  my @base_and_last_addresses = ();
  
  for my $slave_desc (@slave_names)
  {
    # Slaves with no base address have no impact on the address bits.
    next if ($project->SBI($slave_desc)->{Has_Base_Address} eq "0");
    
    my ($address_width, $base_addr, $last_addr) = 
      master_address_width_from_slave_parameters(
        $project, $master_desc, $slave_desc);

    push @base_and_last_addresses, ($base_addr, $last_addr);
  }

  # Empty list?  What do you expect?
  # I'll pretend this makes sense, and say, "none of these
  # bits are volatile".
  return (0, 0) if (!@base_and_last_addresses);

  ribbit("Empty list!\n") if !@base_and_last_addresses;

  # Expect base_addr/last_addr pairs.
  ribbit("Odd number of elements!") if (0 + @base_and_last_addresses & 1);

  # Be nice: accept decimal numbers, octal numbers preceded by 0,
  # and hex numbers preceded by 0x.
  map {if (/^0/) {$_ = oct($_)}} @base_and_last_addresses;

  # Paranoia: what if there's a base, end pair like 0xC00, 0xC05?
  # Boost the end address up to 0xC07.
  my $base;
  map {
    # Even entry: it's the base.
    if (!($_ & 1))
    {
      $base = $base_and_last_addresses[$_];
    }
    else
    {
      # Odd entry: it's the range.
      my $delta = $base_and_last_addresses[$_] - $base;
      if ($delta > 1)
      {
        # Why is 1 a special case?  It's the only value which is both
        # at the top of its range (that is, all 1-bits from the first
        # set bit down to the LSB) and also a power of two.  The routine
        # next_higher_power_of_two() returns powers of 2 unchanged, which
        # results in badness when I subtract 1.
        #
        # 0 is a special case because it causes a ribbit!  Also, it turns out
        # that there's no need to change the last-address in this case.
        $base_and_last_addresses[$_] = $base + next_higher_power_of_two($delta) - 1;
      }
    }
  } (0 .. @base_and_last_addresses - 1);
  
  # The operation I want to do is:
  # (b1 ^ l1) | (l1 ^ b2) | (b2 ^ l2) | ... (bn ^ ln)

  # I have a list of elements
  # (b1, l1, b2, l2, ..., bn, ln)

  # From that, make two lists
  # (b1, l1, b2, l2, ..., bn)
  # (l1, b2, l2, ..., bn, ln)

  # Then it's easy to do operations on adjacent elements of the original
  # list, that is (b1 op l1), (l1 op b2), (b2 op l2), ...

  my @shifted_addrs = @base_and_last_addresses;
  pop @base_and_last_addresses;
  shift @shifted_addrs;

  my $vol = 0;
  for (0 .. @base_and_last_addresses - 1)
  {
    $vol |= $base_and_last_addresses[$_] ^ $shifted_addrs[$_];
  }

  # Any address can be used to find the constant value.
  my $const = $base_and_last_addresses[0] & ~$vol;
  
  return ($vol, $const);
}

################################################################################

=item I<_can_handle_read_latency()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _can_handle_read_latency
{
   my $this = shift;
   return ($this->_get_exclusively_named_port_by_type
       ("readdatavalid") ne "");
}


# Emit a warning in simulation if a master addresses outside
# of its range. 
#
# This routine is flawed: it cannot catch every case of address
# violation (because many masters are smart about only generating
# as many address bits as they need to address all their slaves.
# If a master "attempts" to access a slave at a high address, but
# has insufficient address bits to reach it, this routine can't
# detect it.
#
# Also, upon violation, you'd really like to print the address
# of the violation.  e_sim_write.pm does not allow printing of
# hex numbers for VHDL, annoyingly.
# 
################################################################################

=item I<_make_master_address_assertion()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _make_master_address_assertion
{
  my $this = shift;
  my (
    $master_desc,
    $volatile_address_mask,
    $constant_address_value,
    $address_width,
    $actual_master_address
  ) = @_;

  # And now for something completely different:in simulation, note if
  # the assumption about constant address bits is violated.
  my $allegedly_constant_bits =
    get_mask_of_1_bits($address_width) & (~$volatile_address_mask);

  # Now for something completely different: only emit this assertion if
  # there are any address bits which alledgely assume a constant value.
  if ($allegedly_constant_bits != 0)
  {
    my $master_sbi = $this->{SYSTEM_BUILDER_INFO};

    # The assertion is:
    # complain if <master_select> and
    #   (<master_address constant bits> != <alledged constant value>)
    #
    # The assertion is printed only once, because otherwise too many
    # messages get printed.

    # The mess below just makes the logical expression that's true 
    # when the master is accessing a slave.
    my $master_cs =
      $this->_get_exclusively_named_port_or_its_complement("chipselect");
    my $master_read =
      $this->_get_exclusively_named_port_or_its_complement("read");
    my $master_write =
      $this->_get_exclusively_named_port_or_its_complement("write");
    my @access;
    if ($master_write && $master_sbi->{Make_Write_Address_Bounds_Assertion})
    {
      push @access, $master_write;
    }

    if ($master_read && $master_sbi->{Make_Read_Address_Bounds_Assertion})
    {
      push @access, $master_read;
    }

    # If this master has no read/write signals enabled by
    # ptf assignments, there's nothing to do.
    return if !@access;

    my $select = and_array($master_cs, or_array(@access));

    # Make a process containing a conditional simulation-only write.
    # The simulation write prints the master name and the address
    # which constituted a violation.
    $this->_arbitrator()->add_contents(
      e_process->new({
        tag => 'simulation',
        contents => [
          e_if->new({
            condition =>
              sprintf(
                "($select && " .
                "($actual_master_address & %d'b%b) != %d'b%b)",
                $address_width,
                $allegedly_constant_bits,
                $address_width,
                $constant_address_value),
            then => [
              e_sim_write->new({show_time => 1,
                                spec_string =>
                "Assertion failure: master '$master_desc' attempted to " .
                "address outside its allowed range"}),
              e_stop->new(),
            ],
          }),
        ],
      }),
    );
  }
}

1;

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_ptf_slave

=begin html

<A HREF="e_ptf_slave.html">e_ptf_slave</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
