





=head1 NAME

e_ptf_arbitration_module - description of the module goes here ...

=head1 SYNOPSIS

The e_ptf_arbitration_module class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_ptf_arbitration_module;
#use e_ptf_top_module;
use e_module;
#@ISA = ("e_ptf_top_module");
@ISA = ("e_module");
use strict;
use europa_utils;

################################################################
# e_ptf_arbitration_module::new
#
#
################################################################
my %fields = ();

my %pointers = (
                _master_or_slave => (bless {}, "e_ptf_slave"),
                );

&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

# Prepare for independent clock domains: all register
# and process objects within arbitrators should use this
# handy function to get the name of their clock signal,
# rather than relying on the default 'clk'.
################################################################################

=item I<clock()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub clock
{
   my $this = shift;
   return $this->_master_or_slave()->clock();
}

################################################################################

=item I<reset()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub reset
{
   my $this = shift;
   return $this->_master_or_slave()->reset();
}

################################################################################

=item I<reset_n()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub reset_n
{
   my $this = shift;
   return $this->_master_or_slave()->reset_n();
}

################################################################################

=item I<_make_signal()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _make_signal
{
   my $this = shift;

   my $signal = shift or &ribbit ("no signal");

   $signal =~ s|\/|\_|g;
   $signal =~ s|\_{2,}|\_|g;
   return ($signal);
}

################################################################################

=item I<_update_name()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _update_name
{
   my $this = shift;
   my $slave = $this->_master_or_slave();
   my $slave_mod = $slave->parent_module();

   my $name = join
       ('/',$slave_mod->name(),$slave->name(),"arbitrator");
   return ($this->name($this->_make_signal($name)));
}

################################################################################

=item I<_get_exclusively_named_port_by_type()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_exclusively_named_port_by_type
{
   my $this = shift;

   my $type = shift or &ribbit ("no type");
   my $return = $this->_master_or_slave()->
       _get_exclusively_named_port_or_its_complement
           ($type);

   return ($return);
}

################################################################################

=item I<_get_top()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_top
{
   my $this = shift;

   my $project =
       $this->_master_or_slave()->parent_module()->_project() 
           or &ribbit ("no project");

   my $top = $project->top() or &ribbit ("no top");
   return ($top);
}

################################################################################

=item I<_get_mux_of_type()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_mux_of_type
{
   my $this = shift;
   my $type = shift or &ribbit ("no type");

   my $mux = $this->get_object_by_name("mux $type");

   if (!$mux)  #make $mux_type if it does not exist.
   {
      my $default = 0;
      if ($type =~ /\_n$/)
      {
         $default = 1;
      }
      $mux = e_mux->new
          ({name => "mux $type",
            default => $default,
            parent => $this,
         });

      $this->add_contents($mux);
      $this->document_object($mux);
   }
   return ($mux);
}

################################################################################

=item I<update()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub update
{
   my $this = shift;
   $this->_update_name();

   # It's nice to get a handle on these little nuggets so that you 
   # can apply LogicLock to them when necessary.
   $this->add_attribute (auto_dissolve => {$this->name() => "FALSE"});

   # $this->_get_parents_ports();
   $this->SUPER::update(@_);
}

######################################################################
# _get_parents_ports
#
# ports will bubble correctly from master_or_slave to arbitration
# module unless the m/s isn't in the module.  To avoid that case, we
# make a copy of the m/s ports and stick it (as a signal) in the new
# module
#
######################################################################
################################################################################

=item I<_get_parents_ports()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_parents_ports
{
   my $this  = shift;
   my $ports = $this->_master_or_slave->_ports_by_type();

   foreach my $port (values (%$ports))
   {
      my $exclusive_name = $port->_exclusive_name();
      my $sig = e_signal->new($port);
      $sig->name($exclusive_name);
      $sig->export(0);
      $this->add_contents($sig);
   }
}

################################################################################

=item I<_get_master_module()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_master_module
{
   my $this = shift or ribbit ("no this!");
   my ($master_module_name,
       $master_name) = split (/\//,shift);

   $master_module_name or &ribbit ("no master module name");
   
   #my $project = $this->project() or &ribbit ("no project");
   my $project = $this->_master_or_slave()->project();
   my $master_module =
       $project->get_module_by_name($master_module_name);
   if (!$master_module)
   {
      &ribbit ("($project), known modules include ",
               join ("\n", keys
                     (%{$project->module_hash()})),
               "\n",
               $this->name(),
               "$this no master module declared for $master_module_name\n"
               );
   }
   return ($master_module);
}

################################################################################

=item I<_get_master()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_master
{
   my $this = shift;
   my $master_desc = shift;
   my ($master_module_name,
       $master_name) = split (/\//,
                              $master_desc);

   $master_name or &ribbit ("no master module name");

   my $master_module = $this->_get_master_module($master_desc);
   my $master = $master_module->get_object_by_name($master_name)
       or &ribbit ("no master could be found ($master_desc) ".
                   "known names include ",$master_module->get_object_names(),"\n");

   return ($master);
}

################################################################################

=item I<_get_slave()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_slave
{
   my $this = shift;
   return ($this->_get_master(@_));
}


################################################################################

=item I<_get_slave_id()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _get_slave_id
{
   my $this = shift;
   my $slave_name        = $this->_master_or_slave()->name();
   my $slave_module      = $this->_master_or_slave()->parent_module();
   my $slave_module_name = $slave_module->name();

   my $number_of_kids    = scalar (keys (%{$slave_module->{SLAVE}}) +
                                   keys (%{$slave_module->{MASTER}})
                                   );

   my $slave_id = "$slave_module_name";
   $slave_id .= "/$slave_name";
   #if ($number_of_kids > 1);

   return ($slave_id);

}

######################################################################
# make_signal_of_type
#
# given a textual "type", will create an e_signal of that type.
# uses the helper function get_signal_name_by_type to determine the name of
# this e_signal.  
#
# the rest of the values passed into make_signal_of_type are assumed 
# to be additional parameters for the creation of e_signal.  It is whatever
# the order of e_signal is EXCEPT name (which this function makes for you). 
#
######################################################################
################################################################################

=item I<make_signal_of_type()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub make_signal_of_type
{
  my $this = shift;
  my $type = shift  or &ribbit ("No type");

  my @other_signal_values;  # additional parameters to e_signal
  my $dummy_e_signal = e_signal->new (["dummy"]);
  my @signal_order = grep {$_ !~ /^name$/}  @{$dummy_e_signal->_order()};
  foreach my $signal_value (@_)  {
    push @other_signal_values, shift (@signal_order), $signal_value;
  }

  my $signal_name = $this->get_signal_name_by_type ($type);
  my $new_signal = e_signal->new ({
      name    => $signal_name, 
      type    => $type,
      @other_signal_values,
    }) ->within ($this);
  return $signal_name;
}

######################################################################
# get_signal_name_by_type
#
# given a textual "type", determines a unique name for a signal within a
# module.  Used mainly by make_signal_of_type.
#
######################################################################
################################################################################

=item I<get_signal_name_by_type()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub get_signal_name_by_type
{
  my $this = shift;
  my $type = shift  or &ribbit ("No type");

  my $module_desc = $this->_get_slave_id();
  my $signal_name = $this->_make_signal ($module_desc ."_". $type) ;
  return $signal_name;
}

# because I'm a dorkus, and I'm sick of getting errors:
################################################################################

=item I<get_signal_name_of_type()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub get_signal_name_of_type
{ my $this = shift; return $this->get_signal_name_by_type(@_); }

################################################################################

=item I<get_modelsim_list_info()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub get_modelsim_list_info
{
  my $this = shift;
  
  # I'll assume that any arbitrator sanity checker will want these
  # interesting signals.  Subclasses e_ptf_master, e_ptf_slave may
  # want to include their own signals beyond these, and so should call
  # SUPER, then do their thing.
  my @interesting_types = qw(
    address
    begintransfer
    byteenable
    chipselect
    clk
    dataavailable
    irq
    irqnumber
    outputenable
    read
    readdata
    readdatavalid
    readyfordata
    reset
    waitrequest
    write
    writedata
  );
  
  # 1) go through _master_or_slave() to get signals of interesting types
  my @sim_signals = map {
    $this->_master_or_slave()->_ports_by_type()->{$_} or ()
  } @interesting_types;
  
  print STDERR "ptf signals in e_ptf_arbitration_module @{[$this->name()]}:\n";
  print STDERR (map {"  @{[$_->_exclusive_name()]}\n"} @sim_signals), "\n";  
    
  # 2) return those types derived classes provide 
  # my @sim_signals = grep {my $sig = $_; $sig->isa('e_signal')} @{$this->_updated_contents()};
  # print STDERR "arb signals in e_ptf_arbitration_module @{[$this->name()]}:\n";
  # print STDERR (map {"  @{[$_->name()]}, @{[$_->type()]}, @{[ref $_]}\n"} @sim_signals), "\n";  

  # Strangely, these signals don't appear to have the types I'd expect.  Only a few lonely
  # signals like readdata show up.  Infer types from the signals' names, instead.
  # my @sim_signals = grep {my $sig = $_; $sig->isa('e_signal')} @{$this->_updated_contents()};
  
  # Next weirdness: many signals show up multiple times.  Make them unique.
  my %unique;
  map {$unique{$_->name()} = $_} @sim_signals;
  @sim_signals = values %unique;

  
  # @sim_signals = grep {my $sig = $_; grep {$sig->name() =~ /$_/} @interesting_types} @sim_signals;

  # _get_port_or_its_complement() returns a list of (e_port, $negated).
  # I don't really care about $negated, but I do care if the port turned
  # out to not exist. Drop any null signals.
  # @sim_signals = grep {$_->[0]} @sim_signals;
  
  # Trim the list down to just signals.
  # map {$_ = $_->[0]} @sim_signals;

  
  return {
    instance_name => $this->_instantiated_by()->[0]->name(),
    file_name => __FILE__, 
    package_name => 'e_ptf_arbitration_module_modelsim_assertions',
    test_function => 'do_timestep',
    signals => \@sim_signals,
  };
}


=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_module

=begin html

<A HREF="e_module.html">e_module</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
