
################################################################
# CLASS: e_lpm_equal
#
# Put together to take advantage of lpm_compare for wide compares in
# cache tag compare logic.  Only outputs a==b unsigned compare.
# Initial use: e_icache/e_dcache.  Leveraged from e_bdpram.
# Note that this is always asynchronous, never clocked, tho the
# lpm_compare has that functionality!
################################################################


=head1 NAME

e_lpm_equal - description of the module goes here ...

=head1 SYNOPSIS

The e_lpm_equal class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_lpm_equal;

use europa_utils;
use e_instance;
use e_blind_instance;

@ISA = qw (e_instance);

use strict;

my %fields =
(
  # Size parameters; must set width; chain_size is same as unset default
  data_width => 0,
  chain_size => 8,
);

my %pointers =
(
);

################################################################
# e_lpm_equal::new
################################################################

&package_setup_fields_and_pointers(__PACKAGE__,
                                   \%fields,
                                   \%pointers);

################################################################################

=item I<new()>

Object constructor

=cut

sub new 
{
  my $this = shift;
  my $self = $this->SUPER::new(@_);

  # Verify that required parameters have been set.
  ribbit("Data Port width not specified") if $self->data_width() == 0;
  
  $self->_create_module();

  return $self;
}

################################################################################

=item I<_create_module()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub _create_module
{
  my $this = shift;

  my $proto_name = $this->name() . "_module";
  my $module = e_module->new({name => $proto_name, });
#  $module->do_black_box(1);
  $module->do_black_box(0);

  # This module has the same ports as described in Quartus help!
  # lpm_compare 'clock' port is NOT USED

  my $data_width = $this->data_width();

  $module->add_contents(e_port->new(["dataa",$data_width]));
  $module->add_contents(e_port->new(["datab",$data_width]));
      
  $module->add_contents(e_port->new(["aeb",1,"out"]));
  
  $this->module($module);
}


#
# Why override update?  It seems that at 'new' time, certain properties
# of the object are not quite complete... e.g.
# $this->parent_module()->project()language() is not available.
#
################################################################################

=item I<update()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub update
{
  my $this = shift;  
  $this->parent(@_);

  # the simulation object for this is the altdpram model in file:
  # c:\quartus\eda\sim_lib\altera_mf.v(hd)
  # in e_dpram, this function built a simulation model:
  # $this->add_simulation_objects(); 
  # We might want to re-invoke that function with something that points
  # to the appropriate 'altera_mf' library file according to language.

  # This function builds a 'blind_instance' of altsyncram with correct
  # ports to be picked up by either quartus or modelsim...

  $this->add_objects();

  my $ret = $this->SUPER::update(@_);
  
  return $ret;
}

# Note that this adds lpm_comprae, and e_blind_instance requires
# 'use_sim_models' to force inclusion of the necessary sim model files!
################################################################################

=item I<add_objects()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub add_objects
{
  my $this = shift;
  my $module = $this->module();

  ribbit("bad usage") if (!$module or !$this or @_);

  my @things;
  
  # Per Aaron: "e_blind_instance has a behavior which stymies me, though: it
  # seems that you must pass in_port_map a bona-fide anonymous hash reference,
  # and not a reference to a hash variable, or it completely ignores you."
  my $chain_size = $this->chain_size();
  push @things,
  e_blind_instance->new({
      name => 'the_lpm_equality_compare',
      module => 'lpm_compare',
      use_sim_models => 1,
      in_port_map => {
          dataa  => 'dataa',
          datab  => 'datab',
      },
      out_port_map => {
          aeb    => 'aeb',
      },
      parameter_map => {
          lpm_width          => $this->data_width(),
          lpm_type           => qq("LPM_COMPARE"),
          lpm_representation => qq("UNSIGNED"),
	  lpm_hint           => qq("CHAIN_SIZE=$chain_size"),
      },
  });
  
  # Every thing is a compilation thing.
  # map {$_->tag("compilation")} @things;
  
  $module->add_contents(@things);
}

# end our perl module with style ;-)
qq{
Let the wise one watch over the mind,
So hard to perceive, so artful,
Alighting where it wishes;
A watchfully protected mind
Will bring happiness.

 - Dhammapada
};

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_instance

=begin html

<A HREF="e_instance.html">e_instance</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
