
# This package is intended to be a way to drive UART characters to an external
# file, one character at a time, so that it may be viewed via 'tail -f' or
# some other bash command (more, less, etc...)

# Further documentation can be found in .../documets/Interactive_sim/*


=head1 NAME

e_log - description of the module goes here ...

=head1 SYNOPSIS

The e_log class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_log;
use _e_auto_file_write;
use e_expression;
use e_thing_that_can_go_in_a_module;
@ISA = ("e_instance");

use strict;
use europa_utils;

################################################################
# e_instance::new
#
################################################################
my %fields = (
	      tag => "simulation",
	      log_file => undef,
              writememb => 0,
              showascii => 0,
              );

my %pointers = (
                _module_ref => e_module->dummy(),
                );

&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

################################################################################

=item I<new()>

Object constructor

=cut

sub new 
{
   my $this  = shift;
   my $self = $this->SUPER::new(@_);
   $self->set_up_module;
   return $self;
}

################################################################################

=item I<set_up_module()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub set_up_module
{
    my $this = shift;
    my $name = $this->name or &ribbit ("No name");
    # print "e_log: set_up_module: \$this->log_file = $this->log_file\n";
    my $module = e_module->new
	({ name  => "${name}_module",
	   # do_black_box => 1,
	   contents => [ 
			 e_port->news( 
				       [ "clk" ], # defaults to width 1 input
				       [ "valid" ],
				       [ "strobe" ],
				       [ "data", 8 ],
				       ),
			 # would-be integers for file handle && clk counter
			 # text_handle moved into _e_auto_file_write for
			 # vhdl compatibility

			 # e_signal->new ({name => "text_handle",width=> 32,}),
			 # Here's the low level icky file i/o stuff:
			 _e_auto_file_write->new
                         (
                          {
                              log_file => $this->log_file,
                              writememb=> $this->writememb,
                              showascii=> $this->showascii,
                          }
                          ),
			 ]
			 });

    $this->module($module);
    
} # set_up_module

# perl modules return 1
1;

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_instance

=begin html

<A HREF="e_instance.html">e_instance</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
