




################################################################
# CLASS: e_register
#
################################################################


=head1 NAME

e_lcell - description of the module goes here ...

=head1 SYNOPSIS

The e_lcell class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_lcell;
use europa_utils;

use e_instance;
use e_module;
@ISA = qw (e_instance);

use strict;

################################################################
# e_register::new
#
# Constructor copied straight out of the tutorial.
#
################################################################
my $unused_port_tag = 'open';

my %fields = (
              );


my $id_counter = 1;
my %pointers = ();
&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

################################################################################

=item I<new()>

Object constructor

=cut

sub new
{
   my $this = shift;
   $this = $this->SUPER::new();
   $this->set({
              port_map          => 
              {
                 clk     => $unused_port_tag,
                 dataa   => $unused_port_tag,
                 datab   => $unused_port_tag,
                 datac   => $unused_port_tag,
                 datad   => $unused_port_tag,
                 aclr    => $unused_port_tag,
                 sclr    => $unused_port_tag,
                 sload   => $unused_port_tag,
                 ena     => $unused_port_tag,
                 cin     => $unused_port_tag,
                 cascin  => $unused_port_tag,
                 combout => $unused_port_tag,
                 regout  => $unused_port_tag,
                 cout    => $unused_port_tag,
                 cascout => $unused_port_tag,
              }, 
              parameter_map => 
              {
                 operation_mode => "counter",
                 output_mode    => "comb_and_reg",
                 packed_mode    => "false",
                 lut_mask       => "ffff",
                 power_up       => "low",
                 cin_used       => "false",
              },
              module => 'apex20k_lcell',
           });

   $this->set(@_);
   return $this;
}

################################################################################

=item I<parameter_map()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub parameter_map
{
   my $this = shift;
   
   if (@_)
   {
     my $h = shift;
     
     # Parameters need to be surrounded by double quotes.  If anyone
     # tries to create a parameter with no surrounding double quotes,
     # fix it here.
     my $hash;
     for my $key (keys %$h)
     {
       # lpm_type and id used to be used; to support pre-existing
       # e_lcell code, just ignore these parameters.  In fact, there's
       # no need to ignore them - they just cause parameters to be emitted
       # in the HDL.  Delete them for tidiness.
       my $val = $h->{$key};

       if ($key eq 'lpm_type' and $val =~ /yeager/i)
       {
         # Old-fashioned way of specifying "use stratix lcells".
         $this->module('yeager_lcell');

         # We've noted that someone tried to set 'lpm_type', and
         # acted upon it, but we won't actually save it.
         next;
       }
       
       # Just ignore 'lpm_type'.
       next if $key eq 'lpm_type';
       
       # Just ignore 'id'.
       next if $key eq 'id';
       
       # Double quotes around parameters are important.  Why do I have to do
       # it?  Does this normally happen in SUPER?
       if ($val !~ /^".*"$/)
       {
         $val = qq("$val");
       }
       
       $hash->{$key} = $val;
     }
     return $this->SUPER::parameter_map($hash);
   }
   
   return $this->SUPER::parameter_map();
}

################################################################################

=item I<update()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub update
{
  my $this = shift;
  my $parent = $this->parent(@_);

  my $project = $this->parent_module()->project();

  # Add an instantiation of this lcell, with its particular wrapper.
  my $module_name =
    $project->add_signatured_apex20k_blind_instance(
      $this->port_map(),
      $unused_port_tag
    );

  # print STDERR "e_lcell::update(): asking for a '$module_name'\n";
  $this->module($module_name);
  $this->SUPER::update(@_);
}

1;



=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_instance

=begin html

<A HREF="e_instance.html">e_instance</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
