



################################################################
# CLASS: e_edge_detector
#
################################################################


=head1 NAME

e_edge_detector - description of the module goes here ...

=head1 SYNOPSIS

The e_edge_detector class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_edge_detector;

use europa_utils;
use e_expression;
use e_assign;
use e_register;
use e_thing_that_can_go_in_a_module;

@ISA = qw (e_thing_that_can_go_in_a_module);

use strict;

################################################################
# e_edge_detector::new
#
#  an e_edge_detector can be constructed from at least 2 (and
#  as many as 5) e_expressions.
#
#         and it would first do e_edge_detector->new() and then call
#         $self->edge_signal($my_edge_signal);
#
################################################################
my %fields = (
              _out         => e_expression->new(),
              _built       => 0,
              _edge_type   => "rising",
              _register    => e_register->new(),
              _edge_detect => e_assign->new(),
              );

my %pointers = ();

&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

################################################################################

=item I<new()>

Object constructor

=cut

sub new
{
   my $this = shift;
   $this = $this->SUPER::new(@_);
   $this->_register()->parent($this);
   $this->_edge_detect()->parent($this);
   return $this;
}

################################################################################

=item I<out()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub out
{
   my $this = shift;
   my $out = $this->_out(@_);
   if (@_)
   {
      $out->parent($this);
   }
   return $out;
}

################################################################################

=item I<edge()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub edge
{
  my $this = shift;

  # Can be used as access function (if called with no args).
  if (!(@_)) { return $this->_edge_type()};

  my $etype = shift or &ribbit("no edge-type specified");

  &ribbit ("unknown edge type: $etype")
    unless $etype =~ /(rising)|(falling)|(any)/smig;

  return ($this->_edge_type($etype));
}


################################################################################

=item I<clock()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub clock
{
  my $this = shift;
  return $this->_register()->clock(@_);
}

################################################################################

=item I<enable()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub enable
{
  my $this = shift;
  return $this->_register()->enable(@_);
}

################################################################################

=item I<async_set()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub async_set
{
  my $this = shift;
  return $this->_register()->async_set(@_);
}

################################################################################

=item I<in()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub in 
{
  # Update my unique name when my in-expression is known/changed:
  my $this = shift;
  if (!defined ($this->{in}))
  {
     $this->{in} = e_expression->new();
  }

  my $in_expr = $this->{in};

  if (@_)
  {
     $in_expr->set(@_);
     $this->_unique_name($in_expr->expression());
  }

  return $in_expr;
}

################################################################################

=item I<build()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub build
{
  my $this = shift;

  return if $this->_built();

  # Update all my input/output expressions:
  # I'm hoping this will let me determine my width from,
  # say, my parallel input/output signals.
  foreach my $member ($this->get_fields()) {
    next unless &is_blessed ($member) && $member->isa("e_expression");
    $member->update($this);
  }

  # We have to build an internal signal (the delayed version of the 
  # input).   Derive its name from our unique name.
  # 
  my $d_sig_name = "delayed_" . $this->_unique_name();

  $this->_register()->in ($this->in());
  $this->_register()->out($d_sig_name);
  $this->_register()->name($d_sig_name);

  # Make a signal which accounts for the possibility that
  # the incoming signal (that we're edge-detecting) is an expression
  # and not a signal.
  my $in_expr_text = $this->in()->expression();

  $this->_edge_detect()->lhs ($this->out());
  my $rhs_expr;
  if       ($this->edge() =~ /rising/i)  {
    $rhs_expr = " ($in_expr_text) & ~($d_sig_name)";
  } elsif  ($this->edge() =~ /falling/i) {
    $rhs_expr = "~($in_expr_text) &  ($d_sig_name)";
  } elsif  ($this->edge() =~ /any/i)     {
    $rhs_expr = " ($in_expr_text) ^  ($d_sig_name)";
  }
  $this->_edge_detect()->rhs ($rhs_expr);

  #my $daddy = $this->_register()->parent();
  #my $parent_name = "";
  #$parent_name = $daddy->name() unless $daddy->isa_dummy();

  $this->_built(1);
}


#TIM  the generic update will work, but it gets a little confusing and
#it's slow.
################################################################################

=item I<update()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub update
{
   my $this = shift;
   my $parent = $this->parent(@_);

   $this->build();

#   $this->_register()->update($this);
#   $this->_edge_detect()->update($this);
#     warn "parent is $parent\n";
#     $parent->add_contents($this->_register(),
#                           $this->_edge_detect(),
#                          );

#     warn "parent now should have reg and edge detct in them\n";
#     warn map 
#     {(($_ eq $this->_register()) ||
#       ($_ eq $this->_edge_detect()))? "$_\n":""} @{$parent->contents()};
}

################################################################################

=item I<to_verilog()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub to_verilog
{
   my $this = shift;
   my $indent = shift;

   return (
           $this->string_to_verilog_comment($indent, $this->comment()).
           $this->_register()->to_verilog($indent).
           $this->_edge_detect()->to_verilog($indent)
           );

}

################################################################################

=item I<to_vhdl()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub to_vhdl
{
   my $this = shift;
   my $indent = shift;

   return (
           $this->string_to_vhdl_comment($indent, $this->comment()).
           $this->_register()->to_vhdl($indent).
           $this->_edge_detect()->to_vhdl($indent)
           );

}

1;   # Must say 1

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_thing_that_can_go_in_a_module

=begin html

<A HREF="e_thing_that_can_go_in_a_module.html">e_thing_that_can_go_in_a_module</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
