
# This package is intended to be a DynamicROM replacement for the old e_rom
# simulation only package.  It has a few more wires than the old e_rom, as it
# takes care of it's own address management (resets to 0 when a new external
# file is present) and protects itself from reading beyond the last valid
# (programmed) rom entry.  Max rom length is (1024 - 1), because a terminating
# null character is auto-appended to the output _stream.dat file.

# Further documentation can be found in .../documents/Interactive_sim/*


=head1 NAME

e_drom - description of the module goes here ...

=head1 SYNOPSIS

The e_drom class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_drom;
use _e_auto_file_read;
use e_expression;
use e_thing_that_can_go_in_a_module;
@ISA = ("e_instance");

use strict;
use europa_utils;

################################################################
# e_instance::new
#
################################################################
my %fields = (
              tag => "simulation",
              dat_name => undef,
              mutex_name => undef,
	      interactive=> 0,
              rom_size   => 1024,
              poll_rate => 100,
              readmemb => 0,
              );

my %pointers = (
                _module_ref => e_module->dummy(),
                );

# constructor
&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

################################################################################

=item I<new()>

Object constructor

=cut

sub new 
{
   my $this  = shift;
   my $self = $this->SUPER::new(@_);
   $self->set_up_module();
   return $self;
}

################################################################################

=item I<set_up_module()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub set_up_module
{
    my $this = shift;
    my $name = $this->name or &ribbit ("No name");
    # print "e_drom: set_up_module: \$this->dat_name = $this->dat_name \n";

    my $module = e_module->new
        ({ name  => "${name}_module",
           # do_black_box => 1,
           contents => [ 
                         e_port->news
                         ( 
                           [ "clk" ], # defaults to width 1 input
                           [ "reset_n" ],
                           [ "incr_addr" ],
                           [ "new_rom", 1, "output" ],
                           [ "safe", 1, "output" ],
                           ),
                         e_port->new
                         (
                          { 
                              name => "q",
                              width => 8,
                              copied => 1,
                              direction => "output",
                          },
                          ),
                         # this parameter is used/needed by _e_auto_file_read:
                         e_parameter->new
                         (
                          {
                              name => "POLL_RATE",
                              default => $this->poll_rate(),
                              vhdl_type => "integer",
                          },
                          ),
                         e_assign->new
                         (
                          {
                              lhs => "q",
                              rhs => "mem_array\[address\]",
                              tag => "simulation",
                          },
                          ),
                         # array for rom data && array for mutex data
                         e_signal->news
                         (
                          {
                              name => "mem_array",
                              depth => $this->rom_size(),
                              width => 8,
                              copied => 1,
                          },
                          { 
                              name => "mutex",
                              depth=> 2,
                              width=> 32,
                          },
                          ),
                         # sprout port containing num_bytes in stream
                         # file iff we're in readmemb mode:
                         e_signal->new
                         ({
                             name => "num_bytes",
                             width => 32,
                             export => $this->readmemb,
                             never_export => ($this->readmemb ? 0 : 1),
                         }),
                         # would-be integers for file handle && clk counter
                         e_signal->news
                         (
                          {
                              name => "mutex_handle",
                              width=> 32,
                          },
                          {
                              name => "poll_count",
                              width=> 32,
                          },
                          {
                              name => "address",
                              width=> &Bits_To_Encode($this->rom_size()),
                          },
                          ),
                         e_register->new
                         (
                          {
                              out => "new_rom",
                              in  => "pre",
                              enable=> 1,
                              delay=> 10,
                              tag => "simulation",
                          }
                          ),
                         # Here's the low level icky file i/o stuff:
                         
                         _e_auto_file_read->new
                         (
                          {
                              dat_name => $this->dat_name,
                              mutex_name=>$this->mutex_name,
			      interactive=>$this->interactive,
                              readmemb => $this->readmemb,
                              addrbits => &Bits_To_Encode($this->rom_size()),
                          }
                          ),
                         ]
                         });
    
    $this->module($module);
    
} # set_up_module

# perl modules return 1
1;

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_instance

=begin html

<A HREF="e_instance.html">e_instance</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
