



################################################################
# CLASS: e_custom_instruction_master
#
# Very much like e_custom_instruction_slave.  One difference: its ptf
# section is MASTER, not SLAVE.
#
################################################################

=head1 NAME

e_custom_instruction_master - description of the module goes here ...

=head1 SYNOPSIS

The e_custom_instruction_master class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_custom_instruction_master;

use e_custom_instruction_slave;
@ISA = ("e_custom_instruction_slave");
use strict;

################################################################################

=item I<new()>

Object constructor

=cut

sub new 
{
  my $this  = shift;

  my $self = $this->SUPER::new(@_);

  $self->{section_name} = "MASTER";

  return $self;
}

################################################################################

=item I<recognized_types()>

method description goes here...
...remember: there must be a newline around each POD tag (e.g. =item, =cut etc)!

=cut

sub recognized_types
{
  my $this = shift;
  # Masters know about all the slave signals
  #
  my @known_sigs = $this->SUPER::recognized_types();

  # Masters also know about these other signals.
  push (@known_sigs, 
          "combo_dataa",
          "combo_datab",
          "combo_result",
          "combo_n",
          "combo_a",
          "combo_b",
          "combo_c",
          "combo_readra",
          "combo_readrb",
          "combo_writerc",
          "combo_ipending",
          "combo_status",
          "combo_estatus",
          "multi_dataa",
          "multi_datab",
          "multi_result",
          "multi_n",
          "multi_a",
          "multi_b",
          "multi_c",
          "multi_readra",
          "multi_readrb",
          "multi_writerc",
          "multi_start",
          "multi_done",
          "multi_fixed_done",
          "multi_ipending",
          "multi_status",
          "multi_estatus",
       );

  return @known_sigs;
}


1;





=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_custom_instruction_slave

=begin html

<A HREF="e_custom_instruction_slave.html">e_custom_instruction_slave</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
