


################################################################
# CLASS: e_avalon_master
#
# Very much like e_avalon_slave.  One difference: its ptf
# section is MASTER, not SLAVE.
#
################################################################

=head1 NAME

e_avalon_master - description of the module goes here ...

=head1 SYNOPSIS

The e_avalon_master class implements ... detailed description of functionality

=head1 METHODS

=over 4

=cut

package e_avalon_master;

use europa_utils;
use e_avalon_slave;
@ISA = ("e_avalon_slave");
use strict;

my %fields = (
              section_name     => "MASTER"
              );

my %pointers = ();

&package_setup_fields_and_pointers
    (__PACKAGE__,
     \%fields, 
     \%pointers,
     );

################################################################################

sub input_types($)
{
  my $this = shift;
  my @types = (
    # Nb don't put globals in with inputs.  Handle separately, above.
    # $this->SUPER::global_input_types(),
    # The base class (slave) has a complementary notion of direction.
    $this->SUPER::output_types(),
    qw(
      irqnumber
    )
  );
  
  return @types;
}

sub output_types($)
{
  my $this = shift;
  return (
    # The base class (slave) has a complementary notion of direction.
    $this->SUPER::input_types(),
    qw(
      arbiterlock
      arbiterlock2
      bursthint
      flush
      outputenable
    )
  );
}

sub inout_types($)
{
  my $this = shift;
  return (
    $this->SUPER::inout_types(),
  );
}  

=back

=cut

=head1 EXAMPLE

Here is a usage example ...

=head1 AUTHOR

Santa Cruz Technology Center

=head1 BUGS AND LIMITATIONS

list them here ...

=head1 SEE ALSO

The inherited class e_avalon_slave

=begin html

<A HREF="e_avalon_master.html">e_avalon_slave</A> webpage

=end html

=head1 COPYRIGHT

Copyright (C)2001-2005 Altera Corporation, All rights reserved.

=cut

1;
