library IEEE, maxii;
use IEEE.STD_LOGIC_1164.all;
package maxii_components is
------------------------------------------------------------------
-- maxii_io parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component maxii_io
	generic (
		bus_hold	:	string := "false";
		open_drain_output	:	string := "false";
		operation_mode	:	string;
		lpm_type	:	string := "maxii_io"
	);
	port(
		combout	:	out std_logic;
		datain	:	in std_logic := '0';
		oe	:	in std_logic := '1';
		padio	:	inout std_logic
	);
end component;

------------------------------------------------------------------
-- maxii_lcell parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component maxii_lcell
	generic (
		cin_used	:	string := "false";
		lut_mask	:	string;
		operation_mode	:	string := "normal";
		output_mode	:	string := "reg_and_comb";
		register_cascade_mode	:	string := "off";
		sum_lutc_input	:	string := "datac";
		synch_mode	:	string := "off";
		lpm_type	:	string := "maxii_lcell"
	);
	port(
		aclr	:	in std_logic := '0';
		aload	:	in std_logic := '0';
		cin	:	in std_logic := '0';
		clk	:	in std_logic := '0';
		combout	:	out std_logic;
		cout	:	out std_logic;
		dataa	:	in std_logic := '1';
		datab	:	in std_logic := '1';
		datac	:	in std_logic := '1';
		datad	:	in std_logic := '1';
		ena	:	in std_logic := '1';
		inverta	:	in std_logic := '0';
		regcascin	:	in std_logic := '0';
		regout	:	out std_logic;
		sclr	:	in std_logic := '0';
		sload	:	in std_logic := '0'
	);
end component;

------------------------------------------------------------------
-- maxii_ufm parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component maxii_ufm
	generic (
		address_width	:	natural := 9;
		erase_time	:	natural := 500000000;
		init_file	:	string := "UNUSED";
		osc_sim_setting	:	natural := 180000;
		program_time	:	natural := 1600000;
		lpm_type	:	string := "maxii_ufm"
	);
	port(
		arclk	:	in std_logic := '0';
		ardin	:	in std_logic := '0';
		arshft	:	in std_logic := '1';
		bgpbusy	:	out std_logic;
		busy	:	out std_logic;
		drclk	:	in std_logic := '0';
		drdin	:	in std_logic := '0';
		drdout	:	out std_logic;
		drshft	:	in std_logic := '1';
		erase	:	in std_logic := '0';
		osc	:	out std_logic;
		oscena	:	in std_logic := '0';
		program	:	in std_logic := '0'
	);
end component;

end maxii_components;
