
library ieee;
use ieee.std_logic_1164.all;
library synplify;
use synplify.attributes.all;

package altera_mf_components is

attribute syn_black_box of altera_mf_components : package is true;

type altera_mf_logic_2D is array (NATURAL RANGE <>, NATURAL RANGE <>) of STD_LOGIC;

component parallel_add 

   generic (
      width                   :  integer := 4;    
      size                    :  integer := 2;    
      widthr                  :  integer := 4;    
      shift                   :  integer := 0;    
      msw_subtract            :  string  := "NO";    
      representation          :  string  := "UNSIGNED";    
      pipeline                :  integer := 0;    
      result_alignment        :  string  := "LSB";
      lpm_hint		      :  string  := "UNUSED";    
      lpm_type                :  string  := "parallel_add"
      );

   port (
      data                    : in altera_mf_logic_2D(size - 1 downto 0, width- 1 downto 0);   
      clock                   : in std_logic := '1';
      aclr                    : in std_logic := '0';
      clken                   : in std_logic := '1';
      result                  : out std_logic_vector(widthr - 1 downto 0));   
end component;

attribute syn_black_box of parallel_add : component is true;

--clearbox auto-generated components begin
--Dont add any component declarations after this section
------------------------------------------------------------------
-- altsyncram parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altsyncram
	generic (
		address_aclr_a	:	string := "UNUSED";
		address_aclr_b	:	string := "NONE";
		address_reg_b	:	string := "CLOCK1";
		byte_size	:	natural := 8;
		byteena_aclr_a	:	string := "UNUSED";
		byteena_aclr_b	:	string := "NONE";
		byteena_reg_b	:	string := "CLOCK1";
		clock_enable_input_a	:	string := "NORMAL";
		clock_enable_input_b	:	string := "NORMAL";
		clock_enable_output_a	:	string := "NORMAL";
		clock_enable_output_b	:	string := "NORMAL";
		intended_device_family	:	string := "unused";
		implement_in_les	:	string := "OFF";
		indata_aclr_a	:	string := "UNUSED";
		indata_aclr_b	:	string := "NONE";
		indata_reg_b	:	string := "CLOCK1";
		init_file	:	string := "UNUSED";
		init_file_layout	:	string := "PORT_A";
		maximum_depth	:	natural := 0;
		numwords_a	:	natural := 0;
		numwords_b	:	natural := 0;
		operation_mode	:	string := "BIDIR_DUAL_PORT";
		outdata_aclr_a	:	string := "NONE";
		outdata_aclr_b	:	string := "NONE";
		outdata_reg_a	:	string := "UNREGISTERED";
		outdata_reg_b	:	string := "UNREGISTERED";
		power_up_uninitialized	:	string := "FALSE";
		ram_block_type	:	string := "AUTO";
		rdcontrol_aclr_b	:	string := "NONE";
		rdcontrol_reg_b	:	string := "CLOCK1";
		read_during_write_mode_mixed_ports	:	string := "DONT_CARE";
		width_a	:	natural;
		width_b	:	natural := 1;
		width_byteena_a	:	natural := 1;
		width_byteena_b	:	natural := 1;
		widthad_a	:	natural;
		widthad_b	:	natural := 1;
		wrcontrol_aclr_a	:	string := "UNUSED";
		wrcontrol_aclr_b	:	string := "NONE";
		wrcontrol_wraddress_reg_b	:	string := "CLOCK1";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altsyncram"
	);
	port(
		aclr0	:	in std_logic := '0';
		aclr1	:	in std_logic := '0';
		address_a	:	in std_logic_vector(widthad_a-1 downto 0);
		address_b	:	in std_logic_vector(widthad_b-1 downto 0) := (others => '1');
		addressstall_a	:	in std_logic := '0';
		addressstall_b	:	in std_logic := '0';
		byteena_a	:	in std_logic_vector(width_byteena_a-1 downto 0) := (others => '1');
		byteena_b	:	in std_logic_vector(width_byteena_b-1 downto 0) := (others => '1');
		clock0	:	in std_logic := '1';
		clock1	:	in std_logic := '1';
		clocken0	:	in std_logic := '1';
		clocken1	:	in std_logic := '1';
		data_a	:	in std_logic_vector(width_a-1 downto 0) := (others => '1');
		data_b	:	in std_logic_vector(width_b-1 downto 0) := (others => '1');
		q_a	:	out std_logic_vector(width_a-1 downto 0);
		q_b	:	out std_logic_vector(width_b-1 downto 0);
		rden_b	:	in std_logic := '1';
		wren_a	:	in std_logic := '0';
		wren_b	:	in std_logic := '0'
	);
end component;

attribute syn_black_box of altsyncram : component is true;
------------------------------------------------------------------
-- altshift_taps parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altshift_taps
	generic (
		intended_device_family	:	string := "unused";
		number_of_taps	:	natural;
		power_up_state	:	string := "CLEARED";
		tap_distance	:	natural;
		width	:	natural;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altshift_taps"
	);
	port(
		clken	:	in std_logic := '1';
		clock	:	in std_logic;
		shiftin	:	in std_logic_vector(width-1 downto 0);
		shiftout	:	out std_logic_vector(width-1 downto 0);
		taps	:	out std_logic_vector(width*number_of_taps-1 downto 0)
	);
end component;

attribute syn_black_box of altshift_taps : component is true;
------------------------------------------------------------------
-- altmult_add parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altmult_add
	generic (
		adder1_rounding	:	string := "NO";
		adder3_rounding	:	string := "NO";
		addnsub1_round_aclr	:	string := "ACLR3";
		addnsub1_round_pipeline_aclr	:	string := "ACLR3";
		addnsub1_round_pipeline_register	:	string := "CLOCK0";
		addnsub1_round_register	:	string := "CLOCK0";
		addnsub3_round_aclr	:	string := "ACLR3";
		addnsub3_round_pipeline_aclr	:	string := "ACLR3";
		addnsub3_round_pipeline_register	:	string := "CLOCK0";
		addnsub3_round_register	:	string := "CLOCK0";
		addnsub_multiplier_aclr1	:	string := "ACLR3";
		addnsub_multiplier_aclr3	:	string := "ACLR3";
		addnsub_multiplier_pipeline_aclr1	:	string := "ACLR3";
		addnsub_multiplier_pipeline_aclr3	:	string := "ACLR3";
		addnsub_multiplier_pipeline_register1	:	string := "CLOCK0";
		addnsub_multiplier_pipeline_register3	:	string := "CLOCK0";
		addnsub_multiplier_register1	:	string := "CLOCK0";
		addnsub_multiplier_register3	:	string := "CLOCK0";
		dedicated_multiplier_circuitry	:	string := "AUTO";
		intended_device_family	:	string := "unused";
		dsp_block_balancing	:	string := "Auto";
		extra_latency	:	natural := 0;
		input_aclr_a0	:	string := "ACLR3";
		input_aclr_a1	:	string := "ACLR3";
		input_aclr_a2	:	string := "ACLR3";
		input_aclr_a3	:	string := "ACLR3";
		input_aclr_b0	:	string := "ACLR3";
		input_aclr_b1	:	string := "ACLR3";
		input_aclr_b2	:	string := "ACLR3";
		input_aclr_b3	:	string := "ACLR3";
		input_register_a0	:	string := "CLOCK0";
		input_register_a1	:	string := "CLOCK0";
		input_register_a2	:	string := "CLOCK0";
		input_register_a3	:	string := "CLOCK0";
		input_register_b0	:	string := "CLOCK0";
		input_register_b1	:	string := "CLOCK0";
		input_register_b2	:	string := "CLOCK0";
		input_register_b3	:	string := "CLOCK0";
		input_source_a0	:	string := "DATAA";
		input_source_a1	:	string := "DATAA";
		input_source_a2	:	string := "DATAA";
		input_source_a3	:	string := "DATAA";
		input_source_b0	:	string := "DATAB";
		input_source_b1	:	string := "DATAB";
		input_source_b2	:	string := "DATAB";
		input_source_b3	:	string := "DATAB";
		mult01_round_aclr	:	string := "ACLR3";
		mult01_round_register	:	string := "CLOCK0";
		mult01_saturation_aclr	:	string := "ACLR2";
		mult01_saturation_register	:	string := "CLOCK0";
		mult23_round_aclr	:	string := "ACLR3";
		mult23_round_register	:	string := "CLOCK0";
		mult23_saturation_aclr	:	string := "ACLR3";
		mult23_saturation_register	:	string := "CLOCK0";
		multiplier01_rounding	:	string := "NO";
		multiplier01_saturation	:	string := "NO";
		multiplier1_direction	:	string := "ADD";
		multiplier23_rounding	:	string := "NO";
		multiplier23_saturation	:	string := "NO";
		multiplier3_direction	:	string := "ADD";
		multiplier_aclr0	:	string := "ACLR3";
		multiplier_aclr1	:	string := "ACLR3";
		multiplier_aclr2	:	string := "ACLR3";
		multiplier_aclr3	:	string := "ACLR3";
		multiplier_register0	:	string := "CLOCK0";
		multiplier_register1	:	string := "CLOCK0";
		multiplier_register2	:	string := "CLOCK0";
		multiplier_register3	:	string := "CLOCK0";
		number_of_multipliers	:	natural;
		output_aclr	:	string := "ACLR3";
		output_register	:	string := "CLOCK0";
		port_addnsub1	:	string := "PORT_CONNECTIVITY";
		port_addnsub3	:	string := "PORT_CONNECTIVITY";
		port_mult0_is_saturated	:	string := "UNUSED";
		port_mult1_is_saturated	:	string := "UNUSED";
		port_mult2_is_saturated	:	string := "UNUSED";
		port_mult3_is_saturated	:	string := "UNUSED";
		port_signa	:	string := "PORT_CONNECTIVITY";
		port_signb	:	string := "PORT_CONNECTIVITY";
		representation_a	:	string := "UNSIGNED";
		representation_b	:	string := "UNSIGNED";
		signed_aclr_a	:	string := "ACLR3";
		signed_aclr_b	:	string := "ACLR3";
		signed_pipeline_aclr_a	:	string := "ACLR3";
		signed_pipeline_aclr_b	:	string := "ACLR3";
		signed_pipeline_register_a	:	string := "CLOCK0";
		signed_pipeline_register_b	:	string := "CLOCK0";
		signed_register_a	:	string := "CLOCK0";
		signed_register_b	:	string := "CLOCK0";
		width_a	:	natural;
		width_b	:	natural;
		width_result	:	natural;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altmult_add"
	);
	port(
		aclr0	:	in std_logic := '0';
		aclr1	:	in std_logic := '0';
		aclr2	:	in std_logic := '0';
		aclr3	:	in std_logic := '0';
		addnsub1	:	in std_logic := '1';
		addnsub1_round	:	in std_logic := '0';
		addnsub3	:	in std_logic := '1';
		addnsub3_round	:	in std_logic := '0';
		clock0	:	in std_logic := '1';
		clock1	:	in std_logic := '1';
		clock2	:	in std_logic := '1';
		clock3	:	in std_logic := '1';
		dataa	:	in std_logic_vector(width_a*number_of_multipliers-1 downto 0) := (others => '0');
		datab	:	in std_logic_vector(width_b*number_of_multipliers-1 downto 0) := (others => '0');
		ena0	:	in std_logic := '1';
		ena1	:	in std_logic := '1';
		ena2	:	in std_logic := '1';
		ena3	:	in std_logic := '1';
		mult01_round	:	in std_logic := '0';
		mult01_saturation	:	in std_logic := '0';
		mult0_is_saturated	:	out std_logic;
		mult1_is_saturated	:	out std_logic;
		mult23_round	:	in std_logic := '0';
		mult23_saturation	:	in std_logic := '0';
		mult2_is_saturated	:	out std_logic;
		mult3_is_saturated	:	out std_logic;
		result	:	out std_logic_vector(width_result-1 downto 0);
		scanina	:	in std_logic_vector(width_a-1 downto 0) := (others => '0');
		scaninb	:	in std_logic_vector(width_b-1 downto 0) := (others => '0');
		scanouta	:	out std_logic_vector(width_a-1 downto 0);
		scanoutb	:	out std_logic_vector(width_b-1 downto 0);
		signa	:	in std_logic := '0';
		signb	:	in std_logic := '0';
		sourcea	:	in std_logic_vector(number_of_multipliers-1 downto 0) := (others => '0');
		sourceb	:	in std_logic_vector(number_of_multipliers-1 downto 0) := (others => '0')
	);
end component;

attribute syn_black_box of altmult_add : component is true;
------------------------------------------------------------------
-- altmult_accum parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altmult_accum
	generic (
		accum_direction	:	string := "ADD";
		accum_round_aclr	:	string := "ACLR3";
		accum_round_pipeline_aclr	:	string := "ACLR3";
		accum_round_pipeline_reg	:	string := "CLOCK0";
		accum_round_reg	:	string := "CLOCK0";
		accum_saturation_aclr	:	string := "ACLR3";
		accum_saturation_pipeline_aclr	:	string := "ACLR3";
		accum_saturation_pipeline_reg	:	string := "CLOCK0";
		accum_saturation_reg	:	string := "CLOCK0";
		accum_sload_aclr	:	string := "ACLR3";
		accum_sload_pipeline_aclr	:	string := "ACLR3";
		accum_sload_pipeline_reg	:	string := "CLOCK0";
		accum_sload_reg	:	string := "CLOCK0";
		accum_sload_upper_data_aclr	:	string := "ACLR3";
		accum_sload_upper_data_pipeline_aclr	:	string := "ACLR3";
		accum_sload_upper_data_pipeline_reg	:	string := "CLOCK0";
		accum_sload_upper_data_reg	:	string := "CLOCK0";
		accumulator_rounding	:	string := "NO";
		accumulator_saturation	:	string := "NO";
		addnsub_aclr	:	string := "ACLR3";
		addnsub_pipeline_aclr	:	string := "ACLR3";
		addnsub_pipeline_reg	:	string := "CLOCK0";
		addnsub_reg	:	string := "CLOCK0";
		dedicated_multiplier_circuitry	:	string := "AUTO";
		intended_device_family	:	string := "unused";
		dsp_block_balancing	:	string := "Auto";
		extra_accumulator_latency	:	natural := 0;
		extra_multiplier_latency	:	natural := 0;
		input_aclr_a	:	string := "ACLR3";
		input_aclr_b	:	string := "ACLR3";
		input_reg_a	:	string := "CLOCK0";
		input_reg_b	:	string := "CLOCK0";
		input_source_a	:	string := "DATAA";
		input_source_b	:	string := "DATAB";
		mult_round_aclr	:	string := "ACLR3";
		mult_round_reg	:	string := "CLOCK0";
		mult_saturation_aclr	:	string := "ACLR3";
		mult_saturation_reg	:	string := "CLOCK0";
		multiplier_aclr	:	string := "ACLR3";
		multiplier_reg	:	string := "CLOCK0";
		multiplier_rounding	:	string := "NO";
		multiplier_saturation	:	string := "NO";
		output_aclr	:	string := "ACLR3";
		output_reg	:	string := "CLOCK0";
		port_accum_is_saturated	:	string := "UNUSED";
		port_addnsub	:	string := "PORT_CONNECTIVITY";
		port_mult_is_saturated	:	string := "UNUSED";
		port_signa	:	string := "PORT_CONNECTIVITY";
		port_signb	:	string := "PORT_CONNECTIVITY";
		representation_a	:	string := "UNSIGNED";
		representation_b	:	string := "UNSIGNED";
		sign_aclr_a	:	string := "ACLR3";
		sign_aclr_b	:	string := "ACLR3";
		sign_pipeline_aclr_a	:	string := "ACLR3";
		sign_pipeline_aclr_b	:	string := "ACLR3";
		sign_pipeline_reg_a	:	string := "CLOCK0";
		sign_pipeline_reg_b	:	string := "CLOCK0";
		sign_reg_a	:	string := "CLOCK0";
		sign_reg_b	:	string := "CLOCK0";
		width_a	:	natural;
		width_b	:	natural;
		width_result	:	natural;
		width_upper_data	:	natural := 1;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altmult_accum"
	);
	port(
		accum_is_saturated	:	out std_logic;
		accum_round	:	in std_logic := '0';
		accum_saturation	:	in std_logic := '0';
		accum_sload	:	in std_logic := '0';
		accum_sload_upper_data	:	in std_logic_vector(width_upper_data-1 downto 0) := (others => '0');
		aclr0	:	in std_logic := '0';
		aclr1	:	in std_logic := '0';
		aclr2	:	in std_logic := '0';
		aclr3	:	in std_logic := '0';
		addnsub	:	in std_logic := '1';
		clock0	:	in std_logic := '1';
		clock1	:	in std_logic := '1';
		clock2	:	in std_logic := '1';
		clock3	:	in std_logic := '1';
		dataa	:	in std_logic_vector(width_a-1 downto 0) := (others => '0');
		datab	:	in std_logic_vector(width_b-1 downto 0) := (others => '0');
		ena0	:	in std_logic := '1';
		ena1	:	in std_logic := '1';
		ena2	:	in std_logic := '1';
		ena3	:	in std_logic := '1';
		mult_is_saturated	:	out std_logic;
		mult_round	:	in std_logic := '0';
		mult_saturation	:	in std_logic := '0';
		overflow	:	out std_logic;
		result	:	out std_logic_vector(width_result-1 downto 0);
		scanina	:	in std_logic_vector(width_a-1 downto 0) := (others => '0');
		scaninb	:	in std_logic_vector(width_b-1 downto 0) := (others => '0');
		scanouta	:	out std_logic_vector(width_a-1 downto 0);
		scanoutb	:	out std_logic_vector(width_b-1 downto 0);
		signa	:	in std_logic := '0';
		signb	:	in std_logic := '0';
		sourcea	:	in std_logic := '0';
		sourceb	:	in std_logic := '0'
	);
end component;

attribute syn_black_box of altmult_accum : component is true;
------------------------------------------------------------------
-- altaccumulate parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altaccumulate
	generic (
		carry_chain	:	string := "MANUAL";
		carry_chain_length	:	natural := 32;
		intended_device_family	:	string := "unused";
		extra_latency	:	natural := 0;
		lpm_representation	:	string := "UNSIGNED";
		right_shift_distance	:	natural := 0;
		use_wys	:	string := "ON";
		width_in	:	natural;
		width_out	:	natural;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altaccumulate"
	);
	port(
		aclr	:	in std_logic := '0';
		add_sub	:	in std_logic := '1';
		cin	:	in std_logic := '0';
		clken	:	in std_logic := '1';
		clock	:	in std_logic;
		cout	:	out std_logic;
		data	:	in std_logic_vector(width_in-1 downto 0);
		overflow	:	out std_logic;
		result	:	out std_logic_vector(width_out-1 downto 0);
		sign_data	:	in std_logic := '0';
		sload	:	in std_logic := '0'
	);
end component;

attribute syn_black_box of altaccumulate : component is true;
------------------------------------------------------------------
-- dcfifo parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component dcfifo
	generic (
		add_ram_output_register	:	string := "OFF";
		clocks_are_synchronized	:	string := "FALSE";
		delay_rdusedw	:	natural := 1;
		delay_wrusedw	:	natural := 1;
		intended_device_family	:	string := "unused";
		lpm_numwords	:	natural;
		lpm_showahead	:	string := "OFF";
		lpm_width	:	natural;
		lpm_widthu	:	natural := 1;
		overflow_checking	:	string := "ON";
		rdsync_delaypipe	:	natural := 3;
		underflow_checking	:	string := "ON";
		use_eab	:	string := "ON";
		wrsync_delaypipe	:	natural := 3;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "dcfifo"
	);
	port(
		aclr	:	in std_logic := '0';
		data	:	in std_logic_vector(lpm_width-1 downto 0);
		q	:	out std_logic_vector(lpm_width-1 downto 0);
		rdclk	:	in std_logic;
		rdempty	:	out std_logic;
		rdfull	:	out std_logic;
		rdreq	:	in std_logic;
		rdusedw	:	out std_logic_vector(lpm_widthu-1 downto 0);
		wrclk	:	in std_logic;
		wrempty	:	out std_logic;
		wrfull	:	out std_logic;
		wrreq	:	in std_logic;
		wrusedw	:	out std_logic_vector(lpm_widthu-1 downto 0)
	);
end component;

attribute syn_black_box of dcfifo : component is true;
------------------------------------------------------------------
-- scfifo parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component scfifo
	generic (
		add_ram_output_register	:	string := "OFF";
		allow_rwcycle_when_full	:	string := "OFF";
		almost_empty_value	:	natural := 0;
		almost_full_value	:	natural := 0;
		intended_device_family	:	string := "unused";
		lpm_numwords	:	natural;
		lpm_showahead	:	string := "OFF";
		lpm_width	:	natural;
		lpm_widthu	:	natural := 1;
		overflow_checking	:	string := "ON";
		underflow_checking	:	string := "ON";
		use_eab	:	string := "ON";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "scfifo"
	);
	port(
		aclr	:	in std_logic := '0';
		almost_empty	:	out std_logic;
		almost_full	:	out std_logic;
		clock	:	in std_logic;
		data	:	in std_logic_vector(lpm_width-1 downto 0);
		empty	:	out std_logic;
		full	:	out std_logic;
		q	:	out std_logic_vector(lpm_width-1 downto 0);
		rdreq	:	in std_logic;
		sclr	:	in std_logic := '0';
		usedw	:	out std_logic_vector(lpm_widthu-1 downto 0);
		wrreq	:	in std_logic
	);
end component;

attribute syn_black_box of scfifo : component is true;
------------------------------------------------------------------
-- altfp_mult parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altfp_mult
	generic (
		dedicated_multiplier_circuitry	:	string := "AUTO";
		intended_device_family	:	string := "unused";
		pipeline	:	natural := 5;
		reduced_functionality	:	string := "NO";
		width_exp	:	natural := 8;
		width_man	:	natural := 23;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altfp_mult"
	);
	port(
		aclr	:	in std_logic := '0';
		clk_en	:	in std_logic := '1';
		clock	:	in std_logic;
		dataa	:	in std_logic_vector(width_exp+width_man+1-1 downto 0);
		datab	:	in std_logic_vector(width_exp+width_man+1-1 downto 0);
		denormal	:	out std_logic;
		indefinite	:	out std_logic;
		nan	:	out std_logic;
		overflow	:	out std_logic;
		result	:	out std_logic_vector(width_exp+width_man+1-1 downto 0);
		underflow	:	out std_logic;
		zero	:	out std_logic
	);
end component;

attribute syn_black_box of altfp_mult : component is true;
------------------------------------------------------------------
-- altdpram parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altdpram
	generic (
		intended_device_family	:	string := "unused";
		indata_aclr	:	string := "ON";
		indata_reg	:	string := "INCLOCK";
		lpm_file	:	string := "UNUSED";
		maximum_depth	:	natural := 0;
		numwords	:	natural := 0;
		outdata_aclr	:	string := "ON";
		outdata_reg	:	string := "UNREGISTERED";
		rdaddress_aclr	:	string := "ON";
		rdaddress_reg	:	string := "OUTCLOCK";
		rdcontrol_aclr	:	string := "ON";
		rdcontrol_reg	:	string := "OUTCLOCK";
		use_eab	:	string := "ON";
		width	:	natural;
		widthad	:	natural;
		wraddress_aclr	:	string := "ON";
		wraddress_reg	:	string := "INCLOCK";
		wrcontrol_aclr	:	string := "ON";
		wrcontrol_reg	:	string := "INCLOCK";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altdpram"
	);
	port(
		aclr	:	in std_logic := '0';
		data	:	in std_logic_vector(width-1 downto 0) := (others => '1');
		inclock	:	in std_logic := '1';
		inclocken	:	in std_logic := '1';
		outclock	:	in std_logic := '1';
		outclocken	:	in std_logic := '1';
		q	:	out std_logic_vector(width-1 downto 0);
		rdaddress	:	in std_logic_vector(widthad-1 downto 0);
		rden	:	in std_logic := '1';
		wraddress	:	in std_logic_vector(widthad-1 downto 0);
		wren	:	in std_logic
	);
end component;

attribute syn_black_box of altdpram : component is true;
------------------------------------------------------------------
-- altddio_in parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altddio_in
	generic (
		intended_device_family	:	string := "unused";
		implement_input_in_lcell	:	string := "ON";
		invert_input_clocks	:	string := "OFF";
		power_up_high	:	string := "OFF";
		width	:	natural;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altddio_in"
	);
	port(
		aclr	:	in std_logic := '0';
		aset	:	in std_logic := '0';
		datain	:	in std_logic_vector(width-1 downto 0);
		dataout_h	:	out std_logic_vector(width-1 downto 0);
		dataout_l	:	out std_logic_vector(width-1 downto 0);
		inclock	:	in std_logic;
		inclocken	:	in std_logic := '1'
	);
end component;

attribute syn_black_box of altddio_in : component is true;
------------------------------------------------------------------
-- altddio_out parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altddio_out
	generic (
		intended_device_family	:	string := "unused";
		extend_oe_disable	:	string := "OFF";
		invert_output	:	string := "OFF";
		oe_reg	:	string := "UNREGISTERED";
		power_up_high	:	string := "OFF";
		width	:	natural;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altddio_out"
	);
	port(
		aclr	:	in std_logic := '0';
		aset	:	in std_logic := '0';
		datain_h	:	in std_logic_vector(width-1 downto 0);
		datain_l	:	in std_logic_vector(width-1 downto 0);
		dataout	:	out std_logic_vector(width-1 downto 0);
		oe	:	in std_logic := '1';
		outclock	:	in std_logic;
		outclocken	:	in std_logic := '1'
	);
end component;

attribute syn_black_box of altddio_out : component is true;
------------------------------------------------------------------
-- altddio_bidir parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altddio_bidir
	generic (
		intended_device_family	:	string := "unused";
		extend_oe_disable	:	string := "OFF";
		implement_input_in_lcell	:	string := "OFF";
		invert_output	:	string := "OFF";
		oe_reg	:	string := "UNREGISTERED";
		power_up_high	:	string := "OFF";
		width	:	natural;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altddio_bidir"
	);
	port(
		aclr	:	in std_logic := '0';
		aset	:	in std_logic := '0';
		combout	:	out std_logic_vector(width-1 downto 0);
		datain_h	:	in std_logic_vector(width-1 downto 0);
		datain_l	:	in std_logic_vector(width-1 downto 0);
		dataout_h	:	out std_logic_vector(width-1 downto 0);
		dataout_l	:	out std_logic_vector(width-1 downto 0);
		dqsundelayedout	:	out std_logic_vector(width-1 downto 0);
		inclock	:	in std_logic;
		inclocken	:	in std_logic := '1';
		oe	:	in std_logic := '1';
		outclock	:	in std_logic;
		outclocken	:	in std_logic := '1';
		padio	:	inout std_logic_vector(width-1 downto 0)
	);
end component;

attribute syn_black_box of altddio_bidir : component is true;
------------------------------------------------------------------
-- altlvds_rx parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altlvds_rx
	generic (
		cds_mode	:	string := "UNUSED";
		common_rx_tx_pll	:	string := "ON";
		data_align_rollover	:	natural := 4;
		deserialization_factor	:	natural := 4;
		intended_device_family	:	string := "unused";
		dpll_lock_count	:	natural := 0;
		dpll_lock_window	:	natural := 0;
		enable_dpa_fifo	:	string := "OFF";
		enable_dpa_mode	:	string := "OFF";
		implement_in_les	:	string := "OFF";
		inclock_boost	:	natural := 0;
		inclock_data_alignment	:	string := "EDGE_ALIGNED";
		inclock_period	:	natural := 0;
		input_data_rate	:	natural := 0;
		lose_lock_on_one_change	:	string := "OFF";
		number_of_channels	:	natural;
		outclock_resource	:	string := "AUTO";
		pll_operation_mode	:	string := "NORMAL";
		port_rx_data_align	:	string := "PORT_CONNECTIVITY";
		registered_data_align_input	:	string := "ON";
		registered_output	:	string := "ON";
		reset_fifo_at_first_lock	:	string := "ON";
		use_coreclock_input	:	string := "OFF";
		use_dpll_rawperror	:	string := "OFF";
		use_external_pll	:	string := "OFF";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altlvds_rx"
	);
	port(
		pll_areset	:	in std_logic := '0';
		rx_cda_max	:	out std_logic_vector(number_of_channels-1 downto 0);
		rx_cda_reset	:	in std_logic_vector(number_of_channels-1 downto 0) := (others => '0');
		rx_channel_data_align	:	in std_logic_vector(number_of_channels-1 downto 0) := (others => '0');
		rx_coreclk	:	in std_logic_vector(number_of_channels-1 downto 0) := (others => '1');
		rx_data_align	:	in std_logic := '0';
		rx_deskew	:	in std_logic := '0';
		rx_dpa_locked	:	out std_logic_vector(number_of_channels-1 downto 0);
		rx_dpll_enable	:	in std_logic_vector(number_of_channels-1 downto 0) := (others => '1');
		rx_dpll_hold	:	in std_logic_vector(number_of_channels-1 downto 0) := (others => '0');
		rx_dpll_reset	:	in std_logic_vector(number_of_channels-1 downto 0) := (others => '0');
		rx_enable	:	in std_logic := '1';
		rx_fifo_reset	:	in std_logic_vector(number_of_channels-1 downto 0) := (others => '0');
		rx_in	:	in std_logic_vector(number_of_channels-1 downto 0);
		rx_inclock	:	in std_logic;
		rx_locked	:	out std_logic;
		rx_out	:	out std_logic_vector(deserialization_factor*number_of_channels-1 downto 0);
		rx_outclock	:	out std_logic;
		rx_pll_enable	:	in std_logic := '1';
		rx_reset	:	in std_logic_vector(number_of_channels-1 downto 0) := (others => '0')
	);
end component;

attribute syn_black_box of altlvds_rx : component is true;
------------------------------------------------------------------
-- altlvds_tx parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component altlvds_tx
	generic (
		center_align_msb	:	string := "UNUSED";
		common_rx_tx_pll	:	string := "ON";
		coreclock_divide_by	:	natural := 2;
		deserialization_factor	:	natural := 4;
		intended_device_family	:	string := "unused";
		differential_drive	:	natural := 0;
		implement_in_les	:	string := "OFF";
		inclock_boost	:	natural := 0;
		inclock_data_alignment	:	string := "EDGE_ALIGNED";
		inclock_period	:	natural := 0;
		multi_clock	:	string := "OFF";
		number_of_channels	:	natural;
		outclock_alignment	:	string := "EDGE_ALIGNED";
		outclock_divide_by	:	natural := 1;
		outclock_multiply_by	:	natural := 1;
		outclock_resource	:	string := "AUTO";
		output_data_rate	:	natural := 0;
		preemphasis_setting	:	natural := 0;
		registered_input	:	string := "ON";
		use_external_pll	:	string := "OFF";
		vod_setting	:	natural := 0;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altlvds_tx"
	);
	port(
		pll_areset	:	in std_logic := '0';
		sync_inclock	:	in std_logic := '0';
		tx_coreclock	:	out std_logic;
		tx_enable	:	in std_logic := '1';
		tx_in	:	in std_logic_vector(deserialization_factor*number_of_channels-1 downto 0);
		tx_inclock	:	in std_logic;
		tx_locked	:	out std_logic;
		tx_out	:	out std_logic_vector(number_of_channels-1 downto 0);
		tx_outclock	:	out std_logic;
		tx_pll_enable	:	in std_logic := '1'
	);
end component;

attribute syn_black_box of altlvds_tx : component is true;
------------------------------------------------------------------
-- alt_mac_mult parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component alt_mac_mult
	generic (
		bypass_multiplier	:	string := "NO";
		dataa_clear	:	string := "NONE";
		dataa_clock	:	string := "NONE";
		dataa_width	:	natural;
		datab_clear	:	string := "NONE";
		datab_clock	:	string := "NONE";
		datab_width	:	natural;
		dynamic_scan_chain_supported	:	string := "NO";
		extra_output_clear	:	string := "NONE";
		extra_output_clock	:	string := "NONE";
		extra_signa_clear	:	string := "NONE";
		extra_signa_clock	:	string := "NONE";
		extra_signb_clear	:	string := "NONE";
		extra_signb_clock	:	string := "NONE";
		mult_clear	:	string := "NONE";
		mult_clock	:	string := "NONE";
		mult_input_a_is_constant	:	string := "NO";
		mult_input_b_is_constant	:	string := "NO";
		mult_maximize_speed	:	natural := 5;
		mult_pipeline	:	natural := 0;
		mult_representation_a	:	string := "VARIABLE";
		mult_representation_b	:	string := "VARIABLE";
		output_clear	:	string := "NONE";
		output_clock	:	string := "NONE";
		output_width	:	natural;
		round_clear	:	string := "NONE";
		round_clock	:	string := "NONE";
		saturate_clear	:	string := "NONE";
		saturate_clock	:	string := "NONE";
		signa_clear	:	string := "NONE";
		signa_clock	:	string := "NONE";
		signb_clear	:	string := "NONE";
		signb_clock	:	string := "NONE";
		using_rounding	:	string := "NO";
		using_saturation	:	string := "NO";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "alt_mac_mult"
	);
	port(
		aclr	:	in std_logic_vector(3 downto 0) := (others => '0');
		clk	:	in std_logic_vector(3 downto 0);
		dataa	:	in std_logic_vector(dataa_width-1 downto 0) := (others => '0');
		datab	:	in std_logic_vector(datab_width-1 downto 0);
		dataout	:	out std_logic_vector(output_width-1 downto 0);
		ena	:	in std_logic_vector(3 downto 0) := (others => '1');
		round	:	in std_logic := '0';
		saturate	:	in std_logic := '0';
		scanina	:	in std_logic_vector(dataa_width-1 downto 0) := (others => '0');
		scaninb	:	in std_logic_vector(datab_width-1 downto 0) := (others => '0');
		scanouta	:	out std_logic_vector(dataa_width-1 downto 0);
		scanoutb	:	out std_logic_vector(datab_width-1 downto 0);
		signa	:	in std_logic := '1';
		signb	:	in std_logic := '1';
		sourcea	:	in std_logic := '0';
		sourceb	:	in std_logic := '0'
	);
end component;

attribute syn_black_box of alt_mac_mult : component is true;
------------------------------------------------------------------
-- alt_mac_out parameterized megafunction component declaration
-- Generated with 'clearbox' loader - do not edit
------------------------------------------------------------------
component alt_mac_out
	generic (
		addnsub0_clear	:	string := "NONE";
		addnsub0_clock	:	string := "NONE";
		addnsub0_pipeline_clear	:	string := "NONE";
		addnsub0_pipeline_clock	:	string := "NONE";
		addnsub1_clear	:	string := "NONE";
		addnsub1_clock	:	string := "NONE";
		addnsub1_pipeline_clear	:	string := "NONE";
		addnsub1_pipeline_clock	:	string := "NONE";
		dataa_forced_to_zero	:	string := "NO";
		dataa_width	:	natural;
		datab_width	:	natural := 1;
		datac_forced_to_zero	:	string := "NO";
		datac_width	:	natural := 1;
		datad_width	:	natural := 1;
		loadable_accum_supported	:	string := "NO";
		mode0_clear	:	string := "NONE";
		mode0_clock	:	string := "NONE";
		mode0_pipeline_clear	:	string := "NONE";
		mode0_pipeline_clock	:	string := "NONE";
		mode1_clear	:	string := "NONE";
		mode1_clock	:	string := "NONE";
		mode1_pipeline_clear	:	string := "NONE";
		mode1_pipeline_clock	:	string := "NONE";
		multabsaturate_clear	:	string := "NONE";
		multabsaturate_clock	:	string := "NONE";
		multabsaturate_pipeline_clear	:	string := "NONE";
		multabsaturate_pipeline_clock	:	string := "NONE";
		multcdsaturate_clear	:	string := "NONE";
		multcdsaturate_clock	:	string := "NONE";
		multcdsaturate_pipeline_clear	:	string := "NONE";
		multcdsaturate_pipeline_clock	:	string := "NONE";
		operation_mode	:	string;
		output_clear	:	string := "NONE";
		output_clock	:	string := "NONE";
		output_width	:	natural;
		round0_clear	:	string := "NONE";
		round0_clock	:	string := "NONE";
		round0_pipeline_clear	:	string := "NONE";
		round0_pipeline_clock	:	string := "NONE";
		round1_clear	:	string := "NONE";
		round1_clock	:	string := "NONE";
		round1_pipeline_clear	:	string := "NONE";
		round1_pipeline_clock	:	string := "NONE";
		saturate_clear	:	string := "NONE";
		saturate_clock	:	string := "NONE";
		saturate_pipeline_clear	:	string := "NONE";
		saturate_pipeline_clock	:	string := "NONE";
		signa_clear	:	string := "NONE";
		signa_clock	:	string := "NONE";
		signa_pipeline_clear	:	string := "NONE";
		signa_pipeline_clock	:	string := "NONE";
		signb_clear	:	string := "NONE";
		signb_clock	:	string := "NONE";
		signb_pipeline_clear	:	string := "NONE";
		signb_pipeline_clock	:	string := "NONE";
		using_loadable_accum	:	string := "NO";
		using_mult_saturation	:	string := "NO";
		using_rounding	:	string := "NO";
		using_saturation	:	string := "NO";
		zeroacc_clear	:	string := "NONE";
		zeroacc_clock	:	string := "NONE";
		zeroacc_pipeline_clear	:	string := "NONE";
		zeroacc_pipeline_clock	:	string := "NONE";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "alt_mac_out"
	);
	port(
		accoverflow	:	out std_logic;
		aclr	:	in std_logic_vector(3 downto 0) := (others => '0');
		addnsub0	:	in std_logic := '1';
		addnsub1	:	in std_logic := '1';
		clk	:	in std_logic_vector(3 downto 0);
		dataa	:	in std_logic_vector(dataa_width-1 downto 0) := (others => '0');
		datab	:	in std_logic_vector(datab_width-1 downto 0) := (others => '0');
		datac	:	in std_logic_vector(datac_width-1 downto 0) := (others => '0');
		datad	:	in std_logic_vector(datad_width-1 downto 0) := (others => '0');
		dataout	:	out std_logic_vector(output_width-1 downto 0);
		ena	:	in std_logic_vector(3 downto 0) := (others => '1');
		mode0	:	in std_logic := '0';
		mode1	:	in std_logic := '0';
		multabsaturate	:	in std_logic := '0';
		multcdsaturate	:	in std_logic := '0';
		round0	:	in std_logic := '0';
		round1	:	in std_logic := '0';
		saturate	:	in std_logic := '0';
		saturate1	:	in std_logic := '0';
		signa	:	in std_logic := '1';
		signb	:	in std_logic := '1';
		zeroacc	:	in std_logic := '0';
		zeroacc1	:	in std_logic := '0'
	);
end component;

attribute syn_black_box of alt_mac_out : component is true;
------------------------------------------------------------------
-- altcam parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component altcam
	generic (
		intended_device_family	:	string := "unused";
		lpm_file	:	string := "UNUSED";
		lpm_filex	:	string := "UNUSED";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altcam";
		match_mode	:	string := "MULTIPLE";
		numwords	:	natural := 0;
		output_aclr	:	string := "ON";
		output_reg	:	string := "UNREGISTERED";
		pattern_aclr	:	string := "ON";
		pattern_reg	:	string := "INCLOCK";
		register_odd_match	:	string := "OFF";
		use_eab	:	string := "ON";
		use_wysiwyg	:	string := "ON";
		width	:	natural;
		widthad	:	natural;
		wraddress_aclr	:	string := "ON";
		wrcontrol_aclr	:	string := "ON";
		wrx_aclr	:	string := "ON";
		wrx_reg	:	string := "INCLOCK"	);
	port(
		inaclr	:	in std_logic := '0';
		inclock	:	in std_logic;
		inclocken	:	in std_logic := '1';
		maddress	:	out std_logic_vector(WIDTHAD-1 downto 0);
		mbits	:	out std_logic_vector(NUMWORDS-1 downto 0);
		mcount	:	out std_logic_vector(WIDTHAD-1 downto 0);
		mfound	:	out std_logic;
		mnext	:	in std_logic := '0';
		mstart	:	in std_logic := '0';
		outaclr	:	in std_logic := '0';
		outclock	:	in std_logic := '0';
		outclocken	:	in std_logic := '1';
		pattern	:	in std_logic_vector(WIDTH-1 downto 0);
		rdbusy	:	out std_logic;
		wraddress	:	in std_logic_vector(WIDTHAD-1 downto 0) := (others => '0');
		wrbusy	:	out std_logic;
		wrdelete	:	in std_logic := '0';
		wren	:	in std_logic := '0';
		wrx	:	in std_logic_vector(WIDTH-1 downto 0) := (others => '0');
		wrxused	:	in std_logic := '1'
	);
end component;

attribute syn_black_box of altcam : component is true;
------------------------------------------------------------------
-- altclklock parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component altclklock
	generic (
		clock0_boost	:	natural := 1;
		clock0_divide	:	natural := 1;
		clock0_settings	:	string := "UNUSED";
		clock0_time_delay	:	natural := 0;
		clock1_boost	:	natural := 1;
		clock1_divide	:	natural := 1;
		clock1_settings	:	string := "UNUSED";
		clock1_time_delay	:	natural := 0;
		clock2_boost	:	natural := 1;
		clock2_divide	:	natural := 1;
		clock2_settings	:	string := "UNUSED";
		clock2_time_delay	:	natural := 0;
		clock_ext_boost	:	natural := 1;
		clock_ext_divide	:	natural := 1;
		clock_ext_settings	:	string := "UNUSED";
		clock_ext_time_delay	:	natural := 0;
		inclock_period	:	natural := 10000;
		inclock_settings	:	string := "UNUSED";
		intended_device_family	:	string := "UNUSED";
		invalid_lock_cycles	:	natural := 5;
		invalid_lock_multiplier	:	natural := 5;
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altclklock";
		operation_mode	:	string := "UNUSED";
		outclock_phase_shift	:	natural := 0;
		valid_lock_cycles	:	natural := 5;
		valid_lock_multiplier	:	natural := 5	);
	port(
		clock0	:	out std_logic;
		clock1	:	out std_logic;
		clock2	:	out std_logic;
		clock_ext	:	out std_logic;
		fbin	:	in std_logic := '1';
		inclock	:	in std_logic;
		inclocken	:	in std_logic := '1';
		locked	:	out std_logic
	);
end component;

attribute syn_black_box of altclklock : component is true;
------------------------------------------------------------------
-- altpll parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component altpll
	generic (
		bandwidth	:	natural := 0;
		bandwidth_type	:	string := "AUTO";
		c0_high	:	natural := 0;
		c0_initial	:	natural := 0;
		c0_low	:	natural := 0;
		c0_mode	:	string := "BYPASS";
		c0_ph	:	natural := 0;
		c0_test_source	:	natural := 5;
		c1_high	:	natural := 0;
		c1_initial	:	natural := 0;
		c1_low	:	natural := 0;
		c1_mode	:	string := "BYPASS";
		c1_ph	:	natural := 0;
		c1_test_source	:	natural := 5;
		c1_use_casc_in	:	string := "0";
		c2_high	:	natural := 0;
		c2_initial	:	natural := 0;
		c2_low	:	natural := 0;
		c2_mode	:	string := "BYPASS";
		c2_ph	:	natural := 0;
		c2_test_source	:	natural := 5;
		c2_use_casc_in	:	string := "0";
		c3_high	:	natural := 0;
		c3_initial	:	natural := 0;
		c3_low	:	natural := 0;
		c3_mode	:	string := "BYPASS";
		c3_ph	:	natural := 0;
		c3_test_source	:	natural := 5;
		c3_use_casc_in	:	string := "0";
		c4_high	:	natural := 0;
		c4_initial	:	natural := 0;
		c4_low	:	natural := 0;
		c4_mode	:	string := "BYPASS";
		c4_ph	:	natural := 0;
		c4_test_source	:	natural := 5;
		c4_use_casc_in	:	string := "0";
		c5_high	:	natural := 0;
		c5_initial	:	natural := 0;
		c5_low	:	natural := 0;
		c5_mode	:	string := "BYPASS";
		c5_ph	:	natural := 0;
		c5_test_source	:	natural := 5;
		c5_use_casc_in	:	string := "0";
		charge_pump_current	:	natural := 2;
		clk0_counter	:	string := "G0";
		clk0_divide_by	:	natural := 1;
		clk0_duty_cycle	:	natural := 50;
		clk0_multiply_by	:	natural := 1;
		clk0_output_frequency	:	natural := 0;
		clk0_phase_shift	:	string := "0";
		clk0_time_delay	:	string := "0";
		clk1_counter	:	string := "G0";
		clk1_divide_by	:	natural := 1;
		clk1_duty_cycle	:	natural := 50;
		clk1_multiply_by	:	natural := 1;
		clk1_output_frequency	:	natural := 0;
		clk1_phase_shift	:	string := "0";
		clk1_time_delay	:	string := "0";
		clk2_counter	:	string := "G0";
		clk2_divide_by	:	natural := 1;
		clk2_duty_cycle	:	natural := 50;
		clk2_multiply_by	:	natural := 1;
		clk2_output_frequency	:	natural := 0;
		clk2_phase_shift	:	string := "0";
		clk2_time_delay	:	string := "0";
		clk3_counter	:	string := "G0";
		clk3_divide_by	:	natural := 1;
		clk3_duty_cycle	:	natural := 50;
		clk3_multiply_by	:	natural := 1;
		clk3_phase_shift	:	string := "0";
		clk3_time_delay	:	string := "0";
		clk4_counter	:	string := "G0";
		clk4_divide_by	:	natural := 1;
		clk4_duty_cycle	:	natural := 50;
		clk4_multiply_by	:	natural := 1;
		clk4_phase_shift	:	string := "0";
		clk4_time_delay	:	string := "0";
		clk5_counter	:	string := "G0";
		clk5_divide_by	:	natural := 1;
		clk5_duty_cycle	:	natural := 50;
		clk5_multiply_by	:	natural := 1;
		clk5_phase_shift	:	string := "0";
		clk5_time_delay	:	string := "0";
		compensate_clock	:	string := "CLK0";
		down_spread	:	string := "0";
		e0_high	:	natural := 1;
		e0_initial	:	natural := 1;
		e0_low	:	natural := 1;
		e0_mode	:	string := "BYPASS";
		e0_ph	:	natural := 0;
		e0_time_delay	:	natural := 0;
		e1_high	:	natural := 1;
		e1_initial	:	natural := 1;
		e1_low	:	natural := 1;
		e1_mode	:	string := "BYPASS";
		e1_ph	:	natural := 0;
		e1_time_delay	:	natural := 0;
		e2_high	:	natural := 1;
		e2_initial	:	natural := 1;
		e2_low	:	natural := 1;
		e2_mode	:	string := "BYPASS";
		e2_ph	:	natural := 0;
		e2_time_delay	:	natural := 0;
		e3_high	:	natural := 1;
		e3_initial	:	natural := 1;
		e3_low	:	natural := 1;
		e3_mode	:	string := "BYPASS";
		e3_ph	:	natural := 0;
		e3_time_delay	:	natural := 0;
		enable0_counter	:	string := "L0";
		enable1_counter	:	string := "L0";
		enable_switch_over_counter	:	string := "OFF";
		extclk0_counter	:	string := "E0";
		extclk0_divide_by	:	natural := 1;
		extclk0_duty_cycle	:	natural := 50;
		extclk0_multiply_by	:	natural := 1;
		extclk0_phase_shift	:	string := "0";
		extclk0_time_delay	:	string := "0";
		extclk1_counter	:	string := "E1";
		extclk1_divide_by	:	natural := 1;
		extclk1_duty_cycle	:	natural := 50;
		extclk1_multiply_by	:	natural := 1;
		extclk1_phase_shift	:	string := "0";
		extclk1_time_delay	:	string := "0";
		extclk2_counter	:	string := "E2";
		extclk2_divide_by	:	natural := 1;
		extclk2_duty_cycle	:	natural := 50;
		extclk2_multiply_by	:	natural := 1;
		extclk2_phase_shift	:	string := "0";
		extclk2_time_delay	:	string := "0";
		extclk3_counter	:	string := "E3";
		extclk3_divide_by	:	natural := 1;
		extclk3_duty_cycle	:	natural := 50;
		extclk3_multiply_by	:	natural := 1;
		extclk3_phase_shift	:	string := "0";
		extclk3_time_delay	:	string := "0";
		feedback_source	:	string := "EXTCLK0";
		g0_high	:	natural := 1;
		g0_initial	:	natural := 1;
		g0_low	:	natural := 1;
		g0_mode	:	string := "BYPASS";
		g0_ph	:	natural := 0;
		g0_time_delay	:	natural := 0;
		g1_high	:	natural := 1;
		g1_initial	:	natural := 1;
		g1_low	:	natural := 1;
		g1_mode	:	string := "BYPASS";
		g1_ph	:	natural := 0;
		g1_time_delay	:	natural := 0;
		g2_high	:	natural := 1;
		g2_initial	:	natural := 1;
		g2_low	:	natural := 1;
		g2_mode	:	string := "BYPASS";
		g2_ph	:	natural := 0;
		g2_time_delay	:	natural := 0;
		g3_high	:	natural := 1;
		g3_initial	:	natural := 1;
		g3_low	:	natural := 1;
		g3_mode	:	string := "BYPASS";
		g3_ph	:	natural := 0;
		g3_time_delay	:	natural := 0;
		gate_lock_counter	:	natural := 0;
		gate_lock_signal	:	string := "NO";
		inclk0_input_frequency	:	natural;
		inclk1_input_frequency	:	natural := 0;
		intended_device_family	:	string := "NONE";
		invalid_lock_multiplier	:	natural := 5;
		l0_high	:	natural := 1;
		l0_initial	:	natural := 1;
		l0_low	:	natural := 1;
		l0_mode	:	string := "BYPASS";
		l0_ph	:	natural := 0;
		l0_time_delay	:	natural := 0;
		l1_high	:	natural := 1;
		l1_initial	:	natural := 1;
		l1_low	:	natural := 1;
		l1_mode	:	string := "BYPASS";
		l1_ph	:	natural := 0;
		l1_time_delay	:	natural := 0;
		lock_high	:	natural := 1;
		lock_low	:	natural := 1;
		loop_filter_c	:	natural := 5;
		loop_filter_r	:	string := "1.000000";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altpll";
		m	:	natural := 0;
		m2	:	natural := 1;
		m_initial	:	natural := 0;
		m_ph	:	natural := 0;
		m_test_source	:	natural := 5;
		m_time_delay	:	natural := 0;
		n	:	natural := 1;
		n2	:	natural := 1;
		n_time_delay	:	natural := 0;
		operation_mode	:	string;
		pfd_max	:	natural := 0;
		pfd_min	:	natural := 0;
		pll_type	:	string := "AUTO";
		port_activeclock	:	string := "PORT_CONNECTIVITY";
		port_areset	:	string := "PORT_CONNECTIVITY";
		port_clk0	:	string := "PORT_CONNECTIVITY";
		port_clk1	:	string := "PORT_CONNECTIVITY";
		port_clk2	:	string := "PORT_CONNECTIVITY";
		port_clk3	:	string := "PORT_CONNECTIVITY";
		port_clk4	:	string := "PORT_CONNECTIVITY";
		port_clk5	:	string := "PORT_CONNECTIVITY";
		port_clkbad0	:	string := "PORT_CONNECTIVITY";
		port_clkbad1	:	string := "PORT_CONNECTIVITY";
		port_clkena0	:	string := "PORT_CONNECTIVITY";
		port_clkena1	:	string := "PORT_CONNECTIVITY";
		port_clkena2	:	string := "PORT_CONNECTIVITY";
		port_clkena3	:	string := "PORT_CONNECTIVITY";
		port_clkena4	:	string := "PORT_CONNECTIVITY";
		port_clkena5	:	string := "PORT_CONNECTIVITY";
		port_clkloss	:	string := "PORT_CONNECTIVITY";
		port_clkswitch	:	string := "PORT_CONNECTIVITY";
		port_enable0	:	string := "PORT_CONNECTIVITY";
		port_enable1	:	string := "PORT_CONNECTIVITY";
		port_extclk0	:	string := "PORT_CONNECTIVITY";
		port_extclk1	:	string := "PORT_CONNECTIVITY";
		port_extclk2	:	string := "PORT_CONNECTIVITY";
		port_extclk3	:	string := "PORT_CONNECTIVITY";
		port_extclkena0	:	string := "PORT_CONNECTIVITY";
		port_extclkena1	:	string := "PORT_CONNECTIVITY";
		port_extclkena2	:	string := "PORT_CONNECTIVITY";
		port_extclkena3	:	string := "PORT_CONNECTIVITY";
		port_fbin	:	string := "PORT_CONNECTIVITY";
		port_inclk0	:	string := "PORT_CONNECTIVITY";
		port_inclk1	:	string := "PORT_CONNECTIVITY";
		port_locked	:	string := "PORT_CONNECTIVITY";
		port_pfdena	:	string := "PORT_CONNECTIVITY";
		port_pllena	:	string := "PORT_CONNECTIVITY";
		port_scanaclr	:	string := "PORT_CONNECTIVITY";
		port_scanclk	:	string := "PORT_CONNECTIVITY";
		port_scandata	:	string := "PORT_CONNECTIVITY";
		port_scandataout	:	string := "PORT_CONNECTIVITY";
		port_scandone	:	string := "PORT_CONNECTIVITY";
		port_scanread	:	string := "PORT_CONNECTIVITY";
		port_scanwrite	:	string := "PORT_CONNECTIVITY";
		port_sclkout0	:	string := "PORT_CONNECTIVITY";
		port_sclkout1	:	string := "PORT_CONNECTIVITY";
		primary_clock	:	string := "INCLK0";
		qualify_conf_done	:	string := "OFF";
		scan_chain	:	string := "LONG";
		sclkout0_phase_shift	:	string := "0";
		sclkout1_phase_shift	:	string := "0";
		self_reset_on_gated_loss_lock	:	string := "OFF";
		skip_vco	:	string := "OFF";
		spread_frequency	:	natural := 0;
		ss	:	natural := 1;
		switch_over_counter	:	natural := 0;
		switch_over_on_gated_lock	:	string := "OFF";
		switch_over_on_lossclk	:	string := "OFF";
		switch_over_type	:	string := "AUTO";
		valid_lock_multiplier	:	natural := 1;
		vco_center	:	natural := 0;
		vco_divide_by	:	natural := 0;
		vco_max	:	natural := 0;
		vco_min	:	natural := 0;
		vco_multiply_by	:	natural := 0;
		vco_post_scale	:	natural := 0	);
	port(
		activeclock	:	out std_logic;
		areset	:	in std_logic := '0';
		clk	:	out std_logic_vector(5 downto 0);
		clkbad	:	out std_logic_vector(1 downto 0);
		clkena	:	in std_logic_vector(5 downto 0) := (others => '1');
		clkloss	:	out std_logic;
		clkswitch	:	in std_logic := '0';
		enable0	:	out std_logic;
		enable1	:	out std_logic;
		extclk	:	out std_logic_vector(3 downto 0);
		extclkena	:	in std_logic_vector(3 downto 0) := (others => '1');
		fbin	:	in std_logic := '1';
		inclk	:	in std_logic_vector(1 downto 0) := (others => '0');
		locked	:	out std_logic;
		pfdena	:	in std_logic := '1';
		pllena	:	in std_logic := '1';
		scanaclr	:	in std_logic := '0';
		scanclk	:	in std_logic := '0';
		scandata	:	in std_logic := '0';
		scandataout	:	out std_logic;
		scandone	:	out std_logic;
		scanread	:	in std_logic := '0';
		scanwrite	:	in std_logic := '0';
		sclkout0	:	out std_logic;
		sclkout1	:	out std_logic
	);
end component;

attribute syn_black_box of altpll : component is true;
------------------------------------------------------------------
-- alt3pram parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component alt3pram
	generic (
		indata_aclr	:	string := "ON";
		indata_reg	:	string := "INCLOCK";
		intended_device_family	:	string := "unused";
		lpm_file	:	string := "UNUSED";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "alt3pram";
		numwords	:	natural := 0;
		outdata_aclr_a	:	string := "ON";
		outdata_aclr_b	:	string := "ON";
		outdata_reg_a	:	string := "OUTCLOCK";
		outdata_reg_b	:	string := "OUTCLOCK";
		rdaddress_aclr_a	:	string := "ON";
		rdaddress_aclr_b	:	string := "ON";
		rdaddress_reg_a	:	string := "INCLOCK";
		rdaddress_reg_b	:	string := "INCLOCK";
		rdcontrol_aclr_a	:	string := "ON";
		rdcontrol_aclr_b	:	string := "ON";
		rdcontrol_reg_a	:	string := "INCLOCK";
		rdcontrol_reg_b	:	string := "INCLOCK";
		use_eab	:	string := "ON";
		width	:	natural;
		widthad	:	natural;
		write_aclr	:	string := "ON";
		write_reg	:	string := "INCLOCK"	);
	port(
		aclr	:	in std_logic := '0';
		data	:	in std_logic_vector(WIDTH-1 downto 0);
		inclock	:	in std_logic := '1';
		inclocken	:	in std_logic := '1';
		outclock	:	in std_logic := '1';
		outclocken	:	in std_logic := '1';
		qa	:	out std_logic_vector(WIDTH-1 downto 0);
		qb	:	out std_logic_vector(WIDTH-1 downto 0);
		rdaddress_a	:	in std_logic_vector(WIDTHAD-1 downto 0);
		rdaddress_b	:	in std_logic_vector(WIDTHAD-1 downto 0);
		rden_a	:	in std_logic := '1';
		rden_b	:	in std_logic := '1';
		wraddress	:	in std_logic_vector(WIDTHAD-1 downto 0);
		wren	:	in std_logic
	);
end component;

attribute syn_black_box of alt3pram : component is true;
------------------------------------------------------------------
-- altqpram parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component altqpram
	generic (
		cascade_chain	:	string;
		indata_aclr_a	:	string := "INACLR_A";
		indata_aclr_b	:	string := "INACLR_B";
		indata_reg_a	:	string := "INCLOCK_A";
		indata_reg_b	:	string := "INCLOCK_B";
		init_file	:	string := "UNUSED";
		intended_device_family	:	string := "unused";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altqpram";
		maximum_depth	:	natural := 4096;
		numwords_read_a	:	natural := 1;
		numwords_read_b	:	natural := 1;
		numwords_write_a	:	natural := 1;
		numwords_write_b	:	natural := 1;
		operation_mode	:	string := "QUAD_PORT";
		outdata_aclr_a	:	string := "OUTACLR_A";
		outdata_aclr_b	:	string := "OUTACLR_B";
		outdata_reg_a	:	string := "UNREGISTERED";
		outdata_reg_b	:	string := "UNREGISTERED";
		rdaddress_aclr_a	:	string := "OUTACLR_A";
		rdaddress_aclr_b	:	string := "OUTACLR_B";
		rdaddress_reg_a	:	string := "OUTCLOCK_A";
		rdaddress_reg_b	:	string := "OUTCLOCK_B";
		rdcontrol_aclr_a	:	string := "OUTACLR_A";
		rdcontrol_aclr_b	:	string := "OUTACLR_B";
		rdcontrol_reg_a	:	string := "OUTCLOCK_A";
		rdcontrol_reg_b	:	string := "OUTCLOCK_B";
		suppress_memory_conversion_warnings	:	string := "OFF";
		width_read_a	:	natural := 1;
		width_read_b	:	natural := 1;
		width_write_a	:	natural := 1;
		width_write_b	:	natural := 1;
		widthad_read_a	:	natural := 1;
		widthad_read_b	:	natural := 1;
		widthad_write_a	:	natural := 1;
		widthad_write_b	:	natural := 1;
		wraddress_aclr_a	:	string := "INACLR_A";
		wraddress_aclr_b	:	string := "INACLR_B";
		wrcontrol_aclr_a	:	string := "INACLR_A";
		wrcontrol_aclr_b	:	string := "INACLR_B";
		wrcontrol_wraddress_reg_a	:	string := "INCLOCK_A";
		wrcontrol_wraddress_reg_b	:	string := "INCLOCK_B"	);
	port(
		data_a	:	in std_logic_vector(WIDTH_WRITE_A-1 downto 0) := (others => '1');
		data_b	:	in std_logic_vector(WIDTH_WRITE_B-1 downto 0) := (others => '1');
		inaclr_a	:	in std_logic := '0';
		inaclr_b	:	in std_logic := '0';
		inclock_a	:	in std_logic := '1';
		inclock_b	:	in std_logic := '1';
		inclocken_a	:	in std_logic := '1';
		inclocken_b	:	in std_logic := '1';
		outaclr_a	:	in std_logic := '0';
		outaclr_b	:	in std_logic := '0';
		outclock_a	:	in std_logic := '1';
		outclock_b	:	in std_logic := '1';
		outclocken_a	:	in std_logic := '1';
		outclocken_b	:	in std_logic := '1';
		q_a	:	out std_logic_vector(WIDTH_READ_A-1 downto 0);
		q_b	:	out std_logic_vector(WIDTH_READ_B-1 downto 0);
		rdaddress_a	:	in std_logic_vector(WIDTHAD_READ_A-1 downto 0) := (others => '1');
		rdaddress_b	:	in std_logic_vector(WIDTHAD_READ_B-1 downto 0) := (others => '1');
		rden_a	:	in std_logic := '1';
		rden_b	:	in std_logic := '1';
		wraddress_a	:	in std_logic_vector(WIDTHAD_WRITE_A-1 downto 0) := (others => '1');
		wraddress_b	:	in std_logic_vector(WIDTHAD_WRITE_B-1 downto 0) := (others => '1');
		wren_a	:	in std_logic := '0';
		wren_b	:	in std_logic := '0'
	);
end component;

attribute syn_black_box of altqpram : component is true;
------------------------------------------------------------------
-- altcdr_rx parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component altcdr_rx
	generic (
		bypass_fifo	:	string := "OFF";
		deserialization_factor	:	natural;
		inclock_boost	:	natural := 0;
		inclock_period	:	natural;
		intended_device_family	:	string := "MERCURY";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altcdr_rx";
		number_of_channels	:	natural;
		run_length	:	natural := 62	);
	port(
		rx_aclr	:	in std_logic := '0';
		rx_coreclock	:	in std_logic;
		rx_empty	:	out std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0);
		rx_fifo_rden	:	in std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0) := (others => '1');
		rx_full	:	out std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0);
		rx_in	:	in std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0);
		rx_inclock	:	in std_logic;
		rx_locklost	:	out std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0);
		rx_out	:	out std_logic_vector(DESERIALIZATION_FACTOR*NUMBER_OF_CHANNELS-1 downto 0);
		rx_outclock	:	out std_logic;
		rx_pll_aclr	:	in std_logic := '0';
		rx_pll_locked	:	out std_logic;
		rx_rec_clk	:	out std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0);
		rx_rlv	:	out std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0)
	);
end component;

attribute syn_black_box of altcdr_rx : component is true;
------------------------------------------------------------------
-- altcdr_tx parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component altcdr_tx
	generic (
		bypass_fifo	:	string := "OFF";
		deserialization_factor	:	natural;
		inclock_boost	:	natural := 0;
		inclock_period	:	natural;
		intended_device_family	:	string := "MERCURY";
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altcdr_tx";
		number_of_channels	:	natural	);
	port(
		tx_aclr	:	in std_logic := '0';
		tx_coreclock	:	in std_logic;
		tx_empty	:	out std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0);
		tx_fifo_wren	:	in std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0) := (others => '1');
		tx_full	:	out std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0);
		tx_in	:	in std_logic_vector(DESERIALIZATION_FACTOR*NUMBER_OF_CHANNELS-1 downto 0);
		tx_inclock	:	in std_logic;
		tx_out	:	out std_logic_vector(NUMBER_OF_CHANNELS-1 downto 0);
		tx_outclock	:	out std_logic;
		tx_pll_aclr	:	in std_logic := '0';
		tx_pll_locked	:	out std_logic
	);
end component;

attribute syn_black_box of altcdr_tx : component is true;
------------------------------------------------------------------
-- altsqrt parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component altsqrt
	generic (
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "altsqrt";
		pipeline	:	natural := 0;
		q_port_width	:	natural := 1;
		r_port_width	:	natural := 1;
		width	:	natural	);
	port(
		aclr	:	in std_logic := '0';
		clk	:	in std_logic := '1';
		ena	:	in std_logic := '1';
		q	:	out std_logic_vector(Q_PORT_WIDTH-1 downto 0);
		radical	:	in std_logic_vector(WIDTH-1 downto 0);
		remainder	:	out std_logic_vector(R_PORT_WIDTH-1 downto 0)
	);
end component;

attribute syn_black_box of altsqrt : component is true;
------------------------------------------------------------------
-- sld_virtual_jtag parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component sld_virtual_jtag
	generic (
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "sld_virtual_jtag";
		sld_auto_instance_index	:	string := "NO";
		sld_instance_index	:	natural := 0;
		sld_ir_width	:	natural := 1;
		sld_sim_action	:	string := "UNUSED";
		sld_sim_n_scan	:	natural := 0;
		sld_sim_total_length	:	natural := 0	);
	port(
		ir_in	:	out std_logic_vector(sld_ir_width-1 downto 0);
		ir_out	:	in std_logic_vector(sld_ir_width-1 downto 0);
		jtag_state_cdr	:	out std_logic;
		jtag_state_cir	:	out std_logic;
		jtag_state_e1dr	:	out std_logic;
		jtag_state_e1ir	:	out std_logic;
		jtag_state_e2dr	:	out std_logic;
		jtag_state_e2ir	:	out std_logic;
		jtag_state_pdr	:	out std_logic;
		jtag_state_pir	:	out std_logic;
		jtag_state_rti	:	out std_logic;
		jtag_state_sdr	:	out std_logic;
		jtag_state_sdrs	:	out std_logic;
		jtag_state_sir	:	out std_logic;
		jtag_state_sirs	:	out std_logic;
		jtag_state_tlr	:	out std_logic;
		jtag_state_udr	:	out std_logic;
		jtag_state_uir	:	out std_logic;
		tck	:	out std_logic;
		tdi	:	out std_logic;
		tdo	:	in std_logic;
		tms	:	out std_logic;
		virtual_state_cdr	:	out std_logic;
		virtual_state_cir	:	out std_logic;
		virtual_state_e1dr	:	out std_logic;
		virtual_state_e2dr	:	out std_logic;
		virtual_state_pdr	:	out std_logic;
		virtual_state_sdr	:	out std_logic;
		virtual_state_udr	:	out std_logic;
		virtual_state_uir	:	out std_logic
	);
end component;

attribute syn_black_box of sld_virtual_jtag : component is true;
------------------------------------------------------------------
-- sld_virtual_jtag_basic parameterized megafunction component declaration
-- Generated with 'mega_defn_creator' loader - do not edit
------------------------------------------------------------------
component sld_virtual_jtag_basic
	generic (
		lpm_hint	:	string := "UNUSED";
		lpm_type	:	string := "sld_virtual_jtag_basic";
		sld_auto_instance_index	:	string := "NO";
		sld_instance_index	:	natural := 0;
		sld_ir_width	:	natural := 1;
		sld_mfg_id	:	natural := 0;
		sld_sim_action	:	string := "UNUSED";
		sld_sim_n_scan	:	natural := 0;
		sld_sim_total_length	:	natural := 0;
		sld_type_id	:	natural := 0;
		sld_version	:	natural := 0	);
	port(
		ir_in	:	out std_logic_vector(sld_ir_width-1 downto 0);
		ir_out	:	in std_logic_vector(sld_ir_width-1 downto 0);
		jtag_state_cdr	:	out std_logic;
		jtag_state_cir	:	out std_logic;
		jtag_state_e1dr	:	out std_logic;
		jtag_state_e1ir	:	out std_logic;
		jtag_state_e2dr	:	out std_logic;
		jtag_state_e2ir	:	out std_logic;
		jtag_state_pdr	:	out std_logic;
		jtag_state_pir	:	out std_logic;
		jtag_state_rti	:	out std_logic;
		jtag_state_sdr	:	out std_logic;
		jtag_state_sdrs	:	out std_logic;
		jtag_state_sir	:	out std_logic;
		jtag_state_sirs	:	out std_logic;
		jtag_state_tlr	:	out std_logic;
		jtag_state_udr	:	out std_logic;
		jtag_state_uir	:	out std_logic;
		tck	:	out std_logic;
		tdi	:	out std_logic;
		tdo	:	in std_logic;
		tms	:	out std_logic;
		virtual_state_cdr	:	out std_logic;
		virtual_state_cir	:	out std_logic;
		virtual_state_e1dr	:	out std_logic;
		virtual_state_e2dr	:	out std_logic;
		virtual_state_pdr	:	out std_logic;
		virtual_state_sdr	:	out std_logic;
		virtual_state_udr	:	out std_logic;
		virtual_state_uir	:	out std_logic
	);
end component;

attribute syn_black_box of sld_virtual_jtag_basic : component is true;

component    lcell
    port    (
        a_out    :        std_logic;
        a_in    :        std_logic
    );
end component; --lcell

attribute syn_black_box of lcell : component is true;
end altera_mf_components;

component    dffe
    port    (
        q    :    out    std_logic;
        ena    :    in    std_logic;
        clk    :    in    std_logic;
        d    :    in    std_logic;
        prn    :    in    std_logic;
        clrn    :    in    std_logic
    );
end component; --dffe

attribute syn_black_box of dffe : component is true;

component    carry_sum
    port    (
        cin    :    in    std_logic;
        sin    :    in    std_logic;
        cout    :    out    std_logic;
        sout    :    out    std_logic
    );
end component; --carry_sum

attribute syn_black_box of carry_sum : component is true;

component    soft
    port    (
        a_out    :        std_logic;
        a_in    :        std_logic
    );
end component; --soft

attribute syn_black_box of soft : component is true;

component    cascade
    port    (
        a_out    :        std_logic;
        a_in    :        std_logic
    );
end component; --cascade

attribute syn_black_box of cascade : component is true;

component    latch
    port    (
        q    :    out    std_logic;
        ena    :    in    std_logic;
        d    :    in    std_logic
    );
end component; --latch

attribute syn_black_box of latch : component is true;

component    TRI
    port    (
        oe    :    in    std_logic;
        a_out    :        std_logic;
        a_in    :        std_logic
    );
end component; --TRI

attribute syn_black_box of TRI : component is true;
--clearbox auto-generated components end
end altera_primitives_components;
