
module parallel_add (
    data,
    clock,
    aclr,
    clken,
    result) /* synthesis syn_black_box=1 */;
    
    parameter width = 4;        // Required
    parameter size = 2;         // Required
    parameter widthr = 4;       // Required
    parameter shift = 0;
    parameter msw_subtract = "NO";  // or "YES"
    parameter representation = "UNSIGNED";
    parameter pipeline = 0;
    parameter result_alignment = "LSB"; // or "MSB"
    parameter lpm_type = "parallel_add";

    input [width*size-1:0] data;  // Required port
    input clock;                // Required port
    input aclr;                 // Default = 0
    input clken;                // Default = 1

    output [widthr-1:0] result;  //Required port


endmodule  // end of PARALLEL_ADD
////clearbox auto-generated components begin
////Dont add any component declarations after this section
//////////////////////////////////////////////////////////////////////////
// altsyncram parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altsyncram	(
	aclr0,
	aclr1,
	address_a,
	address_b,
	addressstall_a,
	addressstall_b,
	byteena_a,
	byteena_b,
	clock0,
	clock1,
	clocken0,
	clocken1,
	data_a,
	data_b,
	q_a,
	q_b,
	rden_b,
	wren_a,
	wren_b) /* synthesis syn_black_box */;

	parameter	address_aclr_a = "UNUSED";
	parameter	address_aclr_b = "NONE";
	parameter	address_reg_b = "CLOCK1";
	parameter	byte_size = 8;
	parameter	byteena_aclr_a = "UNUSED";
	parameter	byteena_aclr_b = "NONE";
	parameter	byteena_reg_b = "CLOCK1";
	parameter	clock_enable_input_a = "NORMAL";
	parameter	clock_enable_input_b = "NORMAL";
	parameter	clock_enable_output_a = "NORMAL";
	parameter	clock_enable_output_b = "NORMAL";
	parameter	intended_device_family = "unused";
	parameter	implement_in_les = "OFF";
	parameter	indata_aclr_a = "UNUSED";
	parameter	indata_aclr_b = "NONE";
	parameter	indata_reg_b = "CLOCK1";
	parameter	init_file = "UNUSED";
	parameter	init_file_layout = "PORT_A";
	parameter	maximum_depth = 0;
	parameter	numwords_a = 0;
	parameter	numwords_b = 0;
	parameter	operation_mode = "BIDIR_DUAL_PORT";
	parameter	outdata_aclr_a = "NONE";
	parameter	outdata_aclr_b = "NONE";
	parameter	outdata_reg_a = "UNREGISTERED";
	parameter	outdata_reg_b = "UNREGISTERED";
	parameter	power_up_uninitialized = "FALSE";
	parameter	ram_block_type = "AUTO";
	parameter	rdcontrol_aclr_b = "NONE";
	parameter	rdcontrol_reg_b = "CLOCK1";
	parameter	read_during_write_mode_mixed_ports = "DONT_CARE";
	parameter	width_a = 1;
	parameter	width_b = 1;
	parameter	width_byteena_a = 1;
	parameter	width_byteena_b = 1;
	parameter	widthad_a = 1;
	parameter	widthad_b = 1;
	parameter	wrcontrol_aclr_a = "UNUSED";
	parameter	wrcontrol_aclr_b = "NONE";
	parameter	wrcontrol_wraddress_reg_b = "CLOCK1";
	parameter	lpm_type = "altsyncram";
	parameter	lpm_hint = "unused";

	input	aclr0;
	input	aclr1;
	input	[widthad_a-1:0]	address_a;
	input	[widthad_b-1:0]	address_b;
	input	addressstall_a;
	input	addressstall_b;
	input	[width_byteena_a-1:0]	byteena_a;
	input	[width_byteena_b-1:0]	byteena_b;
	input	clock0;
	input	clock1;
	input	clocken0;
	input	clocken1;
	input	[width_a-1:0]	data_a;
	input	[width_b-1:0]	data_b;
	output	[width_a-1:0]	q_a;
	output	[width_b-1:0]	q_b;
	input	rden_b;
	input	wren_a;
	input	wren_b;

endmodule //altsyncram

//////////////////////////////////////////////////////////////////////////
// altshift_taps parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altshift_taps	(
	clken,
	clock,
	shiftin,
	shiftout,
	taps) /* synthesis syn_black_box */;

	parameter	intended_device_family = "unused";
	parameter	number_of_taps = 1;
	parameter	power_up_state = "CLEARED";
	parameter	tap_distance = 1;
	parameter	width = 1;
	parameter	lpm_type = "altshift_taps";
	parameter	lpm_hint = "unused";

	input	clken;
	input	clock;
	input	[width-1:0]	shiftin;
	output	[width-1:0]	shiftout;
	output	[width*number_of_taps-1:0]	taps;

endmodule //altshift_taps

//////////////////////////////////////////////////////////////////////////
// altmult_add parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altmult_add	(
	aclr0,
	aclr1,
	aclr2,
	aclr3,
	addnsub1,
	addnsub1_round,
	addnsub3,
	addnsub3_round,
	clock0,
	clock1,
	clock2,
	clock3,
	dataa,
	datab,
	ena0,
	ena1,
	ena2,
	ena3,
	mult01_round,
	mult01_saturation,
	mult0_is_saturated,
	mult1_is_saturated,
	mult23_round,
	mult23_saturation,
	mult2_is_saturated,
	mult3_is_saturated,
	result,
	scanina,
	scaninb,
	scanouta,
	scanoutb,
	signa,
	signb,
	sourcea,
	sourceb) /* synthesis syn_black_box */;

	parameter	adder1_rounding = "NO";
	parameter	adder3_rounding = "NO";
	parameter	addnsub1_round_aclr = "ACLR3";
	parameter	addnsub1_round_pipeline_aclr = "ACLR3";
	parameter	addnsub1_round_pipeline_register = "CLOCK0";
	parameter	addnsub1_round_register = "CLOCK0";
	parameter	addnsub3_round_aclr = "ACLR3";
	parameter	addnsub3_round_pipeline_aclr = "ACLR3";
	parameter	addnsub3_round_pipeline_register = "CLOCK0";
	parameter	addnsub3_round_register = "CLOCK0";
	parameter	addnsub_multiplier_aclr1 = "ACLR3";
	parameter	addnsub_multiplier_aclr3 = "ACLR3";
	parameter	addnsub_multiplier_pipeline_aclr1 = "ACLR3";
	parameter	addnsub_multiplier_pipeline_aclr3 = "ACLR3";
	parameter	addnsub_multiplier_pipeline_register1 = "CLOCK0";
	parameter	addnsub_multiplier_pipeline_register3 = "CLOCK0";
	parameter	addnsub_multiplier_register1 = "CLOCK0";
	parameter	addnsub_multiplier_register3 = "CLOCK0";
	parameter	dedicated_multiplier_circuitry = "AUTO";
	parameter	intended_device_family = "unused";
	parameter	dsp_block_balancing = "Auto";
	parameter	extra_latency = 0;
	parameter	input_aclr_a0 = "ACLR3";
	parameter	input_aclr_a1 = "ACLR3";
	parameter	input_aclr_a2 = "ACLR3";
	parameter	input_aclr_a3 = "ACLR3";
	parameter	input_aclr_b0 = "ACLR3";
	parameter	input_aclr_b1 = "ACLR3";
	parameter	input_aclr_b2 = "ACLR3";
	parameter	input_aclr_b3 = "ACLR3";
	parameter	input_register_a0 = "CLOCK0";
	parameter	input_register_a1 = "CLOCK0";
	parameter	input_register_a2 = "CLOCK0";
	parameter	input_register_a3 = "CLOCK0";
	parameter	input_register_b0 = "CLOCK0";
	parameter	input_register_b1 = "CLOCK0";
	parameter	input_register_b2 = "CLOCK0";
	parameter	input_register_b3 = "CLOCK0";
	parameter	input_source_a0 = "DATAA";
	parameter	input_source_a1 = "DATAA";
	parameter	input_source_a2 = "DATAA";
	parameter	input_source_a3 = "DATAA";
	parameter	input_source_b0 = "DATAB";
	parameter	input_source_b1 = "DATAB";
	parameter	input_source_b2 = "DATAB";
	parameter	input_source_b3 = "DATAB";
	parameter	mult01_round_aclr = "ACLR3";
	parameter	mult01_round_register = "CLOCK0";
	parameter	mult01_saturation_aclr = "ACLR2";
	parameter	mult01_saturation_register = "CLOCK0";
	parameter	mult23_round_aclr = "ACLR3";
	parameter	mult23_round_register = "CLOCK0";
	parameter	mult23_saturation_aclr = "ACLR3";
	parameter	mult23_saturation_register = "CLOCK0";
	parameter	multiplier01_rounding = "NO";
	parameter	multiplier01_saturation = "NO";
	parameter	multiplier1_direction = "ADD";
	parameter	multiplier23_rounding = "NO";
	parameter	multiplier23_saturation = "NO";
	parameter	multiplier3_direction = "ADD";
	parameter	multiplier_aclr0 = "ACLR3";
	parameter	multiplier_aclr1 = "ACLR3";
	parameter	multiplier_aclr2 = "ACLR3";
	parameter	multiplier_aclr3 = "ACLR3";
	parameter	multiplier_register0 = "CLOCK0";
	parameter	multiplier_register1 = "CLOCK0";
	parameter	multiplier_register2 = "CLOCK0";
	parameter	multiplier_register3 = "CLOCK0";
	parameter	number_of_multipliers = 1;
	parameter	output_aclr = "ACLR3";
	parameter	output_register = "CLOCK0";
	parameter	port_addnsub1 = "PORT_CONNECTIVITY";
	parameter	port_addnsub3 = "PORT_CONNECTIVITY";
	parameter	port_mult0_is_saturated = "UNUSED";
	parameter	port_mult1_is_saturated = "UNUSED";
	parameter	port_mult2_is_saturated = "UNUSED";
	parameter	port_mult3_is_saturated = "UNUSED";
	parameter	port_signa = "PORT_CONNECTIVITY";
	parameter	port_signb = "PORT_CONNECTIVITY";
	parameter	representation_a = "UNSIGNED";
	parameter	representation_b = "UNSIGNED";
	parameter	signed_aclr_a = "ACLR3";
	parameter	signed_aclr_b = "ACLR3";
	parameter	signed_pipeline_aclr_a = "ACLR3";
	parameter	signed_pipeline_aclr_b = "ACLR3";
	parameter	signed_pipeline_register_a = "CLOCK0";
	parameter	signed_pipeline_register_b = "CLOCK0";
	parameter	signed_register_a = "CLOCK0";
	parameter	signed_register_b = "CLOCK0";
	parameter	width_a = 1;
	parameter	width_b = 1;
	parameter	width_result = 1;
	parameter	lpm_type = "altmult_add";
	parameter	lpm_hint = "unused";

	input	aclr0;
	input	aclr1;
	input	aclr2;
	input	aclr3;
	input	addnsub1;
	input	addnsub1_round;
	input	addnsub3;
	input	addnsub3_round;
	input	clock0;
	input	clock1;
	input	clock2;
	input	clock3;
	input	[width_a*number_of_multipliers-1:0]	dataa;
	input	[width_b*number_of_multipliers-1:0]	datab;
	input	ena0;
	input	ena1;
	input	ena2;
	input	ena3;
	input	mult01_round;
	input	mult01_saturation;
	output	mult0_is_saturated;
	output	mult1_is_saturated;
	input	mult23_round;
	input	mult23_saturation;
	output	mult2_is_saturated;
	output	mult3_is_saturated;
	output	[width_result-1:0]	result;
	input	[width_a-1:0]	scanina;
	input	[width_b-1:0]	scaninb;
	output	[width_a-1:0]	scanouta;
	output	[width_b-1:0]	scanoutb;
	input	signa;
	input	signb;
	input	[number_of_multipliers-1:0]	sourcea;
	input	[number_of_multipliers-1:0]	sourceb;

endmodule //altmult_add

//////////////////////////////////////////////////////////////////////////
// altmult_accum parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altmult_accum	(
	accum_is_saturated,
	accum_round,
	accum_saturation,
	accum_sload,
	accum_sload_upper_data,
	aclr0,
	aclr1,
	aclr2,
	aclr3,
	addnsub,
	clock0,
	clock1,
	clock2,
	clock3,
	dataa,
	datab,
	ena0,
	ena1,
	ena2,
	ena3,
	mult_is_saturated,
	mult_round,
	mult_saturation,
	overflow,
	result,
	scanina,
	scaninb,
	scanouta,
	scanoutb,
	signa,
	signb,
	sourcea,
	sourceb) /* synthesis syn_black_box */;

	parameter	accum_direction = "ADD";
	parameter	accum_round_aclr = "ACLR3";
	parameter	accum_round_pipeline_aclr = "ACLR3";
	parameter	accum_round_pipeline_reg = "CLOCK0";
	parameter	accum_round_reg = "CLOCK0";
	parameter	accum_saturation_aclr = "ACLR3";
	parameter	accum_saturation_pipeline_aclr = "ACLR3";
	parameter	accum_saturation_pipeline_reg = "CLOCK0";
	parameter	accum_saturation_reg = "CLOCK0";
	parameter	accum_sload_aclr = "ACLR3";
	parameter	accum_sload_pipeline_aclr = "ACLR3";
	parameter	accum_sload_pipeline_reg = "CLOCK0";
	parameter	accum_sload_reg = "CLOCK0";
	parameter	accum_sload_upper_data_aclr = "ACLR3";
	parameter	accum_sload_upper_data_pipeline_aclr = "ACLR3";
	parameter	accum_sload_upper_data_pipeline_reg = "CLOCK0";
	parameter	accum_sload_upper_data_reg = "CLOCK0";
	parameter	accumulator_rounding = "NO";
	parameter	accumulator_saturation = "NO";
	parameter	addnsub_aclr = "ACLR3";
	parameter	addnsub_pipeline_aclr = "ACLR3";
	parameter	addnsub_pipeline_reg = "CLOCK0";
	parameter	addnsub_reg = "CLOCK0";
	parameter	dedicated_multiplier_circuitry = "AUTO";
	parameter	intended_device_family = "unused";
	parameter	dsp_block_balancing = "Auto";
	parameter	extra_accumulator_latency = 0;
	parameter	extra_multiplier_latency = 0;
	parameter	input_aclr_a = "ACLR3";
	parameter	input_aclr_b = "ACLR3";
	parameter	input_reg_a = "CLOCK0";
	parameter	input_reg_b = "CLOCK0";
	parameter	input_source_a = "DATAA";
	parameter	input_source_b = "DATAB";
	parameter	mult_round_aclr = "ACLR3";
	parameter	mult_round_reg = "CLOCK0";
	parameter	mult_saturation_aclr = "ACLR3";
	parameter	mult_saturation_reg = "CLOCK0";
	parameter	multiplier_aclr = "ACLR3";
	parameter	multiplier_reg = "CLOCK0";
	parameter	multiplier_rounding = "NO";
	parameter	multiplier_saturation = "NO";
	parameter	output_aclr = "ACLR3";
	parameter	output_reg = "CLOCK0";
	parameter	port_accum_is_saturated = "UNUSED";
	parameter	port_addnsub = "PORT_CONNECTIVITY";
	parameter	port_mult_is_saturated = "UNUSED";
	parameter	port_signa = "PORT_CONNECTIVITY";
	parameter	port_signb = "PORT_CONNECTIVITY";
	parameter	representation_a = "UNSIGNED";
	parameter	representation_b = "UNSIGNED";
	parameter	sign_aclr_a = "ACLR3";
	parameter	sign_aclr_b = "ACLR3";
	parameter	sign_pipeline_aclr_a = "ACLR3";
	parameter	sign_pipeline_aclr_b = "ACLR3";
	parameter	sign_pipeline_reg_a = "CLOCK0";
	parameter	sign_pipeline_reg_b = "CLOCK0";
	parameter	sign_reg_a = "CLOCK0";
	parameter	sign_reg_b = "CLOCK0";
	parameter	width_a = 1;
	parameter	width_b = 1;
	parameter	width_result = 1;
	parameter	width_upper_data = 1;
	parameter	lpm_type = "altmult_accum";
	parameter	lpm_hint = "unused";

	output	accum_is_saturated;
	input	accum_round;
	input	accum_saturation;
	input	accum_sload;
	input	[width_upper_data-1:0]	accum_sload_upper_data;
	input	aclr0;
	input	aclr1;
	input	aclr2;
	input	aclr3;
	input	addnsub;
	input	clock0;
	input	clock1;
	input	clock2;
	input	clock3;
	input	[width_a-1:0]	dataa;
	input	[width_b-1:0]	datab;
	input	ena0;
	input	ena1;
	input	ena2;
	input	ena3;
	output	mult_is_saturated;
	input	mult_round;
	input	mult_saturation;
	output	overflow;
	output	[width_result-1:0]	result;
	input	[width_a-1:0]	scanina;
	input	[width_b-1:0]	scaninb;
	output	[width_a-1:0]	scanouta;
	output	[width_b-1:0]	scanoutb;
	input	signa;
	input	signb;
	input	sourcea;
	input	sourceb;

endmodule //altmult_accum

//////////////////////////////////////////////////////////////////////////
// altaccumulate parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altaccumulate	(
	aclr,
	add_sub,
	cin,
	clken,
	clock,
	cout,
	data,
	overflow,
	result,
	sign_data,
	sload) /* synthesis syn_black_box */;

	parameter	carry_chain = "MANUAL";
	parameter	carry_chain_length = 32;
	parameter	intended_device_family = "unused";
	parameter	extra_latency = 0;
	parameter	lpm_representation = "UNSIGNED";
	parameter	right_shift_distance = 0;
	parameter	use_wys = "ON";
	parameter	width_in = 1;
	parameter	width_out = 1;
	parameter	lpm_type = "altaccumulate";
	parameter	lpm_hint = "unused";

	input	aclr;
	input	add_sub;
	input	cin;
	input	clken;
	input	clock;
	output	cout;
	input	[width_in-1:0]	data;
	output	overflow;
	output	[width_out-1:0]	result;
	input	sign_data;
	input	sload;

endmodule //altaccumulate

//////////////////////////////////////////////////////////////////////////
// dcfifo parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	dcfifo	(
	aclr,
	data,
	q,
	rdclk,
	rdempty,
	rdfull,
	rdreq,
	rdusedw,
	wrclk,
	wrempty,
	wrfull,
	wrreq,
	wrusedw) /* synthesis syn_black_box */;

	parameter	add_ram_output_register = "OFF";
	parameter	clocks_are_synchronized = "FALSE";
	parameter	delay_rdusedw = 1;
	parameter	delay_wrusedw = 1;
	parameter	intended_device_family = "unused";
	parameter	lpm_numwords = 1;
	parameter	lpm_showahead = "OFF";
	parameter	lpm_width = 1;
	parameter	lpm_widthu = 1;
	parameter	overflow_checking = "ON";
	parameter	rdsync_delaypipe = 3;
	parameter	underflow_checking = "ON";
	parameter	use_eab = "ON";
	parameter	wrsync_delaypipe = 3;
	parameter	lpm_type = "dcfifo";
	parameter	lpm_hint = "unused";

	input	aclr;
	input	[lpm_width-1:0]	data;
	output	[lpm_width-1:0]	q;
	input	rdclk;
	output	rdempty;
	output	rdfull;
	input	rdreq;
	output	[lpm_widthu-1:0]	rdusedw;
	input	wrclk;
	output	wrempty;
	output	wrfull;
	input	wrreq;
	output	[lpm_widthu-1:0]	wrusedw;

endmodule //dcfifo

//////////////////////////////////////////////////////////////////////////
// scfifo parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	scfifo	(
	aclr,
	almost_empty,
	almost_full,
	clock,
	data,
	empty,
	full,
	q,
	rdreq,
	sclr,
	usedw,
	wrreq) /* synthesis syn_black_box */;

	parameter	add_ram_output_register = "OFF";
	parameter	allow_rwcycle_when_full = "OFF";
	parameter	almost_empty_value = 0;
	parameter	almost_full_value = 0;
	parameter	intended_device_family = "unused";
	parameter	lpm_numwords = 1;
	parameter	lpm_showahead = "OFF";
	parameter	lpm_width = 1;
	parameter	lpm_widthu = 1;
	parameter	overflow_checking = "ON";
	parameter	underflow_checking = "ON";
	parameter	use_eab = "ON";
	parameter	lpm_type = "scfifo";
	parameter	lpm_hint = "unused";

	input	aclr;
	output	almost_empty;
	output	almost_full;
	input	clock;
	input	[lpm_width-1:0]	data;
	output	empty;
	output	full;
	output	[lpm_width-1:0]	q;
	input	rdreq;
	input	sclr;
	output	[lpm_widthu-1:0]	usedw;
	input	wrreq;

endmodule //scfifo

//////////////////////////////////////////////////////////////////////////
// altfp_mult parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altfp_mult	(
	aclr,
	clk_en,
	clock,
	dataa,
	datab,
	denormal,
	indefinite,
	nan,
	overflow,
	result,
	underflow,
	zero) /* synthesis syn_black_box */;

	parameter	dedicated_multiplier_circuitry = "AUTO";
	parameter	intended_device_family = "unused";
	parameter	pipeline = 5;
	parameter	reduced_functionality = "NO";
	parameter	width_exp = 8;
	parameter	width_man = 23;
	parameter	lpm_type = "altfp_mult";
	parameter	lpm_hint = "unused";

	input	aclr;
	input	clk_en;
	input	clock;
	input	[width_exp+width_man+1-1:0]	dataa;
	input	[width_exp+width_man+1-1:0]	datab;
	output	denormal;
	output	indefinite;
	output	nan;
	output	overflow;
	output	[width_exp+width_man+1-1:0]	result;
	output	underflow;
	output	zero;

endmodule //altfp_mult

//////////////////////////////////////////////////////////////////////////
// altdpram parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altdpram	(
	aclr,
	data,
	inclock,
	inclocken,
	outclock,
	outclocken,
	q,
	rdaddress,
	rden,
	wraddress,
	wren) /* synthesis syn_black_box */;

	parameter	intended_device_family = "unused";
	parameter	indata_aclr = "ON";
	parameter	indata_reg = "INCLOCK";
	parameter	lpm_file = "UNUSED";
	parameter	maximum_depth = 0;
	parameter	numwords = 0;
	parameter	outdata_aclr = "ON";
	parameter	outdata_reg = "UNREGISTERED";
	parameter	rdaddress_aclr = "ON";
	parameter	rdaddress_reg = "OUTCLOCK";
	parameter	rdcontrol_aclr = "ON";
	parameter	rdcontrol_reg = "OUTCLOCK";
	parameter	use_eab = "ON";
	parameter	width = 1;
	parameter	widthad = 1;
	parameter	wraddress_aclr = "ON";
	parameter	wraddress_reg = "INCLOCK";
	parameter	wrcontrol_aclr = "ON";
	parameter	wrcontrol_reg = "INCLOCK";
	parameter	lpm_type = "altdpram";
	parameter	lpm_hint = "unused";

	input	aclr;
	input	[width-1:0]	data;
	input	inclock;
	input	inclocken;
	input	outclock;
	input	outclocken;
	output	[width-1:0]	q;
	input	[widthad-1:0]	rdaddress;
	input	rden;
	input	[widthad-1:0]	wraddress;
	input	wren;

endmodule //altdpram

//////////////////////////////////////////////////////////////////////////
// altddio_in parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altddio_in	(
	aclr,
	aset,
	datain,
	dataout_h,
	dataout_l,
	inclock,
	inclocken) /* synthesis syn_black_box */;

	parameter	intended_device_family = "unused";
	parameter	implement_input_in_lcell = "ON";
	parameter	invert_input_clocks = "OFF";
	parameter	power_up_high = "OFF";
	parameter	width = 1;
	parameter	lpm_type = "altddio_in";
	parameter	lpm_hint = "unused";

	input	aclr;
	input	aset;
	input	[width-1:0]	datain;
	output	[width-1:0]	dataout_h;
	output	[width-1:0]	dataout_l;
	input	inclock;
	input	inclocken;

endmodule //altddio_in

//////////////////////////////////////////////////////////////////////////
// altddio_out parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altddio_out	(
	aclr,
	aset,
	datain_h,
	datain_l,
	dataout,
	oe,
	outclock,
	outclocken) /* synthesis syn_black_box */;

	parameter	intended_device_family = "unused";
	parameter	extend_oe_disable = "OFF";
	parameter	invert_output = "OFF";
	parameter	oe_reg = "UNREGISTERED";
	parameter	power_up_high = "OFF";
	parameter	width = 1;
	parameter	lpm_type = "altddio_out";
	parameter	lpm_hint = "unused";

	input	aclr;
	input	aset;
	input	[width-1:0]	datain_h;
	input	[width-1:0]	datain_l;
	output	[width-1:0]	dataout;
	input	oe;
	input	outclock;
	input	outclocken;

endmodule //altddio_out

//////////////////////////////////////////////////////////////////////////
// altddio_bidir parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altddio_bidir	(
	aclr,
	aset,
	combout,
	datain_h,
	datain_l,
	dataout_h,
	dataout_l,
	dqsundelayedout,
	inclock,
	inclocken,
	oe,
	outclock,
	outclocken,
	padio) /* synthesis syn_black_box */;

	parameter	intended_device_family = "unused";
	parameter	extend_oe_disable = "OFF";
	parameter	implement_input_in_lcell = "OFF";
	parameter	invert_output = "OFF";
	parameter	oe_reg = "UNREGISTERED";
	parameter	power_up_high = "OFF";
	parameter	width = 1;
	parameter	lpm_type = "altddio_bidir";
	parameter	lpm_hint = "unused";

	input	aclr;
	input	aset;
	output	[width-1:0]	combout;
	input	[width-1:0]	datain_h;
	input	[width-1:0]	datain_l;
	output	[width-1:0]	dataout_h;
	output	[width-1:0]	dataout_l;
	output	[width-1:0]	dqsundelayedout;
	input	inclock;
	input	inclocken;
	input	oe;
	input	outclock;
	input	outclocken;
	inout	[width-1:0]	padio;

endmodule //altddio_bidir

//////////////////////////////////////////////////////////////////////////
// altlvds_rx parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altlvds_rx	(
	pll_areset,
	rx_cda_max,
	rx_cda_reset,
	rx_channel_data_align,
	rx_coreclk,
	rx_data_align,
	rx_deskew,
	rx_dpa_locked,
	rx_dpll_enable,
	rx_dpll_hold,
	rx_dpll_reset,
	rx_enable,
	rx_fifo_reset,
	rx_in,
	rx_inclock,
	rx_locked,
	rx_out,
	rx_outclock,
	rx_pll_enable,
	rx_reset) /* synthesis syn_black_box */;

	parameter	cds_mode = "UNUSED";
	parameter	common_rx_tx_pll = "ON";
	parameter	data_align_rollover = 4;
	parameter	deserialization_factor = 4;
	parameter	intended_device_family = "unused";
	parameter	dpll_lock_count = 0;
	parameter	dpll_lock_window = 0;
	parameter	enable_dpa_fifo = "OFF";
	parameter	enable_dpa_mode = "OFF";
	parameter	implement_in_les = "OFF";
	parameter	inclock_boost = 0;
	parameter	inclock_data_alignment = "EDGE_ALIGNED";
	parameter	inclock_period = 0;
	parameter	input_data_rate = 0;
	parameter	lose_lock_on_one_change = "OFF";
	parameter	number_of_channels = 1;
	parameter	outclock_resource = "AUTO";
	parameter	pll_operation_mode = "NORMAL";
	parameter	port_rx_data_align = "PORT_CONNECTIVITY";
	parameter	registered_data_align_input = "ON";
	parameter	registered_output = "ON";
	parameter	reset_fifo_at_first_lock = "ON";
	parameter	use_coreclock_input = "OFF";
	parameter	use_dpll_rawperror = "OFF";
	parameter	use_external_pll = "OFF";
	parameter	lpm_type = "altlvds_rx";
	parameter	lpm_hint = "unused";

	input	pll_areset;
	output	[number_of_channels-1:0]	rx_cda_max;
	input	[number_of_channels-1:0]	rx_cda_reset;
	input	[number_of_channels-1:0]	rx_channel_data_align;
	input	[number_of_channels-1:0]	rx_coreclk;
	input	rx_data_align;
	input	rx_deskew;
	output	[number_of_channels-1:0]	rx_dpa_locked;
	input	[number_of_channels-1:0]	rx_dpll_enable;
	input	[number_of_channels-1:0]	rx_dpll_hold;
	input	[number_of_channels-1:0]	rx_dpll_reset;
	input	rx_enable;
	input	[number_of_channels-1:0]	rx_fifo_reset;
	input	[number_of_channels-1:0]	rx_in;
	input	rx_inclock;
	output	rx_locked;
	output	[deserialization_factor*number_of_channels-1:0]	rx_out;
	output	rx_outclock;
	input	rx_pll_enable;
	input	[number_of_channels-1:0]	rx_reset;

endmodule //altlvds_rx

//////////////////////////////////////////////////////////////////////////
// altlvds_tx parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	altlvds_tx	(
	pll_areset,
	sync_inclock,
	tx_coreclock,
	tx_enable,
	tx_in,
	tx_inclock,
	tx_locked,
	tx_out,
	tx_outclock,
	tx_pll_enable) /* synthesis syn_black_box */;

	parameter	center_align_msb = "UNUSED";
	parameter	common_rx_tx_pll = "ON";
	parameter	coreclock_divide_by = 2;
	parameter	deserialization_factor = 4;
	parameter	intended_device_family = "unused";
	parameter	differential_drive = 0;
	parameter	implement_in_les = "OFF";
	parameter	inclock_boost = 0;
	parameter	inclock_data_alignment = "EDGE_ALIGNED";
	parameter	inclock_period = 0;
	parameter	multi_clock = "OFF";
	parameter	number_of_channels = 1;
	parameter	outclock_alignment = "EDGE_ALIGNED";
	parameter	outclock_divide_by = 1;
	parameter	outclock_multiply_by = 1;
	parameter	outclock_resource = "AUTO";
	parameter	output_data_rate = 0;
	parameter	preemphasis_setting = 0;
	parameter	registered_input = "ON";
	parameter	use_external_pll = "OFF";
	parameter	vod_setting = 0;
	parameter	lpm_type = "altlvds_tx";
	parameter	lpm_hint = "unused";

	input	pll_areset;
	input	sync_inclock;
	output	tx_coreclock;
	input	tx_enable;
	input	[deserialization_factor*number_of_channels-1:0]	tx_in;
	input	tx_inclock;
	output	tx_locked;
	output	[number_of_channels-1:0]	tx_out;
	output	tx_outclock;
	input	tx_pll_enable;

endmodule //altlvds_tx

//////////////////////////////////////////////////////////////////////////
// alt_mac_mult parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	alt_mac_mult	(
	aclr,
	clk,
	dataa,
	datab,
	dataout,
	ena,
	round,
	saturate,
	scanina,
	scaninb,
	scanouta,
	scanoutb,
	signa,
	signb,
	sourcea,
	sourceb) /* synthesis syn_black_box */;

	parameter	bypass_multiplier = "NO";
	parameter	dataa_clear = "NONE";
	parameter	dataa_clock = "NONE";
	parameter	dataa_width = 1;
	parameter	datab_clear = "NONE";
	parameter	datab_clock = "NONE";
	parameter	datab_width = 1;
	parameter	dynamic_scan_chain_supported = "NO";
	parameter	extra_output_clear = "NONE";
	parameter	extra_output_clock = "NONE";
	parameter	extra_signa_clear = "NONE";
	parameter	extra_signa_clock = "NONE";
	parameter	extra_signb_clear = "NONE";
	parameter	extra_signb_clock = "NONE";
	parameter	mult_clear = "NONE";
	parameter	mult_clock = "NONE";
	parameter	mult_input_a_is_constant = "NO";
	parameter	mult_input_b_is_constant = "NO";
	parameter	mult_maximize_speed = 5;
	parameter	mult_pipeline = 0;
	parameter	mult_representation_a = "VARIABLE";
	parameter	mult_representation_b = "VARIABLE";
	parameter	output_clear = "NONE";
	parameter	output_clock = "NONE";
	parameter	output_width = 1;
	parameter	round_clear = "NONE";
	parameter	round_clock = "NONE";
	parameter	saturate_clear = "NONE";
	parameter	saturate_clock = "NONE";
	parameter	signa_clear = "NONE";
	parameter	signa_clock = "NONE";
	parameter	signb_clear = "NONE";
	parameter	signb_clock = "NONE";
	parameter	using_rounding = "NO";
	parameter	using_saturation = "NO";
	parameter	lpm_type = "alt_mac_mult";
	parameter	lpm_hint = "unused";

	input	[3:0]	aclr;
	input	[3:0]	clk;
	input	[dataa_width-1:0]	dataa;
	input	[datab_width-1:0]	datab;
	output	[output_width-1:0]	dataout;
	input	[3:0]	ena;
	input	round;
	input	saturate;
	input	[dataa_width-1:0]	scanina;
	input	[datab_width-1:0]	scaninb;
	output	[dataa_width-1:0]	scanouta;
	output	[datab_width-1:0]	scanoutb;
	input	signa;
	input	signb;
	input	sourcea;
	input	sourceb;

endmodule //alt_mac_mult

//////////////////////////////////////////////////////////////////////////
// alt_mac_out parameterized megafunction component declaration
// Generated with 'clearbox' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module	alt_mac_out	(
	accoverflow,
	aclr,
	addnsub0,
	addnsub1,
	clk,
	dataa,
	datab,
	datac,
	datad,
	dataout,
	ena,
	mode0,
	mode1,
	multabsaturate,
	multcdsaturate,
	round0,
	round1,
	saturate,
	saturate1,
	signa,
	signb,
	zeroacc,
	zeroacc1) /* synthesis syn_black_box */;

	parameter	addnsub0_clear = "NONE";
	parameter	addnsub0_clock = "NONE";
	parameter	addnsub0_pipeline_clear = "NONE";
	parameter	addnsub0_pipeline_clock = "NONE";
	parameter	addnsub1_clear = "NONE";
	parameter	addnsub1_clock = "NONE";
	parameter	addnsub1_pipeline_clear = "NONE";
	parameter	addnsub1_pipeline_clock = "NONE";
	parameter	dataa_forced_to_zero = "NO";
	parameter	dataa_width = 1;
	parameter	datab_width = 1;
	parameter	datac_forced_to_zero = "NO";
	parameter	datac_width = 1;
	parameter	datad_width = 1;
	parameter	loadable_accum_supported = "NO";
	parameter	mode0_clear = "NONE";
	parameter	mode0_clock = "NONE";
	parameter	mode0_pipeline_clear = "NONE";
	parameter	mode0_pipeline_clock = "NONE";
	parameter	mode1_clear = "NONE";
	parameter	mode1_clock = "NONE";
	parameter	mode1_pipeline_clear = "NONE";
	parameter	mode1_pipeline_clock = "NONE";
	parameter	multabsaturate_clear = "NONE";
	parameter	multabsaturate_clock = "NONE";
	parameter	multabsaturate_pipeline_clear = "NONE";
	parameter	multabsaturate_pipeline_clock = "NONE";
	parameter	multcdsaturate_clear = "NONE";
	parameter	multcdsaturate_clock = "NONE";
	parameter	multcdsaturate_pipeline_clear = "NONE";
	parameter	multcdsaturate_pipeline_clock = "NONE";
	parameter	operation_mode = "unused";
	parameter	output_clear = "NONE";
	parameter	output_clock = "NONE";
	parameter	output_width = 1;
	parameter	round0_clear = "NONE";
	parameter	round0_clock = "NONE";
	parameter	round0_pipeline_clear = "NONE";
	parameter	round0_pipeline_clock = "NONE";
	parameter	round1_clear = "NONE";
	parameter	round1_clock = "NONE";
	parameter	round1_pipeline_clear = "NONE";
	parameter	round1_pipeline_clock = "NONE";
	parameter	saturate_clear = "NONE";
	parameter	saturate_clock = "NONE";
	parameter	saturate_pipeline_clear = "NONE";
	parameter	saturate_pipeline_clock = "NONE";
	parameter	signa_clear = "NONE";
	parameter	signa_clock = "NONE";
	parameter	signa_pipeline_clear = "NONE";
	parameter	signa_pipeline_clock = "NONE";
	parameter	signb_clear = "NONE";
	parameter	signb_clock = "NONE";
	parameter	signb_pipeline_clear = "NONE";
	parameter	signb_pipeline_clock = "NONE";
	parameter	using_loadable_accum = "NO";
	parameter	using_mult_saturation = "NO";
	parameter	using_rounding = "NO";
	parameter	using_saturation = "NO";
	parameter	zeroacc_clear = "NONE";
	parameter	zeroacc_clock = "NONE";
	parameter	zeroacc_pipeline_clear = "NONE";
	parameter	zeroacc_pipeline_clock = "NONE";
	parameter	lpm_type = "alt_mac_out";
	parameter	lpm_hint = "unused";

	output	accoverflow;
	input	[3:0]	aclr;
	input	addnsub0;
	input	addnsub1;
	input	[3:0]	clk;
	input	[dataa_width-1:0]	dataa;
	input	[datab_width-1:0]	datab;
	input	[datac_width-1:0]	datac;
	input	[datad_width-1:0]	datad;
	output	[output_width-1:0]	dataout;
	input	[3:0]	ena;
	input	mode0;
	input	mode1;
	input	multabsaturate;
	input	multcdsaturate;
	input	round0;
	input	round1;
	input	saturate;
	input	saturate1;
	input	signa;
	input	signb;
	input	zeroacc;
	input	zeroacc1;

endmodule //alt_mac_out

//////////////////////////////////////////////////////////////////////////
// altcam parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module altcam(
	inaclr,
	inclock,
	inclocken,
	maddress,
	mbits,
	mcount,
	mfound,
	mnext,
	mstart,
	outaclr,
	outclock,
	outclocken,
	pattern,
	rdbusy,
	wraddress,
	wrbusy,
	wrdelete,
	wren,
	wrx,
	wrxused) /* synthesis syn_black_box=1 */;

	parameter	intended_device_family = "unused";
	parameter	lpm_file = "UNUSED";
	parameter	lpm_filex = "UNUSED";
	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "altcam";
	parameter	match_mode = "MULTIPLE";
	parameter	numwords = 0;
	parameter	output_aclr = "ON";
	parameter	output_reg = "UNREGISTERED";
	parameter	pattern_aclr = "ON";
	parameter	pattern_reg = "INCLOCK";
	parameter	register_odd_match = "OFF";
	parameter	use_eab = "ON";
	parameter	use_wysiwyg = "ON";
	parameter	width = 1;
	parameter	widthad = 1;
	parameter	wraddress_aclr = "ON";
	parameter	wrcontrol_aclr = "ON";
	parameter	wrx_aclr = "ON";
	parameter	wrx_reg = "INCLOCK";


	input	inaclr;
	input	inclock;
	input	inclocken;
	output	[widthad-1:0]	maddress;
	output	[numwords-1:0]	mbits;
	output	[widthad-1:0]	mcount;
	output	mfound;
	input	mnext;
	input	mstart;
	input	outaclr;
	input	outclock;
	input	outclocken;
	input	[width-1:0]	pattern;
	output	rdbusy;
	input	[widthad-1:0]	wraddress;
	output	wrbusy;
	input	wrdelete;
	input	wren;
	input	[width-1:0]	wrx;
	input	wrxused;

endmodule // altcam

//////////////////////////////////////////////////////////////////////////
// altclklock parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module altclklock(
	clock0,
	clock1,
	clock2,
	clock_ext,
	fbin,
	inclock,
	inclocken,
	locked) /* synthesis syn_black_box=1 */;

	parameter	clock0_boost = 1;
	parameter	clock0_divide = 1;
	parameter	clock0_settings = "UNUSED";
	parameter	clock0_time_delay = 0;
	parameter	clock1_boost = 1;
	parameter	clock1_divide = 1;
	parameter	clock1_settings = "UNUSED";
	parameter	clock1_time_delay = 0;
	parameter	clock2_boost = 1;
	parameter	clock2_divide = 1;
	parameter	clock2_settings = "UNUSED";
	parameter	clock2_time_delay = 0;
	parameter	clock_ext_boost = 1;
	parameter	clock_ext_divide = 1;
	parameter	clock_ext_settings = "UNUSED";
	parameter	clock_ext_time_delay = 0;
	parameter	inclock_period = 10000;
	parameter	inclock_settings = "UNUSED";
	parameter	intended_device_family = "UNUSED";
	parameter	invalid_lock_cycles = 5;
	parameter	invalid_lock_multiplier = 5;
	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "altclklock";
	parameter	operation_mode = "UNUSED";
	parameter	outclock_phase_shift = 0;
	parameter	valid_lock_cycles = 5;
	parameter	valid_lock_multiplier = 5;


	output	clock0;
	output	clock1;
	output	clock2;
	output	clock_ext;
	input	fbin;
	input	inclock;
	input	inclocken;
	output	locked;

endmodule // altclklock

//////////////////////////////////////////////////////////////////////////
// altpll parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module altpll(
	activeclock,
	areset,
	clk,
	clkbad,
	clkena,
	clkloss,
	clkswitch,
	enable0,
	enable1,
	extclk,
	extclkena,
	fbin,
	inclk,
	locked,
	pfdena,
	pllena,
	scanaclr,
	scanclk,
	scandata,
	scandataout,
	scandone,
	scanread,
	scanwrite,
	sclkout0,
	sclkout1) /* synthesis syn_black_box=1 */;

	parameter	bandwidth = 0;
	parameter	bandwidth_type = "AUTO";
	parameter	c0_high = 0;
	parameter	c0_initial = 0;
	parameter	c0_low = 0;
	parameter	c0_mode = "BYPASS";
	parameter	c0_ph = 0;
	parameter	c0_test_source = 5;
	parameter	c1_high = 0;
	parameter	c1_initial = 0;
	parameter	c1_low = 0;
	parameter	c1_mode = "BYPASS";
	parameter	c1_ph = 0;
	parameter	c1_test_source = 5;
	parameter	c1_use_casc_in = "0";
	parameter	c2_high = 0;
	parameter	c2_initial = 0;
	parameter	c2_low = 0;
	parameter	c2_mode = "BYPASS";
	parameter	c2_ph = 0;
	parameter	c2_test_source = 5;
	parameter	c2_use_casc_in = "0";
	parameter	c3_high = 0;
	parameter	c3_initial = 0;
	parameter	c3_low = 0;
	parameter	c3_mode = "BYPASS";
	parameter	c3_ph = 0;
	parameter	c3_test_source = 5;
	parameter	c3_use_casc_in = "0";
	parameter	c4_high = 0;
	parameter	c4_initial = 0;
	parameter	c4_low = 0;
	parameter	c4_mode = "BYPASS";
	parameter	c4_ph = 0;
	parameter	c4_test_source = 5;
	parameter	c4_use_casc_in = "0";
	parameter	c5_high = 0;
	parameter	c5_initial = 0;
	parameter	c5_low = 0;
	parameter	c5_mode = "BYPASS";
	parameter	c5_ph = 0;
	parameter	c5_test_source = 5;
	parameter	c5_use_casc_in = "0";
	parameter	charge_pump_current = 2;
	parameter	clk0_counter = "G0";
	parameter	clk0_divide_by = 1;
	parameter	clk0_duty_cycle = 50;
	parameter	clk0_multiply_by = 1;
	parameter	clk0_output_frequency = 0;
	parameter	clk0_phase_shift = "0";
	parameter	clk0_time_delay = "0";
	parameter	clk1_counter = "G0";
	parameter	clk1_divide_by = 1;
	parameter	clk1_duty_cycle = 50;
	parameter	clk1_multiply_by = 1;
	parameter	clk1_output_frequency = 0;
	parameter	clk1_phase_shift = "0";
	parameter	clk1_time_delay = "0";
	parameter	clk2_counter = "G0";
	parameter	clk2_divide_by = 1;
	parameter	clk2_duty_cycle = 50;
	parameter	clk2_multiply_by = 1;
	parameter	clk2_output_frequency = 0;
	parameter	clk2_phase_shift = "0";
	parameter	clk2_time_delay = "0";
	parameter	clk3_counter = "G0";
	parameter	clk3_divide_by = 1;
	parameter	clk3_duty_cycle = 50;
	parameter	clk3_multiply_by = 1;
	parameter	clk3_phase_shift = "0";
	parameter	clk3_time_delay = "0";
	parameter	clk4_counter = "G0";
	parameter	clk4_divide_by = 1;
	parameter	clk4_duty_cycle = 50;
	parameter	clk4_multiply_by = 1;
	parameter	clk4_phase_shift = "0";
	parameter	clk4_time_delay = "0";
	parameter	clk5_counter = "G0";
	parameter	clk5_divide_by = 1;
	parameter	clk5_duty_cycle = 50;
	parameter	clk5_multiply_by = 1;
	parameter	clk5_phase_shift = "0";
	parameter	clk5_time_delay = "0";
	parameter	compensate_clock = "CLK0";
	parameter	down_spread = "0";
	parameter	e0_high = 1;
	parameter	e0_initial = 1;
	parameter	e0_low = 1;
	parameter	e0_mode = "BYPASS";
	parameter	e0_ph = 0;
	parameter	e0_time_delay = 0;
	parameter	e1_high = 1;
	parameter	e1_initial = 1;
	parameter	e1_low = 1;
	parameter	e1_mode = "BYPASS";
	parameter	e1_ph = 0;
	parameter	e1_time_delay = 0;
	parameter	e2_high = 1;
	parameter	e2_initial = 1;
	parameter	e2_low = 1;
	parameter	e2_mode = "BYPASS";
	parameter	e2_ph = 0;
	parameter	e2_time_delay = 0;
	parameter	e3_high = 1;
	parameter	e3_initial = 1;
	parameter	e3_low = 1;
	parameter	e3_mode = "BYPASS";
	parameter	e3_ph = 0;
	parameter	e3_time_delay = 0;
	parameter	enable0_counter = "L0";
	parameter	enable1_counter = "L0";
	parameter	enable_switch_over_counter = "OFF";
	parameter	extclk0_counter = "E0";
	parameter	extclk0_divide_by = 1;
	parameter	extclk0_duty_cycle = 50;
	parameter	extclk0_multiply_by = 1;
	parameter	extclk0_phase_shift = "0";
	parameter	extclk0_time_delay = "0";
	parameter	extclk1_counter = "E1";
	parameter	extclk1_divide_by = 1;
	parameter	extclk1_duty_cycle = 50;
	parameter	extclk1_multiply_by = 1;
	parameter	extclk1_phase_shift = "0";
	parameter	extclk1_time_delay = "0";
	parameter	extclk2_counter = "E2";
	parameter	extclk2_divide_by = 1;
	parameter	extclk2_duty_cycle = 50;
	parameter	extclk2_multiply_by = 1;
	parameter	extclk2_phase_shift = "0";
	parameter	extclk2_time_delay = "0";
	parameter	extclk3_counter = "E3";
	parameter	extclk3_divide_by = 1;
	parameter	extclk3_duty_cycle = 50;
	parameter	extclk3_multiply_by = 1;
	parameter	extclk3_phase_shift = "0";
	parameter	extclk3_time_delay = "0";
	parameter	feedback_source = "EXTCLK0";
	parameter	g0_high = 1;
	parameter	g0_initial = 1;
	parameter	g0_low = 1;
	parameter	g0_mode = "BYPASS";
	parameter	g0_ph = 0;
	parameter	g0_time_delay = 0;
	parameter	g1_high = 1;
	parameter	g1_initial = 1;
	parameter	g1_low = 1;
	parameter	g1_mode = "BYPASS";
	parameter	g1_ph = 0;
	parameter	g1_time_delay = 0;
	parameter	g2_high = 1;
	parameter	g2_initial = 1;
	parameter	g2_low = 1;
	parameter	g2_mode = "BYPASS";
	parameter	g2_ph = 0;
	parameter	g2_time_delay = 0;
	parameter	g3_high = 1;
	parameter	g3_initial = 1;
	parameter	g3_low = 1;
	parameter	g3_mode = "BYPASS";
	parameter	g3_ph = 0;
	parameter	g3_time_delay = 0;
	parameter	gate_lock_counter = 0;
	parameter	gate_lock_signal = "NO";
	parameter	inclk0_input_frequency = 1;
	parameter	inclk1_input_frequency = 0;
	parameter	intended_device_family = "NONE";
	parameter	invalid_lock_multiplier = 5;
	parameter	l0_high = 1;
	parameter	l0_initial = 1;
	parameter	l0_low = 1;
	parameter	l0_mode = "BYPASS";
	parameter	l0_ph = 0;
	parameter	l0_time_delay = 0;
	parameter	l1_high = 1;
	parameter	l1_initial = 1;
	parameter	l1_low = 1;
	parameter	l1_mode = "BYPASS";
	parameter	l1_ph = 0;
	parameter	l1_time_delay = 0;
	parameter	lock_high = 1;
	parameter	lock_low = 1;
	parameter	loop_filter_c = 5;
	parameter	loop_filter_r = "1.000000";
	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "altpll";
	parameter	m = 0;
	parameter	m2 = 1;
	parameter	m_initial = 0;
	parameter	m_ph = 0;
	parameter	m_test_source = 5;
	parameter	m_time_delay = 0;
	parameter	n = 1;
	parameter	n2 = 1;
	parameter	n_time_delay = 0;
	parameter	operation_mode = "unused";
	parameter	pfd_max = 0;
	parameter	pfd_min = 0;
	parameter	pll_type = "AUTO";
	parameter	port_activeclock = "PORT_CONNECTIVITY";
	parameter	port_areset = "PORT_CONNECTIVITY";
	parameter	port_clk0 = "PORT_CONNECTIVITY";
	parameter	port_clk1 = "PORT_CONNECTIVITY";
	parameter	port_clk2 = "PORT_CONNECTIVITY";
	parameter	port_clk3 = "PORT_CONNECTIVITY";
	parameter	port_clk4 = "PORT_CONNECTIVITY";
	parameter	port_clk5 = "PORT_CONNECTIVITY";
	parameter	port_clkbad0 = "PORT_CONNECTIVITY";
	parameter	port_clkbad1 = "PORT_CONNECTIVITY";
	parameter	port_clkena0 = "PORT_CONNECTIVITY";
	parameter	port_clkena1 = "PORT_CONNECTIVITY";
	parameter	port_clkena2 = "PORT_CONNECTIVITY";
	parameter	port_clkena3 = "PORT_CONNECTIVITY";
	parameter	port_clkena4 = "PORT_CONNECTIVITY";
	parameter	port_clkena5 = "PORT_CONNECTIVITY";
	parameter	port_clkloss = "PORT_CONNECTIVITY";
	parameter	port_clkswitch = "PORT_CONNECTIVITY";
	parameter	port_enable0 = "PORT_CONNECTIVITY";
	parameter	port_enable1 = "PORT_CONNECTIVITY";
	parameter	port_extclk0 = "PORT_CONNECTIVITY";
	parameter	port_extclk1 = "PORT_CONNECTIVITY";
	parameter	port_extclk2 = "PORT_CONNECTIVITY";
	parameter	port_extclk3 = "PORT_CONNECTIVITY";
	parameter	port_extclkena0 = "PORT_CONNECTIVITY";
	parameter	port_extclkena1 = "PORT_CONNECTIVITY";
	parameter	port_extclkena2 = "PORT_CONNECTIVITY";
	parameter	port_extclkena3 = "PORT_CONNECTIVITY";
	parameter	port_fbin = "PORT_CONNECTIVITY";
	parameter	port_inclk0 = "PORT_CONNECTIVITY";
	parameter	port_inclk1 = "PORT_CONNECTIVITY";
	parameter	port_locked = "PORT_CONNECTIVITY";
	parameter	port_pfdena = "PORT_CONNECTIVITY";
	parameter	port_pllena = "PORT_CONNECTIVITY";
	parameter	port_scanaclr = "PORT_CONNECTIVITY";
	parameter	port_scanclk = "PORT_CONNECTIVITY";
	parameter	port_scandata = "PORT_CONNECTIVITY";
	parameter	port_scandataout = "PORT_CONNECTIVITY";
	parameter	port_scandone = "PORT_CONNECTIVITY";
	parameter	port_scanread = "PORT_CONNECTIVITY";
	parameter	port_scanwrite = "PORT_CONNECTIVITY";
	parameter	port_sclkout0 = "PORT_CONNECTIVITY";
	parameter	port_sclkout1 = "PORT_CONNECTIVITY";
	parameter	primary_clock = "INCLK0";
	parameter	qualify_conf_done = "OFF";
	parameter	scan_chain = "LONG";
	parameter	sclkout0_phase_shift = "0";
	parameter	sclkout1_phase_shift = "0";
	parameter	self_reset_on_gated_loss_lock = "OFF";
	parameter	skip_vco = "OFF";
	parameter	spread_frequency = 0;
	parameter	ss = 1;
	parameter	switch_over_counter = 0;
	parameter	switch_over_on_gated_lock = "OFF";
	parameter	switch_over_on_lossclk = "OFF";
	parameter	switch_over_type = "AUTO";
	parameter	valid_lock_multiplier = 1;
	parameter	vco_center = 0;
	parameter	vco_divide_by = 0;
	parameter	vco_max = 0;
	parameter	vco_min = 0;
	parameter	vco_multiply_by = 0;
	parameter	vco_post_scale = 0;


	output	activeclock;
	input	areset;
	output	[5:0]	clk;
	output	[1:0]	clkbad;
	input	[5:0]	clkena;
	output	clkloss;
	input	clkswitch;
	output	enable0;
	output	enable1;
	output	[3:0]	extclk;
	input	[3:0]	extclkena;
	input	fbin;
	input	[1:0]	inclk;
	output	locked;
	input	pfdena;
	input	pllena;
	input	scanaclr;
	input	scanclk;
	input	scandata;
	output	scandataout;
	output	scandone;
	input	scanread;
	input	scanwrite;
	output	sclkout0;
	output	sclkout1;

endmodule // altpll

//////////////////////////////////////////////////////////////////////////
// alt3pram parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module alt3pram(
	aclr,
	data,
	inclock,
	inclocken,
	outclock,
	outclocken,
	qa,
	qb,
	rdaddress_a,
	rdaddress_b,
	rden_a,
	rden_b,
	wraddress,
	wren) /* synthesis syn_black_box=1 */;

	parameter	indata_aclr = "ON";
	parameter	indata_reg = "INCLOCK";
	parameter	intended_device_family = "unused";
	parameter	lpm_file = "UNUSED";
	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "alt3pram";
	parameter	numwords = 0;
	parameter	outdata_aclr_a = "ON";
	parameter	outdata_aclr_b = "ON";
	parameter	outdata_reg_a = "OUTCLOCK";
	parameter	outdata_reg_b = "OUTCLOCK";
	parameter	rdaddress_aclr_a = "ON";
	parameter	rdaddress_aclr_b = "ON";
	parameter	rdaddress_reg_a = "INCLOCK";
	parameter	rdaddress_reg_b = "INCLOCK";
	parameter	rdcontrol_aclr_a = "ON";
	parameter	rdcontrol_aclr_b = "ON";
	parameter	rdcontrol_reg_a = "INCLOCK";
	parameter	rdcontrol_reg_b = "INCLOCK";
	parameter	use_eab = "ON";
	parameter	width = 1;
	parameter	widthad = 1;
	parameter	write_aclr = "ON";
	parameter	write_reg = "INCLOCK";


	input	aclr;
	input	[width-1:0]	data;
	input	inclock;
	input	inclocken;
	input	outclock;
	input	outclocken;
	output	[width-1:0]	qa;
	output	[width-1:0]	qb;
	input	[widthad-1:0]	rdaddress_a;
	input	[widthad-1:0]	rdaddress_b;
	input	rden_a;
	input	rden_b;
	input	[widthad-1:0]	wraddress;
	input	wren;

endmodule // alt3pram

//////////////////////////////////////////////////////////////////////////
// altqpram parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module altqpram(
	data_a,
	data_b,
	inaclr_a,
	inaclr_b,
	inclock_a,
	inclock_b,
	inclocken_a,
	inclocken_b,
	outaclr_a,
	outaclr_b,
	outclock_a,
	outclock_b,
	outclocken_a,
	outclocken_b,
	q_a,
	q_b,
	rdaddress_a,
	rdaddress_b,
	rden_a,
	rden_b,
	wraddress_a,
	wraddress_b,
	wren_a,
	wren_b) /* synthesis syn_black_box=1 */;

	parameter	cascade_chain = "unused";
	parameter	indata_aclr_a = "INACLR_A";
	parameter	indata_aclr_b = "INACLR_B";
	parameter	indata_reg_a = "INCLOCK_A";
	parameter	indata_reg_b = "INCLOCK_B";
	parameter	init_file = "UNUSED";
	parameter	intended_device_family = "unused";
	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "altqpram";
	parameter	maximum_depth = 4096;
	parameter	numwords_read_a = 1;
	parameter	numwords_read_b = 1;
	parameter	numwords_write_a = 1;
	parameter	numwords_write_b = 1;
	parameter	operation_mode = "QUAD_PORT";
	parameter	outdata_aclr_a = "OUTACLR_A";
	parameter	outdata_aclr_b = "OUTACLR_B";
	parameter	outdata_reg_a = "UNREGISTERED";
	parameter	outdata_reg_b = "UNREGISTERED";
	parameter	rdaddress_aclr_a = "OUTACLR_A";
	parameter	rdaddress_aclr_b = "OUTACLR_B";
	parameter	rdaddress_reg_a = "OUTCLOCK_A";
	parameter	rdaddress_reg_b = "OUTCLOCK_B";
	parameter	rdcontrol_aclr_a = "OUTACLR_A";
	parameter	rdcontrol_aclr_b = "OUTACLR_B";
	parameter	rdcontrol_reg_a = "OUTCLOCK_A";
	parameter	rdcontrol_reg_b = "OUTCLOCK_B";
	parameter	suppress_memory_conversion_warnings = "OFF";
	parameter	width_read_a = 1;
	parameter	width_read_b = 1;
	parameter	width_write_a = 1;
	parameter	width_write_b = 1;
	parameter	widthad_read_a = 1;
	parameter	widthad_read_b = 1;
	parameter	widthad_write_a = 1;
	parameter	widthad_write_b = 1;
	parameter	wraddress_aclr_a = "INACLR_A";
	parameter	wraddress_aclr_b = "INACLR_B";
	parameter	wrcontrol_aclr_a = "INACLR_A";
	parameter	wrcontrol_aclr_b = "INACLR_B";
	parameter	wrcontrol_wraddress_reg_a = "INCLOCK_A";
	parameter	wrcontrol_wraddress_reg_b = "INCLOCK_B";


	input	[width_write_a-1:0]	data_a;
	input	[width_write_b-1:0]	data_b;
	input	inaclr_a;
	input	inaclr_b;
	input	inclock_a;
	input	inclock_b;
	input	inclocken_a;
	input	inclocken_b;
	input	outaclr_a;
	input	outaclr_b;
	input	outclock_a;
	input	outclock_b;
	input	outclocken_a;
	input	outclocken_b;
	output	[width_read_a-1:0]	q_a;
	output	[width_read_b-1:0]	q_b;
	input	[widthad_read_a-1:0]	rdaddress_a;
	input	[widthad_read_b-1:0]	rdaddress_b;
	input	rden_a;
	input	rden_b;
	input	[widthad_write_a-1:0]	wraddress_a;
	input	[widthad_write_b-1:0]	wraddress_b;
	input	wren_a;
	input	wren_b;

endmodule // altqpram

//////////////////////////////////////////////////////////////////////////
// altcdr_rx parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module altcdr_rx(
	rx_aclr,
	rx_coreclock,
	rx_empty,
	rx_fifo_rden,
	rx_full,
	rx_in,
	rx_inclock,
	rx_locklost,
	rx_out,
	rx_outclock,
	rx_pll_aclr,
	rx_pll_locked,
	rx_rec_clk,
	rx_rlv) /* synthesis syn_black_box=1 */;

	parameter	bypass_fifo = "OFF";
	parameter	deserialization_factor = 1;
	parameter	inclock_boost = 0;
	parameter	inclock_period = 1;
	parameter	intended_device_family = "MERCURY";
	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "altcdr_rx";
	parameter	number_of_channels = 1;
	parameter	run_length = 62;


	input	rx_aclr;
	input	rx_coreclock;
	output	[number_of_channels-1:0]	rx_empty;
	input	[number_of_channels-1:0]	rx_fifo_rden;
	output	[number_of_channels-1:0]	rx_full;
	input	[number_of_channels-1:0]	rx_in;
	input	rx_inclock;
	output	[number_of_channels-1:0]	rx_locklost;
	output	[deserialization_factor*number_of_channels-1:0]	rx_out;
	output	rx_outclock;
	input	rx_pll_aclr;
	output	rx_pll_locked;
	output	[number_of_channels-1:0]	rx_rec_clk;
	output	[number_of_channels-1:0]	rx_rlv;

endmodule // altcdr_rx

//////////////////////////////////////////////////////////////////////////
// altcdr_tx parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module altcdr_tx(
	tx_aclr,
	tx_coreclock,
	tx_empty,
	tx_fifo_wren,
	tx_full,
	tx_in,
	tx_inclock,
	tx_out,
	tx_outclock,
	tx_pll_aclr,
	tx_pll_locked) /* synthesis syn_black_box=1 */;

	parameter	bypass_fifo = "OFF";
	parameter	deserialization_factor = 1;
	parameter	inclock_boost = 0;
	parameter	inclock_period = 1;
	parameter	intended_device_family = "MERCURY";
	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "altcdr_tx";
	parameter	number_of_channels = 1;


	input	tx_aclr;
	input	tx_coreclock;
	output	[number_of_channels-1:0]	tx_empty;
	input	[number_of_channels-1:0]	tx_fifo_wren;
	output	[number_of_channels-1:0]	tx_full;
	input	[deserialization_factor*number_of_channels-1:0]	tx_in;
	input	tx_inclock;
	output	[number_of_channels-1:0]	tx_out;
	output	tx_outclock;
	input	tx_pll_aclr;
	output	tx_pll_locked;

endmodule // altcdr_tx

//////////////////////////////////////////////////////////////////////////
// altsqrt parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module altsqrt(
	aclr,
	clk,
	ena,
	q,
	radical,
	remainder) /* synthesis syn_black_box=1 */;

	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "altsqrt";
	parameter	pipeline = 0;
	parameter	q_port_width = 1;
	parameter	r_port_width = 1;
	parameter	width = 1;


	input	aclr;
	input	clk;
	input	ena;
	output	[q_port_width-1:0]	q;
	input	[width-1:0]	radical;
	output	[r_port_width-1:0]	remainder;

endmodule // altsqrt

//////////////////////////////////////////////////////////////////////////
// sld_virtual_jtag parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module sld_virtual_jtag(
	ir_in,
	ir_out,
	jtag_state_cdr,
	jtag_state_cir,
	jtag_state_e1dr,
	jtag_state_e1ir,
	jtag_state_e2dr,
	jtag_state_e2ir,
	jtag_state_pdr,
	jtag_state_pir,
	jtag_state_rti,
	jtag_state_sdr,
	jtag_state_sdrs,
	jtag_state_sir,
	jtag_state_sirs,
	jtag_state_tlr,
	jtag_state_udr,
	jtag_state_uir,
	tck,
	tdi,
	tdo,
	tms,
	virtual_state_cdr,
	virtual_state_cir,
	virtual_state_e1dr,
	virtual_state_e2dr,
	virtual_state_pdr,
	virtual_state_sdr,
	virtual_state_udr,
	virtual_state_uir) /* synthesis syn_black_box=1 */;

	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "sld_virtual_jtag";
	parameter	sld_auto_instance_index = "NO";
	parameter	sld_instance_index = 0;
	parameter	sld_ir_width = 1;
	parameter	sld_sim_action = "UNUSED";
	parameter	sld_sim_n_scan = 0;
	parameter	sld_sim_total_length = 0;


	output	[sld_ir_width-1:0]	ir_in;
	input	[sld_ir_width-1:0]	ir_out;
	output	jtag_state_cdr;
	output	jtag_state_cir;
	output	jtag_state_e1dr;
	output	jtag_state_e1ir;
	output	jtag_state_e2dr;
	output	jtag_state_e2ir;
	output	jtag_state_pdr;
	output	jtag_state_pir;
	output	jtag_state_rti;
	output	jtag_state_sdr;
	output	jtag_state_sdrs;
	output	jtag_state_sir;
	output	jtag_state_sirs;
	output	jtag_state_tlr;
	output	jtag_state_udr;
	output	jtag_state_uir;
	output	tck;
	output	tdi;
	input	tdo;
	output	tms;
	output	virtual_state_cdr;
	output	virtual_state_cir;
	output	virtual_state_e1dr;
	output	virtual_state_e2dr;
	output	virtual_state_pdr;
	output	virtual_state_sdr;
	output	virtual_state_udr;
	output	virtual_state_uir;

endmodule // sld_virtual_jtag

//////////////////////////////////////////////////////////////////////////
// sld_virtual_jtag_basic parameterized megafunction component declaration
// Generated with 'mega_defn_creator' loader - do not edit
//////////////////////////////////////////////////////////////////////////
module sld_virtual_jtag_basic(
	ir_in,
	ir_out,
	jtag_state_cdr,
	jtag_state_cir,
	jtag_state_e1dr,
	jtag_state_e1ir,
	jtag_state_e2dr,
	jtag_state_e2ir,
	jtag_state_pdr,
	jtag_state_pir,
	jtag_state_rti,
	jtag_state_sdr,
	jtag_state_sdrs,
	jtag_state_sir,
	jtag_state_sirs,
	jtag_state_tlr,
	jtag_state_udr,
	jtag_state_uir,
	tck,
	tdi,
	tdo,
	tms,
	virtual_state_cdr,
	virtual_state_cir,
	virtual_state_e1dr,
	virtual_state_e2dr,
	virtual_state_pdr,
	virtual_state_sdr,
	virtual_state_udr,
	virtual_state_uir) /* synthesis syn_black_box=1 */;

	parameter	lpm_hint = "UNUSED";
	parameter	lpm_type = "sld_virtual_jtag_basic";
	parameter	sld_auto_instance_index = "NO";
	parameter	sld_instance_index = 0;
	parameter	sld_ir_width = 1;
	parameter	sld_mfg_id = 0;
	parameter	sld_sim_action = "UNUSED";
	parameter	sld_sim_n_scan = 0;
	parameter	sld_sim_total_length = 0;
	parameter	sld_type_id = 0;
	parameter	sld_version = 0;


	output	[sld_ir_width-1:0]	ir_in;
	input	[sld_ir_width-1:0]	ir_out;
	output	jtag_state_cdr;
	output	jtag_state_cir;
	output	jtag_state_e1dr;
	output	jtag_state_e1ir;
	output	jtag_state_e2dr;
	output	jtag_state_e2ir;
	output	jtag_state_pdr;
	output	jtag_state_pir;
	output	jtag_state_rti;
	output	jtag_state_sdr;
	output	jtag_state_sdrs;
	output	jtag_state_sir;
	output	jtag_state_sirs;
	output	jtag_state_tlr;
	output	jtag_state_udr;
	output	jtag_state_uir;
	output	tck;
	output	tdi;
	input	tdo;
	output	tms;
	output	virtual_state_cdr;
	output	virtual_state_cir;
	output	virtual_state_e1dr;
	output	virtual_state_e2dr;
	output	virtual_state_pdr;
	output	virtual_state_sdr;
	output	virtual_state_udr;
	output	virtual_state_uir;

endmodule // sld_virtual_jtag_basic

module    lcell    (
    out,
    in);



    output    out;
    input    in;

endmodule //lcell

module    dffe    (
    q,
    ena,
    clk,
    d,
    prn,
    clrn);



    output    q;
    input    ena;
    input    clk;
    input    d;
    input    prn;
    input    clrn;

endmodule //dffe

module    carry_sum    (
    cin,
    sin,
    cout,
    sout);



    input    cin;
    input    sin;
    output    cout;
    output    sout;

endmodule //carry_sum

module    soft    (
    out,
    in);



    output    out;
    input    in;

endmodule //soft

module    cascade    (
    out,
    in);



    output    out;
    input    in;

endmodule //cascade

module    latch    (
    q,
    ena,
    d);



    output    q;
    input    ena;
    input    d;

endmodule //latch

module    TRI    (
    oe,
    out,
    in);



    input    oe;
    output    out;
    input    in;

endmodule //TRI

////clearbox auto-generated components end
