// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


`timescale 1 ps/1 ps

module  mercury_lcell (clk, dataa, datab, datac, datad, aclr, aload,
                      sclr, sload, ena, apre, cin, cin0, cin1,
                      multsela, multselb, 
                      modesel, pathsel,
                      combout, regout, cout, cout0, cout1, multout) ;

input  clk, dataa, datab, datac, datad, ena, multsela, multselb ;
input  apre, aclr, aload, sclr, sload, cin, cin0, cin1;
input [7:0] modesel;
input [11:0] pathsel;
output cout, cout0, cout1, regout, combout, multout ;
wire dffin;

mercury_asynch_lcell lecomb (.dataa(dataa), .datab(datab), .datac(datac), 
									  .datad(datad), .cin(cin), .cin0(cin0), .cin1(cin1),
									   .modesel(modesel), .pathsel(pathsel), .multsela(multsela),
										.multselb(multselb), .multdataa(dataa), 
										.multdatab(datab), .combout(combout), 
										.regin(dffin), .cout(cout), .cout0(cout0), 
										.cout1(cout1), .multout(multout));


mercury_lcell_register lereg (.clk(clk), .apre(apre), .aclr(aclr), 
										.aload(aload), .sclr(sclr), .modesel(modesel), .sload(sload), 
										.ena(ena), .datain(dffin), .datac(datac),
										.regout(regout));


endmodule

module mercury_io(datain, ddiodatain, oe, outclk, outclkena, oeclkena, inclk, inclkena, areset,
	modesel, padio, combout, regout, ddioregout);

	inout		padio;
	input		datain, ddiodatain, oe, outclk, outclkena, oeclkena, inclk, inclkena, areset;
	input		[32:0] modesel;
 	output		combout, regout, ddioregout;
	
	wire	tmp_oe_reg_out, tmp_input_reg_out, tmp_output_reg_out; 
	
	wire   	tmp_padio, tmp_combout;
	
	wire	tri_in,  tri_in_new;  // temp result before outputing to padio
	
	wire	od_output;  // open_drain_output mode
	
	wire	in_reg_clr, in_reg_preset, in_reg_sel;
	
	wire	oe_reg_clr, oe_reg_preset, oe_reg_sel;
	
	wire	out_reg_clr, out_reg_preset, out_reg_sel;
	
	wire	input_or_bidir, output_or_bidir, input_not_reg, output_not_reg, oe_not_reg;
	wire	ddio_non_inv, ddio_none, ddio_none_and_reg_sel;
	
	wire	input_reg_pu_low, output_reg_pu_low, oe_reg_pu_low;
	
	wire	tmp_datain;
	wire	b_latch_out, pmuxout, poutmux2, poutmux3, outclk_delayed;
	wire	iareset, iinclkena, ioutclkena, ioeclkena;
	wire	orz, decidez1, decidez2;

	wire	inclkena;
	wire	outclkena;
	wire	oeclkena;
	
	assign iinclkena = inclkena;
	assign ioutclkena =  outclkena;
	assign ioeclkena = oeclkena;
	
	OR2 or2_1 ( .Y(output_or_bidir), .IN1(modesel[1]), .IN2(modesel[2]));
	//assign output_or_bidir = (operation_mode == "output") || (operation_mode == "bidir");

	OR2 or2_2 ( .Y(input_or_bidir), .IN1(modesel[0]), .IN2(modesel[2]));
	//assign input_or_bidir = (operation_mode == "input") || (operation_mode == "bidir");

	OR2 or2_3 ( .Y(ddio_none_inv), .IN1(modesel[3]), .IN2(modesel[4]));
	INV inv_or2_3 ( .Y(ddio_none), .IN1(ddio_none_inv));

	AND2 and2_1 ( .Y(input_not_reg), .IN1(modesel[0]), .IN2(modesel[27]));
	//assign	input_not_reg = ( operation_mode == "input" && input_register_mode == "none" ) ? 'b1 : 'b0 ;
	AND2 and2_2 ( .Y(output_not_reg), .IN1(modesel[1]), .IN2(modesel[11]));
	//assign	output_not_reg = ( operation_mode == "output" && output_register_mode == "none" ) ? 'b1 : 'b0 ;
	AND2 and2_3 ( .Y(oe_not_reg), .IN1(output_or_bidir), .IN2(modesel[19]));
	//assign	oe_not_reg = ( output_or_bidir && oe_register_mode == "none") ? 'b1 : 'b0;
	
	INV inv_1 ( .Y(input_reg_pu_low), .IN1(modesel[32]));
	//assign input_reg_pu_low = ( input_power_up == "low") ? 'b0 : 'b1;

	INV inv_2 ( .Y(output_reg_pu_low), .IN1(modesel[16]));
	//assign output_reg_pu_low = ( output_power_up == "low") ? 'b0 : 'b1;

	INV inv_3 ( .Y(oe_reg_pu_low), .IN1(modesel[24]));
	//assign oe_reg_pu_low = ( oe_power_up == "low") ? 'b0 : 'b1;
	
	assign  out_reg_sel = modesel[9];
	//assign  out_reg_sel = (output_register_mode == "register" ) ? 'b1 : 'b0;

	assign oe_reg_sel = modesel[17];
	//assign	oe_reg_sel = ( oe_register_mode == "register" ) ? 'b1 : 'b0;

	assign in_reg_sel = modesel[25];
	//assign  in_reg_sel = ( input_register_mode == "register") ? 'b1 : 'b0;
	 
	INV inv_4 ( .Y(iareset), .IN1(areset));
	//assign	iareset = ( areset === 'b0 || areset === 'b1 ) ? !areset : 'b1;

	// output registered
	mux21 mux21_1 ( .MO(out_reg_clr), .B(iareset), .A(1'b1), .S(modesel[12]));
	//assign out_reg_clr = (output_reset == "clear") ? iareset : 'b1;


	mux21 mux21_2 ( .MO(out_reg_preset), .B(iareset), .A(1'b1), .S(modesel[13]));
	//assign out_reg_preset = ( output_reset == "preset") ? iareset : 'b1;

	// oe register

	mux21 mux21_3 ( .MO(oe_reg_clr), .B(iareset), .A(1'b1), .S(modesel[20]));
	//assign oe_reg_clr = ( oe_reset == "clear") ? iareset : 'b1;

	mux21 mux21_4 ( .MO(oe_reg_preset), .B(iareset), .A(1'b1), .S(modesel[21]));
	//assign oe_reg_preset = ( oe_reset == "preset") ? iareset : 'b1;

	// input register
	mux21 mux21_5 ( .MO(in_reg_clr), .B(iareset), .A(1'b1), .S(modesel[28]));
	//assign in_reg_clr = ( input_reset == "clear") ? iareset : 'b1;

	mux21 mux21_6 ( .MO(in_reg_preset), .B(iareset), .A(1'b1), .S(modesel[29]));
	//assign in_reg_preset = ( input_reset == "preset") ? iareset : 'b1;
	
	LATCHP b_latch (.D (padio),
                       .ENA (inclk),
                       .PRE (in_reg_clr),
                       .Q (b_latch_out)
                      );
	// both of below muxes together implement this logic -
	//assign oe_reg_data = (ddio_mode == "none") ? oe : (ddio_mode == "output") ? ddiodatain : b_latch_out;
	mux21 mux21_7 ( .MO(oe_reg_data), .B(ddiodatain), .A(pmuxout), .S(modesel[4]));
	//assign oe_reg_data = ( ddio_mode == "output") ? ddiodatain : pmuxout;

	mux21 mux21_8 ( .MO(pmuxout), .B(b_latch_out), .A(oe), .S(modesel[3]));
	//assign pmuxout = ( ddio== input ) ? b_latch_out : oe;

	dffe	input_reg (.Q(tmp_input_reg_out), .CLK(inclk), .ENA(iinclkena), .D(padio), .CLRN(in_reg_clr), .PRN(in_reg_preset));
	
	dffe    output_reg (.Q(tmp_output_reg_out), .CLK(outclk), .ENA(ioutclkena), .D(datain), .CLRN(out_reg_clr), .PRN(out_reg_preset));

	//below 3 muxes together implement this logic-
	//assign tmp_datain = (ddio_mode == "output") ? ddio_data : ((operation_mode == "output" || operation_mode == "bidir") ? (out_reg_sel == 'b1 ? tmp_output_reg_out : datain) : 'b0);

	mux21 out_mux1(.MO(tmp_datain), .B(ddio_data), .A(poutmux2), .S(modesel[4]));
	mux21 out_mux2(.MO(poutmux2), .B(poutmux3), .A(1'b0), .S(output_or_bidir));
	mux21 out_mux3(.MO(poutmux3), .B(tmp_output_reg_out), .A(datain), .S(out_reg_sel));

	dffe    oe_reg (.Q(tmp_oe_reg_out), .CLK(outclk), .ENA(ioeclkena), .D(oe_reg_data), .CLRN(oe_reg_clr), .PRN(oe_reg_preset));

	mux21	oe_mux(.MO(oe_out), .A(oe), .B(tmp_oe_reg_out), .S(ddio_none_and_reg_sel));
	AND2    and2_oe_mux ( .Y(ddio_none_and_reg_sel), .IN1(ddio_none), .IN2(oe_reg_sel));

	AND1    seldelaybuf (.Y(outclk_delayed), .IN1(outclk));

	mux21   ddio_data_mux (.MO (ddio_data),
                               .A (tmp_oe_reg_out),
                               .B (tmp_output_reg_out),
                               .S (outclk_delayed)
                              );

	// timing info in case output and/or input are not registered.
	mercury_asynch_io	mercury_pin(.datain(tmp_datain), .oe(oe_out), .modesel(modesel), .oeregQ(oeregQ), .inregQ(tmp_input_reg_out), .padio(padio), .combout(combout), .regout(regout), .ddioregout(ddioregout));

	mux21	oeregqmux(.MO(oeregQ), .A(1'b0), .B(tmp_oe_reg_out), .S(modesel[3]));

endmodule



///////////////////////////////////////////////////////////////////////////////
//
// MERCURY RAM ATOM
//
///////////////////////////////////////////////////////////////////////////////

module mercury_ram_block (portadatain, portaclk0, portaclk1, portaclr0, portaclr1,
                       portaena0, portaena1, portawe, portare, portaraddr,
                       portawaddr, portadataout,
                       portbdatain, portbclk0, portbclk1, portbclr0, portbclr1,
                       portbena0, portbena1, portbwe, portbre, portbraddr,
                       portbwaddr, portbdataout,
                       portamodesel, portbmodesel);

    input  [15:0] portadatain;
    input  portaclk0, portaclk1, portaclr0, portaclr1;
    input  portaena0, portaena1, portawe, portare;
    input  [15:0] portaraddr, portawaddr;
    input  [15:0] portbdatain;
    input  portbclk0, portbclk1, portbclr0, portbclr1;
    input  portbena0, portbena1, portbwe, portbre;
    input  [15:0] portbraddr, portbwaddr;
    input  [20:0] portamodesel;
    input  [20:0] portbmodesel;
    output [15:0] portadataout;
    output [15:0] portbdataout;

// 'sel' wires for porta

   wire  portadatain_reg_sel, portadatain_reg_clr_sel;
   wire  portawrite_reg_sel, portawe_clr_sel;
   wire  portawaddr_clr_sel;
   wire  [1:0] portaraddr_clr_sel, portare_clr_sel;
   wire  [1:0] portaraddr_clk_sel, portare_clk_sel;
   wire  [1:0] portadataout_clk_sel;
   wire  [1:0] portadataout_clr_sel;
   wire  portaraddr_en_sel, portare_en_sel;
   wire  portadataout_en_sel;

// registered wires for porta

   wire  [15:0] portadatain_reg, portadataout_reg;
   wire  portawe_reg, portare_reg;
   wire  [15:0] portaraddr_reg, portawaddr_reg;

   wire  [15:0] portadatain_int, portadataout_int;
   wire  [15:0] portaraddr_int, portawaddr_int;
   wire  portawe_int, portare_int;

// 'clr' wires for porta

   wire  portadatain_reg_clr, portadinreg_clr;
   wire  portawe_reg_clr, portawereg_clr;
   wire  portawaddr_reg_clr, portawaddrreg_clr;
   wire  portare_reg_clr, portarereg_clr;
   wire  portaraddr_reg_clr, portaraddrreg_clr;
   wire  portadataout_reg_clr, portadataoutreg_clr;

// 'ena' wires for porta

   wire  portareen, portaraddren, portadataouten;

// 'clk' wires for porta

   wire  portare_clk, portare_clr;
   wire  portaraddr_clk, portaraddr_clr;
   wire  portadataout_clk, portadataout_clr;

// other wires

   wire  portawe_reg_mux, portawe_reg_mux_delayed;
   wire  portawe_pulse;
   wire  [15:0] portadataout_tmp;
   wire  portavalid_addr;

// 'sel' wires for portb

   wire  portbdatain_reg_sel, portbdatain_reg_clr_sel;
   wire  portbwrite_reg_sel, portbwe_clr_sel;
   wire  portbwaddr_clr_sel;
   wire  [1:0] portbraddr_clr_sel, portbre_clr_sel;
   wire  [1:0] portbraddr_clk_sel, portbre_clk_sel;
   wire  [1:0] portbdataout_clk_sel;
   wire  [1:0] portbdataout_clr_sel;
   wire  portbraddr_en_sel, portbre_en_sel;
   wire  portbdataout_en_sel;

// registered wires for portb

   wire  [15:0] portbdatain_reg, portbdataout_reg;
   wire  portbwe_reg, portbre_reg;
   wire  [15:0] portbraddr_reg, portbwaddr_reg;

   wire  [15:0] portbdatain_int, portbdataout_int;
   wire  [15:0] portbraddr_int, portbwaddr_int;
   wire  portbwe_int, portbre_int;

// 'clr' wires for portb

   wire  portbdatain_reg_clr, portbdinreg_clr;
   wire  portbwe_reg_clr, portbwereg_clr;
   wire  portbwaddr_reg_clr, portbwaddrreg_clr;
   wire  portbre_reg_clr, portbrereg_clr;
   wire  portbraddr_reg_clr, portbraddrreg_clr;
   wire  portbdataout_reg_clr, portbdataoutreg_clr;

// 'ena' wires for portb

   wire  portbreen, portbraddren, portbdataouten;

// 'clk' wires for portb

   wire  portbre_clk, portbre_clr;
   wire  portbraddr_clk, portbraddr_clr;
   wire  portbdataout_clk, portbdataout_clr;

// other wires

   wire  portbwe_reg_mux, portbwe_reg_mux_delayed;
   wire  portbwe_pulse;
   wire  [15:0] portbdataout_tmp;
   wire  portbvalid_addr;

   wire  NC;
	assign NC = 1'b0;

	 wire re;

     assign portadatain_reg_sel		= portamodesel[0];
     assign portadatain_reg_clr_sel	= portamodesel[1];

     assign portawrite_reg_sel		= portamodesel[2];
     assign portawe_clr_sel		= portamodesel[3];
     assign portawaddr_clr_sel		= portamodesel[4];

     assign portaraddr_clk_sel[0]	= portamodesel[5];
     assign portaraddr_clr_sel[0]	= portamodesel[6];

     assign portare_clk_sel[0]		= portamodesel[7];
     assign portare_clr_sel[0]		= portamodesel[8];

     assign portadataout_clk_sel[0]	= portamodesel[9];
     assign portadataout_clr_sel[0]	= portamodesel[10];

     assign portare_clk_sel[1]		= portamodesel[11];
     assign portare_en_sel		= portamodesel[11];
     assign portare_clr_sel[1]		= portamodesel[12];

     assign portaraddr_clk_sel[1]	= portamodesel[13];
     assign portaraddr_en_sel		= portamodesel[13];
     assign portaraddr_clr_sel[1]	= portamodesel[14];

     assign portadataout_clk_sel[1]	= portamodesel[15];
     assign portadataout_en_sel		= portamodesel[15];
     assign portadataout_clr_sel[1]	= portamodesel[16];

     assign portbdatain_reg_sel		= portbmodesel[0];
     assign portbdatain_reg_clr_sel	= portbmodesel[1];

     assign portbwrite_reg_sel		= portbmodesel[2];
     assign portbwe_clr_sel		= portbmodesel[3];
     assign portbwaddr_clr_sel		= portbmodesel[4];

     assign portbraddr_clk_sel[0]	= portbmodesel[5];
     assign portbraddr_clr_sel[0]	= portbmodesel[6];

     assign portbre_clk_sel[0]		= portbmodesel[7];
     assign portbre_clr_sel[0]		= portbmodesel[8];

     assign portbdataout_clk_sel[0]	= portbmodesel[9];
     assign portbdataout_clr_sel[0]	= portbmodesel[10];

     assign portbre_clk_sel[1]		= portbmodesel[11];
     assign portbre_en_sel		= portbmodesel[11];
     assign portbre_clr_sel[1]		= portbmodesel[12];

     assign portbraddr_clk_sel[1]	= portbmodesel[13];
     assign portbraddr_en_sel		= portbmodesel[13];
     assign portbraddr_clr_sel[1]	= portbmodesel[14];

     assign portbdataout_clk_sel[1]	= portbmodesel[15];
     assign portbdataout_en_sel		= portbmodesel[15];
     assign portbdataout_clr_sel[1]	= portbmodesel[16];


// PORT A registers

nmux21 	portadatainregclr (.MO(portadatain_reg_clr), .A(NC), .B(portaclr0), .S(portadatain_reg_clr_sel));
dffe	portadinreg_0 (.Q(portadatain_reg[0]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[0]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_1 (.Q(portadatain_reg[1]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[1]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_2 (.Q(portadatain_reg[2]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[2]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_3 (.Q(portadatain_reg[3]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[3]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_4 (.Q(portadatain_reg[4]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[4]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_5 (.Q(portadatain_reg[5]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[5]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_6 (.Q(portadatain_reg[6]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[6]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_7 (.Q(portadatain_reg[7]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[7]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_8 (.Q(portadatain_reg[8]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[8]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_9 (.Q(portadatain_reg[9]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[9]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_10 (.Q(portadatain_reg[10]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[10]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_11 (.Q(portadatain_reg[11]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[11]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_12 (.Q(portadatain_reg[12]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[12]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_13 (.Q(portadatain_reg[13]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[13]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_14 (.Q(portadatain_reg[14]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[14]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
dffe	portadinreg_15 (.Q(portadatain_reg[15]), .CLK(portaclk0), .ENA(portaena0), .D(portadatain[15]), .CLRN(portadatain_reg_clr), .PRN(1'b1));
bmux21 	portadatainsel (.MO(portadatain_int), .A(portadatain), .B(portadatain_reg), .S(portadatain_reg_sel));



nmux21 	portaweregclr (.MO(portawe_reg_clr), .A(NC), .B(portaclr0), .S(portawe_clr_sel));
dffe	portawereg (.Q(portawe_reg), .CLK(portaclk0), .ENA(portaena0), .D(portawe), .CLRN(portawe_reg_clr), .PRN(1'b1));
mux21   portawesel1 (.MO(portawe_reg_mux), .A(portawe), .B(portawe_reg), .S(portawrite_reg_sel));
AND1    portawedelaybuf (.Y(portawe_reg_mux_delayed), .IN1(portawe_reg_mux));

INV     inv_1 ( .Y(portaclk0_inv1), .IN1(portaclk0_delayed));

AND1    portaclk0weregdelaybuf (.Y(portaclk0_delayed), .IN1(portaclk0));

AND2    and2_1 ( .Y(portawe_pulse), .IN1(portawe_reg_mux_delayed), .IN2(portaclk0_inv1));

mux21   portawesel2 (.MO(portawe_int), .A(portawe_reg_mux_delayed), .B(portawe_pulse), .S(portawrite_reg_sel));

nmux21 	portawaddrregclr (.MO(portawaddr_reg_clr), .A(NC), .B(portaclr0), .S(portawaddr_clr_sel));
dffe    portawaddrreg_0 (.Q(portawaddr_reg[0]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[0]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_1 (.Q(portawaddr_reg[1]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[1]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_2 (.Q(portawaddr_reg[2]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[2]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_3 (.Q(portawaddr_reg[3]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[3]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_4 (.Q(portawaddr_reg[4]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[4]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_5 (.Q(portawaddr_reg[5]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[5]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_6 (.Q(portawaddr_reg[6]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[6]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_7 (.Q(portawaddr_reg[7]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[7]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_8 (.Q(portawaddr_reg[8]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[8]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_9 (.Q(portawaddr_reg[9]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[9]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_10 (.Q(portawaddr_reg[10]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[10]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_11 (.Q(portawaddr_reg[11]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[11]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_12 (.Q(portawaddr_reg[12]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[12]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_13 (.Q(portawaddr_reg[13]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[13]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_14 (.Q(portawaddr_reg[14]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[14]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));
dffe    portawaddrreg_15 (.Q(portawaddr_reg[15]), .CLK(portaclk0), .ENA(portaena0), .D(portawaddr[15]), .CLRN(portawaddr_reg_clr), .PRN(1'b1));

bmux21 	portawaddrsel (.MO(portawaddr_int), .A(portawaddr), .B(portawaddr_reg), .S(portawrite_reg_sel));


mux21   portaraddrclksel (.MO(portaraddr_clk), .A(portaclk0), .B(portaclk1),
                          .S(portaraddr_clk_sel[1]));
mux21   portaraddrensel (.MO(portaraddren), .A(portaena0), .B(portaena1),
                         .S(portaraddr_en_sel));
mux21   portaraddrclrsel (.MO(portaraddr_clr), .A(portaclr0), .B(portaclr1),
                          .S(portaraddr_clr_sel[1]));
nmux21 	portaraddrregclr (.MO(portaraddr_reg_clr), .A(NC), .B(portaraddr_clr),
                          .S(portaraddr_clr_sel[0]));

dffe    portaraddrreg_0 (.Q(portaraddr_reg[0]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[0]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_1 (.Q(portaraddr_reg[1]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[1]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_2 (.Q(portaraddr_reg[2]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[2]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_3 (.Q(portaraddr_reg[3]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[3]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_4 (.Q(portaraddr_reg[4]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[4]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_5 (.Q(portaraddr_reg[5]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[5]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_6 (.Q(portaraddr_reg[6]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[6]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_7 (.Q(portaraddr_reg[7]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[7]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_8 (.Q(portaraddr_reg[8]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[8]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_9 (.Q(portaraddr_reg[9]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[9]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_10 (.Q(portaraddr_reg[10]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[10]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_11 (.Q(portaraddr_reg[11]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[11]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_12 (.Q(portaraddr_reg[12]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[12]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_13 (.Q(portaraddr_reg[13]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[13]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_14 (.Q(portaraddr_reg[14]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[14]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
dffe    portaraddrreg_15 (.Q(portaraddr_reg[15]), .CLK(portaraddr_clk),
                         .ENA(portaraddren), .D(portaraddr[15]),
                         .CLRN(portaraddr_reg_clr), .PRN(1'b1));
bmux21  portaraddrsel (.MO(portaraddr_int), .A(portaraddr),
                       .B(portaraddr_reg), .S(portaraddr_clk_sel[0]));

mux21 	portareclksel (.MO(portare_clk), .A(portaclk0), .B(portaclk1), .S(portare_clk_sel[1]));
mux21   portareensel (.MO(portareen), .A(portaena0), .B(portaena1), .S(portare_en_sel));
nmux21  portareregclr (.MO(portare_reg_clr), .A(NC), .B(portare_clr), .S(portare_clr_sel[0]));
dffe    portarereg (.Q(portare_reg), .CLK(portare_clk), .ENA(portareen), .D(portare), .CLRN(portare_reg_clr), .PRN(1'b1));
mux21 	portaresel (.MO(portare_int), .A(portare), .B(portare_reg), .S(portare_clk_sel[0]));


mux21   portadataoutclksel (.MO(portadataout_clk), .A(portaclk0), .B(portaclk1),
                            .S(portadataout_clk_sel[1]));
mux21   portadataoutensel (.MO(portadataouten), .A(portaena0), .B(portaena1),
                           .S(portadataout_en_sel));
mux21   portadataoutclrsel (.MO(portadataout_clr), .A(portaclr0), .B(portaclr1),
                            .S(portadataout_clr_sel[1]));
nmux21	portadataoutregclr (.MO(portadataout_reg_clr), .A(NC), .B(portadataout_clr),
                            .S(portadataout_clr_sel[0]));
dffe    portadataoutreg_0 (.Q(portadataout_reg[0]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[0]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_1 (.Q(portadataout_reg[1]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[1]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_2 (.Q(portadataout_reg[2]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[2]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_3 (.Q(portadataout_reg[3]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[3]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_4 (.Q(portadataout_reg[4]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[4]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_5 (.Q(portadataout_reg[5]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[5]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_6 (.Q(portadataout_reg[6]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[6]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_7 (.Q(portadataout_reg[7]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[7]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_8 (.Q(portadataout_reg[8]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[8]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_9 (.Q(portadataout_reg[9]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[9]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_10 (.Q(portadataout_reg[10]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[10]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_11 (.Q(portadataout_reg[11]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[11]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_12 (.Q(portadataout_reg[12]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[12]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_13 (.Q(portadataout_reg[13]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[13]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_14 (.Q(portadataout_reg[14]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[14]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
dffe    portadataoutreg_15 (.Q(portadataout_reg[15]), .CLK(portadataout_clk),
                          .ENA(portadataouten), .D(portadataout_int[15]), 
                          .CLRN(portadataout_reg_clr), .PRN(1'b1));
bmux21 	portadataoutsel (.MO(portadataout_tmp), .A(portadataout_int), .B(portadataout_reg),
                         .S(portadataout_clk_sel[0]));

// PORT B registers


nmux21 	portbdatainregclr (.MO(portbdatain_reg_clr), .A(NC), .B(portbclr0), .S(portbdatain_reg_clr_sel));
dffe	portbdinreg_0 (.Q(portbdatain_reg[0]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[0]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_1 (.Q(portbdatain_reg[1]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[1]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_2 (.Q(portbdatain_reg[2]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[2]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_3 (.Q(portbdatain_reg[3]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[3]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_4 (.Q(portbdatain_reg[4]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[4]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_5 (.Q(portbdatain_reg[5]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[5]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_6 (.Q(portbdatain_reg[6]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[6]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_7 (.Q(portbdatain_reg[7]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[7]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_8 (.Q(portbdatain_reg[8]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[8]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_9 (.Q(portbdatain_reg[9]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[9]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_10 (.Q(portbdatain_reg[10]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[10]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_11 (.Q(portbdatain_reg[11]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[11]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_12 (.Q(portbdatain_reg[12]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[12]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_13 (.Q(portbdatain_reg[13]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[13]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_14 (.Q(portbdatain_reg[14]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[14]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
dffe	portbdinreg_15 (.Q(portbdatain_reg[15]), .CLK(portbclk0), .ENA(portbena0), .D(portbdatain[15]), .CLRN(portbdatain_reg_clr), .PRN(1'b1));
bmux21 	portbdatainsel (.MO(portbdatain_int), .A(portbdatain), .B(portbdatain_reg), .S(portbdatain_reg_sel));



nmux21 	portbweregclr (.MO(portbwe_reg_clr), .A(NC), .B(portbclr0), .S(portbwe_clr_sel));
dffe	portbwereg (.Q(portbwe_reg), .CLK(portbclk0), .ENA(portbena0), .D(portbwe), .CLRN(portbwe_reg_clr), .PRN(1'b1));
mux21   portbwesel1 (.MO(portbwe_reg_mux), .A(portbwe), .B(portbwe_reg), .S(portbwrite_reg_sel));
AND1    portbwedelaybuf (.Y(portbwe_reg_mux_delayed), .IN1(portbwe_reg_mux));

INV     inv_2_1 ( .Y(portbclk0_inv1), .IN1(portbclk0_delayed));

AND1    portbclk0weregdelaybuf (.Y(portbclk0_delayed), .IN1(portbclk0));

AND2    and2_2_1 ( .Y(portbwe_pulse), .IN1(portbwe_reg_mux_delayed), .IN2(portbclk0_inv1));
mux21   portbwesel2 (.MO(portbwe_int), .A(portbwe_reg_mux_delayed), .B(portbwe_pulse), .S(portbwrite_reg_sel));

nmux21 	portbwaddrregclr (.MO(portbwaddr_reg_clr), .A(NC), .B(portbclr0), .S(portbwaddr_clr_sel));
dffe    portbwaddrreg_0 (.Q(portbwaddr_reg[0]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[0]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_1 (.Q(portbwaddr_reg[1]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[1]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_2 (.Q(portbwaddr_reg[2]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[2]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_3 (.Q(portbwaddr_reg[3]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[3]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_4 (.Q(portbwaddr_reg[4]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[4]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_5 (.Q(portbwaddr_reg[5]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[5]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_6 (.Q(portbwaddr_reg[6]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[6]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_7 (.Q(portbwaddr_reg[7]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[7]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_8 (.Q(portbwaddr_reg[8]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[8]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_9 (.Q(portbwaddr_reg[9]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[9]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_10 (.Q(portbwaddr_reg[10]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[10]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_11 (.Q(portbwaddr_reg[11]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[11]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_12 (.Q(portbwaddr_reg[12]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[12]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_13 (.Q(portbwaddr_reg[13]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[13]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_14 (.Q(portbwaddr_reg[14]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[14]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));
dffe    portbwaddrreg_15 (.Q(portbwaddr_reg[15]), .CLK(portbclk0), .ENA(portbena0), .D(portbwaddr[15]), .CLRN(portbwaddr_reg_clr), .PRN(1'b1));

bmux21 	portbwaddrsel (.MO(portbwaddr_int), .A(portbwaddr), .B(portbwaddr_reg), .S(portbwrite_reg_sel));


mux21   portbraddrclksel (.MO(portbraddr_clk), .A(portbclk0), .B(portbclk1),
                          .S(portbraddr_clk_sel[1]));
mux21   portbraddrensel (.MO(portbraddren), .A(portbena0), .B(portbena1),
                         .S(portbraddr_en_sel));
mux21   portbraddrclrsel (.MO(portbraddr_clr), .A(portbclr0), .B(portbclr1),
                          .S(portbraddr_clr_sel[1]));
nmux21 	portbraddrregclr (.MO(portbraddr_reg_clr), .A(NC), .B(portbraddr_clr),
                          .S(portbraddr_clr_sel[0]));

dffe    portbraddrreg_0 (.Q(portbraddr_reg[0]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[0]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_1 (.Q(portbraddr_reg[1]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[1]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_2 (.Q(portbraddr_reg[2]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[2]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_3 (.Q(portbraddr_reg[3]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[3]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_4 (.Q(portbraddr_reg[4]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[4]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_5 (.Q(portbraddr_reg[5]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[5]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_6 (.Q(portbraddr_reg[6]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[6]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_7 (.Q(portbraddr_reg[7]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[7]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_8 (.Q(portbraddr_reg[8]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[8]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_9 (.Q(portbraddr_reg[9]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[9]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_10 (.Q(portbraddr_reg[10]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[10]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_11 (.Q(portbraddr_reg[11]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[11]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_12 (.Q(portbraddr_reg[12]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[12]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_13 (.Q(portbraddr_reg[13]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[13]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_14 (.Q(portbraddr_reg[14]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[14]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
dffe    portbraddrreg_15 (.Q(portbraddr_reg[15]), .CLK(portbraddr_clk),
                         .ENA(portbraddren), .D(portbraddr[15]),
                         .CLRN(portbraddr_reg_clr), .PRN(1'b1));
bmux21  portbraddrsel (.MO(portbraddr_int), .A(portbraddr),
                       .B(portbraddr_reg), .S(portbraddr_clk_sel[0]));

mux21 	portbreclksel (.MO(portbre_clk), .A(portbclk0), .B(portbclk1), .S(portbre_clk_sel[1]));
mux21   portbreensel (.MO(portbreen), .A(portbena0), .B(portbena1), .S(portbre_en_sel));
nmux21  portbreregclr (.MO(portbre_reg_clr), .A(NC), .B(portbre_clr), .S(portbre_clr_sel[0]));
dffe    portbrereg (.Q(portbre_reg), .CLK(portbre_clk), .ENA(portbreen), .D(portbre), .CLRN(portbre_reg_clr), .PRN(1'b1));
mux21 	portbresel (.MO(portbre_int), .A(portbre), .B(portbre_reg), .S(portbre_clk_sel[0]));


mux21   portbdataoutclksel (.MO(portbdataout_clk), .A(portbclk0), .B(portbclk1),
                            .S(portbdataout_clk_sel[1]));
mux21   portbdataoutensel (.MO(portbdataouten), .A(portbena0), .B(portbena1),
                           .S(portbdataout_en_sel));
mux21   portbdataoutclrsel (.MO(portbdataout_clr), .A(portbclr0), .B(portbclr1),
                            .S(portbdataout_clr_sel[1]));
nmux21	portbdataoutregclr (.MO(portbdataout_reg_clr), .A(NC), .B(portbdataout_clr),
                            .S(portbdataout_clr_sel[0]));
dffe    portbdataoutreg_0 (.Q(portbdataout_reg[0]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[0]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_1 (.Q(portbdataout_reg[1]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[1]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_2 (.Q(portbdataout_reg[2]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[2]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_3 (.Q(portbdataout_reg[3]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[3]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_4 (.Q(portbdataout_reg[4]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[4]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_5 (.Q(portbdataout_reg[5]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[5]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_6 (.Q(portbdataout_reg[6]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[6]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_7 (.Q(portbdataout_reg[7]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[7]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_8 (.Q(portbdataout_reg[8]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[8]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_9 (.Q(portbdataout_reg[9]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[9]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_10 (.Q(portbdataout_reg[10]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[10]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_11 (.Q(portbdataout_reg[11]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[11]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_12 (.Q(portbdataout_reg[12]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[12]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_13 (.Q(portbdataout_reg[13]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[13]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_14 (.Q(portbdataout_reg[14]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[14]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
dffe    portbdataoutreg_15 (.Q(portbdataout_reg[15]), .CLK(portbdataout_clk),
                          .ENA(portbdataouten), .D(portbdataout_int[15]), 
                          .CLRN(portbdataout_reg_clr), .PRN(1'b1));
bmux21 	portbdataoutsel (.MO(portbdataout_tmp), .A(portbdataout_int), .B(portbdataout_reg),
                         .S(portbdataout_clk_sel[0]));

mercury_asynch_mem mercurymem (
                        .portadatain (portadatain_int),
                        .portawe (portawe_int),
                        .portare (portare_int),
                        .portaraddr (portaraddr_int),
                        .portawaddr (portawaddr_int),
                        .portbdatain (portbdatain_int),
                        .portbwe (portbwe_int),
                        .portbre (portbre_int),
                        .portbraddr (portbraddr_int),
                        .portbwaddr (portbwaddr_int),
                        .portadataout (portadataout_int),
                        .portbdataout (portbdataout_int),
                        .portamodesel (portamodesel),
                        .portbmodesel (portbmodesel));




assign portadataout = portadataout_tmp;
assign portbdataout = portbdataout_tmp;

endmodule


module mercury_cam_slice (lit, clk0, clk1, clr0, clr1, ena0, ena1,
                          outputselect, we, wrinvert, datain, waddr,
                          matchout, matchfound, modesel);
input  clk0, clk1, clr0, clr1, ena0, ena1, we, datain, wrinvert;
input  outputselect;
input  [5:0] waddr;
input  [31:0] lit;
input  [9:0] modesel;
output [31:0] matchout;
output matchfound;


     wire iena0;
     wire iena1;
     wire clr0;
     wire clr1;

     wire wdatain_reg, we_reg;
     wire [5:0] waddr_reg;
     wire [31:0] matchout_reg, matchout_int;
     wire matchfound_reg, matchfound_int, matchfound_tmp;

     wire we_clr_sel, waddr_clr_sel, write_logic_clr_sel;
     wire write_logic_sel;
     wire output_reg_sel, output_clk_sel;
     wire output_clr_sel, output_reg_clr_sel;
     wire we_pulse;
     wire clk0_delayed, clk0_delayed_inv;

     assign iena0 = ena0;
     assign iena1 = ena1;

     assign waddr_clr_sel = modesel[0];
     assign write_logic_sel = modesel[1];
     assign write_logic_clr_sel = modesel[2];
     assign we_clr_sel = modesel[3];
     assign output_reg_sel = modesel[4];
     assign output_clk_sel = modesel[5];
     assign output_clr_sel = modesel[6];
     assign output_reg_clr_sel = modesel[7];

mux21   outputclksel (.MO(output_clk), .A(clk0), .B(clk1), .S(output_clk_sel));
mux21   outputclkensel (.MO(output_clk_en), .A(iena0), .B(iena1), .S(output_clk_sel));
mux21   outputregclrsel (.MO(output_reg_clr), .A(clr0), .B(clr1), .S(output_reg_clr_sel));
nmux21  outputclrsel (.MO(output_clr), .A(1'b0), .B(output_reg_clr), .S(output_clr_sel));

b32mux21  matchoutsel (.MO(matchout), .A(matchout_int), .B(matchout_reg), .S(output_reg_sel));
mux21   matchfoundsel (.MO(matchfound), .A(matchfound_int), .B(matchfound_reg), .S(output_reg_sel));

mux21   wdatainsel (.MO(wdatain_int), .A(datain), .B(wdatain_reg), .S(write_logic_sel));
mux21   wrinvsel (.MO(wrinv_int), .A(wrinvert), .B(wrinv_reg), .S(write_logic_sel));

nmux21  weclrsel (.MO(we_clr), .A(clr0), .B(1'b0), .S(we_clr_sel));
nmux21  waddrclrsel (.MO(waddr_clr), .A(clr0), .B(1'b0), .S(waddr_clr_sel));
nmux21  writelogicclrsel (.MO(write_logic_clr), .A(clr0), .B(1'b0), .S(write_logic_clr_sel));


dffe	wereg (.Q(we_reg), .CLK(clk0), .ENA(iena0), .D(we), .CLRN(we_clr) , .PRN(1'b1));
AND1    clk0weregdelaybuf (.Y(clk0_delayed), .IN1(clk0));
AND1    wedelay_buf (.Y(we_reg_delayed), .IN1(we_reg));
INV  inv_1 ( .Y(clk0_delayed_inv), .IN1(clk0_delayed));
AND2 and2_1 ( .Y(we_pulse), .IN1(we_reg_delayed), .IN2(clk0_delayed_inv));


dffe    wdatainreg (.Q(wdatain_reg), .CLK(clk0), .ENA(iena0), .D(datain), .CLRN(write_logic_clr), .PRN(1'b1));
dffe    wrinvreg (.Q(wrinv_reg), .CLK(clk0), .ENA(iena0), .D(wrinvert), .CLRN(write_logic_clr), .PRN(1'b1));

dffe    waddrreg_0 (.Q(waddr_reg[0]), .CLK(clk0), .ENA(iena0), .D(waddr[0]), .CLRN(waddr_clr), .PRN(1'b1));
dffe    waddrreg_1 (.Q(waddr_reg[1]), .CLK(clk0), .ENA(iena0), .D(waddr[1]), .CLRN(waddr_clr), .PRN(1'b1));
dffe    waddrreg_2 (.Q(waddr_reg[2]), .CLK(clk0), .ENA(iena0), .D(waddr[2]), .CLRN(waddr_clr), .PRN(1'b1));
dffe    waddrreg_3 (.Q(waddr_reg[3]), .CLK(clk0), .ENA(iena0), .D(waddr[3]), .CLRN(waddr_clr), .PRN(1'b1));
dffe    waddrreg_4 (.Q(waddr_reg[4]), .CLK(clk0), .ENA(iena0), .D(waddr[4]), .CLRN(waddr_clr), .PRN(1'b1));
dffe    waddrreg_5 (.Q(waddr_reg[5]), .CLK(clk0), .ENA(iena0), .D(waddr[5]), .CLRN(waddr_clr), .PRN(1'b1));


dffe    matchoutreg_0 (.Q(matchout_reg[0]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[0]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_1 (.Q(matchout_reg[1]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[1]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_2 (.Q(matchout_reg[2]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[2]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_3 (.Q(matchout_reg[3]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[3]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_4 (.Q(matchout_reg[4]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[4]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_5 (.Q(matchout_reg[5]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[5]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_6 (.Q(matchout_reg[6]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[6]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_7 (.Q(matchout_reg[7]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[7]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_8 (.Q(matchout_reg[8]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[8]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_9 (.Q(matchout_reg[9]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[9]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_10 (.Q(matchout_reg[10]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[10]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_11 (.Q(matchout_reg[11]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[11]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_12 (.Q(matchout_reg[12]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[12]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_13 (.Q(matchout_reg[13]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[13]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_14 (.Q(matchout_reg[14]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[14]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_15 (.Q(matchout_reg[15]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[15]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_16 (.Q(matchout_reg[16]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[16]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_17 (.Q(matchout_reg[17]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[17]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_18 (.Q(matchout_reg[18]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[18]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_19 (.Q(matchout_reg[19]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[19]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_20 (.Q(matchout_reg[20]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[20]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_21 (.Q(matchout_reg[21]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[21]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_22 (.Q(matchout_reg[22]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[22]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_23 (.Q(matchout_reg[23]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[23]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_24 (.Q(matchout_reg[24]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[24]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_25 (.Q(matchout_reg[25]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[25]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_26 (.Q(matchout_reg[26]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[26]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_27 (.Q(matchout_reg[27]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[27]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_28 (.Q(matchout_reg[28]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[28]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_29 (.Q(matchout_reg[29]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[29]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_30 (.Q(matchout_reg[30]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[30]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchoutreg_31 (.Q(matchout_reg[31]), .CLK(output_clk), .ENA(output_clk_en), .D(matchout_int[31]), .CLRN(clr_output), .PRN(1'b1));
dffe    matchfoundreg (.Q(matchfound_reg), .CLK(output_clk), .ENA(output_clk_en), .D(matchfound_int), .CLRN(clr_output), .PRN(1'b1));


wire [1:0] modesel_tmp;
assign modesel_tmp[1] = modesel[9];
assign modesel_tmp[0] = modesel[8];
mercury_cam cam1 (.waddr(waddr_reg), .we(we_pulse), .outputselect(outputselect), .matchout(matchout_int), .matchfound(matchfound_int), .wrinvert(wrinv_int), .datain(wdatain_int), .lit(lit), .modesel(modesel_tmp));

endmodule
