-- Copyright (C) 2005 - Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.

-------------------------------------------------------------------------------
--                                                                           --
-- Containing Verilog Model for the Atoms:                                   --
--                                                                           --
--                         stratixiigx_hssi_receiver                         --
--                         stratixiigx_hssi_transmitter                      --
--                         stratixiigx_hssi_central_management_unit          --
--                         stratixiigx_hssi_cmu_pll                          --
--                         stratixiigx_hssi_cmu_clock_divider                --
--                         stratixiigx_hssi_refclk_divider                   --
--                         stratixiigx_hssi_calibration_block                --
--                                                                           --
-------------------------------------------------------------------------------




LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_aux_clock_div IS
    GENERIC (
        clk_divide_by : INTEGER := 1;
        extra_latency : INTEGER := 0
    );
    PORT (
        clk                     : IN STD_LOGIC;   
        reset                   : IN STD_LOGIC := '0';   
        clkout                  : OUT STD_LOGIC
    );   
END stratixiigx_hssi_aux_clock_div;

ARCHITECTURE clock_div_arch OF stratixiigx_hssi_aux_clock_div IS  
    SIGNAL clk_edges                :  INTEGER := -1;     
    SIGNAL div_n_register           :  STD_LOGIC_VECTOR(2 * extra_latency DOWNTO 0)
                                                    := (OTHERS => '0');     

BEGIN
    PROCESS(clk,reset)
    VARIABLE div_n : STD_LOGIC_VECTOR(2 * extra_latency DOWNTO 0) := (OTHERS => '0');
    VARIABLE m : INTEGER := 0;
    VARIABLE running_clk_edge : INTEGER := -1;
    BEGIN
        running_clk_edge := clk_edges;
        IF (reset = '1') THEN
            clk_edges <= -1;
            m := 0;    
            div_n := (OTHERS => '0');  
        ELSE
        IF (clk'EVENT) THEN
            IF (running_clk_edge = -1) THEN
                m := 0;
                div_n(0) := clk;
                IF (clk = '1') THEN running_clk_edge := 0; END IF;
            ELSIF (running_clk_edge mod clk_divide_by = 0) THEN
                div_n(0) := NOT div_n(0);
            END IF;
            IF (running_clk_edge >= 0 OR clk = '1') THEN 
                clk_edges <= (running_clk_edge + 1) mod (2 * clk_divide_by);
            END IF;
        END IF;
        
        END IF;   
        m := 0;
        div_n_register(m) <= div_n(m); 
        WHILE (m < 2 * extra_latency) LOOP
            div_n_register(m+1) <=  div_n_register(m);  
            m := m + 1;
        END LOOP;
        
    END PROCESS;
    clkout <= div_n_register(2 * extra_latency);

END clock_div_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

ENTITY stratixiigx_hssi_aux_clock_mult IS
    GENERIC (
        clk_multiply_by : INTEGER := 1
    );
    PORT (
        clk                     : IN STD_LOGIC;   
        adjust                  : IN STD_LOGIC := '0';   
        reset                   : IN STD_LOGIC := '0';   
        clkout                  : OUT STD_LOGIC;   
        busy                    : OUT CMU_MULT_STATE_TYPE);   
END stratixiigx_hssi_aux_clock_mult;

ARCHITECTURE clock_mult_arch OF stratixiigx_hssi_aux_clock_mult IS

    SIGNAL busy_m,busy_n : CMU_MULT_STATE_TYPE;
    SIGNAL mult_n                   :  STD_LOGIC := '0';   

BEGIN

    PROCESS (adjust,busy_m)
    BEGIN
        IF (adjust'EVENT AND adjust = '1') THEN
            busy_n <= INITIAL;
        ELSE
            busy_n <= busy_m;
        END IF;
    END PROCESS;
        
    PROCESS
    VARIABLE clk_period :  TIME;   
    VARIABLE clk_fast_period :  TIME; 
    VARIABLE last_rising_edge  :  TIME := 0 ps;     
    VARIABLE n :  INTEGER := 0;
    VARIABLE clk_adjust_settled : BOOLEAN := FALSE;   
    VARIABLE clk_sync_period :  TIME; 
    VARIABLE clk_adjust : TIME := 0 ps;
    VARIABLE clk_adjust_running : TIME := 0 ps;
    VARIABLE clk_adjust_interval : INTEGER := 0;
    VARIABLE current_mult_val : STD_LOGIC;
    
    BEGIN
        WAIT UNTIL (clk'EVENT OR reset'EVENT OR adjust'EVENT);
        IF (reset = '1') THEN
            mult_n <= '0';   
            busy_m <= INITIAL; 
        ELSIF (adjust'EVENT AND adjust = '1') THEN
            busy_m <= INITIAL;
        ELSIF (clk'EVENT AND clk = '1') THEN
            IF (busy_n = INITIAL) THEN -- first rising edge            
                mult_n <= '0';    
                last_rising_edge := NOW;    
                busy_m <= ACTIVE;    
            ELSE
                IF (busy_n = ACTIVE) THEN -- second rising edge                
                    clk_period := NOW - last_rising_edge;    
                    clk_fast_period := clk_period / clk_multiply_by;    
                    clk_adjust := clk_period - (clk_fast_period * clk_multiply_by);    
                    busy_m <= INACTIVE;    
                END IF;
                current_mult_val := mult_n;
                mult_n <= NOT mult_n;    
                IF (clk_adjust > 0 ps) THEN
                    clk_adjust_running := clk_adjust + 1 ps;    
                END IF;
                clk_adjust_settled := (clk_adjust = 0 ps);    --  if no adjustment necessary
                n := clk_multiply_by;
                WHILE (n >= 1) LOOP
                    IF (clk_adjust_settled = FALSE) THEN
                        clk_adjust_running := clk_adjust_running - 1 ps;    
                        clk_adjust_interval := (n * 1 ps)/ clk_adjust_running;    
                        IF ((n * 1 ps) - (clk_adjust_interval * clk_adjust_running) = 0 ps) THEN
                            clk_adjust_settled := TRUE;    
                        END IF;
                        clk_sync_period := clk_fast_period + 1 ps;    
                    ELSE
                        IF (clk_adjust = 0 ps) THEN
                            clk_sync_period := clk_fast_period;    
                        ELSE
                            IF (n mod clk_adjust_interval = 0) THEN
                                clk_sync_period := clk_fast_period + 1 ps;    
                            ELSE
                                clk_sync_period := clk_fast_period;    
                            END IF;
                        END IF;
                    END IF;
                    IF (reset = '1') THEN
                        mult_n <= '0';    
                    ELSE
                        WAIT FOR (clk_sync_period/2);
                        mult_n <= NOT mult_n;  
                        IF (n > 1) THEN
                            WAIT FOR (clk_sync_period - clk_sync_period/2);
                            mult_n <= NOT mult_n;    
                        END IF;
                    END IF;
                    n := n - 1;
                END LOOP;
            END IF;
        END IF;
    END PROCESS;
    clkout <= mult_n ;
    busy <= busy_n;

END clock_mult_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_aux_clock_phaseshift IS
    GENERIC (
        clk_phase_shift_by : TIME := 0 ps
        );
    PORT    (
        clk                     : IN STD_LOGIC;   
        clkout                  : OUT STD_LOGIC
        );   
END stratixiigx_hssi_aux_clock_phaseshift;

ARCHITECTURE clock_ps_arch OF stratixiigx_hssi_aux_clock_phaseshift IS
    SIGNAL pclk : STD_LOGIC;   
BEGIN
    PROCESS(clk)
    BEGIN
        pclk <= TRANSPORT clk AFTER clk_phase_shift_by;    
    END PROCESS;
    
    clkout <= pclk ;
END clock_ps_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.VITAL_Timing.ALL;
USE IEEE.VITAL_Primitives.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

USE work.stratixiigx_hssi_aux_clock_div;

ENTITY stratixiigx_hssi_refclk_divider IS
    GENERIC (
        enable_divider : STRING := "true";
        divider_number : INTEGER := 0;  -- 0 or 1 for logical numbering
        refclk_coupling_termination : STRING := "dc_coupling_external_termination"; -- new in 5.1 SP1
        MsgOnChecks: Boolean := DefMsgOnChecks;
        XOnChecks: Boolean := DefXOnChecks;
        tipd_inclk        : VitalDelayType01 := DefPropDelay01;
        tipd_dprioin      : VitalDelayType01 := DefPropDelay01;
        tipd_dpriodisable : VitalDelayType01 := DefPropDelay01;
        tpd_inclk_clkout  : VitalDelayType01 := DefPropDelay01
    );
    PORT (
        inclk                   : IN STD_LOGIC;   
        dprioin                 : IN STD_LOGIC := '0';   
        dpriodisable            : IN STD_LOGIC := '1';   
        clkout                  : OUT STD_LOGIC;   
        dprioout                : OUT STD_LOGIC);   
END stratixiigx_hssi_refclk_divider;

ARCHITECTURE refclk_div_arch OF stratixiigx_hssi_refclk_divider IS

    COMPONENT stratixiigx_hssi_aux_clock_div
        GENERIC (
            clk_divide_by : INTEGER := 1;
            extra_latency : INTEGER := 0);
        PORT (
            clk                     : IN  STD_LOGIC;
            reset                   : IN  STD_LOGIC := '0';
            clkout                  : OUT STD_LOGIC);
    END COMPONENT;

    SIGNAL divide_by_2_out          :  STD_LOGIC; 
    SIGNAL inclk_ipd                :  STD_LOGIC;
    SIGNAL dprioin_ipd              :  STD_LOGIC;
    SIGNAL dpriodisable_ipd         :  STD_LOGIC;

    SIGNAL tmp_clkout : STD_LOGIC;

BEGIN

    WireDelay : BLOCK
    BEGIN
        VitalWireDelay (inclk_ipd, inclk, tipd_inclk);
        VitalWireDelay (dprioin_ipd, dprioin, tipd_dprioin);
        VitalWireDelay (dpriodisable_ipd, dpriodisable, tipd_dpriodisable);
    END BLOCK;

    VITALTIMING : process(inclk_ipd,divide_by_2_out)
    VARIABLE clkout_VitalGlitchData : VitalGlitchDataType;
    VARIABLE tmp_clkout : STD_LOGIC;
    BEGIN
    
        IF (enable_divider = "true") THEN 
            tmp_clkout := divide_by_2_out;
        ELSE 
            tmp_clkout := inclk_ipd;
        END IF;
        
        VitalPathDelay01 
        (
            OutSignal => clkout,
            OutSignalName => "CLKOUT",
            OutTemp => tmp_clkout,
            Paths => (
                        0 => (inclk_ipd'last_event, tpd_inclk_clkout, TRUE)
                     ),
            GlitchData => clkout_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
    
    END process;
    
    divide_by_2 : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 2,
            extra_latency => 0)
        PORT MAP (
            clk => inclk_ipd, 
            clkout => divide_by_2_out);   
    
    
    dprioout <= '0' WHEN (dpriodisable_ipd = '1') ELSE dprioin_ipd;

END refclk_div_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY stratixiigx_hssi_tx_channel_clk_div IS
    GENERIC (
        clkin0_select         :  string := "true";    
        clk_divide_by_n       :  integer := 1;    
        clk_divide_by_m       :  integer := 4;    
        clk_divide_by_2_select:  string := "true";    
	allow_vco_bypass        :  string := "false";
        lclkout_latency       :  integer := 0;    
        fclkout_latency       :  integer := 0;    
        lclkout_phase_shift   :  TIME := 0 ps;    
        fclkout_phase_shift   :  TIME := 0 ps    
    );
    PORT (
        clkin0                  : IN std_logic;   
        clkin1                  : IN std_logic;   
        reset                   : IN std_logic := '0';
        vcobypassin             : IN std_logic := '0';
        lclkout                 : OUT std_logic;   
        fclkout                 : OUT std_logic
    );   
END stratixiigx_hssi_tx_channel_clk_div;

ARCHITECTURE local_div_arch OF stratixiigx_hssi_tx_channel_clk_div IS

    COMPONENT stratixiigx_hssi_aux_clock_div
        GENERIC (
            clk_divide_by : INTEGER := 1;
            extra_latency : INTEGER := 0
        );
        PORT (
            clk                     : IN STD_LOGIC;
            reset                   : IN STD_LOGIC := '0';
            clkout                  : OUT STD_LOGIC
        );
    END COMPONENT;

    COMPONENT stratixiigx_hssi_aux_clock_phaseshift
        GENERIC (
            clk_phase_shift_by : TIME := 0 ps
        );
        PORT    (
            clk                     : IN STD_LOGIC;
            clkout                  : OUT STD_LOGIC
        );
    END COMPONENT;
    
    SIGNAL divide_by_n_in           :  std_logic := '0';
    -- N divider   
    SIGNAL divide_by_n_out          :  std_logic := '0';
    -- 4,5 divider   
    SIGNAL divide_by_m_out          :  std_logic := '0';   
    -- 2 divider
    SIGNAL divide_by_2_out          :  std_logic := '0'; 
    -- Low speed clock latency,phase shift  
    SIGNAL lclkout_undelayed        :  std_logic; 
    SIGNAL lclkout_pre_latency        :  std_logic;  
    -- High speed clock latency,phase shift 
    SIGNAL hclkout_undelayed      :  std_logic;   
    SIGNAL hclkout_pre_latency      :  std_logic;   

BEGIN
    
    divide_by_n_in <= vcobypassin WHEN (allow_vco_bypass = "true") ELSE
                      clkin0      WHEN (clkin0_select = "true")  ELSE 
                      clkin1;

    divide_by_n : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => clk_divide_by_n,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_in,
	    reset => reset,
            clkout => divide_by_n_out);   
    
    divide_by_m : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => clk_divide_by_m,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_out,
	    reset => reset,
            clkout => divide_by_m_out);   
    
    divide_by_2 : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 2,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_m_out,
	    reset => reset,
            clkout => divide_by_2_out);   
    
    
    lclkout_undelayed <= divide_by_2_out WHEN (clk_divide_by_2_select = "true") ELSE divide_by_m_out;
    hclkout_undelayed <= divide_by_n_out ;
    
    lclk_phase_shift : stratixiigx_hssi_aux_clock_phaseshift 
        GENERIC MAP (
            clk_phase_shift_by => lclkout_phase_shift)
        PORT MAP (
            clk => lclkout_undelayed,
            clkout => lclkout_pre_latency);   
    
    hclk_phase_shift : stratixiigx_hssi_aux_clock_phaseshift 
        GENERIC MAP (
            clk_phase_shift_by => fclkout_phase_shift)
        PORT MAP (
            clk => hclkout_undelayed,
            clkout => hclkout_pre_latency);   
    
    lclk_latency : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 1,
            extra_latency => lclkout_latency)
        PORT MAP (
            clk => lclkout_pre_latency,
	    reset => reset,
            clkout => lclkout);   
    
    hclk_latency : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 1,
            extra_latency => fclkout_latency)
        PORT MAP (
            clk => hclkout_pre_latency,
	    reset => reset,
            clkout => fclkout);   
    
END local_div_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.VITAL_Timing.ALL;
USE IEEE.VITAL_Primitives.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

USE work.stratixiigx_hssi_aux_clock_div;
USE work.stratixiigx_hssi_aux_clock_phaseshift;

ENTITY stratixiigx_hssi_cmu_clock_divider IS
    GENERIC (
      inclk_select          :  integer := 0;    
      use_vco_bypass        :  string := "false";    
      use_digital_refclk_post_divider :  string := "false";    
      use_coreclk_out_post_divider    :  string := "false";    
      divide_by             :  integer := 4;    
      enable_refclk_out     :  string := "true";    
      enable_pclk_x8_out    :  string := "false";    
      select_neighbor_pclk  :  string := "false";    
      coreclk_out_gated_by_quad_reset:  string := "false";    
      select_refclk_dig     :  string := "false";
      -- Interconnect delays
      tipd_clk           : VitalDelayArrayType01(2 DOWNTO 0) := (OTHERS => DefPropDelay01);
      tipd_pclkin        : VitalDelayType01 := DefPropDelay01;
      tipd_dprioin       : VitalDelayArrayType01(29 DOWNTO 0) := (OTHERS => DefPropDelay01);
      tipd_dpriodisable  : VitalDelayType01 := DefPropDelay01;
      tipd_powerdn       : VitalDelayType01 := DefPropDelay01;
      tipd_quadreset     : VitalDelayType01 := DefPropDelay01;
      tipd_refclkdig     : VitalDelayType01 := DefPropDelay01;
      tipd_scanclk       : VitalDelayType01 := DefPropDelay01;
      tipd_scanin        : VitalDelayArrayType01(22 DOWNTO 0) := (OTHERS => DefPropDelay01);
      tipd_scanshift     : VitalDelayType01 := DefPropDelay01;
      tipd_scanmode      : VitalDelayType01 := DefPropDelay01;
      -- Path delays
      MsgOnChecks: Boolean := DefMsgOnChecks;
      XOnChecks: Boolean := DefXOnChecks;
      tpd_clk_coreclkout  : VitalDelayType01 := DefPropDelay01;
      tpd_clk_pclkx8out   : VitalDelayType01 := DefPropDelay01;
      tpd_pclkin_coreclkout : VitalDelayType01 := DefPropDelay01;
      -- Simulation only
      sim_analogrefclkout_phase_shift : INTEGER := 0;     
      sim_analogfastrefclkout_phase_shift : INTEGER := 0;     
      sim_digitalrefclkout_phase_shift  : INTEGER := 0;     
      sim_pclkx8out_phase_shift  : INTEGER := 0;     
      sim_coreclkout_phase_shift  : INTEGER := 0 
    );
    PORT (
        clk                     : IN STD_LOGIC_VECTOR(2 DOWNTO 0) := (OTHERS => '0');   
        pclkin                  : IN STD_LOGIC := '0';   
        dprioin                 : IN STD_LOGIC_VECTOR(29 DOWNTO 0) := (OTHERS => '0');   
        dpriodisable            : IN STD_LOGIC := '1';   
        powerdn                 : IN STD_LOGIC := '0';   
        quadreset               : IN STD_LOGIC := '0';   
        refclkdig               : IN STD_LOGIC := '0';   
        scanclk                 : IN STD_LOGIC := '0';   
        scanin                  : IN STD_LOGIC_VECTOR(22 DOWNTO 0) := (OTHERS => '0');   
        scanshift               : IN STD_LOGIC := '0';   
        scanmode                : IN STD_LOGIC := '0';
        vcobypassin             : IN STD_LOGIC := '0';   
        analogrefclkout         : OUT STD_LOGIC;   
        analogfastrefclkout     : OUT STD_LOGIC;   
        digitalrefclkout        : OUT STD_LOGIC;   
        pclkx8out               : OUT STD_LOGIC;   
        coreclkout              : OUT STD_LOGIC;   
        dprioout                : OUT STD_LOGIC_VECTOR(29 DOWNTO 0);   
        scanout                 : OUT STD_LOGIC_VECTOR(22 DOWNTO 0));   
END stratixiigx_hssi_cmu_clock_divider;

ARCHITECTURE cmu_div_arch OF stratixiigx_hssi_cmu_clock_divider IS

    COMPONENT stratixiigx_hssi_aux_clock_div 
    GENERIC (
        clk_divide_by : INTEGER := 1;
        extra_latency : INTEGER := 0
    );
    PORT (
        clk                     : IN STD_LOGIC;
        reset                   : IN STD_LOGIC := '0';
        clkout                  : OUT STD_LOGIC
    );
    END COMPONENT;
    
    COMPONENT stratixiigx_hssi_aux_clock_phaseshift
    GENERIC (
        clk_phase_shift_by : TIME := 0 ps
        );
    PORT    (
        clk                     : IN STD_LOGIC;
        clkout                  : OUT STD_LOGIC
        );
    END COMPONENT;
     
    SIGNAL divide_by_n_out          :  STD_LOGIC;   
    SIGNAL divide_by_m_out          :  STD_LOGIC;   
    SIGNAL divide_by_2_dig_out      :  STD_LOGIC;   
    SIGNAL divide_by_2_core_out     :  STD_LOGIC;   
    SIGNAL mux_pclk                 :  STD_LOGIC;   
    SIGNAL mux_digrefclk            :  STD_LOGIC;   
    SIGNAL mux_coreclk              :  STD_LOGIC;   
    SIGNAL reset_divs               :  STD_LOGIC;   
    SIGNAL reset_coreclk_only       :  STD_LOGIC;  
    SIGNAL vco_bypass_mux           :  STD_LOGIC; 
    
    SIGNAL analogrefclkout_undelayed,analogfastrefclkout_undelayed, digitalrefclkout_undelayed,
           pclkx8out_undelayed, coreclkout_undelayed : STD_LOGIC;   
           
    SIGNAL clk_ipd : STD_LOGIC_VECTOR(2 DOWNTO 0);
    SIGNAL scanin_ipd : STD_LOGIC_VECTOR(22 DOWNTO 0);
    SIGNAL pclkin_ipd : STD_LOGIC;
    SIGNAL dprioin_ipd : STD_LOGIC_VECTOR(29 DOWNTO 0);
    SIGNAL dpriodisable_ipd : STD_LOGIC;
    SIGNAL powerdn_ipd : STD_LOGIC;
    SIGNAL quadreset_ipd : STD_LOGIC;
    SIGNAL refclkdig_ipd : STD_LOGIC;
    SIGNAL scanclk_ipd : STD_LOGIC;
    SIGNAL scanshift_ipd : STD_LOGIC;
    SIGNAL scanmode_ipd : STD_LOGIC;

    SIGNAL tmp_coreclkout, tmp_pclkx8out : STD_LOGIC;
       
BEGIN
    WireDelay : BLOCK
    BEGIN
        loopbits_clk : FOR i in clk'RANGE GENERATE
            VitalWireDelay (clk_ipd(i), clk(i), tipd_clk(i));
        END GENERATE;
        loopbits_scanin : FOR i in scanin'RANGE GENERATE
            VitalWireDelay (scanin_ipd(i), scanin(i), tipd_scanin(i));
        END GENERATE;
        
        VitalWireDelay (pclkin_ipd, pclkin, tipd_pclkin);

	loopbits_dprioin : FOR i in dprioin'RANGE GENERATE
            VitalWireDelay (dprioin_ipd(i), dprioin(i), tipd_dprioin(i));
	END GENERATE;

        VitalWireDelay (dpriodisable_ipd, dpriodisable, tipd_dpriodisable);
        VitalWireDelay (powerdn_ipd, powerdn, tipd_powerdn);
        VitalWireDelay (quadreset_ipd, quadreset, tipd_quadreset);
        VitalWireDelay (refclkdig_ipd, refclkdig, tipd_refclkdig);
        VitalWireDelay (scanclk_ipd, scanclk, tipd_scanclk);
        VitalWireDelay (scanshift_ipd, scanshift, tipd_scanshift);
        VitalWireDelay (scanmode_ipd, scanmode, tipd_scanmode);
        
    END BLOCK;
    VITALTIMING : process(clk_ipd , pclkin_ipd, tmp_coreclkout, tmp_pclkx8out)
    VARIABLE coreclkout_clk_VitalGlitchData : VitalGlitchDataType;
    VARIABLE coreclkout_pclk_VitalGlitchData : VitalGlitchDataType;
    VARIABLE pclkx8out_VitalGlitchData : VitalGlitchDataType;
    BEGIN
        VitalPathDelay01 
        (
            OutSignal => coreclkout,
            OutSignalName => "CORECLKOUT",
            OutTemp => tmp_coreclkout,
            Paths => (
                        0 => (clk_ipd'last_event, tpd_clk_coreclkout, TRUE)
                     ),
            GlitchData => coreclkout_clk_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
        
        VitalPathDelay01 
        (
            OutSignal => pclkx8out,
            OutSignalName => "PCLKX8OUT",
            OutTemp => tmp_pclkx8out,
            Paths => (
                        0 => (clk_ipd'last_event, tpd_clk_pclkx8out, TRUE)
                     ),
            GlitchData => pclkx8out_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
        
        VitalPathDelay01 
        (
            OutSignal => coreclkout,
            OutSignalName => "CORECLKOUT",
            OutTemp => tmp_coreclkout,
            Paths => (
                        0 => (pclkin_ipd'last_event, tpd_pclkin_coreclkout, TRUE)
                     ),
            GlitchData => coreclkout_pclk_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
    
    END process;

    reset_divs <= powerdn_ipd OR quadreset_ipd ;
    reset_coreclk_only <= '0' WHEN (coreclk_out_gated_by_quad_reset = "false") ELSE quadreset_ipd ;
    -- /N=1 divider
    divide_by_n : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 1,
            extra_latency => 0)
        PORT MAP (
            clk => clk_ipd(inclk_select),
            reset => reset_divs,
            clkout => divide_by_n_out);        
    -- /M divider
    divide_by_m : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => divide_by,
            extra_latency => 0)
        PORT MAP (
            clk => divide_by_n_out,
            reset => reset_divs,
            clkout => divide_by_m_out);   
    
    
    vco_bypass_mux <= vcobypassin WHEN (use_vco_bypass = "true") ELSE divide_by_m_out;
    
    -- /2 divider
    divide_by_2_dig : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 2,
            extra_latency => 0)
        PORT MAP (
            clk => vco_bypass_mux,
            reset => reset_divs,
            clkout => divide_by_2_dig_out);   
    -- /2 coreclk divider
    divide_by_2_core : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 2,
            extra_latency => 0)
        PORT MAP (
            clk => mux_digrefclk,
            reset => reset_coreclk_only,
            clkout => divide_by_2_core_out);   
            
    analogrefclkout_undelayed <= 'Z' WHEN (enable_refclk_out = "false") ELSE divide_by_m_out;
    analogfastrefclkout_undelayed <= divide_by_n_out;
    digitalrefclkout_undelayed <= refclkdig_ipd WHEN (select_refclk_dig = "true") ELSE mux_digrefclk;
    coreclkout_undelayed <= mux_coreclk;
    pclkx8out_undelayed <= 'Z' WHEN (enable_pclk_x8_out = "false") ELSE mux_pclk;
    
    mux_pclk <= divide_by_2_dig_out WHEN (use_digital_refclk_post_divider = "true") ELSE vco_bypass_mux;
    mux_digrefclk <= pclkin_ipd WHEN (select_neighbor_pclk = "true") ELSE mux_pclk;
    
    mux_coreclk <= mux_digrefclk WHEN (use_coreclk_out_post_divider = "false") ELSE divide_by_2_core_out;

    -- Extra phase shift on output clocks
    
    extra_ps_arc : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_analogrefclkout_phase_shift * 1 ps
    )
    PORT MAP (
        clk => analogrefclkout_undelayed,
        clkout => analogrefclkout
    );

    extra_ps_afrc : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_analogfastrefclkout_phase_shift * 1 ps
    )
    PORT MAP (
        clk => analogfastrefclkout_undelayed,
        clkout => analogfastrefclkout
    );

    extra_ps_drc : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_digitalrefclkout_phase_shift * 1 ps
    )
    PORT MAP (
        clk => digitalrefclkout_undelayed,
        clkout => digitalrefclkout
    );

    extra_ps_p8c : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_pclkx8out_phase_shift * 1 ps
    )
    PORT MAP (
        clk => pclkx8out_undelayed,
        clkout => tmp_pclkx8out
    );
    
    extra_ps_cc : stratixiigx_hssi_aux_clock_phaseshift
    GENERIC MAP (
        clk_phase_shift_by => sim_coreclkout_phase_shift * 1 ps
    )
    PORT MAP (
        clk => coreclkout_undelayed,
        clkout => tmp_coreclkout
    );
        
END cmu_div_arch;
--
-- 
-- no digital behavior to simulate
--

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

ENTITY stratixiigx_hssi_calibration_block IS
    GENERIC (
        use_continuous_calibration_mode:  string  := "false";    
        rx_calibration_write_test_value:  integer := 0;    
        tx_calibration_write_test_value:  integer := 0;    
        enable_rx_calibration_test_write: string  := "false";    
        enable_tx_calibration_test_write: string  := "false";    
        send_rx_calibration_status     :  string  := "true");    
    PORT (
        clk                     : IN std_logic := '0';   
        powerdn                 : IN std_logic := '0';   
        enabletestbus           : IN std_logic := '0';   
        calibrationstatus       : OUT std_logic_vector(4 DOWNTO 0));   
END stratixiigx_hssi_calibration_block;

ARCHITECTURE calib_arch OF stratixiigx_hssi_calibration_block IS


    SIGNAL calibrationstatus_xhdl1  :  std_logic_vector(4 DOWNTO 0);   

BEGIN
    calibrationstatus <= calibrationstatus_xhdl1;

END calib_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.VITAL_Timing.ALL;
USE IEEE.VITAL_Primitives.ALL;

LIBRARY STD;
USE STD.textio.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

USE WORK.stratixiigx_hssi_aux_clock_div;
USE WORK.stratixiigx_hssi_aux_clock_mult;
USE WORK.stratixiigx_hssi_aux_clock_phaseshift;

ENTITY stratixiigx_hssi_cmu_pll IS
    GENERIC (
        inclk0_period : INTEGER := 0;  -- time period in ps
        inclk1_period : INTEGER := 0;
        inclk2_period : INTEGER := 0;
        inclk3_period : INTEGER := 0;
        inclk4_period : INTEGER := 0;
        inclk5_period : INTEGER := 0;
        inclk6_period : INTEGER := 0;
        inclk7_period : INTEGER := 0;
        pfd_clk_select : INTEGER := 0;
        multiply_by : INTEGER := 1;
        divide_by : INTEGER := 1;
        low_speed_test_sel : INTEGER := 0;
        pll_type : STRING := "normal"; -- normal,fast,auto
        charge_pump_current_test_enable : INTEGER := 0;
        vco_range : STRING := "low";
        loop_filter_resistor_control : INTEGER := 0;
        loop_filter_ripple_capacitor_control : INTEGER := 0;
        use_default_charge_pump_current_selection : STRING := "false";
        use_default_charge_pump_supply_vccm_vod_control : STRING := "false";
        charge_pump_current_control : INTEGER := 0;
        up_down_control_percent : INTEGER := 0;
        charge_pump_tristate_enable : STRING := "false";
        pll_number : INTEGER := 0;     -- PLL 0-2
        -- Interconnect delays
        tipd_clk           : VitalDelayArrayType01(7 DOWNTO 0)  := (OTHERS => DefPropDelay01);
        tipd_dprioin       : VitalDelayArrayType01(39 DOWNTO 0) := (OTHERS => DefPropDelay01);
        tipd_dpriodisable  : VitalDelayType01 := DefPropDelay01;
        tipd_pllreset      : VitalDelayType01 := DefPropDelay01;
        tipd_pllpowerdn    : VitalDelayType01 := DefPropDelay01;
        -- Path delays
        MsgOnChecks: Boolean := DefMsgOnChecks;
        XOnChecks: Boolean := DefXOnChecks;
        tpd_clk_clkout  : VitalDelayType01 := DefPropDelay01;
        -- Simulation only
        sim_clkout_phase_shift : INTEGER := 0; 
        sim_clkout_latency : INTEGER := 0
    );
    PORT (
        clk                     : IN std_logic_vector(7 DOWNTO 0);   
        dprioin                 : IN std_logic_vector(39 DOWNTO 0) := (OTHERS => '0');   
        dpriodisable            : IN std_logic := '1';   
        pllreset                : IN std_logic := '0';   
        pllpowerdn              : IN std_logic := '0';   
        clkout                  : OUT std_logic;   
        locked                  : OUT std_logic;   
        dprioout                : OUT std_logic_vector(39 DOWNTO 0);
        fbclkout                : OUT std_logic;
        vcobypassout            : OUT std_logic);   
END stratixiigx_hssi_cmu_pll;

ARCHITECTURE cmu_pll_arch OF stratixiigx_hssi_cmu_pll IS

    COMPONENT stratixiigx_hssi_aux_clock_div
        GENERIC (
            clk_divide_by : INTEGER := 1;
            extra_latency : INTEGER := 0
        );
        PORT (
            clk                     : IN  std_logic;
            reset                   : IN  std_logic := '0';
            clkout                  : OUT std_logic);
    END COMPONENT;

    COMPONENT stratixiigx_hssi_aux_clock_mult
        GENERIC (
            clk_multiply_by : INTEGER := 1
        );
        PORT (
            clk                     : IN  std_logic;
            adjust                  : IN  std_logic := '0';
            reset                   : IN  std_logic := '0';
            clkout                  : OUT std_logic;
            busy                    : OUT CMU_MULT_STATE_TYPE);
    END COMPONENT;
    
    COMPONENT stratixiigx_hssi_aux_clock_phaseshift 
    GENERIC (
        clk_phase_shift_by : TIME := 0 ps
        );
    PORT    (
        clk                     : IN STD_LOGIC;
        clkout                  : OUT STD_LOGIC
        );
    END COMPONENT;


    SIGNAL pll_clkin,pll_clkin_pre_latency :  std_logic;   
    SIGNAL clk_pll                  :  std_logic;   
    SIGNAL clk_div                  :  std_logic;
    SIGNAL clk_div_delayed          :  std_logic := '0';   
    SIGNAL clk_vco                  :  std_logic;   
    SIGNAL charge_pump              :  std_logic := '1';             --  re-adjust VCO frequency
    SIGNAL charge_pump_delayed      :  std_logic := '1';
    SIGNAL busy                     :  CMU_MULT_STATE_TYPE;   --  VCO state
    SIGNAL detected_fb_clk_edge     :  BOOLEAN := FALSE;   
    SIGNAL last_fb_clk_edge         :  TIME := 0 ps;      
    SIGNAL expected_clk_period      :  TIME := 0 ps;   
    SIGNAL clk_tolerance            :  TIME := 0 ps;   
    SIGNAL real_clk_period          :  TIME := 0 ps;   
    SIGNAL last_pll_clkin_edge      :  TIME;   
    SIGNAL first_pll_clkin_edge_detect     :  std_logic := '0';   
    SIGNAL display_msgs             :  BIT := '1'; 
    SIGNAL freq_viol_msg_sem        :  BIT := '1';  
    SIGNAL reset                    :  std_logic;  
    
    SIGNAL clk_ipd : STD_LOGIC_VECTOR(7 DOWNTO 0);
    SIGNAL dprioin_ipd : STD_LOGIC_VECTOR(39 DOWNTO 0);
    SIGNAL dpriodisable_ipd : STD_LOGIC;
    SIGNAL pllreset_ipd : STD_LOGIC;
    SIGNAL pllpowerdn_ipd : STD_LOGIC;

    SIGNAL tmp_clkout : STD_LOGIC;

    SIGNAL change_in_clk_freq : BOOLEAN := FALSE;

BEGIN

WireDelay : BLOCK
    BEGIN
        loopbits_clk : FOR i in clk'RANGE GENERATE
            VitalWireDelay (clk_ipd(i), clk(i), tipd_clk(i));
        END GENERATE;
        loopbits_dprioin : FOR i in dprioin'RANGE GENERATE
            VitalWireDelay (dprioin_ipd(i), dprioin(i), tipd_dprioin(i));
        END GENERATE;
        VitalWireDelay (dpriodisable_ipd, dpriodisable, tipd_dpriodisable);
        VitalWireDelay (pllreset_ipd, pllreset, tipd_pllreset);
        VitalWireDelay (pllpowerdn_ipd, pllpowerdn, tipd_pllpowerdn);
        
    END BLOCK;
    
    VITALTIMING : process(clk_ipd,tmp_clkout)
    VARIABLE clkout_VitalGlitchData : VitalGlitchDataType;

    BEGIN
        VitalPathDelay01 
        (
            OutSignal => clkout,
            OutSignalName => "CLKOUT",
            OutTemp => tmp_clkout,
            Paths => (
                        0 => (clk_ipd'last_event, tpd_clk_clkout, TRUE)
                     ),
            GlitchData => clkout_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn => XOnChecks,
            MsgOn => MsgOnChecks
        );
    
    END PROCESS;
        
    PROCESS
        FUNCTION select_clock_period (
            clk_select              : IN integer) RETURN TIME IS
            VARIABLE period_int             :  INTEGER;  
            VARIABLE txt : LINE; 
        BEGIN
            CASE clk_select IS
                WHEN 0 =>
                            period_int := inclk0_period;    
                WHEN 1 =>
                            period_int := inclk1_period;    
                WHEN 2 =>
                            period_int := inclk2_period;    
                WHEN 3 =>
                            period_int := inclk3_period;    
                WHEN 4 =>
                            period_int := inclk4_period;    
                WHEN 5 =>
                            period_int := inclk5_period;    
                WHEN 6 =>
                            period_int := inclk6_period;    
                WHEN 7 =>
                            period_int := inclk7_period;    
                WHEN OTHERS  =>
                            period_int := inclk0_period; 
                
            END CASE;
            RETURN((period_int * (1 ps)));
        END select_clock_period;
        VARIABLE clk_per : TIME := select_clock_period(pfd_clk_select);  
    BEGIN      
        expected_clk_period <= clk_per;
        clk_tolerance <= 0.1 * clk_per;    --  same as Stratix   
        WAIT;
    END PROCESS;
    pll_clkin_pre_latency <= clk_ipd(pfd_clk_select) ;
    reset <= pllreset_ipd OR pllpowerdn_ipd ;

    -- Clock latency
    
    clock_latency : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => 1,
            extra_latency => sim_clkout_latency )
        PORT MAP (
            clk => pll_clkin_pre_latency,
            clkout => pll_clkin);   
            
    -- Input frequency checks
    
    PROCESS
    VARIABLE txt:LINE;
    VARIABLE realt : TIME := 0 ps;
    BEGIN
        WAIT UNTIL (pll_clkin'EVENT AND pll_clkin = '1');
        IF (first_pll_clkin_edge_detect = '0') THEN
            first_pll_clkin_edge_detect <= '1';    
        ELSE
            realt := NOW - last_pll_clkin_edge;    
            IF ((realt < expected_clk_period - clk_tolerance) OR (realt > expected_clk_period + clk_tolerance)) THEN
                IF (freq_viol_msg_sem = '1') THEN
                    assert FALSE report "CMU PLL input frequency violation" severity WARNING;  
                    WRITE(txt,string'("Time :"));
                    WRITE(txt,NOW);
                    WRITELINE(output,txt);
                    WRITE(txt,string'("Expected clock period is "));
                    WRITE(txt,expected_clk_period); 
                    WRITE(txt,string'(" but real clock period is "));
                    WRITE(txt,realt);
                    WRITELINE(output,txt);
                    freq_viol_msg_sem <= '0';
                END IF;  
            END IF;
        END IF;
        IF (realt /= real_clk_period AND real_clk_period > 0 ps) THEN
            change_in_clk_freq <= TRUE;
        ELSE
            change_in_clk_freq <= FALSE;
        END IF;
        real_clk_period <= realt;
        last_pll_clkin_edge <= NOW;    
    END PROCESS;

    -- PFD

    PROCESS (clk_pll)
    BEGIN
        IF (clk_pll'EVENT AND clk_pll = '1' AND NOW > 0 ps) THEN
            last_fb_clk_edge <= NOW;    
        END IF;
    END PROCESS;
    
    PROCESS (pll_clkin,reset,busy,change_in_clk_freq)
    BEGIN
        IF (reset'EVENT AND reset /= '1') THEN
            charge_pump <= '1';     
        ELSIF (busy'EVENT AND busy = INACTIVE) THEN -- VCO
            charge_pump <= '0';    
        ELSIF (change_in_clk_freq = TRUE) THEN
            charge_pump <= '1';  
        ELSIF (pll_clkin'EVENT AND (busy /= ACTIVE) AND (busy /= INITIAL) AND pll_clkin = '0' AND NOW > 0 ps) THEN
                IF (last_fb_clk_edge /= last_pll_clkin_edge) THEN
                    charge_pump <= '1';
                END IF;
        END IF;
    END PROCESS;
    
    PROCESS
    VARIABLE txt : LINE;
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1');
        IF (reset = '1') THEN
            ASSERT FALSE REPORT "CMU PLL is reset" SEVERITY NOTE;   
            write (txt, string'("Time: "));
            write (txt, NOW);
            writeline (output,txt);  
        END IF;
    END PROCESS;

    PROCESS(charge_pump,reset)
    VARIABLE txt : LINE;
    BEGIN
        IF (reset'EVENT AND reset = '1') THEN 
            display_msgs <= '0';
        ELSIF (charge_pump'EVENT) THEN
            IF (charge_pump = '1') THEN
                IF (display_msgs = '0') THEN
                    assert false report "CMU PLL lost lock due to reset or change in frequency of input clock" severity NOTE;  
                    write (txt,string'("Time: "));
                    write (txt,NOW);
                    writeline(output,txt);
                    display_msgs <= '1';    
                END IF;
            ELSE
                IF (display_msgs = '1') THEN
                    assert false report "CMU PLL locked to incoming clock" severity NOTE;  
                    write (txt,string'("Time: "));
                    write (txt,NOW);
                    writeline(output,txt);
                    display_msgs <= '0';    
                END IF;
            END IF;
        END IF;
    END PROCESS;
    
    -- VCO output
    vco : stratixiigx_hssi_aux_clock_mult 
        GENERIC MAP (
            clk_multiply_by => multiply_by * divide_by
            )
        PORT MAP (
            clk => pll_clkin,
            adjust => charge_pump,
            reset => reset,
            clkout => clk_vco,
            busy => busy);   
    
    
    -- Post divider /L
    divide_by_L : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => divide_by,
            extra_latency => 0)
        PORT MAP (
            clk => clk_vco,
            reset => reset,
            clkout => clk_div);   
    
    
    -- Feedback
    divide_by_M : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => multiply_by,
            extra_latency => 0)
        PORT MAP (
            clk => clk_div,
            reset => reset,
            clkout => clk_pll);   
            
    -- Extra phase shift on output
    
    extra_ps_clkout : stratixiigx_hssi_aux_clock_phaseshift
        GENERIC MAP (
            clk_phase_shift_by => sim_clkout_phase_shift * 1 ps
        )
        PORT MAP (
            clk  => clk_div,
            clkout  => clk_div_delayed
        );
        
    -- Extra phase shift on lock
    
    extra_ps_lock : stratixiigx_hssi_aux_clock_phaseshift
        GENERIC MAP (
            clk_phase_shift_by => sim_clkout_phase_shift * 1 ps
        )
        PORT MAP (
            clk  => charge_pump,
            clkout  => charge_pump_delayed
        );
    
    tmp_clkout <= clk_div_delayed AND (NOT charge_pump_delayed);
    dprioout <= (OTHERS => '0') WHEN (dpriodisable_ipd = '1') ELSE dprioin_ipd;
    locked <= '0' WHEN (reset = '1') ELSE
              '1' WHEN (busy = INACTIVE) ELSE '0';
    fbclkout <= clk_pll;
    vcobypassout <= pll_clkin;

END cmu_pll_arch;
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 61 mux21 24 oper_decoder 1 oper_selector 5 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  dskw_sm IS 
	 PORT 
	 ( 
		 align_det_sync	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 align_status	:	OUT  STD_LOGIC;
		 clk_1	:	IN  STD_LOGIC;
		 curr_state	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 enable_deskew	:	OUT  STD_LOGIC;
		 fifo_reset_rd	:	OUT  STD_LOGIC;
		 octal_mode	:	IN  STD_LOGIC;
		 rd_align	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 soft_reset	:	IN  STD_LOGIC;
		 sync_status	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0)
	 ); 
 END dskw_sm;

 ARCHITECTURE RTL OF dskw_sm IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 nl0ii49	:	STD_LOGIC := '1';
	 SIGNAL	 nl0ii50	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0ii50_w_lg_Q237w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0ii51	:	STD_LOGIC := '0';
	 SIGNAL	 nl0il46	:	STD_LOGIC := '1';
	 SIGNAL	 nl0il47	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0il47_w_lg_Q207w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0il48	:	STD_LOGIC := '0';
	 SIGNAL	 nl0iO43	:	STD_LOGIC := '1';
	 SIGNAL	 nl0iO44	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0iO44_w_lg_Q179w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0iO45	:	STD_LOGIC := '0';
	 SIGNAL	 nl0li40	:	STD_LOGIC := '1';
	 SIGNAL	 nl0li41	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0li41_w_lg_Q171w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0li42	:	STD_LOGIC := '0';
	 SIGNAL	 nl0ll37	:	STD_LOGIC := '1';
	 SIGNAL	 nl0ll38	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0ll38_w_lg_Q156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0ll39	:	STD_LOGIC := '0';
	 SIGNAL	 nl0lO34	:	STD_LOGIC := '1';
	 SIGNAL	 nl0lO35	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0lO35_w_lg_Q151w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0lO36	:	STD_LOGIC := '0';
	 SIGNAL	 nl0Oi31	:	STD_LOGIC := '1';
	 SIGNAL	 nl0Oi32	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0Oi32_w_lg_Q139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0Oi33	:	STD_LOGIC := '0';
	 SIGNAL	 nl0Ol28	:	STD_LOGIC := '1';
	 SIGNAL	 nl0Ol29	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0Ol29_w_lg_Q123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0Ol30	:	STD_LOGIC := '0';
	 SIGNAL	 nl0OO25	:	STD_LOGIC := '1';
	 SIGNAL	 nl0OO26	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0OO26_w_lg_Q120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0OO27	:	STD_LOGIC := '0';
	 SIGNAL	 nli1i22	:	STD_LOGIC := '1';
	 SIGNAL	 nli1i23	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli1i23_w_lg_Q100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli1i24	:	STD_LOGIC := '0';
	 SIGNAL	 nli1O19	:	STD_LOGIC := '1';
	 SIGNAL	 nli1O20	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli1O20_w_lg_Q86w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli1O21	:	STD_LOGIC := '0';
	 SIGNAL	 nliil16	:	STD_LOGIC := '1';
	 SIGNAL	 nliil17	:	STD_LOGIC := '1';
	 SIGNAL	 nliil18	:	STD_LOGIC := '0';
	 SIGNAL	 nlili13	:	STD_LOGIC := '1';
	 SIGNAL	 nlili14	:	STD_LOGIC := '1';
	 SIGNAL	 nlili15	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi10	:	STD_LOGIC := '1';
	 SIGNAL	 nliOi11	:	STD_LOGIC := '1';
	 SIGNAL	 nliOi12	:	STD_LOGIC := '0';
	 SIGNAL	 nll0l4	:	STD_LOGIC := '1';
	 SIGNAL	 nll0l5	:	STD_LOGIC := '1';
	 SIGNAL	 nll0l6	:	STD_LOGIC := '0';
	 SIGNAL	 nll1l7	:	STD_LOGIC := '1';
	 SIGNAL	 nll1l8	:	STD_LOGIC := '1';
	 SIGNAL  wire_nll1l8_w_lg_Q47w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nll1l9	:	STD_LOGIC := '0';
	 SIGNAL	 nlliO1	:	STD_LOGIC := '1';
	 SIGNAL	 nlliO2	:	STD_LOGIC := '1';
	 SIGNAL	 nlliO3	:	STD_LOGIC := '0';
	 SIGNAL	n00l	:	STD_LOGIC := '0';
	 SIGNAL	n01l	:	STD_LOGIC := '0';
	 SIGNAL	n01O	:	STD_LOGIC := '0';
	 SIGNAL  wire_n00i_w_lg_n01l79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i_w_lg_n01O242w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n1i	:	STD_LOGIC := '0';
	 SIGNAL	niO	:	STD_LOGIC := '0';
	 SIGNAL	nli	:	STD_LOGIC := '0';
	 SIGNAL	nlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOO	:	STD_LOGIC := '0';
	 SIGNAL  wire_nll_w_lg_nlO82w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll_w_lg_w_lg_nlO82w83w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0O_w_lg_dataout51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n1O_w_lg_dataout52w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_o_range109w111w113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_o_range109w111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_o_range97w140w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_i	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1i_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_o_range109w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_o_range97w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_o_range106w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_o_range112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_o_range110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0il_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n0il_o	:	STD_LOGIC;
	 SIGNAL  wire_n0il_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n0li_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0li_o	:	STD_LOGIC;
	 SIGNAL  wire_n0li_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0ll_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0ll_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ll_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0lO_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lO_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n0Ol_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n0Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_n0Ol_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0l145w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0O81w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1l125w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nll1i50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nli0l :	STD_LOGIC;
	 SIGNAL  nli0O :	STD_LOGIC;
	 SIGNAL  nli1l :	STD_LOGIC;
	 SIGNAL  nliii :	STD_LOGIC;
	 SIGNAL  nlilO :	STD_LOGIC;
	 SIGNAL  nliOO :	STD_LOGIC;
	 SIGNAL  nll0i :	STD_LOGIC;
	 SIGNAL  nll1i :	STD_LOGIC;
	 SIGNAL  nllii :	STD_LOGIC;
	 SIGNAL  nllil :	STD_LOGIC;
 BEGIN

	wire_w_lg_nli0l145w(0) <= NOT nli0l;
	wire_w_lg_nli0O81w(0) <= NOT nli0O;
	wire_w_lg_nli1l125w(0) <= NOT nli1l;
	wire_w_lg_nll1i50w(0) <= NOT nll1i;
	wire_w_lg_soft_reset19w(0) <= NOT soft_reset;
	align_status <= niO;
	curr_state <= ( "0" & n1i & nlOO & nlOl);
	enable_deskew <= n00l;
	fifo_reset_rd <= (n00l AND wire_n00i_w_lg_n01O242w(0));
	nli0l <= (wire_nll_w_lg_w_lg_nlO82w83w(0) OR wire_nli1O20_w_lg_Q86w(0));
	nli0O <= (wire_n0O_dataout AND wire_n00i_w_lg_n01l79w(0));
	nli1l <= wire_nll_w_lg_w_lg_nlO82w83w(0);
	nliii <= ((nlO AND wire_nlll_dataout) AND nliil17);
	nlilO <= ((((((((align_det_sync(3) AND align_det_sync(2)) AND align_det_sync(1)) AND align_det_sync(0)) AND align_det_sync(7)) AND align_det_sync(6)) AND align_det_sync(5)) AND align_det_sync(4)) AND nliOi11);
	nliOO <= (wire_n0O_w_lg_dataout51w(0) AND wire_n1O_w_lg_dataout52w(0));
	nll0i <= ((((((((rd_align(3) AND rd_align(2)) AND rd_align(1)) AND rd_align(0)) AND rd_align(7)) AND rd_align(6)) AND rd_align(5)) AND rd_align(4)) AND nll0l5);
	nll1i <= ((((((((rd_align(3) OR rd_align(2)) OR rd_align(1)) OR rd_align(0)) OR rd_align(7)) OR rd_align(6)) OR rd_align(5)) OR rd_align(4)) OR wire_nll1l8_w_lg_Q47w(0));
	nllii <= '1';
	nllil <= ((((((((sync_status(3) AND sync_status(2)) AND sync_status(1)) AND sync_status(0)) AND sync_status(7)) AND sync_status(6)) AND sync_status(5)) AND sync_status(4)) AND nlliO2);
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0ii49 <= nl0ii51;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0ii50 <= (nl0ii51 XOR nl0ii49);
		END IF;
	END PROCESS;
	wire_nl0ii50_w_lg_Q237w(0) <= nl0ii50 AND wire_niii_dataout;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0ii51 <= nl0ii49;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0il46 <= nl0il48;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0il47 <= (nl0il48 XOR nl0il46);
		END IF;
	END PROCESS;
	wire_nl0il47_w_lg_Q207w(0) <= nl0il47 AND wire_nliO_dataout;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0il48 <= nl0il46;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0iO43 <= nl0iO45;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0iO44 <= (nl0iO45 XOR nl0iO43);
		END IF;
	END PROCESS;
	wire_nl0iO44_w_lg_Q179w(0) <= nl0iO44 AND wire_nl1O_dataout;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0iO45 <= nl0iO43;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0li40 <= nl0li42;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0li41 <= (nl0li42 XOR nl0li40);
		END IF;
	END PROCESS;
	wire_nl0li41_w_lg_Q171w(0) <= nl0li41 AND wire_ni1i_w_o_range106w(0);
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0li42 <= nl0li40;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0ll37 <= nl0ll39;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0ll38 <= (nl0ll39 XOR nl0ll37);
		END IF;
	END PROCESS;
	wire_nl0ll38_w_lg_Q156w(0) <= nl0ll38 AND wire_ni1i_w_o_range112w(0);
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0ll39 <= nl0ll37;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0lO34 <= nl0lO36;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0lO35 <= (nl0lO36 XOR nl0lO34);
		END IF;
	END PROCESS;
	wire_nl0lO35_w_lg_Q151w(0) <= nl0lO35 AND wire_w_lg_nli1l125w(0);
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0lO36 <= nl0lO34;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Oi31 <= nl0Oi33;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Oi32 <= (nl0Oi33 XOR nl0Oi31);
		END IF;
	END PROCESS;
	wire_nl0Oi32_w_lg_Q139w(0) <= nl0Oi32 AND wire_ni1i_w_o_range106w(0);
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Oi33 <= nl0Oi31;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Ol28 <= nl0Ol30;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Ol29 <= (nl0Ol30 XOR nl0Ol28);
		END IF;
	END PROCESS;
	wire_nl0Ol29_w_lg_Q123w(0) <= nl0Ol29 AND nlO;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0Ol30 <= nl0Ol28;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0OO25 <= nl0OO27;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0OO26 <= (nl0OO27 XOR nl0OO25);
		END IF;
	END PROCESS;
	wire_nl0OO26_w_lg_Q120w(0) <= nl0OO26 AND nlO;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nl0OO27 <= nl0OO25;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1i22 <= nli1i24;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1i23 <= (nli1i24 XOR nli1i22);
		END IF;
	END PROCESS;
	wire_nli1i23_w_lg_Q100w(0) <= nli1i23 AND wire_ni1i_w_o_range97w(0);
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1i24 <= nli1i22;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1O19 <= nli1O21;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1O20 <= (nli1O21 XOR nli1O19);
		END IF;
	END PROCESS;
	wire_nli1O20_w_lg_Q86w(0) <= NOT nli1O20;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nli1O21 <= nli1O19;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliil16 <= nliil18;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliil17 <= (nliil18 XOR nliil16);
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliil18 <= nliil16;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlili13 <= nlili15;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlili14 <= (nlili15 XOR nlili13);
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlili15 <= nlili13;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliOi10 <= nliOi12;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliOi11 <= (nliOi12 XOR nliOi10);
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nliOi12 <= nliOi10;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll0l4 <= nll0l6;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll0l5 <= (nll0l6 XOR nll0l4);
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll0l6 <= nll0l4;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll1l7 <= nll1l9;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll1l8 <= (nll1l9 XOR nll1l7);
		END IF;
	END PROCESS;
	wire_nll1l8_w_lg_Q47w(0) <= NOT nll1l8;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nll1l9 <= nll1l7;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlliO1 <= nlliO3;
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlliO2 <= (nlliO3 XOR nlliO1);
		END IF;
	END PROCESS;
	PROCESS (clk_1)
	BEGIN
		IF (clk_1 = '1' AND clk_1'event) THEN nlliO3 <= nlliO1;
		END IF;
	END PROCESS;
	PROCESS (clk_1, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n00l <= '1';
				n01l <= '1';
				n01O <= '1';
		ELSIF (clk_1 = '1' AND clk_1'event) THEN
				n00l <= wire_n0li_o;
				n01l <= n01O;
				n01O <= n00l;
		END IF;
	END PROCESS;
	wire_n00i_w_lg_n01l79w(0) <= NOT n01l;
	wire_n00i_w_lg_n01O242w(0) <= NOT n01O;
	PROCESS (clk_1, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n00O <= '0';
				n1i <= '0';
				niO <= '0';
				nli <= '0';
				nlO <= '0';
				nlOl <= '0';
				nlOO <= '0';
		ELSIF (clk_1 = '1' AND clk_1'event) THEN
				n00O <= wire_ni_dataout;
				n1i <= wire_n0Ol_o;
				niO <= nli;
				nli <= wire_n0il_o;
				nlO <= n00O;
				nlOl <= wire_n0ll_o;
				nlOO <= wire_n0lO_o;
		END IF;
	END PROCESS;
	wire_nll_w_lg_nlO82w(0) <= NOT nlO;
	wire_nll_w_lg_w_lg_nlO82w83w(0) <= wire_nll_w_lg_nlO82w(0) OR nliOO;
	wire_n0O_dataout <= nll0i WHEN octal_mode = '1'  ELSE (((rd_align(3) AND rd_align(2)) AND rd_align(1)) AND rd_align(0));
	wire_n0O_w_lg_dataout51w(0) <= NOT wire_n0O_dataout;
	wire_n1O_dataout <= wire_w_lg_nll1i50w(0) WHEN octal_mode = '1'  ELSE (NOT (((rd_align(3) OR rd_align(2)) OR rd_align(1)) OR rd_align(0)));
	wire_n1O_w_lg_dataout52w(0) <= NOT wire_n1O_dataout;
	wire_ni_dataout <= nllil WHEN octal_mode = '1'  ELSE (((sync_status(3) AND sync_status(2)) AND sync_status(1)) AND sync_status(0));
	wire_ni0i_dataout <= wire_n0O_w_lg_dataout51w(0) AND NOT(nli1l);
	wire_ni0O_dataout <= n00l OR wire_nll_w_lg_nlO82w(0);
	wire_ni1l_dataout <= n00l OR nli1l;
	wire_ni1O_dataout <= nli AND NOT(nli1l);
	wire_niii_dataout <= nli AND NOT(wire_nll_w_lg_nlO82w(0));
	wire_niil_dataout <= wire_nili_dataout AND NOT(wire_nll_w_lg_nlO82w(0));
	wire_niiO_dataout <= wire_nill_dataout AND NOT(wire_nll_w_lg_nlO82w(0));
	wire_nili_dataout <= wire_n0O_dataout OR nliOO;
	wire_nill_dataout <= wire_n0O_w_lg_dataout51w(0) OR nliOO;
	wire_nilO_dataout <= wire_niOl_dataout AND NOT(wire_nll_w_lg_nlO82w(0));
	wire_niOi_dataout <= nliOO AND NOT(wire_nll_w_lg_nlO82w(0));
	wire_niOl_dataout <= wire_n0O_w_lg_dataout51w(0) AND NOT(nliOO);
	wire_niOO_dataout <= nli WHEN nli0l = '1'  ELSE wire_nl0i_dataout;
	wire_nl0i_dataout <= nli OR wire_n0O_dataout;
	wire_nl0O_dataout <= wire_w_lg_nli0O81w(0) AND NOT(nli0l);
	wire_nl1i_dataout <= n00l OR nli0l;
	wire_nl1l_dataout <= wire_n0O_w_lg_dataout51w(0) AND NOT(nli0l);
	wire_nl1O_dataout <= wire_n0O_dataout AND NOT(nli0l);
	wire_nlii_dataout <= nli0O AND NOT(nli0l);
	wire_nliO_dataout <= n00l AND NOT(nliii);
	wire_nlll_dataout <= nlilO WHEN octal_mode = '1'  ELSE ((((align_det_sync(3) AND align_det_sync(2)) AND align_det_sync(1)) AND align_det_sync(0)) AND nlili14);
	wire_ni1i_w_lg_w_lg_w_o_range109w111w113w(0) <= wire_ni1i_w_lg_w_o_range109w111w(0) OR wire_ni1i_w_o_range112w(0);
	wire_ni1i_w_lg_w_o_range109w111w(0) <= wire_ni1i_w_o_range109w(0) OR wire_ni1i_w_o_range110w(0);
	wire_ni1i_w_lg_w_o_range97w140w(0) <= wire_ni1i_w_o_range97w(0) OR wire_ni1i_w_o_range112w(0);
	wire_ni1i_i <= ( "1" & n1i & nlOO & nlOl);
	wire_ni1i_w_o_range109w(0) <= wire_ni1i_o(10);
	wire_ni1i_w_o_range97w(0) <= wire_ni1i_o(12);
	wire_ni1i_w_o_range106w(0) <= wire_ni1i_o(15);
	wire_ni1i_w_o_range112w(0) <= wire_ni1i_o(8);
	wire_ni1i_w_o_range110w(0) <= wire_ni1i_o(9);
	ni1i :  oper_decoder
	  GENERIC MAP (
		width_i => 4,
		width_o => 16
	  )
	  PORT MAP ( 
		i => wire_ni1i_i,
		o => wire_ni1i_o
	  );
	wire_n0il_data <= ( "0" & wire_ni1O_dataout & wire_niii_dataout & wire_nl0ii50_w_lg_Q237w & wire_niii_dataout & wire_niOO_dataout & nli);
	wire_n0il_sel <= ( "0" & wire_ni1i_o(15 DOWNTO 11) & wire_ni1i_w_lg_w_lg_w_o_range109w111w113w);
	n0il :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_n0il_data,
		o => wire_n0il_o,
		sel => wire_n0il_sel
	  );
	wire_n0li_data <= ( "1" & wire_ni1l_dataout & wire_ni0O_dataout & wire_ni0O_dataout & wire_ni0O_dataout & wire_nl1i_dataout & wire_nl1i_dataout & wire_nl1i_dataout & wire_nl0il47_w_lg_Q207w);
	wire_n0li_sel <= ( "0" & wire_ni1i_o(15 DOWNTO 8));
	n0li :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0li_data,
		o => wire_n0li_o,
		sel => wire_n0li_sel
	  );
	wire_n0ll_data <= ( "0" & wire_ni0i_dataout & wire_niil_dataout & wire_nilO_dataout & wire_niOi_dataout & wire_nl1l_dataout & wire_nl0iO44_w_lg_Q179w & wire_nl0O_dataout & nliii);
	wire_n0ll_sel <= ( "0" & wire_nl0li41_w_lg_Q171w & wire_ni1i_o(14 DOWNTO 9) & wire_nl0ll38_w_lg_Q156w);
	n0ll :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0ll_data,
		o => wire_n0ll_o,
		sel => wire_n0ll_sel
	  );
	wire_n0lO_data <= ( "0" & wire_nl0lO35_w_lg_Q151w & wire_niiO_dataout & wire_niOi_dataout & wire_nl1l_dataout & wire_w_lg_nli0l145w & wire_nlii_dataout);
	wire_n0lO_sel <= ( wire_ni1i_w_lg_w_o_range97w140w & wire_nl0Oi32_w_lg_Q139w & wire_ni1i_o(14 DOWNTO 13) & wire_ni1i_o(11 DOWNTO 9));
	n0lO :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_n0lO_data,
		o => wire_n0lO_o,
		sel => wire_n0lO_sel
	  );
	wire_n0Ol_data <= ( "0" & wire_w_lg_nli1l125w & wire_nl0Ol29_w_lg_Q123w & wire_nl0OO26_w_lg_Q120w & nlO & wire_nl1O_dataout);
	wire_n0Ol_sel <= ( wire_ni1i_w_lg_w_lg_w_o_range109w111w113w & wire_ni1i_o(15 DOWNTO 13) & wire_nli1i23_w_lg_Q100w & wire_ni1i_o(11));
	n0Ol :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_n0Ol_data,
		o => wire_n0Ol_o,
		sel => wire_n0Ol_sel
	  );

 END RTL; --dskw_sm
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 153 mux21 336 oper_add 1 oper_decoder 1 oper_less_than 1 oper_selector 39 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  tx_sm IS 
	 PORT 
	 ( 
		 curr_state	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 indv	:	IN  STD_LOGIC;
		 rd_enable_sync	:	IN  STD_LOGIC;
		 sm_ctl	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 sm_data	:	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 soft_reset	:	IN  STD_LOGIC;
		 tx_clk	:	IN  STD_LOGIC;
		 tx_ctl	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 tx_data	:	IN  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 tx_local_fault	:	OUT  STD_LOGIC;
		 tx_local_fault_clr	:	IN  STD_LOGIC;
		 tx_local_fault_det	:	OUT  STD_LOGIC
	 ); 
 END tx_sm;

 ARCHITECTURE RTL OF tx_sm IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 niOlil58	:	STD_LOGIC := '1';
	 SIGNAL	 niOlil59	:	STD_LOGIC := '1';
	 SIGNAL	 niOlil60	:	STD_LOGIC := '0';
	 SIGNAL	 niOlOi55	:	STD_LOGIC := '1';
	 SIGNAL	 niOlOi56	:	STD_LOGIC := '1';
	 SIGNAL	 niOlOi57	:	STD_LOGIC := '0';
	 SIGNAL	 niOO1O52	:	STD_LOGIC := '1';
	 SIGNAL	 niOO1O53	:	STD_LOGIC := '1';
	 SIGNAL	 niOO1O54	:	STD_LOGIC := '0';
	 SIGNAL	 niOOii49	:	STD_LOGIC := '1';
	 SIGNAL	 niOOii50	:	STD_LOGIC := '1';
	 SIGNAL	 niOOii51	:	STD_LOGIC := '0';
	 SIGNAL	 niOOll46	:	STD_LOGIC := '1';
	 SIGNAL	 niOOll47	:	STD_LOGIC := '1';
	 SIGNAL	 niOOll48	:	STD_LOGIC := '0';
	 SIGNAL	 niOOOl43	:	STD_LOGIC := '1';
	 SIGNAL	 niOOOl44	:	STD_LOGIC := '1';
	 SIGNAL	 niOOOl45	:	STD_LOGIC := '0';
	 SIGNAL	 nl100O28	:	STD_LOGIC := '1';
	 SIGNAL	 nl100O29	:	STD_LOGIC := '1';
	 SIGNAL	 nl100O30	:	STD_LOGIC := '0';
	 SIGNAL	 nl10iO25	:	STD_LOGIC := '1';
	 SIGNAL	 nl10iO26	:	STD_LOGIC := '1';
	 SIGNAL	 nl10iO27	:	STD_LOGIC := '0';
	 SIGNAL	 nl10OO22	:	STD_LOGIC := '1';
	 SIGNAL	 nl10OO23	:	STD_LOGIC := '1';
	 SIGNAL	 nl10OO24	:	STD_LOGIC := '0';
	 SIGNAL	 nl110l37	:	STD_LOGIC := '1';
	 SIGNAL	 nl110l38	:	STD_LOGIC := '1';
	 SIGNAL	 nl110l39	:	STD_LOGIC := '0';
	 SIGNAL	 nl111i40	:	STD_LOGIC := '1';
	 SIGNAL	 nl111i41	:	STD_LOGIC := '1';
	 SIGNAL	 nl111i42	:	STD_LOGIC := '0';
	 SIGNAL	 nl11lO34	:	STD_LOGIC := '1';
	 SIGNAL	 nl11lO35	:	STD_LOGIC := '1';
	 SIGNAL	 nl11lO36	:	STD_LOGIC := '0';
	 SIGNAL	 nl11OO31	:	STD_LOGIC := '1';
	 SIGNAL	 nl11OO32	:	STD_LOGIC := '1';
	 SIGNAL	 nl11OO33	:	STD_LOGIC := '0';
	 SIGNAL	 nl1i0O19	:	STD_LOGIC := '1';
	 SIGNAL	 nl1i0O20	:	STD_LOGIC := '1';
	 SIGNAL	 nl1i0O21	:	STD_LOGIC := '0';
	 SIGNAL	 nl1ili16	:	STD_LOGIC := '1';
	 SIGNAL	 nl1ili17	:	STD_LOGIC := '1';
	 SIGNAL	 nl1ili18	:	STD_LOGIC := '0';
	 SIGNAL	 nl1iOl13	:	STD_LOGIC := '1';
	 SIGNAL	 nl1iOl14	:	STD_LOGIC := '1';
	 SIGNAL	 nl1iOl15	:	STD_LOGIC := '0';
	 SIGNAL	 nl1l1l10	:	STD_LOGIC := '1';
	 SIGNAL	 nl1l1l11	:	STD_LOGIC := '1';
	 SIGNAL	 nl1l1l12	:	STD_LOGIC := '0';
	 SIGNAL	 nl1lii7	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lii8	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lii9	:	STD_LOGIC := '0';
	 SIGNAL	 nl1lll4	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lll5	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lll6	:	STD_LOGIC := '0';
	 SIGNAL	 nl1lOl1	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lOl2	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lOl3	:	STD_LOGIC := '0';
	 SIGNAL	n00Oi	:	STD_LOGIC := '0';
	 SIGNAL	n00Ol	:	STD_LOGIC := '0';
	 SIGNAL	n00OO	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	n101i	:	STD_LOGIC := '0';
	 SIGNAL	n101l	:	STD_LOGIC := '0';
	 SIGNAL	n101O	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	niili	:	STD_LOGIC := '0';
	 SIGNAL	niill	:	STD_LOGIC := '0';
	 SIGNAL	niilO	:	STD_LOGIC := '0';
	 SIGNAL	nlilO	:	STD_LOGIC := '0';
	 SIGNAL	nll00l	:	STD_LOGIC := '0';
	 SIGNAL	nll00O	:	STD_LOGIC := '0';
	 SIGNAL	nll01O	:	STD_LOGIC := '0';
	 SIGNAL	nll0ii	:	STD_LOGIC := '0';
	 SIGNAL	nll0il	:	STD_LOGIC := '0';
	 SIGNAL	nll0O	:	STD_LOGIC := '0';
	 SIGNAL	nllii	:	STD_LOGIC := '0';
	 SIGNAL	nllil	:	STD_LOGIC := '0';
	 SIGNAL	nllll	:	STD_LOGIC := '0';
	 SIGNAL	nllOll	:	STD_LOGIC := '0';
	 SIGNAL	nllOlO	:	STD_LOGIC := '0';
	 SIGNAL	nllOOi	:	STD_LOGIC := '0';
	 SIGNAL	nllOOl	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni1i_w_lg_ni1l287w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_nlilO297w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_nll01O289w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_nll0O298w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_nllOll156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlilOl	:	STD_LOGIC := '0';
	 SIGNAL	nlilOO	:	STD_LOGIC := '0';
	 SIGNAL	nliO0i	:	STD_LOGIC := '0';
	 SIGNAL	nliO1i	:	STD_LOGIC := '0';
	 SIGNAL	nliO1l	:	STD_LOGIC := '0';
	 SIGNAL  wire_nliO1O_w_lg_nliO0i1732w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlil0O	:	STD_LOGIC := '0';
	 SIGNAL	nlilii	:	STD_LOGIC := '0';
	 SIGNAL	nlilil	:	STD_LOGIC := '0';
	 SIGNAL	nliliO	:	STD_LOGIC := '0';
	 SIGNAL	nlilli	:	STD_LOGIC := '0';
	 SIGNAL	nlilll	:	STD_LOGIC := '0';
	 SIGNAL	nlillO	:	STD_LOGIC := '0';
	 SIGNAL	nlilOi	:	STD_LOGIC := '0';
	 SIGNAL	nliO0l	:	STD_LOGIC := '0';
	 SIGNAL	nliO0O	:	STD_LOGIC := '0';
	 SIGNAL	nliOii	:	STD_LOGIC := '0';
	 SIGNAL	nliOil	:	STD_LOGIC := '0';
	 SIGNAL	nliOiO	:	STD_LOGIC := '0';
	 SIGNAL	nliOli	:	STD_LOGIC := '0';
	 SIGNAL	nliOll	:	STD_LOGIC := '0';
	 SIGNAL	nliOlO	:	STD_LOGIC := '0';
	 SIGNAL	nliOOi	:	STD_LOGIC := '0';
	 SIGNAL	nliOOl	:	STD_LOGIC := '0';
	 SIGNAL	nliOOO	:	STD_LOGIC := '0';
	 SIGNAL	nll01l	:	STD_LOGIC := '0';
	 SIGNAL	nll10i	:	STD_LOGIC := '0';
	 SIGNAL	nll10l	:	STD_LOGIC := '0';
	 SIGNAL	nll10O	:	STD_LOGIC := '0';
	 SIGNAL	nll11i	:	STD_LOGIC := '0';
	 SIGNAL	nll11l	:	STD_LOGIC := '0';
	 SIGNAL	nll11O	:	STD_LOGIC := '0';
	 SIGNAL	nll1ii	:	STD_LOGIC := '0';
	 SIGNAL	nll1il	:	STD_LOGIC := '0';
	 SIGNAL	nll1iO	:	STD_LOGIC := '0';
	 SIGNAL	nll1li	:	STD_LOGIC := '0';
	 SIGNAL	nll1ll	:	STD_LOGIC := '0';
	 SIGNAL	nll1lO	:	STD_LOGIC := '0';
	 SIGNAL	nll1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nll1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nll1OO	:	STD_LOGIC := '0';
	 SIGNAL  wire_nll01i_w_lg_w_lg_w_lg_nll1OO285w286w1354w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i_w_lg_w_lg_nll1OO1357w1358w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i_w_lg_w_lg_nll1OO291w292w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i_w_lg_w_lg_nll1OO285w286w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i_w_lg_nll1OO1357w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i_w_lg_nll1OO291w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i_w_lg_nlilii158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i_w_lg_nll01l1356w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i_w_lg_nll1Ol280w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll01i_w_lg_nll1OO285w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nllill	:	STD_LOGIC := '0';
	 SIGNAL	nllilO	:	STD_LOGIC := '0';
	 SIGNAL	nlliOi	:	STD_LOGIC := '0';
	 SIGNAL	nlliOl	:	STD_LOGIC := '0';
	 SIGNAL	nlliOO	:	STD_LOGIC := '0';
	 SIGNAL	nlll0i	:	STD_LOGIC := '0';
	 SIGNAL	nlll0l	:	STD_LOGIC := '0';
	 SIGNAL	nlll0O	:	STD_LOGIC := '0';
	 SIGNAL	nlll1i	:	STD_LOGIC := '0';
	 SIGNAL	nlll1l	:	STD_LOGIC := '0';
	 SIGNAL	nlll1O	:	STD_LOGIC := '0';
	 SIGNAL	nlllii	:	STD_LOGIC := '0';
	 SIGNAL	nlllil	:	STD_LOGIC := '0';
	 SIGNAL	nllliO	:	STD_LOGIC := '0';
	 SIGNAL	nlllli	:	STD_LOGIC := '0';
	 SIGNAL	nlllll	:	STD_LOGIC := '0';
	 SIGNAL	nllllO	:	STD_LOGIC := '0';
	 SIGNAL	nlllOi	:	STD_LOGIC := '0';
	 SIGNAL	nlllOl	:	STD_LOGIC := '0';
	 SIGNAL	nlllOO	:	STD_LOGIC := '0';
	 SIGNAL	nllO0i	:	STD_LOGIC := '0';
	 SIGNAL	nllO0l	:	STD_LOGIC := '0';
	 SIGNAL	nllO0O	:	STD_LOGIC := '0';
	 SIGNAL	nllO1i	:	STD_LOGIC := '0';
	 SIGNAL	nllO1l	:	STD_LOGIC := '0';
	 SIGNAL	nllO1O	:	STD_LOGIC := '0';
	 SIGNAL	nllOil	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllOii_w_lg_w_lg_w1728w1730w1731w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w1728w1730w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w1728w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_lg_w_lg_w_lg_w1718w1720w1722w1724w1726w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_lg_w_lg_w1718w1720w1722w1724w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_lg_w1718w1720w1722w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w1718w1720w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w1718w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_lg_w_lg_w_lg_w1708w1710w1712w1714w1716w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_lg_w_lg_w1708w1710w1712w1714w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_lg_w1708w1710w1712w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w1708w1710w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w1708w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_lg_w_lg_w_lg_nlliOO1700w1702w1704w1706w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_lg_w_lg_nlliOO1700w1702w1704w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_lg_nlliOO1700w1702w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlliOO1700w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlll0i1707w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlll0l1709w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlll0O1711w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlll1i1701w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlll1l1703w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlll1O1705w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlllii1713w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlllil1715w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nllliO1717w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlllli1719w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlllll1721w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nllllO1723w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlllOi1725w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlllOl1727w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nlllOO1729w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nllO0i1738w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nllO0l1740w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nllO0O1742w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nllO1l1734w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nllO1O1736w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_nllOil1744w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlli0i_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlli0i_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_nlli0i_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlO00i_i	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO00i_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nlOil_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOil_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlOil_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ili_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0ili_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ili_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0ill_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0ill_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ill_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0ilO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0ilO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ilO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0iOi_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0iOi_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iOi_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0iOl_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0iOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iOl_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0iOO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0iOO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iOO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0l1i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0l1i_o	:	STD_LOGIC;
	 SIGNAL  wire_n0l1i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0l1l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0l1l_o	:	STD_LOGIC;
	 SIGNAL  wire_n0l1l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0l1O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n0l1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0l1O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10Oi_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_n10Oi_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10Ol_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_n10Ol_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10OO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n10OO_o	:	STD_LOGIC;
	 SIGNAL  wire_n10OO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i0i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i0i_o	:	STD_LOGIC;
	 SIGNAL  wire_n1i0i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i0l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i0l_o	:	STD_LOGIC;
	 SIGNAL  wire_n1i0l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i0O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i0O_o	:	STD_LOGIC;
	 SIGNAL  wire_n1i0O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i1i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i1i_o	:	STD_LOGIC;
	 SIGNAL  wire_n1i1i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i1l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i1l_o	:	STD_LOGIC;
	 SIGNAL  wire_n1i1l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i1O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1i1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n1i1O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilii_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilii_o	:	STD_LOGIC;
	 SIGNAL  wire_nilii_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilil_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilil_o	:	STD_LOGIC;
	 SIGNAL  wire_nilil_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niliO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_niliO_o	:	STD_LOGIC;
	 SIGNAL  wire_niliO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilli_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilli_o	:	STD_LOGIC;
	 SIGNAL  wire_nilli_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilll_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilll_o	:	STD_LOGIC;
	 SIGNAL  wire_nilll_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nillO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nillO_o	:	STD_LOGIC;
	 SIGNAL  wire_nillO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilOi_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOi_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilOl_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOl_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilOO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nilOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nilOO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO01i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO01i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO01i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO01l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO01l_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO01l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1iO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1iO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1iO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1li_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1li_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1li_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1ll_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1ll_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1ll_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1lO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1lO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1Oi_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1Oi_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1Ol_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1Ol_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1OO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlO1OO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlOli_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlOli_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOli_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nlOlO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlOlO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOlO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlOOi_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nlOOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOOi_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_w89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w29w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w58w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w86w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w17w20w22w24w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w47w49w51w53w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w75w77w79w81w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w118w120w123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w17w20w22w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w47w49w51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w75w77w79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w118w120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w17w20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w47w49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w75w77w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w118w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w47w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w75w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w104w107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl11il94w108w111w113w116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl1O0i1w8w10w13w15w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_tx_ctl_range35w37w40w42w44w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_tx_ctl_range63w65w68w70w73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_nl11il94w108w111w113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_nl1O0i1w8w10w13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_tx_ctl_range35w37w40w42w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_tx_ctl_range63w65w68w70w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_tx_ctl_range95w97w100w102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nl11il94w108w111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nl1O0i1w8w10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_tx_ctl_range2w4w7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_tx_ctl_range35w37w40w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_tx_ctl_range63w65w68w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_tx_ctl_range95w97w100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_niOiOl157w1353w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl11il94w108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl1O0i1w8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rd_enable_sync154w275w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOiil282w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOili278w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rd_enable_sync277w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range2w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range35w37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range63w65w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_ctl_range95w97w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range309w1458w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range829w1558w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range1095w1689w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range569w1511w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOiOl157w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOiOO155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOl1i153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOl1O1084w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOlOO1083w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOO0l126w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOO0O124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOOiO119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOOli117w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOOOi112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl100i76w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl100l74w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl101l80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl101O78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10il69w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10ll64w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10Oi61w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10Ol59w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl110i101w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl111O103w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11ii96w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11il94w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11li92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11ll90w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11Ol85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i0i50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i0l48w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i1l54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i1O52w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1iil43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1iiO41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1ilO36w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1l0i25w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1l0l23w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1l0O21w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1l1i30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1liO16w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1lli14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1lOi9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1O0i1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1O1i3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rd_enable_sync154w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range828w1543w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range308w1457w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range1094w1590w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_range568w1496w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_rd_enable_sync154w275w276w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niOiOl281w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  niO0Oi :	STD_LOGIC;
	 SIGNAL  niO0Ol :	STD_LOGIC;
	 SIGNAL  niO0OO :	STD_LOGIC;
	 SIGNAL  niOi0i :	STD_LOGIC;
	 SIGNAL  niOi0l :	STD_LOGIC;
	 SIGNAL  niOi0O :	STD_LOGIC;
	 SIGNAL  niOi1i :	STD_LOGIC;
	 SIGNAL  niOi1l :	STD_LOGIC;
	 SIGNAL  niOi1O :	STD_LOGIC;
	 SIGNAL  niOiii :	STD_LOGIC;
	 SIGNAL  niOiil :	STD_LOGIC;
	 SIGNAL  niOiiO :	STD_LOGIC;
	 SIGNAL  niOili :	STD_LOGIC;
	 SIGNAL  niOill :	STD_LOGIC;
	 SIGNAL  niOilO :	STD_LOGIC;
	 SIGNAL  niOiOi :	STD_LOGIC;
	 SIGNAL  niOiOl :	STD_LOGIC;
	 SIGNAL  niOiOO :	STD_LOGIC;
	 SIGNAL  niOl0i :	STD_LOGIC;
	 SIGNAL  niOl0l :	STD_LOGIC;
	 SIGNAL  niOl0O :	STD_LOGIC;
	 SIGNAL  niOl1i :	STD_LOGIC;
	 SIGNAL  niOl1l :	STD_LOGIC;
	 SIGNAL  niOl1O :	STD_LOGIC;
	 SIGNAL  niOlii :	STD_LOGIC;
	 SIGNAL  niOlli :	STD_LOGIC;
	 SIGNAL  niOlll :	STD_LOGIC;
	 SIGNAL  niOllO :	STD_LOGIC;
	 SIGNAL  niOlOO :	STD_LOGIC;
	 SIGNAL  niOO0l :	STD_LOGIC;
	 SIGNAL  niOO0O :	STD_LOGIC;
	 SIGNAL  niOO1i :	STD_LOGIC;
	 SIGNAL  niOO1l :	STD_LOGIC;
	 SIGNAL  niOOiO :	STD_LOGIC;
	 SIGNAL  niOOli :	STD_LOGIC;
	 SIGNAL  niOOOi :	STD_LOGIC;
	 SIGNAL  nl100i :	STD_LOGIC;
	 SIGNAL  nl100l :	STD_LOGIC;
	 SIGNAL  nl101l :	STD_LOGIC;
	 SIGNAL  nl101O :	STD_LOGIC;
	 SIGNAL  nl10il :	STD_LOGIC;
	 SIGNAL  nl10ll :	STD_LOGIC;
	 SIGNAL  nl10lO :	STD_LOGIC;
	 SIGNAL  nl10Oi :	STD_LOGIC;
	 SIGNAL  nl10Ol :	STD_LOGIC;
	 SIGNAL  nl110i :	STD_LOGIC;
	 SIGNAL  nl111O :	STD_LOGIC;
	 SIGNAL  nl11ii :	STD_LOGIC;
	 SIGNAL  nl11il :	STD_LOGIC;
	 SIGNAL  nl11iO :	STD_LOGIC;
	 SIGNAL  nl11li :	STD_LOGIC;
	 SIGNAL  nl11ll :	STD_LOGIC;
	 SIGNAL  nl11Ol :	STD_LOGIC;
	 SIGNAL  nl1i0i :	STD_LOGIC;
	 SIGNAL  nl1i0l :	STD_LOGIC;
	 SIGNAL  nl1i1l :	STD_LOGIC;
	 SIGNAL  nl1i1O :	STD_LOGIC;
	 SIGNAL  nl1iil :	STD_LOGIC;
	 SIGNAL  nl1iiO :	STD_LOGIC;
	 SIGNAL  nl1ilO :	STD_LOGIC;
	 SIGNAL  nl1iOi :	STD_LOGIC;
	 SIGNAL  nl1l0i :	STD_LOGIC;
	 SIGNAL  nl1l0l :	STD_LOGIC;
	 SIGNAL  nl1l0O :	STD_LOGIC;
	 SIGNAL  nl1l1i :	STD_LOGIC;
	 SIGNAL  nl1liO :	STD_LOGIC;
	 SIGNAL  nl1lli :	STD_LOGIC;
	 SIGNAL  nl1lOi :	STD_LOGIC;
	 SIGNAL  nl1O0i :	STD_LOGIC;
	 SIGNAL  nl1O1i :	STD_LOGIC;
	 SIGNAL  wire_w_tx_ctl_range2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_ctl_range35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_ctl_range63w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_ctl_range95w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range309w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range829w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range828w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range308w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range1095w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range1094w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range569w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_range568w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_gnd <= '0';
	wire_w89w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w86w(0) AND nl11lO35;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w29w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w(0) AND nl1l1l11;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w58w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w(0) AND nl10OO23;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w86w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w(0) AND wire_w_lg_nl11Ol85w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w(0) <= wire_w_lg_w_lg_w_lg_w17w20w22w24w(0) AND wire_w_lg_nl1l0i25w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w(0) <= wire_w_lg_w_lg_w_lg_w47w49w51w53w(0) AND wire_w_lg_nl1i1l54w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w(0) <= wire_w_lg_w_lg_w_lg_w75w77w79w81w(0) AND nl11OO32;
	wire_w_lg_w_lg_w_lg_w17w20w22w24w(0) <= wire_w_lg_w_lg_w17w20w22w(0) AND wire_w_lg_nl1l0l23w(0);
	wire_w_lg_w_lg_w_lg_w47w49w51w53w(0) <= wire_w_lg_w_lg_w47w49w51w(0) AND wire_w_lg_nl1i1O52w(0);
	wire_w_lg_w_lg_w_lg_w75w77w79w81w(0) <= wire_w_lg_w_lg_w75w77w79w(0) AND wire_w_lg_nl101l80w(0);
	wire_w_lg_w_lg_w118w120w123w(0) <= wire_w_lg_w118w120w(0) AND niOOii50;
	wire_w_lg_w_lg_w17w20w22w(0) <= wire_w_lg_w17w20w(0) AND wire_w_lg_nl1l0O21w(0);
	wire_w_lg_w_lg_w47w49w51w(0) <= wire_w_lg_w47w49w(0) AND wire_w_lg_nl1i0i50w(0);
	wire_w_lg_w_lg_w75w77w79w(0) <= wire_w_lg_w75w77w(0) AND wire_w_lg_nl101O78w(0);
	wire_w_lg_w118w120w(0) <= wire_w118w(0) AND wire_w_lg_niOOiO119w(0);
	wire_w_lg_w17w20w(0) <= wire_w17w(0) AND nl1lii8;
	wire_w_lg_w47w49w(0) <= wire_w47w(0) AND wire_w_lg_nl1i0l48w(0);
	wire_w_lg_w75w77w(0) <= wire_w75w(0) AND wire_w_lg_nl100i76w(0);
	wire_w118w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl11il94w108w111w113w116w(0) AND wire_w_lg_niOOli117w(0);
	wire_w17w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl1O0i1w8w10w13w15w(0) AND wire_w_lg_nl1liO16w(0);
	wire_w47w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_tx_ctl_range35w37w40w42w44w(0) AND nl1i0O20;
	wire_w75w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_tx_ctl_range63w65w68w70w73w(0) AND wire_w_lg_nl100l74w(0);
	wire_w_lg_w104w107w(0) <= wire_w104w(0) AND nl111i41;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl11il94w108w111w113w116w(0) <= wire_w_lg_w_lg_w_lg_w_lg_nl11il94w108w111w113w(0) AND niOOll47;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl1O0i1w8w10w13w15w(0) <= wire_w_lg_w_lg_w_lg_w_lg_nl1O0i1w8w10w13w(0) AND wire_w_lg_nl1lli14w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w_tx_ctl_range35w37w40w42w44w(0) <= wire_w_lg_w_lg_w_lg_w_tx_ctl_range35w37w40w42w(0) AND wire_w_lg_nl1iil43w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w_tx_ctl_range63w65w68w70w73w(0) <= wire_w_lg_w_lg_w_lg_w_tx_ctl_range63w65w68w70w(0) AND nl100O29;
	wire_w104w(0) <= wire_w_lg_w_lg_w_lg_w_tx_ctl_range95w97w100w102w(0) AND wire_w_lg_nl111O103w(0);
	wire_w_lg_w_lg_w_lg_w_lg_nl11il94w108w111w113w(0) <= wire_w_lg_w_lg_w_lg_nl11il94w108w111w(0) AND wire_w_lg_niOOOi112w(0);
	wire_w_lg_w_lg_w_lg_w_lg_nl1O0i1w8w10w13w(0) <= wire_w_lg_w_lg_w_lg_nl1O0i1w8w10w(0) AND nl1lll5;
	wire_w_lg_w_lg_w_lg_w_tx_ctl_range35w37w40w42w(0) <= wire_w_lg_w_lg_w_tx_ctl_range35w37w40w(0) AND wire_w_lg_nl1iiO41w(0);
	wire_w_lg_w_lg_w_lg_w_tx_ctl_range63w65w68w70w(0) <= wire_w_lg_w_lg_w_tx_ctl_range63w65w68w(0) AND wire_w_lg_nl10il69w(0);
	wire_w_lg_w_lg_w_lg_w_tx_ctl_range95w97w100w102w(0) <= wire_w_lg_w_lg_w_tx_ctl_range95w97w100w(0) AND wire_w_lg_nl110i101w(0);
	wire_w_lg_w_lg_w_lg_nl11il94w108w111w(0) <= wire_w_lg_w_lg_nl11il94w108w(0) AND niOOOl44;
	wire_w_lg_w_lg_w_lg_nl1O0i1w8w10w(0) <= wire_w_lg_w_lg_nl1O0i1w8w(0) AND wire_w_lg_nl1lOi9w(0);
	wire_w_lg_w_lg_w_tx_ctl_range2w4w7w(0) <= wire_w_lg_w_tx_ctl_range2w4w(0) AND nl1lOl2;
	wire_w_lg_w_lg_w_tx_ctl_range35w37w40w(0) <= wire_w_lg_w_tx_ctl_range35w37w(0) AND nl1ili17;
	wire_w_lg_w_lg_w_tx_ctl_range63w65w68w(0) <= wire_w_lg_w_tx_ctl_range63w65w(0) AND nl10iO26;
	wire_w_lg_w_lg_w_tx_ctl_range95w97w100w(0) <= wire_w_lg_w_tx_ctl_range95w97w(0) AND nl110l38;
	wire_w_lg_w_lg_niOiOl157w1353w(0) <= wire_w_lg_niOiOl157w(0) AND niOili;
	wire_w_lg_w_lg_nl11il94w108w(0) <= wire_w_lg_nl11il94w(0) AND wire_w_lg_w104w107w(0);
	wire_w_lg_w_lg_nl1O0i1w8w(0) <= wire_w_lg_nl1O0i1w(0) AND wire_w_lg_w_lg_w_tx_ctl_range2w4w7w(0);
	wire_w_lg_w_lg_rd_enable_sync154w275w(0) <= wire_w_lg_rd_enable_sync154w(0) AND niOiii;
	wire_w_lg_niOiil282w(0) <= niOiil AND wire_w_lg_niOiOl281w(0);
	wire_w_lg_niOili278w(0) <= niOili AND wire_w_lg_rd_enable_sync277w(0);
	wire_w_lg_rd_enable_sync277w(0) <= rd_enable_sync AND niOiii;
	wire_w_lg_w_tx_ctl_range2w4w(0) <= wire_w_tx_ctl_range2w(0) AND wire_w_lg_nl1O1i3w(0);
	wire_w_lg_w_tx_ctl_range35w37w(0) <= wire_w_tx_ctl_range35w(0) AND wire_w_lg_nl1ilO36w(0);
	wire_w_lg_w_tx_ctl_range63w65w(0) <= wire_w_tx_ctl_range63w(0) AND wire_w_lg_nl10ll64w(0);
	wire_w_lg_w_tx_ctl_range95w97w(0) <= wire_w_tx_ctl_range95w(0) AND wire_w_lg_nl11ii96w(0);
	wire_w_lg_w_tx_data_range309w1458w(0) <= wire_w_tx_data_range309w(0) AND wire_w_lg_w_tx_data_range308w1457w(0);
	wire_w_lg_w_tx_data_range829w1558w(0) <= wire_w_tx_data_range829w(0) AND wire_w_lg_w_tx_data_range828w1543w(0);
	wire_w_lg_w_tx_data_range1095w1689w(0) <= wire_w_tx_data_range1095w(0) AND wire_w_lg_w_tx_data_range1094w1590w(0);
	wire_w_lg_w_tx_data_range569w1511w(0) <= wire_w_tx_data_range569w(0) AND wire_w_lg_w_tx_data_range568w1496w(0);
	wire_w_lg_niOiOl157w(0) <= NOT niOiOl;
	wire_w_lg_niOiOO155w(0) <= NOT niOiOO;
	wire_w_lg_niOl1i153w(0) <= NOT niOl1i;
	wire_w_lg_niOl1O1084w(0) <= NOT niOl1O;
	wire_w_lg_niOlOO1083w(0) <= NOT niOlOO;
	wire_w_lg_niOO0l126w(0) <= NOT niOO0l;
	wire_w_lg_niOO0O124w(0) <= NOT niOO0O;
	wire_w_lg_niOOiO119w(0) <= NOT niOOiO;
	wire_w_lg_niOOli117w(0) <= NOT niOOli;
	wire_w_lg_niOOOi112w(0) <= NOT niOOOi;
	wire_w_lg_nl100i76w(0) <= NOT nl100i;
	wire_w_lg_nl100l74w(0) <= NOT nl100l;
	wire_w_lg_nl101l80w(0) <= NOT nl101l;
	wire_w_lg_nl101O78w(0) <= NOT nl101O;
	wire_w_lg_nl10il69w(0) <= NOT nl10il;
	wire_w_lg_nl10ll64w(0) <= NOT nl10ll;
	wire_w_lg_nl10Oi61w(0) <= NOT nl10Oi;
	wire_w_lg_nl10Ol59w(0) <= NOT nl10Ol;
	wire_w_lg_nl110i101w(0) <= NOT nl110i;
	wire_w_lg_nl111O103w(0) <= NOT nl111O;
	wire_w_lg_nl11ii96w(0) <= NOT nl11ii;
	wire_w_lg_nl11il94w(0) <= NOT nl11il;
	wire_w_lg_nl11li92w(0) <= NOT nl11li;
	wire_w_lg_nl11ll90w(0) <= NOT nl11ll;
	wire_w_lg_nl11Ol85w(0) <= NOT nl11Ol;
	wire_w_lg_nl1i0i50w(0) <= NOT nl1i0i;
	wire_w_lg_nl1i0l48w(0) <= NOT nl1i0l;
	wire_w_lg_nl1i1l54w(0) <= NOT nl1i1l;
	wire_w_lg_nl1i1O52w(0) <= NOT nl1i1O;
	wire_w_lg_nl1iil43w(0) <= NOT nl1iil;
	wire_w_lg_nl1iiO41w(0) <= NOT nl1iiO;
	wire_w_lg_nl1ilO36w(0) <= NOT nl1ilO;
	wire_w_lg_nl1l0i25w(0) <= NOT nl1l0i;
	wire_w_lg_nl1l0l23w(0) <= NOT nl1l0l;
	wire_w_lg_nl1l0O21w(0) <= NOT nl1l0O;
	wire_w_lg_nl1l1i30w(0) <= NOT nl1l1i;
	wire_w_lg_nl1liO16w(0) <= NOT nl1liO;
	wire_w_lg_nl1lli14w(0) <= NOT nl1lli;
	wire_w_lg_nl1lOi9w(0) <= NOT nl1lOi;
	wire_w_lg_nl1O0i1w(0) <= NOT nl1O0i;
	wire_w_lg_nl1O1i3w(0) <= NOT nl1O1i;
	wire_w_lg_rd_enable_sync154w(0) <= NOT rd_enable_sync;
	wire_w_lg_soft_reset152w(0) <= NOT soft_reset;
	wire_w_lg_w_tx_data_range828w1543w(0) <= NOT wire_w_tx_data_range828w(0);
	wire_w_lg_w_tx_data_range308w1457w(0) <= NOT wire_w_tx_data_range308w(0);
	wire_w_lg_w_tx_data_range1094w1590w(0) <= NOT wire_w_tx_data_range1094w(0);
	wire_w_lg_w_tx_data_range568w1496w(0) <= NOT wire_w_tx_data_range568w(0);
	wire_w_lg_w_lg_w_lg_rd_enable_sync154w275w276w(0) <= wire_w_lg_w_lg_rd_enable_sync154w275w(0) OR wire_nlOil_o;
	wire_w_lg_niOiOl281w(0) <= niOiOl OR wire_nll01i_w_lg_nll1Ol280w(0);
	curr_state <= ( nll01O & ni1l & nll01l & nll1OO);
	niO0Oi <= (wire_w_lg_w_lg_niOiOl157w1353w(0) AND (((wire_nll01i_w_lg_w_lg_w_lg_nll1OO285w286w1354w(0) AND wire_ni1i_w_lg_nll01O289w(0)) OR (wire_nll01i_w_lg_w_lg_nll1OO1357w1358w(0) AND wire_ni1i_w_lg_nll01O289w(0))) OR (nll1Ol AND niOiiO)));
	niO0Ol <= (((((((wire_nlO00i_o(15) OR wire_nlO00i_o(14)) OR wire_nlO00i_o(13)) OR wire_nlO00i_o(12)) OR wire_nlO00i_o(11)) OR wire_nlO00i_o(10)) OR wire_nlO00i_o(9)) OR wire_nlO00i_o(0));
	niO0OO <= (niOl0l OR niOi1l);
	niOi0i <= (niOi0l AND (wire_ni1i_w_lg_nlilO297w(0) AND wire_ni1i_w_lg_nll0O298w(0)));
	niOi0l <= (((((((wire_nllOii_w_lg_w_lg_w1728w1730w1731w(0) AND wire_nliO1O_w_lg_nliO0i1732w(0)) AND wire_nllOii_w_lg_nllO1l1734w(0)) AND wire_nllOii_w_lg_nllO1O1736w(0)) AND wire_nllOii_w_lg_nllO0i1738w(0)) AND wire_nllOii_w_lg_nllO0l1740w(0)) AND wire_nllOii_w_lg_nllO0O1742w(0)) AND wire_nllOii_w_lg_nllOil1744w(0));
	niOi0O <= (nllOll AND ((((wire_nll01i_w_lg_w_lg_nll1OO285w286w(0) AND wire_ni1i_w_lg_ni1l287w(0)) AND wire_ni1i_w_lg_nll01O289w(0)) OR (wire_nll01i_w_lg_w_lg_nll1OO291w292w(0) AND wire_ni1i_w_lg_nll01O289w(0))) AND niOili));
	niOi1i <= (((((((wire_nlO00i_o(15) OR wire_nlO00i_o(14)) OR wire_nlO00i_o(13)) OR wire_nlO00i_o(12)) OR wire_nlO00i_o(11)) OR wire_nlO00i_o(10)) OR wire_nlO00i_o(9)) OR wire_nlO00i_o(0));
	niOi1l <= (niOlll OR niOlii);
	niOi1O <= (((((((wire_nlO00i_o(15) OR wire_nlO00i_o(14)) OR wire_nlO00i_o(13)) OR wire_nlO00i_o(12)) OR wire_nlO00i_o(11)) OR wire_nlO00i_o(10)) OR wire_nlO00i_o(9)) OR wire_nlO00i_o(0));
	niOiii <= ((wire_nll01i_w_lg_nll1OO291w(0) AND wire_ni1i_w_lg_ni1l287w(0)) AND wire_ni1i_w_lg_nll01O289w(0));
	niOiil <= (niOili AND niOiiO);
	niOiiO <= ((wire_nll01i_w_lg_nll1OO1357w(0) AND wire_ni1i_w_lg_ni1l287w(0)) AND wire_ni1i_w_lg_nll01O289w(0));
	niOili <= (niOlOO OR niOl1O);
	niOill <= (((((((((wire_nlO00i_o(15) OR wire_nlO00i_o(14)) OR wire_nlO00i_o(13)) OR wire_nlO00i_o(12)) OR wire_nlO00i_o(11)) OR wire_nlO00i_o(10)) OR wire_nlO00i_o(9)) OR wire_nlO00i_o(0)) OR wire_nlO00i_o(4)) OR wire_nlO00i_o(3));
	niOilO <= (((((((wire_nlO00i_o(15) OR wire_nlO00i_o(14)) OR wire_nlO00i_o(13)) OR wire_nlO00i_o(12)) OR wire_nlO00i_o(11)) OR wire_nlO00i_o(10)) OR wire_nlO00i_o(9)) OR wire_nlO00i_o(0));
	niOiOi <= ((((((((wire_nlO00i_o(15) OR wire_nlO00i_o(14)) OR wire_nlO00i_o(13)) OR wire_nlO00i_o(12)) OR wire_nlO00i_o(11)) OR wire_nlO00i_o(10)) OR wire_nlO00i_o(9)) OR wire_nlO00i_o(0)) OR wire_nlO00i_o(1));
	niOiOl <= ((((nll0il OR nll0ii) OR nll00O) OR nll00l) OR nlil0O);
	niOiOO <= (wire_w_lg_niOiOl157w(0) AND nll1Ol);
	niOl0i <= (tx_ctl(3) AND nl11il);
	niOl0l <= ((tx_ctl(3) AND tx_ctl(2)) AND niOl0O);
	niOl0O <= ((((((((((((((wire_w_lg_w_tx_data_range829w1558w(0) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23)) AND tx_data(24)) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	niOl1i <= (wire_w_lg_niOlOO1083w(0) AND wire_w_lg_niOl1O1084w(0));
	niOl1l <= '1';
	niOl1O <= (((((NOT tx_ctl(3)) AND (NOT tx_ctl(2))) AND (NOT tx_ctl(1))) AND tx_ctl(0)) AND nl1O0i);
	niOlii <= ((((tx_ctl(3) AND tx_ctl(2)) AND tx_ctl(1)) AND niOlli) AND niOlil59);
	niOlli <= ((((((((((((((((((((((wire_w_lg_w_tx_data_range569w1511w(0) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15)) AND tx_data(16)) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND (NOT tx_data(20))) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND (NOT tx_data(23))) AND tx_data(24)) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	niOlll <= (((((tx_ctl(3) AND tx_ctl(2)) AND tx_ctl(1)) AND tx_ctl(0)) AND niOlOi56) AND niOllO);
	niOllO <= ((((((((((((((((((((((((((((((wire_w_lg_w_tx_data_range309w1458w(0) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7)) AND tx_data(8)) AND tx_data(9)) AND tx_data(10)) AND (NOT tx_data(11))) AND (NOT tx_data(12))) AND (NOT tx_data(13))) AND (NOT tx_data(14))) AND (NOT tx_data(15))) AND tx_data(16)) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND (NOT tx_data(20))) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND (NOT tx_data(23))) AND tx_data(24)) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	niOlOO <= ((((tx_ctl(3) AND tx_ctl(2)) AND tx_ctl(1)) AND tx_ctl(0)) AND niOO1i);
	niOO0l <= (((((((tx_data(24) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND tx_data(28)) AND tx_data(29)) AND tx_data(30)) AND tx_data(31));
	niOO0O <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1094w1590w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND tx_data(29)) AND tx_data(30)) AND tx_data(31));
	niOO1i <= (((((((((((((((((((((((((((((((tx_data(0) AND tx_data(1)) AND tx_data(2)) AND (NOT tx_data(3))) AND (NOT tx_data(4))) AND (NOT tx_data(5))) AND (NOT tx_data(6))) AND (NOT tx_data(7))) AND tx_data(8)) AND tx_data(9)) AND tx_data(10)) AND (NOT tx_data(11))) AND (NOT tx_data(12))) AND (NOT tx_data(13))) AND (NOT tx_data(14))) AND (NOT tx_data(15))) AND tx_data(16)) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND (NOT tx_data(20))) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND (NOT tx_data(23))) AND tx_data(24)) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	niOO1l <= (((wire_w_lg_w_lg_w118w120w123w(0) AND wire_w_lg_niOO0O124w(0)) AND wire_w_lg_niOO0l126w(0)) AND niOO1O53);
	niOOiO <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1094w1590w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND (NOT tx_data(29))) AND tx_data(30)) AND tx_data(31));
	niOOli <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1094w1590w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND (NOT tx_data(29))) AND tx_data(30)) AND (NOT tx_data(31)));
	niOOOi <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1094w1590w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND tx_data(29)) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	nl100i <= ((((((wire_w_lg_w_tx_data_range829w1558w(0) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23));
	nl100l <= (((((((tx_data(16) AND tx_data(17)) AND (NOT tx_data(18))) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23));
	nl101l <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range828w1543w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND (NOT tx_data(21))) AND tx_data(22)) AND (NOT tx_data(23)));
	nl101O <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range828w1543w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND (NOT tx_data(22))) AND (NOT tx_data(23)));
	nl10il <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range828w1543w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND tx_data(23));
	nl10ll <= (((((((tx_data(16) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND (NOT tx_data(20))) AND (NOT tx_data(21))) AND (NOT tx_data(22))) AND (NOT tx_data(23)));
	nl10lO <= ((wire_w_lg_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w58w(0) AND wire_w_lg_nl10Ol59w(0)) AND wire_w_lg_nl10Oi61w(0));
	nl10Oi <= (((((((tx_data(8) AND tx_data(9)) AND tx_data(10)) AND (NOT tx_data(11))) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15));
	nl10Ol <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range568w1496w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15));
	nl110i <= ((((((((NOT tx_data(24)) AND wire_w_lg_w_tx_data_range1094w1590w(0)) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND tx_data(31));
	nl111O <= (((((((tx_data(24) AND tx_data(25)) AND (NOT tx_data(26))) AND tx_data(27)) AND tx_data(28)) AND tx_data(29)) AND tx_data(30)) AND tx_data(31));
	nl11ii <= (((((((tx_data(24) AND tx_data(25)) AND tx_data(26)) AND (NOT tx_data(27))) AND (NOT tx_data(28))) AND (NOT tx_data(29))) AND (NOT tx_data(30))) AND (NOT tx_data(31)));
	nl11il <= ((((((wire_w_lg_w_tx_data_range1095w1689w(0) AND tx_data(26)) AND tx_data(27)) AND tx_data(28)) AND tx_data(29)) AND tx_data(30)) AND tx_data(31));
	nl11iO <= ((wire_w89w(0) AND wire_w_lg_nl11ll90w(0)) AND wire_w_lg_nl11li92w(0));
	nl11li <= (((((((tx_data(16) AND tx_data(17)) AND tx_data(18)) AND (NOT tx_data(19))) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23));
	nl11ll <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range828w1543w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND tx_data(21)) AND tx_data(22)) AND tx_data(23));
	nl11Ol <= ((((((((NOT tx_data(16)) AND wire_w_lg_w_tx_data_range828w1543w(0)) AND tx_data(18)) AND tx_data(19)) AND tx_data(20)) AND (NOT tx_data(21))) AND tx_data(22)) AND tx_data(23));
	nl1i0i <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range568w1496w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND (NOT tx_data(14))) AND (NOT tx_data(15)));
	nl1i0l <= ((((((wire_w_lg_w_tx_data_range569w1511w(0) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15));
	nl1i1l <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range568w1496w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND (NOT tx_data(13))) AND tx_data(14)) AND tx_data(15));
	nl1i1O <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range568w1496w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND (NOT tx_data(13))) AND tx_data(14)) AND (NOT tx_data(15)));
	nl1iil <= (((((((tx_data(8) AND tx_data(9)) AND (NOT tx_data(10))) AND tx_data(11)) AND tx_data(12)) AND tx_data(13)) AND tx_data(14)) AND tx_data(15));
	nl1iiO <= ((((((((NOT tx_data(8)) AND wire_w_lg_w_tx_data_range568w1496w(0)) AND tx_data(10)) AND tx_data(11)) AND tx_data(12)) AND (NOT tx_data(13))) AND (NOT tx_data(14))) AND tx_data(15));
	nl1ilO <= (((((((tx_data(8) AND tx_data(9)) AND tx_data(10)) AND (NOT tx_data(11))) AND (NOT tx_data(12))) AND (NOT tx_data(13))) AND (NOT tx_data(14))) AND (NOT tx_data(15)));
	nl1iOi <= ((wire_w_lg_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w29w(0) AND wire_w_lg_nl1l1i30w(0)) AND nl1iOl14);
	nl1l0i <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range308w1457w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7));
	nl1l0l <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range308w1457w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND (NOT tx_data(5))) AND tx_data(6)) AND tx_data(7));
	nl1l0O <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range308w1457w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND (NOT tx_data(5))) AND tx_data(6)) AND (NOT tx_data(7)));
	nl1l1i <= (((((((tx_data(0) AND tx_data(1)) AND tx_data(2)) AND (NOT tx_data(3))) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7));
	nl1liO <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range308w1457w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND (NOT tx_data(6))) AND (NOT tx_data(7)));
	nl1lli <= ((((((wire_w_lg_w_tx_data_range309w1458w(0) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7));
	nl1lOi <= (((((((tx_data(0) AND tx_data(1)) AND (NOT tx_data(2))) AND tx_data(3)) AND tx_data(4)) AND tx_data(5)) AND tx_data(6)) AND tx_data(7));
	nl1O0i <= ((((((((NOT tx_data(0)) AND wire_w_lg_w_tx_data_range308w1457w(0)) AND tx_data(2)) AND tx_data(3)) AND tx_data(4)) AND (NOT tx_data(5))) AND (NOT tx_data(6))) AND tx_data(7));
	nl1O1i <= (((((((tx_data(0) AND tx_data(1)) AND tx_data(2)) AND (NOT tx_data(3))) AND (NOT tx_data(4))) AND (NOT tx_data(5))) AND (NOT tx_data(6))) AND (NOT tx_data(7)));
	sm_ctl <= ( nliO0l & nliOll & nll11l & nll1il);
	sm_data <= ( nliOli & nllOOl & nliOiO & nliOil & nliOii & nliO0O & nllOOi & nllOlO & nll11i & n101O & nliOOO & nliOOl & nliOOi & nliOlO & n101l & n101i & nll1ii & n00OO & nll10O & nll10l & nll10i & nll11O & n00Ol & n00Oi & nll1Oi & niilO & nll1lO & nll1ll & nll1li & nll1iO & niill & niili);
	tx_local_fault <= nllll;
	tx_local_fault_det <= nlilO;
	wire_w_tx_ctl_range2w(0) <= tx_ctl(0);
	wire_w_tx_ctl_range35w(0) <= tx_ctl(1);
	wire_w_tx_ctl_range63w(0) <= tx_ctl(2);
	wire_w_tx_ctl_range95w(0) <= tx_ctl(3);
	wire_w_tx_data_range309w(0) <= tx_data(0);
	wire_w_tx_data_range829w(0) <= tx_data(16);
	wire_w_tx_data_range828w(0) <= tx_data(17);
	wire_w_tx_data_range308w(0) <= tx_data(1);
	wire_w_tx_data_range1095w(0) <= tx_data(24);
	wire_w_tx_data_range1094w(0) <= tx_data(25);
	wire_w_tx_data_range569w(0) <= tx_data(8);
	wire_w_tx_data_range568w(0) <= tx_data(9);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlil58 <= niOlil60;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlil59 <= (niOlil60 XOR niOlil58);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlil60 <= niOlil58;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlOi55 <= niOlOi57;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlOi56 <= (niOlOi57 XOR niOlOi55);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOlOi57 <= niOlOi55;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOO1O52 <= niOO1O54;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOO1O53 <= (niOO1O54 XOR niOO1O52);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOO1O54 <= niOO1O52;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOii49 <= niOOii51;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOii50 <= (niOOii51 XOR niOOii49);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOii51 <= niOOii49;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOll46 <= niOOll48;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOll47 <= (niOOll48 XOR niOOll46);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOll48 <= niOOll46;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOOl43 <= niOOOl45;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOOl44 <= (niOOOl45 XOR niOOOl43);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN niOOOl45 <= niOOOl43;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl100O28 <= nl100O30;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl100O29 <= (nl100O30 XOR nl100O28);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl100O30 <= nl100O28;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10iO25 <= nl10iO27;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10iO26 <= (nl10iO27 XOR nl10iO25);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10iO27 <= nl10iO25;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10OO22 <= nl10OO24;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10OO23 <= (nl10OO24 XOR nl10OO22);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl10OO24 <= nl10OO22;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl110l37 <= nl110l39;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl110l38 <= (nl110l39 XOR nl110l37);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl110l39 <= nl110l37;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl111i40 <= nl111i42;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl111i41 <= (nl111i42 XOR nl111i40);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl111i42 <= nl111i40;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11lO34 <= nl11lO36;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11lO35 <= (nl11lO36 XOR nl11lO34);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11lO36 <= nl11lO34;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11OO31 <= nl11OO33;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11OO32 <= (nl11OO33 XOR nl11OO31);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl11OO33 <= nl11OO31;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1i0O19 <= nl1i0O21;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1i0O20 <= (nl1i0O21 XOR nl1i0O19);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1i0O21 <= nl1i0O19;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1ili16 <= nl1ili18;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1ili17 <= (nl1ili18 XOR nl1ili16);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1ili18 <= nl1ili16;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1iOl13 <= nl1iOl15;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1iOl14 <= (nl1iOl15 XOR nl1iOl13);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1iOl15 <= nl1iOl13;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1l1l10 <= nl1l1l12;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1l1l11 <= (nl1l1l12 XOR nl1l1l10);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1l1l12 <= nl1l1l10;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lii7 <= nl1lii9;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lii8 <= (nl1lii9 XOR nl1lii7);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lii9 <= nl1lii7;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lll4 <= nl1lll6;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lll5 <= (nl1lll6 XOR nl1lll4);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lll6 <= nl1lll4;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lOl1 <= nl1lOl3;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lOl2 <= (nl1lOl3 XOR nl1lOl1);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN nl1lOl3 <= nl1lOl1;
		END IF;
	END PROCESS;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n00Oi <= '0';
				n00Ol <= '0';
				n00OO <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				n101i <= '0';
				n101l <= '0';
				n101O <= '0';
				ni1l <= '0';
				niili <= '0';
				niill <= '0';
				niilO <= '0';
				nlilO <= '0';
				nll00l <= '0';
				nll00O <= '0';
				nll01O <= '0';
				nll0ii <= '0';
				nll0il <= '0';
				nll0O <= '0';
				nllii <= '0';
				nllil <= '0';
				nllll <= '0';
				nllOll <= '0';
				nllOlO <= '0';
				nllOOi <= '0';
				nllOOl <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
				n00Oi <= wire_n0i1l_dataout;
				n00Ol <= wire_n0i1O_dataout;
				n00OO <= wire_n0iil_dataout;
				n0Ol <= n0OO;
				n0OO <= indv;
				n101i <= wire_n100l_dataout;
				n101l <= wire_n100O_dataout;
				n101O <= wire_n10ll_dataout;
				ni1l <= wire_nlOOi_o;
				niili <= wire_niiOl_dataout;
				niill <= wire_niiOO_dataout;
				niilO <= wire_nil0l_dataout;
				nlilO <= wire_nliOi_dataout;
				nll00l <= wire_nll0iO_dataout;
				nll00O <= wire_nll0li_dataout;
				nll01O <= wire_nlOOO_dataout;
				nll0ii <= wire_nll0ll_dataout;
				nll0il <= wire_nll0lO_dataout;
				nll0O <= wire_nliOl_dataout;
				nllii <= nllil;
				nllil <= tx_local_fault_clr;
				nllll <= wire_nlliO_dataout;
				nllOll <= wire_nllOiO_dataout;
				nllOlO <= wire_nlO11i_dataout;
				nllOOi <= wire_nlO11l_dataout;
				nllOOl <= wire_nlO1ii_dataout;
		END IF;
	END PROCESS;
	wire_ni1i_w_lg_ni1l287w(0) <= NOT ni1l;
	wire_ni1i_w_lg_nlilO297w(0) <= NOT nlilO;
	wire_ni1i_w_lg_nll01O289w(0) <= NOT nll01O;
	wire_ni1i_w_lg_nll0O298w(0) <= NOT nll0O;
	wire_ni1i_w_lg_nllOll156w(0) <= NOT nllOll;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				nlilOl <= '1';
				nlilOO <= '1';
				nliO0i <= '1';
				nliO1i <= '1';
				nliO1l <= '1';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (niOl1O = '1') THEN
				nlilOl <= tx_data(2);
				nlilOO <= tx_data(3);
				nliO0i <= tx_data(25);
				nliO1i <= tx_data(4);
				nliO1l <= tx_data(7);
			END IF;
		END IF;
	END PROCESS;
	wire_nliO1O_w_lg_nliO0i1732w(0) <= NOT nliO0i;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				nlil0O <= '1';
				nlilii <= '1';
				nlilil <= '1';
				nliliO <= '1';
				nlilli <= '1';
				nlilll <= '1';
				nlillO <= '1';
				nlilOi <= '1';
				nliO0l <= '1';
				nliO0O <= '1';
				nliOii <= '1';
				nliOil <= '1';
				nliOiO <= '1';
				nliOli <= '1';
				nliOll <= '1';
				nliOlO <= '1';
				nliOOi <= '1';
				nliOOl <= '1';
				nliOOO <= '1';
				nll01l <= '1';
				nll10i <= '1';
				nll10l <= '1';
				nll10O <= '1';
				nll11i <= '1';
				nll11l <= '1';
				nll11O <= '1';
				nll1ii <= '1';
				nll1il <= '1';
				nll1iO <= '1';
				nll1li <= '1';
				nll1ll <= '1';
				nll1lO <= '1';
				nll1Oi <= '1';
				nll1Ol <= '1';
				nll1OO <= '1';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
				nlil0O <= wire_nll0Oi_dataout;
				nlilii <= (nlilOi XOR nlillO);
				nlilil <= nlilii;
				nliliO <= nlilil;
				nlilli <= nliliO;
				nlilll <= nlilli;
				nlillO <= nlilll;
				nlilOi <= nlillO;
				nliO0l <= wire_nllOOO_dataout;
				nliO0O <= wire_nlO11O_dataout;
				nliOii <= wire_nlO10i_dataout;
				nliOil <= wire_nlO10l_dataout;
				nliOiO <= wire_nlO10O_dataout;
				nliOli <= wire_nlO1il_dataout;
				nliOll <= wire_n100i_dataout;
				nliOlO <= wire_n10ii_dataout;
				nliOOi <= wire_n10il_dataout;
				nliOOl <= wire_n10iO_dataout;
				nliOOO <= wire_n10li_dataout;
				nll01l <= wire_nlOlO_o;
				nll10i <= wire_n0i0l_dataout;
				nll10l <= wire_n0i0O_dataout;
				nll10O <= wire_n0iii_dataout;
				nll11i <= wire_n10lO_dataout;
				nll11l <= wire_n0i1i_dataout;
				nll11O <= wire_n0i0i_dataout;
				nll1ii <= wire_n0iiO_dataout;
				nll1il <= wire_niiOi_dataout;
				nll1iO <= wire_nil1i_dataout;
				nll1li <= wire_nil1l_dataout;
				nll1ll <= wire_nil1O_dataout;
				nll1lO <= wire_nil0i_dataout;
				nll1Oi <= wire_nil0O_dataout;
				nll1Ol <= wire_nlllO_dataout;
				nll1OO <= wire_nlOli_o;
		END IF;
	END PROCESS;
	wire_nll01i_w_lg_w_lg_w_lg_nll1OO285w286w1354w(0) <= wire_nll01i_w_lg_w_lg_nll1OO285w286w(0) AND ni1l;
	wire_nll01i_w_lg_w_lg_nll1OO1357w1358w(0) <= wire_nll01i_w_lg_nll1OO1357w(0) AND ni1l;
	wire_nll01i_w_lg_w_lg_nll1OO291w292w(0) <= wire_nll01i_w_lg_nll1OO291w(0) AND ni1l;
	wire_nll01i_w_lg_w_lg_nll1OO285w286w(0) <= wire_nll01i_w_lg_nll1OO285w(0) AND nll01l;
	wire_nll01i_w_lg_nll1OO1357w(0) <= nll1OO AND wire_nll01i_w_lg_nll01l1356w(0);
	wire_nll01i_w_lg_nll1OO291w(0) <= nll1OO AND nll01l;
	wire_nll01i_w_lg_nlilii158w(0) <= NOT nlilii;
	wire_nll01i_w_lg_nll01l1356w(0) <= NOT nll01l;
	wire_nll01i_w_lg_nll1Ol280w(0) <= NOT nll1Ol;
	wire_nll01i_w_lg_nll1OO285w(0) <= NOT nll1OO;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				nllill <= '0';
				nllilO <= '0';
				nlliOi <= '0';
				nlliOl <= '0';
				nlliOO <= '0';
				nlll0i <= '0';
				nlll0l <= '0';
				nlll0O <= '0';
				nlll1i <= '0';
				nlll1l <= '0';
				nlll1O <= '0';
				nlllii <= '0';
				nlllil <= '0';
				nllliO <= '0';
				nlllli <= '0';
				nlllll <= '0';
				nllllO <= '0';
				nlllOi <= '0';
				nlllOl <= '0';
				nlllOO <= '0';
				nllO0i <= '0';
				nllO0l <= '0';
				nllO0O <= '0';
				nllO1i <= '0';
				nllO1l <= '0';
				nllO1O <= '0';
				nllOil <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (niOl1O = '1') THEN
				nllill <= tx_data(0);
				nllilO <= tx_data(1);
				nlliOi <= tx_data(5);
				nlliOl <= tx_data(6);
				nlliOO <= tx_data(8);
				nlll0i <= tx_data(12);
				nlll0l <= tx_data(13);
				nlll0O <= tx_data(14);
				nlll1i <= tx_data(9);
				nlll1l <= tx_data(10);
				nlll1O <= tx_data(11);
				nlllii <= tx_data(15);
				nlllil <= tx_data(16);
				nllliO <= tx_data(17);
				nlllli <= tx_data(18);
				nlllll <= tx_data(19);
				nllllO <= tx_data(20);
				nlllOi <= tx_data(21);
				nlllOl <= tx_data(22);
				nlllOO <= tx_data(23);
				nllO0i <= tx_data(28);
				nllO0l <= tx_data(29);
				nllO0O <= tx_data(30);
				nllO1i <= tx_data(24);
				nllO1l <= tx_data(26);
				nllO1O <= tx_data(27);
				nllOil <= tx_data(31);
			END IF;
		END IF;
	END PROCESS;
	wire_nllOii_w_lg_w_lg_w1728w1730w1731w(0) <= wire_nllOii_w_lg_w1728w1730w(0) AND nllO1i;
	wire_nllOii_w_lg_w1728w1730w(0) <= wire_nllOii_w1728w(0) AND wire_nllOii_w_lg_nlllOO1729w(0);
	wire_nllOii_w1728w(0) <= wire_nllOii_w_lg_w_lg_w_lg_w_lg_w1718w1720w1722w1724w1726w(0) AND wire_nllOii_w_lg_nlllOl1727w(0);
	wire_nllOii_w_lg_w_lg_w_lg_w_lg_w1718w1720w1722w1724w1726w(0) <= wire_nllOii_w_lg_w_lg_w_lg_w1718w1720w1722w1724w(0) AND wire_nllOii_w_lg_nlllOi1725w(0);
	wire_nllOii_w_lg_w_lg_w_lg_w1718w1720w1722w1724w(0) <= wire_nllOii_w_lg_w_lg_w1718w1720w1722w(0) AND wire_nllOii_w_lg_nllllO1723w(0);
	wire_nllOii_w_lg_w_lg_w1718w1720w1722w(0) <= wire_nllOii_w_lg_w1718w1720w(0) AND wire_nllOii_w_lg_nlllll1721w(0);
	wire_nllOii_w_lg_w1718w1720w(0) <= wire_nllOii_w1718w(0) AND wire_nllOii_w_lg_nlllli1719w(0);
	wire_nllOii_w1718w(0) <= wire_nllOii_w_lg_w_lg_w_lg_w_lg_w1708w1710w1712w1714w1716w(0) AND wire_nllOii_w_lg_nllliO1717w(0);
	wire_nllOii_w_lg_w_lg_w_lg_w_lg_w1708w1710w1712w1714w1716w(0) <= wire_nllOii_w_lg_w_lg_w_lg_w1708w1710w1712w1714w(0) AND wire_nllOii_w_lg_nlllil1715w(0);
	wire_nllOii_w_lg_w_lg_w_lg_w1708w1710w1712w1714w(0) <= wire_nllOii_w_lg_w_lg_w1708w1710w1712w(0) AND wire_nllOii_w_lg_nlllii1713w(0);
	wire_nllOii_w_lg_w_lg_w1708w1710w1712w(0) <= wire_nllOii_w_lg_w1708w1710w(0) AND wire_nllOii_w_lg_nlll0O1711w(0);
	wire_nllOii_w_lg_w1708w1710w(0) <= wire_nllOii_w1708w(0) AND wire_nllOii_w_lg_nlll0l1709w(0);
	wire_nllOii_w1708w(0) <= wire_nllOii_w_lg_w_lg_w_lg_w_lg_nlliOO1700w1702w1704w1706w(0) AND wire_nllOii_w_lg_nlll0i1707w(0);
	wire_nllOii_w_lg_w_lg_w_lg_w_lg_nlliOO1700w1702w1704w1706w(0) <= wire_nllOii_w_lg_w_lg_w_lg_nlliOO1700w1702w1704w(0) AND wire_nllOii_w_lg_nlll1O1705w(0);
	wire_nllOii_w_lg_w_lg_w_lg_nlliOO1700w1702w1704w(0) <= wire_nllOii_w_lg_w_lg_nlliOO1700w1702w(0) AND wire_nllOii_w_lg_nlll1l1703w(0);
	wire_nllOii_w_lg_w_lg_nlliOO1700w1702w(0) <= wire_nllOii_w_lg_nlliOO1700w(0) AND wire_nllOii_w_lg_nlll1i1701w(0);
	wire_nllOii_w_lg_nlliOO1700w(0) <= NOT nlliOO;
	wire_nllOii_w_lg_nlll0i1707w(0) <= NOT nlll0i;
	wire_nllOii_w_lg_nlll0l1709w(0) <= NOT nlll0l;
	wire_nllOii_w_lg_nlll0O1711w(0) <= NOT nlll0O;
	wire_nllOii_w_lg_nlll1i1701w(0) <= NOT nlll1i;
	wire_nllOii_w_lg_nlll1l1703w(0) <= NOT nlll1l;
	wire_nllOii_w_lg_nlll1O1705w(0) <= NOT nlll1O;
	wire_nllOii_w_lg_nlllii1713w(0) <= NOT nlllii;
	wire_nllOii_w_lg_nlllil1715w(0) <= NOT nlllil;
	wire_nllOii_w_lg_nllliO1717w(0) <= NOT nllliO;
	wire_nllOii_w_lg_nlllli1719w(0) <= NOT nlllli;
	wire_nllOii_w_lg_nlllll1721w(0) <= NOT nlllll;
	wire_nllOii_w_lg_nllllO1723w(0) <= NOT nllllO;
	wire_nllOii_w_lg_nlllOi1725w(0) <= NOT nlllOi;
	wire_nllOii_w_lg_nlllOl1727w(0) <= NOT nlllOl;
	wire_nllOii_w_lg_nlllOO1729w(0) <= NOT nlllOO;
	wire_nllOii_w_lg_nllO0i1738w(0) <= NOT nllO0i;
	wire_nllOii_w_lg_nllO0l1740w(0) <= NOT nllO0l;
	wire_nllOii_w_lg_nllO0O1742w(0) <= NOT nllO0O;
	wire_nllOii_w_lg_nllO1l1734w(0) <= NOT nllO1l;
	wire_nllOii_w_lg_nllO1O1736w(0) <= NOT nllO1O;
	wire_nllOii_w_lg_nllOil1744w(0) <= NOT nllOil;
	wire_n000i_dataout <= wire_n1iil_dataout OR NOT(rd_enable_sync);
	wire_n000l_dataout <= wire_n1iiO_dataout AND rd_enable_sync;
	wire_n000O_dataout <= wire_n1ili_dataout AND rd_enable_sync;
	wire_n001i_dataout <= wire_n1lil_dataout OR NOT(niOl1i);
	wire_n001l_dataout <= wire_n1liO_dataout WHEN niOl1i = '1'  ELSE niOiOO;
	wire_n001O_dataout <= wire_n1lli_dataout WHEN niOl1i = '1'  ELSE wire_w_lg_niOiOO155w(0);
	wire_n00i_dataout <= wire_nlOOli_dataout AND NOT(niOl1i);
	wire_n00ii_dataout <= wire_n1ill_dataout OR NOT(rd_enable_sync);
	wire_n00il_dataout <= wire_n1ilO_dataout OR NOT(rd_enable_sync);
	wire_n00iO_dataout <= wire_n1iOi_dataout OR NOT(rd_enable_sync);
	wire_n00l_dataout <= nlilii OR wire_w_lg_niOiOl157w(0);
	wire_n00li_dataout <= wire_n01li_dataout OR NOT(rd_enable_sync);
	wire_n00ll_dataout <= wire_n1iOO_dataout AND rd_enable_sync;
	wire_n00lO_dataout <= wire_n01ll_dataout OR NOT(rd_enable_sync);
	wire_n00O_dataout <= wire_n0ii_dataout OR n0Ol;
	wire_n010i_dataout <= nlllOi WHEN nllOll = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_n010l_dataout <= nlllOl AND nllOll;
	wire_n010O_dataout <= nlllOO WHEN nllOll = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_n011i_dataout <= nlllli OR NOT(nllOll);
	wire_n011l_dataout <= nlllll OR NOT(nllOll);
	wire_n011O_dataout <= nllllO OR NOT(nllOll);
	wire_n01i_dataout <= wire_n01O_dataout OR n0Ol;
	wire_n01ii_dataout <= wire_n1lil_dataout WHEN niOl1i = '1'  ELSE wire_nlOOli_dataout;
	wire_n01il_dataout <= wire_n1liO_dataout WHEN niOl1i = '1'  ELSE wire_w_lg_niOiOl157w(0);
	wire_n01iO_dataout <= wire_n1lli_dataout WHEN niOl1i = '1'  ELSE wire_nlOOll_dataout;
	wire_n01l_dataout <= wire_n00i_dataout OR n0Ol;
	wire_n01li_dataout <= wire_n1lil_dataout AND niOl1i;
	wire_n01ll_dataout <= wire_n1lli_dataout AND niOl1i;
	wire_n01lO_dataout <= wire_n1lil_dataout WHEN niOl1i = '1'  ELSE wire_n01Ol_dataout;
	wire_n01O_dataout <= wire_n00l_dataout OR niOl1i;
	wire_n01Oi_dataout <= wire_n1lli_dataout WHEN niOl1i = '1'  ELSE wire_n01OO_dataout;
	wire_n01Ol_dataout <= nlllOi AND nllOll;
	wire_n01OO_dataout <= nlllOO AND nllOll;
	wire_n0i0i_dataout <= wire_n0iOi_o OR nl10lO;
	wire_n0i0l_dataout <= wire_n0iOl_o OR nl10lO;
	wire_n0i0O_dataout <= wire_n0iOO_o OR nl10lO;
	wire_n0i1i_dataout <= wire_n0ili_o OR nl10lO;
	wire_n0i1l_dataout <= wire_n0ill_o AND NOT(nl10lO);
	wire_n0i1O_dataout <= wire_n0ilO_o OR nl10lO;
	wire_n0ii_dataout <= wire_ni1i_w_lg_nllOll156w(0) OR niOl1i;
	wire_n0iii_dataout <= wire_n0l1i_o OR nl10lO;
	wire_n0iil_dataout <= wire_n0l1l_o OR nl10lO;
	wire_n0iiO_dataout <= wire_n0l1O_o OR nl10lO;
	wire_n0il_dataout <= wire_n0li_dataout OR n0Ol;
	wire_n0iO_dataout <= wire_w_lg_niOl1i153w(0) OR n0Ol;
	wire_n0l0l_dataout <= wire_n0lOl_dataout OR NOT(niOl1i);
	wire_n0l0O_dataout <= wire_n0lOO_dataout AND niOl1i;
	wire_n0li_dataout <= wire_w_lg_niOiOO155w(0) OR niOl1i;
	wire_n0lii_dataout <= wire_n0O1i_dataout AND niOl1i;
	wire_n0lil_dataout <= wire_n0O1l_dataout OR NOT(niOl1i);
	wire_n0liO_dataout <= wire_n0O1O_dataout OR NOT(niOl1i);
	wire_n0ll_dataout <= wire_w_lg_rd_enable_sync154w(0) OR n0Ol;
	wire_n0lli_dataout <= wire_n0O0i_dataout OR NOT(niOl1i);
	wire_n0lll_dataout <= wire_n0O0l_dataout WHEN niOl1i = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_n0llO_dataout <= wire_n0O0O_dataout AND niOl1i;
	wire_n0lO_dataout <= wire_n0Oi_dataout AND NOT(n0Ol);
	wire_n0lOi_dataout <= wire_n0Oii_dataout WHEN niOl1i = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_n0lOl_dataout <= wire_n0Oil_dataout OR niOlll;
	wire_n0lOO_dataout <= wire_n0OiO_dataout AND NOT(niOlll);
	wire_n0O0i_dataout <= wire_n0OOi_dataout OR niOlll;
	wire_n0O0l_dataout <= wire_n0OOl_dataout OR niOlll;
	wire_n0O0O_dataout <= wire_n0OOO_dataout AND NOT(niOlll);
	wire_n0O1i_dataout <= wire_n0Oli_dataout AND NOT(niOlll);
	wire_n0O1l_dataout <= wire_n0Oll_dataout OR niOlll;
	wire_n0O1O_dataout <= wire_n0OlO_dataout OR niOlll;
	wire_n0Oi_dataout <= wire_w_lg_niOl1i153w(0) AND rd_enable_sync;
	wire_n0Oii_dataout <= wire_ni11i_dataout OR niOlll;
	wire_n0Oil_dataout <= tx_ctl(1) OR niOlii;
	wire_n0OiO_dataout <= tx_data(8) OR niOlii;
	wire_n0Oli_dataout <= tx_data(9) AND NOT(niOlii);
	wire_n0Oll_dataout <= tx_data(10) OR niOlii;
	wire_n0OlO_dataout <= tx_data(11) OR niOlii;
	wire_n0OOi_dataout <= tx_data(12) OR niOlii;
	wire_n0OOl_dataout <= tx_data(13) OR niOlii;
	wire_n0OOO_dataout <= tx_data(14) OR niOlii;
	wire_n100i_dataout <= wire_n10Oi_o OR nl11iO;
	wire_n100l_dataout <= wire_n10Ol_o AND NOT(nl11iO);
	wire_n100O_dataout <= wire_n10OO_o OR nl11iO;
	wire_n10i_dataout <= nlilii OR niOl1i;
	wire_n10ii_dataout <= wire_n1i1i_o OR nl11iO;
	wire_n10il_dataout <= wire_n1i1l_o OR nl11iO;
	wire_n10iO_dataout <= wire_n1i1O_o OR nl11iO;
	wire_n10l_dataout <= wire_nll01i_w_lg_nlilii158w(0) AND NOT(niOl1i);
	wire_n10li_dataout <= wire_n1i0i_o OR nl11iO;
	wire_n10ll_dataout <= wire_n1i0l_o OR nl11iO;
	wire_n10lO_dataout <= wire_n1i0O_o OR nl11iO;
	wire_n10O_dataout <= wire_n1li_dataout OR n0Ol;
	wire_n110i_dataout <= wire_nlOi0O_dataout WHEN niOl1i = '1'  ELSE niOiOO;
	wire_n110l_dataout <= wire_nlOiii_dataout WHEN niOl1i = '1'  ELSE wire_w_lg_niOiOO155w(0);
	wire_n111i_dataout <= nllO0l AND nllOll;
	wire_n111l_dataout <= nllOil AND nllOll;
	wire_n111O_dataout <= wire_nlOi0l_dataout OR NOT(niOl1i);
	wire_n11i_dataout <= wire_n10i_dataout OR n0Ol;
	wire_n11ii_dataout <= wire_nlO00l_dataout OR NOT(rd_enable_sync);
	wire_n11il_dataout <= wire_nlO00O_dataout AND rd_enable_sync;
	wire_n11iO_dataout <= wire_nlO0ii_dataout AND rd_enable_sync;
	wire_n11l_dataout <= wire_n10l_dataout OR n0Ol;
	wire_n11li_dataout <= wire_nlO0il_dataout OR NOT(rd_enable_sync);
	wire_n11ll_dataout <= wire_nlO0iO_dataout OR NOT(rd_enable_sync);
	wire_n11lO_dataout <= wire_nlO0li_dataout OR NOT(rd_enable_sync);
	wire_n11O_dataout <= wire_w_lg_niOl1i153w(0) AND NOT(n0Ol);
	wire_n11Oi_dataout <= wire_nlOOlO_dataout OR NOT(rd_enable_sync);
	wire_n11Ol_dataout <= wire_nlO0lO_dataout AND rd_enable_sync;
	wire_n11OO_dataout <= wire_nlOOOi_dataout OR NOT(rd_enable_sync);
	wire_n1ii_dataout <= wire_n1ll_dataout OR n0Ol;
	wire_n1iil_dataout <= wire_n1l1l_dataout OR NOT(niOl1i);
	wire_n1iiO_dataout <= wire_n1l1O_dataout AND niOl1i;
	wire_n1il_dataout <= wire_n1lO_dataout AND NOT(n0Ol);
	wire_n1ili_dataout <= wire_n1l0i_dataout AND niOl1i;
	wire_n1ill_dataout <= wire_n1l0l_dataout OR NOT(niOl1i);
	wire_n1ilO_dataout <= wire_n1l0O_dataout OR NOT(niOl1i);
	wire_n1iO_dataout <= wire_n1Oi_dataout AND NOT(n0Ol);
	wire_n1iOi_dataout <= wire_n1lii_dataout OR NOT(niOl1i);
	wire_n1iOl_dataout <= wire_n1lil_dataout WHEN niOl1i = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_n1iOO_dataout <= wire_n1liO_dataout AND niOl1i;
	wire_n1l0i_dataout <= wire_n1lOi_dataout AND NOT(niOi1l);
	wire_n1l0l_dataout <= wire_n1lOl_dataout OR niOi1l;
	wire_n1l0O_dataout <= wire_n1lOO_dataout OR niOi1l;
	wire_n1l1i_dataout <= wire_n1lli_dataout WHEN niOl1i = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_n1l1l_dataout <= wire_n1lll_dataout OR niOi1l;
	wire_n1l1O_dataout <= wire_n1llO_dataout AND NOT(niOi1l);
	wire_n1li_dataout <= wire_n1Ol_dataout OR niOl1i;
	wire_n1lii_dataout <= wire_n1O1i_dataout OR niOi1l;
	wire_n1lil_dataout <= wire_n1O1l_dataout OR niOi1l;
	wire_n1liO_dataout <= wire_n1O1O_dataout AND NOT(niOi1l);
	wire_n1ll_dataout <= wire_n1OO_dataout AND NOT(niOl1i);
	wire_n1lli_dataout <= wire_n1O0i_dataout OR niOi1l;
	wire_n1lll_dataout <= tx_ctl(2) OR niOl0l;
	wire_n1llO_dataout <= tx_data(16) OR niOl0l;
	wire_n1lO_dataout <= wire_ni1i_w_lg_nllOll156w(0) AND NOT(niOl1i);
	wire_n1lOi_dataout <= tx_data(17) AND NOT(niOl0l);
	wire_n1lOl_dataout <= tx_data(18) OR niOl0l;
	wire_n1lOO_dataout <= tx_data(19) OR niOl0l;
	wire_n1O0i_dataout <= tx_data(23) OR niOl0l;
	wire_n1O0l_dataout <= wire_n1l1l_dataout WHEN niOl1i = '1'  ELSE wire_ni1i_w_lg_nllOll156w(0);
	wire_n1O0O_dataout <= wire_n1l1O_dataout WHEN niOl1i = '1'  ELSE wire_n1OOl_dataout;
	wire_n1O1i_dataout <= tx_data(20) OR niOl0l;
	wire_n1O1l_dataout <= tx_data(21) OR niOl0l;
	wire_n1O1O_dataout <= tx_data(22) OR niOl0l;
	wire_n1Oi_dataout <= nllOll AND NOT(niOl1i);
	wire_n1Oii_dataout <= wire_n1l0i_dataout WHEN niOl1i = '1'  ELSE wire_n1OOO_dataout;
	wire_n1Oil_dataout <= wire_n1l0l_dataout WHEN niOl1i = '1'  ELSE wire_n011i_dataout;
	wire_n1OiO_dataout <= wire_n1l0O_dataout WHEN niOl1i = '1'  ELSE wire_n011l_dataout;
	wire_n1Ol_dataout <= nlilii AND NOT(nllOll);
	wire_n1Oli_dataout <= wire_n1lii_dataout WHEN niOl1i = '1'  ELSE wire_n011O_dataout;
	wire_n1Oll_dataout <= wire_n1lil_dataout WHEN niOl1i = '1'  ELSE wire_n010i_dataout;
	wire_n1OlO_dataout <= wire_n1liO_dataout WHEN niOl1i = '1'  ELSE wire_n010l_dataout;
	wire_n1OO_dataout <= wire_nll01i_w_lg_nlilii158w(0) AND NOT(nllOll);
	wire_n1OOi_dataout <= wire_n1lli_dataout WHEN niOl1i = '1'  ELSE wire_n010O_dataout;
	wire_n1OOl_dataout <= nlllil AND nllOll;
	wire_n1OOO_dataout <= nllliO AND nllOll;
	wire_ni00i_dataout <= wire_n0O0l_dataout WHEN niOl1i = '1'  ELSE wire_nlOOli_dataout;
	wire_ni00l_dataout <= wire_n0O0O_dataout WHEN niOl1i = '1'  ELSE wire_w_lg_niOiOl157w(0);
	wire_ni00O_dataout <= wire_n0Oii_dataout WHEN niOl1i = '1'  ELSE wire_nlOOll_dataout;
	wire_ni01i_dataout <= nlll0l WHEN nllOll = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_ni01l_dataout <= nlll0O AND nllOll;
	wire_ni01O_dataout <= nlllii WHEN nllOll = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_ni0ii_dataout <= wire_n0O0l_dataout AND niOl1i;
	wire_ni0il_dataout <= wire_n0Oii_dataout AND niOl1i;
	wire_ni0iO_dataout <= wire_n0O0l_dataout WHEN niOl1i = '1'  ELSE wire_ni0ll_dataout;
	wire_ni0li_dataout <= wire_n0Oii_dataout WHEN niOl1i = '1'  ELSE wire_ni0lO_dataout;
	wire_ni0ll_dataout <= nlll0l AND nllOll;
	wire_ni0lO_dataout <= nlllii AND nllOll;
	wire_ni0Oi_dataout <= wire_n0O0l_dataout OR NOT(niOl1i);
	wire_ni0Ol_dataout <= wire_n0O0O_dataout WHEN niOl1i = '1'  ELSE niOiOO;
	wire_ni0OO_dataout <= wire_n0Oii_dataout WHEN niOl1i = '1'  ELSE wire_w_lg_niOiOO155w(0);
	wire_ni10i_dataout <= wire_n0O1i_dataout WHEN niOl1i = '1'  ELSE wire_ni1lO_dataout;
	wire_ni10l_dataout <= wire_n0O1l_dataout WHEN niOl1i = '1'  ELSE wire_ni1Oi_dataout;
	wire_ni10O_dataout <= wire_n0O1O_dataout WHEN niOl1i = '1'  ELSE wire_ni1Ol_dataout;
	wire_ni11i_dataout <= tx_data(15) OR niOlii;
	wire_ni11l_dataout <= wire_n0lOl_dataout WHEN niOl1i = '1'  ELSE wire_ni1i_w_lg_nllOll156w(0);
	wire_ni11O_dataout <= wire_n0lOO_dataout WHEN niOl1i = '1'  ELSE wire_ni1ll_dataout;
	wire_ni1ii_dataout <= wire_n0O0i_dataout WHEN niOl1i = '1'  ELSE wire_ni1OO_dataout;
	wire_ni1il_dataout <= wire_n0O0l_dataout WHEN niOl1i = '1'  ELSE wire_ni01i_dataout;
	wire_ni1iO_dataout <= wire_n0O0O_dataout WHEN niOl1i = '1'  ELSE wire_ni01l_dataout;
	wire_ni1li_dataout <= wire_n0Oii_dataout WHEN niOl1i = '1'  ELSE wire_ni01O_dataout;
	wire_ni1ll_dataout <= nlliOO AND nllOll;
	wire_ni1lO_dataout <= nlll1i AND nllOll;
	wire_ni1Oi_dataout <= nlll1l OR NOT(nllOll);
	wire_ni1Ol_dataout <= nlll1O OR NOT(nllOll);
	wire_ni1OO_dataout <= nlll0i OR NOT(nllOll);
	wire_nii0i_dataout <= wire_n0lil_dataout OR NOT(rd_enable_sync);
	wire_nii0l_dataout <= wire_n0liO_dataout OR NOT(rd_enable_sync);
	wire_nii0O_dataout <= wire_n0lli_dataout OR NOT(rd_enable_sync);
	wire_nii1i_dataout <= wire_n0l0l_dataout OR NOT(rd_enable_sync);
	wire_nii1l_dataout <= wire_n0l0O_dataout AND rd_enable_sync;
	wire_nii1O_dataout <= wire_n0lii_dataout AND rd_enable_sync;
	wire_niiii_dataout <= wire_ni0ii_dataout OR NOT(rd_enable_sync);
	wire_niiil_dataout <= wire_n0llO_dataout AND rd_enable_sync;
	wire_niiiO_dataout <= wire_ni0il_dataout OR NOT(rd_enable_sync);
	wire_niiOi_dataout <= wire_nilii_o OR nl1iOi;
	wire_niiOl_dataout <= wire_nilil_o AND NOT(nl1iOi);
	wire_niiOO_dataout <= wire_niliO_o OR nl1iOi;
	wire_nil0i_dataout <= wire_nilOi_o OR nl1iOi;
	wire_nil0l_dataout <= wire_nilOl_o OR nl1iOi;
	wire_nil0O_dataout <= wire_nilOO_o OR nl1iOi;
	wire_nil1i_dataout <= wire_nilli_o OR nl1iOi;
	wire_nil1l_dataout <= wire_nilll_o OR nl1iOi;
	wire_nil1O_dataout <= wire_nillO_o OR nl1iOi;
	wire_niO0i_dataout <= wire_niOOi_dataout AND niOl1i;
	wire_niO0l_dataout <= wire_niOOl_dataout OR NOT(niOl1i);
	wire_niO0O_dataout <= wire_niOOO_dataout OR NOT(niOl1i);
	wire_niO1l_dataout <= wire_niOll_dataout OR NOT(niOl1i);
	wire_niO1O_dataout <= wire_niOlO_dataout AND niOl1i;
	wire_niOii_dataout <= wire_nl11i_dataout OR NOT(niOl1i);
	wire_niOil_dataout <= wire_nl11l_dataout WHEN niOl1i = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_niOiO_dataout <= wire_nl11O_dataout AND niOl1i;
	wire_niOli_dataout <= wire_nl10i_dataout WHEN niOl1i = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_niOll_dataout <= tx_ctl(0) OR niOlll;
	wire_niOlO_dataout <= tx_data(0) OR niOlll;
	wire_niOOi_dataout <= tx_data(1) AND NOT(niOlll);
	wire_niOOl_dataout <= tx_data(2) OR niOlll;
	wire_niOOO_dataout <= tx_data(3) OR niOlll;
	wire_nl00i_dataout <= nlliOl AND nllOll;
	wire_nl00l_dataout <= nliO1l WHEN nllOll = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_nl00O_dataout <= wire_nl11l_dataout WHEN niOl1i = '1'  ELSE wire_nlOOli_dataout;
	wire_nl01i_dataout <= nlilOO OR NOT(nllOll);
	wire_nl01l_dataout <= nliO1i OR NOT(nllOll);
	wire_nl01O_dataout <= nlliOi WHEN nllOll = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_nl0ii_dataout <= wire_nl11O_dataout WHEN niOl1i = '1'  ELSE wire_w_lg_niOiOl157w(0);
	wire_nl0il_dataout <= wire_nl10i_dataout WHEN niOl1i = '1'  ELSE wire_nlOOll_dataout;
	wire_nl0iO_dataout <= wire_nl11l_dataout AND niOl1i;
	wire_nl0li_dataout <= wire_nl10i_dataout AND niOl1i;
	wire_nl0ll_dataout <= wire_nl11l_dataout WHEN niOl1i = '1'  ELSE wire_nl0Oi_dataout;
	wire_nl0lO_dataout <= wire_nl10i_dataout WHEN niOl1i = '1'  ELSE wire_nl0Ol_dataout;
	wire_nl0Oi_dataout <= nlliOi AND nllOll;
	wire_nl0Ol_dataout <= nliO1l AND nllOll;
	wire_nl0OO_dataout <= wire_nl11l_dataout OR NOT(niOl1i);
	wire_nl10i_dataout <= tx_data(7) OR niOlll;
	wire_nl10l_dataout <= wire_niOlO_dataout WHEN niOl1i = '1'  ELSE wire_nl1Oi_dataout;
	wire_nl10O_dataout <= wire_niOOi_dataout WHEN niOl1i = '1'  ELSE wire_nl1Ol_dataout;
	wire_nl11i_dataout <= tx_data(4) OR niOlll;
	wire_nl11l_dataout <= tx_data(5) OR niOlll;
	wire_nl11O_dataout <= tx_data(6) OR niOlll;
	wire_nl1ii_dataout <= wire_niOOl_dataout WHEN niOl1i = '1'  ELSE wire_nl1OO_dataout;
	wire_nl1il_dataout <= wire_niOOO_dataout WHEN niOl1i = '1'  ELSE wire_nl01i_dataout;
	wire_nl1iO_dataout <= wire_nl11i_dataout WHEN niOl1i = '1'  ELSE wire_nl01l_dataout;
	wire_nl1li_dataout <= wire_nl11l_dataout WHEN niOl1i = '1'  ELSE wire_nl01O_dataout;
	wire_nl1ll_dataout <= wire_nl11O_dataout WHEN niOl1i = '1'  ELSE wire_nl00i_dataout;
	wire_nl1lO_dataout <= wire_nl10i_dataout WHEN niOl1i = '1'  ELSE wire_nl00l_dataout;
	wire_nl1Oi_dataout <= nllill AND nllOll;
	wire_nl1Ol_dataout <= nllilO AND nllOll;
	wire_nl1OO_dataout <= nlilOl OR NOT(nllOll);
	wire_nli0i_dataout <= wire_niO1O_dataout AND rd_enable_sync;
	wire_nli0l_dataout <= wire_niO0i_dataout AND rd_enable_sync;
	wire_nli0O_dataout <= wire_niO0l_dataout OR NOT(rd_enable_sync);
	wire_nli1i_dataout <= wire_nl11O_dataout WHEN niOl1i = '1'  ELSE niOiOO;
	wire_nli1l_dataout <= wire_nl10i_dataout WHEN niOl1i = '1'  ELSE wire_w_lg_niOiOO155w(0);
	wire_nli1O_dataout <= wire_niO1l_dataout OR NOT(rd_enable_sync);
	wire_nliii_dataout <= wire_niO0O_dataout OR NOT(rd_enable_sync);
	wire_nliil_dataout <= wire_niOii_dataout OR NOT(rd_enable_sync);
	wire_nliiO_dataout <= wire_nl0iO_dataout OR NOT(rd_enable_sync);
	wire_nlili_dataout <= wire_niOiO_dataout AND rd_enable_sync;
	wire_nlill_dataout <= wire_nl0li_dataout OR NOT(rd_enable_sync);
	wire_nliOi_dataout <= wire_nliOO_dataout AND niOi0O;
	wire_nliOl_dataout <= niOi0i AND niOi0O;
	wire_nliOO_dataout <= (nlilO AND nll0O) OR niOi0i;
	wire_nll0iO_dataout <= nlilii WHEN niO0Oi = '1'  ELSE wire_nll0Ol_dataout;
	wire_nll0li_dataout <= nlilil WHEN niO0Oi = '1'  ELSE wire_nll0OO_dataout;
	wire_nll0ll_dataout <= nliliO WHEN niO0Oi = '1'  ELSE wire_nlli1i_dataout;
	wire_nll0lO_dataout <= nlilli WHEN niO0Oi = '1'  ELSE wire_nlli1l_dataout;
	wire_nll0Oi_dataout <= wire_nlli1O_dataout OR niO0Oi;
	wire_nll0Ol_dataout <= wire_nlli0i_o(1) WHEN niOiOl = '1'  ELSE nll00l;
	wire_nll0OO_dataout <= wire_nlli0i_o(2) WHEN niOiOl = '1'  ELSE nll00O;
	wire_nlli1i_dataout <= wire_nlli0i_o(3) WHEN niOiOl = '1'  ELSE nll0ii;
	wire_nlli1l_dataout <= wire_nlli0i_o(4) WHEN niOiOl = '1'  ELSE nll0il;
	wire_nlli1O_dataout <= wire_nlli0i_o(5) WHEN niOiOl = '1'  ELSE nlil0O;
	wire_nlliO_dataout <= wire_nllli_dataout AND NOT(nllii);
	wire_nllli_dataout <= nllll OR nll0O;
	wire_nlllO_dataout <= wire_nllOi_dataout OR ((wire_w_lg_w_lg_w_lg_rd_enable_sync154w275w276w(0) OR wire_w_lg_niOili278w(0)) OR wire_w_lg_niOiil282w(0));
	wire_nllOi_dataout <= nll1Ol AND NOT((niOiOO AND niOiil));
	wire_nllOiO_dataout <= wire_nllOli_dataout OR niOl1O;
	wire_nllOli_dataout <= nllOll AND NOT(niOi0O);
	wire_nllOOO_dataout <= wire_nlO1iO_o OR niOO1l;
	wire_nlO00l_dataout <= wire_nlO0Ol_dataout OR NOT(niOl1i);
	wire_nlO00O_dataout <= wire_nlO0OO_dataout AND niOl1i;
	wire_nlO0ii_dataout <= wire_nlOi1i_dataout AND niOl1i;
	wire_nlO0il_dataout <= wire_nlOi1l_dataout OR NOT(niOl1i);
	wire_nlO0iO_dataout <= wire_nlOi1O_dataout OR NOT(niOl1i);
	wire_nlO0li_dataout <= wire_nlOi0i_dataout OR NOT(niOl1i);
	wire_nlO0ll_dataout <= wire_nlOi0l_dataout WHEN niOl1i = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_nlO0lO_dataout <= wire_nlOi0O_dataout AND niOl1i;
	wire_nlO0Oi_dataout <= wire_nlOiii_dataout WHEN niOl1i = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_nlO0Ol_dataout <= wire_nlOiil_dataout OR niO0OO;
	wire_nlO0OO_dataout <= wire_nlOiiO_dataout AND NOT(niO0OO);
	wire_nlO10i_dataout <= wire_nlO1Oi_o OR niOO1l;
	wire_nlO10l_dataout <= wire_nlO1Ol_o OR niOO1l;
	wire_nlO10O_dataout <= wire_nlO1OO_o OR niOO1l;
	wire_nlO11i_dataout <= wire_nlO1li_o AND NOT(niOO1l);
	wire_nlO11l_dataout <= wire_nlO1ll_o OR niOO1l;
	wire_nlO11O_dataout <= wire_nlO1lO_o OR niOO1l;
	wire_nlO1ii_dataout <= wire_nlO01i_o OR niOO1l;
	wire_nlO1il_dataout <= wire_nlO01l_o OR niOO1l;
	wire_nlOi0i_dataout <= wire_nlOiOi_dataout OR niO0OO;
	wire_nlOi0l_dataout <= wire_nlOiOl_dataout OR niO0OO;
	wire_nlOi0O_dataout <= wire_nlOiOO_dataout AND NOT(niO0OO);
	wire_nlOi1i_dataout <= wire_nlOili_dataout AND NOT(niO0OO);
	wire_nlOi1l_dataout <= wire_nlOill_dataout OR niO0OO;
	wire_nlOi1O_dataout <= wire_nlOilO_dataout OR niO0OO;
	wire_nlOiii_dataout <= wire_nlOl1i_dataout OR niO0OO;
	wire_nlOiil_dataout <= tx_ctl(3) OR niOl0i;
	wire_nlOiiO_dataout <= tx_data(24) OR niOl0i;
	wire_nlOili_dataout <= tx_data(25) AND NOT(niOl0i);
	wire_nlOill_dataout <= tx_data(26) OR niOl0i;
	wire_nlOilO_dataout <= tx_data(27) OR niOl0i;
	wire_nlOiOi_dataout <= tx_data(28) OR niOl0i;
	wire_nlOiOl_dataout <= tx_data(29) OR niOl0i;
	wire_nlOiOO_dataout <= tx_data(30) OR niOl0i;
	wire_nlOl0l_dataout <= wire_nlO0Ol_dataout WHEN niOl1i = '1'  ELSE wire_ni1i_w_lg_nllOll156w(0);
	wire_nlOl0O_dataout <= wire_nlO0OO_dataout WHEN niOl1i = '1'  ELSE wire_nlOlOl_dataout;
	wire_nlOl1i_dataout <= tx_data(31) OR niOl0i;
	wire_nlOlii_dataout <= wire_nlOi1i_dataout WHEN niOl1i = '1'  ELSE wire_nlOlOO_dataout;
	wire_nlOlil_dataout <= wire_nlOi1l_dataout WHEN niOl1i = '1'  ELSE wire_nlOO1i_dataout;
	wire_nlOliO_dataout <= wire_nlOi1O_dataout WHEN niOl1i = '1'  ELSE wire_nlOO1l_dataout;
	wire_nlOlli_dataout <= wire_nlOi0i_dataout WHEN niOl1i = '1'  ELSE wire_nlOO1O_dataout;
	wire_nlOlll_dataout <= wire_nlOi0l_dataout WHEN niOl1i = '1'  ELSE wire_nlOO0i_dataout;
	wire_nlOllO_dataout <= wire_nlOi0O_dataout WHEN niOl1i = '1'  ELSE wire_nlOO0l_dataout;
	wire_nlOlOi_dataout <= wire_nlOiii_dataout WHEN niOl1i = '1'  ELSE wire_nlOO0O_dataout;
	wire_nlOlOl_dataout <= nllO1i AND nllOll;
	wire_nlOlOO_dataout <= nliO0i AND nllOll;
	wire_nlOO0i_dataout <= nllO0l WHEN nllOll = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_nlOO0l_dataout <= nllO0O AND nllOll;
	wire_nlOO0O_dataout <= nllOil WHEN nllOll = '1'  ELSE wire_nll01i_w_lg_nlilii158w(0);
	wire_nlOO1i_dataout <= nllO1l OR NOT(nllOll);
	wire_nlOO1l_dataout <= nllO1O OR NOT(nllOll);
	wire_nlOO1O_dataout <= nllO0i OR NOT(nllOll);
	wire_nlOOii_dataout <= wire_nlOi0l_dataout WHEN niOl1i = '1'  ELSE wire_nlOOli_dataout;
	wire_nlOOil_dataout <= wire_nlOi0O_dataout WHEN niOl1i = '1'  ELSE wire_w_lg_niOiOl157w(0);
	wire_nlOOiO_dataout <= wire_nlOiii_dataout WHEN niOl1i = '1'  ELSE wire_nlOOll_dataout;
	wire_nlOOli_dataout <= wire_nll01i_w_lg_nlilii158w(0) OR wire_w_lg_niOiOl157w(0);
	wire_nlOOll_dataout <= wire_nll01i_w_lg_nlilii158w(0) AND NOT(wire_w_lg_niOiOl157w(0));
	wire_nlOOlO_dataout <= wire_nlOi0l_dataout AND niOl1i;
	wire_nlOOO_dataout <= wire_n1iO_dataout AND wire_nlO00i_o(7);
	wire_nlOOOi_dataout <= wire_nlOiii_dataout AND niOl1i;
	wire_nlOOOl_dataout <= wire_nlOi0l_dataout WHEN niOl1i = '1'  ELSE wire_n111i_dataout;
	wire_nlOOOO_dataout <= wire_nlOiii_dataout WHEN niOl1i = '1'  ELSE wire_n111l_dataout;
	wire_nlli0i_a <= ( nlil0O & nll0il & nll0ii & nll00O & nll00l & "1");
	wire_nlli0i_b <= ( "1" & "1" & "1" & "1" & "0" & "1");
	nlli0i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 6,
		width_b => 6,
		width_o => 6
	  )
	  PORT MAP ( 
		a => wire_nlli0i_a,
		b => wire_nlli0i_b,
		cin => wire_gnd,
		o => wire_nlli0i_o
	  );
	wire_nlO00i_i <= ( nll01O & ni1l & nll01l & nll1OO);
	nlO00i :  oper_decoder
	  GENERIC MAP (
		width_i => 4,
		width_o => 16
	  )
	  PORT MAP ( 
		i => wire_nlO00i_i,
		o => wire_nlO00i_o
	  );
	wire_nlOil_a <= ( "1" & "0" & "0" & "0");
	wire_nlOil_b <= ( nll01O & ni1l & nll01l & nll1OO);
	nlOil :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nlOil_a,
		b => wire_nlOil_b,
		cin => wire_gnd,
		o => wire_nlOil_o
	  );
	wire_n0ili_data <= ( "1" & wire_n0l0l_dataout & wire_ni11l_dataout & wire_n0l0l_dataout & wire_n0l0l_dataout & wire_n0l0l_dataout & wire_nii1i_dataout & wire_ni11l_dataout & wire_n0l0l_dataout);
	wire_n0ili_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	n0ili :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0ili_data,
		o => wire_n0ili_o,
		sel => wire_n0ili_sel
	  );
	wire_n0ill_data <= ( "0" & wire_n0l0O_dataout & wire_ni11O_dataout & wire_n0l0O_dataout & wire_n0l0O_dataout & wire_n0l0O_dataout & wire_nii1l_dataout & wire_ni11O_dataout & wire_n0l0O_dataout);
	wire_n0ill_sel <= ( niOi1O & wire_nlO00i_o(8 DOWNTO 1));
	n0ill :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0ill_data,
		o => wire_n0ill_o,
		sel => wire_n0ill_sel
	  );
	wire_n0ilO_data <= ( "0" & wire_n0lii_dataout & wire_ni10i_dataout & wire_n0lii_dataout & wire_n0lii_dataout & wire_n0lii_dataout & wire_nii1O_dataout & wire_ni10i_dataout & wire_n0lii_dataout);
	wire_n0ilO_sel <= ( niOi1O & wire_nlO00i_o(8 DOWNTO 1));
	n0ilO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0ilO_data,
		o => wire_n0ilO_o,
		sel => wire_n0ilO_sel
	  );
	wire_n0iOi_data <= ( "1" & wire_n0lil_dataout & wire_ni10l_dataout & wire_n0lil_dataout & wire_n0lil_dataout & wire_n0lil_dataout & wire_nii0i_dataout & wire_ni10l_dataout & wire_n0lil_dataout);
	wire_n0iOi_sel <= ( niOi1O & wire_nlO00i_o(8 DOWNTO 1));
	n0iOi :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0iOi_data,
		o => wire_n0iOi_o,
		sel => wire_n0iOi_sel
	  );
	wire_n0iOl_data <= ( "1" & wire_n0liO_dataout & wire_ni10O_dataout & wire_n0liO_dataout & wire_n0liO_dataout & wire_n0liO_dataout & wire_nii0l_dataout & wire_ni10O_dataout & wire_n0liO_dataout);
	wire_n0iOl_sel <= ( niOi1O & wire_nlO00i_o(8 DOWNTO 1));
	n0iOl :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0iOl_data,
		o => wire_n0iOl_o,
		sel => wire_n0iOl_sel
	  );
	wire_n0iOO_data <= ( "1" & wire_n0lli_dataout & wire_ni1ii_dataout & wire_n0lli_dataout & wire_n0lli_dataout & wire_n0lli_dataout & wire_nii0O_dataout & wire_ni1ii_dataout & wire_n0lli_dataout);
	wire_n0iOO_sel <= ( niOi1O & wire_nlO00i_o(8 DOWNTO 1));
	n0iOO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0iOO_data,
		o => wire_n0iOO_o,
		sel => wire_n0iOO_sel
	  );
	wire_n0l1i_data <= ( "1" & wire_n0lll_dataout & wire_ni1il_dataout & wire_ni00i_dataout & wire_ni00i_dataout & wire_ni0ii_dataout & wire_niiii_dataout & wire_ni0iO_dataout & wire_ni0Oi_dataout);
	wire_n0l1i_sel <= ( niOi1O & wire_nlO00i_o(8 DOWNTO 1));
	n0l1i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0l1i_data,
		o => wire_n0l1i_o,
		sel => wire_n0l1i_sel
	  );
	wire_n0l1l_data <= ( "0" & wire_n0llO_dataout & wire_ni1iO_dataout & wire_ni00l_dataout & wire_ni00l_dataout & wire_n0llO_dataout & wire_niiil_dataout & wire_ni1iO_dataout & wire_ni0Ol_dataout);
	wire_n0l1l_sel <= ( niOi1O & wire_nlO00i_o(8 DOWNTO 1));
	n0l1l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0l1l_data,
		o => wire_n0l1l_o,
		sel => wire_n0l1l_sel
	  );
	wire_n0l1O_data <= ( "1" & wire_n0lOi_dataout & wire_ni1li_dataout & wire_ni00O_dataout & wire_ni00O_dataout & wire_ni0il_dataout & wire_niiiO_dataout & wire_ni0li_dataout & wire_ni0OO_dataout);
	wire_n0l1O_sel <= ( niOi1O & wire_nlO00i_o(8 DOWNTO 1));
	n0l1O :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n0l1O_data,
		o => wire_n0l1O_o,
		sel => wire_n0l1O_sel
	  );
	wire_n10Oi_data <= ( "1" & wire_n1iil_dataout & wire_n1O0l_dataout & wire_n1iil_dataout & wire_n1iil_dataout & wire_n1iil_dataout & wire_n000i_dataout & wire_n1O0l_dataout & wire_n1iil_dataout);
	wire_n10Oi_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	n10Oi :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n10Oi_data,
		o => wire_n10Oi_o,
		sel => wire_n10Oi_sel
	  );
	wire_n10Ol_data <= ( "0" & wire_n1iiO_dataout & wire_n1O0O_dataout & wire_n1iiO_dataout & wire_n1iiO_dataout & wire_n1iiO_dataout & wire_n000l_dataout & wire_n1O0O_dataout & wire_n1iiO_dataout);
	wire_n10Ol_sel <= ( niOi1i & wire_nlO00i_o(8 DOWNTO 1));
	n10Ol :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n10Ol_data,
		o => wire_n10Ol_o,
		sel => wire_n10Ol_sel
	  );
	wire_n10OO_data <= ( "0" & wire_n1ili_dataout & wire_n1Oii_dataout & wire_n1ili_dataout & wire_n1ili_dataout & wire_n1ili_dataout & wire_n000O_dataout & wire_n1Oii_dataout & wire_n1ili_dataout);
	wire_n10OO_sel <= ( niOi1i & wire_nlO00i_o(8 DOWNTO 1));
	n10OO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n10OO_data,
		o => wire_n10OO_o,
		sel => wire_n10OO_sel
	  );
	wire_n1i0i_data <= ( "1" & wire_n1iOl_dataout & wire_n1Oll_dataout & wire_n01ii_dataout & wire_n01ii_dataout & wire_n01li_dataout & wire_n00li_dataout & wire_n01lO_dataout & wire_n001i_dataout);
	wire_n1i0i_sel <= ( niOi1i & wire_nlO00i_o(8 DOWNTO 1));
	n1i0i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n1i0i_data,
		o => wire_n1i0i_o,
		sel => wire_n1i0i_sel
	  );
	wire_n1i0l_data <= ( "0" & wire_n1iOO_dataout & wire_n1OlO_dataout & wire_n01il_dataout & wire_n01il_dataout & wire_n1iOO_dataout & wire_n00ll_dataout & wire_n1OlO_dataout & wire_n001l_dataout);
	wire_n1i0l_sel <= ( niOi1i & wire_nlO00i_o(8 DOWNTO 1));
	n1i0l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n1i0l_data,
		o => wire_n1i0l_o,
		sel => wire_n1i0l_sel
	  );
	wire_n1i0O_data <= ( "1" & wire_n1l1i_dataout & wire_n1OOi_dataout & wire_n01iO_dataout & wire_n01iO_dataout & wire_n01ll_dataout & wire_n00lO_dataout & wire_n01Oi_dataout & wire_n001O_dataout);
	wire_n1i0O_sel <= ( niOi1i & wire_nlO00i_o(8 DOWNTO 1));
	n1i0O :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n1i0O_data,
		o => wire_n1i0O_o,
		sel => wire_n1i0O_sel
	  );
	wire_n1i1i_data <= ( "1" & wire_n1ill_dataout & wire_n1Oil_dataout & wire_n1ill_dataout & wire_n1ill_dataout & wire_n1ill_dataout & wire_n00ii_dataout & wire_n1Oil_dataout & wire_n1ill_dataout);
	wire_n1i1i_sel <= ( niOi1i & wire_nlO00i_o(8 DOWNTO 1));
	n1i1i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n1i1i_data,
		o => wire_n1i1i_o,
		sel => wire_n1i1i_sel
	  );
	wire_n1i1l_data <= ( "1" & wire_n1ilO_dataout & wire_n1OiO_dataout & wire_n1ilO_dataout & wire_n1ilO_dataout & wire_n1ilO_dataout & wire_n00il_dataout & wire_n1OiO_dataout & wire_n1ilO_dataout);
	wire_n1i1l_sel <= ( niOi1i & wire_nlO00i_o(8 DOWNTO 1));
	n1i1l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n1i1l_data,
		o => wire_n1i1l_o,
		sel => wire_n1i1l_sel
	  );
	wire_n1i1O_data <= ( "1" & wire_n1iOi_dataout & wire_n1Oli_dataout & wire_n1iOi_dataout & wire_n1iOi_dataout & wire_n1iOi_dataout & wire_n00iO_dataout & wire_n1Oli_dataout & wire_n1iOi_dataout);
	wire_n1i1O_sel <= ( niOi1i & wire_nlO00i_o(8 DOWNTO 1));
	n1i1O :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n1i1O_data,
		o => wire_n1i1O_o,
		sel => wire_n1i1O_sel
	  );
	wire_nilii_data <= ( "1" & wire_niO1l_dataout & wire_niO1l_dataout & wire_niO1l_dataout & wire_niO1l_dataout & wire_niO1l_dataout & wire_nli1O_dataout & wire_niO1l_dataout & wire_niO1l_dataout);
	wire_nilii_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nilii :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nilii_data,
		o => wire_nilii_o,
		sel => wire_nilii_sel
	  );
	wire_nilil_data <= ( "0" & wire_niO1O_dataout & wire_nl10l_dataout & wire_niO1O_dataout & wire_niO1O_dataout & wire_niO1O_dataout & wire_nli0i_dataout & wire_nl10l_dataout & wire_niO1O_dataout);
	wire_nilil_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nilil :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nilil_data,
		o => wire_nilil_o,
		sel => wire_nilil_sel
	  );
	wire_niliO_data <= ( "0" & wire_niO0i_dataout & wire_nl10O_dataout & wire_niO0i_dataout & wire_niO0i_dataout & wire_niO0i_dataout & wire_nli0l_dataout & wire_nl10O_dataout & wire_niO0i_dataout);
	wire_niliO_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	niliO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_niliO_data,
		o => wire_niliO_o,
		sel => wire_niliO_sel
	  );
	wire_nilli_data <= ( "1" & wire_niO0l_dataout & wire_nl1ii_dataout & wire_niO0l_dataout & wire_niO0l_dataout & wire_niO0l_dataout & wire_nli0O_dataout & wire_nl1ii_dataout & wire_niO0l_dataout);
	wire_nilli_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nilli :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nilli_data,
		o => wire_nilli_o,
		sel => wire_nilli_sel
	  );
	wire_nilll_data <= ( "1" & wire_niO0O_dataout & wire_nl1il_dataout & wire_niO0O_dataout & wire_niO0O_dataout & wire_niO0O_dataout & wire_nliii_dataout & wire_nl1il_dataout & wire_niO0O_dataout);
	wire_nilll_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nilll :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nilll_data,
		o => wire_nilll_o,
		sel => wire_nilll_sel
	  );
	wire_nillO_data <= ( "1" & wire_niOii_dataout & wire_nl1iO_dataout & wire_niOii_dataout & wire_niOii_dataout & wire_niOii_dataout & wire_nliil_dataout & wire_nl1iO_dataout & wire_niOii_dataout);
	wire_nillO_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nillO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nillO_data,
		o => wire_nillO_o,
		sel => wire_nillO_sel
	  );
	wire_nilOi_data <= ( "1" & wire_niOil_dataout & wire_nl1li_dataout & wire_nl00O_dataout & wire_nl00O_dataout & wire_nl0iO_dataout & wire_nliiO_dataout & wire_nl0ll_dataout & wire_nl0OO_dataout);
	wire_nilOi_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nilOi :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nilOi_data,
		o => wire_nilOi_o,
		sel => wire_nilOi_sel
	  );
	wire_nilOl_data <= ( "0" & wire_niOiO_dataout & wire_nl1ll_dataout & wire_nl0ii_dataout & wire_nl0ii_dataout & wire_niOiO_dataout & wire_nlili_dataout & wire_nl1ll_dataout & wire_nli1i_dataout);
	wire_nilOl_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nilOl :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nilOl_data,
		o => wire_nilOl_o,
		sel => wire_nilOl_sel
	  );
	wire_nilOO_data <= ( "1" & wire_niOli_dataout & wire_nl1lO_dataout & wire_nl0il_dataout & wire_nl0il_dataout & wire_nl0li_dataout & wire_nlill_dataout & wire_nl0lO_dataout & wire_nli1l_dataout);
	wire_nilOO_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nilOO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nilOO_data,
		o => wire_nilOO_o,
		sel => wire_nilOO_sel
	  );
	wire_nlO01i_data <= ( "0" & wire_nlO0lO_dataout & wire_nlOllO_dataout & wire_nlOOil_dataout & wire_nlOOil_dataout & wire_nlO0lO_dataout & wire_n11Ol_dataout & wire_nlOllO_dataout & wire_n110i_dataout);
	wire_nlO01i_sel <= ( niO0Ol & wire_nlO00i_o(8 DOWNTO 1));
	nlO01i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlO01i_data,
		o => wire_nlO01i_o,
		sel => wire_nlO01i_sel
	  );
	wire_nlO01l_data <= ( "1" & wire_nlO0Oi_dataout & wire_nlOlOi_dataout & wire_nlOOiO_dataout & wire_nlOOiO_dataout & wire_nlOOOi_dataout & wire_n11OO_dataout & wire_nlOOOO_dataout & wire_n110l_dataout);
	wire_nlO01l_sel <= ( niO0Ol & wire_nlO00i_o(8 DOWNTO 1));
	nlO01l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlO01l_data,
		o => wire_nlO01l_o,
		sel => wire_nlO01l_sel
	  );
	wire_nlO1iO_data <= ( "1" & wire_nlO00l_dataout & wire_nlOl0l_dataout & wire_nlO00l_dataout & wire_nlO00l_dataout & wire_nlO00l_dataout & wire_n11ii_dataout & wire_nlOl0l_dataout & wire_nlO00l_dataout);
	wire_nlO1iO_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nlO1iO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlO1iO_data,
		o => wire_nlO1iO_o,
		sel => wire_nlO1iO_sel
	  );
	wire_nlO1li_data <= ( "0" & wire_nlO00O_dataout & wire_nlOl0O_dataout & wire_nlO00O_dataout & wire_nlO00O_dataout & wire_nlO00O_dataout & wire_n11il_dataout & wire_nlOl0O_dataout & wire_nlO00O_dataout);
	wire_nlO1li_sel <= ( niO0Ol & wire_nlO00i_o(8 DOWNTO 1));
	nlO1li :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlO1li_data,
		o => wire_nlO1li_o,
		sel => wire_nlO1li_sel
	  );
	wire_nlO1ll_data <= ( "0" & wire_nlO0ii_dataout & wire_nlOlii_dataout & wire_nlO0ii_dataout & wire_nlO0ii_dataout & wire_nlO0ii_dataout & wire_n11iO_dataout & wire_nlOlii_dataout & wire_nlO0ii_dataout);
	wire_nlO1ll_sel <= ( niO0Ol & wire_nlO00i_o(8 DOWNTO 1));
	nlO1ll :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlO1ll_data,
		o => wire_nlO1ll_o,
		sel => wire_nlO1ll_sel
	  );
	wire_nlO1lO_data <= ( "1" & wire_nlO0il_dataout & wire_nlOlil_dataout & wire_nlO0il_dataout & wire_nlO0il_dataout & wire_nlO0il_dataout & wire_n11li_dataout & wire_nlOlil_dataout & wire_nlO0il_dataout);
	wire_nlO1lO_sel <= ( niO0Ol & wire_nlO00i_o(8 DOWNTO 1));
	nlO1lO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlO1lO_data,
		o => wire_nlO1lO_o,
		sel => wire_nlO1lO_sel
	  );
	wire_nlO1Oi_data <= ( "1" & wire_nlO0iO_dataout & wire_nlOliO_dataout & wire_nlO0iO_dataout & wire_nlO0iO_dataout & wire_nlO0iO_dataout & wire_n11ll_dataout & wire_nlOliO_dataout & wire_nlO0iO_dataout);
	wire_nlO1Oi_sel <= ( niO0Ol & wire_nlO00i_o(8 DOWNTO 1));
	nlO1Oi :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlO1Oi_data,
		o => wire_nlO1Oi_o,
		sel => wire_nlO1Oi_sel
	  );
	wire_nlO1Ol_data <= ( "1" & wire_nlO0li_dataout & wire_nlOlli_dataout & wire_nlO0li_dataout & wire_nlO0li_dataout & wire_nlO0li_dataout & wire_n11lO_dataout & wire_nlOlli_dataout & wire_nlO0li_dataout);
	wire_nlO1Ol_sel <= ( niO0Ol & wire_nlO00i_o(8 DOWNTO 1));
	nlO1Ol :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlO1Ol_data,
		o => wire_nlO1Ol_o,
		sel => wire_nlO1Ol_sel
	  );
	wire_nlO1OO_data <= ( "1" & wire_nlO0ll_dataout & wire_nlOlll_dataout & wire_nlOOii_dataout & wire_nlOOii_dataout & wire_nlOOlO_dataout & wire_n11Oi_dataout & wire_nlOOOl_dataout & wire_n111O_dataout);
	wire_nlO1OO_sel <= ( niO0Ol & wire_nlO00i_o(8 DOWNTO 1));
	nlO1OO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlO1OO_data,
		o => wire_nlO1OO_o,
		sel => wire_nlO1OO_sel
	  );
	wire_nlOli_data <= ( "1" & wire_n11i_dataout & wire_n10O_dataout & wire_n01i_dataout & wire_n01i_dataout & wire_n00O_dataout & wire_n0il_dataout);
	wire_nlOli_sel <= ( niOill & wire_nlO00i_o(8 DOWNTO 5) & wire_nlO00i_o(2 DOWNTO 1));
	nlOli :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_nlOli_data,
		o => wire_nlOli_o,
		sel => wire_nlOli_sel
	  );
	wire_nlOlO_data <= ( "1" & wire_n11l_dataout & wire_n1ii_dataout & wire_n01l_dataout & wire_n01l_dataout & n0Ol & wire_n0ll_dataout & n0Ol & wire_n0iO_dataout);
	wire_nlOlO_sel <= ( niOilO & wire_nlO00i_o(8 DOWNTO 1));
	nlOlO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlOlO_data,
		o => wire_nlOlO_o,
		sel => wire_nlOlO_sel
	  );
	wire_nlOOi_data <= ( "0" & wire_n11O_dataout & wire_n1il_dataout & wire_n11O_dataout & wire_n11O_dataout & wire_n11O_dataout & wire_n0lO_dataout & wire_n11O_dataout);
	wire_nlOOi_sel <= ( niOiOi & wire_nlO00i_o(8 DOWNTO 2));
	nlOOi :  oper_selector
	  GENERIC MAP (
		width_data => 8,
		width_sel => 8
	  )
	  PORT MAP ( 
		data => wire_nlOOi_data,
		o => wire_nlOOi_o,
		sel => wire_nlOOi_sel
	  );

 END RTL; --tx_sm
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 147 mux21 352 oper_decoder 1 oper_selector 3 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  rcv_sm IS 
	 PORT 
	 ( 
		 clk_2	:	IN  STD_LOGIC;
		 curr_state	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 dec_ctl	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 dec_data	:	IN  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 dec_data_valid	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 indv	:	IN  STD_LOGIC;
		 running_disp	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rx_ctl_rs	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rx_data_rs	:	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 rx_local_fault	:	OUT  STD_LOGIC;
		 rx_local_fault_clr	:	IN  STD_LOGIC;
		 soft_reset	:	IN  STD_LOGIC;
		 tx_local_fault_det	:	IN  STD_LOGIC;
		 xs_link_status	:	OUT  STD_LOGIC;
		 xs_link_status_set	:	IN  STD_LOGIC
	 ); 
 END rcv_sm;

 ARCHITECTURE RTL OF rcv_sm IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 nl000l40	:	STD_LOGIC := '1';
	 SIGNAL	 nl000l41	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl000l41_w_lg_Q136w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl000l42	:	STD_LOGIC := '0';
	 SIGNAL	 nl000O37	:	STD_LOGIC := '1';
	 SIGNAL	 nl000O38	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl000O38_w_lg_Q119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl000O39	:	STD_LOGIC := '0';
	 SIGNAL	 nl001l43	:	STD_LOGIC := '1';
	 SIGNAL	 nl001l44	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl001l44_w_lg_Q159w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl001l45	:	STD_LOGIC := '0';
	 SIGNAL	 nl00il34	:	STD_LOGIC := '1';
	 SIGNAL	 nl00il35	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl00il35_w_lg_Q112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl00il36	:	STD_LOGIC := '0';
	 SIGNAL	 nl00lO31	:	STD_LOGIC := '1';
	 SIGNAL	 nl00lO32	:	STD_LOGIC := '1';
	 SIGNAL	 nl00lO33	:	STD_LOGIC := '0';
	 SIGNAL	 nl010i52	:	STD_LOGIC := '1';
	 SIGNAL	 nl010i53	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl010i53_w_lg_Q179w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl010i54	:	STD_LOGIC := '0';
	 SIGNAL	 nl011i55	:	STD_LOGIC := '1';
	 SIGNAL	 nl011i56	:	STD_LOGIC := '1';
	 SIGNAL	 nl011i57	:	STD_LOGIC := '0';
	 SIGNAL	 nl01li49	:	STD_LOGIC := '1';
	 SIGNAL	 nl01li50	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl01li50_w_lg_Q170w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl01li51	:	STD_LOGIC := '0';
	 SIGNAL	 nl01lO46	:	STD_LOGIC := '1';
	 SIGNAL	 nl01lO47	:	STD_LOGIC := '1';
	 SIGNAL	 nl01lO48	:	STD_LOGIC := '0';
	 SIGNAL	 nl0i0i25	:	STD_LOGIC := '1';
	 SIGNAL	 nl0i0i26	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0i0i26_w_lg_Q82w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0i0i27	:	STD_LOGIC := '0';
	 SIGNAL	 nl0i1i28	:	STD_LOGIC := '1';
	 SIGNAL	 nl0i1i29	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0i1i29_w_lg_Q89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0i1i30	:	STD_LOGIC := '0';
	 SIGNAL	 nl0iil22	:	STD_LOGIC := '1';
	 SIGNAL	 nl0iil23	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0iil23_w_lg_Q72w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0iil24	:	STD_LOGIC := '0';
	 SIGNAL	 nl0iOl19	:	STD_LOGIC := '1';
	 SIGNAL	 nl0iOl20	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0iOl20_w_lg_Q57w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0iOl21	:	STD_LOGIC := '0';
	 SIGNAL	 nl0l0l16	:	STD_LOGIC := '1';
	 SIGNAL	 nl0l0l17	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0l0l17_w_lg_Q49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0l0l18	:	STD_LOGIC := '0';
	 SIGNAL	 nl0liO13	:	STD_LOGIC := '1';
	 SIGNAL	 nl0liO14	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0liO14_w_lg_Q41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0liO15	:	STD_LOGIC := '0';
	 SIGNAL	 nl0lOi10	:	STD_LOGIC := '1';
	 SIGNAL	 nl0lOi11	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0lOi11_w_lg_Q34w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0lOi12	:	STD_LOGIC := '0';
	 SIGNAL	 nl0O0i7	:	STD_LOGIC := '1';
	 SIGNAL	 nl0O0i8	:	STD_LOGIC := '1';
	 SIGNAL	 nl0O0i9	:	STD_LOGIC := '0';
	 SIGNAL	 nl0Oil4	:	STD_LOGIC := '1';
	 SIGNAL	 nl0Oil5	:	STD_LOGIC := '1';
	 SIGNAL	 nl0Oil6	:	STD_LOGIC := '0';
	 SIGNAL	 nl0OlO1	:	STD_LOGIC := '1';
	 SIGNAL	 nl0OlO2	:	STD_LOGIC := '1';
	 SIGNAL	 nl0OlO3	:	STD_LOGIC := '0';
	 SIGNAL	 nl1OOl58	:	STD_LOGIC := '1';
	 SIGNAL	 nl1OOl59	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl1OOl59_w_lg_Q189w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl1OOl60	:	STD_LOGIC := '0';
	 SIGNAL	n000i	:	STD_LOGIC := '0';
	 SIGNAL	n000l	:	STD_LOGIC := '0';
	 SIGNAL	n000O	:	STD_LOGIC := '0';
	 SIGNAL	n001O	:	STD_LOGIC := '0';
	 SIGNAL	n00ii	:	STD_LOGIC := '0';
	 SIGNAL	n0liO	:	STD_LOGIC := '0';
	 SIGNAL	n0lli	:	STD_LOGIC := '0';
	 SIGNAL	n0lll	:	STD_LOGIC := '0';
	 SIGNAL	n0llO	:	STD_LOGIC := '0';
	 SIGNAL	n0lOi	:	STD_LOGIC := '0';
	 SIGNAL	n0lOl	:	STD_LOGIC := '0';
	 SIGNAL	n0lOO	:	STD_LOGIC := '0';
	 SIGNAL	n0O1i	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	n10Oi	:	STD_LOGIC := '0';
	 SIGNAL	n10Ol	:	STD_LOGIC := '0';
	 SIGNAL	n10OO	:	STD_LOGIC := '0';
	 SIGNAL	n1i0i	:	STD_LOGIC := '0';
	 SIGNAL	n1i0l	:	STD_LOGIC := '0';
	 SIGNAL	n1i1i	:	STD_LOGIC := '0';
	 SIGNAL	n1i1l	:	STD_LOGIC := '0';
	 SIGNAL	n1i1O	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0l	:	STD_LOGIC := '0';
	 SIGNAL	ni0O	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1O	:	STD_LOGIC := '0';
	 SIGNAL	nii0O	:	STD_LOGIC := '0';
	 SIGNAL	niiii	:	STD_LOGIC := '0';
	 SIGNAL	niiil	:	STD_LOGIC := '0';
	 SIGNAL	niiiO	:	STD_LOGIC := '0';
	 SIGNAL	niili	:	STD_LOGIC := '0';
	 SIGNAL	niill	:	STD_LOGIC := '0';
	 SIGNAL	niilO	:	STD_LOGIC := '0';
	 SIGNAL	niiOi	:	STD_LOGIC := '0';
	 SIGNAL	niiOl	:	STD_LOGIC := '0';
	 SIGNAL	nili	:	STD_LOGIC := '0';
	 SIGNAL	nill	:	STD_LOGIC := '0';
	 SIGNAL	niOi	:	STD_LOGIC := '0';
	 SIGNAL	nl00i	:	STD_LOGIC := '0';
	 SIGNAL	nl00l	:	STD_LOGIC := '0';
	 SIGNAL	nl00O	:	STD_LOGIC := '0';
	 SIGNAL	nl01O	:	STD_LOGIC := '0';
	 SIGNAL	nl0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl0il	:	STD_LOGIC := '0';
	 SIGNAL	nl0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl0li	:	STD_LOGIC := '0';
	 SIGNAL	nlll0l	:	STD_LOGIC := '0';
	 SIGNAL	nlll0O	:	STD_LOGIC := '0';
	 SIGNAL	nlllii	:	STD_LOGIC := '0';
	 SIGNAL	nlllil	:	STD_LOGIC := '0';
	 SIGNAL	nllliO	:	STD_LOGIC := '0';
	 SIGNAL	nllll	:	STD_LOGIC := '0';
	 SIGNAL	nlllli	:	STD_LOGIC := '0';
	 SIGNAL	nlllll	:	STD_LOGIC := '0';
	 SIGNAL	nllllO	:	STD_LOGIC := '0';
	 SIGNAL	nlllO	:	STD_LOGIC := '0';
	 SIGNAL	nlllOi	:	STD_LOGIC := '0';
	 SIGNAL	nlllOl	:	STD_LOGIC := '0';
	 SIGNAL	nlllOO	:	STD_LOGIC := '0';
	 SIGNAL	nllOi	:	STD_LOGIC := '0';
	 SIGNAL	nllOl	:	STD_LOGIC := '0';
	 SIGNAL	nllOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOili	:	STD_LOGIC := '0';
	 SIGNAL	nlOill	:	STD_LOGIC := '0';
	 SIGNAL	nlOilO	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOiOO	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1i	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOl1O	:	STD_LOGIC := '0';
	 SIGNAL  wire_nilO_w_lg_ni1i262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilO_w_lg_ni1l263w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlli0O	:	STD_LOGIC := '0';
	 SIGNAL	nlliii	:	STD_LOGIC := '0';
	 SIGNAL	nlliil	:	STD_LOGIC := '0';
	 SIGNAL	nlliiO	:	STD_LOGIC := '0';
	 SIGNAL	nllili	:	STD_LOGIC := '0';
	 SIGNAL	nllill	:	STD_LOGIC := '0';
	 SIGNAL	nllilO	:	STD_LOGIC := '0';
	 SIGNAL	nlliOi	:	STD_LOGIC := '0';
	 SIGNAL	nlliOl	:	STD_LOGIC := '0';
	 SIGNAL	nlliOO	:	STD_LOGIC := '0';
	 SIGNAL	nlll0i	:	STD_LOGIC := '0';
	 SIGNAL	nlll1i	:	STD_LOGIC := '0';
	 SIGNAL	nlll1l	:	STD_LOGIC := '0';
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni_w_lg_dataout12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl_w_lg_dataout19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl_w_lg_dataout167w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO_w_lg_dataout5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlO_w_lg_dataout186w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nO_w_lg_dataout218w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0li_w_lg_w_o_range122w124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0li_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0li_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0li_w_o_range122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ii_w_lg_o114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0ii_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0ii_o	:	STD_LOGIC;
	 SIGNAL  wire_n0ii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0il_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0il_o	:	STD_LOGIC;
	 SIGNAL  wire_n0il_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0iO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0iO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl0ill163w166w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl0l1l182w185w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_dec_ctl_range6w7w10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_dec_ctl_range13w14w17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_dec_ctl_range20w21w24w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0ill163w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0l1l182w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_ctl_range6w7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_ctl_range13w14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_ctl_range20w21w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_ctl_range43w219w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range154w266w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range209w282w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range201w290w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range217w274w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl00ll108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl00Ol116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl00OO92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0i0O78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0i1O85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0iii76w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0ili63w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0ilO59w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0l1i53w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0l1O51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0lii45w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0lll37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0lOO30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0O1l27w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range208w281w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range153w265w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range200w289w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_dec_data_range216w273w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl00ll108w109w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nl0O1i67w68w69w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl0l1l61w62w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl0O1i67w68w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0l1l61w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0O1i67w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nl000i :	STD_LOGIC;
	 SIGNAL  nl001i :	STD_LOGIC;
	 SIGNAL  nl00ii :	STD_LOGIC;
	 SIGNAL  nl00li :	STD_LOGIC;
	 SIGNAL  nl00ll :	STD_LOGIC;
	 SIGNAL  nl00Ol :	STD_LOGIC;
	 SIGNAL  nl00OO :	STD_LOGIC;
	 SIGNAL  nl010O :	STD_LOGIC;
	 SIGNAL  nl011O :	STD_LOGIC;
	 SIGNAL  nl01ii :	STD_LOGIC;
	 SIGNAL  nl01il :	STD_LOGIC;
	 SIGNAL  nl01iO :	STD_LOGIC;
	 SIGNAL  nl01Ol :	STD_LOGIC;
	 SIGNAL  nl01OO :	STD_LOGIC;
	 SIGNAL  nl0i0O :	STD_LOGIC;
	 SIGNAL  nl0i1O :	STD_LOGIC;
	 SIGNAL  nl0iii :	STD_LOGIC;
	 SIGNAL  nl0ili :	STD_LOGIC;
	 SIGNAL  nl0ill :	STD_LOGIC;
	 SIGNAL  nl0ilO :	STD_LOGIC;
	 SIGNAL  nl0iOi :	STD_LOGIC;
	 SIGNAL  nl0l0i :	STD_LOGIC;
	 SIGNAL  nl0l1i :	STD_LOGIC;
	 SIGNAL  nl0l1l :	STD_LOGIC;
	 SIGNAL  nl0l1O :	STD_LOGIC;
	 SIGNAL  nl0lii :	STD_LOGIC;
	 SIGNAL  nl0lil :	STD_LOGIC;
	 SIGNAL  nl0lll :	STD_LOGIC;
	 SIGNAL  nl0llO :	STD_LOGIC;
	 SIGNAL  nl0lOO :	STD_LOGIC;
	 SIGNAL  nl0O0O :	STD_LOGIC;
	 SIGNAL  nl0O1i :	STD_LOGIC;
	 SIGNAL  nl0O1l :	STD_LOGIC;
	 SIGNAL  nl0O1O :	STD_LOGIC;
	 SIGNAL  nl0Oii :	STD_LOGIC;
	 SIGNAL  nl0Oli :	STD_LOGIC;
	 SIGNAL  nl0Oll :	STD_LOGIC;
	 SIGNAL  nl0OOl :	STD_LOGIC;
	 SIGNAL  nl0OOO :	STD_LOGIC;
	 SIGNAL  nl1Oil :	STD_LOGIC;
	 SIGNAL  nl1OiO :	STD_LOGIC;
	 SIGNAL  nl1Oli :	STD_LOGIC;
	 SIGNAL  nl1Oll :	STD_LOGIC;
	 SIGNAL  nl1OlO :	STD_LOGIC;
	 SIGNAL  nl1OOi :	STD_LOGIC;
	 SIGNAL  wire_w_dec_ctl_range6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_ctl_range13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_ctl_range20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_ctl_range43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range154w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range209w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range208w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range201w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range200w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range217w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dec_data_range216w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_lg_nl0ill163w166w(0) <= wire_w_lg_nl0ill163w(0) AND nl01lO47;
	wire_w_lg_w_lg_nl0l1l182w185w(0) <= wire_w_lg_nl0l1l182w(0) AND nl011i56;
	wire_w_lg_w_lg_w_dec_ctl_range6w7w10w(0) <= wire_w_lg_w_dec_ctl_range6w7w(0) AND nl0OlO2;
	wire_w_lg_w_lg_w_dec_ctl_range13w14w17w(0) <= wire_w_lg_w_dec_ctl_range13w14w(0) AND nl0Oil5;
	wire_w_lg_w_lg_w_dec_ctl_range20w21w24w(0) <= wire_w_lg_w_dec_ctl_range20w21w(0) AND nl0O0i8;
	wire_w_lg_nl0ill163w(0) <= nl0ill AND nl0lil;
	wire_w_lg_nl0l1l182w(0) <= nl0l1l AND nl0O1i;
	wire_w_lg_w_dec_ctl_range6w7w(0) <= wire_w_dec_ctl_range6w(0) AND nl0OOl;
	wire_w_lg_w_dec_ctl_range13w14w(0) <= wire_w_dec_ctl_range13w(0) AND nl0Oli;
	wire_w_lg_w_dec_ctl_range20w21w(0) <= wire_w_dec_ctl_range20w(0) AND nl0O0O;
	wire_w_lg_w_dec_ctl_range43w219w(0) <= wire_w_dec_ctl_range43w(0) AND nl1Oil;
	wire_w_lg_w_dec_data_range154w266w(0) <= wire_w_dec_data_range154w(0) AND wire_w_lg_w_dec_data_range153w265w(0);
	wire_w_lg_w_dec_data_range209w282w(0) <= wire_w_dec_data_range209w(0) AND wire_w_lg_w_dec_data_range208w281w(0);
	wire_w_lg_w_dec_data_range201w290w(0) <= wire_w_dec_data_range201w(0) AND wire_w_lg_w_dec_data_range200w289w(0);
	wire_w_lg_w_dec_data_range217w274w(0) <= wire_w_dec_data_range217w(0) AND wire_w_lg_w_dec_data_range216w273w(0);
	wire_w_lg_nl00ll108w(0) <= NOT nl00ll;
	wire_w_lg_nl00Ol116w(0) <= NOT nl00Ol;
	wire_w_lg_nl00OO92w(0) <= NOT nl00OO;
	wire_w_lg_nl0i0O78w(0) <= NOT nl0i0O;
	wire_w_lg_nl0i1O85w(0) <= NOT nl0i1O;
	wire_w_lg_nl0iii76w(0) <= NOT nl0iii;
	wire_w_lg_nl0ili63w(0) <= NOT nl0ili;
	wire_w_lg_nl0ilO59w(0) <= NOT nl0ilO;
	wire_w_lg_nl0l1i53w(0) <= NOT nl0l1i;
	wire_w_lg_nl0l1O51w(0) <= NOT nl0l1O;
	wire_w_lg_nl0lii45w(0) <= NOT nl0lii;
	wire_w_lg_nl0lll37w(0) <= NOT nl0lll;
	wire_w_lg_nl0lOO30w(0) <= NOT nl0lOO;
	wire_w_lg_nl0O1l27w(0) <= NOT nl0O1l;
	wire_w_lg_soft_reset107w(0) <= NOT soft_reset;
	wire_w_lg_w_dec_data_range208w281w(0) <= NOT wire_w_dec_data_range208w(0);
	wire_w_lg_w_dec_data_range153w265w(0) <= NOT wire_w_dec_data_range153w(0);
	wire_w_lg_w_dec_data_range200w289w(0) <= NOT wire_w_dec_data_range200w(0);
	wire_w_lg_w_dec_data_range216w273w(0) <= NOT wire_w_dec_data_range216w(0);
	wire_w_lg_w_lg_nl00ll108w109w(0) <= wire_w_lg_nl00ll108w(0) OR ni1O;
	wire_w_lg_w_lg_w_lg_nl0O1i67w68w69w(0) <= wire_w_lg_w_lg_nl0O1i67w68w(0) OR nl0l0i;
	wire_w_lg_w_lg_nl0l1l61w62w(0) <= wire_w_lg_nl0l1l61w(0) OR nl0ill;
	wire_w_lg_w_lg_nl0O1i67w68w(0) <= wire_w_lg_nl0O1i67w(0) OR nl0lil;
	wire_w_lg_nl0l1l61w(0) <= nl0l1l OR nl0iOi;
	wire_w_lg_nl0O1i67w(0) <= nl0O1i OR nl0llO;
	curr_state <= ( ni1l & ni1i);
	nl000i <= (nl0Oll OR nl0Oii);
	nl001i <= ((nl000i OR nl0O1O) OR wire_nl001l44_w_lg_Q159w(0));
	nl00ii <= (wire_w_lg_nl00ll108w(0) OR n0Ol);
	nl00li <= '1';
	nl00ll <= ((((dec_data_valid(3) AND dec_data_valid(2)) AND dec_data_valid(1)) AND dec_data_valid(0)) AND nl00lO32);
	nl00Ol <= (((NOT (wire_w_lg_w_lg_nl0l1l61w62w(0) OR ((NOT dec_ctl(3)) OR wire_w_lg_nl0ili63w(0)))) OR (NOT (wire_w_lg_w_lg_w_lg_nl0O1i67w68w69w(0) OR wire_nl0iil23_w_lg_Q72w(0)))) OR (NOT (((((NOT dec_ctl(3)) OR wire_w_lg_nl0iii76w(0)) OR (((NOT dec_ctl(2)) OR wire_w_lg_nl0i0O78w(0)) OR wire_nl0i0i26_w_lg_Q82w(0))) OR (((NOT dec_ctl(1)) OR wire_w_lg_nl0i1O85w(0)) OR wire_nl0i1i29_w_lg_Q89w(0))) OR ((NOT dec_ctl(0)) OR wire_w_lg_nl00OO92w(0)))));
	nl00OO <= ((((((((NOT dec_data(0)) AND wire_w_lg_w_dec_data_range153w265w(0)) AND dec_data(2)) AND dec_data(3)) AND dec_data(4)) AND (NOT dec_data(5))) AND (NOT dec_data(6))) AND (NOT dec_data(7)));
	nl010O <= (wire_ni_dataout OR (nl0iOi AND nl0llO));
	nl011O <= (nlllii OR ((nlll0O OR nlll0l) OR wire_nl010i53_w_lg_Q179w(0)));
	nl01ii <= (nlllii OR nlll0l);
	nl01il <= (wire_ni_dataout OR nl0llO);
	nl01iO <= (wire_nl_w_lg_dataout167w(0) OR wire_nl01li50_w_lg_Q170w(0));
	nl01Ol <= (wire_nl_dataout OR nl0lil);
	nl01OO <= (nl0l0i OR wire_nO_dataout);
	nl0i0O <= ((((((((NOT dec_data(16)) AND wire_w_lg_w_dec_data_range208w281w(0)) AND dec_data(18)) AND dec_data(19)) AND dec_data(20)) AND (NOT dec_data(21))) AND (NOT dec_data(22))) AND (NOT dec_data(23)));
	nl0i1O <= ((((((((NOT dec_data(8)) AND wire_w_lg_w_dec_data_range216w273w(0)) AND dec_data(10)) AND dec_data(11)) AND dec_data(12)) AND (NOT dec_data(13))) AND (NOT dec_data(14))) AND (NOT dec_data(15)));
	nl0iii <= ((((((((NOT dec_data(24)) AND wire_w_lg_w_dec_data_range200w289w(0)) AND dec_data(26)) AND dec_data(27)) AND dec_data(28)) AND (NOT dec_data(29))) AND (NOT dec_data(30))) AND (NOT dec_data(31)));
	nl0ili <= ((((((((NOT dec_data(24)) AND wire_w_lg_w_dec_data_range200w289w(0)) AND dec_data(26)) AND dec_data(27)) AND dec_data(28)) AND dec_data(29)) AND dec_data(30)) AND (NOT dec_data(31)));
	nl0ill <= ((NOT dec_ctl(2)) OR wire_w_lg_nl0ilO59w(0));
	nl0ilO <= ((((((((NOT dec_data(16)) AND wire_w_lg_w_dec_data_range208w281w(0)) AND dec_data(18)) AND dec_data(19)) AND dec_data(20)) AND dec_data(21)) AND dec_data(22)) AND (NOT dec_data(23)));
	nl0iOi <= (((NOT dec_ctl(1)) OR wire_w_lg_nl0l1i53w(0)) OR wire_nl0iOl20_w_lg_Q57w(0));
	nl0l0i <= (((NOT dec_ctl(3)) OR wire_w_lg_nl0lii45w(0)) OR wire_nl0l0l17_w_lg_Q49w(0));
	nl0l1i <= ((((((((NOT dec_data(8)) AND wire_w_lg_w_dec_data_range216w273w(0)) AND dec_data(10)) AND dec_data(11)) AND dec_data(12)) AND dec_data(13)) AND dec_data(14)) AND (NOT dec_data(15)));
	nl0l1l <= ((NOT dec_ctl(0)) OR wire_w_lg_nl0l1O51w(0));
	nl0l1O <= ((((((((NOT dec_data(0)) AND wire_w_lg_w_dec_data_range153w265w(0)) AND dec_data(2)) AND dec_data(3)) AND dec_data(4)) AND dec_data(5)) AND dec_data(6)) AND (NOT dec_data(7)));
	nl0lii <= ((((((((NOT dec_data(24)) AND wire_w_lg_w_dec_data_range200w289w(0)) AND dec_data(26)) AND dec_data(27)) AND dec_data(28)) AND dec_data(29)) AND (NOT dec_data(30))) AND dec_data(31));
	nl0lil <= (((NOT dec_ctl(2)) OR wire_w_lg_nl0lll37w(0)) OR wire_nl0liO14_w_lg_Q41w(0));
	nl0lll <= ((((((((NOT dec_data(16)) AND wire_w_lg_w_dec_data_range208w281w(0)) AND dec_data(18)) AND dec_data(19)) AND dec_data(20)) AND dec_data(21)) AND (NOT dec_data(22))) AND dec_data(23));
	nl0llO <= (((NOT dec_ctl(1)) OR wire_w_lg_nl0lOO30w(0)) OR wire_nl0lOi11_w_lg_Q34w(0));
	nl0lOO <= ((((((((NOT dec_data(8)) AND wire_w_lg_w_dec_data_range216w273w(0)) AND dec_data(10)) AND dec_data(11)) AND dec_data(12)) AND dec_data(13)) AND (NOT dec_data(14))) AND dec_data(15));
	nl0O0O <= ((((((wire_w_lg_w_dec_data_range209w282w(0) AND dec_data(18)) AND dec_data(19)) AND dec_data(20)) AND dec_data(21)) AND dec_data(22)) AND dec_data(23));
	nl0O1i <= ((NOT dec_ctl(0)) OR wire_w_lg_nl0O1l27w(0));
	nl0O1l <= ((((((((NOT dec_data(0)) AND wire_w_lg_w_dec_data_range153w265w(0)) AND dec_data(2)) AND dec_data(3)) AND dec_data(4)) AND dec_data(5)) AND (NOT dec_data(6))) AND dec_data(7));
	nl0O1O <= (wire_nl_w_lg_dataout19w(0) AND wire_w_lg_w_lg_w_dec_ctl_range20w21w24w(0));
	nl0Oii <= (wire_ni_w_lg_dataout12w(0) AND wire_w_lg_w_lg_w_dec_ctl_range13w14w17w(0));
	nl0Oli <= ((((((wire_w_lg_w_dec_data_range217w274w(0) AND dec_data(10)) AND dec_data(11)) AND dec_data(12)) AND dec_data(13)) AND dec_data(14)) AND dec_data(15));
	nl0Oll <= (wire_nlO_w_lg_dataout5w(0) AND wire_w_lg_w_lg_w_dec_ctl_range6w7w10w(0));
	nl0OOl <= ((((((wire_w_lg_w_dec_data_range154w266w(0) AND dec_data(2)) AND dec_data(3)) AND dec_data(4)) AND dec_data(5)) AND dec_data(6)) AND dec_data(7));
	nl0OOO <= (wire_nilO_w_lg_ni1i262w(0) AND wire_nilO_w_lg_ni1l263w(0));
	nl1Oil <= ((((((wire_w_lg_w_dec_data_range201w290w(0) AND dec_data(26)) AND dec_data(27)) AND dec_data(28)) AND dec_data(29)) AND dec_data(30)) AND dec_data(31));
	nl1OiO <= (ni1i AND ni1l);
	nl1Oli <= (nl0O1O OR nl1Oll);
	nl1Oll <= (nl0Oii OR nl1OlO);
	nl1OlO <= (nl0Oll OR nl00Ol);
	nl1OOi <= (wire_nlO_w_lg_dataout186w(0) OR wire_nl1OOl59_w_lg_Q189w(0));
	rx_ctl_rs <= ( nllll & nl01O & nii0O & nllill);
	rx_data_rs <= ( nl0li & nl0iO & nl0il & nl0ii & nl00O & nl00l & nl00i & nllilO & niiOl & niiOi & niilO & niill & niili & niiiO & niiil & niiii & n0O1i & n0lOO & n0lOl & n0lOi & n0llO & n0lll & n0lli & n0liO & nllili & n00ii & n000O & nlliiO & nlliil & nlliii & n000l & n000i);
	rx_local_fault <= nlll0i;
	xs_link_status <= nili;
	wire_w_dec_ctl_range6w(0) <= dec_ctl(0);
	wire_w_dec_ctl_range13w(0) <= dec_ctl(1);
	wire_w_dec_ctl_range20w(0) <= dec_ctl(2);
	wire_w_dec_ctl_range43w(0) <= dec_ctl(3);
	wire_w_dec_data_range154w(0) <= dec_data(0);
	wire_w_dec_data_range209w(0) <= dec_data(16);
	wire_w_dec_data_range208w(0) <= dec_data(17);
	wire_w_dec_data_range153w(0) <= dec_data(1);
	wire_w_dec_data_range201w(0) <= dec_data(24);
	wire_w_dec_data_range200w(0) <= dec_data(25);
	wire_w_dec_data_range217w(0) <= dec_data(8);
	wire_w_dec_data_range216w(0) <= dec_data(9);
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000l40 <= nl000l42;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000l41 <= (nl000l42 XOR nl000l40);
		END IF;
	END PROCESS;
	wire_nl000l41_w_lg_Q136w(0) <= nl000l41 AND wire_n0ll_dataout;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000l42 <= nl000l40;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000O37 <= nl000O39;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000O38 <= (nl000O39 XOR nl000O37);
		END IF;
	END PROCESS;
	wire_nl000O38_w_lg_Q119w(0) <= nl000O38 AND ni1i;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl000O39 <= nl000O37;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl001l43 <= nl001l45;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl001l44 <= (nl001l45 XOR nl001l43);
		END IF;
	END PROCESS;
	wire_nl001l44_w_lg_Q159w(0) <= NOT nl001l44;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl001l45 <= nl001l43;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00il34 <= nl00il36;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00il35 <= (nl00il36 XOR nl00il34);
		END IF;
	END PROCESS;
	wire_nl00il35_w_lg_Q112w(0) <= NOT nl00il35;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00il36 <= nl00il34;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00lO31 <= nl00lO33;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00lO32 <= (nl00lO33 XOR nl00lO31);
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl00lO33 <= nl00lO31;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl010i52 <= nl010i54;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl010i53 <= (nl010i54 XOR nl010i52);
		END IF;
	END PROCESS;
	wire_nl010i53_w_lg_Q179w(0) <= NOT nl010i53;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl010i54 <= nl010i52;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl011i55 <= nl011i57;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl011i56 <= (nl011i57 XOR nl011i55);
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl011i57 <= nl011i55;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01li49 <= nl01li51;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01li50 <= (nl01li51 XOR nl01li49);
		END IF;
	END PROCESS;
	wire_nl01li50_w_lg_Q170w(0) <= NOT nl01li50;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01li51 <= nl01li49;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01lO46 <= nl01lO48;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01lO47 <= (nl01lO48 XOR nl01lO46);
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl01lO48 <= nl01lO46;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i0i25 <= nl0i0i27;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i0i26 <= (nl0i0i27 XOR nl0i0i25);
		END IF;
	END PROCESS;
	wire_nl0i0i26_w_lg_Q82w(0) <= NOT nl0i0i26;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i0i27 <= nl0i0i25;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i1i28 <= nl0i1i30;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i1i29 <= (nl0i1i30 XOR nl0i1i28);
		END IF;
	END PROCESS;
	wire_nl0i1i29_w_lg_Q89w(0) <= NOT nl0i1i29;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0i1i30 <= nl0i1i28;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iil22 <= nl0iil24;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iil23 <= (nl0iil24 XOR nl0iil22);
		END IF;
	END PROCESS;
	wire_nl0iil23_w_lg_Q72w(0) <= NOT nl0iil23;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iil24 <= nl0iil22;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iOl19 <= nl0iOl21;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iOl20 <= (nl0iOl21 XOR nl0iOl19);
		END IF;
	END PROCESS;
	wire_nl0iOl20_w_lg_Q57w(0) <= NOT nl0iOl20;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0iOl21 <= nl0iOl19;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0l0l16 <= nl0l0l18;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0l0l17 <= (nl0l0l18 XOR nl0l0l16);
		END IF;
	END PROCESS;
	wire_nl0l0l17_w_lg_Q49w(0) <= NOT nl0l0l17;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0l0l18 <= nl0l0l16;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0liO13 <= nl0liO15;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0liO14 <= (nl0liO15 XOR nl0liO13);
		END IF;
	END PROCESS;
	wire_nl0liO14_w_lg_Q41w(0) <= NOT nl0liO14;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0liO15 <= nl0liO13;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0lOi10 <= nl0lOi12;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0lOi11 <= (nl0lOi12 XOR nl0lOi10);
		END IF;
	END PROCESS;
	wire_nl0lOi11_w_lg_Q34w(0) <= NOT nl0lOi11;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0lOi12 <= nl0lOi10;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0O0i7 <= nl0O0i9;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0O0i8 <= (nl0O0i9 XOR nl0O0i7);
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0O0i9 <= nl0O0i7;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0Oil4 <= nl0Oil6;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0Oil5 <= (nl0Oil6 XOR nl0Oil4);
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0Oil6 <= nl0Oil4;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0OlO1 <= nl0OlO3;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0OlO2 <= (nl0OlO3 XOR nl0OlO1);
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl0OlO3 <= nl0OlO1;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl1OOl58 <= nl1OOl60;
		END IF;
	END PROCESS;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl1OOl59 <= (nl1OOl60 XOR nl1OOl58);
		END IF;
	END PROCESS;
	wire_nl1OOl59_w_lg_Q189w(0) <= NOT nl1OOl59;
	PROCESS (clk_2)
	BEGIN
		IF (clk_2 = '1' AND clk_2'event) THEN nl1OOl60 <= nl1OOl58;
		END IF;
	END PROCESS;
	PROCESS (clk_2, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n000i <= '0';
				n000l <= '0';
				n000O <= '0';
				n001O <= '0';
				n00ii <= '0';
				n0liO <= '0';
				n0lli <= '0';
				n0lll <= '0';
				n0llO <= '0';
				n0lOi <= '0';
				n0lOl <= '0';
				n0lOO <= '0';
				n0O1i <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				n10Oi <= '0';
				n10Ol <= '0';
				n10OO <= '0';
				n1i0i <= '0';
				n1i0l <= '0';
				n1i1i <= '0';
				n1i1l <= '0';
				n1i1O <= '0';
				ni0i <= '0';
				ni0l <= '0';
				ni0O <= '0';
				ni1i <= '0';
				ni1l <= '0';
				ni1O <= '0';
				nii0O <= '0';
				niiii <= '0';
				niiil <= '0';
				niiiO <= '0';
				niili <= '0';
				niill <= '0';
				niilO <= '0';
				niiOi <= '0';
				niiOl <= '0';
				nili <= '0';
				nill <= '0';
				niOi <= '0';
				nl00i <= '0';
				nl00l <= '0';
				nl00O <= '0';
				nl01O <= '0';
				nl0ii <= '0';
				nl0il <= '0';
				nl0iO <= '0';
				nl0li <= '0';
				nlll0l <= '0';
				nlll0O <= '0';
				nlllii <= '0';
				nlllil <= '0';
				nllliO <= '0';
				nllll <= '0';
				nlllli <= '0';
				nlllll <= '0';
				nllllO <= '0';
				nlllO <= '0';
				nlllOi <= '0';
				nlllOl <= '0';
				nlllOO <= '0';
				nllOi <= '0';
				nllOl <= '0';
				nllOO <= '0';
				nlOili <= '0';
				nlOill <= '0';
				nlOilO <= '0';
				nlOiOi <= '0';
				nlOiOl <= '0';
				nlOiOO <= '0';
				nlOl1i <= '0';
				nlOl1l <= '0';
				nlOl1O <= '0';
		ELSIF (clk_2 = '1' AND clk_2'event) THEN
				n000i <= wire_n00il_dataout;
				n000l <= wire_n00iO_dataout;
				n000O <= wire_n00Oi_dataout;
				n001O <= wire_n1iOl_dataout;
				n00ii <= wire_n00Ol_dataout;
				n0liO <= wire_n0O1l_dataout;
				n0lli <= wire_n0O1O_dataout;
				n0lll <= wire_n0O0i_dataout;
				n0llO <= wire_n0O0l_dataout;
				n0lOi <= wire_n0O0O_dataout;
				n0lOl <= wire_n0Oii_dataout;
				n0lOO <= wire_n0Oil_dataout;
				n0O1i <= wire_n0OiO_dataout;
				n0Ol <= n0OO;
				n0OO <= indv;
				n10Oi <= wire_nlOllO_dataout;
				n10Ol <= wire_n1iii_dataout;
				n10OO <= wire_n1iil_dataout;
				n1i0i <= wire_n1ilO_dataout;
				n1i0l <= wire_n1iOi_dataout;
				n1i1i <= wire_n1iiO_dataout;
				n1i1l <= wire_n1ili_dataout;
				n1i1O <= wire_n1ill_dataout;
				ni0i <= tx_local_fault_det;
				ni0l <= ni0O;
				ni0O <= xs_link_status_set;
				ni1i <= wire_n0ii_w_lg_o114w(0);
				ni1l <= wire_n0iO_o;
				ni1O <= ni0i;
				nii0O <= wire_n0Oli_dataout;
				niiii <= wire_niiOO_dataout;
				niiil <= wire_nil1i_dataout;
				niiiO <= wire_nil1l_dataout;
				niili <= wire_nil1O_dataout;
				niill <= wire_nil0i_dataout;
				niilO <= wire_nil0l_dataout;
				niiOi <= wire_nil0O_dataout;
				niiOl <= wire_nilii_dataout;
				nili <= wire_niii_dataout;
				nill <= niOi;
				niOi <= rx_local_fault_clr;
				nl00i <= wire_nl0lO_dataout;
				nl00l <= wire_nl0Oi_dataout;
				nl00O <= wire_nl0Ol_dataout;
				nl01O <= wire_nilil_dataout;
				nl0ii <= wire_nl0OO_dataout;
				nl0il <= wire_nli1i_dataout;
				nl0iO <= wire_nli1l_dataout;
				nl0li <= wire_nli1O_dataout;
				nlll0l <= nl0O1O;
				nlll0O <= nl0Oii;
				nlllii <= (wire_nO_w_lg_dataout218w(0) AND wire_w_lg_w_dec_ctl_range43w219w(0));
				nlllil <= wire_nllO1i_dataout;
				nllliO <= wire_nllO1l_dataout;
				nllll <= wire_nli0i_dataout;
				nlllli <= wire_nllO1O_dataout;
				nlllll <= wire_nllO0i_dataout;
				nllllO <= wire_nllO0l_dataout;
				nlllO <= wire_nlO1l_dataout;
				nlllOi <= wire_nllO0O_dataout;
				nlllOl <= wire_nllOii_dataout;
				nlllOO <= wire_nllOil_dataout;
				nllOi <= wire_nlO1O_dataout;
				nllOl <= wire_nlOii_dataout;
				nllOO <= wire_nlOil_dataout;
				nlOili <= wire_nllOiO_dataout;
				nlOill <= wire_nlOl0i_dataout;
				nlOilO <= wire_nlOl0l_dataout;
				nlOiOi <= wire_nlOl0O_dataout;
				nlOiOl <= wire_nlOlii_dataout;
				nlOiOO <= wire_nlOlil_dataout;
				nlOl1i <= wire_nlOliO_dataout;
				nlOl1l <= wire_nlOlli_dataout;
				nlOl1O <= wire_nlOlll_dataout;
		END IF;
	END PROCESS;
	wire_nilO_w_lg_ni1i262w(0) <= NOT ni1i;
	wire_nilO_w_lg_ni1l263w(0) <= NOT ni1l;
	PROCESS (clk_2, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				nlli0O <= '1';
				nlliii <= '1';
				nlliil <= '1';
				nlliiO <= '1';
				nllili <= '1';
				nllill <= '1';
				nllilO <= '1';
				nlliOi <= '1';
				nlliOl <= '1';
				nlliOO <= '1';
				nlll0i <= '1';
				nlll1i <= '1';
				nlll1l <= '1';
		ELSIF (clk_2 = '1' AND clk_2'event) THEN
				nlli0O <= wire_n1i0O_dataout;
				nlliii <= wire_n00li_dataout;
				nlliil <= wire_n00ll_dataout;
				nlliiO <= wire_n00lO_dataout;
				nllili <= wire_n00OO_dataout;
				nllill <= wire_n0i1i_dataout;
				nllilO <= wire_nl0ll_dataout;
				nlliOi <= wire_nlO1i_dataout;
				nlliOl <= wire_nlO0i_dataout;
				nlliOO <= wire_nlO0l_dataout;
				nlll0i <= wire_niOl_dataout;
				nlll1i <= wire_nlO0O_dataout;
				nlll1l <= wire_nlOiO_dataout;
		END IF;
	END PROCESS;
	wire_n00i_dataout <= dec_data(6) OR wire_nlO_dataout;
	wire_n00il_dataout <= wire_n0i1l_dataout AND NOT(nl0OOO);
	wire_n00iO_dataout <= wire_n0i1O_dataout AND NOT(nl0OOO);
	wire_n00l_dataout <= dec_data(7) OR wire_nlO_dataout;
	wire_n00li_dataout <= wire_n0i0i_dataout OR nl0OOO;
	wire_n00ll_dataout <= wire_n0i0l_dataout OR nl0OOO;
	wire_n00lO_dataout <= wire_n0i0O_dataout OR nl0OOO;
	wire_n00O_dataout <= dec_ctl(0) OR wire_nlO_dataout;
	wire_n00Oi_dataout <= wire_n0iii_dataout AND NOT(nl0OOO);
	wire_n00Ol_dataout <= wire_n0iil_dataout AND NOT(nl0OOO);
	wire_n00OO_dataout <= wire_n0iiO_dataout OR nl0OOO;
	wire_n010i_dataout <= wire_n01Oi_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n010l_dataout <= wire_n01Ol_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n010O_dataout <= wire_n1O1O_dataout OR nl1Oli;
	wire_n011i_dataout <= wire_n01li_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n011l_dataout <= wire_n01ll_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n011O_dataout <= wire_n01lO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n01i_dataout <= dec_data(3) OR wire_nlO_dataout;
	wire_n01ii_dataout <= wire_n1O0i_dataout OR nl1Oli;
	wire_n01il_dataout <= wire_n1O0l_dataout OR nl1Oli;
	wire_n01iO_dataout <= wire_n1O0O_dataout AND NOT(nl1Oli);
	wire_n01l_dataout <= dec_data(4) OR wire_nlO_dataout;
	wire_n01li_dataout <= wire_n1Oii_dataout AND NOT(nl1Oli);
	wire_n01ll_dataout <= wire_n1Oil_dataout AND NOT(nl1Oli);
	wire_n01lO_dataout <= wire_n1OiO_dataout AND NOT(nl1Oli);
	wire_n01O_dataout <= dec_data(5) OR wire_nlO_dataout;
	wire_n01Oi_dataout <= wire_n1Oli_dataout AND NOT(nl1Oli);
	wire_n01Ol_dataout <= wire_n1Oll_dataout OR nl1Oli;
	wire_n0i0i_dataout <= wire_n0iOi_dataout WHEN nl011O = '1'  ELSE nlliOl;
	wire_n0i0l_dataout <= wire_n0iOl_dataout WHEN nl011O = '1'  ELSE nlliOO;
	wire_n0i0O_dataout <= wire_n0iOO_dataout WHEN nl011O = '1'  ELSE nlll1i;
	wire_n0i1i_dataout <= wire_n0ili_dataout OR nl0OOO;
	wire_n0i1l_dataout <= wire_n0ill_dataout WHEN nl011O = '1'  ELSE nlllO;
	wire_n0i1O_dataout <= wire_n0ilO_dataout WHEN nl011O = '1'  ELSE nllOi;
	wire_n0iii_dataout <= wire_n0l1i_dataout WHEN nl011O = '1'  ELSE nllOl;
	wire_n0iil_dataout <= wire_n0l1l_dataout WHEN nl011O = '1'  ELSE nllOO;
	wire_n0iiO_dataout <= wire_n0l1O_dataout WHEN nl011O = '1'  ELSE nlll1l;
	wire_n0ili_dataout <= wire_n0l0i_dataout WHEN nl011O = '1'  ELSE nlliOi;
	wire_n0ill_dataout <= nlllO AND NOT(nl1OOi);
	wire_n0ilO_dataout <= nllOi OR nl1OOi;
	wire_n0iOi_dataout <= nlliOl OR nl1OOi;
	wire_n0iOl_dataout <= nlliOO OR nl1OOi;
	wire_n0iOO_dataout <= nlll1i OR nl1OOi;
	wire_n0l0i_dataout <= nlliOi OR nl1OOi;
	wire_n0l1i_dataout <= nllOl OR nl1OOi;
	wire_n0l1l_dataout <= nllOO OR nl1OOi;
	wire_n0l1O_dataout <= nlll1l OR nl1OOi;
	wire_n0ll_dataout <= nl00Ol AND NOT(nl00ii);
	wire_n0lO_dataout <= wire_w_lg_nl00Ol116w(0) AND NOT(nl00ii);
	wire_n0O0i_dataout <= wire_n0OOi_dataout AND NOT(nl0OOO);
	wire_n0O0l_dataout <= wire_n0OOl_dataout AND NOT(nl0OOO);
	wire_n0O0O_dataout <= wire_n0OOO_dataout AND NOT(nl0OOO);
	wire_n0O1l_dataout <= wire_n0Oll_dataout AND NOT(nl0OOO);
	wire_n0O1O_dataout <= wire_n0OlO_dataout AND NOT(nl0OOO);
	wire_n0Oii_dataout <= wire_ni11i_dataout AND NOT(nl0OOO);
	wire_n0Oil_dataout <= wire_ni11l_dataout AND NOT(nl0OOO);
	wire_n0OiO_dataout <= wire_ni11O_dataout AND NOT(nl0OOO);
	wire_n0Oli_dataout <= wire_ni10i_dataout AND NOT(nl0OOO);
	wire_n0Oll_dataout <= wire_ni0ll_dataout WHEN nl0Oll = '1'  ELSE wire_ni10l_dataout;
	wire_n0OlO_dataout <= wire_ni0lO_dataout WHEN nl0Oll = '1'  ELSE wire_ni10O_dataout;
	wire_n0OOi_dataout <= wire_ni0Oi_dataout WHEN nl0Oll = '1'  ELSE wire_ni1ii_dataout;
	wire_n0OOl_dataout <= wire_ni0Ol_dataout WHEN nl0Oll = '1'  ELSE wire_ni1il_dataout;
	wire_n0OOO_dataout <= wire_ni0OO_dataout WHEN nl0Oll = '1'  ELSE wire_ni1iO_dataout;
	wire_n100i_dataout <= wire_n111i_dataout OR nl1Oll;
	wire_n100l_dataout <= wire_n111l_dataout OR nl1Oll;
	wire_n100O_dataout <= wire_n111O_dataout OR nl1Oll;
	wire_n101i_dataout <= wire_n10li_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n101l_dataout <= wire_n10ll_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n101O_dataout <= wire_n10lO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n10i_dataout <= dec_ctl(0) WHEN nl0Oll = '1'  ELSE wire_n00O_dataout;
	wire_n10ii_dataout <= wire_n110i_dataout AND NOT(nl1Oll);
	wire_n10il_dataout <= wire_n110l_dataout AND NOT(nl1Oll);
	wire_n10iO_dataout <= wire_n110O_dataout AND NOT(nl1Oll);
	wire_n10l_dataout <= dec_data(0) WHEN nl0Oll = '1'  ELSE wire_n1Oi_dataout;
	wire_n10li_dataout <= wire_n11ii_dataout AND NOT(nl1Oll);
	wire_n10ll_dataout <= wire_n11il_dataout AND NOT(nl1Oll);
	wire_n10lO_dataout <= wire_n11iO_dataout OR nl1Oll;
	wire_n10O_dataout <= dec_data(1) WHEN nl0Oll = '1'  ELSE wire_n1Ol_dataout;
	wire_n110i_dataout <= dec_data(19) OR wire_nl_dataout;
	wire_n110l_dataout <= dec_data(20) OR wire_nl_dataout;
	wire_n110O_dataout <= dec_data(21) OR wire_nl_dataout;
	wire_n111i_dataout <= dec_data(16) AND NOT(wire_nl_dataout);
	wire_n111l_dataout <= dec_data(17) OR wire_nl_dataout;
	wire_n111O_dataout <= dec_data(18) OR wire_nl_dataout;
	wire_n11i_dataout <= wire_n1li_dataout AND NOT(wire_n0il_o);
	wire_n11ii_dataout <= dec_data(22) OR wire_nl_dataout;
	wire_n11il_dataout <= dec_data(23) OR wire_nl_dataout;
	wire_n11iO_dataout <= dec_ctl(2) OR wire_nl_dataout;
	wire_n11l_dataout <= wire_n1ll_dataout AND NOT(wire_n0il_o);
	wire_n11li_dataout <= wire_n100i_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n11ll_dataout <= wire_n100l_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n11lO_dataout <= wire_n100O_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n11O_dataout <= wire_n1lO_dataout AND NOT(wire_n0il_o);
	wire_n11Oi_dataout <= wire_n10ii_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n11Ol_dataout <= wire_n10il_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n11OO_dataout <= wire_n10iO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1i0O_dataout <= wire_n1OlO_dataout WHEN nl1OiO = '1'  ELSE wire_n1iOO_dataout;
	wire_n1ii_dataout <= dec_data(2) WHEN nl0Oll = '1'  ELSE wire_n1OO_dataout;
	wire_n1iii_dataout <= wire_n1OOi_dataout WHEN nl1OiO = '1'  ELSE wire_n1l1i_dataout;
	wire_n1iil_dataout <= wire_n1OOl_dataout WHEN nl1OiO = '1'  ELSE wire_n1l1l_dataout;
	wire_n1iiO_dataout <= wire_n1OOO_dataout WHEN nl1OiO = '1'  ELSE wire_n1l1O_dataout;
	wire_n1il_dataout <= dec_data(3) WHEN nl0Oll = '1'  ELSE wire_n01i_dataout;
	wire_n1ili_dataout <= wire_n011i_dataout WHEN nl1OiO = '1'  ELSE wire_n1l0i_dataout;
	wire_n1ill_dataout <= wire_n011l_dataout WHEN nl1OiO = '1'  ELSE wire_n1l0l_dataout;
	wire_n1ilO_dataout <= wire_n011O_dataout WHEN nl1OiO = '1'  ELSE wire_n1l0O_dataout;
	wire_n1iO_dataout <= dec_data(4) WHEN nl0Oll = '1'  ELSE wire_n01l_dataout;
	wire_n1iOi_dataout <= wire_n010i_dataout WHEN nl1OiO = '1'  ELSE wire_n1lii_dataout;
	wire_n1iOl_dataout <= wire_n010l_dataout WHEN nl1OiO = '1'  ELSE wire_n1lil_dataout;
	wire_n1iOO_dataout <= wire_n1liO_dataout OR wire_w_lg_nl00ll108w(0);
	wire_n1l0i_dataout <= wire_n1lOi_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1l0l_dataout <= wire_n1lOl_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1l0O_dataout <= wire_n1lOO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1l1i_dataout <= wire_n1lli_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1l1l_dataout <= wire_n1lll_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1l1O_dataout <= wire_n1llO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1li_dataout <= dec_data(5) WHEN nl0Oll = '1'  ELSE wire_n01O_dataout;
	wire_n1lii_dataout <= wire_n1O1i_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1lil_dataout <= wire_n1O1l_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1liO_dataout <= wire_n1O1O_dataout OR nl00Ol;
	wire_n1ll_dataout <= dec_data(6) WHEN nl0Oll = '1'  ELSE wire_n00i_dataout;
	wire_n1lli_dataout <= wire_n1O0i_dataout OR nl00Ol;
	wire_n1lll_dataout <= wire_n1O0l_dataout OR nl00Ol;
	wire_n1llO_dataout <= wire_n1O0O_dataout AND NOT(nl00Ol);
	wire_n1lO_dataout <= dec_data(7) WHEN nl0Oll = '1'  ELSE wire_n00l_dataout;
	wire_n1lOi_dataout <= wire_n1Oii_dataout AND NOT(nl00Ol);
	wire_n1lOl_dataout <= wire_n1Oil_dataout AND NOT(nl00Ol);
	wire_n1lOO_dataout <= wire_n1OiO_dataout AND NOT(nl00Ol);
	wire_n1O0i_dataout <= dec_data(25) OR wire_nO_dataout;
	wire_n1O0l_dataout <= dec_data(26) OR wire_nO_dataout;
	wire_n1O0O_dataout <= dec_data(27) OR wire_nO_dataout;
	wire_n1O1i_dataout <= wire_n1Oli_dataout AND NOT(nl00Ol);
	wire_n1O1l_dataout <= wire_n1Oll_dataout OR nl00Ol;
	wire_n1O1O_dataout <= dec_data(24) AND NOT(wire_nO_dataout);
	wire_n1Oi_dataout <= dec_data(0) AND NOT(wire_nlO_dataout);
	wire_n1Oii_dataout <= dec_data(28) OR wire_nO_dataout;
	wire_n1Oil_dataout <= dec_data(29) OR wire_nO_dataout;
	wire_n1OiO_dataout <= dec_data(30) OR wire_nO_dataout;
	wire_n1Ol_dataout <= dec_data(1) OR wire_nlO_dataout;
	wire_n1Oli_dataout <= dec_data(31) OR wire_nO_dataout;
	wire_n1Oll_dataout <= dec_ctl(3) OR wire_nO_dataout;
	wire_n1OlO_dataout <= wire_n010O_dataout OR wire_w_lg_nl00ll108w(0);
	wire_n1OO_dataout <= dec_data(2) OR wire_nlO_dataout;
	wire_n1OOi_dataout <= wire_n01ii_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1OOl_dataout <= wire_n01il_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_n1OOO_dataout <= wire_n01iO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_ni_dataout <= running_disp(1) AND NOT(nl0OOO);
	wire_ni_w_lg_dataout12w(0) <= NOT wire_ni_dataout;
	wire_ni00i_dataout <= nlllOi OR nl010O;
	wire_ni00l_dataout <= nlllOl OR nl010O;
	wire_ni00O_dataout <= nlllOO OR nl010O;
	wire_ni01i_dataout <= nlllli OR nl010O;
	wire_ni01l_dataout <= nlllll OR nl010O;
	wire_ni01O_dataout <= nllllO OR nl010O;
	wire_ni0ii_dataout <= nlOili OR nl010O;
	wire_ni0ll_dataout <= nlllil AND NOT(nl01il);
	wire_ni0lO_dataout <= nllliO OR nl01il;
	wire_ni0Oi_dataout <= nlllli OR nl01il;
	wire_ni0Ol_dataout <= nlllll OR nl01il;
	wire_ni0OO_dataout <= nllllO OR nl01il;
	wire_ni10i_dataout <= wire_nii0i_dataout WHEN nl0Oll = '1'  ELSE wire_ni1Oi_dataout;
	wire_ni10l_dataout <= wire_ni1Ol_dataout WHEN nl01ii = '1'  ELSE nlllil;
	wire_ni10O_dataout <= wire_ni1OO_dataout WHEN nl01ii = '1'  ELSE nllliO;
	wire_ni11i_dataout <= wire_nii1i_dataout WHEN nl0Oll = '1'  ELSE wire_ni1li_dataout;
	wire_ni11l_dataout <= wire_nii1l_dataout WHEN nl0Oll = '1'  ELSE wire_ni1ll_dataout;
	wire_ni11O_dataout <= wire_nii1O_dataout WHEN nl0Oll = '1'  ELSE wire_ni1lO_dataout;
	wire_ni1ii_dataout <= wire_ni01i_dataout WHEN nl01ii = '1'  ELSE nlllli;
	wire_ni1il_dataout <= wire_ni01l_dataout WHEN nl01ii = '1'  ELSE nlllll;
	wire_ni1iO_dataout <= wire_ni01O_dataout WHEN nl01ii = '1'  ELSE nllllO;
	wire_ni1li_dataout <= wire_ni00i_dataout WHEN nl01ii = '1'  ELSE nlllOi;
	wire_ni1ll_dataout <= wire_ni00l_dataout WHEN nl01ii = '1'  ELSE nlllOl;
	wire_ni1lO_dataout <= wire_ni00O_dataout WHEN nl01ii = '1'  ELSE nlllOO;
	wire_ni1Oi_dataout <= wire_ni0ii_dataout WHEN nl01ii = '1'  ELSE nlOili;
	wire_ni1Ol_dataout <= nlllil AND NOT(nl010O);
	wire_ni1OO_dataout <= nllliO OR nl010O;
	wire_nii0i_dataout <= nlOili OR nl01il;
	wire_nii1i_dataout <= nlllOi OR nl01il;
	wire_nii1l_dataout <= nlllOl OR nl01il;
	wire_nii1O_dataout <= nlllOO OR nl01il;
	wire_niii_dataout <= wire_niil_dataout OR ni0l;
	wire_niil_dataout <= nili AND NOT((wire_w_lg_w_lg_nl00ll108w109w(0) OR wire_nl00il35_w_lg_Q112w(0)));
	wire_niiOO_dataout <= wire_niliO_dataout AND NOT(nl0OOO);
	wire_nil0i_dataout <= wire_nilOi_dataout AND NOT(nl0OOO);
	wire_nil0l_dataout <= wire_nilOl_dataout AND NOT(nl0OOO);
	wire_nil0O_dataout <= wire_nilOO_dataout AND NOT(nl0OOO);
	wire_nil1i_dataout <= wire_nilli_dataout AND NOT(nl0OOO);
	wire_nil1l_dataout <= wire_nilll_dataout AND NOT(nl0OOO);
	wire_nil1O_dataout <= wire_nillO_dataout AND NOT(nl0OOO);
	wire_nilii_dataout <= wire_niO1i_dataout AND NOT(nl0OOO);
	wire_nilil_dataout <= wire_niO1l_dataout AND NOT(nl0OOO);
	wire_niliO_dataout <= wire_nl1il_dataout WHEN nl000i = '1'  ELSE wire_niO1O_dataout;
	wire_nilli_dataout <= wire_nl1iO_dataout WHEN nl000i = '1'  ELSE wire_niO0i_dataout;
	wire_nilll_dataout <= wire_nl1li_dataout WHEN nl000i = '1'  ELSE wire_niO0l_dataout;
	wire_nillO_dataout <= wire_nl1ll_dataout WHEN nl000i = '1'  ELSE wire_niO0O_dataout;
	wire_nilOi_dataout <= wire_nl1lO_dataout WHEN nl000i = '1'  ELSE wire_niOii_dataout;
	wire_nilOl_dataout <= wire_nl1Oi_dataout WHEN nl000i = '1'  ELSE wire_niOil_dataout;
	wire_nilOO_dataout <= wire_nl1Ol_dataout WHEN nl000i = '1'  ELSE wire_niOiO_dataout;
	wire_niO0i_dataout <= wire_niOOi_dataout WHEN nlllii = '1'  ELSE nlOilO;
	wire_niO0l_dataout <= wire_niOOl_dataout WHEN nlllii = '1'  ELSE nlOiOi;
	wire_niO0O_dataout <= wire_niOOO_dataout WHEN nlllii = '1'  ELSE nlOiOl;
	wire_niO1i_dataout <= wire_nl1OO_dataout WHEN nl000i = '1'  ELSE wire_niOli_dataout;
	wire_niO1l_dataout <= wire_nl01i_dataout WHEN nl000i = '1'  ELSE wire_niOll_dataout;
	wire_niO1O_dataout <= wire_niOlO_dataout WHEN nlllii = '1'  ELSE nlOill;
	wire_niOii_dataout <= wire_nl11i_dataout WHEN nlllii = '1'  ELSE nlOiOO;
	wire_niOil_dataout <= wire_nl11l_dataout WHEN nlllii = '1'  ELSE nlOl1i;
	wire_niOiO_dataout <= wire_nl11O_dataout WHEN nlllii = '1'  ELSE nlOl1l;
	wire_niOl_dataout <= wire_niOO_dataout AND NOT(nill);
	wire_niOli_dataout <= wire_nl10i_dataout WHEN nlllii = '1'  ELSE nlOl1O;
	wire_niOll_dataout <= wire_nl10l_dataout WHEN nlllii = '1'  ELSE n10Oi;
	wire_niOlO_dataout <= nlOill AND NOT(nl01iO);
	wire_niOO_dataout <= nlll0i OR NOT(nl00ll);
	wire_niOOi_dataout <= nlOilO OR nl01iO;
	wire_niOOl_dataout <= nlOiOi OR nl01iO;
	wire_niOOO_dataout <= nlOiOl OR nl01iO;
	wire_nl_dataout <= running_disp(2) AND NOT(nl0OOO);
	wire_nl_w_lg_dataout19w(0) <= NOT wire_nl_dataout;
	wire_nl_w_lg_dataout167w(0) <= wire_nl_dataout OR wire_w_lg_w_lg_nl0ill163w166w(0);
	wire_nl01i_dataout <= n10Oi OR nl01Ol;
	wire_nl0ll_dataout <= wire_nli0l_dataout OR nl0OOO;
	wire_nl0lO_dataout <= wire_nli0O_dataout AND NOT(nl0OOO);
	wire_nl0Oi_dataout <= wire_nliii_dataout AND NOT(nl0OOO);
	wire_nl0Ol_dataout <= wire_nliil_dataout AND NOT(nl0OOO);
	wire_nl0OO_dataout <= wire_nliiO_dataout AND NOT(nl0OOO);
	wire_nl10i_dataout <= nlOl1O OR nl01iO;
	wire_nl10l_dataout <= n10Oi OR nl01iO;
	wire_nl11i_dataout <= nlOiOO OR nl01iO;
	wire_nl11l_dataout <= nlOl1i OR nl01iO;
	wire_nl11O_dataout <= nlOl1l OR nl01iO;
	wire_nl1il_dataout <= nlOill AND NOT(nl01Ol);
	wire_nl1iO_dataout <= nlOilO OR nl01Ol;
	wire_nl1li_dataout <= nlOiOi OR nl01Ol;
	wire_nl1ll_dataout <= nlOiOl OR nl01Ol;
	wire_nl1lO_dataout <= nlOiOO OR nl01Ol;
	wire_nl1Oi_dataout <= nlOl1i OR nl01Ol;
	wire_nl1Ol_dataout <= nlOl1l OR nl01Ol;
	wire_nl1OO_dataout <= nlOl1O OR nl01Ol;
	wire_nli0i_dataout <= wire_nliOi_dataout AND NOT(nl0OOO);
	wire_nli0l_dataout <= wire_nliOl_dataout WHEN nl001i = '1'  ELSE nlli0O;
	wire_nli0O_dataout <= wire_nliOO_dataout WHEN nl001i = '1'  ELSE n10Ol;
	wire_nli1i_dataout <= wire_nlili_dataout AND NOT(nl0OOO);
	wire_nli1l_dataout <= wire_nlill_dataout AND NOT(nl0OOO);
	wire_nli1O_dataout <= wire_nlilO_dataout AND NOT(nl0OOO);
	wire_nliii_dataout <= wire_nll1i_dataout WHEN nl001i = '1'  ELSE n10OO;
	wire_nliil_dataout <= wire_nll1l_dataout WHEN nl001i = '1'  ELSE n1i1i;
	wire_nliiO_dataout <= wire_nll1O_dataout WHEN nl001i = '1'  ELSE n1i1l;
	wire_nlili_dataout <= wire_nll0i_dataout WHEN nl001i = '1'  ELSE n1i1O;
	wire_nlill_dataout <= wire_nll0l_dataout WHEN nl001i = '1'  ELSE n1i0i;
	wire_nlilO_dataout <= wire_nll0O_dataout WHEN nl001i = '1'  ELSE n1i0l;
	wire_nliOi_dataout <= wire_nllii_dataout WHEN nl001i = '1'  ELSE n001O;
	wire_nliOl_dataout <= nlli0O AND NOT(nl01OO);
	wire_nliOO_dataout <= n10Ol OR nl01OO;
	wire_nll0i_dataout <= n1i1O OR nl01OO;
	wire_nll0l_dataout <= n1i0i OR nl01OO;
	wire_nll0O_dataout <= n1i0l OR nl01OO;
	wire_nll1i_dataout <= n10OO OR nl01OO;
	wire_nll1l_dataout <= n1i1i OR nl01OO;
	wire_nll1O_dataout <= n1i1l OR nl01OO;
	wire_nllii_dataout <= n001O OR nl01OO;
	wire_nllO0i_dataout <= wire_nlO0li_dataout WHEN nl1OiO = '1'  ELSE wire_nllOOi_dataout;
	wire_nllO0l_dataout <= wire_nlO0ll_dataout WHEN nl1OiO = '1'  ELSE wire_nllOOl_dataout;
	wire_nllO0O_dataout <= wire_nlO0lO_dataout WHEN nl1OiO = '1'  ELSE wire_nllOOO_dataout;
	wire_nllO1i_dataout <= wire_nlO0ii_dataout WHEN nl1OiO = '1'  ELSE wire_nllOli_dataout;
	wire_nllO1l_dataout <= wire_nlO0il_dataout WHEN nl1OiO = '1'  ELSE wire_nllOll_dataout;
	wire_nllO1O_dataout <= wire_nlO0iO_dataout WHEN nl1OiO = '1'  ELSE wire_nllOlO_dataout;
	wire_nllOii_dataout <= wire_nlO0Oi_dataout WHEN nl1OiO = '1'  ELSE wire_nlO11i_dataout;
	wire_nllOil_dataout <= wire_nlO0Ol_dataout WHEN nl1OiO = '1'  ELSE wire_nlO11l_dataout;
	wire_nllOiO_dataout <= wire_nlO0OO_dataout WHEN nl1OiO = '1'  ELSE wire_nlO11O_dataout;
	wire_nllOli_dataout <= wire_nlO10i_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nllOll_dataout <= wire_nlO10l_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nllOlO_dataout <= wire_nlO10O_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nllOOi_dataout <= wire_nlO1ii_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nllOOl_dataout <= wire_nlO1il_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nllOOO_dataout <= wire_nlO1iO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO_dataout <= running_disp(0) AND NOT(nl0OOO);
	wire_nlO_w_lg_dataout5w(0) <= NOT wire_nlO_dataout;
	wire_nlO_w_lg_dataout186w(0) <= wire_nlO_dataout OR wire_w_lg_w_lg_nl0l1l182w185w(0);
	wire_nlO00i_dataout <= dec_data(14) OR wire_ni_dataout;
	wire_nlO00l_dataout <= dec_data(15) OR wire_ni_dataout;
	wire_nlO00O_dataout <= dec_ctl(1) OR wire_ni_dataout;
	wire_nlO01i_dataout <= dec_data(11) OR wire_ni_dataout;
	wire_nlO01l_dataout <= dec_data(12) OR wire_ni_dataout;
	wire_nlO01O_dataout <= dec_data(13) OR wire_ni_dataout;
	wire_nlO0i_dataout <= wire_nlOOi_dataout OR wire_n0ii_o;
	wire_nlO0ii_dataout <= wire_nlOi1i_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO0il_dataout <= wire_nlOi1l_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO0iO_dataout <= wire_nlOi1O_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO0l_dataout <= wire_nlOOl_dataout OR wire_n0ii_o;
	wire_nlO0li_dataout <= wire_nlOi0i_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO0ll_dataout <= wire_nlOi0l_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO0lO_dataout <= wire_nlOi0O_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO0O_dataout <= wire_nlOOO_dataout OR wire_n0ii_o;
	wire_nlO0Oi_dataout <= wire_nlOiii_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO0Ol_dataout <= wire_nlOiil_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO0OO_dataout <= wire_nlOiiO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO10i_dataout <= wire_nlO1Oi_dataout OR nl00Ol;
	wire_nlO10l_dataout <= wire_nlO1Ol_dataout OR nl00Ol;
	wire_nlO10O_dataout <= wire_nlO1OO_dataout OR nl00Ol;
	wire_nlO11i_dataout <= wire_nlO1li_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO11l_dataout <= wire_nlO1ll_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO11O_dataout <= wire_nlO1lO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlO1i_dataout <= wire_nlOli_dataout OR wire_n0ii_o;
	wire_nlO1ii_dataout <= wire_nlO01i_dataout AND NOT(nl00Ol);
	wire_nlO1il_dataout <= wire_nlO01l_dataout AND NOT(nl00Ol);
	wire_nlO1iO_dataout <= wire_nlO01O_dataout AND NOT(nl00Ol);
	wire_nlO1l_dataout <= wire_nlOll_dataout AND NOT(wire_n0ii_o);
	wire_nlO1li_dataout <= wire_nlO00i_dataout AND NOT(nl00Ol);
	wire_nlO1ll_dataout <= wire_nlO00l_dataout AND NOT(nl00Ol);
	wire_nlO1lO_dataout <= wire_nlO00O_dataout OR nl00Ol;
	wire_nlO1O_dataout <= wire_nlOlO_dataout AND NOT(wire_n0ii_o);
	wire_nlO1Oi_dataout <= dec_data(8) AND NOT(wire_ni_dataout);
	wire_nlO1Ol_dataout <= dec_data(9) OR wire_ni_dataout;
	wire_nlO1OO_dataout <= dec_data(10) OR wire_ni_dataout;
	wire_nlOi0i_dataout <= wire_nlO01i_dataout AND NOT(nl1OlO);
	wire_nlOi0l_dataout <= wire_nlO01l_dataout AND NOT(nl1OlO);
	wire_nlOi0O_dataout <= wire_nlO01O_dataout AND NOT(nl1OlO);
	wire_nlOi1i_dataout <= wire_nlO1Oi_dataout OR nl1OlO;
	wire_nlOi1l_dataout <= wire_nlO1Ol_dataout OR nl1OlO;
	wire_nlOi1O_dataout <= wire_nlO1OO_dataout OR nl1OlO;
	wire_nlOii_dataout <= wire_n11i_dataout AND NOT(wire_n0ii_o);
	wire_nlOiii_dataout <= wire_nlO00i_dataout AND NOT(nl1OlO);
	wire_nlOiil_dataout <= wire_nlO00l_dataout AND NOT(nl1OlO);
	wire_nlOiiO_dataout <= wire_nlO00O_dataout OR nl1OlO;
	wire_nlOil_dataout <= wire_n11l_dataout AND NOT(wire_n0ii_o);
	wire_nlOiO_dataout <= wire_n11O_dataout OR wire_n0ii_o;
	wire_nlOl0i_dataout <= wire_n11li_dataout WHEN nl1OiO = '1'  ELSE wire_nlOlOi_dataout;
	wire_nlOl0l_dataout <= wire_n11ll_dataout WHEN nl1OiO = '1'  ELSE wire_nlOlOl_dataout;
	wire_nlOl0O_dataout <= wire_n11lO_dataout WHEN nl1OiO = '1'  ELSE wire_nlOlOO_dataout;
	wire_nlOli_dataout <= wire_n10i_dataout OR wire_n0il_o;
	wire_nlOlii_dataout <= wire_n11Oi_dataout WHEN nl1OiO = '1'  ELSE wire_nlOO1i_dataout;
	wire_nlOlil_dataout <= wire_n11Ol_dataout WHEN nl1OiO = '1'  ELSE wire_nlOO1l_dataout;
	wire_nlOliO_dataout <= wire_n11OO_dataout WHEN nl1OiO = '1'  ELSE wire_nlOO1O_dataout;
	wire_nlOll_dataout <= wire_n10l_dataout OR wire_n0il_o;
	wire_nlOlli_dataout <= wire_n101i_dataout WHEN nl1OiO = '1'  ELSE wire_nlOO0i_dataout;
	wire_nlOlll_dataout <= wire_n101l_dataout WHEN nl1OiO = '1'  ELSE wire_nlOO0l_dataout;
	wire_nlOllO_dataout <= wire_n101O_dataout WHEN nl1OiO = '1'  ELSE wire_nlOO0O_dataout;
	wire_nlOlO_dataout <= wire_n10O_dataout OR wire_n0il_o;
	wire_nlOlOi_dataout <= wire_nlOOii_dataout OR wire_w_lg_nl00ll108w(0);
	wire_nlOlOl_dataout <= wire_nlOOil_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlOlOO_dataout <= wire_nlOOiO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlOO0i_dataout <= wire_nlOOOi_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlOO0l_dataout <= wire_nlOOOl_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlOO0O_dataout <= wire_nlOOOO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlOO1i_dataout <= wire_nlOOli_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlOO1l_dataout <= wire_nlOOll_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlOO1O_dataout <= wire_nlOOlO_dataout AND NOT(wire_w_lg_nl00ll108w(0));
	wire_nlOOi_dataout <= wire_n1ii_dataout OR wire_n0il_o;
	wire_nlOOii_dataout <= wire_n111i_dataout OR nl00Ol;
	wire_nlOOil_dataout <= wire_n111l_dataout OR nl00Ol;
	wire_nlOOiO_dataout <= wire_n111O_dataout OR nl00Ol;
	wire_nlOOl_dataout <= wire_n1il_dataout AND NOT(wire_n0il_o);
	wire_nlOOli_dataout <= wire_n110i_dataout AND NOT(nl00Ol);
	wire_nlOOll_dataout <= wire_n110l_dataout AND NOT(nl00Ol);
	wire_nlOOlO_dataout <= wire_n110O_dataout AND NOT(nl00Ol);
	wire_nlOOO_dataout <= wire_n1iO_dataout AND NOT(wire_n0il_o);
	wire_nlOOOi_dataout <= wire_n11ii_dataout AND NOT(nl00Ol);
	wire_nlOOOl_dataout <= wire_n11il_dataout AND NOT(nl00Ol);
	wire_nlOOOO_dataout <= wire_n11iO_dataout OR nl00Ol;
	wire_nO_dataout <= running_disp(3) AND NOT(nl0OOO);
	wire_nO_w_lg_dataout218w(0) <= NOT wire_nO_dataout;
	wire_n0li_w_lg_w_o_range122w124w(0) <= NOT wire_n0li_w_o_range122w(0);
	wire_n0li_i <= ( ni1l & wire_nl000O38_w_lg_Q119w);
	wire_n0li_w_o_range122w(0) <= wire_n0li_o(2);
	n0li :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n0li_i,
		o => wire_n0li_o
	  );
	wire_n0ii_w_lg_o114w(0) <= NOT wire_n0ii_o;
	wire_n0ii_data <= ( "1" & nl00ii);
	wire_n0ii_sel <= ( wire_n0li_o(2) & wire_n0li_w_lg_w_o_range122w124w);
	n0ii :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n0ii_data,
		o => wire_n0ii_o,
		sel => wire_n0ii_sel
	  );
	wire_n0il_data <= ( "0" & wire_nl000l41_w_lg_Q136w);
	wire_n0il_sel <= ( wire_n0li_o(2) & wire_n0li_w_lg_w_o_range122w124w);
	n0il :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n0il_data,
		o => wire_n0il_o,
		sel => wire_n0il_sel
	  );
	wire_n0iO_data <= ( "0" & wire_n0lO_dataout);
	wire_n0iO_sel <= ( wire_n0li_o(2) & wire_n0li_w_lg_w_o_range122w124w);
	n0iO :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n0iO_data,
		o => wire_n0iO_o,
		sel => wire_n0iO_sel
	  );

 END RTL; --rcv_sm
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 35 mux21 32 oper_add 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  mdio_addr IS 
	 PORT 
	 ( 
		 incr_addr	:	IN  STD_LOGIC;
		 mdc	:	IN  STD_LOGIC;
		 mdio_in	:	IN  STD_LOGIC;
		 reg_addr	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 reset	:	IN  STD_LOGIC;
		 shift_addr	:	IN  STD_LOGIC
	 ); 
 END mdio_addr;

 ARCHITECTURE RTL OF mdio_addr IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 nlO0l16	:	STD_LOGIC := '1';
	 SIGNAL	 nlO0l17	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlO0l17_w_lg_Q48w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlO0l18	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0O13	:	STD_LOGIC := '1';
	 SIGNAL	 nlO0O14	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlO0O14_w_lg_Q40w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlO0O15	:	STD_LOGIC := '0';
	 SIGNAL	 nlOii10	:	STD_LOGIC := '1';
	 SIGNAL	 nlOii11	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlOii11_w_lg_Q36w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOii12	:	STD_LOGIC := '0';
	 SIGNAL	 nlOil7	:	STD_LOGIC := '1';
	 SIGNAL	 nlOil8	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlOil8_w_lg_Q33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOil9	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiO4	:	STD_LOGIC := '1';
	 SIGNAL	 nlOiO5	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlOiO5_w_lg_Q28w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOiO6	:	STD_LOGIC := '0';
	 SIGNAL	 nlOlO1	:	STD_LOGIC := '1';
	 SIGNAL	 nlOlO2	:	STD_LOGIC := '1';
	 SIGNAL	 nlOlO3	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0l	:	STD_LOGIC := '0';
	 SIGNAL	ni0O	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1O	:	STD_LOGIC := '0';
	 SIGNAL	niii	:	STD_LOGIC := '0';
	 SIGNAL	niil	:	STD_LOGIC := '0';
	 SIGNAL	nO	:	STD_LOGIC := '0';
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nll_a	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nll_b	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_nll_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOll20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nlOli :	STD_LOGIC;
	 SIGNAL  nlOll :	STD_LOGIC;
	 SIGNAL  nlOOO :	STD_LOGIC;
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_nlOll20w(0) <= NOT nlOll;
	wire_w_lg_reset1w(0) <= NOT reset;
	nlOli <= (wire_w_lg_nlOll20w(0) AND incr_addr);
	nlOll <= ((((((((((((((((n0iO AND n0li) AND n0ll) AND n0lO) AND n0Oi) AND n0Ol) AND n0OO) AND ni1i) AND ni1l) AND ni1O) AND ni0i) AND ni0l) AND ni0O) AND niii) AND niil) AND nO) AND nlOlO2);
	nlOOO <= '1';
	reg_addr <= ( nO & niil & niii & ni0O & ni0l & ni0i & ni1O & ni1l & ni1i & n0OO & n0Ol & n0Oi & n0lO & n0ll & n0li & n0iO);
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0l16 <= nlO0l18;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0l17 <= (nlO0l18 XOR nlO0l16);
		END IF;
	END PROCESS;
	wire_nlO0l17_w_lg_Q48w(0) <= nlO0l17 AND nO;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0l18 <= nlO0l16;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0O13 <= nlO0O15;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0O14 <= (nlO0O15 XOR nlO0O13);
		END IF;
	END PROCESS;
	wire_nlO0O14_w_lg_Q40w(0) <= nlO0O14 AND ni1O;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlO0O15 <= nlO0O13;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOii10 <= nlOii12;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOii11 <= (nlOii12 XOR nlOii10);
		END IF;
	END PROCESS;
	wire_nlOii11_w_lg_Q36w(0) <= nlOii11 AND ni1i;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOii12 <= nlOii10;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOil7 <= nlOil9;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOil8 <= (nlOil9 XOR nlOil7);
		END IF;
	END PROCESS;
	wire_nlOil8_w_lg_Q33w(0) <= nlOil8 AND n0OO;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOil9 <= nlOil7;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOiO4 <= nlOiO6;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOiO5 <= (nlOiO6 XOR nlOiO4);
		END IF;
	END PROCESS;
	wire_nlOiO5_w_lg_Q28w(0) <= nlOiO5 AND n0lO;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOiO6 <= nlOiO4;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOlO1 <= nlOlO3;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOlO2 <= (nlOlO3 XOR nlOlO1);
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nlOlO3 <= nlOlO1;
		END IF;
	END PROCESS;
	PROCESS (mdc, reset)
	BEGIN
		IF (reset = '1') THEN
				n0il <= '0';
				n0iO <= '0';
				n0li <= '0';
				n0ll <= '0';
				n0lO <= '0';
				n0Oi <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				ni0i <= '0';
				ni0l <= '0';
				ni0O <= '0';
				ni1i <= '0';
				ni1l <= '0';
				ni1O <= '0';
				niii <= '0';
				niil <= '0';
				nO <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
				n0il <= mdio_in;
				n0iO <= wire_niiO_dataout;
				n0li <= wire_nili_dataout;
				n0ll <= wire_nill_dataout;
				n0lO <= wire_nilO_dataout;
				n0Oi <= wire_niOi_dataout;
				n0Ol <= wire_niOl_dataout;
				n0OO <= wire_niOO_dataout;
				ni0i <= wire_nl0i_dataout;
				ni0l <= wire_nl0l_dataout;
				ni0O <= wire_nl0O_dataout;
				ni1i <= wire_nl1i_dataout;
				ni1l <= wire_nl1l_dataout;
				ni1O <= wire_nl1O_dataout;
				niii <= wire_nlii_dataout;
				niil <= wire_nlil_dataout;
				nO <= wire_nliO_dataout;
		END IF;
	END PROCESS;
	wire_n0i_dataout <= wire_nll_o(9) WHEN nlOli = '1'  ELSE ni1O;
	wire_n0l_dataout <= wire_nll_o(10) WHEN nlOli = '1'  ELSE ni0i;
	wire_n0O_dataout <= wire_nll_o(11) WHEN nlOli = '1'  ELSE ni0l;
	wire_n1i_dataout <= wire_nll_o(6) WHEN nlOli = '1'  ELSE n0OO;
	wire_n1l_dataout <= wire_nll_o(7) WHEN nlOli = '1'  ELSE ni1i;
	wire_n1O_dataout <= wire_nll_o(8) WHEN nlOli = '1'  ELSE ni1l;
	wire_nii_dataout <= wire_nll_o(12) WHEN nlOli = '1'  ELSE ni0O;
	wire_niiO_dataout <= n0il WHEN shift_addr = '1'  ELSE wire_nlli_dataout;
	wire_nil_dataout <= wire_nll_o(13) WHEN nlOli = '1'  ELSE niii;
	wire_nili_dataout <= n0iO WHEN shift_addr = '1'  ELSE wire_nlll_dataout;
	wire_nill_dataout <= n0li WHEN shift_addr = '1'  ELSE wire_nllO_dataout;
	wire_nilO_dataout <= n0ll WHEN shift_addr = '1'  ELSE wire_nlOi_dataout;
	wire_niO_dataout <= wire_nll_o(14) WHEN nlOli = '1'  ELSE niil;
	wire_niOi_dataout <= n0lO WHEN shift_addr = '1'  ELSE wire_nlOl_dataout;
	wire_niOl_dataout <= n0Oi WHEN shift_addr = '1'  ELSE wire_nlOO_dataout;
	wire_niOO_dataout <= n0Ol WHEN shift_addr = '1'  ELSE wire_n1i_dataout;
	wire_nl0i_dataout <= ni1O WHEN shift_addr = '1'  ELSE wire_n0l_dataout;
	wire_nl0l_dataout <= ni0i WHEN shift_addr = '1'  ELSE wire_n0O_dataout;
	wire_nl0O_dataout <= ni0l WHEN shift_addr = '1'  ELSE wire_nii_dataout;
	wire_nl1i_dataout <= n0OO WHEN shift_addr = '1'  ELSE wire_n1l_dataout;
	wire_nl1l_dataout <= ni1i WHEN shift_addr = '1'  ELSE wire_n1O_dataout;
	wire_nl1O_dataout <= ni1l WHEN shift_addr = '1'  ELSE wire_n0i_dataout;
	wire_nli_dataout <= wire_nll_o(15) WHEN nlOli = '1'  ELSE nO;
	wire_nlii_dataout <= ni0O WHEN shift_addr = '1'  ELSE wire_nil_dataout;
	wire_nlil_dataout <= niii WHEN shift_addr = '1'  ELSE wire_niO_dataout;
	wire_nliO_dataout <= niil WHEN shift_addr = '1'  ELSE wire_nli_dataout;
	wire_nlli_dataout <= wire_nll_o(0) WHEN nlOli = '1'  ELSE n0iO;
	wire_nlll_dataout <= wire_nll_o(1) WHEN nlOli = '1'  ELSE n0li;
	wire_nllO_dataout <= wire_nll_o(2) WHEN nlOli = '1'  ELSE n0ll;
	wire_nlOi_dataout <= wire_nll_o(3) WHEN nlOli = '1'  ELSE n0lO;
	wire_nlOl_dataout <= wire_nll_o(4) WHEN nlOli = '1'  ELSE n0Oi;
	wire_nlOO_dataout <= wire_nll_o(5) WHEN nlOli = '1'  ELSE n0Ol;
	wire_nll_a <= ( wire_nlO0l17_w_lg_Q48w & niil & niii & ni0O & ni0l & ni0i & wire_nlO0O14_w_lg_Q40w & ni1l & wire_nlOii11_w_lg_Q36w & wire_nlOil8_w_lg_Q33w & n0Ol & n0Oi & wire_nlOiO5_w_lg_Q28w & n0ll & n0li & n0iO);
	wire_nll_b <= ( "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "0" & "1");
	nll :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 16,
		width_b => 16,
		width_o => 16
	  )
	  PORT MAP ( 
		a => wire_nll_a,
		b => wire_nll_b,
		cin => wire_gnd,
		o => wire_nll_o
	  );

 END RTL; --mdio_addr
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 14 mux21 10 oper_add 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  mdio_cnt IS 
	 PORT 
	 ( 
		 cnt_eq_0	:	OUT  STD_LOGIC;
		 cnt_val	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 ld_cnt	:	IN  STD_LOGIC;
		 mdc	:	IN  STD_LOGIC;
		 reset	:	IN  STD_LOGIC
	 ); 
 END mdio_cnt;

 ARCHITECTURE RTL OF mdio_cnt IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 niii7	:	STD_LOGIC := '1';
	 SIGNAL	 niii8	:	STD_LOGIC := '1';
	 SIGNAL	 niii9	:	STD_LOGIC := '0';
	 SIGNAL	 nill4	:	STD_LOGIC := '1';
	 SIGNAL	 nill5	:	STD_LOGIC := '1';
	 SIGNAL  wire_nill5_w_lg_Q18w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nill6	:	STD_LOGIC := '0';
	 SIGNAL	 niOi1	:	STD_LOGIC := '1';
	 SIGNAL	 niOi2	:	STD_LOGIC := '1';
	 SIGNAL  wire_niOi2_w_lg_Q7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niOi3	:	STD_LOGIC := '0';
	 SIGNAL	n1i	:	STD_LOGIC := '0';
	 SIGNAL	n1O	:	STD_LOGIC := '0';
	 SIGNAL	nlll	:	STD_LOGIC := '0';
	 SIGNAL	nlOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOO	:	STD_LOGIC := '0';
	 SIGNAL  wire_n1l_w_lg_w_lg_w_lg_w_lg_n1O1w2w3w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l_w_lg_w_lg_w_lg_n1O1w2w3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l_w_lg_w_lg_n1O1w2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1l_w_lg_n1O1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nl_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_nl_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_w_lg_ld_cnt43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_niiO44w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset42w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  niiO :	STD_LOGIC;
	 SIGNAL  nili :	STD_LOGIC;
	 SIGNAL  nilO :	STD_LOGIC;
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_ld_cnt43w(0) <= NOT ld_cnt;
	wire_w_lg_niiO44w(0) <= NOT niiO;
	wire_w_lg_reset42w(0) <= NOT reset;
	cnt_eq_0 <= ((wire_w_lg_ld_cnt43w(0) AND wire_w_lg_niiO44w(0)) AND niii8);
	niiO <= wire_n1l_w_lg_w_lg_w_lg_w_lg_n1O1w2w3w4w(0);
	nili <= '1';
	nilO <= (wire_n1l_w_lg_w_lg_w_lg_w_lg_n1O1w2w3w4w(0) OR wire_niOi2_w_lg_Q7w(0));
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niii7 <= niii9;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niii8 <= (niii9 XOR niii7);
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niii9 <= niii7;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nill4 <= nill6;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nill5 <= (nill6 XOR nill4);
		END IF;
	END PROCESS;
	wire_nill5_w_lg_Q18w(0) <= nill5 AND nlll;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nill6 <= nill4;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOi1 <= niOi3;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOi2 <= (niOi3 XOR niOi1);
		END IF;
	END PROCESS;
	wire_niOi2_w_lg_Q7w(0) <= NOT niOi2;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOi3 <= niOi1;
		END IF;
	END PROCESS;
	PROCESS (mdc, reset)
	BEGIN
		IF (reset = '1') THEN
				n1i <= '0';
				n1O <= '0';
				nlll <= '0';
				nlOl <= '0';
				nlOO <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
				n1i <= wire_n0O_dataout;
				n1O <= wire_nii_dataout;
				nlll <= wire_nil_dataout;
				nlOl <= wire_n0i_dataout;
				nlOO <= wire_n0l_dataout;
		END IF;
	END PROCESS;
	wire_n1l_w_lg_w_lg_w_lg_w_lg_n1O1w2w3w4w(0) <= wire_n1l_w_lg_w_lg_w_lg_n1O1w2w3w(0) OR nlll;
	wire_n1l_w_lg_w_lg_w_lg_n1O1w2w3w(0) <= wire_n1l_w_lg_w_lg_n1O1w2w(0) OR nlOl;
	wire_n1l_w_lg_w_lg_n1O1w2w(0) <= wire_n1l_w_lg_n1O1w(0) OR nlOO;
	wire_n1l_w_lg_n1O1w(0) <= n1O OR n1i;
	wire_n0i_dataout <= cnt_val(0) WHEN ld_cnt = '1'  ELSE wire_niO_dataout;
	wire_n0l_dataout <= cnt_val(1) WHEN ld_cnt = '1'  ELSE wire_nli_dataout;
	wire_n0O_dataout <= cnt_val(2) WHEN ld_cnt = '1'  ELSE wire_nll_dataout;
	wire_ni_dataout <= wire_nl_o(5) WHEN nilO = '1'  ELSE nlll;
	wire_nii_dataout <= cnt_val(3) WHEN ld_cnt = '1'  ELSE wire_nlO_dataout;
	wire_nil_dataout <= cnt_val(4) WHEN ld_cnt = '1'  ELSE wire_ni_dataout;
	wire_niO_dataout <= wire_nl_o(1) WHEN nilO = '1'  ELSE nlOl;
	wire_nli_dataout <= wire_nl_o(2) WHEN nilO = '1'  ELSE nlOO;
	wire_nll_dataout <= wire_nl_o(3) WHEN nilO = '1'  ELSE n1i;
	wire_nlO_dataout <= wire_nl_o(4) WHEN nilO = '1'  ELSE n1O;
	wire_nl_a <= ( wire_nill5_w_lg_Q18w & n1O & n1i & nlOO & nlOl & "1");
	wire_nl_b <= ( "1" & "1" & "1" & "1" & "0" & "1");
	nl :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 6,
		width_b => 6,
		width_o => 6
	  )
	  PORT MAP ( 
		a => wire_nl_a,
		b => wire_nl_b,
		cin => wire_gnd,
		o => wire_nl_o
	  );

 END RTL; --mdio_cnt
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

--synthesis_resources = lut 54 mux21 36 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  mdio_ctl_data IS 
	 PORT 
	 ( 
		 data_enable_n	:	OUT  STD_LOGIC;
		 dev_addr	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 latch_ctl	:	IN  STD_LOGIC;
		 ld_data	:	IN  STD_LOGIC;
		 mbus_in	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mbus_out	:	IN  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mdc	:	IN  STD_LOGIC;
		 mdio_in	:	IN  STD_LOGIC;
		 mdio_out	:	OUT  STD_LOGIC;
		 opcode	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 port_addr	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 reset	:	IN  STD_LOGIC;
		 shift_in	:	IN  STD_LOGIC;
		 shift_out	:	IN  STD_LOGIC;
		 valid_addr	:	OUT  STD_LOGIC;
		 valid_addr_lt	:	IN  STD_LOGIC
	 ); 
 END mdio_ctl_data;

 ARCHITECTURE RTL OF mdio_ctl_data IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 nilOi31	:	STD_LOGIC := '1';
	 SIGNAL	 nilOi32	:	STD_LOGIC := '1';
	 SIGNAL	 nilOi33	:	STD_LOGIC := '0';
	 SIGNAL	 nilOO28	:	STD_LOGIC := '1';
	 SIGNAL	 nilOO29	:	STD_LOGIC := '1';
	 SIGNAL  wire_nilOO29_w_lg_Q111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nilOO30	:	STD_LOGIC := '0';
	 SIGNAL	 niO0i22	:	STD_LOGIC := '1';
	 SIGNAL	 niO0i23	:	STD_LOGIC := '1';
	 SIGNAL  wire_niO0i23_w_lg_Q92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niO0i24	:	STD_LOGIC := '0';
	 SIGNAL	 niO0O19	:	STD_LOGIC := '1';
	 SIGNAL	 niO0O20	:	STD_LOGIC := '1';
	 SIGNAL	 niO0O21	:	STD_LOGIC := '0';
	 SIGNAL	 niO1l25	:	STD_LOGIC := '1';
	 SIGNAL	 niO1l26	:	STD_LOGIC := '1';
	 SIGNAL  wire_niO1l26_w_lg_Q104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niO1l27	:	STD_LOGIC := '0';
	 SIGNAL	 niOil16	:	STD_LOGIC := '1';
	 SIGNAL	 niOil17	:	STD_LOGIC := '1';
	 SIGNAL  wire_niOil17_w_lg_Q49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niOil18	:	STD_LOGIC := '0';
	 SIGNAL	 niOli13	:	STD_LOGIC := '1';
	 SIGNAL	 niOli14	:	STD_LOGIC := '1';
	 SIGNAL  wire_niOli14_w_lg_Q44w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 niOli15	:	STD_LOGIC := '0';
	 SIGNAL	 niOlO10	:	STD_LOGIC := '1';
	 SIGNAL	 niOlO11	:	STD_LOGIC := '1';
	 SIGNAL	 niOlO12	:	STD_LOGIC := '0';
	 SIGNAL	 niOOO7	:	STD_LOGIC := '1';
	 SIGNAL	 niOOO8	:	STD_LOGIC := '1';
	 SIGNAL	 niOOO9	:	STD_LOGIC := '0';
	 SIGNAL	 nl10l4	:	STD_LOGIC := '1';
	 SIGNAL	 nl10l5	:	STD_LOGIC := '1';
	 SIGNAL	 nl10l6	:	STD_LOGIC := '0';
	 SIGNAL	 nl1iO1	:	STD_LOGIC := '1';
	 SIGNAL	 nl1iO2	:	STD_LOGIC := '1';
	 SIGNAL	 nl1iO3	:	STD_LOGIC := '0';
	 SIGNAL	n01l	:	STD_LOGIC := '0';
	 SIGNAL	n1lO	:	STD_LOGIC := '0';
	 SIGNAL	n00i	:	STD_LOGIC := '0';
	 SIGNAL	n00l	:	STD_LOGIC := '0';
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n01O	:	STD_LOGIC := '0';
	 SIGNAL	n0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0lO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	n1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1li	:	STD_LOGIC := '0';
	 SIGNAL	n1ll	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni1O_w_lg_w_lg_n0Oi30w33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_w_lg_n0Oi34w35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0Oi30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0Oi34w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_ni1i3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_ni1l2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n1li46w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n00i101w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n00l108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1O_w_lg_n0lO89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_reset29w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_shift_out41w45w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_shift_out41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  niOOl :	STD_LOGIC;
	 SIGNAL  nl10i :	STD_LOGIC;
	 SIGNAL  nl11l :	STD_LOGIC;
	 SIGNAL  nl11O :	STD_LOGIC;
	 SIGNAL  nl1ii :	STD_LOGIC;
	 SIGNAL  nl1il :	STD_LOGIC;
	 SIGNAL  wire_w_dev_addr_range100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_dev_addr_range107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_port_addr_range88w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_reset29w(0) <= NOT reset;
	wire_w_lg_w_lg_shift_out41w45w(0) <= wire_w_lg_shift_out41w(0) OR wire_niOli14_w_lg_Q44w(0);
	wire_w_lg_shift_out41w(0) <= shift_out OR ld_data;
	data_enable_n <= (NOT (((wire_ni1O_w_lg_n1li46w(0) OR wire_niOil17_w_lg_Q49w(0)) AND (valid_addr_lt OR nl10i)) AND niO0O20));
	mbus_in <= ( n1iO & ni0i & ni1l & ni1i & n0OO & n0Ol & n0Oi & n0lO & n0ll & n0li & n0iO & n0il & n0ii & n00O & n00l & n00i);
	mdio_out <= wire_nl_dataout;
	niOOl <= (wire_ni1O_w_lg_w_lg_n0Oi30w33w(0) OR wire_ni1O_w_lg_w_lg_n0Oi34w35w(0));
	nl10i <= (((((wire_ni1O_w_lg_ni1l2w(0) AND wire_ni1O_w_lg_ni1i3w(0)) AND nl1iO2) AND nl1il) AND nl1ii) AND nl10l5);
	nl11l <= '1';
	nl11O <= (shift_out OR shift_in);
	nl1ii <= ((((((NOT (wire_ni1O_w_lg_n00i101w(0) XOR wire_niO1l26_w_lg_Q104w(0))) AND (NOT (wire_ni1O_w_lg_n00l108w(0) XOR wire_nilOO29_w_lg_Q111w(0)))) AND (NOT (n00O XOR dev_addr(2)))) AND (NOT (n0ii XOR dev_addr(3)))) AND (NOT (n0il XOR dev_addr(4)))) AND nilOi32);
	nl1il <= (((((NOT (n0iO XOR port_addr(0))) AND (NOT (n0li XOR port_addr(1)))) AND (NOT (n0ll XOR port_addr(2)))) AND (NOT (wire_ni1O_w_lg_n0lO89w(0) XOR wire_niO0i23_w_lg_Q92w(0)))) AND (NOT (n0Oi XOR port_addr(4))));
	opcode <= ( n01l & n1lO);
	valid_addr <= nl10i;
	wire_w_dev_addr_range100w(0) <= dev_addr(0);
	wire_w_dev_addr_range107w(0) <= dev_addr(1);
	wire_w_port_addr_range88w(0) <= port_addr(3);
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOi31 <= nilOi33;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOi32 <= (nilOi33 XOR nilOi31);
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOi33 <= nilOi31;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOO28 <= nilOO30;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOO29 <= (nilOO30 XOR nilOO28);
		END IF;
	END PROCESS;
	wire_nilOO29_w_lg_Q111w(0) <= NOT nilOO29;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nilOO30 <= nilOO28;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0i22 <= niO0i24;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0i23 <= (niO0i24 XOR niO0i22);
		END IF;
	END PROCESS;
	wire_niO0i23_w_lg_Q92w(0) <= NOT niO0i23;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0i24 <= niO0i22;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0O19 <= niO0O21;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0O20 <= (niO0O21 XOR niO0O19);
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO0O21 <= niO0O19;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO1l25 <= niO1l27;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO1l26 <= (niO1l27 XOR niO1l25);
		END IF;
	END PROCESS;
	wire_niO1l26_w_lg_Q104w(0) <= NOT niO1l26;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niO1l27 <= niO1l25;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOil16 <= niOil18;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOil17 <= (niOil18 XOR niOil16);
		END IF;
	END PROCESS;
	wire_niOil17_w_lg_Q49w(0) <= NOT niOil17;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOil18 <= niOil16;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOli13 <= niOli15;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOli14 <= (niOli15 XOR niOli13);
		END IF;
	END PROCESS;
	wire_niOli14_w_lg_Q44w(0) <= NOT niOli14;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOli15 <= niOli13;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOlO10 <= niOlO12;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOlO11 <= (niOlO12 XOR niOlO10);
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOlO12 <= niOlO10;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOOO7 <= niOOO9;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOOO8 <= (niOOO9 XOR niOOO7);
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN niOOO9 <= niOOO7;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl10l4 <= nl10l6;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl10l5 <= (nl10l6 XOR nl10l4);
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl10l6 <= nl10l4;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl1iO1 <= nl1iO3;
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl1iO2 <= (nl1iO3 XOR nl1iO1);
		END IF;
	END PROCESS;
	PROCESS (mdc)
	BEGIN
		IF (mdc = '1' AND mdc'event) THEN nl1iO3 <= nl1iO1;
		END IF;
	END PROCESS;
	PROCESS (mdc, reset)
	BEGIN
		IF (reset = '1') THEN
				n01l <= '0';
				n1lO <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
			IF (latch_ctl = '1') THEN
				n01l <= n0Ol;
				n1lO <= n0Oi;
			END IF;
		END IF;
	END PROCESS;
	PROCESS (mdc, reset)
	BEGIN
		IF (reset = '1') THEN
				n00i <= '0';
				n00l <= '0';
				n00O <= '0';
				n01O <= '0';
				n0ii <= '0';
				n0il <= '0';
				n0iO <= '0';
				n0li <= '0';
				n0ll <= '0';
				n0lO <= '0';
				n0Oi <= '0';
				n0Ol <= '0';
				n0OO <= '0';
				n1iO <= '0';
				n1li <= '0';
				n1ll <= '0';
				ni0i <= '0';
				ni1i <= '0';
				ni1l <= '0';
		ELSIF (mdc = '1' AND mdc'event) THEN
				n00i <= wire_ni0l_dataout;
				n00l <= wire_ni0O_dataout;
				n00O <= wire_niii_dataout;
				n01O <= mdio_in;
				n0ii <= wire_niil_dataout;
				n0il <= wire_niiO_dataout;
				n0iO <= wire_nili_dataout;
				n0li <= wire_nill_dataout;
				n0ll <= wire_nilO_dataout;
				n0lO <= wire_niOi_dataout;
				n0Oi <= wire_niOl_dataout;
				n0Ol <= wire_niOO_dataout;
				n0OO <= wire_nl1i_dataout;
				n1iO <= wire_nl0l_dataout;
				n1li <= wire_n1Oi_dataout;
				n1ll <= wire_n1Ol_dataout;
				ni0i <= wire_nl0i_dataout;
				ni1i <= wire_nl1l_dataout;
				ni1l <= wire_nl1O_dataout;
		END IF;
	END PROCESS;
	wire_ni1O_w_lg_w_lg_n0Oi30w33w(0) <= wire_ni1O_w_lg_n0Oi30w(0) AND niOOO8;
	wire_ni1O_w_lg_w_lg_n0Oi34w35w(0) <= wire_ni1O_w_lg_n0Oi34w(0) AND n0Ol;
	wire_ni1O_w_lg_n0Oi30w(0) <= n0Oi AND n0Ol;
	wire_ni1O_w_lg_n0Oi34w(0) <= NOT n0Oi;
	wire_ni1O_w_lg_ni1i3w(0) <= NOT ni1i;
	wire_ni1O_w_lg_ni1l2w(0) <= NOT ni1l;
	wire_ni1O_w_lg_n1li46w(0) <= n1li OR wire_w_lg_w_lg_shift_out41w45w(0);
	wire_ni1O_w_lg_n00i101w(0) <= n00i XOR wire_w_dev_addr_range100w(0);
	wire_ni1O_w_lg_n00l108w(0) <= n00l XOR wire_w_dev_addr_range107w(0);
	wire_ni1O_w_lg_n0lO89w(0) <= n0lO XOR wire_w_port_addr_range88w(0);
	wire_n0i_dataout <= ni1i WHEN nl11O = '1'  ELSE ni1l;
	wire_n0l_dataout <= ni1l WHEN nl11O = '1'  ELSE ni0i;
	wire_n0O_dataout <= ni0i WHEN nl11O = '1'  ELSE n1iO;
	wire_n1i_dataout <= n0Oi WHEN nl11O = '1'  ELSE n0Ol;
	wire_n1l_dataout <= n0Ol WHEN nl11O = '1'  ELSE n0OO;
	wire_n1O_dataout <= n0OO WHEN nl11O = '1'  ELSE ni1i;
	wire_n1Oi_dataout <= niOOl WHEN latch_ctl = '1'  ELSE ((n1li AND n1ll) AND niOlO11);
	wire_n1Ol_dataout <= niOOl AND latch_ctl;
	wire_ni0l_dataout <= mbus_out(15) WHEN ld_data = '1'  ELSE wire_nl0O_dataout;
	wire_ni0O_dataout <= mbus_out(0) WHEN ld_data = '1'  ELSE wire_nlii_dataout;
	wire_niii_dataout <= mbus_out(1) WHEN ld_data = '1'  ELSE wire_nlil_dataout;
	wire_niil_dataout <= mbus_out(2) WHEN ld_data = '1'  ELSE wire_nliO_dataout;
	wire_niiO_dataout <= mbus_out(3) WHEN ld_data = '1'  ELSE wire_nlli_dataout;
	wire_nili_dataout <= mbus_out(4) WHEN ld_data = '1'  ELSE wire_nlll_dataout;
	wire_nill_dataout <= mbus_out(5) WHEN ld_data = '1'  ELSE wire_nllO_dataout;
	wire_nilO_dataout <= mbus_out(6) WHEN ld_data = '1'  ELSE wire_nlOi_dataout;
	wire_niOi_dataout <= mbus_out(7) WHEN ld_data = '1'  ELSE wire_nlOl_dataout;
	wire_niOl_dataout <= mbus_out(8) WHEN ld_data = '1'  ELSE wire_nlOO_dataout;
	wire_niOO_dataout <= mbus_out(9) WHEN ld_data = '1'  ELSE wire_n1i_dataout;
	wire_nl_dataout <= mbus_out(15) WHEN ld_data = '1'  ELSE wire_nO_dataout;
	wire_nl0i_dataout <= mbus_out(13) WHEN ld_data = '1'  ELSE wire_n0l_dataout;
	wire_nl0l_dataout <= mbus_out(14) WHEN ld_data = '1'  ELSE wire_n0O_dataout;
	wire_nl0O_dataout <= n01O WHEN nl11O = '1'  ELSE n00i;
	wire_nl1i_dataout <= mbus_out(10) WHEN ld_data = '1'  ELSE wire_n1l_dataout;
	wire_nl1l_dataout <= mbus_out(11) WHEN ld_data = '1'  ELSE wire_n1O_dataout;
	wire_nl1O_dataout <= mbus_out(12) WHEN ld_data = '1'  ELSE wire_n0i_dataout;
	wire_nlii_dataout <= n00i WHEN nl11O = '1'  ELSE n00l;
	wire_nlil_dataout <= n00l WHEN nl11O = '1'  ELSE n00O;
	wire_nliO_dataout <= n00O WHEN nl11O = '1'  ELSE n0ii;
	wire_nlli_dataout <= n0ii WHEN nl11O = '1'  ELSE n0il;
	wire_nlll_dataout <= n0il WHEN nl11O = '1'  ELSE n0iO;
	wire_nllO_dataout <= n0iO WHEN nl11O = '1'  ELSE n0li;
	wire_nlOi_dataout <= n0li WHEN nl11O = '1'  ELSE n0ll;
	wire_nlOl_dataout <= n0ll WHEN nl11O = '1'  ELSE n0lO;
	wire_nlOO_dataout <= n0lO WHEN nl11O = '1'  ELSE n0Oi;
	wire_nO_dataout <= n1iO AND shift_out;

 END RTL; --mdio_ctl_data
--synopsys translate_on
--VALID FILE

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY mdio_pcs_bus_out_mux IS
    PORT (
        pcs_ctrl_in1            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in2            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in3            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in4            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in5            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in6            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in7            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in8            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in9            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in10           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in11           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in12           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in13           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in14           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in15           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in16           : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in1     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in2     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in3     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in4     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in5     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in6     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in7     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in8     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in9     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in10    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in11    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in12    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in13    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in14    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in15    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in16    : IN std_logic_vector(15 DOWNTO 0);   
        reg_addr                : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_out            : OUT std_logic_vector(15 DOWNTO 0));   
END mdio_pcs_bus_out_mux;

ARCHITECTURE mdio_pcs_bus_out_mux_arch OF mdio_pcs_bus_out_mux IS


    SIGNAL temp_xhdl2               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl3               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl4               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl5               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl6               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl7               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl8               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl9               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl10              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl11              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl12              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl13              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl14              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl15              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl16              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl17              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL pcs_ctrl_out_xhdl1       :  std_logic_vector(15 DOWNTO 0);   

BEGIN
    pcs_ctrl_out <= pcs_ctrl_out_xhdl1;
    temp_xhdl2 <= pcs_ctrl_in16 WHEN (reg_addr = hw_address_ctrl_in16) ELSE "0000000000000000";
    temp_xhdl3 <= pcs_ctrl_in15 WHEN (reg_addr = hw_address_ctrl_in15) ELSE temp_xhdl2;
    temp_xhdl4 <= pcs_ctrl_in14 WHEN (reg_addr = hw_address_ctrl_in14) ELSE temp_xhdl3;
    temp_xhdl5 <= pcs_ctrl_in13 WHEN (reg_addr = hw_address_ctrl_in13) ELSE temp_xhdl4;
    temp_xhdl6 <= pcs_ctrl_in12 WHEN (reg_addr = hw_address_ctrl_in12) ELSE temp_xhdl5;
    temp_xhdl7 <= pcs_ctrl_in11 WHEN (reg_addr = hw_address_ctrl_in11) ELSE temp_xhdl6;
    temp_xhdl8 <= pcs_ctrl_in10 WHEN (reg_addr = hw_address_ctrl_in10) ELSE temp_xhdl7;
    temp_xhdl9 <= pcs_ctrl_in9 WHEN (reg_addr = hw_address_ctrl_in9) ELSE temp_xhdl8;
    temp_xhdl10 <= pcs_ctrl_in8 WHEN (reg_addr = hw_address_ctrl_in8) ELSE temp_xhdl9;
    temp_xhdl11 <= pcs_ctrl_in7 WHEN (reg_addr = hw_address_ctrl_in7) ELSE temp_xhdl10;
    temp_xhdl12 <= pcs_ctrl_in6 WHEN (reg_addr = hw_address_ctrl_in6) ELSE temp_xhdl11;
    temp_xhdl13 <= pcs_ctrl_in5 WHEN (reg_addr = hw_address_ctrl_in5) ELSE temp_xhdl12;
    temp_xhdl14 <= pcs_ctrl_in4 WHEN (reg_addr = hw_address_ctrl_in4) ELSE temp_xhdl13;
    temp_xhdl15 <= pcs_ctrl_in3 WHEN (reg_addr = hw_address_ctrl_in3) ELSE temp_xhdl14;
    temp_xhdl16 <= pcs_ctrl_in2 WHEN (reg_addr = hw_address_ctrl_in2) ELSE temp_xhdl15;
    temp_xhdl17 <= pcs_ctrl_in1 WHEN (reg_addr = hw_address_ctrl_in1) ELSE temp_xhdl16;
    pcs_ctrl_out_xhdl1 <= temp_xhdl17 ;

END mdio_pcs_bus_out_mux_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY mdio_sm IS
    PORT (
        mdc                     : IN std_logic;   --  Clock for MDIO interface
        mdio_in                 : IN std_logic;   --  Signal bit data
        reset                   : IN std_logic;   --  Active high Hard Reset
        opcode                  : IN std_logic_vector(1 DOWNTO 0);   --  2 bit opcode from mdio_ctl_data module
                                                                     -- 00 - Address
                                                                     -- 01 - Write
                                                                     -- 10 - Read with no post Increment
                                                                     -- 11 - Read with post increment

        valid_addr              : IN std_logic;   --  When set the Port and Dev Address
                                                  -- corresponds to this module

        cnt_eq_0                : IN std_logic;   --  From mdio_cnt module, down counter is 0
        shift_in                : OUT std_logic;   --  Shift in enable for either data or control
        shift_out               : OUT std_logic;   --  Shift out enable for mdio_ctl_data
        latch_ctl               : OUT std_logic;   --  Latch the Opcode, to mdio_ctl_data
        incr_addr               : OUT std_logic;   --  Increment signal for mdio_addr
        mdio_wr                 : OUT std_logic;   --  This is used for writing the mdio registers
        mdio_rd                 : OUT std_logic;   --  This is used for clearing the mdio status registers
        shift_addr              : OUT std_logic;   --  Shift in Enable for mdio_addr
        ld_data                 : OUT std_logic;   --  When set, the shift register is mdio_ctl_data is parallely
                                                   -- loaded with the data from mdio_reg module

        ld_cnt                  : OUT std_logic;   --  Load Down counter
        cnt_val                 : OUT std_logic_vector(4 DOWNTO 0);   --  Value to load the down counter
        valid_addr_lt           : OUT std_logic;   
        curr_state              : OUT std_logic_vector(2 DOWNTO 0));   
END mdio_sm;

ARCHITECTURE mdio_sm_arch OF mdio_sm IS


    -- Allowed states for curr_state and next_state
    --wire      ld_data_d;
    CONSTANT  IDLE                  :  std_logic_vector(2 DOWNTO 0) := "000";    
    CONSTANT  PREAMBLE              :  std_logic_vector(2 DOWNTO 0) := "001";    
    CONSTANT  CONTROL               :  std_logic_vector(2 DOWNTO 0) := "010";    
    CONSTANT  TURN_ARND_0           :  std_logic_vector(2 DOWNTO 0) := "011";    
    CONSTANT  TURN_ARND_1           :  std_logic_vector(2 DOWNTO 0) := "100";    
    CONSTANT  ADDR_DATA             :  std_logic_vector(2 DOWNTO 0) := "101";    
    -- Decode for opcode
    CONSTANT  ADDR_OP               :  std_logic_vector(1 DOWNTO 0) := "00";    
    CONSTANT  WR_OP                 :  std_logic_vector(1 DOWNTO 0) := "01";    
    CONSTANT  RD_INC_OP             :  std_logic_vector(1 DOWNTO 0) := "10";    
    CONSTANT  RD_OP                 :  std_logic_vector(1 DOWNTO 0) := "11";    
    SIGNAL next_state               :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL shift_in_xhdl1           :  std_logic;   
    SIGNAL shift_out_xhdl2          :  std_logic;   
    SIGNAL latch_ctl_xhdl3          :  std_logic;   
    SIGNAL incr_addr_xhdl4          :  std_logic;   
    SIGNAL mdio_wr_xhdl5            :  std_logic;   
    SIGNAL mdio_rd_xhdl6            :  std_logic;   
    SIGNAL shift_addr_xhdl7         :  std_logic;   
    SIGNAL ld_data_xhdl8            :  std_logic;   
    SIGNAL ld_cnt_xhdl9             :  std_logic;   
    SIGNAL cnt_val_xhdl10           :  std_logic_vector(4 DOWNTO 0);   
    SIGNAL valid_addr_lt_xhdl11     :  std_logic;   
    SIGNAL curr_state_xhdl12        :  std_logic_vector(2 DOWNTO 0);   

BEGIN
    shift_in <= shift_in_xhdl1;
    shift_out <= shift_out_xhdl2;
    latch_ctl <= latch_ctl_xhdl3;
    incr_addr <= incr_addr_xhdl4;
    mdio_wr <= mdio_wr_xhdl5;
    mdio_rd <= mdio_rd_xhdl6;
    shift_addr <= shift_addr_xhdl7;
    ld_data <= ld_data_xhdl8;
    ld_cnt <= ld_cnt_xhdl9;
    cnt_val <= cnt_val_xhdl10;
    valid_addr_lt <= valid_addr_lt_xhdl11;
    curr_state <= curr_state_xhdl12;

    -- Latch Curr State
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            curr_state_xhdl12 <= IDLE;    
        ELSE
            curr_state_xhdl12 <= next_state;    
        END IF;
    END PROCESS;

    -- Next State loic for mdio_sm
    
    PROCESS
    BEGIN
        WAIT UNTIL curr_state_xhdl12'EVENT OR mdio_in'EVENT OR cnt_eq_0'EVENT OR valid_addr'EVENT OR opcode'EVENT;
        CASE curr_state_xhdl12 IS
            WHEN IDLE =>
                        IF (mdio_in = '1') THEN
                            next_state <= PREAMBLE;    
                        ELSE
                            next_state <= IDLE;    
                        END IF;
            WHEN PREAMBLE =>
                        IF (mdio_in /= '1' AND cnt_eq_0 /= '1') THEN
                            next_state <= IDLE;    
                        ELSE
                            IF (mdio_in /= '1' AND cnt_eq_0 = '1') THEN
                                next_state <= CONTROL;    
                            ELSE
                                next_state <= PREAMBLE;    
                            END IF;
                        END IF;
            WHEN CONTROL =>
                        IF (cnt_eq_0 = '1') THEN
                            IF (mdio_in = '0') THEN
                                next_state <= IDLE;    
                            ELSE
                                next_state <= TURN_ARND_0;    
                            END IF;
                        ELSE
                            next_state <= CONTROL;    
                        END IF;
            WHEN TURN_ARND_0 =>
                        IF (mdio_in = '1' OR valid_addr = '0') THEN
                            next_state <= IDLE;    
                        ELSE
                            IF (opcode = WR_OP OR opcode = ADDR_OP) THEN
                                next_state <= TURN_ARND_1;    
                            ELSE
                                next_state <= ADDR_DATA;    
                            END IF;
                        END IF;
            WHEN TURN_ARND_1 =>                        
                        next_state <= ADDR_DATA;    
            WHEN ADDR_DATA =>
                        IF ((cnt_eq_0 = '1' AND mdio_in = '1') AND (opcode = WR_OP OR opcode = ADDR_OP)) THEN
                            next_state <= PREAMBLE;    
                        ELSE
                            IF (cnt_eq_0 = '1') THEN
                                next_state <= IDLE;    
                            ELSE
                                next_state <= ADDR_DATA;    
                            END IF;
                        END IF;
            WHEN OTHERS  =>
                        next_state <= IDLE;    
            
        END CASE;
    END PROCESS;

    -- Valid_addr_lt is used to enable mdio_out
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            valid_addr_lt_xhdl11 <= '0';    
        ELSE
            IF (valid_addr = '1' AND curr_state_xhdl12 = TURN_ARND_0) THEN
                valid_addr_lt_xhdl11 <= '1';    
            ELSE
                IF (curr_state_xhdl12 = ADDR_DATA AND cnt_eq_0 = '1') THEN
                    valid_addr_lt_xhdl11 <= '0';    
                END IF;
            END IF;
        END IF;
    END PROCESS;

    -- Logic for shift_in, This signal is used for shifting in
    -- control logic, during all commands, and data during
    -- Write command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            shift_in_xhdl1 <= '0';    
        ELSE
            IF ((curr_state_xhdl12 = PREAMBLE AND next_state = CONTROL) OR (next_state = CONTROL) OR (next_state = ADDR_DATA AND opcode = WR_OP)) THEN
                shift_in_xhdl1 <= '1';    
            ELSE
                shift_in_xhdl1 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Shift_out logic, shift_out is set when d ata is shifted out on
    -- a RD_OP or RD_INC_OP command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            shift_out_xhdl2 <= '0';    
        ELSE
            IF ((curr_state_xhdl12 = TURN_ARND_0 AND next_state = ADDR_DATA) OR 
                ((curr_state_xhdl12 = ADDR_DATA) AND 
                 (opcode = RD_OP OR opcode = RD_INC_OP) AND 
                 (cnt_eq_0 = '0'))) THEN
                shift_out_xhdl2 <= '1';    
            ELSE
                shift_out_xhdl2 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for latch_ctl, this signal is used for latching the opcode
    -- This signal is set when in Control state and moving to TURN_ARND_0
    -- state
    --
    -- always @(posedge reset or posedge mdc)
    -- begin
    --    if (reset)
    --        latch_ctl <= 1'b0;
    --    else
    --       if (curr_state == CONTROL && next_state == TURN_ARND_0)
    --          latch_ctl <= 1'b1;
    --       else
    --          latch_ctl <= 1'b0;
    -- end
    -- 
    
    PROCESS
    BEGIN
        WAIT UNTIL cnt_eq_0'EVENT OR curr_state_xhdl12'EVENT;
        IF (cnt_eq_0 = '1' AND curr_state_xhdl12 = CONTROL) THEN    
             latch_ctl_xhdl3 <= '1';
        ELSE
             latch_ctl_xhdl3 <= '0';
        END IF;
    END PROCESS;

    -- Logic for incr_addr, incr_addr is set for opcode RD_INC_OP and
    -- after completely shifting out the read data for the current command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            incr_addr_xhdl4 <= '0';    
        ELSE
            IF (curr_state_xhdl12 = ADDR_DATA AND cnt_eq_0 = '1' AND opcode = RD_INC_OP) THEN
                incr_addr_xhdl4 <= '1';    
            ELSE
                incr_addr_xhdl4 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for shift addr, this bit is set when moving to ADDR_DATA 
    -- state and when in ADDR_DATA state for ADDR_OP command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            shift_addr_xhdl7 <= '0';    
        ELSE
            IF (next_state = ADDR_DATA AND opcode = ADDR_OP) THEN
                shift_addr_xhdl7 <= '1';    
            ELSE
                shift_addr_xhdl7 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for mdio_wr, this bit is set when moving from ADDR_DATA to the
    -- IDLE for a WR_OP command
    -- Logic for mdio_rd, this bit is set when moving from ADDR_DATA to the
    -- IDLE for a RD_OP/RD_INC_OP command
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            mdio_wr_xhdl5 <= '0';    
            mdio_rd_xhdl6 <= '0';    
        ELSE
            IF (curr_state_xhdl12 = ADDR_DATA AND cnt_eq_0 = '1') THEN
                IF (opcode = WR_OP) THEN
                    mdio_wr_xhdl5 <= '1';    
                ELSE
                    mdio_wr_xhdl5 <= '0';    
                END IF;
                IF (opcode = RD_OP OR opcode = RD_INC_OP) THEN
                    mdio_rd_xhdl6 <= '1';    
                ELSE
                    mdio_rd_xhdl6 <= '0';    
                END IF;
            ELSE
                mdio_wr_xhdl5 <= '0';    
                mdio_rd_xhdl6 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for ld_data, this signal is used for parallely loading the
    -- shift register in mdio_ctl_data module with the data from mdio_reg
    -- module. This set is set for RD_OP and RD_INC_OP commands when the
    -- SM transitions from TURN_ARND_0 to ADDR_DATA state
    -- assign ld_data_d = (curr_state == TURN_ARND_0 && (opcode == RD_OP | opcode == RD_INC_OP));
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            ld_data_xhdl8 <= '0';    
        ELSE
            IF (curr_state_xhdl12 = TURN_ARND_0 AND next_state = ADDR_DATA) THEN   
                ld_data_xhdl8 <= '1';
            ELSE
                ld_data_xhdl8 <= '0';            
            END IF;    
        END IF;
    END PROCESS;

    -- Logic for ld_cnt, this signal is used for loading the down counter
    -- with cnt_val signal. This signal is set when going to
    -- CONTROL state or ADDR_DATA state or PREAMBLE states
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            ld_cnt_xhdl9 <= '0';    
        ELSE
            IF ((curr_state_xhdl12 = IDLE AND next_state = PREAMBLE) OR (curr_state_xhdl12 = ADDR_DATA AND next_state = PREAMBLE) OR (curr_state_xhdl12 = PREAMBLE AND next_state = CONTROL) OR (curr_state_xhdl12 = TURN_ARND_0 AND next_state = ADDR_DATA) OR (curr_state_xhdl12 = TURN_ARND_1 AND next_state = ADDR_DATA)) THEN
                ld_cnt_xhdl9 <= '1';    
            ELSE
                ld_cnt_xhdl9 <= '0';    
            END IF;
        END IF;
    END PROCESS;

    -- Logic for cnt_val, this counter value is used for sown counting
    -- the mdio_cnt, when the counter reaches zero, the cnt_eq_0 is
    -- set. The counter is loading with 31 for PREAMBLE, 13 for 
    -- CONTROL, and 15 for ADDR_DATA
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (mdc'EVENT AND mdc = '1');
        IF (reset = '1') THEN
            cnt_val_xhdl10 <= "00000";    
        ELSE
            IF ((curr_state_xhdl12 = IDLE OR curr_state_xhdl12 = ADDR_DATA) AND next_state = PREAMBLE) THEN
                cnt_val_xhdl10 <= "11110";    
            ELSE
                IF (curr_state_xhdl12 = PREAMBLE AND next_state = CONTROL) THEN
                    cnt_val_xhdl10 <= "01100";    
                ELSE
                    IF (curr_state_xhdl12 = TURN_ARND_0 AND next_state = ADDR_DATA) THEN
                        cnt_val_xhdl10 <= "01110";    
                    ELSE
                        IF (curr_state_xhdl12 = TURN_ARND_1 AND next_state = ADDR_DATA) THEN
                            cnt_val_xhdl10 <= "01110";    
                        ELSE
                            cnt_val_xhdl10 <= cnt_val_xhdl10;    
                        END IF;
                    END IF;
                END IF;
            END IF;
        END IF;
    END PROCESS;

END mdio_sm_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY bsc_in_r IS
    PORT (
        -- synthesis ALTERA_ATTRIBUTE="{-to so} POWER_UP_LEVEL=LOW" 
        reset                   : IN std_logic;   --  reset
        clk                     : IN std_logic;   --  clock
        sig_in                  : IN std_logic;   --  signal input
        ext_in                  : IN std_logic;   --  external input port
        jtag_mode               : IN std_logic;   
        si                      : IN std_logic;   --  scan input
        shift                   : IN std_logic;   --  1'b1=shift in data from si into scan flop
        -- 1'b0=load data from sig_in into scan flop

        mdio_dis                : IN std_logic;   --  1'b1=choose ext_in to the sig_out mux
        -- 1'b0=choose so to the sign_out mux

        sig_out                 : OUT std_logic;   --  signal output
        so                      : OUT std_logic);   --  scan output
END bsc_in_r;

ARCHITECTURE bsc_in_r_arch OF bsc_in_r IS


    SIGNAL cram_int                 :  std_logic;   
    SIGNAL set_int                  :  std_logic;   
    -- select signal output
    SIGNAL temp_xhdl3               :  std_logic;   
    SIGNAL temp_xhdl4               :  std_logic;   
    -- Set signal for the flop
    SIGNAL temp_xhdl5               :  std_logic;   
    SIGNAL sig_out_xhdl1            :  std_logic;   
    SIGNAL so_xhdl2                 :  std_logic;   

BEGIN
    sig_out <= sig_out_xhdl1;
    so <= so_xhdl2;
    temp_xhdl3 <= (so_xhdl2 AND NOT shift) WHEN (jtag_mode) = '1' ELSE (cram_int);
    sig_out_xhdl1 <= temp_xhdl3 ;
    temp_xhdl4 <= (ext_in) WHEN (mdio_dis) = '1' ELSE (so_xhdl2);
    cram_int <= temp_xhdl4 ;
    temp_xhdl5 <= '0' WHEN (shift) = '1' ELSE ext_in;
    set_int <= temp_xhdl5 ;

    -- scan flop
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (set_int'EVENT AND set_int = '1') OR (clk'EVENT AND clk = '1');
        IF (reset = '1') THEN
            so_xhdl2 <= '0';    
        ELSE
            IF (set_int = '1') THEN
                so_xhdl2 <= '1';    
            ELSE
                IF ((shift AND jtag_mode) = '1') THEN
                    so_xhdl2 <= si;    
                ELSE
                    so_xhdl2 <= sig_in;    
                END IF;
            END IF;
        END IF;
    END PROCESS;

END bsc_in_r_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY ctrl_reg IS
    PORT (
        reset                   : IN std_logic;   --  reset
        mdio_wr                 : IN std_logic;   
        reg_addr                : IN std_logic_vector(15 DOWNTO 0);   
        target_addr             : IN std_logic_vector(15 DOWNTO 0);   
        clk                     : IN std_logic;   --  clock
        sig_in                  : IN std_logic_vector(15 DOWNTO 0);   --  signal input
        ext_in                  : IN std_logic_vector(15 DOWNTO 0);   --  external port input
        jtag_mode               : IN std_logic;   
        si                      : IN std_logic;   --  scan input
        shift                   : IN std_logic;   --  1'b1=shift in data from si into scan flop
        -- 1'b0=load data from sig_in into scan flop

        mdio_dis                : IN std_logic;   
        -- 1'b1=output CRAM
-- 1'b0=output MDIO control register

        sig_out                 : OUT std_logic_vector(15 DOWNTO 0);   --  signal output
        so                      : OUT std_logic);   --  scan output
END ctrl_reg;

ARCHITECTURE ctrl_reg_arch OF ctrl_reg IS

    COMPONENT bsc_in_r
        PORT (
            reset                   : IN  std_logic;
            clk                     : IN  std_logic;
            sig_in                  : IN  std_logic;
            ext_in                  : IN  std_logic;
            jtag_mode               : IN  std_logic;
            si                      : IN  std_logic;
            shift                   : IN  std_logic;
            mdio_dis                : IN  std_logic;
            sig_out                 : OUT std_logic;
            so                      : OUT std_logic);
    END COMPONENT;


    SIGNAL signal_in_int            :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL chain                    :  std_logic_vector(14 DOWNTO 0);   
    SIGNAL temp_xhdl3               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL port_xhdl14              :  std_logic;   
    SIGNAL port_xhdl15              :  std_logic;   
    SIGNAL port_xhdl16              :  std_logic;   
    SIGNAL port_xhdl17              :  std_logic;   
    SIGNAL port_xhdl28              :  std_logic;   
    SIGNAL port_xhdl29              :  std_logic;   
    SIGNAL port_xhdl30              :  std_logic;   
    SIGNAL port_xhdl31              :  std_logic;   
    SIGNAL port_xhdl32              :  std_logic;   
    SIGNAL port_xhdl43              :  std_logic;   
    SIGNAL port_xhdl44              :  std_logic;   
    SIGNAL port_xhdl45              :  std_logic;   
    SIGNAL port_xhdl46              :  std_logic;   
    SIGNAL port_xhdl47              :  std_logic;   
    SIGNAL port_xhdl58              :  std_logic;   
    SIGNAL port_xhdl59              :  std_logic;   
    SIGNAL port_xhdl60              :  std_logic;   
    SIGNAL port_xhdl61              :  std_logic;   
    SIGNAL port_xhdl62              :  std_logic;   
    SIGNAL port_xhdl73              :  std_logic;   
    SIGNAL port_xhdl74              :  std_logic;   
    SIGNAL port_xhdl75              :  std_logic;   
    SIGNAL port_xhdl76              :  std_logic;   
    SIGNAL port_xhdl77              :  std_logic;   
    SIGNAL port_xhdl88              :  std_logic;   
    SIGNAL port_xhdl89              :  std_logic;   
    SIGNAL port_xhdl90              :  std_logic;   
    SIGNAL port_xhdl91              :  std_logic;   
    SIGNAL port_xhdl92              :  std_logic;   
    SIGNAL port_xhdl103             :  std_logic;   
    SIGNAL port_xhdl104             :  std_logic;   
    SIGNAL port_xhdl105             :  std_logic;   
    SIGNAL port_xhdl106             :  std_logic;   
    SIGNAL port_xhdl107             :  std_logic;   
    SIGNAL port_xhdl118             :  std_logic;   
    SIGNAL port_xhdl119             :  std_logic;   
    SIGNAL port_xhdl120             :  std_logic;   
    SIGNAL port_xhdl121             :  std_logic;   
    SIGNAL port_xhdl122             :  std_logic;   
    SIGNAL port_xhdl133             :  std_logic;   
    SIGNAL port_xhdl134             :  std_logic;   
    SIGNAL port_xhdl135             :  std_logic;   
    SIGNAL port_xhdl136             :  std_logic;   
    SIGNAL port_xhdl137             :  std_logic;   
    SIGNAL port_xhdl148             :  std_logic;   
    SIGNAL port_xhdl149             :  std_logic;   
    SIGNAL port_xhdl150             :  std_logic;   
    SIGNAL port_xhdl151             :  std_logic;   
    SIGNAL port_xhdl152             :  std_logic;   
    SIGNAL port_xhdl163             :  std_logic;   
    SIGNAL port_xhdl164             :  std_logic;   
    SIGNAL port_xhdl165             :  std_logic;   
    SIGNAL port_xhdl166             :  std_logic;   
    SIGNAL port_xhdl167             :  std_logic;   
    SIGNAL port_xhdl178             :  std_logic;   
    SIGNAL port_xhdl179             :  std_logic;   
    SIGNAL port_xhdl180             :  std_logic;   
    SIGNAL port_xhdl181             :  std_logic;   
    SIGNAL port_xhdl182             :  std_logic;   
    SIGNAL port_xhdl193             :  std_logic;   
    SIGNAL port_xhdl194             :  std_logic;   
    SIGNAL port_xhdl195             :  std_logic;   
    SIGNAL port_xhdl196             :  std_logic;   
    SIGNAL port_xhdl197             :  std_logic;   
    SIGNAL port_xhdl208             :  std_logic;   
    SIGNAL port_xhdl209             :  std_logic;   
    SIGNAL port_xhdl210             :  std_logic;   
    SIGNAL port_xhdl211             :  std_logic;   
    SIGNAL port_xhdl212             :  std_logic;   
    SIGNAL port_xhdl223             :  std_logic;   
    SIGNAL port_xhdl224             :  std_logic;   
    SIGNAL port_xhdl225             :  std_logic;   
    SIGNAL port_xhdl226             :  std_logic;   
    SIGNAL port_xhdl227             :  std_logic;   
    SIGNAL port_xhdl238             :  std_logic;   
    SIGNAL port_xhdl239             :  std_logic;   
    SIGNAL port_xhdl240             :  std_logic;   
    SIGNAL port_xhdl241             :  std_logic;   
    SIGNAL sig_out_xhdl1            :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL so_xhdl2                 :  std_logic;   

BEGIN
    sig_out <= sig_out_xhdl1;
    so <= so_xhdl2;
    temp_xhdl3 <= sig_in WHEN (mdio_wr = '1' AND reg_addr = target_addr) ELSE (so_xhdl2 & chain);
    signal_in_int <= temp_xhdl3 ;
    port_xhdl14 <= signal_in_int(0);
    port_xhdl15 <= ext_in(0);
    sig_out_xhdl1(0) <= port_xhdl16;
    chain(0) <= port_xhdl17;
    bsc_in_r_0 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl14,
            ext_in => port_xhdl15,
            jtag_mode => jtag_mode,
            si => si,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl16,
            so => port_xhdl17);   
    
    port_xhdl28 <= signal_in_int(1);
    port_xhdl29 <= ext_in(1);
    port_xhdl30 <= chain(0);
    sig_out_xhdl1(1) <= port_xhdl31;
    chain(1) <= port_xhdl32;
    bsc_in_r_1 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl28,
            ext_in => port_xhdl29,
            jtag_mode => jtag_mode,
            si => port_xhdl30,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl31,
            so => port_xhdl32);   
    
    port_xhdl43 <= signal_in_int(2);
    port_xhdl44 <= ext_in(2);
    port_xhdl45 <= chain(1);
    sig_out_xhdl1(2) <= port_xhdl46;
    chain(2) <= port_xhdl47;
    bsc_in_r_2 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl43,
            ext_in => port_xhdl44,
            jtag_mode => jtag_mode,
            si => port_xhdl45,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl46,
            so => port_xhdl47);   
    
    port_xhdl58 <= signal_in_int(3);
    port_xhdl59 <= ext_in(3);
    port_xhdl60 <= chain(2);
    sig_out_xhdl1(3) <= port_xhdl61;
    chain(3) <= port_xhdl62;
    bsc_in_r_3 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl58,
            ext_in => port_xhdl59,
            jtag_mode => jtag_mode,
            si => port_xhdl60,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl61,
            so => port_xhdl62);   
    
    port_xhdl73 <= signal_in_int(4);
    port_xhdl74 <= ext_in(4);
    port_xhdl75 <= chain(3);
    sig_out_xhdl1(4) <= port_xhdl76;
    chain(4) <= port_xhdl77;
    bsc_in_r_4 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl73,
            ext_in => port_xhdl74,
            jtag_mode => jtag_mode,
            si => port_xhdl75,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl76,
            so => port_xhdl77);   
    
    port_xhdl88 <= signal_in_int(5);
    port_xhdl89 <= ext_in(5);
    port_xhdl90 <= chain(4);
    sig_out_xhdl1(5) <= port_xhdl91;
    chain(5) <= port_xhdl92;
    bsc_in_r_5 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl88,
            ext_in => port_xhdl89,
            jtag_mode => jtag_mode,
            si => port_xhdl90,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl91,
            so => port_xhdl92);   
    
    port_xhdl103 <= signal_in_int(6);
    port_xhdl104 <= ext_in(6);
    port_xhdl105 <= chain(5);
    sig_out_xhdl1(6) <= port_xhdl106;
    chain(6) <= port_xhdl107;
    bsc_in_r_6 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl103,
            ext_in => port_xhdl104,
            jtag_mode => jtag_mode,
            si => port_xhdl105,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl106,
            so => port_xhdl107);   
    
    port_xhdl118 <= signal_in_int(7);
    port_xhdl119 <= ext_in(7);
    port_xhdl120 <= chain(6);
    sig_out_xhdl1(7) <= port_xhdl121;
    chain(7) <= port_xhdl122;
    bsc_in_r_7 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl118,
            ext_in => port_xhdl119,
            jtag_mode => jtag_mode,
            si => port_xhdl120,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl121,
            so => port_xhdl122);   
    
    port_xhdl133 <= signal_in_int(8);
    port_xhdl134 <= ext_in(8);
    port_xhdl135 <= chain(7);
    sig_out_xhdl1(8) <= port_xhdl136;
    chain(8) <= port_xhdl137;
    bsc_in_r_8 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl133,
            ext_in => port_xhdl134,
            jtag_mode => jtag_mode,
            si => port_xhdl135,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl136,
            so => port_xhdl137);   
    
    port_xhdl148 <= signal_in_int(9);
    port_xhdl149 <= ext_in(9);
    port_xhdl150 <= chain(8);
    sig_out_xhdl1(9) <= port_xhdl151;
    chain(9) <= port_xhdl152;
    bsc_in_r_9 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl148,
            ext_in => port_xhdl149,
            jtag_mode => jtag_mode,
            si => port_xhdl150,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl151,
            so => port_xhdl152);   
    
    port_xhdl163 <= signal_in_int(10);
    port_xhdl164 <= ext_in(10);
    port_xhdl165 <= chain(9);
    sig_out_xhdl1(10) <= port_xhdl166;
    chain(10) <= port_xhdl167;
    bsc_in_r_10 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl163,
            ext_in => port_xhdl164,
            jtag_mode => jtag_mode,
            si => port_xhdl165,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl166,
            so => port_xhdl167);   
    
    port_xhdl178 <= signal_in_int(11);
    port_xhdl179 <= ext_in(11);
    port_xhdl180 <= chain(10);
    sig_out_xhdl1(11) <= port_xhdl181;
    chain(11) <= port_xhdl182;
    bsc_in_r_11 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl178,
            ext_in => port_xhdl179,
            jtag_mode => jtag_mode,
            si => port_xhdl180,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl181,
            so => port_xhdl182);   
    
    port_xhdl193 <= signal_in_int(12);
    port_xhdl194 <= ext_in(12);
    port_xhdl195 <= chain(11);
    sig_out_xhdl1(12) <= port_xhdl196;
    chain(12) <= port_xhdl197;
    bsc_in_r_12 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl193,
            ext_in => port_xhdl194,
            jtag_mode => jtag_mode,
            si => port_xhdl195,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl196,
            so => port_xhdl197);   
    
    port_xhdl208 <= signal_in_int(13);
    port_xhdl209 <= ext_in(13);
    port_xhdl210 <= chain(12);
    sig_out_xhdl1(13) <= port_xhdl211;
    chain(13) <= port_xhdl212;
    bsc_in_r_13 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl208,
            ext_in => port_xhdl209,
            jtag_mode => jtag_mode,
            si => port_xhdl210,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl211,
            so => port_xhdl212);   
    
    port_xhdl223 <= signal_in_int(14);
    port_xhdl224 <= ext_in(14);
    port_xhdl225 <= chain(13);
    sig_out_xhdl1(14) <= port_xhdl226;
    chain(14) <= port_xhdl227;
    bsc_in_r_14 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl223,
            ext_in => port_xhdl224,
            jtag_mode => jtag_mode,
            si => port_xhdl225,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl226,
            so => port_xhdl227);   
    
    port_xhdl238 <= signal_in_int(15);
    port_xhdl239 <= ext_in(15);
    port_xhdl240 <= chain(14);
    sig_out_xhdl1(15) <= port_xhdl241;
    bsc_in_r_15 : bsc_in_r 
        PORT MAP (
            reset => reset,
            clk => clk,
            sig_in => port_xhdl238,
            ext_in => port_xhdl239,
            jtag_mode => jtag_mode,
            si => port_xhdl240,
            shift => shift,
            mdio_dis => mdio_dis,
            sig_out => port_xhdl241,
            so => so_xhdl2);   
    

END ctrl_reg_arch;
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

--synthesis_resources = lut 1 mux21 2 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  bsc_out IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 jtag_mode	:	IN  STD_LOGIC;
		 reset	:	IN  STD_LOGIC;
		 shift_load	:	IN  STD_LOGIC;
		 si	:	IN  STD_LOGIC;
		 sig_in	:	IN  STD_LOGIC;
		 sig_out	:	OUT  STD_LOGIC;
		 so	:	OUT  STD_LOGIC
	 ); 
 END bsc_out;

 ARCHITECTURE RTL OF bsc_out IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	ni	:	STD_LOGIC := '0';
	 SIGNAL	wire_nl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_reset1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n1i :	STD_LOGIC;
 BEGIN

	wire_w_lg_reset1w(0) <= NOT reset;
	n1i <= '1';
	sig_out <= wire_nO_dataout;
	so <= ni;
	PROCESS (clk, reset)
	BEGIN
		IF (reset = '1') THEN
				ni <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				ni <= wire_nl_dataout;
		END IF;
	END PROCESS;
	wire_nl_dataout <= si WHEN shift_load = '1'  ELSE sig_in;
	wire_nO_dataout <= ni WHEN jtag_mode = '1'  ELSE sig_in;

 END RTL; --bsc_out
--synopsys translate_on
--VALID FILE

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.mdio_pcs_bus_out_mux;
USE WORK.bsc_out;
USE WORK.bsc_in_r;
USE WORK.ctrl_reg;

ENTITY stratixiigx_hssi_cmu_dprio_reg IS
  GENERIC (
    rx0_phy : INTEGER := 0;
    rx1_phy : INTEGER := 1;
    rx2_phy : INTEGER := 2;
    rx3_phy : INTEGER := 3;
    tx0_phy : INTEGER := 0;
    tx1_phy : INTEGER := 1;
    tx2_phy : INTEGER := 2;
    tx3_phy : INTEGER := 3
  );
  PORT (
    mdc          : IN std_logic := '0';       
    mdio_rst     : IN std_logic := '0';
    mdio_dis     : IN std_logic := '1';
    dprioload    : IN std_logic := '0';
    align_status : IN std_logic := '0';
    sync_status  : IN std_logic_vector (3 DOWNTO 0) := (OTHERS => '0');
    reg_addr     : IN std_logic_vector (15 DOWNTO 0) := (OTHERS => '0');
    mdio_wr      : IN std_logic := '0';      
    mdio_rd      : IN std_logic := '0';
    dev_addr_0   : IN std_logic := '0';
    mbus_in      : IN std_logic_vector (15 DOWNTO 0) := (OTHERS => '0');
                        
    cmudividerdprioin : IN std_logic_vector (29 DOWNTO 0)   := (OTHERS => '0');
    cmuplldprioin     : IN std_logic_vector (119 DOWNTO 0)  := (OTHERS => '0');
    cmudprioin        : IN std_logic_vector (29 DOWNTO 0)   := (OTHERS => '0');
    refclkdividerdprioin : IN std_logic_vector (1 DOWNTO 0) := (OTHERS => '0');
    rxdprioin         : IN std_logic_vector (799 DOWNTO 0)  := (OTHERS => '0');
    txdprioin         : IN std_logic_vector (399 DOWNTO 0)  := (OTHERS => '0');
           
    cmudividerdprioout : OUT std_logic_vector (29 DOWNTO 0);
    cmuplldprioout     : OUT std_logic_vector (119 DOWNTO 0);
    cmudprioout        : OUT std_logic_vector (29 DOWNTO 0);
    refclkdividerdprioout : OUT std_logic_vector (1 DOWNTO 0);
    rxdprioout         : OUT std_logic_vector (799 DOWNTO 0);
    txdprioout         : OUT std_logic_vector (399 DOWNTO 0);
            		            
    mbus_out           : OUT std_logic_vector (15 DOWNTO 0));
END stratixiigx_hssi_cmu_dprio_reg;           

ARCHITECTURE dprio_reg_arch OF stratixiigx_hssi_cmu_dprio_reg IS

-- COMPONENTS begin  ---------------------------------------------------
COMPONENT mdio_pcs_bus_out_mux
    PORT (
        pcs_ctrl_in1            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in2            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in3            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in4            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in5            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in6            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in7            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in8            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in9            : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in10           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in11           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in12           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in13           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in14           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in15           : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_in16           : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in1     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in2     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in3     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in4     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in5     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in6     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in7     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in8     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in9     : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in10    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in11    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in12    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in13    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in14    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in15    : IN std_logic_vector(15 DOWNTO 0);   
        hw_address_ctrl_in16    : IN std_logic_vector(15 DOWNTO 0);   
        reg_addr                : IN std_logic_vector(15 DOWNTO 0);   
        pcs_ctrl_out            : OUT std_logic_vector(15 DOWNTO 0));   
END COMPONENT;

COMPONENT  bsc_out
	 PORT 
	 ( 
		 clk	    :	IN  STD_LOGIC;
		 jtag_mode	:	IN  STD_LOGIC;
		 reset	    :	IN  STD_LOGIC;
		 shift_load	:	IN  STD_LOGIC;
		 si	        :	IN  STD_LOGIC;
		 sig_in	    :	IN  STD_LOGIC;
		 sig_out	:	OUT  STD_LOGIC;
		 so	        :	OUT  STD_LOGIC
	 ); 
END COMPONENT;

COMPONENT bsc_in_r
    PORT (
        -- synthesis ALTERA_ATTRIBUTE="{-to so} POWER_UP_LEVEL=LOW" 
        reset                   : IN std_logic;   --  reset
        clk                     : IN std_logic;   --  clock
        sig_in                  : IN std_logic;   --  signal input
        ext_in                  : IN std_logic;   --  external input port
        jtag_mode               : IN std_logic;   
        si                      : IN std_logic;   --  scan input
        shift                   : IN std_logic;   --  1'b1=shift in data from si into scan flop
                                                  -- '0'=load data from sig_in into scan flop

        mdio_dis                : IN std_logic;   --  1'b1=choose ext_in to the sig_out mux
                                                  -- '0'=choose so to the sign_out mux

        sig_out                 : OUT std_logic;   --  signal output
        so                      : OUT std_logic);  --  scan output
END COMPONENT;

COMPONENT ctrl_reg
    PORT (
        reset                   : IN std_logic;   --  reset
        mdio_wr                 : IN std_logic;   
        reg_addr                : IN std_logic_vector(15 DOWNTO 0);   
        target_addr             : IN std_logic_vector(15 DOWNTO 0);   
        clk                     : IN std_logic;   --  clock
        sig_in                  : IN std_logic_vector(15 DOWNTO 0);   --  signal input
        ext_in                  : IN std_logic_vector(15 DOWNTO 0);   --  external port input
        jtag_mode               : IN std_logic;   
        si                      : IN std_logic;   --  scan input
        shift                   : IN std_logic;   --  1'b1=shift in data from si into scan flop
                                                  --  '0'=load data from sig_in into scan flop

        mdio_dis                : IN std_logic;   
                                                 -- 1'b1=output CRAM
                                                 -- '0'=output MDIO control register

        sig_out                 : OUT std_logic_vector(15 DOWNTO 0);   --  signal output
        so                      : OUT std_logic);   --  scan output
END COMPONENT;

-- COMPONENTS end  ---------------------------------------------------

SIGNAL my_gnd                   : std_logic := '0';
SIGNAL my_vcc                   : std_logic := '1';

-------------------------------------------------------------------------------
-- DPRIO INDEX TABLE ----------------------------------------------------------
-------------------------------------------------------------------------------

-- make sure indices with _DP_ in the middle to distiguish from rx/tx
constant rclk_1_sel_DP_RX_IDX_0     : integer := 10;
constant rclk_1_sel_DP_RX_IDX_1     : integer := 11;
constant rclk_2_sel_DP_RX_IDX_0     : integer := 12;
constant rclk_2_sel_DP_RX_IDX_1     : integer := 13;
constant rrcvd_clk_sel_DP_RX_IDX_0  : integer := 14;
constant rrcvd_clk_sel_DP_RX_IDX_1  : integer := 15;
-- make sure indices with _DP_ in the middle to distiguish from rx/tx

-- name twists between WYSIWYG and RTL ----------------------------------------
SIGNAL jtag_shift_load : std_logic;      -- in

-- un-supported ports - turning into wires ------------------------------------
-- inputs get initialized appropriately

-- JTAG inputs/outputs
SIGNAL          jtag_mode : std_logic := '0';            -- in
SIGNAL          jtag_si : std_logic := 'X';              -- in
     
SIGNAL         jtag_so : std_logic;               -- out

-- input - status signals generated by PCS
SIGNAL          tx_local_fault : std_logic := '0';        -- from tx_sm
SIGNAL          rx_local_fault : std_logic := '0';        -- from rcv_sm
SIGNAL          xs_link_status : std_logic := '0';        -- from rcv_sm

-- ouptut
SIGNAL         local_fault_ext : std_logic;       -- Status signal wire
SIGNAL         xs_link_status_ext : std_logic;    -- Status signal wire
SIGNAL         rx_local_fault_ext : std_logic;    -- Status signal wire
SIGNAL         tx_local_fault_ext : std_logic;    -- Status signal wire

-- Unused CRAMs
SIGNAL          rxs_link_status_set : std_logic;        -- in
SIGNAL          rtx_rx_local_fault_clr : std_logic;     -- in

SIGNAL         rxs_link_status_set_int : std_logic;     -- out
SIGNAL         rtx_rx_local_fault_clr_int : std_logic;  -- out

------------------------------------------------------------------------------------------------------
--              Beginning of named CRAMs                                                            --
------------------------------------------------------------------------------------------------------

-- TX PCS CRAMs wire from CSR ----------------------------------------------------------------------
SIGNAL   rpowdnt :  std_logic_vector (3 DOWNTO 0);               -- TX channel power down CRAM
SIGNAL   rtxurstpcs :  std_logic_vector (3 DOWNTO 0);            -- Gated CRAM for TXURSTPCS
SIGNAL   rbisten_tx :  std_logic_vector (3 DOWNTO 0);               -- ENBIST CRAM
SIGNAL   rrev_loopbk  :  std_logic_vector (3 DOWNTO 0);	      -- CRAM - Enable dynamic Reverse, PIPE mode
SIGNAL   rforce_disp    :  std_logic_vector (3 DOWNTO 0);	      -- Acting with TXD[9, 19] forces current disparity to 1 or 0
SIGNAL   rib_force_disp :  std_logic_vector (3 DOWNTO 0);        -- Disparity force CRAM in IB mode
SIGNAL   rforce_echar :  std_logic_vector (3 DOWNTO 0);          -- Force /E/ char CRAM
SIGNAL   rforce_kchar :  std_logic_vector (3 DOWNTO 0);          -- Force /K/ char CRAM
SIGNAL   rendec_tx :  std_logic_vector (3 DOWNTO 0);             -- Enable 8B/10B encoder CRAM
SIGNAL   rge_xaui_tx :  std_logic_vector (3 DOWNTO 0);           -- GIGE Idle test enable CRAM
SIGNAL   rdwidth_tx :  std_logic_vector (3 DOWNTO 0);            -- TX parallel interface data width CRAM
SIGNAL   rtxfifo_dis :  std_logic_vector (3 DOWNTO 0);           -- TX FIFO disable CRAM
SIGNAL   rcascaded_8b10b_en_tx :  std_logic_vector (3 DOWNTO 0); -- Caascaded 8b/10b encoder enable CRAM
SIGNAL   rprbsen_tx :  std_logic_vector (3 DOWNTO 0);            -- PRBS generator enable CRAM
SIGNAL   rprbs_sel_ch0 :  std_logic_vector (2 DOWNTO 0);         -- PRBS selection CRAM
SIGNAL   rprbs_sel_ch1 :  std_logic_vector (2 DOWNTO 0);         -- PRBS selection CRAM
SIGNAL   rprbs_sel_ch2 :  std_logic_vector (2 DOWNTO 0);         -- PRBS selection CRAM
SIGNAL   rprbs_sel_ch3 :  std_logic_vector (2 DOWNTO 0);         -- PRBS selection CRAM
SIGNAL   rbist_sel_ch0 :  std_logic_vector (1 DOWNTO 0);         -- BIST selection CRAM
SIGNAL   rbist_sel_ch1 :  std_logic_vector (1 DOWNTO 0);         -- BIST selection CRAM
SIGNAL   rbist_sel_ch2 :  std_logic_vector (1 DOWNTO 0);         -- BIST selection CRAM
SIGNAL   rbist_sel_ch3 :  std_logic_vector (1 DOWNTO 0);         -- BIST selection CRAM
SIGNAL   rcxpat_chnl_en_ch0 :  std_logic_vector (1 DOWNTO 0);    -- CRPAT or CJPAT selection CRAM
SIGNAL   rcxpat_chnl_en_ch1 :  std_logic_vector (1 DOWNTO 0);    -- CRPAT or CJPAT selection CRAM
SIGNAL   rcxpat_chnl_en_ch2 :  std_logic_vector (1 DOWNTO 0);    -- CRPAT or CJPAT selection CRAM
SIGNAL   rcxpat_chnl_en_ch3 :  std_logic_vector (1 DOWNTO 0);    -- CRPAT or CJPAT selection CRAM
SIGNAL   renpolinv_tx :  std_logic_vector (3 DOWNTO 0);          -- TX Polarity inversion enable CRAM
SIGNAL   rphfifopldentx :  std_logic_vector (3 DOWNTO 0);        -- TX phase comp. FIFO PLD read/write enable CRAM
SIGNAL   rphfifoursttx :  std_logic_vector (3 DOWNTO 0);         -- TX phase comp. FIFO user reset enable CRAM
SIGNAL   rfreerun_tx :  std_logic_vector (3 DOWNTO 0);           -- TX_CLK out free running during TX PCS reset enable CRAM
SIGNAL   rtxwrclksel :  std_logic_vector (3 DOWNTO 0);           -- TX FIFO write clock selection CRAM
SIGNAL   rtxrdclksel :  std_logic_vector (3 DOWNTO 0);           -- TX FIFO read clock selection CRAM
SIGNAL   rtx_pipe_enable :  std_logic_vector (3 DOWNTO 0);       -- TX PIPE interface enable CRAM
SIGNAL   renbitrev_tx :  std_logic_vector (3 DOWNTO 0);          -- TX bit reversal enable CRAM
SIGNAL   rensymswap_tx :  std_logic_vector (3 DOWNTO 0);         -- TX symbol swap enable CRAM
SIGNAL   r8b10b_enc_ibm_en :  std_logic_vector (3 DOWNTO 0);     -- 8B10B Encoder fix enable CRAM
SIGNAL   rtxfifo_lowlatency_en :  std_logic_vector (3 DOWNTO 0); -- TX FIFO low latency enable CRAM
SIGNAL   rtx_idle_delay_ch0 :  std_logic_vector (1 DOWNTO 0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL   rtx_idle_delay_ch1 :  std_logic_vector (1 DOWNTO 0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL   rtx_idle_delay_ch2 :  std_logic_vector (1 DOWNTO 0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL   rtx_idle_delay_ch3 :  std_logic_vector (1 DOWNTO 0);    -- PIPE TxElecIdle delay value CRAM

-- TX PCS CRAMs outputs to TX PCS : ending with _int --------------------------------------------------------------

-- TX PMA CRAMs --------------------------------------------------------------------------------
SIGNAL    rpmadwidth_tx :  std_logic_vector (3 DOWNTO 0);         -- TX PCS to TX PMA data width selection CRAM
SIGNAL    rpma_doublewidth_tx :  std_logic_vector (3 DOWNTO 0);   -- PCS/PMA double width (16/20) selection CRAM
SIGNAL    rtx_term_ch0 :  std_logic_vector (1 DOWNTO 0);          -- TX output buffer termination select CRAMs
SIGNAL    rtx_term_ch1 :  std_logic_vector (1 DOWNTO 0);          -- TX output buffer termination select CRAMs
SIGNAL    rtx_term_ch2 :  std_logic_vector (1 DOWNTO 0);          -- TX output buffer termination select CRAMs
SIGNAL    rtx_term_ch3 :  std_logic_vector (1 DOWNTO 0);          -- TX output buffer termination select CRAMs
SIGNAL    rtx_vod_sel_ch0 :  std_logic_vector (2 DOWNTO 0);       -- TX output buffer Vod switching control CRAMs
SIGNAL    rtx_vod_sel_ch1 :  std_logic_vector (2 DOWNTO 0);       -- TX output buffer Vod switching control CRAMs
SIGNAL    rtx_vod_sel_ch2 :  std_logic_vector (2 DOWNTO 0);       -- TX output buffer Vod switching control CRAMs
SIGNAL    rtx_vod_sel_ch3 :  std_logic_vector (2 DOWNTO 0);       -- TX output buffer Vod switching control CRAMs
SIGNAL    rpmphs_1tap_ch0 :  std_logic_vector (3 DOWNTO 0);       -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL    rpmphs_1tap_ch1 :  std_logic_vector (3 DOWNTO 0);       -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL    rpmphs_1tap_ch2 :  std_logic_vector (3 DOWNTO 0);       -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL    rpmphs_1tap_ch3 :  std_logic_vector (3 DOWNTO 0);       -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL    rtx_slewrate :  std_logic_vector (3 DOWNTO 0);          -- Slew rate control CRAM
SIGNAL    rlst_tx_ch0 :  std_logic_vector (3 DOWNTO 0);           -- Low speed Test selection CRAMs
SIGNAL    rlst_tx_ch1 :  std_logic_vector (3 DOWNTO 0);           -- Low speed Test selection CRAMs
SIGNAL    rlst_tx_ch2 :  std_logic_vector (3 DOWNTO 0);           -- Low speed Test selection CRAMs
SIGNAL    rlst_tx_ch3 :  std_logic_vector (3 DOWNTO 0);           -- Low speed Test selection CRAMs
SIGNAL    rtx_cmu_sel :  std_logic_vector (3 DOWNTO 0);           -- CMU selection CRAM
SIGNAL    rtx_m_sel_ch0 :  std_logic_vector (1 DOWNTO 0);         -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL    rtx_m_sel_ch1 :  std_logic_vector (1 DOWNTO 0);         -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL    rtx_m_sel_ch2 :  std_logic_vector (1 DOWNTO 0);         -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL    rtx_m_sel_ch3 :  std_logic_vector (1 DOWNTO 0);         -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL    rtxvcobypass :  std_logic_vector (3 DOWNTO 0);          -- TX VCO bypass CRAM
SIGNAL    rtx_cgb_1x_en :  std_logic_vector (3 DOWNTO 0);         -- Single CLKGENBUF mode enable CRAM
SIGNAL    rtx_cgb_4x_en :  std_logic_vector (3 DOWNTO 0);         -- Quad CLKGENBUF mode enable CRAM
SIGNAL    rtx_4x_sw :  std_logic_vector (3 DOWNTO 0);   	      -- Xaui mode (CPULSE aligned across 4 channels) selection CRAM
SIGNAL    rsig_inv_2tap :  std_logic_vector (3 DOWNTO 0);         -- Pre-emphasis FIR-tap selection CRAM
SIGNAL    rpmphs_ptap_ch0 :  std_logic_vector (2 DOWNTO 0);       -- Control CRAM
SIGNAL    rpmphs_ptap_ch1 :  std_logic_vector (2 DOWNTO 0);       -- Control CRAM
SIGNAL    rpmphs_ptap_ch2 :  std_logic_vector (2 DOWNTO 0);       -- Control CRAM
SIGNAL    rpmphs_ptap_ch3 :  std_logic_vector (2 DOWNTO 0);       -- Control CRAM
SIGNAL    rtx_cgb_pdb :  std_logic_vector (3 DOWNTO 0);           -- Power down (bar) CRAM for CLKGENBUF6G
SIGNAL    rtx_ob_pdb :  std_logic_vector (3 DOWNTO 0);            -- Power down (bar) CRAM for output buffer
SIGNAL    r_tx_det_rx_ch0 :  std_logic_vector (1 DOWNTO 0);       -- RX Detect block CRAMs
SIGNAL    r_tx_det_rx_ch1 :  std_logic_vector (1 DOWNTO 0);       -- RX Detect block CRAMs
SIGNAL    r_tx_det_rx_ch2 :  std_logic_vector (1 DOWNTO 0);       -- RX Detect block CRAMs
SIGNAL    r_tx_det_rx_ch3 :  std_logic_vector (1 DOWNTO 0);       -- RX Detect block CRAMs
SIGNAL    rpmphs_2tap_ch0 :  std_logic_vector (2 DOWNTO 0);       -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL    rpmphs_2tap_ch1 :  std_logic_vector (2 DOWNTO 0);       -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL    rpmphs_2tap_ch2 :  std_logic_vector (2 DOWNTO 0);       -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL    rpmphs_2tap_ch3 :  std_logic_vector (2 DOWNTO 0);       -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL    rtx_vtt_ch0 :  std_logic_vector (1 DOWNTO 0);           -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL    rtx_vtt_ch1 :  std_logic_vector (1 DOWNTO 0);           -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL    rtx_vtt_ch2 :  std_logic_vector (1 DOWNTO 0);           -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL    rtx_vtt_ch3 :  std_logic_vector (1 DOWNTO 0);           -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL    rsig_inv_pre :  std_logic_vector (3 DOWNTO 0);          -- Enable CRAM for SIG_INV_PRE dynamic control signal
SIGNAL    rrsvd_tx_ch0 :  std_logic_vector (4 DOWNTO 0);          -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL    rrsvd_tx_ch1 :  std_logic_vector (4 DOWNTO 0);          -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL    rrsvd_tx_ch2 :  std_logic_vector (4 DOWNTO 0);          -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL    rrsvd_tx_ch3 :  std_logic_vector (4 DOWNTO 0);          -- Rerserved CRAMs for both TX PCS and TX PMA

-- TX PMA CRAMs outputs to TX PMAs ending with _int  ------------------------------------------------------

-- RX PCS CRAMs -------------------------------------------------------------------------------------------------------
SIGNAL    rskpsetbased :  std_logic_vector (3 DOWNTO 0);          -- Enable rate matching for PCI-E/PIPE, other standards based on COMMA DEL DEL..
SIGNAL    rtruebac2bac :  std_logic_vector (3 DOWNTO 0);          -- Enabled (high) for all standards except PIPE. Back to back rate match enable.
SIGNAL    ralfull_ch0 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost full goes high	
SIGNAL    ralempty_ch0 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost empty goes high
SIGNAL    ralfull_ch1 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost full goes high	
SIGNAL    ralempty_ch1 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost empty goes high
SIGNAL    ralfull_ch2 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost full goes high	
SIGNAL    ralempty_ch2 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost empty goes high
SIGNAL    ralfull_ch3 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost full goes high	
SIGNAL    ralempty_ch3 :  std_logic_vector (3 DOWNTO 0);	      -- CRAM bits - Program when almost empty goes high
SIGNAL    rcmpfifourst :  std_logic_vector (3 DOWNTO 0);          -- Enable cmpfifourst
SIGNAL    rphfifourstrx :  std_logic_vector (3 DOWNTO 0);         -- Enable phfifourst_rx
SIGNAL    rpowdnr :  std_logic_vector (3 DOWNTO 0);               -- RX channel power down CRAM
SIGNAL    rrxurstpcs :  std_logic_vector (3 DOWNTO 0);            -- Gated CRAM for RXURSTPCS
SIGNAL    rcomp_size_ch0 :  std_logic_vector (2 DOWNTO 0);        -- Pattern comparision length CRAMs
SIGNAL    rcomp_size_ch1 :  std_logic_vector (2 DOWNTO 0);        -- Pattern comparision length CRAMs
SIGNAL    rcomp_size_ch2 :  std_logic_vector (2 DOWNTO 0);        -- Pattern comparision length CRAMs
SIGNAL    rcomp_size_ch3 :  std_logic_vector (2 DOWNTO 0);        -- Pattern comparision length CRAMs
SIGNAL    rcomp_pat_ch0 :  std_logic_vector (39 DOWNTO 0);         -- Sync pattern CRAMs
SIGNAL    rcomp_pat_ch1 :  std_logic_vector (39 DOWNTO 0);         -- Sync pattern CRAMs
SIGNAL    rcomp_pat_ch2 :  std_logic_vector (39 DOWNTO 0);         -- Sync pattern CRAMs
SIGNAL    rcomp_pat_ch3 :  std_logic_vector (39 DOWNTO 0);         -- Sync pattern CRAMs
SIGNAL    rrundisp_ch0 :  std_logic_vector (5 DOWNTO 0);          -- Run lengh violation setting CRAMs
SIGNAL    rrundisp_ch1 :  std_logic_vector (5 DOWNTO 0);          -- Run lengh violation setting CRAMs
SIGNAL    rrundisp_ch2 :  std_logic_vector (5 DOWNTO 0);          -- Run lengh violation setting CRAMs
SIGNAL    rrundisp_ch3 :  std_logic_vector (5 DOWNTO 0);          -- Run lengh violation setting CRAMs
SIGNAL    rib_inv_cd_ch0 :  std_logic_vector (1 DOWNTO 0);        -- Invalid code setting CRAMs for IB
SIGNAL    rib_inv_cd_ch1 :  std_logic_vector (1 DOWNTO 0);        -- Invalid code setting CRAMs for IB
SIGNAL    rib_inv_cd_ch2 :  std_logic_vector (1 DOWNTO 0);        -- Invalid code setting CRAMs for IB
SIGNAL    rib_inv_cd_ch3 :  std_logic_vector (1 DOWNTO 0);        -- Invalid code setting CRAMs for IB
SIGNAL    rrlv_en :  std_logic_vector (3 DOWNTO 0);               -- RLV enable CRAM
SIGNAL    rsync_sm_dis :  std_logic_vector (3 DOWNTO 0);          -- GIGE/XAUI Sync SM disable CRAM
SIGNAL    rautobtalg_dis :  std_logic_vector (3 DOWNTO 0);        -- BITSLIP mode enable CRAM
SIGNAL    rdis_rx_disp :  std_logic_vector (3 DOWNTO 0);          -- Receive running disparity calculation disable CRAM
SIGNAL    rmatchen :  std_logic_vector (3 DOWNTO 0);              -- Clock compensation enable CRAM
SIGNAL    rgenericfifo :  std_logic_vector (3 DOWNTO 0);          -- GenericFIFO mode enable CRAM
SIGNAL    rendec_rx :  std_logic_vector (3 DOWNTO 0);             -- 10B/8B decoder enable CRAM
SIGNAL    rdwidth_rx :  std_logic_vector (3 DOWNTO 0);            -- RX parallel interface data width selection CRAM
SIGNAL    rlp20ben :  std_logic_vector (3 DOWNTO 0);              -- 20-b loopback enable CRAM
SIGNAL    rrxfifo_dis :  std_logic_vector (3 DOWNTO 0);           -- RX FIFO bypassing CRAM
SIGNAL    renumber_ch0 :  std_logic_vector (2 DOWNTO 0);          -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL    renumber_ch1 :  std_logic_vector (2 DOWNTO 0);          -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL    renumber_ch2 :  std_logic_vector (2 DOWNTO 0);          -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL    renumber_ch3 :  std_logic_vector (2 DOWNTO 0);          -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL    rknumber_ch0 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL    rknumber_ch1 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL    rknumber_ch2 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL    rknumber_ch3 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL    renpolinv_rx :  std_logic_vector (3 DOWNTO 0);          -- Allow polarity inversion
SIGNAL    rgnumber_ch0 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL    rgnumber_ch1 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL    rgnumber_ch2 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL    rgnumber_ch3 :  std_logic_vector (7 DOWNTO 0);          -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL    rclkcmpsqmd :  std_logic_vector (3 DOWNTO 0);           -- How many characters to match
SIGNAL    rclkcmpsq1p_ch0 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL    rclkcmpsq1p_ch1 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL    rclkcmpsq1p_ch2 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL    rclkcmpsq1p_ch3 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL    rclkcmpsq1n_ch0 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL    rclkcmpsq1n_ch1 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL    rclkcmpsq1n_ch2 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL    rclkcmpsq1n_ch3 :  std_logic_vector (19 DOWNTO 0);       -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL    rclkcmppos :  std_logic_vector (3 DOWNTO 0);            -- Match only the pos disp. sequence 
SIGNAL    rosnumber_ch0 :  std_logic_vector (1 DOWNTO 0);         -- Length of the ordered set
SIGNAL    rosnumber_ch1 :  std_logic_vector (1 DOWNTO 0);         -- Length of the ordered set
SIGNAL    rosnumber_ch2 :  std_logic_vector (1 DOWNTO 0);         -- Length of the ordered set
SIGNAL    rosnumber_ch3 :  std_logic_vector (1 DOWNTO 0);         -- Length of the ordered set
SIGNAL    rosbased :  std_logic_vector (3 DOWNTO 0);              -- Enable ordered-set based algorithm
SIGNAL    rkchar :  std_logic_vector (3 DOWNTO 0);                -- use kchar at cg_bad logic calculation
SIGNAL    rcascaded_8b10b_en_rx :  std_logic_vector (3 DOWNTO 0); -- Cascaded 8B/10B decoder enable CRAM
SIGNAL    resync_badcg_en_ch0 :  std_logic_vector (1 DOWNTO 0);   --
SIGNAL    resync_badcg_en_ch1 :  std_logic_vector (1 DOWNTO 0);   --
SIGNAL    resync_badcg_en_ch2 :  std_logic_vector (1 DOWNTO 0);   --
SIGNAL    resync_badcg_en_ch3 :  std_logic_vector (1 DOWNTO 0);   --
SIGNAL    rencdt_rising :  std_logic_vector (3 DOWNTO 0);         -- encdt on rising edge enable CRAM
SIGNAL    rcomp_pat_porn :  std_logic_vector (3 DOWNTO 0);        -- Positive and negative match enable CRAM
SIGNAL    rprbsen_rx :  std_logic_vector (3 DOWNTO 0);            -- PRBS Verifier enable CRAM
SIGNAL    rprbs_clr_rslt_rx :  std_logic_vector (3 DOWNTO 0);     -- PRBS pass/fail flag clear CRAM
SIGNAL    rbisten_rx :  std_logic_vector (3 DOWNTO 0);            -- BIST Verifier enable CRAM
SIGNAL    rbist_clr_rx :  std_logic_vector (3 DOWNTO 0);          -- BIST pass/fail flag clear CRAM
SIGNAL    rwa_6g_en :  std_logic_vector (3 DOWNTO 0);             -- 6G word alignment enable CRAM
SIGNAL    rbitslip_size_ch0 :  std_logic_vector (1 DOWNTO 0);     -- BITSLIP size selection CRAM
SIGNAL    rbitslip_size_ch1 :  std_logic_vector (1 DOWNTO 0);     -- BITSLIP size selection CRAM
SIGNAL    rbitslip_size_ch2 :  std_logic_vector (1 DOWNTO 0);     -- BITSLIP size selection CRAM
SIGNAL    rbitslip_size_ch3 :  std_logic_vector (1 DOWNTO 0);     -- BITSLIP size selection CRAM
SIGNAL    rbytord_2sym_en :  std_logic_vector (3 DOWNTO 0);       -- Enable 2 symbols byte orderring CRAM
SIGNAL    rbysync_polinv_en :  std_logic_vector (3 DOWNTO 0);     -- Word alignment polarity inversion enable CRAM
SIGNAL    rbitloc_rev_en :  std_logic_vector (3 DOWNTO 0);        -- Bit reversal enable CRAM
SIGNAL    rbyte_rev_en :  std_logic_vector (3 DOWNTO 0);          -- Byte swap enable CRAM
SIGNAL    rbyteorden_ch0 :  std_logic_vector (1 DOWNTO 0);        -- Byte ordering enable CRAM
SIGNAL    rbyteorden_ch1 :  std_logic_vector (1 DOWNTO 0);        -- Byte ordering enable CRAM
SIGNAL    rbyteorden_ch2 :  std_logic_vector (1 DOWNTO 0);        -- Byte ordering enable CRAM
SIGNAL    rbyteorden_ch3 :  std_logic_vector (1 DOWNTO 0);        -- Byte ordering enable CRAM
SIGNAL    rbytordplden :  std_logic_vector (3 DOWNTO 0);          -- PLD control signal BYTEORDPLD enable CRAM
SIGNAL    rphfifopldenrx :  std_logic_vector (3 DOWNTO 0);        -- RX phase comp. FIFO read/write enable CRAM
SIGNAL    rautoinsdis :  std_logic_vector (3 DOWNTO 0);           -- Disable CRAM for auto insertion of 8'h9C
SIGNAL    rppmsel_ch0 :  std_logic_vector (5 DOWNTO 0);           -- Programmable PPM ajustment CRAM
SIGNAL    rppmsel_ch1 :  std_logic_vector (5 DOWNTO 0);           -- Programmable PPM ajustment CRAM
SIGNAL    rppmsel_ch2 :  std_logic_vector (5 DOWNTO 0);           -- Programmable PPM ajustment CRAM
SIGNAL    rppmsel_ch3 :  std_logic_vector (5 DOWNTO 0);           -- Programmable PPM ajustment CRAM
SIGNAL    rforce0_freqdet :  std_logic_vector (3 DOWNTO 0);       -- Forcing FREQDET signal to low CRAM
SIGNAL    rforce1_freqdet :  std_logic_vector (3 DOWNTO 0);       -- Forcing FREQDET signal to high CRAM
SIGNAL    rbytordpat_ch0 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pattern CRAM
SIGNAL    rbytordpat_ch1 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pattern CRAM
SIGNAL    rbytordpat_ch2 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pattern CRAM
SIGNAL    rbytordpat_ch3 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pattern CRAM
SIGNAL    rbytordpad_ch0 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pad pattern CRAM
SIGNAL    rbytordpad_ch1 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pad pattern CRAM
SIGNAL    rbytordpad_ch2 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pad pattern CRAM
SIGNAL    rbytordpad_ch3 :  std_logic_vector (9 DOWNTO 0);        -- Byte ordering pad pattern CRAM
SIGNAL    rforce_sig_det_pcs :  std_logic_vector (3 DOWNTO 0);    -- Forcing sigdet to high in PCS CRAM
SIGNAL    rfreerun_rx :  std_logic_vector (3 DOWNTO 0);           -- RX_CLK out free running during RX PCS reset enable CRAM
SIGNAL    rrcvd_clk_sel_ch0 :  std_logic_vector (1 DOWNTO 0);     -- RCVD_CLK domain selection CRAM
SIGNAL    rrcvd_clk_sel_ch1 :  std_logic_vector (1 DOWNTO 0);     -- RCVD_CLK domain selection CRAM
SIGNAL    rrcvd_clk_sel_ch2 :  std_logic_vector (1 DOWNTO 0);     -- RCVD_CLK domain selection CRAM
SIGNAL    rrcvd_clk_sel_ch3 :  std_logic_vector (1 DOWNTO 0);     -- RCVD_CLK domain selection CRAM
SIGNAL    rclk_1_sel_ch0 :  std_logic_vector (1 DOWNTO 0);        -- CLK_1 domain selection CRAM
SIGNAL    rclk_1_sel_ch1 :  std_logic_vector (1 DOWNTO 0);        -- CLK_1 domain selection CRAM
SIGNAL    rclk_1_sel_ch2 :  std_logic_vector (1 DOWNTO 0);        -- CLK_1 domain selection CRAM
SIGNAL    rclk_1_sel_ch3 :  std_logic_vector (1 DOWNTO 0);        -- CLK_1 domain selection CRAM
SIGNAL    rclk_2_sel_ch0 :  std_logic_vector (1 DOWNTO 0);        -- CLK_2 domain selection CRAM
SIGNAL    rclk_2_sel_ch1 :  std_logic_vector (1 DOWNTO 0);        -- CLK_2 domain selection CRAM
SIGNAL    rclk_2_sel_ch2 :  std_logic_vector (1 DOWNTO 0);        -- CLK_2 domain selection CRAM
SIGNAL    rclk_2_sel_ch3 :  std_logic_vector (1 DOWNTO 0);        -- CLK_2 domain selection CRAM
SIGNAL    rrx_rd_clk_sel :  std_logic_vector (3 DOWNTO 0);        -- RX FIFO read clock selection CRAM
SIGNAL    rrx_pipe_enable :  std_logic_vector (3 DOWNTO 0);       -- RX PIPE interface enable CRAM
SIGNAL    rall_one_dect_only :  std_logic_vector (3 DOWNTO 0);    -- PRBS Verifier detect all one only enable CRAM
SIGNAL    rtest_bus_sel_ch0 :  std_logic_vector (2 DOWNTO 0);     -- Per channel test bus selection CRAMs
SIGNAL    rtest_bus_sel_ch1 :  std_logic_vector (2 DOWNTO 0);     -- Per channel test bus selection CRAMs
SIGNAL    rtest_bus_sel_ch2 :  std_logic_vector (2 DOWNTO 0);     -- Per channel test bus selection CRAMs
SIGNAL    rtest_bus_sel_ch3 :  std_logic_vector (2 DOWNTO 0);     -- Per channel test bus selection CRAMs
SIGNAL    r8b10b_dec_ibm_en_ch0 :  std_logic_vector (1 DOWNTO 0); -- 8B10B Decoder fix enable CRAM
SIGNAL    r8b10b_dec_ibm_en_ch1 :  std_logic_vector (1 DOWNTO 0); -- 8B10B Decoder fix enable CRAM
SIGNAL    r8b10b_dec_ibm_en_ch2 :  std_logic_vector (1 DOWNTO 0); -- 8B10B Decoder fix enable CRAM
SIGNAL    r8b10b_dec_ibm_en_ch3 :  std_logic_vector (1 DOWNTO 0); -- 8B10B Decoder fix enable CRAM
SIGNAL    rrxfifo_lowlatency_en :  std_logic_vector (3 DOWNTO 0); -- RX FIFO low latency enable CRAM
SIGNAL    rppm_cnt_reset :  std_logic_vector (3 DOWNTO 0);        -- PPM counter reset CRAM (latched version on Test bus)
SIGNAL    rrx_detect_bypass :  std_logic_vector (3 DOWNTO 0);     -- PMA RX detection bypass enable CRAM
SIGNAL    rclkcmpinsertpad :  std_logic_vector (3 DOWNTO 0);      -- Rate matching pad insertion enable CRAM

-- RX PCS CRAMs outputs to RX PCS -------------------------------------------------------------------------------------

-- RX PMA CRAMs ----------------------------------------------------------------------------------
SIGNAL rpmadwidth_rx        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- RX PMA to RX PCS data width sel CRAMs
SIGNAL rpma_doublewidth_rx  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- RX PMA/PCS double width (16/20) sel CRAM
SIGNAL rrx_sloslv_ch0       : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch1       : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch2       : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch3       : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Signal loss threshold select CRAMs
SIGNAL rrx_term_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RX input buffer termination select CRAMs
SIGNAL rrxvcobypass         : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- RX VCO bypass CRAM
SIGNAL rbwctral_rx_ch0      : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch1      : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch2      : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch3      : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RX PLL loop filter bandwidth control CRAMs
SIGNAL rforce_sigdet        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- SIGDET forcing CRAM
SIGNAL rrefclk_sel_ch0      : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch1      : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch2      : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch3      : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- RXPLL alternative clock source selection CRAMs
SIGNAL rs_lpbk              : STD_LOGIC_VECTOR(3   DOWNTO   0);		      -- Serial loopback CRAM
SIGNAL r_rlpbk              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Reverse serial loopback CRAM for RX channel
SIGNAL rs_rdlpbk            : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Serial reversed diagnostic loopback CRAM
SIGNAL rrx_revlb_sw         : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Reverse loopback switch CRAM
SIGNAL risel_rx_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- RXPLL charge pump current control CRAM
SIGNAL riupsel_rx_ch0       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch1       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch2       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch3       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL ridnsel_rx_ch0       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch1       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch2       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch3       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL rtesten_cp_rx        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Charge pump test mode control CRAM in RXPLL
SIGNAL rtristate_cp_rx      : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Charge pump tristate control CRAM in RXPLL
SIGNAL rtestupen_cp_rx      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Charge pump current test control CRAM in RXPLL
SIGNAL rtestdnen_cp_rx      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Charge pump current test control CRAM in RXPLL
SIGNAL rrx_vtt_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);	      -- Programmable termination voltage setting CRAM
SIGNAL rlst_rx_ch0          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rx_ch1          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rx_ch2          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rx_ch3          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch0       : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch1       : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch2       : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch3       : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rltr                 : STD_LOGIC_VECTOR(3   DOWNTO   0);		      -- Lock to reference clock enable CRAM
SIGNAL rltd                 : STD_LOGIC_VECTOR(3   DOWNTO   0);		      -- Lock to received data enable CRAM
SIGNAL rrx_cru_m_ch0        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M control CRAM
SIGNAL rrx_cru_m_ch1        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M control CRAM
SIGNAL rrx_cru_m_ch2        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M control CRAM
SIGNAL rrx_cru_m_ch3        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M control CRAM
SIGNAL rrx_cru_l_ch0        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch1        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch2        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch3        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L contrl CRAM
SIGNAL rrx_ignore_phslck    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Ignore phase lock CRAM
SIGNAL rrx_cru_ctl_ch0      : STD_LOGIC_VECTOR(5   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch1      : STD_LOGIC_VECTOR(5   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch2      : STD_LOGIC_VECTOR(5   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch3      : STD_LOGIC_VECTOR(5   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rreg_cp_rx           : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- RX PLL charge pump regulator enable CRAM
SIGNAL rrx_piso_bypass_ch0  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch1  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch2  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch3  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Reference bypass around PISO CRAM
SIGNAL rrx_cru_m_sel_ch0    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch1    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch2    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch3    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_div2         : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Reference clock divided by 2 enable CRAM
SIGNAL rrx_osc_en           : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- CGB RX OSC enable CRAM
SIGNAL rrx_cru_pdb          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Power down (bar) CRAM for CRU
SIGNAL rrx_cru_rst          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Reset CRAM for PLL in CRU
SIGNAL rrx_ib_pdb           : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Power down (bar) for input buffer
SIGNAL rurx_pdb             : STD_LOGIC_VECTOR(3   DOWNTO   0);              -- Enable CRAM for URX_PDB dynamic signal
SIGNAL radce_pdb            : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- Power down for adaptive equalization
SIGNAL radce_rst            : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- Reset CRAM for counters in adaptive engine
SIGNAL rrxurstpma           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Enable CRAM for RXURSTPMA dynamic signal
SIGNAL rrx_dc_couple        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Programmable DC couple CRAM for RX input buffer
SIGNAL rrx_eq_dc_ch0        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch1        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch2        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch3        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- CRAMs for Equalizer block
SIGNAL radce_adapt          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Continuous adaptation enable CRAM
SIGNAL rseq_sel_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Sequence of adaptation selection CRAMs
SIGNAL rrgen_set_ch0        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- D2A control CRAMs
SIGNAL rrgen_set_ch1        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- D2A control CRAMs
SIGNAL rrgen_set_ch2        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- D2A control CRAMs
SIGNAL rrgen_set_ch3        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- D2A control CRAMs
SIGNAL rclkdiv_ch0          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch1          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch2          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch3          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Division ration selection CRAMs for adaptation engine
SIGNAL rf_lpf_ch0           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch1           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch2           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch3           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- LPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch0           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch1           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch2           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch3           : STD_LOGIC_VECTOR(1   DOWNTO   0);            -- HPF corner frequency setting CRAMs
SIGNAL rrgen_bw_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- RGEN corner frequency setting CRAMs
SIGNAL rhyst_ch0            : STD_LOGIC_VECTOR(2   DOWNTO   0);             -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch1            : STD_LOGIC_VECTOR(2   DOWNTO   0);             -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch2            : STD_LOGIC_VECTOR(2   DOWNTO   0);             -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch3            : STD_LOGIC_VECTOR(2   DOWNTO   0);             -- Programmable digital filtering setting CRAMs
SIGNAL rrect_adj_ch0        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch1        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch2        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch3        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- Rectifier leaker current setting CRAMs
SIGNAL rd2a_res_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- D2A resolution settting CRAMs
SIGNAL rrgen_vod_ch0        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch1        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch2        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch3        : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- RGEN amplitude setting CRAMs
SIGNAL rlf_os_ch0           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch1           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch2           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch3           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch0           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch1           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch2           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch3           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- High freq. loop offset cancelling setting CRAMs
SIGNAL reqa_ct_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch0          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch1          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch2          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch3          : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL rdc_freq_ch0         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- ADCE CRAM
SIGNAL rdc_freq_ch1         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- ADCE CRAM
SIGNAL rdc_freq_ch2         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- ADCE CRAM
SIGNAL rdc_freq_ch3         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- ADCE CRAM
SIGNAL r_iqclk_ch0          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- IQCLK selection CRAM
SIGNAL r_iqclk_ch1          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- IQCLK selection CRAM
SIGNAL r_iqclk_ch2          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- IQCLK selection CRAM
SIGNAL r_iqclk_ch3          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- IQCLK selection CRAM
SIGNAL r_dfe_ch0            : STD_LOGIC_VECTOR(5   DOWNTO   0);             -- DFE CRAM
SIGNAL r_dfe_ch1            : STD_LOGIC_VECTOR(5   DOWNTO   0);             -- DFE CRAM
SIGNAL r_dfe_ch2            : STD_LOGIC_VECTOR(5   DOWNTO   0);             -- DFE CRAM
SIGNAL r_dfe_ch3            : STD_LOGIC_VECTOR(5   DOWNTO   0);             -- DFE CRAM
SIGNAL r_cp_mode            : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- CP mode CRAM
SIGNAL r_impctrl_ch0        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- IMPCTRL CRAM
SIGNAL r_impctrl_ch1        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- IMPCTRL CRAM
SIGNAL r_impctrl_ch2        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- IMPCTRL CRAM
SIGNAL r_impctrl_ch3        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- IMPCTRL CRAM
SIGNAL rpd_ien              : STD_LOGIC_VECTOR(3   DOWNTO   0);               -- PD current setting CRAM
SIGNAL rrsvd_rx_ch0         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch1         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch2         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch3         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Rerserved CRAMs for both RX PCS and RX PMA

-- RX PMA CRAM outputs to RX PMAs ----------------------------------------------------------------------

-- CMU PCS CRAMs wire  ----------------------------------------------------------------------
SIGNAL rs_lpbk_all          : STD_LOGIC;           -- Global serial loopback enable CRAM
SIGNAL rindv_tx             : STD_LOGIC;              -- TX SM bypassing CRAM
SIGNAL rindv_rx             : STD_LOGIC;              -- RX SM bypassing CRAM
SIGNAL rdeskewen            : STD_LOGIC;             -- Deskew function enable CRAM
SIGNAL ralgnect             : STD_LOGIC_VECTOR(1   DOWNTO   0);              -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL ralgnact             : STD_LOGIC_VECTOR(2   DOWNTO   0);              -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL ralgngct             : STD_LOGIC_VECTOR(1   DOWNTO   0);              -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL rdskposdisp          : STD_LOGIC;           -- Match the programmed de-skew pattern only
SIGNAL rdskchrp             : STD_LOGIC_VECTOR(9   DOWNTO   0);              -- Programmable Deskew Char. Pos. Disp.
SIGNAL ralgnopt             : STD_LOGIC;              -- De-skew SM Hysteresis Option
SIGNAL rfreerun_centrl      : STD_LOGIC;       -- REFCLK_OUT free running enable CRAM
SIGNAL rcentrl_clk_sel      : STD_LOGIC;       -- REFCLK_PMA global clock selection CRAM
SIGNAL rrefclk_out_div2     : STD_LOGIC;      -- REFCLK_OUT divide by 2 enable CRAM
SIGNAL rtest_bus_centrl_sel : STD_LOGIC_VECTOR(2   DOWNTO   0);  -- Central Test bus selection CRAMs
SIGNAL rendec_data_sel_tx   : STD_LOGIC;    -- TX 8B10B encoder data in selection CRAM
SIGNAL rendec_data_sel_rx   : STD_LOGIC;    -- RX 8B10B decoder data out selection CRAM
SIGNAL rphfifo_master_sel_tx : STD_LOGIC; -- TX Phase comp. FIFO pointers selection CRAM
SIGNAL rphfifo_master_sel_rx : STD_LOGIC; -- TX Phase comp. FIFO pointers selection CRAM

-- CMU PCS CRAMs outputs to CMU
SIGNAL rs_lpbk_all_md       : STD_LOGIC;        -- Output CRAM of RS_LPBK_ALL
                                      
-- RESET, CMU PMA, and CLKREF CRAMs wire  ----------------------------------------------------------------------
SIGNAL rpowerdown           : STD_LOGIC;            -- Quad power down CRAM
SIGNAL rnenbpin             : STD_LOGIC;              -- Gated CRAM for ENPLL pin
SIGNAL rpllurst             : STD_LOGIC;              -- Gated CRAM for PLLURST
SIGNAL rreset               : STD_LOGIC;                -- Quad reset CRAM
SIGNAL rbgbypass            : STD_LOGIC;	      -- Bandgap bypass CRAM
SIGNAL rlst_bg              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Programmable test bus setting CRAM
SIGNAL rcmu_rst             : STD_LOGIC;	      -- Reset CRAM for divider in CMU feedback loop
SIGNAL rcmu_iqclkout_sel    : STD_LOGIC;     -- REFClock select for going to IQ lines CRAM
SIGNAL rcmu0_isel           : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu1_isel           : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu0_iupsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu1_iupsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu0_idnsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu1_idnsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu0_testen_cp      : STD_LOGIC;       -- Charge pump test mode control CRAM in TXPLL0
SIGNAL rcmu1_testen_cp      : STD_LOGIC;       -- Charge pump test mode control CRAM in TXPLL1
SIGNAL rcmu0_tristate_cp    : STD_LOGIC;     -- Charge pump tristate control CRAM in TXPLL0
SIGNAL rcmu1_tristate_cp    : STD_LOGIC;     -- Charge pump tristate control CRAM in TXPLL1
SIGNAL rcmu0_testupen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM in TXPLL0
SIGNAL rcmu1_testupen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM in TXPLL1
SIGNAL rcmu0_lst            : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu1_lst            : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu0_ctl            : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu1_ctl            : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu0_div2           : STD_LOGIC;	      -- Reference clock divided by 2 enable CRAM
SIGNAL rcmu1_div2           : STD_LOGIC;	      -- Reference clock divided by 2 enable CRAM
SIGNAL rcmu0_ref_sel        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Reference selection control CRAM
SIGNAL rcmu1_ref_sel        : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Reference selection control CRAM
SIGNAL rcmu0_m              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Programmable M selection CRAM
SIGNAL rcmu1_m              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Programmable M selection CRAM
SIGNAL rcmu0_l              : STD_LOGIC_VECTOR(1   DOWNTO   0);	              -- Programmable L selection CRAM
SIGNAL rcmu1_l              : STD_LOGIC_VECTOR(1   DOWNTO   0);	              -- Programmable L selection CRAM
SIGNAL rcmu0_pdb            : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu1_pdb            : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu0_txpll_rst      : STD_LOGIC;       -- TXPLL0 reset CRAM
SIGNAL rcmu1_txpll_rst      : STD_LOGIC;       -- TXPLL0 reset CRAM
SIGNAL rcmu0_testdnen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM
SIGNAL rcmu1_testdnen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM
SIGNAL rcmu_peclrx0_cm      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Common mode control CRAM
SIGNAL rcmu_peclrx1_cm      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Common mode control CRAM
SIGNAL rcmu_peclrx0_lst     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Analog test bus setting CRAM
SIGNAL rcmu_peclrx1_lst     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Analog test bus setting CRAM
SIGNAL rcmu_txpll0_1x_en    : STD_LOGIC;     -- 1X enable CRAM in central CGB
SIGNAL rcmu_txpll1_1x_en    : STD_LOGIC;     -- 1X enable CRAM in central CGB
SIGNAL rcmu_txpll0_iqclkin_sel : STD_LOGIC_VECTOR(2   DOWNTO   0);-- IQ clock selection CRAMs
SIGNAL rcmu_txpll1_iqclkin_sel : STD_LOGIC_VECTOR(2   DOWNTO   0);-- IQ clock selection CRAMs
SIGNAL rcmu_cgb_cmusel      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Central CGB CMU selection CRAM
SIGNAL rcmu_cgb_ndiv        : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- N-divider selection CRAM for wire  clock in central CGB
SIGNAL rcmu_cgb_div5        : STD_LOGIC;         -- TX PCS to TX PMA data width selection CRAM
SIGNAL rcmu_cgb_div2        : STD_LOGIC;         -- TX PCS to TX PMA double data width selection CRAM
SIGNAL rcmu_cgb_vcobypass   : STD_LOGIC;    -- CMU VCO bypass CRAM in central CGB
SIGNAL rcmu_cgb_4x_en       : STD_LOGIC;        -- Quad channel mode clock driver enable CRAM
SIGNAL rcmu_cgb_8x_en       : STD_LOGIC;        -- Eight channel mode clock driver enable CRAM
SIGNAL rcmu_cgb_pclksel     : STD_LOGIC;      -- Central CGB PCLK select CRAM
SIGNAL rcmu2_isel           : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu2_iupsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu2_idnsel         : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu2_testen_cp      : STD_LOGIC;       -- Charge pump test mode control CRAM in TXPLL2
SIGNAL rcmu2_tristate_cp    : STD_LOGIC;     -- Charge pump tristate control CRAM in TXPLL2
SIGNAL rcmu2_testupen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM in TXPLL2
SIGNAL rcmu2_testdnen_cp    : STD_LOGIC;     -- Charge pump current test control CRAM in TXPLL2
SIGNAL rcmu2_lst            : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu2_ctl            : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu2_refsel         : STD_LOGIC;          -- Reference select CRAM for CMU2
SIGNAL rcmu2_m              : STD_LOGIC_VECTOR(3   DOWNTO   0);	              -- Programmable M selection CRAM
SIGNAL rcmu2_l              : STD_LOGIC_VECTOR(1   DOWNTO   0);	              -- Programmable L selection CRAM
SIGNAL rcmu2_pdb            : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu2_txpll_rst      : STD_LOGIC;       -- TXPLL2 reset CRAM
SIGNAL rcmu0_rcp_mode       : STD_LOGIC;        -- CMU0 charge pump mode select CRAM
SIGNAL rcmu1_rcp_mode       : STD_LOGIC;        -- CMU1 charge pump mode select CRAM
SIGNAL rpma_testbus_sel     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- PMA testbus selection
SIGNAL rrsvd_cmu            : STD_LOGIC_VECTOR(4   DOWNTO   0);             -- Reserved CRAMs for both PMA CMU and PCS CMU

-- CMU PMA, and CLKREF CRAMs outputs ----------------------------------------------------------------------

-- Output CRAM for Quad reset ----------------------------------------------------------------------
SIGNAL rnenbpin_md          : STD_LOGIC;           -- Output CRAM of RNENBPIN
SIGNAL rpllurst_md          : STD_LOGIC;           -- Output CRAM of RPLLURST
SIGNAL rreset_md            : STD_LOGIC;             -- Output CRAM of RRESET
SIGNAL rpowerdown_md        : STD_LOGIC;         -- Output CRAM of RPOWERDOWN
SIGNAL rrxurstpcs_md        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Output CRAM of RRXURSTPCS
SIGNAL rpowdnr_md           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Output CRAM of RPOWDNR
SIGNAL rtxurstpcs_md        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Output CRAM of RTXURSTPCS
SIGNAL rpowdnt_md           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Output CRAM of RPOWDNT
SIGNAL rrxurstpma_md        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Output CRAM of RRXURSTPMA

------------------------------------------------------------------------------------------------------
--              end of named CRAMs                                                                  --
------------------------------------------------------------------------------------------------------

-- MDIO related wires
SIGNAL chain                : STD_LOGIC_VECTOR(127 DOWNTO   0);
SIGNAL local_fault          : STD_LOGIC;
SIGNAL xs_link_status_rd    : STD_LOGIC;
SIGNAL tx_rx_local_fault_status_rd : STD_LOGIC;
SIGNAL xs_tx_local_fault    : STD_LOGIC;
SIGNAL xs_rx_local_fault    : STD_LOGIC;

-- Control and Status register outputs
SIGNAL xgxs_ctrl_reg        : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL trunking_mode_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch0_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch1_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch2_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch3_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl0_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl1_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl2_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);

SIGNAL pma_ctrl1_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch0_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch1_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch2_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch3_reg    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch0_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch1_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch2_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch3_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl0_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl1_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl2_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl3_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl4_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl5_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl6_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl7_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl8_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl9_reg : STD_LOGIC_VECTOR(15  DOWNTO   0);

SIGNAL xgxs_stat1_reg       : STD_LOGIC_VECTOR(15  DOWNTO   0);    
SIGNAL xgxs_stat2_reg       : STD_LOGIC_VECTOR(15  DOWNTO   0);    
SIGNAL xgxs_lane_stat_reg   : STD_LOGIC_VECTOR(15  DOWNTO   0);

-- External inputs for control registers
SIGNAL xgxs_ctrl_ext        : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL trunking_mode_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl1_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl2_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl3_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl4_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl5_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl6_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl7_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl8_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch0_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch1_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch2_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL prbs_bist_ctrl_ch3_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl9_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl10_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl11_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl12_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl13_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl14_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_ctrl15_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl0_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl1_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pcs_global_ctrl2_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);

SIGNAL pma_ctrl1_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl1_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl2_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl3_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl4_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl5_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl6_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl7_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl8_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch0_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch1_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch2_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl9_ch3_ext    : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl10_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch0_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch1_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch2_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_ctrl11_ch3_ext   : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl0_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl1_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl2_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl3_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl4_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl5_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl6_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl7_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl8_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);
SIGNAL pma_global_ctrl9_ext : STD_LOGIC_VECTOR(15  DOWNTO   0);

-- TX PCS CRAMs wires to TX PCS
SIGNAL rbisten_tx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- ENBIST CRAM
SIGNAL rrev_loopbk_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- CRAM - Enable dynamic Reverse, PIPE mode
SIGNAL rforce_disp_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Acting with TXD[9, 19] forces current disparity to 1 or 0
SIGNAL rib_force_disp_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);    -- Disparity force CRAM in IB mode
SIGNAL rforce_echar_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Force /E/ char CRAM
SIGNAL rforce_kchar_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Force /K/ char CRAM
SIGNAL rendec_tx_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Enable 8B/10B encoder CRAM
SIGNAL rge_xaui_tx_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- GIGE Idle test enable CRAM
SIGNAL rdwidth_tx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- TX parallel interface data width CRAM
SIGNAL rtxfifo_dis_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- TX FIFO disable CRAM
SIGNAL rcascaded_8b10b_en_tx_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- Caascaded 8b/10b encoder enable CRAM
SIGNAL rprbsen_tx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- PRBS generator enable CRAM
SIGNAL rprbs_sel_ch0_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- PRBS selection CRAM
SIGNAL rprbs_sel_ch1_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- PRBS selection CRAM
SIGNAL rprbs_sel_ch2_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- PRBS selection CRAM
SIGNAL rprbs_sel_ch3_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- PRBS selection CRAM
SIGNAL rbist_sel_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- BIST selection CRAM
SIGNAL rbist_sel_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- BIST selection CRAM
SIGNAL rbist_sel_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- BIST selection CRAM
SIGNAL rbist_sel_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);         -- BIST selection CRAM
SIGNAL rcxpat_chnl_en_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- CRPAT or CJPAT selection CRAM
SIGNAL rcxpat_chnl_en_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- CRPAT or CJPAT selection CRAM
SIGNAL rcxpat_chnl_en_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- CRPAT or CJPAT selection CRAM
SIGNAL rcxpat_chnl_en_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- CRPAT or CJPAT selection CRAM
SIGNAL renpolinv_tx_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- TX Polarity inversion enable CRAM
SIGNAL rphfifopldentx_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- TX phase comp. FIFO PLD read/write enable CRAM
SIGNAL rphfifoursttx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- TX phase comp. FIFO user reset enable CRAM
SIGNAL rfreerun_tx_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- TX_CLK out free running during TX PCS reset enable CRAM
SIGNAL rtxwrclksel_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- TX FIFO write clock selection CRAM
SIGNAL rtxrdclksel_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- TX FIFO read clock selection CRAM
SIGNAL rtx_pipe_enable_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- TX PIPE interface enable CRAM
SIGNAL renbitrev_tx_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- TX bit reversal enable CRAM
SIGNAL rensymswap_tx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- TX symbol swap enable CRAM
SIGNAL r8b10b_enc_ibm_en_int : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- 8B10B Encoder fix enable CRAM
SIGNAL rtxfifo_lowlatency_en_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- TX FIFO low latency enable CRAM
SIGNAL rtx_idle_delay_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL rtx_idle_delay_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL rtx_idle_delay_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- PIPE TxElecIdle delay value CRAM
SIGNAL rtx_idle_delay_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- PIPE TxElecIdle delay value CRAM

-- TX PMA CRAMs wires to TX PMAs
SIGNAL rpmadwidth_tx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- TX PCS to TX PMA data width selection CRAM
SIGNAL rpma_doublewidth_tx_int : STD_LOGIC_VECTOR(3   DOWNTO   0);-- PCS/PMA double width (16/20) selection CRAM
SIGNAL rtx_term_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- TX output buffer termination select CRAMs
SIGNAL rtx_term_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- TX output buffer termination select CRAMs
SIGNAL rtx_term_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- TX output buffer termination select CRAMs
SIGNAL rtx_term_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- TX output buffer termination select CRAMs
SIGNAL rtx_vod_sel_ch0_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- TX output buffer Vod switching control CRAMs
SIGNAL rtx_vod_sel_ch1_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- TX output buffer Vod switching control CRAMs
SIGNAL rtx_vod_sel_ch2_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- TX output buffer Vod switching control CRAMs
SIGNAL rtx_vod_sel_ch3_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- TX output buffer Vod switching control CRAMs
SIGNAL rpmphs_1tap_ch0_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL rpmphs_1tap_ch1_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL rpmphs_1tap_ch2_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL rpmphs_1tap_ch3_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- TX output buffer pre-emphasis switching control CRAMs
SIGNAL rtx_slewrate_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Slew rate control CRAM
SIGNAL rlst_tx_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Low speed Test selection CRAMs
SIGNAL rlst_tx_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Low speed Test selection CRAMs
SIGNAL rlst_tx_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Low speed Test selection CRAMs
SIGNAL rlst_tx_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Low speed Test selection CRAMs
SIGNAL rtx_cmu_sel_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- CMU selection CRAM
SIGNAL rtx_m_sel_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL rtx_m_sel_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL rtx_m_sel_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL rtx_m_sel_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Division ratio CRAM selection of output clock in CLKGENBUF
SIGNAL rtxvcobypass_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- TX VCO bypass CRAM
SIGNAL rtx_cgb_1x_en_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Single CLKGENBUF mode enable CRAM
SIGNAL rtx_cgb_4x_en_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Quad CLKGENBUF mode enable CRAM
SIGNAL rtx_4x_sw_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Xaui mode (CPULSE aligned across 4 channels) selection CRAM
SIGNAL rsig_inv_2tap_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Pre-emphasis FIR-tap selection CRAM
SIGNAL rpmphs_ptap_ch0_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Control CRAM
SIGNAL rpmphs_ptap_ch1_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Control CRAM
SIGNAL rpmphs_ptap_ch2_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Control CRAM
SIGNAL rpmphs_ptap_ch3_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Control CRAM
SIGNAL rtx_cgb_pdb_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Power down (bar) CRAM for CLKGENBUF6G
--wire    [3:0]  rtx_piso_pdb_int;      -- Power down (bar) CRAM for PISO
SIGNAL rtx_ob_pdb_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- Power down (bar) CRAM for output buffer
SIGNAL r_tx_det_rx_ch0_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- RX Detect block CRAMs
SIGNAL r_tx_det_rx_ch1_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- RX Detect block CRAMs
SIGNAL r_tx_det_rx_ch2_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- RX Detect block CRAMs
SIGNAL r_tx_det_rx_ch3_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- RX Detect block CRAMs
SIGNAL rpmphs_2tap_ch0_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL rpmphs_2tap_ch1_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL rpmphs_2tap_ch2_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL rpmphs_2tap_ch3_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);   -- Enable CRAM for PMPHS_2TAP_CHn[1:0] dynamic control signal
SIGNAL rtx_vtt_ch0_int      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL rtx_vtt_ch1_int      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL rtx_vtt_ch2_int      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL rtx_vtt_ch3_int      : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Enable CRAM for TX_VTT_CHn[2:0] dynamic control signal
SIGNAL rsig_inv_pre_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Enable CRAM for SIG_INV_PRE dynamic control signal
SIGNAL rrsvd_tx_ch0_int     : STD_LOGIC_VECTOR(4   DOWNTO   0);      -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL rrsvd_tx_ch1_int     : STD_LOGIC_VECTOR(4   DOWNTO   0);      -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL rrsvd_tx_ch2_int     : STD_LOGIC_VECTOR(4   DOWNTO   0);      -- Rerserved CRAMs for both TX PCS and TX PMA
SIGNAL rrsvd_tx_ch3_int     : STD_LOGIC_VECTOR(4   DOWNTO   0);      -- Rerserved CRAMs for both TX PCS and TX PMA

-- RX PCS CRAMs wires to RX PCS
SIGNAL rskpsetbased_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Enable rate matching for PCI-E/PIPE, other standards based on COMMA DEL DEL..
SIGNAL rtruebac2bac_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Enabled (high) for all standards except PIPE. Back to back rate match enable.
SIGNAL ralfull_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Program when almost full goes high	
SIGNAL ralempty_ch0_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Program when almost empty goes high
SIGNAL ralfull_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Program when almost full goes high	
SIGNAL ralempty_ch1_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Program when almost empty goes high
SIGNAL ralfull_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Program when almost full goes high	
SIGNAL ralempty_ch2_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Program when almost empty goes high
SIGNAL ralfull_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Program when almost full goes high	
SIGNAL ralempty_ch3_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Program when almost empty goes high
SIGNAL rcmpfifourst_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Enable cmpfifourst
SIGNAL rphfifourstrx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Enable phfifourst_rx
SIGNAL rcomp_size_ch0_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);    -- Pattern comparision length CRAMs
SIGNAL rcomp_size_ch1_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);    -- Pattern comparision length CRAMs
SIGNAL rcomp_size_ch2_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);    -- Pattern comparision length CRAMs
SIGNAL rcomp_size_ch3_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);    -- Pattern comparision length CRAMs
SIGNAL rcomp_pat_ch0_int    : STD_LOGIC_VECTOR(39  DOWNTO   0);     -- Sync pattern CRAMs
SIGNAL rcomp_pat_ch1_int    : STD_LOGIC_VECTOR(39  DOWNTO   0);     -- Sync pattern CRAMs
SIGNAL rcomp_pat_ch2_int    : STD_LOGIC_VECTOR(39  DOWNTO   0);     -- Sync pattern CRAMs
SIGNAL rcomp_pat_ch3_int    : STD_LOGIC_VECTOR(39  DOWNTO   0);     -- Sync pattern CRAMs
SIGNAL rrundisp_ch0_int     : STD_LOGIC_VECTOR(5   DOWNTO   0);      -- Run lengh violation setting CRAMs
SIGNAL rrundisp_ch1_int     : STD_LOGIC_VECTOR(5   DOWNTO   0);      -- Run lengh violation setting CRAMs
SIGNAL rrundisp_ch2_int     : STD_LOGIC_VECTOR(5   DOWNTO   0);      -- Run lengh violation setting CRAMs
SIGNAL rrundisp_ch3_int     : STD_LOGIC_VECTOR(5   DOWNTO   0);      -- Run lengh violation setting CRAMs
SIGNAL rib_inv_cd_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- Invalid code setting CRAMs for IB
SIGNAL rib_inv_cd_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- Invalid code setting CRAMs for IB
SIGNAL rib_inv_cd_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- Invalid code setting CRAMs for IB
SIGNAL rib_inv_cd_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);    -- Invalid code setting CRAMs for IB
SIGNAL rrlv_en_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- RLV enable CRAM
SIGNAL rsync_sm_dis_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- GIGE/XAUI Sync SM disable CRAM
SIGNAL rautobtalg_dis_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);    -- BITSLIP mode enable CRAM
SIGNAL rdis_rx_disp_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Receive running disparity calculation disable CRAM
SIGNAL rmatchen_int         : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Clock compensation enable CRAM
SIGNAL rgenericfifo_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- GenericFIFO mode enable CRAM
SIGNAL rendec_rx_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- 10B/8B decoder enable CRAM
SIGNAL rdwidth_rx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- RX parallel interface data width selection CRAM
SIGNAL rlp20ben_int         : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- 20-b loopback enable CRAM
SIGNAL rrxfifo_dis_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- RX FIFO bypassing CRAM
SIGNAL renumber_ch0_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);      -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL renumber_ch1_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);      -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL renumber_ch2_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);      -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL renumber_ch3_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);      -- Number of consecutive errors without valid data to goto LOSS_OF_SYNC
SIGNAL rknumber_ch0_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL rknumber_ch1_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL rknumber_ch2_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL rknumber_ch3_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive commas to reach SYNC_ACQ from LOSS_OF_SYNC
SIGNAL renpolinv_rx_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Allow polarity inversion
SIGNAL rgnumber_ch0_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL rgnumber_ch1_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL rgnumber_ch2_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL rgnumber_ch3_int     : STD_LOGIC_VECTOR(7   DOWNTO   0);      -- Number of consecutive good data to approach SYNC_ACQ
SIGNAL rclkcmpsqmd_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- How many characters to match
SIGNAL rclkcmpsq1p_ch0_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL rclkcmpsq1p_ch1_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL rclkcmpsq1p_ch2_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL rclkcmpsq1p_ch3_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence pos. disp.
SIGNAL rclkcmpsq1n_ch0_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL rclkcmpsq1n_ch1_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL rclkcmpsq1n_ch2_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL rclkcmpsq1n_ch3_int  : STD_LOGIC_VECTOR(19  DOWNTO   0);   -- Programmable 20-bit encoded comp sequence neg. disp.
SIGNAL rclkcmppos_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- Match only the pos disp. sequence 
SIGNAL rosnumber_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Length of the ordered set
SIGNAL rosnumber_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Length of the ordered set
SIGNAL rosnumber_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Length of the ordered set
SIGNAL rosnumber_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Length of the ordered set
SIGNAL rosbased_int         : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Enable ordered-set based algorithm
SIGNAL rkchar_int           : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- use kchar at cg_bad logic calculation
SIGNAL rcascaded_8b10b_en_rx_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- Cascaded 8B/10B decoder enable CRAM
SIGNAL resync_badcg_en_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   --
SIGNAL resync_badcg_en_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   --
SIGNAL resync_badcg_en_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   --
SIGNAL resync_badcg_en_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   --
SIGNAL rencdt_rising_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- encdt on rising edge enable CRAM
SIGNAL rcomp_pat_porn_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- Positive and negative match enable CRAM
SIGNAL rprbsen_rx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- PRBS Verifier enable CRAM
SIGNAL rprbs_clr_rslt_rx_int : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- PRBS pass/fail flag clear CRAM
SIGNAL rbisten_rx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- BIST Verifier enable CRAM
SIGNAL rbist_clr_rx_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- BIST pass/fail flag clear CRAM
SIGNAL rwa_6g_en_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- 6G word alignment enable CRAM
SIGNAL rbitslip_size_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- BITSLIP size selection CRAM
SIGNAL rbitslip_size_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- BITSLIP size selection CRAM
SIGNAL rbitslip_size_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- BITSLIP size selection CRAM
SIGNAL rbitslip_size_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- BITSLIP size selection CRAM
SIGNAL rbytord_2sym_en_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Enable 2 symbols byte orderring CRAM
SIGNAL rbysync_polinv_en_int : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Word alignment polarity inversion enable CRAM
SIGNAL rbitloc_rev_en_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- Bit reversal enable CRAM
SIGNAL rbyte_rev_en_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Byte swap enable CRAM
SIGNAL rbyteorden_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Byte ordering enable CRAM
SIGNAL rbyteorden_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Byte ordering enable CRAM
SIGNAL rbyteorden_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Byte ordering enable CRAM
SIGNAL rbyteorden_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Byte ordering enable CRAM
SIGNAL rbytordplden_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- PLD control signal BYTEORDPLD enable CRAM
SIGNAL rphfifopldenrx_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- RX phase comp. FIFO read/write enable CRAM
SIGNAL rautoinsdis_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Disable CRAM for auto insertion of 8'h9C
SIGNAL rppmsel_ch0_int      : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- Programmable PPM ajustment CRAM
SIGNAL rppmsel_ch1_int      : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- Programmable PPM ajustment CRAM
SIGNAL rppmsel_ch2_int      : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- Programmable PPM ajustment CRAM
SIGNAL rppmsel_ch3_int      : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- Programmable PPM ajustment CRAM
SIGNAL rforce0_freqdet_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Forcing FREQDET signal to low CRAM
SIGNAL rforce1_freqdet_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Forcing FREQDET signal to high CRAM
SIGNAL rbytordpat_ch0_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pattern CRAM
SIGNAL rbytordpat_ch1_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pattern CRAM
SIGNAL rbytordpat_ch2_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pattern CRAM
SIGNAL rbytordpat_ch3_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pattern CRAM
SIGNAL rbytordpad_ch0_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pad pattern CRAM
SIGNAL rbytordpad_ch1_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pad pattern CRAM
SIGNAL rbytordpad_ch2_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pad pattern CRAM
SIGNAL rbytordpad_ch3_int   : STD_LOGIC_VECTOR(9   DOWNTO   0);        -- Byte ordering pad pattern CRAM
SIGNAL rforce_sig_det_pcs_int : STD_LOGIC_VECTOR(3   DOWNTO   0);    -- Forcing sigdet to high in PCS CRAM
SIGNAL rfreerun_rx_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- RX_CLK out free running during RX PCS reset enable CRAM
SIGNAL rrcvd_clk_sel_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- RCVD_CLK domain selection CRAM
SIGNAL rrcvd_clk_sel_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- RCVD_CLK domain selection CRAM
SIGNAL rrcvd_clk_sel_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- RCVD_CLK domain selection CRAM
SIGNAL rrcvd_clk_sel_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- RCVD_CLK domain selection CRAM
SIGNAL rclk_1_sel_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_1 domain selection CRAM
SIGNAL rclk_1_sel_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_1 domain selection CRAM
SIGNAL rclk_1_sel_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_1 domain selection CRAM
SIGNAL rclk_1_sel_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_1 domain selection CRAM
SIGNAL rclk_2_sel_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_2 domain selection CRAM
SIGNAL rclk_2_sel_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_2 domain selection CRAM
SIGNAL rclk_2_sel_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_2 domain selection CRAM
SIGNAL rclk_2_sel_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- CLK_2 domain selection CRAM
SIGNAL rrx_rd_clk_sel_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- RX FIFO read clock selection CRAM
SIGNAL rrx_pipe_enable_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- RX PIPE interface enable CRAM
SIGNAL rall_one_dect_only_int : STD_LOGIC_VECTOR(3   DOWNTO   0);    -- PRBS Verifier detect all one only enable CRAM
SIGNAL rtest_bus_sel_ch0_int : STD_LOGIC_VECTOR(2   DOWNTO   0);     -- Per channel test bus selection CRAMs
SIGNAL rtest_bus_sel_ch1_int : STD_LOGIC_VECTOR(2   DOWNTO   0);     -- Per channel test bus selection CRAMs
SIGNAL rtest_bus_sel_ch2_int : STD_LOGIC_VECTOR(2   DOWNTO   0);     -- Per channel test bus selection CRAMs
SIGNAL rtest_bus_sel_ch3_int : STD_LOGIC_VECTOR(2   DOWNTO   0);     -- Per channel test bus selection CRAMs
SIGNAL r8b10b_dec_ibm_en_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- 8B10B Decoder fix enable CRAM
SIGNAL r8b10b_dec_ibm_en_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- 8B10B Decoder fix enable CRAM
SIGNAL r8b10b_dec_ibm_en_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- 8B10B Decoder fix enable CRAM
SIGNAL r8b10b_dec_ibm_en_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- 8B10B Decoder fix enable CRAM
SIGNAL rrxfifo_lowlatency_en_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- RX FIFO low latency enable CRAM
SIGNAL rppm_cnt_reset_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);        -- PPM counter reset CRAM (latched version on Test bus)
SIGNAL rrx_detect_bypass_int : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- PMA RX detection bypass enable CRAM
SIGNAL rclkcmpinsertpad_int : STD_LOGIC_VECTOR(3   DOWNTO   0);      -- Rate matching pad insertion enable CRAM

-- RX PMA CRAM wires to RX PMAs
SIGNAL rpmadwidth_rx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- RX PMA to RX PCS data width sel CRAMs
SIGNAL rpma_doublewidth_rx_int : STD_LOGIC_VECTOR(3   DOWNTO   0); -- RX PMA/PCS double width (16/20) sel CRAM
SIGNAL rrx_sloslv_ch0_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch1_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch2_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- Signal loss threshold select CRAMs
SIGNAL rrx_sloslv_ch3_int   : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- Signal loss threshold select CRAMs
SIGNAL rrx_term_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RX input buffer termination select CRAMs
SIGNAL rrx_term_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RX input buffer termination select CRAMs
SIGNAL rrxvcobypass_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- RX VCO bypass CRAM
SIGNAL rbwctral_rx_ch0_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch1_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch2_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RX PLL loop filter bandwidth control CRAMs
SIGNAL rbwctral_rx_ch3_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RX PLL loop filter bandwidth control CRAMs
SIGNAL rforce_sigdet_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- SIGDET forcing CRAM
SIGNAL rrefclk_sel_ch0_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch1_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch2_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- RXPLL alternative clock source selection CRAMs
SIGNAL rrefclk_sel_ch3_int  : STD_LOGIC_VECTOR(2   DOWNTO   0);	-- RXPLL alternative clock source selection CRAMs
SIGNAL rs_lpbk_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);		-- Serial loopback CRAM
SIGNAL r_rlpbk_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Reverse serial loopback CRAM for RX channel
SIGNAL rs_rdlpbk_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Serial reversed diagnostic loopback CRAM
SIGNAL rrx_revlb_sw_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Reverse loopback switch CRAM
SIGNAL risel_rx_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RXPLL charge pump current control CRAM
SIGNAL risel_rx_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- RXPLL charge pump current control CRAM
SIGNAL riupsel_rx_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL riupsel_rx_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Iup)
SIGNAL ridnsel_rx_ch0_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch1_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch2_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL ridnsel_rx_ch3_int   : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Intentionally mismatch UP/DN current CRAMs control (Idn)
SIGNAL rtesten_cp_rx_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Charge pump test mode control CRAM in RXPLL
SIGNAL rtristate_cp_rx_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Charge pump tristate control CRAM in RXPLL
SIGNAL rtestupen_cp_rx_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Charge pump current test control CRAM in RXPLL
SIGNAL rtestdnen_cp_rx_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);     -- Charge pump current test control CRAM in RXPLL
SIGNAL rrx_vtt_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);	        -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);	        -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);	        -- Programmable termination voltage setting CRAM
SIGNAL rrx_vtt_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);	        -- Programmable termination voltage setting CRAM
SIGNAL rlst_rx_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Low speed test selection CRAM
SIGNAL rlst_rx_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Low speed test selection CRAM
SIGNAL rlst_rx_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Low speed test selection CRAM
SIGNAL rlst_rx_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch0_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch1_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch2_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Low speed test selection CRAM
SIGNAL rlst_rxpll_ch3_int   : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Low speed test selection CRAM
SIGNAL rltr_int             : STD_LOGIC_VECTOR(3   DOWNTO   0);		-- Lock to reference clock enable CRAM
SIGNAL rltd_int             : STD_LOGIC_VECTOR(3   DOWNTO   0);		-- Lock to received data enable CRAM
SIGNAL rrx_cru_m_ch0_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Programmable M control CRAM
SIGNAL rrx_cru_m_ch1_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Programmable M control CRAM
SIGNAL rrx_cru_m_ch2_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Programmable M control CRAM
SIGNAL rrx_cru_m_ch3_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Programmable M control CRAM
SIGNAL rrx_cru_l_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Programmable L contrl CRAM
SIGNAL rrx_cru_l_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);	-- Programmable L contrl CRAM
SIGNAL rrx_ignore_phslck_int : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- Ignore phase lock CRAM
SIGNAL rrx_cru_ctl_ch0_int  : STD_LOGIC_VECTOR(5   DOWNTO   0);	-- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch1_int  : STD_LOGIC_VECTOR(5   DOWNTO   0);	-- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch2_int  : STD_LOGIC_VECTOR(5   DOWNTO   0);	-- Programmable control CRAM
SIGNAL rrx_cru_ctl_ch3_int  : STD_LOGIC_VECTOR(5   DOWNTO   0);	-- Programmable control CRAM
SIGNAL rreg_cp_rx_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- RX PLL charge pump regulator enable CRAM
SIGNAL rrx_piso_bypass_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- Reference bypass around PISO CRAM
SIGNAL rrx_piso_bypass_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0); -- Reference bypass around PISO CRAM
SIGNAL rrx_cru_m_sel_ch0_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch1_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch2_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_m_sel_ch3_int : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Division ratio CRAM selection of input clock in CDR
SIGNAL rrx_cru_div2_int     : STD_LOGIC_VECTOR(3   DOWNTO   0);	-- Reference clock divided by 2 enable CRAM
SIGNAL rrx_osc_en_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- CGB RX OSC enable CRAM
SIGNAL rrx_cru_pdb_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Power down (bar) CRAM for CRU
SIGNAL rrx_cru_rst_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Reset CRAM for PLL in CRU
SIGNAL rrx_ib_pdb_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);	        -- Power down (bar) for input buffer
--wire    [3:0]  rrx_sipo_pdb_int;	-- Power down (bar) for SIPO
SIGNAL rurx_pdb_int         : STD_LOGIC_VECTOR(3   DOWNTO   0);            -- Enable CRAM for URX_PDB dynamic signal
SIGNAL radce_pdb_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Power down for adaptive equalization
SIGNAL radce_rst_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- Reset CRAM for counters in adaptive engine
SIGNAL rrx_dc_couple_int    : STD_LOGIC_VECTOR(3   DOWNTO   0);       -- Programmable DC couple CRAM for RX wire  buffer
SIGNAL rrx_eq_dc_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- CRAMs for Equalizer block
SIGNAL rrx_eq_dc_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- CRAMs for Equalizer block
SIGNAL radce_adapt_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Continuous adaptation enable CRAM
SIGNAL rseq_sel_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Sequence of adaptation selection CRAMs
SIGNAL rseq_sel_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- Sequence of adaptation selection CRAMs
SIGNAL rrgen_set_ch0_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- D2A control CRAMs
SIGNAL rrgen_set_ch1_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- D2A control CRAMs
SIGNAL rrgen_set_ch2_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- D2A control CRAMs
SIGNAL rrgen_set_ch3_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- D2A control CRAMs
SIGNAL rclkdiv_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Division ration selection CRAMs for adaptation engine
SIGNAL rclkdiv_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- Division ration selection CRAMs for adaptation engine
SIGNAL rf_lpf_ch0_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch1_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch2_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- LPF corner frequency setting CRAMs
SIGNAL rf_lpf_ch3_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- LPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch0_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch1_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch2_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- HPF corner frequency setting CRAMs
SIGNAL rf_hpf_ch3_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- HPF corner frequency setting CRAMs
SIGNAL rrgen_bw_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RGEN corner frequency setting CRAMs
SIGNAL rrgen_bw_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- RGEN corner frequency setting CRAMs
SIGNAL rhyst_ch0_int        : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch1_int        : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch2_int        : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Programmable digital filtering setting CRAMs
SIGNAL rhyst_ch3_int        : STD_LOGIC_VECTOR(2   DOWNTO   0);           -- Programmable digital filtering setting CRAMs
SIGNAL rrect_adj_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Rectifier leaker current setting CRAMs
SIGNAL rrect_adj_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- Rectifier leaker current setting CRAMs
SIGNAL rd2a_res_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- D2A resolution settting CRAMs
SIGNAL rd2a_res_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- D2A resolution settting CRAMs
SIGNAL rrgen_vod_ch0_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch1_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch2_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- RGEN amplitude setting CRAMs
SIGNAL rrgen_vod_ch3_int    : STD_LOGIC_VECTOR(2   DOWNTO   0);       -- RGEN amplitude setting CRAMs
SIGNAL rlf_os_ch0_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch1_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch2_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rlf_os_ch3_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- Low freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch0_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch1_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch2_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- High freq. loop offset cancelling setting CRAMs
SIGNAL rhf_os_ch3_int       : STD_LOGIC_VECTOR(3   DOWNTO   0);          -- High freq. loop offset cancelling setting CRAMs
SIGNAL reqa_ct_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqa_ct_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQA_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqb_ct_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQB_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqc_ct_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQC_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL reqd_ct_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQD_CT_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch0_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch1_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch2_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL req_ctv_ch3_int      : STD_LOGIC_VECTOR(2   DOWNTO   0);         -- Enable CRAMs for EQ_CTV_CHn[2:0] dynamic control signals
SIGNAL rdc_freq_ch0_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- ADCE CRAM
SIGNAL rdc_freq_ch1_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- ADCE CRAM
SIGNAL rdc_freq_ch2_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- ADCE CRAM
SIGNAL rdc_freq_ch3_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);        -- ADCE CRAM
SIGNAL r_iqclk_ch0_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- IQCLK selection CRAM
SIGNAL r_iqclk_ch1_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- IQCLK selection CRAM
SIGNAL r_iqclk_ch2_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- IQCLK selection CRAM
SIGNAL r_iqclk_ch3_int      : STD_LOGIC_VECTOR(3   DOWNTO   0);         -- IQCLK selection CRAM
SIGNAL r_dfe_ch0_int        : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- DFE CRAM
SIGNAL r_dfe_ch1_int        : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- DFE CRAM
SIGNAL r_dfe_ch2_int        : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- DFE CRAM
SIGNAL r_dfe_ch3_int        : STD_LOGIC_VECTOR(5   DOWNTO   0);           -- DFE CRAM
SIGNAL r_cp_mode_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);           -- CP mode CRAM
SIGNAL r_impctrl_ch0_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- IMPCTRL CRAM
SIGNAL r_impctrl_ch1_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- IMPCTRL CRAM
SIGNAL r_impctrl_ch2_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- IMPCTRL CRAM
SIGNAL r_impctrl_ch3_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);       -- IMPCTRL CRAM
SIGNAL rpd_ien_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);             -- PD current setting CRAM
SIGNAL rrsvd_rx_ch0_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);        -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch1_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);        -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch2_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);        -- Rerserved CRAMs for both RX PCS and RX PMA
SIGNAL rrsvd_rx_ch3_int     : STD_LOGIC_VECTOR(2   DOWNTO   0);        -- Rerserved CRAMs for both RX PCS and RX PMA

-- CMU PCS CRAMs wires to CMU
SIGNAL rindv_tx_int         : STD_LOGIC;          -- TX SM bypassing CRAM
SIGNAL rindv_rx_int         : STD_LOGIC;          -- RX SM bypassing CRAM
SIGNAL rdeskewen_int        : STD_LOGIC;         -- Deskew function enable CRAM
SIGNAL ralgnect_int         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL ralgnact_int         : STD_LOGIC_VECTOR(2   DOWNTO   0);          -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL ralgngct_int         : STD_LOGIC_VECTOR(1   DOWNTO   0);          -- Number of consecutive errors without valid data to goto LOSS_OF_ALIGN
SIGNAL rdskposdisp_int      : STD_LOGIC;       -- Match the programmed de-skew pattern only
SIGNAL rdskchrp_int         : STD_LOGIC_VECTOR(9   DOWNTO   0);          -- Programmable Deskew Char. Pos. Disp.
SIGNAL ralgnopt_int         : STD_LOGIC;          -- De-skew SM Hysteresis Option
SIGNAL rfreerun_centrl_int  : STD_LOGIC;   -- REFCLK_OUT free running enable CRAM
SIGNAL rcentrl_clk_sel_int  : STD_LOGIC;   -- REFCLK_PMA global clock selection CRAM
SIGNAL rrefclk_out_div2_int : STD_LOGIC;  -- REFCLK_OUT divide by 2 enable CRAM
SIGNAL rtest_bus_centrl_sel_int : STD_LOGIC_VECTOR(2   DOWNTO   0);  -- Central Test bus selection CRAMs
SIGNAL rendec_data_sel_tx_int : STD_LOGIC;-- TX 8B10B encoder data in selection CRAM
SIGNAL rendec_data_sel_rx_int : STD_LOGIC;-- RX 8B10B decoder data out selection CRAM
SIGNAL rphfifo_master_sel_tx_int : STD_LOGIC; -- TX Phase comp. FIFO pointers selection CRAM
SIGNAL rphfifo_master_sel_rx_int : STD_LOGIC; -- TX Phase comp. FIFO pointers selection CRAM

-- CMU PMA, and CLKREF CRAMs wires
SIGNAL rbgbypass_int        : STD_LOGIC;	      -- Bandgap bypass CRAM
--wire           ratb_en_int;	      -- Analog test bus enable CRAM
SIGNAL rlst_bg_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable test bus setting CRAM
SIGNAL rcmu_rst_int         : STD_LOGIC;	      -- Reset CRAM for divider in CMU feedback loop
SIGNAL rcmu_iqclkout_sel_int : STD_LOGIC; -- REFClock select for going to IQ lines CRAM
SIGNAL rcmu0_isel_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu1_isel_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu0_iupsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu1_iupsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu0_idnsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu1_idnsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu0_testen_cp_int  : STD_LOGIC;   -- Charge pump test mode control CRAM in TXPLL0
SIGNAL rcmu1_testen_cp_int  : STD_LOGIC;   -- Charge pump test mode control CRAM in TXPLL1
SIGNAL rcmu0_tristate_cp_int : STD_LOGIC; -- Charge pump tristate control CRAM in TXPLL0
SIGNAL rcmu1_tristate_cp_int : STD_LOGIC; -- Charge pump tristate control CRAM in TXPLL1
SIGNAL rcmu0_testupen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM in TXPLL0
SIGNAL rcmu1_testupen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM in TXPLL1
SIGNAL rcmu0_lst_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu1_lst_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu0_ctl_int        : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu1_ctl_int        : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu0_div2_int       : STD_LOGIC;	      -- Reference clock divided by 2 enable CRAM
SIGNAL rcmu1_div2_int       : STD_LOGIC;	      -- Reference clock divided by 2 enable CRAM
SIGNAL rcmu0_ref_sel_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Reference selection control CRAM
SIGNAL rcmu1_ref_sel_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- Reference selection control CRAM
SIGNAL rcmu0_m_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M selection CRAM
SIGNAL rcmu1_m_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M selection CRAM
SIGNAL rcmu0_l_int          : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L selection CRAM
SIGNAL rcmu1_l_int          : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L selection CRAM
SIGNAL rcmu0_pdb_int        : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu1_pdb_int        : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu0_txpll_rst_int  : STD_LOGIC;   -- TXPLL0 reset CRAM
SIGNAL rcmu1_txpll_rst_int  : STD_LOGIC;   -- TXPLL0 reset CRAM
SIGNAL rcmu0_testdnen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM
SIGNAL rcmu1_testdnen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM
SIGNAL rcmu_peclrx0_cm_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- Common mode control CRAM
SIGNAL rcmu_peclrx1_cm_int  : STD_LOGIC_VECTOR(3   DOWNTO   0);   -- Common mode control CRAM
SIGNAL rcmu_peclrx0_lst_int : STD_LOGIC_VECTOR(3   DOWNTO   0);  -- Analog test bus setting CRAM
SIGNAL rcmu_peclrx1_lst_int : STD_LOGIC_VECTOR(3   DOWNTO   0);  -- Analog test bus setting CRAM
SIGNAL rcmu_txpll0_1x_en_int : STD_LOGIC; -- 1X enable CRAM in central CGB
SIGNAL rcmu_txpll1_1x_en_int : STD_LOGIC; -- 1X enable CRAM in central CGB
SIGNAL rcmu_txpll0_iqclkin_sel_int : STD_LOGIC_VECTOR(2   DOWNTO   0);-- IQ clock selection CRAMs
SIGNAL rcmu_txpll1_iqclkin_sel_int : STD_LOGIC_VECTOR(2   DOWNTO   0);-- IQ clock selection CRAMs
SIGNAL rcmu_cgb_cmusel_int  : STD_LOGIC_VECTOR(1   DOWNTO   0);   -- Central CGB CMU selection CRAM
SIGNAL rcmu_cgb_ndiv_int    : STD_LOGIC_VECTOR(1   DOWNTO   0);     -- N-divider selection CRAM for wire  clock in central CGB
SIGNAL rcmu_cgb_div5_int    : STD_LOGIC;     -- TX PCS to TX PMA data width selection CRAM
SIGNAL rcmu_cgb_div2_int    : STD_LOGIC;     -- TX PCS to TX PMA double data width selection CRAM
SIGNAL rcmu_cgb_vcobypass_int : STD_LOGIC;-- CMU VCO bypass CRAM in central CGB
SIGNAL rcmu_cgb_4x_en_int   : STD_LOGIC;    -- Quad channel mode clock driver enable CRAM
SIGNAL rcmu_cgb_8x_en_int   : STD_LOGIC;    -- Eight channel mode clock driver enable CRAM
SIGNAL rcmu_cgb_pclksel_int : STD_LOGIC;  -- Central CGB PCLK select CRAM
SIGNAL rcmu2_isel_int       : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- TXPLL charge pump current control CRAM
SIGNAL rcmu2_iupsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Iup)
SIGNAL rcmu2_idnsel_int     : STD_LOGIC_VECTOR(1   DOWNTO   0);      -- Intentionally mismatch UP/DN current control CRAM (Idn)
SIGNAL rcmu2_testen_cp_int  : STD_LOGIC;   -- Charge pump test mode control CRAM in TXPLL2
SIGNAL rcmu2_tristate_cp_int : STD_LOGIC; -- Charge pump tristate control CRAM in TXPLL2
SIGNAL rcmu2_testupen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM in TXPLL2
SIGNAL rcmu2_testdnen_cp_int : STD_LOGIC; -- Charge pump current test control CRAM in TXPLL2
SIGNAL rcmu2_lst_int        : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Low speed test selection CRAM
SIGNAL rcmu2_ctl_int        : STD_LOGIC_VECTOR(7   DOWNTO   0);	      -- Programmable control CRAM
SIGNAL rcmu2_refsel_int     : STD_LOGIC;      -- Reference select CRAM for CMU2
SIGNAL rcmu2_m_int          : STD_LOGIC_VECTOR(3   DOWNTO   0);	      -- Programmable M selection CRAM
SIGNAL rcmu2_l_int          : STD_LOGIC_VECTOR(1   DOWNTO   0);	      -- Programmable L selection CRAM
SIGNAL rcmu2_pdb_int        : STD_LOGIC;	      -- Powerdown (bar)CMU CRAM
SIGNAL rcmu2_txpll_rst_int  : STD_LOGIC;   -- TXPLL2 reset CRAM
SIGNAL rcmu0_rcp_mode_int   : STD_LOGIC;    -- CMU0 charge pump mode select CRAM
SIGNAL rcmu1_rcp_mode_int   : STD_LOGIC;    -- CMU1 charge pump mode select CRAM
SIGNAL rpma_testbus_sel_int : STD_LOGIC_VECTOR(3   DOWNTO   0);  -- PMA testbus selection
SIGNAL rrsvd_cmu_int        : STD_LOGIC_VECTOR(4   DOWNTO   0);         -- Reserved CRAMs for both PMA CMU and PCS CMU

SIGNAL pcs_ctrl_out_ch0     : STD_LOGIC_VECTOR(15  DOWNTO   0);      -- PCS MDIO out for channel0
SIGNAL pcs_ctrl_out_ch1     : STD_LOGIC_VECTOR(15  DOWNTO   0);      -- PCS MDIO out for channel1
SIGNAL pcs_ctrl_out_ch2     : STD_LOGIC_VECTOR(15  DOWNTO   0);      -- PCS MDIO out for channel2
SIGNAL pcs_ctrl_out_ch3     : STD_LOGIC_VECTOR(15  DOWNTO   0);      -- PCS MDIO out for channel3

-- Control register address parameters
constant XGXS_CTRL          : std_logic_vector(15 DOWNTO 0) :=  "0000000000000000";  -- 0000
constant XGXS_STATUS1       : std_logic_vector(15 DOWNTO 0) :=  "0000000000000001";  -- 0001
constant XGXS_STATUS2       : std_logic_vector(15 DOWNTO 0) :=  "0000000000001000";  -- 0008
constant XGXS_LANE_STATUS   : std_logic_vector(15 DOWNTO 0) :=  "0000000000011000";  -- 0018
constant TRUNKING_MODE      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000000";  -- 8000
constant PCS_CTRL1_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000001";  -- 8001
constant PCS_CTRL1_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000010";  -- 8002
constant PCS_CTRL1_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000011";  -- 8003
constant PCS_CTRL1_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000100";  -- 8004
constant PCS_CTRL2_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000101";  -- 8005
constant PCS_CTRL2_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000110";  -- 8006
constant PCS_CTRL2_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000000111";  -- 8007
constant PCS_CTRL2_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001000";  -- 8008
constant PCS_CTRL3_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001001";  -- 8009
constant PCS_CTRL3_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001010";  -- 800a
constant PCS_CTRL3_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001011";  -- 800b
constant PCS_CTRL3_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001100";  -- 800c
constant PCS_CTRL4_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001101";  -- 800d
constant PCS_CTRL4_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001110";  -- 800e
constant PCS_CTRL4_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000001111";  -- 800f
constant PCS_CTRL4_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010000";  -- 8010
constant PCS_CTRL5_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010001";  -- 8011
constant PCS_CTRL5_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010010";  -- 8012
constant PCS_CTRL5_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010011";  -- 8013
constant PCS_CTRL5_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010100";  -- 8014
constant PCS_CTRL6_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010101";  -- 8015
constant PCS_CTRL6_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010110";  -- 8016
constant PCS_CTRL6_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000010111";  -- 8017
constant PCS_CTRL6_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011000";  -- 8018
constant PCS_CTRL7_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011001";  -- 8019
constant PCS_CTRL7_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011010";  -- 801a
constant PCS_CTRL7_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011011";  -- 801b
constant PCS_CTRL7_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011100";  -- 801c
constant PCS_CTRL8_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011101";  -- 801d
constant PCS_CTRL8_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011110";  -- 801e
constant PCS_CTRL8_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000011111";  -- 801f
constant PCS_CTRL8_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000100000";  -- 8020
constant PRBS_BIST_CTRL_CH0 : std_logic_vector(15 DOWNTO 0) :=  "1000000000100001";  -- 8021
constant PRBS_BIST_CTRL_CH1 : std_logic_vector(15 DOWNTO 0) :=  "1000000000100010";  -- 8022
constant PRBS_BIST_CTRL_CH2 : std_logic_vector(15 DOWNTO 0) :=  "1000000000100011";  -- 8023
constant PRBS_BIST_CTRL_CH3 : std_logic_vector(15 DOWNTO 0) :=  "1000000000100100";  -- 8024
constant PCS_CTRL9_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000000100101";  -- 8025
constant PCS_CTRL9_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000000100110";  -- 8026
constant PCS_CTRL9_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000000100111";  -- 8027
constant PCS_CTRL9_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000000101000";  -- 8028
constant PCS_CTRL10_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101001";  -- 8029
constant PCS_CTRL10_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101010";  -- 802a
constant PCS_CTRL10_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101011";  -- 802b
constant PCS_CTRL10_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101100";  -- 802c
constant PCS_CTRL11_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101101";  -- 802d
constant PCS_CTRL11_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101110";  -- 802e
constant PCS_CTRL11_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000101111";  -- 802f
constant PCS_CTRL11_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110000";  -- 8030
constant PCS_CTRL12_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110001";  -- 8031
constant PCS_CTRL12_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110010";  -- 8032
constant PCS_CTRL12_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110011";  -- 8033
constant PCS_CTRL12_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110100";  -- 8034
constant PCS_CTRL13_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110101";  -- 8035
constant PCS_CTRL13_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110110";  -- 8036
constant PCS_CTRL13_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000110111";  -- 8037
constant PCS_CTRL13_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111000";  -- 8038
constant PCS_CTRL14_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111001";  -- 8039
constant PCS_CTRL14_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111010";  -- 803a
constant PCS_CTRL14_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111011";  -- 803b
constant PCS_CTRL14_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111100";  -- 803c
constant PCS_CTRL15_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111101";  -- 803d
constant PCS_CTRL15_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111110";  -- 803e
constant PCS_CTRL15_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000000111111";  -- 803f
constant PCS_CTRL15_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000001000000";  -- 8040
constant PCS_GLOBAL_CTRL0   : std_logic_vector(15 DOWNTO 0) :=  "1000000001010000";  -- 8050
constant PCS_GLOBAL_CTRL1   : std_logic_vector(15 DOWNTO 0) :=  "1000000001010001";  -- 8051
constant PCS_GLOBAL_CTRL2   : std_logic_vector(15 DOWNTO 0) :=  "1000000001010010";  -- 8052
constant PMA_CTRL1_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100000";  -- 8060
constant PMA_CTRL1_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100001";  -- 8061
constant PMA_CTRL1_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100010";  -- 8062
constant PMA_CTRL1_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100011";  -- 8063
constant PMA_CTRL2_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100100";  -- 8064
constant PMA_CTRL2_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100101";  -- 8065
constant PMA_CTRL2_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100110";  -- 8066
constant PMA_CTRL2_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001100111";  -- 8067
constant PMA_CTRL3_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101000";  -- 8068
constant PMA_CTRL3_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101001";  -- 8069
constant PMA_CTRL3_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101010";  -- 806a
constant PMA_CTRL3_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101011";  -- 806b
constant PMA_CTRL4_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101100";  -- 806c
constant PMA_CTRL4_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101101";  -- 806d
constant PMA_CTRL4_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101110";  -- 806e
constant PMA_CTRL4_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001101111";  -- 806f
constant PMA_CTRL5_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110000";  -- 8070
constant PMA_CTRL5_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110001";  -- 8071
constant PMA_CTRL5_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110010";  -- 8072
constant PMA_CTRL5_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110011";  -- 8073
constant PMA_CTRL6_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110100";  -- 8074
constant PMA_CTRL6_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110101";  -- 8075
constant PMA_CTRL6_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110110";  -- 8076
constant PMA_CTRL6_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001110111";  -- 8077
constant PMA_CTRL7_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111000";  -- 8078
constant PMA_CTRL7_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111001";  -- 8079
constant PMA_CTRL7_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111010";  -- 807a
constant PMA_CTRL7_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111011";  -- 807b
constant PMA_CTRL8_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111100";  -- 807c
constant PMA_CTRL8_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111101";  -- 807d
constant PMA_CTRL8_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111110";  -- 807e
constant PMA_CTRL8_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000001111111";  -- 807f
constant PMA_CTRL9_CH0      : std_logic_vector(15 DOWNTO 0) :=  "1000000010000000";  -- 8080
constant PMA_CTRL9_CH1      : std_logic_vector(15 DOWNTO 0) :=  "1000000010000001";  -- 8081
constant PMA_CTRL9_CH2      : std_logic_vector(15 DOWNTO 0) :=  "1000000010000010";  -- 8082
constant PMA_CTRL9_CH3      : std_logic_vector(15 DOWNTO 0) :=  "1000000010000011";  -- 8083
constant PMA_CTRL10_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000010000100";  -- 8084
constant PMA_CTRL10_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000010000101";  -- 8085
constant PMA_CTRL10_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000010000110";  -- 8086
constant PMA_CTRL10_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000010000111";  -- 8087
constant PMA_CTRL11_CH0     : std_logic_vector(15 DOWNTO 0) :=  "1000000010001000";  -- 8088
constant PMA_CTRL11_CH1     : std_logic_vector(15 DOWNTO 0) :=  "1000000010001001";  -- 8089
constant PMA_CTRL11_CH2     : std_logic_vector(15 DOWNTO 0) :=  "1000000010001010";  -- 808a
constant PMA_CTRL11_CH3     : std_logic_vector(15 DOWNTO 0) :=  "1000000010001011";  -- 808b
constant PMA_GLOBAL_CTRL0   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010000";  -- 8090
constant PMA_GLOBAL_CTRL1   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010001";  -- 8091
constant PMA_GLOBAL_CTRL2   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010010";  -- 8092
constant PMA_GLOBAL_CTRL3   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010011";  -- 8093
constant PMA_GLOBAL_CTRL4   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010100";  -- 8094
constant PMA_GLOBAL_CTRL5   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010101";  -- 8095
constant PMA_GLOBAL_CTRL6   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010110";  -- 8096
constant PMA_GLOBAL_CTRL7   : std_logic_vector(15 DOWNTO 0) :=  "1000000010010111";  -- 8097
constant PMA_GLOBAL_CTRL8   : std_logic_vector(15 DOWNTO 0) :=  "1000000010011000";  -- 8098
constant PMA_GLOBAL_CTRL9   : std_logic_vector(15 DOWNTO 0) :=  "1000000010011001";  -- 8099

--------------------------------------------------------------------------------
-- mqmap begin                                                                --
--------------------------------------------------------------------------------
CONSTANT TX_PMA_ST : INTEGER := 68;
CONSTANT RX_PMA_ST : INTEGER := 152;

--logic - in and out: interface to upper level
SIGNAL rxdprioin_logic_ch0 : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioin_logic_ch1 : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioin_logic_ch2 : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioin_logic_ch3 : STD_LOGIC_VECTOR(199 DOWNTO   0);

SIGNAL txdprioin_logic_ch0 : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioin_logic_ch1 : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioin_logic_ch2 : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioin_logic_ch3 : STD_LOGIC_VECTOR(99  DOWNTO   0);

SIGNAL rxdprioout_logic_ch0 : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioout_logic_ch1 : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioout_logic_ch2 : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioout_logic_ch3 : STD_LOGIC_VECTOR(199 DOWNTO   0);

SIGNAL txdprioout_logic_ch0 : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioout_logic_ch1 : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioout_logic_ch2 : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioout_logic_ch3 : STD_LOGIC_VECTOR(99  DOWNTO   0);

-- phy - in and out: interface to lower level
SIGNAL rxdprioin_phy_ch0   : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioin_phy_ch1   : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioin_phy_ch2   : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioin_phy_ch3   : STD_LOGIC_VECTOR(199 DOWNTO   0);

SIGNAL txdprioin_phy_ch0   : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioin_phy_ch1   : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioin_phy_ch2   : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioin_phy_ch3   : STD_LOGIC_VECTOR(99  DOWNTO   0);

SIGNAL rxdprioout_phy_ch0  : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioout_phy_ch1  : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioout_phy_ch2  : STD_LOGIC_VECTOR(199 DOWNTO   0);
SIGNAL rxdprioout_phy_ch3  : STD_LOGIC_VECTOR(199 DOWNTO   0);

SIGNAL txdprioout_phy_ch0  : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioout_phy_ch1  : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioout_phy_ch2  : STD_LOGIC_VECTOR(99  DOWNTO   0);
SIGNAL txdprioout_phy_ch3  : STD_LOGIC_VECTOR(99  DOWNTO   0);

BEGIN  -- logic

jtag_shift_load <= dprioload;

rxdprioin_logic_ch0 <= rxdprioin(199 DOWNTO 0);
rxdprioin_logic_ch1 <= rxdprioin(399 DOWNTO 200);
rxdprioin_logic_ch2 <= rxdprioin(599 DOWNTO 400);
rxdprioin_logic_ch3 <= rxdprioin(799 DOWNTO 600);

rxdprioout(199 DOWNTO 0)   <= rxdprioout_logic_ch0;
rxdprioout(399 DOWNTO 200) <= rxdprioout_logic_ch1;
rxdprioout(599 DOWNTO 400) <= rxdprioout_logic_ch2;
rxdprioout(799 DOWNTO 600) <= rxdprioout_logic_ch3;

txdprioin_logic_ch0 <= txdprioin(99 DOWNTO 0);
txdprioin_logic_ch1 <= txdprioin(199 DOWNTO 100);
txdprioin_logic_ch2 <= txdprioin(299 DOWNTO 200);
txdprioin_logic_ch3 <= txdprioin(399 DOWNTO 300);

txdprioout(99 DOWNTO 0)    <= txdprioout_logic_ch0;
txdprioout(199 DOWNTO 100) <= txdprioout_logic_ch1;
txdprioout(299 DOWNTO 200) <= txdprioout_logic_ch2;
txdprioout(399 DOWNTO 300) <= txdprioout_logic_ch3;

-- phy map: input is logic --> phy
rxdprioin_phy_ch0 <=  rxdprioin_logic_ch0 WHEN (rx0_phy = 0) ELSE rxdprioin_logic_ch1 WHEN (rx1_phy = 0) ELSE rxdprioin_logic_ch2 WHEN (rx2_phy = 0) ELSE rxdprioin_logic_ch3;
rxdprioin_phy_ch1 <=  rxdprioin_logic_ch0 WHEN (rx0_phy = 1) ELSE rxdprioin_logic_ch1 WHEN (rx1_phy = 1) ELSE rxdprioin_logic_ch2 WHEN (rx2_phy = 1) ELSE rxdprioin_logic_ch3;
rxdprioin_phy_ch2 <=  rxdprioin_logic_ch0 WHEN (rx0_phy = 2) ELSE rxdprioin_logic_ch1 WHEN (rx1_phy = 2) ELSE rxdprioin_logic_ch2 WHEN (rx2_phy = 2) ELSE rxdprioin_logic_ch3;
rxdprioin_phy_ch3 <=  rxdprioin_logic_ch0 WHEN (rx0_phy = 3) ELSE rxdprioin_logic_ch1 WHEN (rx1_phy = 3) ELSE rxdprioin_logic_ch2 WHEN (rx2_phy = 3) ELSE rxdprioin_logic_ch3;

txdprioin_phy_ch0 <=  txdprioin_logic_ch0 WHEN (tx0_phy = 0) ELSE txdprioin_logic_ch1 WHEN (tx1_phy = 0) ELSE txdprioin_logic_ch2 WHEN (tx2_phy = 0) ELSE txdprioin_logic_ch3;
txdprioin_phy_ch1 <=  txdprioin_logic_ch0 WHEN (tx0_phy = 1) ELSE txdprioin_logic_ch1 WHEN (tx1_phy = 1) ELSE txdprioin_logic_ch2 WHEN (tx2_phy = 1) ELSE txdprioin_logic_ch3;
txdprioin_phy_ch2 <=  txdprioin_logic_ch0 WHEN (tx0_phy = 2) ELSE txdprioin_logic_ch1 WHEN (tx1_phy = 2) ELSE txdprioin_logic_ch2 WHEN (tx2_phy = 2) ELSE txdprioin_logic_ch3;
txdprioin_phy_ch3 <=  txdprioin_logic_ch0 WHEN (tx0_phy = 3) ELSE txdprioin_logic_ch1 WHEN (tx1_phy = 3) ELSE txdprioin_logic_ch2 WHEN (tx2_phy = 3) ELSE txdprioin_logic_ch3;


-- phy map: output is phy --> logic
rxdprioout_logic_ch0 <=  rxdprioout_phy_ch0 WHEN (rx0_phy = 0) ELSE rxdprioout_phy_ch1 WHEN (rx0_phy = 1) ELSE rxdprioout_phy_ch2 WHEN (rx0_phy = 2) ELSE rxdprioout_phy_ch3;
rxdprioout_logic_ch1 <=  rxdprioout_phy_ch0 WHEN (rx1_phy = 0) ELSE rxdprioout_phy_ch1 WHEN (rx1_phy = 1) ELSE rxdprioout_phy_ch2 WHEN (rx1_phy = 2) ELSE rxdprioout_phy_ch3;
rxdprioout_logic_ch2 <=  rxdprioout_phy_ch0 WHEN (rx2_phy = 0) ELSE rxdprioout_phy_ch1 WHEN (rx2_phy = 1) ELSE rxdprioout_phy_ch2 WHEN (rx2_phy = 2) ELSE rxdprioout_phy_ch3;
rxdprioout_logic_ch3 <=  rxdprioout_phy_ch0 WHEN (rx3_phy = 0) ELSE rxdprioout_phy_ch1 WHEN (rx3_phy = 1) ELSE rxdprioout_phy_ch2 WHEN (rx3_phy = 2) ELSE rxdprioout_phy_ch3;

txdprioout_logic_ch0 <=  txdprioout_phy_ch0 WHEN (tx0_phy = 0) ELSE txdprioout_phy_ch1 WHEN (tx0_phy = 1) ELSE txdprioout_phy_ch2 WHEN (tx0_phy = 2) ELSE txdprioout_phy_ch3;
txdprioout_logic_ch1 <=  txdprioout_phy_ch0 WHEN (tx1_phy = 0) ELSE txdprioout_phy_ch1 WHEN (tx1_phy = 1) ELSE txdprioout_phy_ch2 WHEN (tx1_phy = 2) ELSE txdprioout_phy_ch3;
txdprioout_logic_ch2 <=  txdprioout_phy_ch0 WHEN (tx2_phy = 0) ELSE txdprioout_phy_ch1 WHEN (tx2_phy = 1) ELSE txdprioout_phy_ch2 WHEN (tx2_phy = 2) ELSE txdprioout_phy_ch3;
txdprioout_logic_ch3 <=  txdprioout_phy_ch0 WHEN (tx3_phy = 0) ELSE txdprioout_phy_ch1 WHEN (tx3_phy = 1) ELSE txdprioout_phy_ch2 WHEN (tx3_phy = 2) ELSE txdprioout_phy_ch3;

                              
-- TX PMA CRAM - input (parameter) ----------------------------------------------------

-- pma_ctrl1: 4.8060-4.8063 (tx)
rtx_vod_sel_ch0  <= txdprioin_phy_ch0(TX_PMA_ST+15 DOWNTO TX_PMA_ST+13);    -- 3-bits
rtx_slewrate(0)  <= txdprioin_phy_ch0(TX_PMA_ST+12);                   -- 1-bit
rpmphs_2tap_ch0  <= txdprioin_phy_ch0(TX_PMA_ST+11 DOWNTO TX_PMA_ST+9);     -- 3
rpmphs_1tap_ch0  <= txdprioin_phy_ch0(TX_PMA_ST+8  DOWNTO TX_PMA_ST+5);     -- 4 
rtx_vtt_ch0      <= txdprioin_phy_ch0(TX_PMA_ST+4  DOWNTO TX_PMA_ST+3);     -- 2 - to add in wys
rpmphs_ptap_ch0  <= txdprioin_phy_ch0(TX_PMA_ST+2  DOWNTO TX_PMA_ST);       -- 3

rtx_vod_sel_ch1  <= txdprioin_phy_ch1(TX_PMA_ST+15 DOWNTO TX_PMA_ST+13);    -- 3-bits
rtx_slewrate(1)  <= txdprioin_phy_ch1(TX_PMA_ST+12);                   -- 1-bit
rpmphs_2tap_ch1  <= txdprioin_phy_ch1(TX_PMA_ST+11 DOWNTO TX_PMA_ST+9);     -- 3
rpmphs_1tap_ch1  <= txdprioin_phy_ch1(TX_PMA_ST+8  DOWNTO TX_PMA_ST+5);     -- 4 
rtx_vtt_ch1      <= txdprioin_phy_ch1(TX_PMA_ST+4  DOWNTO TX_PMA_ST+3);     -- 2 - to add in wys
rpmphs_ptap_ch1  <= txdprioin_phy_ch1(TX_PMA_ST+2  DOWNTO TX_PMA_ST);       -- 3

rtx_vod_sel_ch2  <= txdprioin_phy_ch2(TX_PMA_ST+15 DOWNTO TX_PMA_ST+13);    -- 3-bits
rtx_slewrate(2)  <= txdprioin_phy_ch2(TX_PMA_ST+12);                   -- 1-bit
rpmphs_2tap_ch2  <= txdprioin_phy_ch2(TX_PMA_ST+11 DOWNTO TX_PMA_ST+9);     -- 3
rpmphs_1tap_ch2  <= txdprioin_phy_ch2(TX_PMA_ST+8  DOWNTO TX_PMA_ST+5);     -- 4 
rtx_vtt_ch2      <= txdprioin_phy_ch2(TX_PMA_ST+4  DOWNTO TX_PMA_ST+3);     -- 2 - to add in wys
rpmphs_ptap_ch2  <= txdprioin_phy_ch2(TX_PMA_ST+2  DOWNTO TX_PMA_ST);       -- 3

rtx_vod_sel_ch3  <= txdprioin_phy_ch3(TX_PMA_ST+15 DOWNTO TX_PMA_ST+13);    -- 3-bits
rtx_slewrate(3)  <= txdprioin_phy_ch3(TX_PMA_ST+12);                   -- 1-bit
rpmphs_2tap_ch3  <= txdprioin_phy_ch3(TX_PMA_ST+11 DOWNTO TX_PMA_ST+9);     -- 3
rpmphs_1tap_ch3  <= txdprioin_phy_ch3(TX_PMA_ST+8  DOWNTO TX_PMA_ST+5);     -- 4 
rtx_vtt_ch3      <= txdprioin_phy_ch3(TX_PMA_ST+4  DOWNTO TX_PMA_ST+3);     -- 2 - to add in wys
rpmphs_ptap_ch3  <= txdprioin_phy_ch3(TX_PMA_ST+2  DOWNTO TX_PMA_ST);       -- 3

-- pma_ctrl8: 4.807c-807h - skipping other 14 bits
rs_lpbk(3 DOWNTO 0)     <= "0000";            -- 15
r_rlpbk(3 DOWNTO 0)     <= "0000";            -- 14
rs_rdlpbk(3 DOWNTO 0)   <= "0000";            -- 13
rrx_revlb_sw(3 DOWNTO 0)<= "0000";            -- 12
rurx_pdb(3 DOWNTO 0)    <= "0000";            -- 11
rtx_cgb_pdb(3 DOWNTO 0) <= "1111";            -- 10
rtx_ob_pdb(3 DOWNTO 0)  <= "1111";            -- 9
rrx_cru_pdb(3 DOWNTO 0) <= "1111";            -- 8
rrx_cru_rst(3 DOWNTO 0) <= "0000";            -- 7 
rrx_ib_pdb(3 DOWNTO 0)  <= "1111";            -- 6
rrxurstpma(3 DOWNTO 0)  <= "0000";            -- 5
radce_adapt(3 DOWNTO 0) <= "1111";            -- 4
radce_pdb(3 DOWNTO 0)   <= "1111";            -- 3
radce_rst(3 DOWNTO 0)   <= "0000";            -- 2

rsig_inv_2tap(0) <= txdprioin_phy_ch0(TX_PMA_ST+17);       -- 1 
rsig_inv_pre(0)  <= txdprioin_phy_ch0(TX_PMA_ST+16);       -- 1

rsig_inv_2tap(1) <= txdprioin_phy_ch1(TX_PMA_ST+17);       -- 1 
rsig_inv_pre(1)  <= txdprioin_phy_ch1(TX_PMA_ST+16);       -- 1

rsig_inv_2tap(2) <= txdprioin_phy_ch2(TX_PMA_ST+17);       -- 1 
rsig_inv_pre(2)  <= txdprioin_phy_ch2(TX_PMA_ST+16);       -- 1

rsig_inv_2tap(3) <= txdprioin_phy_ch3(TX_PMA_ST+17);       -- 1 
rsig_inv_pre(3)  <= txdprioin_phy_ch3(TX_PMA_ST+16);       -- 1

-- txpma_ctrl_input_to_add  


-- TX PMA - output -----------------------------------------------------------------------------

-- pma_ctrl1: 4.8060-4.8063 (tx)
txdprioout_phy_ch0(TX_PMA_ST+15 DOWNTO TX_PMA_ST+13)<= rtx_vod_sel_ch0_int;    -- 3-bits - qpmaused
txdprioout_phy_ch0(TX_PMA_ST+12)               <= rtx_slewrate_int(0);   -- 1-bit
txdprioout_phy_ch0(TX_PMA_ST+11 DOWNTO TX_PMA_ST+9) <= rpmphs_2tap_ch0_int;    -- 3  - qpmaused
txdprioout_phy_ch0(TX_PMA_ST+8 DOWNTO TX_PMA_ST+5)  <= rpmphs_1tap_ch0_int;    -- 4  - qpmaused
txdprioout_phy_ch0(TX_PMA_ST+4 DOWNTO TX_PMA_ST+3)  <= rtx_vtt_ch0_int;        -- 2 - to add in wys
txdprioout_phy_ch0(TX_PMA_ST+2 DOWNTO TX_PMA_ST)    <= rpmphs_ptap_ch0_int;    -- 3 - qpmaused

txdprioout_phy_ch1(TX_PMA_ST+15 DOWNTO TX_PMA_ST+13)<= rtx_vod_sel_ch1_int;    -- 3-bits
txdprioout_phy_ch1(TX_PMA_ST+12)               <= rtx_slewrate_int(1);   -- 1-bit
txdprioout_phy_ch1(TX_PMA_ST+11 DOWNTO TX_PMA_ST+9) <= rpmphs_2tap_ch1_int;    -- 3
txdprioout_phy_ch1(TX_PMA_ST+8 DOWNTO TX_PMA_ST+5)  <= rpmphs_1tap_ch1_int;    -- 4 
txdprioout_phy_ch1(TX_PMA_ST+4 DOWNTO TX_PMA_ST+3)  <= rtx_vtt_ch1_int;        -- 2 - to add in wys
txdprioout_phy_ch1(TX_PMA_ST+2 DOWNTO TX_PMA_ST)    <= rpmphs_ptap_ch1_int;    -- 3

txdprioout_phy_ch2(TX_PMA_ST+15 DOWNTO TX_PMA_ST+13)<= rtx_vod_sel_ch2_int;    -- 3-bits
txdprioout_phy_ch2(TX_PMA_ST+12)               <= rtx_slewrate_int(2);   -- 1-bit
txdprioout_phy_ch2(TX_PMA_ST+11 DOWNTO TX_PMA_ST+9) <= rpmphs_2tap_ch2_int;    -- 3
txdprioout_phy_ch2(TX_PMA_ST+8 DOWNTO TX_PMA_ST+5)  <= rpmphs_1tap_ch2_int;    -- 4 
txdprioout_phy_ch2(TX_PMA_ST+4 DOWNTO TX_PMA_ST+3)  <= rtx_vtt_ch2_int;        -- 2 - to add in wys
txdprioout_phy_ch2(TX_PMA_ST+2 DOWNTO TX_PMA_ST)    <= rpmphs_ptap_ch2_int;    -- 3

txdprioout_phy_ch3(TX_PMA_ST+15 DOWNTO TX_PMA_ST+13)<= rtx_vod_sel_ch3_int;    -- 3-bits
txdprioout_phy_ch3(TX_PMA_ST+12)               <= rtx_slewrate_int(3);   -- 1-bit
txdprioout_phy_ch3(TX_PMA_ST+11 DOWNTO TX_PMA_ST+9) <= rpmphs_2tap_ch3_int;    -- 3
txdprioout_phy_ch3(TX_PMA_ST+8 DOWNTO TX_PMA_ST+5)  <= rpmphs_1tap_ch3_int;    -- 4 
txdprioout_phy_ch3(TX_PMA_ST+4 DOWNTO TX_PMA_ST+3)  <= rtx_vtt_ch3_int;        -- 2 - to add in wys
txdprioout_phy_ch3(TX_PMA_ST+2 DOWNTO TX_PMA_ST)    <= rpmphs_ptap_ch3_int;    -- 3 

-- pma_ctrl8: 4.807c-807h - skipping other 14 bits
txdprioout_phy_ch0(TX_PMA_ST+16+15 DOWNTO TX_PMA_ST+16+2) <= "00000000000000";  -- 14 
txdprioout_phy_ch0(TX_PMA_ST+17) <= rsig_inv_2tap_int(0);  -- 1 
txdprioout_phy_ch0(TX_PMA_ST+16) <= rsig_inv_pre_int(0);   -- 1

txdprioout_phy_ch1(TX_PMA_ST+16+15 DOWNTO TX_PMA_ST+16+2) <= "00000000000000";  -- 14 
txdprioout_phy_ch1(TX_PMA_ST+17) <= rsig_inv_2tap_int(1);  -- 1 
txdprioout_phy_ch1(TX_PMA_ST+16) <= rsig_inv_pre_int(1);   -- 1

txdprioout_phy_ch2(TX_PMA_ST+16+15 DOWNTO TX_PMA_ST+16+2) <= "00000000000000";  -- 14 
txdprioout_phy_ch2(TX_PMA_ST+17) <= rsig_inv_2tap_int(2);  -- 1 
txdprioout_phy_ch2(TX_PMA_ST+16) <= rsig_inv_pre_int(2);   -- 1

txdprioout_phy_ch3(TX_PMA_ST+16+15 DOWNTO TX_PMA_ST+16+2) <= "00000000000000";  -- 14 
txdprioout_phy_ch3(TX_PMA_ST+17) <= rsig_inv_2tap_int(3);  -- 1 
txdprioout_phy_ch3(TX_PMA_ST+16) <= rsig_inv_pre_int(3);   -- 1

-- txpma_ctrl_output_to_add  - make sure _int is used


-- RX PMA - input-----------------------------------------------------------------------------

-- pma_ctrl2: 4.8064-4.8067 (rx)
rtx_term_ch0     <= rxdprioin_phy_ch0(RX_PMA_ST+15 DOWNTO RX_PMA_ST+14);      -- 2-bits
r_tx_det_rx_ch0  <= rxdprioin_phy_ch0(RX_PMA_ST+13 DOWNTO RX_PMA_ST+12);      -- 2-bit
rrx_term_ch0     <= rxdprioin_phy_ch0(RX_PMA_ST+11 DOWNTO RX_PMA_ST+10);      -- 2
rforce_sigdet(0) <= rxdprioin_phy_ch0(RX_PMA_ST+9);                      -- 1 
rrx_dc_couple(0) <= rxdprioin_phy_ch0(RX_PMA_ST+8);                      -- 1
rrx_eq_dc_ch0    <= rxdprioin_phy_ch0(RX_PMA_ST+7  DOWNTO RX_PMA_ST+6);       -- 2 - qpmaused
rrx_vtt_ch0      <= rxdprioin_phy_ch0(RX_PMA_ST+5  DOWNTO RX_PMA_ST+3);       -- 3
rrx_sloslv_ch0   <= rxdprioin_phy_ch0(RX_PMA_ST+2  DOWNTO RX_PMA_ST);         -- 3

rtx_term_ch1     <= rxdprioin_phy_ch1(RX_PMA_ST+15 DOWNTO RX_PMA_ST+14);      -- 2-bits
r_tx_det_rx_ch1  <= rxdprioin_phy_ch1(RX_PMA_ST+13 DOWNTO RX_PMA_ST+12);      -- 2-bit
rrx_term_ch1     <= rxdprioin_phy_ch1(RX_PMA_ST+11 DOWNTO RX_PMA_ST+10);      -- 2
rforce_sigdet(1) <= rxdprioin_phy_ch1(RX_PMA_ST+9);                      -- 1 
rrx_dc_couple(1) <= rxdprioin_phy_ch1(RX_PMA_ST+8);                      -- 1 - 
rrx_eq_dc_ch1    <= rxdprioin_phy_ch1(RX_PMA_ST+7  DOWNTO RX_PMA_ST+6);       -- 2
rrx_vtt_ch1      <= rxdprioin_phy_ch1(RX_PMA_ST+5  DOWNTO RX_PMA_ST+3);       -- 3
rrx_sloslv_ch1   <= rxdprioin_phy_ch1(RX_PMA_ST+2  DOWNTO RX_PMA_ST);         -- 3

rtx_term_ch2     <= rxdprioin_phy_ch2(RX_PMA_ST+15 DOWNTO RX_PMA_ST+14);      -- 2-bits
r_tx_det_rx_ch2  <= rxdprioin_phy_ch2(RX_PMA_ST+13 DOWNTO RX_PMA_ST+12);      -- 2-bit
rrx_term_ch2     <= rxdprioin_phy_ch2(RX_PMA_ST+11 DOWNTO RX_PMA_ST+10);      -- 2
rforce_sigdet(2) <= rxdprioin_phy_ch2(RX_PMA_ST+9);                      -- 1 
rrx_dc_couple(2) <= rxdprioin_phy_ch2(RX_PMA_ST+8);                      -- 1 - 
rrx_eq_dc_ch2    <= rxdprioin_phy_ch2(RX_PMA_ST+7  DOWNTO RX_PMA_ST+6);       -- 2
rrx_vtt_ch2      <= rxdprioin_phy_ch2(RX_PMA_ST+5  DOWNTO RX_PMA_ST+3);       -- 3
rrx_sloslv_ch2   <= rxdprioin_phy_ch2(RX_PMA_ST+2  DOWNTO RX_PMA_ST);         -- 3

rtx_term_ch3     <= rxdprioin_phy_ch3(RX_PMA_ST+15 DOWNTO RX_PMA_ST+14);      -- 2-bits
r_tx_det_rx_ch3  <= rxdprioin_phy_ch3(RX_PMA_ST+13 DOWNTO RX_PMA_ST+12);      -- 2-bit
rrx_term_ch3     <= rxdprioin_phy_ch3(RX_PMA_ST+11 DOWNTO RX_PMA_ST+10);      -- 2
rforce_sigdet(3) <= rxdprioin_phy_ch3(RX_PMA_ST+9);                      -- 1 
rrx_dc_couple(3) <= rxdprioin_phy_ch3(RX_PMA_ST+8);                      -- 1 - 
rrx_eq_dc_ch3    <= rxdprioin_phy_ch3(RX_PMA_ST+7  DOWNTO RX_PMA_ST+6);       -- 2
rrx_vtt_ch3      <= rxdprioin_phy_ch3(RX_PMA_ST+5  DOWNTO RX_PMA_ST+3);       -- 3
rrx_sloslv_ch3   <= rxdprioin_phy_ch3(RX_PMA_ST+2  DOWNTO RX_PMA_ST);         -- 3

-- pma_ctrl3: 4.8068-4.806b (rx)
reqa_ct_ch0     <= rxdprioin_phy_ch0(RX_PMA_ST+16+15 DOWNTO RX_PMA_ST+16+13); -- 3-bits  - qpmaused
reqb_ct_ch0     <= rxdprioin_phy_ch0(RX_PMA_ST+16+12 DOWNTO RX_PMA_ST+16+10); -- 3-bit - qpmaused
reqc_ct_ch0     <= rxdprioin_phy_ch0(RX_PMA_ST+16+9 DOWNTO RX_PMA_ST+16+7);   -- 3 - qpmaused
reqd_ct_ch0     <= rxdprioin_phy_ch0(RX_PMA_ST+16+6 DOWNTO RX_PMA_ST+16+4);   -- 3 - qpmaused 
req_ctv_ch0     <= rxdprioin_phy_ch0(RX_PMA_ST+16+3 DOWNTO RX_PMA_ST+16+1);   -- 3 - qpmaused
                                                                               -- 1 - unused

reqa_ct_ch1     <= rxdprioin_phy_ch1(RX_PMA_ST+16+15 DOWNTO RX_PMA_ST+16+13); -- 3-bits  - 
reqb_ct_ch1     <= rxdprioin_phy_ch1(RX_PMA_ST+16+12 DOWNTO RX_PMA_ST+16+10); -- 3-bit - 
reqc_ct_ch1     <= rxdprioin_phy_ch1(RX_PMA_ST+16+9 DOWNTO RX_PMA_ST+16+7);   -- 3 - 
reqd_ct_ch1     <= rxdprioin_phy_ch1(RX_PMA_ST+16+6 DOWNTO RX_PMA_ST+16+4);   -- 3 -  
req_ctv_ch1     <= rxdprioin_phy_ch1(RX_PMA_ST+16+3 DOWNTO RX_PMA_ST+16+1);   -- 3 - 
                                                                               -- 1 - unused

reqa_ct_ch2     <= rxdprioin_phy_ch2(RX_PMA_ST+16+15 DOWNTO RX_PMA_ST+16+13); -- 3-bits  - 
reqb_ct_ch2     <= rxdprioin_phy_ch2(RX_PMA_ST+16+12 DOWNTO RX_PMA_ST+16+10); -- 3-bit - 
reqc_ct_ch2     <= rxdprioin_phy_ch2(RX_PMA_ST+16+9 DOWNTO RX_PMA_ST+16+7);   -- 3 - 
reqd_ct_ch2     <= rxdprioin_phy_ch2(RX_PMA_ST+16+6 DOWNTO RX_PMA_ST+16+4);   -- 3 -  
req_ctv_ch2     <= rxdprioin_phy_ch2(RX_PMA_ST+16+3 DOWNTO RX_PMA_ST+16+1);   -- 3 - 
                                                                               -- 1 - unused

reqa_ct_ch3     <= rxdprioin_phy_ch3(RX_PMA_ST+16+15 DOWNTO RX_PMA_ST+16+13); -- 3-bits  - 
reqb_ct_ch3     <= rxdprioin_phy_ch3(RX_PMA_ST+16+12 DOWNTO RX_PMA_ST+16+10); -- 3-bit - 
reqc_ct_ch3     <= rxdprioin_phy_ch3(RX_PMA_ST+16+9 DOWNTO RX_PMA_ST+16+7);   -- 3 - 
reqd_ct_ch3     <= rxdprioin_phy_ch3(RX_PMA_ST+16+6 DOWNTO RX_PMA_ST+16+4);   -- 3 -  
req_ctv_ch3     <= rxdprioin_phy_ch3(RX_PMA_ST+16+3 DOWNTO RX_PMA_ST+16+1);   -- 3 - 
                                                                               -- 1 - unused
-- rxpma_ctrl_input_to_add

-- RX PMA - output -----------------------------------------------------------------------------

-- pma_ctrl2: 4.8064-4.8067 (rx)
rxdprioout_phy_ch0(RX_PMA_ST+15 DOWNTO RX_PMA_ST+14) <= rtx_term_ch0_int;      -- 2-bits
rxdprioout_phy_ch0(RX_PMA_ST+13 DOWNTO RX_PMA_ST+12) <= r_tx_det_rx_ch0_int;   -- 2-bit
rxdprioout_phy_ch0(RX_PMA_ST+11 DOWNTO RX_PMA_ST+10) <= rrx_term_ch0_int;      -- 2
rxdprioout_phy_ch0(RX_PMA_ST+9)                 <= rforce_sigdet_int(0);  -- 1 
rxdprioout_phy_ch0(RX_PMA_ST+8)                 <= rrx_dc_couple_int(0);  -- 1
rxdprioout_phy_ch0(RX_PMA_ST+7  DOWNTO RX_PMA_ST+6)  <= rrx_eq_dc_ch0_int;     -- 2 - qpmaused
rxdprioout_phy_ch0(RX_PMA_ST+5  DOWNTO RX_PMA_ST+3)  <= rrx_vtt_ch0_int;       -- 3
rxdprioout_phy_ch0(RX_PMA_ST+2  DOWNTO RX_PMA_ST)    <= rrx_sloslv_ch0_int;    -- 3

rxdprioout_phy_ch1(RX_PMA_ST+15 DOWNTO RX_PMA_ST+14) <= rtx_term_ch1_int;      -- 2-bits
rxdprioout_phy_ch1(RX_PMA_ST+13 DOWNTO RX_PMA_ST+12) <= r_tx_det_rx_ch1_int;   -- 2-bit
rxdprioout_phy_ch1(RX_PMA_ST+11 DOWNTO RX_PMA_ST+10) <= rrx_term_ch1_int;      -- 2
rxdprioout_phy_ch1(RX_PMA_ST+9)                 <= rforce_sigdet_int(1);  -- 1 
rxdprioout_phy_ch1(RX_PMA_ST+8)                 <= rrx_dc_couple_int(1);  -- 1 - 
rxdprioout_phy_ch1(RX_PMA_ST+7  DOWNTO RX_PMA_ST+6)  <= rrx_eq_dc_ch1_int;     -- 2
rxdprioout_phy_ch1(RX_PMA_ST+5  DOWNTO RX_PMA_ST+3)  <= rrx_vtt_ch1_int;       -- 3
rxdprioout_phy_ch1(RX_PMA_ST+2  DOWNTO RX_PMA_ST)    <= rrx_sloslv_ch1_int;    -- 3

rxdprioout_phy_ch2(RX_PMA_ST+15 DOWNTO RX_PMA_ST+14) <= rtx_term_ch2_int;      -- 2-bits
rxdprioout_phy_ch2(RX_PMA_ST+13 DOWNTO RX_PMA_ST+12) <= r_tx_det_rx_ch2_int;   -- 2-bit
rxdprioout_phy_ch2(RX_PMA_ST+11 DOWNTO RX_PMA_ST+10) <= rrx_term_ch2_int;      -- 2
rxdprioout_phy_ch2(RX_PMA_ST+9)                 <= rforce_sigdet_int(2);  -- 1 
rxdprioout_phy_ch2(RX_PMA_ST+8)                 <= rrx_dc_couple_int(2);  -- 1 - 
rxdprioout_phy_ch2(RX_PMA_ST+7  DOWNTO RX_PMA_ST+6)  <= rrx_eq_dc_ch2_int;     -- 2
rxdprioout_phy_ch2(RX_PMA_ST+5  DOWNTO RX_PMA_ST+3)  <= rrx_vtt_ch2_int;       -- 3
rxdprioout_phy_ch2(RX_PMA_ST+2  DOWNTO RX_PMA_ST)    <= rrx_sloslv_ch2_int;    -- 3

rxdprioout_phy_ch3(RX_PMA_ST+15 DOWNTO RX_PMA_ST+14) <= rtx_term_ch3_int;      -- 2-bits
rxdprioout_phy_ch3(RX_PMA_ST+13 DOWNTO RX_PMA_ST+12) <= r_tx_det_rx_ch3_int;   -- 2-bit
rxdprioout_phy_ch3(RX_PMA_ST+11 DOWNTO RX_PMA_ST+10) <= rrx_term_ch3_int;      -- 2
rxdprioout_phy_ch3(RX_PMA_ST+9)                 <= rforce_sigdet_int(3);  -- 1 
rxdprioout_phy_ch3(RX_PMA_ST+8)                 <= rrx_dc_couple_int(3);  -- 1 - 
rxdprioout_phy_ch3(RX_PMA_ST+7  DOWNTO RX_PMA_ST+6)  <= rrx_eq_dc_ch3_int;         -- 2
rxdprioout_phy_ch3(RX_PMA_ST+5  DOWNTO RX_PMA_ST+3)  <= rrx_vtt_ch3_int;           -- 3
rxdprioout_phy_ch3(RX_PMA_ST+2  DOWNTO RX_PMA_ST)    <= rrx_sloslv_ch3_int;        -- 3

-- pma_ctrl3: 4.8068-4.806b (rx)
rxdprioout_phy_ch0(RX_PMA_ST+16+15 DOWNTO RX_PMA_ST+16+13) <= reqa_ct_ch0_int;    -- 3-bits  - qpmaused
rxdprioout_phy_ch0(RX_PMA_ST+16+12 DOWNTO RX_PMA_ST+16+10) <= reqb_ct_ch0_int;    -- 3-bit - qpmaused
rxdprioout_phy_ch0(RX_PMA_ST+16+9 DOWNTO  RX_PMA_ST+16+7)  <= reqc_ct_ch0_int;    -- 3 - qpmaused
rxdprioout_phy_ch0(RX_PMA_ST+16+6 DOWNTO  RX_PMA_ST+16+4)  <= reqd_ct_ch0_int;    -- 3 - qpmaused 
rxdprioout_phy_ch0(RX_PMA_ST+16+3 DOWNTO  RX_PMA_ST+16+1)  <= req_ctv_ch0_int;    -- 3 - qpmaused
rxdprioout_phy_ch0(RX_PMA_ST+16)                      <= '0';           -- 1 - used

rxdprioout_phy_ch1(RX_PMA_ST+16+15 DOWNTO RX_PMA_ST+16+13) <= reqa_ct_ch1_int;    -- 3-bits  - 
rxdprioout_phy_ch1(RX_PMA_ST+16+12 DOWNTO RX_PMA_ST+16+10) <= reqb_ct_ch1_int;    -- 3-bit - 
rxdprioout_phy_ch1(RX_PMA_ST+16+9 DOWNTO  RX_PMA_ST+16+7)  <= reqc_ct_ch1_int;    -- 3 - 
rxdprioout_phy_ch1(RX_PMA_ST+16+6 DOWNTO  RX_PMA_ST+16+4)  <= reqd_ct_ch1_int;    -- 3 -  
rxdprioout_phy_ch1(RX_PMA_ST+16+3 DOWNTO  RX_PMA_ST+16+1)  <= req_ctv_ch1_int;    -- 3 - 
rxdprioout_phy_ch1(RX_PMA_ST+16)                      <= '0';           -- 1 - used

rxdprioout_phy_ch2(RX_PMA_ST+16+15 DOWNTO RX_PMA_ST+16+13) <= reqa_ct_ch2_int;    -- 3-bits  - 
rxdprioout_phy_ch2(RX_PMA_ST+16+12 DOWNTO RX_PMA_ST+16+10) <= reqb_ct_ch2_int;    -- 3-bit - 
rxdprioout_phy_ch2(RX_PMA_ST+16+9 DOWNTO  RX_PMA_ST+16+7)  <= reqc_ct_ch2_int;    -- 3 - 
rxdprioout_phy_ch2(RX_PMA_ST+16+6 DOWNTO  RX_PMA_ST+16+4)  <= reqd_ct_ch2_int;    -- 3 -  
rxdprioout_phy_ch2(RX_PMA_ST+16+3 DOWNTO  RX_PMA_ST+16+1)  <= req_ctv_ch2_int;    -- 3 - 
rxdprioout_phy_ch2(RX_PMA_ST+16)                      <= '0';           -- 1 - used

rxdprioout_phy_ch3(RX_PMA_ST+16+15 DOWNTO RX_PMA_ST+16+13) <= reqa_ct_ch3_int;    -- 3-bits  - 
rxdprioout_phy_ch3(RX_PMA_ST+16+12 DOWNTO RX_PMA_ST+16+10) <= reqb_ct_ch3_int;    -- 3-bit - 
rxdprioout_phy_ch3(RX_PMA_ST+16+9 DOWNTO  RX_PMA_ST+16+7)  <= reqc_ct_ch3_int;    -- 3 - 
rxdprioout_phy_ch3(RX_PMA_ST+16+6 DOWNTO  RX_PMA_ST+16+4)  <= reqd_ct_ch3_int;    -- 3 -  
rxdprioout_phy_ch3(RX_PMA_ST+16+3 DOWNTO  RX_PMA_ST+16+1)  <= req_ctv_ch3_int;    -- 3 - 
rxdprioout_phy_ch3(RX_PMA_ST+16)                      <= '0';           -- 1 - used

-- rxpma_ctrl_output_to_add  - make sure _int is used


-- PCS  - rx and tx mixed together within the 16-bit register

-- PCS input -----------------------------------------------------------------------------

-- PCS_CTRL8
rfreerun_tx <= "0000";  -- for POF
rtxwrclksel <= "0000";
rtxrdclksel <= "1111"; 
rfreerun_rx <= "0000";  -- for POF
rrcvd_clk_sel_ch0  <= rxdprioin_phy_ch0(rrcvd_clk_sel_DP_RX_IDX_1 DOWNTO rrcvd_clk_sel_DP_RX_IDX_0);    -- dprio_enabled: bits 11-10 
rclk_1_sel_ch0     <= rxdprioin_phy_ch0(rclk_1_sel_DP_RX_IDX_1    DOWNTO rclk_1_sel_DP_RX_IDX_0);       -- dprio_enabled: bits 9-8 
rclk_2_sel_ch0     <= rxdprioin_phy_ch0(rclk_2_sel_DP_RX_IDX_1    DOWNTO rclk_2_sel_DP_RX_IDX_0);       -- dprio_enabled: bits 7-6
rrx_rd_clk_sel  <= "1111";
renumber_ch0    <= "000"; 
renumber_ch1    <= "000"; 
renumber_ch2    <= "000"; 
renumber_ch3    <= "000"; 
renpolinv_rx    <= "0000"; 
rclkcmpinsertpad<= "0000";

rrcvd_clk_sel_ch1  <= rxdprioin_phy_ch1(rrcvd_clk_sel_DP_RX_IDX_1 DOWNTO rrcvd_clk_sel_DP_RX_IDX_0);    -- dprio_enabled: bits 11-10 
rclk_1_sel_ch1     <= rxdprioin_phy_ch1(rclk_1_sel_DP_RX_IDX_1    DOWNTO rclk_1_sel_DP_RX_IDX_0);       -- dprio_enabled: bits 9-8 
rclk_2_sel_ch1     <= rxdprioin_phy_ch1(rclk_2_sel_DP_RX_IDX_1    DOWNTO rclk_2_sel_DP_RX_IDX_0);       -- dprio_enabled: bits 7-6

rrcvd_clk_sel_ch2  <= rxdprioin_phy_ch2(rrcvd_clk_sel_DP_RX_IDX_1 DOWNTO rrcvd_clk_sel_DP_RX_IDX_0);    -- dprio_enabled: bits 11-10 
rclk_1_sel_ch2     <= rxdprioin_phy_ch2(rclk_1_sel_DP_RX_IDX_1    DOWNTO rclk_1_sel_DP_RX_IDX_0);       -- dprio_enabled: bits 9-8 
rclk_2_sel_ch2     <= rxdprioin_phy_ch2(rclk_2_sel_DP_RX_IDX_1    DOWNTO rclk_2_sel_DP_RX_IDX_0);       -- dprio_enabled: bits 7-6

rrcvd_clk_sel_ch3  <= rxdprioin_phy_ch3(rrcvd_clk_sel_DP_RX_IDX_1 DOWNTO rrcvd_clk_sel_DP_RX_IDX_0);    -- dprio_enabled: bits 11-10 
rclk_1_sel_ch3     <= rxdprioin_phy_ch3(rclk_1_sel_DP_RX_IDX_1    DOWNTO rclk_1_sel_DP_RX_IDX_0);       -- dprio_enabled: bits 9-8 
rclk_2_sel_ch3     <= rxdprioin_phy_ch3(rclk_2_sel_DP_RX_IDX_1    DOWNTO rclk_2_sel_DP_RX_IDX_0);       -- dprio_enabled: bits 7-6

-- pcs_ctrl in to add

-- PCS output -----------------------------------------------------------------------------

-- PCS_CTRL8
rxdprioout_phy_ch0(rrcvd_clk_sel_DP_RX_IDX_1 DOWNTO rrcvd_clk_sel_DP_RX_IDX_0) <= rrcvd_clk_sel_ch0_int ; -- dprio_enabled: bits 11-10 
rxdprioout_phy_ch0(rclk_1_sel_DP_RX_IDX_1    DOWNTO rclk_1_sel_DP_RX_IDX_0)    <= rclk_1_sel_ch0_int;     -- dprio_enabled: bits 9-8 
rxdprioout_phy_ch0(rclk_2_sel_DP_RX_IDX_1    DOWNTO rclk_2_sel_DP_RX_IDX_0)    <= rclk_2_sel_ch0_int;     -- dprio_enabled: bits 7-6

rxdprioout_phy_ch1(rrcvd_clk_sel_DP_RX_IDX_1 DOWNTO rrcvd_clk_sel_DP_RX_IDX_0) <= rrcvd_clk_sel_ch1_int ; -- dprio_enabled: bits 11-10 
rxdprioout_phy_ch1(rclk_1_sel_DP_RX_IDX_1    DOWNTO rclk_1_sel_DP_RX_IDX_0)    <= rclk_1_sel_ch1_int;     -- dprio_enabled: bits 9-8 
rxdprioout_phy_ch1(rclk_2_sel_DP_RX_IDX_1    DOWNTO rclk_2_sel_DP_RX_IDX_0)    <= rclk_2_sel_ch1_int;     -- dprio_enabled: bits 7-6

rxdprioout_phy_ch2(rrcvd_clk_sel_DP_RX_IDX_1 DOWNTO rrcvd_clk_sel_DP_RX_IDX_0) <= rrcvd_clk_sel_ch2_int ; -- dprio_enabled: bits 11-10 
rxdprioout_phy_ch2(rclk_1_sel_DP_RX_IDX_1    DOWNTO rclk_1_sel_DP_RX_IDX_0)    <= rclk_1_sel_ch2_int;     -- dprio_enabled: bits 9-8 
rxdprioout_phy_ch2(rclk_2_sel_DP_RX_IDX_1    DOWNTO rclk_2_sel_DP_RX_IDX_0)    <= rclk_2_sel_ch2_int;     -- dprio_enabled: bits 7-6

rxdprioout_phy_ch3(rrcvd_clk_sel_DP_RX_IDX_1 DOWNTO rrcvd_clk_sel_DP_RX_IDX_0) <= rrcvd_clk_sel_ch3_int ; -- dprio_enabled: bits 11-10 
rxdprioout_phy_ch3(rclk_1_sel_DP_RX_IDX_1    DOWNTO rclk_1_sel_DP_RX_IDX_0)    <= rclk_1_sel_ch3_int;     -- dprio_enabled: bits 9-8 
rxdprioout_phy_ch3(rclk_2_sel_DP_RX_IDX_1    DOWNTO rclk_2_sel_DP_RX_IDX_0)    <= rclk_2_sel_ch3_int;     -- dprio_enabled: bits 7-6

-- pcs_ctrl out to add - make sure ended with _int

--------------------------------------------------------------------------------
-- mqmap end                                                                 --
--------------------------------------------------------------------------------

-- XGXS_STATUS1 and XGXS_STATUS2 status registers
xs_link_status_rd <= '1' WHEN (mdio_rd = '1' AND reg_addr=XGXS_STATUS1) ELSE '0'; 
tx_rx_local_fault_status_rd <= '1' WHEN (mdio_rd = '1' AND reg_addr=XGXS_STATUS2) ELSE '0'; 


-- Output data
-- PCS channel0 output
pcs_chnl_0 : mdio_pcs_bus_out_mux
				PORT MAP (
			         pcs_ctrl_in1 => pcs_ctrl1_ch0_reg,
			         pcs_ctrl_in2 => pcs_ctrl2_ch0_reg,
			         pcs_ctrl_in3 => pcs_ctrl3_ch0_reg,
			         pcs_ctrl_in4 => pcs_ctrl4_ch0_reg,
			         pcs_ctrl_in5 => pcs_ctrl5_ch0_reg,
			         pcs_ctrl_in6 => pcs_ctrl6_ch0_reg,
			         pcs_ctrl_in7 => pcs_ctrl7_ch0_reg,
			         pcs_ctrl_in8 => pcs_ctrl8_ch0_reg,
			         pcs_ctrl_in9 => pcs_ctrl9_ch0_reg,
			         pcs_ctrl_in10 => pcs_ctrl10_ch0_reg,
			         pcs_ctrl_in11 => pcs_ctrl11_ch0_reg,
			         pcs_ctrl_in12 => pcs_ctrl12_ch0_reg,
			         pcs_ctrl_in13 => pcs_ctrl13_ch0_reg,
			         pcs_ctrl_in14 => pcs_ctrl14_ch0_reg,
			         pcs_ctrl_in15 => pcs_ctrl15_ch0_reg,
			         pcs_ctrl_in16 => prbs_bist_ctrl_ch0_reg,
			         hw_address_ctrl_in1 => PCS_CTRL1_CH0,
			         hw_address_ctrl_in2 => PCS_CTRL2_CH0,
			         hw_address_ctrl_in3 => PCS_CTRL3_CH0,
			         hw_address_ctrl_in4 => PCS_CTRL4_CH0,
			         hw_address_ctrl_in5 => PCS_CTRL5_CH0,
			         hw_address_ctrl_in6 => PCS_CTRL6_CH0,
			         hw_address_ctrl_in7 => PCS_CTRL7_CH0,
			         hw_address_ctrl_in8 => PCS_CTRL8_CH0,
			         hw_address_ctrl_in9 => PCS_CTRL9_CH0,
			         hw_address_ctrl_in10 => PCS_CTRL10_CH0,
			         hw_address_ctrl_in11 => PCS_CTRL11_CH0,
			         hw_address_ctrl_in12 => PCS_CTRL12_CH0,
			         hw_address_ctrl_in13 => PCS_CTRL13_CH0,
			         hw_address_ctrl_in14 => PCS_CTRL14_CH0,
			         hw_address_ctrl_in15 => PCS_CTRL15_CH0,
			         hw_address_ctrl_in16 => PRBS_BIST_CTRL_CH0,
			         reg_addr => reg_addr,
			         pcs_ctrl_out => pcs_ctrl_out_ch0
				);

-- PCS channel1 output
pcs_chnl_1 : mdio_pcs_bus_out_mux
				PORT MAP (
			         pcs_ctrl_in1 => pcs_ctrl1_ch1_reg,
			         pcs_ctrl_in2 => pcs_ctrl2_ch1_reg,
			         pcs_ctrl_in3 => pcs_ctrl3_ch1_reg,
			         pcs_ctrl_in4 => pcs_ctrl4_ch1_reg,
			         pcs_ctrl_in5 => pcs_ctrl5_ch1_reg,
			         pcs_ctrl_in6 => pcs_ctrl6_ch1_reg,
			         pcs_ctrl_in7 => pcs_ctrl7_ch1_reg,
			         pcs_ctrl_in8 => pcs_ctrl8_ch1_reg,
			         pcs_ctrl_in9 => pcs_ctrl9_ch1_reg,
			         pcs_ctrl_in10 => pcs_ctrl10_ch1_reg,
			         pcs_ctrl_in11 => pcs_ctrl11_ch1_reg,
			         pcs_ctrl_in12 => pcs_ctrl12_ch1_reg,
			         pcs_ctrl_in13 => pcs_ctrl13_ch1_reg,
			         pcs_ctrl_in14 => pcs_ctrl14_ch1_reg,
			         pcs_ctrl_in15 => pcs_ctrl15_ch1_reg,
			         pcs_ctrl_in16 => prbs_bist_ctrl_ch1_reg,
			         hw_address_ctrl_in1 => PCS_CTRL1_CH1,
			         hw_address_ctrl_in2 => PCS_CTRL2_CH1,
			         hw_address_ctrl_in3 => PCS_CTRL3_CH1,
			         hw_address_ctrl_in4 => PCS_CTRL4_CH1,
			         hw_address_ctrl_in5 => PCS_CTRL5_CH1,
			         hw_address_ctrl_in6 => PCS_CTRL6_CH1,
			         hw_address_ctrl_in7 => PCS_CTRL7_CH1,
			         hw_address_ctrl_in8 => PCS_CTRL8_CH1,
			         hw_address_ctrl_in9 => PCS_CTRL9_CH1,
			         hw_address_ctrl_in10 => PCS_CTRL10_CH1,
			         hw_address_ctrl_in11 => PCS_CTRL11_CH1,
			         hw_address_ctrl_in12 => PCS_CTRL12_CH1,
			         hw_address_ctrl_in13 => PCS_CTRL13_CH1,
			         hw_address_ctrl_in14 => PCS_CTRL14_CH1,
			         hw_address_ctrl_in15 => PCS_CTRL15_CH1,
			         hw_address_ctrl_in16 => PRBS_BIST_CTRL_CH1,
			         reg_addr => reg_addr,
			         pcs_ctrl_out => pcs_ctrl_out_ch1
				);

-- PCS channel2 output
pcs_chnl_2 : mdio_pcs_bus_out_mux
				PORT MAP ( 
			         pcs_ctrl_in1 => pcs_ctrl1_ch2_reg,
			         pcs_ctrl_in2 => pcs_ctrl2_ch2_reg,
			         pcs_ctrl_in3 => pcs_ctrl3_ch2_reg,
			         pcs_ctrl_in4 => pcs_ctrl4_ch2_reg,
			         pcs_ctrl_in5 => pcs_ctrl5_ch2_reg,
			         pcs_ctrl_in6 => pcs_ctrl6_ch2_reg,
			         pcs_ctrl_in7 => pcs_ctrl7_ch2_reg,
			         pcs_ctrl_in8 => pcs_ctrl8_ch2_reg,
			         pcs_ctrl_in9 => pcs_ctrl9_ch2_reg,
			         pcs_ctrl_in10 => pcs_ctrl10_ch2_reg,
			         pcs_ctrl_in11 => pcs_ctrl11_ch2_reg,
			         pcs_ctrl_in12 => pcs_ctrl12_ch2_reg,
			         pcs_ctrl_in13 => pcs_ctrl13_ch2_reg,
			         pcs_ctrl_in14 => pcs_ctrl14_ch2_reg,
			         pcs_ctrl_in15 => pcs_ctrl15_ch2_reg,
			         pcs_ctrl_in16 => prbs_bist_ctrl_ch2_reg,
			         hw_address_ctrl_in1 => PCS_CTRL1_CH2,
			         hw_address_ctrl_in2 => PCS_CTRL2_CH2,
			         hw_address_ctrl_in3 => PCS_CTRL3_CH2,
			         hw_address_ctrl_in4 => PCS_CTRL4_CH2,
			         hw_address_ctrl_in5 => PCS_CTRL5_CH2,
			         hw_address_ctrl_in6 => PCS_CTRL6_CH2,
			         hw_address_ctrl_in7 => PCS_CTRL7_CH2,
			         hw_address_ctrl_in8 => PCS_CTRL8_CH2,
			         hw_address_ctrl_in9 => PCS_CTRL9_CH2,
			         hw_address_ctrl_in10 => PCS_CTRL10_CH2,
			         hw_address_ctrl_in11 => PCS_CTRL11_CH2,
			         hw_address_ctrl_in12 => PCS_CTRL12_CH2,
			         hw_address_ctrl_in13 => PCS_CTRL13_CH2,
			         hw_address_ctrl_in14 => PCS_CTRL14_CH2,
			         hw_address_ctrl_in15 => PCS_CTRL15_CH2,
			         hw_address_ctrl_in16 => PRBS_BIST_CTRL_CH2,
			         reg_addr => reg_addr,
			         pcs_ctrl_out => pcs_ctrl_out_ch2
				);

-- PCS channel3 output
pcs_chnl_3 : mdio_pcs_bus_out_mux
				PORT MAP ( 
			         pcs_ctrl_in1 => pcs_ctrl1_ch3_reg,
			         pcs_ctrl_in2 => pcs_ctrl2_ch3_reg,
			         pcs_ctrl_in3 => pcs_ctrl3_ch3_reg,
			         pcs_ctrl_in4 => pcs_ctrl4_ch3_reg,
			         pcs_ctrl_in5 => pcs_ctrl5_ch3_reg,
			         pcs_ctrl_in6 => pcs_ctrl6_ch3_reg,
			         pcs_ctrl_in7 => pcs_ctrl7_ch3_reg,
			         pcs_ctrl_in8 => pcs_ctrl8_ch3_reg,
			         pcs_ctrl_in9 => pcs_ctrl9_ch3_reg,
			         pcs_ctrl_in10 => pcs_ctrl10_ch3_reg,
			         pcs_ctrl_in11 => pcs_ctrl11_ch3_reg,
			         pcs_ctrl_in12 => pcs_ctrl12_ch3_reg,
			         pcs_ctrl_in13 => pcs_ctrl13_ch3_reg,
			         pcs_ctrl_in14 => pcs_ctrl14_ch3_reg,
			         pcs_ctrl_in15 => pcs_ctrl15_ch3_reg,
			         pcs_ctrl_in16 => prbs_bist_ctrl_ch3_reg,
			         hw_address_ctrl_in1 => PCS_CTRL1_CH3,
			         hw_address_ctrl_in2 => PCS_CTRL2_CH3,
			         hw_address_ctrl_in3 => PCS_CTRL3_CH3,
			         hw_address_ctrl_in4 => PCS_CTRL4_CH3,
			         hw_address_ctrl_in5 => PCS_CTRL5_CH3,
			         hw_address_ctrl_in6 => PCS_CTRL6_CH3,
			         hw_address_ctrl_in7 => PCS_CTRL7_CH3,
			         hw_address_ctrl_in8 => PCS_CTRL8_CH3,
			         hw_address_ctrl_in9 => PCS_CTRL9_CH3,
			         hw_address_ctrl_in10 => PCS_CTRL10_CH3,
			         hw_address_ctrl_in11 => PCS_CTRL11_CH3,
			         hw_address_ctrl_in12 => PCS_CTRL12_CH3,
			         hw_address_ctrl_in13 => PCS_CTRL13_CH3,
			         hw_address_ctrl_in14 => PCS_CTRL14_CH3,
			         hw_address_ctrl_in15 => PCS_CTRL15_CH3,
			         hw_address_ctrl_in16 => PRBS_BIST_CTRL_CH3,
			         reg_addr => reg_addr,
			         pcs_ctrl_out => pcs_ctrl_out_ch3
				);

mbus_out <=	xgxs_ctrl_reg         WHEN  (reg_addr = XGXS_CTRL)           ELSE
			xgxs_stat1_reg        WHEN  (reg_addr = XGXS_STATUS1)        ELSE
			xgxs_stat2_reg        WHEN  (reg_addr = XGXS_STATUS2)        ELSE
			xgxs_lane_stat_reg    WHEN  (reg_addr = XGXS_LANE_STATUS)    ELSE
			trunking_mode_reg     WHEN  (reg_addr = TRUNKING_MODE)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL1_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL1_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL1_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL1_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL2_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL2_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL2_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL2_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL3_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL3_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL3_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL3_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL4_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL4_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL4_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL4_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL5_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL5_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL5_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL5_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL6_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL6_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL6_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL6_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL7_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL7_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL7_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL7_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL8_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL8_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL8_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL8_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PRBS_BIST_CTRL_CH0)  ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PRBS_BIST_CTRL_CH1)  ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PRBS_BIST_CTRL_CH2)  ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PRBS_BIST_CTRL_CH3)  ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL9_CH0)       ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL9_CH1)       ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL9_CH2)       ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL9_CH3)       ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL10_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL10_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL10_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL10_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL11_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL11_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL11_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL11_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL12_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL12_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL12_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL12_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL13_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL13_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL13_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL13_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL14_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL14_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL14_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL14_CH3)      ELSE
			pcs_ctrl_out_ch0      WHEN  (reg_addr = PCS_CTRL15_CH0)      ELSE
			pcs_ctrl_out_ch1      WHEN  (reg_addr = PCS_CTRL15_CH1)      ELSE
			pcs_ctrl_out_ch2      WHEN  (reg_addr = PCS_CTRL15_CH2)      ELSE
			pcs_ctrl_out_ch3      WHEN  (reg_addr = PCS_CTRL15_CH3)      ELSE
			pcs_global_ctrl0_reg  WHEN  (reg_addr = PCS_GLOBAL_CTRL0)    ELSE
			pcs_global_ctrl1_reg  WHEN  (reg_addr = PCS_GLOBAL_CTRL1)    ELSE
			pcs_global_ctrl2_reg  WHEN  (reg_addr = PCS_GLOBAL_CTRL2)    ELSE
			pma_ctrl1_ch0_reg     WHEN  (reg_addr = PMA_CTRL1_CH0)       ELSE
			pma_ctrl1_ch1_reg     WHEN  (reg_addr = PMA_CTRL1_CH1)       ELSE
			pma_ctrl1_ch2_reg     WHEN  (reg_addr = PMA_CTRL1_CH2)       ELSE
			pma_ctrl1_ch3_reg     WHEN  (reg_addr = PMA_CTRL1_CH3)       ELSE
			pma_ctrl2_ch0_reg     WHEN  (reg_addr = PMA_CTRL2_CH0)       ELSE
			pma_ctrl2_ch1_reg     WHEN  (reg_addr = PMA_CTRL2_CH1)       ELSE
			pma_ctrl2_ch2_reg     WHEN  (reg_addr = PMA_CTRL2_CH2)       ELSE
			pma_ctrl2_ch3_reg     WHEN  (reg_addr = PMA_CTRL2_CH3)       ELSE
			pma_ctrl3_ch0_reg     WHEN  (reg_addr = PMA_CTRL3_CH0)       ELSE
			pma_ctrl3_ch1_reg     WHEN  (reg_addr = PMA_CTRL3_CH1)       ELSE
			pma_ctrl3_ch2_reg     WHEN  (reg_addr = PMA_CTRL3_CH2)       ELSE
			pma_ctrl3_ch3_reg     WHEN  (reg_addr = PMA_CTRL3_CH3)       ELSE
			pma_ctrl4_ch0_reg     WHEN  (reg_addr = PMA_CTRL4_CH0)       ELSE
			pma_ctrl4_ch1_reg     WHEN  (reg_addr = PMA_CTRL4_CH1)       ELSE
			pma_ctrl4_ch2_reg     WHEN  (reg_addr = PMA_CTRL4_CH2)       ELSE
			pma_ctrl4_ch3_reg     WHEN  (reg_addr = PMA_CTRL4_CH3)       ELSE
			pma_ctrl5_ch0_reg     WHEN  (reg_addr = PMA_CTRL5_CH0)       ELSE
			pma_ctrl5_ch1_reg     WHEN  (reg_addr = PMA_CTRL5_CH1)       ELSE
			pma_ctrl5_ch2_reg     WHEN  (reg_addr = PMA_CTRL5_CH2)       ELSE
			pma_ctrl5_ch3_reg     WHEN  (reg_addr = PMA_CTRL5_CH3)       ELSE
			pma_ctrl6_ch0_reg     WHEN  (reg_addr = PMA_CTRL6_CH0)       ELSE
			pma_ctrl6_ch1_reg     WHEN  (reg_addr = PMA_CTRL6_CH1)       ELSE
			pma_ctrl6_ch2_reg     WHEN  (reg_addr = PMA_CTRL6_CH2)       ELSE
			pma_ctrl6_ch3_reg     WHEN  (reg_addr = PMA_CTRL6_CH3)       ELSE
			pma_ctrl7_ch0_reg     WHEN  (reg_addr = PMA_CTRL7_CH0)       ELSE
			pma_ctrl7_ch1_reg     WHEN  (reg_addr = PMA_CTRL7_CH1)       ELSE
			pma_ctrl7_ch2_reg     WHEN  (reg_addr = PMA_CTRL7_CH2)       ELSE
			pma_ctrl7_ch3_reg     WHEN  (reg_addr = PMA_CTRL7_CH3)       ELSE
			pma_ctrl8_ch0_reg     WHEN  (reg_addr = PMA_CTRL8_CH0)       ELSE
			pma_ctrl8_ch1_reg     WHEN  (reg_addr = PMA_CTRL8_CH1)       ELSE
			pma_ctrl8_ch2_reg     WHEN  (reg_addr = PMA_CTRL8_CH2)       ELSE
			pma_ctrl8_ch3_reg     WHEN  (reg_addr = PMA_CTRL8_CH3)       ELSE
			pma_ctrl9_ch0_reg     WHEN  (reg_addr = PMA_CTRL9_CH0)       ELSE
			pma_ctrl9_ch1_reg     WHEN  (reg_addr = PMA_CTRL9_CH1)       ELSE
			pma_ctrl9_ch2_reg     WHEN  (reg_addr = PMA_CTRL9_CH2)       ELSE
			pma_ctrl9_ch3_reg     WHEN  (reg_addr = PMA_CTRL9_CH3)       ELSE
			pma_ctrl10_ch0_reg    WHEN  (reg_addr = PMA_CTRL10_CH0)      ELSE
			pma_ctrl10_ch1_reg    WHEN  (reg_addr = PMA_CTRL10_CH1)      ELSE
			pma_ctrl10_ch2_reg    WHEN  (reg_addr = PMA_CTRL10_CH2)      ELSE
			pma_ctrl10_ch3_reg    WHEN  (reg_addr = PMA_CTRL10_CH3)      ELSE
			pma_ctrl11_ch0_reg    WHEN  (reg_addr = PMA_CTRL11_CH0)      ELSE
			pma_ctrl11_ch1_reg    WHEN  (reg_addr = PMA_CTRL11_CH1)      ELSE
			pma_ctrl11_ch2_reg    WHEN  (reg_addr = PMA_CTRL11_CH2)      ELSE
			pma_ctrl11_ch3_reg    WHEN  (reg_addr = PMA_CTRL11_CH3)      ELSE
			pma_global_ctrl0_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL0)    ELSE
			pma_global_ctrl1_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL1)    ELSE
			pma_global_ctrl2_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL2)    ELSE
			pma_global_ctrl3_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL3)    ELSE
			pma_global_ctrl4_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL4)    ELSE
			pma_global_ctrl5_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL5)    ELSE
			pma_global_ctrl6_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL6)    ELSE
			pma_global_ctrl7_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL7)    ELSE
			pma_global_ctrl8_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL8)    ELSE
			pma_global_ctrl9_reg  WHEN  (reg_addr = PMA_GLOBAL_CTRL9)    ELSE
			"0000000000000000";


-- EXTERNAL INPUTS FOR CONTROL REGISTERS

xgxs_ctrl_ext <= '0' & rs_lpbk_all & "00" & rpowerdown & "00000000000";

--************************************************************************************
-- Status registers
local_fault        <= '1' WHEN (tx_local_fault <= '1' OR rx_local_fault <= '1') ELSE '0';
xgxs_stat1_reg     <= "00000000" & local_fault & "0000" & xs_link_status & "10";
xs_tx_local_fault  <= tx_local_fault WHEN (dev_addr_0 <= '1') ELSE rx_local_fault ;
xs_rx_local_fault  <= rx_local_fault WHEN (dev_addr_0 <= '1') ELSE tx_local_fault ;
xgxs_stat2_reg     <= "1000" & xs_rx_local_fault & xs_tx_local_fault & "0000000000";
xgxs_lane_stat_reg <= "000" & align_status & "11000000" & sync_status;
-- ***********************************************************************************

-- PCS CRAMs
trunking_mode_ext <= '0' & rphfifo_master_sel_tx & rphfifo_master_sel_rx & 
                             rendec_data_sel_tx & rendec_data_sel_rx & rnenbpin & rpllurst & 
                             rreset & rrsvd_cmu & rdeskewen & rindv_tx & rindv_rx;

pcs_ctrl1_ch0_ext <= rtx_pipe_enable(0) & rrx_pipe_enable(0) & rpowdnr(0) & rpowdnt(0) &
                             rendec_tx(0) & rendec_rx(0) & r8b10b_enc_ibm_en(0) & rmatchen(0) &
                             r8b10b_dec_ibm_en_ch0 & rforce_kchar(0) & rforce_echar(0) &
                             rlp20ben(0) & rgenericfifo(0) & rcascaded_8b10b_en_tx(0) &
                             rcascaded_8b10b_en_rx(0);
pcs_ctrl1_ch1_ext <= rtx_pipe_enable(1) & rrx_pipe_enable(1) & rpowdnr(1) & rpowdnt(1) &
                             rendec_tx(1) & rendec_rx(1) & r8b10b_enc_ibm_en(1) & rmatchen(1) &
                             r8b10b_dec_ibm_en_ch1 & rforce_kchar(1) & rforce_echar(1) &
                             rlp20ben(1) & rgenericfifo(1) & rcascaded_8b10b_en_tx(1) &
                             rcascaded_8b10b_en_rx(1);
pcs_ctrl1_ch2_ext <= rtx_pipe_enable(2) & rrx_pipe_enable(2) & rpowdnr(2) & rpowdnt(2) &
                             rendec_tx(2) & rendec_rx(2) & r8b10b_enc_ibm_en(2) & rmatchen(2) &
                             r8b10b_dec_ibm_en_ch2 & rforce_kchar(2) & rforce_echar(2) &
                             rlp20ben(2) & rgenericfifo(2) & rcascaded_8b10b_en_tx(2) &
                             rcascaded_8b10b_en_rx(2);
pcs_ctrl1_ch3_ext <= rtx_pipe_enable(3) & rrx_pipe_enable(3) & rpowdnr(3) & rpowdnt(3) &
                             rendec_tx(3) & rendec_rx(3) & r8b10b_enc_ibm_en(3) & rmatchen(3) &
                             r8b10b_dec_ibm_en_ch3 & rforce_kchar(3) & rforce_echar(3) &
                             rlp20ben(3) & rgenericfifo(3) & rcascaded_8b10b_en_tx(3) &
                             rcascaded_8b10b_en_rx(3);

pcs_ctrl2_ch0_ext <= resync_badcg_en_ch0 & rencdt_rising(0) & rdis_rx_disp(0) &
                             rcomp_pat_porn(0) & rcomp_size_ch0 & rcomp_pat_ch0(39 DOWNTO 32);
pcs_ctrl2_ch1_ext <= resync_badcg_en_ch1 & rencdt_rising(1) & rdis_rx_disp(1) &
                             rcomp_pat_porn(1) & rcomp_size_ch1 & rcomp_pat_ch1(39 DOWNTO 32);                             
pcs_ctrl2_ch2_ext <= resync_badcg_en_ch2 & rencdt_rising(2) & rdis_rx_disp(2) &
                             rcomp_pat_porn(2) & rcomp_size_ch2 & rcomp_pat_ch2(39 DOWNTO 32);
pcs_ctrl2_ch3_ext <= resync_badcg_en_ch3 & rencdt_rising(3) & rdis_rx_disp(3) &
                             rcomp_pat_porn(3) & rcomp_size_ch3 & rcomp_pat_ch3(39 DOWNTO 32);

pcs_ctrl3_ch0_ext <= rcomp_pat_ch0(31 DOWNTO 16);
pcs_ctrl3_ch1_ext <= rcomp_pat_ch1(31 DOWNTO 16);
pcs_ctrl3_ch2_ext <= rcomp_pat_ch2(31 DOWNTO 16);
pcs_ctrl3_ch3_ext <= rcomp_pat_ch3(31 DOWNTO 16);

pcs_ctrl4_ch0_ext <= rcomp_pat_ch0(15 DOWNTO 0);
pcs_ctrl4_ch1_ext <= rcomp_pat_ch1(15 DOWNTO 0);
pcs_ctrl4_ch2_ext <= rcomp_pat_ch2(15 DOWNTO 0);
pcs_ctrl4_ch3_ext <= rcomp_pat_ch3(15 DOWNTO 0);

pcs_ctrl5_ch0_ext <= rrxfifo_dis(0) & rtxfifo_dis(0) & rib_force_disp(0) &
                            rrundisp_ch0 & rtxfifo_lowlatency_en(0) & rrlv_en(0) & rautobtalg_dis(0) &
                             rsync_sm_dis(0) & rib_inv_cd_ch0 & rrxfifo_lowlatency_en(0);
pcs_ctrl5_ch1_ext <= rrxfifo_dis(1) & rtxfifo_dis(1) & rib_force_disp(1) &
                             rrundisp_ch1 & rtxfifo_lowlatency_en(1) & rrlv_en(1) & rautobtalg_dis(1) &
                             rsync_sm_dis(1) & rib_inv_cd_ch1 & rrxfifo_lowlatency_en(1);
pcs_ctrl5_ch2_ext <= rrxfifo_dis(2) & rtxfifo_dis(2) & rib_force_disp(2) &
                             rrundisp_ch2 & rtxfifo_lowlatency_en(2) & rrlv_en(2) & rautobtalg_dis(2) &
                             rsync_sm_dis(2) & rib_inv_cd_ch2 & rrxfifo_lowlatency_en(2);
pcs_ctrl5_ch3_ext <= rrxfifo_dis(3) & rtxfifo_dis(3) & rib_force_disp(3) &
                             rrundisp_ch3 & rtxfifo_lowlatency_en(3) & rrlv_en(3) & rautobtalg_dis(3) &
                             rsync_sm_dis(3) & rib_inv_cd_ch3 & rrxfifo_lowlatency_en(3);

pcs_ctrl6_ch0_ext <= rdwidth_tx(0) & rdwidth_rx(0) & rge_xaui_tx(0) &
                             rrx_detect_bypass(0) & rtxurstpcs(0) & rrxurstpcs(0) &
                             rrsvd_tx_ch0 & rskpsetbased(0) & rtruebac2bac(0) &rrsvd_rx_ch0;
pcs_ctrl6_ch1_ext <= rdwidth_tx(1) & rdwidth_rx(1) & rge_xaui_tx(1) &
                             rrx_detect_bypass(1) & rtxurstpcs(1) & rrxurstpcs(1) &
                             rrsvd_tx_ch1 & rskpsetbased(1) & rtruebac2bac(1) &rrsvd_rx_ch1;
pcs_ctrl6_ch2_ext <= rdwidth_tx(2) & rdwidth_rx(2) & rge_xaui_tx(2) &
                             rrx_detect_bypass(2) & rtxurstpcs(2) & rrxurstpcs(2) &
                             rrsvd_tx_ch2 & rskpsetbased(2) & rtruebac2bac(2) &rrsvd_rx_ch2;
pcs_ctrl6_ch3_ext <= rdwidth_tx(3) & rdwidth_rx(3) & rge_xaui_tx(3) &
                             rrx_detect_bypass(3) & rtxurstpcs(3) & rrxurstpcs(3) &
                             rrsvd_tx_ch3 & rskpsetbased(3) & rtruebac2bac(3) &rrsvd_rx_ch3;

pcs_ctrl7_ch0_ext <= rgnumber_ch0 & rknumber_ch0;
pcs_ctrl7_ch1_ext <= rgnumber_ch1 & rknumber_ch1;
pcs_ctrl7_ch2_ext <= rgnumber_ch2 & rknumber_ch2;
pcs_ctrl7_ch3_ext <= rgnumber_ch3 & rknumber_ch3;

pcs_ctrl8_ch0_ext <= rfreerun_tx(0) & rtxwrclksel(0) & rtxrdclksel(0) &
                             rfreerun_rx(0) & rrcvd_clk_sel_ch0 & 
                             rclk_1_sel_ch0 & rclk_2_sel_ch0 & rrx_rd_clk_sel(0) & 
                             renumber_ch0 & renpolinv_rx(0) & rclkcmpinsertpad(0);
pcs_ctrl8_ch1_ext <= rfreerun_tx(1) & rtxwrclksel(1) & rtxrdclksel(1) &
                             rfreerun_rx(1) & rrcvd_clk_sel_ch1 & 
                             rclk_1_sel_ch1 & rclk_2_sel_ch1 & rrx_rd_clk_sel(1) & 
                             renumber_ch1 & renpolinv_rx(1) & rclkcmpinsertpad(1);
pcs_ctrl8_ch2_ext <= rfreerun_tx(2) & rtxwrclksel(2) & rtxrdclksel(2) &
                             rfreerun_rx(2) & rrcvd_clk_sel_ch2 & 
                             rclk_1_sel_ch2 & rclk_2_sel_ch2 & rrx_rd_clk_sel(2) & 
                             renumber_ch2 & renpolinv_rx(2) & rclkcmpinsertpad(2);
pcs_ctrl8_ch3_ext <= rfreerun_tx(3) & rtxwrclksel(3) & rtxrdclksel(3) &
                             rfreerun_rx(3) & rrcvd_clk_sel_ch3 & 
                             rclk_1_sel_ch3 & rclk_2_sel_ch3 & rrx_rd_clk_sel(3) & 
                             renumber_ch3 & renpolinv_rx(3) & rclkcmpinsertpad(3);

prbs_bist_ctrl_ch0_ext <= rprbsen_tx(0) & rprbsen_rx(0) & rprbs_clr_rslt_rx(0) &
                                  rprbs_sel_ch0 & rbisten_tx(0) & rbisten_rx(0) &
                                  rbist_clr_rx(0) & rbist_sel_ch0 &
                                  rcxpat_chnl_en_ch0 & rall_one_dect_only(0) & "00";
prbs_bist_ctrl_ch1_ext <= rprbsen_tx(1) & rprbsen_rx(1) & rprbs_clr_rslt_rx(1) &
                                  rprbs_sel_ch1 & rbisten_tx(1) & rbisten_rx(1) &
                                  rbist_clr_rx(1) & rbist_sel_ch1 &
                                  rcxpat_chnl_en_ch1 & rall_one_dect_only(1) & "00";
prbs_bist_ctrl_ch2_ext <= rprbsen_tx(2) & rprbsen_rx(2) & rprbs_clr_rslt_rx(2) &
                                  rprbs_sel_ch2 & rbisten_tx(2) & rbisten_rx(2) &
                                  rbist_clr_rx(2) & rbist_sel_ch2 &
                                  rcxpat_chnl_en_ch2 & rall_one_dect_only(2) & "00";
prbs_bist_ctrl_ch3_ext <= rprbsen_tx(3) & rprbsen_rx(3) & rprbs_clr_rslt_rx(3) &
                                  rprbs_sel_ch3 & rbisten_tx(3) & rbisten_rx(3) &
                                  rbist_clr_rx(3) & rbist_sel_ch3 &
                                  rcxpat_chnl_en_ch3 & rall_one_dect_only(3) & "00";

pcs_ctrl9_ch0_ext <= rppm_cnt_reset(0) & rphfifourstrx(0) & rcmpfifourst(0) & rtx_idle_delay_ch0 & 
                             rclkcmpsqmd(0) & rclkcmpsq1p_ch0(9 DOWNTO 0);
pcs_ctrl9_ch1_ext <= rppm_cnt_reset(1) & rphfifourstrx(1) & rcmpfifourst(1) & rtx_idle_delay_ch1 & 
                             rclkcmpsqmd(1) & rclkcmpsq1p_ch1(9 DOWNTO 0);
pcs_ctrl9_ch2_ext <= rppm_cnt_reset(2) & rphfifourstrx(2) & rcmpfifourst(2) & rtx_idle_delay_ch2 & 
                             rclkcmpsqmd(2) & rclkcmpsq1p_ch2(9 DOWNTO 0);
pcs_ctrl9_ch3_ext <= rppm_cnt_reset(3) & rphfifourstrx(3) & rcmpfifourst(3) & rtx_idle_delay_ch3 & 
                             rclkcmpsqmd(3) & rclkcmpsq1p_ch3(9 DOWNTO 0);

pcs_ctrl10_ch0_ext <= rclkcmpsq1n_ch0(19 DOWNTO 15) & rclkcmppos(0) & rclkcmpsq1p_ch0(19 DOWNTO 10);
pcs_ctrl10_ch1_ext <= rclkcmpsq1n_ch1(19 DOWNTO 15) & rclkcmppos(1) & rclkcmpsq1p_ch1(19 DOWNTO 10);
pcs_ctrl10_ch2_ext <= rclkcmpsq1n_ch2(19 DOWNTO 15) & rclkcmppos(2) & rclkcmpsq1p_ch2(19 DOWNTO 10);
pcs_ctrl10_ch3_ext <= rclkcmpsq1n_ch3(19 DOWNTO 15) & rclkcmppos(3) & rclkcmpsq1p_ch3(19 DOWNTO 10);

pcs_ctrl11_ch0_ext <= rclkcmpsq1n_ch0(14 DOWNTO 10) & '0' & rclkcmpsq1n_ch0(9 DOWNTO 0);
pcs_ctrl11_ch1_ext <= rclkcmpsq1n_ch1(14 DOWNTO 10) & '0' & rclkcmpsq1n_ch1(9 DOWNTO 0);
pcs_ctrl11_ch2_ext <= rclkcmpsq1n_ch2(14 DOWNTO 10) & '0' & rclkcmpsq1n_ch2(9 DOWNTO 0);
pcs_ctrl11_ch3_ext <= rclkcmpsq1n_ch3(14 DOWNTO 10) & '0' & rclkcmpsq1n_ch3(9 DOWNTO 0);

pcs_ctrl12_ch0_ext <= rrev_loopbk(0) & ralempty_ch0 & ralfull_ch0 & rforce_disp(0) & 
                              rkchar(0) & rosbased(0) & rensymswap_tx(0) & '0' & rosnumber_ch0;
pcs_ctrl12_ch1_ext <= rrev_loopbk(1) & ralempty_ch1 & ralfull_ch1 & rforce_disp(1) &
                              rkchar(1) & rosbased(1) & rensymswap_tx(1) & '0' & rosnumber_ch1;
pcs_ctrl12_ch2_ext <= rrev_loopbk(2) & ralempty_ch2 & ralfull_ch2 & rforce_disp(2) &
                              rkchar(2) & rosbased(2) & rensymswap_tx(2) & '0' & rosnumber_ch2;
pcs_ctrl12_ch3_ext <= rrev_loopbk(3) & ralempty_ch3 & ralfull_ch3 & rforce_disp(3) &
                              rkchar(3) & rosbased(3) & rensymswap_tx(3) & '0' & rosnumber_ch3;

pcs_ctrl13_ch0_ext <= rwa_6g_en(0) & renpolinv_tx(0) & rbitslip_size_ch0 & rbytord_2sym_en(0) &
                              rbysync_polinv_en(0) & rbitloc_rev_en(0) & rbyte_rev_en(0) & renbitrev_tx(0) &
                              rbyteorden_ch0 & rbytordplden(0) & rphfifopldentx(0) & rphfifoursttx(0) &
                              rphfifopldenrx(0) & rautoinsdis(0);
pcs_ctrl13_ch1_ext <= rwa_6g_en(1) & renpolinv_tx(1) & rbitslip_size_ch1 & rbytord_2sym_en(1) &
                              rbysync_polinv_en(1) & rbitloc_rev_en(1) & rbyte_rev_en(1) & renbitrev_tx(1) &
                              rbyteorden_ch1 & rbytordplden(1) & rphfifopldentx(1) & rphfifoursttx(1) &
                              rphfifopldenrx(1) & rautoinsdis(1);
pcs_ctrl13_ch2_ext <= rwa_6g_en(2) & renpolinv_tx(2) & rbitslip_size_ch2 & rbytord_2sym_en(2) &
                              rbysync_polinv_en(2) & rbitloc_rev_en(2) & rbyte_rev_en(2) & renbitrev_tx(2) &
                              rbyteorden_ch2 & rbytordplden(2) & rphfifopldentx(2) & rphfifoursttx(2) &
                              rphfifopldenrx(2) & rautoinsdis(2);
pcs_ctrl13_ch3_ext <= rwa_6g_en(3) & renpolinv_tx(3) & rbitslip_size_ch3 & rbytord_2sym_en(3) &
                              rbysync_polinv_en(3) & rbitloc_rev_en(3) & rbyte_rev_en(3) & renbitrev_tx(3) &
                              rbyteorden_ch3 & rbytordplden(3) & rphfifopldentx(3) & rphfifoursttx(3) &
                              rphfifopldenrx(3) & rautoinsdis(3);

pcs_ctrl14_ch0_ext <= rppmsel_ch0 & rbytordpat_ch0;
pcs_ctrl14_ch1_ext <= rppmsel_ch1 & rbytordpat_ch1;
pcs_ctrl14_ch2_ext <= rppmsel_ch2 & rbytordpat_ch2;
pcs_ctrl14_ch3_ext <= rppmsel_ch3 & rbytordpat_ch3;

pcs_ctrl15_ch0_ext <= rtest_bus_sel_ch0 & rforce_sig_det_pcs(0) & rforce0_freqdet(0) & 
                              rforce1_freqdet(0) & rbytordpad_ch0;
pcs_ctrl15_ch1_ext <= rtest_bus_sel_ch1 & rforce_sig_det_pcs(1) & rforce0_freqdet(1) & 
                              rforce1_freqdet(1) & rbytordpad_ch1;
pcs_ctrl15_ch2_ext <= rtest_bus_sel_ch2 & rforce_sig_det_pcs(2) & rforce0_freqdet(2) & 
                              rforce1_freqdet(2) & rbytordpad_ch2;
pcs_ctrl15_ch3_ext <= rtest_bus_sel_ch3 & rforce_sig_det_pcs(3) & rforce0_freqdet(3) & 
                              rforce1_freqdet(3) & rbytordpad_ch3;

pcs_global_ctrl0_ext <= "000000000" & ralgnect & ralgngct & ralgnact;
pcs_global_ctrl1_ext <= rfreerun_centrl & rcentrl_clk_sel & "00" & rrefclk_out_div2 & rdskposdisp & rdskchrp;
pcs_global_ctrl2_ext <= "00" & ralgnopt & rtest_bus_centrl_sel & "0000000000";

-- Analog CRAMs
pma_ctrl1_ch0_ext <= rtx_vod_sel_ch0 & rtx_slewrate(0) & rpmphs_2tap_ch0 &
                             rpmphs_1tap_ch0 & rtx_vtt_ch0 & rpmphs_ptap_ch0;
pma_ctrl1_ch1_ext <= rtx_vod_sel_ch1 & rtx_slewrate(1) & rpmphs_2tap_ch1 &
                             rpmphs_1tap_ch1 & rtx_vtt_ch1 & rpmphs_ptap_ch1;
pma_ctrl1_ch2_ext <= rtx_vod_sel_ch2 & rtx_slewrate(2) & rpmphs_2tap_ch2 &
                            rpmphs_1tap_ch2 & rtx_vtt_ch2 & rpmphs_ptap_ch2;
pma_ctrl1_ch3_ext <= rtx_vod_sel_ch3 & rtx_slewrate(3) & rpmphs_2tap_ch3 &
                             rpmphs_1tap_ch3 & rtx_vtt_ch3 & rpmphs_ptap_ch3;

pma_ctrl2_ch0_ext <= rtx_term_ch0 & r_tx_det_rx_ch0 & rrx_term_ch0 & rforce_sigdet(0) &
                             rrx_dc_couple(0) & rrx_eq_dc_ch0 & rrx_vtt_ch0 & rrx_sloslv_ch0;
pma_ctrl2_ch1_ext <= rtx_term_ch1 & r_tx_det_rx_ch1 & rrx_term_ch1 & rforce_sigdet(1) &
                             rrx_dc_couple(1) & rrx_eq_dc_ch1 & rrx_vtt_ch1 & rrx_sloslv_ch1;
pma_ctrl2_ch2_ext <= rtx_term_ch2 & r_tx_det_rx_ch2 & rrx_term_ch2 & rforce_sigdet(2) &
                             rrx_dc_couple(2) & rrx_eq_dc_ch2 & rrx_vtt_ch2 & rrx_sloslv_ch2;
pma_ctrl2_ch3_ext <= rtx_term_ch3 & r_tx_det_rx_ch3 & rrx_term_ch3 & rforce_sigdet(3) &
                             rrx_dc_couple(3) & rrx_eq_dc_ch3 & rrx_vtt_ch3 & rrx_sloslv_ch3;
                             
 pma_ctrl3_ch0_ext <= reqa_ct_ch0 & reqb_ct_ch0 & reqc_ct_ch0 & reqd_ct_ch0 & req_ctv_ch0 & '0';
 pma_ctrl3_ch1_ext <= reqa_ct_ch1 & reqb_ct_ch1 & reqc_ct_ch1 & reqd_ct_ch1 & req_ctv_ch1 & '0';
 pma_ctrl3_ch2_ext <= reqa_ct_ch2 & reqb_ct_ch2 & reqc_ct_ch2 & reqd_ct_ch2 & req_ctv_ch2 & '0';
 pma_ctrl3_ch3_ext <= reqa_ct_ch3 & reqb_ct_ch3 & reqc_ct_ch3 & reqd_ct_ch3 & req_ctv_ch3 & '0';

 pma_ctrl4_ch0_ext <= rpmadwidth_tx(0) & rpma_doublewidth_tx(0) & rtx_cmu_sel(0) &
                             rtx_m_sel_ch0 & rtxvcobypass(0) & rtx_cgb_1x_en(0) & rtx_cgb_4x_en(0) &
                             rtx_4x_sw(0) & rpmadwidth_rx(0) & rpma_doublewidth_rx(0) &
                             rrxvcobypass(0) &rrect_adj_ch0 & rrx_piso_bypass_ch0;
 pma_ctrl4_ch1_ext <= rpmadwidth_tx(1) & rpma_doublewidth_tx(1) & rtx_cmu_sel(1) &
                             rtx_m_sel_ch1 & rtxvcobypass(1) & rtx_cgb_1x_en(1) & rtx_cgb_4x_en(1) &
                             rtx_4x_sw(1) & rpmadwidth_rx(1) & rpma_doublewidth_rx(1) &
                             rrxvcobypass(1) &rrect_adj_ch1 & rrx_piso_bypass_ch1;
 pma_ctrl4_ch2_ext <= rpmadwidth_tx(2) & rpma_doublewidth_tx(2) & rtx_cmu_sel(2) &
                             rtx_m_sel_ch2 & rtxvcobypass(2) & rtx_cgb_1x_en(2) & rtx_cgb_4x_en(2) &
                             rtx_4x_sw(2) & rpmadwidth_rx(2) & rpma_doublewidth_rx(2) &
                             rrxvcobypass(2) &rrect_adj_ch2 & rrx_piso_bypass_ch2;
 pma_ctrl4_ch3_ext <= rpmadwidth_tx(3) & rpma_doublewidth_tx(3) & rtx_cmu_sel(3) &
                             rtx_m_sel_ch3 & rtxvcobypass(3) & rtx_cgb_1x_en(3) & rtx_cgb_4x_en(3) &
                             rtx_4x_sw(3) & rpmadwidth_rx(3) & rpma_doublewidth_rx(3) &
                             rrxvcobypass(3) &rrect_adj_ch3 & rrx_piso_bypass_ch3;

 pma_ctrl5_ch0_ext <= rlst_tx_ch0 & rlst_rx_ch0 & rlst_rxpll_ch0 & rrx_ignore_phslck(0) &
                             rdc_freq_ch0 & rrx_osc_en(0);
 pma_ctrl5_ch1_ext <= rlst_tx_ch1 & rlst_rx_ch1 & rlst_rxpll_ch1 & rrx_ignore_phslck(1) &
                             rdc_freq_ch1 & rrx_osc_en(1);
 pma_ctrl5_ch2_ext <= rlst_tx_ch2 & rlst_rx_ch2 & rlst_rxpll_ch2 & rrx_ignore_phslck(2) &
                             rdc_freq_ch2 & rrx_osc_en(2);
 pma_ctrl5_ch3_ext <= rlst_tx_ch3 & rlst_rx_ch3 & rlst_rxpll_ch3 & rrx_ignore_phslck(3) &
                             rdc_freq_ch3 & rrx_osc_en(3);

 pma_ctrl6_ch0_ext <= rrefclk_sel_ch0 & rbwctral_rx_ch0 & rrx_cru_m_sel_ch0 & 
                             rrx_cru_div2(0) & rrx_cru_ctl_ch0 & rltr(0) & rltd(0);
 pma_ctrl6_ch1_ext <= rrefclk_sel_ch1 & rbwctral_rx_ch1 & rrx_cru_m_sel_ch1 & 
                             rrx_cru_div2(1) & rrx_cru_ctl_ch1 & rltr(1) & rltd(1);
 pma_ctrl6_ch2_ext <= rrefclk_sel_ch2 & rbwctral_rx_ch2 & rrx_cru_m_sel_ch2 & 
                             rrx_cru_div2(2) & rrx_cru_ctl_ch2 & rltr(2) & rltd(2);
 pma_ctrl6_ch3_ext <= rrefclk_sel_ch3 & rbwctral_rx_ch3 & rrx_cru_m_sel_ch3 & 
                             rrx_cru_div2(3) & rrx_cru_ctl_ch3 & rltr(3) & rltd(3);

 pma_ctrl7_ch0_ext <= risel_rx_ch0 & riupsel_rx_ch0 & ridnsel_rx_ch0 &
                             rtesten_cp_rx(0) & rtristate_cp_rx(0) & rtestupen_cp_rx(0) &
                             rtestdnen_cp_rx(0) & rrx_cru_m_ch0 & rrx_cru_l_ch0;
 pma_ctrl7_ch1_ext <= risel_rx_ch1 & riupsel_rx_ch1 & ridnsel_rx_ch1 &
                             rtesten_cp_rx(1) & rtristate_cp_rx(1) & rtestupen_cp_rx(1) &
                             rtestdnen_cp_rx(1) & rrx_cru_m_ch1 & rrx_cru_l_ch1;
 pma_ctrl7_ch2_ext <= risel_rx_ch2 & riupsel_rx_ch2 & ridnsel_rx_ch2 &
                             rtesten_cp_rx(2) & rtristate_cp_rx(2) & rtestupen_cp_rx(2) &
                             rtestdnen_cp_rx(2) & rrx_cru_m_ch2 & rrx_cru_l_ch2;
 pma_ctrl7_ch3_ext <= risel_rx_ch3 & riupsel_rx_ch3 & ridnsel_rx_ch3 &
                             rtesten_cp_rx(3) & rtristate_cp_rx(3) & rtestupen_cp_rx(3) &
                             rtestdnen_cp_rx(3) & rrx_cru_m_ch3 & rrx_cru_l_ch3;
                             
 pma_ctrl8_ch0_ext <= rs_lpbk(0) & r_rlpbk(0) & rs_rdlpbk(0) & rrx_revlb_sw(0) &
                             rurx_pdb(0) & rtx_cgb_pdb(0) & rtx_ob_pdb(0) & rrx_cru_pdb(0) &
                             rrx_cru_rst(0) & rrx_ib_pdb(0) & rrxurstpma(0) & radce_adapt(0) &
                             radce_pdb(0) & radce_rst(0) & rsig_inv_2tap(0) & rsig_inv_pre(0);
 pma_ctrl8_ch1_ext <= rs_lpbk(1) & r_rlpbk(1) & rs_rdlpbk(1) & rrx_revlb_sw(1) &
                             rurx_pdb(1) & rtx_cgb_pdb(1) & rtx_ob_pdb(1) & rrx_cru_pdb(1) &
                             rrx_cru_rst(1) & rrx_ib_pdb(1) & rrxurstpma(1) & radce_adapt(1) &
                             radce_pdb(1) & radce_rst(1) & rsig_inv_2tap(1) & rsig_inv_pre(1);
 pma_ctrl8_ch2_ext <= rs_lpbk(2) & r_rlpbk(2) & rs_rdlpbk(2) & rrx_revlb_sw(2) &
                             rurx_pdb(2) & rtx_cgb_pdb(2) & rtx_ob_pdb(2) & rrx_cru_pdb(2) &
                             rrx_cru_rst(2) & rrx_ib_pdb(2) & rrxurstpma(2) & radce_adapt(2) &
                             radce_pdb(2) & radce_rst(2) & rsig_inv_2tap(2) & rsig_inv_pre(2);
 pma_ctrl8_ch3_ext <= rs_lpbk(3) & r_rlpbk(3) & rs_rdlpbk(3) & rrx_revlb_sw(3) &
                             rurx_pdb(3) & rtx_cgb_pdb(3) & rtx_ob_pdb(3) & rrx_cru_pdb(3) &
                             rrx_cru_rst(3) & rrx_ib_pdb(3) & rrxurstpma(3) & radce_adapt(3) &
                             radce_pdb(3) & radce_rst(3) & rsig_inv_2tap(3) & rsig_inv_pre(3);

 pma_ctrl9_ch0_ext <= rseq_sel_ch0 & rrgen_set_ch0 & rclkdiv_ch0 & rf_lpf_ch0 & 
                             rf_hpf_ch0 & rrgen_bw_ch0 & '0';
 pma_ctrl9_ch1_ext <= rseq_sel_ch1 & rrgen_set_ch1 & rclkdiv_ch1 & rf_lpf_ch1 & 
                             rf_hpf_ch1 & rrgen_bw_ch1 & '0';
 pma_ctrl9_ch2_ext <= rseq_sel_ch2 & rrgen_set_ch2 & rclkdiv_ch2 & rf_lpf_ch2 & 
                             rf_hpf_ch2 & rrgen_bw_ch2 & '0';
 pma_ctrl9_ch3_ext <= rseq_sel_ch3 & rrgen_set_ch3 & rclkdiv_ch3 & rf_lpf_ch3 & 
                             rf_hpf_ch3 & rrgen_bw_ch3 & '0';

 pma_ctrl10_ch0_ext<= rhyst_ch0 & rd2a_res_ch0 & rrgen_vod_ch0 &
                             rlf_os_ch0 & rhf_os_ch0;
 pma_ctrl10_ch1_ext<= rhyst_ch1 & rd2a_res_ch1 & rrgen_vod_ch1 &
                             rlf_os_ch1 & rhf_os_ch1;
 pma_ctrl10_ch2_ext<= rhyst_ch2 & rd2a_res_ch2 & rrgen_vod_ch2 &
                             rlf_os_ch2 & rhf_os_ch2;
 pma_ctrl10_ch3_ext<= rhyst_ch3 & rd2a_res_ch3 & rrgen_vod_ch3 &
                             rlf_os_ch3 & rhf_os_ch3;

 pma_ctrl11_ch0_ext<= r_iqclk_ch0 & r_dfe_ch0 & r_cp_mode(0) & rreg_cp_rx(0) & r_impctrl_ch0 & rpd_ien(0) & '0';
 pma_ctrl11_ch1_ext<= r_iqclk_ch1 & r_dfe_ch1 & r_cp_mode(1) & rreg_cp_rx(1) & r_impctrl_ch1 & rpd_ien(1) & '0';
 pma_ctrl11_ch2_ext<= r_iqclk_ch2 & r_dfe_ch2 & r_cp_mode(2) & rreg_cp_rx(2) & r_impctrl_ch2 & rpd_ien(2) & '0';
 pma_ctrl11_ch3_ext<= r_iqclk_ch3 & r_dfe_ch3 & r_cp_mode(3) & rreg_cp_rx(3) & r_impctrl_ch3 & rpd_ien(3) & '0';

 pma_global_ctrl0_ext <= rbgbypass & '0' & rlst_bg & rcmu_rst & "000" &
                                rcmu2_isel & rcmu0_isel & rcmu1_isel;
 pma_global_ctrl1_ext <= rcmu0_iupsel & rcmu1_iupsel & rcmu2_iupsel & rcmu0_idnsel & rcmu1_idnsel & rcmu2_idnsel &
                                rcmu0_testen_cp & rcmu1_testen_cp & rcmu0_tristate_cp & rcmu1_tristate_cp;
 pma_global_ctrl2_ext <= "00" & rcmu0_lst & rcmu1_lst &
                                rcmu0_div2 & rcmu1_div2 & rcmu0_ref_sel & rcmu1_ref_sel;
 pma_global_ctrl3_ext <= rcmu0_ctl & rcmu1_ctl;
 pma_global_ctrl4_ext <= rcmu0_m & rcmu1_m & rcmu0_l & rcmu1_l & rcmu0_pdb & rcmu1_pdb &
                                rcmu0_txpll_rst & rcmu1_txpll_rst;
 pma_global_ctrl5_ext <= rpma_testbus_sel & rcmu_peclrx0_cm & rcmu_peclrx1_cm &
                                rcmu0_testupen_cp & rcmu1_testupen_cp & rcmu0_testdnen_cp & rcmu1_testdnen_cp;                                
 pma_global_ctrl6_ext <= rcmu_peclrx0_lst & rcmu_peclrx1_lst & '0' & rcmu_iqclkout_sel &
                                rcmu_txpll0_iqclkin_sel & rcmu_txpll1_iqclkin_sel;
 pma_global_ctrl7_ext <= rcmu_cgb_cmusel & rcmu_cgb_ndiv & rcmu_cgb_div5 & rcmu_cgb_div2 &
                                rcmu_cgb_vcobypass & rcmu_txpll0_1x_en & rcmu_txpll1_1x_en & 
                                rcmu_cgb_4x_en & rcmu_cgb_8x_en & rcmu_cgb_pclksel & "0000";
 pma_global_ctrl8_ext <= rcmu2_testen_cp & rcmu2_tristate_cp & rcmu2_testupen_cp &
                                rcmu2_testdnen_cp & rcmu2_lst & rcmu2_ctl;
 pma_global_ctrl9_ext <= rcmu2_refsel & rcmu2_m & rcmu2_l & rcmu2_pdb & rcmu2_txpll_rst & 
                                rcmu0_rcp_mode & rcmu1_rcp_mode & "00000";                              

-- OUTPUT CRAMS FROM CONTROL REGISTERS
-- PCS CRAMs
-- Outputs from DTE XG Control register (4.0h)
rs_lpbk_all_md <= xgxs_ctrl_reg(14);
rpowerdown_md  <= xgxs_ctrl_reg(11);

-- Outputs from Trunking mode Control register (4.8000h)
rphfifo_master_sel_tx_int <= trunking_mode_reg(14);
rphfifo_master_sel_rx_int <= trunking_mode_reg(13);
rendec_data_sel_tx_int    <= trunking_mode_reg(12);
rendec_data_sel_rx_int    <= trunking_mode_reg(11);
rnenbpin_md               <= trunking_mode_reg(10);
rpllurst_md               <= trunking_mode_reg(9);
rreset_md                 <= trunking_mode_reg(8);
rrsvd_cmu_int             <= trunking_mode_reg(7 DOWNTO 3);
rdeskewen_int             <= trunking_mode_reg(2);
rindv_tx_int              <= trunking_mode_reg(1);
rindv_rx_int              <= trunking_mode_reg(0);

-- Outputs from PCS Per channel control register 1 for channel0 (4.8001h)
rtx_pipe_enable_int(0)   <= pcs_ctrl1_ch0_reg(15);
rrx_pipe_enable_int(0)   <= pcs_ctrl1_ch0_reg(14);
rpowdnr_md(0)            <= pcs_ctrl1_ch0_reg(13);
rpowdnt_md(0)            <= pcs_ctrl1_ch0_reg(12);
rendec_tx_int(0)         <= pcs_ctrl1_ch0_reg(11);
rendec_rx_int(0)         <= pcs_ctrl1_ch0_reg(10);
r8b10b_enc_ibm_en_int(0) <= pcs_ctrl1_ch0_reg(9);
rmatchen_int(0)          <= pcs_ctrl1_ch0_reg(8);
r8b10b_dec_ibm_en_ch0_int<= pcs_ctrl1_ch0_reg(7 DOWNTO 6);
rforce_kchar_int(0)      <= pcs_ctrl1_ch0_reg(5);
rforce_echar_int(0)      <= pcs_ctrl1_ch0_reg(4);
rlp20ben_int(0)          <= pcs_ctrl1_ch0_reg(3);
rgenericfifo_int(0)      <= pcs_ctrl1_ch0_reg(2);
rcascaded_8b10b_en_tx_int(0) <= pcs_ctrl1_ch0_reg(1);
rcascaded_8b10b_en_rx_int(0) <= pcs_ctrl1_ch0_reg(0);

-- Outputs from PCS Per channel control register 1 for channel1 (4.8002h)
rtx_pipe_enable_int(1)   <= pcs_ctrl1_ch1_reg(15);
rrx_pipe_enable_int(1)   <= pcs_ctrl1_ch1_reg(14);
rpowdnr_md(1)            <= pcs_ctrl1_ch1_reg(13);
rpowdnt_md(1)            <= pcs_ctrl1_ch1_reg(12);
rendec_tx_int(1)         <= pcs_ctrl1_ch1_reg(11);
rendec_rx_int(1)         <= pcs_ctrl1_ch1_reg(10);
r8b10b_enc_ibm_en_int(1) <= pcs_ctrl1_ch1_reg(9);
rmatchen_int(1)          <= pcs_ctrl1_ch1_reg(8);
r8b10b_dec_ibm_en_ch1_int<= pcs_ctrl1_ch1_reg(7 DOWNTO 6);
rforce_kchar_int(1)      <= pcs_ctrl1_ch1_reg(5);
rforce_echar_int(1)      <= pcs_ctrl1_ch1_reg(4);
rlp20ben_int(1)          <= pcs_ctrl1_ch1_reg(3);
rgenericfifo_int(1)      <= pcs_ctrl1_ch1_reg(2);
rcascaded_8b10b_en_tx_int(1) <= pcs_ctrl1_ch1_reg(1);
rcascaded_8b10b_en_rx_int(1) <= pcs_ctrl1_ch1_reg(0);

-- Outputs from PCS Per channel control register 1 for channel2 (4.8003h)
rtx_pipe_enable_int(2)   <= pcs_ctrl1_ch2_reg(15);
rrx_pipe_enable_int(2)   <= pcs_ctrl1_ch2_reg(14);
rpowdnr_md(2)            <= pcs_ctrl1_ch2_reg(13);
rpowdnt_md(2)            <= pcs_ctrl1_ch2_reg(12);
rendec_tx_int(2)         <= pcs_ctrl1_ch2_reg(11);
rendec_rx_int(2)         <= pcs_ctrl1_ch2_reg(10);
r8b10b_enc_ibm_en_int(2) <= pcs_ctrl1_ch2_reg(9);
rmatchen_int(2)          <= pcs_ctrl1_ch2_reg(8);
r8b10b_dec_ibm_en_ch2_int<= pcs_ctrl1_ch2_reg(7 DOWNTO 6);
rforce_kchar_int(2)      <= pcs_ctrl1_ch2_reg(5);
rforce_echar_int(2)      <= pcs_ctrl1_ch2_reg(4);
rlp20ben_int(2)          <= pcs_ctrl1_ch2_reg(3);
rgenericfifo_int(2)      <= pcs_ctrl1_ch2_reg(2);
rcascaded_8b10b_en_tx_int(2) <= pcs_ctrl1_ch2_reg(1);
rcascaded_8b10b_en_rx_int(2) <= pcs_ctrl1_ch2_reg(0);

-- Outputs from PCS Per channel control register 1 for channel3 (4.8004h)
rtx_pipe_enable_int(3)   <= pcs_ctrl1_ch3_reg(15);
rrx_pipe_enable_int(3)   <= pcs_ctrl1_ch3_reg(14);
rpowdnr_md(3)            <= pcs_ctrl1_ch3_reg(13);
rpowdnt_md(3)            <= pcs_ctrl1_ch3_reg(12);
rendec_tx_int(3)         <= pcs_ctrl1_ch3_reg(11);
rendec_rx_int(3)         <= pcs_ctrl1_ch3_reg(10);
r8b10b_enc_ibm_en_int(3) <= pcs_ctrl1_ch3_reg(9);
rmatchen_int(3)          <= pcs_ctrl1_ch3_reg(8);
r8b10b_dec_ibm_en_ch3_int<= pcs_ctrl1_ch3_reg(7 DOWNTO 6);
rforce_kchar_int(3)      <= pcs_ctrl1_ch3_reg(5);
rforce_echar_int(3)      <= pcs_ctrl1_ch3_reg(4);
rlp20ben_int(3)          <= pcs_ctrl1_ch3_reg(3);
rgenericfifo_int(3)      <= pcs_ctrl1_ch3_reg(2);
rcascaded_8b10b_en_tx_int(3) <= pcs_ctrl1_ch3_reg(1);
rcascaded_8b10b_en_rx_int(3) <= pcs_ctrl1_ch3_reg(0);

-- Outputs from PCS Per channel control register 2 for channel0 (4.8005h)
resync_badcg_en_ch0_int  <= pcs_ctrl2_ch0_reg(15 DOWNTO 14);
rencdt_rising_int(0)     <= pcs_ctrl2_ch0_reg(13);
rdis_rx_disp_int(0)      <= pcs_ctrl2_ch0_reg(12);
rcomp_pat_porn_int(0)    <= pcs_ctrl2_ch0_reg(11);
rcomp_size_ch0_int       <= pcs_ctrl2_ch0_reg(10 DOWNTO 8);
rcomp_pat_ch0_int(39 DOWNTO 32) <= pcs_ctrl2_ch0_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 2 for channel1 (4.8006h)
resync_badcg_en_ch1_int  <= pcs_ctrl2_ch1_reg(15 DOWNTO 14);
rencdt_rising_int(1)     <= pcs_ctrl2_ch1_reg(13);
rdis_rx_disp_int(1)      <= pcs_ctrl2_ch1_reg(12);
rcomp_pat_porn_int(1)    <= pcs_ctrl2_ch1_reg(11);
rcomp_size_ch1_int       <= pcs_ctrl2_ch1_reg(10 DOWNTO 8);
rcomp_pat_ch1_int(39 DOWNTO 32) <= pcs_ctrl2_ch1_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 2 for channel2 (4.8007h)
resync_badcg_en_ch2_int  <= pcs_ctrl2_ch2_reg(15 DOWNTO 14);
rencdt_rising_int(2)     <= pcs_ctrl2_ch2_reg(13);
rdis_rx_disp_int(2)      <= pcs_ctrl2_ch2_reg(12);
rcomp_pat_porn_int(2)    <= pcs_ctrl2_ch2_reg(11);
rcomp_size_ch2_int       <= pcs_ctrl2_ch2_reg(10 DOWNTO 8);
rcomp_pat_ch2_int(39 DOWNTO 32) <= pcs_ctrl2_ch2_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 2 for channel3 (4.8008h)
resync_badcg_en_ch3_int  <= pcs_ctrl2_ch3_reg(15 DOWNTO 14);
rencdt_rising_int(3)     <= pcs_ctrl2_ch3_reg(13);
rdis_rx_disp_int(3)      <= pcs_ctrl2_ch3_reg(12);
rcomp_pat_porn_int(3)    <= pcs_ctrl2_ch3_reg(11);
rcomp_size_ch3_int       <= pcs_ctrl2_ch3_reg(10 DOWNTO 8);
rcomp_pat_ch3_int(39 DOWNTO 32) <= pcs_ctrl2_ch3_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 3 for channel0 &1 &2 &3 (4.8009h-800Ch)
rcomp_pat_ch0_int(31 DOWNTO 16) <= pcs_ctrl3_ch0_reg;
rcomp_pat_ch1_int(31 DOWNTO 16) <= pcs_ctrl3_ch1_reg;
rcomp_pat_ch2_int(31 DOWNTO 16) <= pcs_ctrl3_ch2_reg;
rcomp_pat_ch3_int(31 DOWNTO 16) <= pcs_ctrl3_ch3_reg;

-- Outputs from PCS Per channel control register 4 for channel0 &1 &2 &3 (4.800Dh-8010h)
rcomp_pat_ch0_int(15 DOWNTO 0) <= pcs_ctrl4_ch0_reg;
rcomp_pat_ch1_int(15 DOWNTO 0) <= pcs_ctrl4_ch1_reg;
rcomp_pat_ch2_int(15 DOWNTO 0) <= pcs_ctrl4_ch2_reg;
rcomp_pat_ch3_int(15 DOWNTO 0) <= pcs_ctrl4_ch3_reg;

-- Outputs from PCS Per channel control register 5 for channel0 (4.8011h)
rrxfifo_dis_int(0)          <= pcs_ctrl5_ch0_reg(15);
rtxfifo_dis_int(0)          <= pcs_ctrl5_ch0_reg(14);
rib_force_disp_int(0)       <= pcs_ctrl5_ch0_reg(13);
rrundisp_ch0_int            <= pcs_ctrl5_ch0_reg(12 DOWNTO 7);
rtxfifo_lowlatency_en_int(0)<= pcs_ctrl5_ch0_reg(6);
rrlv_en_int(0)              <= pcs_ctrl5_ch0_reg(5);
rautobtalg_dis_int(0)       <= pcs_ctrl5_ch0_reg(4);
rsync_sm_dis_int(0)         <= pcs_ctrl5_ch0_reg(3);
rib_inv_cd_ch0_int          <= pcs_ctrl5_ch0_reg(2 DOWNTO 1);
rrxfifo_lowlatency_en_int(0)<= pcs_ctrl5_ch0_reg(0);

-- Outputs from PCS Per channel control register 5 for channel1 (4.8012h)
rrxfifo_dis_int(1)          <= pcs_ctrl5_ch1_reg(15);
rtxfifo_dis_int(1)          <= pcs_ctrl5_ch1_reg(14);
rib_force_disp_int(1)       <= pcs_ctrl5_ch1_reg(13);
rrundisp_ch1_int            <= pcs_ctrl5_ch1_reg(12 DOWNTO 7);
rtxfifo_lowlatency_en_int(1)<= pcs_ctrl5_ch1_reg(6);
rrlv_en_int(1)              <= pcs_ctrl5_ch1_reg(5);
rautobtalg_dis_int(1)       <= pcs_ctrl5_ch1_reg(4);
rsync_sm_dis_int(1)         <= pcs_ctrl5_ch1_reg(3);
rib_inv_cd_ch1_int          <= pcs_ctrl5_ch1_reg(2 DOWNTO 1);
rrxfifo_lowlatency_en_int(1)<= pcs_ctrl5_ch1_reg(0);

-- Outputs from PCS Per channel control register 5 for channel2 (4.8013h)
rrxfifo_dis_int(2)          <= pcs_ctrl5_ch2_reg(15);
rtxfifo_dis_int(2)          <= pcs_ctrl5_ch2_reg(14);
rib_force_disp_int(2)       <= pcs_ctrl5_ch2_reg(13);
rrundisp_ch2_int            <= pcs_ctrl5_ch2_reg(12 DOWNTO 7);
rtxfifo_lowlatency_en_int(2)<= pcs_ctrl5_ch2_reg(6);
rrlv_en_int(2)              <= pcs_ctrl5_ch2_reg(5);
rautobtalg_dis_int(2)       <= pcs_ctrl5_ch2_reg(4);
rsync_sm_dis_int(2)         <= pcs_ctrl5_ch2_reg(3);
rib_inv_cd_ch2_int          <= pcs_ctrl5_ch2_reg(2 DOWNTO 1);
rrxfifo_lowlatency_en_int(2)<= pcs_ctrl5_ch2_reg(0);

-- Outputs from PCS Per channel control register 5 for channel3 (4.8014h)
rrxfifo_dis_int(3)          <= pcs_ctrl5_ch3_reg(15);
rtxfifo_dis_int(3)          <= pcs_ctrl5_ch3_reg(14);
rib_force_disp_int(3)       <= pcs_ctrl5_ch3_reg(13);
rrundisp_ch3_int            <= pcs_ctrl5_ch3_reg(12 DOWNTO 7);
rtxfifo_lowlatency_en_int(3)<= pcs_ctrl5_ch3_reg(6);
rrlv_en_int(3)              <= pcs_ctrl5_ch3_reg(5);
rautobtalg_dis_int(3)       <= pcs_ctrl5_ch3_reg(4);
rsync_sm_dis_int(3)         <= pcs_ctrl5_ch3_reg(3);
rib_inv_cd_ch3_int          <= pcs_ctrl5_ch3_reg(2 DOWNTO 1);
rrxfifo_lowlatency_en_int(3)<= pcs_ctrl5_ch3_reg(0);

-- Outputs from PCS Per channel control register 6 for channel0 (4.8015h)
rdwidth_tx_int(0)       <= pcs_ctrl6_ch0_reg(15);
rdwidth_rx_int(0)       <= pcs_ctrl6_ch0_reg(14);
rge_xaui_tx_int(0)      <= pcs_ctrl6_ch0_reg(13);
rrx_detect_bypass_int(0)<= pcs_ctrl6_ch0_reg(12);
rtxurstpcs_md(0)        <= pcs_ctrl6_ch0_reg(11);
rrxurstpcs_md(0)        <= pcs_ctrl6_ch0_reg(10);
rrsvd_tx_ch0_int        <= pcs_ctrl6_ch0_reg(9 DOWNTO 5);
rskpsetbased_int(0)     <= pcs_ctrl6_ch0_reg(4);
rtruebac2bac_int(0)     <= pcs_ctrl6_ch0_reg(3);
rrsvd_rx_ch0_int        <= pcs_ctrl6_ch0_reg(2 DOWNTO 0);

-- Outputs from PCS Per channel control register 6 for channel1 (4.8016h)
rdwidth_tx_int(1)       <= pcs_ctrl6_ch1_reg(15);
rdwidth_rx_int(1)       <= pcs_ctrl6_ch1_reg(14);
rge_xaui_tx_int(1)      <= pcs_ctrl6_ch1_reg(13);
rrx_detect_bypass_int(1)<= pcs_ctrl6_ch1_reg(12);
rtxurstpcs_md(1)        <= pcs_ctrl6_ch1_reg(11);
rrxurstpcs_md(1)        <= pcs_ctrl6_ch1_reg(10);
rrsvd_tx_ch1_int        <= pcs_ctrl6_ch1_reg(9 DOWNTO 5);
rskpsetbased_int(1)     <= pcs_ctrl6_ch1_reg(4);
rtruebac2bac_int(1)     <= pcs_ctrl6_ch1_reg(3);
rrsvd_rx_ch1_int        <= pcs_ctrl6_ch1_reg(2 DOWNTO 0);

-- Outputs from PCS Per channel control register 6 for channel2 (4.8017h)
rdwidth_tx_int(2)       <= pcs_ctrl6_ch2_reg(15);
rdwidth_rx_int(2)       <= pcs_ctrl6_ch2_reg(14);
rge_xaui_tx_int(2)      <= pcs_ctrl6_ch2_reg(13);
rrx_detect_bypass_int(2)<= pcs_ctrl6_ch2_reg(12);
rtxurstpcs_md(2)        <= pcs_ctrl6_ch2_reg(11);
rrxurstpcs_md(2)        <= pcs_ctrl6_ch2_reg(10);
rrsvd_tx_ch2_int        <= pcs_ctrl6_ch2_reg(9 DOWNTO 5);
rskpsetbased_int(2)     <= pcs_ctrl6_ch2_reg(4);
rtruebac2bac_int(2)     <= pcs_ctrl6_ch2_reg(3);
rrsvd_rx_ch2_int        <= pcs_ctrl6_ch2_reg(2 DOWNTO 0);

-- Outputs from PCS Per channel control register 6 for channel3 (4.8018h)
rdwidth_tx_int(3)       <= pcs_ctrl6_ch3_reg(15);
rdwidth_rx_int(3)       <= pcs_ctrl6_ch3_reg(14);
rge_xaui_tx_int(3)      <= pcs_ctrl6_ch3_reg(13);
rrx_detect_bypass_int(3)<= pcs_ctrl6_ch3_reg(12);
rtxurstpcs_md(3)        <= pcs_ctrl6_ch3_reg(11);
rrxurstpcs_md(3)        <= pcs_ctrl6_ch3_reg(10);
rrsvd_tx_ch3_int        <= pcs_ctrl6_ch3_reg(9 DOWNTO 5);
rskpsetbased_int(3)     <= pcs_ctrl6_ch3_reg(4);
rtruebac2bac_int(3)     <= pcs_ctrl6_ch3_reg(3);
rrsvd_rx_ch3_int        <= pcs_ctrl6_ch3_reg(2 DOWNTO 0);

-- Outputs from PCS Per channel control register 7 for channel0 (4.8019h)
rgnumber_ch0_int      <= pcs_ctrl7_ch0_reg(15 DOWNTO 8);
rknumber_ch0_int      <= pcs_ctrl7_ch0_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 7 for channel1 (4.801Ah)
rgnumber_ch1_int      <= pcs_ctrl7_ch1_reg(15 DOWNTO 8);
rknumber_ch1_int      <= pcs_ctrl7_ch1_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 7 for channel2 (4.801Bh)
rgnumber_ch2_int      <= pcs_ctrl7_ch2_reg(15 DOWNTO 8);
rknumber_ch2_int      <= pcs_ctrl7_ch2_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 7 for channel3 (4.801Ch)
rgnumber_ch3_int      <= pcs_ctrl7_ch3_reg(15 DOWNTO 8);
rknumber_ch3_int      <= pcs_ctrl7_ch3_reg(7 DOWNTO 0);

-- Outputs from PCS Per channel control register 8 for channel0 (4.801Dh)
rfreerun_tx_int(0)      <= pcs_ctrl8_ch0_reg(15);
rtxwrclksel_int(0)      <= pcs_ctrl8_ch0_reg(14);
rtxrdclksel_int(0)      <= pcs_ctrl8_ch0_reg(13);
rfreerun_rx_int(0)      <= pcs_ctrl8_ch0_reg(12);
rrcvd_clk_sel_ch0_int   <= pcs_ctrl8_ch0_reg(11 DOWNTO 10);
rclk_1_sel_ch0_int      <= pcs_ctrl8_ch0_reg(9 DOWNTO 8);
rclk_2_sel_ch0_int      <= pcs_ctrl8_ch0_reg(7 DOWNTO 6);
rrx_rd_clk_sel_int(0)   <= pcs_ctrl8_ch0_reg(5);
renumber_ch0_int        <= pcs_ctrl8_ch0_reg(4 DOWNTO 2);
renpolinv_rx_int(0)     <= pcs_ctrl8_ch0_reg(1);
rclkcmpinsertpad_int(0) <= pcs_ctrl8_ch0_reg(0);

-- Outputs from PCS Per channel control register 8 for channel1 (4.801Eh)
rfreerun_tx_int(1)      <= pcs_ctrl8_ch1_reg(15);
rtxwrclksel_int(1)      <= pcs_ctrl8_ch1_reg(14);
rtxrdclksel_int(1)      <= pcs_ctrl8_ch1_reg(13);
rfreerun_rx_int(1)      <= pcs_ctrl8_ch1_reg(12);
rrcvd_clk_sel_ch1_int   <= pcs_ctrl8_ch1_reg(11 DOWNTO 10);
rclk_1_sel_ch1_int      <= pcs_ctrl8_ch1_reg(9 DOWNTO 8);
rclk_2_sel_ch1_int      <= pcs_ctrl8_ch1_reg(7 DOWNTO 6);
rrx_rd_clk_sel_int(1)   <= pcs_ctrl8_ch1_reg(5);
renumber_ch1_int        <= pcs_ctrl8_ch1_reg(4 DOWNTO 2);
renpolinv_rx_int(1)     <= pcs_ctrl8_ch1_reg(1);
rclkcmpinsertpad_int(1) <= pcs_ctrl8_ch1_reg(0);

-- Outputs from PCS Per channel control register 8 for channel2 (4.801Fh)
rfreerun_tx_int(2)      <= pcs_ctrl8_ch2_reg(15);
rtxwrclksel_int(2)      <= pcs_ctrl8_ch2_reg(14);
rtxrdclksel_int(2)      <= pcs_ctrl8_ch2_reg(13);
rfreerun_rx_int(2)      <= pcs_ctrl8_ch2_reg(12);
rrcvd_clk_sel_ch2_int   <= pcs_ctrl8_ch2_reg(11 DOWNTO 10);
rclk_1_sel_ch2_int      <= pcs_ctrl8_ch2_reg(9 DOWNTO 8);
rclk_2_sel_ch2_int      <= pcs_ctrl8_ch2_reg(7 DOWNTO 6);
rrx_rd_clk_sel_int(2)   <= pcs_ctrl8_ch2_reg(5);
renumber_ch2_int        <= pcs_ctrl8_ch2_reg(4 DOWNTO 2);
renpolinv_rx_int(2)     <= pcs_ctrl8_ch2_reg(1);
rclkcmpinsertpad_int(2) <= pcs_ctrl8_ch2_reg(0);

-- Outputs from PCS Per channel control register 8 for channel3 (4.8020h)
rfreerun_tx_int(3)      <= pcs_ctrl8_ch3_reg(15);
rtxwrclksel_int(3)      <= pcs_ctrl8_ch3_reg(14);
rtxrdclksel_int(3)      <= pcs_ctrl8_ch3_reg(13);
rfreerun_rx_int(3)      <= pcs_ctrl8_ch3_reg(12);
rrcvd_clk_sel_ch3_int   <= pcs_ctrl8_ch3_reg(11 DOWNTO 10);
rclk_1_sel_ch3_int      <= pcs_ctrl8_ch3_reg(9 DOWNTO 8);
rclk_2_sel_ch3_int      <= pcs_ctrl8_ch3_reg(7 DOWNTO 6);
rrx_rd_clk_sel_int(3)   <= pcs_ctrl8_ch3_reg(5);
renumber_ch3_int        <= pcs_ctrl8_ch3_reg(4 DOWNTO 2);
renpolinv_rx_int(3)     <= pcs_ctrl8_ch3_reg(1);
rclkcmpinsertpad_int(3) <= pcs_ctrl8_ch3_reg(0);

-- Outputs from BIST/PRBS test control register for channel0 (4.8021h)
rprbsen_tx_int(0)        <= prbs_bist_ctrl_ch0_reg(15);
rprbsen_rx_int(0)        <= prbs_bist_ctrl_ch0_reg(14);
rprbs_clr_rslt_rx_int(0) <= prbs_bist_ctrl_ch0_reg(13);
rprbs_sel_ch0_int        <= prbs_bist_ctrl_ch0_reg(12 DOWNTO 10);
rbisten_tx_int(0)        <= prbs_bist_ctrl_ch0_reg(9);
rbisten_rx_int(0)        <= prbs_bist_ctrl_ch0_reg(8);
rbist_clr_rx_int(0)      <= prbs_bist_ctrl_ch0_reg(7);
rbist_sel_ch0_int        <= prbs_bist_ctrl_ch0_reg(6 DOWNTO 5);
rcxpat_chnl_en_ch0_int   <= prbs_bist_ctrl_ch0_reg(4 DOWNTO 3);
rall_one_dect_only_int(0)<= prbs_bist_ctrl_ch0_reg(2);

-- Outputs from BIST/PRBS test control register for channel1 (4.8022h)
rprbsen_tx_int(1)        <= prbs_bist_ctrl_ch1_reg(15);
rprbsen_rx_int(1)        <= prbs_bist_ctrl_ch1_reg(14);
rprbs_clr_rslt_rx_int(1) <= prbs_bist_ctrl_ch1_reg(13);
rprbs_sel_ch1_int        <= prbs_bist_ctrl_ch1_reg(12 DOWNTO 10);
rbisten_tx_int(1)        <= prbs_bist_ctrl_ch1_reg(9);
rbisten_rx_int(1)        <= prbs_bist_ctrl_ch1_reg(8);
rbist_clr_rx_int(1)      <= prbs_bist_ctrl_ch1_reg(7);
rbist_sel_ch1_int        <= prbs_bist_ctrl_ch1_reg(6 DOWNTO 5);
rcxpat_chnl_en_ch1_int   <= prbs_bist_ctrl_ch1_reg(4 DOWNTO 3);
rall_one_dect_only_int(1)<= prbs_bist_ctrl_ch1_reg(2);

-- Outputs from BIST/PRBS test control register for channel2 (4.8023h)
rprbsen_tx_int(2)        <= prbs_bist_ctrl_ch2_reg(15);
rprbsen_rx_int(2)        <= prbs_bist_ctrl_ch2_reg(14);
rprbs_clr_rslt_rx_int(2) <= prbs_bist_ctrl_ch2_reg(13);
rprbs_sel_ch2_int        <= prbs_bist_ctrl_ch2_reg(12 DOWNTO 10);
rbisten_tx_int(2)        <= prbs_bist_ctrl_ch2_reg(9);
rbisten_rx_int(2)        <= prbs_bist_ctrl_ch2_reg(8);
rbist_clr_rx_int(2)      <= prbs_bist_ctrl_ch2_reg(7);
rbist_sel_ch2_int        <= prbs_bist_ctrl_ch2_reg(6 DOWNTO 5);
rcxpat_chnl_en_ch2_int   <= prbs_bist_ctrl_ch2_reg(4 DOWNTO 3);
rall_one_dect_only_int(2)<= prbs_bist_ctrl_ch2_reg(2);

-- Outputs from BIST/PRBS test control register for channel3 (4.8024h)
rprbsen_tx_int(3)        <= prbs_bist_ctrl_ch3_reg(15);
rprbsen_rx_int(3)        <= prbs_bist_ctrl_ch3_reg(14);
rprbs_clr_rslt_rx_int(3) <= prbs_bist_ctrl_ch3_reg(13);
rprbs_sel_ch3_int        <= prbs_bist_ctrl_ch3_reg(12 DOWNTO 10);
rbisten_tx_int(3)        <= prbs_bist_ctrl_ch3_reg(9);
rbisten_rx_int(3)        <= prbs_bist_ctrl_ch3_reg(8);
rbist_clr_rx_int(3)      <= prbs_bist_ctrl_ch3_reg(7);
rbist_sel_ch3_int        <= prbs_bist_ctrl_ch3_reg(6 DOWNTO 5);
rcxpat_chnl_en_ch3_int   <= prbs_bist_ctrl_ch3_reg(4 DOWNTO 3);
rall_one_dect_only_int(3)<= prbs_bist_ctrl_ch3_reg(2);

-- Outputs from PCS Per channel control register 9 for channel0 (4.8025h)
rppm_cnt_reset_int(0)     <= pcs_ctrl9_ch0_reg(15);
rphfifourstrx_int(0)      <= pcs_ctrl9_ch0_reg(14);
rcmpfifourst_int(0)       <= pcs_ctrl9_ch0_reg(13);
rtx_idle_delay_ch0_int    <= pcs_ctrl9_ch0_reg(12 DOWNTO 11);
rclkcmpsqmd_int(0)        <= pcs_ctrl9_ch0_reg(10);
rclkcmpsq1p_ch0_int(9 DOWNTO 0)  <= pcs_ctrl9_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 9 for channel1 (4.8026h)
rppm_cnt_reset_int(1)     <= pcs_ctrl9_ch1_reg(15);
rphfifourstrx_int(1)      <= pcs_ctrl9_ch1_reg(14);
rcmpfifourst_int(1)       <= pcs_ctrl9_ch1_reg(13);
rtx_idle_delay_ch1_int    <= pcs_ctrl9_ch1_reg(12 DOWNTO 11);
rclkcmpsqmd_int(1)        <= pcs_ctrl9_ch1_reg(10);
rclkcmpsq1p_ch1_int(9 DOWNTO 0)  <= pcs_ctrl9_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 9 for channel2 (4.8027h)
rppm_cnt_reset_int(2)     <= pcs_ctrl9_ch2_reg(15);
rphfifourstrx_int(2)      <= pcs_ctrl9_ch2_reg(14);
rcmpfifourst_int(2)       <= pcs_ctrl9_ch2_reg(13);
rtx_idle_delay_ch2_int    <= pcs_ctrl9_ch2_reg(12 DOWNTO 11);
rclkcmpsqmd_int(2)        <= pcs_ctrl9_ch2_reg(10);
rclkcmpsq1p_ch2_int(9 DOWNTO 0)  <= pcs_ctrl9_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 9 for channel3 (4.8028h)
rppm_cnt_reset_int(3)     <= pcs_ctrl9_ch3_reg(15);
rphfifourstrx_int(3)      <= pcs_ctrl9_ch3_reg(14);
rcmpfifourst_int(3)       <= pcs_ctrl9_ch3_reg(13);
rtx_idle_delay_ch3_int    <= pcs_ctrl9_ch3_reg(12 DOWNTO 11);
rclkcmpsqmd_int(3)        <= pcs_ctrl9_ch3_reg(10);
rclkcmpsq1p_ch3_int(9 DOWNTO 0)  <= pcs_ctrl9_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 10 for channel0 (4.8029h)
rclkcmpsq1n_ch0_int(19 DOWNTO 15)  <= pcs_ctrl10_ch0_reg(15 DOWNTO 11);
rclkcmppos_int(0)           <= pcs_ctrl10_ch0_reg(10);
rclkcmpsq1p_ch0_int(19 DOWNTO 10)  <= pcs_ctrl10_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 10 for channel1 (4.802Ah)
rclkcmpsq1n_ch1_int(19 DOWNTO 15)  <= pcs_ctrl10_ch1_reg(15 DOWNTO 11);
rclkcmppos_int(1)           <= pcs_ctrl10_ch1_reg(10);
rclkcmpsq1p_ch1_int(19 DOWNTO 10)  <= pcs_ctrl10_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 10 for channel2 (4.802Bh)
rclkcmpsq1n_ch2_int(19 DOWNTO 15)  <= pcs_ctrl10_ch2_reg(15 DOWNTO 11);
rclkcmppos_int(2)           <= pcs_ctrl10_ch2_reg(10);
rclkcmpsq1p_ch2_int(19 DOWNTO 10)  <= pcs_ctrl10_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 10 for channel3 (4.802Ch)
rclkcmpsq1n_ch3_int(19 DOWNTO 15)  <= pcs_ctrl10_ch3_reg(15 DOWNTO 11);
rclkcmppos_int(3)           <= pcs_ctrl10_ch3_reg(10);
rclkcmpsq1p_ch3_int(19 DOWNTO 10)  <= pcs_ctrl10_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 11 for channel0 (4.802Dh)
rclkcmpsq1n_ch0_int(14 DOWNTO 10)  <= pcs_ctrl11_ch0_reg(15 DOWNTO 11);
rclkcmpsq1n_ch0_int(9 DOWNTO 0)    <= pcs_ctrl11_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 11 for channel1 (4.802Eh)
rclkcmpsq1n_ch1_int(14 DOWNTO 10)  <= pcs_ctrl11_ch1_reg(15 DOWNTO 11);
rclkcmpsq1n_ch1_int(9 DOWNTO 0)    <= pcs_ctrl11_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 11 for channel2 (4.802Fh)
rclkcmpsq1n_ch2_int(14 DOWNTO 10)  <= pcs_ctrl11_ch2_reg(15 DOWNTO 11);
rclkcmpsq1n_ch2_int(9 DOWNTO 0)    <= pcs_ctrl11_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 11 for channel3 (4.8030h)
rclkcmpsq1n_ch3_int(14 DOWNTO 10)  <= pcs_ctrl11_ch3_reg(15 DOWNTO 11);
rclkcmpsq1n_ch3_int(9 DOWNTO 0)    <= pcs_ctrl11_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 12 for channel0 (4.8031h)
rrev_loopbk_int(0)          <= pcs_ctrl12_ch0_reg(15);
ralempty_ch0_int            <= pcs_ctrl12_ch0_reg(14 DOWNTO 11);
ralfull_ch0_int             <= pcs_ctrl12_ch0_reg(10 DOWNTO 7);
rforce_disp_int(0)          <= pcs_ctrl12_ch0_reg(6);
rkchar_int(0)               <= pcs_ctrl12_ch0_reg(5);
rosbased_int(0)             <= pcs_ctrl12_ch0_reg(4);
rensymswap_tx_int(0)        <= pcs_ctrl12_ch0_reg(3);
rosnumber_ch0_int           <= pcs_ctrl12_ch0_reg(1 DOWNTO 0);

-- Outputs from PCS Per channel control register 12 for channel1 (4.8032h)
rrev_loopbk_int(1)          <= pcs_ctrl12_ch1_reg(15);
ralempty_ch1_int            <= pcs_ctrl12_ch1_reg(14 DOWNTO 11);
ralfull_ch1_int             <= pcs_ctrl12_ch1_reg(10 DOWNTO 7);
rforce_disp_int(1)          <= pcs_ctrl12_ch1_reg(6);
rkchar_int(1)               <= pcs_ctrl12_ch1_reg(5);
rosbased_int(1)             <= pcs_ctrl12_ch1_reg(4);
rensymswap_tx_int(1)        <= pcs_ctrl12_ch1_reg(3);
rosnumber_ch1_int           <= pcs_ctrl12_ch1_reg(1 DOWNTO 0);

-- Outputs from PCS Per channel control register 12 for channel2 (4.8033h)
rrev_loopbk_int(2)          <= pcs_ctrl12_ch2_reg(15);
ralempty_ch2_int            <= pcs_ctrl12_ch2_reg(14 DOWNTO 11);
ralfull_ch2_int             <= pcs_ctrl12_ch2_reg(10 DOWNTO 7);
rforce_disp_int(2)          <= pcs_ctrl12_ch2_reg(6);
rkchar_int(2)               <= pcs_ctrl12_ch2_reg(5);
rosbased_int(2)             <= pcs_ctrl12_ch2_reg(4);
rensymswap_tx_int(2)        <= pcs_ctrl12_ch2_reg(3);
rosnumber_ch2_int           <= pcs_ctrl12_ch2_reg(1 DOWNTO 0);

-- Outputs from PCS Per channel control register 12 for channel3 (4.8034h)
rrev_loopbk_int(3)          <= pcs_ctrl12_ch3_reg(15);
ralempty_ch3_int            <= pcs_ctrl12_ch3_reg(14 DOWNTO 11);
ralfull_ch3_int             <= pcs_ctrl12_ch3_reg(10 DOWNTO 7);
rforce_disp_int(3)          <= pcs_ctrl12_ch3_reg(6);
rkchar_int(3)               <= pcs_ctrl12_ch3_reg(5);
rosbased_int(3)             <= pcs_ctrl12_ch3_reg(4);
rensymswap_tx_int(3)        <= pcs_ctrl12_ch3_reg(3);
rosnumber_ch3_int           <= pcs_ctrl12_ch3_reg(1 DOWNTO 0);

-- Outputs from PCS Per channel control register 13 for channel0 (4.8035h)
rwa_6g_en_int(0)            <= pcs_ctrl13_ch0_reg(15);
renpolinv_tx_int(0)         <= pcs_ctrl13_ch0_reg(14);
rbitslip_size_ch0_int       <= pcs_ctrl13_ch0_reg(13 DOWNTO 12);
rbytord_2sym_en_int(0)      <= pcs_ctrl13_ch0_reg(11);
rbysync_polinv_en_int(0)    <= pcs_ctrl13_ch0_reg(10);
rbitloc_rev_en_int(0)       <= pcs_ctrl13_ch0_reg(9);
rbyte_rev_en_int(0)         <= pcs_ctrl13_ch0_reg(8);
renbitrev_tx_int(0)         <= pcs_ctrl13_ch0_reg(7);
rbyteorden_ch0_int          <= pcs_ctrl13_ch0_reg(6 DOWNTO 5);
rbytordplden_int(0)         <= pcs_ctrl13_ch0_reg(4);
rphfifopldentx_int(0)       <= pcs_ctrl13_ch0_reg(3);
rphfifoursttx_int(0)        <= pcs_ctrl13_ch0_reg(2);
rphfifopldenrx_int(0)       <= pcs_ctrl13_ch0_reg(1);
rautoinsdis_int(0)          <= pcs_ctrl13_ch0_reg(0);

-- Outputs from PCS Per channel control register 13 for channel1 (4.8036h)
rwa_6g_en_int(1)            <= pcs_ctrl13_ch1_reg(15);
renpolinv_tx_int(1)         <= pcs_ctrl13_ch1_reg(14);
rbitslip_size_ch1_int       <= pcs_ctrl13_ch1_reg(13 DOWNTO 12);
rbytord_2sym_en_int(1)      <= pcs_ctrl13_ch1_reg(11);
rbysync_polinv_en_int(1)    <= pcs_ctrl13_ch1_reg(10);
rbitloc_rev_en_int(1)       <= pcs_ctrl13_ch1_reg(9);
rbyte_rev_en_int(1)         <= pcs_ctrl13_ch1_reg(8);
renbitrev_tx_int(1)         <= pcs_ctrl13_ch1_reg(7);
rbyteorden_ch1_int          <= pcs_ctrl13_ch1_reg(6 DOWNTO 5);
rbytordplden_int(1)         <= pcs_ctrl13_ch1_reg(4);
rphfifopldentx_int(1)       <= pcs_ctrl13_ch1_reg(3);
rphfifoursttx_int(1)        <= pcs_ctrl13_ch1_reg(2);
rphfifopldenrx_int(1)       <= pcs_ctrl13_ch1_reg(1);
rautoinsdis_int(1)          <= pcs_ctrl13_ch1_reg(0);

-- Outputs from PCS Per channel control register 13 for channel2 (4.8037h)
rwa_6g_en_int(2)            <= pcs_ctrl13_ch2_reg(15);
renpolinv_tx_int(2)         <= pcs_ctrl13_ch2_reg(14);
rbitslip_size_ch2_int       <= pcs_ctrl13_ch2_reg(13 DOWNTO 12);
rbytord_2sym_en_int(2)      <= pcs_ctrl13_ch2_reg(11);
rbysync_polinv_en_int(2)    <= pcs_ctrl13_ch2_reg(10);
rbitloc_rev_en_int(2)       <= pcs_ctrl13_ch2_reg(9);
rbyte_rev_en_int(2)         <= pcs_ctrl13_ch2_reg(8);
renbitrev_tx_int(2)         <= pcs_ctrl13_ch2_reg(7);
rbyteorden_ch2_int          <= pcs_ctrl13_ch2_reg(6 DOWNTO 5);
rbytordplden_int(2)         <= pcs_ctrl13_ch2_reg(4);
rphfifopldentx_int(2)       <= pcs_ctrl13_ch2_reg(3);
rphfifoursttx_int(2)        <= pcs_ctrl13_ch2_reg(2);
rphfifopldenrx_int(2)       <= pcs_ctrl13_ch2_reg(1);
rautoinsdis_int(2)          <= pcs_ctrl13_ch2_reg(0);

-- Outputs from PCS Per channel control register 13 for channel3 (4.8038h)
rwa_6g_en_int(3)            <= pcs_ctrl13_ch3_reg(15);
renpolinv_tx_int(3)         <= pcs_ctrl13_ch3_reg(14);
rbitslip_size_ch3_int       <= pcs_ctrl13_ch3_reg(13 DOWNTO 12);
rbytord_2sym_en_int(3)      <= pcs_ctrl13_ch3_reg(11);
rbysync_polinv_en_int(3)    <= pcs_ctrl13_ch3_reg(10);
rbitloc_rev_en_int(3)       <= pcs_ctrl13_ch3_reg(9);
rbyte_rev_en_int(3)         <= pcs_ctrl13_ch3_reg(8);
renbitrev_tx_int(3)         <= pcs_ctrl13_ch3_reg(7);
rbyteorden_ch3_int          <= pcs_ctrl13_ch3_reg(6 DOWNTO 5);
rbytordplden_int(3)         <= pcs_ctrl13_ch3_reg(4);
rphfifopldentx_int(3)       <= pcs_ctrl13_ch3_reg(3);
rphfifoursttx_int(3)        <= pcs_ctrl13_ch3_reg(2);
rphfifopldenrx_int(3)       <= pcs_ctrl13_ch3_reg(1);
rautoinsdis_int(3)          <= pcs_ctrl13_ch3_reg(0);

-- Outputs from PCS Per channel control register 14 for channel0 (4.8039h)
rppmsel_ch0_int       <= pcs_ctrl14_ch0_reg(15 DOWNTO 10);
rbytordpat_ch0_int    <= pcs_ctrl14_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 14 for channel1 (4.803Ah)
rppmsel_ch1_int       <= pcs_ctrl14_ch1_reg(15 DOWNTO 10);
rbytordpat_ch1_int    <= pcs_ctrl14_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 14 for channel2 (4.803Bh)
rppmsel_ch2_int       <= pcs_ctrl14_ch2_reg(15 DOWNTO 10);
rbytordpat_ch2_int    <= pcs_ctrl14_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 14 for channel3 (4.803Ch)
rppmsel_ch3_int       <= pcs_ctrl14_ch3_reg(15 DOWNTO 10);
rbytordpat_ch3_int    <= pcs_ctrl14_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 15 for channel0 (4.803Dh)
rtest_bus_sel_ch0_int        <= pcs_ctrl15_ch0_reg(15 DOWNTO 13);
rforce_sig_det_pcs_int(0)    <= pcs_ctrl15_ch0_reg(12);
rforce0_freqdet_int(0)       <= pcs_ctrl15_ch0_reg(11);
rforce1_freqdet_int(0)       <= pcs_ctrl15_ch0_reg(10);
rbytordpad_ch0_int           <= pcs_ctrl15_ch0_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 15 for channel1 (4.803Eh)
rtest_bus_sel_ch1_int        <= pcs_ctrl15_ch1_reg(15 DOWNTO 13);
rforce_sig_det_pcs_int(1)    <= pcs_ctrl15_ch1_reg(12);
rforce0_freqdet_int(1)       <= pcs_ctrl15_ch1_reg(11);
rforce1_freqdet_int(1)       <= pcs_ctrl15_ch1_reg(10);
rbytordpad_ch1_int           <= pcs_ctrl15_ch1_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 15 for channel2 (4.803Fh)
rtest_bus_sel_ch2_int        <= pcs_ctrl15_ch2_reg(15 DOWNTO 13);
rforce_sig_det_pcs_int(2)    <= pcs_ctrl15_ch2_reg(12);
rforce0_freqdet_int(2)       <= pcs_ctrl15_ch2_reg(11);
rforce1_freqdet_int(2)       <= pcs_ctrl15_ch2_reg(10);
rbytordpad_ch2_int           <= pcs_ctrl15_ch2_reg(9 DOWNTO 0);

-- Outputs from PCS Per channel control register 15 for channel3 (4.8040h)
rtest_bus_sel_ch3_int        <= pcs_ctrl15_ch3_reg(15 DOWNTO 13);
rforce_sig_det_pcs_int(3)    <= pcs_ctrl15_ch3_reg(12);
rforce0_freqdet_int(3)       <= pcs_ctrl15_ch3_reg(11);
rforce1_freqdet_int(3)       <= pcs_ctrl15_ch3_reg(10);
rbytordpad_ch3_int           <= pcs_ctrl15_ch3_reg(9 DOWNTO 0);

-- Outputs from PCS Global control register 0 (4.8050h)
ralgnect_int     <= pcs_global_ctrl0_reg(6 DOWNTO 5);
ralgngct_int     <= pcs_global_ctrl0_reg(4 DOWNTO 3);
ralgnact_int     <= pcs_global_ctrl0_reg(2 DOWNTO 0);

-- Outputs from PCS Global control register 1 (4.8051h)
rfreerun_centrl_int <= pcs_global_ctrl1_reg(15);
rcentrl_clk_sel_int <= pcs_global_ctrl1_reg(14);
rrefclk_out_div2_int<= pcs_global_ctrl1_reg(11);
rdskposdisp_int     <= pcs_global_ctrl1_reg(10);
rdskchrp_int        <= pcs_global_ctrl1_reg(9 DOWNTO 0);

-- Outputs from PCS Global control register 2 (4.8052h)
rtest_bus_centrl_sel_int <= pcs_global_ctrl2_reg(12 DOWNTO 10);
ralgnopt_int             <= pcs_global_ctrl2_reg(13);

-- PMA CRAMs
-- Outputs from PMA Per channel control register 1 for channel0 (4.8060h)
 rtx_vod_sel_ch0_int          <= pma_ctrl1_ch0_reg(15 DOWNTO 13);
 rtx_slewrate_int(0)          <= pma_ctrl1_ch0_reg(12);
 rpmphs_2tap_ch0_int          <= pma_ctrl1_ch0_reg(11 DOWNTO 9);
 rpmphs_1tap_ch0_int          <= pma_ctrl1_ch0_reg(8 DOWNTO 5);
 rtx_vtt_ch0_int              <= pma_ctrl1_ch0_reg(4 DOWNTO 3);
 rpmphs_ptap_ch0_int          <= pma_ctrl1_ch0_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 1 for channel1 (4.8061h)
 rtx_vod_sel_ch1_int          <= pma_ctrl1_ch1_reg(15 DOWNTO 13);
 rtx_slewrate_int(1)          <= pma_ctrl1_ch1_reg(12);
 rpmphs_2tap_ch1_int          <= pma_ctrl1_ch1_reg(11 DOWNTO 9);
 rpmphs_1tap_ch1_int          <= pma_ctrl1_ch1_reg(8 DOWNTO 5);
 rtx_vtt_ch1_int              <= pma_ctrl1_ch1_reg(4 DOWNTO 3);
 rpmphs_ptap_ch1_int          <= pma_ctrl1_ch1_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 1 for channel2 (4.8062h)
 rtx_vod_sel_ch2_int          <= pma_ctrl1_ch2_reg(15 DOWNTO 13);
 rtx_slewrate_int(2)          <= pma_ctrl1_ch2_reg(12);
 rpmphs_2tap_ch2_int          <= pma_ctrl1_ch2_reg(11 DOWNTO 9);
 rpmphs_1tap_ch2_int          <= pma_ctrl1_ch2_reg(8 DOWNTO 5);
 rtx_vtt_ch2_int              <= pma_ctrl1_ch2_reg(4 DOWNTO 3);
 rpmphs_ptap_ch2_int          <= pma_ctrl1_ch2_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 1 for channel3 (4.8063h)
 rtx_vod_sel_ch3_int          <= pma_ctrl1_ch3_reg(15 DOWNTO 13);
 rtx_slewrate_int(3)          <= pma_ctrl1_ch3_reg(12);
 rpmphs_2tap_ch3_int          <= pma_ctrl1_ch3_reg(11 DOWNTO 9);
 rpmphs_1tap_ch3_int          <= pma_ctrl1_ch3_reg(8 DOWNTO 5);
 rtx_vtt_ch3_int              <= pma_ctrl1_ch3_reg(4 DOWNTO 3);
 rpmphs_ptap_ch3_int          <= pma_ctrl1_ch3_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 2 for channel0 (4.8064h)
 rtx_term_ch0_int             <= pma_ctrl2_ch0_reg(15 DOWNTO 14);
 r_tx_det_rx_ch0_int          <= pma_ctrl2_ch0_reg(13 DOWNTO 12);
 rrx_term_ch0_int             <= pma_ctrl2_ch0_reg(11 DOWNTO 10);
 rforce_sigdet_int(0)         <= pma_ctrl2_ch0_reg(9);
 rrx_dc_couple_int(0)         <= pma_ctrl2_ch0_reg(8);
 rrx_eq_dc_ch0_int            <= pma_ctrl2_ch0_reg(7 DOWNTO 6);
 rrx_vtt_ch0_int              <= pma_ctrl2_ch0_reg(5 DOWNTO 3);
 rrx_sloslv_ch0_int           <= pma_ctrl2_ch0_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 2 for channel1 (4.8065h)
 rtx_term_ch1_int             <= pma_ctrl2_ch1_reg(15 DOWNTO 14);
 r_tx_det_rx_ch1_int          <= pma_ctrl2_ch1_reg(13 DOWNTO 12);
 rrx_term_ch1_int             <= pma_ctrl2_ch1_reg(11 DOWNTO 10);
 rforce_sigdet_int(1)         <= pma_ctrl2_ch1_reg(9);
 rrx_dc_couple_int(1)         <= pma_ctrl2_ch1_reg(8);
 rrx_eq_dc_ch1_int            <= pma_ctrl2_ch1_reg(7 DOWNTO 6);
 rrx_vtt_ch1_int              <= pma_ctrl2_ch1_reg(5 DOWNTO 3);
 rrx_sloslv_ch1_int           <= pma_ctrl2_ch1_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 2 for channel2 (4.8066h)
 rtx_term_ch2_int             <= pma_ctrl2_ch2_reg(15 DOWNTO 14);
 r_tx_det_rx_ch2_int          <= pma_ctrl2_ch2_reg(13 DOWNTO 12);
 rrx_term_ch2_int             <= pma_ctrl2_ch2_reg(11 DOWNTO 10);
 rforce_sigdet_int(2)         <= pma_ctrl2_ch2_reg(9);
 rrx_dc_couple_int(2)         <= pma_ctrl2_ch2_reg(8);
 rrx_eq_dc_ch2_int            <= pma_ctrl2_ch2_reg(7 DOWNTO 6);
 rrx_vtt_ch2_int              <= pma_ctrl2_ch2_reg(5 DOWNTO 3);
 rrx_sloslv_ch2_int           <= pma_ctrl2_ch2_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 2 for channel3 (4.8067h)
 rtx_term_ch3_int             <= pma_ctrl2_ch3_reg(15 DOWNTO 14);
 r_tx_det_rx_ch3_int          <= pma_ctrl2_ch3_reg(13 DOWNTO 12);
 rrx_term_ch3_int             <= pma_ctrl2_ch3_reg(11 DOWNTO 10);
 rforce_sigdet_int(3)         <= pma_ctrl2_ch3_reg(9);
 rrx_dc_couple_int(3)         <= pma_ctrl2_ch3_reg(8);
 rrx_eq_dc_ch3_int            <= pma_ctrl2_ch3_reg(7 DOWNTO 6);
 rrx_vtt_ch3_int              <= pma_ctrl2_ch3_reg(5 DOWNTO 3);
 rrx_sloslv_ch3_int           <= pma_ctrl2_ch3_reg(2 DOWNTO 0);

-- Outputs from PMA Per channel control register 3 for channel0 (4.8068h)
	reqa_ct_ch0_int	             <= pma_ctrl3_ch0_reg(15 DOWNTO 13);
	reqb_ct_ch0_int	             <= pma_ctrl3_ch0_reg(12 DOWNTO 10);
	reqc_ct_ch0_int	             <= pma_ctrl3_ch0_reg(9 DOWNTO 7);
	reqd_ct_ch0_int	             <= pma_ctrl3_ch0_reg(6 DOWNTO 4);
	req_ctv_ch0_int	             <= pma_ctrl3_ch0_reg(3 DOWNTO 1);

-- Outputs from PMA Per channel control register 3 for channel1 (4.8069h)
	reqa_ct_ch1_int	             <= pma_ctrl3_ch1_reg(15 DOWNTO 13);
	reqb_ct_ch1_int	             <= pma_ctrl3_ch1_reg(12 DOWNTO 10);
	reqc_ct_ch1_int	             <= pma_ctrl3_ch1_reg(9 DOWNTO 7);
	reqd_ct_ch1_int	             <= pma_ctrl3_ch1_reg(6 DOWNTO 4);
	req_ctv_ch1_int	             <= pma_ctrl3_ch1_reg(3 DOWNTO 1);

-- Outputs from PMA Per channel control register 3 for channel2 (4.806Ah)
	reqa_ct_ch2_int	             <= pma_ctrl3_ch2_reg(15 DOWNTO 13);
	reqb_ct_ch2_int	             <= pma_ctrl3_ch2_reg(12 DOWNTO 10);
	reqc_ct_ch2_int	             <= pma_ctrl3_ch2_reg(9 DOWNTO 7);
	reqd_ct_ch2_int	             <= pma_ctrl3_ch2_reg(6 DOWNTO 4);
	req_ctv_ch2_int	             <= pma_ctrl3_ch2_reg(3 DOWNTO 1);

-- Outputs from PMA Per channel control register 3 for channel3 (4.806Bh)
	reqa_ct_ch3_int	             <= pma_ctrl3_ch3_reg(15 DOWNTO 13);
	reqb_ct_ch3_int	             <= pma_ctrl3_ch3_reg(12 DOWNTO 10);
	reqc_ct_ch3_int	             <= pma_ctrl3_ch3_reg(9 DOWNTO 7);
	reqd_ct_ch3_int	             <= pma_ctrl3_ch3_reg(6 DOWNTO 4);
	req_ctv_ch3_int	             <= pma_ctrl3_ch3_reg(3 DOWNTO 1);

-- Outputs from PMA Per channel control register 4 for channel0 (4.806Ch)
 rpmadwidth_tx_int(0)         <= pma_ctrl4_ch0_reg(15);
 rpma_doublewidth_tx_int(0)   <= pma_ctrl4_ch0_reg(14);
 rtx_cmu_sel_int(0)           <= pma_ctrl4_ch0_reg(13);
 rtx_m_sel_ch0_int            <= pma_ctrl4_ch0_reg(12 DOWNTO 11);
 rtxvcobypass_int(0)          <= pma_ctrl4_ch0_reg(10);
 rtx_cgb_1x_en_int(0)         <= pma_ctrl4_ch0_reg(9);
 rtx_cgb_4x_en_int(0)         <= pma_ctrl4_ch0_reg(8);
 rtx_4x_sw_int(0)             <= pma_ctrl4_ch0_reg(7);
 rpmadwidth_rx_int(0)         <= pma_ctrl4_ch0_reg(6);
 rpma_doublewidth_rx_int(0)   <= pma_ctrl4_ch0_reg(5);
 rrxvcobypass_int(0)          <= pma_ctrl4_ch0_reg(4);
 rrect_adj_ch0_int            <= pma_ctrl4_ch0_reg(3 DOWNTO 2);
 rrx_piso_bypass_ch0_int      <= pma_ctrl4_ch0_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 4 for channel1 (4.806Dh)
 rpmadwidth_tx_int(1)         <= pma_ctrl4_ch1_reg(15);
 rpma_doublewidth_tx_int(1)   <= pma_ctrl4_ch1_reg(14);
 rtx_cmu_sel_int(1)           <= pma_ctrl4_ch1_reg(13);
 rtx_m_sel_ch1_int            <= pma_ctrl4_ch1_reg(12 DOWNTO 11);
 rtxvcobypass_int(1)          <= pma_ctrl4_ch1_reg(10);
 rtx_cgb_1x_en_int(1)         <= pma_ctrl4_ch1_reg(9);
 rtx_cgb_4x_en_int(1)         <= pma_ctrl4_ch1_reg(8);
 rtx_4x_sw_int(1)             <= pma_ctrl4_ch1_reg(7);
 rpmadwidth_rx_int(1)         <= pma_ctrl4_ch1_reg(6);
 rpma_doublewidth_rx_int(1)   <= pma_ctrl4_ch1_reg(5);
 rrxvcobypass_int(1)          <= pma_ctrl4_ch1_reg(4);
 rrect_adj_ch1_int            <= pma_ctrl4_ch1_reg(3 DOWNTO 2);
 rrx_piso_bypass_ch1_int      <= pma_ctrl4_ch1_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 4 for channel2 (4.806Eh)
 rpmadwidth_tx_int(2)         <= pma_ctrl4_ch2_reg(15);
 rpma_doublewidth_tx_int(2)   <= pma_ctrl4_ch2_reg(14);
 rtx_cmu_sel_int(2)           <= pma_ctrl4_ch2_reg(13);
 rtx_m_sel_ch2_int            <= pma_ctrl4_ch2_reg(12 DOWNTO 11);
 rtxvcobypass_int(2)          <= pma_ctrl4_ch2_reg(10);
 rtx_cgb_1x_en_int(2)         <= pma_ctrl4_ch2_reg(9);
 rtx_cgb_4x_en_int(2)         <= pma_ctrl4_ch2_reg(8);
 rtx_4x_sw_int(2)             <= pma_ctrl4_ch2_reg(7);
 rpmadwidth_rx_int(2)         <= pma_ctrl4_ch2_reg(6);
 rpma_doublewidth_rx_int(2)   <= pma_ctrl4_ch2_reg(5);
 rrxvcobypass_int(2)          <= pma_ctrl4_ch2_reg(4);
 rrect_adj_ch2_int            <= pma_ctrl4_ch2_reg(3 DOWNTO 2);
 rrx_piso_bypass_ch2_int      <= pma_ctrl4_ch2_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 4 for channel3 (4.806Fh)
 rpmadwidth_tx_int(3)         <= pma_ctrl4_ch3_reg(15);
 rpma_doublewidth_tx_int(3)   <= pma_ctrl4_ch3_reg(14);
 rtx_cmu_sel_int(3)           <= pma_ctrl4_ch3_reg(13);
 rtx_m_sel_ch3_int            <= pma_ctrl4_ch3_reg(12 DOWNTO 11);
 rtxvcobypass_int(3)          <= pma_ctrl4_ch3_reg(10);
 rtx_cgb_1x_en_int(3)         <= pma_ctrl4_ch3_reg(9);
 rtx_cgb_4x_en_int(3)         <= pma_ctrl4_ch3_reg(8);
 rtx_4x_sw_int(3)             <= pma_ctrl4_ch3_reg(7);
 rpmadwidth_rx_int(3)         <= pma_ctrl4_ch3_reg(6);
 rpma_doublewidth_rx_int(3)   <= pma_ctrl4_ch3_reg(5);
 rrxvcobypass_int(3)          <= pma_ctrl4_ch3_reg(4);
 rrect_adj_ch3_int            <= pma_ctrl4_ch3_reg(3 DOWNTO 2);
 rrx_piso_bypass_ch3_int      <= pma_ctrl4_ch3_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 5 for channel0 (4.8070h)
	rlst_tx_ch0_int              <= pma_ctrl5_ch0_reg(15 DOWNTO 12);
	rlst_rx_ch0_int              <= pma_ctrl5_ch0_reg(11 DOWNTO 8);
	rlst_rxpll_ch0_int           <= pma_ctrl5_ch0_reg(7 DOWNTO 4);
	rrx_ignore_phslck_int(0)     <= pma_ctrl5_ch0_reg(3);
	rdc_freq_ch0_int             <= pma_ctrl5_ch0_reg(2 DOWNTO 1);
	rrx_osc_en_int(0)            <= pma_ctrl5_ch0_reg(0);

-- Outputs from PMA Per channel control register 5 for channel1 (4.8071h)
	rlst_tx_ch1_int              <= pma_ctrl5_ch1_reg(15 DOWNTO 12);
	rlst_rx_ch1_int              <= pma_ctrl5_ch1_reg(11 DOWNTO 8);
	rlst_rxpll_ch1_int           <= pma_ctrl5_ch1_reg(7 DOWNTO 4);
	rrx_ignore_phslck_int(1)     <= pma_ctrl5_ch1_reg(3);
	rdc_freq_ch1_int             <= pma_ctrl5_ch1_reg(2 DOWNTO 1);
	rrx_osc_en_int(1)            <= pma_ctrl5_ch1_reg(0);

-- Outputs from PMA Per channel control register 5 for channel2 (4.8072h)
	rlst_tx_ch2_int              <= pma_ctrl5_ch2_reg(15 DOWNTO 12);
	rlst_rx_ch2_int              <= pma_ctrl5_ch2_reg(11 DOWNTO 8);
	rlst_rxpll_ch2_int           <= pma_ctrl5_ch2_reg(7 DOWNTO 4);
	rrx_ignore_phslck_int(2)     <= pma_ctrl5_ch2_reg(3);
	rdc_freq_ch2_int             <= pma_ctrl5_ch2_reg(2 DOWNTO 1);
	rrx_osc_en_int(2)            <= pma_ctrl5_ch2_reg(0);

-- Outputs from PMA Per channel control register 5 for channel3 (4.8073h)
	rlst_tx_ch3_int              <= pma_ctrl5_ch3_reg(15 DOWNTO 12);
	rlst_rx_ch3_int              <= pma_ctrl5_ch3_reg(11 DOWNTO 8);
	rlst_rxpll_ch3_int           <= pma_ctrl5_ch3_reg(7 DOWNTO 4);
	rrx_ignore_phslck_int(3)     <= pma_ctrl5_ch3_reg(3);
	rdc_freq_ch3_int             <= pma_ctrl5_ch3_reg(2 DOWNTO 1);
	rrx_osc_en_int(3)            <= pma_ctrl5_ch3_reg(0);

-- Outputs from PMA Per channel control register 6 for channel0 (4.8074h)
	rrefclk_sel_ch0_int          <= pma_ctrl6_ch0_reg(15 DOWNTO 13);
	rbwctral_rx_ch0_int          <= pma_ctrl6_ch0_reg(12 DOWNTO 11);
	rrx_cru_m_sel_ch0_int        <= pma_ctrl6_ch0_reg(10 DOWNTO 9);
	rrx_cru_div2_int(0)          <= pma_ctrl6_ch0_reg(8);
	rrx_cru_ctl_ch0_int          <= pma_ctrl6_ch0_reg(7 DOWNTO 2);
	rltr_int(0)		             <= pma_ctrl6_ch0_reg(1);
	rltd_int(0)		             <= pma_ctrl6_ch0_reg(0);

-- Outputs from PMA Per channel control register 6 for channel1 (4.8075h)
	rrefclk_sel_ch1_int          <= pma_ctrl6_ch1_reg(15 DOWNTO 13);
	rbwctral_rx_ch1_int          <= pma_ctrl6_ch1_reg(12 DOWNTO 11);
	rrx_cru_m_sel_ch1_int        <= pma_ctrl6_ch1_reg(10 DOWNTO 9);
	rrx_cru_div2_int(1)          <= pma_ctrl6_ch1_reg(8);
	rrx_cru_ctl_ch1_int          <= pma_ctrl6_ch1_reg(7 DOWNTO 2);
	rltr_int(1)		             <= pma_ctrl6_ch1_reg(1);
	rltd_int(1)		             <= pma_ctrl6_ch1_reg(0);

-- Outputs from PMA Per channel control register 6 for channel2 (4.8076h)
	rrefclk_sel_ch2_int          <= pma_ctrl6_ch2_reg(15 DOWNTO 13);
	rbwctral_rx_ch2_int          <= pma_ctrl6_ch2_reg(12 DOWNTO 11);
	rrx_cru_m_sel_ch2_int        <= pma_ctrl6_ch2_reg(10 DOWNTO 9);
	rrx_cru_div2_int(2)          <= pma_ctrl6_ch2_reg(8);
	rrx_cru_ctl_ch2_int          <= pma_ctrl6_ch2_reg(7 DOWNTO 2);
	rltr_int(2)		             <= pma_ctrl6_ch2_reg(1);
	rltd_int(2)		             <= pma_ctrl6_ch2_reg(0);

-- Outputs from PMA Per channel control register 6 for channel3 (4.8077h)
	rrefclk_sel_ch3_int          <= pma_ctrl6_ch3_reg(15 DOWNTO 13);
	rbwctral_rx_ch3_int          <= pma_ctrl6_ch3_reg(12 DOWNTO 11);
	rrx_cru_m_sel_ch3_int        <= pma_ctrl6_ch3_reg(10 DOWNTO 9);
	rrx_cru_div2_int(3)          <= pma_ctrl6_ch3_reg(8);
	rrx_cru_ctl_ch3_int          <= pma_ctrl6_ch3_reg(7 DOWNTO 2);
	rltr_int(3)		             <= pma_ctrl6_ch3_reg(1);
	rltd_int(3)		             <= pma_ctrl6_ch3_reg(0);

-- Outputs from PMA Per channel control register 7 for channel0 (4.8078h)
	risel_rx_ch0_int             <= pma_ctrl7_ch0_reg(15 DOWNTO 14);
	riupsel_rx_ch0_int           <= pma_ctrl7_ch0_reg(13 DOWNTO 12);
	ridnsel_rx_ch0_int           <= pma_ctrl7_ch0_reg(11 DOWNTO 10);
	rtesten_cp_rx_int(0)         <= pma_ctrl7_ch0_reg(9);
	rtristate_cp_rx_int(0)       <= pma_ctrl7_ch0_reg(8);
	rtestupen_cp_rx_int(0)       <= pma_ctrl7_ch0_reg(7);
	rtestdnen_cp_rx_int(0)       <= pma_ctrl7_ch0_reg(6);
	rrx_cru_m_ch0_int            <= pma_ctrl7_ch0_reg(5 DOWNTO 2);
	rrx_cru_l_ch0_int            <= pma_ctrl7_ch0_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 7 for channel1 (4.8079h)
	risel_rx_ch1_int             <= pma_ctrl7_ch1_reg(15 DOWNTO 14);
	riupsel_rx_ch1_int           <= pma_ctrl7_ch1_reg(13 DOWNTO 12);
	ridnsel_rx_ch1_int           <= pma_ctrl7_ch1_reg(11 DOWNTO 10);
	rtesten_cp_rx_int(1)         <= pma_ctrl7_ch1_reg(9);
	rtristate_cp_rx_int(1)       <= pma_ctrl7_ch1_reg(8);
	rtestupen_cp_rx_int(1)       <= pma_ctrl7_ch1_reg(7);
	rtestdnen_cp_rx_int(1)       <= pma_ctrl7_ch1_reg(6);
	rrx_cru_m_ch1_int            <= pma_ctrl7_ch1_reg(5 DOWNTO 2);
	rrx_cru_l_ch1_int            <= pma_ctrl7_ch1_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 7 for channel2 (4.807Ah)
	risel_rx_ch2_int             <= pma_ctrl7_ch2_reg(15 DOWNTO 14);
	riupsel_rx_ch2_int           <= pma_ctrl7_ch2_reg(13 DOWNTO 12);
	ridnsel_rx_ch2_int           <= pma_ctrl7_ch2_reg(11 DOWNTO 10);
	rtesten_cp_rx_int(2)         <= pma_ctrl7_ch2_reg(9);
	rtristate_cp_rx_int(2)       <= pma_ctrl7_ch2_reg(8);
	rtestupen_cp_rx_int(2)       <= pma_ctrl7_ch2_reg(7);
	rtestdnen_cp_rx_int(2)       <= pma_ctrl7_ch2_reg(6);
	rrx_cru_m_ch2_int            <= pma_ctrl7_ch2_reg(5 DOWNTO 2);
	rrx_cru_l_ch2_int            <= pma_ctrl7_ch2_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 7 for channel3 (4.807Bh)
	risel_rx_ch3_int             <= pma_ctrl7_ch3_reg(15 DOWNTO 14);
	riupsel_rx_ch3_int           <= pma_ctrl7_ch3_reg(13 DOWNTO 12);
	ridnsel_rx_ch3_int           <= pma_ctrl7_ch3_reg(11 DOWNTO 10);
	rtesten_cp_rx_int(3)         <= pma_ctrl7_ch3_reg(9);
	rtristate_cp_rx_int(3)       <= pma_ctrl7_ch3_reg(8);
	rtestupen_cp_rx_int(3)       <= pma_ctrl7_ch3_reg(7);
	rtestdnen_cp_rx_int(3)       <= pma_ctrl7_ch3_reg(6);
	rrx_cru_m_ch3_int            <= pma_ctrl7_ch3_reg(5 DOWNTO 2);
	rrx_cru_l_ch3_int            <= pma_ctrl7_ch3_reg(1 DOWNTO 0);

-- Outputs from PMA Per channel control register 8 for channel0 (4.807Ch)
	rs_lpbk_int(0)        	     <= pma_ctrl8_ch0_reg(15);
	r_rlpbk_int(0)        	     <= pma_ctrl8_ch0_reg(14);
	rs_rdlpbk_int(0)             <= pma_ctrl8_ch0_reg(13);
	rrx_revlb_sw_int(0)          <= pma_ctrl8_ch0_reg(12);
	rurx_pdb_int(0)        	     <= pma_ctrl8_ch0_reg(11);
	rtx_cgb_pdb_int(0)           <= pma_ctrl8_ch0_reg(10);
	rtx_ob_pdb_int(0)            <= pma_ctrl8_ch0_reg(9);
	rrx_cru_pdb_int(0)           <= pma_ctrl8_ch0_reg(8);
	rrx_cru_rst_int(0)           <= pma_ctrl8_ch0_reg(7);
	rrx_ib_pdb_int(0)            <= pma_ctrl8_ch0_reg(6);
	rrxurstpma_md(0)             <= pma_ctrl8_ch0_reg(5);
	radce_adapt_int(0)           <= pma_ctrl8_ch0_reg(4);
	radce_pdb_int(0)             <= pma_ctrl8_ch0_reg(3);
	radce_rst_int(0)             <= pma_ctrl8_ch0_reg(2);
	rsig_inv_2tap_int(0)         <= pma_ctrl8_ch0_reg(1);
	rsig_inv_pre_int(0)          <= pma_ctrl8_ch0_reg(0);

-- Outputs from PMA Per channel control register 8 for channel1 (4.807Dh)
	rs_lpbk_int(1)        	     <= pma_ctrl8_ch1_reg(15);
	r_rlpbk_int(1)        	     <= pma_ctrl8_ch1_reg(14);
	rs_rdlpbk_int(1)             <= pma_ctrl8_ch1_reg(13);
	rrx_revlb_sw_int(1)          <= pma_ctrl8_ch1_reg(12);
	rurx_pdb_int(1)        	     <= pma_ctrl8_ch1_reg(11);
	rtx_cgb_pdb_int(1)           <= pma_ctrl8_ch1_reg(10);
	rtx_ob_pdb_int(1)            <= pma_ctrl8_ch1_reg(9);
	rrx_cru_pdb_int(1)           <= pma_ctrl8_ch1_reg(8);
	rrx_cru_rst_int(1)           <= pma_ctrl8_ch1_reg(7);
	rrx_ib_pdb_int(1)            <= pma_ctrl8_ch1_reg(6);
	rrxurstpma_md(1)             <= pma_ctrl8_ch1_reg(5);
	radce_adapt_int(1)           <= pma_ctrl8_ch1_reg(4);
	radce_pdb_int(1)             <= pma_ctrl8_ch1_reg(3);
	radce_rst_int(1)             <= pma_ctrl8_ch1_reg(2);
	rsig_inv_2tap_int(1)         <= pma_ctrl8_ch1_reg(1);
	rsig_inv_pre_int(1)          <= pma_ctrl8_ch1_reg(0);

-- Outputs from PMA Per channel control register 8 for channel2 (4.807Eh)
	rs_lpbk_int(2)        	     <= pma_ctrl8_ch2_reg(15);
	r_rlpbk_int(2)        	     <= pma_ctrl8_ch2_reg(14);
	rs_rdlpbk_int(2)             <= pma_ctrl8_ch2_reg(13);
	rrx_revlb_sw_int(2)          <= pma_ctrl8_ch2_reg(12);
	rurx_pdb_int(2)        	     <= pma_ctrl8_ch2_reg(11);
	rtx_cgb_pdb_int(2)           <= pma_ctrl8_ch2_reg(10);
	rtx_ob_pdb_int(2)            <= pma_ctrl8_ch2_reg(9);
	rrx_cru_pdb_int(2)           <= pma_ctrl8_ch2_reg(8);
	rrx_cru_rst_int(2)           <= pma_ctrl8_ch2_reg(7);
	rrx_ib_pdb_int(2)            <= pma_ctrl8_ch2_reg(6);
	rrxurstpma_md(2)             <= pma_ctrl8_ch2_reg(5);
	radce_adapt_int(2)           <= pma_ctrl8_ch2_reg(4);
	radce_pdb_int(2)             <= pma_ctrl8_ch2_reg(3);
	radce_rst_int(2)             <= pma_ctrl8_ch2_reg(2);
	rsig_inv_2tap_int(2)         <= pma_ctrl8_ch2_reg(1);
	rsig_inv_pre_int(2)          <= pma_ctrl8_ch2_reg(0);

-- Outputs from PMA Per channel control register 8 for channel3 (4.807Fh)
	rs_lpbk_int(3)        	     <= pma_ctrl8_ch3_reg(15);
	r_rlpbk_int(3)        	     <= pma_ctrl8_ch3_reg(14);
	rs_rdlpbk_int(3)             <= pma_ctrl8_ch3_reg(13);
	rrx_revlb_sw_int(3)          <= pma_ctrl8_ch3_reg(12);
	rurx_pdb_int(3)        	     <= pma_ctrl8_ch3_reg(11);
	rtx_cgb_pdb_int(3)           <= pma_ctrl8_ch3_reg(10);
	rtx_ob_pdb_int(3)            <= pma_ctrl8_ch3_reg(9);
	rrx_cru_pdb_int(3)           <= pma_ctrl8_ch3_reg(8);
	rrx_cru_rst_int(3)           <= pma_ctrl8_ch3_reg(7);
	rrx_ib_pdb_int(3)            <= pma_ctrl8_ch3_reg(6);
	rrxurstpma_md(3)             <= pma_ctrl8_ch3_reg(5);
	radce_adapt_int(3)           <= pma_ctrl8_ch3_reg(4);
	radce_pdb_int(3)             <= pma_ctrl8_ch3_reg(3);
	radce_rst_int(3)             <= pma_ctrl8_ch3_reg(2);
	rsig_inv_2tap_int(3)         <= pma_ctrl8_ch3_reg(1);
	rsig_inv_pre_int(3)          <= pma_ctrl8_ch3_reg(0);

-- Outputs from PMA Per channel control register 9 for channel0 (4.8080h)
	rseq_sel_ch0_int	     <= pma_ctrl9_ch0_reg(15 DOWNTO 14);
	rrgen_set_ch0_int	     <= pma_ctrl9_ch0_reg(13 DOWNTO 11);
	rclkdiv_ch0_int 	     <= pma_ctrl9_ch0_reg(10 DOWNTO 7);
	rf_lpf_ch0_int  	     <= pma_ctrl9_ch0_reg(6 DOWNTO 5);
	rf_hpf_ch0_int  	     <= pma_ctrl9_ch0_reg(4 DOWNTO 3);
	rrgen_bw_ch0_int  	     <= pma_ctrl9_ch0_reg(2 DOWNTO 1);

-- Outputs from PMA Per channel control register 9 for channel1 (4.8081h)
	rseq_sel_ch1_int	     <= pma_ctrl9_ch1_reg(15 DOWNTO 14);
	rrgen_set_ch1_int	     <= pma_ctrl9_ch1_reg(13 DOWNTO 11);
	rclkdiv_ch1_int 	     <= pma_ctrl9_ch1_reg(10 DOWNTO 7);
	rf_lpf_ch1_int  	     <= pma_ctrl9_ch1_reg(6 DOWNTO 5);
	rf_hpf_ch1_int  	     <= pma_ctrl9_ch1_reg(4 DOWNTO 3);
	rrgen_bw_ch1_int  	     <= pma_ctrl9_ch1_reg(2 DOWNTO 1);

-- Outputs from PMA Per channel control register 9 for channel2 (4.8082h)
	rseq_sel_ch2_int	     <= pma_ctrl9_ch2_reg(15 DOWNTO 14);
	rrgen_set_ch2_int	     <= pma_ctrl9_ch2_reg(13 DOWNTO 11);
	rclkdiv_ch2_int 	     <= pma_ctrl9_ch2_reg(10 DOWNTO 7);
	rf_lpf_ch2_int  	     <= pma_ctrl9_ch2_reg(6 DOWNTO 5);
	rf_hpf_ch2_int  	     <= pma_ctrl9_ch2_reg(4 DOWNTO 3);
	rrgen_bw_ch2_int  	     <= pma_ctrl9_ch2_reg(2 DOWNTO 1);

-- Outputs from PMA Per channel control register 9 for channel3 (4.8083h)
	rseq_sel_ch3_int	     <= pma_ctrl9_ch3_reg(15 DOWNTO 14);
	rrgen_set_ch3_int	     <= pma_ctrl9_ch3_reg(13 DOWNTO 11);
	rclkdiv_ch3_int 	     <= pma_ctrl9_ch3_reg(10 DOWNTO 7);
	rf_lpf_ch3_int  	     <= pma_ctrl9_ch3_reg(6 DOWNTO 5);
	rf_hpf_ch3_int  	     <= pma_ctrl9_ch3_reg(4 DOWNTO 3);
	rrgen_bw_ch3_int  	     <= pma_ctrl9_ch3_reg(2 DOWNTO 1);

-- Outputs from PMA Per channel control register 10 for channel0 (4.8084h)
	rhyst_ch0_int	         <= pma_ctrl10_ch0_reg(15 DOWNTO 13);
	rd2a_res_ch0_int	     <= pma_ctrl10_ch0_reg(12 DOWNTO 11);
	rrgen_vod_ch0_int	     <= pma_ctrl10_ch0_reg(10 DOWNTO 8);
	rlf_os_ch0_int	         <= pma_ctrl10_ch0_reg(7 DOWNTO 4);
	rhf_os_ch0_int	         <= pma_ctrl10_ch0_reg(3 DOWNTO 0);

-- Outputs from PMA Per channel control register 10 for channel1 (4.8085h)
	rhyst_ch1_int	         <= pma_ctrl10_ch1_reg(15 DOWNTO 13);
	rd2a_res_ch1_int	     <= pma_ctrl10_ch1_reg(12 DOWNTO 11);
	rrgen_vod_ch1_int	     <= pma_ctrl10_ch1_reg(10 DOWNTO 8);
	rlf_os_ch1_int	         <= pma_ctrl10_ch1_reg(7 DOWNTO 4);
	rhf_os_ch1_int	         <= pma_ctrl10_ch1_reg(3 DOWNTO 0);

-- Outputs from PMA Per channel control register 10 for channel2 (4.8086h)
	rhyst_ch2_int	         <= pma_ctrl10_ch2_reg(15 DOWNTO 13);
	rd2a_res_ch2_int	     <= pma_ctrl10_ch2_reg(12 DOWNTO 11);
	rrgen_vod_ch2_int	     <= pma_ctrl10_ch2_reg(10 DOWNTO 8);
	rlf_os_ch2_int	         <= pma_ctrl10_ch2_reg(7 DOWNTO 4);
	rhf_os_ch2_int	         <= pma_ctrl10_ch2_reg(3 DOWNTO 0);

-- Outputs from PMA Per channel control register 10 for channel3 (4.8087h)
	rhyst_ch3_int	         <= pma_ctrl10_ch3_reg(15 DOWNTO 13);
	rd2a_res_ch3_int	     <= pma_ctrl10_ch3_reg(12 DOWNTO 11);
	rrgen_vod_ch3_int	     <= pma_ctrl10_ch3_reg(10 DOWNTO 8);
	rlf_os_ch3_int	         <= pma_ctrl10_ch3_reg(7 DOWNTO 4);
	rhf_os_ch3_int	         <= pma_ctrl10_ch3_reg(3 DOWNTO 0);

-- Outputs from PMA Per channel control register 11 for channel0 (4.8088h)
	r_iqclk_ch0_int    	     <= pma_ctrl11_ch0_reg(15 DOWNTO 12);
	r_dfe_ch0_int     	     <= pma_ctrl11_ch0_reg(11 DOWNTO 6);
	r_cp_mode_int(0)    	 <= pma_ctrl11_ch0_reg(5);
	rreg_cp_rx_int(0)    	 <= pma_ctrl11_ch0_reg(4);
	r_impctrl_ch0_int    	 <= pma_ctrl11_ch0_reg(3 DOWNTO 2);
	rpd_ien_int(0)    	     <= pma_ctrl11_ch0_reg(1);

-- Outputs from PMA Per channel control register 11 for channel1 (4.8089h)
	r_iqclk_ch1_int    	     <= pma_ctrl11_ch1_reg(15 DOWNTO 12);
	r_dfe_ch1_int     	     <= pma_ctrl11_ch1_reg(11 DOWNTO 6);
	r_cp_mode_int(1)    	 <= pma_ctrl11_ch1_reg(5);
	rreg_cp_rx_int(1)    	 <= pma_ctrl11_ch1_reg(4);
	r_impctrl_ch1_int    	 <= pma_ctrl11_ch1_reg(3 DOWNTO 2);
	rpd_ien_int(1)    	     <= pma_ctrl11_ch1_reg(1);

-- Outputs from PMA Per channel control register 11 for channel2 (4.808Ah)
	r_iqclk_ch2_int    	     <= pma_ctrl11_ch2_reg(15 DOWNTO 12);
	r_dfe_ch2_int     	     <= pma_ctrl11_ch2_reg(11 DOWNTO 6);
	r_cp_mode_int(2)    	 <= pma_ctrl11_ch2_reg(5);
	rreg_cp_rx_int(2)    	 <= pma_ctrl11_ch2_reg(4);
	r_impctrl_ch2_int    	 <= pma_ctrl11_ch2_reg(3 DOWNTO 2);
	rpd_ien_int(2)    	     <= pma_ctrl11_ch2_reg(1);

-- Outputs from PMA Per channel control register 11 for channel3 (4.808Bh)
	r_iqclk_ch3_int    	     <= pma_ctrl11_ch3_reg(15 DOWNTO 12);
	r_dfe_ch3_int     	     <= pma_ctrl11_ch3_reg(11 DOWNTO 6);
	r_cp_mode_int(3)    	 <= pma_ctrl11_ch3_reg(5);
	rreg_cp_rx_int(3)    	 <= pma_ctrl11_ch3_reg(4);
	r_impctrl_ch3_int    	 <= pma_ctrl11_ch3_reg(3 DOWNTO 2);
	rpd_ien_int(3)    	     <= pma_ctrl11_ch3_reg(1);


-- Outputs from PMA Global control register 0 (4.8090h)
	rbgbypass_int	          <= pma_global_ctrl0_reg(15);
	rlst_bg_int	              <= pma_global_ctrl0_reg(13 DOWNTO 10);
	rcmu_rst_int	          <= pma_global_ctrl0_reg(9);
    rcmu2_isel_int            <= pma_global_ctrl0_reg(5 DOWNTO 4); 
	rcmu0_isel_int	          <= pma_global_ctrl0_reg(3 DOWNTO 2);
	rcmu1_isel_int	          <= pma_global_ctrl0_reg(1 DOWNTO 0);

-- Outputs from PMA Global control register 1 (4.8091h)
	rcmu0_iupsel_int        <= pma_global_ctrl1_reg(15 DOWNTO 14);
	rcmu1_iupsel_int        <= pma_global_ctrl1_reg(13 DOWNTO 12);
	rcmu2_iupsel_int        <= pma_global_ctrl1_reg(11 DOWNTO 10);
	rcmu0_idnsel_int        <= pma_global_ctrl1_reg(9 DOWNTO 8);
	rcmu1_idnsel_int        <= pma_global_ctrl1_reg(7 DOWNTO 6);
	rcmu2_idnsel_int        <= pma_global_ctrl1_reg(5 DOWNTO 4);
	rcmu0_testen_cp_int     <= pma_global_ctrl1_reg(3);
	rcmu1_testen_cp_int     <= pma_global_ctrl1_reg(2);
	rcmu0_tristate_cp_int   <= pma_global_ctrl1_reg(1);
	rcmu1_tristate_cp_int   <= pma_global_ctrl1_reg(0);

-- Outputs from PMA Global control register 2 (4.8092h)
	rcmu0_lst_int		<= pma_global_ctrl2_reg(13 DOWNTO 10);
	rcmu1_lst_int		<= pma_global_ctrl2_reg(9 DOWNTO 6);
	rcmu0_div2_int		<= pma_global_ctrl2_reg(5);
	rcmu1_div2_int		<= pma_global_ctrl2_reg(4);
	rcmu0_ref_sel_int	<= pma_global_ctrl2_reg(3 DOWNTO 2);
	rcmu1_ref_sel_int	<= pma_global_ctrl2_reg(1 DOWNTO 0);

-- Outputs from PMA Global control register 3 (4.8093h)
	rcmu0_ctl_int	        <= pma_global_ctrl3_reg(15 DOWNTO 8);
	rcmu1_ctl_int	        <= pma_global_ctrl3_reg(7 DOWNTO 0);

-- Outputs from PMA Global control register 4 (4.8094h)
	rcmu0_m_int		<= pma_global_ctrl4_reg(15 DOWNTO 12);
	rcmu1_m_int		<= pma_global_ctrl4_reg(11 DOWNTO 8);
	rcmu0_l_int		<= pma_global_ctrl4_reg(7 DOWNTO 6);
	rcmu1_l_int		<= pma_global_ctrl4_reg(5 DOWNTO 4);
	rcmu0_pdb_int		<= pma_global_ctrl4_reg(3);
	rcmu1_pdb_int		<= pma_global_ctrl4_reg(2);
	rcmu0_txpll_rst_int	<= pma_global_ctrl4_reg(1);
	rcmu1_txpll_rst_int	<= pma_global_ctrl4_reg(0);

-- Outputs from PMA Global control register 5 (4.8095h)
 rpma_testbus_sel_int    <= pma_global_ctrl5_reg(15 DOWNTO 12);
	rcmu_peclrx0_cm_int	<= pma_global_ctrl5_reg(11 DOWNTO 8);
	rcmu_peclrx1_cm_int	<= pma_global_ctrl5_reg(7 DOWNTO 4);
	rcmu0_testupen_cp_int	<= pma_global_ctrl5_reg(3);
	rcmu1_testupen_cp_int	<= pma_global_ctrl5_reg(2);
	rcmu0_testdnen_cp_int	<= pma_global_ctrl5_reg(1);
	rcmu1_testdnen_cp_int	<= pma_global_ctrl5_reg(0);

-- Outputs from PMA Global control register 6 (4.8096h)
	rcmu_peclrx0_lst_int	    <= pma_global_ctrl6_reg(15 DOWNTO 12);
	rcmu_peclrx1_lst_int	    <= pma_global_ctrl6_reg(11 DOWNTO 8);
    rcmu_iqclkout_sel_int       <= pma_global_ctrl6_reg(6);
    rcmu_txpll0_iqclkin_sel_int <= pma_global_ctrl6_reg(5 DOWNTO 3);
    rcmu_txpll1_iqclkin_sel_int <= pma_global_ctrl6_reg(2 DOWNTO 0);

-- Outputs from PMA Global control register 7 (4.8097h)
    rcmu_cgb_cmusel_int     <= pma_global_ctrl7_reg(15 DOWNTO 14);
    rcmu_cgb_ndiv_int       <= pma_global_ctrl7_reg(13 DOWNTO 12);
    rcmu_cgb_div5_int       <= pma_global_ctrl7_reg(11);
    rcmu_cgb_div2_int       <= pma_global_ctrl7_reg(10);
    rcmu_cgb_vcobypass_int  <= pma_global_ctrl7_reg(9);
	rcmu_txpll0_1x_en_int	<= pma_global_ctrl7_reg(8);
	rcmu_txpll1_1x_en_int	<= pma_global_ctrl7_reg(7);
    rcmu_cgb_4x_en_int      <= pma_global_ctrl7_reg(6);
    rcmu_cgb_8x_en_int      <= pma_global_ctrl7_reg(5);
    rcmu_cgb_pclksel_int    <= pma_global_ctrl7_reg(4);

-- Outputs from PMA Global control register 8 (4.8098h)
 rcmu2_testen_cp_int     <= pma_global_ctrl8_reg(15);
 rcmu2_tristate_cp_int   <= pma_global_ctrl8_reg(14);
 rcmu2_testupen_cp_int   <= pma_global_ctrl8_reg(13);
 rcmu2_testdnen_cp_int   <= pma_global_ctrl8_reg(12);
 rcmu2_lst_int           <= pma_global_ctrl8_reg(11 DOWNTO 8);
 rcmu2_ctl_int           <= pma_global_ctrl8_reg(7 DOWNTO 0);

-- Outputs from PMA Global control register 9 (4.8099h)
 rcmu2_refsel_int        <= pma_global_ctrl9_reg(15);
 rcmu2_m_int             <= pma_global_ctrl9_reg(14 DOWNTO 11);
 rcmu2_l_int             <= pma_global_ctrl9_reg(10 DOWNTO 9);
 rcmu2_pdb_int           <= pma_global_ctrl9_reg(8);
 rcmu2_txpll_rst_int     <= pma_global_ctrl9_reg(7);
 rcmu0_rcp_mode_int      <= pma_global_ctrl9_reg(6);
 rcmu1_rcp_mode_int      <= pma_global_ctrl9_reg(5);

--Control and Status Registers instantiation

-- Status Register
local_fault_0  : bsc_out PORT MAP (reset => mdio_rst,
                        clk => mdc,
                        sig_in => local_fault,
                        jtag_mode => jtag_mode,
                        si => chain(126),
                        shift_load => jtag_shift_load,
                        sig_out => local_fault_ext,
                        so => chain(127));

xs_link_status_0 : bsc_out PORT MAP (reset => mdio_rst,
                        clk => mdc,
                        sig_in => xs_link_status,
                        jtag_mode => jtag_mode,
                        si => chain(125),
                        shift_load => jtag_shift_load,
                        sig_out => xs_link_status_ext,
                        so => chain(126));

rx_local_fault_0 : bsc_out PORT MAP (reset => mdio_rst,
                        clk => mdc,
                        sig_in => rx_local_fault,
                        jtag_mode => jtag_mode,
                        si => chain(124),
                        shift_load => jtag_shift_load,
                        sig_out => rx_local_fault_ext,
                        so => chain(125));

tx_local_fault_0 : bsc_out PORT MAP (reset => mdio_rst,
                        clk => mdc,
                        sig_in => tx_local_fault,
                        jtag_mode => jtag_mode,
                        si => chain(123),
                        shift_load => jtag_shift_load,
                        sig_out => tx_local_fault_ext,
                        so => chain(124));

-- Single control bits
xs_link_status_set : bsc_in_r PORT MAP (reset => mdio_rst, 
                             clk => mdc, 
                             sig_in => xs_link_status_rd, 
                             ext_in => rxs_link_status_set, 
                             jtag_mode => jtag_mode, 
                             si => chain(122), 
                             shift => jtag_shift_load, 
                             mdio_dis => mdio_dis,
                             sig_out => rxs_link_status_set_int, 
                             so => chain(123));

tx_rx_local_fault_clr : bsc_in_r PORT MAP (reset => mdio_rst, 
                                clk => mdc, 
                                sig_in => tx_rx_local_fault_status_rd, 
                                ext_in => rtx_rx_local_fault_clr, 
                                jtag_mode => jtag_mode, 
                                si => '0', 
                                shift => jtag_shift_load, 
                                mdio_dis => mdio_dis,
                                sig_out => rtx_rx_local_fault_clr_int, 
                                so => chain(122));
                        

-- Main control registers instantiation
xgxs_ctrl_0    : ctrl_reg PORT MAP (reset => mdio_rst,
                         mdio_wr => mdio_wr,
                         reg_addr => reg_addr,
                         target_addr => XGXS_CTRL,
                         clk => mdc,
                         sig_in => mbus_in,
                         ext_in => xgxs_ctrl_ext,
                         jtag_mode => jtag_mode,
                         si => chain(121),
                         shift => jtag_shift_load,
                         mdio_dis => mdio_dis,
                         sig_out => xgxs_ctrl_reg,
                         so => jtag_so);

trunking_mode_0 : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => TRUNKING_MODE,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => trunking_mode_ext,
                        jtag_mode => jtag_mode,
                        si => chain(120),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => trunking_mode_reg,
                        so => chain(121));

pcs_ctrl1_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL1_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl1_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(119),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl1_ch0_reg,
                        so => chain(120));

pcs_ctrl1_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL1_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl1_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(118),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl1_ch1_reg,
                        so => chain(119));

pcs_ctrl1_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL1_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl1_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(117),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl1_ch2_reg,
                        so => chain(118));

pcs_ctrl1_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL1_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl1_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(116),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl1_ch3_reg,
                        so => chain(117));

pcs_ctrl2_0    : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL2_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl2_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(115),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl2_ch0_reg,
                        so => chain(116));

pcs_ctrl2_1    : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL2_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl2_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(114),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl2_ch1_reg,
                        so => chain(115));

pcs_ctrl2_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL2_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl2_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(113),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl2_ch2_reg,
                        so => chain(114));

pcs_ctrl2_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL2_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl2_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(112),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl2_ch3_reg,
                        so => chain(113));

pcs_ctrl3_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL3_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl3_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(111),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl3_ch0_reg,
                        so => chain(112));

pcs_ctrl3_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL3_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl3_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(110),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl3_ch1_reg,
                        so => chain(111));

pcs_ctrl3_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL3_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl3_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(109),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl3_ch2_reg,
                        so => chain(110));

pcs_ctrl3_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL3_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl3_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(108),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl3_ch3_reg,
                        so => chain(109));

pcs_ctrl4_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL4_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl4_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(107),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl4_ch0_reg,
                        so => chain(108));

pcs_ctrl4_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL4_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl4_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(106),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl4_ch1_reg,
                        so => chain(107));

pcs_ctrl4_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL4_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl4_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(105),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl4_ch2_reg,
                        so => chain(106));

pcs_ctrl4_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL4_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl4_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(104),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl4_ch3_reg,
                        so => chain(105));

pcs_ctrl5_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL5_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl5_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(103),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl5_ch0_reg,
                        so => chain(104));

pcs_ctrl5_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL5_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl5_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(102),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl5_ch1_reg,
                        so => chain(103));

pcs_ctrl5_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL5_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl5_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(101),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl5_ch2_reg,
                        so => chain(102));

pcs_ctrl5_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL5_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl5_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(100),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl5_ch3_reg,
                        so => chain(101));

pcs_ctrl6_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL6_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl6_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(99),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl6_ch0_reg,
                        so => chain(100));

pcs_ctrl6_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL6_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl6_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(98),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl6_ch1_reg,
                        so => chain(99));

pcs_ctrl6_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL6_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl6_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(97),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl6_ch2_reg,
                        so => chain(98));

pcs_ctrl6_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL6_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl6_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(96),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl6_ch3_reg,
                        so => chain(97));
                        
pcs_ctrl7_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL7_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl7_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(95),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl7_ch0_reg,
                        so => chain(96));

pcs_ctrl7_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL7_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl7_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(94),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl7_ch1_reg,
                        so => chain(95));

pcs_ctrl7_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL7_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl7_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(93),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl7_ch2_reg,
                        so => chain(94));

pcs_ctrl7_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL7_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl7_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(92),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl7_ch3_reg,
                        so => chain(93));

pcs_ctrl8_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL8_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl8_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(91),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl8_ch0_reg,
                        so => chain(92));

pcs_ctrl8_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL8_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl8_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(90),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl8_ch1_reg,
                        so => chain(91));

pcs_ctrl8_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL8_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl8_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(89),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl8_ch2_reg,
                        so => chain(90));

pcs_ctrl8_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL8_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl8_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(88),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl8_ch3_reg,
                        so => chain(89));

bist_prbs_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PRBS_BIST_CTRL_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => prbs_bist_ctrl_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(87),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => prbs_bist_ctrl_ch0_reg,
                        so => chain(88));

bist_prbs_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PRBS_BIST_CTRL_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => prbs_bist_ctrl_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(86),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => prbs_bist_ctrl_ch1_reg,
                        so => chain(87));

bist_prbs_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PRBS_BIST_CTRL_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => prbs_bist_ctrl_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(85),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => prbs_bist_ctrl_ch2_reg,
                        so => chain(86));

bist_prbs_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PRBS_BIST_CTRL_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => prbs_bist_ctrl_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(84),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => prbs_bist_ctrl_ch3_reg,
                        so => chain(85));


pcs_ctrl9_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL9_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl9_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(83),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl9_ch0_reg,
                        so => chain(84));

pcs_ctrl9_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL9_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl9_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(82),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl9_ch1_reg,
                        so => chain(83));

pcs_ctrl9_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL9_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl9_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(81),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl9_ch2_reg,
                        so => chain(82));

pcs_ctrl9_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL9_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl9_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(80),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl9_ch3_reg,
                        so => chain(81));                        

pcs_ctrl10_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL10_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl10_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(79),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl10_ch0_reg,
                        so => chain(80));

pcs_ctrl10_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL10_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl10_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(78),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl10_ch1_reg,
                        so => chain(79));

pcs_ctrl10_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL10_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl10_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(77),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl10_ch2_reg,
                        so => chain(78));

pcs_ctrl10_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL10_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl10_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(76),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl10_ch3_reg,
                        so => chain(77));

pcs_ctrl11_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL11_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl11_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(75),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl11_ch0_reg,
                        so => chain(76));

pcs_ctrl11_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL11_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl11_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(74),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl11_ch1_reg,
                        so => chain(75));

pcs_ctrl11_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL11_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl11_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(73),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl11_ch2_reg,
                        so => chain(74));

pcs_ctrl11_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL11_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl11_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(72),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl11_ch3_reg,
                        so => chain(73));

pcs_ctrl12_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL12_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl12_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(71),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl12_ch0_reg,
                        so => chain(72));

pcs_ctrl12_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL12_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl12_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(70),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl12_ch1_reg,
                        so => chain(71));

pcs_ctrl12_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL12_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl12_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(69),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl12_ch2_reg,
                        so => chain(70));

pcs_ctrl12_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL12_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl12_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(68),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl12_ch3_reg,
                        so => chain(69));

pcs_ctrl13_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL13_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl13_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(67),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl13_ch0_reg,
                        so => chain(68));

pcs_ctrl13_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL13_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl13_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(66),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl13_ch1_reg,
                        so => chain(67));

pcs_ctrl13_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL13_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl13_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(65),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl13_ch2_reg,
                        so => chain(66));

pcs_ctrl13_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL13_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl13_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(64),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl13_ch3_reg,
                        so => chain(65));
                        
pcs_ctrl14_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL14_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl14_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(63),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl14_ch0_reg,
                        so => chain(64));

pcs_ctrl14_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL14_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl14_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(62),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl14_ch1_reg,
                        so => chain(63));

pcs_ctrl14_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL14_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl14_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(61),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl14_ch2_reg,
                        so => chain(62));

pcs_ctrl14_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL14_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl14_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(60),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl14_ch3_reg,
                        so => chain(61));                        

pcs_ctrl15_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL15_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl15_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(59),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl15_ch0_reg,
                        so => chain(60));

pcs_ctrl15_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL15_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl15_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(58),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl15_ch1_reg,
                        so => chain(59));

pcs_ctrl15_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL15_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl15_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(57),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl15_ch2_reg,
                        so => chain(58));

pcs_ctrl15_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PCS_CTRL15_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pcs_ctrl15_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(56),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pcs_ctrl15_ch3_reg,
                        so => chain(57));
                        
mpcs_global_ctrl0   : ctrl_reg PORT MAP (reset => mdio_rst,
                             mdio_wr => mdio_wr,
                             reg_addr => reg_addr,
                             target_addr => PCS_GLOBAL_CTRL0,
                             clk => mdc,
                             sig_in => mbus_in,
                             ext_in => pcs_global_ctrl0_ext,
                             jtag_mode => jtag_mode,
                             si => chain(55),
                             shift => jtag_shift_load,
                             mdio_dis => mdio_dis,
                             sig_out => pcs_global_ctrl0_reg,
                             so => chain(56));
                        
mpcs_global_ctrl1   : ctrl_reg PORT MAP (reset => mdio_rst,
                             mdio_wr => mdio_wr,
                             reg_addr => reg_addr,
                             target_addr => PCS_GLOBAL_CTRL1,
                             clk => mdc,
                             sig_in => mbus_in,
                             ext_in => pcs_global_ctrl1_ext,
                             jtag_mode => jtag_mode,
                             si => chain(54),
                             shift => jtag_shift_load,
                             mdio_dis => mdio_dis,
                             sig_out => pcs_global_ctrl1_reg,
                             so => chain(55));

mpcs_global_ctrl2   : ctrl_reg PORT MAP (reset => mdio_rst,
                             mdio_wr => mdio_wr,
                             reg_addr => reg_addr,
                             target_addr => PCS_GLOBAL_CTRL2,
                             clk => mdc,
                             sig_in => mbus_in,
                             ext_in => pcs_global_ctrl2_ext,
                             jtag_mode => jtag_mode,
                             si => chain(53),
                             shift => jtag_shift_load,
                             mdio_dis => mdio_dis,
                             sig_out => pcs_global_ctrl2_reg,
                             so => chain(54));

mpma_ctrl1_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL1_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl1_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(52),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl1_ch0_reg,
                        so => chain(53));

pma_ctrl1_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL1_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl1_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(51),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl1_ch1_reg,
                        so => chain(52));

pma_ctrl1_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL1_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl1_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(50),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl1_ch2_reg,
                        so => chain(51));

pma_ctrl1_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL1_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl1_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(49),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl1_ch3_reg,
                        so => chain(50));

pma_ctrl2_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL2_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl2_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(48),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl2_ch0_reg,
                        so => chain(49));

pma_ctrl2_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL2_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl2_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(47),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl2_ch1_reg,
                        so => chain(48));

pma_ctrl2_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL2_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl2_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(46),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl2_ch2_reg,
                        so => chain(47));

pma_ctrl2_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL2_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl2_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(45),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl2_ch3_reg,
                        so => chain(46));

pma_ctrl3_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL3_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl3_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(44),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl3_ch0_reg,
                        so => chain(45));

pma_ctrl3_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL3_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl3_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(43),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl3_ch1_reg,
                        so => chain(44));

pma_ctrl3_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL3_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl3_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(42),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl3_ch2_reg,
                        so => chain(43));

pma_ctrl3_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL3_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl3_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(41),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl3_ch3_reg,
                        so => chain(42));

pma_ctrl4_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL4_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl4_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(40),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl4_ch0_reg,
                        so => chain(41));

pma_ctrl4_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL4_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl4_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(39),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl4_ch1_reg,
                        so => chain(40));

pma_ctrl4_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL4_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl4_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(38),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl4_ch2_reg,
                        so => chain(39));

pma_ctrl4_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL4_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl4_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(37),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl4_ch3_reg,
                        so => chain(38));

pma_ctrl5_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL5_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl5_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(36),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl5_ch0_reg,
                        so => chain(37));

pma_ctrl5_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL5_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl5_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(35),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl5_ch1_reg,
                        so => chain(36));

pma_ctrl5_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL5_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl5_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(34),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl5_ch2_reg,
                        so => chain(35));

pma_ctrl5_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL5_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl5_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(33),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl5_ch3_reg,
                        so => chain(34));

pma_ctrl6_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL6_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl6_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(32),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl6_ch0_reg,
                        so => chain(33));

pma_ctrl6_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL6_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl6_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(31),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl6_ch1_reg,
                        so => chain(32));

pma_ctrl6_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL6_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl6_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(30),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl6_ch2_reg,
                        so => chain(31));

pma_ctrl6_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL6_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl6_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(29),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl6_ch3_reg,
                        so => chain(30));

pma_ctrl7_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL7_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl7_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(28),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl7_ch0_reg,
                        so => chain(29));

pma_ctrl7_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL7_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl7_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(27),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl7_ch1_reg,
                        so => chain(28));

pma_ctrl7_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL7_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl7_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(26),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl7_ch2_reg,
                        so => chain(27));

pma_ctrl7_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL7_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl7_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(25),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl7_ch3_reg,
                        so => chain(26));

pma_ctrl8_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL8_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl8_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(24),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl8_ch0_reg,
                        so => chain(25));

pma_ctrl8_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL8_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl8_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(23),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl8_ch1_reg,
                        so => chain(24));
                        
pma_ctrl8_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL8_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl8_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(22),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl8_ch2_reg,
                        so => chain(23));
                        
pma_ctrl8_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL8_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl8_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(21),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl8_ch3_reg,
                        so => chain(22));

pma_ctrl9_0   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL9_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl9_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(20),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl9_ch0_reg,
                        so => chain(21));

pma_ctrl9_1   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL9_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl9_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(19),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl9_ch1_reg,
                        so => chain(20));

pma_ctrl9_2   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL9_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl9_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(18),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl9_ch2_reg,
                        so => chain(19));

pma_ctrl9_3   : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL9_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl9_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(17),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl9_ch3_reg,
                        so => chain(18));

pma_ctrl10_0  : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL10_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl10_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(16),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl10_ch0_reg,
                        so => chain(17));

pma_ctrl10_1  : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL10_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl10_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(15),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl10_ch1_reg,
                        so => chain(16));

pma_ctrl10_2  : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL10_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl10_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(14),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl10_ch2_reg,
                        so => chain(15));

pma_ctrl10_3  : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL10_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl10_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(13),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl10_ch3_reg,
                        so => chain(14));

pma_ctrl11_0  : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL11_CH0,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl11_ch0_ext,
                        jtag_mode => jtag_mode,
                        si => chain(12),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl11_ch0_reg,
                        so => chain(13));

pma_ctrl11_1  : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL11_CH1,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl11_ch1_ext,
                        jtag_mode => jtag_mode,
                        si => chain(11),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl11_ch1_reg,
                        so => chain(12));

pma_ctrl11_2  : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL11_CH2,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl11_ch2_ext,
                        jtag_mode => jtag_mode,
                        si => chain(10),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl11_ch2_reg,
                        so => chain(11));
                        
pma_ctrl11_3  : ctrl_reg PORT MAP (reset => mdio_rst,
                        mdio_wr => mdio_wr,
                        reg_addr => reg_addr,
                        target_addr => PMA_CTRL11_CH3,
                        clk => mdc,
                        sig_in => mbus_in,
                        ext_in => pma_ctrl11_ch3_ext,
                        jtag_mode => jtag_mode,
                        si => chain(9),
                        shift => jtag_shift_load,
                        mdio_dis => mdio_dis,
                        sig_out => pma_ctrl11_ch3_reg,
                        so => chain(10));                        

mpma_global_ctrl0 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL0,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl0_ext,
                          jtag_mode => jtag_mode,
                          si => chain(8),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl0_reg,
                          so => chain(9));
                        
mpma_global_ctrl1 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL1,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl1_ext,
                          jtag_mode => jtag_mode,
                          si => chain(7),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl1_reg,
                          so => chain(8));

mpma_global_ctrl2 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL2,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl2_ext,
                          jtag_mode => jtag_mode,
                          si => chain(6),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl2_reg,
                          so => chain(7));
                        
mpma_global_ctrl3 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL3,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl3_ext,
                          jtag_mode => jtag_mode,
                          si => chain(5),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl3_reg,
                          so => chain(6));

mpma_global_ctrl4 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL4,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl4_ext,
                          jtag_mode => jtag_mode,
                          si => chain(4),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl4_reg,
                          so => chain(5));

mpma_global_ctrl5 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL5,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl5_ext,
                          jtag_mode => jtag_mode,
                          si => chain(3),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl5_reg,
                          so => chain(4));
                        
mpma_global_ctrl6 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL6,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl6_ext,
                          jtag_mode => jtag_mode,
                          si => chain(2),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl6_reg,
                          so => chain(3));
                        
mpma_global_ctrl7 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL7,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl7_ext,
                          jtag_mode => jtag_mode,
                          si => chain(1),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl7_reg,
                          so => chain(2));

mpma_global_ctrl8 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL8,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl8_ext,
                          jtag_mode => jtag_mode,
                          si => chain(0),
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl8_reg,
                          so => chain(1));

mpma_global_ctrl9 : ctrl_reg PORT MAP (reset => mdio_rst,
                          mdio_wr => mdio_wr,
                          reg_addr => reg_addr,
                          target_addr => PMA_GLOBAL_CTRL9,
                          clk => mdc,
                          sig_in => mbus_in,
                          ext_in => pma_global_ctrl9_ext,
                          jtag_mode => jtag_mode,
                          si => jtag_si,
                          shift => jtag_shift_load,
                          mdio_dis => mdio_dis,
                          sig_out => pma_global_ctrl9_reg,
                          so => chain(0));

END dprio_reg_arch;


LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.mdio_addr;
USE WORK.mdio_cnt;
USE WORK.mdio_sm;
USE WORK.mdio_ctl_data;
USE WORK.stratixiigx_hssi_cmu_dprio_reg;


ENTITY stratixiigx_hssi_cmu_dprio_top IS
  GENERIC (
       rx0_phy : INTEGER := 0;
       rx1_phy : INTEGER := 1;
       rx2_phy : INTEGER := 2;
       rx3_phy : INTEGER := 3;
       tx0_phy : INTEGER := 0;
       tx1_phy : INTEGER := 1;
       tx2_phy : INTEGER := 2;
       tx3_phy : INTEGER := 3
  );
    PORT (
        sync_status             : IN std_logic_vector(3 DOWNTO 0);   
        align_status            : IN std_logic;   
        mdio_in                 : IN std_logic;   
        mdc                     : IN std_logic;   
        port_addr               : IN std_logic_vector(4 DOWNTO 0);   
        dev_addr                : IN std_logic_vector(4 DOWNTO 0);   
        mdio_dis                : IN std_logic;   
        dprioload               : IN std_logic;   
        mdio_rst                : IN std_logic;   
        cmudividerdprioin       : IN std_logic_vector(29 DOWNTO 0);   
        cmuplldprioin           : IN std_logic_vector(119 DOWNTO 0);   
        cmudprioin              : IN std_logic_vector(29 DOWNTO 0);   
        refclkdividerdprioin    : IN std_logic_vector(1 DOWNTO 0);   
        rxdprioin               : IN std_logic_vector(799 DOWNTO 0);   
        txdprioin               : IN std_logic_vector(399 DOWNTO 0);   

        cmudividerdprioout      : OUT std_logic_vector(29 DOWNTO 0);   
        cmuplldprioout          : OUT std_logic_vector(119 DOWNTO 0);   
        cmudprioout             : OUT std_logic_vector(29 DOWNTO 0);   
        refclkdividerdprioout   : OUT std_logic_vector(1 DOWNTO 0);   
        rxdprioout              : OUT std_logic_vector(799 DOWNTO 0);   
        txdprioout              : OUT std_logic_vector(399 DOWNTO 0);   
        mdio_out                : OUT std_logic;   
        data_enable_n           : OUT std_logic;   
        mdio_curr_st            : OUT std_logic_vector(2 DOWNTO 0));   
END stratixiigx_hssi_cmu_dprio_top;

ARCHITECTURE cmu_dprio_top_arc OF stratixiigx_hssi_cmu_dprio_top IS

-- COMPONENTS begin  ---------------------------------------------------
 COMPONENT  mdio_addr
	 PORT 
	 ( 
		 incr_addr	:	IN  STD_LOGIC;
		 mdc	    :	IN  STD_LOGIC;
		 mdio_in	:	IN  STD_LOGIC;
		 reg_addr	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 reset	    :	IN  STD_LOGIC;
		 shift_addr	:	IN  STD_LOGIC
	 ); 
 END COMPONENT;

  COMPONENT  mdio_cnt 
	 PORT 
	 ( 
		 cnt_eq_0	:	OUT  STD_LOGIC;
		 cnt_val	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 ld_cnt	    :	IN  STD_LOGIC;
		 mdc	    :	IN  STD_LOGIC;
		 reset	    :	IN  STD_LOGIC
	 ); 
 END COMPONENT;

 COMPONENT mdio_sm
    PORT (
        mdc                     : IN std_logic;   --  Clock for MDIO interface
        mdio_in                 : IN std_logic;   --  Signal bit data
        reset                   : IN std_logic;   --  Active high Hard Reset
        opcode                  : IN std_logic_vector(1 DOWNTO 0);   --  2 bit opcode from mdio_ctl_data module

        valid_addr              : IN std_logic;   --  When set the Port and Dev Address
                                                  -- corresponds to this module

        cnt_eq_0                : IN std_logic;   --  From mdio_cnt module, down counter is 0
        shift_in                : OUT std_logic;   --  Shift in enable for either data or control
        shift_out               : OUT std_logic;   --  Shift out enable for mdio_ctl_data
        latch_ctl               : OUT std_logic;   --  Latch the Opcode, to mdio_ctl_data
        incr_addr               : OUT std_logic;   --  Increment signal for mdio_addr
        mdio_wr                 : OUT std_logic;   --  This is used for writing the mdio registers
        mdio_rd                 : OUT std_logic;   --  This is used for clearing the mdio status registers
        shift_addr              : OUT std_logic;   --  Shift in Enable for mdio_addr
        ld_data                 : OUT std_logic;   --  When set, the shift register is mdio_ctl_data is parallely
                                                   -- loaded with the data from mdio_reg module

        ld_cnt                  : OUT std_logic;   --  Load Down counter
        cnt_val                 : OUT std_logic_vector(4 DOWNTO 0);   --  Value to load the down counter
        valid_addr_lt           : OUT std_logic;   
        curr_state              : OUT std_logic_vector(2 DOWNTO 0));   
 END COMPONENT;

 COMPONENT  mdio_ctl_data 
	 PORT 
	 ( 
		 data_enable_n	:	OUT  STD_LOGIC;
		 dev_addr	    :	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 latch_ctl	    :	IN  STD_LOGIC;
		 ld_data	    :	IN  STD_LOGIC;
		 mbus_in	    :	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mbus_out	    :	IN  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 mdc	        :	IN  STD_LOGIC;
		 mdio_in	    :	IN  STD_LOGIC;
		 mdio_out	    :	OUT  STD_LOGIC;
		 opcode	        :	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 port_addr	    :	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 reset	        :	IN  STD_LOGIC;
		 shift_in	    :	IN  STD_LOGIC;
		 shift_out	    :	IN  STD_LOGIC;
		 valid_addr	    :	OUT  STD_LOGIC;
		 valid_addr_lt	:	IN  STD_LOGIC
	 ); 
 END COMPONENT;

 COMPONENT stratixiigx_hssi_cmu_dprio_reg
  GENERIC (
    rx0_phy : INTEGER := 0;
    rx1_phy : INTEGER := 1;
    rx2_phy : INTEGER := 2;
    rx3_phy : INTEGER := 3;
    tx0_phy : INTEGER := 0;
    tx1_phy : INTEGER := 1;
    tx2_phy : INTEGER := 2;
    tx3_phy : INTEGER := 3
  );
  PORT (
    mdc          : IN std_logic := '0';       
    mdio_rst     : IN std_logic := '0';
    mdio_dis     : IN std_logic := '1';
    dprioload    : IN std_logic := '0';
    align_status : IN std_logic := '0';
    sync_status  : IN std_logic_vector (3 DOWNTO 0) := (OTHERS => '0');
    reg_addr     : IN std_logic_vector (15 DOWNTO 0) := (OTHERS => '0');
    mdio_wr      : IN std_logic := '0';      
    mdio_rd      : IN std_logic := '0';
    dev_addr_0   : IN std_logic := '0';
    mbus_in      : IN std_logic_vector (15 DOWNTO 0) := (OTHERS => '0');
                        
    cmudividerdprioin : IN std_logic_vector (29 DOWNTO 0)   := (OTHERS => '0');
    cmuplldprioin     : IN std_logic_vector (119 DOWNTO 0)  := (OTHERS => '0');
    cmudprioin        : IN std_logic_vector (29 DOWNTO 0)   := (OTHERS => '0');
    refclkdividerdprioin : IN std_logic_vector (1 DOWNTO 0) := (OTHERS => '0');
    rxdprioin         : IN std_logic_vector (799 DOWNTO 0)  := (OTHERS => '0');
    txdprioin         : IN std_logic_vector (399 DOWNTO 0)  := (OTHERS => '0');
           
    cmudividerdprioout : OUT std_logic_vector (29 DOWNTO 0);
    cmuplldprioout     : OUT std_logic_vector (119 DOWNTO 0);
    cmudprioout        : OUT std_logic_vector (29 DOWNTO 0);
    refclkdividerdprioout : OUT std_logic_vector (1 DOWNTO 0);
    rxdprioout         : OUT std_logic_vector (799 DOWNTO 0);
    txdprioout         : OUT std_logic_vector (399 DOWNTO 0);
            		            
    mbus_out           : OUT std_logic_vector (15 DOWNTO 0));
 END COMPONENT;

-- COMPONENTS end  ---------------------------------------------------

-- unused ports to be moved into reg
SIGNAL          jtag_mode       : STD_LOGIC;
SIGNAL          jtag_shift_load : STD_LOGIC;
SIGNAL          jtag_si         : STD_LOGIC;
SIGNAL          jtag_so         : STD_LOGIC;   -- wire

-- status signals generated by PCS
SIGNAL          tx_local_fault : STD_LOGIC;        -- from tx_sm
SIGNAL          rx_local_fault : STD_LOGIC;        -- from rcv_sm
SIGNAL          xs_link_status : STD_LOGIC;        -- from rcv_sm

SIGNAL         local_fault_ext    : STD_LOGIC;       -- Status signal wire
SIGNAL         xs_link_status_ext : STD_LOGIC;    -- Status signal wire
SIGNAL         rx_local_fault_ext : STD_LOGIC;    -- Status signal wire
SIGNAL         tx_local_fault_ext : STD_LOGIC;    -- Status signal wire

-- interconnect wires --------------------------------------------------

-- wires from addr
SIGNAL        reg_addr : STD_LOGIC_VECTOR(15 DOWNTO 0);    -- addr --> reg

-- wires from sm
SIGNAL         shift_addr : STD_LOGIC;          -- sm --> addr
SIGNAL         incr_addr : STD_LOGIC;           -- sm --> addr

SIGNAL         ld_cnt  : STD_LOGIC;              -- sm --> cnt
SIGNAL         cnt_val : STD_LOGIC_VECTOR(4 DOWNTO 0);  -- sm --> cnt
SIGNAL         ld_data : STD_LOGIC;             -- sm --> cnt

SIGNAL         shift_in      : STD_LOGIC;             -- sm --> ctl_data
SIGNAL         shift_out     : STD_LOGIC;            -- sm --> ctl_data
SIGNAL         latch_ctl     : STD_LOGIC;            -- sm --> ctl_data
SIGNAL         valid_addr_lt : STD_LOGIC;        -- sm --> ctl_data

SIGNAL         mdio_wr : STD_LOGIC;              -- sm --> reg         
SIGNAL         mdio_rd : STD_LOGIC;              -- sm --> reg         

SIGNAL         curr_state : STD_LOGIC_VECTOR(2 DOWNTO 0); -- sm --> top (../../pcs_central_testbus in central_chnnl)

-- wires from cnt
SIGNAL         cnt_eq_0 : STD_LOGIC;            -- cnt --> sm

-- wires from ctl_data
SIGNAL         mbus_in    : STD_LOGIC_VECTOR(15 DOWNTO 0);   -- ctl_data --> reg
SIGNAL         valid_addr : STD_LOGIC;          -- ctl_data --> sm
SIGNAL         opcode     : STD_LOGIC_VECTOR(1 DOWNTO 0);     -- ctl_data --> sm

--SIGNAL         mdio_out      : STD_LOGIC;       -- ctl_data --> top
--SIGNAL         data_enable_n : STD_LOGIC;       -- ctl_data --> top

-- wires from reg
SIGNAL         mbus_out : STD_LOGIC_VECTOR(15 DOWNTO 0);  -- reg --> ctl_data

--wires to reg
SIGNAL dev_addr_0 : STD_LOGIC;

BEGIN

-- outputs
mdio_curr_st <= curr_state;  -- from SM

-- module instantiatations ------------------------------------------------

mdio_addr_1 : mdio_addr
              PORT MAP (  
                        reset  => mdio_rst,               -- from top
                        mdc  => mdc,                      -- from top
                        mdio_in  => mdio_in,              -- from top
                        shift_addr  => shift_addr,        -- from sm
                        incr_addr  => incr_addr,          -- from sm
                        reg_addr  => reg_addr             -- To  => 16-bit reg addr) reg 
              );
                      
mdio_cnt_1 : mdio_cnt
              PORT MAP (  
                      reset  => mdio_rst,
                      mdc  => mdc,
                      ld_cnt  => ld_cnt,                  -- from sm
                      cnt_val  => cnt_val,                -- from sm
                      cnt_eq_0  => cnt_eq_0               -- to sm
              );


mdio_sm_1 : mdio_sm
              PORT MAP (  
                    reset  => mdio_rst,
                    mdio_in  => mdio_in,                 -- from top                 
                    mdc  => mdc,
                    opcode  => opcode,                   -- from ctl_data
                    valid_addr  => valid_addr,           -- from ctl_data
                    cnt_eq_0  => cnt_eq_0,               -- from cnt
                    shift_addr  => shift_addr,           -- to addr
                    incr_addr  => incr_addr,             -- to addr
                    mdio_wr  => mdio_wr,                 -- to reg
                    mdio_rd  => mdio_rd,                 -- to reg
                    shift_in  => shift_in,               -- to ctl_data
                    shift_out  => shift_out,             -- to ctl_data
                    latch_ctl  => latch_ctl,             -- to ctl_data
                    ld_data  => ld_data,                 -- to ctl_data
                    valid_addr_lt => valid_addr_lt,      -- to cnt_data
                    ld_cnt  => ld_cnt,                   -- to cnt
                    cnt_val  => cnt_val,                 -- to cnt  => 5-bit)
                    curr_state  => curr_state            -- to top
                  );

mdio_ctl_data_1 : mdio_ctl_data 
              PORT MAP (  
                    reset  => mdio_rst,
                    mdc  => mdc,
                    mdio_in  => mdio_in,
                    shift_in  => shift_in,        -- from sm
                    shift_out  => shift_out,      -- frm sm
                    ld_data  => ld_data,          -- from sm
                    latch_ctl  => latch_ctl,      -- from sm
                    port_addr  => port_addr,
                    dev_addr  => dev_addr,
                    valid_addr_lt => valid_addr_lt, -- from sm
                    mbus_out  => mbus_out,          -- from reg
                    mdio_out  => mdio_out,          -- to top
                    mbus_in  => mbus_in,            -- to reg 
                    opcode  => opcode,              -- to sm
                    valid_addr  => valid_addr,      -- to sm
                    data_enable_n  => data_enable_n -- to top
               );
                              
dev_addr_0 <= dev_addr(0);
                              
mdio_reg_1 : stratixiigx_hssi_cmu_dprio_reg 
              GENERIC MAP ( 
                    rx0_phy => rx0_phy,
                    rx1_phy => rx1_phy,
                    rx2_phy => rx2_phy,
                    rx3_phy => rx3_phy,

                    tx0_phy => tx0_phy,
                    tx1_phy => tx1_phy,
                    tx2_phy => tx2_phy,
                    tx3_phy => tx3_phy              
              )  
              PORT MAP( 
                    mdc => mdc,       -- from top        
                    mdio_rst => mdio_rst,                  -- from top
                    mdio_dis  => mdio_dis,                 -- from top
                    dprioload => dprioload,                -- from top     
                    align_status  => align_status,         -- from top   
                    sync_status  => sync_status,           -- from top
                    reg_addr => reg_addr,                  -- from addr
                    mdio_wr => mdio_wr,                    -- from sm        
                    mdio_rd => mdio_rd,                    -- from sm
                    dev_addr_0  => dev_addr_0,             -- from top
                    mbus_in => mbus_in,                    -- from ctrl_data
                        
                    cmudividerdprioin => cmudividerdprioin,  -- CRAM in from para
                    cmuplldprioin => cmuplldprioin,
                    cmudprioin => cmudprioin,
                    refclkdividerdprioin => refclkdividerdprioin,
                    rxdprioin => rxdprioin,
                    txdprioin => txdprioin,
                    cmudividerdprioout => cmudividerdprioout,-- CRAM out to channels
                    cmuplldprioout => cmuplldprioout,
                    cmudprioout => cmudprioout,
                    refclkdividerdprioout => refclkdividerdprioout,
                    rxdprioout => rxdprioout,
                    txdprioout => txdprioout,
 			            
 			        mbus_out => mbus_out                  -- to ctrl_data
 			  ); 
           
END cmu_dprio_top_arc;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

USE WORK.dskw_sm;
USE WORK.tx_sm;
USE WORK.rcv_sm;
USE WORK.stratixiigx_hssi_cmu_dprio_top;
USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;

ENTITY stratixiigx_hssi_central_management_unit IS
    GENERIC (
        in_xaui_mode          :  string := "false";    
        portaddr              :  integer := 1;        -- 1-based
        devaddr               :  integer := 1;        -- 1-based
        bonded_quad_mode      :  string := "none";    
        use_deskew_fifo       :  string := "false";    
        num_con_errors_for_align_loss  :  integer := 2;    
        num_con_good_data_for_align_approach: integer := 3;    
        num_con_align_chars_for_align  :  integer := 4;    
        offset_all_errors_align        :  string := "false";    
        lpm_type                       :  string := "stratixiigx_hssi_central_management_unit";
        rx0_cru_clock0_physical_mapping:  string := "cmu_div_clk";    
        rx0_cru_clock1_physical_mapping:  string := "cmu_div_clk";    
        rx0_cru_clock2_physical_mapping:  string := "cmu_div_clk";    
        rx0_cru_clock3_physical_mapping:  string := "cmu_div_clk";    
        rx0_cru_clock4_physical_mapping:  string := "cmu_div_clk";    
        rx0_cru_clock5_physical_mapping:  string := "cmu_div_clk";    
        rx0_cru_clock6_physical_mapping:  string := "cmu_div_clk";    
        rx0_cru_clock7_physical_mapping:  string := "cmu_div_clk";    
        rx0_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock0_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock1_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock2_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock3_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock4_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock5_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock6_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock7_physical_mapping:  string := "cmu_div_clk";    
        rx1_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock0_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock1_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock2_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock3_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock4_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock5_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock6_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock7_physical_mapping:  string := "cmu_div_clk";    
        rx2_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock0_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock1_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock2_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock3_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock4_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock5_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock6_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock7_physical_mapping:  string := "cmu_div_clk";    
        rx3_cru_clock8_physical_mapping:  string := "cmu_div_clk";    
        tx0_pll_fast_clk0_physical_mapping: string := "pll0";    
        tx0_pll_fast_clk1_physical_mapping: string := "pll0";    
        tx1_pll_fast_clk0_physical_mapping: string := "pll0";    
        tx1_pll_fast_clk1_physical_mapping: string := "pll0";    
        tx2_pll_fast_clk0_physical_mapping: string := "pll0";    
        tx2_pll_fast_clk1_physical_mapping: string := "pll0";    
        tx3_pll_fast_clk0_physical_mapping: string := "pll0";    
        tx3_pll_fast_clk1_physical_mapping: string := "pll0";    
        pll0_inclk0_logical_to_physical_mapping: string := "clkrefclk0";    
        pll0_inclk1_logical_to_physical_mapping: string := "clkrefclk0";    
        pll0_inclk2_logical_to_physical_mapping: string := "clkrefclk0";    
        pll0_inclk3_logical_to_physical_mapping: string := "clkrefclk0";    
        pll0_inclk4_logical_to_physical_mapping: string := "clkrefclk0";    
        pll0_inclk5_logical_to_physical_mapping: string := "clkrefclk0";    
        pll0_inclk6_logical_to_physical_mapping: string := "clkrefclk0";    
        pll0_inclk7_logical_to_physical_mapping: string := "clkrefclk0";    
        pll1_inclk0_logical_to_physical_mapping: string := "clkrefclk0";    
        pll1_inclk1_logical_to_physical_mapping: string := "clkrefclk0";    
        pll1_inclk2_logical_to_physical_mapping: string := "clkrefclk0";    
        pll1_inclk3_logical_to_physical_mapping: string := "clkrefclk0";    
        pll1_inclk4_logical_to_physical_mapping: string := "clkrefclk0";    
        pll1_inclk5_logical_to_physical_mapping: string := "clkrefclk0";    
        pll1_inclk6_logical_to_physical_mapping: string := "clkrefclk0";    
        pll1_inclk7_logical_to_physical_mapping: string := "clkrefclk0";    
        pll2_inclk0_logical_to_physical_mapping: string := "clkrefclk0";    
        pll2_inclk1_logical_to_physical_mapping: string := "clkrefclk0";    
        pll2_inclk2_logical_to_physical_mapping: string := "clkrefclk0";    
        pll2_inclk3_logical_to_physical_mapping: string := "clkrefclk0";    
        pll2_inclk4_logical_to_physical_mapping: string := "clkrefclk0";    
        pll2_inclk5_logical_to_physical_mapping: string := "clkrefclk0";    
        pll2_inclk6_logical_to_physical_mapping: string := "clkrefclk0";    
        pll2_inclk7_logical_to_physical_mapping: string := "clkrefclk0";    
        cmu_divider_inclk0_physical_mapping: string := "pll0";    
        cmu_divider_inclk1_physical_mapping: string := "pll1";    
        cmu_divider_inclk2_physical_mapping: string := "pll2";    
        rx0_logical_to_physical_mapping:  integer := 0;    
        rx1_logical_to_physical_mapping:  integer := 1;    
        rx2_logical_to_physical_mapping:  integer := 2;    
        rx3_logical_to_physical_mapping:  integer := 3;    
        tx0_logical_to_physical_mapping:  integer := 0;    
        tx1_logical_to_physical_mapping:  integer := 1;    
        tx2_logical_to_physical_mapping:  integer := 2;    
        tx3_logical_to_physical_mapping:  integer := 3;    
        pll0_logical_to_physical_mapping: integer := 0;    
        pll1_logical_to_physical_mapping: integer := 1;    
        pll2_logical_to_physical_mapping: integer := 2;    
        refclk_divider0_logical_to_physical_mapping: integer := 0;    
        refclk_divider1_logical_to_physical_mapping: integer := 1;    
        analog_test_bus_enable:  string := "false";    
        bypass_bandgap:  string := "true";    
        central_test_bus_select:  integer := 5;
        TimingChecksOn: Boolean := True;
        MsgOn: Boolean := DefGlitchMsgOn;
        XOn: Boolean := DefGlitchXOn;
        MsgOnChecks: Boolean := DefMsgOnChecks;
        XOnChecks: Boolean := DefXOnChecks;
        InstancePath: String  := "*";
		-- input port delay section
        tipd_dpclk: VitalDelayType01 := DefpropDelay01;
        tipd_dpriodisable: VitalDelayType01 := DefpropDelay01;
        tipd_dprioin: VitalDelayType01 := DefpropDelay01;
        tipd_dprioload: VitalDelayType01 := DefpropDelay01;
        tipd_fixedclk: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        tipd_quadenable: VitalDelayType01 := DefpropDelay01;
        tipd_quadreset: VitalDelayType01 := DefpropDelay01;
        tipd_rxanalogreset: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        tipd_rxclk: VitalDelayType01 := DefpropDelay01;
        tipd_rxdigitalreset: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        tipd_rxpowerdown: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        tipd_txclk: VitalDelayType01 := DefpropDelay01;
        tipd_txdigitalreset: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
        -- TSU/TH section
		tsetup_dprioin_dpclk_noedge_posedge: VitalDelayType := DefSetupHoldCnst;
        thold_dprioin_dpclk_noedge_posedge: VitalDelayType := DefSetupHoldCnst;
		-- TCO section
        tpd_dpclk_dprioout_posedge: VitalDelayType01 := DefPropDelay01;
        tpd_dpclk_dpriooe_posedge: VitalDelayType01 := DefPropDelay01
    );
    PORT (
        adet                    : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        cmudividerdprioin       : IN std_logic_vector(29 DOWNTO 0)  := (OTHERS => '0');   
        cmuplldprioin           : IN std_logic_vector(119 DOWNTO 0)  := (OTHERS => '0');   
        dpclk                   : IN std_logic := '0';   
        dpriodisable            : IN std_logic := '1';   
        dprioin                 : IN std_logic := '0';   
        dprioload               : IN std_logic := '0';   
        fixedclk                : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        quadenable              : IN std_logic := '1';   
        quadreset               : IN std_logic := '0';   
        rdalign                 : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rdenablesync            : IN std_logic := '1';   
        recovclk                : IN std_logic := '0';   
        refclkdividerdprioin    : IN std_logic_vector(1 DOWNTO 0)  := (OTHERS => '0');   
        rxanalogreset           : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxclk                   : IN std_logic := '0';   
        rxctrl                  : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxdatain                : IN std_logic_vector(31 DOWNTO 0)  := (OTHERS => '0');   
        rxdatavalid             : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxdigitalreset          : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxdprioin               : IN std_logic_vector(799 DOWNTO 0)  := (OTHERS => '0');   
        rxpowerdown             : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        rxrunningdisp           : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        syncstatus              : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        txclk                   : IN std_logic := '0';   
        txctrl                  : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        txdatain                : IN std_logic_vector(31 DOWNTO 0)  := (OTHERS => '0');   
        txdigitalreset          : IN std_logic_vector(3 DOWNTO 0)  := (OTHERS => '0');   
        txdprioin               : IN std_logic_vector(399 DOWNTO 0)  := (OTHERS => '0');   
        alignstatus             : OUT std_logic;   
        clkdivpowerdn           : OUT std_logic;   
        cmudividerdprioout      : OUT std_logic_vector(29 DOWNTO 0);   
        cmuplldprioout          : OUT std_logic_vector(119 DOWNTO 0);   
        dpriodisableout         : OUT std_logic;   
        dpriooe                 : OUT std_logic;   
        dprioout                : OUT std_logic;   
        enabledeskew            : OUT std_logic;   
        fiforesetrd             : OUT std_logic;   
        pllresetout             : OUT std_logic_vector(2 DOWNTO 0);   
        pllpowerdn              : OUT std_logic_vector(2 DOWNTO 0);   
        quadresetout            : OUT std_logic;   
        refclkdividerdprioout   : OUT std_logic_vector(1 DOWNTO 0);   
        rxadcepowerdn           : OUT std_logic_vector(3 DOWNTO 0);   
        rxadceresetout          : OUT std_logic_vector(3 DOWNTO 0);   
        rxanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
        rxcruresetout           : OUT std_logic_vector(3 DOWNTO 0);   
        rxcrupowerdn            : OUT std_logic_vector(3 DOWNTO 0);   
        rxctrlout               : OUT std_logic_vector(3 DOWNTO 0);   
        rxdataout               : OUT std_logic_vector(31 DOWNTO 0);   
        rxdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
        rxdprioout              : OUT std_logic_vector(799 DOWNTO 0);   
        rxibpowerdn             : OUT std_logic_vector(3 DOWNTO 0);   
        txctrlout               : OUT std_logic_vector(3 DOWNTO 0);   
        txdataout               : OUT std_logic_vector(31 DOWNTO 0);   
        txdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
        txanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
        txdetectrxpowerdn       : OUT std_logic_vector(3 DOWNTO 0);   
        txdividerpowerdn        : OUT std_logic_vector(3 DOWNTO 0);   
        txobpowerdn             : OUT std_logic_vector(3 DOWNTO 0);   
        txdprioout              : OUT std_logic_vector(399 DOWNTO 0);   
        digitaltestout          : OUT std_logic_vector(9 DOWNTO 0)
        );   
END stratixiigx_hssi_central_management_unit;

ARCHITECTURE vital_cmu_top_arch OF stratixiigx_hssi_central_management_unit IS

    COMPONENT  dskw_sm  
	PORT( 
        align_det_sync	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0) := (OTHERS => '0');
        clk_1	        :	IN  STD_LOGIC := '0';
        octal_mode	    :	IN  STD_LOGIC := '0';
        rd_align	    :	IN  STD_LOGIC_VECTOR (7 DOWNTO 0) := (OTHERS => '0');
        soft_reset	    :	IN  STD_LOGIC := '0';
        sync_status	    :	IN  STD_LOGIC_VECTOR (7 DOWNTO 0) := (OTHERS => '0');
        align_status	:	OUT  STD_LOGIC;
        curr_state	    :	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
        enable_deskew	:	OUT  STD_LOGIC;
        fifo_reset_rd	:	OUT  STD_LOGIC
	); 
    END COMPONENT;

    COMPONENT  rcv_sm  
    PORT ( 
        clk_2	            :	IN  STD_LOGIC := '0';
        dec_ctl	            :	IN  STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0');
        dec_data	        :	IN  STD_LOGIC_VECTOR (31 DOWNTO 0) := (OTHERS => '0');
        dec_data_valid	    :	IN  STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0');
        indv	            :	IN  STD_LOGIC := '0';
        running_disp	    :	IN  STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0');
        rx_local_fault_clr	:	IN  STD_LOGIC := '0';
        soft_reset	        :	IN  STD_LOGIC := '0';
        tx_local_fault_det	:	IN  STD_LOGIC := '0';
        xs_link_status_set	:	IN  STD_LOGIC := '0';
        curr_state	        :	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
        rx_ctl_rs	        :	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
        rx_data_rs	        :	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
        rx_local_fault	    :	OUT  STD_LOGIC;
        xs_link_status	    :	OUT  STD_LOGIC
	); 
    END COMPONENT;

    COMPONENT  tx_sm  
    PORT ( 
        indv	            :	IN  STD_LOGIC := '0';
        rd_enable_sync	    :	IN  STD_LOGIC := '0';
        soft_reset	        :	IN  STD_LOGIC := '0';
        tx_clk	            :	IN  STD_LOGIC := '0';
        tx_ctl	            :	IN  STD_LOGIC_VECTOR (3 DOWNTO 0) := (OTHERS => '0');
        tx_data	            :	IN  STD_LOGIC_VECTOR (31 DOWNTO 0) := (OTHERS => '0');
        tx_local_fault_clr	:	IN  STD_LOGIC := '0';
        curr_state	        :	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
        sm_ctl	            :	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
        sm_data	            :	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
        tx_local_fault	    :	OUT  STD_LOGIC;
		tx_local_fault_det	:	OUT  STD_LOGIC
    ); 
    END COMPONENT;

 COMPONENT stratixiigx_hssi_cmu_dprio_top 
    GENERIC (
       rx0_phy : INTEGER := 0;
       rx1_phy : INTEGER := 1;
       rx2_phy : INTEGER := 2;
       rx3_phy : INTEGER := 3;
       tx0_phy : INTEGER := 0;
       tx1_phy : INTEGER := 1;
       tx2_phy : INTEGER := 2;
       tx3_phy : INTEGER := 3
    );
    PORT (
        sync_status             : IN std_logic_vector(3 DOWNTO 0) := (OTHERS => '0');   
        align_status            : IN std_logic := '0';   
        mdio_in                 : IN std_logic := '0';   
        mdc                     : IN std_logic := '0';   
        port_addr               : IN std_logic_vector(4 DOWNTO 0) := (OTHERS => '0');   
        dev_addr                : IN std_logic_vector(4 DOWNTO 0) := (OTHERS => '0');   
        mdio_dis                : IN std_logic := '0';   
        dprioload               : IN std_logic := '0';   
        mdio_rst                : IN std_logic := '0';   
        cmudividerdprioin       : IN std_logic_vector(29 DOWNTO 0)  := (OTHERS => '0');   
        cmuplldprioin           : IN std_logic_vector(119 DOWNTO 0) := (OTHERS => '0');   
        cmudprioin              : IN std_logic_vector(29 DOWNTO 0)  := (OTHERS => '0');   
        refclkdividerdprioin    : IN std_logic_vector(1 DOWNTO 0)   := (OTHERS => '0');   
        rxdprioin               : IN std_logic_vector(799 DOWNTO 0) := (OTHERS => '0');   
        txdprioin               : IN std_logic_vector(399 DOWNTO 0) := (OTHERS => '0');   

        cmudividerdprioout      : OUT std_logic_vector(29 DOWNTO 0);   
        cmuplldprioout          : OUT std_logic_vector(119 DOWNTO 0);   
        cmudprioout             : OUT std_logic_vector(29 DOWNTO 0);   
        refclkdividerdprioout   : OUT std_logic_vector(1 DOWNTO 0);   
        rxdprioout              : OUT std_logic_vector(799 DOWNTO 0);   
        txdprioout              : OUT std_logic_vector(399 DOWNTO 0);   
        mdio_out                : OUT std_logic;   
        data_enable_n           : OUT std_logic;   
        mdio_curr_st            : OUT std_logic_vector(2 DOWNTO 0)
	);   
    END COMPONENT;
    
	SIGNAL my_gnd                   :  std_logic := '0';

    SIGNAL enpll                    :  std_logic;   
    SIGNAL pllurst                  :  std_logic;   
    SIGNAL rxurstpcs                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txurstpcs                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxurstpma                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL urx_pdb                  :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL hard_reset               :  std_logic;   
    SIGNAL rxpma_rstb               :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txpma_rstb               :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxpcs_rst                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txpcs_rst                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cru_rstb                 :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL adce_rstb                :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cmu_txpll_rstb           :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL tx_pdb                   :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rx_pdb                   :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cru_pdb                  :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL adce_pdb                 :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cgb_pdb                  :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL cmu_txpll_pdb            :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL rx_det_pdb               :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxpcsrst_hssi            :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txpcsrst_hssi            :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxpmarst_hssi            :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL pipe_rst_hssi            :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rx_pd_hssi               :  std_logic_vector(3 DOWNTO 0);   

    SIGNAL refclk_pma_out           :  std_logic;   
    SIGNAL mdc_b                    :  std_logic;   
    SIGNAL refclk_b                 :  std_logic;   
    SIGNAL clk_1_b                  :  std_logic;   
    SIGNAL clk_2_b                  :  std_logic;   
    SIGNAL rxrst_int                :  std_logic := '0';   
    SIGNAL txrst_int                :  std_logic := '0';   
    SIGNAL txrst_sync1              :  std_logic := '0';   
    SIGNAL txrst_sync2              :  std_logic := '0';   
    SIGNAL rxrst_sync1              :  std_logic := '0';   
    SIGNAL rxrst_sync2              :  std_logic := '0';   
    SIGNAL dskw_curr_st             :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL alignstatus_int          :  std_logic := '0';   
    SIGNAL align_det_sync_sig       :  std_logic_vector(7 DOWNTO 0) := (OTHERS => '0');   
    SIGNAL rd_align_sig             :  std_logic_vector(7 DOWNTO 0) := (OTHERS => '0');   
    SIGNAL sync_status_sig          :  std_logic_vector(7 DOWNTO 0) := (OTHERS => '0');   
    SIGNAL rtx_rx_local_fault_clr_int      :  std_logic;   
    SIGNAL rindv_tx_int             :  std_logic;   
    SIGNAL tx_curr_st               :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL tx_local_fault_det       :  std_logic;   
    SIGNAL tx_local_fault_int       :  std_logic;   
    SIGNAL rindv_rx_int             :  std_logic;   
    SIGNAL rxs_link_status_set_int  :  std_logic;   
    SIGNAL rx_local_fault_int       :  std_logic;   
    SIGNAL xlink_status_int         :  std_logic;   
    SIGNAL rcv_curr_st              :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL port_addr                :  std_logic_vector(4 DOWNTO 0);   
    SIGNAL dev_addr                 :  std_logic_vector(4 DOWNTO 0);   
    SIGNAL mdio_rst                 :  std_logic;
    SIGNAL mdio_rst_reg             :  std_logic := '1';      
    SIGNAL cmudprioin               :  std_logic_vector(29 DOWNTO 0);   
    SIGNAL cmudprioout              :  std_logic_vector(29 DOWNTO 0);   
    SIGNAL mdio_curr_st             :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL cmudividerdprioout_sig :  std_logic_vector(29 DOWNTO 0);   
    SIGNAL cmuplldprioout_sig     :  std_logic_vector(119 DOWNTO 0);   
    SIGNAL dpriooe_tim              :  std_logic;   
    SIGNAL dprioout_tim             :  std_logic;   
    SIGNAL enabledeskew_sig       :  std_logic;   
    SIGNAL fiforesetrd_sig        :  std_logic;   
    SIGNAL refclkdividerdprioout_xhdl13    :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL rxctrlout_xhdl19         :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL rxdataout_xhdl20         :  std_logic_vector(31 DOWNTO 0);   
    SIGNAL rxdprioout_xhdl22        :  std_logic_vector(799 DOWNTO 0);   
    SIGNAL txctrlout_xhdl25         :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txdataout_xhdl26         :  std_logic_vector(31 DOWNTO 0);   
    SIGNAL txdprioout_xhdl30        :  std_logic_vector(399 DOWNTO 0);   
    SIGNAL xs_link_status_int       :  std_logic;   

    -- Signals for input buffers
    SIGNAL dpclk_in : std_logic;
    SIGNAL dpriodisable_in : std_logic;
    SIGNAL dprioin_in : std_logic;
    SIGNAL dprioload_in : std_logic;
    SIGNAL fixedclk_in : std_logic_vector(3 DOWNTO 0);
    SIGNAL quadenable_in : std_logic;
    SIGNAL quadreset_in : std_logic;
    SIGNAL rxanalogreset_in : std_logic_vector(3 DOWNTO 0);
    SIGNAL rxclk_in : std_logic;
    SIGNAL rxdigitalreset_in : std_logic_vector(3 DOWNTO 0);
    SIGNAL rxpowerdown_in : std_logic_vector(3 DOWNTO 0);
    SIGNAL txclk_in : std_logic;
    SIGNAL txdigitalreset_in : std_logic_vector(3 DOWNTO 0);

    -- Signals for internal delays
    SIGNAL mdio_in : std_logic;
    
BEGIN

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
    WireDelay : block
    begin
        VitalWireDelay (dpclk_in, dpclk, tipd_dpclk);
        VitalWireDelay (dpriodisable_in, dpriodisable, tipd_dpriodisable);
        VitalWireDelay (dprioin_in, dprioin, tipd_dprioin);
        VitalWireDelay (dprioload_in, dprioload, tipd_dprioload);

        VitalWireDelay (fixedclk_in(0), fixedclk(0), tipd_fixedclk(0));
        VitalWireDelay (fixedclk_in(1), fixedclk(1), tipd_fixedclk(1));
        VitalWireDelay (fixedclk_in(2), fixedclk(2), tipd_fixedclk(2));
        VitalWireDelay (fixedclk_in(3), fixedclk(3), tipd_fixedclk(3));

        VitalWireDelay (quadenable_in, quadenable, tipd_quadenable);
        VitalWireDelay (quadreset_in, quadreset, tipd_quadreset);

        VitalWireDelay (rxanalogreset_in(0), rxanalogreset(0), tipd_rxanalogreset(0));
        VitalWireDelay (rxanalogreset_in(1), rxanalogreset(1), tipd_rxanalogreset(1));
        VitalWireDelay (rxanalogreset_in(2), rxanalogreset(2), tipd_rxanalogreset(2));
        VitalWireDelay (rxanalogreset_in(3), rxanalogreset(3), tipd_rxanalogreset(3));

        VitalWireDelay (rxclk_in, rxclk, tipd_rxclk);

        VitalWireDelay (rxdigitalreset_in(0), rxdigitalreset(0), tipd_rxdigitalreset(0));
        VitalWireDelay (rxdigitalreset_in(1), rxdigitalreset(1), tipd_rxdigitalreset(1));
        VitalWireDelay (rxdigitalreset_in(2), rxdigitalreset(2), tipd_rxdigitalreset(2));
        VitalWireDelay (rxdigitalreset_in(3), rxdigitalreset(3), tipd_rxdigitalreset(3));

        VitalWireDelay (rxpowerdown_in(0), rxpowerdown(0), tipd_rxpowerdown(0));
        VitalWireDelay (rxpowerdown_in(1), rxpowerdown(1), tipd_rxpowerdown(1));
        VitalWireDelay (rxpowerdown_in(2), rxpowerdown(2), tipd_rxpowerdown(2));
        VitalWireDelay (rxpowerdown_in(3), rxpowerdown(3), tipd_rxpowerdown(3));

        VitalWireDelay (txclk_in, txclk, tipd_txclk);

        VitalWireDelay (txdigitalreset_in(0), txdigitalreset(0), tipd_txdigitalreset(0));
        VitalWireDelay (txdigitalreset_in(1), txdigitalreset(1), tipd_txdigitalreset(1));
        VitalWireDelay (txdigitalreset_in(2), txdigitalreset(2), tipd_txdigitalreset(2));
        VitalWireDelay (txdigitalreset_in(3), txdigitalreset(3), tipd_txdigitalreset(3));

    end block;

    alignstatus <= alignstatus_int;
    clkdivpowerdn <= '0';
    cmudividerdprioout <= cmudividerdprioout_sig;
    cmuplldprioout <= cmuplldprioout_sig;
    dpriodisableout <= dpriodisable_in;
    dpriooe <= dpriooe_tim;
    dprioout <= dprioout_tim;
    enabledeskew <= enabledeskew_sig;
    fiforesetrd <= fiforesetrd_sig;
    pllpowerdn <= cmu_txpll_pdb;
    pllresetout <= NOT (cmu_txpll_rstb);
    quadresetout <= hard_reset;
    refclkdividerdprioout <= refclkdividerdprioout_xhdl13;
    rxadcepowerdn <= adce_pdb;
    rxadceresetout <= NOT (adce_rstb);
    rxanalogresetout <= NOT(rxpma_rstb);
    rxcrupowerdn <= cru_pdb;
    rxcruresetout <= NOT cru_rstb;
    rxctrlout <= rxctrlout_xhdl19;
    rxdataout <= rxdataout_xhdl20;
    rxdigitalresetout <= rxpcs_rst;
    rxdprioout <= rxdprioout_xhdl22;
    rxibpowerdn <= rx_pdb;
    txanalogresetout <= NOT txpma_rstb;
    txctrlout <= txctrlout_xhdl25;
    txdataout <= txdataout_xhdl26;
    txdetectrxpowerdn <= rx_det_pdb;
    txdigitalresetout <= txpcs_rst;
    txdividerpowerdn <= cgb_pdb;
    txdprioout <= txdprioout_xhdl30;
    txobpowerdn <= tx_pdb;
    digitaltestout <= "XXXXXXXXXX";

    enpll <= '0' WHEN (quadenable_in = '0') ELSE '1';
    pllurst <= '1' WHEN (quadreset_in = '1') ELSE '0';
    rxurstpcs <= rxdigitalreset_in;
    txurstpcs <= txdigitalreset_in;
    rxurstpma <= rxanalogreset_in;
    urx_pdb <= rxpowerdown_in;
    hard_reset <= '1' WHEN (enpll = '0' OR pllurst = '1') ELSE '0' ;
    rxpcsrst_hssi(0) <= '1' WHEN rxurstpcs(0) = '1' ELSE '0' ;
    rxpcsrst_hssi(1) <= '1' WHEN rxurstpcs(1) = '1' ELSE '0' ;
    rxpcsrst_hssi(2) <= '1' WHEN rxurstpcs(2) = '1' ELSE '0' ;
    rxpcsrst_hssi(3) <= '1' WHEN rxurstpcs(3) = '1' ELSE '0' ;
    txpcsrst_hssi(0) <= '1' WHEN txurstpcs(0) = '1' ELSE '0' ;
    txpcsrst_hssi(1) <= '1' WHEN txurstpcs(1) = '1' ELSE '0' ;
    txpcsrst_hssi(2) <= '1' WHEN txurstpcs(2) = '1' ELSE '0' ;
    txpcsrst_hssi(3) <= '1' WHEN txurstpcs(3) = '1' ELSE '0' ;
    rxpcs_rst <= rxpcsrst_hssi OR hard_reset & hard_reset & hard_reset & hard_reset ;
    txpcs_rst <= txpcsrst_hssi OR hard_reset & hard_reset & hard_reset & hard_reset ;
    rxpmarst_hssi(0) <= '1' WHEN rxurstpma(0) = '1' ELSE '0' ;
    rxpmarst_hssi(1) <= '1' WHEN rxurstpma(1) = '1' ELSE '0' ;
    rxpmarst_hssi(2) <= '1' WHEN rxurstpma(2) = '1' ELSE '0' ;
    rxpmarst_hssi(3) <= '1' WHEN rxurstpma(3) = '1' ELSE '0' ;
    rxpma_rstb <= NOT (rxpmarst_hssi OR hard_reset & hard_reset & hard_reset & hard_reset) ;
    txpma_rstb <= NOT (hard_reset & hard_reset & hard_reset & hard_reset) ;
    cru_rstb <= rxpma_rstb ;
    adce_rstb <= rxpma_rstb ;
    cmu_txpll_rstb <= NOT (hard_reset & hard_reset & hard_reset) ;
    rx_pd_hssi(0) <= '1' WHEN (urx_pdb(0) = '1') ELSE '0' ;
    rx_pd_hssi(1) <= '1' WHEN (urx_pdb(1) = '1') ELSE '0' ;
    rx_pd_hssi(2) <= '1' WHEN (urx_pdb(2) = '1') ELSE '0' ;
    rx_pd_hssi(3) <= '1' WHEN (urx_pdb(3) = '1') ELSE '0' ;
    rx_pdb <= rx_pd_hssi OR hard_reset & hard_reset & hard_reset & hard_reset ;
    tx_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    cru_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    adce_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    cgb_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    rx_det_pdb <= hard_reset & hard_reset & hard_reset & hard_reset ;
    cmu_txpll_pdb <= hard_reset & hard_reset & hard_reset ;
    refclk_pma_out <= txclk_in;
    mdc_b <= dpclk_in;
    refclk_b <= refclk_pma_out ;
    clk_1_b <= recovclk ;
    clk_2_b <= rxclk_in;

    PROCESS
    BEGIN
        WAIT UNTIL (hard_reset'EVENT AND hard_reset = '1') OR (clk_2_b'EVENT AND clk_2_b = '1');
        IF (hard_reset = '1') THEN
            rxrst_sync2 <= '1';    
            rxrst_sync1 <= '1';    
        ELSE
            rxrst_sync2 <= rxrst_sync1 AFTER 1 ps;    
            rxrst_sync1 <= rxpcs_rst(0);    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (hard_reset'EVENT AND hard_reset = '1') OR (refclk_b'EVENT AND refclk_b = '1');
        IF (hard_reset = '1') THEN
            txrst_sync2 <= '1';    
            txrst_sync1 <= '1';    
        ELSE
            txrst_sync2 <= txrst_sync1 AFTER 1 ps;    
            txrst_sync1 <= txpcs_rst(0);    
        END IF;
    END PROCESS;

    VITAL: PROCESS (dpclk_in, dprioin_in, dprioout_tim, dpriooe_tim)
    variable Tviol_dprioin_dpclk : std_ulogic := '0';
    variable TimingData_dprioin_dpclk : VitalTimingDataType := VitalTimingDataInit;
    variable dprioout_VitalGlitchData: VitalGlitchDataType;
    variable dpriooe_VitalGlitchData: VitalGlitchDataType;
    
    BEGIN
    
    	------------------------
    	--  Timing Check Section
    	------------------------
    
    	if (TimingChecksOn) then
    
    		VitalSetupHoldCheck (
    			Violation       => Tviol_dprioin_dpclk,
    			TimingData      => TimingData_dprioin_dpclk,
    			TestSignal      => dprioin_in,
    			TestSignalName  => "DPRIOIN",
    			RefSignal       => dpclk_in,
    			RefSignalName   => "DPCLK",
    			SetupHigh       => tsetup_dprioin_dpclk_noedge_posedge,
                SetupLow        => tsetup_dprioin_dpclk_noedge_posedge,
    			HoldHigh        => thold_dprioin_dpclk_noedge_posedge,
    			HoldLow         => thold_dprioin_dpclk_noedge_posedge,
    			RefTransition   => '/',
    			HeaderMsg       => InstancePath & "/STRATIXIIGX_HSSI_CENTRAL_MANAGEMENT_UNIT",
    			XOn             => XOnChecks,
    			MsgOn           => MsgOnChecks );
       end if;

        ----------------------
        --  Path Delay Section
        ----------------------
 
        VitalPathDelay01 (
            OutSignal => dprioout,
            OutSignalName => "DPRIOOUT",
            OutTemp => dprioout_tim,
            Paths => (1 => (dpclk_in'last_event, tpd_dpclk_dprioout_posedge, TRUE)),
            GlitchData => dprioout_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn  => XOn,
            MsgOn  => MsgOn );

        VitalPathDelay01 (
            OutSignal => dpriooe,
            OutSignalName => "DPRIOOE",
            OutTemp => dpriooe_tim,
            Paths => (1 => (dpclk_in'last_event, tpd_dpclk_dpriooe_posedge, TRUE)),
            GlitchData => dpriooe_VitalGlitchData,
            Mode => DefGlitchMode,
            XOn  => XOn,
            MsgOn  => MsgOn );

    END PROCESS;

    txrst_int <= txrst_sync2 ;
    rxrst_int <= rxrst_sync2 ;
    
    align_det_sync_sig <= ("1111" & adet);
    sync_status_sig <= ("1111" & syncstatus);
    rd_align_sig <= ("1111" & rdalign);
    dskw_sm_1 : dskw_sm 
        PORT MAP (
            soft_reset => rxrst_int,
            clk_1 => clk_1_b,
            octal_mode => my_gnd,
            align_det_sync => align_det_sync_sig,
            rd_align => rd_align_sig,
            sync_status => sync_status_sig,
            align_status => alignstatus_int,
            enable_deskew => enabledeskew_sig,
            fifo_reset_rd => fiforesetrd_sig,
            curr_state => dskw_curr_st);   
    
    rtx_rx_local_fault_clr_int <= '0' ;
    rindv_tx_int <= '0' ;
    
    tx_sm_1 : tx_sm 
        PORT MAP (
            tx_clk => refclk_b,
            soft_reset => txrst_int,
            indv => rindv_tx_int,
            tx_data => txdatain,
            tx_ctl => txctrl,
            rd_enable_sync => rdenablesync,
            tx_local_fault_clr => rtx_rx_local_fault_clr_int,
            sm_data => txdataout_xhdl26,
            sm_ctl => txctrlout_xhdl25,
            tx_local_fault_det => tx_local_fault_det,
            tx_local_fault => tx_local_fault_int,
            curr_state => tx_curr_st);   
    
    rindv_rx_int <= '0' ;
    rxs_link_status_set_int <= '0' ;
    
    rcv_sm_1 : rcv_sm 
        PORT MAP (
            clk_2 => clk_2_b,
            soft_reset => rxrst_int,
            indv => rindv_rx_int,
            dec_data_valid => rxdatavalid,
            dec_data => rxdatain,
            dec_ctl => rxctrl,
            running_disp => rxrunningdisp,
            rx_local_fault_clr => rtx_rx_local_fault_clr_int,
            xs_link_status_set => rxs_link_status_set_int,
            tx_local_fault_det => tx_local_fault_det,
            rx_data_rs => rxdataout_xhdl20,
            rx_ctl_rs => rxctrlout_xhdl19,
            rx_local_fault => rx_local_fault_int,
            xs_link_status => xs_link_status_int,
            curr_state => rcv_curr_st);   
    
    port_addr <= int2bin((portaddr - 1), 5);        -- 1-based in Quartus
    dev_addr  <= int2bin((devaddr - 1), 5);         -- 1-based in Quartus
        
    mdio_in  <= dprioin_in AFTER 1 ps;
    
    mdio_rst_reg <= '0' AFTER 1000 ps;    
    mdio_rst <= mdio_rst_reg ;
    cmudprioin <= "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ;
    
    control_top_0 : stratixiigx_hssi_cmu_dprio_top 
        GENERIC MAP ( 
            rx0_phy => rx0_logical_to_physical_mapping,
            rx1_phy => rx1_logical_to_physical_mapping,
            rx2_phy => rx2_logical_to_physical_mapping,
            rx3_phy => rx3_logical_to_physical_mapping,

            tx0_phy => tx0_logical_to_physical_mapping,
            tx1_phy => tx1_logical_to_physical_mapping,
            tx2_phy => tx2_logical_to_physical_mapping,
            tx3_phy => tx3_logical_to_physical_mapping              
        )  
        PORT MAP (
            cmudividerdprioin => cmudividerdprioin,
            cmuplldprioin => cmuplldprioin,
            cmudprioin => cmudprioin,
            refclkdividerdprioin => refclkdividerdprioin,
            rxdprioin => rxdprioin,
            txdprioin => txdprioin,
            cmudividerdprioout => cmudividerdprioout_sig,
            cmuplldprioout => cmuplldprioout_sig,
            cmudprioout => cmudprioout,
            refclkdividerdprioout => refclkdividerdprioout_xhdl13,
            rxdprioout => rxdprioout_xhdl22,
            txdprioout => txdprioout_xhdl30,
            sync_status => syncstatus,
            align_status => alignstatus_int,
            dprioload => dprioload_in,
            mdio_in => mdio_in,
            mdc => dpclk_in,
            port_addr => port_addr,
            dev_addr => dev_addr,
            mdio_dis => dpriodisable_in,
            mdio_rst => mdio_rst,
            mdio_out => dprioout_tim,
            data_enable_n => dpriooe_tim,
            mdio_curr_st => mdio_curr_st);   
    

END vital_cmu_top_arch;
--****************************************************************************
-- Description:
--    This is a flip-flop based implementation
--    Bit 15,14 are the underflow/overflow/insertion/deletion status bits
--    Bit 13 is the running Disparity polarity bits 
--    Bit 12 is the Disparity Error bit
--    Bit 11 is the Resync/Sync_status bit
--    Bit 10 is the Invalid Code bit
--    Bit 9 to 0 -- Encoded 10-bit data
--****************************************************************************

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY ram20x16_syn IS
    GENERIC (
        read_access_time      :  NATURAL := 0;    
        write_access_time     :  NATURAL := 0;    
        ram_width             :  NATURAL := 16
	);  
    PORT (
        data_in                 : IN std_logic_vector(15 DOWNTO 0);   
        clk                     : IN std_logic;   
        fifo_wr                 : IN std_logic_vector(19 DOWNTO 0);   
        rst_l                   : IN std_logic;   
        fifo_re1                : IN std_logic_vector(19 DOWNTO 0);   
        fifo_re2                : IN std_logic_vector(19 DOWNTO 0);   
        data_out1               : OUT std_logic_vector(15 DOWNTO 0);   
        data_out2               : OUT std_logic_vector(15 DOWNTO 0));   
END ram20x16_syn;

ARCHITECTURE ram20x16_syn_arch OF ram20x16_syn IS


    SIGNAL data_out1_i              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_out2_i              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_16           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_17           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_18           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_19           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_16           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_17           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_18           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_19           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_0               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_1               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_2               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_3               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_4               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_5               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_6               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_7               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_8               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_9               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_10              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_11              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_12              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_13              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_14              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_15              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_16              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_17              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_18              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_19              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL we                       :  std_logic;   
    SIGNAL re_l                     :  std_logic;   
    --assignment
    -- Assuming address trigerred operation only 
    -- Modelling the read port 
    SIGNAL temp_xhdl3               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl4               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl5               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl6               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl7               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl8               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl9               :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl10              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl11              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl12              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl13              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl14              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl15              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl16              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl17              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl18              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl19              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl20              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl21              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl22              :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL temp_xhdl23              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL temp_xhdl24              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_out1_xhdl1          :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL data_out2_xhdl2          :  std_logic_vector(15 DOWNTO 0);   

BEGIN
    data_out1 <= data_out1_xhdl1;
    data_out2 <= data_out2_xhdl2;
    we <= '1' ;
    re_l <= '0' ;
    temp_xhdl3 <= data_in WHEN (fifo_wr(0) = '1') ELSE ram_array_q_0;
    temp_xhdl4 <= data_in WHEN (fifo_wr(1) = '1') ELSE ram_array_q_1;
    temp_xhdl5 <= data_in WHEN (fifo_wr(2) = '1') ELSE ram_array_q_2;
    temp_xhdl6 <= data_in WHEN (fifo_wr(3) = '1') ELSE ram_array_q_3;
    temp_xhdl7 <= data_in WHEN (fifo_wr(4) = '1') ELSE ram_array_q_4;
    temp_xhdl8 <= data_in WHEN (fifo_wr(5) = '1') ELSE ram_array_q_5;
    temp_xhdl9 <= data_in WHEN (fifo_wr(6) = '1') ELSE ram_array_q_6;
    temp_xhdl10 <= data_in WHEN (fifo_wr(7) = '1') ELSE ram_array_q_7;
    temp_xhdl11 <= data_in WHEN (fifo_wr(8) = '1') ELSE ram_array_q_8;
    temp_xhdl12 <= data_in WHEN (fifo_wr(9) = '1') ELSE ram_array_q_9;
    temp_xhdl13 <= data_in WHEN (fifo_wr(10) = '1') ELSE ram_array_q_10;
    temp_xhdl14 <= data_in WHEN (fifo_wr(11) = '1') ELSE ram_array_q_11;
    temp_xhdl15 <= data_in WHEN (fifo_wr(12) = '1') ELSE ram_array_q_12;
    temp_xhdl16 <= data_in WHEN (fifo_wr(13) = '1') ELSE ram_array_q_13;
    temp_xhdl17 <= data_in WHEN (fifo_wr(14) = '1') ELSE ram_array_q_14;
    temp_xhdl18 <= data_in WHEN (fifo_wr(15) = '1') ELSE ram_array_q_15;
    temp_xhdl19 <= data_in WHEN (fifo_wr(16) = '1') ELSE ram_array_q_16;
    temp_xhdl20 <= data_in WHEN (fifo_wr(17) = '1') ELSE ram_array_q_17;
    temp_xhdl21 <= data_in WHEN (fifo_wr(18) = '1') ELSE ram_array_q_18;
    temp_xhdl22 <= data_in WHEN (fifo_wr(19) = '1') ELSE ram_array_q_19;
    data_reg_0 <= temp_xhdl3 ;
    data_reg_1 <= temp_xhdl4 ;
    data_reg_2 <= temp_xhdl5 ;
    data_reg_3 <= temp_xhdl6 ;
    data_reg_4 <= temp_xhdl7 ;
    data_reg_5 <= temp_xhdl8 ;
    data_reg_6 <= temp_xhdl9 ;
    data_reg_7 <= temp_xhdl10 ;
    data_reg_8 <= temp_xhdl11 ;
    data_reg_9 <= temp_xhdl12 ;
    data_reg_10 <= temp_xhdl13 ;
    data_reg_11 <= temp_xhdl14 ;
    data_reg_12 <= temp_xhdl15 ;
    data_reg_13 <= temp_xhdl16 ;
    data_reg_14 <= temp_xhdl17 ;
    data_reg_15 <= temp_xhdl18 ;
    data_reg_16 <= temp_xhdl19 ;
    data_reg_17 <= temp_xhdl20 ;
    data_reg_18 <= temp_xhdl21 ;
    data_reg_19 <= temp_xhdl22 ;
    temp_xhdl23 <= "0000000000000000" WHEN re_l = '1' ELSE data_out1_i;
    data_out1_xhdl1 <= temp_xhdl23  AFTER (read_access_time * 1 ps);
    temp_xhdl24 <= "0000000000000000" WHEN re_l = '1' ELSE data_out2_i;
    data_out2_xhdl2 <= temp_xhdl24  AFTER (read_access_time * 1 ps);

    PROCESS
    BEGIN
        WAIT UNTIL ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT OR ram_array_q_8'EVENT OR ram_array_q_9'EVENT OR ram_array_q_10'EVENT OR ram_array_q_11'EVENT OR ram_array_q_12'EVENT OR ram_array_q_13'EVENT OR ram_array_q_14'EVENT OR ram_array_q_15'EVENT OR ram_array_q_16'EVENT OR ram_array_q_17'EVENT OR ram_array_q_18'EVENT OR ram_array_q_19'EVENT OR fifo_re1'EVENT OR fifo_re2'EVENT;
        CASE fifo_re1 IS
            -- synopsys parallel_case full_case
            
            WHEN "00000000000000000001" =>
                        data_out1_i <= ram_array_q_0;    
            WHEN "00000000000000000010" =>
                        data_out1_i <= ram_array_q_1;    
            WHEN "00000000000000000100" =>
                        data_out1_i <= ram_array_q_2;    
            WHEN "00000000000000001000" =>
                        data_out1_i <= ram_array_q_3;    
            WHEN "00000000000000010000" =>
                        data_out1_i <= ram_array_q_4;    
            WHEN "00000000000000100000" =>
                        data_out1_i <= ram_array_q_5;    
            WHEN "00000000000001000000" =>
                        data_out1_i <= ram_array_q_6;    
            WHEN "00000000000010000000" =>
                        data_out1_i <= ram_array_q_7;    
            WHEN "00000000000100000000" =>
                        data_out1_i <= ram_array_q_8;    
            WHEN "00000000001000000000" =>
                        data_out1_i <= ram_array_q_9;    
            WHEN "00000000010000000000" =>
                        data_out1_i <= ram_array_q_10;    
            WHEN "00000000100000000000" =>
                        data_out1_i <= ram_array_q_11;    
            WHEN "00000001000000000000" =>
                        data_out1_i <= ram_array_q_12;    
            WHEN "00000010000000000000" =>
                        data_out1_i <= ram_array_q_13;    
            WHEN "00000100000000000000" =>
                        data_out1_i <= ram_array_q_14;    
            WHEN "00001000000000000000" =>
                        data_out1_i <= ram_array_q_15;    
            WHEN "00010000000000000000" =>
                        data_out1_i <= ram_array_q_16;    
            WHEN "00100000000000000000" =>
                        data_out1_i <= ram_array_q_17;    
            WHEN "01000000000000000000" =>
                        data_out1_i <= ram_array_q_18;    
            WHEN "10000000000000000000" =>
                        data_out1_i <= ram_array_q_19;    
            WHEN OTHERS =>
                        NULL;
            
        END CASE;
        CASE fifo_re2 IS
            -- synopsys parallel_case full_case
            
            WHEN "00000000000000000001" =>
                        data_out2_i <= ram_array_q_0;    
            WHEN "00000000000000000010" =>
                        data_out2_i <= ram_array_q_1;    
            WHEN "00000000000000000100" =>
                        data_out2_i <= ram_array_q_2;    
            WHEN "00000000000000001000" =>
                        data_out2_i <= ram_array_q_3;    
            WHEN "00000000000000010000" =>
                        data_out2_i <= ram_array_q_4;    
            WHEN "00000000000000100000" =>
                        data_out2_i <= ram_array_q_5;    
            WHEN "00000000000001000000" =>
                        data_out2_i <= ram_array_q_6;    
            WHEN "00000000000010000000" =>
                        data_out2_i <= ram_array_q_7;    
            WHEN "00000000000100000000" =>
                        data_out2_i <= ram_array_q_8;    
            WHEN "00000000001000000000" =>
                        data_out2_i <= ram_array_q_9;    
            WHEN "00000000010000000000" =>
                        data_out2_i <= ram_array_q_10;    
            WHEN "00000000100000000000" =>
                        data_out2_i <= ram_array_q_11;    
            WHEN "00000001000000000000" =>
                        data_out2_i <= ram_array_q_12;    
            WHEN "00000010000000000000" =>
                        data_out2_i <= ram_array_q_13;    
            WHEN "00000100000000000000" =>
                        data_out2_i <= ram_array_q_14;    
            WHEN "00001000000000000000" =>
                        data_out2_i <= ram_array_q_15;    
            WHEN "00010000000000000000" =>
                        data_out2_i <= ram_array_q_16;    
            WHEN "00100000000000000000" =>
                        data_out2_i <= ram_array_q_17;    
            WHEN "01000000000000000000" =>
                        data_out2_i <= ram_array_q_18;    
            WHEN "10000000000000000000" =>
                        data_out2_i <= ram_array_q_19;    
            WHEN OTHERS =>
                        NULL;
            
        END CASE;
    END PROCESS;

    -- Modelling the write port 
    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (rst_l'EVENT AND rst_l = '0');
        IF (NOT rst_l = '1') THEN
            ram_array_q_0 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_8 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_9 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_10 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_11 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_12 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_13 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_14 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_15 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_16 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_17 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_18 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_19 <= "0000000000000000" AFTER (write_access_time * 1 ps);    
        ELSE
            ram_array_q_0 <= ram_array_d_0 AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= ram_array_d_1 AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= ram_array_d_2 AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= ram_array_d_3 AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= ram_array_d_4 AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= ram_array_d_5 AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= ram_array_d_6 AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= ram_array_d_7 AFTER (write_access_time * 1 ps);    
            ram_array_q_8 <= ram_array_d_8 AFTER (write_access_time * 1 ps);    
            ram_array_q_9 <= ram_array_d_9 AFTER (write_access_time * 1 ps);    
            ram_array_q_10 <= ram_array_d_10 AFTER (write_access_time * 1 ps);    
            ram_array_q_11 <= ram_array_d_11 AFTER (write_access_time * 1 ps);    
            ram_array_q_12 <= ram_array_d_12 AFTER (write_access_time * 1 ps);    
            ram_array_q_13 <= ram_array_d_13 AFTER (write_access_time * 1 ps);    
            ram_array_q_14 <= ram_array_d_14 AFTER (write_access_time * 1 ps);    
            ram_array_q_15 <= ram_array_d_15 AFTER (write_access_time * 1 ps);    
            ram_array_q_16 <= ram_array_d_16 AFTER (write_access_time * 1 ps);    
            ram_array_q_17 <= ram_array_d_17 AFTER (write_access_time * 1 ps);    
            ram_array_q_18 <= ram_array_d_18 AFTER (write_access_time * 1 ps);    
            ram_array_q_19 <= ram_array_d_19 AFTER (write_access_time * 1 ps);    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL we'EVENT OR data_reg_0'EVENT OR data_reg_1'EVENT OR data_reg_2'EVENT OR data_reg_3'EVENT OR data_reg_4'EVENT OR data_reg_5'EVENT OR data_reg_6'EVENT OR data_reg_7'EVENT OR data_reg_8'EVENT OR data_reg_9'EVENT OR data_reg_10'EVENT OR data_reg_11'EVENT OR data_reg_12'EVENT OR data_reg_13'EVENT OR data_reg_14'EVENT OR data_reg_15'EVENT OR data_reg_16'EVENT OR data_reg_17'EVENT OR data_reg_18'EVENT OR data_reg_19'EVENT OR ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT OR ram_array_q_8'EVENT OR ram_array_q_9'EVENT OR ram_array_q_10'EVENT OR ram_array_q_11'EVENT OR ram_array_q_12'EVENT OR ram_array_q_13'EVENT OR ram_array_q_14'EVENT OR ram_array_q_15'EVENT OR ram_array_q_16'EVENT OR ram_array_q_17'EVENT OR ram_array_q_18'EVENT OR ram_array_q_19'EVENT;
        IF (we = '1') THEN
            ram_array_d_0 <= data_reg_0 AFTER (write_access_time * 1 ps);    
            ram_array_d_1 <= data_reg_1 AFTER (write_access_time * 1 ps);    
            ram_array_d_2 <= data_reg_2 AFTER (write_access_time * 1 ps);    
            ram_array_d_3 <= data_reg_3 AFTER (write_access_time * 1 ps);    
            ram_array_d_4 <= data_reg_4 AFTER (write_access_time * 1 ps);    
            ram_array_d_5 <= data_reg_5 AFTER (write_access_time * 1 ps);    
            ram_array_d_6 <= data_reg_6 AFTER (write_access_time * 1 ps);    
            ram_array_d_7 <= data_reg_7 AFTER (write_access_time * 1 ps);    
            ram_array_d_8 <= data_reg_8 AFTER (write_access_time * 1 ps);    
            ram_array_d_9 <= data_reg_9 AFTER (write_access_time * 1 ps);    
            ram_array_d_10 <= data_reg_10 AFTER (write_access_time * 1 ps);    
            ram_array_d_11 <= data_reg_11 AFTER (write_access_time * 1 ps);    
            ram_array_d_12 <= data_reg_12 AFTER (write_access_time * 1 ps);    
            ram_array_d_13 <= data_reg_13 AFTER (write_access_time * 1 ps);    
            ram_array_d_14 <= data_reg_14 AFTER (write_access_time * 1 ps);    
            ram_array_d_15 <= data_reg_15 AFTER (write_access_time * 1 ps);    
            ram_array_d_16 <= data_reg_16 AFTER (write_access_time * 1 ps);    
            ram_array_d_17 <= data_reg_17 AFTER (write_access_time * 1 ps);    
            ram_array_d_18 <= data_reg_18 AFTER (write_access_time * 1 ps);    
            ram_array_d_19 <= data_reg_19 AFTER (write_access_time * 1 ps);    
        ELSE
            ram_array_d_0 <= ram_array_q_0 AFTER (write_access_time * 1 ps);    
            ram_array_d_1 <= ram_array_q_1 AFTER (write_access_time * 1 ps);    
            ram_array_d_2 <= ram_array_q_2 AFTER (write_access_time * 1 ps);    
            ram_array_d_3 <= ram_array_q_3 AFTER (write_access_time * 1 ps);    
            ram_array_d_4 <= ram_array_q_4 AFTER (write_access_time * 1 ps);    
            ram_array_d_5 <= ram_array_q_5 AFTER (write_access_time * 1 ps);    
            ram_array_d_6 <= ram_array_q_6 AFTER (write_access_time * 1 ps);    
            ram_array_d_7 <= ram_array_q_7 AFTER (write_access_time * 1 ps);    
            ram_array_d_8 <= ram_array_q_8 AFTER (write_access_time * 1 ps);    
            ram_array_d_9 <= ram_array_q_9 AFTER (write_access_time * 1 ps);    
            ram_array_d_10 <= ram_array_q_10 AFTER (write_access_time * 1 ps);    
            ram_array_d_11 <= ram_array_q_11 AFTER (write_access_time * 1 ps);    
            ram_array_d_12 <= ram_array_q_12 AFTER (write_access_time * 1 ps);    
            ram_array_d_13 <= ram_array_q_13 AFTER (write_access_time * 1 ps);    
            ram_array_d_14 <= ram_array_q_14 AFTER (write_access_time * 1 ps);    
            ram_array_d_15 <= ram_array_q_15 AFTER (write_access_time * 1 ps);    
            ram_array_d_16 <= ram_array_q_16 AFTER (write_access_time * 1 ps);    
            ram_array_d_17 <= ram_array_q_17 AFTER (write_access_time * 1 ps);    
            ram_array_d_18 <= ram_array_q_18 AFTER (write_access_time * 1 ps);    
            ram_array_d_19 <= ram_array_q_19 AFTER (write_access_time * 1 ps);    
        END IF;
    END PROCESS;

END ram20x16_syn_arch;
--************************************************************
-- Description:
--
--    Started from ram16x13_syn.v and modified to have 
--    width of 14
--
--    Bit 13 is the running Disparity polarity bits 
--    Bit 12 is the Disparity Error bit
--    Bit 11 is the Resync/Sync_status bit
--    Bit 10 is the Invalid Code bit
--    Bit 9 to 0 -- Encoded 10-bit data
-- **********************************************************


LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY ram16x14_syn IS
    GENERIC (
        read_access_time      :  NATURAL := 0;    
        write_access_time     :  NATURAL := 0;    
        ram_width             :  NATURAL := 14
	);  
    PORT (
        clk                     : IN std_logic;   
        rst_l                   : IN std_logic;   
        addr_wr                 : IN std_logic_vector(15 DOWNTO 0);   
        addr_rd1                : IN std_logic_vector(15 DOWNTO 0);   
        addr_rd2                : IN std_logic_vector(15 DOWNTO 0);   
        data_in                 : IN std_logic_vector(13 DOWNTO 0);   
        we                      : IN std_logic;   
        re_l                    : IN std_logic;   
        data_out1               : OUT std_logic_vector(13 DOWNTO 0);   
        data_out2               : OUT std_logic_vector(13 DOWNTO 0));   
END ram16x14_syn;

ARCHITECTURE ram16x14_syn_arch OF ram16x14_syn IS


    SIGNAL data_out1_i              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_out2_i              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_0               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_1               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_2               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_3               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_4               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_5               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_6               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_7               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_8               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_9               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_10              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_11              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_12              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_13              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_14              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_15              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    --assignment
    -- Assuming address trigerred operation only 
    -- Modelling the read port 
    SIGNAL temp_xhdl3               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl4               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl5               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl6               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl7               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl8               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl9               :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl10              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl11              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl12              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl13              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl14              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl15              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl16              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl17              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl18              :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL temp_xhdl19              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL temp_xhdl20              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_out1_xhdl1          :  std_logic_vector(13 DOWNTO 0);   
    SIGNAL data_out2_xhdl2          :  std_logic_vector(13 DOWNTO 0);   

BEGIN
    data_out1 <= data_out1_xhdl1;
    data_out2 <= data_out2_xhdl2;
    temp_xhdl3 <= data_in WHEN (addr_wr(0) = '1') ELSE ram_array_q_0;
    temp_xhdl4 <= data_in WHEN (addr_wr(1) = '1') ELSE ram_array_q_1;
    temp_xhdl5 <= data_in WHEN (addr_wr(2) = '1') ELSE ram_array_q_2;
    temp_xhdl6 <= data_in WHEN (addr_wr(3) = '1') ELSE ram_array_q_3;
    temp_xhdl7 <= data_in WHEN (addr_wr(4) = '1') ELSE ram_array_q_4;
    temp_xhdl8 <= data_in WHEN (addr_wr(5) = '1') ELSE ram_array_q_5;
    temp_xhdl9 <= data_in WHEN (addr_wr(6) = '1') ELSE ram_array_q_6;
    temp_xhdl10 <= data_in WHEN (addr_wr(7) = '1') ELSE ram_array_q_7;
    temp_xhdl11 <= data_in WHEN (addr_wr(8) = '1') ELSE ram_array_q_8;
    temp_xhdl12 <= data_in WHEN (addr_wr(9) = '1') ELSE ram_array_q_9;
    temp_xhdl13 <= data_in WHEN (addr_wr(10) = '1') ELSE ram_array_q_10;
    temp_xhdl14 <= data_in WHEN (addr_wr(11) = '1') ELSE ram_array_q_11;
    temp_xhdl15 <= data_in WHEN (addr_wr(12) = '1') ELSE ram_array_q_12;
    temp_xhdl16 <= data_in WHEN (addr_wr(13) = '1') ELSE ram_array_q_13;
    temp_xhdl17 <= data_in WHEN (addr_wr(14) = '1') ELSE ram_array_q_14;
    temp_xhdl18 <= data_in WHEN (addr_wr(15) = '1') ELSE ram_array_q_15;
    data_reg_0 <= temp_xhdl3 ;
    data_reg_1 <= temp_xhdl4 ;
    data_reg_2 <= temp_xhdl5 ;
    data_reg_3 <= temp_xhdl6 ;
    data_reg_4 <= temp_xhdl7 ;
    data_reg_5 <= temp_xhdl8 ;
    data_reg_6 <= temp_xhdl9 ;
    data_reg_7 <= temp_xhdl10 ;
    data_reg_8 <= temp_xhdl11 ;
    data_reg_9 <= temp_xhdl12 ;
    data_reg_10 <= temp_xhdl13 ;
    data_reg_11 <= temp_xhdl14 ;
    data_reg_12 <= temp_xhdl15 ;
    data_reg_13 <= temp_xhdl16 ;
    data_reg_14 <= temp_xhdl17 ;
    data_reg_15 <= temp_xhdl18 ;
    temp_xhdl19 <= "00000000000000" WHEN re_l = '1' ELSE data_out1_i;
    data_out1_xhdl1 <= temp_xhdl19  AFTER (read_access_time * 1 ps);
    temp_xhdl20 <= "00000000000000" WHEN re_l = '1' ELSE data_out2_i;
    data_out2_xhdl2 <= temp_xhdl20  AFTER (read_access_time * 1 ps);

    PROCESS
    BEGIN
        WAIT UNTIL ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT OR ram_array_q_8'EVENT OR ram_array_q_9'EVENT OR ram_array_q_10'EVENT OR ram_array_q_11'EVENT OR ram_array_q_12'EVENT OR ram_array_q_13'EVENT OR ram_array_q_14'EVENT OR ram_array_q_15'EVENT OR addr_rd1'EVENT OR addr_rd2'EVENT;
        CASE addr_rd1 IS
            -- synopsys parallel_case full_case
            
            WHEN "0000000000000001" =>
                        data_out1_i <= ram_array_q_0;    
            WHEN "0000000000000010" =>
                        data_out1_i <= ram_array_q_1;    
            WHEN "0000000000000100" =>
                        data_out1_i <= ram_array_q_2;    
            WHEN "0000000000001000" =>
                        data_out1_i <= ram_array_q_3;    
            WHEN "0000000000010000" =>
                        data_out1_i <= ram_array_q_4;    
            WHEN "0000000000100000" =>
                        data_out1_i <= ram_array_q_5;    
            WHEN "0000000001000000" =>
                        data_out1_i <= ram_array_q_6;    
            WHEN "0000000010000000" =>
                        data_out1_i <= ram_array_q_7;    
            WHEN "0000000100000000" =>
                        data_out1_i <= ram_array_q_8;    
            WHEN "0000001000000000" =>
                        data_out1_i <= ram_array_q_9;    
            WHEN "0000010000000000" =>
                        data_out1_i <= ram_array_q_10;    
            WHEN "0000100000000000" =>
                        data_out1_i <= ram_array_q_11;    
            WHEN "0001000000000000" =>
                        data_out1_i <= ram_array_q_12;    
            WHEN "0010000000000000" =>
                        data_out1_i <= ram_array_q_13;    
            WHEN "0100000000000000" =>
                        data_out1_i <= ram_array_q_14;    
            WHEN "1000000000000000" =>
                        data_out1_i <= ram_array_q_15;    
            WHEN OTHERS =>
                        NULL;
            
        END CASE;
        CASE addr_rd2 IS
            -- synopsys parallel_case full_case
            
            WHEN "0000000000000001" =>
                        data_out2_i <= ram_array_q_0;    
            WHEN "0000000000000010" =>
                        data_out2_i <= ram_array_q_1;    
            WHEN "0000000000000100" =>
                        data_out2_i <= ram_array_q_2;    
            WHEN "0000000000001000" =>
                        data_out2_i <= ram_array_q_3;    
            WHEN "0000000000010000" =>
                        data_out2_i <= ram_array_q_4;    
            WHEN "0000000000100000" =>
                        data_out2_i <= ram_array_q_5;    
            WHEN "0000000001000000" =>
                        data_out2_i <= ram_array_q_6;    
            WHEN "0000000010000000" =>
                        data_out2_i <= ram_array_q_7;    
            WHEN "0000000100000000" =>
                        data_out2_i <= ram_array_q_8;    
            WHEN "0000001000000000" =>
                        data_out2_i <= ram_array_q_9;    
            WHEN "0000010000000000" =>
                        data_out2_i <= ram_array_q_10;    
            WHEN "0000100000000000" =>
                        data_out2_i <= ram_array_q_11;    
            WHEN "0001000000000000" =>
                        data_out2_i <= ram_array_q_12;    
            WHEN "0010000000000000" =>
                        data_out2_i <= ram_array_q_13;    
            WHEN "0100000000000000" =>
                        data_out2_i <= ram_array_q_14;    
            WHEN "1000000000000000" =>
                        data_out2_i <= ram_array_q_15;    
            WHEN OTHERS =>
                        NULL;
            
        END CASE;
    END PROCESS;

    -- Modelling the write port 
    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (rst_l'EVENT AND rst_l = '0');
        IF (NOT rst_l = '1') THEN
            ram_array_q_0 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_8 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_9 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_10 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_11 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_12 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_13 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_14 <= "00000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_15 <= "00000000000000" AFTER (write_access_time * 1 ps);    
        ELSE
            ram_array_q_0 <= ram_array_d_0 AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= ram_array_d_1 AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= ram_array_d_2 AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= ram_array_d_3 AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= ram_array_d_4 AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= ram_array_d_5 AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= ram_array_d_6 AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= ram_array_d_7 AFTER (write_access_time * 1 ps);    
            ram_array_q_8 <= ram_array_d_8 AFTER (write_access_time * 1 ps);    
            ram_array_q_9 <= ram_array_d_9 AFTER (write_access_time * 1 ps);    
            ram_array_q_10 <= ram_array_d_10 AFTER (write_access_time * 1 ps);    
            ram_array_q_11 <= ram_array_d_11 AFTER (write_access_time * 1 ps);    
            ram_array_q_12 <= ram_array_d_12 AFTER (write_access_time * 1 ps);    
            ram_array_q_13 <= ram_array_d_13 AFTER (write_access_time * 1 ps);    
            ram_array_q_14 <= ram_array_d_14 AFTER (write_access_time * 1 ps);    
            ram_array_q_15 <= ram_array_d_15 AFTER (write_access_time * 1 ps);    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL we'EVENT OR data_reg_0'EVENT OR data_reg_1'EVENT OR data_reg_2'EVENT OR data_reg_3'EVENT OR data_reg_4'EVENT OR data_reg_5'EVENT OR data_reg_6'EVENT OR data_reg_7'EVENT OR data_reg_8'EVENT OR data_reg_9'EVENT OR data_reg_10'EVENT OR data_reg_11'EVENT OR data_reg_12'EVENT OR data_reg_13'EVENT OR data_reg_14'EVENT OR data_reg_15'EVENT OR ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT OR ram_array_q_8'EVENT OR ram_array_q_9'EVENT OR ram_array_q_10'EVENT OR ram_array_q_11'EVENT OR ram_array_q_12'EVENT OR ram_array_q_13'EVENT OR ram_array_q_14'EVENT OR ram_array_q_15'EVENT;
        IF (we = '1') THEN
            ram_array_d_0 <= data_reg_0 AFTER (write_access_time * 1 ps);    
            ram_array_d_1 <= data_reg_1 AFTER (write_access_time * 1 ps);    
            ram_array_d_2 <= data_reg_2 AFTER (write_access_time * 1 ps);    
            ram_array_d_3 <= data_reg_3 AFTER (write_access_time * 1 ps);    
            ram_array_d_4 <= data_reg_4 AFTER (write_access_time * 1 ps);    
            ram_array_d_5 <= data_reg_5 AFTER (write_access_time * 1 ps);    
            ram_array_d_6 <= data_reg_6 AFTER (write_access_time * 1 ps);    
            ram_array_d_7 <= data_reg_7 AFTER (write_access_time * 1 ps);    
            ram_array_d_8 <= data_reg_8 AFTER (write_access_time * 1 ps);    
            ram_array_d_9 <= data_reg_9 AFTER (write_access_time * 1 ps);    
            ram_array_d_10 <= data_reg_10 AFTER (write_access_time * 1 ps);    
            ram_array_d_11 <= data_reg_11 AFTER (write_access_time * 1 ps);    
            ram_array_d_12 <= data_reg_12 AFTER (write_access_time * 1 ps);    
            ram_array_d_13 <= data_reg_13 AFTER (write_access_time * 1 ps);    
            ram_array_d_14 <= data_reg_14 AFTER (write_access_time * 1 ps);    
            ram_array_d_15 <= data_reg_15 AFTER (write_access_time * 1 ps);    
        ELSE
            ram_array_d_0 <= ram_array_q_0 AFTER (write_access_time * 1 ps);    
            ram_array_d_1 <= ram_array_q_1 AFTER (write_access_time * 1 ps);    
            ram_array_d_2 <= ram_array_q_2 AFTER (write_access_time * 1 ps);    
            ram_array_d_3 <= ram_array_q_3 AFTER (write_access_time * 1 ps);    
            ram_array_d_4 <= ram_array_q_4 AFTER (write_access_time * 1 ps);    
            ram_array_d_5 <= ram_array_q_5 AFTER (write_access_time * 1 ps);    
            ram_array_d_6 <= ram_array_q_6 AFTER (write_access_time * 1 ps);    
            ram_array_d_7 <= ram_array_q_7 AFTER (write_access_time * 1 ps);    
            ram_array_d_8 <= ram_array_q_8 AFTER (write_access_time * 1 ps);    
            ram_array_d_9 <= ram_array_q_9 AFTER (write_access_time * 1 ps);    
            ram_array_d_10 <= ram_array_q_10 AFTER (write_access_time * 1 ps);    
            ram_array_d_11 <= ram_array_q_11 AFTER (write_access_time * 1 ps);    
            ram_array_d_12 <= ram_array_q_12 AFTER (write_access_time * 1 ps);    
            ram_array_d_13 <= ram_array_q_13 AFTER (write_access_time * 1 ps);    
            ram_array_d_14 <= ram_array_q_14 AFTER (write_access_time * 1 ps);    
            ram_array_d_15 <= ram_array_q_15 AFTER (write_access_time * 1 ps);    
        END IF;
    END PROCESS;

END ram16x14_syn_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY ram8x65_syn IS
    GENERIC (
        read_access_time      :  NATURAL := 0;    
        write_access_time     :  NATURAL := 0;    
        ram_width             :  NATURAL := 65
	);  
    PORT (
        rst_l                   : IN std_logic;   
        clk                     : IN std_logic;   
        fifo_wr                 : IN std_logic_vector(7 DOWNTO 0);   
        data_in                 : IN std_logic_vector(64 DOWNTO 0);   
        fifo_re                 : IN std_logic_vector(7 DOWNTO 0);   
        data_out                : OUT std_logic_vector(64 DOWNTO 0));   
END ram8x65_syn;

ARCHITECTURE ram8x65_syn_arch OF ram8x65_syn IS


    SIGNAL data_out_i               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_d_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL ram_array_q_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_0               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_1               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_2               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_3               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_4               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_5               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_6               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_reg_7               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL we                       :  std_logic;   
    SIGNAL re_l                     :  std_logic;   
    --assignment
    -- Assuming address trigerred operation only 
    -- Modelling the read port 
    SIGNAL temp_xhdl2               :  std_logic_vector(64 DOWNTO 0);   
    SIGNAL temp_xhdl3               :  std_logic_vector(64 DOWNTO 0);   
    SIGNAL temp_xhdl4               :  std_logic_vector(64 DOWNTO 0);   
    SIGNAL temp_xhdl5               :  std_logic_vector(64 DOWNTO 0);   
    SIGNAL temp_xhdl6               :  std_logic_vector(64 DOWNTO 0);   
    SIGNAL temp_xhdl7               :  std_logic_vector(64 DOWNTO 0);   
    SIGNAL temp_xhdl8               :  std_logic_vector(64 DOWNTO 0);   
    SIGNAL temp_xhdl9               :  std_logic_vector(64 DOWNTO 0);   
    SIGNAL temp_xhdl10              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
    SIGNAL data_out_xhdl1           :  std_logic_vector(64 DOWNTO 0);   

BEGIN
    data_out <= data_out_xhdl1;
    we <= '1' ;
    re_l <= '0' ;
    temp_xhdl2 <= data_in WHEN (fifo_wr(0) = '1') ELSE ram_array_q_0;
    temp_xhdl3 <= data_in WHEN (fifo_wr(1) = '1') ELSE ram_array_q_1;
    temp_xhdl4 <= data_in WHEN (fifo_wr(2) = '1') ELSE ram_array_q_2;
    temp_xhdl5 <= data_in WHEN (fifo_wr(3) = '1') ELSE ram_array_q_3;
    temp_xhdl6 <= data_in WHEN (fifo_wr(4) = '1') ELSE ram_array_q_4;
    temp_xhdl7 <= data_in WHEN (fifo_wr(5) = '1') ELSE ram_array_q_5;
    temp_xhdl8 <= data_in WHEN (fifo_wr(6) = '1') ELSE ram_array_q_6;
    temp_xhdl9 <= data_in WHEN (fifo_wr(7) = '1') ELSE ram_array_q_7;
    data_reg_0 <= temp_xhdl2 ;
    data_reg_1 <= temp_xhdl3 ;
    data_reg_2 <= temp_xhdl4 ;
    data_reg_3 <= temp_xhdl5 ;
    data_reg_4 <= temp_xhdl6 ;
    data_reg_5 <= temp_xhdl7 ;
    data_reg_6 <= temp_xhdl8 ;
    data_reg_7 <= temp_xhdl9 ;
    temp_xhdl10 <= "00000000000000000000000000000000000000000000000000000000000000000" WHEN re_l = '1' ELSE data_out_i;
    data_out_xhdl1 <= temp_xhdl10 ;

    PROCESS
    BEGIN
        WAIT UNTIL ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT OR fifo_re'EVENT;
        CASE fifo_re IS
            -- synopsys parallel_case full_case
            
            WHEN "00000001" =>
                        data_out_i <= ram_array_q_0;    
            WHEN "00000010" =>
                        data_out_i <= ram_array_q_1;    
            WHEN "00000100" =>
                        data_out_i <= ram_array_q_2;    
            WHEN "00001000" =>
                        data_out_i <= ram_array_q_3;    
            WHEN "00010000" =>
                        data_out_i <= ram_array_q_4;    
            WHEN "00100000" =>
                        data_out_i <= ram_array_q_5;    
            WHEN "01000000" =>
                        data_out_i <= ram_array_q_6;    
            WHEN "10000000" =>
                        data_out_i <= ram_array_q_7;    
            WHEN OTHERS  =>
                        data_out_i <= ram_array_q_0;    
            
        END CASE;
    END PROCESS;

    -- Modelling the write port 
    PROCESS
    BEGIN
        WAIT UNTIL (clk'EVENT AND clk = '1') OR (rst_l'EVENT AND rst_l = '0');
        IF (NOT rst_l = '1') THEN
            ram_array_q_0 <= "00000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= "00000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= "00000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= "00000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= "00000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= "00000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= "00000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= "00000000000000000000000000000000000000000000000000000000000000000" AFTER (write_access_time * 1 ps);    
        ELSE
            ram_array_q_0 <= ram_array_d_0 AFTER (write_access_time * 1 ps);    
            ram_array_q_1 <= ram_array_d_1 AFTER (write_access_time * 1 ps);    
            ram_array_q_2 <= ram_array_d_2 AFTER (write_access_time * 1 ps);    
            ram_array_q_3 <= ram_array_d_3 AFTER (write_access_time * 1 ps);    
            ram_array_q_4 <= ram_array_d_4 AFTER (write_access_time * 1 ps);    
            ram_array_q_5 <= ram_array_d_5 AFTER (write_access_time * 1 ps);    
            ram_array_q_6 <= ram_array_d_6 AFTER (write_access_time * 1 ps);    
            ram_array_q_7 <= ram_array_d_7 AFTER (write_access_time * 1 ps);    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL we'EVENT OR data_reg_0'EVENT OR data_reg_1'EVENT OR data_reg_2'EVENT OR data_reg_3'EVENT OR data_reg_4'EVENT OR data_reg_5'EVENT OR data_reg_6'EVENT OR data_reg_7'EVENT OR ram_array_q_0'EVENT OR ram_array_q_1'EVENT OR ram_array_q_2'EVENT OR ram_array_q_3'EVENT OR ram_array_q_4'EVENT OR ram_array_q_5'EVENT OR ram_array_q_6'EVENT OR ram_array_q_7'EVENT;
        IF (we = '1') THEN
            ram_array_d_0 <= data_reg_0;    
            ram_array_d_1 <= data_reg_1;    
            ram_array_d_2 <= data_reg_2;    
            ram_array_d_3 <= data_reg_3;    
            ram_array_d_4 <= data_reg_4;    
            ram_array_d_5 <= data_reg_5;    
            ram_array_d_6 <= data_reg_6;    
            ram_array_d_7 <= data_reg_7;    
        ELSE
            ram_array_d_0 <= ram_array_q_0;    
            ram_array_d_1 <= ram_array_q_1;    
            ram_array_d_2 <= ram_array_q_2;    
            ram_array_d_3 <= ram_array_q_3;    
            ram_array_d_4 <= ram_array_q_4;    
            ram_array_d_5 <= ram_array_q_5;    
            ram_array_d_6 <= ram_array_q_6;    
            ram_array_d_7 <= ram_array_q_7;    
        END IF;
    END PROCESS;

END ram8x65_syn_arch;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

ENTITY stratixiigx_hssi_pcs_reset IS
    PORT (
        hard_reset              : IN std_logic;   
        clk_2_b                 : IN std_logic;   
        refclk_b_in             : IN std_logic;   
        scan_mode               : IN std_logic;   
        rxpcs_rst               : IN std_logic;   
        txpcs_rst               : IN std_logic;   
        rxrst_int               : OUT std_logic;   
        txrst_int               : OUT std_logic);   
END stratixiigx_hssi_pcs_reset;

ARCHITECTURE pcs_reset_arc OF stratixiigx_hssi_pcs_reset IS

    CONSTANT xhdl_timescale         : time := 1 ns;


    SIGNAL txrst_sync1              :  std_logic := '0';   
    SIGNAL txrst_sync2              :  std_logic := '0';   
    SIGNAL rxrst_sync1              :  std_logic := '0';   
    SIGNAL rxrst_sync2              :  std_logic := '0';   
    SIGNAL rxrst_int_xhdl1          :  std_logic := '0';   
    SIGNAL txrst_int_xhdl2          :  std_logic := '0';   

BEGIN
    rxrst_int <= rxrst_int_xhdl1;
    txrst_int <= txrst_int_xhdl2;

    PROCESS
    BEGIN
        WAIT UNTIL (hard_reset'EVENT AND hard_reset = '1') OR (clk_2_b'EVENT AND clk_2_b = '1');
        IF (hard_reset = '1') THEN
            rxrst_sync2 <= '1';    
            rxrst_sync1 <= '1';    
        ELSE
            rxrst_sync2 <= rxrst_sync1 AFTER 1 * xhdl_timescale;    
            rxrst_sync1 <= rxpcs_rst;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (hard_reset'EVENT AND hard_reset = '1') OR (refclk_b_in'EVENT AND refclk_b_in = '1');
        IF (hard_reset = '1') THEN
            txrst_sync2 <= '1';    
            txrst_sync1 <= '1';    
        ELSE
            txrst_sync2 <= txrst_sync1 AFTER 1 * xhdl_timescale;    
            txrst_sync1 <= txpcs_rst;    
        END IF;
    END PROCESS;
    -- 06-14-02 BT Changed SCAN_SHIFT signal to SCAN_MODE
    --assign rxrst_int = !SCAN_SHIFT & rxrst_sync2;
    --assign txrst_int = !SCAN_SHIFT & txrst_sync2;
    rxrst_int_xhdl1 <= NOT scan_mode AND rxrst_sync2 ;
    txrst_int_xhdl2 <= NOT scan_mode AND txrst_sync2 ;

END pcs_reset_arc;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

USE WORK.stratixiigx_hssi_aux_clock_div;
--USE WORK.stratixiigx_hssi_aux_clock_mult;
--USE WORK.stratixiigx_hssi_aux_clock_phaseshift;
--USE WORK.stratixiigx_hssi_cmu_pll;


ENTITY stratixiigx_hssi_rx_cdr IS
    GENERIC (
        cru_clock_select               :  integer := 0;    --   <CRUCLK<n> where n is 0 through 7 >
        cru_divide_by                  :  integer := 1;    --  <1,2,4>;
        cru_multiply_by                :  integer := 10;    --  <1,2,4,5,8,10,16,20,25>;
        cru_pre_divide_by              :  integer := 1;    --  <1,2,4,8>;
        cruclk0_period                 :  integer    := 10000;    --   in ps
        cruclk1_period                 :  integer    := 10000;    --   in ps
        cruclk2_period                 :  integer    := 10000;    --   in ps
        cruclk3_period                 :  integer    := 10000;    --   in ps
        cruclk4_period                 :  integer    := 10000;    --   in ps
        cruclk5_period                 :  integer    := 10000;    --   in ps
        cruclk6_period                 :  integer    := 10000;    --   in ps
        cruclk7_period                 :  integer    := 10000;    --   in ps
        force_signal_detect            :  string  := "false";    --  RFORCE_SIGDET
        force_freq_det_high            :  string  := "false";
        force_freq_det_low             :  string  := "false";
        sim_rxpll_clkout_phase_shift   :  integer := 0;
        sim_rxpll_clkout_latency       :  integer := 0;
        ignore_lock_detect             :  string  := "false";    
        signal_detect_threshhold       :  integer := 0;    
        send_direct_reverse_serial_loopback: string := "false");    
    PORT (
        cruclk                  : IN std_logic_vector(8 DOWNTO 0) := (OTHERS => '0');   
        dpriodisable            : IN std_logic := '1';   
        dprioin                 : IN std_logic_vector(19 DOWNTO 0) := (OTHERS => '0');   
        freqlock                : IN std_logic := '0';   
        ltd                     : IN std_logic := '0';   
        ltr                     : IN std_logic := '0';   
        pdb                     : IN std_logic := '0';   
        reset                   : IN std_logic := '0';   
        rxin                    : IN std_logic := '0';   
        clklow                  : OUT std_logic := '0';   
        dprioout                : OUT std_logic_vector(19 DOWNTO 0);   
        fref                    : OUT std_logic;   
        freqlocked              : OUT std_logic;   --  rxpll_lock
        phaselockloss           : OUT std_logic;   --  !rxpll_phaselock,
        revserialfdbk           : OUT std_logic;   
        serialclkout            : OUT std_logic;   
        signaldetect            : OUT std_logic);   
END stratixiigx_hssi_rx_cdr;

ARCHITECTURE rx_cdr_arc OF stratixiigx_hssi_rx_cdr IS

    COMPONENT stratixiigx_hssi_aux_clock_div
    GENERIC (
        clk_divide_by : INTEGER := 1;
        extra_latency : INTEGER := 0
    );
    PORT (
        clk                     : IN STD_LOGIC;   
        reset                   : IN STD_LOGIC := '0';   
        clkout                  : OUT STD_LOGIC
    );   
    END COMPONENT;

	SIGNAL my_vcc                 :  std_logic := '1';

    SIGNAL refclk                   :  std_logic;   
    SIGNAL predivided_clk           :  std_logic;   
    SIGNAL rxpll_dprioin            :  std_logic_vector(39 DOWNTO 0);   
    SIGNAL rxpllrefclk              :  std_logic_vector(7 DOWNTO 0);   
    SIGNAL rxpll_sclkout            :  std_logic;   
    SIGNAL rxpll_lock               :  std_logic;   
    SIGNAL rxpll_phaselock          :  std_logic;   
    SIGNAL signal_detect_reg        :  std_logic := '0';   
    -- Connect primary outputs
    SIGNAL temp_xhdl9               :  std_logic;   
    SIGNAL temp_xhdl10              :  std_logic;   
    -- PRE-DIVIDER
    SIGNAL temp_xhdl11              :  std_logic;   
    SIGNAL temp_xhdl16              :  std_logic;   
    SIGNAL clklow_xhdl1             :  std_logic;   
    SIGNAL dprioout_xhdl2           :  std_logic_vector(19 DOWNTO 0);   
    SIGNAL fref_xhdl3               :  std_logic;   
    SIGNAL phaselockloss_xhdl5      :  std_logic;   
    SIGNAL revserialfdbk_xhdl6      :  std_logic;   
    SIGNAL serialclkout_xhdl7       :  std_logic;   
    SIGNAL signaldetect_xhdl8       :  std_logic;
    
    -- freqlock
    SIGNAL mrxpll_not_locked : std_logic := '1';
    SIGNAL mfreqlocked_reg   : std_logic := '0';
    SIGNAL mfreqlocked_cnt   : integer := 0;  -- 4 bit 
   
BEGIN
    clklow <= clklow_xhdl1;
    dprioout <= dprioout_xhdl2;
    fref <= fref_xhdl3;
    freqlocked <= mfreqlocked_reg;
    phaselockloss <= phaselockloss_xhdl5;
    serialclkout <= serialclkout_xhdl7;
    signaldetect <= signaldetect_xhdl8;

    temp_xhdl9 <= 'Z' WHEN (pdb = '1') ELSE rxin;
    revserialfdbk_xhdl6 <= temp_xhdl9 ;
    revserialfdbk <= revserialfdbk_xhdl6;

    phaselockloss_xhdl5 <= rxpll_phaselock ;
    fref_xhdl3 <= predivided_clk ;
    dprioout_xhdl2 <= "00000000000000000000" ;
    serialclkout_xhdl7 <= rxpll_sclkout ;
    temp_xhdl10 <= '1' WHEN (force_signal_detect = "true") ELSE signal_detect_reg;
    signaldetect_xhdl8 <= temp_xhdl10 ;
    temp_xhdl11 <= cruclk(cru_clock_select) WHEN (cru_clock_select<=7) ELSE cruclk(0);
    refclk <= temp_xhdl11 ;

    m_predivider : stratixiigx_hssi_aux_clock_div 
        GENERIC MAP (
            clk_divide_by => cru_pre_divide_by,
            extra_latency => 0)
        PORT MAP (
            clk => refclk,
            reset => reset,
            clkout => predivided_clk);   
    
    -- RX PLL
    --assign rxpllrefclk = {6'b000000,predivided_clk};
    rxpllrefclk(cru_clock_select) <= predivided_clk ;
    rxpll_dprioin <= "0000000000000000000000000000000000000000" ;
    m_rxpll : stratixiigx_hssi_cmu_pll 
        GENERIC MAP (
            divide_by     => cru_divide_by,
            inclk0_period => (cruclk0_period * cru_pre_divide_by),
            inclk1_period => (cruclk1_period * cru_pre_divide_by),
            inclk2_period => (cruclk2_period * cru_pre_divide_by),
            inclk3_period => (cruclk3_period * cru_pre_divide_by),
            inclk4_period => (cruclk4_period * cru_pre_divide_by),
            inclk5_period => (cruclk5_period * cru_pre_divide_by),
            inclk6_period => (cruclk6_period * cru_pre_divide_by),
            inclk7_period => (cruclk7_period * cru_pre_divide_by),
            sim_clkout_phase_shift  => sim_rxpll_clkout_phase_shift,
            sim_clkout_latency  => sim_rxpll_clkout_latency,
            multiply_by   => (2 * cru_multiply_by),
            pfd_clk_select=> cru_clock_select)
        PORT MAP (
            clk          => rxpllrefclk,
            dprioin      => rxpll_dprioin,
            dpriodisable => my_vcc,
            pllreset     => reset,
            pllpowerdn   => pdb,
            clkout       => rxpll_sclkout,
            locked       => rxpll_phaselock,
            dprioout     => open,
            fbclkout     => clklow_xhdl1);   
    
    temp_xhdl16 <= signal_detect_reg WHEN (ignore_lock_detect = "true") ELSE (rxpll_phaselock AND signal_detect_reg);
    rxpll_lock <= temp_xhdl16 ;

    PROCESS
    BEGIN
        WAIT UNTIL reset'EVENT OR rxin'EVENT;
        IF (reset = '1') THEN
            signal_detect_reg <= '0';    
        ELSE
            IF (rxin = '0' OR rxin = '1') THEN
                signal_detect_reg <= '1'; 
            ELSE
                signal_detect_reg <= '0';                
            END IF;
        END IF;
    END PROCESS;

    -- freqlocked simplified model
    mrxpll_not_locked <= '0' WHEN (rxpll_phaselock = '1') ELSE '1';

    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (predivided_clk'EVENT AND predivided_clk = '1');
        IF (reset = '1') THEN
            mfreqlocked_reg <= '0';
        ELSIF (mfreqlocked_cnt = 15) THEN
            mfreqlocked_reg <= '1';
        ELSE
            mfreqlocked_reg <= '0';
        END IF;    
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (mrxpll_not_locked'EVENT AND mrxpll_not_locked = '1') OR (predivided_clk'EVENT AND predivided_clk = '1');
        IF (mrxpll_not_locked = '1') THEN
            mfreqlocked_cnt <= 0;
        ELSIF (mfreqlocked_cnt /= 15) THEN
            mfreqlocked_cnt <= mfreqlocked_cnt + 1;
        END IF;    
    END PROCESS;

END rx_cdr_arc;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_components.ALL;

ENTITY stratixiigx_hssi_rx_des IS
    PORT (
        datain                  : IN std_logic;   
        rdoublewidth            : IN std_logic := '0';   --  1 = double pma
        rdwidth                 : IN std_logic := '0';   --  1 = 10-bit, 0 = 8-bit
        reset                   : IN std_logic := '0';   
        serialclk               : IN std_logic;   
        serialfdbken            : IN std_logic;   
        serialfdbkin            : IN std_logic;   
        paralleldataout         : OUT std_logic_vector(19 DOWNTO 0);   
        recvclkout              : OUT std_logic);   
END stratixiigx_hssi_rx_des;

ARCHITECTURE rx_des_arc OF stratixiigx_hssi_rx_des IS

    CONSTANT xhdl_timescale         : time := 1 ps;


    SIGNAL srcvd_clk                :  std_logic;   
    SIGNAL shift_reg                :  std_logic_vector(19 DOWNTO 0);   --  shift register buffer
    SIGNAL RXD                      :  std_logic;   
    SIGNAL RCLK_PMA_int             :  std_logic;   --  recovered clk from DES
    SIGNAL clk_shift_10b            :  std_logic_vector(9 DOWNTO 0) := "0000111110";   --  serial clk counter to generate rcvd clk
    SIGNAL clk_shift_8b             :  std_logic_vector(9 DOWNTO 0) := "0000011110";   
    SIGNAL PUDI                     :  std_logic_vector(9 DOWNTO 0);   

    --///////////////////////////////////////////////////////////////////////
    -- Byte DES -----------------------------------------------------------//
    --///////////////////////////////////////////////////////////////////////

    SIGNAL RCLK_PMA_int_sync        :  std_logic;   --  delayed by serialclk
    SIGNAL RCLK_PMA_int_sync1       :  std_logic;   --  recovered clk from DES
    SIGNAL RCLK_PMA_phi             :  std_logic;   --  delayed by 2 serial clk cycles of pma_clk
    SIGNAL ddoutB                   :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL ddoutA                   :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL ddoutA_pre               :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL ddclk_out                :  std_logic;   
    SIGNAL ddclk_by2                :  std_logic := '1';   
    SIGNAL neg_ddclk_by2            :  std_logic;   
    SIGNAL pre_reg_clk              :  std_logic;   
    SIGNAL temp_xhdl3               :  std_logic;   
    -- Recovered clk from DES
    SIGNAL temp_xhdl4               :  std_logic;   
    SIGNAL temp_xhdl5               :  std_logic;   
    SIGNAL temp_xhdl6               :  std_logic;   
    SIGNAL recvclkout_xhdl1         :  std_logic;   
    SIGNAL paralleldataout_xhdl2    :  std_logic_vector(19 DOWNTO 0);   

BEGIN
    recvclkout <= recvclkout_xhdl1;
    paralleldataout <= paralleldataout_xhdl2;
    srcvd_clk <= serialclk AFTER 11 * xhdl_timescale ;
    temp_xhdl3 <= serialfdbkin WHEN (serialfdbken = '1') ELSE datain;
    RXD <= temp_xhdl3 ;

    -- 10-bit shift register for received data - rising edge only
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (srcvd_clk'EVENT AND srcvd_clk = '1');
        IF (reset = '1') THEN
            shift_reg(19 DOWNTO 10) <= "0000000000" AFTER 1 * xhdl_timescale;    
        ELSE
            -- avoid X propagation at gate-level netlist
            
            IF (RXD = '0' OR RXD = '1') THEN
                shift_reg(19) <= RXD AFTER 1 * xhdl_timescale;    --  First goint to lower index
            ELSE
                shift_reg(19) <= '0' AFTER 1 * xhdl_timescale;    
            END IF;
            shift_reg(18 DOWNTO 10) <= shift_reg(19 DOWNTO 11) AFTER 1 * xhdl_timescale;    --  Pushing down to lower index
        END IF;
    END PROCESS;

    --///////////////////////////////////////////////////////////////////
    --  WORD boundary = loading time = 1 std_logic latency after reset ------//
    --///////////////////////////////////////////////////////////////////
    -- 10-bit shift register for rcvd_clk 
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (srcvd_clk'EVENT AND srcvd_clk = '1');
        IF (reset = '1') THEN
            clk_shift_10b <= "0000111110";    
        ELSE
            clk_shift_10b(9 DOWNTO 0) <= clk_shift_10b(0) & clk_shift_10b(9 DOWNTO 1);    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (srcvd_clk'EVENT AND srcvd_clk = '1');
        IF (reset = '1') THEN
            clk_shift_8b <= "0000011110";    
        ELSE
            clk_shift_8b(7 DOWNTO 0) <= clk_shift_8b(0) & clk_shift_8b(7 DOWNTO 1);    
        END IF;
    END PROCESS;
    temp_xhdl4 <= clk_shift_10b(0) WHEN (rdwidth = '1') ELSE clk_shift_8b(0);
    RCLK_PMA_int <= temp_xhdl4 ;

    -- 1 pclock latency
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (RCLK_PMA_int'EVENT AND RCLK_PMA_int = '1');
        IF (reset = '1') THEN
            shift_reg(9 DOWNTO 0) <= "0000000000" AFTER 1 * xhdl_timescale;    
        ELSE
            shift_reg(9 DOWNTO 0) <= shift_reg(19 DOWNTO 10) AFTER 1 * xhdl_timescale;    
        END IF;
    END PROCESS;

    -- 2nd pclock latency
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (RCLK_PMA_int'EVENT AND RCLK_PMA_int = '1');
        IF (reset = '1') THEN
            PUDI <= "0000000000";    
        ELSE
            PUDI <= shift_reg(9 DOWNTO 0);    
        END IF;
    END PROCESS;
    --///////////////////////////////////////////////////////////////////////
    -- Byte DES -----------------------------------------------------------//
    --///////////////////////////////////////////////////////////////////////
    RCLK_PMA_phi <= RCLK_PMA_int_sync ;

    --///////////////////////////////////////////////////////////////////////
    -- double pma width: --------------------------------------------------//
    --          1). same word boundary as 8/10 = 1 std_logic after reset         //
    --          2). rcvd clkout is sent with 1 + 2 serial std_logic = 3 latency  //
    --///////////////////////////////////////////////////////////////////////
    -- 2 serial std_logic latency
    
    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (srcvd_clk'EVENT AND srcvd_clk = '1');
        IF (reset = '1') THEN
            RCLK_PMA_int_sync1 <= '0';    
            RCLK_PMA_int_sync <= '0';    
        ELSE
            RCLK_PMA_int_sync1 <= RCLK_PMA_int;    
            RCLK_PMA_int_sync <= RCLK_PMA_int_sync1;    
        END IF;
    END PROCESS;
    --///////////////////////////////////////////////////////////////////////
    -- double pma width and pam width is 8 std_logic: ---------------------------//
    --                                                                     //
    --          walign_datain = {PUDI[17:10], PUDI[7:0]}                   //
    --///////////////////////////////////////////////////////////////////////
    paralleldataout_xhdl2 <= ddoutB & ddoutA ;
    recvclkout_xhdl1 <= ddclk_out ;
    temp_xhdl5 <= ddclk_by2 WHEN (rdoublewidth = '1') ELSE RCLK_PMA_int;
    ddclk_out <= temp_xhdl5 ;

    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (ddclk_out'EVENT AND ddclk_out = '1');
        IF (reset = '1' OR rdoublewidth = '0') THEN
            ddoutB <= "0000000000";    
        ELSE
            ddoutB <= PUDI;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (ddclk_out'EVENT AND ddclk_out = '1');
        IF (reset = '1') THEN
            ddoutA <= "0000000000";    
        ELSE
            ddoutA <= ddoutA_pre;    --  ddoutA_pre is negedge sampled
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (RCLK_PMA_phi'EVENT AND RCLK_PMA_phi = '1');
        IF (reset = '1') THEN
            ddclk_by2 <= '1';    --  on purpose
        ELSE
            ddclk_by2 <= NOT ddclk_by2;    
        END IF;
    END PROCESS;
    neg_ddclk_by2 <= NOT ddclk_by2 ;
    temp_xhdl6 <= neg_ddclk_by2 WHEN (rdoublewidth = '1') ELSE RCLK_PMA_phi;
    pre_reg_clk <= temp_xhdl6 ;

    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (pre_reg_clk'EVENT AND pre_reg_clk = '1');
        IF (reset = '1') THEN
            ddoutA_pre <= "0000000000";    
        ELSE
            ddoutA_pre <= PUDI;    
        END IF;
    END PROCESS;

END rx_des_arc;
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

--synthesis_resources = lut 140 mux21 128 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_rx_pipe_interface IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 latched_p0	:	IN  STD_LOGIC;
		 latched_p0s	:	IN  STD_LOGIC;
		 latched_p1	:	IN  STD_LOGIC;
		 latched_p2	:	IN  STD_LOGIC;
		 polinv_rx	:	IN  STD_LOGIC;
		 polinv_rx_int	:	OUT  STD_LOGIC;
		 rclkcmpinsertpad	:	IN  STD_LOGIC;
		 reset_n	:	IN  STD_LOGIC;
		 rrdwidth_rx	:	IN  STD_LOGIC;
		 rrx_pipe_enable	:	IN  STD_LOGIC;
		 rx_detect_valid	:	IN  STD_LOGIC;
		 rx_detect_valid_sync	:	IN  STD_LOGIC;
		 rx_found	:	IN  STD_LOGIC;
		 rxbeacon	:	IN  STD_LOGIC;
		 rxd	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rxd_ch	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rxelecidle	:	OUT  STD_LOGIC;
		 rxelectricalidle	:	IN  STD_LOGIC;
		 rxpolarity	:	IN  STD_LOGIC;
		 rxstatus	:	OUT  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxvalid	:	OUT  STD_LOGIC
	 ); 
 END stratixiigx_hssi_rx_pipe_interface;

 ARCHITECTURE RTL OF stratixiigx_hssi_rx_pipe_interface IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 nlllOi55	:	STD_LOGIC := '1';
	 SIGNAL	 nlllOi56	:	STD_LOGIC := '1';
	 SIGNAL	 nlllOi57	:	STD_LOGIC := '0';
	 SIGNAL	 nllO0l49	:	STD_LOGIC := '1';
	 SIGNAL	 nllO0l50	:	STD_LOGIC := '1';
	 SIGNAL	 nllO0l51	:	STD_LOGIC := '0';
	 SIGNAL	 nllO1l52	:	STD_LOGIC := '1';
	 SIGNAL	 nllO1l53	:	STD_LOGIC := '1';
	 SIGNAL	 nllO1l54	:	STD_LOGIC := '0';
	 SIGNAL	 nllOil46	:	STD_LOGIC := '1';
	 SIGNAL	 nllOil47	:	STD_LOGIC := '1';
	 SIGNAL	 nllOil48	:	STD_LOGIC := '0';
	 SIGNAL	 nllOlO43	:	STD_LOGIC := '1';
	 SIGNAL	 nllOlO44	:	STD_LOGIC := '1';
	 SIGNAL	 nllOlO45	:	STD_LOGIC := '0';
	 SIGNAL	 nllOOl40	:	STD_LOGIC := '1';
	 SIGNAL	 nllOOl41	:	STD_LOGIC := '1';
	 SIGNAL	 nllOOl42	:	STD_LOGIC := '0';
	 SIGNAL	 nlO01O22	:	STD_LOGIC := '1';
	 SIGNAL	 nlO01O23	:	STD_LOGIC := '1';
	 SIGNAL	 nlO01O24	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0il19	:	STD_LOGIC := '1';
	 SIGNAL	 nlO0il20	:	STD_LOGIC := '1';
	 SIGNAL	 nlO0il21	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0lO16	:	STD_LOGIC := '1';
	 SIGNAL	 nlO0lO17	:	STD_LOGIC := '1';
	 SIGNAL	 nlO0lO18	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0Ol13	:	STD_LOGIC := '1';
	 SIGNAL	 nlO0Ol14	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlO0Ol14_w_lg_Q91w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlO0Ol15	:	STD_LOGIC := '0';
	 SIGNAL	 nlO10O34	:	STD_LOGIC := '1';
	 SIGNAL	 nlO10O35	:	STD_LOGIC := '1';
	 SIGNAL	 nlO10O36	:	STD_LOGIC := '0';
	 SIGNAL	 nlO11l37	:	STD_LOGIC := '1';
	 SIGNAL	 nlO11l38	:	STD_LOGIC := '1';
	 SIGNAL	 nlO11l39	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1il31	:	STD_LOGIC := '1';
	 SIGNAL	 nlO1il32	:	STD_LOGIC := '1';
	 SIGNAL	 nlO1il33	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1lO28	:	STD_LOGIC := '1';
	 SIGNAL	 nlO1lO29	:	STD_LOGIC := '1';
	 SIGNAL	 nlO1lO30	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1OO25	:	STD_LOGIC := '1';
	 SIGNAL	 nlO1OO26	:	STD_LOGIC := '1';
	 SIGNAL	 nlO1OO27	:	STD_LOGIC := '0';
	 SIGNAL	 nlOi1l10	:	STD_LOGIC := '1';
	 SIGNAL	 nlOi1l11	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlOi1l11_w_lg_Q86w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOi1l12	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiii7	:	STD_LOGIC := '1';
	 SIGNAL	 nlOiii8	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlOiii8_w_lg_Q79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOiii9	:	STD_LOGIC := '0';
	 SIGNAL	 nlOill4	:	STD_LOGIC := '1';
	 SIGNAL	 nlOill5	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlOill5_w_lg_Q73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlOill6	:	STD_LOGIC := '0';
	 SIGNAL	 nlOiOl1	:	STD_LOGIC := '1';
	 SIGNAL	 nlOiOl2	:	STD_LOGIC := '1';
	 SIGNAL	 nlOiOl3	:	STD_LOGIC := '0';
	 SIGNAL	n100l	:	STD_LOGIC := '0';
	 SIGNAL	n100O	:	STD_LOGIC := '0';
	 SIGNAL	n10ii	:	STD_LOGIC := '0';
	 SIGNAL	n10il	:	STD_LOGIC := '0';
	 SIGNAL	n10O	:	STD_LOGIC := '0';
	 SIGNAL	n11ii	:	STD_LOGIC := '0';
	 SIGNAL	n11il	:	STD_LOGIC := '0';
	 SIGNAL	n11iO	:	STD_LOGIC := '0';
	 SIGNAL	n11l	:	STD_LOGIC := '0';
	 SIGNAL	n11Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1lii	:	STD_LOGIC := '0';
	 SIGNAL	n1liO	:	STD_LOGIC := '0';
	 SIGNAL	n1lll	:	STD_LOGIC := '0';
	 SIGNAL	n1O1i	:	STD_LOGIC := '0';
	 SIGNAL	niO0i	:	STD_LOGIC := '0';
	 SIGNAL	niO0l	:	STD_LOGIC := '0';
	 SIGNAL	niO0O	:	STD_LOGIC := '0';
	 SIGNAL	niO1l	:	STD_LOGIC := '0';
	 SIGNAL	niO1O	:	STD_LOGIC := '0';
	 SIGNAL	niOii	:	STD_LOGIC := '0';
	 SIGNAL	niOil	:	STD_LOGIC := '0';
	 SIGNAL	niOiO	:	STD_LOGIC := '0';
	 SIGNAL	niOli	:	STD_LOGIC := '0';
	 SIGNAL	niOll	:	STD_LOGIC := '0';
	 SIGNAL	niOlO	:	STD_LOGIC := '0';
	 SIGNAL	niOOi	:	STD_LOGIC := '0';
	 SIGNAL	niOOl	:	STD_LOGIC := '0';
	 SIGNAL	niOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl00i	:	STD_LOGIC := '0';
	 SIGNAL	nl00l	:	STD_LOGIC := '0';
	 SIGNAL	nl00O	:	STD_LOGIC := '0';
	 SIGNAL	nl01i	:	STD_LOGIC := '0';
	 SIGNAL	nl01l	:	STD_LOGIC := '0';
	 SIGNAL	nl01O	:	STD_LOGIC := '0';
	 SIGNAL	nl0ii	:	STD_LOGIC := '0';
	 SIGNAL	nl0il	:	STD_LOGIC := '0';
	 SIGNAL	nl0iO	:	STD_LOGIC := '0';
	 SIGNAL	nl0li	:	STD_LOGIC := '0';
	 SIGNAL	nl0ll	:	STD_LOGIC := '0';
	 SIGNAL	nl0lO	:	STD_LOGIC := '0';
	 SIGNAL	nl0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl0OO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10O	:	STD_LOGIC := '0';
	 SIGNAL	nl11i	:	STD_LOGIC := '0';
	 SIGNAL	nl11l	:	STD_LOGIC := '0';
	 SIGNAL	nl11O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1il	:	STD_LOGIC := '0';
	 SIGNAL	nl1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1li	:	STD_LOGIC := '0';
	 SIGNAL	nl1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1OO	:	STD_LOGIC := '0';
	 SIGNAL	nli0i	:	STD_LOGIC := '0';
	 SIGNAL	nli0l	:	STD_LOGIC := '0';
	 SIGNAL	nli0O	:	STD_LOGIC := '0';
	 SIGNAL	nli1i	:	STD_LOGIC := '0';
	 SIGNAL	nli1l	:	STD_LOGIC := '0';
	 SIGNAL	nli1O	:	STD_LOGIC := '0';
	 SIGNAL	nliii	:	STD_LOGIC := '0';
	 SIGNAL	nliil	:	STD_LOGIC := '0';
	 SIGNAL	nliiO	:	STD_LOGIC := '0';
	 SIGNAL	nlili	:	STD_LOGIC := '0';
	 SIGNAL	nlill	:	STD_LOGIC := '0';
	 SIGNAL	nlilO	:	STD_LOGIC := '0';
	 SIGNAL	nliOi	:	STD_LOGIC := '0';
	 SIGNAL	nliOl	:	STD_LOGIC := '0';
	 SIGNAL	nliOO	:	STD_LOGIC := '0';
	 SIGNAL	nll0i	:	STD_LOGIC := '0';
	 SIGNAL	nll0l	:	STD_LOGIC := '0';
	 SIGNAL	nll0O	:	STD_LOGIC := '0';
	 SIGNAL	nll1i	:	STD_LOGIC := '0';
	 SIGNAL	nll1l	:	STD_LOGIC := '0';
	 SIGNAL	nll1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOliO	:	STD_LOGIC := '0';
	 SIGNAL	nlOlli	:	STD_LOGIC := '0';
	 SIGNAL	nlOlll	:	STD_LOGIC := '0';
	 SIGNAL	nlOllO	:	STD_LOGIC := '0';
	 SIGNAL  wire_n10l_w_lg_n100l163w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n10l_w_lg_nlOliO221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_nlO0ll170w173w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlO10l229w232w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlO10l223w226w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rx_found164w167w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO0ll176w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO0ll170w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO10l229w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO10l223w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rx_found164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range51w255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range19w197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nllOli242w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO00l183w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO0li175w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO10i228w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rclkcmpinsertpad169w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rrdwidth_rx193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rrx_pipe_enable93w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range50w253w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range18w195w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nlllOO :	STD_LOGIC;
	 SIGNAL  nllO0i :	STD_LOGIC;
	 SIGNAL  nllO1i :	STD_LOGIC;
	 SIGNAL  nllOii :	STD_LOGIC;
	 SIGNAL  nllOli :	STD_LOGIC;
	 SIGNAL  nllOll :	STD_LOGIC;
	 SIGNAL  nlO00l :	STD_LOGIC;
	 SIGNAL  nlO00O :	STD_LOGIC;
	 SIGNAL  nlO01l :	STD_LOGIC;
	 SIGNAL  nlO0ii :	STD_LOGIC;
	 SIGNAL  nlO0li :	STD_LOGIC;
	 SIGNAL  nlO0ll :	STD_LOGIC;
	 SIGNAL  nlO10i :	STD_LOGIC;
	 SIGNAL  nlO10l :	STD_LOGIC;
	 SIGNAL  nlO11i :	STD_LOGIC;
	 SIGNAL  nlO1li :	STD_LOGIC;
	 SIGNAL  nlO1ll :	STD_LOGIC;
	 SIGNAL  nlO1Ol :	STD_LOGIC;
	 SIGNAL  nlOi0i :	STD_LOGIC;
	 SIGNAL  nlOi0l :	STD_LOGIC;
	 SIGNAL  nlOi0O :	STD_LOGIC;
	 SIGNAL  nlOi1i :	STD_LOGIC;
	 SIGNAL  nlOiiO :	STD_LOGIC;
	 SIGNAL  nlOili :	STD_LOGIC;
	 SIGNAL  nlOiOi :	STD_LOGIC;
	 SIGNAL  wire_w_rxd_range51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range18w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_lg_nlO0ll170w173w(0) <= wire_w_lg_nlO0ll170w(0) AND nlO0il20;
	wire_w_lg_w_lg_nlO10l229w232w(0) <= wire_w_lg_nlO10l229w(0) AND nllOOl41;
	wire_w_lg_w_lg_nlO10l223w226w(0) <= wire_w_lg_nlO10l223w(0) AND nlO11l38;
	wire_w_lg_w_lg_rx_found164w167w(0) <= wire_w_lg_rx_found164w(0) AND nlO0lO17;
	wire_w_lg_nlO0ll176w(0) <= nlO0ll AND wire_w_lg_nlO0li175w(0);
	wire_w_lg_nlO0ll170w(0) <= nlO0ll AND nlO0li;
	wire_w_lg_nlO10l229w(0) <= nlO10l AND wire_w_lg_nlO10i228w(0);
	wire_w_lg_nlO10l223w(0) <= nlO10l AND nlO10i;
	wire_w_lg_rx_found164w(0) <= rx_found AND rx_detect_valid_sync;
	wire_w_lg_w_rxd_range51w255w(0) <= wire_w_rxd_range51w(0) AND wire_w_lg_w_rxd_range50w253w(0);
	wire_w_lg_w_rxd_range19w197w(0) <= wire_w_rxd_range19w(0) AND wire_w_lg_w_rxd_range18w195w(0);
	wire_w_lg_nllOli242w(0) <= NOT nllOli;
	wire_w_lg_nlO00l183w(0) <= NOT nlO00l;
	wire_w_lg_nlO0li175w(0) <= NOT nlO0li;
	wire_w_lg_nlO10i228w(0) <= NOT nlO10i;
	wire_w_lg_rclkcmpinsertpad169w(0) <= NOT rclkcmpinsertpad;
	wire_w_lg_rrdwidth_rx193w(0) <= NOT rrdwidth_rx;
	wire_w_lg_rrx_pipe_enable93w(0) <= NOT rrx_pipe_enable;
	wire_w_lg_w_rxd_range50w253w(0) <= NOT wire_w_rxd_range50w(0);
	wire_w_lg_w_rxd_range18w195w(0) <= NOT wire_w_rxd_range18w(0);
	nlllOO <= ((NOT rxd(13)) AND wire_w_lg_w_rxd_range50w253w(0));
	nllO0i <= (rclkcmpinsertpad AND ((nlO10l AND wire_w_lg_nllOli242w(0)) AND nllO0l50));
	nllO1i <= wire_w_lg_w_rxd_range51w255w(0);
	nllOii <= (rclkcmpinsertpad AND ((nlO10l AND nllOli) AND nllOil47));
	nllOli <= (((((((rxd(0) AND rxd(1)) AND rxd(2)) AND (NOT rxd(3))) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7));
	nllOll <= ((wire_w_lg_rclkcmpinsertpad169w(0) AND wire_w_lg_w_lg_nlO10l229w232w(0)) AND nllOlO44);
	nlO00l <= ((((((((rxd(32) AND rxd(33)) AND rxd(34)) AND (NOT rxd(35))) AND rxd(36)) AND rxd(37)) AND rxd(38)) AND rxd(39)) AND nlO10O35);
	nlO00O <= (wire_w_lg_rclkcmpinsertpad169w(0) AND wire_w_lg_nlO0ll176w(0));
	nlO01l <= (rclkcmpinsertpad AND ((nlO0ll AND nlO00l) AND nlO01O23));
	nlO0ii <= (wire_w_lg_rclkcmpinsertpad169w(0) AND wire_w_lg_w_lg_nlO0ll170w173w(0));
	nlO0li <= ((((((((NOT rxd(32)) AND rxd(33)) AND rxd(34)) AND rxd(35)) AND rxd(36)) AND rxd(37)) AND rxd(38)) AND rxd(39));
	nlO0ll <= (((NOT rxd(45)) AND rxd(46)) AND nlO1il32);
	nlO10i <= (((((((((NOT rxd(0)) AND rxd(1)) AND rxd(2)) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND nlllOi56);
	nlO10l <= ((NOT rxd(13)) AND rxd(14));
	nlO11i <= (wire_w_lg_rclkcmpinsertpad169w(0) AND wire_w_lg_w_lg_nlO10l223w226w(0));
	nlO1li <= ((NOT rxd(45)) AND wire_w_lg_w_rxd_range18w195w(0));
	nlO1ll <= wire_w_lg_w_rxd_range19w197w(0);
	nlO1Ol <= (((nlO0ll AND wire_w_lg_nlO00l183w(0)) AND rclkcmpinsertpad) AND nlO1OO26);
	nlOi0i <= (n1liO OR n11il);
	nlOi0l <= (n10il OR nlOllO);
	nlOi0O <= ((n1lii OR n11ii) OR wire_nlOiii8_w_lg_Q79w(0));
	nlOi1i <= ((n10ii OR nlOlll) OR wire_nlOi1l11_w_lg_Q86w(0));
	nlOiiO <= (n1lll OR n11iO);
	nlOili <= ((n1O1i OR n11Oi) OR wire_nlOill5_w_lg_Q73w(0));
	nlOiOi <= '1';
	polinv_rx_int <= wire_n1ll_dataout;
	rxd_ch <= ( wire_nO_dataout & wire_nl_dataout & wire_ni_dataout & wire_nlO_dataout & wire_nll_dataout & wire_nli_dataout & wire_niO_dataout & wire_nil_dataout & wire_nii_dataout & wire_n0O_dataout & wire_n0l_dataout & wire_n0i_dataout & wire_n1O_dataout & wire_n1l_dataout & wire_n1i_dataout & wire_nlOO_dataout & wire_nlOl_dataout & wire_nlOi_dataout & wire_nllO_dataout & wire_nlll_dataout & wire_nlli_dataout & wire_nliO_dataout & wire_nlil_dataout & wire_nlii_dataout & wire_nl0O_dataout & wire_nl0l_dataout & wire_nl0i_dataout & wire_nl1O_dataout & wire_nl1l_dataout & wire_nl1i_dataout & wire_niOO_dataout & wire_niOl_dataout & wire_niOi_dataout & wire_nilO_dataout & wire_nill_dataout & wire_nili_dataout & wire_niiO_dataout & wire_niil_dataout & wire_niii_dataout & wire_ni0O_dataout & wire_ni0l_dataout & wire_ni0i_dataout & wire_ni1O_dataout & wire_ni1l_dataout & wire_ni1i_dataout & wire_n0OO_dataout & wire_n0Ol_dataout & wire_n0Oi_dataout & wire_n0lO_dataout & wire_n0ll_dataout & wire_n0li_dataout & wire_n0iO_dataout & wire_n0il_dataout & wire_n0ii_dataout & wire_n00O_dataout & wire_n00l_dataout & wire_n00i_dataout & wire_n01O_dataout & wire_n01l_dataout & wire_n01i_dataout & wire_n1OO_dataout & wire_n1Ol_dataout & wire_n1Oi_dataout & wire_n1lO_dataout);
	rxelecidle <= wire_n1iO_dataout;
	rxstatus <= ( wire_nlliO_dataout & wire_nllil_dataout & wire_nllii_dataout);
	rxvalid <= wire_n1li_dataout;
	wire_w_rxd_range51w(0) <= rxd(13);
	wire_w_rxd_range50w(0) <= rxd(14);
	wire_w_rxd_range19w(0) <= rxd(45);
	wire_w_rxd_range18w(0) <= rxd(46);
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlllOi55 <= nlllOi57;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlllOi56 <= (nlllOi57 XOR nlllOi55);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlllOi57 <= nlllOi55;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllO0l49 <= nllO0l51;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllO0l50 <= (nllO0l51 XOR nllO0l49);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllO0l51 <= nllO0l49;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllO1l52 <= nllO1l54;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllO1l53 <= (nllO1l54 XOR nllO1l52);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllO1l54 <= nllO1l52;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOil46 <= nllOil48;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOil47 <= (nllOil48 XOR nllOil46);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOil48 <= nllOil46;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOlO43 <= nllOlO45;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOlO44 <= (nllOlO45 XOR nllOlO43);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOlO45 <= nllOlO43;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOOl40 <= nllOOl42;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOOl41 <= (nllOOl42 XOR nllOOl40);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOOl42 <= nllOOl40;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO01O22 <= nlO01O24;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO01O23 <= (nlO01O24 XOR nlO01O22);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO01O24 <= nlO01O22;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0il19 <= nlO0il21;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0il20 <= (nlO0il21 XOR nlO0il19);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0il21 <= nlO0il19;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0lO16 <= nlO0lO18;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0lO17 <= (nlO0lO18 XOR nlO0lO16);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0lO18 <= nlO0lO16;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0Ol13 <= nlO0Ol15;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0Ol14 <= (nlO0Ol15 XOR nlO0Ol13);
		END IF;
	END PROCESS;
	wire_nlO0Ol14_w_lg_Q91w(0) <= NOT nlO0Ol14;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO0Ol15 <= nlO0Ol13;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO10O34 <= nlO10O36;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO10O35 <= (nlO10O36 XOR nlO10O34);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO10O36 <= nlO10O34;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO11l37 <= nlO11l39;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO11l38 <= (nlO11l39 XOR nlO11l37);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO11l39 <= nlO11l37;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1il31 <= nlO1il33;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1il32 <= (nlO1il33 XOR nlO1il31);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1il33 <= nlO1il31;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1lO28 <= nlO1lO30;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1lO29 <= (nlO1lO30 XOR nlO1lO28);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1lO30 <= nlO1lO28;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1OO25 <= nlO1OO27;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1OO26 <= (nlO1OO27 XOR nlO1OO25);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1OO27 <= nlO1OO25;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOi1l10 <= nlOi1l12;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOi1l11 <= (nlOi1l12 XOR nlOi1l10);
		END IF;
	END PROCESS;
	wire_nlOi1l11_w_lg_Q86w(0) <= NOT nlOi1l11;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOi1l12 <= nlOi1l10;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiii7 <= nlOiii9;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiii8 <= (nlOiii9 XOR nlOiii7);
		END IF;
	END PROCESS;
	wire_nlOiii8_w_lg_Q79w(0) <= NOT nlOiii8;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiii9 <= nlOiii7;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOill4 <= nlOill6;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOill5 <= (nlOill6 XOR nlOill4);
		END IF;
	END PROCESS;
	wire_nlOill5_w_lg_Q73w(0) <= NOT nlOill5;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOill6 <= nlOill4;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiOl1 <= nlOiOl3;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiOl2 <= (nlOiOl3 XOR nlOiOl1);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlOiOl3 <= nlOiOl1;
		END IF;
	END PROCESS;
	PROCESS (clk, reset_n)
	BEGIN
		IF (reset_n = '0') THEN
				n100l <= '0';
				n100O <= '0';
				n10ii <= '0';
				n10il <= '0';
				n10O <= '0';
				n11ii <= '0';
				n11il <= '0';
				n11iO <= '0';
				n11l <= '0';
				n11Oi <= '0';
				n1lii <= '0';
				n1liO <= '0';
				n1lll <= '0';
				n1O1i <= '0';
				niO0i <= '0';
				niO0l <= '0';
				niO0O <= '0';
				niO1l <= '0';
				niO1O <= '0';
				niOii <= '0';
				niOil <= '0';
				niOiO <= '0';
				niOli <= '0';
				niOll <= '0';
				niOlO <= '0';
				niOOi <= '0';
				niOOl <= '0';
				niOOO <= '0';
				nl00i <= '0';
				nl00l <= '0';
				nl00O <= '0';
				nl01i <= '0';
				nl01l <= '0';
				nl01O <= '0';
				nl0ii <= '0';
				nl0il <= '0';
				nl0iO <= '0';
				nl0li <= '0';
				nl0ll <= '0';
				nl0lO <= '0';
				nl0Oi <= '0';
				nl0Ol <= '0';
				nl0OO <= '0';
				nl10i <= '0';
				nl10l <= '0';
				nl10O <= '0';
				nl11i <= '0';
				nl11l <= '0';
				nl11O <= '0';
				nl1ii <= '0';
				nl1il <= '0';
				nl1iO <= '0';
				nl1li <= '0';
				nl1ll <= '0';
				nl1lO <= '0';
				nl1Oi <= '0';
				nl1Ol <= '0';
				nl1OO <= '0';
				nli0i <= '0';
				nli0l <= '0';
				nli0O <= '0';
				nli1i <= '0';
				nli1l <= '0';
				nli1O <= '0';
				nliii <= '0';
				nliil <= '0';
				nliiO <= '0';
				nlili <= '0';
				nlill <= '0';
				nlilO <= '0';
				nliOi <= '0';
				nliOl <= '0';
				nliOO <= '0';
				nll0i <= '0';
				nll0l <= '0';
				nll0O <= '0';
				nll1i <= '0';
				nll1l <= '0';
				nll1O <= '0';
				nlOliO <= '0';
				nlOlli <= '0';
				nlOlll <= '0';
				nlOllO <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n100l <= rx_detect_valid_sync;
				n100O <= wire_n10iO_dataout;
				n10ii <= wire_n10li_dataout;
				n10il <= wire_n10ll_dataout;
				n10O <= wire_n11O_dataout;
				n11ii <= wire_nlOO1i_dataout;
				n11il <= rxd(11);
				n11iO <= rxd(9);
				n11l <= rxpolarity;
				n11Oi <= wire_n11li_dataout;
				n1lii <= wire_n10lO_dataout;
				n1liO <= wire_n1lil_dataout;
				n1lll <= wire_n1lli_dataout;
				n1O1i <= wire_n1llO_dataout;
				niO0i <= rxd(1);
				niO0l <= rxd(2);
				niO0O <= rxd(3);
				niO1l <= wire_n1ii_dataout;
				niO1O <= rxd(0);
				niOii <= rxd(4);
				niOil <= rxd(5);
				niOiO <= rxd(6);
				niOli <= rxd(7);
				niOll <= rxd(8);
				niOlO <= rxd(9);
				niOOi <= rxd(10);
				niOOl <= rxd(11);
				niOOO <= rxd(12);
				nl00i <= rxd(31);
				nl00l <= rxd(32);
				nl00O <= rxd(33);
				nl01i <= rxd(28);
				nl01l <= rxd(29);
				nl01O <= rxd(30);
				nl0ii <= rxd(34);
				nl0il <= rxd(35);
				nl0iO <= rxd(36);
				nl0li <= rxd(37);
				nl0ll <= rxd(38);
				nl0lO <= rxd(39);
				nl0Oi <= rxd(40);
				nl0Ol <= rxd(41);
				nl0OO <= rxd(42);
				nl10i <= rxd(16);
				nl10l <= rxd(17);
				nl10O <= rxd(18);
				nl11i <= rxd(13);
				nl11l <= rxd(14);
				nl11O <= rxd(15);
				nl1ii <= rxd(19);
				nl1il <= rxd(20);
				nl1iO <= rxd(21);
				nl1li <= rxd(22);
				nl1ll <= rxd(23);
				nl1lO <= rxd(24);
				nl1Oi <= rxd(25);
				nl1Ol <= rxd(26);
				nl1OO <= rxd(27);
				nli0i <= rxd(46);
				nli0l <= rxd(47);
				nli0O <= rxd(48);
				nli1i <= rxd(43);
				nli1l <= rxd(44);
				nli1O <= rxd(45);
				nliii <= rxd(49);
				nliil <= rxd(50);
				nliiO <= rxd(51);
				nlili <= rxd(52);
				nlill <= rxd(53);
				nlilO <= rxd(54);
				nliOi <= rxd(55);
				nliOl <= rxd(56);
				nliOO <= rxd(57);
				nll0i <= rxd(61);
				nll0l <= rxd(62);
				nll0O <= rxd(63);
				nll1i <= rxd(58);
				nll1l <= rxd(59);
				nll1O <= rxd(60);
				nlOliO <= rx_detect_valid_sync;
				nlOlli <= wire_nlOlOi_dataout;
				nlOlll <= wire_nlOlOl_dataout;
				nlOllO <= wire_nlOlOO_dataout;
		END IF;
	END PROCESS;
	wire_n10l_w_lg_n100l163w(0) <= NOT n100l;
	wire_n10l_w_lg_nlOliO221w(0) <= NOT nlOliO;
	wire_n00i_dataout <= niOli WHEN rrx_pipe_enable = '1'  ELSE rxd(7);
	wire_n00l_dataout <= niOll WHEN rrx_pipe_enable = '1'  ELSE rxd(8);
	wire_n00O_dataout <= niOlO WHEN rrx_pipe_enable = '1'  ELSE rxd(9);
	wire_n01i_dataout <= niOii WHEN rrx_pipe_enable = '1'  ELSE rxd(4);
	wire_n01l_dataout <= niOil WHEN rrx_pipe_enable = '1'  ELSE rxd(5);
	wire_n01O_dataout <= niOiO WHEN rrx_pipe_enable = '1'  ELSE rxd(6);
	wire_n0i_dataout <= nlili WHEN rrx_pipe_enable = '1'  ELSE rxd(52);
	wire_n0ii_dataout <= niOOi WHEN rrx_pipe_enable = '1'  ELSE rxd(10);
	wire_n0il_dataout <= niOOl WHEN rrx_pipe_enable = '1'  ELSE rxd(11);
	wire_n0iO_dataout <= niOOO WHEN rrx_pipe_enable = '1'  ELSE rxd(12);
	wire_n0l_dataout <= nlill WHEN rrx_pipe_enable = '1'  ELSE rxd(53);
	wire_n0li_dataout <= nl11i WHEN rrx_pipe_enable = '1'  ELSE rxd(13);
	wire_n0ll_dataout <= nl11l WHEN rrx_pipe_enable = '1'  ELSE rxd(14);
	wire_n0lO_dataout <= nl11O WHEN rrx_pipe_enable = '1'  ELSE rxd(15);
	wire_n0O_dataout <= nlilO WHEN rrx_pipe_enable = '1'  ELSE rxd(54);
	wire_n0Oi_dataout <= nl10i WHEN rrx_pipe_enable = '1'  ELSE rxd(16);
	wire_n0Ol_dataout <= nl10l WHEN rrx_pipe_enable = '1'  ELSE rxd(17);
	wire_n0OO_dataout <= nl10O WHEN rrx_pipe_enable = '1'  ELSE rxd(18);
	wire_n10iO_dataout <= wire_n10Oi_dataout AND NOT(wire_w_lg_rrdwidth_rx193w(0));
	wire_n10li_dataout <= wire_n10Ol_dataout AND NOT(wire_w_lg_rrdwidth_rx193w(0));
	wire_n10ll_dataout <= wire_n10OO_dataout AND NOT(wire_w_lg_rrdwidth_rx193w(0));
	wire_n10lO_dataout <= wire_n1i1i_dataout AND NOT(wire_w_lg_rrdwidth_rx193w(0));
	wire_n10Oi_dataout <= wire_n1i1l_dataout AND NOT(nlO1li);
	wire_n10Ol_dataout <= nlO1ll AND NOT(nlO1li);
	wire_n10OO_dataout <= wire_n1i1O_dataout AND NOT(nlO1li);
	wire_n11li_dataout <= (wire_n10l_w_lg_nlOliO221w(0) AND wire_w_lg_rx_found164w(0)) AND latched_p1;
	wire_n11O_dataout <= rxelectricalidle AND NOT((rxbeacon AND latched_p2));
	wire_n1i_dataout <= nliii WHEN rrx_pipe_enable = '1'  ELSE rxd(49);
	wire_n1i0i_dataout <= wire_n1iii_dataout AND NOT(nlO1ll);
	wire_n1i0l_dataout <= wire_n1iil_dataout AND NOT(nlO0ii);
	wire_n1i0O_dataout <= wire_n1iiO_dataout OR nlO0ii;
	wire_n1i1i_dataout <= wire_n1i0i_dataout AND NOT(nlO1li);
	wire_n1i1l_dataout <= wire_n1i0l_dataout AND NOT(nlO1ll);
	wire_n1i1O_dataout <= wire_n1i0O_dataout AND NOT(nlO1ll);
	wire_n1ii_dataout <= ((rxd(10) AND rxd(42)) AND nlOiOl2) WHEN rrdwidth_rx = '1'  ELSE rxd(10);
	wire_n1iii_dataout <= wire_n1ili_dataout AND NOT(nlO0ii);
	wire_n1iil_dataout <= wire_n1ill_dataout OR nlO00O;
	wire_n1iiO_dataout <= nlO01l AND NOT(nlO00O);
	wire_n1ili_dataout <= wire_n1ilO_dataout AND NOT(nlO00O);
	wire_n1ill_dataout <= nlO1Ol AND NOT(nlO01l);
	wire_n1ilO_dataout <= wire_n1iOi_dataout AND NOT(nlO01l);
	wire_n1iO_dataout <= n10O WHEN rrx_pipe_enable = '1'  ELSE rxelectricalidle;
	wire_n1iOi_dataout <= ((rxd(45) AND rxd(46)) AND nlO1lO29) AND NOT(nlO1Ol);
	wire_n1l_dataout <= nliil WHEN rrx_pipe_enable = '1'  ELSE rxd(50);
	wire_n1li_dataout <= niO1l AND rrx_pipe_enable;
	wire_n1lil_dataout <= rxd(43) AND rrdwidth_rx;
	wire_n1ll_dataout <= n11l WHEN rrx_pipe_enable = '1'  ELSE polinv_rx;
	wire_n1lli_dataout <= rxd(41) AND rrdwidth_rx;
	wire_n1llO_dataout <= wire_n1lOi_dataout AND rrdwidth_rx;
	wire_n1lO_dataout <= niO1O WHEN rrx_pipe_enable = '1'  ELSE rxd(0);
	wire_n1lOi_dataout <= (wire_n10l_w_lg_n100l163w(0) AND wire_w_lg_w_lg_rx_found164w167w(0)) AND latched_p1;
	wire_n1O_dataout <= nliiO WHEN rrx_pipe_enable = '1'  ELSE rxd(51);
	wire_n1Oi_dataout <= niO0i WHEN rrx_pipe_enable = '1'  ELSE rxd(1);
	wire_n1Ol_dataout <= niO0l WHEN rrx_pipe_enable = '1'  ELSE rxd(2);
	wire_n1OO_dataout <= niO0O WHEN rrx_pipe_enable = '1'  ELSE rxd(3);
	wire_ni_dataout <= nll0i WHEN rrx_pipe_enable = '1'  ELSE rxd(61);
	wire_ni0i_dataout <= nl1li WHEN rrx_pipe_enable = '1'  ELSE rxd(22);
	wire_ni0l_dataout <= nl1ll WHEN rrx_pipe_enable = '1'  ELSE rxd(23);
	wire_ni0O_dataout <= nl1lO WHEN rrx_pipe_enable = '1'  ELSE rxd(24);
	wire_ni1i_dataout <= nl1ii WHEN rrx_pipe_enable = '1'  ELSE rxd(19);
	wire_ni1l_dataout <= nl1il WHEN rrx_pipe_enable = '1'  ELSE rxd(20);
	wire_ni1O_dataout <= nl1iO WHEN rrx_pipe_enable = '1'  ELSE rxd(21);
	wire_nii_dataout <= nliOi WHEN rrx_pipe_enable = '1'  ELSE rxd(55);
	wire_niii_dataout <= nl1Oi WHEN rrx_pipe_enable = '1'  ELSE rxd(25);
	wire_niil_dataout <= nl1Ol WHEN rrx_pipe_enable = '1'  ELSE rxd(26);
	wire_niiO_dataout <= nl1OO WHEN rrx_pipe_enable = '1'  ELSE rxd(27);
	wire_nil_dataout <= nliOl WHEN rrx_pipe_enable = '1'  ELSE rxd(56);
	wire_nili_dataout <= nl01i WHEN rrx_pipe_enable = '1'  ELSE rxd(28);
	wire_nill_dataout <= nl01l WHEN rrx_pipe_enable = '1'  ELSE rxd(29);
	wire_nilO_dataout <= nl01O WHEN rrx_pipe_enable = '1'  ELSE rxd(30);
	wire_niO_dataout <= nliOO WHEN rrx_pipe_enable = '1'  ELSE rxd(57);
	wire_niOi_dataout <= nl00i WHEN rrx_pipe_enable = '1'  ELSE rxd(31);
	wire_niOl_dataout <= nl00l WHEN rrx_pipe_enable = '1'  ELSE rxd(32);
	wire_niOO_dataout <= nl00O WHEN rrx_pipe_enable = '1'  ELSE rxd(33);
	wire_nl_dataout <= nll0l WHEN rrx_pipe_enable = '1'  ELSE rxd(62);
	wire_nl0i_dataout <= nl0li WHEN rrx_pipe_enable = '1'  ELSE rxd(37);
	wire_nl0l_dataout <= nl0ll WHEN rrx_pipe_enable = '1'  ELSE rxd(38);
	wire_nl0O_dataout <= nl0lO WHEN rrx_pipe_enable = '1'  ELSE rxd(39);
	wire_nl1i_dataout <= nl0ii WHEN rrx_pipe_enable = '1'  ELSE rxd(34);
	wire_nl1l_dataout <= nl0il WHEN rrx_pipe_enable = '1'  ELSE rxd(35);
	wire_nl1O_dataout <= nl0iO WHEN rrx_pipe_enable = '1'  ELSE rxd(36);
	wire_nli_dataout <= nll1i WHEN rrx_pipe_enable = '1'  ELSE rxd(58);
	wire_nlii_dataout <= nl0Oi WHEN rrx_pipe_enable = '1'  ELSE rxd(40);
	wire_nlil_dataout <= nl0Ol WHEN rrx_pipe_enable = '1'  ELSE rxd(41);
	wire_nliO_dataout <= nl0OO WHEN rrx_pipe_enable = '1'  ELSE rxd(42);
	wire_nll_dataout <= nll1l WHEN rrx_pipe_enable = '1'  ELSE rxd(59);
	wire_nlli_dataout <= nli1i WHEN rrx_pipe_enable = '1'  ELSE rxd(43);
	wire_nllii_dataout <= rx_found WHEN wire_w_lg_rrx_pipe_enable93w(0) = '1'  ELSE wire_nllli_dataout;
	wire_nllil_dataout <= rx_detect_valid WHEN wire_w_lg_rrx_pipe_enable93w(0) = '1'  ELSE wire_nllll_dataout;
	wire_nlliO_dataout <= rxbeacon WHEN wire_w_lg_rrx_pipe_enable93w(0) = '1'  ELSE wire_nlllO_dataout;
	wire_nlll_dataout <= nli1l WHEN rrx_pipe_enable = '1'  ELSE rxd(44);
	wire_nllli_dataout <= wire_nllOi_dataout OR nlOili;
	wire_nllll_dataout <= wire_nllOl_dataout OR nlOili;
	wire_nlllO_dataout <= wire_nllOO_dataout AND NOT(nlOili);
	wire_nllO_dataout <= nli1O WHEN rrx_pipe_enable = '1'  ELSE rxd(45);
	wire_nllOi_dataout <= wire_nlO1i_dataout AND NOT(nlOiiO);
	wire_nllOl_dataout <= wire_nlO1l_dataout AND NOT(nlOiiO);
	wire_nllOO_dataout <= wire_nlO1O_dataout OR nlOiiO;
	wire_nlO_dataout <= nll1O WHEN rrx_pipe_enable = '1'  ELSE rxd(60);
	wire_nlO0i_dataout <= wire_nlOii_dataout AND NOT(nlOi0l);
	wire_nlO0l_dataout <= wire_nlOil_dataout OR nlOi0l;
	wire_nlO0O_dataout <= nlOi0i OR nlOi0l;
	wire_nlO1i_dataout <= wire_nlO0i_dataout OR nlOi0O;
	wire_nlO1l_dataout <= wire_nlO0l_dataout AND NOT(nlOi0O);
	wire_nlO1O_dataout <= wire_nlO0O_dataout OR nlOi0O;
	wire_nlOi_dataout <= nli0i WHEN rrx_pipe_enable = '1'  ELSE rxd(46);
	wire_nlOii_dataout <= wire_nlOiO_dataout OR nlOi0i;
	wire_nlOil_dataout <= nlOi1i OR nlOi0i;
	wire_nlOiO_dataout <= ((n100O OR nlOlli) OR wire_nlO0Ol14_w_lg_Q91w(0)) AND NOT(nlOi1i);
	wire_nlOl_dataout <= nli0l WHEN rrx_pipe_enable = '1'  ELSE rxd(47);
	wire_nlOlOi_dataout <= wire_nlOO1l_dataout AND NOT(nlllOO);
	wire_nlOlOl_dataout <= nllO1i AND NOT(nlllOO);
	wire_nlOlOO_dataout <= wire_nlOO1O_dataout AND NOT(nlllOO);
	wire_nlOO_dataout <= nli0O WHEN rrx_pipe_enable = '1'  ELSE rxd(48);
	wire_nlOO0i_dataout <= wire_nlOOii_dataout AND NOT(nllO1i);
	wire_nlOO0l_dataout <= wire_nlOOil_dataout AND NOT(nlO11i);
	wire_nlOO0O_dataout <= wire_nlOOiO_dataout OR nlO11i;
	wire_nlOO1i_dataout <= wire_nlOO0i_dataout AND NOT(nlllOO);
	wire_nlOO1l_dataout <= wire_nlOO0l_dataout AND NOT(nllO1i);
	wire_nlOO1O_dataout <= wire_nlOO0O_dataout AND NOT(nllO1i);
	wire_nlOOii_dataout <= wire_nlOOli_dataout AND NOT(nlO11i);
	wire_nlOOil_dataout <= wire_nlOOll_dataout OR nllOll;
	wire_nlOOiO_dataout <= nllOii AND NOT(nllOll);
	wire_nlOOli_dataout <= wire_nlOOlO_dataout AND NOT(nllOll);
	wire_nlOOll_dataout <= nllO0i AND NOT(nllOii);
	wire_nlOOlO_dataout <= wire_nlOOOi_dataout AND NOT(nllOii);
	wire_nlOOOi_dataout <= ((rxd(13) AND rxd(14)) AND nllO1l53) AND NOT(nllO0i);
	wire_nO_dataout <= nll0O WHEN rrx_pipe_enable = '1'  ELSE rxd(63);

 END RTL; --stratixiigx_hssi_rx_pipe_interface
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

--synthesis_resources = lut 70 mux21 7 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_phystatus_generator IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 latched_p0	:	IN  STD_LOGIC;
		 latched_p0s	:	IN  STD_LOGIC;
		 latched_p1	:	IN  STD_LOGIC;
		 latched_p2	:	IN  STD_LOGIC;
		 phystat_ena	:	IN  STD_LOGIC;
		 phystatus	:	OUT  STD_LOGIC;
		 power_state_transition_done	:	IN  STD_LOGIC;
		 power_state_transition_done_ena	:	IN  STD_LOGIC;
		 powerdown	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 reset_n	:	IN  STD_LOGIC;
		 rphystatus_rst_toggle	:	IN  STD_LOGIC;
		 rx_detect_valid	:	IN  STD_LOGIC
	 ); 
 END stratixiigx_hssi_phystatus_generator;

 ARCHITECTURE RTL OF stratixiigx_hssi_phystatus_generator IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 nliiO31	:	STD_LOGIC := '1';
	 SIGNAL	 nliiO32	:	STD_LOGIC := '1';
	 SIGNAL	 nliiO33	:	STD_LOGIC := '0';
	 SIGNAL	 nlill28	:	STD_LOGIC := '1';
	 SIGNAL	 nlill29	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlill29_w_lg_Q73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlill30	:	STD_LOGIC := '0';
	 SIGNAL	 nliOi25	:	STD_LOGIC := '1';
	 SIGNAL	 nliOi26	:	STD_LOGIC := '1';
	 SIGNAL  wire_nliOi26_w_lg_Q66w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliOi27	:	STD_LOGIC := '0';
	 SIGNAL	 nll0O16	:	STD_LOGIC := '1';
	 SIGNAL	 nll0O17	:	STD_LOGIC := '1';
	 SIGNAL	 nll0O18	:	STD_LOGIC := '0';
	 SIGNAL	 nll1i22	:	STD_LOGIC := '1';
	 SIGNAL	 nll1i23	:	STD_LOGIC := '1';
	 SIGNAL	 nll1i24	:	STD_LOGIC := '0';
	 SIGNAL	 nll1O19	:	STD_LOGIC := '1';
	 SIGNAL	 nll1O20	:	STD_LOGIC := '1';
	 SIGNAL	 nll1O21	:	STD_LOGIC := '0';
	 SIGNAL	 nllil13	:	STD_LOGIC := '1';
	 SIGNAL	 nllil14	:	STD_LOGIC := '1';
	 SIGNAL	 nllil15	:	STD_LOGIC := '0';
	 SIGNAL	 nllli10	:	STD_LOGIC := '1';
	 SIGNAL	 nllli11	:	STD_LOGIC := '1';
	 SIGNAL	 nllli12	:	STD_LOGIC := '0';
	 SIGNAL	 nllOi7	:	STD_LOGIC := '1';
	 SIGNAL	 nllOi8	:	STD_LOGIC := '1';
	 SIGNAL  wire_nllOi8_w_lg_Q17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nllOi9	:	STD_LOGIC := '0';
	 SIGNAL	 nllOO4	:	STD_LOGIC := '1';
	 SIGNAL	 nllOO5	:	STD_LOGIC := '1';
	 SIGNAL  wire_nllOO5_w_lg_Q10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nllOO6	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1l1	:	STD_LOGIC := '1';
	 SIGNAL	 nlO1l2	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlO1l2_w_lg_Q4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlO1l3	:	STD_LOGIC := '0';
	 SIGNAL	n01i	:	STD_LOGIC := '0';
	 SIGNAL	n01O	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1OO	:	STD_LOGIC := '0';
	 SIGNAL	ni1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1O	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni1l_w_lg_ni1i7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n00i	:	STD_LOGIC := '0';
	 SIGNAL	n00l	:	STD_LOGIC := '0';
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n10i	:	STD_LOGIC := '0';
	 SIGNAL	n10l	:	STD_LOGIC := '0';
	 SIGNAL	n10O	:	STD_LOGIC := '0';
	 SIGNAL	n11i	:	STD_LOGIC := '0';
	 SIGNAL	n11l	:	STD_LOGIC := '0';
	 SIGNAL	n11O	:	STD_LOGIC := '0';
	 SIGNAL	n1il	:	STD_LOGIC := '0';
	 SIGNAL	n1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1li	:	STD_LOGIC := '0';
	 SIGNAL	n1ll	:	STD_LOGIC := '0';
	 SIGNAL	n1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi	:	STD_LOGIC := '0';
	 SIGNAL	ni0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0l	:	STD_LOGIC := '0';
	 SIGNAL	niiO	:	STD_LOGIC := '0';
	 SIGNAL	nili	:	STD_LOGIC := '0';
	 SIGNAL	nill	:	STD_LOGIC := '0';
	 SIGNAL	nilO	:	STD_LOGIC := '0';
	 SIGNAL	niOO	:	STD_LOGIC := '0';
	 SIGNAL	nl0l	:	STD_LOGIC := '0';
	 SIGNAL	nl1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOOO	:	STD_LOGIC := '0';
	 SIGNAL  wire_nl0i_w_lg_w_lg_w_lg_w_lg_w_lg_n00i43w44w45w46w49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_w_lg_w_lg_w_lg_n00i43w54w55w56w59w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_w_lg_w_lg_n00i43w44w45w46w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_w_lg_w_lg_n00i43w54w55w56w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_w_lg_n00i43w44w45w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_w_lg_n00i43w44w51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_w_lg_n00i43w54w55w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_nilO25w28w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_n00i43w44w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_n00i43w54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_n00i38w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_ni0l13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_nilO25w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_n00i43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_n00l41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_n00O39w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_n0ii37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_nill24w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_nl1l19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_w_lg_nl1i1w5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_ni0i14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_nili6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl0i_w_lg_nl1i1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlil_w_lg_dataout12w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_power_state_transition_done_ena81w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nliOO :	STD_LOGIC;
	 SIGNAL  nll0l :	STD_LOGIC;
	 SIGNAL  nlllO :	STD_LOGIC;
 BEGIN

	wire_w_lg_power_state_transition_done_ena81w(0) <= NOT power_state_transition_done_ena;
	nliOO <= (((((wire_nl0i_w_lg_n00i38w(0) AND wire_nl0i_w_lg_n00O39w(0)) AND wire_nl0i_w_lg_n00l41w(0)) OR wire_nl0i_w_lg_w_lg_w_lg_w_lg_w_lg_n00i43w44w45w46w49w(0)) OR (wire_nl0i_w_lg_w_lg_w_lg_n00i43w44w51w(0) AND wire_nl0i_w_lg_n00l41w(0))) OR wire_nl0i_w_lg_w_lg_w_lg_w_lg_w_lg_n00i43w54w55w56w59w(0));
	nll0l <= '0';
	nlllO <= '1';
	phystatus <= wire_nlll_dataout;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nliiO31 <= nliiO33;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nliiO32 <= (nliiO33 XOR nliiO31);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nliiO33 <= nliiO31;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlill28 <= nlill30;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlill29 <= (nlill30 XOR nlill28);
		END IF;
	END PROCESS;
	wire_nlill29_w_lg_Q73w(0) <= NOT nlill29;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlill30 <= nlill28;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nliOi25 <= nliOi27;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nliOi26 <= (nliOi27 XOR nliOi25);
		END IF;
	END PROCESS;
	wire_nliOi26_w_lg_Q66w(0) <= NOT nliOi26;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nliOi27 <= nliOi25;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nll0O16 <= nll0O18;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nll0O17 <= (nll0O18 XOR nll0O16);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nll0O18 <= nll0O16;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nll1i22 <= nll1i24;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nll1i23 <= (nll1i24 XOR nll1i22);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nll1i24 <= nll1i22;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nll1O19 <= nll1O21;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nll1O20 <= (nll1O21 XOR nll1O19);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nll1O21 <= nll1O19;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllil13 <= nllil15;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllil14 <= (nllil15 XOR nllil13);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllil15 <= nllil13;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllli10 <= nllli12;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllli11 <= (nllli12 XOR nllli10);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllli12 <= nllli10;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOi7 <= nllOi9;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOi8 <= (nllOi9 XOR nllOi7);
		END IF;
	END PROCESS;
	wire_nllOi8_w_lg_Q17w(0) <= NOT nllOi8;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOi9 <= nllOi7;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOO4 <= nllOO6;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOO5 <= (nllOO6 XOR nllOO4);
		END IF;
	END PROCESS;
	wire_nllOO5_w_lg_Q10w(0) <= NOT nllOO5;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nllOO6 <= nllOO4;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1l1 <= nlO1l3;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1l2 <= (nlO1l3 XOR nlO1l1);
		END IF;
	END PROCESS;
	wire_nlO1l2_w_lg_Q4w(0) <= NOT nlO1l2;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN nlO1l3 <= nlO1l1;
		END IF;
	END PROCESS;
	PROCESS (clk, reset_n)
	BEGIN
		IF (reset_n = '0') THEN
				n01i <= '0';
				n01O <= '0';
				n1Ol <= '0';
				n1OO <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
			IF (nliOO = '1') THEN
				n01i <= n00O;
				n01O <= n0ii;
				n1Ol <= n00i;
				n1OO <= n00l;
			END IF;
		END IF;
	END PROCESS;
	PROCESS (clk, reset_n)
	BEGIN
		IF (reset_n = '0') THEN
				ni1i <= '1';
				ni1O <= '1';
		ELSIF (clk = '1' AND clk'event) THEN
				ni1i <= wire_nl0O_dataout;
				ni1O <= nll0l;
		END IF;
	END PROCESS;
	wire_ni1l_w_lg_ni1i7w(0) <= ni1i OR wire_nl0i_w_lg_nili6w(0);
	PROCESS (clk, reset_n)
	BEGIN
		IF (reset_n = '0') THEN
				n00i <= '0';
				n00l <= '0';
				n00O <= '0';
				n0ii <= '0';
				n0il <= '0';
				n0iO <= '0';
				n0li <= '0';
				n10i <= '0';
				n10l <= '0';
				n10O <= '0';
				n11i <= '0';
				n11l <= '0';
				n11O <= '0';
				n1il <= '0';
				n1iO <= '0';
				n1li <= '0';
				n1ll <= '0';
				n1lO <= '0';
				n1Oi <= '0';
				ni0i <= '0';
				ni0l <= '0';
				niiO <= '0';
				nili <= '0';
				nill <= '0';
				nilO <= '0';
				niOO <= '0';
				nl0l <= '0';
				nl1i <= '0';
				nl1l <= '0';
				nl1O <= '0';
				nlOOO <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n00i <= n0il;
				n00l <= n0iO;
				n00O <= n0li;
				n0ii <= nlOOO;
				n0il <= latched_p0;
				n0iO <= latched_p0s;
				n0li <= latched_p1;
				n10i <= n10l;
				n10l <= n10O;
				n10O <= n1il;
				n11i <= n11l;
				n11l <= n11O;
				n11O <= n10i;
				n1il <= ((n1iO AND (phystat_ena AND wire_w_lg_power_state_transition_done_ena81w(0))) AND nliiO32);
				n1iO <= (NOT ((((NOT (n1Ol XOR n1li)) AND (NOT ((n1OO XOR n1ll) XOR wire_nliOi26_w_lg_Q66w(0)))) AND (NOT ((n01i XOR n1lO) XOR wire_nlill29_w_lg_Q73w(0)))) AND (NOT (n01O XOR n1Oi))));
				n1li <= n1Ol;
				n1ll <= n1OO;
				n1lO <= n01i;
				n1Oi <= n01O;
				ni0i <= wire_ni0O_dataout;
				ni0l <= niiO;
				niiO <= wire_nlil_dataout;
				nili <= ((wire_nl0i_w_lg_nill24w(0) AND wire_nl0i_w_lg_w_lg_nilO25w28w(0)) AND nllil14);
				nill <= rx_detect_valid;
				nilO <= niOO;
				niOO <= latched_p1;
				nl0l <= power_state_transition_done;
				nl1i <= wire_nliO_dataout;
				nl1l <= nl1O;
				nl1O <= nl0l;
				nlOOO <= latched_p2;
		END IF;
	END PROCESS;
	wire_nl0i_w_lg_w_lg_w_lg_w_lg_w_lg_n00i43w44w45w46w49w(0) <= wire_nl0i_w_lg_w_lg_w_lg_w_lg_n00i43w44w45w46w(0) AND nll1O20;
	wire_nl0i_w_lg_w_lg_w_lg_w_lg_w_lg_n00i43w54w55w56w59w(0) <= wire_nl0i_w_lg_w_lg_w_lg_w_lg_n00i43w54w55w56w(0) AND nll1i23;
	wire_nl0i_w_lg_w_lg_w_lg_w_lg_n00i43w44w45w46w(0) <= wire_nl0i_w_lg_w_lg_w_lg_n00i43w44w45w(0) AND n00l;
	wire_nl0i_w_lg_w_lg_w_lg_w_lg_n00i43w54w55w56w(0) <= wire_nl0i_w_lg_w_lg_w_lg_n00i43w54w55w(0) AND wire_nl0i_w_lg_n00l41w(0);
	wire_nl0i_w_lg_w_lg_w_lg_n00i43w44w45w(0) <= wire_nl0i_w_lg_w_lg_n00i43w44w(0) AND wire_nl0i_w_lg_n00O39w(0);
	wire_nl0i_w_lg_w_lg_w_lg_n00i43w44w51w(0) <= wire_nl0i_w_lg_w_lg_n00i43w44w(0) AND n00O;
	wire_nl0i_w_lg_w_lg_w_lg_n00i43w54w55w(0) <= wire_nl0i_w_lg_w_lg_n00i43w54w(0) AND wire_nl0i_w_lg_n00O39w(0);
	wire_nl0i_w_lg_w_lg_nilO25w28w(0) <= wire_nl0i_w_lg_nilO25w(0) AND nllli11;
	wire_nl0i_w_lg_w_lg_n00i43w44w(0) <= wire_nl0i_w_lg_n00i43w(0) AND wire_nl0i_w_lg_n0ii37w(0);
	wire_nl0i_w_lg_w_lg_n00i43w54w(0) <= wire_nl0i_w_lg_n00i43w(0) AND n0ii;
	wire_nl0i_w_lg_n00i38w(0) <= n00i AND wire_nl0i_w_lg_n0ii37w(0);
	wire_nl0i_w_lg_ni0l13w(0) <= ni0l AND wire_nlil_w_lg_dataout12w(0);
	wire_nl0i_w_lg_nilO25w(0) <= nilO AND rx_detect_valid;
	wire_nl0i_w_lg_n00i43w(0) <= NOT n00i;
	wire_nl0i_w_lg_n00l41w(0) <= NOT n00l;
	wire_nl0i_w_lg_n00O39w(0) <= NOT n00O;
	wire_nl0i_w_lg_n0ii37w(0) <= NOT n0ii;
	wire_nl0i_w_lg_nill24w(0) <= NOT nill;
	wire_nl0i_w_lg_nl1l19w(0) <= NOT nl1l;
	wire_nl0i_w_lg_w_lg_nl1i1w5w(0) <= wire_nl0i_w_lg_nl1i1w(0) OR wire_nlO1l2_w_lg_Q4w(0);
	wire_nl0i_w_lg_ni0i14w(0) <= ni0i OR wire_nl0i_w_lg_ni0l13w(0);
	wire_nl0i_w_lg_nili6w(0) <= nili OR wire_nl0i_w_lg_w_lg_nl1i1w5w(0);
	wire_nl0i_w_lg_nl1i1w(0) <= nl1i OR ni1O;
	wire_ni0O_dataout <= wire_niii_dataout OR ((wire_nlil_w_lg_dataout12w(0) AND niiO) AND nll0O17);
	wire_niii_dataout <= ni0i AND NOT(wire_nliO_dataout);
	wire_nl0O_dataout <= wire_nlii_dataout AND NOT(rphystatus_rst_toggle);
	wire_nlii_dataout <= ni1i AND NOT(wire_nliO_dataout);
	wire_nlil_dataout <= phystat_ena AND (powerdown(0) AND powerdown(1));
	wire_nlil_w_lg_dataout12w(0) <= NOT wire_nlil_dataout;
	wire_nliO_dataout <= (nl1O AND wire_nl0i_w_lg_nl1l19w(0)) WHEN power_state_transition_done_ena = '1'  ELSE n11i;
	wire_nlll_dataout <= (wire_ni1l_w_lg_ni1i7w(0) OR wire_nllOO5_w_lg_Q10w(0)) OR (wire_nl0i_w_lg_ni0i14w(0) OR wire_nllOi8_w_lg_Q17w(0));

 END RTL; --stratixiigx_hssi_phystatus_generator
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 88 mux21 56 oper_decoder 1 oper_selector 1 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_tx_pipe_interface IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 powerdown	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerstate	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 refclk_b	:	IN  STD_LOGIC;
		 refclk_b_reset_n	:	IN  STD_LOGIC;
		 reset_n	:	IN  STD_LOGIC;
		 rev_loopbk	:	OUT  STD_LOGIC;
		 revloopback	:	IN  STD_LOGIC;
		 rtx_elec_idle_delay	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rtx_pipe_enable	:	IN  STD_LOGIC;
		 tx_elec_idle	:	OUT  STD_LOGIC;
		 tx_elec_idle_comp	:	IN  STD_LOGIC;
		 txbeacon	:	OUT  STD_LOGIC;
		 txcompliance	:	IN  STD_LOGIC;
		 txd	:	OUT  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 txd_ch	:	IN  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 txdetectrx	:	OUT  STD_LOGIC;
		 txdetectrxloopback	:	IN  STD_LOGIC;
		 txelecidle	:	IN  STD_LOGIC
	 ); 
 END stratixiigx_hssi_tx_pipe_interface;

 ARCHITECTURE RTL OF stratixiigx_hssi_tx_pipe_interface IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 n0i0l22	:	STD_LOGIC := '1';
	 SIGNAL	 n0i0l23	:	STD_LOGIC := '1';
	 SIGNAL	 n0i0l24	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1i28	:	STD_LOGIC := '1';
	 SIGNAL	 n0i1i29	:	STD_LOGIC := '1';
	 SIGNAL	 n0i1i30	:	STD_LOGIC := '0';
	 SIGNAL	 n0i1O25	:	STD_LOGIC := '1';
	 SIGNAL	 n0i1O26	:	STD_LOGIC := '1';
	 SIGNAL	 n0i1O27	:	STD_LOGIC := '0';
	 SIGNAL	 n0iii19	:	STD_LOGIC := '1';
	 SIGNAL	 n0iii20	:	STD_LOGIC := '1';
	 SIGNAL	 n0iii21	:	STD_LOGIC := '0';
	 SIGNAL	 n0ill16	:	STD_LOGIC := '1';
	 SIGNAL	 n0ill17	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0ill17_w_lg_Q133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0ill18	:	STD_LOGIC := '0';
	 SIGNAL	 n0ilO13	:	STD_LOGIC := '1';
	 SIGNAL	 n0ilO14	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0ilO14_w_lg_Q127w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0ilO15	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOi10	:	STD_LOGIC := '1';
	 SIGNAL	 n0iOi11	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0iOi11_w_lg_Q122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0iOi12	:	STD_LOGIC := '0';
	 SIGNAL	 n0iOO7	:	STD_LOGIC := '1';
	 SIGNAL	 n0iOO8	:	STD_LOGIC := '1';
	 SIGNAL	 n0iOO9	:	STD_LOGIC := '0';
	 SIGNAL	 n0l0i1	:	STD_LOGIC := '1';
	 SIGNAL	 n0l0i2	:	STD_LOGIC := '1';
	 SIGNAL	 n0l0i3	:	STD_LOGIC := '0';
	 SIGNAL	 n0l1l4	:	STD_LOGIC := '1';
	 SIGNAL	 n0l1l5	:	STD_LOGIC := '1';
	 SIGNAL	 n0l1l6	:	STD_LOGIC := '0';
	 SIGNAL	n0Oii	:	STD_LOGIC := '0';
	 SIGNAL	n0Oil	:	STD_LOGIC := '0';
	 SIGNAL	n0OiO	:	STD_LOGIC := '0';
	 SIGNAL	n0Oli	:	STD_LOGIC := '0';
	 SIGNAL	n0OlO	:	STD_LOGIC := '0';
	 SIGNAL	n0OOl	:	STD_LOGIC := '0';
	 SIGNAL	wire_n0OOi_ENA	:	STD_LOGIC;
	 SIGNAL	ni0il	:	STD_LOGIC := '0';
	 SIGNAL	ni10l	:	STD_LOGIC := '0';
	 SIGNAL	ni11O	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni10i_w_lg_ni11O140w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n0lOi	:	STD_LOGIC := '0';
	 SIGNAL	n0lOl	:	STD_LOGIC := '0';
	 SIGNAL	n0lOO	:	STD_LOGIC := '0';
	 SIGNAL	n0O1i	:	STD_LOGIC := '0';
	 SIGNAL	ni01l	:	STD_LOGIC := '0';
	 SIGNAL	ni0iO	:	STD_LOGIC := '0';
	 SIGNAL	ni0Ol	:	STD_LOGIC := '0';
	 SIGNAL	ni0OO	:	STD_LOGIC := '0';
	 SIGNAL	ni1iO	:	STD_LOGIC := '0';
	 SIGNAL	nii0i	:	STD_LOGIC := '0';
	 SIGNAL	nii0l	:	STD_LOGIC := '0';
	 SIGNAL	nii0O	:	STD_LOGIC := '0';
	 SIGNAL	nii1i	:	STD_LOGIC := '0';
	 SIGNAL	nii1l	:	STD_LOGIC := '0';
	 SIGNAL	nii1O	:	STD_LOGIC := '0';
	 SIGNAL	niiii	:	STD_LOGIC := '0';
	 SIGNAL	niiil	:	STD_LOGIC := '0';
	 SIGNAL	niiiO	:	STD_LOGIC := '0';
	 SIGNAL	niili	:	STD_LOGIC := '0';
	 SIGNAL	niill	:	STD_LOGIC := '0';
	 SIGNAL	niilO	:	STD_LOGIC := '0';
	 SIGNAL	niiOi	:	STD_LOGIC := '0';
	 SIGNAL	niiOl	:	STD_LOGIC := '0';
	 SIGNAL	niiOO	:	STD_LOGIC := '0';
	 SIGNAL	nil0i	:	STD_LOGIC := '0';
	 SIGNAL	nil0l	:	STD_LOGIC := '0';
	 SIGNAL	nil0O	:	STD_LOGIC := '0';
	 SIGNAL	nil1i	:	STD_LOGIC := '0';
	 SIGNAL	nil1l	:	STD_LOGIC := '0';
	 SIGNAL	nil1O	:	STD_LOGIC := '0';
	 SIGNAL	nilii	:	STD_LOGIC := '0';
	 SIGNAL	nilil	:	STD_LOGIC := '0';
	 SIGNAL	niliO	:	STD_LOGIC := '0';
	 SIGNAL	nilli	:	STD_LOGIC := '0';
	 SIGNAL	nilll	:	STD_LOGIC := '0';
	 SIGNAL	nillO	:	STD_LOGIC := '0';
	 SIGNAL	nilOi	:	STD_LOGIC := '0';
	 SIGNAL	nilOl	:	STD_LOGIC := '0';
	 SIGNAL	nilOO	:	STD_LOGIC := '0';
	 SIGNAL	niO0i	:	STD_LOGIC := '0';
	 SIGNAL	niO0l	:	STD_LOGIC := '0';
	 SIGNAL	niO0O	:	STD_LOGIC := '0';
	 SIGNAL	niO1i	:	STD_LOGIC := '0';
	 SIGNAL	niO1l	:	STD_LOGIC := '0';
	 SIGNAL	niO1O	:	STD_LOGIC := '0';
	 SIGNAL	niOii	:	STD_LOGIC := '0';
	 SIGNAL	niOil	:	STD_LOGIC := '0';
	 SIGNAL	niOiO	:	STD_LOGIC := '0';
	 SIGNAL	niOll	:	STD_LOGIC := '0';
	 SIGNAL  wire_niOli_w_lg_ni01l107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOli_w_lg_ni0OO95w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlili_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni11l_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni11l_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni11l_w_o_range119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni11l_w_o_range124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni11l_w_o_range130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni11i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni11i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni11i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_powerdown_range143w146w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOl139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rtx_pipe_enable105w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_powerdown_range144w145w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n0iiO :	STD_LOGIC;
	 SIGNAL  n0ili :	STD_LOGIC;
	 SIGNAL  n0iOl :	STD_LOGIC;
	 SIGNAL  n0l0O :	STD_LOGIC;
	 SIGNAL  wire_w_powerdown_range143w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_powerdown_range144w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_powerdown_range143w146w(0) <= wire_w_powerdown_range143w(0) AND wire_w_lg_w_powerdown_range144w145w(0);
	wire_w_lg_n0iOl139w(0) <= NOT n0iOl;
	wire_w_lg_rtx_pipe_enable105w(0) <= NOT rtx_pipe_enable;
	wire_w_lg_w_powerdown_range144w145w(0) <= NOT wire_w_powerdown_range144w(0);
	n0iiO <= ((NOT powerdown(0)) AND wire_w_lg_w_powerdown_range144w145w(0));
	n0ili <= '0';
	n0iOl <= (n0OOl OR tx_elec_idle_comp);
	n0l0O <= '1';
	powerstate <= ( wire_ni00O_dataout & wire_ni00l_dataout & wire_ni00i_dataout & wire_ni01O_dataout);
	rev_loopbk <= wire_ni1OO_dataout;
	tx_elec_idle <= wire_ni1Ol_dataout;
	txbeacon <= wire_ni1li_dataout;
	txd <= ( wire_nlili_dataout & wire_nliiO_dataout & wire_nliil_dataout & wire_nliii_dataout & wire_nli0O_dataout & wire_nli0l_dataout & wire_nli0i_dataout & wire_nli1O_dataout & wire_nli1l_dataout & wire_nli1i_dataout & wire_nl0OO_dataout & wire_nl0Ol_dataout & wire_nl0Oi_dataout & wire_nl0lO_dataout & wire_nl0ll_dataout & wire_nl0li_dataout & wire_nl0iO_dataout & wire_nl0il_dataout & wire_nl0ii_dataout & wire_nl00O_dataout & wire_nl00l_dataout & wire_nl00i_dataout & wire_nl01O_dataout & wire_nl01l_dataout & wire_nl01i_dataout & wire_nl1OO_dataout & wire_nl1Ol_dataout & wire_nl1Oi_dataout & wire_nl1lO_dataout & wire_nl1ll_dataout & wire_nl1li_dataout & wire_nl1iO_dataout & wire_nl1il_dataout & wire_nl1ii_dataout & wire_nl10O_dataout & wire_nl10l_dataout & wire_nl10i_dataout & wire_nl11O_dataout & wire_nl11l_dataout & wire_nl11i_dataout & wire_niOOO_dataout & wire_niOOl_dataout & wire_niOOi_dataout & wire_niOlO_dataout);
	txdetectrx <= wire_ni1lO_dataout;
	wire_w_powerdown_range143w(0) <= powerdown(0);
	wire_w_powerdown_range144w(0) <= powerdown(1);
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0i0l22 <= n0i0l24;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0i0l23 <= (n0i0l24 XOR n0i0l22);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0i0l24 <= n0i0l22;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0i1i28 <= n0i1i30;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0i1i29 <= (n0i1i30 XOR n0i1i28);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0i1i30 <= n0i1i28;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0i1O25 <= n0i1O27;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0i1O26 <= (n0i1O27 XOR n0i1O25);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0i1O27 <= n0i1O25;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0iii19 <= n0iii21;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0iii20 <= (n0iii21 XOR n0iii19);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0iii21 <= n0iii19;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0ill16 <= n0ill18;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0ill17 <= (n0ill18 XOR n0ill16);
		END IF;
	END PROCESS;
	wire_n0ill17_w_lg_Q133w(0) <= n0ill17 AND wire_ni11l_w_o_range130w(0);
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0ill18 <= n0ill16;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0ilO13 <= n0ilO15;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0ilO14 <= (n0ilO15 XOR n0ilO13);
		END IF;
	END PROCESS;
	wire_n0ilO14_w_lg_Q127w(0) <= n0ilO14 AND wire_ni11l_w_o_range124w(0);
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0ilO15 <= n0ilO13;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0iOi10 <= n0iOi12;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0iOi11 <= (n0iOi12 XOR n0iOi10);
		END IF;
	END PROCESS;
	wire_n0iOi11_w_lg_Q122w(0) <= n0iOi11 AND wire_ni11l_w_o_range119w(0);
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0iOi12 <= n0iOi10;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0iOO7 <= n0iOO9;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0iOO8 <= (n0iOO9 XOR n0iOO7);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0iOO9 <= n0iOO7;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l0i1 <= n0l0i3;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l0i2 <= (n0l0i3 XOR n0l0i1);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l0i3 <= n0l0i1;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l1l4 <= n0l1l6;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l1l5 <= (n0l1l6 XOR n0l1l4);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l1l6 <= n0l1l4;
		END IF;
	END PROCESS;
	PROCESS (refclk_b, refclk_b_reset_n)
	BEGIN
		IF (refclk_b_reset_n = '0') THEN
				n0Oii <= '1';
				n0Oil <= '1';
				n0OiO <= '1';
				n0Oli <= '1';
				n0OlO <= '1';
		ELSIF (refclk_b = '1' AND refclk_b'event) THEN
				n0Oii <= n0Oil;
				n0Oil <= n0OiO;
				n0OiO <= n0Oli;
				n0Oli <= n0OlO;
				n0OlO <= n0iOl;
		END IF;
	END PROCESS;
	PROCESS (refclk_b, refclk_b_reset_n)
	BEGIN
		IF (refclk_b_reset_n = '0') THEN
				n0OOl <= '1';
		ELSIF (refclk_b = '1' AND refclk_b'event) THEN
			IF (wire_n0OOi_ENA = '1') THEN
				n0OOl <= n0ili;
			END IF;
		END IF;
	END PROCESS;
	wire_n0OOi_ENA <= (wire_ni10i_w_lg_ni11O140w(0) AND (n0OOl AND ni10l));
	PROCESS (clk, reset_n)
	BEGIN
		IF (reset_n = '0') THEN
				ni0il <= '1';
		ELSIF (clk = '1' AND clk'event) THEN
				ni0il <= txelecidle;
		END IF;
	END PROCESS;
	PROCESS (refclk_b, refclk_b_reset_n)
	BEGIN
		IF (refclk_b_reset_n = '0') THEN
				ni10l <= '0';
				ni11O <= '0';
		ELSIF (refclk_b = '1' AND refclk_b'event) THEN
				ni10l <= tx_elec_idle_comp;
				ni11O <= ni10l;
		END IF;
	END PROCESS;
	wire_ni10i_w_lg_ni11O140w(0) <= NOT ni11O;
	PROCESS (clk, reset_n)
	BEGIN
		IF (reset_n = '0') THEN
				n0lOi <= '0';
				n0lOl <= '0';
				n0lOO <= '0';
				n0O1i <= '0';
				ni01l <= '0';
				ni0iO <= '0';
				ni0Ol <= '0';
				ni0OO <= '0';
				ni1iO <= '0';
				nii0i <= '0';
				nii0l <= '0';
				nii0O <= '0';
				nii1i <= '0';
				nii1l <= '0';
				nii1O <= '0';
				niiii <= '0';
				niiil <= '0';
				niiiO <= '0';
				niili <= '0';
				niill <= '0';
				niilO <= '0';
				niiOi <= '0';
				niiOl <= '0';
				niiOO <= '0';
				nil0i <= '0';
				nil0l <= '0';
				nil0O <= '0';
				nil1i <= '0';
				nil1l <= '0';
				nil1O <= '0';
				nilii <= '0';
				nilil <= '0';
				niliO <= '0';
				nilli <= '0';
				nilll <= '0';
				nillO <= '0';
				nilOi <= '0';
				nilOl <= '0';
				nilOO <= '0';
				niO0i <= '0';
				niO0l <= '0';
				niO0O <= '0';
				niO1i <= '0';
				niO1l <= '0';
				niO1O <= '0';
				niOii <= '0';
				niOil <= '0';
				niOiO <= '0';
				niOll <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n0lOi <= ((rtx_pipe_enable AND n0iiO) AND n0i1i29);
				n0lOl <= ((rtx_pipe_enable AND (powerdown(0) AND powerdown(1))) AND n0i1O26);
				n0lOO <= (rtx_pipe_enable AND ((NOT powerdown(0)) AND powerdown(1)));
				n0O1i <= ((rtx_pipe_enable AND (wire_w_lg_w_powerdown_range143w146w(0) AND n0iii20)) AND n0i0l23);
				ni01l <= txelecidle;
				ni0iO <= txd_ch(43);
				ni0Ol <= wire_n0O0O_dataout;
				ni0OO <= txcompliance;
				ni1iO <= txdetectrxloopback;
				nii0i <= txd_ch(3);
				nii0l <= txd_ch(4);
				nii0O <= txd_ch(5);
				nii1i <= txd_ch(0);
				nii1l <= txd_ch(1);
				nii1O <= txd_ch(2);
				niiii <= txd_ch(6);
				niiil <= txd_ch(7);
				niiiO <= txd_ch(8);
				niili <= txd_ch(9);
				niill <= txd_ch(11);
				niilO <= txd_ch(12);
				niiOi <= txd_ch(13);
				niiOl <= txd_ch(14);
				niiOO <= txd_ch(15);
				nil0i <= txd_ch(19);
				nil0l <= txd_ch(20);
				nil0O <= txd_ch(21);
				nil1i <= txd_ch(16);
				nil1l <= txd_ch(17);
				nil1O <= txd_ch(18);
				nilii <= txd_ch(22);
				nilil <= txd_ch(23);
				niliO <= txd_ch(24);
				nilli <= txd_ch(25);
				nilll <= txd_ch(26);
				nillO <= txd_ch(27);
				nilOi <= txd_ch(28);
				nilOl <= txd_ch(29);
				nilOO <= txd_ch(30);
				niO0i <= txd_ch(36);
				niO0l <= txd_ch(37);
				niO0O <= txd_ch(38);
				niO1i <= txd_ch(33);
				niO1l <= txd_ch(34);
				niO1O <= txd_ch(35);
				niOii <= txd_ch(39);
				niOil <= txd_ch(40);
				niOiO <= txd_ch(41);
				niOll <= txd_ch(42);
		END IF;
	END PROCESS;
	wire_niOli_w_lg_ni01l107w(0) <= NOT ni01l;
	wire_niOli_w_lg_ni0OO95w(0) <= NOT ni0OO;
	wire_n0O0O_dataout <= rtx_pipe_enable AND n0iiO;
	wire_n0OOO_dataout <= n0OlO WHEN wire_w_lg_n0iOl139w(0) = '1'  ELSE wire_ni11i_o;
	wire_ni00i_dataout <= n0O1i AND rtx_pipe_enable;
	wire_ni00l_dataout <= n0lOO AND rtx_pipe_enable;
	wire_ni00O_dataout <= n0lOl AND rtx_pipe_enable;
	wire_ni01O_dataout <= n0lOi AND rtx_pipe_enable;
	wire_ni0li_dataout <= wire_ni0ll_dataout OR (ni0OO AND ni0Ol);
	wire_ni0ll_dataout <= niili AND NOT(((wire_niOli_w_lg_ni0OO95w(0) AND ni0Ol) AND n0l0i2));
	wire_ni1li_dataout <= ((wire_niOli_w_lg_ni01l107w(0) AND n0lOl) AND n0iOO8) AND NOT(wire_w_lg_rtx_pipe_enable105w(0));
	wire_ni1lO_dataout <= txdetectrxloopback WHEN wire_w_lg_rtx_pipe_enable105w(0) = '1'  ELSE (ni1iO AND n0lOO);
	wire_ni1Ol_dataout <= txelecidle WHEN wire_w_lg_rtx_pipe_enable105w(0) = '1'  ELSE wire_n0OOO_dataout;
	wire_ni1OO_dataout <= revloopback WHEN wire_w_lg_rtx_pipe_enable105w(0) = '1'  ELSE ((ni1iO AND n0lOi) AND n0l1l5);
	wire_niOlO_dataout <= nii1i WHEN rtx_pipe_enable = '1'  ELSE txd_ch(0);
	wire_niOOi_dataout <= nii1l WHEN rtx_pipe_enable = '1'  ELSE txd_ch(1);
	wire_niOOl_dataout <= nii1O WHEN rtx_pipe_enable = '1'  ELSE txd_ch(2);
	wire_niOOO_dataout <= nii0i WHEN rtx_pipe_enable = '1'  ELSE txd_ch(3);
	wire_nl00i_dataout <= nilii WHEN rtx_pipe_enable = '1'  ELSE txd_ch(22);
	wire_nl00l_dataout <= nilil WHEN rtx_pipe_enable = '1'  ELSE txd_ch(23);
	wire_nl00O_dataout <= niliO WHEN rtx_pipe_enable = '1'  ELSE txd_ch(24);
	wire_nl01i_dataout <= nil0i WHEN rtx_pipe_enable = '1'  ELSE txd_ch(19);
	wire_nl01l_dataout <= nil0l WHEN rtx_pipe_enable = '1'  ELSE txd_ch(20);
	wire_nl01O_dataout <= nil0O WHEN rtx_pipe_enable = '1'  ELSE txd_ch(21);
	wire_nl0ii_dataout <= nilli WHEN rtx_pipe_enable = '1'  ELSE txd_ch(25);
	wire_nl0il_dataout <= nilll WHEN rtx_pipe_enable = '1'  ELSE txd_ch(26);
	wire_nl0iO_dataout <= nillO WHEN rtx_pipe_enable = '1'  ELSE txd_ch(27);
	wire_nl0li_dataout <= nilOi WHEN rtx_pipe_enable = '1'  ELSE txd_ch(28);
	wire_nl0ll_dataout <= nilOl WHEN rtx_pipe_enable = '1'  ELSE txd_ch(29);
	wire_nl0lO_dataout <= nilOO WHEN rtx_pipe_enable = '1'  ELSE txd_ch(30);
	wire_nl0Oi_dataout <= txd_ch(31) AND NOT(rtx_pipe_enable);
	wire_nl0Ol_dataout <= ni0il WHEN rtx_pipe_enable = '1'  ELSE txd_ch(32);
	wire_nl0OO_dataout <= niO1i WHEN rtx_pipe_enable = '1'  ELSE txd_ch(33);
	wire_nl10i_dataout <= niiil WHEN rtx_pipe_enable = '1'  ELSE txd_ch(7);
	wire_nl10l_dataout <= niiiO WHEN rtx_pipe_enable = '1'  ELSE txd_ch(8);
	wire_nl10O_dataout <= wire_ni0li_dataout WHEN rtx_pipe_enable = '1'  ELSE txd_ch(9);
	wire_nl11i_dataout <= nii0l WHEN rtx_pipe_enable = '1'  ELSE txd_ch(4);
	wire_nl11l_dataout <= nii0O WHEN rtx_pipe_enable = '1'  ELSE txd_ch(5);
	wire_nl11O_dataout <= niiii WHEN rtx_pipe_enable = '1'  ELSE txd_ch(6);
	wire_nl1ii_dataout <= ni0il WHEN rtx_pipe_enable = '1'  ELSE txd_ch(10);
	wire_nl1il_dataout <= niill WHEN rtx_pipe_enable = '1'  ELSE txd_ch(11);
	wire_nl1iO_dataout <= niilO WHEN rtx_pipe_enable = '1'  ELSE txd_ch(12);
	wire_nl1li_dataout <= niiOi WHEN rtx_pipe_enable = '1'  ELSE txd_ch(13);
	wire_nl1ll_dataout <= niiOl WHEN rtx_pipe_enable = '1'  ELSE txd_ch(14);
	wire_nl1lO_dataout <= niiOO WHEN rtx_pipe_enable = '1'  ELSE txd_ch(15);
	wire_nl1Oi_dataout <= nil1i WHEN rtx_pipe_enable = '1'  ELSE txd_ch(16);
	wire_nl1Ol_dataout <= nil1l WHEN rtx_pipe_enable = '1'  ELSE txd_ch(17);
	wire_nl1OO_dataout <= nil1O WHEN rtx_pipe_enable = '1'  ELSE txd_ch(18);
	wire_nli0i_dataout <= niO0l WHEN rtx_pipe_enable = '1'  ELSE txd_ch(37);
	wire_nli0l_dataout <= niO0O WHEN rtx_pipe_enable = '1'  ELSE txd_ch(38);
	wire_nli0O_dataout <= niOii WHEN rtx_pipe_enable = '1'  ELSE txd_ch(39);
	wire_nli1i_dataout <= niO1l WHEN rtx_pipe_enable = '1'  ELSE txd_ch(34);
	wire_nli1l_dataout <= niO1O WHEN rtx_pipe_enable = '1'  ELSE txd_ch(35);
	wire_nli1O_dataout <= niO0i WHEN rtx_pipe_enable = '1'  ELSE txd_ch(36);
	wire_nliii_dataout <= niOil WHEN rtx_pipe_enable = '1'  ELSE txd_ch(40);
	wire_nliil_dataout <= niOiO WHEN rtx_pipe_enable = '1'  ELSE txd_ch(41);
	wire_nliiO_dataout <= niOll WHEN rtx_pipe_enable = '1'  ELSE txd_ch(42);
	wire_nlili_dataout <= ni0iO WHEN rtx_pipe_enable = '1'  ELSE txd_ch(43);
	wire_ni11l_i <= ( rtx_elec_idle_delay(1 DOWNTO 0));
	wire_ni11l_w_o_range119w(0) <= wire_ni11l_o(0);
	wire_ni11l_w_o_range124w(0) <= wire_ni11l_o(1);
	wire_ni11l_w_o_range130w(0) <= wire_ni11l_o(3);
	ni11l :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_ni11l_i,
		o => wire_ni11l_o
	  );
	wire_ni11i_data <= ( n0Oii & n0Oil & n0OiO & n0Oli);
	wire_ni11i_sel <= ( wire_n0ill17_w_lg_Q133w & wire_ni11l_o(2) & wire_n0ilO14_w_lg_Q127w & wire_n0iOi11_w_lg_Q122w);
	ni11i :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_ni11i_data,
		o => wire_ni11i_o,
		sel => wire_ni11i_sel
	  );

 END RTL; --stratixiigx_hssi_tx_pipe_interface
--synopsys translate_on
--VALID FILE
--************************************************************
-- Description:
-- pipe_interface_top
--
-- This is the top module for the PIPE Interface.
-- 
--************************************************************


LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.stratixiigx_hssi_rx_pipe_interface;
USE WORK.stratixiigx_hssi_tx_pipe_interface;
USE WORK.stratixiigx_hssi_phystatus_generator;

ENTITY stratixiigx_hssi_q_pipe_interface_top IS
    PORT (
        pipe_tx_clk             : IN std_logic;   
        pipe_rx_clk             : IN std_logic;   
        refclk_b                : IN std_logic;   
        tx_pipe_reset           : IN std_logic;   
        rx_pipe_reset           : IN std_logic;   
        refclk_b_reset          : IN std_logic;   
        -- CRAM 

        rtx_pipe_enable         : IN std_logic;   
        rrx_pipe_enable         : IN std_logic;   
        rrdwidth_rx             : IN std_logic;   
        rtx_elec_idle_delay     : IN std_logic_vector(1 DOWNTO 0);   
        rrx_detect_bypass       : IN std_logic;   
        rclkcmpinsertpad        : IN std_logic;   
        rphystatus_rst_toggle   : IN std_logic;   
        -- PLD - PIPE Interface
        -- TX PIPE Interface: Command 

        txdetectrxloopback      : IN std_logic;   
        txelecidle              : IN std_logic;   
        txcompliance            : IN std_logic;   
        powerdown               : IN std_logic_vector(1 DOWNTO 0);   
        -- TX PIPE Interface: Data

        txd_ch                  : IN std_logic_vector(43 DOWNTO 0);   
        -- RX PIPE Interface: Command/Status

        rxpolarity              : IN std_logic;   
        rxvalid                 : OUT std_logic;   
        rxelecidle              : OUT std_logic;   
        rxstatus                : OUT std_logic_vector(2 DOWNTO 0);   
        -- RX PIPE Interface: Data

        rxd_ch                  : OUT std_logic_vector(63 DOWNTO 0);   
        -- PHYStatus Generator

        phystatus               : OUT std_logic;   
        -- Commands

        revloopback             : IN std_logic;   
        polinv_rx               : IN std_logic;   
        -- PIPE - PCS Inteface
        -- TX PIPE Interface

        txd                     : OUT std_logic_vector(43 DOWNTO 0);   
        rev_loopbk              : OUT std_logic;   
        tx_elec_idle_comp       : IN std_logic;   
        -- RX PIPE Interface

        rxd                     : IN std_logic_vector(63 DOWNTO 0);   
        polinv_rx_int           : OUT std_logic;   
        -- PIPE - PMA Interface
        -- TX PIPE Interface

        tx_elec_idle            : OUT std_logic;   
        txdetectrx              : OUT std_logic;   
        powerstate              : OUT std_logic_vector(3 DOWNTO 0);   
        txbeacon                : OUT std_logic;   
        -- RX PIPE Interface

        rx_found                : IN std_logic;   
        rx_detect_valid         : IN std_logic;   
        rxelectricalidle        : IN std_logic;   
        rxbeacon                : IN std_logic;   
        -- General signals

        txdetectrxin            : IN std_logic;   -- shawn
        powerstatein            : IN std_logic_vector(3 DOWNTO 0);   -- shawn
        use_powerstatein        : IN std_logic;   -- shawn
        -- PHYStatus Generator

        power_state_transition_done: IN std_logic;   
        power_state_transition_done_ena: IN std_logic);   
END stratixiigx_hssi_q_pipe_interface_top;

ARCHITECTURE q_pipe_interface_top_arch OF stratixiigx_hssi_q_pipe_interface_top IS

    -- COMPONENT begin ---------------------------------------------------------------
    COMPONENT  stratixiigx_hssi_tx_pipe_interface
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 powerdown	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 powerstate	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 refclk_b	:	IN  STD_LOGIC;
		 refclk_b_reset_n	:	IN  STD_LOGIC;
		 reset_n	:	IN  STD_LOGIC;
		 rev_loopbk	:	OUT  STD_LOGIC;
		 revloopback	:	IN  STD_LOGIC;
		 rtx_elec_idle_delay	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rtx_pipe_enable	:	IN  STD_LOGIC;
		 tx_elec_idle	:	OUT  STD_LOGIC;
		 tx_elec_idle_comp	:	IN  STD_LOGIC;
		 txbeacon	:	OUT  STD_LOGIC;
		 txcompliance	:	IN  STD_LOGIC;
		 txd	:	OUT  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 txd_ch	:	IN  STD_LOGIC_VECTOR (43 DOWNTO 0);
		 txdetectrx	:	OUT  STD_LOGIC;
		 txdetectrxloopback	:	IN  STD_LOGIC;
		 txelecidle	:	IN  STD_LOGIC
	 ); 
    END COMPONENT;

    COMPONENT  stratixiigx_hssi_rx_pipe_interface 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 latched_p0	:	IN  STD_LOGIC;
		 latched_p0s	:	IN  STD_LOGIC;
		 latched_p1	:	IN  STD_LOGIC;
		 latched_p2	:	IN  STD_LOGIC;
		 polinv_rx	:	IN  STD_LOGIC;
		 polinv_rx_int	:	OUT  STD_LOGIC;
		 rclkcmpinsertpad	:	IN  STD_LOGIC;
		 reset_n	:	IN  STD_LOGIC;
		 rrdwidth_rx	:	IN  STD_LOGIC;
		 rrx_pipe_enable	:	IN  STD_LOGIC;
		 rx_detect_valid	:	IN  STD_LOGIC;
		 rx_detect_valid_sync	:	IN  STD_LOGIC;
		 rx_found	:	IN  STD_LOGIC;
		 rxbeacon	:	IN  STD_LOGIC;
		 rxd	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rxd_ch	:	OUT  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 rxelecidle	:	OUT  STD_LOGIC;
		 rxelectricalidle	:	IN  STD_LOGIC;
		 rxpolarity	:	IN  STD_LOGIC;
		 rxstatus	:	OUT  STD_LOGIC_VECTOR (2 DOWNTO 0);
		 rxvalid	:	OUT  STD_LOGIC
	 ); 
    END COMPONENT;

    COMPONENT  stratixiigx_hssi_phystatus_generator
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 latched_p0	:	IN  STD_LOGIC;
		 latched_p0s	:	IN  STD_LOGIC;
		 latched_p1	:	IN  STD_LOGIC;
		 latched_p2	:	IN  STD_LOGIC;
		 phystat_ena	:	IN  STD_LOGIC;
		 phystatus	:	OUT  STD_LOGIC;
		 power_state_transition_done	:	IN  STD_LOGIC;
		 power_state_transition_done_ena	:	IN  STD_LOGIC;
		 powerdown	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 reset_n	:	IN  STD_LOGIC;
		 rphystatus_rst_toggle	:	IN  STD_LOGIC;
		 rx_detect_valid	:	IN  STD_LOGIC
	 ); 
    END COMPONENT;

    -- COMPONENT end ---------------------------------------------------------------

    --********************************************************************************
    -- DECLARATIONS
    --********************************************************************************
    --********************************************************************************
    -- PARAMETERS
    --********************************************************************************
    SIGNAL phystat_ena              :  std_logic;   
    SIGNAL rx_detect_valid_reg_0    :  std_logic;   
    SIGNAL rx_detect_valid_reg_1    :  std_logic;   
    SIGNAL tx_pipe_reset_n          :  std_logic;   
    SIGNAL rx_pipe_reset_n          :  std_logic;   
    SIGNAL refclk_b_reset_n         :  std_logic;   --  reset for txelecidle_d_generator
    SIGNAL txdetectrx_reg_0         :  std_logic;   
    SIGNAL txdetectrx_reg_1         :  std_logic;   
    SIGNAL txdetectrx_reg_2         :  std_logic;   
    SIGNAL txdetectrx_reg_3         :  std_logic;   
    SIGNAL txdetectrx_reg_4         :  std_logic;   
    SIGNAL txdetectrx_reg_5         :  std_logic;   
    SIGNAL txdetectrx_reg_6         :  std_logic;   
    SIGNAL bypass_rx_found          :  std_logic;   
    SIGNAL bypass_rx_detect_valid   :  std_logic;   
    SIGNAL rx_found_int             :  std_logic;   
    SIGNAL rx_detect_valid_int      :  std_logic;   
    SIGNAL latched_p0               :  std_logic;   
    SIGNAL latched_p0s              :  std_logic;   
    SIGNAL latched_p1               :  std_logic;   
    SIGNAL latched_p2               :  std_logic;   
    SIGNAL temp_xhdl13              :  std_logic;   
    SIGNAL temp_xhdl14              :  std_logic;   
    SIGNAL temp_xhdl15              :  std_logic;   -- shawn
    SIGNAL temp_xhdl16              :  std_logic;   -- shawn;
    SIGNAL temp_xhdl17              :  std_logic;   -- shawn;
    SIGNAL temp_xhdl18              :  std_logic;   -- shawn;
    SIGNAL rxvalid_xhdl1            :  std_logic;   
    SIGNAL rxelecidle_xhdl2         :  std_logic;   
    SIGNAL rxstatus_xhdl3           :  std_logic_vector(2 DOWNTO 0);   
    SIGNAL rxd_ch_xhdl4             :  std_logic_vector(63 DOWNTO 0);   
    SIGNAL phystatus_xhdl5          :  std_logic;   
    SIGNAL txd_xhdl6                :  std_logic_vector(43 DOWNTO 0);   
    SIGNAL rev_loopbk_xhdl7         :  std_logic;   
    SIGNAL polinv_rx_int_xhdl8      :  std_logic;   
    SIGNAL tx_elec_idle_xhdl9       :  std_logic;   
    SIGNAL txdetectrx_xhdl10        :  std_logic;   
    SIGNAL powerstate_xhdl11        :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL txbeacon_xhdl12          :  std_logic;   

    SIGNAL tmp_txdetectrxin         :  std_logic;   -- shawn 

BEGIN
    rxvalid <= rxvalid_xhdl1;
    rxelecidle <= rxelecidle_xhdl2;
    rxstatus <= rxstatus_xhdl3;
    rxd_ch <= rxd_ch_xhdl4;
    phystatus <= phystatus_xhdl5;
    txd <= txd_xhdl6;
    rev_loopbk <= rev_loopbk_xhdl7;
    polinv_rx_int <= polinv_rx_int_xhdl8;
    tx_elec_idle <= tx_elec_idle_xhdl9;
    txdetectrx <= txdetectrx_xhdl10;
    powerstate <= powerstate_xhdl11;
    txbeacon <= txbeacon_xhdl12;

	tmp_txdetectrxin <= txdetectrxin WHEN (use_powerstatein = '1') ELSE txdetectrx_xhdl10;

    --********************************************************************************
    -- ASSIGN STATEMENTS
    --********************************************************************************
    phystat_ena <= rtx_pipe_enable OR rrx_pipe_enable ;
    tx_pipe_reset_n <= NOT tx_pipe_reset ;
    rx_pipe_reset_n <= NOT rx_pipe_reset ;
    refclk_b_reset_n <= NOT refclk_b_reset ;
    temp_xhdl13 <= bypass_rx_found WHEN rrx_detect_bypass = '1' ELSE rx_found;
    rx_found_int <= temp_xhdl13 ;
    temp_xhdl14 <= bypass_rx_detect_valid WHEN rrx_detect_bypass = '1' ELSE rx_detect_valid_reg_1;
    rx_detect_valid_int <= temp_xhdl14 ;
    temp_xhdl15 <= powerstatein(0) WHEN (use_powerstatein = '1') ELSE powerstate_xhdl11(0);
    latched_p0 <= temp_xhdl15 ;
    temp_xhdl16 <= powerstatein(1) WHEN (use_powerstatein = '1') ELSE powerstate_xhdl11(1);
    latched_p0s <= temp_xhdl16 ;
    temp_xhdl17 <= powerstatein(2) WHEN (use_powerstatein = '1') ELSE powerstate_xhdl11(2);
    latched_p1 <= temp_xhdl17 ;
    temp_xhdl18 <= powerstatein(3) WHEN (use_powerstatein = '1') ELSE powerstate_xhdl11(3);
    latched_p2 <= temp_xhdl18 ;
    
    --********************************************************************************
    -- SUBMODULE INSTANTIATIONS
    --********************************************************************************
    -- General signals
    -- CRAM 
    -- PLD - PIPE Interface
    -- TX PIPE Interface: Command
    -- TX PIPE Interface: Data
    -- Commands
    -- PIPE - PCS Inteface
    -- TX PIPE Interface
    -- PIPE - PMA Interface
    -- Central PCS

    tx_pipe_interface_inst : stratixiigx_hssi_tx_pipe_interface 
        PORT MAP (
            clk => pipe_tx_clk,
            refclk_b => refclk_b,
            reset_n => tx_pipe_reset_n,
            refclk_b_reset_n => refclk_b_reset_n,
            rtx_pipe_enable => rtx_pipe_enable,
            rtx_elec_idle_delay => rtx_elec_idle_delay,
            txdetectrxloopback => txdetectrxloopback,
            txelecidle => txelecidle,
            txcompliance => txcompliance,
            powerdown => powerdown,
            txd_ch => txd_ch,
            revloopback => revloopback,
            txd => txd_xhdl6,
            rev_loopbk => rev_loopbk_xhdl7,
            tx_elec_idle_comp => tx_elec_idle_comp,
            tx_elec_idle => tx_elec_idle_xhdl9,
            txdetectrx => txdetectrx_xhdl10,
            txbeacon => txbeacon_xhdl12,
            powerstate => powerstate_xhdl11);   
    
    
    -- General signals
    -- CRAM 
    -- PLD - PIPE Interface
    -- RX PIPE Interface: Command/Status
    -- RX PIPE Interface: Data
    -- Commands
    -- PIPE - PCS Inteface
    -- RX PIPE Interface
    -- Latched Power State Signals
    -- PIPE - PMA Interface
    -- TX PIPE Interface
    -- RX PIPE Interface

    rx_pipe_interface_inst : stratixiigx_hssi_rx_pipe_interface 
        PORT MAP (
            clk => pipe_rx_clk,
            reset_n => rx_pipe_reset_n,
            rrx_pipe_enable => rrx_pipe_enable,
            rrdwidth_rx => rrdwidth_rx,
            rclkcmpinsertpad => rclkcmpinsertpad,
            rxpolarity => rxpolarity,
            rxvalid => rxvalid_xhdl1,
            rxelecidle => rxelecidle_xhdl2,
            rxstatus => rxstatus_xhdl3,
            rxd_ch => rxd_ch_xhdl4,
            polinv_rx => polinv_rx,
            rxd => rxd,
            polinv_rx_int => polinv_rx_int_xhdl8,
            latched_p0 => latched_p0,
            latched_p0s => latched_p0s,
            latched_p1 => latched_p1,
            latched_p2 => latched_p2,
            rx_found => rx_found_int,
            rx_detect_valid => rx_detect_valid,
            rx_detect_valid_sync => rx_detect_valid_int,
            rxelectricalidle => rxelectricalidle,
            rxbeacon => rxbeacon);   
    
    
    -- General signals
    --CRAM
    -- PLD Interface
    -- Latched Power State Signals
    -- PMA interface
    -- TX PMA Interface
    -- RX PMA Interface

    phystatus_generator_inst : stratixiigx_hssi_phystatus_generator 
        PORT MAP (
            clk => pipe_rx_clk,
            reset_n => rx_pipe_reset_n,
            phystat_ena => phystat_ena,
            rphystatus_rst_toggle => rphystatus_rst_toggle,
            powerdown => powerdown,
            phystatus => phystatus_xhdl5,
            latched_p0 => latched_p0,
            latched_p0s => latched_p0s,
            latched_p1 => latched_p1,
            latched_p2 => latched_p2,
            rx_detect_valid => rx_detect_valid_int,
            power_state_transition_done => power_state_transition_done,
            power_state_transition_done_ena => power_state_transition_done_ena);   
    

    --********************************************************************************
    -- MAIN CODE 
    --********************************************************************************
    
    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            rx_detect_valid_reg_0 <= '0';    
        ELSE
            rx_detect_valid_reg_0 <= rx_detect_valid;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            rx_detect_valid_reg_1 <= '0';    
        ELSE
            rx_detect_valid_reg_1 <= rx_detect_valid_reg_0;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            txdetectrx_reg_0 <= '0';    
        ELSE
            txdetectrx_reg_0 <= tmp_txdetectrxin;   -- txdetectrx_xhdl10;  shawn  
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            txdetectrx_reg_1 <= '0';    
        ELSE
            txdetectrx_reg_1 <= txdetectrx_reg_0;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            txdetectrx_reg_2 <= '0';    
        ELSE
            txdetectrx_reg_2 <= txdetectrx_reg_1;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            txdetectrx_reg_3 <= '0';    
        ELSE
            txdetectrx_reg_3 <= txdetectrx_reg_2;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            txdetectrx_reg_4 <= '0';    
        ELSE
            txdetectrx_reg_4 <= txdetectrx_reg_3;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            txdetectrx_reg_5 <= '0';    
        ELSE
            txdetectrx_reg_5 <= txdetectrx_reg_4;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            txdetectrx_reg_6 <= '0';    
        ELSE
            txdetectrx_reg_6 <= txdetectrx_reg_5;    
        END IF;
    END PROCESS;

    PROCESS
    BEGIN
        WAIT UNTIL (pipe_rx_clk'EVENT AND pipe_rx_clk = '1') OR (rx_pipe_reset_n'EVENT AND rx_pipe_reset_n = '0');
        IF (NOT rx_pipe_reset_n = '1') THEN
            bypass_rx_found <= '0';    
            bypass_rx_detect_valid <= '0';    
        ELSE
            bypass_rx_found <= txdetectrx_reg_6;    
            bypass_rx_detect_valid <= txdetectrx_reg_6;    
        END IF;
    END PROCESS;
    -- Synchronize powerstate to rx clk domain
    --
    -- always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
    -- begin
    -- 	if (!rx_pipe_reset_n)
    -- 	begin
    -- 		powerstate_0	<= 1'b0;
    -- 		powerstate_1	<= 1'b0;
    -- 		powerstate_2	<= 1'b0;
    -- 		powerstate_3	<= 1'b0;
    -- 	end
    -- 	else
    -- 	begin
    -- 		powerstate_0	<= powerstate[0];
    -- 		powerstate_1	<= powerstate[1];
    -- 		powerstate_2	<= powerstate[2];
    -- 		powerstate_3	<= powerstate[3];
    -- 	end
    -- end
    -- always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
    -- begin
    -- 	if (!rx_pipe_reset_n)
    -- 	begin
    -- 		latched_p0	<= 1'b0;
    -- 		latched_p0s	<= 1'b0;
    -- 		latched_p1	<= 1'b0;
    -- 		latched_p2	<= 1'b0;
    -- 	end
    -- 	else
    -- 	begin
    -- 		latched_p0	<= powerstate_0;
    -- 		latched_p0s	<= powerstate_1;
    -- 		latched_p1	<= powerstate_2;
    -- 		latched_p2	<= powerstate_3;
    -- 	end
    -- end

END q_pipe_interface_top_arch;
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 160 mux21 608 oper_add 8 oper_decoder 4 oper_selector 41 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixiigx_hssi_rx_bist_ver IS 
	 PORT 
	 ( 
		 bistdone	:	OUT  STD_LOGIC;
		 bisterr	:	OUT  STD_LOGIC;
		 clk_2	:	IN  STD_LOGIC;
		 cur_state	:	OUT  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 err_ctl	:	OUT  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 err_data	:	OUT  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 prbs_done	:	IN  STD_LOGIC;
		 prbs_err	:	IN  STD_LOGIC;
		 rbist_clr_rx	:	IN  STD_LOGIC;
		 rbist_sel	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rbisten_rx	:	IN  STD_LOGIC;
		 rcxpat_chnl_sel	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 rdwidth_rx	:	IN  STD_LOGIC;
		 rpma_doublewidth_rx	:	IN  STD_LOGIC;
		 rpmadwidth_rx	:	IN  STD_LOGIC;
		 rxc	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rxd	:	IN  STD_LOGIC_VECTOR (63 DOWNTO 0);
		 selftest_done	:	OUT  STD_LOGIC;
		 selftest_err	:	OUT  STD_LOGIC;
		 soft_reset	:	IN  STD_LOGIC;
		 sync_status	:	IN  STD_LOGIC
	 ); 
 END stratixiigx_hssi_rx_bist_ver;

 ARCHITECTURE RTL OF stratixiigx_hssi_rx_bist_ver IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 n0liiO58	:	STD_LOGIC := '1';
	 SIGNAL	 n0liiO59	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0liiO59_w_lg_Q272w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0liiO60	:	STD_LOGIC := '0';
	 SIGNAL	 n0lili55	:	STD_LOGIC := '1';
	 SIGNAL	 n0lili56	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0lili56_w_lg_Q255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0lili57	:	STD_LOGIC := '0';
	 SIGNAL	 n0lill52	:	STD_LOGIC := '1';
	 SIGNAL	 n0lill53	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0lill53_w_lg_Q249w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0lill54	:	STD_LOGIC := '0';
	 SIGNAL	 n0lilO49	:	STD_LOGIC := '1';
	 SIGNAL	 n0lilO50	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0lilO50_w_lg_Q228w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0lilO51	:	STD_LOGIC := '0';
	 SIGNAL	 n0liOi46	:	STD_LOGIC := '1';
	 SIGNAL	 n0liOi47	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0liOi47_w_lg_Q224w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0liOi48	:	STD_LOGIC := '0';
	 SIGNAL	 n0liOl43	:	STD_LOGIC := '1';
	 SIGNAL	 n0liOl44	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0liOl44_w_lg_Q200w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0liOl45	:	STD_LOGIC := '0';
	 SIGNAL	 n0ll0i34	:	STD_LOGIC := '1';
	 SIGNAL	 n0ll0i35	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0ll0i35_w_lg_Q156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0ll0i36	:	STD_LOGIC := '0';
	 SIGNAL	 n0ll0O31	:	STD_LOGIC := '1';
	 SIGNAL	 n0ll0O32	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0ll0O32_w_lg_Q150w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0ll0O33	:	STD_LOGIC := '0';
	 SIGNAL	 n0ll1i40	:	STD_LOGIC := '1';
	 SIGNAL	 n0ll1i41	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0ll1i41_w_lg_Q189w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0ll1i42	:	STD_LOGIC := '0';
	 SIGNAL	 n0ll1O37	:	STD_LOGIC := '1';
	 SIGNAL	 n0ll1O38	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0ll1O38_w_lg_Q160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0ll1O39	:	STD_LOGIC := '0';
	 SIGNAL	 n0llOi28	:	STD_LOGIC := '1';
	 SIGNAL	 n0llOi29	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0llOi29_w_lg_Q141w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0llOi30	:	STD_LOGIC := '0';
	 SIGNAL	 n0O00i10	:	STD_LOGIC := '1';
	 SIGNAL	 n0O00i11	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0O00i11_w_lg_Q49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0O00i12	:	STD_LOGIC := '0';
	 SIGNAL	 n0O01l13	:	STD_LOGIC := '1';
	 SIGNAL	 n0O01l14	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0O01l14_w_lg_Q54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0O01l15	:	STD_LOGIC := '0';
	 SIGNAL	 n0O0ll7	:	STD_LOGIC := '1';
	 SIGNAL	 n0O0ll8	:	STD_LOGIC := '1';
	 SIGNAL	 n0O0ll9	:	STD_LOGIC := '0';
	 SIGNAL	 n0O0Oi4	:	STD_LOGIC := '1';
	 SIGNAL	 n0O0Oi5	:	STD_LOGIC := '1';
	 SIGNAL	 n0O0Oi6	:	STD_LOGIC := '0';
	 SIGNAL	 n0O0OO1	:	STD_LOGIC := '1';
	 SIGNAL	 n0O0OO2	:	STD_LOGIC := '1';
	 SIGNAL	 n0O0OO3	:	STD_LOGIC := '0';
	 SIGNAL	 n0O11l25	:	STD_LOGIC := '1';
	 SIGNAL	 n0O11l26	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0O11l26_w_lg_Q115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0O11l27	:	STD_LOGIC := '0';
	 SIGNAL	 n0O1il22	:	STD_LOGIC := '1';
	 SIGNAL	 n0O1il23	:	STD_LOGIC := '1';
	 SIGNAL	 n0O1il24	:	STD_LOGIC := '0';
	 SIGNAL	 n0O1Oi19	:	STD_LOGIC := '1';
	 SIGNAL	 n0O1Oi20	:	STD_LOGIC := '1';
	 SIGNAL	 n0O1Oi21	:	STD_LOGIC := '0';
	 SIGNAL	 n0O1OO16	:	STD_LOGIC := '1';
	 SIGNAL	 n0O1OO17	:	STD_LOGIC := '1';
	 SIGNAL	 n0O1OO18	:	STD_LOGIC := '0';
	 SIGNAL	ni00l	:	STD_LOGIC := '0';
	 SIGNAL	ni01O	:	STD_LOGIC := '0';
	 SIGNAL	nii0OO	:	STD_LOGIC := '0';
	 SIGNAL	niii0i	:	STD_LOGIC := '0';
	 SIGNAL	niii0l	:	STD_LOGIC := '0';
	 SIGNAL	niii0O	:	STD_LOGIC := '0';
	 SIGNAL	niii1i	:	STD_LOGIC := '0';
	 SIGNAL	niii1l	:	STD_LOGIC := '0';
	 SIGNAL	niii1O	:	STD_LOGIC := '0';
	 SIGNAL	niiiii	:	STD_LOGIC := '0';
	 SIGNAL	niiiil	:	STD_LOGIC := '0';
	 SIGNAL	niiiiO	:	STD_LOGIC := '0';
	 SIGNAL	niiili	:	STD_LOGIC := '0';
	 SIGNAL	niiill	:	STD_LOGIC := '0';
	 SIGNAL	niiilO	:	STD_LOGIC := '0';
	 SIGNAL	niiiOi	:	STD_LOGIC := '0';
	 SIGNAL	niiiOl	:	STD_LOGIC := '0';
	 SIGNAL	niiiOO	:	STD_LOGIC := '0';
	 SIGNAL	niil1i	:	STD_LOGIC := '0';
	 SIGNAL	niil1l	:	STD_LOGIC := '0';
	 SIGNAL	niil1O	:	STD_LOGIC := '0';
	 SIGNAL	niilii	:	STD_LOGIC := '0';
	 SIGNAL	niilil	:	STD_LOGIC := '0';
	 SIGNAL	nll1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nll1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n0OOOi	:	STD_LOGIC := '0';
	 SIGNAL	ni00O	:	STD_LOGIC := '0';
	 SIGNAL	ni01i	:	STD_LOGIC := '0';
	 SIGNAL	ni01l	:	STD_LOGIC := '0';
	 SIGNAL	ni0ii	:	STD_LOGIC := '0';
	 SIGNAL	ni0il	:	STD_LOGIC := '0';
	 SIGNAL	ni0iO	:	STD_LOGIC := '0';
	 SIGNAL	ni0li	:	STD_LOGIC := '0';
	 SIGNAL	ni0ll	:	STD_LOGIC := '0';
	 SIGNAL	ni0lO	:	STD_LOGIC := '0';
	 SIGNAL	ni0Oi	:	STD_LOGIC := '0';
	 SIGNAL	ni0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nii1i	:	STD_LOGIC := '0';
	 SIGNAL	niil0i	:	STD_LOGIC := '0';
	 SIGNAL	niil0l	:	STD_LOGIC := '0';
	 SIGNAL	niil0O	:	STD_LOGIC := '0';
	 SIGNAL	niiliO	:	STD_LOGIC := '0';
	 SIGNAL	niilli	:	STD_LOGIC := '0';
	 SIGNAL	niilll	:	STD_LOGIC := '0';
	 SIGNAL	niillO	:	STD_LOGIC := '0';
	 SIGNAL	niilOi	:	STD_LOGIC := '0';
	 SIGNAL	niilOl	:	STD_LOGIC := '0';
	 SIGNAL	niilOO	:	STD_LOGIC := '0';
	 SIGNAL	niiO0i	:	STD_LOGIC := '0';
	 SIGNAL	niiO0l	:	STD_LOGIC := '0';
	 SIGNAL	niiO0O	:	STD_LOGIC := '0';
	 SIGNAL	niiO1i	:	STD_LOGIC := '0';
	 SIGNAL	niiO1l	:	STD_LOGIC := '0';
	 SIGNAL	niiO1O	:	STD_LOGIC := '0';
	 SIGNAL	niiOii	:	STD_LOGIC := '0';
	 SIGNAL	niiOil	:	STD_LOGIC := '0';
	 SIGNAL	niiOiO	:	STD_LOGIC := '0';
	 SIGNAL	niiOli	:	STD_LOGIC := '0';
	 SIGNAL	niiOll	:	STD_LOGIC := '0';
	 SIGNAL	niiOlO	:	STD_LOGIC := '0';
	 SIGNAL	niiOOi	:	STD_LOGIC := '0';
	 SIGNAL	niiOOl	:	STD_LOGIC := '0';
	 SIGNAL	niiOOO	:	STD_LOGIC := '0';
	 SIGNAL	nil10i	:	STD_LOGIC := '0';
	 SIGNAL	nil10l	:	STD_LOGIC := '0';
	 SIGNAL	nil10O	:	STD_LOGIC := '0';
	 SIGNAL	nil11i	:	STD_LOGIC := '0';
	 SIGNAL	nil11l	:	STD_LOGIC := '0';
	 SIGNAL	nil11O	:	STD_LOGIC := '0';
	 SIGNAL	nil1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1lii	:	STD_LOGIC := '0';
	 SIGNAL	nll00i	:	STD_LOGIC := '0';
	 SIGNAL	nll00l	:	STD_LOGIC := '0';
	 SIGNAL	nll00O	:	STD_LOGIC := '0';
	 SIGNAL	nll01i	:	STD_LOGIC := '0';
	 SIGNAL	nll01l	:	STD_LOGIC := '0';
	 SIGNAL	nll01O	:	STD_LOGIC := '0';
	 SIGNAL	nll0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nll0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nll0OO	:	STD_LOGIC := '0';
	 SIGNAL	nll1ll	:	STD_LOGIC := '0';
	 SIGNAL	nll1lO	:	STD_LOGIC := '0';
	 SIGNAL	nll1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlli0i	:	STD_LOGIC := '0';
	 SIGNAL	nlli0l	:	STD_LOGIC := '0';
	 SIGNAL	nlli0O	:	STD_LOGIC := '0';
	 SIGNAL	nlli1i	:	STD_LOGIC := '0';
	 SIGNAL	nlli1l	:	STD_LOGIC := '0';
	 SIGNAL	nlli1O	:	STD_LOGIC := '0';
	 SIGNAL	nlliii	:	STD_LOGIC := '0';
	 SIGNAL	nlliil	:	STD_LOGIC := '0';
	 SIGNAL	nlliiO	:	STD_LOGIC := '0';
	 SIGNAL	nllili	:	STD_LOGIC := '0';
	 SIGNAL	nllill	:	STD_LOGIC := '0';
	 SIGNAL	nllilO	:	STD_LOGIC := '0';
	 SIGNAL	nlliOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOi	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_w1463w1464w1465w1466w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w1472w1473w1474w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w1463w1464w1465w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w1472w1473w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w1463w1464w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w1472w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w1463w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_w_lg_nllili1468w1469w1470w1471w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_w_lg_nlli1i1092w1094w1095w1096w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_w_lg_nllili1443w1459w1461w1462w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_ni0ll945w946w947w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_nlli1i1097w1098w1099w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_nllili1468w1469w1470w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_nlli1i1092w1094w1095w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_nllili1443w1445w1446w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_w_lg_nllili1443w1459w1461w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_ni0ll945w946w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_nlli1i1097w1098w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_nllili1468w1469w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_nll00O1548w1549w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_nlli1i1092w1094w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_nllili1443w1445w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_w_lg_nllili1443w1459w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_ni01i498w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_ni0ll945w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nll00O1557w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nll1ll1299w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlli1i1097w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nllili1468w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_ni00O152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_ni0ii948w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_niil0O2081w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nll00i1550w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nll00l1556w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nll00O1548w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nll01O1552w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nll0Oi1490w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nll0OO1093w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nll1OO1115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlli0i1453w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlli0l1451w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlli0O1449w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlli1i1092w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlli1l1457w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlli1O1455w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlliii1447w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlliil1460w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nlliiO1444w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0OO_w_lg_nllili1443w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nll0il	:	STD_LOGIC := '0';
	 SIGNAL	wire_nll0ii_ENA	:	STD_LOGIC;
	 SIGNAL	nll0li	:	STD_LOGIC := '0';
	 SIGNAL	wire_nll0iO_ENA	:	STD_LOGIC;
	 SIGNAL	nll0lO	:	STD_LOGIC := '0';
	 SIGNAL	wire_nll0ll_ENA	:	STD_LOGIC;
	 SIGNAL  wire_nll0ll_w_lg_nll0lO1507w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni_w_lg_dataout153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nililO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl_w_lg_dataout1116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlii_w_lg_dataout2040w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlil_w_lg_dataout807w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nliO_w_lg_dataout809w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nliO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlli_w_lg_dataout811w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlll_w_lg_w_lg_w_lg_dataout2422w2423w2424w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlll_w_lg_w_lg_dataout2422w2423w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlll_w_lg_dataout2422w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlll_w_lg_dataout777w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllO_w_lg_dataout813w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nllO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOi_w_lg_dataout779w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOl_w_lg_dataout815w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlOO_w_lg_dataout817w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nO_w_lg_dataout1708w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiOl_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niiOl_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_niiOl_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_niO1lO_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niO1lO_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niO1lO_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niO1Oi_a	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niO1Oi_b	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niO1Oi_o	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_niO1Ol_a	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niO1Ol_b	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_niO1Ol_o	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nlllOi_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlllOi_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlllOi_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlllOl_a	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlllOl_b	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlllOl_o	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nllOil_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOil_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOil_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nlO1lO_a	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1lO_b	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlO1lO_o	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n100i_w_lg_w_lg_w_lg_w_o_range246w492w493w494w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n100i_w_lg_w_lg_w_o_range246w492w493w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n100i_w_lg_w_o_range246w492w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n100i_i	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n100i_o	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_n100i_w_o_range221w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n100i_w_o_range225w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n100i_w_o_range237w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n100i_w_o_range240w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n100i_w_o_range243w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n100i_w_o_range246w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n100i_w_o_range197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_lg_w_lg_w_lg_w_o_range2105w2149w2150w2151w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_lg_w_lg_w_lg_w_o_range2111w2113w2115w2117w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_lg_w_lg_w_o_range2105w2149w2150w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_lg_w_lg_w_o_range2111w2113w2115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_lg_w_o_range2105w2149w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_lg_w_o_range2111w2113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_i	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni101l_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_o_range2114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_o_range2099w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_o_range2102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_o_range2105w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_o_range2108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_o_range2112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_o_range2116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni101l_w_o_range2111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_lg_w_lg_w_lg_w_o_range1720w1919w1920w1921w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_lg_w_lg_w_lg_w_o_range1718w1952w1953w1954w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_lg_w_lg_w_o_range1722w1936w1937w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_lg_w_lg_w_o_range1720w1919w1920w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_lg_w_lg_w_o_range1718w1952w1953w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_lg_w_o_range1722w1936w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_lg_w_o_range1720w1919w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_lg_w_o_range1718w1952w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_i	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_o_range1745w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_o_range1722w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_o_range1743w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_o_range1720w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_o_range1752w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nii0Ol_w_o_range1718w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1OlO_w_lg_w_lg_w_o_range1134w1191w1192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1OlO_w_lg_w_o_range1134w1191w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1OlO_i	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl1OlO_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nl1OlO_w_o_range1123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1OlO_w_o_range1132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nl1OlO_w_o_range1134w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0OOOl_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0OOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n0OOOl_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n101l_data	:	STD_LOGIC_VECTOR (20 DOWNTO 0);
	 SIGNAL  wire_n101l_o	:	STD_LOGIC;
	 SIGNAL  wire_n101l_sel	:	STD_LOGIC_VECTOR (20 DOWNTO 0);
	 SIGNAL  wire_n110i_data	:	STD_LOGIC_VECTOR (18 DOWNTO 0);
	 SIGNAL  wire_n110i_o	:	STD_LOGIC;
	 SIGNAL  wire_n110i_sel	:	STD_LOGIC_VECTOR (18 DOWNTO 0);
	 SIGNAL  wire_n110l_data	:	STD_LOGIC_VECTOR (18 DOWNTO 0);
	 SIGNAL  wire_n110l_o	:	STD_LOGIC;
	 SIGNAL  wire_n110l_sel	:	STD_LOGIC_VECTOR (18 DOWNTO 0);
	 SIGNAL  wire_n111i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n111i_o	:	STD_LOGIC;
	 SIGNAL  wire_n111i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n111l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n111l_o	:	STD_LOGIC;
	 SIGNAL  wire_n111l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11ii_data	:	STD_LOGIC_VECTOR (18 DOWNTO 0);
	 SIGNAL  wire_n11ii_o	:	STD_LOGIC;
	 SIGNAL  wire_n11ii_sel	:	STD_LOGIC_VECTOR (18 DOWNTO 0);
	 SIGNAL  wire_n11li_data	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_n11li_o	:	STD_LOGIC;
	 SIGNAL  wire_n11li_sel	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_n11lO_data	:	STD_LOGIC_VECTOR (16 DOWNTO 0);
	 SIGNAL  wire_n11lO_o	:	STD_LOGIC;
	 SIGNAL  wire_n11lO_sel	:	STD_LOGIC_VECTOR (16 DOWNTO 0);
	 SIGNAL  wire_n11OO_data	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_n11OO_o	:	STD_LOGIC;
	 SIGNAL  wire_n11OO_sel	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_ni0Oii_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0Oii_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0Oii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0Oli_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0Oli_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0Oli_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0OOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni0OOl_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0OOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni110i_data	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_ni110i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni110i_sel	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_ni110O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni110O_o	:	STD_LOGIC;
	 SIGNAL  wire_ni110O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni111i_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_ni111i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni111i_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_ni111O_data	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_ni111O_o	:	STD_LOGIC;
	 SIGNAL  wire_ni111O_sel	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_ni11il_data	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_ni11il_o	:	STD_LOGIC;
	 SIGNAL  wire_ni11il_sel	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_ni11li_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni11li_o	:	STD_LOGIC;
	 SIGNAL  wire_ni11li_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni11lO_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_ni11lO_o	:	STD_LOGIC;
	 SIGNAL  wire_ni11lO_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_ni11Ol_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_ni11Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_ni11Ol_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_nii00l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nii00l_o	:	STD_LOGIC;
	 SIGNAL  wire_nii00l_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nii01i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nii01i_o	:	STD_LOGIC;
	 SIGNAL  wire_nii01i_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nii01O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nii01O_o	:	STD_LOGIC;
	 SIGNAL  wire_nii01O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nii0ii_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nii0ii_o	:	STD_LOGIC;
	 SIGNAL  wire_nii0ii_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nii0iO_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nii0iO_o	:	STD_LOGIC;
	 SIGNAL  wire_nii0iO_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nii0lO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nii0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_nii0lO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nii10l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nii10l_o	:	STD_LOGIC;
	 SIGNAL  wire_nii10l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nii11l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nii11l_o	:	STD_LOGIC;
	 SIGNAL  wire_nii11l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nii1il_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nii1il_o	:	STD_LOGIC;
	 SIGNAL  wire_nii1il_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nii1ll_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nii1ll_o	:	STD_LOGIC;
	 SIGNAL  wire_nii1ll_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nii1Oi_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nii1Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_nii1Oi_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nii1OO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nii1OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nii1OO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nl1lil_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nl1lil_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1lil_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nl1O0l_data	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_nl1O0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1O0l_sel	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_nl1O1l_data	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_nl1O1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1O1l_sel	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_nl1O1O_data	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_nl1O1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1O1O_sel	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_nl1Oii_data	:	STD_LOGIC_VECTOR (14 DOWNTO 0);
	 SIGNAL  wire_nl1Oii_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1Oii_sel	:	STD_LOGIC_VECTOR (14 DOWNTO 0);
	 SIGNAL  wire_nl1Oil_data	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_nl1Oil_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1Oil_sel	:	STD_LOGIC_VECTOR (13 DOWNTO 0);
	 SIGNAL  wire_nl1Oli_data	:	STD_LOGIC_VECTOR (14 DOWNTO 0);
	 SIGNAL  wire_nl1Oli_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1Oli_sel	:	STD_LOGIC_VECTOR (14 DOWNTO 0);
	 SIGNAL  wire_nlOOOl_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlOOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOOOl_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_w_lg_w2519w2520w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w2490w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w2519w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w2485w2486w2487w2488w2489w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w2514w2515w2516w2517w2518w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w2485w2486w2487w2488w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w2514w2515w2516w2517w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w2485w2486w2487w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w2514w2515w2516w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w2594w2595w2596w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w2485w2486w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w2514w2515w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w2594w2595w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w2485w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w2541w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w2514w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w2594w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2483w2484w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2483w2540w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2512w2513w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w771w772w773w1433w2593w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w2480w2481w2482w2483w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w2480w2481w2482w2512w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w771w772w773w1433w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w2480w2481w2482w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w771w772w773w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w2480w2481w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w771w772w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w2480w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w771w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_rxd_range741w768w884w885w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_rxd_range741w768w769w770w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_rxd_range741w768w884w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_rxd_range741w768w769w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l0OO1081w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rbist_sel_range1w9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rcxpat_chnl_sel_range950w955w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxc_range107w1082w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxc_range107w2611w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxc_range107w2036w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range741w758w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i00l2063w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i01i2067w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i01O2065w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0ii2061w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0il2209w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0iO2059w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0li2057w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0ll2055w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0lO2058w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0Oi2053w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i0OO2051w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i10O2079w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1il2077w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1li2075w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1ll2212w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1lO2073w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1Oi2071w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1Ol2069w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0i1OO2072w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ii0l2046w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ii0O2045w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ii1l2049w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0ii1O2048w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iill2039w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iilO2038w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0illl1901w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iO0i1725w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOli1113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOll1112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOlO1111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOOi1110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOOO1108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l00i1087w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l00l1086w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l01i1089w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l01l1088w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l10i1104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l10l1103w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l11i1107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l11l1106w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l11O1105w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l1il1102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l1iO1101w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l1Oi1091w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0l1Ol1090w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0llil146w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lliO145w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0llli144w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0llll143w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0llOO134w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lO0i130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lO0l129w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lO0O128w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lO1i133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lO1l132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lO1O131w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lOii127w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lOil126w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lOiO125w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lOli124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lOll123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lOlO122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lOOi121w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lOOO120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0O0iO119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rbist_clr_rx105w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rpma_doublewidth_rx14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rbist_sel_range3w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rcxpat_chnl_sel_range952w953w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range741w768w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range742w757w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range751w763w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range753w774w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxd_range755w766w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n00OOi :	STD_LOGIC;
	 SIGNAL  n00OOl :	STD_LOGIC;
	 SIGNAL  n00OOO :	STD_LOGIC;
	 SIGNAL  n0i00i :	STD_LOGIC;
	 SIGNAL  n0i00l :	STD_LOGIC;
	 SIGNAL  n0i00O :	STD_LOGIC;
	 SIGNAL  n0i01i :	STD_LOGIC;
	 SIGNAL  n0i01l :	STD_LOGIC;
	 SIGNAL  n0i01O :	STD_LOGIC;
	 SIGNAL  n0i0ii :	STD_LOGIC;
	 SIGNAL  n0i0il :	STD_LOGIC;
	 SIGNAL  n0i0iO :	STD_LOGIC;
	 SIGNAL  n0i0li :	STD_LOGIC;
	 SIGNAL  n0i0ll :	STD_LOGIC;
	 SIGNAL  n0i0lO :	STD_LOGIC;
	 SIGNAL  n0i0Oi :	STD_LOGIC;
	 SIGNAL  n0i0Ol :	STD_LOGIC;
	 SIGNAL  n0i0OO :	STD_LOGIC;
	 SIGNAL  n0i10i :	STD_LOGIC;
	 SIGNAL  n0i10l :	STD_LOGIC;
	 SIGNAL  n0i10O :	STD_LOGIC;
	 SIGNAL  n0i11i :	STD_LOGIC;
	 SIGNAL  n0i11l :	STD_LOGIC;
	 SIGNAL  n0i11O :	STD_LOGIC;
	 SIGNAL  n0i1ii :	STD_LOGIC;
	 SIGNAL  n0i1il :	STD_LOGIC;
	 SIGNAL  n0i1iO :	STD_LOGIC;
	 SIGNAL  n0i1li :	STD_LOGIC;
	 SIGNAL  n0i1ll :	STD_LOGIC;
	 SIGNAL  n0i1lO :	STD_LOGIC;
	 SIGNAL  n0i1Oi :	STD_LOGIC;
	 SIGNAL  n0i1Ol :	STD_LOGIC;
	 SIGNAL  n0i1OO :	STD_LOGIC;
	 SIGNAL  n0ii0i :	STD_LOGIC;
	 SIGNAL  n0ii0l :	STD_LOGIC;
	 SIGNAL  n0ii0O :	STD_LOGIC;
	 SIGNAL  n0ii1i :	STD_LOGIC;
	 SIGNAL  n0ii1l :	STD_LOGIC;
	 SIGNAL  n0ii1O :	STD_LOGIC;
	 SIGNAL  n0iiii :	STD_LOGIC;
	 SIGNAL  n0iiil :	STD_LOGIC;
	 SIGNAL  n0iiiO :	STD_LOGIC;
	 SIGNAL  n0iili :	STD_LOGIC;
	 SIGNAL  n0iill :	STD_LOGIC;
	 SIGNAL  n0iilO :	STD_LOGIC;
	 SIGNAL  n0iiOi :	STD_LOGIC;
	 SIGNAL  n0iiOl :	STD_LOGIC;
	 SIGNAL  n0iiOO :	STD_LOGIC;
	 SIGNAL  n0il0i :	STD_LOGIC;
	 SIGNAL  n0il0l :	STD_LOGIC;
	 SIGNAL  n0il0O :	STD_LOGIC;
	 SIGNAL  n0il1i :	STD_LOGIC;
	 SIGNAL  n0il1l :	STD_LOGIC;
	 SIGNAL  n0il1O :	STD_LOGIC;
	 SIGNAL  n0ilii :	STD_LOGIC;
	 SIGNAL  n0ilil :	STD_LOGIC;
	 SIGNAL  n0iliO :	STD_LOGIC;
	 SIGNAL  n0illi :	STD_LOGIC;
	 SIGNAL  n0illl :	STD_LOGIC;
	 SIGNAL  n0illO :	STD_LOGIC;
	 SIGNAL  n0ilOi :	STD_LOGIC;
	 SIGNAL  n0ilOl :	STD_LOGIC;
	 SIGNAL  n0ilOO :	STD_LOGIC;
	 SIGNAL  n0iO0i :	STD_LOGIC;
	 SIGNAL  n0iO0l :	STD_LOGIC;
	 SIGNAL  n0iO0O :	STD_LOGIC;
	 SIGNAL  n0iO1i :	STD_LOGIC;
	 SIGNAL  n0iO1l :	STD_LOGIC;
	 SIGNAL  n0iO1O :	STD_LOGIC;
	 SIGNAL  n0iOii :	STD_LOGIC;
	 SIGNAL  n0iOil :	STD_LOGIC;
	 SIGNAL  n0iOiO :	STD_LOGIC;
	 SIGNAL  n0iOli :	STD_LOGIC;
	 SIGNAL  n0iOll :	STD_LOGIC;
	 SIGNAL  n0iOlO :	STD_LOGIC;
	 SIGNAL  n0iOOi :	STD_LOGIC;
	 SIGNAL  n0iOOl :	STD_LOGIC;
	 SIGNAL  n0iOOO :	STD_LOGIC;
	 SIGNAL  n0l00i :	STD_LOGIC;
	 SIGNAL  n0l00l :	STD_LOGIC;
	 SIGNAL  n0l00O :	STD_LOGIC;
	 SIGNAL  n0l01i :	STD_LOGIC;
	 SIGNAL  n0l01l :	STD_LOGIC;
	 SIGNAL  n0l01O :	STD_LOGIC;
	 SIGNAL  n0l0ii :	STD_LOGIC;
	 SIGNAL  n0l0il :	STD_LOGIC;
	 SIGNAL  n0l0iO :	STD_LOGIC;
	 SIGNAL  n0l0li :	STD_LOGIC;
	 SIGNAL  n0l0ll :	STD_LOGIC;
	 SIGNAL  n0l0lO :	STD_LOGIC;
	 SIGNAL  n0l0Oi :	STD_LOGIC;
	 SIGNAL  n0l0Ol :	STD_LOGIC;
	 SIGNAL  n0l0OO :	STD_LOGIC;
	 SIGNAL  n0l10i :	STD_LOGIC;
	 SIGNAL  n0l10l :	STD_LOGIC;
	 SIGNAL  n0l10O :	STD_LOGIC;
	 SIGNAL  n0l11i :	STD_LOGIC;
	 SIGNAL  n0l11l :	STD_LOGIC;
	 SIGNAL  n0l11O :	STD_LOGIC;
	 SIGNAL  n0l1ii :	STD_LOGIC;
	 SIGNAL  n0l1il :	STD_LOGIC;
	 SIGNAL  n0l1iO :	STD_LOGIC;
	 SIGNAL  n0l1li :	STD_LOGIC;
	 SIGNAL  n0l1ll :	STD_LOGIC;
	 SIGNAL  n0l1lO :	STD_LOGIC;
	 SIGNAL  n0l1Oi :	STD_LOGIC;
	 SIGNAL  n0l1Ol :	STD_LOGIC;
	 SIGNAL  n0l1OO :	STD_LOGIC;
	 SIGNAL  n0li0i :	STD_LOGIC;
	 SIGNAL  n0li0l :	STD_LOGIC;
	 SIGNAL  n0li0O :	STD_LOGIC;
	 SIGNAL  n0li1i :	STD_LOGIC;
	 SIGNAL  n0li1l :	STD_LOGIC;
	 SIGNAL  n0li1O :	STD_LOGIC;
	 SIGNAL  n0liii :	STD_LOGIC;
	 SIGNAL  n0liil :	STD_LOGIC;
	 SIGNAL  n0liOO :	STD_LOGIC;
	 SIGNAL  n0ll0l :	STD_LOGIC;
	 SIGNAL  n0llil :	STD_LOGIC;
	 SIGNAL  n0lliO :	STD_LOGIC;
	 SIGNAL  n0llli :	STD_LOGIC;
	 SIGNAL  n0llll :	STD_LOGIC;
	 SIGNAL  n0lllO :	STD_LOGIC;
	 SIGNAL  n0llOO :	STD_LOGIC;
	 SIGNAL  n0lO0i :	STD_LOGIC;
	 SIGNAL  n0lO0l :	STD_LOGIC;
	 SIGNAL  n0lO0O :	STD_LOGIC;
	 SIGNAL  n0lO1i :	STD_LOGIC;
	 SIGNAL  n0lO1l :	STD_LOGIC;
	 SIGNAL  n0lO1O :	STD_LOGIC;
	 SIGNAL  n0lOii :	STD_LOGIC;
	 SIGNAL  n0lOil :	STD_LOGIC;
	 SIGNAL  n0lOiO :	STD_LOGIC;
	 SIGNAL  n0lOli :	STD_LOGIC;
	 SIGNAL  n0lOll :	STD_LOGIC;
	 SIGNAL  n0lOlO :	STD_LOGIC;
	 SIGNAL  n0lOOi :	STD_LOGIC;
	 SIGNAL  n0lOOl :	STD_LOGIC;
	 SIGNAL  n0lOOO :	STD_LOGIC;
	 SIGNAL  n0O00O :	STD_LOGIC;
	 SIGNAL  n0O0ii :	STD_LOGIC;
	 SIGNAL  n0O0il :	STD_LOGIC;
	 SIGNAL  n0O0iO :	STD_LOGIC;
	 SIGNAL  n0O0li :	STD_LOGIC;
	 SIGNAL  n0O10i :	STD_LOGIC;
	 SIGNAL  n0O10l :	STD_LOGIC;
	 SIGNAL  n0O10O :	STD_LOGIC;
	 SIGNAL  n0O11i :	STD_LOGIC;
	 SIGNAL  n0O1ii :	STD_LOGIC;
	 SIGNAL  n0O1li :	STD_LOGIC;
	 SIGNAL  n0O1ll :	STD_LOGIC;
	 SIGNAL  n0O1lO :	STD_LOGIC;
	 SIGNAL  wire_w_rbist_sel_range1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rbist_sel_range3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rcxpat_chnl_sel_range950w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rcxpat_chnl_sel_range952w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxc_range107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range741w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range742w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range744w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range747w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range749w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range751w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range753w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxd_range755w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_w2519w2520w(0) <= wire_w2519w(0) AND wire_nlOl_dataout;
	wire_w2490w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w2485w2486w2487w2488w2489w(0) AND wire_nllO_dataout;
	wire_w2519w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w2514w2515w2516w2517w2518w(0) AND wire_nllO_dataout;
	wire_w_lg_w_lg_w_lg_w_lg_w2485w2486w2487w2488w2489w(0) <= wire_w_lg_w_lg_w_lg_w2485w2486w2487w2488w(0) AND wire_nlli_dataout;
	wire_w_lg_w_lg_w_lg_w_lg_w2514w2515w2516w2517w2518w(0) <= wire_w_lg_w_lg_w_lg_w2514w2515w2516w2517w(0) AND wire_nlli_dataout;
	wire_w_lg_w_lg_w_lg_w2485w2486w2487w2488w(0) <= wire_w_lg_w_lg_w2485w2486w2487w(0) AND wire_nliO_w_lg_dataout809w(0);
	wire_w_lg_w_lg_w_lg_w2514w2515w2516w2517w(0) <= wire_w_lg_w_lg_w2514w2515w2516w(0) AND wire_nliO_w_lg_dataout809w(0);
	wire_w_lg_w_lg_w2485w2486w2487w(0) <= wire_w_lg_w2485w2486w(0) AND wire_nlil_w_lg_dataout807w(0);
	wire_w_lg_w_lg_w2514w2515w2516w(0) <= wire_w_lg_w2514w2515w(0) AND wire_nlil_w_lg_dataout807w(0);
	wire_w_lg_w_lg_w2594w2595w2596w(0) <= wire_w_lg_w2594w2595w(0) AND wire_nlil_dataout;
	wire_w_lg_w2485w2486w(0) <= wire_w2485w(0) AND wire_nlOi_dataout;
	wire_w_lg_w2514w2515w(0) <= wire_w2514w(0) AND wire_nlOi_dataout;
	wire_w_lg_w2594w2595w(0) <= wire_w2594w(0) AND wire_nlOi_dataout;
	wire_w2485w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2483w2484w(0) AND wire_nlll_dataout;
	wire_w2541w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2483w2540w(0) AND wire_nlll_dataout;
	wire_w2514w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2512w2513w(0) AND wire_nlll_dataout;
	wire_w2594w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w771w772w773w1433w2593w(0) AND wire_nlll_dataout;
	wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2483w2484w(0) <= wire_w_lg_w_lg_w_lg_w2480w2481w2482w2483w(0) AND wire_w_lg_w_rxd_range755w766w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2483w2540w(0) <= wire_w_lg_w_lg_w_lg_w2480w2481w2482w2483w(0) AND wire_w_rxd_range755w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2512w2513w(0) <= wire_w_lg_w_lg_w_lg_w2480w2481w2482w2512w(0) AND wire_w_lg_w_rxd_range755w766w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w771w772w773w1433w2593w(0) <= wire_w_lg_w_lg_w_lg_w771w772w773w1433w(0) AND wire_w_rxd_range755w(0);
	wire_w_lg_w_lg_w_lg_w2480w2481w2482w2483w(0) <= wire_w_lg_w_lg_w2480w2481w2482w(0) AND wire_w_lg_w_rxd_range753w774w(0);
	wire_w_lg_w_lg_w_lg_w2480w2481w2482w2512w(0) <= wire_w_lg_w_lg_w2480w2481w2482w(0) AND wire_w_rxd_range753w(0);
	wire_w_lg_w_lg_w_lg_w771w772w773w1433w(0) <= wire_w_lg_w_lg_w771w772w773w(0) AND wire_w_rxd_range753w(0);
	wire_w_lg_w_lg_w2480w2481w2482w(0) <= wire_w_lg_w2480w2481w(0) AND wire_w_lg_w_rxd_range751w763w(0);
	wire_w_lg_w_lg_w771w772w773w(0) <= wire_w_lg_w771w772w(0) AND wire_w_rxd_range751w(0);
	wire_w_lg_w2480w2481w(0) <= wire_w2480w(0) AND wire_w_rxd_range749w(0);
	wire_w_lg_w771w772w(0) <= wire_w771w(0) AND wire_w_rxd_range749w(0);
	wire_w2480w(0) <= wire_w_lg_w_lg_w_lg_w_rxd_range741w768w884w885w(0) AND wire_w_rxd_range747w(0);
	wire_w771w(0) <= wire_w_lg_w_lg_w_lg_w_rxd_range741w768w769w770w(0) AND wire_w_rxd_range747w(0);
	wire_w_lg_w_lg_w_lg_w_rxd_range741w768w884w885w(0) <= wire_w_lg_w_lg_w_rxd_range741w768w884w(0) AND wire_w_rxd_range744w(0);
	wire_w_lg_w_lg_w_lg_w_rxd_range741w768w769w770w(0) <= wire_w_lg_w_lg_w_rxd_range741w768w769w(0) AND wire_w_rxd_range744w(0);
	wire_w_lg_w_lg_w_rxd_range741w768w884w(0) <= wire_w_lg_w_rxd_range741w768w(0) AND wire_w_lg_w_rxd_range742w757w(0);
	wire_w_lg_w_lg_w_rxd_range741w768w769w(0) <= wire_w_lg_w_rxd_range741w768w(0) AND wire_w_rxd_range742w(0);
	wire_w_lg_n0l0OO1081w(0) <= n0l0OO AND n0l0Ol;
	wire_w_lg_w_rbist_sel_range1w9w(0) <= wire_w_rbist_sel_range1w(0) AND wire_w_lg_w_rbist_sel_range3w4w(0);
	wire_w_lg_w_rcxpat_chnl_sel_range950w955w(0) <= wire_w_rcxpat_chnl_sel_range950w(0) AND wire_w_lg_w_rcxpat_chnl_sel_range952w953w(0);
	wire_w_lg_w_rxc_range107w1082w(0) <= wire_w_rxc_range107w(0) AND wire_w_lg_n0l0OO1081w(0);
	wire_w_lg_w_rxc_range107w2611w(0) <= wire_w_rxc_range107w(0) AND wire_nlii_w_lg_dataout2040w(0);
	wire_w_lg_w_rxc_range107w2036w(0) <= wire_w_rxc_range107w(0) AND n0iiOi;
	wire_w_lg_w_rxd_range741w758w(0) <= wire_w_rxd_range741w(0) AND wire_w_lg_w_rxd_range742w757w(0);
	wire_w_lg_n0i00l2063w(0) <= NOT n0i00l;
	wire_w_lg_n0i01i2067w(0) <= NOT n0i01i;
	wire_w_lg_n0i01O2065w(0) <= NOT n0i01O;
	wire_w_lg_n0i0ii2061w(0) <= NOT n0i0ii;
	wire_w_lg_n0i0il2209w(0) <= NOT n0i0il;
	wire_w_lg_n0i0iO2059w(0) <= NOT n0i0iO;
	wire_w_lg_n0i0li2057w(0) <= NOT n0i0li;
	wire_w_lg_n0i0ll2055w(0) <= NOT n0i0ll;
	wire_w_lg_n0i0lO2058w(0) <= NOT n0i0lO;
	wire_w_lg_n0i0Oi2053w(0) <= NOT n0i0Oi;
	wire_w_lg_n0i0OO2051w(0) <= NOT n0i0OO;
	wire_w_lg_n0i10O2079w(0) <= NOT n0i10O;
	wire_w_lg_n0i1il2077w(0) <= NOT n0i1il;
	wire_w_lg_n0i1li2075w(0) <= NOT n0i1li;
	wire_w_lg_n0i1ll2212w(0) <= NOT n0i1ll;
	wire_w_lg_n0i1lO2073w(0) <= NOT n0i1lO;
	wire_w_lg_n0i1Oi2071w(0) <= NOT n0i1Oi;
	wire_w_lg_n0i1Ol2069w(0) <= NOT n0i1Ol;
	wire_w_lg_n0i1OO2072w(0) <= NOT n0i1OO;
	wire_w_lg_n0ii0l2046w(0) <= NOT n0ii0l;
	wire_w_lg_n0ii0O2045w(0) <= NOT n0ii0O;
	wire_w_lg_n0ii1l2049w(0) <= NOT n0ii1l;
	wire_w_lg_n0ii1O2048w(0) <= NOT n0ii1O;
	wire_w_lg_n0iill2039w(0) <= NOT n0iill;
	wire_w_lg_n0iilO2038w(0) <= NOT n0iilO;
	wire_w_lg_n0illl1901w(0) <= NOT n0illl;
	wire_w_lg_n0iO0i1725w(0) <= NOT n0iO0i;
	wire_w_lg_n0iOli1113w(0) <= NOT n0iOli;
	wire_w_lg_n0iOll1112w(0) <= NOT n0iOll;
	wire_w_lg_n0iOlO1111w(0) <= NOT n0iOlO;
	wire_w_lg_n0iOOi1110w(0) <= NOT n0iOOi;
	wire_w_lg_n0iOOO1108w(0) <= NOT n0iOOO;
	wire_w_lg_n0l00i1087w(0) <= NOT n0l00i;
	wire_w_lg_n0l00l1086w(0) <= NOT n0l00l;
	wire_w_lg_n0l01i1089w(0) <= NOT n0l01i;
	wire_w_lg_n0l01l1088w(0) <= NOT n0l01l;
	wire_w_lg_n0l10i1104w(0) <= NOT n0l10i;
	wire_w_lg_n0l10l1103w(0) <= NOT n0l10l;
	wire_w_lg_n0l11i1107w(0) <= NOT n0l11i;
	wire_w_lg_n0l11l1106w(0) <= NOT n0l11l;
	wire_w_lg_n0l11O1105w(0) <= NOT n0l11O;
	wire_w_lg_n0l1il1102w(0) <= NOT n0l1il;
	wire_w_lg_n0l1iO1101w(0) <= NOT n0l1iO;
	wire_w_lg_n0l1Oi1091w(0) <= NOT n0l1Oi;
	wire_w_lg_n0l1Ol1090w(0) <= NOT n0l1Ol;
	wire_w_lg_n0llil146w(0) <= NOT n0llil;
	wire_w_lg_n0lliO145w(0) <= NOT n0lliO;
	wire_w_lg_n0llli144w(0) <= NOT n0llli;
	wire_w_lg_n0llll143w(0) <= NOT n0llll;
	wire_w_lg_n0llOO134w(0) <= NOT n0llOO;
	wire_w_lg_n0lO0i130w(0) <= NOT n0lO0i;
	wire_w_lg_n0lO0l129w(0) <= NOT n0lO0l;
	wire_w_lg_n0lO0O128w(0) <= NOT n0lO0O;
	wire_w_lg_n0lO1i133w(0) <= NOT n0lO1i;
	wire_w_lg_n0lO1l132w(0) <= NOT n0lO1l;
	wire_w_lg_n0lO1O131w(0) <= NOT n0lO1O;
	wire_w_lg_n0lOii127w(0) <= NOT n0lOii;
	wire_w_lg_n0lOil126w(0) <= NOT n0lOil;
	wire_w_lg_n0lOiO125w(0) <= NOT n0lOiO;
	wire_w_lg_n0lOli124w(0) <= NOT n0lOli;
	wire_w_lg_n0lOll123w(0) <= NOT n0lOll;
	wire_w_lg_n0lOlO122w(0) <= NOT n0lOlO;
	wire_w_lg_n0lOOi121w(0) <= NOT n0lOOi;
	wire_w_lg_n0lOOO120w(0) <= NOT n0lOOO;
	wire_w_lg_n0O0iO119w(0) <= NOT n0O0iO;
	wire_w_lg_rbist_clr_rx105w(0) <= NOT rbist_clr_rx;
	wire_w_lg_rpma_doublewidth_rx14w(0) <= NOT rpma_doublewidth_rx;
	wire_w_lg_soft_reset104w(0) <= NOT soft_reset;
	wire_w_lg_w_rbist_sel_range3w4w(0) <= NOT wire_w_rbist_sel_range3w(0);
	wire_w_lg_w_rcxpat_chnl_sel_range952w953w(0) <= NOT wire_w_rcxpat_chnl_sel_range952w(0);
	wire_w_lg_w_rxd_range741w768w(0) <= NOT wire_w_rxd_range741w(0);
	wire_w_lg_w_rxd_range742w757w(0) <= NOT wire_w_rxd_range742w(0);
	wire_w_lg_w_rxd_range751w763w(0) <= NOT wire_w_rxd_range751w(0);
	wire_w_lg_w_rxd_range753w774w(0) <= NOT wire_w_rxd_range753w(0);
	wire_w_lg_w_rxd_range755w766w(0) <= NOT wire_w_rxd_range755w(0);
	bistdone <= ((wire_nl1l_dataout OR prbs_done) OR wire_n0O01l14_w_lg_Q54w(0));
	bisterr <= ((wire_nl1i_dataout OR prbs_err) OR wire_n0O00i11_w_lg_Q49w(0));
	cur_state <= ( wire_n1OO_dataout & wire_n1Ol_dataout & wire_n1Oi_dataout & wire_n1lO_dataout & wire_n1ll_dataout);
	err_ctl <= ( wire_niOO_dataout & wire_niOl_dataout);
	err_data <= ( wire_niOi_dataout & wire_nilO_dataout & wire_nill_dataout & wire_nili_dataout & wire_niiO_dataout & wire_niil_dataout & wire_niii_dataout & wire_ni0O_dataout & wire_ni0l_dataout & wire_ni0i_dataout & wire_ni1O_dataout & wire_ni1l_dataout & wire_ni1i_dataout & wire_n0OO_dataout & wire_n0Ol_dataout & wire_n0Oi_dataout);
	n00OOi <= (((((((((((wire_ni101l_w_lg_w_o_range2111w2113w(0) OR wire_ni101l_o(5)) OR wire_ni101l_o(3)) OR wire_ni101l_o(2)) OR wire_ni101l_o(1)) OR wire_ni101l_o(0)) OR wire_ni101l_o(15)) OR wire_ni101l_o(14)) OR wire_ni101l_o(10)) OR wire_ni101l_o(8)) OR wire_ni101l_o(6)) OR wire_ni101l_o(4));
	n00OOl <= ((((wire_ni101l_o(13) OR wire_ni101l_o(0)) OR wire_ni101l_o(15)) OR wire_ni101l_o(14)) OR wire_ni101l_o(6));
	n00OOO <= ((wire_ni101l_o(0) OR wire_ni101l_o(15)) OR wire_ni101l_o(14));
	n0i00i <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0i00l2063w(0));
	n0i00l <= ((((((((wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2483w2540w(0) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0i00O <= (wire_w_lg_n0ii0O2045w(0) OR wire_w_lg_n0i0ii2061w(0));
	n0i01i <= (((((((((((wire_w_lg_w2480w2481w(0) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_dataout) AND wire_nlil_dataout) AND wire_nliO_dataout) AND wire_nlli_dataout) AND wire_nllO_dataout) AND wire_nlOl_dataout) AND wire_nlOO_dataout);
	n0i01l <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0i01O2065w(0));
	n0i01O <= (((((((((wire_w_lg_w_lg_w_lg_w2480w2481w2482w2512w(0) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0i0ii <= (((((((wire_w2541w(0) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_dataout) AND wire_nllO_dataout) AND wire_nlOl_dataout) AND wire_nlOO_dataout);
	n0i0il <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0i0iO2059w(0));
	n0i0iO <= (((((((((((wire_w_lg_w2480w2481w(0) AND rxd(5)) AND rxd(6)) AND wire_w_lg_w_rxd_range755w766w(0)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0i0li <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0i0ll2055w(0));
	n0i0ll <= ((((((((wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2512w2513w(0) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0i0lO <= (wire_w_lg_n0ii0O2045w(0) OR wire_w_lg_n0i0Oi2053w(0));
	n0i0Oi <= (wire_w_lg_w2519w2520w(0) AND wire_nlOO_w_lg_dataout817w(0));
	n0i0Ol <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0i0OO2051w(0));
	n0i0OO <= (((((((((((wire_w_lg_w2480w2481w(0) AND rxd(5)) AND wire_w_lg_w_rxd_range753w774w(0)) AND wire_w_lg_w_rxd_range755w766w(0)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0i10i <= (wire_ni101l_o(15) OR wire_ni101l_o(14));
	n0i10l <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0i10O2079w(0));
	n0i10O <= ((((((((((((((wire_w_lg_w_rxd_range741w758w(0) AND rxd(2)) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0i11i <= (((((((((((((wire_ni101l_o(13) OR wire_ni101l_o(11)) OR wire_ni101l_o(9)) OR wire_ni101l_o(7)) OR wire_ni101l_o(5)) OR wire_ni101l_o(3)) OR wire_ni101l_o(0)) OR wire_ni101l_o(15)) OR wire_ni101l_o(14)) OR wire_ni101l_o(12)) OR wire_ni101l_o(10)) OR wire_ni101l_o(8)) OR wire_ni101l_o(6)) OR wire_ni101l_o(4));
	n0i11l <= ((((wire_ni101l_o(12) OR wire_ni101l_o(10)) OR wire_ni101l_o(8)) OR wire_ni101l_o(6)) OR wire_ni101l_o(4));
	n0i11O <= (((((((wire_ni101l_o(11) OR wire_ni101l_o(7)) OR wire_ni101l_o(3)) OR wire_ni101l_o(15)) OR wire_ni101l_o(14)) OR wire_ni101l_o(12)) OR wire_ni101l_o(8)) OR wire_ni101l_o(4));
	n0i1ii <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0i1il2077w(0));
	n0i1il <= ((((((((wire_w_lg_w_lg_w_lg_w_lg_w771w772w773w1433w2593w(0) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0i1iO <= (wire_w_lg_n0ii0O2045w(0) OR wire_w_lg_n0i1li2075w(0));
	n0i1li <= (((((wire_w_lg_w_lg_w2594w2595w2596w(0) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_dataout) AND wire_nllO_dataout) AND wire_nlOl_dataout) AND wire_nlOO_dataout);
	n0i1ll <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0i1lO2073w(0));
	n0i1lO <= (((((((((((((((rxd(0) AND rxd(1)) AND rxd(2)) AND (NOT rxd(3))) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0i1Oi <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0i1Ol2069w(0));
	n0i1Ol <= (((((((((((wire_w_lg_w2480w2481w(0) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0i1OO <= (wire_w_lg_n0ii0O2045w(0) OR wire_w_lg_n0i01i2067w(0));
	n0ii0i <= (wire_w_lg_n0ii0O2045w(0) OR wire_w_lg_n0ii0l2046w(0));
	n0ii0l <= ((wire_w2490w(0) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0ii0O <= (rxc(0) AND wire_nlii_dataout);
	n0ii1i <= (wire_w_lg_n0ii1O2048w(0) OR wire_w_lg_n0ii1l2049w(0));
	n0ii1l <= ((((((((wire_w_lg_w_lg_w_lg_w_lg_w2480w2481w2482w2483w2484w(0) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0ii1O <= wire_w_lg_w_rxc_range107w2611w(0);
	n0iiii <= (((((((niiOOO AND niiOOl) AND niiOOi) AND niiOlO) AND niiOll) AND niiOli) AND niiOiO) AND niiOil);
	n0iiil <= (n0O0iO AND n0iiiO);
	n0iiiO <= ((((((niilOO AND niilOl) AND niilOi) AND niillO) AND niilll) AND niilli) AND niiliO);
	n0iili <= (wire_w_lg_n0iill2039w(0) OR (NOT ((NOT rxc(0)) AND wire_nlii_w_lg_dataout2040w(0))));
	n0iill <= ((((((((((((((((NOT (rxd(0) XOR wire_niO1OO_dataout)) AND (NOT (rxd(1) XOR wire_niO01i_dataout))) AND (NOT (rxd(2) XOR wire_niO01l_dataout))) AND (NOT (rxd(3) XOR wire_niO01O_dataout))) AND (NOT (rxd(4) XOR wire_niO00i_dataout))) AND (NOT (rxd(5) XOR wire_niO00l_dataout))) AND (NOT (rxd(6) XOR wire_niO00O_dataout))) AND (NOT (rxd(7) XOR wire_niO0ii_dataout))) AND (NOT (n0O0iO XOR wire_nlil_dataout))) AND (NOT (wire_nliO_dataout XOR wire_niO0il_dataout))) AND (NOT (wire_nlli_dataout XOR wire_niO0iO_dataout))) AND (NOT (wire_nlll_dataout XOR wire_niO0li_dataout))) AND (NOT (wire_nllO_dataout XOR wire_niO0ll_dataout))) AND (NOT (wire_nlOi_dataout XOR wire_niO0lO_dataout))) AND (NOT (wire_nlOl_dataout XOR wire_niO0Oi_dataout))) AND (NOT (wire_nlOO_dataout XOR wire_niO0Ol_dataout)));
	n0iilO <= (wire_w_lg_n0O0iO119w(0) AND wire_w_lg_w_rxc_range107w2036w(0));
	n0iiOi <= (((((((rxd(0) AND rxd(1)) AND (NOT rxd(2))) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7));
	n0iiOl <= (n0O0iO AND (wire_nlii_dataout AND n0iiOO));
	n0iiOO <= ((((wire_nlll_w_lg_w_lg_w_lg_dataout2422w2423w2424w(0) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_dataout) AND wire_nlOl_dataout) AND wire_nlOO_dataout);
	n0il0i <= ((((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(1)) OR wire_nii0Ol_o(15)) OR wire_nii0Ol_o(14)) OR wire_nii0Ol_o(13)) OR wire_nii0Ol_o(0));
	n0il0l <= (((((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(9)) OR wire_nii0Ol_o(7)) OR wire_nii0Ol_o(5)) OR wire_nii0Ol_o(3));
	n0il0O <= ((((((wire_nii0Ol_o(10) OR wire_nii0Ol_o(1)) OR wire_nii0Ol_o(15)) OR wire_nii0Ol_o(14)) OR wire_nii0Ol_o(13)) OR wire_nii0Ol_o(0)) OR wire_nii0Ol_o(11));
	n0il1i <= (((((((niiOOO AND niiOOl) AND niiOOi) AND niiOlO) AND niiOll) AND niiOli) AND niiOiO) AND niiOil);
	n0il1l <= (niil0i AND wire_nO_dataout);
	n0il1O <= (((((((wire_nii0Ol_o(8) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(11)) OR wire_nii0Ol_o(9)) OR wire_nii0Ol_o(7)) OR wire_nii0Ol_o(5)) OR wire_nii0Ol_o(3));
	n0ilii <= (((((((((((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(1)) OR wire_nii0Ol_o(15)) OR wire_nii0Ol_o(14)) OR wire_nii0Ol_o(13)) OR wire_nii0Ol_o(0)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(11)) OR wire_nii0Ol_o(9)) OR wire_nii0Ol_o(7)) OR wire_nii0Ol_o(5)) OR wire_nii0Ol_o(3));
	n0ilil <= ((((((((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(1)) OR wire_nii0Ol_o(15)) OR wire_nii0Ol_o(14)) OR wire_nii0Ol_o(13)) OR wire_nii0Ol_o(0)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(11)) OR wire_nii0Ol_o(9));
	n0iliO <= (((((((((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(1)) OR wire_nii0Ol_o(15)) OR wire_nii0Ol_o(14)) OR wire_nii0Ol_o(13)) OR wire_nii0Ol_o(0)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(11)) OR wire_nii0Ol_o(9)) OR wire_nii0Ol_o(5));
	n0illi <= ((((((((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(1)) OR wire_nii0Ol_o(15)) OR wire_nii0Ol_o(14)) OR wire_nii0Ol_o(13)) OR wire_nii0Ol_o(0)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(11)) OR wire_nii0Ol_o(9)) OR wire_nii0Ol_o(7));
	n0illl <= (((((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(7)) OR wire_nii0Ol_o(5)) OR wire_nii0Ol_o(3));
	n0illO <= ((((((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(11)) OR wire_nii0Ol_o(7)) OR wire_nii0Ol_o(5)) OR wire_nii0Ol_o(3));
	n0ilOi <= (((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(9));
	n0ilOl <= ((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4));
	n0ilOO <= (((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(7));
	n0iO0i <= (((((wire_nii0Ol_o(2) OR wire_nii0Ol_o(12)) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4));
	n0iO0l <= ((((((((((wire_nl1OlO_o(15) OR wire_nl1OlO_o(9)) OR wire_nl1OlO_o(8)) OR wire_nl1OlO_o(7)) OR wire_nl1OlO_o(6)) OR wire_nl1OlO_o(5)) OR wire_nl1OlO_o(2)) OR wire_nl1OlO_o(1)) OR wire_nl1OlO_o(0)) OR wire_nl1OlO_o(4)) OR wire_nl1OlO_o(3));
	n0iO0O <= (((wire_nl1OlO_o(2) OR wire_nl1OlO_o(1)) OR wire_nl1OlO_o(0)) OR wire_nl1OlO_o(3));
	n0iO1i <= (((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(3));
	n0iO1l <= ((((((wire_nii0Ol_o(12) OR wire_nii0Ol_o(10)) OR wire_nii0Ol_o(8)) OR wire_nii0Ol_o(6)) OR wire_nii0Ol_o(4)) OR wire_nii0Ol_o(5)) OR wire_nii0Ol_o(3));
	n0iO1O <= (((wire_nii0Ol_o(15) OR wire_nii0Ol_o(14)) OR wire_nii0Ol_o(13)) OR wire_nii0Ol_o(0));
	n0iOii <= (((((wire_nl1OlO_o(14) OR wire_nl1OlO_o(13)) OR wire_nl1OlO_o(12)) OR wire_nl1OlO_o(11)) OR wire_nl1OlO_o(4)) OR wire_nl1OlO_o(3));
	n0iOil <= (wire_nl1OlO_o(0) OR wire_nl1OlO_o(3));
	n0iOiO <= ((NOT rxc(0)) OR wire_w_lg_n0iOli1113w(0));
	n0iOli <= ((((((((((((((wire_w_lg_w_rxd_range741w758w(0) AND rxd(2)) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0iOll <= (((((((((((((((rxd(0) AND rxd(1)) AND (NOT rxd(2))) AND rxd(3)) AND (NOT rxd(4))) AND rxd(5)) AND wire_w_lg_w_rxd_range753w774w(0)) AND rxd(7)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0iOlO <= (((((((((((wire_w_lg_w771w772w(0) AND wire_w_lg_w_rxd_range751w763w(0)) AND wire_w_lg_w_rxd_range753w774w(0)) AND wire_w_lg_w_rxd_range755w766w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0iOOi <= (((((((((((((((rxd(0) AND rxd(1)) AND rxd(2)) AND rxd(3)) AND rxd(4)) AND wire_w_lg_w_rxd_range751w763w(0)) AND wire_w_lg_w_rxd_range753w774w(0)) AND rxd(7)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0iOOl <= (wire_w_lg_n0iOOO1108w(0) OR (NOT ((NOT rxc(0)) AND wire_nlii_dataout)));
	n0iOOO <= ((((((((((((((wire_w_lg_w_rxd_range741w758w(0) AND rxd(2)) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND wire_w_lg_w_rxd_range753w774w(0)) AND rxd(7)) AND wire_nliO_w_lg_dataout809w(0)) AND (NOT (n0O0iO XOR wire_nlil_dataout))) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOl_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0l00i <= (wire_ni0OO_w_lg_w_lg_w_lg_w1463w1464w1465w1466w(0) AND wire_ni0OO_w_lg_nlli1l1457w(0));
	n0l00l <= (((((((((((((((rxd(0) AND rxd(1)) AND (NOT rxd(2))) AND rxd(3)) AND (NOT rxd(4))) AND wire_w_lg_w_rxd_range751w763w(0)) AND wire_w_lg_w_rxd_range753w774w(0)) AND wire_w_lg_w_rxd_range755w766w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nlOO_w_lg_dataout817w(0)) AND (NOT (n0O0iO XOR wire_nliO_dataout))) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOl_dataout)));
	n0l00O <= ((NOT rcxpat_chnl_sel(0)) AND rcxpat_chnl_sel(1));
	n0l01i <= (wire_ni0OO_w_lg_w_lg_w_lg_w1463w1464w1465w1466w(0) AND nlli1l);
	n0l01l <= (wire_ni0OO_w_lg_w_lg_w1472w1473w1474w(0) AND wire_ni0OO_w_lg_nlli1l1457w(0));
	n0l01O <= ((((((wire_ni0OO_w_lg_w_lg_w_lg_nllili1443w1445w1446w(0) AND wire_ni0OO_w_lg_nlliii1447w(0)) AND wire_ni0OO_w_lg_nlli0O1449w(0)) AND wire_ni0OO_w_lg_nlli0l1451w(0)) AND wire_ni0OO_w_lg_nlli0i1453w(0)) AND wire_ni0OO_w_lg_nlli1O1455w(0)) AND wire_ni0OO_w_lg_nlli1l1457w(0));
	n0l0ii <= wire_w_lg_w_rcxpat_chnl_sel_range950w955w(0);
	n0l0il <= (n0l0lO AND n0l0iO);
	n0l0iO <= (rcxpat_chnl_sel(0) AND rcxpat_chnl_sel(1));
	n0l0li <= (n0l0lO AND n0l0ll);
	n0l0ll <= (n0l0ii OR n0l00O);
	n0l0lO <= ((((((wire_w_lg_w_rxd_range741w758w(0) AND rxd(2)) AND (NOT rxd(3))) AND rxd(4)) AND wire_w_lg_w_rxd_range751w763w(0)) AND rxd(6)) AND wire_w_lg_w_rxd_range755w766w(0));
	n0l0Oi <= wire_w_lg_w_rxc_range107w1082w(0);
	n0l0Ol <= ((NOT rcxpat_chnl_sel(0)) AND wire_w_lg_w_rcxpat_chnl_sel_range952w953w(0));
	n0l0OO <= (((((((rxd(0) AND rxd(1)) AND (NOT rxd(2))) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7));
	n0l10i <= (((((((((((((((rxd(5) AND rxd(7)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND (NOT (wire_w_lg_n0O0iO119w(0) XOR rxd(0)))) AND (NOT (wire_w_lg_n0O0iO119w(0) XOR rxd(1)))) AND (NOT (n0O0iO XOR rxd(2)))) AND (NOT (wire_w_lg_n0O0iO119w(0) XOR rxd(3)))) AND (NOT (n0O0iO XOR rxd(4)))) AND (NOT (n0O0iO XOR rxd(6)))) AND (NOT (n0O0iO XOR wire_nlil_dataout))) AND (NOT (n0O0iO XOR wire_nliO_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0l10l <= (((((((((((((((rxd(0) AND rxd(1)) AND (NOT rxd(2))) AND rxd(3)) AND (NOT rxd(4))) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOl_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0l10O <= ((wire_nll0ll_w_lg_nll0lO1507w(0) AND nll0li) AND nll0il);
	n0l11i <= ((((((((((((((wire_w_lg_w_rxd_range741w758w(0) AND rxd(2)) AND (NOT rxd(3))) AND rxd(4)) AND rxd(5)) AND wire_w_lg_w_rxd_range753w774w(0)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND (NOT (n0O0iO XOR wire_nlil_dataout))) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0l11l <= ((((wire_ni0OO_w_lg_w_lg_nll00O1548w1549w(0) AND wire_ni0OO_w_lg_nll00i1550w(0)) AND wire_ni0OO_w_lg_nll01O1552w(0)) AND nll01l) AND nll01i);
	n0l11O <= ((((wire_ni0OO_w_lg_nll00O1557w(0) AND wire_ni0OO_w_lg_nll00i1550w(0)) AND nll01O) AND nll01l) AND nll01i);
	n0l1ii <= ((nll0lO AND nll0li) AND nll0il);
	n0l1il <= (((((((((((((wire_w_lg_w_lg_w_lg_w_rxd_range741w768w884w885w(0) AND (NOT rxd(3))) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND (NOT (n0O0iO XOR wire_nlil_dataout))) AND (NOT (n0O0iO XOR wire_nliO_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOl_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0l1iO <= (wire_ni0OO_w_lg_w_lg_w_lg_nlli1i1092w1094w1095w(0) AND wire_ni0OO_w_lg_nll0Oi1490w(0));
	n0l1li <= (((wire_ni0OO_w_lg_nlli1i1092w(0) AND nll0OO) AND nll0Ol) AND nll0Oi);
	n0l1ll <= (((nlli1i AND nll0OO) AND nll0Ol) AND nll0Oi);
	n0l1lO <= (wire_ni0OO_w_lg_w_lg_w_lg_w_lg_nlli1i1092w1094w1095w1096w(0) OR wire_ni0OO_w_lg_w_lg_w_lg_nlli1i1097w1098w1099w(0));
	n0l1Oi <= (((((((((wire_w_lg_w_lg_w_lg_w771w772w773w1433w(0) AND wire_w_lg_w_rxd_range755w766w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nlOO_w_lg_dataout817w(0)) AND (NOT (n0O0iO XOR wire_nliO_dataout))) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOl_dataout)));
	n0l1Ol <= (wire_ni0OO_w_lg_w_lg_w1472w1473w1474w(0) AND nlli1l);
	n0l1OO <= ((((((wire_ni0OO_w_lg_w_lg_w_lg_nllili1443w1445w1446w(0) AND wire_ni0OO_w_lg_nlliii1447w(0)) AND wire_ni0OO_w_lg_nlli0O1449w(0)) AND wire_ni0OO_w_lg_nlli0l1451w(0)) AND wire_ni0OO_w_lg_nlli0i1453w(0)) AND wire_ni0OO_w_lg_nlli1O1455w(0)) AND nlli1l);
	n0li0i <= ((((((((((wire_n100i_o(31) OR wire_n100i_o(30)) OR wire_n100i_o(29)) OR wire_n100i_o(28)) OR wire_n100i_o(27)) OR wire_n100i_o(26)) OR wire_n100i_o(25)) OR wire_n100i_o(24)) OR wire_n100i_o(23)) OR wire_n100i_o(22)) OR wire_n100i_o(3));
	n0li0l <= ((((((((((((((((((wire_n100i_o(16) OR wire_n100i_o(11)) OR wire_n100i_o(7)) OR wire_n100i_o(0)) OR wire_n100i_o(31)) OR wire_n100i_o(30)) OR wire_n100i_o(29)) OR wire_n100i_o(28)) OR wire_n100i_o(27)) OR wire_n100i_o(26)) OR wire_n100i_o(25)) OR wire_n100i_o(24)) OR wire_n100i_o(23)) OR wire_n100i_o(22)) OR wire_n100i_o(3)) OR wire_n100i_o(20)) OR wire_n100i_o(19)) OR wire_n100i_o(18)) OR wire_n100i_o(17));
	n0li0O <= (((((wire_n100i_o(13) OR wire_n100i_o(12)) OR wire_n100i_o(11)) OR wire_n100i_o(5)) OR wire_n100i_o(4)) OR wire_n100i_o(3));
	n0li1i <= ((((((((((((((((((((((((((wire_n100i_o(21) OR wire_n100i_o(15)) OR wire_n100i_o(14)) OR wire_n100i_o(13)) OR wire_n100i_o(12)) OR wire_n100i_o(11)) OR wire_n100i_o(10)) OR wire_n100i_o(9)) OR wire_n100i_o(8)) OR wire_n100i_o(7)) OR wire_n100i_o(6)) OR wire_n100i_o(5)) OR wire_n100i_o(4)) OR wire_n100i_o(2)) OR wire_n100i_o(1)) OR wire_n100i_o(0)) OR wire_n100i_o(31)) OR wire_n100i_o(30)) OR wire_n100i_o(29)) OR wire_n100i_o(28)) OR wire_n100i_o(27)) OR wire_n100i_o(26)) OR wire_n100i_o(25)) OR wire_n100i_o(24)) OR wire_n100i_o(23)) OR wire_n100i_o(22)) OR wire_n100i_o(3));
	n0li1l <= (((((((((((((((((((((((((((((wire_n100i_o(21) OR wire_n100i_o(16)) OR wire_n100i_o(13)) OR wire_n100i_o(12)) OR wire_n100i_o(11)) OR wire_n100i_o(10)) OR wire_n100i_o(9)) OR wire_n100i_o(8)) OR wire_n100i_o(7)) OR wire_n100i_o(6)) OR wire_n100i_o(5)) OR wire_n100i_o(4)) OR wire_n100i_o(2)) OR wire_n100i_o(1)) OR wire_n100i_o(0)) OR wire_n100i_o(31)) OR wire_n100i_o(30)) OR wire_n100i_o(29)) OR wire_n100i_o(28)) OR wire_n100i_o(27)) OR wire_n100i_o(26)) OR wire_n100i_o(25)) OR wire_n100i_o(24)) OR wire_n100i_o(23)) OR wire_n100i_o(22)) OR wire_n100i_o(3)) OR wire_n100i_o(20)) OR wire_n100i_o(19)) OR wire_n100i_o(18)) OR wire_n100i_o(17));
	n0li1O <= (((((((((((((wire_n100i_o(2) OR wire_n100i_o(1)) OR wire_n100i_o(0)) OR wire_n100i_o(31)) OR wire_n100i_o(30)) OR wire_n100i_o(29)) OR wire_n100i_o(28)) OR wire_n100i_o(27)) OR wire_n100i_o(26)) OR wire_n100i_o(25)) OR wire_n100i_o(24)) OR wire_n100i_o(23)) OR wire_n100i_o(22)) OR wire_n100i_o(3));
	n0liii <= ((((((((((wire_n100i_o(0) OR wire_n100i_o(31)) OR wire_n100i_o(30)) OR wire_n100i_o(29)) OR wire_n100i_o(28)) OR wire_n100i_o(27)) OR wire_n100i_o(26)) OR wire_n100i_o(25)) OR wire_n100i_o(24)) OR wire_n100i_o(23)) OR wire_n100i_o(22));
	n0liil <= ((((((((((((((((((wire_n100i_o(16) OR wire_n100i_o(5)) OR wire_n100i_o(4)) OR wire_n100i_o(0)) OR wire_n100i_o(31)) OR wire_n100i_o(30)) OR wire_n100i_o(29)) OR wire_n100i_o(28)) OR wire_n100i_o(27)) OR wire_n100i_o(26)) OR wire_n100i_o(25)) OR wire_n100i_o(24)) OR wire_n100i_o(23)) OR wire_n100i_o(22)) OR wire_n100i_o(3)) OR wire_n100i_o(20)) OR wire_n100i_o(19)) OR wire_n100i_o(18)) OR wire_n100i_o(17));
	n0liOO <= ((((((((((((wire_n100i_o(0) OR wire_n100i_o(31)) OR wire_n100i_o(30)) OR wire_n100i_o(29)) OR wire_n100i_o(28)) OR wire_n100i_o(27)) OR wire_n100i_o(26)) OR wire_n100i_o(25)) OR wire_n100i_o(24)) OR wire_n100i_o(23)) OR wire_n100i_o(22)) OR wire_n100i_o(3)) OR wire_n0ll1i41_w_lg_Q189w(0));
	n0ll0l <= (((NOT rxc(0)) OR wire_w_lg_n0llil146w(0)) OR wire_n0ll0O32_w_lg_Q150w(0));
	n0llil <= ((((((wire_w_lg_w_rxd_range741w758w(0) AND rxd(2)) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7));
	n0lliO <= ((((((wire_w_lg_w_rxd_range741w758w(0) AND (NOT rxd(2))) AND rxd(3)) AND rxd(4)) AND wire_w_lg_w_rxd_range751w763w(0)) AND rxd(6)) AND wire_w_lg_w_rxd_range755w766w(0));
	n0llli <= ((((((wire_w_lg_w_rxd_range741w758w(0) AND rxd(2)) AND (NOT rxd(3))) AND (NOT rxd(4))) AND wire_w_lg_w_rxd_range751w763w(0)) AND wire_w_lg_w_rxd_range753w774w(0)) AND wire_w_lg_w_rxd_range755w766w(0));
	n0llll <= ((((((wire_w_lg_w_rxd_range741w758w(0) AND (NOT rxd(2))) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND wire_w_lg_w_rxd_range755w766w(0));
	n0lllO <= ((wire_w_lg_n0llOO134w(0) OR (NOT ((NOT rxc(0)) AND wire_nlii_dataout))) OR wire_n0llOi29_w_lg_Q141w(0));
	n0llOO <= ((((((((((((((wire_w_lg_w_lg_w_rxd_range741w768w884w(0) AND (NOT rxd(2))) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND wire_nliO_w_lg_dataout809w(0)) AND (NOT (n0O0iO XOR wire_nlil_dataout))) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOl_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0lO0i <= (((((((((((((((rxd(0) AND rxd(1)) AND (NOT rxd(2))) AND rxd(3)) AND rxd(4)) AND rxd(5)) AND rxd(6)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0lO0l <= (((((((((((wire_w_lg_w771w772w(0) AND wire_w_lg_w_rxd_range751w763w(0)) AND rxd(6)) AND wire_w_lg_w_rxd_range755w766w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND (NOT (n0O0iO XOR wire_nlil_dataout))) AND (NOT (n0O0iO XOR wire_nliO_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOi_dataout))) AND (NOT (n0O0iO XOR wire_nlOl_dataout))) AND (NOT (n0O0iO XOR wire_nlOO_dataout)));
	n0lO0O <= (((((((((((((wire_w_lg_w_lg_w_lg_w_rxd_range741w768w884w885w(0) AND (NOT rxd(3))) AND rxd(4)) AND wire_w_lg_w_rxd_range751w763w(0)) AND wire_w_lg_w_rxd_range753w774w(0)) AND wire_w_lg_w_rxd_range755w766w(0)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0lO1i <= ((((((((((((((wire_w_lg_w_rxd_range741w758w(0) AND (NOT rxd(2))) AND rxd(3)) AND rxd(4)) AND wire_w_lg_w_rxd_range751w763w(0)) AND rxd(6)) AND wire_w_lg_w_rxd_range755w766w(0)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0lO1l <= ((((((((((((((wire_w_lg_w_rxd_range741w758w(0) AND rxd(2)) AND (NOT rxd(3))) AND rxd(4)) AND rxd(5)) AND wire_w_lg_w_rxd_range753w774w(0)) AND wire_w_lg_w_rxd_range755w766w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nlOO_w_lg_dataout817w(0)) AND (NOT (n0O0iO XOR wire_nlil_dataout))) AND (NOT (n0O0iO XOR wire_nlll_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout))) AND (NOT (n0O0iO XOR wire_nlOl_dataout)));
	n0lO1O <= (wire_ni0OO_w_lg_w_lg_w_lg_ni0ll945w946w947w(0) AND wire_ni0OO_w_lg_ni0ii948w(0));
	n0lOii <= (((((((((((((((rxd(0) AND rxd(1)) AND (NOT rxd(2))) AND (NOT rxd(3))) AND rxd(4)) AND rxd(5)) AND wire_w_lg_w_rxd_range753w774w(0)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0)) AND (NOT (n0O0iO XOR wire_nlli_dataout))) AND (NOT (n0O0iO XOR wire_nllO_dataout)));
	n0lOil <= (((((((((((((((rxd(0) AND rxd(1)) AND rxd(2)) AND rxd(3)) AND (NOT rxd(4))) AND wire_w_lg_w_rxd_range751w763w(0)) AND wire_w_lg_w_rxd_range753w774w(0)) AND rxd(7)) AND wire_nlll_w_lg_dataout777w(0)) AND wire_nlOi_w_lg_dataout779w(0)) AND wire_nlil_w_lg_dataout807w(0)) AND wire_nliO_w_lg_dataout809w(0)) AND wire_nlli_w_lg_dataout811w(0)) AND wire_nllO_w_lg_dataout813w(0)) AND wire_nlOl_w_lg_dataout815w(0)) AND wire_nlOO_w_lg_dataout817w(0));
	n0lOiO <= (((((((((((((((rxd(0) AND rxd(1)) AND (NOT rxd(2))) AND rxd(3)) AN